/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","./../util/isTemplate","sap/ui/model/json/JSONModel","sap/m/Label","sap/ui/core/Fragment","sap/base/util/restricted/_omit","sap/ui/base/ManagedObjectObserver","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/ui/integration/designtime/baseEditor/util/createPromise","sap/base/util/restricted/_CancelablePromise","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/isPlainObject","sap/base/util/each","sap/ui/integration/designtime/baseEditor/validator/ValidatorRegistry","sap/ui/integration/designtime/baseEditor/util/BaseDefaultValidatorModules","sap/ui/integration/designtime/baseEditor/util/cleanupDesigntimeMetadata"],function(t,e,i,r,a,n,s,o,p,u,h,g,l,f,d,c,y){"use strict";var m=t.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor",{metadata:{library:"sap.ui.integration",interfaces:["sap.ui.core.IFormContent"],properties:{renderLabel:{type:"boolean",defaultValue:true},value:{type:"any"},config:{type:"object"}},aggregations:{_label:{type:"sap.m.Label",visibility:"hidden",multiple:false},content:{type:"sap.ui.core.Control",multiple:false}},events:{beforeValueChange:{parameters:{path:{type:"string"},value:{type:"any"},nextValue:{type:"any"}}},valueChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},designtimeMetadataChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},configChange:{parameters:{previousConfig:{type:"object"},config:{type:"object"}}},fragmentChange:{parameters:{previousFragment:{type:"string"},fragment:{type:"string"}}},ready:{},init:{},validationErrorChange:{parameters:{hasError:{type:"boolean"}}}}},xmlFragment:null,_currentXmlFragment:null,_bFragmentReady:false,constructor:function(){this._iExpectedWrapperCount=0;this._currentXmlFragment=this.xmlFragment;t.prototype.constructor.apply(this,arguments);this._oDefaultModel=new i({value:this.getValue(),config:this.getConfig(),displayValue:this._formatValue(this.getValue())});this._oDefaultModel.setDefaultBindingMode("OneWay");this.setBindingContext(this._oDefaultModel.getContext("/"));this.setModel(this._oDefaultModel);this.bindProperty("visible","config/visible");this._setReady(false);this._aEditorWrappers=[];this._bInitFinished=false;this.attachBeforeValueChange(function(t){this._iExpectedWrapperCount=this.getExpectedWrapperCount(t.getParameter("nextValue"))},this);this.attachValueChange(function(t){var e=t.getParameter("value");this._oDefaultModel.setData(Object.assign({},this._oDefaultModel.getData(),{value:e,displayValue:this._formatValue(e)}));this._checkReadyState()},this);this.attachConfigChange(function(t){var e=t.getParameter("previousConfig");var i=t.getParameter("config");if(e&&i&&!g(e.validators,i.validators)){this._validate(this.getValue())}this._oDefaultModel.setData(Object.assign({},this._oDefaultModel.getData(),{config:i}))},this);this.asyncInit().then(function(){this._bInitFinished=true;this.fireInit();this._checkReadyState()}.bind(this));if(this.getFragment()){this._initFragment(this.getFragment())}},renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e);t.style("display","inline-block");t.style("width","100%");t.openEnd();if(e.getRenderLabel()&&e.getLabel()){t.openStart("div");t.openEnd();t.renderControl(e.getLabel());t.close("div")}t.renderControl(e.getContent());t.close("div")}}});m.prototype.init=function(){this.attachFragmentChange(function(t){if(this.getContent()){this.getContent().destroy()}var e=t.getParameter("fragment");this._initFragment(e)},this)};m.prototype.asyncInit=function(){return Promise.resolve()};m.prototype.onFragmentReady=function(){};m.prototype.setValue=function(t,e){var i=this.getValue();var r=this.getConfig()||{};var a=t;if(r.type==="integer"&&Number.isInteger(Number(t))){a=parseInt(t)}if(r.visible===false){return}if(typeof a==="undefined"&&typeof r.defaultValue!=="undefined"){a=h(r.defaultValue)}this._validate(a,function(t){if((t||e)&&!g(a,i)){this.fireBeforeValueChange({path:r.path,value:i,nextValue:a});this.setProperty("value",a);this.fireValueChange({path:r.path,previousValue:i,value:a})}this.setHasOwnError(!t)}.bind(this))};m.prototype.setDesigntimeMetadata=function(t){var e=this.getDesigntimeMetadata();var i=t;y(i);var r=this.getConfig();if(!g(e,i)){this.fireDesigntimeMetadataChange({path:r.path,previousValue:e,value:i})}};m.prototype.getDesigntimeMetadata=function(){return(this.getConfig()||{}).designtime||{}};m.prototype.setDesigntimeMetadataValue=function(t){this.setDesigntimeMetadata(Object.assign({},this.getConfig().designtime,{__value:t}))};m.prototype.getNestedDesigntimeMetadata=function(t){var e=(this.getConfig()||{}).designtime||{};return e[t]};m.prototype.getNestedDesigntimeMetadataValue=function(t){return(this.getNestedDesigntimeMetadata(t)||{}).__value||{}};m.prototype.getDesigntimeMetadataValue=function(){var t=(this.getConfig()||{}).designtime||{};return t.__value||{}};m.prototype._getValidators=function(){var t=this.getConfig().validators||{};return Object.values(Object.assign({},this.getDefaultValidators(),t)).filter(function(t){return t.isEnabled!==false})};m.prototype.getDefaultValidators=function(){return{}};m.prototype._validate=function(t,e){var i=[];var r=this._getValidators();r=r.map(function(t){var e=d.hasValidator(t.type)?d.getValidator(t.type):this.getDefaultValidatorModules()[t.type];if(!e){throw new Error("Unknown validator: "+t.type)}var i={};var r=t.errorMessage||e.errorMessage;var a=[];var n=r;if(l(r)){a=r.placeholders(t.config);n=r.message}Object.keys(t.config||{}).forEach(function(e){var r=t.config[e];if(typeof r==="function"){r=r(this)}i[e]=r}.bind(this));return{validator:e,config:i,errorMessage:this.getI18nProperty(n,a),type:t.type}}.bind(this));var a=function(){var t=i.length===0;this.setInputState(!t,i[0]);if(typeof e==="function"){e(t)}}.bind(this);r.forEach(function(e){if(!e.validator.validate(t,e.config)){i.push(e.errorMessage)}});a()};m.prototype.setInputState=function(t,e){this._sErrorMessage=t&&e;if(this.isReady()){this._setInputState()}};m.prototype._setInputState=function(){var t=this.getContent();if(!t||!t.setValueState){return}var e=this._sErrorMessage;if(e){t.setValueState("Error");t.setValueStateText(e)}else{t.setValueState("None")}};m.prototype.getDefaultValidatorModules=function(){return c};m.prototype._formatValue=function(t){return this.formatValue(h(t))};m.prototype.formatValue=function(t){return t};m.prototype.getExpectedWrapperCount=function(){return 0};m.prototype._checkReadyState=function(){if(this._mWrapperReadyCheck){this._mWrapperReadyCheck.cancel()}if(!this._bInitFinished){this._setReady(false);return}if(!this._bFragmentReady){this._setReady(false);return}if(this._iExpectedWrapperCount===0){this._setReady(true);return}if(this._iExpectedWrapperCount===this._aEditorWrappers.length){if(this._aEditorWrappers.every(function(t){return t.isReady()})){this._setReady(true)}else{this._setReady(false);this._mWrapperReadyCheck=p(function(t){Promise.all(this._aEditorWrappers.map(function(t){return t.ready()})).then(t)}.bind(this));this._mWrapperReadyCheck.promise.then(function(){this._setReady(true);delete this._mWrapperReadyCheck}.bind(this))}}else{this._setReady(false)}};m.prototype.wrapperInit=function(t){if(!this._oWrapperObserver){this._oWrapperObserver=new s(function(t){var i=t.object;switch(t.type){case"destroy":this._aEditorWrappers=this._aEditorWrappers.filter(function(t){return t!==i});this._checkReadyState();this._checkForError();break;case"parent":b(i).forEach(function(t){if(!e(t,this)){this._registerWrapper(t)}else{_(this._oWrapperObserver,t)}}.bind(this));this._oWrapperObserver.unobserve(i);break;default:return}}.bind(this))}var i=t.getSource();if(e(i,this)){_(this._oWrapperObserver,i);return}this._registerWrapper(i)};function _(t,e){var i=v(e);if(!t.isObserved(i,{parent:true})){t.observe(i,{parent:true})}}function v(t){var e=t.getParent();return e?v(e):t}function b(t){return C(t)?[t]:t.findAggregatedObjects(true,function(t){return C(t)})}function C(t){return t.isA("sap.ui.integration.designtime.baseEditor.PropertyEditors")||t.isA("sap.ui.integration.designtime.baseEditor.PropertyEditor")}m.prototype._registerWrapper=function(t){this._aEditorWrappers.push(t);t.attachReady(function(t){this._setReady(false);this._checkReadyState()}.bind(this));t.attachValidationErrorChange(this._checkForError.bind(this));if(t.isA("sap.ui.integration.designtime.baseEditor.PropertyEditor")){t.attachPropertyEditorChange(function(t){var e=t.getParameter("propertyEditor");if(!e){this._setReady(false)}},this)}this._oWrapperObserver.observe(t,{destroy:true});this._checkReadyState()};m.prototype._setReady=function(t){var e=this._bIsReady;this._bIsReady=t;if(e!==true&&t===true){this.fireReady()}};m.prototype.isReady=function(){return!!this._bIsReady};m.prototype.setHasOwnError=function(t){this._bHasOwnError=t;this._checkForError()};m.prototype._checkForError=function(){var t=this.hasError();if(t!==this._bHasError){this._bHasError=t;this.fireValidationErrorChange({hasError:t})}};m.prototype.hasError=function(){return!!this._bHasOwnError||this._aEditorWrappers.some(function(t){return t.hasError()})};m.prototype.ready=function(){return new Promise(function(t){if(this.isReady()){t()}else{this.attachEventOnce("ready",t)}}.bind(this))};m.prototype.setFragment=function(t,e){if(this._currentXmlFragment!==t){var i=this._currentXmlFragment;this._currentXmlFragment=t;if(typeof e==="function"){this.getExpectedWrapperCount=e}this.fireFragmentChange({previousFragment:i,fragment:t})}};m.prototype.getFragment=function(){return this._currentXmlFragment};m.prototype._initFragment=function(t){this._setReady(false);this._bFragmentReady=false;if(this._oFragmentPromise){this._oFragmentPromise.cancel()}var e=new u(function(e,i,r){r.shouldReject=false;this._loadFragment(t).then(e,i)}.bind(this));this._oFragmentPromise=e;return e.then(function(t){if(e.isCanceled){t.destroy();return}this._bFragmentReady=true;this.setContent(t);this.onFragmentReady();this._setInputState();this._checkReadyState()}.bind(this))};m.prototype._loadFragment=function(t){return a.load({name:t,controller:this})};m.prototype.clone=function(){this.destroyContent();return t.prototype.clone.apply(this,arguments)};m.prototype.exit=function(){this._oDefaultModel.destroy();if(this._oConfigBinding){this._oConfigBinding.destroy()}if(this._oWrapperObserver){this._oWrapperObserver.destroy()}if(this._oFragmentPromise){this._oFragmentPromise.cancel()}};m.configMetadata={visible:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},typeLabel:{defaultValue:"BASE_EDITOR.FALLBACK_TYPE"}};m.prototype.setConfig=function(t){var e=this.getConfig();var i={};var r=o.getByClassName(this.getMetadata().getName()).configMetadata;f(r,function(t,e){i[t]=e.defaultValue});var a=Object.assign({},i,t);a=this.onBeforeConfigChange(a);if(!g(e,a)){this.setProperty("config",a);this.fireConfigChange({previousConfig:e,config:a})}};m.prototype.onBeforeConfigChange=function(t){return t};m.prototype.getI18nProperty=function(t,e){if(this.getModel("i18n")){return this.getModel("i18n").getResourceBundle().getText(t,e)}return t};m.prototype.getLabel=function(){var t=this.getAggregation("_label");if(!t){t=new r({text:"{config/label}",design:"Bold"});this.setAggregation("_label",t)}return t};m.prototype.enhanceAccessibilityState=function(t,e){var i=this.getParent();if(i&&i.enhanceAccessibilityState){i.enhanceAccessibilityState(this,e)}};m.prototype.getFocusDomRef=function(){var t=this.getContent();if(t&&t.isA("sap.ui.core.IFormContent")){return t.getFocusDomRef()}};m.prototype.getIdForLabel=function(){var t=this.getContent();if(t&&t.isA("sap.ui.core.IFormContent")){return t.getIdForLabel()}};return m});
//# sourceMappingURL=BasePropertyEditor.js.map