/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/Core","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/merge","sap/ui/base/Interface","sap/ui/integration/Designtime","sap/ui/model/json/JSONModel","sap/ui/model/odata/v4/ODataModel","sap/ui/integration/util/Utils","sap/ui/integration/util/Destinations","sap/ui/integration/util/DataProviderFactory","sap/m/Label","sap/m/HBox","sap/m/VBox","sap/ui/core/Icon","sap/m/ResponsivePopover","sap/m/Popover","sap/m/Text","sap/base/Log","sap/ui/core/Popup","sap/base/i18n/ResourceBundle","sap/ui/integration/editor/EditorResourceBundles","sap/ui/dom/includeStylesheet","sap/base/util/LoaderExtensions","sap/ui/core/theming/Parameters","sap/base/util/ObjectPath","sap/m/FormattedText","sap/m/MessageStrip","sap/m/ToolbarSpacer","sap/ui/model/resource/ResourceModel","./Manifest","./Merger","./Settings","sap/m/FlexItemData","sap/m/FlexBox","sap/m/Button"],function(e,t,i,a,n,s,r,o,l,d,f,g,u,p,h,c,_,m,v,y,b,I,M,C,P,x,T,S,D,E,A,w,L,O,R,V,F){"use strict";var B=m.prototype.init;m.prototype.init=function(){B.apply(this,arguments);var e=this.oPopup._applyPosition,t=this;this.oPopup._applyPosition=function(){var i=t.close;t.close=function(){};e.apply(this,arguments);t.close=i}};function U(e){if(e&&e.nodeType!==1){return 0}var t=parseInt(window.getComputedStyle(e).getPropertyValue("z-index"));if(isNaN(t)){return U(e.parentNode)}return t+1}var j=/\{\{(?!parameters.)(?!destinations.)([^\}\}]+)\}\}/g,N=/\{\{parameters\.([^\}\}]+)/g,W=5e3,k=t.getLibraryResourceBundle("sap.ui.integration"),H="_strip",q="module:";var G=e.extend("sap.ui.integration.editor.Editor",{metadata:{library:"sap.ui.integration",properties:{mode:{type:"string",defaultValue:"admin"},language:{type:"string",defaultValue:""},allowDynamicValues:{type:"boolean",defaultValue:false},allowSettings:{type:"boolean",defaultValue:false},designtime:{type:"object"},section:{type:"string",defaultValue:"sap.card"},host:{type:"string",defaultValue:""},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},json:{type:"object"},previewPosition:{type:"string",defaultValue:"right"},width:{type:"sap.ui.core.CSSSize",defaultValue:""},height:{type:"sap.ui.core.CSSSize",defaultValue:""}},aggregations:{_formContent:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},_preview:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_messageStrip:{type:"sap.m.MessageStrip",multiple:false,visibility:"hidden"},_extension:{type:"sap.ui.integration.editor.Extension",multiple:false,visibility:"hidden"}},events:{ready:{},manifestReady:{}}},renderer:{apiVersion:2,render:function(e,i){var n=i.getAggregation("_preview");var s=i.getMode()!=="translation"&&i.hasPreview();var r=i.getPreviewPosition();if(s&&(r==="top"||r==="bottom")){e.openStart("div",i);e.openEnd();if(i.isReady()&&r==="top"){e.renderControl(n)}}if(s&&r==="left"){e.openStart("div",i);e.class("sapUiIntegrationEditor");e.openEnd();if(i.isReady()){e.renderControl(n)}}else if(s&&(r==="top"||r==="bottom")){e.openStart("div");e.class("sapUiIntegrationEditor");e.openEnd()}else{e.openStart("div",i);e.class("sapUiIntegrationEditor");e.openEnd()}if(i.isReady()){e.openStart("div");e.class("sapUiIntegrationEditorForm");if(i.getMode()!=="translation"){e.class("settingsButtonSpace")}e.openEnd();if(i.getMode()!=="translation"){e.renderControl(i.getAggregation("_messageStrip"))}var o=i.getAggregation("_formContent");if(o){var l;var d;var f;var g;var u=[];var c=[];var _;var m=function(){if(u.length>0){var e=2-u.length;for(var t=0;t<e;t++){u.push(new h)}l.addContent(new V({alignItems:"Start",justifyContent:"SpaceBetween",items:u}));u=[]}};var v=function(){if(c.length>0){var e=2-c.length;for(var t=0;t<e;t++){c.push(new h)}d.addContent(new V({alignItems:"Start",justifyContent:"SpaceBetween",items:c}));c=[]}};var y=function(t){if(t.getContent().length>0){var i=t.getContent();if(i.length===1&&i[0].isA("sap.m.MessageStrip")){return}if(i[0].isA("sap.m.MessageStrip")){t.removeContent(0);t.addContent(i[0])}e.renderControl(t.getParent());if(t._messageStrip){e.renderControl(t._messageStrip)}}};var b=function(e,t){if(e&&t.getContent().length>0){var i=t.getContent();if(i[0].isA("sap.m.MessageStrip")){t.removeContent(0);t.addContent(i[0])}e.addContent(t.getParent());if(t._messageStrip){e.addContent(t._messageStrip)}}else{t=null}};var I=function(e,t){var i=e.getContent(),a;if(i.length>0){for(var n=0;n<i.length;n++){if(i[n].getAggregation("_field")&&i[n].getAggregation("_field").isA("sap.m.IconTabBar")){a=i[n].getAggregation("_field")}}}if(a&&t.getContent().length>0){a.addItem(t)}};for(var M=0;M<o.length;M++){var C=o[M];if(i.getMode()!=="translation"){if(C.isA("sap.ui.integration.editor.fields.GroupField")){var P=C.getAggregation("_field");if(!P){continue}if(d){v();if(P.isA("sap.m.Panel")&&d.isA("sap.m.Panel")){b(l,d)}else{I(l,d)}}var x=0;if(P.isA("sap.m.Panel")){x=P._level}else if(P.isA("sap.m.IconTabBar")){x="1"}if(x==="1"){if(u.length>0){m()}if(P.isA("sap.m.IconTabBar")){var T=l.getContent(),S=false,D;if(T.length>0){for(var E=0;E<T.length;E++){if(T[E].getAggregation("_field")&&T[E].getAggregation("_field").isA("sap.m.IconTabBar")){S=true;D=T[E].getAggregation("_field")}}}d=P.getItems()[0];d._subItems=d._subItems||[];if(!S){P.removeItem(P.getItems()[0]);if(P._messageStrip){l.addContent(P._messageStrip)}P.addStyleClass("sapUiIntegrationEditorSubTab");l.addContent(C)}else{D.addItem(P.getItems()[0]);P.destroy()}}else{d=P;d._subItems=d._subItems||[];d.addStyleClass("sapUiIntegrationEditorSubGroup")}}else{if(l){m();y(l);d=null}l=P;l._subItems=l._subItems||[];l.addStyleClass("sapUiIntegrationEditorItem")}if(M===o.length-1){m();y(l)}continue}if(C.isA("sap.m.FormattedText")){if(d){d.addContent(C.addStyleClass("sapUiIntegrationEditorHint"))}else{l.addContent(C.addStyleClass("sapUiIntegrationEditorHint"))}if(M===o.length-1){if(d){v();b(l,d)}m();y(l)}continue}var A=C._layout;if(C.isA("sap.m.Label")){C.addStyleClass("sapUiIntegrationEditorItemLabel");if(C.getRequired()){C.addStyleClass("sapUiIntegrationEditorItemLabelWithRequired")}if(A&&!a(A,{})){if(A.alignment&&A.alignment.label==="end"){C.setTextAlign("End")}g=C}else{if(C._cols===2){if(d){v()}else{m()}}else if(c.length===2){v()}else if(u.length===2){m()}if(d){d.addContent(C)}else{l.addContent(C)}}}else if(C.isA("sap.m.ToolbarSpacer")){if(C._hasLine){C.addStyleClass("sapUiIntegrationEditorSpacerWithLine")}else{C.addStyleClass("sapUiIntegrationEditorSpacerWithoutLine")}if(d){v();d.addContent(C)}else{m();l.addContent(C)}}else{var w=C.getConfiguration(),L=new p,O=.1,F=0,B;if(C._descriptionIcon){L.addItem(C._descriptionIcon);O+=.9}var U=t.byId(C.getAssociation("_messageIcon"));if(C.getAssociation("_messageIcon")&&U){L.addItem(U);O+=1.2}if(C._settingsButton){C._settingsButton.addStyleClass("sapUiIntegrationEditorSettingsButton");F=2}var j=new R({growFactor:10,maxWidth:"calc(100% - "+F+"rem)"});var N=new R({maxWidth:"calc(100% - "+O+"rem)"});if(g){var W,k,H="50%";if(A&&A["label-width"]){H=A["label-width"]}var q=parseInt(H);var G=100-q;if(C._cols===2){q=q-.5;G=G-.5}if(A.alignment&&A.alignment.field==="end"){C.addStyleClass("sapUiIntegrationEditorFieldAlignEnd")}if(A.alignment&&A.alignment.label==="end"){g.setLayoutData(new R({maxWidth:"calc(100% - "+O+"rem)",minWidth:"calc(100% - "+O+"rem)"}))}else{g.setLayoutData(N)}if(L.getItems().length>0){g.addStyleClass("sapUiIntegrationEditorItemLabelWithInfo");B=new p({items:[g,L]})}else{B=g}if(A&&A.position&&A.position==="field-label"){B.setLayoutData(j);k=new p({alignItems:"Start",justifyContent:"SpaceBetween",items:[B,C._settingsButton]});k.setLayoutData(new R({growFactor:q,maxWidth:q+"%"}));C.setLayoutData(new R({growFactor:G,maxWidth:G+"%"}));W=new p({alignItems:"Start",justifyContent:"SpaceBetween",items:[C,k]})}else{C.setLayoutData(j);k=new p({alignItems:"Start",justifyContent:"SpaceBetween",items:[C,C._settingsButton]});B.setLayoutData(new R({growFactor:q,maxWidth:q+"%"}));k.setLayoutData(new R({growFactor:G,maxWidth:G+"%"}));W=new p({alignItems:"Start",justifyContent:"SpaceBetween",items:[B,k]})}if(C._cols===1){if(d){if(c.length===2){v()}if(w.hint){var K=i._createHint(w.hint,C.getParameterId());var z=new h({items:[W,K.addStyleClass("sapUiIntegrationEditorHint")]});z.addStyleClass("col1");c.push(z)}else{W.addStyleClass("col1");c.push(W)}}else{if(u.length===2){m()}if(w.hint){var K=i._createHint(w.hint,C.getParameterId());var z=new h({items:[W,K.addStyleClass("sapUiIntegrationEditorHint")]});z.addStyleClass("col1");u.push(z)}else{W.addStyleClass("col1");u.push(W)}}}else if(d){v();d.addContent(W)}else{m();l.addContent(W)}g=null}else{var J;if(d){J=d.getContent().pop()}else{J=l.getContent().pop()}J.setLayoutData(N);if(L.getItems().length>0){J.addStyleClass("sapUiIntegrationEditorItemLabelWithInfo");B=new p({items:[J,L]})}else{B=J}B.setLayoutData(j);var X=new V({alignItems:"Start",justifyContent:"SpaceBetween",items:[B,C._settingsButton]});if(C._cols===1){var z=new h({items:[X,C]});if(w.hint){var K=i._createHint(w.hint,C.getParameterId());z.addItem(K.addStyleClass("sapUiIntegrationEditorHint"))}z.addStyleClass("col1");if(d){c.push(z)}else{u.push(z)}}else if(d){d.addContent(X);d.addContent(C)}else{l.addContent(X);l.addContent(C)}}if(d){d._subItems.push({settingspath:C.getConfiguration()._settingspath,itemId:C.getId()})}l._subItems.push({settingspath:C.getConfiguration()._settingspath,itemId:C.getId()})}if(M===o.length-1){if(d){v();if(d.isA("sap.m.Panel")){b(l,d)}else{I(l,d)}}m();y(l)}}else{if(M===0){f=C.getAggregation("_field");e.renderControl(C);C.addStyleClass("sapUiIntegrationEditorTranslationPanel");continue}if(C.isA("sap.ui.integration.editor.fields.GroupField")){var P=C.getAggregation("_field");if(d){if(P.isA("sap.m.Panel")&&d.isA("sap.m.Panel")){b(l,d)}else{I(l,d)}}var Y=0;if(P.isA("sap.m.Panel")){Y=P._level}else if(P.isA("sap.m.IconTabBar")){if(P.getItems().length>0&&P.getItems()[0]._level){Y=P.getItems()[0]._level}}if(Y==="1"){if(P.isA("sap.m.IconTabBar")){if(M!==o.length-1||M<o.length&&(o[M].isA("sap.m.IconTabBar")||o[M].isA("sap.m.Panel"))){var Z=l.getContent(),Q=false;if(Z.length>0){for(var $=0;$<Z.length;$++){if(Z[$].getAggregation("_field")&&Z[$].getAggregation("_field").isA("sap.m.IconTabBar")){Q=true}}}if(!Q){d=P.getItems()[0];P.removeItem(P.getItems()[0]);l.addContent(P.getParent())}else{d=P.getItems()[0]}}}else{d=P;d.addStyleClass("sapUiIntegrationEditorSubGroup")}}else{d=null;if(l&&l.getContent().length>0){f.addContent(l.getParent())}l=P;l.addStyleClass("sapUiIntegrationEditorSubGroup")}if(M===o.length-1){m();y(l)}continue}if(C.isA("sap.m.ToolbarSpacer")){continue}if(C.isA("sap.m.FormattedText")){continue}if(C.isA("sap.m.Label")){if(d){d.addContent(C)}else{l.addContent(C)}continue}if(C.isOrigLangField){_=C;continue}_.addStyleClass("sapUiIntegrationFieldTranslationText");var W=new p({items:[_,C]}).addStyleClass("notWrappingRow");if(d){d.addContent(W)}else{l.addContent(W)}if(M===o.length-1){if(d){if(d.isA("sap.m.Panel")){b(l,d)}else{I(l,d)}}f.addContent(l.getParent())}}}}e.close("div");if(s&&r==="right"){e.renderControl(n)}}e.close("div");if(s&&(r==="top"||r==="bottom")){if(r==="bottom"){e.renderControl(n)}e.close("div")}}}});G.prototype.init=function(){this._ready=false;this._aFieldReadyPromise=[];this._oResourceBundle=t.getLibraryResourceBundle("sap.ui.integration");this._appliedLayerManifestChanges=[];this._currentLayerManifestChanges={};this._mDestinationDataProviders={};var e=new D(this.getId()+H,{showIcon:false});e.addStyleClass("sapUiIntegrationEditorFieldMessageStrip");this.setAggregation("_messageStrip",e);H=e.getId();this.setLanguage(t.getConfiguration().getLanguage());this._oLimitedInterface=new s(this,["getParameters","resolveDestination","request","getModel"])};G.prototype.getParameters=function(){if(!this._isManifestReady){y.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.editor.Editor");return null}var e=this._oEditorManifest.getProcessedParameters(),t={},i;for(i in e){t[i]=e[i].value}return t};G.prototype.resolveDestination=function(e){return this._oDestinations.getUrl(e)};G.prototype.isReady=function(){return this._ready};G.prototype.hasPreview=function(){var e=this.getAggregation("_preview");if(e&&e.visible!==false){return true}return false};G.prototype.getSeparatePreview=function(){var e=this.getPreviewPosition();if(!this.isReady()||e!=="separate"){return null}if(!this._oPreview){this._oPreview=this.getAggregation("_preview")}return this._oPreview};G.prototype.flattenData=function(e,t,i,a){a=a||"";i=i||[];if(typeof e==="object"){if(!e[t]){for(var n in e){this.flattenData(e[n],t,i,a+"/"+n)}}else{if(e.type){i.push({path:e.pathvalue||a.substring(1),value:e.pathvalue||"{context>"+a.substring(1)+"/value}",object:e})}else{i.push({path:a.substring(1),object:e});for(var n in e){this.flattenData(e[n],t,i,a+"/"+n)}}}}return i};G.prototype.setJson=function(e,t){this._ready=false;if(a(e,this._preIdOrSettings)){return this}this._preIdOrSettings=i(e,500);if(typeof e==="string"){try{e=JSON.parse(e)}catch(e){}}if(typeof e==="object"){if(e.manifestChanges){this._filterManifestChangesByLayer(e)}if(this._manifestModel){return}if(this._oDesigntimeInstance){this._oDesigntimeInstance.destroy()}if(e.host){this.setProperty("host",e.host)}if(e.baseUrl){this.setProperty("baseUrl",e.baseUrl)}this._appliedLayerManifestChanges=e.manifestChanges;this.createManifest(e,t)}};G.prototype.createManifest=function(e,t){var i=this.getBaseUrl();var a={},s=e.manifest;this._isManifestReady=false;if(typeof s==="string"){a.manifestUrl=s;s=null}if(this._oEditorManifest){this._oEditorManifest.destroy()}this.destroyAggregation("_extension");var r=L.layers[this.getMode()];this._oEditorManifest=new w(this.getSection(),s,i,e.manifestChanges);this._oEditorManifest.load(a).then(function(){this._registerManifestModulePath();this._oInitialManifestModel=new o(this._oEditorManifest._oInitialJson);this.setProperty("json",this._oEditorManifest._oInitialJson,t);var e=this._oEditorManifest.oJson;var i=n({},e);this._beforeManifestModel=new o(i);if(r<L.layers["translation"]&&this._currentLayerManifestChanges){e=L.mergeDelta(e,[this._currentLayerManifestChanges],this.getSection())}this._manifestModel=new o(e);this._isManifestReady=true;this.fireManifestReady();this._initResourceBundlesForMultiTranslation();this._loadDefaultTranslations();this._createContextModel();if(this._oEditorManifest.getResourceBundle()){this._enhanceI18nModel(this._oEditorManifest.getResourceBundle())}return this._loadExtension().then(function(){this._initInternal()}.bind(this))}.bind(this))};G.prototype._initResourceBundlesForMultiTranslation=function(){var e=this._oEditorManifest.get("/sap.app/i18n");var t;var i;if(typeof e==="string"){t=this.getBaseUrl()+e}else if(typeof e==="object"){if(e.bundleUrl){t=this.getBaseUrl()+e.bundleUrl}if(e.supportedLocales){i=e.supportedLocales}}this._oEditorResourceBundles=new M({url:t,languages:G._oLanguages,supportedLocales:i})};G.prototype._registerManifestModulePath=function(){if(!this._oEditorManifest){return}this._sAppId=this._oEditorManifest.get("/sap.app/id");if(this._sAppId){P.registerResourcePath(this._sAppId.replace(/\./g,"/"),this._oEditorManifest.getUrl()||"/")}else{y.error("sap.app/id entry in the manifest is mandatory")}};G.prototype._loadDefaultTranslations=function(){if(this._defaultTranslationsLoaded){return}var e=t.getLibraryResourceBundle("sap.ui.integration");var i=new A({bundle:e});this.setModel(i,"i18n");this._oResourceBundle=e;this._defaultTranslationsLoaded=true};G.prototype._enhanceI18nModel=function(e){var t=this.getModel("i18n");if(t.getResourceBundle().oUrlInfo.url!==e.oUrlInfo.url){t.enhance(e);this._oResourceBundle=t.getResourceBundle()}};G.prototype._loadExtension=function(){var e=this._oEditorManifest.get(this.getConfigurationPath()+"/extension")||this._oEditorManifest.get("/"+this.getSection()+"/extension"),t;if(!e){y.info("Extension is not defined in manifest, do not load it.");return new Promise(function(e,t){e()})}if(e.startsWith(q)){t=e.replace(q,"")}else{t=this._sAppId.replace(/\./g,"/")+"/"+e}return new Promise(function(i,a){sap.ui.require([t],function(e){var t=new e;t._setEditor(this,this._oLimitedInterface);this.setAggregation("_extension",t);i()}.bind(this),function(t){y.error("Failed to load "+e+". Check if the path is correct. Reason: "+t);a(t)})}.bind(this))};G.prototype.request=function(e){return this._oDataProviderFactory.create({request:e}).setAllowCustomDataType(true).getData()};G.prototype.initDestinations=function(e){this._destinationsModel=new o({});this.setModel(this._destinationsModel,"destinations");var t=this.getHostInstance();if(e&&!t){y.error("Host with id '"+e+"' is not available during editor initialization. It must be available for host specific features to work.","Make sure that the host already exists, before assigning it to the editor.","sap.ui.integration.editor.Editor")}if(this._oDestinations){this._oDestinations.setHost(t)}else{var i=this.getConfigurationPath();this._oDestinations=new f({host:t,manifestConfig:this._manifestModel.getProperty(i+"/destinations")})}};G.prototype.initDataProviderFactory=function(){if(this._oDataProviderFactory){this._oDataProviderFactory.destroy()}var e=this.getAggregation("_extension");this._oDataProviderFactory=new g({destinations:this._oDestinations,extension:e,editor:this})};G.prototype.getRuntimeUrl=function(e){var t=this._sAppId,i,a=e&&e.trim().replace(/^\//,"");if(t===null){y.error("The manifest is not ready so the URL can not be resolved. Consider using the 'manifestReady' event.","sap.ui.integration.editor.Editor");return null}if(!t||e.startsWith("http://")||e.startsWith("https://")||e.startsWith("//")){return e}i=t.replace(/\./g,"/");return sap.ui.require.toUrl(i)+"/"+a};G.prototype.getBindingNamespaces=function(){var e={},t=this.getAggregation("_extension");if(t){e.extension={formatters:t.getFormatters()}}return e};G.prototype.getHostInstance=function(){var e=this.getHost();if(!e){return null}return t.byId(e)};G.prototype.setLanguage=function(e,t){if(!e||typeof e!=="string"){return this}this._language=e.replaceAll("_","-");if(this.getLanguage()!=e){this._loadDefaultTranslations()}this.setProperty("language",e,t);if(!G._oLanguages[this._language]){this._language=this._language.split("-")[0]}if(!G._oLanguages[this._language]){y.warning("The language: "+e+" is currently unknown, some UI controls might show "+e+" instead of the language name.")}return this};G.prototype.onAfterRendering=function(){if(this.getDomRef()){this._iZIndex=U(this.getDomRef());b.setInitialZIndex(this._iZIndex)}};G.prototype._filterManifestChangesByLayer=function(e){var i=[],a=this,s={},r={":layer":L.layers[this.getMode()]},o=L.layers[a.getMode()];e.manifestChanges.forEach(function(e){var l=e.hasOwnProperty(":layer")?e[":layer"]:1e3;if(l===L.layers["translation"]){var d=a._language;if(d===""){d=t.getConfiguration().getLanguage().replaceAll("_","-")}var f={texts:{}};delete e.texts;f.texts[d]={};Object.keys(e).forEach(function(t){if(t.charAt(0)==="/"){f.texts[d][t]=e[t]}else{f[t]=e[t]}});e=f}if(l<o){i.push(e);s=n(s,e)}else if(l===o){r=e}});e.manifestChanges=i;this._currentLayerManifestChanges=r;this._beforeLayerManifestChanges=s};G.prototype._initInternal=function(){var e=this;var t=e.getConfigurationPath();var i=e._oEditorManifest.get(t+"/editor");if(!i){i=e._oEditorManifest.get("/"+e.getSection()+"/designtime")}var a=e._manifestModel.getProperty(t),n,s=e.getDesigntime();if(s){if(typeof s==="function"){n=new Promise(function(t,i){var a=new s;e._applyDesigntimeDefaults(a.getSettings());t(a)})}else if(typeof s==="object"){n=new Promise(function(t,i){sap.ui.require(["sap/ui/integration/Designtime"],function(i){var a=i.extend("test.Designtime");a.prototype.create=function(){return s};var n=new a;e._applyDesigntimeDefaults(n.getSettings());t(n)})})}}else if(i){n=e.loadDesigntime().then(function(t){e._applyDesigntimeDefaults(t.getSettings());return t})}else{n=Promise.resolve(e._createParameterDesigntime(a))}n.then(function(t){e._oDesigntimeInstance=t;e.initDestinations();e.initDataProviderFactory();if(e.getMode()==="admin"||e.getMode()==="all"){e._addDestinationSettings(a)}else{e._deleleDestinationSettings()}e._settingsModel=new o(e._oDesigntimeInstance.getSettings());e.setModel(e._settingsModel,"currentSettings");e.setModel(e._settingsModel,"items");return e._loadValueContextInDesigntime()}).then(function(){e._applyDesigntimeLayers();return e._requestExtensionData()}).then(function(){e._requireFields().then(function(){e._startEditor()})})};G.prototype.loadDesigntime=function(){if(this._oDesigntime){return Promise.resolve(this._oDesigntime)}if(!this._oEditorManifest){return new Promise(function(e,t){this.attachManifestReady(function(){this.loadDesigntime().then(e,t)}.bind(this))}.bind(this))}if(!this._sAppId){return Promise.reject("App id not maintained")}return new Promise(function(e,t){var i=this._oEditorManifest.get(this.getConfigurationPath()+"/editor");if(!i){i=this._oEditorManifest.get("/"+this.getSection()+"/designtime")}var a=this._sAppId.replace(/\./g,"/")+"/"+i;if(a){sap.ui.require([a],function(t){t=new t;t._readyPromise(this._oLimitedInterface,this).then(function(){this._oDesigntime=t;e(t)}.bind(this))}.bind(this),function(){t({error:a+" not found"})})}else{t()}}.bind(this))};G.prototype.getConfigurationPath=function(){return"/"+this.getSection()+"/configuration"};G.prototype.getCurrentSettings=function(){var e=this._settingsModel.getProperty("/"),t={},s;if(e&&e.form&&e.form.items){for(var r in e.form.items){var o=e.form.items[r];if(o.editable&&o.visible){if(this.getMode()!=="translation"){if(o.translatable&&!o._changed&&o._translatedPlaceholder&&!this._currentLayerManifestChanges[o.manifestpath]){}else{if(o.valueItems){t[o.manifestpath.substring(0,o.manifestpath.lastIndexOf("/"))+"/valueItems"]=o.valueItems}if(o.valueTokens){t[o.manifestpath.substring(0,o.manifestpath.lastIndexOf("/"))+"/valueTokens"]=o.valueTokens}switch(o.type){case"string":if(!o.translatable){t[o.manifestpath]=o.value}else if(o._hasDynamicValue){t[o.manifestpath]=o.value;this.deleteAllTranslationValuesInTexts(o.manifestpath)}else if(o._beforeValue&&(o._beforeValue.indexOf("{context>")===0||o._beforeValue.indexOf("{{parameters")===0)){t[o.manifestpath]=o.value}break;case"group":break;case"object":if(o.value&&o.value!==""&&typeof o.value==="object"){t[o.manifestpath]=o.value}break;case"object[]":if(Array.isArray(o.value)){var l=i(o.value,500);l=l.sort(function(e,t){if(!e._dt||!e._dt._position||!t._dt||!t._dt._position){return 0}return e._dt._position-t._dt._position});for(var d=0;d<l.length;d++){var f=l[d];f._dt=f._dt||{};f._dt._position=d+1}t[o.manifestpath]=l}break;default:t[o.manifestpath]=o.value}}}else if(o.translatable&&o.value){t[o.manifestpath]=o.value}if(o._next&&this.getAllowSettings()){if(o.type==="destination"){if(o._next.pageAdminNewDestinationParameter){s=s||{};s[o._settingspath+"/pageAdminNewDestinationParameter"]=o._next.pageAdminNewDestinationParameter}}else{var g=typeof o.visibleToUser==="undefined"?true:o.visibleToUser;var u=typeof o.editableToUser==="undefined"?true:o.editableToUser;var p=typeof o.allowDynamicValues==="undefined"?true:o.allowDynamicValues;if(o._next.visible===!g){s=s||{};s[o._settingspath+"/visible"]=o._next.visible}if(o._next.editable===!u){s=s||{};s[o._settingspath+"/editable"]=o._next.editable}if(o._next.allowDynamicValues===!p){s=s||{};s[o._settingspath+"/allowDynamicValues"]=o._next.allowDynamicValues}if(o._next.pageAdminValues){s=s||{};s[o._settingspath+"/pageAdminValues"]=o._next.pageAdminValues}}}}}}if(this.getMode()==="translation"){delete t.texts}else if(e.texts){t.texts=i(e.texts,500)||{};for(var h in t.texts){for(var c in t.texts[h]){if(typeof t.texts[h][c]==="object"){var _=t[c];if(!_||typeof _!=="object"||a(_,{})||a(_,[])){delete t.texts[h][c]}else if(Array.isArray(_)){var m=_.map(function(e){return e._dt?e._dt._uuid||"":""});for(var v in t.texts[h][c]){if(!m.includes(v)){delete t.texts[h][c][v]}}}else{var y=_._dt?_._dt._uuid||"":"";if(y!==""){var b=t.texts[h][c][y];if(!b){delete t.texts[h][c]}else{t.texts[h][c]={};t.texts[h][c][y]=b}}else{delete t.texts[h][c]}}}}if(a(t.texts[h],{})){delete t.texts[h]}}if(a(t.texts,{})){delete t.texts}}t[":layer"]=L.layers[this.getMode()];t[":errors"]=this.checkCurrentSettings()[":errors"];if(s){t[":designtime"]=s}if(e[":designtime"]){t[":designtime"]=n(t[":designtime"],e[":designtime"])}return t};G.prototype.checkCurrentSettings=function(){var e=this._settingsModel.getProperty("/"),t={};if(e&&e.form&&e.form.items){for(var i in e.form.items){var a=e.form.items[i];if(a.editable){if((a.isValid||a.required)&&!(this.getMode()==="translation"&&a.translatable)){if(a.isValid){t[a.manifestpath]=a.isValid(a)}t[a.manifestpath]=true;var n=a.value;var s=a.type;if(s==="string"&&n===""){t[a.manifestpath]=n}if((s==="date"||s==="datetime")&&isNaN(Date.parse(n))){t[a.manifestpath]=n}if(s==="integer"){if(isNaN(parseInt(n))){t[a.manifestpath]=n}else if(n<a.min||n>a.max){t[a.manifestpath]=n}}if(s==="number"){if(isNaN(parseFloat(n))){t[a.manifestpath]=n}else if(n<a.min||n>a.max){t[a.manifestpath]=n}}}}}t[":layer"]=L.layers[this.getMode()]}t[":errors"]=Object.values(t).indexOf(false)>-1;return t};G.prototype._createContextModel=function(){var e=this.getHostInstance(),t=new o({}),i=new o([]);this.setModel(t,"context");this.setModel(i,"contextflat");t._aPendingPromises=[];i._getPathObject=function(e){var t=this.getData().filter(function(t){if(t.path===e){return true}});return t.length?t[0]:null};i._getValueObject=function(e){var t=this.getData()||[];t=t.filter(function(t){if(t.value===e||t.object.value===e){return true}});return t.length?t[0]:null};var a=new Promise(function(t,i){if(e&&e.getContext){var a=false;setTimeout(function(){if(a){return}y.error("Editor context could not be determined with "+W+".");a=true;t({})},W);e.getContext().then(function(e){if(a){y.error("Editor context returned after more than "+W+". Context is ignored.")}a=true;t(e||{})})}else{t({})}});a.then(function(e){var a=this._mergeContextData(e);t.setData(a);i.setData(this.flattenData(a,"label"))}.bind(this));t.getProperty=function(t,i){if(t&&!t.startsWith("/")&&!i){t="/"+t}var a=this.resolve(t,i),n;if(a.endsWith("/value")){this._mValues=this._mValues||{};if(this._mValues.hasOwnProperty(a)){return this._mValues[a]}this._mValues[a]=undefined;n=d.timeoutPromise(e.getContextValue(a.substring(1)));n=n.then(function(e){this._mValues[a]=e;this.checkUpdate()}.bind(this)).catch(function(e){this._mValues[a]=null;this.checkUpdate();y.error("Path "+a+" could not be resolved. Reason: "+e)}.bind(this));this._aPendingPromises.push(n);return undefined}else{return o.prototype.getProperty.apply(this,arguments)}}};G.prototype._mergeContextData=function(e){var t={};t["empty"]=G._contextEntries.empty;for(var i in e){t[i]=e[i]}t["editor.internal"]=G._contextEntries["editor.internal"];return t};G.prototype._loadValueContextInDesigntime=function(){var e=this.getModel("context");var t=this._oDesigntimeInstance.getSettings();var i;if(t&&t.form&&t.form.items){i=JSON.stringify(t.form.items)}if(i){var a=/\{context\>[\/?\w+.]+\}/g;var n=i.match(a);var s;if(n&&n.length>0){n=n.filter(function(e){return e.endsWith("value}")});s=n.map(function(e){return e.substring("{context>".length,e.length-1)});s.forEach(function(t){e.getProperty(t)});return Promise.all(e._aPendingPromises).then(function(){e._aPendingPromises=[]})}}return Promise.resolve()};G.fieldMap={string:"sap/ui/integration/editor/fields/StringField","string[]":"sap/ui/integration/editor/fields/StringListField",integer:"sap/ui/integration/editor/fields/IntegerField",number:"sap/ui/integration/editor/fields/NumberField",boolean:"sap/ui/integration/editor/fields/BooleanField",date:"sap/ui/integration/editor/fields/DateField",datetime:"sap/ui/integration/editor/fields/DateTimeField",object:"sap/ui/integration/editor/fields/ObjectField","object[]":"sap/ui/integration/editor/fields/ObjectListField",destination:"sap/ui/integration/editor/fields/DestinationField",group:"sap/ui/integration/editor/fields/GroupField"};G.Fields=null;G.prototype._requireFields=function(){if(G.Fields){return Promise.resolve()}return new Promise(function(e){sap.ui.require(Object.values(G.fieldMap),function(){G.Fields={};for(var t in G.fieldMap){G.Fields[t]=arguments[Object.keys(G.fieldMap).indexOf(t)]}e()})})};G.prototype._createDescription=function(e,t){var i=new c(this.getId()+"_"+t+"_description_icon",{src:"sap-icon://message-information",color:"Marker",size:"12px",useIconTooltip:false,visible:typeof e.visible==="boolean"?"{currentSettings>visible}":e.visible,objectBindings:{currentSettings:{path:"currentSettings>"+e._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});i.addStyleClass("sapUiIntegrationEditorDescriptionIcon");i.onmouseover=function(t){t.addDependent(this._getPopover());this._getPopover().getContent()[0].applySettings({text:e.description});this._getPopover().openBy(t)}.bind(this,i);i.onmouseout=function(e){this._getPopover().close();e.removeDependent(this._getPopover())}.bind(this,i);return i};G.prototype._createMessageIcon=function(e,t){var i=e.getConfiguration();var a=new c(this.getId()+"_"+t+"_message_icon",{src:"sap-icon://message-information",size:"12px",visible:typeof i.visible==="boolean"?"{currentSettings>visible}":i.visible,useIconTooltip:false,objectBindings:{currentSettings:{path:"currentSettings>"+i._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});a.onmouseover=function(e){e._showMessage()}.bind(this,e);a.onmouseout=function(e){e._hideMessage()}.bind(this,e);a.addStyleClass("sapUiIntegrationEditorMessageIcon");return a};G.prototype._createLabel=function(e,t){var i=new u(this.getId()+"_"+t+"_label",{text:e.label,tooltip:e.tooltip||e.label,required:e.required&&e.editable||false,visible:typeof e.visible==="boolean"?"{currentSettings>visible}":e.visible,objectBindings:{currentSettings:{path:"currentSettings>"+e._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});i._cols=e.cols||2;if(e.layout){i._layout=e.layout}i._sOriginalType=e.type;return i};G.prototype._createSettingsButton=function(e,t){var i=e.getConfiguration();var a=new F(this.getId()+"_"+t+"_settings_btn",{icon:"{= ${currentSettings>_hasDynamicValue} ? 'sap-icon://display-more' : 'sap-icon://enter-more'}",type:"Transparent",tooltip:this._oResourceBundle.getText("EDITOR_FIELD_MORE_SETTINGS"),press:function(t){this._openSettingsDialog(200,t.oSource,e)}.bind(this),visible:typeof i.visible==="boolean"?"{currentSettings>visible}":i.visible,objectBindings:{currentSettings:{path:"currentSettings>"+i._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});return a};G.prototype._getSettingsPanel=function(e){if(!e._oSettingsPanel){e._oSettingsPanel=new O}return e._oSettingsPanel};G.prototype._openSettingsDialog=function(e,t,i){var a=this._getSettingsPanel(i);window.setTimeout(function(){a.setConfiguration(i.getConfiguration());a.open(t,t,this,i.getHost(),i,i._applySettings.bind(i),i._cancelSettings.bind(i))}.bind(this),e||600)};G.prototype._getPopover=function(){if(this._oPopover){return this._oPopover}var e=new v({text:""});e.addStyleClass("sapUiTinyMargin sapUiIntegrationEditorDescriptionText");this._oPopover=new _(this.getId()+"_popover",{showHeader:false,content:[e]});this._oPopover.addStyleClass("sapUiIntegrationEditorPopover");return this._oPopover};G.prototype._createField=function(e,t){var i=new G.Fields[e.type](this.getId()+"_"+t+"_field",{configuration:e,mode:this.getMode(),host:this.getHostInstance(),parameterKey:t,objectBindings:{currentSettings:{path:"currentSettings>"+e._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"},destinations:{path:"destinations>/"}},visible:typeof e.visible==="boolean"?"{currentSettings>visible}":e.visible});i.setAssociation("_editor",this);this._aFieldReadyPromise.push(i._readyPromise.then(function(){if(e.type!=="group"){if(e.require||e.validation||e.validations&&e.validations.length>0||e.values&&e.values.data&&!e.values.data.json){var a=this._createMessageIcon(i,t);i.setAssociation("_messageIcon",a)}if(e.description&&this.getMode()!=="translation"){i._descriptionIcon=this._createDescription(e,t)}if(e._changeDynamicValues){i._settingsButton=this._createSettingsButton(i,t);i._applyButtonStyles()}}}.bind(this)));if(e.type!=="group"){i._oValueBinding=this._settingsModel.bindProperty(e._settingspath+"/value");i._oValueBinding.attachChange(function(){if(!this._bIgnoreUpdates){e._changed=true;if(e._dependentFields&&e._dependentFields.length>0){this._updateEditor(e._dependentFields)}this._updatePreview()}}.bind(this));if(i.isFilterBackend()){var a=this._settingsModel.bindProperty(e._settingspath+"/suggestValue");a.attachChange(function(){var t=n({},e);t._cancel=false;this._addValueListModel(t,i)}.bind(this))}if(e.values){if(e.values.metadata){this._addMetadataModel(e,i)}if(e.type==="string[]"&&i.isFilterBackend()&&e.visualization&&e.visualization.type==="MultiInput"){i.setModel(new o({}),undefined)}else{this._addValueListModel(e,i)}}this._createDependentFields(e,i);i._oDataProviderFactory=this._oDataProviderFactory}i._cols=e.cols||2;if(e.layout){i._layout=e.layout}i._oEditorResourceBundles=this._oEditorResourceBundles;i.setAssociation("_messageStrip",H);return i};G.prototype._updateEditor=function(e){if(this._ready){if(e.length===0){return}for(var t=0;t<e.length;t++){var i=e[t];i.config._cancel=true}if(!this._oDataProviderFactory){return}this._bIgnoreUpdates=true;for(var t=0;t<e.length;t++){var i=e[t];i.config._cancel=false;this._addValueListModel(i.config,i.field,500*t)}this._bIgnoreUpdates=false}};G.prototype._updatePreview=function(){var e=this.getAggregation("_preview")||this._oPreview;if(e&&e.update){e.update()}};G.prototype._requestData=function(e,t){var i=this._oDataProviderFactory.create(e.values.data);i.bindObject({path:"items>/form/items"});i.bindObject({path:"currentSettings>"+e._settingspath});i.bindObject({path:"context>/"});var a=i.getData();a.then(function(i){if(e._cancel){e._values=[];this._settingsModel.setProperty(e._settingspath+"/_loading",false);return}var a=e.values.data.path,n,s=[];if(a&&a!=="/"){if(a.startsWith("/")){a=a.substring(1)}if(a.endsWith("/")){a=a.substring(0,a.length-1)}n=a.split("/");s=T.get(n,i)}else{s=i}if(e.type==="object"||e.type==="object[]"){s.forEach(function(e){e._dt={_editable:false}})}if(this.getMode()==="content"&&e.pageAdminValues&&e.pageAdminValues.length>0){var r=e.pageAdminValues,o=e.value,l=e.valueItems,d=[],f=[],g=[];this.prepareFieldsInKey(e);if(r.length>0){for(var u=0;u<r.length;u++){for(var p=0;p<s.length;p++){var h=this.getKeyFromItem(s[p]);if(r[u]===h){d.push(s[p])}}if(Array.isArray(o)){for(var c=0;c<o.length;c++){if(r[u]===o[c]){f.push(o[c])}}for(var _=0;_<l.length;_++){var m=this.getKeyFromItem(l[_]);if(r[u]===m){g.push(l[_])}}}}if(f.length>0){e.value=[];e.value=f}if(g.length>0){e.valueItems=[];e.valueItems=g}}if(e.values.data.path&&e.values.data.path!=="/"){delete i[n];T.set(n,d,i)}else{i=[];i=d}}var v=t.getConfiguration();if(e.type==="string[]"){var y=e.values.data.path;if(y&&y!=="/"){if(y.startsWith("/")){y=y.substring(1)}if(y.endsWith("/")){y=y.substring(0,y.length-1)}var n=y.split("/");var b=T.get(n,i);if(Array.isArray(b)){for(var I in b){var M=t.getKeyFromItem(b[I]);if(Array.isArray(v.value)&&v.value.length>0&&v.value.includes(M)){b[I].Selected=this._oResourceBundle.getText("EDITOR_ITEM_SELECTED")}else{b[I].Selected=this._oResourceBundle.getText("EDITOR_ITEM_UNSELECTED")}}T.set(n,b,i)}}else if(Array.isArray(i)){for(var I in i){var M=t.getKeyFromItem(i[I]);if(Array.isArray(v.value)&&v.value.length>0&&v.value.includes(M)){i[I].Selected=this._oResourceBundle.getText("EDITOR_ITEM_SELECTED")}else{i[I].Selected=this._oResourceBundle.getText("EDITOR_ITEM_UNSELECTED")}}}}e._values=i;var C=t.getModel();C.setData(i);C.checkUpdate(true);C.firePropertyChange();if(e.type==="object"||e.type==="object[]"){t.mergeValueWithRequestResult(s)}this._settingsModel.setProperty(e._settingspath+"/_loading",false);t._hideValueState(true,true)}.bind(this)).catch(function(i){var a=new Promise(function(e){var t=this._oResourceBundle.getText("EDITOR_BAD_REQUEST");if(Array.isArray(i)&&i.length>0){t=i[0];var a=i[1];if(a){var n;a.text().then(function(i){if(d.isJson(i)){n=JSON.parse(i).error}else{t=i}if(n){t=(n.code||n.errorCode||a.status)+": "+n.message}e(t)});return}else{e(t);return}}else if(typeof i==="string"){t=i;e(t);return}else{e(t);return}}.bind(this));return a.then(function(i){var a=t.getModel();a.firePropertyChange();if(e.type==="object"||e.type==="object[]"){t.mergeValueWithRequestResult()}this._settingsModel.setProperty(e._settingspath+"/_loading",false);t._showValueState("error",i,true)}.bind(this))}.bind(this))};G.prototype._requestExtensionData=function(){var e=this.getAggregation("_extension");if(!e){y.info("Extension is not defined or created, do not load data of it.");return new Promise(function(e,t){e()})}var t=false;var i={};var a=this._oEditorManifest.get(this.getConfigurationPath()+"/data/extension");var n;if(a){t=true;n=this._oEditorManifest.get(this.getConfigurationPath()+"/data/path");i={extension:a};if(n){i.path=n}}else{a=this._oEditorManifest.get("/"+this.getSection()+"/data/extension");if(a){t=true;n=this._oEditorManifest.get("/"+this.getSection()+"/data/path");i={extension:a};if(n){i.path=n}}}if(!t){y.info("Extension data is not defined in manifest, do not load data of it.");return new Promise(function(e,t){e()})}var s=this._oDataProviderFactory.create(i);var r=s.getData();return r.then(function(t){var i=e.getModel();if(!i){i=new o(t||{});e.setModel(i,undefined)}else{i.setData(t)}i.checkUpdate(true)}).catch(function(e){var t=this._oResourceBundle.getText("EDITOR_BAD_REQUEST");if(Array.isArray(e)&&e.length>0){t=e[0];var i=e[1];if(i){var a;i.text().then(function(e){if(d.isJson(e)){a=JSON.parse(e).error}else{t=e}if(a){t=(a.code||a.errorCode||i.status)+": "+a.message}y.error("Request extension data failed, "+t)})}}else if(typeof e==="string"){t=e;y.error("Request extension data failed, "+t)}}.bind(this))};G.prototype._addValueListModel=function(e,t,i){if(e.values){var a;if(e.values.data){if(this._oDataProviderFactory){a=t.getModel();if(!a){a=new o({});t.setModel(a,undefined)}this._settingsModel.setProperty(e._settingspath+"/_loading",true);if(!i){this._requestData(e,t)}else{setTimeout(function(){this._requestData(e,t)}.bind(this),i)}}t.bindObject({path:e.values.data.path||"/"})}else if(this.getAggregation("_extension")){a=this.getAggregation("_extension").getModel();if(a&&this.getMode()==="content"&&e.pageAdminValues&&e.pageAdminValues.length>0){this.prepareFieldsInKey(e);var n=e.values.path;if(n.length>1){n=n.substring(1)}var s=T.get([n],a.getData()),r=e.pageAdminValues,l=[];for(var d=0;d<r.length;d++){for(var f=0;f<s.length;f++){var g=this.getKeyFromItem(s[f]);if(r[d]===g){l.push(s[f])}}}delete s[n];T.set(n,l,s);a.setData(s)}t.bindObject({path:e.values.path||"/"});t.setModel(a,undefined)}}};G.prototype._addMetadataModel=function(e,t){if(e.values&&e.values.metadata){var i={synchronizationMode:"None"};i=n(i,e.values.metadata.request);var a={url:i.serviceUrl};var s=Promise.resolve(a);if(this._oDestinations){s=this._oDestinations.process(a)}s.then(function(e){if(!e.url.endsWith("/")){e.url=e.url+"/"}i.serviceUrl=e.url;var a=new l(i);a.oMetaModel.fetchData().then(function(e){t.setModel(new o(e),"meta")})})}};G.prototype._createDependentFields=function(e,t){if(e.values){var i=JSON.stringify(e.values.data);if(i){var a=/parameters\.([^\}\}]+)|destinations\.([^\}\}]+)|\{items\>[\/?\w+]+\}/g,s=i.match(a);if(s){for(var r=0;r<s.length;r++){var o="/value";var l=this.getConfigurationPath();if(s[r].indexOf("destinations.")===0||s[r].indexOf("parameters.")===0){if(s[r].indexOf("destinations.")===0){o="/name"}l=l+"/"+s[r].replace(".","/")+o}else if(s[r].indexOf("{items>")===0){l=l+"/parameters/"+s[r].slice(7,-1)}var d=this._mItemsByPaths[l];if(d){if(d._settingspath===e._settingspath){e=n({},e)}d._dependentFields=d._dependentFields||[];d._dependentFields.push({field:t,config:e})}}}}}};G.prototype.getBeforeLayerChange=function(e){if(!this._beforeLayerManifestChanges){this._beforeLayerManifestChanges={}}return this._beforeLayerManifestChanges[e]};G.prototype.getTranslationValueInTexts=function(e,t){var i="/texts/"+e;var a=this._settingsModel.getProperty(i)||{};return a[t]};G.prototype.deleteAllTranslationValuesInTexts=function(e){var t=this;var a=t._settingsModel.getData();if(!a||!a.texts){return}var n="/texts";var s=i(a.texts,500);for(var r in s){if(s[r][e]){delete s[r][e]}}this._settingsModel.setProperty(n,s)};G.prototype._addItem=function(e,a){var n=this.getMode();if(this.getAllowDynamicValues()===false||!e.allowDynamicValues){e.allowDynamicValues=false}if(this.getAllowSettings()===false){e.allowSettings=false}e.__cols=e.cols||2;if(e.visible===false||!e.translatable&&n==="translation"&&e.type!=="group"){return}if(e.type==="group"){e.expanded=e.expanded!==false;var s=this._createField(e,a);this.addAggregation("_formContent",s);if(e.hint){this._addHint(e.hint,this.getId()+"_"+a)}return}if(e.type==="separator"){var r=new E;this.addAggregation("_formContent",r);return}var o=null;var l=t.getConfiguration().getLanguage().replaceAll("_","-");if(n==="translation"){if(e.type!=="string"){return}if(typeof e.value==="string"&&e.value.indexOf("{")===0||typeof e.values!=="undefined"){return}e._language={value:e.value};e.cols=1;delete e.values;var d=i(e,500);d._settingspath+="/_language";d.editable=false;d.required=false;if(!G._oLanguages[l]&&l.indexOf("-")>-1){l=l.substring(0,l.indexOf("-"))}if(G._oLanguages[l]){var f=this.getTranslationValueInTexts(l,e.manifestpath);if(f){d.value=f}}if(!d.value){d.value="-"}var g=this._createLabel(d,a);this.addAggregation("_formContent",g);var u=this._createField(d,a+"_ori");u.isOrigLangField=true;this.addAggregation("_formContent",u);e.editable=e.visible=e.translatable;l=this._language;if(!this.getBeforeLayerChange(e.manifestpath)){e.value=e._translatedValue||""}var f=this.getTranslationValueInTexts(l,e.manifestpath);if(f){e.value=f}e.label=e._translatedLabel||"";e.required=false;var p=this._createField(e,a+"_trans");var h={onAfterRendering:function(e){var t=document.getElementById(p.getId());t.setAttribute("aria-label",g)}};p.addEventDelegate(h);this.addAggregation("_formContent",p)}else{o=this._createLabel(e,a);this.addAggregation("_formContent",o);var c=this.getBeforeLayerChange(e.manifestpath);if(c){e._beforeLayerChange=c}if(this._currentLayerManifestChanges&&this._currentLayerManifestChanges[e.manifestpath]){e.value=this._currentLayerManifestChanges[e.manifestpath];e._beforeLayerChange=e.value}if(e.type==="string"){l=this._language;var f=this.getTranslationValueInTexts(l,e.manifestpath);if(f){e.value=f}}var s=this._createField(e,a);var _={onAfterRendering:function(e){var t=document.getElementById(s.getId());t.setAttribute("aria-label",o)}};s.addEventDelegate(_);this.addAggregation("_formContent",s)}if(e.hint&&(!e.cols||e.cols===2)){this._addHint(e.hint,this.getId()+"_"+a)}e.cols=e.__cols;delete e.__cols};G.prototype._createHint=function(e,t){e=e.replace(/<a href/g,"<a target='blank' href");var i=new S(t+"_hint",{htmlText:e});return i};G.prototype._addHint=function(e,t){var i=this._createHint(e,t);this.addAggregation("_formContent",i)};G.prototype._getCurrentLanguageSpecificText=function(e){if(this._oTranslationBundle){var t=this._oTranslationBundle.getText(e,[],true);if(t===undefined){return""}return t}var i=this._language;if(!i){return""}var a=this._oEditorManifest.get("/sap.app/i18n"),n,s;if(!a){return""}if(typeof a==="string"){n=this.getBaseUrl()+a}else if(typeof a==="object"){if(a.bundleUrl){n=this.getBaseUrl()+a.bundleUrl}if(a.supportedLocales&&Array.isArray(a.supportedLocales)){s=a.supportedLocales;for(var r=0;r<s.length;r++){s[r]=s[r].replaceAll("_","-")}}}if(n){var o=[i];if(i.indexOf("-")>-1){o.push(i.substring(0,i.indexOf("-")))}if(!o.includes("en")){o.push("en")}o=this._filterSupportedFallbackLanguages(o,s);this._oTranslationBundle=I.create({url:n,async:false,locale:o[0],supportedLocales:o,fallbackLocale:"en"});return this._getCurrentLanguageSpecificText(e)}else{return""}};G.prototype._filterSupportedFallbackLanguages=function(e,t){if(Array.isArray(t)){var i=[];for(var a=0;a<e.length;a++){if(t.includes(e[a])){i.push(e[a])}}e=i}return e};G.prototype._startEditor=function(){var e=this.getAggregation("_formContent");if(e&&e.length>0){this.destroyAggregation("_formContent")}var i=this._settingsModel.getData();var a;if(i.form&&i.form.items){a=i.form.items;var s=false,r=this._destinationGroupAtTop?1:0,o=Object.keys(a),l=o.length,d=0;for(var f=r;f<l;f++){var g=a[o[f]];if(g.type==="destination"){if(!this._destinationGroupAtTop){break}d=f;continue}else if(g.type==="group"&&g.level!=="1"){break}else if(g.visible){s=true;break}}if(s){var u={type:"group",translatable:true,expanded:true,label:this._oResourceBundle.getText("EDITOR_PARAMETERS_GENERALSETTINGS"),_settingspath:"/form/items/generalPanel"};if(this._destinationGroupAtTop){var p={};var h=0;o.forEach(function(e){p[e]=a[e];if(h===d){p["generalPanel"]=u}h++});a=p}else{a=n({generalPanel:u},a)}i.form.items=a;this._settingsModel.setData(i)}}var c=this._settingsModel.getProperty("/");this._mItemsByPaths={};if(c.form&&c.form.items){a=c.form.items;var _=this._language||this.getLanguage()||t.getConfiguration().getLanguage().replaceAll("_","-");if(this.getMode()==="translation"){this._addItem({type:"group",translatable:true,expandable:false,expanded:true,label:this._oResourceBundle.getText("EDITOR_ORIGINALLANG")+": "+G._oLanguages[_]},"translationTopPanel")}for(var m in a){var g=a[m];if(g){g.label=g.label||m;var v;if(g.manifestpath){this._mItemsByPaths[g.manifestpath]=g;if(this.getMode()!=="translation"){v=this._currentLayerManifestChanges[g.manifestpath]}}g._changed=v!==undefined&&this.getMode()!=="translation";if(g.values){g.translatable=false}g._beforeValue=this._getManifestBeforelValue(g.manifestpath);if(g.type==="string"){g._translatedDefaultPlaceholder=this._getManifestDefaultValue(g.manifestpath);var y=null,b=g._translatedDefaultPlaceholder;if(b){if(this._isValueWithParameterSyntax(b)){g.translatable=false}if(this._isValueWithHandlebarsTranslation(b)){y=b.substring(2,b.length-2)}else if(b.startsWith("{i18n>")){y=b.substring(6,b.length-1)}if(y){g.translatable=true}else if(g.translatable&&this.getMode()==="translation"&&!this.getBeforeLayerChange(g.manifestpath)){g._translatedValue=g._translatedDefaultPlaceholder;g.value=g._translatedValue}}g._translatedPlaceholder=g._beforeValue;b=g._translatedPlaceholder;if(b){if(this._isValueWithParameterSyntax(b)){g.translatable=false}if(this._isValueWithHandlebarsTranslation(b)){y=b.substring(2,b.length-2)}else if(b.startsWith("{i18n>")){y=b.substring(6,b.length-1)}}if(g.value&&(g.value.indexOf("{context>")===0||g.value.indexOf("{{parameters")===0)){this.deleteAllTranslationValuesInTexts(g.manifestpath);y=null}var I=this.getTranslationValueInTexts(_,g.manifestpath);if(y){g._translatedValue=this.getModel("i18n").getResourceBundle().getText(y);if(g._changed){g.value=v}else if(g.value===g._translatedDefaultPlaceholder){g.value=g._translatedValue}if(this.getMode()==="translation"){var M=this._getCurrentLanguageSpecificText(y);if(M!==""){g._translatedValue=M}}else if(I){g.value=I}}else if(this.getMode()!=="translation"&&g.translatable&&I){g.value=I}if(this.getMode()==="translation"){if(this._isValueWithHandlebarsTranslation(g.label)){g._translatedLabel=this._getCurrentLanguageSpecificText(g.label.substring(2,g.label.length-2),true)}else if(g.label&&g.label.startsWith("{i18n>")){g._translatedLabel=this._getCurrentLanguageSpecificText(g.label.substring(6,g.label.length-1),true)}}}else if(g.type==="string[]"){var C=g.manifestpath.substring(0,g.manifestpath.lastIndexOf("/"))+"/valueItems";var P=this._manifestModel.getProperty(C);if(P){g.valueItems=P}var x=g.manifestpath.substring(0,g.manifestpath.lastIndexOf("/"))+"/valueTokens";var T=this._manifestModel.getProperty(x);if(T){g.valueTokens=T}}else if(typeof g.value==="object"&&g.type==="object"){if(typeof g.value._editable==="boolean"){g.value._dt={_editable:g.value._editable};delete g.value._editable}}else if(Array.isArray(g.value)&&g.value.length>0&&g.type==="object[]"){g.value.forEach(function(e){if(typeof e._editable==="boolean"){e._dt={_editable:e._editable};delete e._editable}})}if(g.label&&this._isValueWithHandlebarsTranslation(g.label)){var S=g.label.substring(2,g.label.length-2);if(S){g.label=this.getModel("i18n").getResourceBundle().getText(S)}}}}}for(var m in a){var g=a[m];this._addItem(g,m)}var D=this._settingsModel.getProperty("/form/height")!==undefined?this._settingsModel.getProperty("/form/height"):"350px",E=this._settingsModel.getProperty("/form/width")!==undefined?this._settingsModel.getProperty("/form/width"):"100%";if(this.getProperty("height")===""){this.setProperty("height",D);document.body.style.setProperty("--sapUiIntegrationEditorFormHeight",D);document.body.style.setProperty("--sapUiIntegrationEditorPreviewHeight",D)}if(this.getProperty("width")===""){this.setProperty("width",E);document.body.style.setProperty("--sapUiIntegrationEditorFormWidth",E)}if(this.getMode()!=="translation"&&this.getPreviewPosition()!=="separate"){this._initPreview()}Promise.all(this._aFieldReadyPromise).then(function(){this._ready=true;this.fireReady()}.bind(this))};G.prototype.setHeight=function(e){if(e){this.setProperty("height",e);document.body.style.setProperty("--sapUiIntegrationEditorFormHeight",e);document.body.style.setProperty("--sapUiIntegrationEditorPreviewHeight",e)}};G.prototype.setWidth=function(e){if(e){this.setProperty("width",e);document.body.style.setProperty("--sapUiIntegrationEditorFormWidth",e)}};G.prototype.destroy=function(){if(this._oPopover){this._oPopover.destroy()}if(this._oDesigntimeInstance){this._oDesigntimeInstance.destroy()}var i=this.getAggregation("_preview");if(i&&i.destroy){i.destroy()}var a=t.byId(H);if(a){a.destroy()}this._manifestModel=null;this._beforeManifestModel=null;this._oInitialManifestModel=null;this._settingsModel=null;this._destinationsModel=null;document.body.style.removeProperty("--sapUiIntegrationEditorFormWidth");document.body.style.removeProperty("--sapUiIntegrationEditorFormHeight");e.prototype.destroy.apply(this,arguments)};G.prototype._initPreview=function(){};G.prototype._applyDesigntimeDefaults=function(e){e=e||{};e.form=e.form||{};e.form.items=e.form.items||{};var t=e.form.items||e.form.items;for(var i in t){var a=t[i];if(a.type==="destination"){continue}if(a.manifestpath){a.value=this._manifestModel.getProperty(a.manifestpath)}if(a.visible===undefined||a.visible===null){a.visible=true}if(a.editable===undefined||a.editable===null){a.editable=true}if(this.getMode()!=="admin"){if(a.visibleToUser!==undefined){a.visible=a.visibleToUser}if(a.editableToUser!==undefined){a.editable=a.editableToUser}}if(typeof a.translatable!=="boolean"){a.translatable=false}if(!a.label){a.label=i}if(!a.type||a.type==="enum"){a.type="string"}if(a.value===undefined||a.value===null){switch(a.type){case"boolean":a.value=false;break;case"integer":case"number":a.value=0;break;case"string[]":a.value=[];break;case"object":a.value=undefined;break;case"object[]":a.value=undefined;break;default:a.value=""}}if(a.type==="group"){if(a.visible===undefined||a.value===null){a.visible=true}}a._settingspath="/form/items/"+i}};G.prototype._applyDesigntimeLayers=function(e){var t={};var i={};if(this._appliedLayerManifestChanges&&Array.isArray(this._appliedLayerManifestChanges)){for(var s=0;s<this._appliedLayerManifestChanges.length;s++){var r=this._appliedLayerManifestChanges[s][":designtime"];if(r){var o=Object.keys(r);for(var l=0;l<o.length;l++){var d=o[l],f=r[d];if(!d.endsWith("/pageAdminValues")&&typeof f==="object"){if(f.configuration&&f.configuration.parameterFromDestination){var g=f.configuration;delete g.parameterFromDestination;g.value=this._manifestModel.getProperty(g.manifestpath);g._settingspath="/form/items/"+f.parameter;this._settingsModel.setProperty(g._settingspath,g)}else{i[o[l]]=n(i[o[l]],f);continue}}else{this._settingsModel.setProperty(o[l],f)}}}var u=this._appliedLayerManifestChanges[s]["texts"];if(u){t=n(t,u)}}}if(this._currentLayerManifestChanges){var r=this._currentLayerManifestChanges[":designtime"];if(r){var o=Object.keys(r);for(var l=0;l<o.length;l++){var d=o[l],f=r[d];p=d.substring(0,d.lastIndexOf("/")+1)+"_next";if(!d.endsWith("/pageAdminValues")&&typeof f==="object"){if(!f.configuration||!f.configuration.parameterFromDestination){i[d]=n(i[d],f);continue}}if(!this._settingsModel.getProperty(p)){this._settingsModel.setProperty(p,{})}var p=d.substring(0,d.lastIndexOf("/")+1)+"_next",h=d.substring(d.lastIndexOf("/")+1);this._settingsModel.setProperty(p+"/"+h,f)}}var c=this._currentLayerManifestChanges["texts"];if(c){t=n(t,c)}}if(!a(t,{})){this._settingsModel.setProperty("/texts",t)}if(!a(i,{})){this._settingsModel.setProperty("/:designtime",i)}};G.prototype._createParameterDesigntime=function(e){var t={},i=this.getConfigurationPath()+"/parameters",a=this.getMode();if(e&&e.parameters){t.form=t.form||{};t.form.items=t.form.items||{};var s=t.form.items;Object.keys(e.parameters).forEach(function(t){s[t]=n({manifestpath:i+"/"+t+"/value",editable:a!=="translation",_settingspath:"/form/items/"+t},e.parameters[t]);var r=s[t];if(!r.type){r.type="string"}if(!r.hasOwnProperty("visible")){r.visible=true}})}return new r(t)};G.prototype._addDestinationSettings=function(e){var t=this._oDesigntimeInstance.getSettings(),i=this.getConfigurationPath()+"/destinations";t.form=t.form||{};t.form.items=t.form.items||{};if(t&&e&&e.destinations){this._destinationGroupAtTop=false;var a=t.form.items,s={},r=this.getHostInstance();var o={label:this._oResourceBundle.getText("EDITOR_DESTINATIONS")||"Destinations",type:"group",expanded:true,visible:true,_settingspath:"/form/items/destination.group"};if(a["destination.group"]){this._destinationGroupAtTop=Object.keys(a)[0]==="destination.group";o=n(o,a["destination.group"]);delete a["destination.group"]}s["destination.group"]=o;Object.keys(e.destinations).forEach(function(t){var r=n({manifestpath:i+"/"+t+"/name",visible:true,type:"destination",editable:true,allowDynamicValues:false,allowSettings:false,value:e.destinations[t].name,defaultValue:e.destinations[t].defaultUrl,_settingspath:"/form/items/"+[t+".destination"],_values:[],_destinationName:t},e.destinations[t]);if(typeof r.label==="undefined"){r.label=t}if(a[t+".destination"]){r=n(r,a[t+".destination"]);delete a[t+".destination"]}s[t+".destination"]=r});if(this._destinationGroupAtTop){t.form.items=n(s,a)}else{t.form.items=n(a,s)}var l=false;if(r){this._destinationsModel.setProperty("/_loading",true);this._destinationsModel.checkUpdate(true);this.getHostInstance().getDestinations().then(function(e){l=true;this._destinationsModel.setProperty("/_values",e);this._destinationsModel.setProperty("/_loading",false);this._destinationsModel.setSizeLimit(e.length);this._destinationsModel.checkUpdate(true)}.bind(this)).catch(function(){return this.getHostInstance().getDestinations()}.bind(this)).then(function(e){if(l){return}this._destinationsModel.setProperty("/_values",e);this._destinationsModel.setProperty("/_loading",false);this._destinationsModel.setSizeLimit(e.length);this._destinationsModel.checkUpdate(true)}.bind(this)).catch(function(e){this._destinationsModel.setProperty("/_loading",false);this._destinationsModel.checkUpdate(true);y.error("Can not get destinations list from '"+r.getId()+"'.")}.bind(this))}}};G.prototype._deleleDestinationSettings=function(){var e=this._oDesigntimeInstance.getSettings();e.form=e.form||{};e.form.items=e.form.items||{};delete e.form.items["destination.group"];for(var t in e.form.items){var i=e.form.items[t];if(i.type==="destination"){delete e.form.items[t]}}};G.prototype._getManifestDefaultValue=function(e){return this._oInitialManifestModel.getProperty(e)};G.prototype._getManifestBeforelValue=function(e){return this._beforeManifestModel.getProperty(e)};G.prototype._isValueWithHandlebarsTranslation=function(e){if(typeof e==="string"){return!!e.match(j)}return false};G.prototype._isValueWithParameterSyntax=function(e){if(typeof e==="string"){return!!e.match(N)}return false};G.prototype.prepareFieldsInKey=function(e){this._sKeySeparator=e.values.keySeparator;if(!this._sKeySeparator){this._sKeySeparator="#"}var t=e.values.item.key;this._aFields=t.split(this._sKeySeparator);for(var i in this._aFields){if(this._aFields[i].startsWith("{")){this._aFields[i]=this._aFields[i].substring(1)}if(this._aFields[i].endsWith("}")){this._aFields[i]=this._aFields[i].substring(0,this._aFields[i].length-1)}}};G.prototype.getKeyFromItem=function(e){var t="";this._aFields.forEach(function(i){t+=e[i].toString()+this._sKeySeparator}.bind(this));if(t.endsWith(this._sKeySeparator)){t=t.substring(0,t.length-this._sKeySeparator.length)}return t};G._contextEntries={empty:{label:k.getText("EDITOR_CONTEXT_EMPTY_VAL"),type:"string",description:k.getText("EDITOR_CONTEXT_EMPTY_DESC"),placeholder:"",value:""},"editor.internal":{label:k.getText("EDITOR_CONTEXT_EDITOR_INTERNAL_VAL"),todayIso:{type:"string",label:k.getText("EDITOR_CONTEXT_EDITOR_TODAY_VAL"),description:k.getText("EDITOR_CONTEXT_EDITOR_TODAY_DESC"),tags:[],placeholder:k.getText("EDITOR_CONTEXT_EDITOR_TODAY_VAL"),customize:["format.dataTime"],value:"{{parameters.TODAY_ISO}}"},nowIso:{type:"string",label:k.getText("EDITOR_CONTEXT_EDITOR_NOW_VAL"),description:k.getText("EDITOR_CONTEXT_EDITOR_NOW_DESC"),tags:[],placeholder:k.getText("EDITOR_CONTEXT_EDITOR_NOW_VAL"),customize:["dateFormatters"],value:"{{parameters.NOW_ISO}}"},currentLanguage:{type:"string",label:k.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),description:k.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),tags:["technical"],customize:["languageFormatters"],placeholder:k.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),value:"{{parameters.LOCALE}}"}}};G._oLanguages={};G._appendThemeVars=function(){var e=["sapUiButtonHoverBackground","sapUiBaseBG","sapUiContentLabelColor","sapUiTileSeparatorColor","sapUiHighlight","sapUiListSelectionBackgroundColor","sapUiNegativeText","sapUiCriticalText","sapUiPositiveText","sapUiChartScrollbarBorderColor"];var t=x.get({name:e,callback:function(e){}});if(t){for(var i in t){document.body.style.setProperty("--"+i,t[i])}}};G.init=function(){this.init=function(){};G._appendThemeVars();t.attachThemeChanged(function(){G._appendThemeVars()});var e=sap.ui.require.toUrl("sap.ui.integration.editor.css.Editor".replace(/\./g,"/")+".css");C(e);P.loadResource("sap/ui/integration/editor/languages.json",{dataType:"json",failOnError:false,async:true}).then(function(e){G._oLanguages=e})};G.init();return G});
//# sourceMappingURL=Editor.js.map