/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/editor/fields/BaseField","sap/m/Panel","sap/m/IconTabBar","sap/m/IconTabFilter","sap/m/MessageStrip","sap/ui/core/Core"],function(e,t,r,i,n,a){"use strict";var s=e.extend("sap.ui.integration.editor.fields.GroupField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});s.prototype.initVisualization=function(e){var i=e.visualization;if(!i||i.type==="Panel"){i={type:t,settings:{headerText:e.label,visible:e.visible,expandable:e.expandable!==false,expanded:"{currentSettings>expanded}",width:"auto",backgroundDesign:"Transparent",objectBindings:{currentSettings:{path:"currentSettings>"+(e._settingspath||"/form/items")},items:{path:"items>/form/items"},context:{path:"context>/"}},expand:function(e){var t=e.getParameter("expand");if(t){var r=e.getSource();var i=this.getConfiguration();if(!r._level){r._level=i.level||0}var n=r._level==="1"&&this.getParent().getParent()?this.getParent().getParent().getAggregation("_messageStrip"):this.getParent().getAggregation("_messageStrip");if(n===null){n=a.byId(this.getAssociation("_messageStrip"))}r.addContent(n);r.focus()}}.bind(this)}}}else if(i.type==="Tab"){i={type:r,settings:{expandable:e.expandable!==false,visible:e.visible,expanded:"{currentSettings>expanded}",objectBindings:{currentSettings:{path:"currentSettings>"+(e._settingspath||"/form/items")},items:{path:"items>/form/items"},context:{path:"context>/"}},select:this.checkErrorsInIconTabBar.bind(this)}}}this._visualization=i;this.attachAfterInit(this._afterInit)};s.prototype._afterInit=function(){var e=this.getConfiguration();var a=this.getAggregation("_field");if(a instanceof t){if(this.getMode()!=="translation"){var s=this.getResourceBundle();var o=new n({id:this.getParameterId()+"_strip",showIcon:false,visible:"{= !${currentSettings>expanded} && ${currentSettings>hasError} === true}",text:{path:"currentSettings>errorType",formatter:function(e){var t="";switch(e){case"Error":t=s.getText("EDITOR_GROUP_ERRORS");break;case"Warning":t=s.getText("EDITOR_GROUP_WARNINGS");break;default:}return t}},type:"{currentSettings>errorType}",objectBindings:{currentSettings:{path:"currentSettings>"+(e._settingspath||"/form/items")}}});if(e.level!=="1"){o.setModel(this._settingsModel,"currentSettings")}o.addStyleClass("sapUiIntegrationEditorPanelMessageStrip");a._messageStrip=o}a._cols=e.cols||2;a._level=e.level||0;var g={onAfterRendering:function(i){var n=i.srcControl;var a=document.getElementById(n.getId());a.setAttribute("aria-label",e.label);if(n._subItems&&n._subItems.length>0){this.checkErrorsInSubItems(this._settingsModel,n)}var s=n._messageStrip;if(n._level!=="1"&&s){s.rerender()}if(n.getExpanded()){var o=n.getContent();o.forEach(function(e){if(e.isA("sap.ui.integration.editor.fields.GroupField")){var i=e.getAggregation("_field");if(i instanceof t&&i._subItems&&i._subItems.length>0){e.checkErrorsInSubItems(e._settingsModel,i)}else if(i instanceof r&&i.getItems().length>0){e.checkErrorsInIconTabBar()}}})}}.bind(this)};a.addEventDelegate(g)}else if(a instanceof r){var l=new i(this.getParameterId()+"_control_icontabfilter",{text:e.label,visible:e.visible,objectBindings:{currentSettings:{path:"currentSettings>"+(e._settingspath||"/form/items")},items:{path:"items>/form/items"},context:{path:"context>/"}}});a.addItem(l);a.setBackgroundDesign("Transparent");a.setHeaderBackgroundDesign("Transparent");a.addStyleClass("sapUiIntegrationEditorSubGroup");if(this.getMode()!=="translation"){var d=new n({id:this.getParameterId()+"_strip",showIcon:false,visible:false,objectBindings:{currentSettings:{path:"currentSettings>"+(e._settingspath||"/form/items")}}});d.addStyleClass("sapUiIntegrationEditorTabMessageStrip");a._messageStrip=d}a._level=e.level||0}};s.prototype.checkErrorsInIconTabBar=function(e){var t=this.getAggregation("_field"),r=t.getSelectedKey(),n=t.getItems(),s=t.getExpanded(),o=false;for(var g=0;g<n.length;g++){if(!s){o=true}else if(n[g].getId()!==r){o=true}else if(n[g].getId()===r){o=false}if(o){var l=false,d="None";if(n[g]._subItems&&n[g]._subItems.length>0){var u=n[g].getModel("currentSettings");var c=this.checkErrorsInSubItems(u,n[g]);l=c.hasError;d=c.errorType}if(l){var p=new i,f=n[g];if(f.getItems().length>0){f.removeAllItems()}f.addItem(p);this._handleITBValidation(f,d);if(f._oExpandButton===undefined){this._delayHandleITBValidation(f,d)}else{this._handleITBValidation(f,d)}}}else if(n[g].getItems().length>0){n[g].removeItem(n[g].getItems()[0]);if(n[g]._oExpandButton){n[g]._oExpandButton.visible=false}var h=this.getParent().getParent().getAggregation("_messageStrip");if(h===null){h=a.byId(this.getAssociation("_messageStrip"))}n[g].addContent(h)}}};s.prototype.checkErrorsInSubItems=function(e,t){var r=false;var i="None";for(var n=0;n<t._subItems.length;n++){var s=t._subItems[n].settingspath;var o=a.byId(t._subItems[n].itemId);if(e.getProperty(s+"/hasError")===true&&o.getVisible()){r=true;var g=e.getProperty(s+"/errorType");if(g==="Error"){i="Error";break}else if(g==="Warning"&&i!=="Error"){i="Warning"}}}e.setProperty("hasError",r,this.getBindingContext("currentSettings"));e.setProperty("errorType",i,this.getBindingContext("currentSettings"));return{hasError:r,errorType:i}};s.prototype._handleITBValidation=function(e,t){var r=this.getResourceBundle();if(e.getItems().length>0&&e._oExpandButton){var i=e._oExpandButton;var n=null;if(t==="Error"){n=r.getText("EDITOR_GROUP_ERRORS");i.setIcon("sap-icon://message-error");i.addStyleClass("errorBTNImage")}else if(t==="Warning"){n=r.getText("EDITOR_GROUP_WARNINGS");i.setIcon("sap-icon://message-warning");i.addStyleClass("warningBTNImage")}i.setTooltip(null);i.addEventDelegate({onAfterRendering:function(e){var t=document.getElementById(i.getId());t.setAttribute("aria-label","With validation errors");t.setAttribute("title","")}});i.setEnabled(false);i.addStyleClass("errorBTN").addStyleClass("errorBTNDisabled");var s=a.byId(this.getParameterId()+"_strip");i.addEventDelegate({onmouseover:function(){s.setVisible(true);s.setType(t);s.setText(n)},onmouseout:function(){s.setVisible(false)}},this)}};s.prototype._delayHandleITBValidation=function(e,t){var r=this;var i=setInterval(function(){if(e._oExpandButton){r._handleITBValidation(e,t);clearInterval(i)}},50)};return s});
//# sourceMappingURL=GroupField.js.map