//@ui5-bundle sap/ui/integration/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/ActionDefinition", ["sap/m/library","sap/ui/core/Element"],function(e,t){"use strict";var a=e.ButtonType;var i=t.extend("sap.ui.integration.ActionDefinition",{metadata:{library:"sap.ui.integration",properties:{type:{type:"sap.ui.integration.CardActionType"},text:{type:"string",defaultValue:""},icon:{type:"sap.ui.core.URI"},buttonType:{type:"sap.m.ButtonType",defaultValue:a.Transparent},enabled:{type:"boolean",defaultValue:true},visible:{type:"boolean",defaultValue:true},parameters:{type:"object"}},events:{press:{}},associations:{_menuButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}}}});return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/Designtime", ["sap/ui/base/ManagedObject"],function(t){"use strict";var e=t.extend("sap.ui.integration.Designtime",{metadata:{library:"sap.ui.integration"},constructor:function(e){t.apply(this);this.settings=e||this.create&&this.create()||{}}});e.prototype.init=function(){this._oCard=null};e.prototype.exit=function(){this._oCard=null};e.prototype.onCardReady=function(t,e){this._oCard=t;this._oInternalCardInstance=e};e.prototype._readyPromise=function(t,e){this.onCardReady(t,e);return Promise.resolve()};e.prototype.getCard=function(){return this._oCard};e.prototype.getSettings=function(){return this.settings};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/Extension", ["sap/ui/integration/library","sap/base/Log","sap/ui/base/ManagedObject","sap/base/util/fetch"],function(t,e,r,o){"use strict";var i=r.extend("sap.ui.integration.Extension",{metadata:{library:"sap.ui.integration",properties:{actions:{type:"sap.ui.integration.CardMenuAction[]",deprecated:true},formatters:{type:"object"}},events:{action:{allowPreventDefault:true,parameters:{card:{type:"sap.ui.core.Control"},actionConfig:{type:"object"},actionSource:{type:"sap.ui.core.Control"},parameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}}}}});i.prototype.init=function(){this._oCardInterface=null;this._oCard=null};i.prototype.exit=function(){this._oCardInterface=null;this._oCard=null};i.prototype.setActions=function(t){this.setProperty("actions",t);if(this._oCard){this._oCard._refreshActionsMenu()}return this};i.prototype.setFormatters=function(t){this.setProperty("formatters",t);if(!this._oCard){return this}if(!this._oCard._bApplyManifest||this._oCard.getAggregation("_extension")!==this){e.error("Extension formatters must be set before the initialization of the card. Do this inside Extension#init().")}return this};i.prototype.onCardReady=function(){};i.prototype.loadDependencies=function(){return Promise.resolve()};i.prototype.getCard=function(){return this._oCardInterface};i.prototype.fetch=function(t,e,r){var i=this._oCard,n=this._oCard.getHostInstance();if(n){return n.fetch(t,e,r,i)}else{return o(t,e)}};i.prototype._setCard=function(t,e){this._oCard=t;this._oCardInterface=e};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/Host", ["sap/ui/integration/library","sap/ui/core/Element","sap/ui/core/Supportability","sap/base/util/fetch"],function(e,t,r,i){"use strict";var o=t.extend("sap.ui.integration.Host",{metadata:{library:"sap.ui.integration",properties:{actions:{type:"sap.ui.integration.CardMenuAction[]"},resolveDestination:{type:"function",invalidate:false,parameters:{destinationName:{type:"string"},card:{type:"sap.ui.integration.widgets.Card"}}}},events:{action:{allowPreventDefault:true,parameters:{card:{type:"sap.ui.core.Control"},actionConfig:{type:"object"},actionSource:{type:"sap.ui.core.Control"},parameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}},cardConfigurationChange:{parameters:{card:{type:"sap.ui.core.Control"},changes:{type:"object"}}},cardStateChanged:{parameters:{card:{type:"sap.ui.core.Control"}}},cardInitialized:{parameters:{card:{type:"sap.ui.core.Control"}}},message:{parameters:{data:{type:"object"}}}}}});o.prototype.init=function(){this._handlePostMessageBound=this._handlePostMessage.bind(this)};o.prototype.getDestination=function(e,t){var r=this.getResolveDestination(),i;if(typeof r!=="function"){return Promise.reject("Could not resolve destination '"+e+"'. There is no 'resolveDestination' callback function configured in the host.")}i=r(e,t);if(i===null||i===undefined){return Promise.reject("Destination '"+e+"' could not be resolved by the host.")}if(i instanceof Promise){return i}return Promise.resolve(i)};o.prototype.getCsrfToken=function(e){return Promise.resolve()};o.prototype.csrfTokenFetched=function(e,t){};o.prototype.csrfTokenExpired=function(e){};o.prototype.getContextValue=function(e){if(!e){return Promise.resolve(null)}return Promise.resolve(null)};o.prototype.getDestinations=function(){return Promise.resolve([])};o.prototype.getContexts=function(){return Promise.resolve({})};o.prototype.useExperimentalCaching=function(){this.bUseExperimentalCaching=true;this.subscribeForMessages()};o.prototype.stopUsingExperimentalCaching=function(){this.bUseExperimentalCaching=false;this.unsubscribeForMessages()};o.prototype.modifyRequestHeaders=function(e,t,r){return e};o.prototype.modifyRequest=function(e,t,r){return e};o.prototype.fetch=function(e,t,o,a){if(r.isStatisticsEnabled()){e=this._addStatisticsParameter(e)}if(this.bUseExperimentalCaching){this._addCacheHeaders(t.headers,o)}return i(e,t)};o.prototype._addStatisticsParameter=function(e){var t=new URL(e,window.location.href);t.searchParams.set("sap-statistics","true");return t.href};o.prototype._addCacheHeaders=function(e,t){var r=t.cache,i=[];if(r.enabled===false){i.push("max-age=0");i.push("no-store")}else{i.push("max-age="+parseInt(r.maxAge||0));if(r.staleWhileRevalidate){i.push("x-stale-while-revalidate")}}if(i.length){e.set("Cache-Control",i.join(", "))}e.set("x-sap-card","true");e.set("x-use-cryptocache","true")};o.prototype.subscribeForMessages=function(){if(!navigator||!navigator.serviceWorker){return}navigator.serviceWorker.addEventListener("message",this._handlePostMessageBound)};o.prototype.unsubscribeForMessages=function(){if(!navigator||!navigator.serviceWorker){return}navigator.serviceWorker.removeEventListener("message",this._handlePostMessageBound)};o.prototype._handlePostMessage=function(e){this.fireMessage({data:e.data})};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/bindingFeatures/DateRange", ["sap/ui/core/date/UniversalDateUtils","sap/base/Log"],function(e,n){"use strict";var r={start:function(e,n){var r=this._getRange(e,n);if(!r){return null}return r[0]},end:function(e,n){var r=this._getRange(e,n);if(!r){return null}return r[1]},_getRange:function(r,t){var a=e.ranges[r];if(!a){n.error("The requested date range type '"+r+"' is not found","sap.ui.integration.widgets.Card");return null}return a(t)}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/AdaptiveContent", ["sap/ui/integration/library","sap/ui/core/library","sap/ui/dom/includeScript","sap/ui/integration/cards/BaseContent","sap/ui/integration/cards/adaptivecards/elements/hostConfig","sap/m/VBox","sap/ui/core/HTML","sap/ui/core/Core","sap/ui/model/json/JSONModel","sap/base/Log"],function(t,e,n,i,a,r,o,s,d,p){"use strict";var u,l,c,g,h,f,C,m,y,v;var _=e.MessageType;var b=i.extend("sap.ui.integration.cards.AdaptiveContent",{metadata:{library:"sap.ui.integration"},renderer:{apiVersion:2,render:function(t,e){var n=i.getMetadata().getRenderer();return n.render.apply(this,arguments)}}});b.prototype.init=function(){i.prototype.init.apply(this,arguments);this.awaitEvent("_adaptiveCardElementsReady");this.fireEvent("_actionContentReady");this.setComponentsReady(false);this._setupCardContent()};b.prototype.onAfterRendering=function(){this._renderMSCardContent(this._oCardTemplate||this.getConfiguration())};b.prototype.loadDependencies=function(t){var e=[this._loadWebcomponents()];e.push(new Promise(function(t,e){sap.ui.require(["sap/ui/integration/thirdparty/adaptivecards","sap/ui/integration/thirdparty/adaptivecards-templating","sap/ui/integration/cards/adaptivecards/elements/UI5InputText","sap/ui/integration/cards/adaptivecards/elements/UI5InputNumber","sap/ui/integration/cards/adaptivecards/elements/UI5InputChoiceSet","sap/ui/integration/cards/adaptivecards/elements/UI5InputTime","sap/ui/integration/cards/adaptivecards/elements/UI5InputDate","sap/ui/integration/cards/adaptivecards/elements/UI5InputToggle","sap/ui/integration/cards/adaptivecards/overwrites/ActionRender"],function(e,n,i,a,r,o,s,d,p){u=e;l=n;g=i;h=a;f=r;C=o;m=s;y=d;v=p;this._setupAdaptiveCardDependency();t()}.bind(this),e)}.bind(this)));if(t.get("/sap.card/configuration/enableMarkdown")){e.push(new Promise(function(t,e){sap.ui.require(["sap/ui/integration/thirdparty/markdown-it"],function(e){c=e;t()},e)}))}return Promise.all(e)};b.prototype._setupCardContent=function(){var t=new o(this.getId()+"content",{preferDOM:false,content:"<div>&nbsp;</div>"});this.setAggregation("_content",new r({items:[t]}))};b.prototype.applyConfiguration=function(){var t=this.getConfiguration();if(t&&t.request&&t.request.url){this._loadManifestFromUrl(t.request.url);return}this._handleMarkDown();this._setupMSCardContent()};b.prototype.onThemeChanged=function(){if(this.getDomRef()&&u){this._adjustHostConfig();this.invalidate()}};b.prototype._handleMarkDown=function(){var t=this;u.AdaptiveCard.onProcessMarkdown=function(e,n){var i=t.getParent(),a=i&&i.getManifestEntry("/sap.card/configuration/enableMarkdown");if(a){n.outputHtml=(new c).render(e);n.didProcess=true;return n}}};b.prototype._loadManifestFromUrl=function(t){var e=new d,n=this;e.loadData(t).then(function(){n.setConfiguration(Object.assign(n.getConfiguration(),e.getData()))}).then(function(){n._handleMarkDown();n._setupMSCardContent()}).then(function(){e.destroy();e=null}).catch(function(){this.fireEvent("_dataReady");this.fireEvent("_adaptiveCardElementsReady");p.error("No JSON file found on this URL. Please provide a correct path to the JSON-serialized card object model file.")}.bind(this))};b.prototype._setupAdaptiveCardDependency=function(){this.adaptiveCardInstance=new u.AdaptiveCard;this._doMSCardsOverwrites();this._adjustHostConfig();this._handleActions();this._replaceElements();this._isRtl()};b.prototype._doMSCardsOverwrites=function(){u.Action.prototype.render=v};b.prototype._adjustHostConfig=function(){this.adaptiveCardInstance.hostConfig=new u.HostConfig(a())};b.prototype._isRtl=function(){this.adaptiveCardInstance.isRtl=function(){return s.getConfiguration().getRTL()}};b.prototype._handleActions=function(){this.adaptiveCardInstance.onExecuteAction=function(e){var n,i,a;if(e instanceof u.OpenUrlAction){i={url:e.url};n=t.CardActionType.Navigation}else if(e instanceof u.SubmitAction){this.getModel("form").setProperty("/",e.data);n=t.CardActionType.Submit}else{return}a=this.getActions();if(a){a.fireAction(this,n,i)}}.bind(this)};b.prototype.onActionSubmitStart=function(t){this.getParent().setBusy(true)};b.prototype.onActionSubmitEnd=function(t,e){var n=s.getLibraryResourceBundle("sap.ui.integration"),i=e?n.getText("CARDS_ADAPTIVE_ACTION_SUBMIT_ERROR"):n.getText("CARDS_ADAPTIVE_ACTION_SUBMIT_SUCCESS"),a=e?_.Error:_.Success;this.showMessage(i,a);this.getParent().setBusy(false)};b.prototype._replaceElements=function(){u.GlobalRegistry.elements.unregister("Input.Text");u.GlobalRegistry.elements.register("Input.Text",g);u.GlobalRegistry.elements.unregister("Input.Number");u.GlobalRegistry.elements.register("Input.Number",h);u.GlobalRegistry.elements.unregister("Input.ChoiceSet");u.GlobalRegistry.elements.register("Input.ChoiceSet",f);u.GlobalRegistry.elements.unregister("Input.Time");u.GlobalRegistry.elements.register("Input.Time",C);u.GlobalRegistry.elements.unregister("Input.Date");u.GlobalRegistry.elements.register("Input.Date",m);u.GlobalRegistry.elements.unregister("Input.Toggle");u.GlobalRegistry.elements.register("Input.Toggle",y)};b.prototype.setCardDataProvider=function(t){this._oCardDataProvider=t};b.prototype._setupMSCardContent=function(){var t=this.getConfiguration(),e,n=this._oCardDataProvider;if(!this.adaptiveCardInstance||!t){return}e=t.$data||t.data;if(!e&&!n){this._oCardTemplate=null;this._renderMSCardContent(t);this.fireEvent("_dataReady");return}if(t.$data){e={json:e}}this.setDataConfiguration(e)};b.prototype.onDataChanged=function(){var t=this.getBindingContext().getPath(),e=this.getModel().getProperty(t);this._oCardTemplate=this._setTemplating(this.getConfiguration(),e);this.invalidate()};b.prototype._renderMSCardContent=function(t){var e=this.getAggregation("_content").getItems()[0].$(),n=!!this.isLoading();this.setBusy(n);this.getAggregation("_content").toggleStyleClass("sapFCardContentHidden",n);if(this.adaptiveCardInstance&&t&&e.length){this.adaptiveCardInstance.parse(t);e.html(this.adaptiveCardInstance.render());this.fireEvent("_adaptiveCardElementsReady");if(this.adaptiveCardInstance.renderedElement){this.adaptiveCardInstance.renderedElement.tabIndex=-1}}};b.prototype._setTemplating=function(t,e){var n=new l.Template(t);return n.expand({$root:e})};b.prototype._loadWebcomponents=function(){if(this.getComponentsReady()){p.debug("WebComponents were already loaded");return Promise.resolve()}return new Promise(function(t,e){setTimeout(function(){if(window.customElements.get("ui5-button")){t();return}n({id:"webcomponents-bundle",attributes:{type:"module"},url:sap.ui.require.toUrl("sap/ui/integration/thirdparty/webcomponents/bundle.esm.js")}).then(t)})}).then(function(){this.setComponentsReady(true)}.bind(this))};b.prototype.setComponentsReady=function(t){this._bComponentsReady=t;return this};b.prototype.getComponentsReady=function(){return!!this._bComponentsReady};return b});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/AnalyticalContent", ["./AnalyticalContentRenderer","./BaseContent","sap/f/cards/loading/AnalyticalPlaceholder","sap/m/IllustratedMessageType","sap/ui/integration/library","sap/ui/integration/util/BindingResolver","sap/base/Log","sap/base/util/merge","sap/ui/core/Core"],function(t,e,a,i,n,r,o,s,l){"use strict";var p=n.CardActionArea;var c,d,u,g,h,v;var f={Top:"top",Bottom:"bottom",Left:"left",Right:"right"};var m={TopLeft:"topLeft",Center:"center"};var y={Left:"left",Center:"center",Right:"right"};var _={Line:"line",StackedColumn:"stacked_column",StackedBar:"stacked_bar",Donut:"donut"};var A={Chart:"Chart",Full:"Full"};var b=e.extend("sap.ui.integration.cards.AnalyticalContent",{metadata:{library:"sap.ui.integration"},renderer:t});b.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oPopover){this._oPopover.destroy()}};b.prototype.createLoadingPlaceholder=function(e){return new a({chartType:e.chartType,minHeight:t.getMinHeight(e)})};b.prototype.loadDependencies=function(t){return new Promise(function(t,e){l.loadLibrary("sap.viz",{async:true}).then(function(){sap.ui.require(["sap/viz/ui5/controls/VizFrame","sap/viz/ui5/controls/common/feeds/FeedItem","sap/viz/ui5/controls/Popover","sap/viz/ui5/data/FlattenedDataset","sap/viz/ui5/data/MeasureDefinition","sap/viz/ui5/data/DimensionDefinition"],function(e,a,i,n,r,o){c=e;d=a;g=i;u=n;h=r;v=o;t()},function(t){e(t)})}).catch(function(){e("Analytical content type is not available with this distribution.")})})};b.prototype.onDataChanged=function(){this._createChart();var t=this.getAggregation("_content");if(t){var e=t._getVizDataset(),a=e&&e._FlatTableD&&e._FlatTableD._data&&Array.isArray(e._FlatTableD._data)&&e._FlatTableD._data.length;if(a){this.hideNoDataMessage()}else{this.showNoDataMessage({illustrationType:i.NoEntries,title:this.getCardInstance().getTranslatedText("CARD_NO_ITEMS_ERROR_LISTS")})}}};b.prototype._createChart=function(){var t=this.getParsedConfiguration();if(!t.chartType){o.error('"sap.card".content.chartType is mandatory property.',null,"sap.ui.integration.widgets.Card");return}var e=r.resolveValue(t,this,"/");var a=new c({uiConfig:{applicationSet:"fiori"},height:"100%",width:"100%",vizType:_[e.chartType]||e.chartType,vizProperties:this._getVizProperties(e),dataset:this._getDataset(t,e),feeds:this._getFeeds(e)});this.setAggregation("_content",a);this._attachActions(t);if(e.popover&&e.popover.active){this._attachPopover()}};b.prototype._attachActions=function(t){var e={area:p.Content,actions:t.actions,control:this};if(t.actionableArea===A.Chart){e.eventName="selectData";e.actionControl=this.getAggregation("_content");this._oActions.setBindingPathResolver(function(t){var e=t.getParameter("data")[0].data._context_row_number;return this.getBindingContext().getPath()+"/"+e}.bind(this))}else{e.eventName="press"}this._oActions.attach(e)};b.prototype._attachPopover=function(){if(this._oPopover){this._oPopover.destroy()}this._oPopover=new g;this._oPopover.connect(this.getAggregation("_content").getVizUid())};b.prototype._getVizProperties=function(t){if(!t){return null}var e=t.title,a=t.legend,i=t.plotArea;var n={title:{style:{fontWeight:"normal"},layout:{respectPlotPosition:false}},legend:{},legendGroup:{layout:{}},plotArea:{window:{start:"firstDataPoint",end:"lastDataPoint"}},categoryAxis:{title:{}},valueAxis:{title:{}},interaction:{noninteractiveMode:true}};if(t.actions||t.popover){var r=t.actionableArea===A.Chart||t.popover&&t.popover.active;n.interaction.noninteractiveMode=!r}if(e){n.title.text=e.text;n.title.visible=e.visible;n.title.alignment=y[e.alignment];o.warning('"sap.card".content.title is deprecated. Use "sap.card".content.chartProperties instead',null,"sap.ui.integration.widgets.Card")}if(a){n.legend.visible=a.visible;n.legendGroup.layout.position=f[a.position];n.legendGroup.layout.alignment=m[a.alignment];o.warning('"sap.card".content.legend is deprecated. Use "sap.card".content.chartProperties instead',null,"sap.ui.integration.widgets.Card")}if(i){if(i.dataLabel){n.plotArea.dataLabel=i.dataLabel}if(i.categoryAxisText){n.categoryAxis.title.visible=i.categoryAxisText.visible}if(i.valueAxisText){n.valueAxis.title.visible=i.valueAxisText.visible}o.warning('"sap.card".content.plotArea is deprecated. Use "sap.card".content.chartProperties instead',null,"sap.ui.integration.widgets.Card")}s(n,t.chartProperties);return n};b.prototype._getDataset=function(t,e){var a,i;if(t.dimensions){i=t.dimensions.map(function(t,a){return new v({name:e.dimensions[a].name||e.dimensions[a].label,value:t.value,displayValue:t.displayValue,dataType:t.dataType})})}if(t.measures){a=t.measures.map(function(t,a){return new h({name:e.measures[a].name||e.measures[a].label,value:t.value})})}return new u({measures:a,dimensions:i,data:{path:this.getBindingContext().getPath()}})};b.prototype._getFeeds=function(t){var e=t.feeds;if(t.measureAxis||t.dimensionAxis){o.warning('"sap.card".content.measureAxis and "sap.card".content.dimensionAxis are deprecated. Use "sap.card".content.feeds instead',null,"sap.ui.integration.widgets.Card");e=[{uid:t.measureAxis,type:"Measure",values:t.measures.map(function(t){return t.label})},{uid:t.dimensionAxis,type:"Dimension",values:t.dimensions.map(function(t){return t.label})}]}return e.map(function(t){return new d(t)})};return b});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/AnalyticalContentRenderer", ["./BaseContentRenderer"],function(e){"use strict";var n=e.extend("sap.ui.integration.cards.AnalyticalContentRenderer",{apiVersion:2,MIN_ANALYTICAL_CONTENT_HEIGHT:"14rem"});n.getMinHeight=function(e,t){if(e.minHeight){return e.minHeight}return n.MIN_ANALYTICAL_CONTENT_HEIGHT};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/AnalyticsCloudContent", ["./AnalyticsCloudContentRenderer","./BaseContent","sap/ui/integration/library","sap/ui/core/HTML","sap/ui/integration/util/BindingResolver","sap/m/IllustratedMessageType","sap/base/Log"],function(t,i,r,e,h,a,s){"use strict";var n=r.CardActionArea;var o=i.extend("sap.ui.integration.cards.AnalyticsCloudContent",{metadata:{library:"sap.ui.integration"},renderer:t});o.prototype.init=function(){i.prototype.init.apply(this,arguments);var t=this.getId()+"-highchartContainer";this._oHighchartContainer=new e(t,{content:"<div id="+t+" class='sapFCardAnalyticsCloudContentHCC'></div>"});this.setAggregation("_content",this._oHighchartContainer)};o.prototype.exit=function(){i.prototype.exit.apply(this,arguments);if(this._oHighchart){this._oHighchart.destroy();this._oHighchart=null}if(this._oHighchartContainer){this._oHighchartContainer.destroy();this._oHighchartContainer=null}};o.prototype.loadDependencies=function(t){return this._loadHighcharts()};o.prototype.applyConfiguration=function(){var t=this.getParsedConfiguration();this.fireEvent("_actionContentReady");this._oActions.attach({area:n.Content,actions:t.actions,control:this})};o.prototype.onAfterRendering=function(){if(this.getAggregation("_blockingMessage")){return}this._createHighchart()};o.prototype._loadHighcharts=function(){var t=this.getCardInstance(),i=o.SAC_DESTINATION_KEY,r=t.resolveDestination(i);return r.then(function(t){return o.loadHighcharts(t)},function(t){return Promise.reject("Destination with key '"+i+"' is required for AnalyticsCloud card. It could not be resolved. Reason: '"+t+"'")})};o.prototype._createHighchart=function(){if(this._bIsBeingDestroyed){return}var t=this.getCardInstance(),i=this.getParsedConfiguration(),r=this.getBindingContext(),e,n;if(!t.isReady()){t.attachEventOnce("_ready",this._createHighchart,this);return}if(!window.Highcharts){this.handleError({illustrationType:a.ErrorScreen,title:t.getTranslatedText("CARD_DATA_LOAD_ERROR"),description:t.getTranslatedText("CARD_ERROR_HIGHCHARTS_DESCRIPTION")});return}if(!this._oHighchartContainer){s.error("Highcharts container is not created or destroyed.");return}if(r){e=r.getPath()}n=h.resolveValue(i.options,this,e);this._oHighchart=new window.Highcharts.Chart(this._oHighchartContainer.getId(),n)};o.SAC_DESTINATION_KEY="sac";o.HIGHCHART_MODULES={"highcharts/highstock":{amd:true,exports:"Highcharts"},"highcharts/highcharts-more":{deps:["highcharts/highstock"]},"highcharts/solid-gauge":{deps:["highcharts/highstock","highcharts/highcharts-more"]},"highcharts/histogram-bellcurve":{deps:["highcharts/highstock"]},"highcharts/no-data-to-display":{deps:["highcharts/highstock"]},"highcharts/wordcloud":{deps:["highcharts/highstock"]},"highcharts/variable-pie":{deps:["highcharts/highstock"]},"highcharts/heatmap":{deps:["highcharts/highstock"]},"highcharts/treemap":{deps:["highcharts/highstock"]},"highcharts/variwide":{deps:["highcharts/highstock"]},"highcharts/pattern-fill":{deps:["highcharts/highstock"]},"highcharts/highcharts-3d":{deps:["highcharts/highstock"]},"highcharts/grouped-categories":{deps:["highcharts/highstock"]}};o.loadHighcharts=function(t){var i=t.trim().replace(/\/$/,""),r=i,e=this._isHighchartsIncluded(r),h=this._isHighchartsIncludedByThirdParty();if(e){return this._pLoadModules}if(h){return Promise.resolve()}this._sIncludedFrom=r;this._pLoadModules=this._loadModules(r);return this._pLoadModules};o._isHighchartsIncluded=function(t){var i=this._sIncludedFrom;if(i&&i===t){return true}if(i&&i!==t){s.warning("Highcharts library is already included from '"+i+"'. The included version will be used and will not load from '"+t+"'","sap.ui.integration.widgets.Card#AnalyticsCloud");return true}return false};o._isHighchartsIncludedByThirdParty=function(){if(window.Highcharts){s.warning("Highcharts library is already included on the page. The included version will be used and will not load another one.","sap.ui.integration.widgets.Card#AnalyticsCloud");return true}return false};o._loadModules=function(t){var i=this.HIGHCHART_MODULES,r=Object.getOwnPropertyNames(i);sap.ui.loader.config({paths:{highcharts:t+"/highcharts"},async:true,shim:i});return this._require(r).catch(function(){return Promise.reject("There was a problem with loading of the Highcharts library files.")})};o._require=function(t){return new Promise(function(i,r){sap.ui.require(t,function(){i(arguments)},function(t){r(t)})})};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/AnalyticsCloudContentRenderer", ["./BaseContentRenderer"],function(e){"use strict";var n=e.extend("sap.ui.integration.cards.AnalyticsCloudContentRenderer",{apiVersion:2,MIN_ANALYTICS_CLOUD_CONTENT_HEIGHT:"14rem"});n.getMinHeight=function(e,t){if(e.minHeight){return e.minHeight}return n.MIN_ANALYTICS_CLOUD_CONTENT_HEIGHT};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/BaseContent", ["./BaseContentRenderer","sap/f/cards/loading/GenericPlaceholder","sap/m/MessageStrip","sap/m/VBox","sap/m/library","sap/m/IllustratedMessageType","sap/m/IllustratedMessageSize","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/InvisibleMessage","sap/ui/core/library","sap/ui/integration/controls/BlockingMessage","sap/ui/integration/model/ObservableModel","sap/ui/base/ManagedObjectObserver","sap/ui/integration/util/LoadingProvider","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/base/util/merge","sap/ui/integration/library"],function(t,e,i,n,a,o,r,s,d,g,h,p,c,l,u,f,y,v,_){"use strict";var C=h.InvisibleMessageMode;var m=_.CardDesign;var P=_.CardBlockingMessageType;var D=_.CardPreviewMode;var b=d.extend("sap.ui.integration.cards.BaseContent",{metadata:{library:"sap.ui.integration",properties:{design:{type:"sap.ui.integration.CardDesign",group:"Appearance",defaultValue:m.Solid},configuration:{type:"object"},noDataConfiguration:{type:"object"}},aggregations:{_content:{multiple:false,visibility:"hidden"},_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},_loadingPlaceholder:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},_messageContainer:{type:"sap.m.VBox",multiple:false,visibility:"hidden"},_blockingMessage:{type:"sap.ui.integration.controls.BlockingMessage",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}},events:{press:{},ready:{}}},renderer:t});b.prototype.init=function(){this._oAwaitedEvents=new Set;this._bReady=false;this._mObservers={};this.setAggregation("_loadingProvider",new u);this.awaitEvent("_dataReady");this.awaitEvent("_actionContentReady")};b.prototype.onBeforeRendering=function(){var t=this.getConfiguration(),e=this.getCardInstance(),i=this.getAggregation("_loadingPlaceholder");if(!i&&t){this.setAggregation("_loadingPlaceholder",this.createLoadingPlaceholder(t));i=this.getAggregation("_loadingPlaceholder")}if(i&&e){i.setRenderTooltip(e.getPreviewMode()!==D.Abstract);if(typeof this._getTable==="function"){i.setHasContent(this._getTable().getColumns().length>0)}}};b.prototype.ontap=function(t){if(!t.isMarked()){this.firePress({})}};b.prototype.exit=function(){this.hideLoadingPlaceholders();this._oAwaitedEvents=null;if(this._mObservers){Object.keys(this._mObservers).forEach(function(t){this._mObservers[t].disconnect();delete this._mObservers[t]},this)}this._oServiceManager=null;this._oDataProviderFactory=null;this._oIconFormatter=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null}if(this._oActions){this._oActions.destroy();this._oActions=null}this._sContentBindingPath=null};b.prototype.createLoadingPlaceholder=function(t){return new e};b.prototype.loadDependencies=function(t){return Promise.resolve()};b.prototype.applyConfiguration=function(){};b.prototype.setLoadDependenciesPromise=function(t){this._pLoadDependencies=t;this.awaitEvent("_loadDependencies");this._pLoadDependencies.then(function(){this.fireEvent("_loadDependencies")}.bind(this))};b.prototype.getLoadDependenciesPromise=function(){return this._pLoadDependencies};b.prototype.getActions=function(){return this._oActions};b.prototype.setActions=function(t){this._oActions=t};b.prototype.awaitEvent=function(t){if(this._oAwaitedEvents.has(t)){return}this._bReady=false;this._oAwaitedEvents.add(t);this.showLoadingPlaceholders(true);this.attachEventOnce(t,function(){this._oAwaitedEvents.delete(t);if(this._oAwaitedEvents.size===0){this._bReady=true;this.hideLoadingPlaceholders();this.fireReady()}}.bind(this))};b.prototype._forceCompleteAwaitedEvents=function(){this._oAwaitedEvents.forEach(function(t){this.fireEvent(t)}.bind(this))};b.prototype.getParsedConfiguration=function(){var t=v({},this.getConfiguration()),e=t.data;delete t.data;t=f.createBindingInfos(t,this.getCardInstance().getBindingNamespaces());if(e){t.data=e}return t};b.prototype.getStaticConfiguration=function(){return this.getConfiguration()};b.prototype.showMessage=function(t,e){var n=this._getMessageContainer();var a=new i({text:f.createBindingInfos(t,this.getCardInstance().getBindingNamespaces()),type:e,showCloseButton:true,showIcon:true,close:function(){this._getMessageContainer().destroy()}.bind(this)}).addStyleClass("sapFCardContentMessage");var o=this.getDomRef();n.destroyItems();n.addItem(a);if(o&&o.contains(document.activeElement)){g.getInstance().announce(t,C.Assertive)}else{g.getInstance().announce(t,C.Polite)}};b.prototype.hideMessage=function(){var t=this._getMessageContainer();t.destroyItems()};b.prototype.showBlockingMessage=function(t){this.destroyAggregation("_blockingMessage");this.setAggregation("_blockingMessage",p.create(t,this.getCardInstance()));this._forceCompleteAwaitedEvents()};b.prototype.hideBlockingMessage=function(){this.destroyAggregation("_blockingMessage")};b.prototype.getBlockingMessage=function(){var t=this.getAggregation("_blockingMessage");if(t){return{type:t.getType(),illustrationType:t.getIllustrationType(),illustrationSize:t.getIllustrationSize(),title:t.getTitle(),description:t.getDescription(),httpResponse:t.getHttpResponse()}}return null};b.prototype.showNoDataMessage=function(t){var e=this.getNoDataConfiguration()||{};e=y.resolveValue(e,this.getCardInstance());var i={type:P.NoData,illustrationType:o[e.type]||e.type||t.illustrationType,illustrationSize:r[e.size]||t.illustrationSize,title:e.title||t.title,description:e.description||t.description};this.showBlockingMessage(i)};b.prototype.hideNoDataMessage=function(){this.hideBlockingMessage()};b.prototype.setDataConfiguration=function(t){var e=this.getCardInstance(),i;if(!t){this._sContentBindingPath=null;this.fireEvent("_dataReady");return}this._sContentBindingPath=y.resolveValue(t.path||"/",this.getCardInstance());this.bindObject(this._sContentBindingPath);if(this._oDataProvider){this._oDataProvider.destroy()}this._oDataProvider=this._oDataProviderFactory.create(t,this._oServiceManager);if(t.name){i=e.getModel(t.name)}else if(this._oDataProvider){i=new c;i.setSizeLimit(e.getModelSizeLimit());this.setModel(i)}if(!i){this.fireEvent("_dataReady");return}i.attachEvent("change",function(){this.getLoadDependenciesPromise().then(function(t){if(t&&!this.isDestroyed()){this.onDataChanged();this.onDataRequestComplete()}}.bind(this))}.bind(this));if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.onDataRequested()}.bind(this));this._oDataProvider.attachDataChanged(function(t){var e=t.getParameter("data");this.getLoadDependenciesPromise().then(function(t){if(t&&!this.isDestroyed()){i.setData(e)}}.bind(this))}.bind(this));this._oDataProvider.attachError(function(t){this.handleError({requestErrorParams:t.getParameters(),requestSettings:this._oDataProvider.getSettings()});this.onDataRequestComplete()}.bind(this));this._oDataProvider.triggerDataUpdate()}else{this.fireEvent("_dataReady")}};b.prototype.onDataRequested=function(){this.awaitEvent("_dataReady")};b.prototype.onDataRequestComplete=function(){var t=this.getCardInstance();this.fireEvent("_dataReady");if(t){t._fireContentDataChange()}};b.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate()}};b.prototype.showLoadingPlaceholders=function(t){if(!t&&this._isDataProviderJson()){return}var e=this.getAggregation("_loadingProvider"),i=this.getCardInstance();e.setLoading(true);if(i){i.addActiveLoadingProvider(e)}};b.prototype.hideLoadingPlaceholders=function(){var t=this.getAggregation("_loadingProvider"),e=this.getCardInstance();if(!t.getLoading()){return}t.setLoading(false);if(e){e.removeActiveLoadingProvider(t)}};b.prototype.onDataChanged=function(){};b.prototype.onCardDataChanged=function(){this.getLoadDependenciesPromise().then(function(t){if(t&&!this.isDestroyed()){this.onDataChanged()}}.bind(this))};b.prototype._bindAggregationToControl=function(t,e,i){var n;if(!i){return}if(!i.path){i.path=this._sContentBindingPath}if(!i.path){n=this.getCardInstance().getBindingContext();i.path=n&&n.getPath()}if(!i.path){return}this._observeAggregation(t,e);e.bindAggregation(t,i)};b.prototype._observeAggregation=function(t,e){var i=this.getCardInstance().getModel("parameters"),n;if(this._mObservers[t]){return}n=new l(function(n){var a;if(n.name!==t){return}if(!(n.mutation==="insert"||n.mutation==="remove")){return}a=e.getMetadata().getAggregation(t).get(e);var o=a.length;a.forEach(function(t){if(t.isA("sap.m.GroupHeaderListItem")){o-=1}});i.setProperty("/visibleItems",o)});i.setProperty("/visibleItems",0);n.observe(e,{aggregations:[t]});this._mObservers[t]=n};b.prototype.isReady=function(){return this._bReady};b.prototype.handleError=function(t){this.fireEvent("_error",{errorInfo:t})};b.prototype.setServiceManager=function(t){this._oServiceManager=t;return this};b.prototype.setDataProviderFactory=function(t){this._oDataProviderFactory=t;return this};b.prototype.setIconFormatter=function(t){this._oIconFormatter=t;return this};b.prototype.isLoading=function(){if(!this.isReady()){return true}if(this._oDataProvider){return this.getAggregation("_loadingProvider").getLoading()}var t=this.getCardInstance();return t&&t.isLoading()};b.prototype.attachPress=function(){var t=Array.prototype.slice.apply(arguments);t.unshift("press");d.prototype.attachEvent.apply(this,t);this.invalidate();return this};b.prototype.detachPress=function(){var t=Array.prototype.slice.apply(arguments);t.unshift("press");d.prototype.detachEvent.apply(this,t);this.invalidate();return this};b.prototype.onActionSubmitStart=function(t){};b.prototype.onActionSubmitEnd=function(t,e){};b.prototype.validateControls=function(t,e){};b.prototype.getCardInstance=function(){return s.byId(this.getCard())};b.prototype.isSkeleton=function(){var t=this.getCardInstance();return t&&t.isSkeleton()};b.prototype.sliceData=function(t,e){};b.prototype.getDataLength=function(){return 0};b.prototype._getMessageContainer=function(){var t=this.getAggregation("_messageContainer");if(!t){t=new n({renderType:a.FlexRendertype.Bare,alignItems:a.FlexAlignItems.Center}).addStyleClass("sapFCardContentMessageContainer");this.setAggregation("_messageContainer",t)}return t};b.prototype._isDataProviderJson=function(){return this._oDataProvider&&this._oDataProvider.getSettings()&&this._oDataProvider.getSettings()["json"]};b.prototype.getHeaderTitleId=function(){var t=this.getCardInstance();if(!t){return undefined}return t.getId()+"-header-title-inner"};b.prototype.isInteractive=function(){return this.hasListeners("press")};return b});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/BaseContentRenderer", ["sap/ui/core/Renderer","sap/ui/integration/library"],function(e,t){"use strict";var n=t.CardPreviewMode;var a=e.extend("sap.ui.integration.cards.BaseContentRenderer",{apiVersion:2});a.DEFAULT_MIN_HEIGHT="5rem";a.render=function(e,t){var a="sapFCard",r=t.getMetadata().getName(),i=r.slice(r.lastIndexOf(".")+1),s=t.getCardInstance(),o=t.isLoading(),g=s&&s.getPreviewMode()===n.Abstract,d=t.getAggregation("_messageContainer"),c=t.getAggregation("_blockingMessage");a+=i;e.openStart("div",t).class(a).class("sapFCardBaseContent");if(t.isInteractive()){e.class("sapFCardSectionClickable")}if(s&&s.getHeight()==="auto"){var C=this.getMinHeight(t.getParsedConfiguration(),t,s);e.style("min-height",C)}if(o||g){e.class("sapFCardContentLoading")}e.openEnd();if(o||g){e.renderControl(t.getAggregation("_loadingPlaceholder"))}if(d){e.renderControl(d)}if(c){e.renderControl(c)}else{this.renderContent(e,t)}e.close("div")};a.renderContent=function(e,t){e.renderControl(t.getAggregation("_content"))};a.getMinHeight=function(e,t){return this.DEFAULT_MIN_HEIGHT};a.isCompact=function(e){var t=e,n=e.getParent();if(!e.getDomRef()&&n&&n.isA("sap.f.ICard")){t=n}return t.$().closest(".sapUiSizeCompact").hasClass("sapUiSizeCompact")};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/BaseListContent", ["sap/ui/integration/cards/BaseContent","sap/ui/integration/util/BindingResolver","sap/m/IllustratedMessageType","sap/ui/integration/library","sap/base/Log","sap/ui/model/Sorter"],function(t,e,i,n,r,s){"use strict";var a=t.extend("sap.ui.integration.cards.BaseListContent",{metadata:{library:"sap.ui.integration"},renderer:{apiVersion:2}});a.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oAwaitingPromise=null;this._fMinHeight=0;this._bIsFirstRendering=true};a.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._oAwaitingPromise=null};a.prototype.onAfterRendering=function(){if(!this._bIsFirstRendering){this._keepHeight()}this._bIsFirstRendering=false};a.prototype.onDataChanged=function(){if(this.hasData()){this.hideNoDataMessage()}else{this.showNoDataMessage({illustrationType:i.NoEntries,title:this.getCardInstance().getTranslatedText("CARD_NO_ITEMS_ERROR_LISTS")})}};a.prototype._keepHeight=function(){if(!this.getDomRef()){return}var t=this.getDomRef().getBoundingClientRect().height;if(t>this._fMinHeight){this._fMinHeight=t}if(this._fMinHeight){this.getDomRef().style.minHeight=this._fMinHeight+"px"}this._keepPlaceholderMinItems()};a.prototype._keepPlaceholderMinItems=function(){var t=this.getAggregation("_loadingPlaceholder"),e=!!this.getAggregation("_content"),i,n;if(!t||!t.getMinItems||!e){return}i=this.getItemsLength();n=Math.max(t.getMinItems(),i);t.setMinItems(n)};a.prototype.applyConfiguration=function(){var t=this.getConfiguration();if(!t){return}var e=this.getInnerList(),i=this.getCard()?this.getCardInstance().hasPaginator():false,n=t.maxItems;if(!Number.isNaN(parseInt(n))){n=parseInt(n)}if(e&&n&&!i){e.applySettings({growing:true,growingThreshold:n});e.addStyleClass("sapFCardMaxItems")}this._fMinHeight=0};a.prototype.getInnerList=function(){return null};a.prototype.getItemsLength=function(){return 0};a.prototype._checkHiddenNavigationItems=function(t){if(!t.actions){return}if(!this.getInnerList()){return}var i=this.getInnerList(),n=this.isA("sap.ui.integration.cards.TimelineContent")?i.getContent():i.getItems(),s=[],a=t.actions[0],o,g=0;if(!a||!a.service||a.type!=="Navigation"){return}if(a.service==="object"){o=a.service.name}else{o=a.service}n.forEach(function(t){var i=e.resolveValue(a.parameters,this,t.getBindingContext().getPath());s.push(this._oServiceManager.getService(o).then(function(t){if(!t.hidden){return false}return t.hidden({parameters:i})}).then(function(e){t.setVisible(!e);if(!e){g++}}).catch(function(t){r.error(t)}))}.bind(this));this.awaitEvent("_filterNavItemsReady");var h=this._oAwaitingPromise=Promise.all(s).then(function(){if(this._oAwaitingPromise===h){if(this.getModel("parameters")){this.getModel("parameters").setProperty("/visibleItems",g)}this.fireEvent("_filterNavItemsReady")}}.bind(this))};a.prototype.hasData=function(){var t=this.getInnerList(),e=t.getBinding(t.getMetadata().getDefaultAggregationName()),i=e.getModel(),n=e.getPath(),r=i.getProperty(n);if(r&&r.length){return true}return false};a.prototype._getGroupSorter=function(t){var i=false;if(t.order.dir&&t.order.dir==="DESC"){i=true}var n=new s(t.order.path,i,function(i){return e.resolveValue(t.title,i.getModel(),i.getPath())});return n};a.prototype.sliceData=function(t,e){this.getModel().sliceData(t,e);if(t!==0){this._keepHeight()}};a.prototype.getDataLength=function(){var t=this.getModel().getProperty(this.getInnerList().getBindingContext().getPath());if(Array.isArray(t)){return t.length}return Object.getOwnPropertyNames(t).length};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/CalendarContent", ["./CalendarContentRenderer","sap/ui/core/ResizeHandler","sap/ui/integration/library","sap/ui/integration/cards/BaseContent","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/f/cards/loading/CalendarPlaceholder","sap/f/CalendarAppointmentInCard","sap/f/CalendarInCard","sap/f/PlanningCalendarInCardLegend","sap/m/library","sap/m/Button","sap/m/FlexBox","sap/ui/core/format/DateFormat","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/DateTypeRange","sap/ui/core/date/UniversalDate","sap/ui/unified/CalendarLegendItem","sap/ui/core/Configuration","sap/ui/core/date/UI5Date","sap/ui/unified/DateRange","sap/ui/core/Core"],function(t,e,a,i,n,s,o,r,l,p,d,g,m,h,c,u,f,D,_,I,C,y,S,A,v,T,b){"use strict";var L=a.CardActionArea;var M=i.extend("sap.ui.integration.cards.CalendarContent",{renderer:t,metadata:{library:"sap.ui.integration",properties:{visibleAppointmentsCount:{type:"int",group:"Data",defaultValue:2},noAppointmentsText:{type:"string",group:"Misc",defaultValue:null}},aggregations:{appointments:{type:"sap.f.CalendarAppointmentInCard",multiple:true,singularName:"appointment"}}}});M.prototype.changeMonth=function(t){var e=this._oCalendar,a=this._oCalendar.getSelectedDates()[0],i,n;i=a.getStartDate().getFullYear();n=new Date(i,t,1);e.focusDate(n);this.invalidate();this.getCardInstance().scheduleFireStateChanged()};M.prototype.changeDate=function(t){var e=this.getActions(),a=new T,i=this._oCalendar;a.setStartDate(t);i.destroySelectedDates();i.addAggregation("selectedDates",a);this._oFocusedDate=i.getSelectedDates()[0]?i.getSelectedDates()[0]:null;this.changeMonth(t.getMonth());e.fireAction(this,"DateChange",{selectedDate:t})};M.prototype._createCardContent=function(){this._oCalendar=new l(this.getId()+"-navigation",{startDateChange:function(t){var e=t.getSource()._getFocusedDate().toLocalJSDate();this._handleStartDateChange(e)}.bind(this),select:function(t){var e=t.getSource().getSelectedDates()[0].getStartDate();this._setParameters(t,t.getParameter("startDate"));this._refreshVisibleAppointments(e);this.invalidate();this._handleSelect(e)}.bind(this)});this._oLegend=new p(this.getId()+"-legend",{columnWidth:"7.5rem",standardItems:[]});this._oCalendar.setLegend(this._oLegend);this._oContent=new m(this.getId()+"-wrapper",{items:[this._oCalendar,this._oLegend]});this.setAggregation("_content",this._oContent);this._oFormatAria=h.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' "+x.call(this).getTimePattern("medium")})};M.prototype.init=function(){this._aVisibleAppointments=[];i.prototype.init.apply(this,arguments);this._createCardContent()};M.prototype.exit=function(){if(this._sTwoColumnsResizeListener){e.deregister(this._sTwoColumnsResizeListener);this._sTwoColumnsResizeListener=undefined}i.prototype.exit.apply(this,arguments);if(this._oAppointmentTemplate){this._oAppointmentTemplate.destroy();this._oAppointmentTemplate=null}if(this._oSpecialDateTemplate){this._oSpecialDateTemplate.destroy();this._oSpecialDateTemplate=null}if(this._oCalendarLegendItemTemplate){this._oCalendarLegendItemTemplate.destroy();this._oCalendarLegendItemTemplate=null}if(this._oAppointmentLegendItemTemplate){this._oAppointmentLegendItemTemplate.destroy();this._oAppointmentLegendItemTemplate=null}if(this._bDataInitiallyLoaded){this._bDataInitiallyLoaded=null}};M.prototype.onDataChanged=function(){var t=this._oCalendar.getSelectedDates()[0]&&this._oCalendar.getSelectedDates()[0].getStartDate();if(!t){return}if(!this._bDataInitiallyLoaded){this._handleSelect(t);this._handleStartDateChange(t);this._bDataInitiallyLoaded=true}this._setParameters();this._refreshVisibleAppointments(t);this.invalidate()};M.prototype.onBeforeRendering=function(){i.prototype.onBeforeRendering.apply(this,arguments);var t=this._oCalendar.getSelectedDates().length?this._oCalendar.getSelectedDates()[0].getStartDate():this._oCalendar.getStartDate();this._setParameters();this._refreshVisibleAppointments(t);this.getModel("parameters").setProperty("/visibleItems",this._iVisibleItems);this.getModel("parameters").setProperty("/allItems",this._iAllItems)};M.prototype.onAfterRendering=function(){i.prototype.onAfterRendering.call(this,arguments);if(!this._sTwoColumnsResizeListener){this._sTwoColumnsResizeListener=e.register(this,this.resizeHandler);this.resizeHandler({control:this,target:this.getDomRef()})}};M.prototype.resizeHandler=function(t){t.control.toggleStyleClass("sapMPCInCardTwoColumns",t.target.getBoundingClientRect().width>576)};M.prototype.createLoadingPlaceholder=function(t){var e=this.getCardInstance(),a=e.getContentMinItems(t);return new o({minItems:a!==null?a:2,maxLegendItems:t.maxLegendItems?parseInt(t.maxLegendItems):2,item:t.item?t.item.template:{},legendItem:t.legendItem?t.legendItem.template:{}})};M.prototype.applyConfiguration=function(){var t=this.getParsedConfiguration();this.fireEvent("_actionContentReady");if(!t){return}if(t.item){this._addItem(t.item)}if(t.specialDate){this._addSpecialDate(t.specialDate)}if(t.legendItem){this._addLegendItem(t.legendItem)}if(t.date){this._addDate(t.date)}if(t.maxItems){this._addMaxItems(t.maxItems)}if(t.maxLegendItems){this._addMaxLegendItems(t.maxLegendItems)}if(t.noItemsText){this._addNoItemsText(t.noItemsText)}if(t.moreItems&&t.moreItems.actions){this._oActions.attach({area:L.Content,actions:t.moreItems.actions,control:this._getMoreButton()})}};M.prototype._getStaticConfigurationLegendItems=function(t,e,a,i){var o=[];t.forEach(function(t,e){var r=Object.keys(a.legendItem.template),l={};r.forEach(function(t){var o=n.prependRelativePaths(a.legendItem.template[t],i.getBindingPath("items")+"/"+e);l[t]=s.resolveValue(o,this)}.bind(this));o.push(l)}.bind(this));e.forEach(function(t,e){var r=Object.keys(a.legendItem.template),l={};r.forEach(function(t){var o=n.prependRelativePaths(a.legendItem.template[t],i.getBindingPath("items")+"/"+e);l[t]=s.resolveValue(o,this)}.bind(this));o.push(l)}.bind(this));return o};M.prototype._getStaticConfigurationSpecialDates=function(t,e){var a=[];t.forEach(function(t,i){var o=this._oCalendar,r=t.getStartDate(),l=t.getEndDate(),p=o._getMonthPicker().getMonth()?o._getMonthPicker().getMonth():o._getFocusedDate().getMonth(),d=Number(o._getYearString()),g=r.getMonth()===p,m=l?l.getMonth()===p:false,h=r.getFullYear()===d,c=t.getEndDate()?t.getEndDate().getFullYear()===d:h,u=(g||m)&&(h||c),f,D;if(u){f=Object.keys(e.specialDate.template);var _={};f.forEach(function(t){_[t]=n.prependRelativePaths(e.specialDate.template[t],this._oCalendar.getBindingPath("specialDates")+"/"+i)}.bind(this));D=s.resolveValue(_,this);D.startDate=new Date(D.startDate).toISOString();if(D.endDate){D.endDate=new Date(D.endDate).toISOString()}a.push(D)}}.bind(this));return a};M.prototype._getStaticConfigurationAppointments=function(t,e,a,i){var o=[],r=false;t.forEach(function(t,l){var p=t.getStartDate(),d=t.getEndDate(),g,m,h=p>=e&&p<=a,c=d>=e&&d<=a,u=p<=e&&d>a,f=h||c||u;if(f){g=Object.keys(i.item.template);m={};g.forEach(function(t){var e=n.prependRelativePaths(i.item.template[t],this.getBindingPath("appointments")+"/"+l);m[t]=s.resolveValue(e,this)}.bind(this));m.startDate=new Date(m.startDate).toISOString();if(m.endDate){m.endDate=new Date(m.endDate).toISOString()}o.push(m);if(o.length>i.maxItems){r=true}}}.bind(this));return{resolvedItems:o,moreItems:r}};M.prototype.getStaticConfiguration=function(){var t=this.getParsedConfiguration(),e=this.getAppointments(),a=this._oCalendar.getSpecialDates(),i=this._oCalendar.getLegend(),n=b.byId(i),o=n.getItems(),r=n.getAppointmentItems(),l=this._oCalendar.getSelectedDates()[0]?this._oCalendar.getSelectedDates()[0].getStartDate():null,p=864e5,d=this._oCalendar.getSelectedDates()[0]?this._oCalendar.getSelectedDates()[0]:null,g=d.getStartDate?d.getStartDate().getTime()+p:null,m=d.getStartDate(),h=t.maxItems,c=t.maxLegendItems,u=t.noItemsText,f=false,D={},_,I,C,y,S;S=l?l.toISOString():null;S=S?S:t.date;_=this._getStaticConfigurationAppointments(e,m,g,t);y=_.resolvedItems;f=_.moreItems;I=this._getStaticConfigurationSpecialDates(a,t);C=this._getStaticConfigurationLegendItems(o,r,t,n);D.items=y;D.specialDates=I;D.legendItems=C;D.date=S;D.maxItems=h;D.maxLegendItems=c;D.noItemsText=u;if(f){D.moreItems=s.resolveValue(t.moreItems,this)}return D};M.prototype._setParameters=function(t,e){var a,i,n,s,o;if(e){a=e}else if(this._oCalendar.getSelectedDates().length){a=this._oCalendar.getSelectedDates()[0].getStartDate()}else{a=this._oCalendar.getStartDate()}i=v.getInstance(a.getFullYear(),a.getMonth(),a.getDate()).getTime();n=v.getInstance(a.getFullYear(),a.getMonth(),a.getDate()+1).getTime();s=this.getAppointments();if(s){o=s.filter(function(t){var e=t.getStartDate().getTime(),a=t.getEndDate().getTime();if(e>=i&&e<n||a>i&&a<=n||e<i&&a>n){return t}})}else{o=[]}this._iAllItems=o.length;this._iMaxItems=this.getVisibleAppointmentsCount();this._iVisibleItems=Math.min(this._iMaxItems,this._iAllItems);if(this.getModel("parameters")){this.getModel("parameters").setProperty("/visibleItems",this._iVisibleItems);this.getModel("parameters").setProperty("/allItems",this._iAllItems)}};M.prototype._refreshVisibleAppointments=function(t){this._aVisibleAppointments=this._calculateVisibleAppointments(this.getAppointments(),t)};M.prototype._calculateVisibleAppointments=function(t,e){var a=this._isAppointmentInSelectedDate(e);var i=function(t,a){var i=t.getEndDate(),n=v.getInstance();if(e.getDate()===n.getDate()&&e.getMonth()===n.getMonth()&&e.getFullYear()===n.getFullYear()){return this._iAllItems-a<this._iVisibleItems||i.getTime()>n.getTime()}return true};var n=t.filter(a,this).sort(this._sortByStartHourCB).filter(i,this).slice(0,this._iVisibleItems);return n};M.prototype._sortByStartHourCB=function(t,e){return t.getStartDate().getTime()-e.getStartDate().getTime()||e.getEndDate().getTime()-t.getEndDate().getTime()};M.prototype._isAppointmentInSelectedDate=function(t){return function(e){var a=e.getStartDate().getTime(),i=e.getEndDate().getTime(),n=t.getTime(),s=y.getInstance(v.getInstance(t.getTime())),o,r,l,p;s.setDate(s.getDate()+1);o=s.getTime()-1e3;r=a<n&&i>o;l=a>=n&&a<o;p=i>n&&i<=o;return r||l||p}};M.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments};M.prototype.formatDate=function(t){var e=h.getDateTimeInstance({pattern:"yyyy-MM-dd'T'HH:mm:ss.SSSXXX"}).parse(t);if(!e){e=h.getInstance({pattern:"yyyy-MM-dd"}).parse(t)}return e};M.prototype._addItem=function(t){var e={title:t.template.title,text:t.template.text,type:t.template.type},a;if(t.template.startDate){e.startDate=n.formattedProperty(t.template.startDate,this.formatDate)}if(t.template.endDate){e.endDate=n.formattedProperty(t.template.endDate,this.formatDate)}if(t.template.icon&&t.template.icon.src){e.icon=n.formattedProperty(t.template.icon.src,function(t){return this._oIconFormatter.formatSrc(t)}.bind(this))}this._oAppointmentTemplate=new r(e);var i=this.getActions();i.attach({area:L.ContentItem,actions:t.template.actions,control:this,actionControl:this._oAppointmentTemplate,enabledPropertyName:"clickable",enabledPropertyValue:true,disabledPropertyValue:false});a={path:t.path,template:this._oAppointmentTemplate};this._bindAggregationToControl("appointments",this,a)};M.prototype._addSpecialDate=function(t){var e=t.template,a;if(e.startDate){e.startDate=n.formattedProperty(e.startDate,this.formatDate)}if(e.endDate){e.endDate=n.formattedProperty(e.endDate,this.formatDate)}this._oSpecialDateTemplate=new C(e);a={path:t.path,template:this._oSpecialDateTemplate};this._bindAggregationToControl("specialDates",this._oCalendar,a)};M.prototype._addLegendItem=function(t){var e={text:t.template.text,type:t.template.type},a={text:t.template.text,type:t.template.type},i,n;this._oCalendarLegendItemTemplate=new S(e);i={path:t.path,template:this._oCalendarLegendItemTemplate,filters:new f({path:"category",operator:D.Contains,value1:"calendar"})};this._bindAggregationToControl("items",this._oLegend,i);this._oAppointmentLegendItemTemplate=new S(a);n={path:t.path,template:this._oAppointmentLegendItemTemplate,filters:new f({path:"category",operator:D.Contains,value1:"appointment"})};this._bindAggregationToControl("appointmentItems",this._oLegend,n)};M.prototype._addDate=function(t){if(n.isBindingInfo(t)){if(!t){return}var e=new C;e.bindProperty("startDate",n.formattedProperty(t,this.formatDate));this._oCalendar.addSelectedDate(e)}else{this._oCalendar.addSelectedDate(new C({startDate:this.formatDate(t)}));var a=this.formatDate(t);this._handleSelect(a);this._handleStartDateChange(a);this._bDataInitiallyLoaded=true}};M.prototype._addMaxItems=function(t){if(n.isBindingInfo(t)){t&&this.bindProperty("visibleAppointmentsCount",t)}else{this.setVisibleAppointmentsCount(t)}};M.prototype._addMaxLegendItems=function(t){if(n.isBindingInfo(t)){t&&this._oLegend.bindProperty("visibleLegendItemsCount",t)}else{this._oLegend.setVisibleLegendItemsCount(t)}};M.prototype._addNoItemsText=function(t){if(n.isBindingInfo(t)){t&&this.bindProperty("noAppointmentsText",t)}else{this.setNoAppointmentsText(t)}};M.prototype._getMoreButton=function(){if(!this._oMoreAppsButton){this._oMoreAppsButton=new g({text:"More"})}return this._oMoreAppsButton};M.prototype._bNeedForMoreButton=function(){return this._iAllItems>this.getVisibleAppointmentsCount()};M.prototype._getCurrentAppointment=function(){var t=this._getVisibleAppointments(),e=v.getInstance(),a,i,n,s,o=this._oCalendar.getSelectedDates().length?this._oCalendar.getSelectedDates()[0].getStartDate():this._oCalendar.getStartDate();if(o.getDate()===e.getDate()&&o.getMonth()===e.getMonth()&&o.getFullYear()===e.getFullYear()){for(s=t.length-1;s>=0;s--){a=t[s];i=a.getStartDate().getTime();n=a.getEndDate().getTime();if(e.getTime()>i&&e.getTime()<n){return a}}}};M.prototype._handleStartDateChange=function(t){var e=this.getActions(),a=_.fromLocalJSDate(t),i=I._getFirstDateOfWeek(I._getFirstDateOfMonth(a)),n=new _(t.getFullYear(),t.getMonth()+1,1),s;n.setDate(n.getDate()-1);s=I._getFirstDateOfWeek(n);s.setDate(s.getDate()+6);e.fireAction(this,"MonthChange",{firstDate:i.toLocalJSDate(),lastDate:s.toLocalJSDate()})};M.prototype._handleSelect=function(t){var e=this.getActions();e.fireAction(this,"DateChange",{selectedDate:t})};function x(){if(!this._oLocaleData){var t=P.call(this);var e=new c(t);this._oLocaleData=u.getInstance(e)}return this._oLocaleData}function P(){if(!this._sLocale){this._sLocale=A.getFormatSettings().getFormatLocale().toString()}return this._sLocale}return M});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/CalendarContentRenderer", ["./BaseContentRenderer","sap/ui/core/IconPool","sap/ui/core/InvisibleText","sap/ui/unified/library","sap/ui/unified/CalendarLegendRenderer"],function(e,t,a,n,r){"use strict";var i=n.CalendarDayType;var p=e.extend("sap.ui.integration.cards.CalendarContentRenderer",{apiVersion:2});p.renderContent=function(e,t){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.integration"),n=t.getId();e.openStart("div",n+"card-group");e.attr("role","group");e.attr("aria-label",a.getText("CARDS_CALENDAR"));e.class("sapFCalCard");e.openEnd();e.openStart("div",n+"card-layout");e.class("sapFCalCardLayout");e.openEnd();e.openStart("div",n+"left-side");e.class("sapFCalCardLeftSide");e.openEnd();e.renderControl(t._oCalendar);e.openStart("div",n+"card-legend");e.attr("aria-label",a.getText("CARDS_CALENDAR_LEGEND"));e.openEnd();e.renderControl(t._oLegend);e.close("div");e.openStart("div","card-line-separator");e.class("sapFCalCardLineSeparator");e.openEnd();e.close("div");e.close("div");e.openStart("div",n+"right-side");e.class("sapFCalCardRightSide");e.openEnd();p.renderAppointments(e,t);if(t._bNeedForMoreButton()){e.renderControl(t._getMoreButton())}e.close("div");e.close("div");e.close("div")};p.renderAppointments=function(e,t){var a=t._getVisibleAppointments(),n=t._getCurrentAppointment(),r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.integration");e.openStart("div",t.getId()+"appointments-list");e.attr("role","list");e.attr("aria-label",r.getText("CARDS_CALENDAR_APPOINTMENTS"));e.class("sapFCalCardAppList");e.openEnd();if(!a.length){e.openStart("div");e.class("sapFCalCardNoItemsText");e.openEnd();e.text(t.getNoAppointmentsText());e.close("div")}a.forEach(function(a){p.renderAppointment(e,t,a,n==a)});e.close("div")};p.renderAppointment=function(e,t,a,n){var r=t._oCalendar.getSelectedDates()[0].getStartDate();e.openStart("div");e.attr("role","listitem");e.class("sapUiCalendarAppContainer");if(n){e.class("sapUiCalendarAppCurrent")}e.openEnd();e.openStart("div");e.class("sapUiCalendarAppContainerLeft");e.openEnd();e.openStart("div");e.class("sapUiCalendarAppStart");e.openEnd();e.text(a._getDateRangeIntersectionText(r).start);e.close("div");e.openStart("div");e.class("sapUiCalendarAppEnd");e.openEnd();e.text(a._getDateRangeIntersectionText(r).end);e.close("div");e.close("div");e.openStart("div");e.class("sapUiCalendarAppContainerRight");e.openEnd();this._renderAppointment(e,t,a,r);e.close("div");p.renderAdditionalAriaLabel(e,t,a);e.close("div")};p._renderAppointment=function(e,t,a,n){var r=a.getId();var l=a.getTitle();var o=a.getText();var d=a.getType();var s=a.getIcon();var c=!l||!o;e.openStart("div",a);e.class("sapUiCalendarApp");if(a.getClickable()){e.attr("tabindex","0")}else{e.class("sapUiCalendarAppDisabled")}e.accessibilityState(a,p.getAccProps(a));if(d&&d!=i.None){e.class("sapUiCalendarApp"+d)}if(c){e.class("sapUiCalendarAppOneLine")}e.openEnd();e.openStart("div");e.class("sapUiCalendarAppCont");e.openEnd();if(s){var g=["sapUiCalendarAppIcon"];var v={};v["id"]=r+"-Icon";v["title"]=null;v["role"]="img";e.icon(s,g,v)}e.openStart("div");e.class("sapUiCalendarAppTitleWrapper");e.openEnd();if(l){e.openStart("span",r+"-Title");e.class("sapUiCalendarAppTitle");e.openEnd();e.text(l);e.close("span")}if(o){e.openStart("span",r+"-Text");e.class("sapUiCalendarAppText");e.openEnd();e.text(o);e.close("span")}e.close("div");e.close("div");e.close("div")};p.renderAdditionalAriaLabel=function(e,t,a){var n=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),r=t._oFormatAria,p=a.getType(),l=t._oLegend?t._oLegend.getAppointmentItems():[];var o=n.getText("CALENDAR_START_TIME")+": "+r.format(a.getStartDate());o=o+"; "+n.getText("CALENDAR_END_TIME")+": "+r.format(a.getEndDate());if(p&&p!=i.None){o=o+"; "+this.getAriaTextForType(p,l)}e.openStart("span",a.getId()+"-Descr");e.class("sapUiInvisibleText");e.openEnd();e.text(o);e.close("span")};p.getAriaTextForType=function(e,t){var a,n,i,p;if(t&&t.length){for(var p=0;p<t.length;p++){i=t[p];if(i.getType()===e){a=i.getText();break}}}if(!a){n=r.getTypeAriaText(e);if(n){a=n.getText()}}return a};p.getAccProps=function(e){var t=e.getId();var n={labelledby:{value:a.getStaticId("sap.ui.unified","APPOINTMENT")+" "+t+"-Descr",append:true},selected:null};if(e.getTitle()){n["labelledby"].value=n["labelledby"].value+" "+t+"-Title"}if(e.getText()){n["labelledby"].value=n["labelledby"].value+" "+t+"-Text"}if(e.getSelected()){n["labelledby"].value=n["labelledby"].value+" "+a.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED")}return n};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/ComponentContent", ["./BaseContent","./ComponentContentRenderer","sap/ui/integration/library","sap/m/IllustratedMessageType","sap/ui/core/ComponentContainer","sap/ui/core/Component"],function(t,e,n,a,i,r){"use strict";var o=n.CardPreviewMode;var s=t.extend("sap.ui.integration.cards.ComponentContent",{metadata:{library:"sap.ui.integration"},renderer:e});r._fnOnInstanceCreated=function(t){var e=t.getComponentData();if(e&&e["__sapUiIntegration_card"]&&t.onCardReady){t.onCardReady(e["__sapUiIntegration_card"])}};s.prototype.applyConfiguration=function(){var t=this.getParsedConfiguration();if(!t){return}if(this.getCardInstance().getPreviewMode()===o.Abstract){this.fireEvent("_actionContentReady");return}var e=new i({manifest:t.componentManifest,async:true,settings:{componentData:{__sapUiIntegration_card:this.getCardInstance()}},componentCreated:function(){this.fireEvent("_actionContentReady");this.fireEvent("_updated")}.bind(this),componentFailed:function(){var t=this.getCardInstance();this.fireEvent("_actionContentReady");this.handleError({illustrationType:a.ErrorScreen,title:t.getTranslatedText("CARD_DATA_LOAD_ERROR"),description:"Card content failed to create component"})}.bind(this)});this.setAggregation("_content",e)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/ComponentContentRenderer", ["./BaseContentRenderer"],function(e){"use strict";var n=e.extend("sap.ui.integration.cards.ComponentContentRenderer",{apiVersion:2});n.getMinHeight=function(n,t){if(n.minHeight){return n.minHeight}return e.getMinHeight.apply(this,arguments)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/Footer", ["sap/ui/core/Control","sap/ui/core/Core","sap/base/util/merge","sap/ui/integration/controls/ActionsStrip","sap/ui/integration/controls/Paginator","sap/ui/integration/util/BindingHelper"],function(t,i,n,e,r,a){"use strict";var o=t.extend("sap.ui.integration.cards.Footer",{metadata:{properties:{configuration:{type:"object"}},aggregations:{actionsStrip:{type:"sap.ui.integration.controls.ActionsStrip",multiple:false},paginator:{type:"sap.ui.integration.controls.Paginator",multiple:false}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:{apiVersion:2,render:function(t,i){var n=i.getActionsStrip(),e=i.getPaginator();t.openStart("div",i).class("sapFCardFooter");if(n){t.class("sapFCardFooterWithActionsStrip")}if(i.getCardInstance().isLoading()&&i._hasBinding()){t.class("sapFCardFooterLoading")}t.openEnd();if(e){t.renderControl(e)}if(n){t.renderControl(n)}t.close("div")}}});o.prototype._hasBinding=function(){var t=a.createBindingInfos(this.getConfiguration(),this.getCardInstance().getBindingNamespaces());return(t.actionsStrip||[]).some(function(t){for(var i in t){if(a.isBindingInfo(t[i])){return true}}return false})};o.prototype.getCardInstance=function(){return i.byId(this.getCard())};o.prototype.setEnabled=function(t){var i=this.getActionsStrip();if(!i){return}if(t){i.enableItems()}else{i.disableItems()}};o.prototype.getStaticConfiguration=function(){var t=n({},this.getConfiguration()),i=this.getPaginator();if(i){t.paginator=i.getStaticConfiguration()}return t};o.create=function(t,i){return new o({configuration:a.createBindingInfos(i,t.getBindingNamespaces()),card:t,actionsStrip:e.create(t,i.actionsStrip,true),paginator:r.create(t,i.paginator),visible:i.visible})};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/Header", ["sap/ui/core/Core","sap/ui/model/json/JSONModel","sap/base/util/merge","sap/f/cards/Header","sap/f/cards/HeaderRenderer","sap/m/library","sap/m/Text","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/LoadingProvider","sap/ui/integration/util/Utils","sap/ui/integration/formatters/IconFormatter"],function(t,i,e,a,r,o,n,s,d,c,h,u){"use strict";var l=o.AvatarColor;var g=a.extend("sap.ui.integration.cards.Header",{constructor:function(t,i,e,r){i=i||{};var o={title:i.title,titleMaxLines:i.titleMaxLines,subtitle:i.subTitle,subtitleMaxLines:i.subTitleMaxLines,dataTimestamp:i.dataTimestamp,visible:i.visible};if(i.status&&i.status.text&&!i.status.text.format){o.statusText=i.status.text;o.statusVisible=i.status.visible}if(i.icon){var d=i.icon.initials||i.icon.text;var c=i.icon.backgroundColor||(d?l.Accent6:l.Transparent);o.iconSrc=i.icon.src;o.iconDisplayShape=i.icon.shape;o.iconInitials=d;o.iconAlt=i.icon.alt;o.iconBackgroundColor=c;o.iconVisible=i.icon.visible}if(o.iconSrc){o.iconSrc=s.formattedProperty(o.iconSrc,function(t){return r.formatSrc(t)})}if(i.banner){o.bannerLines=i.banner.map(function(t){var i=new n({text:t.text,visible:t.visible});if(t.diminished){i.addStyleClass("sapFCardHeaderBannerLineDiminished")}return i})}o.toolbar=e;a.call(this,t,o);this._oConfiguration=i;this._oIconFormatter=r},metadata:{library:"sap.ui.integration",properties:{interactive:{type:"boolean",defaultValue:false}},aggregations:{_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:r});g.prototype.init=function(){a.prototype.init.call(this);this._bReady=false;this.setAggregation("_loadingProvider",new c);this._aReadyPromises=[];this._awaitEvent("_dataReady");this._awaitEvent("_actionHeaderReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready")}.bind(this))};g.prototype.exit=function(){a.prototype.exit.call(this);this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null}if(this._oActions){this._oActions.destroy();this._oActions=null}};g.prototype.shouldShowIcon=function(){return this.getIconVisible()&&this.getIconSrc()!==u.SRC_FOR_HIDDEN_ICON};g.prototype.isInteractive=function(){return this.getInteractive()};g.prototype.isReady=function(){return this._bReady};g.prototype.isLoading=function(){if(!this.isReady()){return true}if(this._oDataProvider){return this.getAggregation("_loadingProvider").getLoading()}var t=this.getCardInstance();return t&&t.isLoading()};g.prototype._handleError=function(t){this.fireEvent("_error",{errorInfo:t})};g.prototype._awaitEvent=function(t){this._aReadyPromises.push(new Promise(function(i){this.attachEventOnce(t,function(){i()})}.bind(this)))};g.prototype.setServiceManager=function(t){this._oServiceManager=t;return this};g.prototype.setDataProviderFactory=function(t){this._oDataProviderFactory=t;return this};g.prototype.getStaticConfiguration=function(){var t=e({},this._oConfiguration),i=h.getNestedPropertyValue(t,"/status/text/format"),a;if(i){a=h.getStatusTextBindingInfo(i)}if(a){t.status.text=a}if(t.icon&&t.icon.src){t.icon.src=this._oIconFormatter.formatSrc(d.resolveValue(t.icon.src,this))}return t};g.prototype._setDataConfiguration=function(t){var e=this.getCardInstance(),a="/",r;if(t&&t.path){a=d.resolveValue(t.path,this.getCardInstance())}this.bindObject(a);if(this._oDataProvider){this._oDataProvider.destroy()}this._oDataProvider=this._oDataProviderFactory.create(t,this._oServiceManager);if(t&&t.name){r=e.getModel(t.name)}else if(this._oDataProvider){r=new i;this.setModel(r)}if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.showLoadingPlaceholders()}.bind(this));this._oDataProvider.attachDataChanged(function(t){r.setData(t.getParameter("data"));this.onDataRequestComplete()}.bind(this));this._oDataProvider.attachError(function(t){this._handleError({requestErrorParams:t.getParameters(),requestSettings:this._oDataProvider.getSettings()});this.onDataRequestComplete()}.bind(this));this._oDataProvider.triggerDataUpdate()}else{this.fireEvent("_dataReady")}};g.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate()}};g.prototype.showLoadingPlaceholders=function(){if(!this._isDataProviderJson()){this.getAggregation("_loadingProvider").setLoading(true)}};g.prototype.hideLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(false)};g.prototype.onDataRequestComplete=function(){var t=this.getCardInstance();if(t){t._fireDataChange()}this.fireEvent("_dataReady");this.hideLoadingPlaceholders()};g.prototype.getCardInstance=function(){return t.byId(this.getCard())};g.prototype._isDataProviderJson=function(){return this._oDataProvider&&this._oDataProvider.getSettings()&&this._oDataProvider.getSettings()["json"]};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/ListContent", ["./BaseListContent","./ListContentRenderer","sap/ui/util/openWindow","sap/m/library","sap/m/List","sap/f/cards/loading/ListPlaceholder","sap/ui/integration/controls/ObjectStatus","sap/ui/integration/library","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/controls/Microchart","sap/ui/integration/controls/MicrochartLegend","sap/ui/integration/controls/ListContentItem","sap/ui/integration/controls/ActionsStrip","sap/ui/integration/cards/list/MicrochartsResizeHelper"],function(t,i,e,o,n,s,r,a,c,h,l,p,g,u,d){"use strict";var f=o.AvatarColor;var m=o.ListType;var I=o.ListSeparators;var y=a.CardActionArea;var v=o.EmptyIndicatorMode;var _="_legendColorsLoad";var b=t.extend("sap.ui.integration.cards.ListContent",{metadata:{library:"sap.ui.integration",aggregations:{_legend:{multiple:false,visibility:"hidden"}}},renderer:i});b.prototype.onBeforeRendering=function(){t.prototype.onBeforeRendering.apply(this,arguments);this._getList().setBackgroundDesign(this.getDesign())};b.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null}if(this._oMicrochartsResizeHelper){this._oMicrochartsResizeHelper.destroy();this._oMicrochartsResizeHelper=null}};b.prototype.createLoadingPlaceholder=function(t){var e=this.getCardInstance(),o=e.getContentMinItems(t);const n=h.resolveValue(t.item,this);const r=g.getPlaceholderInfo(n);return new s({minItems:o!==null?o:2,hasIcon:r.hasIcon,attributesLength:r.attributesLength,hasChart:r.hasChart,hasActionsStrip:r.hasActionsStrip,hasDescription:r.hasDescription,itemHeight:i.getItemMinHeight(t,this)+"rem"})};b.prototype.loadDependencies=function(t){if(!this.isSkeleton()&&t.get("/sap.card/content/item/chart")){return l.loadDependencies()}return Promise.resolve()};b.prototype.applyConfiguration=function(){t.prototype.applyConfiguration.apply(this,arguments);var i=this.getParsedConfiguration();if(!i){return}if(i.items){this._setStaticItems(i.items);return}if(i.item){this._setItem(i)}};b.prototype.getStaticConfiguration=function(){var t=this.getInnerList().getItems(),i=this.getParsedConfiguration(),e=t[0]&&t[0].isA("sap.m.GroupHeaderListItem"),o=[],n=[],s;t.forEach(function(t){if(t.isA("sap.m.GroupHeaderListItem")){if(s){n.push(s)}o=[];s={title:t.getTitle(),items:o}}else{var e=h.resolveValue(i.item,this,t.getBindingContext().getPath());if(e.icon&&e.icon.src){e.icon.src=this._oIconFormatter.formatSrc(e.icon.src)}o.push(e)}}.bind(this));if(s){n.push(s)}var r={};if(e){r.groups=n}else{r.groups=[{items:o}]}return r};b.prototype.getItemsLength=function(){return this._getList().getItems().filter(t=>!t.isA("sap.m.GroupHeaderListItem")).length};b.prototype.onDataChanged=function(){t.prototype.onDataChanged.apply(this,arguments);this._checkHiddenNavigationItems(this.getParsedConfiguration().item)};b.prototype._getList=function(){if(this._bIsBeingDestroyed){return null}if(!this._oList){this._oList=new n({id:this.getId()+"-list",growing:false,showNoData:false,ariaLabelledBy:this.getHeaderTitleId(),updateFinished:function(){if(this._iVisibleItems){var t=this._oList.getItems();for(var i=this._iVisibleItems+1;i<t.length;i++){t[i].setVisible(false)}}}.bind(this)});this._oList.onItemFocusIn=function(t,i){this._oList._handleStickyItemFocus(t.getDomRef())}.bind(this);this._oList.addEventDelegate({onfocusin:function(t){if(!(t.srcControl instanceof g)){return}var i=t.target.getBoundingClientRect().bottom;var e=this.getDomRef().getBoundingClientRect().bottom;var o=Math.abs(i-e);var n=10;if(o<n){t.srcControl.addStyleClass("sapUiIntLCIRoundedCorners")}}},this);this.setAggregation("_content",this._oList)}return this._oList};b.prototype._setItem=function(t){var i=t.item,e=this._getList(),o=this.isSkeleton(),n,s={title:i.title&&(i.title.value||i.title),description:i.description&&(i.description.value||i.description),descriptionVisible:i.description?i.description.visible:undefined,highlight:i.highlight,highlightText:i.highlightText,info:i.info&&i.info.value,infoState:i.info&&i.info.state,infoVisible:i.info&&i.info.visible,showInfoStateIcon:i.info&&i.info.showStateIcon,customInfoStatusIcon:i.info&&i.info.customStateIcon,attributes:[]};if(i.icon){s.icon=c.formattedProperty(i.icon.src,function(t){return this._oIconFormatter.formatSrc(t)}.bind(this));s.iconAlt=i.icon.alt;s.iconDisplayShape=i.icon.shape;s.iconInitials=i.icon.initials||i.icon.text;s.iconVisible=i.icon.visible;if(i.icon.size){s.iconSize=i.icon.size}s.iconBackgroundColor=i.icon.backgroundColor||(s.iconInitials?undefined:f.Transparent)}if(i.attributesLayoutType){s.attributesLayoutType=i.attributesLayoutType}if(i.attributes){i.attributes.forEach(function(t){n=new r({text:t.value,state:t.state,emptyIndicatorMode:v.On,visible:t.visible,showStateIcon:t.showStateIcon,icon:t.customStateIcon});s.attributes.push(n)})}if(!o){if(i.chart){s.microchart=this._createChartAndAddLegend(i.chart)}if(i.actionsStrip){s.actionsStrip=u.create(this.getCardInstance(),i.actionsStrip);e.setShowSeparators(I.All)}else{e.setShowSeparators(I.None)}}this._oItemTemplate=new g(s);this._oActions.attach({area:y.ContentItem,actions:i.actions,control:this,actionControl:this._oItemTemplate,enabledPropertyName:"type",enabledPropertyValue:m.Active,disabledPropertyValue:m.Inactive});var a=t.group;if(a){this._oSorter=this._getGroupSorter(a)}var h={template:this._oItemTemplate,sorter:this._oSorter};this._bindAggregationToControl("items",e,h)};b.prototype._createChartAndAddLegend=function(t){var i=l.create(t);this.destroyAggregation("_legend");if(t.type==="StackedBar"){var e=new p({chart:i.getChart(),colorsLoad:function(){this.fireEvent(_)}.bind(this),visible:t.visible});e.initItemsTitles(t.bars,this.getBindingContext().getPath());this.setAggregation("_legend",e);this.awaitEvent(_)}this._oMicrochartsResizeHelper=new d(this._oList);return i};b.prototype._setStaticItems=function(t){var i=this._getList();t.forEach(function(t){var o=new g({title:t.title?t.title:"",description:t.description?t.description:"",icon:t.icon?t.icon:"",infoState:t.infoState?t.infoState:"None",info:t.info?t.info:"",highlight:t.highlight?t.highlight:"None",highlightText:t.highlightText?t.highlightText:""});if(t.action){o.setType("Navigation");if(t.action.url){o.attachPress(function(){e(t.action.url,t.target||"_blank")})}}i.addItem(o)});this.fireEvent("_actionContentReady")};b.prototype.getInnerList=function(){return this._getList()};return b});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/ListContentRenderer", ["./BaseContentRenderer","../controls/ListContentItem"],function(e,t){"use strict";var n=e.extend("sap.ui.integration.cards.ListContentRenderer",{apiVersion:2});n.renderContent=function(e,t){e.renderControl(t.getAggregation("_content"));if(t.getAggregation("_legend")){e.renderControl(t.getAggregation("_legend"))}};n.getMinHeight=function(e,t,n){if(t._fMinHeight){return t._fMinHeight+"px"}var i=n.getContentMinItems(e),r;if(!e||!e.item||i==null){return this.DEFAULT_MIN_HEIGHT}r=this.getItemMinHeight(e,t);return i*r+"rem"};n.getItemMinHeight=function(e,n){if(!e||!e.item){return 0}var i=this.isCompact(n),r=e.item,g=i?2:2.75,o=0,s=t.getLinesCount(r,n);if(s===2){g=5}else if(s>2){g=s+(s-1)*.5;o=2}if(r.actionsStrip){g+=i?2:2.75;o+=.5;if(s>2){g+=.5;o=1.5}}g+=o;return g};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/NumericHeader", ["sap/ui/core/Core","sap/base/util/extend","sap/f/cards/NumericHeader","sap/f/cards/NumericHeaderRenderer","sap/f/cards/NumericSideIndicator","sap/m/library","sap/m/Text","sap/ui/integration/util/BindingHelper","sap/ui/model/json/JSONModel","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/LoadingProvider"],function(t,i,e,a,r,n,o,s,d,c,l){"use strict";var u=n.AvatarColor;var h=e.extend("sap.ui.integration.cards.NumericHeader",{constructor:function(t,a,n,d){a=a||{};var c={title:a.title,titleMaxLines:a.titleMaxLines,subtitle:a.subTitle,subtitleMaxLines:a.subTitleMaxLines,dataTimestamp:a.dataTimestamp,visible:a.visible};if(a.status&&a.status.text&&!a.status.text.format){c.statusText=a.status.text;c.statusVisible=a.status.visible}if(a.icon){var l=a.icon.initials||a.icon.text;var h=a.icon.backgroundColor||(l?u.Accent6:u.Transparent);c.iconSrc=a.icon.src;c.iconDisplayShape=a.icon.shape;c.iconInitials=l;c.iconAlt=a.icon.alt;c.iconBackgroundColor=h;c.iconVisible=a.icon.visible}if(c.iconSrc){c.iconSrc=s.formattedProperty(c.iconSrc,function(t){return d.formatSrc(t)})}i(c,{unitOfMeasurement:a.unitOfMeasurement,details:a.details?.text||a.details,detailsMaxLines:a.details?.maxLines||a.detailsMaxLines,sideIndicatorsAlignment:a.sideIndicatorsAlignment});if(a.details?.state){c.detailsState=a.details.state}if(a.mainIndicator){c.number=a.mainIndicator.number;c.scale=a.mainIndicator.unit;c.trend=a.mainIndicator.trend;c.state=a.mainIndicator.state;c.numberVisible=a.mainIndicator.visible}if(a.sideIndicators){c.sideIndicators=a.sideIndicators.map(function(t){return new r(t)})}if(a.banner){c.bannerLines=a.banner.map(function(t){var i=new o({text:t.text,visible:t.visible});if(t.diminished){i.addStyleClass("sapFCardHeaderBannerLineDiminished")}return i})}c.toolbar=n;e.call(this,t,c)},metadata:{library:"sap.ui.integration",properties:{interactive:{type:"boolean",defaultValue:false}},aggregations:{_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:a});h.prototype.init=function(){e.prototype.init.call(this);this._bReady=false;this.setAggregation("_loadingProvider",new l);this._aReadyPromises=[];this._awaitEvent("_dataReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready")}.bind(this))};h.prototype.exit=function(){e.prototype.exit.call(this);this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null}if(this._oActions){this._oActions.destroy();this._oActions=null}};h.prototype.isInteractive=function(){return this.getInteractive()};h.prototype.isReady=function(){return this._bReady};h.prototype.isLoading=function(){if(!this.isReady()){return true}if(this._oDataProvider){return this.getAggregation("_loadingProvider").getLoading()}var t=this.getCardInstance();return t&&t.isLoading()};h.prototype._awaitEvent=function(t){this._aReadyPromises.push(new Promise(function(i){this.attachEventOnce(t,function(){i()})}.bind(this)))};h.prototype.setServiceManager=function(t){this._oServiceManager=t;return this};h.prototype.setDataProviderFactory=function(t){this._oDataProviderFactory=t;return this};h.prototype._setDataConfiguration=function(t){var i=this.getCardInstance(),e="/",a;if(t&&t.path){e=c.resolveValue(t.path,this.getCardInstance())}this.bindObject(e);if(this._oDataProvider){this._oDataProvider.destroy()}this._oDataProvider=this._oDataProviderFactory.create(t,this._oServiceManager);if(t&&t.name){a=i.getModel(t.name)}else if(this._oDataProvider){a=new d;this.setModel(a)}if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.showLoadingPlaceholders()}.bind(this));this._oDataProvider.attachDataChanged(function(t){a.setData(t.getParameter("data"));this.onDataRequestComplete()}.bind(this));this._oDataProvider.attachError(function(t){this._handleError({requestErrorParams:t.getParameters(),requestSettings:this._oDataProvider.getSettings()});this.onDataRequestComplete()}.bind(this));this._oDataProvider.triggerDataUpdate()}else{this.fireEvent("_dataReady")}};h.prototype._handleError=function(t){this.fireEvent("_error",{errorInfo:t})};h.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate()}};h.prototype.showLoadingPlaceholders=function(){if(!this._isDataProviderJson()){this.getAggregation("_loadingProvider").setLoading(true)}};h.prototype.hideLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(false)};h.prototype.onDataRequestComplete=function(){this.fireEvent("_dataReady");this.hideLoadingPlaceholders()};h.prototype.getCardInstance=function(){return t.byId(this.getCard())};h.prototype._isDataProviderJson=function(){return this._oDataProvider&&this._oDataProvider.getSettings()&&this._oDataProvider.getSettings()["json"]};return h});
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/cards/ObjectContent", ["./BaseContent","./ObjectContentRenderer","sap/ui/integration/library","sap/m/library","sap/m/IllustratedMessageType","sap/m/FlexItemData","sap/m/HBox","sap/m/VBox","sap/m/Text","sap/m/Avatar","sap/m/Link","sap/m/Label","sap/m/RatingIndicator","sap/m/Image","sap/ui/integration/controls/ObjectStatus","sap/m/ComboBox","sap/m/TextArea","sap/m/Input","sap/m/TimePicker","sap/base/Log","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/util/merge","sap/ui/core/ResizeHandler","sap/ui/layout/AlignedFlowLayout","sap/ui/dom/units/Rem","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/Utils","sap/ui/integration/util/Form","sap/ui/integration/util/DateRangeHelper","sap/ui/integration/util/Duration","sap/f/AvatarGroup","sap/f/AvatarGroupItem","sap/f/cards/NumericIndicators","sap/f/cards/NumericSideIndicator","sap/f/cards/loading/ObjectPlaceholder","sap/f/library","sap/m/OverflowToolbar","sap/m/OverflowToolbarButton","sap/ui/core/ListItem"],function(e,t,a,i,r,o,n,s,l,u,p,c,d,m,f,g,h,v,b,y,I,C,_,w,S,F,x,A,B,R,O,T,G,L,P,j,D,V,k,z,E){"use strict";var M=i.AvatarSize;var N=i.AvatarColor;var q=i.AvatarImageFitType;var U=i.ButtonType;var H=i.FlexRendertype;var W=i.FlexJustifyContent;var K=a.CardActionArea;var X=V.AvatarGroupType;var J=i.ToolbarStyle;var Q=e.extend("sap.ui.integration.cards.ObjectContent",{metadata:{library:"sap.ui.integration",aggregations:{_form:{type:"sap.ui.integration.util.Form",multiple:false,visibility:"hidden"}}},renderer:t});Q.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._sResizeListenerId){w.deregister(this._sResizeListenerId);this._sResizeListenerId=""}};Q.prototype.createLoadingPlaceholder=function(e){return new D};Q.prototype.onDataChanged=function(){var e=this.getCardInstance();if(this._hasData()){this.hideNoDataMessage()}else{this.showNoDataMessage({illustrationType:r.NoData,title:this.getCardInstance().getTranslatedText("CARD_NO_ITEMS_ERROR_CHART")})}this._getForm().updateModel();if(e.isReady()){this.validateControls(false)}};Q.prototype._getForm=function(){var e=this.getAggregation("_form");if(!e){e=new R(this.getCardInstance());this.setAggregation("_form",e)}return e};Q.prototype.validateControls=function(e,t){this._getForm().validate(e,t)};Q.prototype._hasData=function(){var e=this.getConfiguration();if(!e.hasOwnProperty("hasData")){return true}var t=A.resolveValue(e.hasData,this,this.getBindingContext().getPath());if(Array.isArray(t)&&!t.length||C(t)&&I(t)){return false}return!!t};Q.prototype.applyConfiguration=function(){var e=this.getParsedConfiguration();if(!e){return}if(e.groups){this._addGroups(e)}};Q.prototype.getStaticConfiguration=function(){var e=this.getParsedConfiguration(),t;if(!this.getBindingContext()){return e}else{t=this.getBindingContext().getPath()}if(e.groups){e.groups.forEach(function(e){var a=[];if(e.items){e.items.forEach(function(e){var i=this._resolveGroupItem(e,e.path,t);a.push(i)}.bind(this))}e.items=a}.bind(this))}return e};Q.prototype._resolveGroupItem=function(e,t,a){var i=_({},e),r=[],o=a+t,n=["TextArea","Input","ComboBox","Duration","DateRange"].includes(e.type),s=["ButtonGroup","IconGroup"].includes(e.type);if(n){i=_(i,this._getForm().resolveControl(e))}if(e.type==="ComboBox"){if(e.item){s=true;o=a+e.item.path.substring(1);e.template=e.item.template;delete i.item}else{s=false}}if(s){var l=e.template,u=this.getModel().getProperty(o);u.forEach(function(e,t){var a=A.resolveValue(l,this,o+"/"+t+"/");if(a.icon&&a.icon.src){a.icon.src=this._oIconFormatter.formatSrc(a.icon.src)}else if(a.icon&&typeof a.icon==="string"){a.icon=this._oIconFormatter.formatSrc(a.icon)}r.push(a)}.bind(this));i.items=r;delete i.path;delete i.template}if(e.icon&&e.icon.src){i.icon.src=this._oIconFormatter.formatSrc(A.resolveValue(e.icon.src,this))}return i};Q.prototype._getRootContainer=function(){var e=this.getAggregation("_content");if(!e){e=new s({renderType:H.Bare});this.setAggregation("_content",e);this._sResizeListenerId=w.register(e,this._onResize.bind(this))}return e};Q.prototype._addGroups=function(e){var t=this._getRootContainer(),a,i=true,r=e.groups||[];r.forEach(function(e,n){var s=this._createGroup(e,"/sap.card/content/groups/"+n);if(e.alignment==="Stretch"){s.setLayoutData(new o({growFactor:1}));t.addItem(s);i=true}else{if(i){a=this._createAFLayout();t.addItem(a);i=false}a.addContent(s)}if(n===r.length-1){s.addStyleClass("sapFCardObjectGroupLastInColumn")}},this);this._oActions.attach({area:K.Content,actions:e.actions,control:this})};Q.prototype._createGroup=function(e,t){var a;if(typeof e.visible=="string"){a=!B.hasFalsyValueAsString(e.visible)}else{a=e.visible}var i=new s({visible:a,renderType:H.Bare}).addStyleClass("sapFCardObjectGroup");if(e.title){i.addItem(new l({text:e.title,maxLines:e.titleMaxLines||1}).addStyleClass("sapFCardObjectItemTitle sapMTitle sapMTitleStyleAuto"));i.addStyleClass("sapFCardObjectGroupWithTitle")}e.items.forEach(function(a,r){a.labelWrapping=e.labelWrapping;this._createGroupItems(a,t+"/items/"+r).forEach(i.addItem,i)},this);return i};Q.prototype._createGroupItems=function(e,t){var a=e.label,i=e.showColon,r,o,l;e.showColon=i===undefined?true:i;if(typeof e.visible=="string"){o=!B.hasFalsyValueAsString(e.visible)}else{o=e.visible}if(a){r=new c({text:a,visible:o,wrapping:e.labelWrapping,showColon:e.showColon}).addStyleClass("sapFCardObjectItemLabel");r.addEventDelegate({onBeforeRendering:function(){r.setVisible(r.getVisible()&&!!r.getText())}})}l=this._createItem(e,o,r,t);if(l&&!l.isA("sap.m.Image")){l.addStyleClass("sapFCardObjectItemValue")}if(e.icon){var u=new s({renderType:H.Bare,justifyContent:W.Center,items:[r,l]}).addStyleClass("sapFCardObjectItemPairContainer");var p=new n({visible:o,renderType:H.Bare,items:[this._createGroupItemAvatar(e.icon),u]}).addStyleClass("sapFCardObjectItemLabel");return[p]}else{return[r,l]}};Q.prototype._createGroupItemAvatar=function(e){var t=x.formattedProperty(e.src,function(e){return this._oIconFormatter.formatSrc(e)}.bind(this));var a=e.initials||e.text;var i=new u({displaySize:e.size||M.XS,src:t,initials:a,displayShape:e.shape,tooltip:e.alt,backgroundColor:e.backgroundColor||(a?undefined:N.Transparent),imageFitType:q.Contain,visible:e.visible}).addStyleClass("sapFCardObjectItemAvatar sapFCardIcon");return i};Q.prototype._createItem=function(e,t,a,i){var r,o=e.value,n=e.tooltip,s;switch(e.type){case"NumericData":r=this._createNumericDataItem(e,t);break;case"Status":r=this._createStatusItem(e,t);break;case"IconGroup":r=this._createIconGroupItem(e,t);break;case"ButtonGroup":r=this._createButtonGroupItem(e,t);break;case"ComboBox":r=this._createComboBoxItem(e,t,a,i);break;case"TextArea":r=this._createTextAreaItem(e,t,a,i);break;case"RatingIndicator":r=this._createRatingIndicatorItem(e,t);break;case"Image":r=this._createImageItem(e,t);break;case"Input":r=this._createInputItem(e,t,a,i);break;case"Duration":r=this._createDurationItem(e,t,a,i);break;case"DateRange":r=this._createDateRangeItem(e,t,a,i);break;case"link":y.warning("Usage of Object Group Item property 'type' with value 'link' is deprecated. Use Card Actions for navigation instead.",null,"sap.ui.integration.widgets.Card");r=new p({href:e.url||o,text:o,tooltip:n,target:e.target||"_blank",visible:x.reuse(t)});break;case"email":y.warning("Usage of Object Group Item property 'type' with value 'email' is deprecated. Use Card Actions for navigation instead.",null,"sap.ui.integration.widgets.Card");var l=[];if(e.value){l.push(e.value)}if(e.emailSubject){l.push(e.emailSubject)}s=x.formattedProperty(l,function(e,t){if(t){return"mailto:"+e+"?subject="+t}else{return"mailto:"+e}});r=new p({href:s,text:o,tooltip:n,visible:x.reuse(t)});break;case"phone":y.warning("Usage of Object Group Item property 'type' with value 'phone' is deprecated. Use Card Actions for navigation instead.",null,"sap.ui.integration.widgets.Card");s=x.formattedProperty(o,function(e){return"tel:"+e});r=new p({href:s,text:o,tooltip:n,visible:x.reuse(t)});break;default:r=this._createTextItem(e,t,a)}return r};Q.prototype._createNumericDataItem=function(e,t){var a=new s({visible:x.reuse(t)});var i=new P({number:e.mainIndicator.number,numberSize:e.mainIndicator.size,scale:e.mainIndicator.unit,trend:e.mainIndicator.trend,state:e.mainIndicator.state}).addStyleClass("sapUiIntOCNumericIndicators");a.addItem(i);if(e.sideIndicators){e.sideIndicators.forEach(function(e){i.addSideIndicator(new j({title:e.title,number:e.number,unit:e.unit,state:e.state}))})}if(e.details){a.addItem(new l({text:e.details,maxLines:1}).addStyleClass("sapUiIntOCNumericIndicatorsDetails"))}return a};Q.prototype._createStatusItem=function(e,t){var a=new f({text:e.value,visible:x.reuse(t),state:e.state,showStateIcon:e.showStateIcon,icon:e.customStateIcon});return a};Q.prototype._createTextItem=function(e,t,a){var i=e.value,r=e.tooltip,o;if(i&&e.actions){o=new p({text:i,tooltip:r,visible:x.reuse(t)});if(a){o.addAriaLabelledBy(a)}else{y.warning("Missing label for Object group item with actions.",null,"sap.ui.integration.widgets.Card")}this._oActions.attach({area:K.ContentItemDetail,actions:e.actions,control:this,actionControl:o,enabledPropertyName:"enabled"});o=new n({renderType:H.Bare,items:o})}else if(i){o=new l({text:i,visible:x.reuse(t),maxLines:e.maxLines})}return o};Q.prototype._createButtonGroupItem=function(e,t){var a=e.template;if(!a){return null}var i=new k({visible:x.reuse(t),style:J.Clear});i.addStyleClass("sapUiIntCardObjectButtonGroup");var r=new z({icon:x.formattedProperty(a.icon,function(e){return this._oIconFormatter.formatSrc(e)}.bind(this)),text:a.text||a.tooltip,tooltip:a.tooltip||a.text,type:U.Transparent,visible:a.visible});if(a.actions){r.attachPress(function(e){this._onButtonGroupPress(e,a.actions)}.bind(this))}i.bindAggregation("content",{path:e.path||"/",template:r,templateShareable:false});return i};Q.prototype._onButtonGroupPress=function(e,t){var a=e.getSource();var i=A.resolveValue(t,a,a.getBindingContext().getPath());var r=i[0];this.getActions().fireAction(this,r.type,r.parameters)};Q.prototype._createIconGroupItem=function(e,t){var a=e.template;if(!a){return null}var i=new G({avatarDisplaySize:e.size||M.XS,groupType:X.Individual,visible:x.reuse(t)});i._oShowMoreButton.setType(U.Transparent);i._oShowMoreButton.setEnabled(false);if(a.actions){i.attachPress(function(e){this._onIconGroupPress(e,a.actions)}.bind(this))}else{i._setInteractive(false)}var r=new L({src:x.formattedProperty(a.icon.src,function(e){return this._oIconFormatter.formatSrc(e)}.bind(this)),initials:a.icon.initials||a.icon.text,tooltip:a.icon.alt});i.bindAggregation("items",{path:e.path||"/",template:r,templateShareable:false});return i};Q.prototype._onIconGroupPress=function(e,t){if(e.getParameter("overflowButtonPressed")){}else{var a=e.getParameter("eventSource");var i=A.resolveValue(t,a,a.getBindingContext().getPath());var r=i[0];this.getActions().fireAction(this,r.type,r.parameters)}};Q.prototype._createComboBoxItem=function(e,t,a,i){var r=this._getForm(),o={visible:x.reuse(t),placeholder:e.placeholder,required:r.getRequiredValidationValue(e)},n,s;if(e.selectedKey){o.selectedKey=e.selectedKey}else if(e.value){o.value=e.value}n=new g(o);if(a){a.setLabelFor(n)}if(e.item){s=new E({key:e.item.template.key,text:e.item.template.title});n.bindItems({path:e.item.path||"/",template:s,templateShareable:false})}r.addControl("change",n,e,i);return n};Q.prototype.setFormFieldValue=function(e){this._getForm().setControlValue(e)};Q.prototype._createTextAreaItem=function(e,t,a,i){var r=this._getForm(),o=new h({required:r.getRequiredValidationValue(e),value:e.value,visible:x.reuse(t),rows:e.rows,placeholder:e.placeholder});if(a){a.setLabelFor(o)}r.addControl("liveChange",o,e,i);return o};Q.prototype._createInputItem=function(e,t,a,i){var r=this._getForm(),o=new v({required:r.getRequiredValidationValue(e),value:e.value,visible:x.reuse(t),placeholder:e.placeholder});if(a){a.setLabelFor(o)}r.addControl("liveChange",o,e,i);return o};Q.prototype._createDurationItem=function(e,t,a,i){var r=this._getForm(),o=new b({valueFormat:"HH:mm",displayFormat:"HH:mm",support2400:true,required:r.getRequiredValidationValue(e),value:x.formattedProperty(e.value,T.fromISO),visible:x.reuse(t),placeholder:e.placeholder});if(a){a.setLabelFor(o)}r.addControl("change",o,e,i);return o};Q.prototype._createRatingIndicatorItem=function(e,t){var a=new d({editable:false,displayOnly:true,maxValue:e.maxValue,value:e.value,visualMode:e.visualMode,visible:x.reuse(t),iconSize:"1rem"});return a};Q.prototype._createImageItem=function(e,t){var a=x.formattedProperty(e.src,function(e){return this._oIconFormatter.formatSrc(e)}.bind(this));var i=new m({src:a,alt:e.alt,tooltip:e.tooltip,visible:x.reuse(t)}).addStyleClass("sapFCardObjectImage");if(e.fullWidth){i.addStyleClass("sapFCardObjectImageFullWidth")}return i};Q.prototype._createDateRangeItem=function(e,t,a,i){var r={options:["date"],value:e.value};var o=this._getForm();var n=O.createInput(r,this.getCardInstance(),true);if(x.isBindingInfo(t)){n.bindProperty("visible",x.reuse(t))}else{n.setVisible(t)}n.setRequired(o.getRequiredValidationValue(e));if(a){a.setLabelFor(n)}o.addControl("change",n,e,i);return n};Q.prototype._createAFLayout=function(){var e=new S;e.addEventDelegate({onAfterRendering:function(){this.getContent().forEach(function(e){if(!e.getVisible()){document.getElementById("sap-ui-invisible-"+e.getId()).parentElement.classList.add("sapFCardInvisibleContent")}})}},e);return e};Q.prototype._onResize=function(e){if(e.size.width===e.oldSize.width){return}var t=this._getRootContainer().getItems();t.forEach(function(a,i){if(a.isA("sap.ui.layout.AlignedFlowLayout")){this._onAlignedFlowLayoutResize(a,e,i===t.length-1)}}.bind(this))};Q.prototype._onAlignedFlowLayoutResize=function(e,t,a){var i=e.getMinItemWidth(),r,o=e.getContent().filter(function(e){return e.getVisible()}).length;if(i.lastIndexOf("rem")!==-1){r=F.toPx(i)}else if(i.lastIndexOf("px")!==-1){r=parseFloat(i)}var n=Math.floor(t.size.width/r);if(n>o){n=o}var s=n-1,l=Math.ceil(o/n);e.getContent().forEach(function(e,t){e.addStyleClass("sapFCardObjectSpaceBetweenGroup");if(s===t&&s<o){e.removeStyleClass("sapFCardObjectSpaceBetweenGroup");s+=n}if(a&&t+1>(l-1)*n){e.addStyleClass("sapFCardObjectGroupLastInColumn")}else{e.removeStyleClass("sapFCardObjectGroupLastInColumn")}})};return Q});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/ObjectContentRenderer", ["./BaseContentRenderer"],function(e){"use strict";var n=e.extend("sap.ui.integration.cards.ObjectContentRenderer",{apiVersion:2,MIN_OBJECT_CONTENT_HEIGHT:"3rem"});n.getMinHeight=function(e,t){return n.MIN_OBJECT_CONTENT_HEIGHT};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/TableContent", ["./BaseListContent","./TableContentRenderer","sap/ui/integration/library","sap/f/cards/loading/TablePlaceholder","sap/m/Table","sap/m/Column","sap/m/ColumnListItem","sap/m/Text","sap/m/Link","sap/m/ProgressIndicator","sap/m/ObjectIdentifier","sap/ui/integration/controls/ObjectStatus","sap/m/Avatar","sap/ui/core/library","sap/m/library","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/BindingHelper","sap/base/Log"],function(t,e,i,n,r,a,o,s,l,c,g,h,d,p,u,f,m,v){"use strict";var y=u.AvatarSize;var C=u.AvatarColor;var b=u.AvatarImageFitType;var I=p.VerticalAlign;var w=u.ListSeparators;var A=u.ListType;var _=i.CardActionArea;var T=t.extend("sap.ui.integration.cards.TableContent",{metadata:{library:"sap.ui.integration"},renderer:e});T.prototype.onBeforeRendering=function(){t.prototype.onBeforeRendering.apply(this,arguments);this._getTable().setBackgroundDesign(this.getDesign())};T.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null}};T.prototype.createLoadingPlaceholder=function(t){var i=this.getCardInstance(),r=i.getContentMinItems(t);return new n({minItems:r!==null?r:2,itemHeight:e.getItemMinHeight(t,this)+"rem",columns:t.row?t.row.columns.length||2:2})};T.prototype._getTable=function(){if(this._bIsBeingDestroyed){return null}var t=this.getAggregation("_content");if(!t){t=new r({id:this.getId()+"-Table",showSeparators:w.None,ariaLabelledBy:this.getHeaderTitleId()});t.addEventDelegate({onfocusin:function(t){if(!(t.srcControl instanceof o)){return}var e=t.target.getBoundingClientRect().bottom;var i=this.getDomRef().getBoundingClientRect().bottom;var n=Math.abs(e-i);var r=10;if(n<r){t.srcControl.addStyleClass("sapUiIntTCIRoundedCorners")}}},this);this.setAggregation("_content",t)}return t};T.prototype.applyConfiguration=function(){t.prototype.applyConfiguration.apply(this,arguments);var e=this.getParsedConfiguration();if(!e){return}if(e.rows&&e.columns){this._setStaticColumns(e.rows,e.columns);return}if(e.row&&e.row.columns){this._setColumns(e.row)}};T.prototype.getStaticConfiguration=function(){var t=this.getInnerList().getItems(),e=this.getParsedConfiguration(),i=t[0]&&t[0].isA("sap.m.GroupHeaderListItem"),n=[],r=[],a=[],o,s;(e.row.columns||[]).forEach(function(t){t=f.resolveValue(t,this,this.getBindingContext().getPath());n.push({title:t.title,width:t.width,hAlign:t.hAlign,visible:t.visible,identifier:t.identifier})}.bind(this));t.forEach(function(t){if(t.isA("sap.m.GroupHeaderListItem")){if(s){a.push(s)}r=[];s={title:t.getTitle(),rows:r}}else{o=f.resolveValue(e.row,this,t.getBindingContext().getPath());(o.columns||[]).forEach(function(t){delete t.title;delete t.width;delete t.hAlign;delete t.visible;delete t.identifier;if(t.icon&&t.icon.src){t.icon.src=this._oIconFormatter.formatSrc(t.icon.src)}}.bind(this));r.push(o)}}.bind(this));if(s){a.push(s)}var l={headers:n};if(i){l.groups=a}else{l.groups=[{rows:r}]}return l};T.prototype.getItemsLength=function(){return this._getTable().getItems().filter(t=>!t.isA("sap.m.GroupHeaderListItem")).length};T.prototype.onDataChanged=function(){t.prototype.onDataChanged.apply(this,arguments);this._checkHiddenNavigationItems(this.getParsedConfiguration().row)};T.prototype._setColumns=function(t){var e=[],i=this._getTable(),n=t.columns;n.forEach(function(t){i.addColumn(new a({header:new s({text:t.title}),width:t.width,hAlign:t.hAlign,visible:t.visible}));e.push(this._createCell(t))}.bind(this));this._oItemTemplate=new o({cells:e,vAlign:I.Middle,highlight:t.highlight,highlightText:t.highlightText});this._oActions.attach({area:_.ContentItem,actions:t.actions,control:this,actionControl:this._oItemTemplate,enabledPropertyName:"type",enabledPropertyValue:A.Active,disabledPropertyValue:A.Inactive});var r=this.getParsedConfiguration().group;if(r){this._oSorter=this._getGroupSorter(r)}var l={template:this._oItemTemplate,sorter:this._oSorter};this._bindAggregationToControl("items",i,l)};T.prototype._setStaticColumns=function(t,e){var i=this._getTable();e.forEach(function(t){i.addColumn(new a({header:new s({text:t.title}),width:t.width,hAlign:t.hAlign}))});t.forEach(function(t){var e=new o({vAlign:I.Middle,highlight:t.highlight,highlightText:t.highlightText});if(t.cells&&Array.isArray(t.cells)){for(var n=0;n<t.cells.length;n++){e.addCell(this._createCell(t.cells[n]))}}if(t.actions&&Array.isArray(t.actions)){this._oActions.attach({area:_.ContentItem,actions:t.actions,control:this,actionControl:e,enabledPropertyName:"type",enabledPropertyValue:A.Active,disabledPropertyValue:A.Inactive})}i.addItem(e)}.bind(this));this.fireEvent("_actionContentReady")};T.prototype._createCell=function(t){var e;if(t.identifier){if(typeof t.identifier=="object"){if(!m.isBindingInfo(t.identifier)){v.warning("Usage of object type for column property 'identifier' is deprecated.",null,"sap.ui.integration.widgets.Card")}if(t.identifier.url){t.actions=[{type:"Navigation",parameters:{url:t.identifier.url,target:t.identifier.target}}]}}e=new g({title:t.value,text:t.additionalText});if(t.actions){e.setTitleActive(true);this._oActions.attach({area:_.ContentItemDetail,actions:t.actions,control:this,actionControl:e,enabledPropertyName:"titleActive",eventName:"titlePress"})}return e}if(t.url){v.warning("Usage of column property 'url' is deprecated. Use card actions for navigation.",null,"sap.ui.integration.widgets.Card");t.actions=[{type:"Navigation",parameters:{url:t.url,target:t.target}}]}if(t.actions){e=new l({text:t.value});this._oActions.attach({area:_.ContentItemDetail,actions:t.actions,control:this,actionControl:e,enabledPropertyName:"enabled"});return e}if(t.state){return new h({text:t.value,state:t.state,showStateIcon:t.showStateIcon,icon:t.customStateIcon})}if(t.value){return new s({text:t.value})}if(t.icon){var i=m.formattedProperty(t.icon.src,function(t){return this._oIconFormatter.formatSrc(t)}.bind(this));var n=t.icon.initials||t.icon.text;return new d({src:i,displayShape:t.icon.shape,displaySize:t.icon.size||y.XS,tooltip:t.icon.alt,initials:n,backgroundColor:t.icon.backgroundColor||(n?undefined:C.Transparent),imageFitType:b.Contain,visible:t.icon.visible}).addStyleClass("sapFCardIcon")}if(t.progressIndicator){return new c({percentValue:t.progressIndicator.percent,displayValue:t.progressIndicator.text,state:t.progressIndicator.state})}};T.prototype.getInnerList=function(){return this._getTable()};return T});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/TableContentRenderer", ["./BaseContentRenderer","../library"],function(e,t){"use strict";var n=e.extend("sap.ui.integration.cards.TableContentRenderer",{apiVersion:2});n.getMinHeight=function(e,t,n){if(t._fMinHeight){return t._fMinHeight+"px"}var i=n.getContentMinItems(e);if(i==null){return this.DEFAULT_MIN_HEIGHT}var r=this.isCompact(t),a=r?2:2.75,s=r?2:2.75;return i*a+s+"rem"};n.getItemMinHeight=function(e,t){if(!e||!e.row){return 0}var n=this.isCompact(t);return n?2:2.75};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/TimelineContent", ["./BaseListContent","./TimelineContentRenderer","sap/f/cards/loading/TimelinePlaceholder","sap/ui/integration/library","sap/ui/core/Core","sap/ui/integration/util/BindingHelper"],function(e,t,i,n,o,r){"use strict";var a=n.CardActionArea;var s,m;var l=e.extend("sap.ui.integration.cards.TimelineContent",{metadata:{library:"sap.ui.integration"},renderer:t});l.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oTimeLineItemTemplate){this._oTimeLineItemTemplate.destroy();this._oTimeLineItemTemplate=null}};l.prototype.createLoadingPlaceholder=function(e){var n=this.getCardInstance(),o=n.getContentMinItems(e);return new i({minItems:o!==null?o:2,item:e.item,itemHeight:t.getItemMinHeight(e,this)+"rem"})};l.prototype.loadDependencies=function(e){return new Promise(function(e,t){o.loadLibrary("sap.suite.ui.commons",{async:true}).then(function(){sap.ui.require(["sap/suite/ui/commons/Timeline","sap/suite/ui/commons/TimelineItem"],function(t,i){s=t;m=i;e()},function(e){t(e)})}).catch(function(){t("Timeline content type is not available with this distribution.")})})};l.prototype._getTimeline=function(){var e=this.getAggregation("_content");if(this._bIsBeingDestroyed){return null}if(!e){e=new s({id:this.getId()+"-Timeline",showHeaderBar:false,enableScroll:false,growingThreshold:0,ariaLabelledBy:this.getHeaderTitleId()});this.setAggregation("_content",e)}return e};l.prototype.applyConfiguration=function(){e.prototype.applyConfiguration.apply(this,arguments);var t=this.getParsedConfiguration();if(!t){return}if(t.items){this._setStaticItems(t.items);return}if(t.item){this._setItem(t.item)}};l.prototype.getItemsLength=function(){return this._getTimeline().getContent().length};l.prototype.onDataChanged=function(){e.prototype.onDataChanged.apply(this,arguments);this._checkHiddenNavigationItems(this.getParsedConfiguration().item)};l.prototype._setItem=function(e){var t={userNameClickable:false,title:e.title&&e.title.value,text:e.description&&e.description.value,dateTime:e.dateTime&&e.dateTime.value,userName:e.owner&&e.owner.value,icon:e.icon&&e.icon.src};if(e.ownerImage&&e.ownerImage.value){t.userPicture=r.formattedProperty(e.ownerImage.value,function(e){return this._oIconFormatter.formatSrc(e)}.bind(this))}this._oTimeLineItemTemplate=new m(t);this._oActions.attach({area:a.ContentItem,actions:e.actions,control:this,actionControl:this._oTimeLineItemTemplate,eventName:"select"});var i={template:this._oTimeLineItemTemplate};this._bindAggregationToControl("content",this._getTimeline(),i);return this};l.prototype._setStaticItems=function(e){var t=this._getTimeline(),i;e.forEach(function(e){i=new m({title:e.title,text:e.description,userPicture:e.ownerImage,dateTime:e.dateTime,userName:e.owner,icon:e.icon});t.addContent(i)})};l.prototype.getInnerList=function(){return this._getTimeline()};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/TimelineContentRenderer", ["./BaseContentRenderer"],function(e){"use strict";var t=e.extend("sap.ui.integration.cards.TimelineContentRenderer",{apiVersion:2});t.getMinHeight=function(e,t,n){if(t._fMinHeight){return t._fMinHeight+"px"}var i=n.getContentMinItems(e);if(i==null){return this.DEFAULT_MIN_HEIGHT}var r=this.getItemMinHeight(e,t);return i*r+"rem"};t.getItemMinHeight=function(e,t){if(!e||!e.item){return 0}return e.item.ownerImage?7:5.625};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/WebPageContent", ["sap/m/IllustratedMessageType","./BaseContent","./WebPageContentRenderer","sap/ui/core/Core","sap/ui/integration/util/BindingHelper"],function(e,t,i,r,n){"use strict";var o="_frameLoaded";var a=15*1e3;var s=t.extend("sap.ui.integration.cards.WebPageContent",{metadata:{properties:{minHeight:{type:"sap.ui.core.CSSSize",defaultValue:i.MIN_WEB_PAGE_CONTENT_HEIGHT,bindable:true},src:{type:"sap.ui.core.URI",defaultValue:"",bindable:true},sandbox:{type:"string",defaultValue:"",bindable:true}},library:"sap.ui.integration"},renderer:i});s.prototype.init=function(){t.prototype.init.apply(this,arguments);this._onFrameLoadedBound=this._onFrameLoaded.bind(this);this._sPrevSrc=this.getSrc()};s.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this._iLoadTimeout){clearTimeout(this._iLoadTimeout)}};s.prototype.onBeforeRendering=function(){t.prototype.onBeforeRendering.apply(this,arguments);if(this.getDomRef()){this.getDomRef("frame").removeEventListener("load",this._onFrameLoadedBound)}};s.prototype.onAfterRendering=function(){t.prototype.onAfterRendering.apply(this,arguments);if(this.getDomRef("frame")){this.getDomRef("frame").addEventListener("load",this._onFrameLoadedBound);this._checkSrc()}};s.prototype.applyConfiguration=function(){var e=this.getParsedConfiguration();this.fireEvent("_actionContentReady");if(!e){return}var t=n.formattedProperty(e.src,function(e){return this._oIconFormatter.formatSrc(e)}.bind(this));if(t){this.bindSrc(t)}if(typeof e.sandbox==="object"){this.bindSandbox(n.reuse(e.sandbox))}else{this.setSandbox(e.sandbox)}if(typeof e.minHeight==="object"){this.bindMinHeight(n.reuse(e.minHeight))}else{this.setMinHeight(e.minHeight)}};s.prototype._checkSrc=function(){var t=this.getCardInstance(),i=this.getSrc();if(!t){return}if(i===""){this.handleError({illustrationType:e.ErrorScreen,title:t.getTranslatedText("CARD_WEB_PAGE_EMPTY_URL_ERROR"),description:t.getTranslatedText("CARD_ERROR_CONFIGURATION_DESCRIPTION")});return}if(!i.startsWith("https://")){this.handleError({illustrationType:e.ErrorScreen,title:t.getTranslatedText("CARD_WEB_PAGE_HTTPS_URL_ERROR"),description:t.getTranslatedText("CARD_ERROR_REQUEST_ACCESS_DENIED_DESCRIPTION")});return}if(this._sPrevSrc!==i){this._raceFrameLoad();this._sPrevSrc=i}};s.prototype._raceFrameLoad=function(){this.awaitEvent(o);this._iLoadTimeout=setTimeout(function(){var t=a/1e3,i=this.getCardInstance();this.handleError({illustrationType:e.ReloadScreen,title:i.getTranslatedText("CARD_WEB_PAGE_TIMEOUT_ERROR",[t]),details:"Failed to load '"+this.getSrc()+"' after "+t+" seconds."})}.bind(this),a)};s.prototype._onFrameLoaded=function(){this.fireEvent(o);clearTimeout(this._iLoadTimeout)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/WebPageContentRenderer", ["./BaseContentRenderer","sap/ui/integration/util/BindingResolver"],function(e,t){"use strict";var n="2px";var i=e.extend("sap.ui.integration.cards.WebPageContentRenderer",{apiVersion:2,MIN_WEB_PAGE_CONTENT_HEIGHT:"150px"});i.renderContent=function(e,t){e.openStart("iframe",t.getId()+"-frame").class("sapUiIntWPCFrame");e.style("height","calc("+t.getMinHeight()+" - "+n+")").attr("src",t.getSrc()).attr("tabindex","0").attr("sandbox",t.getSandbox()).openEnd().close("iframe")};i.getMinHeight=function(e,n){if(e.minHeight){return t.resolveValue(e.minHeight,n)}return i.MIN_WEB_PAGE_CONTENT_HEIGHT};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/actions/BaseAction", ["sap/ui/base/ManagedObject","sap/ui/core/Core","sap/ui/integration/util/BindingResolver"],function(e,t,i){"use strict";var n=e.extend("sap.ui.integration.cards.actions.BaseAction",{metadata:{library:"sap.ui.integration",properties:{config:{type:"object"},parameters:{type:"object"},actionHandler:{type:"object"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false},source:{type:"sap.ui.base.EventProvider",multiple:false}}}});n.prototype.execute=function(){};n.prototype.getResolvedConfig=function(){var e=this.getSourceInstance(),t=e.getBindingContext(),n;if(t){n=e.getBindingContext().getPath()}return i.resolveValue(this.getConfig(),e,n)};n.prototype.getCardInstance=function(){return t.byId(this.getCard())};n.prototype.getSourceInstance=function(){return t.byId(this.getSource())};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/actions/CardActions", ["sap/ui/integration/library","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/integration/cards/actions/CustomAction","sap/ui/integration/cards/actions/DateChangeAction","sap/ui/integration/cards/actions/MonthChangeAction","sap/ui/integration/cards/actions/SubmitAction","sap/ui/integration/cards/actions/NavigationAction","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/base/strings/capitalize","sap/base/util/deepClone","sap/ui/integration/cards/actions/ShowCardAction","sap/ui/integration/cards/actions/HideCardAction"],function(e,t,n,a,i,r,o,s,c,l,u,d,f,p){"use strict";function g(e){if(e&&typeof e==="object"){return e.name}return e}var h=e.CardActionArea,v=e.CardActionType;var b=n.extend("sap.ui.integration.cards.actions.CardActions",{metadata:{library:"sap.ui.integration",properties:{card:{type:"object"},bindingPathResolver:{type:"function"}}}});b.prototype.attach=function(e){var t=e.control,n=e.area;e.actionControl=e.actionControl||e.control;e.enabledPropertyValue=e.enabledPropertyValue!==undefined?e.enabledPropertyValue:true;e.disabledPropertyValue=e.disabledPropertyValue||false;e.eventName=e.eventName||"press";if(!e.actions){this._fireActionReady(t,n);return}var a=e.actions[0];if(a&&a.type){e.action=a;this._attachAction(e)}else{this._fireActionReady(t,n)}};b.prototype._attachAction=function(e){var t=e.action,n=e.area,a=e.control,i=e.enabledPropertyName,r=true,o=this._isSingleAction(n),s=true;if(i){r=false;if(t.service&&!o){this._setControlEnabledStateUsingService(e)}else{this._setControlEnabledState(e)}}if(t.service&&o){this._getSingleActionEnabledState(t,a).then(function(t){if(t){this._attachEventListener(e)}this._fireActionReady(a,n)}.bind(this));return}if(r){s=t.enabled!==false&&t.enabled!=="false"}if(s){this._attachEventListener(e)}this._fireActionReady(a,n)};b.prototype._setControlEnabledStateUsingService=function(e){var t=e.action,a=e.control,i=e.actionControl,r=e.enabledPropertyName,o=e.enabledPropertyValue,s=e.disabledPropertyValue,c=n.bindingParser("{path:''}");c.formatter=function(e){var n=this.getBindingContext(),i,r;if(n){i=n.getPath()}r=l.resolveValue(t.parameters,a,i);if(e.__resolved){if(!e.__enabled||e.__enabled==="false"){return s}return o}if(!e.__promise){e.__promise=true;a._oServiceManager.getService(g(t.service)).then(function(t){if(t){t.enabled({parameters:r}).then(function(t){e.__resolved=true;e.__enabled=t;a.getModel().checkUpdate(true)}).catch(function(){e.__resolved=true;e.__enabled=false})}else{e.__resolved=true;e.__enabled=false}})}return s};i.bindProperty(r,c)};b.prototype._setControlEnabledState=function(e){var t=e.action,n=e.actionControl,a=e.enabledPropertyName,i=e.enabledPropertyValue,r=e.disabledPropertyValue,o,s;if(typeof t.enabled==="object"){o=c.formattedProperty(t.enabled,function(e){if(!e||e==="false"){return r}return i})}if(o){n.bindProperty(a,o)}else{s=t.enabled===false||t.enabled==="false"?r:i;n.setProperty(a,s)}};b.prototype._getSingleActionEnabledState=function(e,t){var n=t.getBindingContext(),a,i;if(n){i=n.getPath()}a=l.resolveValue(e.parameters,t,i);return new Promise(function(n){t._oServiceManager.getService(g(e.service)).then(function(e){if(e){e.enabled({parameters:a}).then(function(e){n(e)}).catch(function(){n(false)})}else{n(false)}}).catch(function(){n(false)})})};b.prototype._fireActionReady=function(e,t){var n=t===h.Header;var a=n?"_actionHeaderReady":"_actionContentReady";e.fireEvent(a)};b.prototype._resolveBindingPath=function(e){var t=e.getSource().getBindingContext(),n;if(this.getBindingPathResolver()){n=this.getBindingPathResolver()(e)}else if(t){n=t.getPath()}return n};b.prototype._handleServiceAction=function(e,n,a){var i=e.getSource();var r=this._resolveBindingPath(e);a._oServiceManager.getService(g(n.service)).then(function(e){if(e){e.navigate({parameters:l.resolveValue(n.parameters,i,r)})}}).catch(function(e){t.error("Navigation service unavailable",e)}).finally(function(){this._processAction(i,n,r)}.bind(this))};b.prototype._attachEventListener=function(e){var t=e.action;e.actionControl["attach"+u(e.eventName)](function(n){var a=n.getSource();if(t.service){this._handleServiceAction(n,t,e.control)}else{this._processAction(a,t,this._resolveBindingPath(n))}}.bind(this))};b.prototype._processAction=function(e,t,n){var a=this._getHostInstance(),i=this.getCard();b.fireAction({card:i,host:a,action:t,parameters:l.resolveValue(t.parameters,e,n),source:e})};b.prototype._getHostInstance=function(){var e=this.getCard();if(e){return e.getHostInstance()}return null};b.prototype.fireAction=function(e,t,n){b.fireAction({card:this.getCard(),host:this._getHostInstance(),action:{type:t},parameters:n,source:e})};b.fireAction=function(e){var t=e.host,n=e.card,a=n.getAggregation("_extension"),i=e.action.type,r=d(e.parameters,100)||{},o={type:i,card:n,actionSource:e.source},s,c=true;if(i===v.Submit){r.data=n.getModel("form").getData()}o.parameters=r;s=Object.assign({},o,{manifestParameters:r});if(a){c=a.fireAction(o)}if(!c){return false}c=n.fireAction(s);if(!c){return false}if(t){c=t.fireAction(o)}if(!c){return false}var l=b._createHandler(e);if(l){l.execute();l.destroy()}return true};b.prototype._isSingleAction=function(e){return[h.Header,h.Content,h.ContentItemDetail,h.ActionsStrip].indexOf(e)>-1};b._createHandler=function(e){var n=null;switch(e.action.type){case v.Custom:n=a;break;case v.DateChange:n=i;break;case v.HideCard:n=p;break;case v.MonthChange:n=r;break;case v.Navigation:n=s;break;case v.ShowCard:n=f;break;case v.Submit:n=o;break;default:t.error("Unknown action type '"+e.action.type+"'. Expected one of "+Object.values(v).join(", "),null,"sap.ui.integration.widgets.Card")}if(n){return new n({config:e.action,parameters:e.parameters,actionHandler:e.card.getManifestEntry("/sap.card/configuration/actionHandlers/"+e.action.type.toLowerCase()),card:e.card,source:e.source})}return null};return b});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/actions/CustomAction", ["./BaseAction"],function(t){"use strict";var i=t.extend("sap.ui.integration.cards.actions.CustomAction",{metadata:{library:"sap.ui.integration"}});i.prototype.execute=function(){var t=this.getConfig();if(typeof t.action==="function"){t.action(this.getCardInstance(),this.getSourceInstance())}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/actions/DateChangeAction", ["./BaseAction"],function(a){"use strict";var t=a.extend("sap.ui.integration.cards.actions.DateChangeAction",{metadata:{library:"sap.ui.integration"}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/actions/HideCardAction", ["./BaseAction","sap/m/Dialog"],function(t,e){"use strict";var a=t.extend("sap.ui.integration.cards.actions.HideCardAction",{metadata:{library:"sap.ui.integration"}});a.prototype.execute=function(){var t=this.getCardInstance(),a=t.getParent(),n=t.getHostInstance();if(n&&n.onHideCard){n.onHideCard(t);return}if(a instanceof e){a.close();a.attachAfterClose(function(){t.destroy()})}else{t.destroy()}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/actions/MonthChangeAction", ["./BaseAction"],function(t){"use strict";var a=t.extend("sap.ui.integration.cards.actions.MonthChangeAction",{metadata:{library:"sap.ui.integration"}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/actions/NavigationAction", ["./BaseAction","sap/ui/util/openWindow"],function(t,e){"use strict";var i=t.extend("sap.ui.integration.cards.actions.NavigationAction",{metadata:{library:"sap.ui.integration"}});i.prototype.execute=function(){var t=this.getResolvedConfig();if(t.service){return}var e=this.getParameters(),i,n,r,a;if(e){r=e.url;a=e.target}i=t.url||r;n=t.target||a||"_blank";if(i){this._openUrl(i,n)}};i.prototype._openUrl=function(t,i){e(t,i)};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/actions/ShowCardAction", ["./BaseAction","sap/m/Dialog","sap/ui/core/Core","sap/ui/dom/jquery/Focusable"],function(e,t,a){"use strict";var o=e.extend("sap.ui.integration.cards.actions.ShowCardAction",{metadata:{library:"sap.ui.integration"}});o.prototype.execute=function(){var e=this.getParameters()||{},t=this.getCardInstance(),o=t.getHostInstance(),i;if(e._cardId){i=a.byId(e._cardId)}else{i=t._createChildCard(e)}if(o&&o.onShowCard){o.onShowCard(i,e);return}this._openDialog(i,t)};o.prototype._openDialog=function(e,a){const o=new t({content:[e],showHeader:false,ariaLabelledBy:e.getId(),escapeHandler:function(t){e.hide();t.resolve()},resizable:this.getParameters().resizable});const i={onmousedown:t=>{if(t.target.classList.contains("sapMDialogResizeHandler")){e.setHeight("100%");o.setContentHeight(o.getDomRef("cont").offsetHeight+"px");o.setVerticalScrolling(false);o.removeEventDelegate(i)}}};o.addStyleClass("sapUiIntCardDialog");o.addEventDelegate(i);o.attachAfterClose(()=>{o.destroy()});a.addDependent(o);e.startManifestProcessing();e.attachManifestApplied(function(){o.open()});e.attachEvent("_ready",function(){setTimeout(function(){this._setFocus(e,o)}.bind(this),0)}.bind(this))};o.prototype._setFocus=function(e,t){var a=e.getAggregation("_filter"),o=e.getAggregation("_content"),i=e.getAggregation("_footer"),s;s=a&&a.$().firstFocusableDomRef()||o&&o.$().firstFocusableDomRef()||i&&i.$().firstFocusableDomRef();if(s){t.setInitialFocus(s.id);s.focus()}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/actions/SubmitAction", ["./BaseAction","sap/base/Log","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/Utils"],function(t,e,n,i,a){"use strict";var r=t.extend("sap.ui.integration.cards.actions.SubmitAction",{metadata:{library:"sap.ui.integration"}});r.prototype.execute=function(){var t=this.getCardInstance(),n=this.getActionHandler();if(!t.validateControls()){return}if(!n){return}var i=this.getCardInstance()._oDataProviderFactory,a=t.getModel("form").getData();this._onActionSubmitStart(a);var r=i.create({request:this._createRequest(n,a)},undefined,undefined,true);r.getData().then(function(t){this._onActionSubmitEnd(t,null)}.bind(this),function(t){e.error(t);this._onActionSubmitEnd(null,{error:t})}.bind(this)).finally(function(){i.remove(r)})};r.prototype._onActionSubmitStart=function(t){var e=this.getSourceInstance();if(e.isA("sap.ui.integration.cards.BaseContent")){e.onActionSubmitStart(t)}};r.prototype._onActionSubmitEnd=function(t,e){var n=this.getSourceInstance();if(n.isA("sap.ui.integration.cards.BaseContent")){n.onActionSubmitEnd(t,e)}};r.prototype._createRequest=function(t,e){var r={mode:t.mode||"cors",url:t.url,method:t.method||"POST",parameters:t.parameters||e,headers:t.headers,withCredentials:!!t.withCredentials};r=i.resolveValue(n.createBindingInfos(r,this.getCardInstance().getBindingNamespaces()),this.getSourceInstance());a.makeUndefinedValuesNull(r.parameters);return r};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/adaptivecards/elements/UI5InputChoiceSet", ["sap/ui/integration/thirdparty/adaptivecards","sap/ui/integration/cards/adaptivecards/overwrites/inputsGeneralOverwrites"],function(t,e){"use strict";function i(){t.ChoiceSetInput.apply(this,arguments)}i.prototype=Object.create(t.ChoiceSetInput.prototype);i.prototype.overrideInternalRender=function(){var i=t.TextInput.prototype.overrideInternalRender.call(this,arguments);e.overwriteLabel(this);e.overwriteRequired(this);return i};i.prototype.internalRender=function(){if(!this.isMultiSelect){if(this.isCompact){this._selectElement=document.createElement("ui5-select");this._selectElement.id=this.id;this._selectElement.addEventListener("change",function(){this.valueChanged()}.bind(this));var t=document.createDocumentFragment();for(var e=0;e<this.choices.length;e++){var i=document.createElement("ui5-option");i.value=this.choices[e].value;i.textContent=this.choices[e].title;if(this.choices[e].value===this.defaultValue){i.selected=true}t.appendChild(i)}this._selectElement.appendChild(t);return this._selectElement}var n=document.createElement("div");n.classList.add("sapFCardAdaptiveContentChoiceSetWrapper");n.id=this.id;n.setAttribute("role","radiogroup");n.addEventListener("change",function(){this.valueChanged()}.bind(this));this._toggleInputs=[];for(var s=0;s<this.choices.length;s++){var r=document.createElement("ui5-radio-button");r.value=this.choices[s].value;r.text=this.choices[s].title;r.name=this.id;r.wrappingType=this.wrap?"Normal":"None";if(this.choices[s].value===this.defaultValue){r.checked=true}this._toggleInputs.push(r);n.appendChild(r)}return n}var l=this.defaultValue?this.defaultValue.split(","):null;var a=document.createElement("div");a.classList.add("sapFCardAdaptiveContentChoiceSetWrapper");a.setAttribute("role","group");a.id=this.id;a.addEventListener("change",function(){this.valueChanged()}.bind(this));this._toggleInputs=[];for(var o=0;o<this.choices.length;o++){var u=document.createElement("ui5-checkbox");u.value=this.choices[o].value;u.text=this.choices[o].title;u.name=this.id;u.wrappingType=this.wrap?"Normal":"None";if(l&&l.indexOf(this.choices[o].value)>=0){u.checked=true}this._toggleInputs.push(u);a.appendChild(u)}return a};Object.defineProperty(i.prototype,"value",{get:function t(){var e;if(!this.isMultiSelect){if(this.isCompact){return this._selectElement.selectedOption?this._selectElement.selectedOption.value:null}else{if(!this._toggleInputs||this._toggleInputs.length===0){return null}for(e=0;e<this._toggleInputs.length;e++){if(this._toggleInputs[e].checked){return this._toggleInputs[e].value}}return null}}else{if(!this._toggleInputs||this._toggleInputs.length===0){return null}var i="";for(e=0;e<this._toggleInputs.length;e++){if(this._toggleInputs[e].checked){if(i!==""){i+=this.hostConfig.choiceSetInputValueSeparator}i+=this._toggleInputs[e].value}}return i===""?null:i}}});i.prototype.updateInputControlAriaLabelledBy=function(){var t=!this.isMultiSelect&&this.isCompact?"accessible-name-ref":"aria-labelledby";e.overwriteAriaLabelling(this,t)};i.prototype.showValidationErrorMessage=function(){if(!this._toggleInputs||!this._toggleInputs.length){return}this._toggleInputs.forEach(function(t){t.valueState="Error"})};i.prototype.resetValidationFailureCue=function(){t.TextInput.prototype.resetValidationFailureCue.call(this,arguments);if(!this._toggleInputs||!this._toggleInputs.length){return}this._toggleInputs.forEach(function(t){t.valueState="None"})};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/adaptivecards/elements/UI5InputDate", ["sap/ui/integration/thirdparty/adaptivecards","sap/ui/integration/cards/adaptivecards/overwrites/inputsGeneralOverwrites"],function(t,e){"use strict";function n(){t.DateInput.apply(this,arguments)}n.prototype=Object.create(t.DateInput.prototype);n.prototype.overrideInternalRender=function(){var n=t.TextInput.prototype.overrideInternalRender.call(this,arguments);e.overwriteLabel(this);e.overwriteRequired(this);return n};n.prototype.internalRender=function(){this._dateInputElement=document.createElement("ui5-date-picker");this._dateInputElement.id=this.id;this._dateInputElement.placeholder=this.placeholder;this._dateInputElement.formatPattern="yyyy-MM-dd";this._dateInputElement.value=this.defaultValue||"";this._dateInputElement.minDate=this.min||"";this._dateInputElement.maxDate=this.max||"";e.createValueStateElement(this,this._dateInputElement);this._dateInputElement.addEventListener("input",function(){this.valueChanged()}.bind(this));return this._dateInputElement};n.prototype.updateInputControlAriaLabelledBy=function(){e.overwriteAriaLabelling(this,"accessible-name-ref")};n.prototype.showValidationErrorMessage=function(){if(this.renderedInputControlElement){this.renderedInputControlElement.valueState="Error"}};n.prototype.resetValidationFailureCue=function(){t.TextInput.prototype.resetValidationFailureCue.call(this,arguments);if(this.renderedInputControlElement){this.renderedInputControlElement.valueState="None"}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/adaptivecards/elements/UI5InputNumber", ["sap/ui/integration/thirdparty/adaptivecards","sap/ui/integration/cards/adaptivecards/overwrites/inputsGeneralOverwrites"],function(e,t){"use strict";function n(){e.NumberInput.apply(this,arguments)}n.prototype=Object.create(e.NumberInput.prototype);n.prototype.overrideInternalRender=function(){var n=e.TextInput.prototype.overrideInternalRender.call(this,arguments);t.overwriteLabel(this);t.overwriteRequired(this);return n};n.prototype.internalRender=function(){this._numberInputElement=document.createElement("ui5-step-input");this._numberInputElement.id=this.id;this._numberInputElement.placeholder=this.placeholder||"";this._numberInputElement.value=this.defaultValue||"";this._numberInputElement.min=this.min;this._numberInputElement.max=this.max;this._numberInputElement.style.width="13.125rem";t.createValueStateElement(this,this._numberInputElement);this._numberInputElement.addEventListener("input",function(e){this.valueChanged()}.bind(this));return this._numberInputElement};Object.defineProperty(n.prototype,"value",{get:function(){return this._numberInputElement?this._numberInputElement.value:undefined}});n.prototype.updateInputControlAriaLabelledBy=function(){t.overwriteAriaLabelling(this,"accessible-name-ref")};n.prototype.showValidationErrorMessage=function(){if(this.renderedInputControlElement){this.renderedInputControlElement.valueState="Error"}};n.prototype.resetValidationFailureCue=function(){e.TextInput.prototype.resetValidationFailureCue.call(this,arguments);if(this.renderedInputControlElement){this.renderedInputControlElement.valueState="None"}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/adaptivecards/elements/UI5InputText", ["sap/ui/integration/thirdparty/adaptivecards","sap/ui/integration/cards/adaptivecards/overwrites/inputsGeneralOverwrites"],function(e,t){"use strict";function r(){e.TextInput.apply(this,arguments)}r.prototype=Object.create(e.TextInput.prototype);r.prototype.overrideInternalRender=function(){var r=e.TextInput.prototype.overrideInternalRender.call(this,arguments);t.overwriteLabel(this);t.overwriteRequired(this);return r};r.prototype.internalRender=function(){if(this.isMultiline){var e=document.createElement("ui5-textarea");e.id=this.id;e.placeholder=this.placeholder||"";e.value=this.defaultValue||"";e.maxlength=this.maxLength||null;t.createValueStateElement(this,e);e.addEventListener("input",function(){this.valueChanged()}.bind(this));return e}var r=document.createElement("ui5-input");switch(this.style){case 1:r.type="Tel";break;case 2:r.type="URL";break;case 3:r.type="Email";break;default:r.type="Text"}r.id=this.id;r.placeholder=this.placeholder||"";r.value=this.defaultValue||"";r.maxlength=this.maxLength||null;t.createValueStateElement(this,r);r.addEventListener("input",function(){this.valueChanged()}.bind(this));return r};r.prototype.updateInputControlAriaLabelledBy=function(){t.overwriteAriaLabelling(this,"accessible-name-ref")};r.prototype.showValidationErrorMessage=function(){if(this.renderedInputControlElement){this.renderedInputControlElement.valueState="Error"}};r.prototype.resetValidationFailureCue=function(){e.TextInput.prototype.resetValidationFailureCue.call(this,arguments);if(this.renderedInputControlElement){this.renderedInputControlElement.valueState="None"}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/adaptivecards/elements/UI5InputTime", ["sap/ui/integration/thirdparty/adaptivecards","sap/ui/integration/cards/adaptivecards/overwrites/inputsGeneralOverwrites"],function(e,t){"use strict";function n(){e.TimeInput.apply(this,arguments)}var i="HH:mm";n.prototype=Object.create(e.TimeInput.prototype);n.prototype.overrideInternalRender=function(){var n=e.TextInput.prototype.overrideInternalRender.call(this,arguments);t.overwriteLabel(this);t.overwriteRequired(this);return n};n.prototype.internalRender=function(){var e="ui5-time-picker";this._timeInputElement=document.createElement(e);this._timeInputElement.id=this.id;this._timeInputElement.value=this.defaultValue||"";this._timeInputElement.formatPattern=i;t.createValueStateElement(this,this._timeInputElement);this._timeInputElement.addEventListener("input",function(e){this.valueChanged()}.bind(this));return this._timeInputElement};n.prototype.updateInputControlAriaLabelledBy=function(){t.overwriteAriaLabelling(this,"aria-labelledby")};n.prototype.showValidationErrorMessage=function(){if(this.renderedInputControlElement){this.renderedInputControlElement.valueState="Error"}};n.prototype.resetValidationFailureCue=function(){e.TextInput.prototype.resetValidationFailureCue.call(this,arguments);if(this.renderedInputControlElement){this.renderedInputControlElement.valueState="None"}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/adaptivecards/elements/UI5InputToggle", ["sap/ui/integration/thirdparty/adaptivecards","sap/ui/integration/cards/adaptivecards/overwrites/inputsGeneralOverwrites"],function(e,t){"use strict";function n(){e.ToggleInput.apply(this,arguments)}n.prototype=Object.create(e.ToggleInput.prototype);n.prototype.overrideInternalRender=function(){var n=e.TextInput.prototype.overrideInternalRender.call(this,arguments);t.overwriteLabel(this);t.overwriteRequired(this);return n};n.prototype.internalRender=function(){this._checkboxInputElement=document.createElement("ui5-checkbox");this._checkboxInputElement.id=this.id;this._checkboxInputElement.text=this.title||"";this._checkboxInputElement.wrappingType=this.wrap?"Normal":"None";this._checkboxInputElement.checked=false;if(this.defaultValue===this.valueOn){this._checkboxInputElement.checked=true}this._checkboxInputElement.addEventListener("change",function(){this.valueChanged()}.bind(this));return this._checkboxInputElement};n.prototype.updateInputControlAriaLabelledBy=function(){t.overwriteAriaLabelling(this,"aria-labelledby")};n.prototype.showValidationErrorMessage=function(){if(this._checkboxInputElement){this._checkboxInputElement.valueState="Error"}};n.prototype.resetValidationFailureCue=function(){e.TextInput.prototype.resetValidationFailureCue.call(this,arguments);if(this._checkboxInputElement){this._checkboxInputElement.valueState="None"}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/adaptivecards/elements/hostConfig", ["sap/ui/core/theming/Parameters"],function(e){"use strict";return function(){return{spacing:{small:8,default:16,medium:32,large:48,extraLarge:48,padding:16},separator:{lineThickness:1,lineColor:e.get("sapUiToolbarSeparatorColor")},supportsInteractivity:true,fontTypes:{default:{fontFamily:e.get("sapUiFontFamily"),fontSizes:{small:12,default:14,medium:14,large:16,extraLarge:20}},monospace:{}},containerStyles:{default:{backgroundColor:"transparent",foregroundColors:{default:{default:e.get("sapUiBaseText"),subtle:e.get("sapUiContentLabelColor")},accent:{default:e.get("sapUiInformativeText")},attention:{default:e.get("sapUiNegativeText")},good:{default:e.get("sapUiPositiveText")},warning:{default:e.get("sapUiCriticalText")}}},emphasis:{backgroundColor:e.get("sapTile_Background"),foregroundColors:{default:{default:e.get("sapUiBaseText")},accent:{default:e.get("sapUiInformativeText")},attention:{default:e.get("sapUiNegativeText")},good:{default:e.get("sapUiPositiveText")},warning:{default:e.get("sapUiCriticalText")}}},accent:{backgroundColor:e.get("sapUiInformationBG"),foregroundColors:{default:{default:e.get("sapUiBaseText")},accent:{default:e.get("sapUiInformativeText")},attention:{default:e.get("sapUiNegativeText")},good:{default:e.get("sapUiPositiveText")},warning:{default:e.get("sapUiCriticalText")}}},good:{backgroundColor:e.get("sapUiSuccessBG"),foregroundColors:{default:{default:e.get("sapUiBaseText")},accent:{default:e.get("sapUiInformativeText")},attention:{default:e.get("sapUiNegativeText")},good:{default:e.get("sapUiPositiveText")},warning:{default:e.get("sapUiCriticalText")}}},attention:{backgroundColor:e.get("sapUiErrorBG"),foregroundColors:{default:{default:e.get("sapUiBaseText")},accent:{default:e.get("sapUiInformativeText")},attention:{default:e.get("sapUiNegativeText")},good:{default:e.get("sapUiPositiveText")},warning:{default:e.get("sapUiCriticalText")}}},warning:{backgroundColor:e.get("sapUiWarningBG"),foregroundColors:{default:{default:e.get("sapUiBaseText")},accent:{default:e.get("sapUiInformativeText")},attention:{default:e.get("sapUiNegativeText")},good:{default:e.get("sapUiPositiveText")},warning:{default:e.get("sapUiCriticalText")}}}}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/adaptivecards/overwrites/ActionRender", ["sap/ui/integration/thirdparty/adaptivecards"],function(t){"use strict";return function(e){if(e===0){e="ac-pushButton"}var i=this.parent.hostConfig;var s=document.createElement("ui5-button");this.addCssClasses(s);s.setAttribute("aria-label",this.title);s.type="button";s.style.display="flex";s.style.alignItems="center";s.style.justifyContent="center";var n=this.style;if(n==="positive"){s.setAttribute("design","Positive")}else if(n==="destructive"){s.setAttribute("design","Negative")}var l=this.title;var a=document.createElement("div");a.style.overflow="hidden";a.style.textOverflow="ellipsis";if(!(i.actions.iconPlacement===t.ActionIconPlacement.AboveTitle||i.actions.allowTitleToWrap)){a.style.whiteSpace="nowrap"}if(l){a.innerText=this.title}if(!this.iconUrl){s.classList.add("noIcon");s.appendChild(a)}else{var o=document.createElement("img");o.src=this.iconUrl;o.style.width=i.actions.iconSize+"px";o.style.height=i.actions.iconSize+"px";o.style.flex="0 0 auto";if(i.actions.iconPlacement===t.ActionIconPlacement.AboveTitle){s.classList.add("iconAbove");s.style.flexDirection="column";if(l){o.style.marginBottom="4px"}}else{s.classList.add("iconLeft");if(l){o.style.marginRight="4px"}}s.appendChild(o);s.appendChild(a)}this._renderedElement=s}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/adaptivecards/overwrites/inputsGeneralOverwrites", ["sap/ui/core/InvisibleText","sap/ui/core/Core"],function(e,r){"use strict";var t={};t.overwriteRequired=function(t){var n=t._renderedInputControlElement.getAttribute("role");if(n==="radiogroup"){return}t.renderedInputControlElement.removeAttribute("aria-required");if(!n){t.renderedInputControlElement.required=t.isRequired;return}if(n==="group"&&t.isRequired){var i=new e({id:t._renderedInputControlElement.id+"-InvisibleText",text:r.getLibraryResourceBundle("sap.ui.integration").getText("ADAPTIVE_CARDS_REQUIRED_FIELD")}).toStatic().getId();t.renderedInputControlElement.setAttribute("aria-describedby",i)}};t.overwriteLabel=function(e){if(!e._renderedLabelElement){return}var r=document.createElement("ui5-label");r.id=e._renderedLabelElement.id;r.innerText=e.label;r.for=e._renderedInputControlElement.id;r.required=e.isRequired;r.style.marginBottom=e.hostConfig.getEffectiveSpacing(e.hostConfig.inputs.label.inputSpacing)+"px";e._renderedLabelElement.remove();e._renderedLabelElement=r;e._outerContainerElement.insertBefore(e._renderedLabelElement,e.inputControlContainerElement)};t.overwriteAriaLabelling=function(e,r){if(!e._renderedInputControlElement){return}if(e._renderedLabelElement){e._renderedInputControlElement.setAttribute(r,e._renderedLabelElement.id)}else{e._renderedInputControlElement.removeAttribute(r)}};t.createValueStateElement=function(e,r){if(!e.errorMessage){return}var t=document.createElement("div");t.setAttribute("slot","valueStateMessage");t.innerText=e.errorMessage;r.appendChild(t)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/filters/BaseFilter", ["sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/InvisibleText","sap/base/Log","sap/ui/core/Icon","sap/m/HBox","sap/m/Text","sap/ui/integration/model/ObservableModel","sap/ui/integration/util/LoadingProvider"],function(t,e,i,a,r,o,n,s,d){"use strict";var l=t.extend("sap.ui.integration.cards.filters.BaseFilter",{metadata:{abstract:true,library:"sap.ui.integration",properties:{key:{type:"string",defaultValue:""},config:{type:"object",defaultValue:"null"},value:{type:"object",defaultValue:null}},aggregations:{_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},_label:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:{apiVersion:2,render:function(t,e){var i=e.isLoading();t.openStart("div",e).class("sapFCardFilter");if(i){t.class("sapFCardFilterLoading")}t.openEnd();if(e._hasError()){t.renderControl(e._getErrorMessage())}else{t.renderControl(e.getField())}t.close("div")}}});l.prototype.init=function(){this.setAggregation("_loadingProvider",new d);this.attachEventOnce("_dataReady",function(){this.fireEvent("_ready")})};l.prototype.exit=function(){if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null}};l.prototype.isLoading=function(){var t=this.getAggregation("_loadingProvider");return t.getLoading()};l.prototype.getField=function(){return null};l.prototype.createLabel=function(t){if(t.label){this.setAggregation("_label",new i({text:t.label}).toStatic());return this.getAggregation("_label")}return null};l.prototype.showLoadingPlaceholders=function(){if(!this._isDataProviderJson()){this.getAggregation("_loadingProvider").setLoading(true)}};l.prototype.hideLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(false)};l.prototype.onDataChanged=function(){};l.prototype.setValueFromOutside=function(t){};l.prototype.getValueForModel=function(){};l.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate()}};l.prototype.getCardInstance=function(){return e.byId(this.getCard())};l.prototype._hasError=function(){return!!this._bError};l.prototype._getErrorMessage=function(){var t=e.getLibraryResourceBundle("sap.ui.integration").getText("CARD_FILTER_DATA_LOAD_ERROR");return new o({justifyContent:"Center",alignItems:"Center",items:[new r({src:"sap-icon://message-error",size:"1rem"}).addStyleClass("sapUiTinyMargin"),new n({text:t})]})};l.prototype._handleError=function(t){a.error(t);this._bError=true;this.invalidate()};l.prototype._onDataRequestComplete=function(){this.fireEvent("_dataReady");this.hideLoadingPlaceholders()};l.prototype._setDataConfiguration=function(t){var e=this.getCardInstance(),i;if(!t){this.fireEvent("_dataReady");return}if(this._oDataProvider){this._oDataProvider.destroy()}this._oDataProvider=e.getDataProviderFactory().create(t,null,true);if(t.name){i=e.getModel(t.name)}else if(this._oDataProvider){i=new s;i.setSizeLimit(e.getModelSizeLimit());this.setModel(i)}if(!i){this.fireEvent("_dataReady");return}i.attachEvent("change",function(){this.onDataChanged()}.bind(this));if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.showLoadingPlaceholders()}.bind(this));this._oDataProvider.attachDataChanged(function(t){i.setData(t.getParameter("data"));this._onDataRequestComplete()}.bind(this));this._oDataProvider.attachError(function(t){this._handleError(t.getParameter("message"));this._onDataRequestComplete()}.bind(this));this._oDataProvider.triggerDataUpdate()}else{this.fireEvent("_dataReady")}};l.prototype._syncValue=function(){var t=this.getValueForModel(),e=this.getCardInstance(),i={},a;this.setValue(t);if(e){a="/sap.card/configuration/filters/"+this.getKey()+"/value";i[a]=t.value;e._fireConfigurationChange(i);e.resetPaginator()}};l.prototype._isDataProviderJson=function(){return this._oDataProvider&&this._oDataProvider.getSettings()&&this._oDataProvider.getSettings()["json"]};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/filters/DateRangeFilter", ["./BaseFilter","sap/base/Log","sap/ui/core/library","sap/ui/integration/util/DateRangeHelper"],function(e,t,a,r){"use strict";var i=a.ValueState;var n=e.extend("sap.ui.integration.cards.filters.DateRangeFilter",{metadata:{library:"sap.ui.integration",aggregations:{_ddr:{type:"sap.m.DynamicDateRange",multiple:false,visibility:"hidden"}}},renderer:{apiVersion:2}});n.prototype.getField=function(){return this._getDdr()};n.prototype.setValueFromOutside=function(e){t.error("Setting a filter value programatically on a DateRangeFilter is currently unsupported.",null,"sap.ui.integration.widgets.Card")};n.prototype.getValueForModel=function(){return r.getValueForModel(this._getDdr())};n.prototype._getDdr=function(){var e=this.getAggregation("_ddr");if(!e){e=this._createDdr();this.setAggregation("_ddr",e)}return e};n.prototype._createDdr=function(){var e=Object.assign({},this.getConfig());e.options=e.options||this._getDefaultOptions();var t=r.createInput(e,this.getCardInstance(),false);t.addStyleClass("sapFCardDateRangeField");t.attachChange(function(e){if(e.getParameter("valid")){t.setValueState(i.None);this._syncValue()}else{t.setValueState(i.Error)}}.bind(this));var a=this.createLabel(e);if(a){t.addAriaLabelledBy(a)}return t};n.prototype._getDefaultOptions=function(){return["date","today","dateRange","from","to","lastDays","nextDays","lastWeeks","nextWeeks"]};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/filters/FilterBar", ["sap/ui/base/ManagedObjectObserver","sap/ui/core/Control"],function(e,t){"use strict";var i=t.extend("sap.ui.integration.cards.filters.FilterBar",{metadata:{library:"sap.ui.integration",properties:{},aggregations:{content:{type:"sap.ui.core.Control",multiple:false}}},renderer:{apiVersion:2,render:function(e,t){var i=t._getFilters().some(function(e){return e.getVisible()});if(!i){return}e.openStart("div",t).class("sapFCardFilterBar").openEnd();e.renderControl(t.getContent());e.close("div")}}});i.prototype.init=function(){this._mObservers=new Map;this._oAggregationObserver=new e(this._onContentAggregationChange.bind(this));this._fnFilterVisibilityChangeHandler=this._onFilterVisibilityChange.bind(this);this._fnObserveFilter=this._observeFilter.bind(this);this._oAggregationObserver.observe(this,{aggregations:["content"]})};i.prototype.exit=function(){this._oAggregationObserver.disconnect();delete this._oAggregationObserver;this._mObservers.forEach(function(e){e.disconnect()});this._mObservers.clear();delete this._mObservers;delete this._fnFilterVisibilityChangeHandler;delete this._fnObserveFilter};i.prototype._onContentAggregationChange=function(e){if(e.mutation==="remove"){this._mObservers.forEach(function(e){e.disconnect()});this._mObservers.clear();return}var t=e.child,i="items";if(t.isA("sap.ui.layout.AlignedFlowLayout")){i="content"}if(e.mutation==="insert"){t.getAggregation(i).forEach(this._fnObserveFilter)}};i.prototype._observeFilter=function(t){var i=t.getParent().getId(),r=new e(this._fnFilterVisibilityChangeHandler);r.observe(t,{properties:["visible"]});this._mObservers.set(i,r)};i.prototype._onFilterVisibilityChange=function(){this.invalidate()};i.prototype.showLoadingPlaceholders=function(){this._getFilters().forEach(function(e){e.showLoadingPlaceholders()})};i.prototype.hideLoadingPlaceholders=function(){this._getFilters().forEach(function(e){e.hideLoadingPlaceholders()})};i.prototype.refreshData=function(){this._getFilters().forEach(function(e){e.refreshData()})};i.prototype._getFilters=function(){var e=this.getContent();if(!e||!e.isA(["sap.m.FlexBox","sap.ui.layout.AlignedFlowLayout"])){return[]}return e.getItems?e.getItems():e.getContent()};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/filters/FilterBarFactory", ["./FilterBar","./SearchFilter","./SelectFilter","./DateRangeFilter","sap/ui/base/Object","sap/m/library","sap/m/HBox","sap/ui/layout/AlignedFlowLayout"],function(e,t,a,r,n,i,s,l){"use strict";var o=i.FlexWrap;var u=i.FlexRendertype;var c=n.extend("sap.ui.integration.util.FilterBarFactory",{metadata:{library:"sap.ui.integration"},constructor:function(e){n.call(this);this._oCard=e}});c.prototype.create=function(t,a){var r=[],n=[],i,c,d,p,f=null;for(c in t){i=t[c];f=this._getClass(i.type);d=new f({card:this._oCard,key:c,config:i,value:{model:"filters",path:"/"+c},visible:i.visible});a.setProperty("/"+c,d.getValueForModel());this._awaitEvent(n,d,"_ready");d._setDataConfiguration(i.data);r.push(d)}if(!r.length){return null}if(r.length>1){p=new l({content:r,minItemWidth:"10rem",maxItemWidth:"20rem"});r.forEach(function(e){e.getField().setWidth("100%")});p.addStyleClass("sapFCardFilterBarAFLayout")}else{p=new s({wrap:o.Wrap,renderType:u.Bare,items:r})}p.addStyleClass("sapFCardFilterBarContent");var h=new e({content:p});Promise.all(n).then(function(){h.fireEvent("_filterBarDataReady")});return h};c.prototype._awaitEvent=function(e,t,a){e.push(new Promise(function(e){t.attachEventOnce(a,function(){e()})}))};c.prototype._getClass=function(e){e=e||"select";switch(e.toLowerCase()){case"string":case"integer":case"select":return a;case"daterange":return r;case"search":return t;default:return undefined}};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/filters/SearchFilter", ["./BaseFilter","sap/m/SearchField"],function(e,t){"use strict";var i=e.extend("sap.ui.integration.cards.filters.SearchFilter",{metadata:{library:"sap.ui.integration",aggregations:{_searchField:{type:"sap.m.SearchField",multiple:false,visibility:"hidden"}}},renderer:{apiVersion:2}});i.prototype.getField=function(){return this._getSearchField()};i.prototype.setValueFromOutside=function(e){this._getSearchField().setValue(e);this._syncValue()};i.prototype.getValueForModel=function(){return{value:this._escapeDoubleQuotes(this._getSearchField().getValue())}};i.prototype._getSearchField=function(){var e=this.getAggregation("_searchField");if(!e){e=this._createSearchField();this.setAggregation("_searchField",e)}return e};i.prototype._createSearchField=function(){var e=this.getConfig();var i=new t({value:e.value,placeholder:e.placeholder});var a=this.createLabel(e);if(a){i.addAriaLabelledBy(a)}i.attachChange(function(){this._syncValue()}.bind(this));return i};i.prototype._escapeDoubleQuotes=function(e){return e.replaceAll('"','\\"')};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/filters/SelectFilter", ["./BaseFilter","sap/m/Select","sap/ui/core/ListItem","sap/ui/model/json/JSONModel","sap/ui/integration/util/BindingResolver","sap/base/util/merge"],function(e,t,i,a,l,r){"use strict";var s=e.extend("sap.ui.integration.cards.filters.SelectFilter",{metadata:{library:"sap.ui.integration",aggregations:{_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}}},renderer:{apiVersion:2}});s.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy()}};s.prototype.getField=function(){return this._getSelect()};s.prototype.onDataChanged=function(){var e=this._getSelect();e.setSelectedKey(this.getValue().value);this._syncValue()};s.prototype.getValueForModel=function(){var e=this._getSelect().getSelectedItem();if(e){return{value:e.getKey(),selectedItem:{title:e.getText(),key:e.getKey()}}}return{value:this._getSelect().getSelectedKey()}};s.prototype.setValueFromOutside=function(e){this._getSelect().setSelectedKey(l.resolveValue(e,this.getCardInstance()));this._syncValue()};s.prototype.getStaticConfiguration=function(){var e=this.getConfig();var t="/";var i;var a=[];var s;if(e.item&&e.item.path){t=e.item.path}i=this.getModel().getProperty(t);if(e.item&&e.item.template){s=e.item.template;a=i.map(function(e,i){var a=t==="/"?t+i:t+"/"+i;return l.resolveValue(s,this,a)}.bind(this))}else{a=i}a=a.map(function(e){return{key:e.key&&e.key.toString(),title:e.title&&e.title.toString()}});var n=r({},e);delete n.item;n.items=a;n.value=this.getValueForModel().value;return n};s.prototype._getSelect=function(){var e=this.getAggregation("_select");if(!e){e=this._createSelect();this.setAggregation("_select",e)}return e};s.prototype._createSelect=function(){var e=new t,r=this.getCardInstance(),s,n,o="/",p=this.getConfig(),u=this.createLabel(p),c;e.attachChange(function(e){this._syncValue()}.bind(this));if(p&&p.item){o=p.item.path||o}if(p&&p.item&&p.item.template){s=p.item.template.key;n=p.item.template.title}if(p&&p.items){s="{key}";n="{title}";c=new a(p.items);c.setSizeLimit(r.getModelSizeLimit());this.setModel(c)}this._oItemTemplate=new i({key:s,text:n});e.bindItems({path:o,template:this._oItemTemplate});e.setSelectedKey(l.resolveValue(p.value,r));if(u){e.addAriaLabelledBy(u)}return e};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/list/MicrochartsResizeHelper", ["sap/ui/base/Object","sap/ui/core/ResizeHandler","sap/ui/base/ManagedObjectObserver"],function(e,i,t){"use strict";var s=e.extend("sap.ui.integration.cards.list.MicrochartsResizeHelper",{constructor:function(i){e.call(this);this._oItemDelegate={onAfterRendering:this._onAfterItemRendering};this._oList=i;this._oItemsObserver=new t(this._onItemChange.bind(this));this._oItemsObserver.observe(i,{aggregations:["items"]})}});s.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments);if(this._iMicrochartsResizeHandler){i.deregister(this._iMicrochartsResizeHandler);this._iMicrochartsResizeHandler=undefined}if(this._iResizeMicrochartsTimeout){clearTimeout(this._iResizeMicrochartsTimeout);this._iResizeMicrochartsTimeout=null}this._oItemsObserver=null;this._oItemDelegate=null};s.prototype._onItemChange=function(e){if(e.name!=="items"||!e?.child?.getMicrochart?.()){return}if(e.mutation==="insert"){e.child.getMicrochart().addEventDelegate(this._oItemDelegate,this)}else if(e.mutation==="remove"){e.child.getMicrochart().removeEventDelegate(this._oItemDelegate,this)}};s.prototype._onAfterItemRendering=function(){this._scheduleResizeMicrocharts()};s.prototype._scheduleResizeMicrocharts=function(){if(this._iResizeMicrochartsTimeout){clearTimeout(this._iResizeMicrochartsTimeout);this._iResizeMicrochartsTimeout=null}this._iResizeMicrochartsTimeout=setTimeout(function(){this._resizeMicrocharts()}.bind(this),0)};s.prototype._resizeMicrocharts=function(){var e=this._oList.$().find(".sapUiIntMicrochartChart"),t=Number.MAX_VALUE;if(e.length===0){return}e.each(function(e,i){t=Math.min(t,i.offsetWidth)});e.find(".sapUiIntMicrochartChartInner").css("max-width",t+"px");if(!this._iMicrochartsResizeHandler){this._iMicrochartsResizeHandler=i.register(this._oList,this._resizeMicrocharts.bind(this))}};return s});
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/ActionsStrip", ["../library","sap/m/library","sap/ui/core/Core","sap/ui/core/Control","sap/ui/integration/cards/actions/CardActions","sap/ui/integration/util/BindingHelper","sap/m/Button","sap/ui/integration/controls/LinkWithIcon","sap/m/OverflowToolbarButton","sap/m/OverflowToolbar","sap/m/OverflowToolbarLayoutData","sap/m/ToolbarSpacer"],function(t,e,a,o,i,n,r,s,l,p,u,c){"use strict";var b=e.ToolbarStyle;var d=e.ToolbarDesign;var f=t.CardActionArea;var g=o.extend("sap.ui.integration.controls.ActionsStrip",{metadata:{library:"sap.ui.integration",properties:{disableItemsInitially:{type:"boolean",defaultValue:false}},aggregations:{_toolbar:{type:"sap.m.OverflowToolbar",multiple:false}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e).class("sapUiIntActionsStrip").openEnd();t.renderControl(e._getToolbar());t.close("div")}}});g.prototype._getToolbar=function(){var t=this.getAggregation("_toolbar");if(!t){t=new p({style:b.Clear,design:d.Transparent});this.setAggregation("_toolbar",t)}return t};g.prototype._initButtons=function(t){if(!t||!t.length){return null}var e=this._getToolbar(),o=a.byId(this.getCard()),r=new i({card:o}),s=false,l;this._oActions=r;t=n.createBindingInfos(t,o.getBindingNamespaces());t.forEach(function(t){if(t.type==="ToolbarSpacer"){s=true;e.addContent(new c);return}var a=t.actions,o=new u({group:t.overflowGroup,priority:t.overflowPriority}),i;switch(t.type){case"Link":i=this._createLink(t);break;case"Button":default:i=this._createButton(t);break}i.setLayoutData(o);l={area:f.ActionsStrip,control:i,actions:a,enabledPropertyName:"enabled"};if(this.getDisableItemsInitially()){l.enabledPropertyValue=false;i._mActionsConfig=l;i._bIsDisabled=true}r.attach(l);e.addContent(i)}.bind(this));if(!s){e.insertContent(new c,0)}};g.prototype.disableItems=function(){var t=this._getToolbar().getContent();t.forEach(function(t){if(t.setEnabled&&!t._bIsDisabled){t.setEnabled(false);t._bIsDisabled=true}})};g.prototype.enableItems=function(){var t=this._getToolbar().getContent(),e=this._oActions,a;t.forEach(function(t){if(t.setEnabled&&t._bIsDisabled){a=t._mActionsConfig;if(a.action){a.enabledPropertyValue=true;e._setControlEnabledState(a)}else{t.setEnabled(true)}delete t._bIsDisabled}})};g.prototype._createLink=function(t){var e=new s({icon:t.icon,text:t.text,tooltip:t.tooltip,ariaHasPopup:t.ariaHasPopup,emphasized:t.emphasized,visible:t.visible});return e};g.prototype._createButton=function(t){var e;if(t.icon){e=new l({icon:t.icon,text:t.text||t.tooltip,tooltip:t.tooltip||t.text,type:t.buttonType,ariaHasPopup:t.ariaHasPopup,visible:t.visible});return e}e=new r({text:t.text,tooltip:t.tooltip,type:t.buttonType,ariaHasPopup:t.ariaHasPopup,visible:t.visible});return e};g.create=function(t,e,a){if(!e){return null}var o=new g({card:t,disableItemsInitially:a});o._initButtons(e);return o};return g});
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/ActionsToolbar", ["./ActionsToolbarRenderer","sap/base/strings/capitalize","sap/ui/core/Control","sap/m/library","sap/ui/core/library","sap/m/Button","sap/m/ActionSheet","sap/ui/base/ManagedObjectObserver","sap/ui/core/Core","sap/ui/integration/cards/actions/CardActions"],function(t,e,i,n,o,s,r,a,c,u){"use strict";var p=n.ButtonType;var g=o.aria.HasPopup;function h(t,e,i,n){return new Promise(function(o){var s;if(typeof i==="function"){s=i(n);if(s instanceof Promise){s.then(function(i){t.setProperty(e,i);o()});return}}else{s=i}t.setProperty(e,s);o()})}var l=i.extend("sap.ui.integration.controls.ActionsToolbar",{metadata:{library:"sap.ui.integration",properties:{},aggregations:{actionDefinitions:{type:"sap.ui.integration.ActionDefinition",multiple:true},_toolbar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_actionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"}}},renderer:t});l.prototype.init=function(){this.setAggregation("_actionSheet",new r);this._aActions=[];this._mActionObservers=new Map;this._oObserver=new a(this._observeActionsAggregation.bind(this));this._oObserver.observe(this,{aggregations:["actionDefinitions"]})};l.prototype.exit=function(){this._oCard=null;this._aActions=null;this._oObserver.disconnect();this._oObserver=null;this._mActionObservers.clear();this._mActionObservers=null};l.prototype.onBeforeRendering=function(){this._updateVisibility()};l.prototype.initializeContent=function(t){var e=this,i,n=[],o=[],s=this.getAggregation("_actionSheet"),r=t.getHostInstance(),a=t.getAggregation("_extension");if(r){o=o.concat(r.getActions()||[])}if(a){o=o.concat(a.getActions()||[])}this._aActions=o;o.forEach(function(t){i=e._createActionButton(t,false);n.push(i)});if(this._aButtons){this._aButtons.forEach(function(t){t.destroy()})}n.forEach(s.addButton,s);this._aButtons=n;this._refreshButtons().then(this._updateVisibility.bind(this))};l.prototype.setCard=function(t){this._oCard=t};l.prototype._open=function(){this._refreshButtons().then(function(){this.getAggregation("_actionSheet").openBy(this._getToolbar())}.bind(this))};l.prototype._getToolbar=function(){var t=c.getLibraryResourceBundle("sap.ui.integration");var e=this.getAggregation("_toolbar");if(!e){e=new s({id:this.getId()+"-overflowButton",icon:"sap-icon://overflow",type:p.Transparent,ariaHasPopup:g.Menu,tooltip:t.getText("CARD_ACTIONS_OVERFLOW_BUTTON_TOOLTIP"),press:function(t){this._open()}.bind(this)});this.setAggregation("_toolbar",e)}return e};l.prototype._refreshButtons=function(){var t=this._aActions,e=this._oCard,i=this._aButtons,n,o,s,r=[];for(s=0;s<t.length;s++){n=t[s];o=i[s];r.push(h(o,"enabled",n.enabled,e));r.push(h(o,"visible",n.visible,e))}return Promise.all(r)};l.prototype._createActionButton=function(t,e){var i=e?this._getActionConfig(t):t;var n=new s({icon:i.icon,text:i.text,tooltip:i.tooltip,type:i.buttonType,visible:e?i.visible:false,press:function(i){var n=e?this._getActionConfig(t):t;u.fireAction({card:this._oCard,host:this._oCard.getHostInstance(),action:n,parameters:n.parameters,source:i.getSource()})}.bind(this)});if(e){n.setEnabled(i.enabled)}return n};l.prototype._updateVisibility=function(){var t=this.getAggregation("_actionSheet").getButtons().some(function(t){return t.getVisible()});this.setVisible(t)};l.prototype._getActionConfig=function(t){var i=["visible","enabled","icon","text","tooltip","parameters","buttonType","type"].reduce(function(i,n){i[n]=t["get"+e(n)]();return i},{});i.action=function(){t.firePress()};return i};l.prototype._observeActionsAggregation=function(t){var e=t.child;if(t.mutation==="insert"){var i=this._createActionButton(e,true);this.getAggregation("_actionSheet").insertButton(i,this.indexOfActionDefinition(e));e.setAssociation("_menuButton",i);var n=new a(this._observeSingleAction.bind(this));n.observe(e,{properties:true,aggregations:["tooltip"]});this._mActionObservers.set(e.getId(),n);this._updateVisibility()}else if(t.mutation==="remove"){c.byId(e.getAssociation("_menuButton")).destroy();this._mActionObservers.get(e.getId()).disconnect();this._mActionObservers.delete(e.getId())}};l.prototype._observeSingleAction=function(t){var i=t.object,n=t.name,o=c.byId(i.getAssociation("_menuButton")),s=t.current;if(["type","parameters"].indexOf(n)!==-1){return}if(t.type==="aggregation"){s=t.child}if(n==="buttonType"){n="type"}o["set"+e(n)](s);this._updateVisibility()};l.prototype.setEnabled=function(t){var e=this._getToolbar();if(t){e.setEnabled(true)}else{this.getAggregation("_actionSheet").close();e.setEnabled(false)}};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/controls/ActionsToolbarRenderer", [],function(){"use strict";var n={apiVersion:2};n.render=function(n,e){n.openStart("div",e).class("sapUiIntActionsToolbar").openEnd();n.renderControl(e._getToolbar());n.close("div")};return n},true);
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/BlockingMessage", ["../library","sap/base/Log","sap/m/Bar","sap/m/Button","sap/m/Dialog","sap/m/IllustratedMessage","sap/m/IllustratedMessageType","sap/m/IllustratedMessageSize","sap/m/Title","sap/m/Text","sap/ui/Device","sap/ui/core/Core","sap/ui/core/Configuration","sap/ui/core/Control","sap/ui/core/library"],function(e,t,i,a,s,n,r,o,l,p,g,u,d,c,f){"use strict";var y=f.TitleLevel;var C=e.CardBlockingMessageType;var T=c.extend("sap.ui.integration.controls.BlockingMessage",{metadata:{library:"sap.ui.integration",properties:{type:{type:"sap.ui.integration.CardBlockingMessageType",defaultValue:C.Information},height:{type:"sap.ui.core.CSSSize",defaultValue:""},illustrationType:{type:"string",defaultValue:"ErrorScreen"},illustrationSize:{type:"sap.m.IllustratedMessageSize",defaultValue:o.Auto},title:{type:"string",defaultValue:""},description:{type:"string",defaultValue:""},details:{type:"string",defaultValue:""},httpResponse:{type:"object",defaultValue:null}},aggregations:{_illustratedMessage:{type:"sap.m.IllustratedMessage",multiple:false}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t).class("sapUiIntBlockingMsg");if(t.getHeight()){e.style("height",t.getHeight())}e.openEnd();e.renderControl(t.getAggregation("_illustratedMessage"));e.close("div")}}});T.create=function(e,i){var a=e.illustrationType,s=e.illustrationSize||o.Auto,n="100%",l=e.title,p=e.description,g=e.details;if(e.type===C.Error){a=a||r.ErrorScreen}else if(e.type===C.NoData){a=a||r.NoData}i._oContentMessage={type:e.type===C.NoData?"noData":"error",illustrationType:a,illustrationSize:s,title:l,description:p,details:g};if(i.getCardContent()&&i.getCardContent().getDomRef()){n=i.getCardContent().getDomRef().offsetHeight+"px"}var u=new T({type:e.type,height:n,illustrationType:a,illustrationSize:s,title:l,description:p,httpResponse:e.httpResponse});if(g&&d.getDebug()){u.setDetails(g)}else if(g){t.error(g)}return u};T.prototype.init=function(){this.setAggregation("_illustratedMessage",new n({enableDefaultTitleAndDescription:false,enableVerticalResponsiveness:true}))};T.prototype.onBeforeRendering=function(){var e=this.getAggregation("_illustratedMessage");e.setIllustrationType(this.getIllustrationType()).setIllustrationSize(this.getIllustrationSize()).setTitle(this.getTitle()).setDescription(this.getDescription()).destroyAdditionalContent();if(this.getDetails()){e.addAdditionalContent(this._getAdditionalContent())}};T.prototype._getAdditionalContent=function(){var e=u.getLibraryResourceBundle("sap.ui.integration");return new a({text:e.getText("CARD_BUTTON_SHOW_MORE"),press:function(){var t=new p({renderWhitespace:true,text:this.getDetails()}).addStyleClass("sapUiSmallMargin");var n=new s({stretch:g.system.phone,customHeader:new i({contentMiddle:new l({text:e.getText("CARD_ERROR_DIALOG_TITLE"),level:y.H1}),contentRight:new a({icon:"sap-icon://copy",tooltip:e.getText("CARD_TEXT_COPY"),press:function(){var e=document.createRange(),i=t.getDomRef();e.selectNode(i);window.getSelection().removeAllRanges();window.getSelection().addRange(e);window.navigator.clipboard.writeText(i.textContent)}})}),content:[t],buttons:[new a({text:e.getText("CARD_DIALOG_CLOSE_BUTTON"),press:function(){n.close()}})],afterClose:function(){n.destroy()}});n.open()}.bind(this)})};return T});
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/LinkWithIcon", ["./LinkWithIconRenderer","sap/ui/integration/library","sap/m/Link","sap/ui/core/Icon"],function(e,i,t,n){"use strict";var o=t.extend("sap.ui.integration.controls.LinkWithIcon",{metadata:{library:"sap.ui.integration",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""}},aggregations:{_icon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}},renderer:e});o.prototype.onBeforeRendering=function(){t.prototype.onBeforeRendering.apply(this,arguments);if(this.getIcon()){this._getIcon().setSrc(this.getIcon())}this.addStyleClass("sapUiIntCardLinkWithIcon")};o.prototype._getIcon=function(){var e=this.getAggregation("_icon");if(!e){e=new n;this.setAggregation("_icon",e)}return e};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/controls/LinkWithIconRenderer", ["sap/ui/integration/library","sap/ui/core/Renderer","sap/m/LinkRenderer"],function(e,r,n){"use strict";var i=r.extend(n);i.apiVersion=2;i.renderText=function(e,r){var i=r.getAggregation("_icon");if(i){e.renderControl(i)}n.renderText.apply(this,arguments)};return i},true);
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/ListContentItem", ["sap/ui/integration/library","./ListContentItemRenderer","sap/ui/integration/controls/ObjectStatus","sap/m/library","sap/m/Avatar","sap/m/AvatarShape","sap/m/AvatarSize","sap/m/ListItemBase","sap/ui/core/Core","sap/ui/core/library","sap/ui/integration/util/BindingResolver"],function(t,e,i,a,s,n,o,r,l,u,p){"use strict";var c=t.AttributesLayoutType;var g=u.ValueState;var h=a.EmptyIndicatorMode;var f=a.AvatarImageFitType;var y=r.extend("sap.ui.integration.controls.ListContentItem",{metadata:{library:"sap.ui.integration",properties:{title:{type:"string",group:"Misc",defaultValue:null},description:{type:"string",group:"Misc",defaultValue:null},descriptionVisible:{type:"boolean",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconAlt:{type:"string",defaultValue:""},iconDisplayShape:{type:"sap.m.AvatarShape",defaultValue:n.Square},iconInitials:{type:"string",defaultValue:""},iconSize:{type:"sap.m.AvatarSize",defaultValue:o.XS},iconBackgroundColor:{type:"sap.m.AvatarColor"},iconVisible:{type:"boolean",defaultValue:true},info:{type:"string",group:"Misc",defaultValue:null},infoVisible:{type:"boolean",defaultValue:true},infoState:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:g.None},showInfoStateIcon:{type:"boolean",defaultValue:false},customInfoStatusIcon:{type:"string",group:"Misc",defaultValue:null},attributesLayoutType:{type:"sap.ui.integration.AttributesLayoutType",defaultValue:c.TwoColumns}},aggregations:{microchart:{type:"sap.ui.integration.controls.Microchart",multiple:false},actionsStrip:{type:"sap.ui.integration.controls.ActionsStrip",multiple:false},attributes:{type:"sap.m.ObjectStatus",multiple:true},_avatar:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"},_objectStatus:{type:"sap.m.ObjectStatus",multiple:false,visibility:"hidden"}}},renderer:e});y.getPlaceholderInfo=function(t){const e=t?.attributes?.filter(function(t){return t.hasOwnProperty("visible")?t.visible:true});const i=t?.icon?.hasOwnProperty("visible")?t?.icon.visible:!!t?.icon;return{hasIcon:i,attributesLength:e?e.length:0,hasChart:!!t?.chart,hasActionsStrip:!!(t?.actionsStrip?.length>0),hasDescription:!!t?.description}};y.getLinesCount=function(t,e){let i=1;const a=p.resolveValue(t,e);const s=y.getPlaceholderInfo(a);const n=a.description?.hasOwnProperty("visible")?a.description?.visible:true;if(a.description&&n){i+=1}const o=s.attributesLength;if(a.attributesLayoutType===c.OneColumn){i+=o}else{i+=Math.ceil(o/2)}const r=a.chart?.hasOwnProperty("visible")?a.chart?.visible:true;if(a.chart&&r){i+=1}return i};y.prototype.onBeforeRendering=function(){r.prototype.onBeforeRendering.apply(this,arguments);if(this.isPropertyInitial("iconSize")){if(this.getLinesCount()===1){this._getAvatar().setDisplaySize(o.XS)}else{this._getAvatar().setDisplaySize(o.S)}}else{this._getAvatar().setDisplaySize(this.getIconSize())}};y.prototype.getLinesCount=function(){var t=1;if(this.getDescription()&&this.getDescriptionVisible()){t+=1}if(this.getAttributesLayoutType()===c.OneColumn){t+=this._getVisibleAttributes().length}else{t+=Math.ceil(this._getVisibleAttributes().length/2)}if(this.getMicrochart()&&this.getMicrochart().getVisible()){t+=1}return t};y.prototype.getContentAnnouncement=function(){var t=this.getInfoState(),e=this.getTitle(),i=this.getDescription(),a=[],s=this.getInfo(),n=l.getLibraryResourceBundle("sap.m");if(e){a.push(e)}if(i){a.push(i)}if(s){a.push(s)}if(t!=g.None&&t!==this.getHighlight()){a.push(n.getText("LIST_ITEM_STATE_"+t.toUpperCase()))}return a.join(" . ").trim()};y.prototype._getAvatar=function(){var t=this.getAggregation("_avatar");if(!t){t=new s({imageFitType:f.Contain}).addStyleClass("sapFCardIcon");this.setAggregation("_avatar",t)}t.setSrc(this.getIcon()).setDisplayShape(this.getIconDisplayShape()).setTooltip(this.getIconAlt()).setInitials(this.getIconInitials()).setBackgroundColor(this.getIconBackgroundColor()).setVisible(this.getIconVisible());return t};y.prototype._getObjectStatus=function(){var t=this.getAggregation("_objectStatus");if(!t){t=new i;this.setAggregation("_objectStatus",t)}t.setText(this.getInfo()).setState(this.getInfoState()).setShowStateIcon(this.getShowInfoStateIcon()).setIcon(this.getCustomInfoStatusIcon()).setEmptyIndicatorMode(h.On);return t};y.prototype._getVisibleAttributes=function(){return this.getAttributes().filter(function(t){return t.getVisible()})};return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/controls/ListContentItemRenderer", ["sap/ui/integration/library","sap/ui/core/Renderer","sap/ui/core/IconPool","sap/m/ListItemBaseRenderer"],function(e,t,n,i){"use strict";var s=t.extend(i);s.apiVersion=2;var r=e.AttributesLayoutType;s.renderLIAttributes=function(e,t){e.class("sapUiIntLCI");var i=t.getLinesCount(),s=t.getIcon();if(i===1){e.class("sapUiIntLCIOneLine");if(s&&!n.isIconURI(s)){e.class("sapUiIntLCIThumbnail")}}else if(i===2){e.class("sapUiIntLCITwoLines")}else{e.class("sapUiIntLCIMultipleLines")}if(t.getActionsStrip()){e.class("sapUiIntLCIWithActionsStrip")}};s.renderLIContent=function(e,t){var n=t.getMicrochart();var i=t.getActionsStrip();e.openStart("div").class("sapUiIntLCIContent").openEnd();e.openStart("div").class("sapUiIntLCIIconAndLines").openEnd();if(!t.isPropertyInitial("icon")||!t.isPropertyInitial("iconInitials")){e.renderControl(t._getAvatar())}e.openStart("div").class("sapUiIntLCILines").openEnd();this.renderTitle(e,t);if(t.getDescription()&&t.getDescriptionVisible()){this.renderDescription(e,t)}this.renderItemAttributes(e,t);if(n){e.renderControl(n)}e.close("div");e.close("div");if(i){e.renderControl(i)}e.close("div")};s.renderTitle=function(e,t){var n=t.getTitle(),i=t.getInfo();e.openStart("div").class("sapUiIntLCITitleWrapper").openEnd();e.openStart("div").class("sapUiIntLCITitle").openEnd().text(n).close("div");if(i&&!t.getDescription()&&t.getInfoVisible()){this.renderInfo(e,t)}e.close("div")};s.renderDescription=function(e,t){var n=t.getDescription(),i=t.getInfo();e.openStart("div").class("sapUiIntLCIDescriptionWrapper").openEnd();e.openStart("div").class("sapUiIntLCIDescription").openEnd().text(n).close("div");if(i&&t.getInfoVisible()){this.renderInfo(e,t)}e.close("div")};s.renderInfo=function(e,t){var n=t._getObjectStatus();e.openStart("div").class("sapUiIntLCIInfo").openEnd();if(n){e.renderControl(n)}e.close("div")};s.renderItemAttributes=function(e,t){var n=t._getVisibleAttributes(),i=t.getAttributesLayoutType(),s=n.length,o;if(!s){return}for(o=0;o<s;o++){e.openStart("div").class("sapUiIntLCIAttrRow").openEnd();e.openStart("span").class("sapUiIntLCIAttrCell").openEnd();e.renderControl(n[o]);e.close("span");if(i===r.TwoColumns){o++;if(n[o]){e.openStart("span").class("sapUiIntLCIAttrCell").class("sapUiIntLCIAttrSecondCell").openEnd();e.renderControl(n[o]);e.close("span")}}e.close("div")}};return s},true);
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/Microchart", ["sap/m/library","sap/ui/core/Control","sap/ui/core/Core","sap/ui/base/DataType","sap/base/Log"],function(a,e,r,t,i){"use strict";var o,l,s,n;var u=a.ValueColor;function c(a){if(!a||typeof a!=="string"){return a}var e=t.getType("sap.m.ValueColor").isValid(a);if(!e){i.error("The value for stacked bar color must be a valid 'sap.m.ValueColor'. Given '"+a+"'.","sap.ui.integration.controls.Microchart");return null}return a}var p=e.extend("sap.ui.integration.controls.Microchart",{metadata:{library:"sap.ui.integration",properties:{displayValue:{type:"string"},valueColor:{type:"sap.m.ValueColor",defaultValue:u.Neutral}},aggregations:{chart:{type:"sap.ui.core.Control",multiple:false}}},renderer:{apiVersion:2,render:function(a,e){var r="sapUiIntMicrochartValue"+e.getValueColor();a.openStart("div",e).class("sapUiIntMicrochartChartWrapper").openEnd();a.openStart("div").class("sapUiIntMicrochartChart").openEnd();a.openStart("div").class("sapUiIntMicrochartChartInner").openEnd().renderControl(e.getChart()).close("div");a.close("div");a.openStart("div").class("sapMSLIInfo").class(r).openEnd().text(e.getDisplayValue()).close("div");a.close("div")}}});p.loadDependencies=function(){return new Promise(function(a,e){r.loadLibrary("sap.suite.ui.microchart",{async:true}).then(function(){sap.ui.require(["sap/suite/ui/microchart/BulletMicroChart","sap/suite/ui/microchart/BulletMicroChartData","sap/suite/ui/microchart/StackedBarMicroChart","sap/suite/ui/microchart/StackedBarMicroChartBar"],function(e,r,t,i){o=e;l=r;s=t;n=i;a()},function(a){e(a)})}).catch(function(){e("The usage of Microcharts is not available with this distribution.")})})};p.create=function(a){var e,r;if(a.type==="Bullet"){var t=[];if(a.thresholds){t=a.thresholds.map(function(a){return new l({value:a.value,color:a.color})})}r=new o({size:"Responsive",minValue:a.minValue,maxValue:a.maxValue,targetValue:a.target,showTargetValue:!!a.target,scaleColor:"Light",scale:a.scale,actual:new l({value:a.value,color:a.color}),thresholds:t});e=new p({valueColor:a.color,displayValue:a.displayValue,chart:r,visible:a.visible})}if(a.type==="StackedBar"){var i=a.bars.map(function(a){var e=c(a.color);return new n({value:a.value,displayValue:a.displayValue,valueColor:e})});r=new s({size:"Responsive",bars:i,maxValue:a.maxValue});e=new p({displayValue:a.displayValue,chart:r,visible:a.visible})}return e};return p});
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/MicrochartLegend", ["./MicrochartLegendRenderer","sap/m/Text","sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/theming/Parameters","sap/ui/integration/util/BindingHelper"],function(e,t,i,n,o,r){"use strict";var s=i.extend("sap.ui.integration.controls.MicrochartLegend",{metadata:{library:"sap.ui.integration",aggregations:{_titles:{type:"sap.m.Text",multiple:true,visibility:"hidden"}},associations:{chart:{type:"sap.ui.core.Control",multiple:false}},events:{colorsLoad:{}}},renderer:e});s.prototype.onBeforeRendering=function(){this._mLegendColors={};this._loadLegendColors()};s.prototype.onAfterRendering=function(){this._equalizeWidths()};s.prototype._equalizeWidths=function(){var e=this.$().children(".sapUiIntMicrochartLegendItem"),t=0;e.css("width","");e.each(function(){var e=this.getBoundingClientRect().width;if(e>t){t=e}});e.css("min-width",t+"px")};s.prototype.initItemsTitles=function(e,i){this.destroyAggregation("_titles");e.forEach(function(e,n){var o=r.prependRelativePaths(e.legendTitle,i+"/"+n);var s=new t({text:o});s.addEventDelegate({onAfterRendering:this._equalizeWidths},this);this.addAggregation("_titles",s)}.bind(this))};s.prototype._loadLegendColors=function(){var e=n.byId(this.getChart()),t=[],i;if(e){t=e._calculateChartData().filter(function(e){return e.color?.startsWith("sapUi")}).map(function(e){return e.color})}if(t.length>0){i=o.get({name:t,callback:function(e){this._handleColorsLoad(t,e)}.bind(this)})}if(this._mLegendColors!==undefined){this._handleColorsLoad(t,i)}};s.prototype._handleColorsLoad=function(e,t){if(typeof t==="string"){this._mLegendColors={};this._mLegendColors[e[0]]=t}else if(t){this._mLegendColors=t}this.fireColorsLoad()};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/controls/MicrochartLegendRenderer", ["sap/m/library","sap/ui/core/Core"],function(e,r){"use strict";var n=e.ValueColor;var o={apiVersion:2};o.render=function(e,n){var t=r.byId(n.getChart()),a=[],i=n.getAggregation("_titles");if(t){a=t._calculateChartData().map(function(e){return e.color})}e.openStart("div",n).class("sapUiIntMicrochartLegend").openEnd();a.forEach(function(r,t){e.openStart("div").class("sapUiIntMicrochartLegendItem").openEnd();e.openStart("div");o.addColor(e,n,r);e.openEnd().close("div");e.renderControl(i[t]);e.close("div")});e.close("div")};o.addColor=function(e,r,o){if(n[o]){e.class("sapUiIntMicrochartLegendItem"+o)}else{var t=r._mLegendColors[o]||o;e.style("background",t)}};return o},true);
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/ObjectStatus", ["sap/m/ObjectStatus","sap/m/ObjectStatusRenderer"],function(t,e){"use strict";var a=t.extend("sap.ui.integration.controls.ObjectStatus",{metadata:{library:"sap.ui.integration",properties:{showStateIcon:{type:"boolean",defaultValue:false}}},renderer:e});a.prototype.onBeforeRendering=function(){if(this.getShowStateIcon()){if(!this.getIcon()){this.addStyleClass("sapMObjStatusShowIcon")}else{this.addStyleClass("sapMObjStatusShowCustomIcon")}}};return a});
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/Paginator", ["../library","sap/ui/base/EventProvider","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/Configuration","sap/ui/core/Icon","./PaginatorRenderer"],function(t,e,i,n,a,s,o){"use strict";var r=i.getConfiguration().getAnimationMode(),d=r!==a.AnimationMode.none&&r!==a.AnimationMode.minimal,g=200,h=i.getLibraryResourceBundle("sap.m");var l=n.extend("sap.ui.integration.controls.Paginator",{metadata:{library:"sap.ui.integration",properties:{card:{type:"object"},pageNumber:{type:"int",defaultValue:0},pageCount:{type:"int",defaultValue:0},pageSize:{type:"int",defaultValue:0},totalCount:{type:"int"},skip:{type:"int"}},aggregations:{_prevIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_nextIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{animationComplete:{}}},renderer:o});l.create=function(t,e){if(!e){return null}return new l({card:t,totalCount:e.totalCount,pageSize:e.pageSize,skip:e.skip,visible:e.visible})};l.prototype.init=function(){this._listUpdateFinishedHandler=this._listUpdateFinished.bind(this);this._dataChangedHandler=this._dataChanged.bind(this);this.setAggregation("_prevIcon",new s({src:"sap-icon://slim-arrow-left",useIconTooltip:false,decorative:false,tooltip:h.getText("PAGINGBUTTON_PREVIOUS"),press:this.previous.bind(this)}));this.setAggregation("_nextIcon",new s({src:"sap-icon://slim-arrow-right",useIconTooltip:false,decorative:false,tooltip:h.getText("PAGINGBUTTON_NEXT"),press:this.next.bind(this)}))};l.prototype.exit=function(){var t=this.getCard(),i,n;if(t){if(this._dataChangedHandler){t.detachEvent("_contentDataChange",this._dataChangedHandler)}i=t.getCardContent();if(i){n=i.getAggregation("_content");if(n&&e.hasListener(n,"updateFinished",this._listUpdateFinishedHandler)){n.detachEvent("updateFinished",this._listUpdateFinishedHandler)}}}delete this._listUpdateFinishedHandler;delete this._iPreviousStartIndex;delete this._oClonedContent};l.prototype.isServerSide=function(){return this.getTotalCount()};l.prototype._dataChanged=function(){var t=this.getCard(),e=t.getCardContent();if(!e||!e.isA("sap.ui.integration.cards.BaseContent")){this.setPageCount(0);return}e.getLoadDependenciesPromise().then(t=>{if(t){this._initFromContent(e)}})};l.prototype._initFromContent=function(t){if(!t.hasData()){this.setPageCount(0);return}this.setModel(t.getModel());const i=t.getAggregation("_content");const n=e.hasListener(i,"updateFinished",this._listUpdateFinishedHandler);if(this._hasAnimation()&&!n){i.attachEvent("updateFinished",this._listUpdateFinishedHandler);if(this.isServerSide()){t.getAggregation("_loadingPlaceholder").addDelegate({onAfterRendering:this.onPlaceholderAfterRendering.bind(this)})}}if(n){this._clearAnimation(this)}const a=this.getTotalCount()||t.getDataLength();this.setPageCount(Math.ceil(a/this.getPageSize()));this.setPageNumber(Math.min(Math.max(0,this.getPageNumber()),this._getLastPageNumber()));this.sliceData()};l.prototype.setCard=function(t){this.setProperty("card",t,true);if(t){t.attachEvent("_contentDataChange",this._dataChangedHandler)}return this};l.prototype.sliceData=function(){const t=this.getCard();if(!t){return}const e=this.getModel("paginator"),i=t.getCardContent(),n=t.getAggregation("_loadingProvider"),a=i.getAggregation("_loadingProvider"),s=this.getPageNumber()*this.getPageSize(),o=this._iPreviousStartIndex!==undefined&&this._iPreviousStartIndex!==s,r=this.isServerSide();e.setData({skip:s,size:this.getPageSize(),pageIndex:this.getPageNumber()});if(o){this._prepareAnimation(s)}if(r&&o){if(!e.getBindings().length){t.refreshAllData()}if(this._hasAnimation()){a.setAwaitPagination(true);n.setAwaitPagination(true)}}else if(!r&&i.isA("sap.ui.integration.cards.BaseContent")){i.sliceData(s,s+this.getPageSize())}this._iPreviousStartIndex=s};l.prototype.reset=function(){this.setPageNumber(0).sliceData()};l.prototype._prepareAnimation=function(t){if(!this._hasAnimation()||this._isSkeletonCard()){return}var e=this.getCard().getCardContent().getDomRef(),i=e.cloneNode(true);this._bActiveAnimation=true;this._bReverseAnimation=this._iPreviousStartIndex>t;i.removeAttribute("id");i.querySelectorAll("*[id]").forEach(function(t){t.removeAttribute("id")});i.classList.add("sapFCardContentCloned");if(this._bReverseAnimation){i.classList.add("sapFCardContentReverseAnim")}if(this.isServerSide()){this._oClonedContent=i}else{e.classList.add("sapFCardContentOriginal");if(this._bReverseAnimation){e.classList.add("sapFCardContentReverseAnim")}e.parentElement.insertBefore(i,e)}};l.prototype._clearAnimation=function(){if(!this._hasAnimation()||!this._bActiveAnimation||this._isSkeletonCard()){return}var t=this.getCard(),e=t.getCardContent(),i=e.getDomRef(),n=i.previousSibling,a,s;a=t.getAggregation("_loadingProvider");s=e.getAggregation("_loadingProvider");if(s.getAwaitPagination()){s.setAwaitPagination(false);a.setAwaitPagination(false)}else{if(n){n.parentNode.removeChild(n)}i.classList.remove("sapFCardContentOriginal");i.classList.remove("sapFCardContentTransition");i.classList.remove("sapFCardContentReverseAnim");e.hideLoadingPlaceholders();a.setLoading(false);this._bActiveAnimation=false}this.fireAnimationComplete()};l.prototype._listUpdateFinished=function(){if(!this._bActiveAnimation||this.isServerSide()||this._isSkeletonCard()){return}var t=this.getCard().getCardContent(),e=t.getDomRef(),i=e.previousSibling;if(!i){return}i.addEventListener("transitionend",function(){i.parentNode.removeChild(i);e.classList.remove("sapFCardContentOriginal");e.classList.remove("sapFCardContentTransition");e.classList.remove("sapFCardContentReverseAnim");this._bActiveAnimation=false}.bind(this));e.classList.add("sapFCardContentTransition");i.classList.add("sapFCardContentTransition")};l.prototype._isSkeletonCard=function(){return this.getCard().isSkeleton()};l.prototype.onPlaceholderAfterRendering=function(){if(!this._oClonedContent||this._isSkeletonCard()){return}var t=this.getCard(),e=t.getCardContent(),i=e.getDomRef(),n=this._oClonedContent;i.classList.add("sapFCardContentOriginal");i.parentElement.insertBefore(n,i);if(this._bReverseAnimation){i.classList.add("sapFCardContentReverseAnim")}this._oClonedContent.addEventListener("transitionend",function(){setTimeout(this._clearAnimation.bind(this),g)}.bind(this));this._oClonedContent=null;setTimeout(function(){n.classList.add("sapFCardContentTransition");i.classList.add("sapFCardContentTransition")},30)};l.prototype._getNavigationArrow=function(t){return this.getAggregation("_"+t+"Icon")};l.prototype._hasAnimation=function(){return d&&this.getCard().getCardContent().isA("sap.ui.integration.cards.ListContent")};l.prototype._hasActiveLoadingProvider=function(){var t=this.getCard();return t&&t.hasActiveLoadingProvider()};l.prototype.previous=function(){if(this._bActiveAnimation||this._hasActiveLoadingProvider()){return}this.setPageNumber(Math.max(0,this.getPageNumber()-1));this.sliceData()};l.prototype.next=function(){if(this._bActiveAnimation||this._hasActiveLoadingProvider()){return}this.setPageNumber(Math.min(this._getLastPageNumber(),this.getPageNumber()+1));this.sliceData()};l.prototype.onmousedown=function(t){var e=t.target,i=e.getAttribute("data-slide");if(i&&!e.classList.contains("sapMCrslActive")){this.setPageNumber(parseInt(i)-1);this.sliceData()}};l.prototype.getStaticConfiguration=function(){return{pageCount:this.getPageCount(),pageIndex:this.getPageNumber()}};l.prototype._getLastPageNumber=function(){return Math.max(0,this.getPageCount()-1)};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/controls/PaginatorRenderer", ["sap/m/library","sap/ui/core/Core","sap/base/strings/capitalize","sap/ui/core/InvisibleRenderer"],function(e,r,s,n){"use strict";var a=r.getLibraryResourceBundle("sap.m");var t=5;var i={apiVersion:2};i.render=function(e,r){var s=r.getId(),i=r.getPageNumber(),o=r.getPageCount(),l,p;if(o<=1||!r.getVisible()){n.render(e,r,r.TagName);return}e.openStart("div",r).class("sapUiIntPaginator").openEnd();e.openStart("div").class("sapMCrslControls").openEnd();e.openStart("div").class("sapMCrslControlsContainer").openEnd();this._renderArrow(e,r,"previous");e.openStart("div",s+"-pageIndicator");if(o<t){e.class("sapMCrslBulleted").openEnd();for(l=0;l<o;l++){e.openStart("span").accessibilityState({role:"img",label:a.getText("CAROUSEL_POSITION",[l+1,o])});e.attr("data-slide",l+1);if(l===i){e.class("sapMCrslActive")}e.openEnd().close("span")}}else{e.class("sapMCrslNumeric").openEnd();p=a.getText("CAROUSEL_PAGE_INDICATOR_TEXT",[i+1,o]);e.openStart("span",s+"-"+"slide-number").openEnd().text(p).close("span")}e.close("div");this._renderArrow(e,r,"next");e.close("div").close("div").close("div")};i._renderArrow=function(e,r,n){e.openStart("div").class("sapMCrsl"+s(n.slice(0,4))).openEnd();e.openStart("div").class("sapMCrslArrowInner").openEnd();e.renderControl(r._getNavigationArrow(n==="previous"?"prev":"next"));e.close("div").close("div")};return i},true);
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/customElements/CustomElementBase", ["sap/ui/integration/util/Utils","sap/base/strings/hyphenate","sap/base/strings/camelize"],function(t,e,i){"use strict";function n(){if(this.constructor===n){throw new TypeError('Abstract class "CustomElementBase" cannot be instantiated directly.')}return Reflect.construct(HTMLElement,[],this.constructor)}n.prototype=Object.create(HTMLElement.prototype);n.prototype.constructor=n;n.prototype.connectedCallback=function(){this._init();this._upgradeAllProperties();this._oControlInstance.placeAt(this.firstElementChild);this._attachEventListeners()};n.prototype.disconnectedCallback=function(){if(this._oControlInstance){this._oControlInstance.destroy();delete this._oControlInstance}if(this.firstElementChild){this.removeChild(this.firstElementChild)}};n.prototype.attributeChangedCallback=function(e,o,s){this._init();var r=i(e);if(t.isJson(s)){s=JSON.parse(s)}if(this._mAllProperties[r]){this._mAllProperties[r].set(this._oControlInstance,s)}else if(this._mAllAssociations[r]){var a=document.getElementById(s);if(a instanceof n){s=document.getElementById(s)._getControl()}this._mAllAssociations[r].set(this._oControlInstance,s)}};n.prototype._init=function(){if(!this._oControlInstance){this._oControlInstance=new this._ControlClass}if(!this.firstElementChild){var t=document.createElement("div");this.appendChild(t)}};n.prototype._getControl=function(){this._init();return this._oControlInstance};n.prototype._attachEventListeners=function(){Object.keys(this._oMetadata.getEvents()).map(function(t){this._oControlInstance.attachEvent(t,function(e){this.dispatchEvent(new CustomEvent(t,{detail:e,bubbles:true}))},this)}.bind(this))};n.prototype._upgradeAllProperties=function(){this._aAllProperties.forEach(this._upgradeProperty.bind(this))};n.prototype._upgradeProperty=function(t){if(this[t]){var e=this[t];delete this[t];this[t]=e}};n.generateAccessors=function(t,i){i.forEach(function(i){Object.defineProperty(t,i,{get:function(){return this.getAttribute(e(i))},set:function(t){if(typeof t==="object"){t=JSON.stringify(t)}this.setAttribute(e(i),t)}})})};n.define=function(t,e,i){i=i||[];n.awaitDependencies(i).then(function(){window.customElements.define(t,e)})};n.awaitDependencies=function(t){var e=t.map(function(t){return window.customElements.whenDefined(t)});return Promise.all(e)};n.extend=function(t,i){function o(){return n.apply(this,arguments)}o.prototype=Object.create(n.prototype);o.prototype.constructor=o;var s=o.prototype,r="";s._ControlClass=t;s._oMetadata=t.getMetadata();s._mAllAssociations=s._oMetadata.getAllAssociations();s._mAllProperties=s._oMetadata.getAllProperties();s._aAllProperties=[];if(i&&i.customProperties){s._mAllProperties=Object.assign(s._mAllProperties,i.customProperties)}for(r in s._mAllProperties){if(i&&i.privateProperties&&i.privateProperties.indexOf(r)!==-1){continue}s._aAllProperties.push(r)}for(r in s._mAllAssociations){s._aAllProperties.push(r)}Object.defineProperty(o,"observedAttributes",{get:function(){var t=s._aAllProperties.map(e);return t}});n.generateAccessors(s,s._aAllProperties);return o};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/Editor", ["sap/ui/core/Control","sap/ui/core/Core","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/merge","sap/ui/base/Interface","sap/ui/integration/Designtime","sap/ui/model/json/JSONModel","sap/ui/model/odata/v4/ODataModel","sap/ui/integration/util/Utils","sap/ui/integration/util/Destinations","sap/ui/integration/util/DataProviderFactory","sap/m/Label","sap/m/HBox","sap/m/VBox","sap/ui/core/Icon","sap/m/ResponsivePopover","sap/m/Popover","sap/m/Text","sap/base/Log","sap/ui/core/Popup","sap/base/i18n/ResourceBundle","sap/ui/integration/editor/EditorResourceBundles","sap/ui/dom/includeStylesheet","sap/base/util/LoaderExtensions","sap/ui/core/theming/Parameters","sap/base/util/ObjectPath","sap/m/FormattedText","sap/m/MessageStrip","sap/m/ToolbarSpacer","sap/ui/model/resource/ResourceModel","./Manifest","./Merger","./Settings","sap/m/FlexItemData","sap/m/FlexBox","sap/m/Button"],function(e,t,i,a,n,s,r,o,l,d,f,g,u,p,h,c,_,m,v,y,b,I,M,C,P,x,T,S,D,E,A,w,L,O,R,V,F){"use strict";var B=m.prototype.init;m.prototype.init=function(){B.apply(this,arguments);var e=this.oPopup._applyPosition,t=this;this.oPopup._applyPosition=function(){var i=t.close;t.close=function(){};e.apply(this,arguments);t.close=i}};function U(e){if(e&&e.nodeType!==1){return 0}var t=parseInt(window.getComputedStyle(e).getPropertyValue("z-index"));if(isNaN(t)){return U(e.parentNode)}return t+1}var j=/\{\{(?!parameters.)(?!destinations.)([^\}\}]+)\}\}/g,N=/\{\{parameters\.([^\}\}]+)/g,W=5e3,k=t.getLibraryResourceBundle("sap.ui.integration"),H="_strip",q="module:";var G=e.extend("sap.ui.integration.editor.Editor",{metadata:{library:"sap.ui.integration",properties:{mode:{type:"string",defaultValue:"admin"},language:{type:"string",defaultValue:""},allowDynamicValues:{type:"boolean",defaultValue:false},allowSettings:{type:"boolean",defaultValue:false},designtime:{type:"object"},section:{type:"string",defaultValue:"sap.card"},host:{type:"string",defaultValue:""},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},json:{type:"object"},previewPosition:{type:"string",defaultValue:"right"},width:{type:"sap.ui.core.CSSSize",defaultValue:""},height:{type:"sap.ui.core.CSSSize",defaultValue:""}},aggregations:{_formContent:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},_preview:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_messageStrip:{type:"sap.m.MessageStrip",multiple:false,visibility:"hidden"},_extension:{type:"sap.ui.integration.editor.Extension",multiple:false,visibility:"hidden"}},events:{ready:{},manifestReady:{}}},renderer:{apiVersion:2,render:function(e,i){var n=i.getAggregation("_preview");var s=i.getMode()!=="translation"&&i.hasPreview();var r=i.getPreviewPosition();if(s&&(r==="top"||r==="bottom")){e.openStart("div",i);e.openEnd();if(i.isReady()&&r==="top"){e.renderControl(n)}}if(s&&r==="left"){e.openStart("div",i);e.class("sapUiIntegrationEditor");e.openEnd();if(i.isReady()){e.renderControl(n)}}else if(s&&(r==="top"||r==="bottom")){e.openStart("div");e.class("sapUiIntegrationEditor");e.openEnd()}else{e.openStart("div",i);e.class("sapUiIntegrationEditor");e.openEnd()}if(i.isReady()){e.openStart("div");e.class("sapUiIntegrationEditorForm");if(i.getMode()!=="translation"){e.class("settingsButtonSpace")}e.openEnd();if(i.getMode()!=="translation"){e.renderControl(i.getAggregation("_messageStrip"))}var o=i.getAggregation("_formContent");if(o){var l;var d;var f;var g;var u=[];var c=[];var _;var m=function(){if(u.length>0){var e=2-u.length;for(var t=0;t<e;t++){u.push(new h)}l.addContent(new V({alignItems:"Start",justifyContent:"SpaceBetween",items:u}));u=[]}};var v=function(){if(c.length>0){var e=2-c.length;for(var t=0;t<e;t++){c.push(new h)}d.addContent(new V({alignItems:"Start",justifyContent:"SpaceBetween",items:c}));c=[]}};var y=function(t){if(t.getContent().length>0){var i=t.getContent();if(i.length===1&&i[0].isA("sap.m.MessageStrip")){return}if(i[0].isA("sap.m.MessageStrip")){t.removeContent(0);t.addContent(i[0])}e.renderControl(t.getParent());if(t._messageStrip){e.renderControl(t._messageStrip)}}};var b=function(e,t){if(e&&t.getContent().length>0){var i=t.getContent();if(i[0].isA("sap.m.MessageStrip")){t.removeContent(0);t.addContent(i[0])}e.addContent(t.getParent());if(t._messageStrip){e.addContent(t._messageStrip)}}else{t=null}};var I=function(e,t){var i=e.getContent(),a;if(i.length>0){for(var n=0;n<i.length;n++){if(i[n].getAggregation("_field")&&i[n].getAggregation("_field").isA("sap.m.IconTabBar")){a=i[n].getAggregation("_field")}}}if(a&&t.getContent().length>0){a.addItem(t)}};for(var M=0;M<o.length;M++){var C=o[M];if(i.getMode()!=="translation"){if(C.isA("sap.ui.integration.editor.fields.GroupField")){var P=C.getAggregation("_field");if(!P){continue}if(d){v();if(P.isA("sap.m.Panel")&&d.isA("sap.m.Panel")){b(l,d)}else{I(l,d)}}var x=0;if(P.isA("sap.m.Panel")){x=P._level}else if(P.isA("sap.m.IconTabBar")){x="1"}if(x==="1"){if(u.length>0){m()}if(P.isA("sap.m.IconTabBar")){var T=l.getContent(),S=false,D;if(T.length>0){for(var E=0;E<T.length;E++){if(T[E].getAggregation("_field")&&T[E].getAggregation("_field").isA("sap.m.IconTabBar")){S=true;D=T[E].getAggregation("_field")}}}d=P.getItems()[0];d._subItems=d._subItems||[];if(!S){P.removeItem(P.getItems()[0]);if(P._messageStrip){l.addContent(P._messageStrip)}P.addStyleClass("sapUiIntegrationEditorSubTab");l.addContent(C)}else{D.addItem(P.getItems()[0]);P.destroy()}}else{d=P;d._subItems=d._subItems||[];d.addStyleClass("sapUiIntegrationEditorSubGroup")}}else{if(l){m();y(l);d=null}l=P;l._subItems=l._subItems||[];l.addStyleClass("sapUiIntegrationEditorItem")}if(M===o.length-1){m();y(l)}continue}if(C.isA("sap.m.FormattedText")){if(d){d.addContent(C.addStyleClass("sapUiIntegrationEditorHint"))}else{l.addContent(C.addStyleClass("sapUiIntegrationEditorHint"))}if(M===o.length-1){if(d){v();b(l,d)}m();y(l)}continue}var A=C._layout;if(C.isA("sap.m.Label")){C.addStyleClass("sapUiIntegrationEditorItemLabel");if(C.getRequired()){C.addStyleClass("sapUiIntegrationEditorItemLabelWithRequired")}if(A&&!a(A,{})){if(A.alignment&&A.alignment.label==="end"){C.setTextAlign("End")}g=C}else{if(C._cols===2){if(d){v()}else{m()}}else if(c.length===2){v()}else if(u.length===2){m()}if(d){d.addContent(C)}else{l.addContent(C)}}}else if(C.isA("sap.m.ToolbarSpacer")){if(C._hasLine){C.addStyleClass("sapUiIntegrationEditorSpacerWithLine")}else{C.addStyleClass("sapUiIntegrationEditorSpacerWithoutLine")}if(d){v();d.addContent(C)}else{m();l.addContent(C)}}else{var w=C.getConfiguration(),L=new p,O=.1,F=0,B;if(C._descriptionIcon){L.addItem(C._descriptionIcon);O+=.9}var U=t.byId(C.getAssociation("_messageIcon"));if(C.getAssociation("_messageIcon")&&U){L.addItem(U);O+=1.2}if(C._settingsButton){C._settingsButton.addStyleClass("sapUiIntegrationEditorSettingsButton");F=2}var j=new R({growFactor:10,maxWidth:"calc(100% - "+F+"rem)"});var N=new R({maxWidth:"calc(100% - "+O+"rem)"});if(g){var W,k,H="50%";if(A&&A["label-width"]){H=A["label-width"]}var q=parseInt(H);var G=100-q;if(C._cols===2){q=q-.5;G=G-.5}if(A.alignment&&A.alignment.field==="end"){C.addStyleClass("sapUiIntegrationEditorFieldAlignEnd")}if(A.alignment&&A.alignment.label==="end"){g.setLayoutData(new R({maxWidth:"calc(100% - "+O+"rem)",minWidth:"calc(100% - "+O+"rem)"}))}else{g.setLayoutData(N)}if(L.getItems().length>0){g.addStyleClass("sapUiIntegrationEditorItemLabelWithInfo");B=new p({items:[g,L]})}else{B=g}if(A&&A.position&&A.position==="field-label"){B.setLayoutData(j);k=new p({alignItems:"Start",justifyContent:"SpaceBetween",items:[B,C._settingsButton]});k.setLayoutData(new R({growFactor:q,maxWidth:q+"%"}));C.setLayoutData(new R({growFactor:G,maxWidth:G+"%"}));W=new p({alignItems:"Start",justifyContent:"SpaceBetween",items:[C,k]})}else{C.setLayoutData(j);k=new p({alignItems:"Start",justifyContent:"SpaceBetween",items:[C,C._settingsButton]});B.setLayoutData(new R({growFactor:q,maxWidth:q+"%"}));k.setLayoutData(new R({growFactor:G,maxWidth:G+"%"}));W=new p({alignItems:"Start",justifyContent:"SpaceBetween",items:[B,k]})}if(C._cols===1){if(d){if(c.length===2){v()}if(w.hint){var K=i._createHint(w.hint,C.getParameterId());var z=new h({items:[W,K.addStyleClass("sapUiIntegrationEditorHint")]});z.addStyleClass("col1");c.push(z)}else{W.addStyleClass("col1");c.push(W)}}else{if(u.length===2){m()}if(w.hint){var K=i._createHint(w.hint,C.getParameterId());var z=new h({items:[W,K.addStyleClass("sapUiIntegrationEditorHint")]});z.addStyleClass("col1");u.push(z)}else{W.addStyleClass("col1");u.push(W)}}}else if(d){v();d.addContent(W)}else{m();l.addContent(W)}g=null}else{var J;if(d){J=d.getContent().pop()}else{J=l.getContent().pop()}J.setLayoutData(N);if(L.getItems().length>0){J.addStyleClass("sapUiIntegrationEditorItemLabelWithInfo");B=new p({items:[J,L]})}else{B=J}B.setLayoutData(j);var X=new V({alignItems:"Start",justifyContent:"SpaceBetween",items:[B,C._settingsButton]});if(C._cols===1){var z=new h({items:[X,C]});if(w.hint){var K=i._createHint(w.hint,C.getParameterId());z.addItem(K.addStyleClass("sapUiIntegrationEditorHint"))}z.addStyleClass("col1");if(d){c.push(z)}else{u.push(z)}}else if(d){d.addContent(X);d.addContent(C)}else{l.addContent(X);l.addContent(C)}}if(d){d._subItems.push({settingspath:C.getConfiguration()._settingspath,itemId:C.getId()})}l._subItems.push({settingspath:C.getConfiguration()._settingspath,itemId:C.getId()})}if(M===o.length-1){if(d){v();if(d.isA("sap.m.Panel")){b(l,d)}else{I(l,d)}}m();y(l)}}else{if(M===0){f=C.getAggregation("_field");e.renderControl(C);C.addStyleClass("sapUiIntegrationEditorTranslationPanel");continue}if(C.isA("sap.ui.integration.editor.fields.GroupField")){var P=C.getAggregation("_field");if(d){if(P.isA("sap.m.Panel")&&d.isA("sap.m.Panel")){b(l,d)}else{I(l,d)}}var Y=0;if(P.isA("sap.m.Panel")){Y=P._level}else if(P.isA("sap.m.IconTabBar")){if(P.getItems().length>0&&P.getItems()[0]._level){Y=P.getItems()[0]._level}}if(Y==="1"){if(P.isA("sap.m.IconTabBar")){if(M!==o.length-1||M<o.length&&(o[M].isA("sap.m.IconTabBar")||o[M].isA("sap.m.Panel"))){var Z=l.getContent(),Q=false;if(Z.length>0){for(var $=0;$<Z.length;$++){if(Z[$].getAggregation("_field")&&Z[$].getAggregation("_field").isA("sap.m.IconTabBar")){Q=true}}}if(!Q){d=P.getItems()[0];P.removeItem(P.getItems()[0]);l.addContent(P.getParent())}else{d=P.getItems()[0]}}}else{d=P;d.addStyleClass("sapUiIntegrationEditorSubGroup")}}else{d=null;if(l&&l.getContent().length>0){f.addContent(l.getParent())}l=P;l.addStyleClass("sapUiIntegrationEditorSubGroup")}if(M===o.length-1){m();y(l)}continue}if(C.isA("sap.m.ToolbarSpacer")){continue}if(C.isA("sap.m.FormattedText")){continue}if(C.isA("sap.m.Label")){if(d){d.addContent(C)}else{l.addContent(C)}continue}if(C.isOrigLangField){_=C;continue}_.addStyleClass("sapUiIntegrationFieldTranslationText");var W=new p({items:[_,C]}).addStyleClass("notWrappingRow");if(d){d.addContent(W)}else{l.addContent(W)}if(M===o.length-1){if(d){if(d.isA("sap.m.Panel")){b(l,d)}else{I(l,d)}}f.addContent(l.getParent())}}}}e.close("div");if(s&&r==="right"){e.renderControl(n)}}e.close("div");if(s&&(r==="top"||r==="bottom")){if(r==="bottom"){e.renderControl(n)}e.close("div")}}}});G.prototype.init=function(){this._ready=false;this._aFieldReadyPromise=[];this._oResourceBundle=t.getLibraryResourceBundle("sap.ui.integration");this._appliedLayerManifestChanges=[];this._currentLayerManifestChanges={};this._mDestinationDataProviders={};var e=new D(this.getId()+H,{showIcon:false});e.addStyleClass("sapUiIntegrationEditorFieldMessageStrip");this.setAggregation("_messageStrip",e);H=e.getId();this.setLanguage(t.getConfiguration().getLanguage());this._oLimitedInterface=new s(this,["getParameters","resolveDestination","request","getModel"])};G.prototype.getParameters=function(){if(!this._isManifestReady){y.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.editor.Editor");return null}var e=this._oEditorManifest.getProcessedParameters(),t={},i;for(i in e){t[i]=e[i].value}return t};G.prototype.resolveDestination=function(e){return this._oDestinations.getUrl(e)};G.prototype.isReady=function(){return this._ready};G.prototype.hasPreview=function(){var e=this.getAggregation("_preview");if(e&&e.visible!==false){return true}return false};G.prototype.getSeparatePreview=function(){var e=this.getPreviewPosition();if(!this.isReady()||e!=="separate"){return null}if(!this._oPreview){this._oPreview=this.getAggregation("_preview")}return this._oPreview};G.prototype.flattenData=function(e,t,i,a){a=a||"";i=i||[];if(typeof e==="object"){if(!e[t]){for(var n in e){this.flattenData(e[n],t,i,a+"/"+n)}}else{if(e.type){i.push({path:e.pathvalue||a.substring(1),value:e.pathvalue||"{context>"+a.substring(1)+"/value}",object:e})}else{i.push({path:a.substring(1),object:e});for(var n in e){this.flattenData(e[n],t,i,a+"/"+n)}}}}return i};G.prototype.setJson=function(e,t){this._ready=false;if(a(e,this._preIdOrSettings)){return this}this._preIdOrSettings=i(e,500);if(typeof e==="string"){try{e=JSON.parse(e)}catch(e){}}if(typeof e==="object"){if(e.manifestChanges){this._filterManifestChangesByLayer(e)}if(this._manifestModel){return}if(this._oDesigntimeInstance){this._oDesigntimeInstance.destroy()}if(e.host){this.setProperty("host",e.host)}if(e.baseUrl){this.setProperty("baseUrl",e.baseUrl)}this._appliedLayerManifestChanges=e.manifestChanges;this.createManifest(e,t)}};G.prototype.createManifest=function(e,t){var i=this.getBaseUrl();var a={},s=e.manifest;this._isManifestReady=false;if(typeof s==="string"){a.manifestUrl=s;s=null}if(this._oEditorManifest){this._oEditorManifest.destroy()}this.destroyAggregation("_extension");var r=L.layers[this.getMode()];this._oEditorManifest=new w(this.getSection(),s,i,e.manifestChanges);this._oEditorManifest.load(a).then(function(){this._registerManifestModulePath();this._oInitialManifestModel=new o(this._oEditorManifest._oInitialJson);this.setProperty("json",this._oEditorManifest._oInitialJson,t);var e=this._oEditorManifest.oJson;var i=n({},e);this._beforeManifestModel=new o(i);if(r<L.layers["translation"]&&this._currentLayerManifestChanges){e=L.mergeDelta(e,[this._currentLayerManifestChanges],this.getSection())}this._manifestModel=new o(e);this._isManifestReady=true;this.fireManifestReady();this._initResourceBundlesForMultiTranslation();this._loadDefaultTranslations();this._createContextModel();if(this._oEditorManifest.getResourceBundle()){this._enhanceI18nModel(this._oEditorManifest.getResourceBundle())}return this._loadExtension().then(function(){this._initInternal()}.bind(this))}.bind(this))};G.prototype._initResourceBundlesForMultiTranslation=function(){var e=this._oEditorManifest.get("/sap.app/i18n");var t;var i;if(typeof e==="string"){t=this.getBaseUrl()+e}else if(typeof e==="object"){if(e.bundleUrl){t=this.getBaseUrl()+e.bundleUrl}if(e.supportedLocales){i=e.supportedLocales}}this._oEditorResourceBundles=new M({url:t,languages:G._oLanguages,supportedLocales:i})};G.prototype._registerManifestModulePath=function(){if(!this._oEditorManifest){return}this._sAppId=this._oEditorManifest.get("/sap.app/id");if(this._sAppId){P.registerResourcePath(this._sAppId.replace(/\./g,"/"),this._oEditorManifest.getUrl()||"/")}else{y.error("sap.app/id entry in the manifest is mandatory")}};G.prototype._loadDefaultTranslations=function(){if(this._defaultTranslationsLoaded){return}var e=t.getLibraryResourceBundle("sap.ui.integration");var i=new A({bundle:e});this.setModel(i,"i18n");this._oResourceBundle=e;this._defaultTranslationsLoaded=true};G.prototype._enhanceI18nModel=function(e){var t=this.getModel("i18n");if(t.getResourceBundle().oUrlInfo.url!==e.oUrlInfo.url){t.enhance(e);this._oResourceBundle=t.getResourceBundle()}};G.prototype._loadExtension=function(){var e=this._oEditorManifest.get(this.getConfigurationPath()+"/extension")||this._oEditorManifest.get("/"+this.getSection()+"/extension"),t;if(!e){y.info("Extension is not defined in manifest, do not load it.");return new Promise(function(e,t){e()})}if(e.startsWith(q)){t=e.replace(q,"")}else{t=this._sAppId.replace(/\./g,"/")+"/"+e}return new Promise(function(i,a){sap.ui.require([t],function(e){var t=new e;t._setEditor(this,this._oLimitedInterface);this.setAggregation("_extension",t);i()}.bind(this),function(t){y.error("Failed to load "+e+". Check if the path is correct. Reason: "+t);a(t)})}.bind(this))};G.prototype.request=function(e){return this._oDataProviderFactory.create({request:e}).setAllowCustomDataType(true).getData()};G.prototype.initDestinations=function(e){this._destinationsModel=new o({});this.setModel(this._destinationsModel,"destinations");var t=this.getHostInstance();if(e&&!t){y.error("Host with id '"+e+"' is not available during editor initialization. It must be available for host specific features to work.","Make sure that the host already exists, before assigning it to the editor.","sap.ui.integration.editor.Editor")}if(this._oDestinations){this._oDestinations.setHost(t)}else{var i=this.getConfigurationPath();this._oDestinations=new f({host:t,manifestConfig:this._manifestModel.getProperty(i+"/destinations")})}};G.prototype.initDataProviderFactory=function(){if(this._oDataProviderFactory){this._oDataProviderFactory.destroy()}var e=this.getAggregation("_extension");this._oDataProviderFactory=new g({destinations:this._oDestinations,extension:e,editor:this})};G.prototype.getRuntimeUrl=function(e){var t=this._sAppId,i,a=e&&e.trim().replace(/^\//,"");if(t===null){y.error("The manifest is not ready so the URL can not be resolved. Consider using the 'manifestReady' event.","sap.ui.integration.editor.Editor");return null}if(!t||e.startsWith("http://")||e.startsWith("https://")||e.startsWith("//")){return e}i=t.replace(/\./g,"/");return sap.ui.require.toUrl(i)+"/"+a};G.prototype.getBindingNamespaces=function(){var e={},t=this.getAggregation("_extension");if(t){e.extension={formatters:t.getFormatters()}}return e};G.prototype.getHostInstance=function(){var e=this.getHost();if(!e){return null}return t.byId(e)};G.prototype.setLanguage=function(e,t){if(!e||typeof e!=="string"){return this}this._language=e.replaceAll("_","-");if(this.getLanguage()!=e){this._loadDefaultTranslations()}this.setProperty("language",e,t);if(!G._oLanguages[this._language]){this._language=this._language.split("-")[0]}if(!G._oLanguages[this._language]){y.warning("The language: "+e+" is currently unknown, some UI controls might show "+e+" instead of the language name.")}return this};G.prototype.onAfterRendering=function(){if(this.getDomRef()){this._iZIndex=U(this.getDomRef());b.setInitialZIndex(this._iZIndex)}};G.prototype._filterManifestChangesByLayer=function(e){var i=[],a=this,s={},r={":layer":L.layers[this.getMode()]},o=L.layers[a.getMode()];e.manifestChanges.forEach(function(e){var l=e.hasOwnProperty(":layer")?e[":layer"]:1e3;if(l===L.layers["translation"]){var d=a._language;if(d===""){d=t.getConfiguration().getLanguage().replaceAll("_","-")}var f={texts:{}};delete e.texts;f.texts[d]={};Object.keys(e).forEach(function(t){if(t.charAt(0)==="/"){f.texts[d][t]=e[t]}else{f[t]=e[t]}});e=f}if(l<o){i.push(e);s=n(s,e)}else if(l===o){r=e}});e.manifestChanges=i;this._currentLayerManifestChanges=r;this._beforeLayerManifestChanges=s};G.prototype._initInternal=function(){var e=this;var t=e.getConfigurationPath();var i=e._oEditorManifest.get(t+"/editor");if(!i){i=e._oEditorManifest.get("/"+e.getSection()+"/designtime")}var a=e._manifestModel.getProperty(t),n,s=e.getDesigntime();if(s){if(typeof s==="function"){n=new Promise(function(t,i){var a=new s;e._applyDesigntimeDefaults(a.getSettings());t(a)})}else if(typeof s==="object"){n=new Promise(function(t,i){sap.ui.require(["sap/ui/integration/Designtime"],function(i){var a=i.extend("test.Designtime");a.prototype.create=function(){return s};var n=new a;e._applyDesigntimeDefaults(n.getSettings());t(n)})})}}else if(i){n=e.loadDesigntime().then(function(t){e._applyDesigntimeDefaults(t.getSettings());return t})}else{n=Promise.resolve(e._createParameterDesigntime(a))}n.then(function(t){e._oDesigntimeInstance=t;e.initDestinations();e.initDataProviderFactory();if(e.getMode()==="admin"||e.getMode()==="all"){e._addDestinationSettings(a)}else{e._deleleDestinationSettings()}e._settingsModel=new o(e._oDesigntimeInstance.getSettings());e.setModel(e._settingsModel,"currentSettings");e.setModel(e._settingsModel,"items");return e._loadValueContextInDesigntime()}).then(function(){e._applyDesigntimeLayers();return e._requestExtensionData()}).then(function(){e._requireFields().then(function(){e._startEditor()})})};G.prototype.loadDesigntime=function(){if(this._oDesigntime){return Promise.resolve(this._oDesigntime)}if(!this._oEditorManifest){return new Promise(function(e,t){this.attachManifestReady(function(){this.loadDesigntime().then(e,t)}.bind(this))}.bind(this))}if(!this._sAppId){return Promise.reject("App id not maintained")}return new Promise(function(e,t){var i=this._oEditorManifest.get(this.getConfigurationPath()+"/editor");if(!i){i=this._oEditorManifest.get("/"+this.getSection()+"/designtime")}var a=this._sAppId.replace(/\./g,"/")+"/"+i;if(a){sap.ui.require([a],function(t){t=new t;t._readyPromise(this._oLimitedInterface,this).then(function(){this._oDesigntime=t;e(t)}.bind(this))}.bind(this),function(){t({error:a+" not found"})})}else{t()}}.bind(this))};G.prototype.getConfigurationPath=function(){return"/"+this.getSection()+"/configuration"};G.prototype.getCurrentSettings=function(){var e=this._settingsModel.getProperty("/"),t={},s;if(e&&e.form&&e.form.items){for(var r in e.form.items){var o=e.form.items[r];if(o.editable&&o.visible){if(this.getMode()!=="translation"){if(o.translatable&&!o._changed&&o._translatedPlaceholder&&!this._currentLayerManifestChanges[o.manifestpath]){}else{if(o.valueItems){t[o.manifestpath.substring(0,o.manifestpath.lastIndexOf("/"))+"/valueItems"]=o.valueItems}if(o.valueTokens){t[o.manifestpath.substring(0,o.manifestpath.lastIndexOf("/"))+"/valueTokens"]=o.valueTokens}switch(o.type){case"string":if(!o.translatable){t[o.manifestpath]=o.value}else if(o._hasDynamicValue){t[o.manifestpath]=o.value;this.deleteAllTranslationValuesInTexts(o.manifestpath)}else if(o._beforeValue&&(o._beforeValue.indexOf("{context>")===0||o._beforeValue.indexOf("{{parameters")===0)){t[o.manifestpath]=o.value}break;case"group":break;case"object":if(o.value&&o.value!==""&&typeof o.value==="object"){t[o.manifestpath]=o.value}break;case"object[]":if(Array.isArray(o.value)){var l=i(o.value,500);l=l.sort(function(e,t){if(!e._dt||!e._dt._position||!t._dt||!t._dt._position){return 0}return e._dt._position-t._dt._position});for(var d=0;d<l.length;d++){var f=l[d];f._dt=f._dt||{};f._dt._position=d+1}t[o.manifestpath]=l}break;default:t[o.manifestpath]=o.value}}}else if(o.translatable&&o.value){t[o.manifestpath]=o.value}if(o._next&&this.getAllowSettings()){if(o.type==="destination"){if(o._next.pageAdminNewDestinationParameter){s=s||{};s[o._settingspath+"/pageAdminNewDestinationParameter"]=o._next.pageAdminNewDestinationParameter}}else{var g=typeof o.visibleToUser==="undefined"?true:o.visibleToUser;var u=typeof o.editableToUser==="undefined"?true:o.editableToUser;var p=typeof o.allowDynamicValues==="undefined"?true:o.allowDynamicValues;if(o._next.visible===!g){s=s||{};s[o._settingspath+"/visible"]=o._next.visible}if(o._next.editable===!u){s=s||{};s[o._settingspath+"/editable"]=o._next.editable}if(o._next.allowDynamicValues===!p){s=s||{};s[o._settingspath+"/allowDynamicValues"]=o._next.allowDynamicValues}if(o._next.pageAdminValues){s=s||{};s[o._settingspath+"/pageAdminValues"]=o._next.pageAdminValues}}}}}}if(this.getMode()==="translation"){delete t.texts}else if(e.texts){t.texts=i(e.texts,500)||{};for(var h in t.texts){for(var c in t.texts[h]){if(typeof t.texts[h][c]==="object"){var _=t[c];if(!_||typeof _!=="object"||a(_,{})||a(_,[])){delete t.texts[h][c]}else if(Array.isArray(_)){var m=_.map(function(e){return e._dt?e._dt._uuid||"":""});for(var v in t.texts[h][c]){if(!m.includes(v)){delete t.texts[h][c][v]}}}else{var y=_._dt?_._dt._uuid||"":"";if(y!==""){var b=t.texts[h][c][y];if(!b){delete t.texts[h][c]}else{t.texts[h][c]={};t.texts[h][c][y]=b}}else{delete t.texts[h][c]}}}}if(a(t.texts[h],{})){delete t.texts[h]}}if(a(t.texts,{})){delete t.texts}}t[":layer"]=L.layers[this.getMode()];t[":errors"]=this.checkCurrentSettings()[":errors"];if(s){t[":designtime"]=s}if(e[":designtime"]){t[":designtime"]=n(t[":designtime"],e[":designtime"])}return t};G.prototype.checkCurrentSettings=function(){var e=this._settingsModel.getProperty("/"),t={};if(e&&e.form&&e.form.items){for(var i in e.form.items){var a=e.form.items[i];if(a.editable){if((a.isValid||a.required)&&!(this.getMode()==="translation"&&a.translatable)){if(a.isValid){t[a.manifestpath]=a.isValid(a)}t[a.manifestpath]=true;var n=a.value;var s=a.type;if(s==="string"&&n===""){t[a.manifestpath]=n}if((s==="date"||s==="datetime")&&isNaN(Date.parse(n))){t[a.manifestpath]=n}if(s==="integer"){if(isNaN(parseInt(n))){t[a.manifestpath]=n}else if(n<a.min||n>a.max){t[a.manifestpath]=n}}if(s==="number"){if(isNaN(parseFloat(n))){t[a.manifestpath]=n}else if(n<a.min||n>a.max){t[a.manifestpath]=n}}}}}t[":layer"]=L.layers[this.getMode()]}t[":errors"]=Object.values(t).indexOf(false)>-1;return t};G.prototype._createContextModel=function(){var e=this.getHostInstance(),t=new o({}),i=new o([]);this.setModel(t,"context");this.setModel(i,"contextflat");t._aPendingPromises=[];i._getPathObject=function(e){var t=this.getData().filter(function(t){if(t.path===e){return true}});return t.length?t[0]:null};i._getValueObject=function(e){var t=this.getData()||[];t=t.filter(function(t){if(t.value===e||t.object.value===e){return true}});return t.length?t[0]:null};var a=new Promise(function(t,i){if(e&&e.getContext){var a=false;setTimeout(function(){if(a){return}y.error("Editor context could not be determined with "+W+".");a=true;t({})},W);e.getContext().then(function(e){if(a){y.error("Editor context returned after more than "+W+". Context is ignored.")}a=true;t(e||{})})}else{t({})}});a.then(function(e){var a=this._mergeContextData(e);t.setData(a);i.setData(this.flattenData(a,"label"))}.bind(this));t.getProperty=function(t,i){if(t&&!t.startsWith("/")&&!i){t="/"+t}var a=this.resolve(t,i),n;if(a.endsWith("/value")){this._mValues=this._mValues||{};if(this._mValues.hasOwnProperty(a)){return this._mValues[a]}this._mValues[a]=undefined;n=d.timeoutPromise(e.getContextValue(a.substring(1)));n=n.then(function(e){this._mValues[a]=e;this.checkUpdate()}.bind(this)).catch(function(e){this._mValues[a]=null;this.checkUpdate();y.error("Path "+a+" could not be resolved. Reason: "+e)}.bind(this));this._aPendingPromises.push(n);return undefined}else{return o.prototype.getProperty.apply(this,arguments)}}};G.prototype._mergeContextData=function(e){var t={};t["empty"]=G._contextEntries.empty;for(var i in e){t[i]=e[i]}t["editor.internal"]=G._contextEntries["editor.internal"];return t};G.prototype._loadValueContextInDesigntime=function(){var e=this.getModel("context");var t=this._oDesigntimeInstance.getSettings();var i;if(t&&t.form&&t.form.items){i=JSON.stringify(t.form.items)}if(i){var a=/\{context\>[\/?\w+.]+\}/g;var n=i.match(a);var s;if(n&&n.length>0){n=n.filter(function(e){return e.endsWith("value}")});s=n.map(function(e){return e.substring("{context>".length,e.length-1)});s.forEach(function(t){e.getProperty(t)});return Promise.all(e._aPendingPromises).then(function(){e._aPendingPromises=[]})}}return Promise.resolve()};G.fieldMap={string:"sap/ui/integration/editor/fields/StringField","string[]":"sap/ui/integration/editor/fields/StringListField",integer:"sap/ui/integration/editor/fields/IntegerField",number:"sap/ui/integration/editor/fields/NumberField",boolean:"sap/ui/integration/editor/fields/BooleanField",date:"sap/ui/integration/editor/fields/DateField",datetime:"sap/ui/integration/editor/fields/DateTimeField",object:"sap/ui/integration/editor/fields/ObjectField","object[]":"sap/ui/integration/editor/fields/ObjectListField",destination:"sap/ui/integration/editor/fields/DestinationField",group:"sap/ui/integration/editor/fields/GroupField"};G.Fields=null;G.prototype._requireFields=function(){if(G.Fields){return Promise.resolve()}return new Promise(function(e){sap.ui.require(Object.values(G.fieldMap),function(){G.Fields={};for(var t in G.fieldMap){G.Fields[t]=arguments[Object.keys(G.fieldMap).indexOf(t)]}e()})})};G.prototype._createDescription=function(e,t){var i=new c(this.getId()+"_"+t+"_description_icon",{src:"sap-icon://message-information",color:"Marker",size:"12px",useIconTooltip:false,visible:typeof e.visible==="boolean"?"{currentSettings>visible}":e.visible,objectBindings:{currentSettings:{path:"currentSettings>"+e._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});i.addStyleClass("sapUiIntegrationEditorDescriptionIcon");i.onmouseover=function(t){t.addDependent(this._getPopover());this._getPopover().getContent()[0].applySettings({text:e.description});this._getPopover().openBy(t)}.bind(this,i);i.onmouseout=function(e){this._getPopover().close();e.removeDependent(this._getPopover())}.bind(this,i);return i};G.prototype._createMessageIcon=function(e,t){var i=e.getConfiguration();var a=new c(this.getId()+"_"+t+"_message_icon",{src:"sap-icon://message-information",size:"12px",visible:typeof i.visible==="boolean"?"{currentSettings>visible}":i.visible,useIconTooltip:false,objectBindings:{currentSettings:{path:"currentSettings>"+i._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});a.onmouseover=function(e){e._showMessage()}.bind(this,e);a.onmouseout=function(e){e._hideMessage()}.bind(this,e);a.addStyleClass("sapUiIntegrationEditorMessageIcon");return a};G.prototype._createLabel=function(e,t){var i=new u(this.getId()+"_"+t+"_label",{text:e.label,tooltip:e.tooltip||e.label,required:e.required&&e.editable||false,visible:typeof e.visible==="boolean"?"{currentSettings>visible}":e.visible,objectBindings:{currentSettings:{path:"currentSettings>"+e._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});i._cols=e.cols||2;if(e.layout){i._layout=e.layout}i._sOriginalType=e.type;return i};G.prototype._createSettingsButton=function(e,t){var i=e.getConfiguration();var a=new F(this.getId()+"_"+t+"_settings_btn",{icon:"{= ${currentSettings>_hasDynamicValue} ? 'sap-icon://display-more' : 'sap-icon://enter-more'}",type:"Transparent",tooltip:this._oResourceBundle.getText("EDITOR_FIELD_MORE_SETTINGS"),press:function(t){this._openSettingsDialog(200,t.oSource,e)}.bind(this),visible:typeof i.visible==="boolean"?"{currentSettings>visible}":i.visible,objectBindings:{currentSettings:{path:"currentSettings>"+i._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});return a};G.prototype._getSettingsPanel=function(e){if(!e._oSettingsPanel){e._oSettingsPanel=new O}return e._oSettingsPanel};G.prototype._openSettingsDialog=function(e,t,i){var a=this._getSettingsPanel(i);window.setTimeout(function(){a.setConfiguration(i.getConfiguration());a.open(t,t,this,i.getHost(),i,i._applySettings.bind(i),i._cancelSettings.bind(i))}.bind(this),e||600)};G.prototype._getPopover=function(){if(this._oPopover){return this._oPopover}var e=new v({text:""});e.addStyleClass("sapUiTinyMargin sapUiIntegrationEditorDescriptionText");this._oPopover=new _(this.getId()+"_popover",{showHeader:false,content:[e]});this._oPopover.addStyleClass("sapUiIntegrationEditorPopover");return this._oPopover};G.prototype._createField=function(e,t){var i=new G.Fields[e.type](this.getId()+"_"+t+"_field",{configuration:e,mode:this.getMode(),host:this.getHostInstance(),parameterKey:t,objectBindings:{currentSettings:{path:"currentSettings>"+e._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"},destinations:{path:"destinations>/"}},visible:typeof e.visible==="boolean"?"{currentSettings>visible}":e.visible});i.setAssociation("_editor",this);this._aFieldReadyPromise.push(i._readyPromise.then(function(){if(e.type!=="group"){if(e.require||e.validation||e.validations&&e.validations.length>0||e.values&&e.values.data&&!e.values.data.json){var a=this._createMessageIcon(i,t);i.setAssociation("_messageIcon",a)}if(e.description&&this.getMode()!=="translation"){i._descriptionIcon=this._createDescription(e,t)}if(e._changeDynamicValues){i._settingsButton=this._createSettingsButton(i,t);i._applyButtonStyles()}}}.bind(this)));if(e.type!=="group"){i._oValueBinding=this._settingsModel.bindProperty(e._settingspath+"/value");i._oValueBinding.attachChange(function(){if(!this._bIgnoreUpdates){e._changed=true;if(e._dependentFields&&e._dependentFields.length>0){this._updateEditor(e._dependentFields)}this._updatePreview()}}.bind(this));if(i.isFilterBackend()){var a=this._settingsModel.bindProperty(e._settingspath+"/suggestValue");a.attachChange(function(){var t=n({},e);t._cancel=false;this._addValueListModel(t,i)}.bind(this))}if(e.values){if(e.values.metadata){this._addMetadataModel(e,i)}if(e.type==="string[]"&&i.isFilterBackend()&&e.visualization&&e.visualization.type==="MultiInput"){i.setModel(new o({}),undefined)}else{this._addValueListModel(e,i)}}this._createDependentFields(e,i);i._oDataProviderFactory=this._oDataProviderFactory}i._cols=e.cols||2;if(e.layout){i._layout=e.layout}i._oEditorResourceBundles=this._oEditorResourceBundles;i.setAssociation("_messageStrip",H);return i};G.prototype._updateEditor=function(e){if(this._ready){if(e.length===0){return}for(var t=0;t<e.length;t++){var i=e[t];i.config._cancel=true}if(!this._oDataProviderFactory){return}this._bIgnoreUpdates=true;for(var t=0;t<e.length;t++){var i=e[t];i.config._cancel=false;this._addValueListModel(i.config,i.field,500*t)}this._bIgnoreUpdates=false}};G.prototype._updatePreview=function(){var e=this.getAggregation("_preview")||this._oPreview;if(e&&e.update){e.update()}};G.prototype._requestData=function(e,t){var i=this._oDataProviderFactory.create(e.values.data);i.bindObject({path:"items>/form/items"});i.bindObject({path:"currentSettings>"+e._settingspath});i.bindObject({path:"context>/"});var a=i.getData();a.then(function(i){if(e._cancel){e._values=[];this._settingsModel.setProperty(e._settingspath+"/_loading",false);return}var a=e.values.data.path,n,s=[];if(a&&a!=="/"){if(a.startsWith("/")){a=a.substring(1)}if(a.endsWith("/")){a=a.substring(0,a.length-1)}n=a.split("/");s=T.get(n,i)}else{s=i}if(e.type==="object"||e.type==="object[]"){s.forEach(function(e){e._dt={_editable:false}})}if(this.getMode()==="content"&&e.pageAdminValues&&e.pageAdminValues.length>0){var r=e.pageAdminValues,o=e.value,l=e.valueItems,d=[],f=[],g=[];this.prepareFieldsInKey(e);if(r.length>0){for(var u=0;u<r.length;u++){for(var p=0;p<s.length;p++){var h=this.getKeyFromItem(s[p]);if(r[u]===h){d.push(s[p])}}if(Array.isArray(o)){for(var c=0;c<o.length;c++){if(r[u]===o[c]){f.push(o[c])}}for(var _=0;_<l.length;_++){var m=this.getKeyFromItem(l[_]);if(r[u]===m){g.push(l[_])}}}}if(f.length>0){e.value=[];e.value=f}if(g.length>0){e.valueItems=[];e.valueItems=g}}if(e.values.data.path&&e.values.data.path!=="/"){delete i[n];T.set(n,d,i)}else{i=[];i=d}}var v=t.getConfiguration();if(e.type==="string[]"){var y=e.values.data.path;if(y&&y!=="/"){if(y.startsWith("/")){y=y.substring(1)}if(y.endsWith("/")){y=y.substring(0,y.length-1)}var n=y.split("/");var b=T.get(n,i);if(Array.isArray(b)){for(var I in b){var M=t.getKeyFromItem(b[I]);if(Array.isArray(v.value)&&v.value.length>0&&v.value.includes(M)){b[I].Selected=this._oResourceBundle.getText("EDITOR_ITEM_SELECTED")}else{b[I].Selected=this._oResourceBundle.getText("EDITOR_ITEM_UNSELECTED")}}T.set(n,b,i)}}else if(Array.isArray(i)){for(var I in i){var M=t.getKeyFromItem(i[I]);if(Array.isArray(v.value)&&v.value.length>0&&v.value.includes(M)){i[I].Selected=this._oResourceBundle.getText("EDITOR_ITEM_SELECTED")}else{i[I].Selected=this._oResourceBundle.getText("EDITOR_ITEM_UNSELECTED")}}}}e._values=i;var C=t.getModel();C.setData(i);C.checkUpdate(true);C.firePropertyChange();if(e.type==="object"||e.type==="object[]"){t.mergeValueWithRequestResult(s)}this._settingsModel.setProperty(e._settingspath+"/_loading",false);t._hideValueState(true,true)}.bind(this)).catch(function(i){var a=new Promise(function(e){var t=this._oResourceBundle.getText("EDITOR_BAD_REQUEST");if(Array.isArray(i)&&i.length>0){t=i[0];var a=i[1];if(a){var n;a.text().then(function(i){if(d.isJson(i)){n=JSON.parse(i).error}else{t=i}if(n){t=(n.code||n.errorCode||a.status)+": "+n.message}e(t)});return}else{e(t);return}}else if(typeof i==="string"){t=i;e(t);return}else{e(t);return}}.bind(this));return a.then(function(i){var a=t.getModel();a.firePropertyChange();if(e.type==="object"||e.type==="object[]"){t.mergeValueWithRequestResult()}this._settingsModel.setProperty(e._settingspath+"/_loading",false);t._showValueState("error",i,true)}.bind(this))}.bind(this))};G.prototype._requestExtensionData=function(){var e=this.getAggregation("_extension");if(!e){y.info("Extension is not defined or created, do not load data of it.");return new Promise(function(e,t){e()})}var t=false;var i={};var a=this._oEditorManifest.get(this.getConfigurationPath()+"/data/extension");var n;if(a){t=true;n=this._oEditorManifest.get(this.getConfigurationPath()+"/data/path");i={extension:a};if(n){i.path=n}}else{a=this._oEditorManifest.get("/"+this.getSection()+"/data/extension");if(a){t=true;n=this._oEditorManifest.get("/"+this.getSection()+"/data/path");i={extension:a};if(n){i.path=n}}}if(!t){y.info("Extension data is not defined in manifest, do not load data of it.");return new Promise(function(e,t){e()})}var s=this._oDataProviderFactory.create(i);var r=s.getData();return r.then(function(t){var i=e.getModel();if(!i){i=new o(t||{});e.setModel(i,undefined)}else{i.setData(t)}i.checkUpdate(true)}).catch(function(e){var t=this._oResourceBundle.getText("EDITOR_BAD_REQUEST");if(Array.isArray(e)&&e.length>0){t=e[0];var i=e[1];if(i){var a;i.text().then(function(e){if(d.isJson(e)){a=JSON.parse(e).error}else{t=e}if(a){t=(a.code||a.errorCode||i.status)+": "+a.message}y.error("Request extension data failed, "+t)})}}else if(typeof e==="string"){t=e;y.error("Request extension data failed, "+t)}}.bind(this))};G.prototype._addValueListModel=function(e,t,i){if(e.values){var a;if(e.values.data){if(this._oDataProviderFactory){a=t.getModel();if(!a){a=new o({});t.setModel(a,undefined)}this._settingsModel.setProperty(e._settingspath+"/_loading",true);if(!i){this._requestData(e,t)}else{setTimeout(function(){this._requestData(e,t)}.bind(this),i)}}t.bindObject({path:e.values.data.path||"/"})}else if(this.getAggregation("_extension")){a=this.getAggregation("_extension").getModel();if(a&&this.getMode()==="content"&&e.pageAdminValues&&e.pageAdminValues.length>0){this.prepareFieldsInKey(e);var n=e.values.path;if(n.length>1){n=n.substring(1)}var s=T.get([n],a.getData()),r=e.pageAdminValues,l=[];for(var d=0;d<r.length;d++){for(var f=0;f<s.length;f++){var g=this.getKeyFromItem(s[f]);if(r[d]===g){l.push(s[f])}}}delete s[n];T.set(n,l,s);a.setData(s)}t.bindObject({path:e.values.path||"/"});t.setModel(a,undefined)}}};G.prototype._addMetadataModel=function(e,t){if(e.values&&e.values.metadata){var i={synchronizationMode:"None"};i=n(i,e.values.metadata.request);var a={url:i.serviceUrl};var s=Promise.resolve(a);if(this._oDestinations){s=this._oDestinations.process(a)}s.then(function(e){if(!e.url.endsWith("/")){e.url=e.url+"/"}i.serviceUrl=e.url;var a=new l(i);a.oMetaModel.fetchData().then(function(e){t.setModel(new o(e),"meta")})})}};G.prototype._createDependentFields=function(e,t){if(e.values){var i=JSON.stringify(e.values.data);if(i){var a=/parameters\.([^\}\}]+)|destinations\.([^\}\}]+)|\{items\>[\/?\w+]+\}/g,s=i.match(a);if(s){for(var r=0;r<s.length;r++){var o="/value";var l=this.getConfigurationPath();if(s[r].indexOf("destinations.")===0||s[r].indexOf("parameters.")===0){if(s[r].indexOf("destinations.")===0){o="/name"}l=l+"/"+s[r].replace(".","/")+o}else if(s[r].indexOf("{items>")===0){l=l+"/parameters/"+s[r].slice(7,-1)}var d=this._mItemsByPaths[l];if(d){if(d._settingspath===e._settingspath){e=n({},e)}d._dependentFields=d._dependentFields||[];d._dependentFields.push({field:t,config:e})}}}}}};G.prototype.getBeforeLayerChange=function(e){if(!this._beforeLayerManifestChanges){this._beforeLayerManifestChanges={}}return this._beforeLayerManifestChanges[e]};G.prototype.getTranslationValueInTexts=function(e,t){var i="/texts/"+e;var a=this._settingsModel.getProperty(i)||{};return a[t]};G.prototype.deleteAllTranslationValuesInTexts=function(e){var t=this;var a=t._settingsModel.getData();if(!a||!a.texts){return}var n="/texts";var s=i(a.texts,500);for(var r in s){if(s[r][e]){delete s[r][e]}}this._settingsModel.setProperty(n,s)};G.prototype._addItem=function(e,a){var n=this.getMode();if(this.getAllowDynamicValues()===false||!e.allowDynamicValues){e.allowDynamicValues=false}if(this.getAllowSettings()===false){e.allowSettings=false}e.__cols=e.cols||2;if(e.visible===false||!e.translatable&&n==="translation"&&e.type!=="group"){return}if(e.type==="group"){e.expanded=e.expanded!==false;var s=this._createField(e,a);this.addAggregation("_formContent",s);if(e.hint){this._addHint(e.hint,this.getId()+"_"+a)}return}if(e.type==="separator"){var r=new E;this.addAggregation("_formContent",r);return}var o=null;var l=t.getConfiguration().getLanguage().replaceAll("_","-");if(n==="translation"){if(e.type!=="string"){return}if(typeof e.value==="string"&&e.value.indexOf("{")===0||typeof e.values!=="undefined"){return}e._language={value:e.value};e.cols=1;delete e.values;var d=i(e,500);d._settingspath+="/_language";d.editable=false;d.required=false;if(!G._oLanguages[l]&&l.indexOf("-")>-1){l=l.substring(0,l.indexOf("-"))}if(G._oLanguages[l]){var f=this.getTranslationValueInTexts(l,e.manifestpath);if(f){d.value=f}}if(!d.value){d.value="-"}var g=this._createLabel(d,a);this.addAggregation("_formContent",g);var u=this._createField(d,a+"_ori");u.isOrigLangField=true;this.addAggregation("_formContent",u);e.editable=e.visible=e.translatable;l=this._language;if(!this.getBeforeLayerChange(e.manifestpath)){e.value=e._translatedValue||""}var f=this.getTranslationValueInTexts(l,e.manifestpath);if(f){e.value=f}e.label=e._translatedLabel||"";e.required=false;var p=this._createField(e,a+"_trans");var h={onAfterRendering:function(e){var t=document.getElementById(p.getId());t.setAttribute("aria-label",g)}};p.addEventDelegate(h);this.addAggregation("_formContent",p)}else{o=this._createLabel(e,a);this.addAggregation("_formContent",o);var c=this.getBeforeLayerChange(e.manifestpath);if(c){e._beforeLayerChange=c}if(this._currentLayerManifestChanges&&this._currentLayerManifestChanges[e.manifestpath]){e.value=this._currentLayerManifestChanges[e.manifestpath];e._beforeLayerChange=e.value}if(e.type==="string"){l=this._language;var f=this.getTranslationValueInTexts(l,e.manifestpath);if(f){e.value=f}}var s=this._createField(e,a);var _={onAfterRendering:function(e){var t=document.getElementById(s.getId());t.setAttribute("aria-label",o)}};s.addEventDelegate(_);this.addAggregation("_formContent",s)}if(e.hint&&(!e.cols||e.cols===2)){this._addHint(e.hint,this.getId()+"_"+a)}e.cols=e.__cols;delete e.__cols};G.prototype._createHint=function(e,t){e=e.replace(/<a href/g,"<a target='blank' href");var i=new S(t+"_hint",{htmlText:e});return i};G.prototype._addHint=function(e,t){var i=this._createHint(e,t);this.addAggregation("_formContent",i)};G.prototype._getCurrentLanguageSpecificText=function(e){if(this._oTranslationBundle){var t=this._oTranslationBundle.getText(e,[],true);if(t===undefined){return""}return t}var i=this._language;if(!i){return""}var a=this._oEditorManifest.get("/sap.app/i18n"),n,s;if(!a){return""}if(typeof a==="string"){n=this.getBaseUrl()+a}else if(typeof a==="object"){if(a.bundleUrl){n=this.getBaseUrl()+a.bundleUrl}if(a.supportedLocales&&Array.isArray(a.supportedLocales)){s=a.supportedLocales;for(var r=0;r<s.length;r++){s[r]=s[r].replaceAll("_","-")}}}if(n){var o=[i];if(i.indexOf("-")>-1){o.push(i.substring(0,i.indexOf("-")))}if(!o.includes("en")){o.push("en")}o=this._filterSupportedFallbackLanguages(o,s);this._oTranslationBundle=I.create({url:n,async:false,locale:o[0],supportedLocales:o,fallbackLocale:"en"});return this._getCurrentLanguageSpecificText(e)}else{return""}};G.prototype._filterSupportedFallbackLanguages=function(e,t){if(Array.isArray(t)){var i=[];for(var a=0;a<e.length;a++){if(t.includes(e[a])){i.push(e[a])}}e=i}return e};G.prototype._startEditor=function(){var e=this.getAggregation("_formContent");if(e&&e.length>0){this.destroyAggregation("_formContent")}var i=this._settingsModel.getData();var a;if(i.form&&i.form.items){a=i.form.items;var s=false,r=this._destinationGroupAtTop?1:0,o=Object.keys(a),l=o.length,d=0;for(var f=r;f<l;f++){var g=a[o[f]];if(g.type==="destination"){if(!this._destinationGroupAtTop){break}d=f;continue}else if(g.type==="group"&&g.level!=="1"){break}else if(g.visible){s=true;break}}if(s){var u={type:"group",translatable:true,expanded:true,label:this._oResourceBundle.getText("EDITOR_PARAMETERS_GENERALSETTINGS"),_settingspath:"/form/items/generalPanel"};if(this._destinationGroupAtTop){var p={};var h=0;o.forEach(function(e){p[e]=a[e];if(h===d){p["generalPanel"]=u}h++});a=p}else{a=n({generalPanel:u},a)}i.form.items=a;this._settingsModel.setData(i)}}var c=this._settingsModel.getProperty("/");this._mItemsByPaths={};if(c.form&&c.form.items){a=c.form.items;var _=this._language||this.getLanguage()||t.getConfiguration().getLanguage().replaceAll("_","-");if(this.getMode()==="translation"){this._addItem({type:"group",translatable:true,expandable:false,expanded:true,label:this._oResourceBundle.getText("EDITOR_ORIGINALLANG")+": "+G._oLanguages[_]},"translationTopPanel")}for(var m in a){var g=a[m];if(g){g.label=g.label||m;var v;if(g.manifestpath){this._mItemsByPaths[g.manifestpath]=g;if(this.getMode()!=="translation"){v=this._currentLayerManifestChanges[g.manifestpath]}}g._changed=v!==undefined&&this.getMode()!=="translation";if(g.values){g.translatable=false}g._beforeValue=this._getManifestBeforelValue(g.manifestpath);if(g.type==="string"){g._translatedDefaultPlaceholder=this._getManifestDefaultValue(g.manifestpath);var y=null,b=g._translatedDefaultPlaceholder;if(b){if(this._isValueWithParameterSyntax(b)){g.translatable=false}if(this._isValueWithHandlebarsTranslation(b)){y=b.substring(2,b.length-2)}else if(b.startsWith("{i18n>")){y=b.substring(6,b.length-1)}if(y){g.translatable=true}else if(g.translatable&&this.getMode()==="translation"&&!this.getBeforeLayerChange(g.manifestpath)){g._translatedValue=g._translatedDefaultPlaceholder;g.value=g._translatedValue}}g._translatedPlaceholder=g._beforeValue;b=g._translatedPlaceholder;if(b){if(this._isValueWithParameterSyntax(b)){g.translatable=false}if(this._isValueWithHandlebarsTranslation(b)){y=b.substring(2,b.length-2)}else if(b.startsWith("{i18n>")){y=b.substring(6,b.length-1)}}if(g.value&&(g.value.indexOf("{context>")===0||g.value.indexOf("{{parameters")===0)){this.deleteAllTranslationValuesInTexts(g.manifestpath);y=null}var I=this.getTranslationValueInTexts(_,g.manifestpath);if(y){g._translatedValue=this.getModel("i18n").getResourceBundle().getText(y);if(g._changed){g.value=v}else if(g.value===g._translatedDefaultPlaceholder){g.value=g._translatedValue}if(this.getMode()==="translation"){var M=this._getCurrentLanguageSpecificText(y);if(M!==""){g._translatedValue=M}}else if(I){g.value=I}}else if(this.getMode()!=="translation"&&g.translatable&&I){g.value=I}if(this.getMode()==="translation"){if(this._isValueWithHandlebarsTranslation(g.label)){g._translatedLabel=this._getCurrentLanguageSpecificText(g.label.substring(2,g.label.length-2),true)}else if(g.label&&g.label.startsWith("{i18n>")){g._translatedLabel=this._getCurrentLanguageSpecificText(g.label.substring(6,g.label.length-1),true)}}}else if(g.type==="string[]"){var C=g.manifestpath.substring(0,g.manifestpath.lastIndexOf("/"))+"/valueItems";var P=this._manifestModel.getProperty(C);if(P){g.valueItems=P}var x=g.manifestpath.substring(0,g.manifestpath.lastIndexOf("/"))+"/valueTokens";var T=this._manifestModel.getProperty(x);if(T){g.valueTokens=T}}else if(typeof g.value==="object"&&g.type==="object"){if(typeof g.value._editable==="boolean"){g.value._dt={_editable:g.value._editable};delete g.value._editable}}else if(Array.isArray(g.value)&&g.value.length>0&&g.type==="object[]"){g.value.forEach(function(e){if(typeof e._editable==="boolean"){e._dt={_editable:e._editable};delete e._editable}})}if(g.label&&this._isValueWithHandlebarsTranslation(g.label)){var S=g.label.substring(2,g.label.length-2);if(S){g.label=this.getModel("i18n").getResourceBundle().getText(S)}}}}}for(var m in a){var g=a[m];this._addItem(g,m)}var D=this._settingsModel.getProperty("/form/height")!==undefined?this._settingsModel.getProperty("/form/height"):"350px",E=this._settingsModel.getProperty("/form/width")!==undefined?this._settingsModel.getProperty("/form/width"):"100%";if(this.getProperty("height")===""){this.setProperty("height",D);document.body.style.setProperty("--sapUiIntegrationEditorFormHeight",D);document.body.style.setProperty("--sapUiIntegrationEditorPreviewHeight",D)}if(this.getProperty("width")===""){this.setProperty("width",E);document.body.style.setProperty("--sapUiIntegrationEditorFormWidth",E)}if(this.getMode()!=="translation"&&this.getPreviewPosition()!=="separate"){this._initPreview()}Promise.all(this._aFieldReadyPromise).then(function(){this._ready=true;this.fireReady()}.bind(this))};G.prototype.setHeight=function(e){if(e){this.setProperty("height",e);document.body.style.setProperty("--sapUiIntegrationEditorFormHeight",e);document.body.style.setProperty("--sapUiIntegrationEditorPreviewHeight",e)}};G.prototype.setWidth=function(e){if(e){this.setProperty("width",e);document.body.style.setProperty("--sapUiIntegrationEditorFormWidth",e)}};G.prototype.destroy=function(){if(this._oPopover){this._oPopover.destroy()}if(this._oDesigntimeInstance){this._oDesigntimeInstance.destroy()}var i=this.getAggregation("_preview");if(i&&i.destroy){i.destroy()}var a=t.byId(H);if(a){a.destroy()}this._manifestModel=null;this._beforeManifestModel=null;this._oInitialManifestModel=null;this._settingsModel=null;this._destinationsModel=null;document.body.style.removeProperty("--sapUiIntegrationEditorFormWidth");document.body.style.removeProperty("--sapUiIntegrationEditorFormHeight");e.prototype.destroy.apply(this,arguments)};G.prototype._initPreview=function(){};G.prototype._applyDesigntimeDefaults=function(e){e=e||{};e.form=e.form||{};e.form.items=e.form.items||{};var t=e.form.items||e.form.items;for(var i in t){var a=t[i];if(a.type==="destination"){continue}if(a.manifestpath){a.value=this._manifestModel.getProperty(a.manifestpath)}if(a.visible===undefined||a.visible===null){a.visible=true}if(a.editable===undefined||a.editable===null){a.editable=true}if(this.getMode()!=="admin"){if(a.visibleToUser!==undefined){a.visible=a.visibleToUser}if(a.editableToUser!==undefined){a.editable=a.editableToUser}}if(typeof a.translatable!=="boolean"){a.translatable=false}if(!a.label){a.label=i}if(!a.type||a.type==="enum"){a.type="string"}if(a.value===undefined||a.value===null){switch(a.type){case"boolean":a.value=false;break;case"integer":case"number":a.value=0;break;case"string[]":a.value=[];break;case"object":a.value=undefined;break;case"object[]":a.value=undefined;break;default:a.value=""}}if(a.type==="group"){if(a.visible===undefined||a.value===null){a.visible=true}}a._settingspath="/form/items/"+i}};G.prototype._applyDesigntimeLayers=function(e){var t={};var i={};if(this._appliedLayerManifestChanges&&Array.isArray(this._appliedLayerManifestChanges)){for(var s=0;s<this._appliedLayerManifestChanges.length;s++){var r=this._appliedLayerManifestChanges[s][":designtime"];if(r){var o=Object.keys(r);for(var l=0;l<o.length;l++){var d=o[l],f=r[d];if(!d.endsWith("/pageAdminValues")&&typeof f==="object"){if(f.configuration&&f.configuration.parameterFromDestination){var g=f.configuration;delete g.parameterFromDestination;g.value=this._manifestModel.getProperty(g.manifestpath);g._settingspath="/form/items/"+f.parameter;this._settingsModel.setProperty(g._settingspath,g)}else{i[o[l]]=n(i[o[l]],f);continue}}else{this._settingsModel.setProperty(o[l],f)}}}var u=this._appliedLayerManifestChanges[s]["texts"];if(u){t=n(t,u)}}}if(this._currentLayerManifestChanges){var r=this._currentLayerManifestChanges[":designtime"];if(r){var o=Object.keys(r);for(var l=0;l<o.length;l++){var d=o[l],f=r[d];p=d.substring(0,d.lastIndexOf("/")+1)+"_next";if(!d.endsWith("/pageAdminValues")&&typeof f==="object"){if(!f.configuration||!f.configuration.parameterFromDestination){i[d]=n(i[d],f);continue}}if(!this._settingsModel.getProperty(p)){this._settingsModel.setProperty(p,{})}var p=d.substring(0,d.lastIndexOf("/")+1)+"_next",h=d.substring(d.lastIndexOf("/")+1);this._settingsModel.setProperty(p+"/"+h,f)}}var c=this._currentLayerManifestChanges["texts"];if(c){t=n(t,c)}}if(!a(t,{})){this._settingsModel.setProperty("/texts",t)}if(!a(i,{})){this._settingsModel.setProperty("/:designtime",i)}};G.prototype._createParameterDesigntime=function(e){var t={},i=this.getConfigurationPath()+"/parameters",a=this.getMode();if(e&&e.parameters){t.form=t.form||{};t.form.items=t.form.items||{};var s=t.form.items;Object.keys(e.parameters).forEach(function(t){s[t]=n({manifestpath:i+"/"+t+"/value",editable:a!=="translation",_settingspath:"/form/items/"+t},e.parameters[t]);var r=s[t];if(!r.type){r.type="string"}if(!r.hasOwnProperty("visible")){r.visible=true}})}return new r(t)};G.prototype._addDestinationSettings=function(e){var t=this._oDesigntimeInstance.getSettings(),i=this.getConfigurationPath()+"/destinations";t.form=t.form||{};t.form.items=t.form.items||{};if(t&&e&&e.destinations){this._destinationGroupAtTop=false;var a=t.form.items,s={},r=this.getHostInstance();var o={label:this._oResourceBundle.getText("EDITOR_DESTINATIONS")||"Destinations",type:"group",expanded:true,visible:true,_settingspath:"/form/items/destination.group"};if(a["destination.group"]){this._destinationGroupAtTop=Object.keys(a)[0]==="destination.group";o=n(o,a["destination.group"]);delete a["destination.group"]}s["destination.group"]=o;Object.keys(e.destinations).forEach(function(t){var r=n({manifestpath:i+"/"+t+"/name",visible:true,type:"destination",editable:true,allowDynamicValues:false,allowSettings:false,value:e.destinations[t].name,defaultValue:e.destinations[t].defaultUrl,_settingspath:"/form/items/"+[t+".destination"],_values:[],_destinationName:t},e.destinations[t]);if(typeof r.label==="undefined"){r.label=t}if(a[t+".destination"]){r=n(r,a[t+".destination"]);delete a[t+".destination"]}s[t+".destination"]=r});if(this._destinationGroupAtTop){t.form.items=n(s,a)}else{t.form.items=n(a,s)}var l=false;if(r){this._destinationsModel.setProperty("/_loading",true);this._destinationsModel.checkUpdate(true);this.getHostInstance().getDestinations().then(function(e){l=true;this._destinationsModel.setProperty("/_values",e);this._destinationsModel.setProperty("/_loading",false);this._destinationsModel.setSizeLimit(e.length);this._destinationsModel.checkUpdate(true)}.bind(this)).catch(function(){return this.getHostInstance().getDestinations()}.bind(this)).then(function(e){if(l){return}this._destinationsModel.setProperty("/_values",e);this._destinationsModel.setProperty("/_loading",false);this._destinationsModel.setSizeLimit(e.length);this._destinationsModel.checkUpdate(true)}.bind(this)).catch(function(e){this._destinationsModel.setProperty("/_loading",false);this._destinationsModel.checkUpdate(true);y.error("Can not get destinations list from '"+r.getId()+"'.")}.bind(this))}}};G.prototype._deleleDestinationSettings=function(){var e=this._oDesigntimeInstance.getSettings();e.form=e.form||{};e.form.items=e.form.items||{};delete e.form.items["destination.group"];for(var t in e.form.items){var i=e.form.items[t];if(i.type==="destination"){delete e.form.items[t]}}};G.prototype._getManifestDefaultValue=function(e){return this._oInitialManifestModel.getProperty(e)};G.prototype._getManifestBeforelValue=function(e){return this._beforeManifestModel.getProperty(e)};G.prototype._isValueWithHandlebarsTranslation=function(e){if(typeof e==="string"){return!!e.match(j)}return false};G.prototype._isValueWithParameterSyntax=function(e){if(typeof e==="string"){return!!e.match(N)}return false};G.prototype.prepareFieldsInKey=function(e){this._sKeySeparator=e.values.keySeparator;if(!this._sKeySeparator){this._sKeySeparator="#"}var t=e.values.item.key;this._aFields=t.split(this._sKeySeparator);for(var i in this._aFields){if(this._aFields[i].startsWith("{")){this._aFields[i]=this._aFields[i].substring(1)}if(this._aFields[i].endsWith("}")){this._aFields[i]=this._aFields[i].substring(0,this._aFields[i].length-1)}}};G.prototype.getKeyFromItem=function(e){var t="";this._aFields.forEach(function(i){t+=e[i].toString()+this._sKeySeparator}.bind(this));if(t.endsWith(this._sKeySeparator)){t=t.substring(0,t.length-this._sKeySeparator.length)}return t};G._contextEntries={empty:{label:k.getText("EDITOR_CONTEXT_EMPTY_VAL"),type:"string",description:k.getText("EDITOR_CONTEXT_EMPTY_DESC"),placeholder:"",value:""},"editor.internal":{label:k.getText("EDITOR_CONTEXT_EDITOR_INTERNAL_VAL"),todayIso:{type:"string",label:k.getText("EDITOR_CONTEXT_EDITOR_TODAY_VAL"),description:k.getText("EDITOR_CONTEXT_EDITOR_TODAY_DESC"),tags:[],placeholder:k.getText("EDITOR_CONTEXT_EDITOR_TODAY_VAL"),customize:["format.dataTime"],value:"{{parameters.TODAY_ISO}}"},nowIso:{type:"string",label:k.getText("EDITOR_CONTEXT_EDITOR_NOW_VAL"),description:k.getText("EDITOR_CONTEXT_EDITOR_NOW_DESC"),tags:[],placeholder:k.getText("EDITOR_CONTEXT_EDITOR_NOW_VAL"),customize:["dateFormatters"],value:"{{parameters.NOW_ISO}}"},currentLanguage:{type:"string",label:k.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),description:k.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),tags:["technical"],customize:["languageFormatters"],placeholder:k.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),value:"{{parameters.LOCALE}}"}}};G._oLanguages={};G._appendThemeVars=function(){var e=["sapUiButtonHoverBackground","sapUiBaseBG","sapUiContentLabelColor","sapUiTileSeparatorColor","sapUiHighlight","sapUiListSelectionBackgroundColor","sapUiNegativeText","sapUiCriticalText","sapUiPositiveText","sapUiChartScrollbarBorderColor"];var t=x.get({name:e,callback:function(e){}});if(t){for(var i in t){document.body.style.setProperty("--"+i,t[i])}}};G.init=function(){this.init=function(){};G._appendThemeVars();t.attachThemeChanged(function(){G._appendThemeVars()});var e=sap.ui.require.toUrl("sap.ui.integration.editor.css.Editor".replace(/\./g,"/")+".css");C(e);P.loadResource("sap/ui/integration/editor/languages.json",{dataType:"json",failOnError:false,async:true}).then(function(e){G._oLanguages=e})};G.init();return G});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/EditorResourceBundles", ["sap/ui/base/ManagedObject","sap/base/i18n/ResourceBundle"],function(e,r){"use strict";var s=e.extend("sap.ui.integration.editor.EditorResourceBundles",{metadata:{library:"sap.ui.integration",properties:{url:{type:"string",defaultValue:""},languages:{type:"object"},supportedLocales:{type:"array"}}}});s.prototype.loadResourceBundles=function(){var e=this.getUrl();var s=this.getSupportedLocales();var a=this.getLanguages();this._aEditorResourceBundles=[];for(var t in a){var u;if(e){var i=[t];if(t.indexOf("-")>-1){i.push(t.substring(0,t.indexOf("-")))}if(!i.includes("en")){i.push("en")}u=r.create({url:e,async:false,locale:t,supportedLocales:i})}var o={language:a[t],resourceBundle:u,isSupportedLocale:true};if(Array.isArray(s)&&!s.includes(t)&&!s.includes(t.replace("-","_"))){o.isSupportedLocale=false}this._aEditorResourceBundles[t]=o}};s.prototype.getResourceBundles=function(){if(!this._aEditorResourceBundles){this.loadResourceBundles()}return this._aEditorResourceBundles};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/Extension", ["sap/ui/integration/Extension","sap/base/Log"],function(t,i){"use strict";var o=t.extend("sap.ui.integration.editor.Extension");o.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oEditorInterface=null;this._oEditor=null};o.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._oEditorInterface=null;this._oEditor=null};o.prototype.setFormatters=function(o){t.prototype.setFormatters.apply(this,arguments);if(!this._oEditor){return}if(this._oEditor.getAggregation("_extension")!==this){i.error("Extension formatters must be set before the initialization of the editor. Do this inside Extension#init().")}};o.prototype.onEditorReady=function(){};o.prototype.getEditor=function(){return this._oEditorInterface};o.prototype._setEditor=function(t,i){this._oEditor=t;this._oEditorInterface=i};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/Manifest", ["sap/ui/integration/util/Manifest","./Merger"],function(e,t){"use strict";var i=e.extend("sap.ui.integration.editor.Manifest");i.prototype.mergeDeltaChanges=function(e){return t.mergeDelta(e,this._aChanges,this._sSection)};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/Merger", ["sap/base/util/merge","sap/ui/model/json/JSONModel","sap/ui/core/Core"],function(e,r,a){"use strict";var t={layers:{admin:0,content:5,translation:10,all:20},mergeManifestPathChanges:function(e,r){Object.keys(r).forEach(function(a){if(a.charAt(0)==="/"){var t=r[a];e.setProperty(a,t)}})},mergeDelta:function(a,n,o){var i=e({},a);if(typeof o==="undefined"){o="sap.card"}if(Array.isArray(n)&&n.length>0){var s;n.forEach(function(a){if(a.content){e(i[o],a.content)}else{s=s||new r(i);t.mergeManifestPathChanges(s,a)}})}return i},mergeDesigntimeMetadata:function(r,a){var t=e({},r);a.forEach(function(e){var r=e.content.entityPropertyChange||[];r.forEach(function(e){var r=e.propertyPath;switch(e.operation){case"UPDATE":if(t.hasOwnProperty(r)){t[r]=e.propertyValue}break;case"DELETE":delete t[r];break;case"INSERT":if(!t.hasOwnProperty(r)){t[r]=e.propertyValue}break;default:break}})});return t}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/Settings", ["sap/ui/core/Control","sap/m/Popover","sap/ui/model/json/JSONModel","sap/m/Button","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/VBox","sap/m/HBox","sap/m/Select","sap/ui/core/ListItem","sap/m/Label","sap/m/Text","sap/m/Title","sap/m/CheckBox","sap/m/Menu","sap/m/MenuItem","sap/m/Input","sap/ui/integration/util/ParameterMap","sap/base/util/merge","sap/ui/core/Core","sap/m/Table","sap/m/Column","sap/m/ColumnListItem","sap/m/ScrollContainer","sap/base/util/ObjectPath","sap/ui/integration/util/BindingHelper","sap/ui/integration/editor/fields/ObjectListField","sap/ui/layout/form/SimpleForm","sap/ui/integration/util/Utils","sap/base/util/deepClone","sap/base/util/deepEqual"],function(e,t,a,n,s,i,l,r,o,d,u,p,_,g,c,m,f,v,y,b,S,h,w,T,I,x,P,E,V,D,M,C,O){"use strict";var A=e.extend("sap.ui.integration.editor.Settings",{metadata:{library:"sap.ui.integration"},renderer:null});var R=h.getLibraryResourceBundle("sap.ui.integration"),N,L,j=null,B,U,F,$,K,k,H,G,W,z,Y,Z,q,X=450,J=360;A.prototype.setConfiguration=function(e){this._originalConfig=e;e=S({},e);var t=new a(e);this.setModel(t,"currentSettings");this.bindElement({path:"currentSettings>/"})};A.prototype.open=function(e,t,a,n,s,i,l){var r=this.getModel("currentSettings").getData(),o=s.getParameterId();if(r.values&&r.values.item){this.prepareFieldsInKey(r)}j=this;q=Q(r,s);this.addDependent(q);this.oHost=n;this.fnApply=i;this.fnCancel=l;this._oOpener=s;L=true;e.addDependent(this);if(!r.allowDynamicValues&&r.values&&r.values.item){h.byId(o+"_settings_popover_scroll_container").setHeight("155px")}this.getModel("currentSettings").checkUpdate(true,true);ve(R.getText("EDITOR_SELECT_FROM_LIST"),[]);if(t){var d=a.getDomRef().offsetHeight;d=d>X?X:d;q.setContentHeight(d-50+"px");var u;var p="Right";var _=a.getDomRef().getBoundingClientRect();var g=e.getDomRef().getBoundingClientRect();var c=g.x+g.width/2-_.x;var m=_.width;if(2*c>m){p="Left";u=c-g.width*1.5}else{u=m-c-g.width}u=u>J?J:u;q.setContentWidth(u+"px");q.setPlacement(p);K.setValue(e._label);q.openBy(e)}else{q.open()}N=this.getModel("currentSettings");if(N.getProperty("/type")==="destination"){ie(o)}else if(N.getProperty("/_hasDynamicValue")){le(o)}else if(N.getProperty("/_hasSettings")){se(o)}else if(N.getProperty("/allowDynamicValues")){le(o)}else if(N.getProperty("/allowSettings")){se(o)}};A.prototype._applyCurrentSettings=function(){this.fnApply(N.getData())};A.prototype._cancelCurrentSettings=function(){this.fnCancel(this._originalConfig)};A.prototype.destroy=function(){this.removeDependent(q);return e.prototype.destroy.apply(this,arguments)};function Q(e,a){var s=a.getParameterId(),i=ae(e,s),o=ne(e,s,a),d=ue(s),u=pe(s),p=_e(e,a),_=ge(e,a),g=new t({id:s+"_settings_popover",showArrow:true,contentWidth:"400px",showHeader:false,horizontalScrolling:false,verticalScrolling:false,modal:false,footer:new l({content:[o,new r,new n(s+"_settings_popover_ok_btn",{text:R.getText("EDITOR_MORE_OK"),type:"Emphasized",press:function(){if(e.type==="destination"){if(a._oNewParameter){var t=Object.assign({},a._oNewParameter);var n=C(Object.assign([],a._oValue.value));n=n.sort(function(e,t){if(!e._dt||!e._dt._position||!t._dt||!t._dt._position){return 0}return e._dt._position-t._dt._position});n.forEach(function(e){delete e._dt});t.configuration.values.data.json={values:n};re("pageAdminNewDestinationParameter",t)}}else{if(e.values&&e.values.item){var i=h.byId(s+"_settings_popover_pav_table"),l=i.getSelectedContexts(),r=[];if(N.getProperty("/selectedValues")==="Partion"){for(var o=0;o<l.length;o++){var d=j.getKeyFromItem(l[o].getObject());r.push(d)}re("pageAdminValues",r)}else{re("pageAdminValues",[])}}}j._applyCurrentSettings();L=false;g.close()}}),new n(s+"_settings_popover_cancel_btn",{text:R.getText("EDITOR_MORE_CANCEL"),press:function(){g.close()}})]}),afterClose:function(){if(L){j._cancelCurrentSettings()}L=true;g.destroy()},afterOpen:function(){window.requestAnimationFrame(function(){g.getDomRef()&&(g.getDomRef().style.opacity="1")});if(e.values&&e.values.item){var t=h.byId(s+"_settings_popover_pav_table"),a=N.getProperty("/_next/pageAdminValues");if(a!==undefined&&a.length>0){t.removeSelections();N.setProperty("/selectedValues","None");var n=N.getProperty("/_next/pageAdminValues"),i=t.getItems();for(var l=0;l<n.length;l++){for(var r=0;r<i.length;r++){var o=j.getKeyFromItem(i[r].getBindingContext().getObject());if(n[l]===o){t.setSelectedItem(i[r])}}}N.setProperty("/selectedValues","Partion")}else{t.selectAll();N.setProperty("/selectedValues","All")}}}});g.setCustomHeader(i);g.addContent(d);g.addContent(u);g.addContent(p);g.addContent(_);g.addStyleClass("sapUiIntegrationFieldSettings");return g}function ee(e){z=new i({text:R.getText("EDITOR_MORE_SETTINGS"),tooltip:R.getText("EDITOR_MORE_SETTINGS"),key:"settings",icon:"sap-icon://action-settings",width:"50%",press:function(t){se(e)}}).addStyleClass("setbtn");return z}function te(e){z=ee(e);Y=new s(e+"_settings_popover_segmented_btn",{width:"100%",visible:"{= ${currentSettings>allowDynamicValues} && ${currentSettings>allowSettings}}",items:[new i({text:R.getText("EDITOR_MORE_DYNAMICVALUES"),tooltip:R.getText("EDITOR_MORE_DYNAMICVALUES"),key:"dynamic",icon:"{= ${currentSettings>_hasDynamicValue} ? 'sap-icon://display-more' : 'sap-icon://enter-more'}",width:"50%",press:function(t){le(e)}}).addStyleClass("dynbtn sel"),z]});return Y}function ae(e,t){Y=te(t);var a=new g(t+"_settings_popover_dynamicvalue_txt",{text:R.getText("EDITOR_MORE_DYNAMICVALUES"),tooltip:R.getText("EDITOR_MORE_DYNAMICVALUES"),visible:e.type!=="destination"&&e.allowDynamicValues&&!e.allowSettings}).addStyleClass("sapUiTinyMagin");var n=new g(t+"_settings_popover_settings_txt",{text:R.getText("EDITOR_MORE_SETTINGS"),visible:e.type!=="destination"&&!e.allowDynamicValues&&e.allowSettings}).addStyleClass("sapUiTinyMagin");var s=new g(t+"_settings_popover_transform_txt",{text:R.getText("EDITOR_MORE_TRANSFORM"),visible:e.type==="destination"}).addStyleClass("sapUiTinyMagin");var i=new l({content:[Y,a,n,s]}).addStyleClass("headertitle");return i}function ne(e,t,a){Z=new n(t+"_settings_popover_reset_btn",{type:"Transparent",text:R.getText("EDITOR_MORE_RESET"),enabled:"{= ${currentSettings>_next/visible} === (typeof(${currentSettings>visibleToUser}) === 'undefined' ? false : !${currentSettings>visibleToUser}) || ${currentSettings>_next/editable} === (typeof(${currentSettings>editableToUser}) === 'undefined' ? false : !${currentSettings>editableToUser}) || ${currentSettings>_next/allowDynamicValues} === (typeof(${currentSettings>allowDynamicValues}) === 'undefined' ? false : !${currentSettings>allowDynamicValues}) || ${currentSettings>_beforeValue} !== ${currentSettings>value} || ${currentSettings>type} === 'destination'}",tooltip:R.getText("EDITOR_MORE_SETTINGS_P_ADMIN_RESET"),press:function(){if(e.type==="destination"){re("pageAdminNewDestinationParameter",undefined);a._oValue=undefined;a._oNewParameter=undefined}else{var n=typeof N.getProperty("/visibleToUser")==="undefined"?true:N.getProperty("/visibleToUser");var s=typeof N.getProperty("/editableToUser")==="undefined"?true:N.getProperty("/editableToUser");var i=typeof N.getProperty("/allowDynamicValues")==="undefined"?true:N.getProperty("/allowDynamicValues");re("visible",n);re("editable",s);re("allowDynamicValues",i);if(N.getProperty("/translatable")){if(N.getProperty("/_translatedDefaultValue")&&N.getProperty("/_translatedDefaultValue")!==""){N.setProperty("/value",N.getProperty("/_translatedDefaultValue"))}else if(N.getProperty("/_translatedDefaultPlaceholder")&&N.getProperty("/_translatedDefaultPlaceholder")!==""){N.setProperty("/value",N.getProperty("/_translatedDefaultPlaceholder"))}N.setProperty("/_changed",false)}else{N.setProperty("/value",N.getProperty("/_beforeValue"));if(e.type.indexOf("object")>-1){a.setValue(N.getProperty("/_beforeValue"));a.resetControl()}}if(e.values&&e.values.item){var l=h.byId(t+"_settings_popover_pav_table"),r=N.getProperty("/_next/pageAdminValues"),o=l.getItems();if(r!==undefined&&r.length>0&&r.length<o.length){l.removeSelections();for(var d=0;d<r.length;d++){for(var u=0;u<o.length;u++){var p=j.getKeyFromItem(o[u].getBindingContext().getObject());if(r[d]===p){l.setSelectedItem(o[u])}}}N.setProperty("/selectedValues","Partion")}else{l.selectAll();N.setProperty("/selectedValues","All")}}}var _=h.byId(t+"_settings_popover");_.getFooter().getContent()[2].firePress()}}).addStyleClass("resetbutton");return Z}function se(e){U.setVisible(true);B.setVisible(false);F.setVisible(false);h.byId(e+"_settings_popover_segmented_btn").setSelectedKey("settings");var t=h.byId(e+"_settings_popover_currentvalue");t.setVisible(false)}function ie(e){F.setVisible(true);U.setVisible(false);B.setVisible(false);var t=h.byId(e+"_settings_popover_currentvalue");t.setVisible(false)}function le(e){U.setVisible(false);F.setVisible(false);B.setVisible(true);h.byId(e+"_settings_popover_segmented_btn").setSelectedKey("dynamic");var t=j.getModel("contextflat"),a=t._getValueObject(N.getProperty("/value"));if(a&&a.object.label){K.setValue(a.object.label);ve(a.object.description,a.object.tags);if(a.path==="empty"){K.setValue(a.object.label)}be(a)}var n=h.byId(e+"_settings_popover_currentvalue");n.setVisible(true)}function re(e,t){if(!N.getProperty("/_next")){N.setProperty("/_next",{})}N.setProperty("/_next/"+e,t)}function oe(e,t){var a=[];for(var n in e){if(e[n]&&e[n].label){var s=new v({text:e[n].label});s.__data=e[n];e[n].pathvalue=(t+"/"+n).substring(1);a.push(s);var i=oe(e[n],t+"/"+n);for(var l=0;l<i.length;l++){s.addItem(i[l])}}}return a}var de=[{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Relative date/datetime text of the value",description:"Should be applied to dynamic values of type date or datetime or string values that represent a datetime in the format 'yyyy-MM-ddZhh:mm:ss'",example:"4 weeks ago",syntax:"handlebars",binding:"{= format.dateTime('__|VALUE|__',{relative:true})}"},{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Short date/datetime text of the value",description:"Should be applied to dynamic values of type date, date-time or text values that represent a datetime in the format 'yyyy-MM-ddZhh:mm:ss.sss'",example:"9/18/20, 2:09 PM",binding:"{= format.dateTime('__|VALUE|__',{style:'short'})}"},{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Medium date/datetime text of the value",description:"Should be applied to dynamic values of type date, date-time or text values that represent a datetime in the format 'yyyy-MM-ddThh:mm:ss.sssZ'",example:"Sep 18, 2020, 2:09:04 PM",binding:"{= format.dateTime('__|VALUE|__',{style:'medium'})}"},{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Long date, date-time text of the value",description:"Should be applied to dynamic values of type date or date-time or string values that represent a datetime in the format 'yyyy-MM-ddThh:mm:ss.sssZ'",example:"Sep 18, 2020, 2:09:04 PM",binding:"{= format.dateTime('__|VALUE|__',{style:'long'})}"}];function ue(e){B=new o({visible:true});B.addStyleClass("sapUiSmallMargin");K=new y(e+"_settings_popover_dynamicvalue_input",{width:"100%",showValueHelp:true,valueHelpOnly:true,valueHelpRequest:function(){if(k){k.destroy()}k=new f({});H=oe(B.getModel("context").getData(),"");for(var e=0;e<H.length;e++){k.addItem(H[e])}k.attachItemSelected(function(e){var t=e.getParameter("item").__data;ve(t.description||"",t.tags||[]);K.setValue(t.placeholder||t.label);var a=j.getModel("contextflat");be(a._getPathObject(t.pathvalue))});K.addDependent(k);k.addStyleClass("sapUiIntegrationFieldSettingsMenu");k.openBy(K,false,null,null,"1 0")}});K.addStyleClass("selectvariable");var t=new _(e+"_settings_popover_dynamicvalue_label",{text:"Select a dynamic value"});K.addAriaLabelledBy(t);var a=new o({items:[t,K]});B.addItem(a);$=new g(e+"_settings_popover_dynamicvalue_desc_txt",{text:"",maxLines:6,renderWhitespace:true});a=new o({width:"100%",items:[$]});$.addStyleClass("description");B.addItem(a);if(de.length===-1){G=new u(e+"_settings_popover_dynamicvalue_format_select",{width:"100%",enabled:true,change:function(){W.setText(G.getSelectedItem()._data.description)}});a=new o({visible:false,items:[new _({text:"Customize the value..."}),G]});B.addItem(a);W=new g(e+"_settings_popover_dynamicvalue_format_label",{text:"",maxLines:4,renderWhitespace:true});W.addStyleClass("description");a=new o({width:"100%",items:[W]});B.addItem(a);B.getItems()[2].getItems()[0].addStyleClass("sapUiTinyMarginTop")}B.getItems()[0].getItems()[0].addStyleClass("sapUiTinyMarginTop");return B}function pe(e){var t=new g(e+"_settings_popover_actualvalue_label",{text:R.getText("EDITOR_ACTUAL_VALUE")});var a=new y(e+"_settings_popover_actualvalue_input",{value:{path:"currentSettings>_currentContextValue"},editable:false});a.addAriaLabelledBy(t);var n=new o(e+"_settings_popover_currentvalue",{width:"100%",items:[t,a]});n.addStyleClass("currentval");return n}function _e(e,t){var s=t.getParameterId();U=new o({visible:false});if(e.type==="destination"){return U}var i=(new o).addStyleClass("commonSettings");U.addItem(i);i.addItem(new c({text:R.getText("EDITOR_MORE_SETTINGS_P_ADMIN"),wrapping:true}).addStyleClass("stitle"));var l=new _(s+"_settings_popover_adminvisible_label",{text:R.getText("EDITOR_MORE_SETTINGS_P_ADMIN_VISIBLE"),wrapping:true});var r=new m(s+"_settings_popover_adminvisible_checkbox",{selected:"{= ${currentSettings>_next/visible} !== false}",select:function(e){re("visible",e.getParameter("selected"))}});r.addAriaLabelledBy(l);i.addItem(new d({alignItems:"Start",justifyContent:"SpaceBetween",items:[l,r]}).addStyleClass("cbrow"));var u=new _(s+"_settings_popover_admineditable_label",{text:R.getText("EDITOR_MORE_SETTINGS_P_ADMIN_EDIT"),wrapping:true});var p=new m(s+"_settings_popover_admineditable_checkbox",{selected:"{= ${currentSettings>_next/editable} !== false}",enabled:"{= ${currentSettings>_next/visible} !== false}",select:function(e){re("editable",e.getParameter("selected"))}});p.addAriaLabelledBy(u);i.addItem(new d({alignItems:"Start",justifyContent:"SpaceBetween",items:[u,p]}).addStyleClass("cbrow"));var f=new _(s+"_settings_popover_allowdynamicvalues_label",{text:R.getText("EDITOR_MORE_SETTINGS_P_ADMIN_DYN"),wrapping:true});var v=new m(s+"_settings_popover_allowdynamicvalues_checkbox",{selected:"{= ${currentSettings>_next/allowDynamicValues} !== false}",enabled:"{= ${currentSettings>_next/visible} !== false && ${currentSettings>_next/editable} !== false}",select:function(e){re("allowDynamicValues",e.getParameter("selected"))}});v.addAriaLabelledBy(f);i.addItem(new d({alignItems:"Start",justifyContent:"SpaceBetween",visible:"{= ${currentSettings>allowDynamicValues}!== false}",items:[f,v]}).addStyleClass("cbrow"));if(e.values&&e.values.item){var y;if(e.values.data){var b=e.values.data.path,S;if(b&&b!=="/"){if(b.startsWith("/")){b=b.substring(1)}if(b.endsWith("/")){b=b.substring(0,b.length-1)}S=b.split("/");y=P.get(["_values",S],e)}else{y=P.get(["_values"],e)}}else if(t.getParent().getParent().getAggregation("_extension")){var h=e.values.path;if(h.length>1){h=h.substring(1)}y=P.get([h],t.getModel().getData())}i.addItem(new d({alignItems:"Start",justifyContent:"SpaceBetween",visible:"{= ${currentSettings>_next/visible} !== false && ${currentSettings>_next/editable} !== false}",items:[new _(s+"_settings_popover_allowselectedvalues_label",{text:R.getText("EDITOR_MORE_SETTINGS_P_ADMIN_VALUES_LIST"),tooltip:R.getText("EDITOR_MORE_SETTINGS_P_ADMIN_VALUES_LIST_TOOLTIPS"),wrapping:false}),new n(s+"_settings_popover_allowselectedvalues_all_btn",{type:"Transparent",enabled:y!==undefined,icon:{path:"currentSettings>selectedValues",formatter:function(e){if(e==="All"){return"sap-icon://multiselect-all"}else if(e==="Partion"){return"sap-icon://multi-select"}else if(e==="None"){return"sap-icon://multiselect-none"}}},tooltip:{path:"currentSettings>selectedValues",formatter:function(e){if(e==="All"){return R.getText("EDITOR_MORE_SETTINGS_P_ADMIN_DESELECT_ALL")}else{return R.getText("EDITOR_MORE_SETTINGS_P_ADMIN_SELECT_ALL")}}},press:function(){ce(s)}})]}).addStyleClass("cbrow"));var V=new w({id:s+"_settings_popover_pav_table",mode:"MultiSelect",select:function(e){me(e,s)},columns:[new T]}).addStyleClass("tableHdr");var D=e.values.item.text,M=new a(y);V.setModel(M);var C=(new I).addStyleClass("pavlistItem");if(y){for(var O=0;O<y.length;O++){C.addCell(new d({items:[new g({text:E.createBindingInfos(D)}).addStyleClass("pavTblCellText")]})).addStyleClass("pavlistItem")}}V.bindItems("/",C);var A=new x({id:s+"_settings_popover_scroll_container",height:"125px",vertical:true,horizontal:false,visible:"{= ${currentSettings>_next/visible} !== false && ${currentSettings>_next/editable} !== false}",content:[V]}).addStyleClass("SettingsPAVTable");U.addItem(A)}return U}function ge(e,t){F=new o({visible:false});if(e.type!=="destination"){return F}var n=new _({text:R.getText("EDITOR_MORE_TRANSFORM_P_ADMIN_LABEL"),wrapping:true});var s=new y({id:t.getAssociation("_editor")+"_"+t.getParameterKey()+".toParameter_label",value:"{/configuration/label}"});s.addAriaLabelledBy(n);var i=new _({text:R.getText("EDITOR_MORE_TRANSFORM_P_ADMIN_MAPPINGS"),wrapping:true});var l=1,r=C(t.getModel("destinations").getData()._values),d=e._next?e._next.pageAdminNewDestinationParameter:undefined;if(!t._oValue){var u=d?d.configuration.values.data.json.values:[];if(Array.isArray(u)&&u.length>0){u.forEach(function(e){e.label=e.label||e.name;e._dt={_uuid:M.generateUuidV4(),_position:l};l++})}else{var p=t.getAggregation("_field").getSelectedItem();var g=p?p.getBindingContext("destinations").getPath():undefined;if(g){var c=C(p.getModel("destinations").getProperty(g));c.label=c.label||c.name;c._dt={_uuid:M.generateUuidV4(),_position:l};u=[c]}}t._oValue={value:u}}else{t._oValue.value.forEach(function(e){e._dt=e._dt||{};var t=C(e);delete t._dt;if(typeof t==="object"&&!O(t,{})){e.label=t.label||t.name}})}var m=new a(t._oValue);t._oDestinationValueObjectConfig={label:"Destination Mappings",type:"object[]",values:{data:{path:"/value"},allowAdd:true},showSelectionColumn:false,properties:{label:{label:"Label",column:{width:"50%"},cell:{text:"{label}",editable:true}},name:{label:"Name",column:{width:"50%"},cell:{type:"string",values:{data:{json:r,path:"/"},item:{text:"{settings>name}",key:"{settings>name}"},sorter:"name"},change:function(e){var t=e.getSource();var a=t.getBindingContext().getObject();if(a&&!a.label&&a.name){a.label=a.name}}}}},value:t._oValue.value};var f=new V(t.getAssociation("_editor")+"_"+t.getParameterKey()+".toParameter_field",{configuration:t._oDestinationValueObjectConfig,allowPopover:false,parameterKey:t.getParameterKey()+".toParameter",objectBindings:{currentSettings:{path:"currentSettings>/"}}});f.setAssociation("_editor",t.getAssociation("_editor"));f.setModel(m);f.setModel(new a(t._oDestinationValueObjectConfig),"currentSettings");var v=new D({layout:"ResponsiveGridLayout",labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:12,emptySpanXL:1,emptySpanL:1,emptySpanM:1,emptySpanS:0,columnsXL:1,columnsL:1,columnsM:1,content:[n,s,i,f]});if(!t._oNewParameter){t._oNewParameter={parameter:t.getParameterKey()+".toParameter",configuration:{label:e.label,manifestpath:e.manifestpath,type:"string",visible:true,editable:true,values:{data:{path:"/values"},item:{text:"{label}",key:"{name}"}},parameterFromDestination:true}};if(d){delete d.configuration.values.data.json;t._oNewParameter=Object.assign(t._oNewParameter,d)}}var b=new a(t._oNewParameter);v.setModel(b);F.addItem(v);return F}function ce(e){var t=h.byId(e+"_settings_popover_pav_table"),a=h.byId(e+"_settings_popover_reset_btn"),n=N.getProperty("/selectedValues");if(n==="All"){t.removeSelections();N.setProperty("/selectedValues","None")}else{t.selectAll();N.setProperty("/selectedValues","All")}if(!a.getEnabled()){a.setEnabled(true)}}function me(e,t){var a=e.getSource(),n=a.getSelectedItems(),s=a.getItems(),i=h.byId(t+"_settings_popover_reset_btn");if(n.length===s.length){N.setProperty("/selectedValues","All")}else if(n.length<s.length&&n.length>0){N.setProperty("/selectedValues","Partion")}else{N.setProperty("/selectedValues","None")}if(!i.getEnabled()){i.setEnabled(true)}}function fe(e,t){e=e||[];G.removeAllItems();var a=[];G.addItem(new p({text:"No customizing needed",key:""}));for(var n=0;n<de.length;n++){var s=de[n],i=new p({text:s.label,key:"key"+n});i._data=s;if(s.sourceTypes.indexOf(t)>-1||e.indexOf(s.formatMethod)>-1){G.addItem(i)}else{a.push(i)}}for(var n=0;n<a.length;n++){G.addItem(a[n])}}function ve(e,t){t=t||[];if(t.indexOf("technical")>-1){e=e+"\n"+R.getText("EDITOR_MORE_DYNAMICVALUES_TECHHINT")}$.setText(e)}function ye(e){if(de.length===-1){if(!e){G.removeAllItems();G.addItem(new p({text:"No customizing available for this value"}));W.setText("");G.setEnabled(false)}else{fe(e.customize,e.type);G.setEnabled(true)}}}function be(e){if(e){N.setProperty("/_hasDynamicValue",true);var t=e.value;N.setProperty("/value",t);N.setProperty("/_contextpath",e.path);if(e.object&&e.object.value&&e.object.value.indexOf("{{")===0){N.setProperty("/_currentContextValue",b.processPredefinedParameter(e.object.value));ye(e.object)}else{if(e.path==="empty"){N.setProperty("/value","");N.setProperty("/_currentContextValue","");N.setProperty("/_hasDynamicValue",false);ye()}else{ye(e.object);if(e.object&&e.object.hasOwnProperty("value")){N.setProperty("/_currentContextValue",e.object.value)}else{j.oHost.getContextValue(e.path+"/value").then(function(t){if(t===null){N.setProperty("/_currentContextValue","(not available)")}else{N.setProperty("/_currentContextValue",t)}e.object&&(e.object.value=t)})}}}}}A._private=function(){return{oPopover:q,oSegmentedButton:Y,oSettingsButton:z,oDynamicPanel:B,oSettingsPanel:U,oTransformPanel:F,oCurrentModel:N,updateCurrentValue:be,oCurrentInstance:j,oDynamicValueField:K,oResetToDefaultButton:Z,getMenuItems:function(){return H},getMenu:function(){return k}}};A.prototype.prepareFieldsInKey=function(e){this._sKeySeparator=e.values.keySeparator;if(!this._sKeySeparator){this._sKeySeparator="#"}var t=e.values.item.key;this._aFields=t.split(this._sKeySeparator);for(var a in this._aFields){if(this._aFields[a].startsWith("{")){this._aFields[a]=this._aFields[a].substring(1)}if(this._aFields[a].endsWith("}")){this._aFields[a]=this._aFields[a].substring(0,this._aFields[a].length-1)}}};A.prototype.getKeyFromItem=function(e){var t="";this._aFields.forEach(function(a){t+=e[a].toString()+this._sKeySeparator}.bind(this));if(t.endsWith(this._sKeySeparator)){t=t.substring(0,t.length-this._sKeySeparator.length)}return t};return A});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/BaseField", ["sap/ui/core/Control","sap/m/Text","sap/m/Input","sap/m/MultiInput","sap/m/Token","sap/ui/core/Core","sap/ui/integration/util/BindingHelper","sap/ui/core/ListItem","sap/base/util/ObjectPath","sap/base/util/deepEqual","sap/base/util/deepClone","sap/ui/core/Fragment","sap/ui/integration/util/Validators","sap/ui/model/json/JSONModel","sap/m/List","sap/m/CustomListItem","sap/m/VBox","sap/ui/core/CustomData","sap/ui/model/Sorter"],function(e,t,i,s,a,n,r,o,l,g,u,d,f,h,p,y,c,_,v){"use strict";var m="sap/ui/integration/editor/fields/viz";var b=e.extend("sap.ui.integration.editor.fields.BaseField",{metadata:{library:"sap.ui.integration",properties:{configuration:{type:"object"},specialButton:{type:"object"},mode:{type:"string"},host:{type:"object"},visible:{type:"boolean",defaultValue:true},parameterKey:{type:"string"},allowPopover:{type:"boolean",defaultValue:true}},aggregations:{_field:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_dynamicField:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{_messageIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_messageStrip:{type:"sap.m.MessageStrip",multiple:false,visibility:"hidden"},_editor:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{afterInit:{},validateFailed:{}}},renderer:{apiVersion:2,render:function(e,t){var i=t.getAggregation("_field"),s=t._getDynamicField();e.openStart("div",t);e.class("sapUiIntegrationEditorItemField");if(i&&i.getWidth){}if(!t.getVisible()){e.style("display","none")}e.openEnd();if(t.getVisible()){e.openStart("span");e.class("sapUiIntegrationEditorEditor");if(t._hasDynamicValue()){e.style("width","1px");e.style("opacity","0")}else{e.style("width","100%")}e.openEnd();e.renderControl(i);e.close("span");if(t._hasDynamicValue()){e.openStart("span");e.class("sapUiIntegrationEditorSettings");e.openEnd();e.openStart("span");e.class("sapUiIntegrationEditorSettingsField");e.style("width","100%");e.style("opacity","1");e.openEnd();e.renderControl(s);e.close("span");e.close("span")}e.openStart("div",t.getId()+"-ms");e.style("height","0");e.openEnd();e.close("div")}e.close("div")}}});b.prototype.init=function(){this._readyPromise=new Promise(function(e){this._fieldResolver=e}.bind(this))};b.prototype.getMessagestrip=function(){var e=this.getAssociation("_messageStrip");return n.byId(e)};b.prototype.getMessageIcon=function(){var e=this.getAssociation("_messageIcon");return n.byId(e)};b.prototype._removeValidationMessage=function(){var e=this.control,t=e.getParent().getMessageIcon();if(t){t.setVisible(false)}if(e.getEnabled()){e.setEnabled(false)}};b.prototype.getResourceBundle=function(){return this.getModel("i18n").getResourceBundle()};b.prototype.setConfiguration=function(e,t){if(e!==this.getConfiguration()){this._sanitizeValidationSettings(e);this.setProperty("configuration",e,t);if(e){Promise.resolve().then(function(){this.initEditor(e)}.bind(this))}}return this};b.prototype._sanitizeValidationSettings=function(e){e.validations=e.validations||[];if(e.validation&&e.validations&&Array.isArray(e.validations)){e.validations.push(e.validation);delete e.validation}if(e.validation&&!e.validations){e.validations=[e.validation];delete e.validation}if(e.required){e.validations.unshift({required:true,type:"error"})}};b.prototype.deleteTranslationValuesInTexts=function(e){var t=this;var i=t.getConfiguration();var s="/texts";var a=this._settingsModel.getData();if(!a||!a.texts){return}var n=u(a.texts,500);if(e){if(n[e]){delete n[e][i.manifestpath];if(g(n[e],{})){delete n[e]}if(g(n,{})){delete a.texts;this._settingsModel.setData(a)}else{this._settingsModel.setProperty(s,n)}}}else{for(var r in n){t.deleteTranslationValuesInTexts(r)}}};b.prototype._triggerValidation=function(e){if(g(e,this._preChangedValue)&&this._messageFrom==="validation"){return}this._preChangedValue=e;var t=this.getConfiguration();var i=false;if(t.required){i=true}else if(t.type==="string"&&e){i=true}else if((t.type==="integer"||t.type==="number")&&!isNaN(e)){if(e!==""){i=true}}else if(t.type==="boolean"){i=true}else if(t.type==="string[]"&&Array.isArray(e)){i=true}if(t.validations&&Array.isArray(t.validations)&&i){for(var s=0;s<t.validations.length;s++){var a=this._handleValidation(t.validations[s],e);if(typeof a==="boolean"&&!a){this.fireValidateFailed();return false}else if(typeof a.then==="function"){a.then(function(e){if(!e){this.fireValidateFailed();return false}}.bind(this))}}this._hideValueState()}return true};b.prototype._requestData=function(e){var t=this.control.getParent();var i=t.getConfiguration();var s=t._oDataProviderFactory.create(e.data);t.getModel("currentSettings").setProperty(i._settingspath+"/_loading",true);var a=s.getData();return a.then(function(s){t.getModel("currentSettings").setProperty(i._settingspath+"/_loading",false);var a=e.data.path||"/";if(a.startsWith("/")){a=a.substring(1)}if(a.endsWith("/")){a=a.substring(0,a.length-1)}var n=a.split("/");var r=l.get(n,s);return r})};b.prototype._handleValidation=function(e,t){var i=this.getConfiguration(),s=f[i.type];var a=function(a,n){var r;if(typeof e.message==="function"){r=e.message(t,i,n)}else{r=e.message}if(!r){if(e._txt){r=this.getResourceBundle().getText(s[e._txt],[e[a]])}else{r=this.getResourceBundle().getText(s[a+"Txt"],[e[a]])}}this._showValueState(e.type||"error",r)}.bind(this);if(e["validate"]){var n={control:this.getAggregation("_field"),requestData:this._requestData,removeValidationMessage:this._removeValidationMessage};var r=e["validate"];return Promise.resolve(r(t,i,n)).then(function(e){var t=e.isValid;if(typeof t==="undefined"){t=e}var i=e.data?e.data:undefined;if(!t){a("validate",i);return false}else{this._hideValueState(true,false);return true}}.bind(this))}else{for(var o in e){if(s){var l=s[o];e._txt="";if(l){if(!l(t,e[o],e)){a(o);return false}}}}}return true};b.prototype.onAfterRendering=function(){this._applyMessage();var e=this.getMessagestrip();if(e&&e.getDomRef()){e.getDomRef().style.opacity="0"}};b.prototype._applyMessage=function(){var e=n.byId(this.getAssociation("_messageIcon"));if(this.getAssociation("_messageIcon")&&e){var t=e.getDomRef();if(t){t.classList.remove("error");t.classList.remove("warning");t.classList.remove("success");if(this._message){t.classList.add(this._message.type)}}}if(this._message&&(this._message.type==="error"||this._message.type==="warning")){var i=this._message.type==="error"?"Error":"Warning";this._setCurrentProperty("hasError",true);this._setCurrentProperty("errorType",i)}else{this._setCurrentProperty("hasError",false);this._setCurrentProperty("errorType","None")}};b.prototype._showValueState=function(e,t,i){var s=this.getAggregation("_field"),a=e.substring(0,1).toUpperCase()+e.substring(1);this._message={enum:a,type:e,message:t,atControl:false};this._messageFrom="validation";if(i){this._messageFrom="request"}var n=this.getMessagestrip();if(s&&s.setValueState){this._message.atControl=true;if(s.setShowValueStateMessage){s.setShowValueStateMessage(false)}s.setValueState(a);s.setValueStateText(t)}else if(n&&n.getVisible()&&s.getMetadata().getName()!=="sap.m.Switch"){this._showMessage()}this._applyMessage()};b.prototype._hideValueState=function(e,t){if(!this.getParent()){return}var i=this.getMessagestrip();if(this._message){if(e&&this._messageFrom==="request"||!e&&this._messageFrom==="validation"){var s=this.getAggregation("_field");this._message={enum:"Success",type:"success",message:"Corrected",atControl:this._message.atControl};this._messageFrom="validation";if(e){this._messageFrom="request"}if(this._messageto){clearTimeout(this._messageto)}this._messageto=setTimeout(function(){this._messageto=null;this._applyMessage();if(!this._message&&s.setValueState){s.setValueState("None")}}.bind(this),1500);this._applyMessage();if(i){if(i.getDomRef()){i.getDomRef().style.opacity="0"}i.onAfterRendering=null}if(s.setValueState){s.setValueState("Success")}if(s.setValueStateText){s.setValueStateText("")}this._message=null}if(!this._message&&e&&t){this._triggerValidation(this.getConfiguration().value)}}};b.prototype.onfocusin=function(e){if(e&&e.target.classList.contains("sapMBtn")){return}this._showMessage()};b.prototype.onfocusout=function(e){this._hideMessage()};b.prototype._showMessage=function(){if(!this.getParent()){return}var e=this.getMessagestrip();if(this._message&&e){e.applySettings({type:this._message.enum,text:this._message.message});var t=this;e.onAfterRendering=function(){e.getDomRef().style.zIndex="1";e.getDomRef().style.opacity="1";t.getDomRef("ms")&&t.getDomRef("ms").appendChild(e.getDomRef());var i=t.getAggregation("_field");if(t._message&&!t._message.atControl){e.getDomRef().style.marginTop="0";e.getDomRef().style.marginLeft="0"}var s=i.getDomRef()?i.getDomRef().offsetWidth-5:100;if(s<=100){s=i.getParent().getDomRef()?i.getParent().getDomRef().offsetWidth-35:100}e.getDomRef().style.width=s+"px"};e.rerender()}};b.prototype._hideMessage=function(){var e=this.getMessagestrip();var t=this.getAggregation("_field"),i=t.getDomRef()&&t.getDomRef().contains(window.document.activeElement);if(e){if(!i&&e.getDomRef()){e.getDomRef().style.opacity="0";e.getDomRef().style.zIndex="-1"}e.onAfterRendering=null}};b.prototype.getParameterId=function(){return this.getAssociation("_editor")+"_"+this.getParameterKey()};b.prototype.initEditor=function(t){var i;this._settingsModel=this.getModel("currentSettings");this.initVisualization&&this.initVisualization(t);if(this._visualization.editor){i=this._visualization.editor}else if(this._visualization.type){if(typeof this._visualization.type==="string"){if(this._visualization.type.indexOf("/")===-1){this._visualization.type=m+"/"+this._visualization.type;this._visualization.settings=this._visualization.settings||{value:"{currentSettings>value}",editable:t.editable}}sap.ui.require([this._visualization.type],function(e){this._visualization.type=e;this.initEditor(t)}.bind(this));return}i=new this._visualization.type(this.getParameterId()+"_control",this._visualization.settings||{})}else if(this._visualization.fragment){if(typeof this._visualization.fragment==="string"){if(!this._visualization.controller){this._visualization.controller=this._visualization.fragment+".controller"}if(typeof this._visualization.controller==="string"){sap.ui.require([this._visualization.controller],function(e){this._visualization.controller=new e;this._visualization.controller.init();this._visualization.controller.setField(this);this.initEditor(t)}.bind(this))}else if(typeof this._visualization.controller==="object"){d.load({name:this._visualization.fragment,controller:this._visualization.controller}).then(function(e){this._visualization.fragment=e;this.initEditor(t)}.bind(this))}else{d.load({name:this._visualization.fragment}).then(function(e){this._visualization.fragment=e;this.initEditor(t)}.bind(this))}return}i=this._visualization.fragment}if(i instanceof e){this.setAggregation("_field",i);if(i.attachChange){i.attachChange(function(e){if(e.mParameters.value===""){var t=this.getConfiguration();if(t.type==="string[]"){this._triggerValidation(t.value)}else{this._triggerValidation(e.getParameter("value"))}}}.bind(this))}var s=this._settingsModel.bindProperty("value",this.getBindingContext("currentSettings"));s.attachChange(function(){this._triggerValidation(t.value)}.bind(this));this._triggerValidation(t.value)}var a=this.getMode();t.allowSettings=t.allowSettings||t.allowSettings!==false&&a==="admin";t.allowDynamicValues=t.allowDynamicValues||t.allowDynamicValues!==false;t._changeDynamicValues=t.visible&&t.editable&&(t.allowDynamicValues||t.allowSettings)&&a!=="translation";if(t._changeDynamicValues){this._getDynamicField()}this._applySettings(t);this.fireAfterInit()};b.prototype.initVisualization=function(){};b.prototype._hasDynamicValue=function(){var e=this._getCurrentProperty("value");var t=typeof e==="string"&&(e.indexOf("{context>")===0||e.indexOf("{{parameters")===0);this._setCurrentProperty("_hasDynamicValue",t);return t};b.prototype._hasSettings=function(){var e=this.getConfiguration();if(e._next){var t=e.hasOwnProperty("visibleToUser")?e.visibleToUser:true;var i=e.hasOwnProperty("editableToUser")?e.editableToUser:true;var s=e._next.visible===false?false:e._next.editable;var a=e.hasOwnProperty("allowDynamicValues")?e.allowDynamicValues:true;e._hasSettings=e._next.visible===!t||s===!i||e._next.allowDynamicValues===!a||typeof e._next.pageAdminNewDestinationParameter!=="undefined"}else{e._hasSettings=false;if(e.hasOwnProperty("editableToUser")||e.hasOwnProperty("visibleToUser")){e._next={}}if(e.hasOwnProperty("editableToUser")){e._next.editable=e.editableToUser}if(e.hasOwnProperty("visibleToUser")){e._next.visible=e.visibleToUser}}return e._hasSettings};b.prototype._getDynamicField=function(){var e=this.getAggregation("_dynamicField");if(!e){var e=new s(this.getParameterId()+"_dynamic_control",{showValueHelp:false});this.setAggregation("_dynamicField",e)}return e};b.prototype._hideDynamicField=function(){var e=this._getDynamicField(),t=this.getAggregation("_field");if(e.getDomRef()){var i=e.getDomRef().parentNode.style;i.width="1px";i.opacity=0;i=t.getDomRef().parentNode.style;t.getDomRef().style.visibility="visible";i.width="100%";i.opacity=1}};b.prototype._showDynamicField=function(){var e=this._getDynamicField(),t=this.getAggregation("_field");if(e.getDomRef()){var i=e.getDomRef().parentNode.style;i.width="100%";i.opacity=1;i=t.getDomRef().parentNode.style;t.getDomRef().style.visibility="hidden";i.width="1px";i.opacity=0}};b.prototype._setCurrentProperty=function(e,t){if(this._getCurrentProperty(e)!==t){this._settingsModel.setProperty(e,t,this.getBindingContext("currentSettings"))}};b.prototype._getCurrentProperty=function(e){return this._settingsModel.getProperty(e,this.getBindingContext("currentSettings"))};b.prototype._applySettings=function(e){var t=this._getDynamicField(),i=this.getModel("contextflat")._getValueObject(e.value);t.removeAllTokens();if(!this._getCurrentProperty("_changeDynamicValues")){t.setEnabled(false)}if(i&&i.path!=="empty"){if(i.object.value&&i.object.value.indexOf("{{")==0){this._setCurrentProperty("value",i.object.value)}else{this._setCurrentProperty("value",i.value)}t.addToken(new a({text:i.object.label,delete:function(){this._setCurrentProperty("value","");var e=this.getAggregation("_field");e.setValue("");e.fireChange();if(!this._hasDynamicValue()){this._hideDynamicField()}this._applyButtonStyles();window.setTimeout(function(){this.getAggregation("_field").focus()}.bind(this),100)}.bind(this)}));var s=this.getConfiguration();if(s.type==="string"&&s.translatable){this.deleteTranslationValuesInTexts()}}else{this._setCurrentProperty("value",e.value);this._setCurrentProperty("_changed",e._changed);this._hideDynamicField()}this._setCurrentProperty("_next",e._next);this._applyButtonStyles();if(!this._hasDynamicValue()){this._hideDynamicField()}else{this._showDynamicField()}this._fieldResolver&&this._fieldResolver();this._fieldResolver=null};b.prototype._cancelSettings=function(){this._applyButtonStyles();if(!this._hasDynamicValue()){this._hideDynamicField()}};b.prototype._applyButtonStyles=function(){if(!this._settingsButton){return}if(!this._hasDynamicValue()){this._settingsButton.removeStyleClass("dynamicvalue")}else{this._settingsButton.addStyleClass("dynamicvalue")}if(!this._hasSettings()){this._settingsButton.removeStyleClass("settings")}else{this._settingsButton.addStyleClass("settings")}};b.prototype.isFilterBackend=function(){var e=this.getConfiguration();var t=false;if(e&&e.values&&e.values.data){if(e.values.data.request&&e.values.data.request.parameters&&e.values.data.request.parameters.$filter&&e.values.data.request.parameters.$filter.indexOf("{currentSettings>suggestValue}")>-1){t=true}else if(e.values.data.request&&e.values.data.request.url&&e.values.data.request.url.indexOf("{currentSettings>suggestValue}")>-1){t=true}}return t};b.prototype.formatListItem=function(e){var t=new o;for(var i in e){t.bindProperty(i,r.createBindingInfos(e[i]))}return t};b.prototype.getPopoverPlacement=function(e){var t="Right";var i=e.getDomRef().getBoundingClientRect().x;var s=document.body.offsetWidth;if(2*i>s){t="Left"}return t};b.prototype.buildTranslationsList=function(e){return new p(e+"",{growing:true,growingThreshold:60,items:{path:"languages>/translatedLanguages",key:"key",template:new y({content:[new c({items:[new t({text:"{languages>description}"}),new i({value:"{languages>value}",editable:"{languages>editable}"})]})],customData:[new _({key:"{languages>key}",value:"{languages>description}"})]}),sorter:[new v({path:"status",descending:true,group:true})]}})};b.prototype.buildTranslationsModel=function(e){var t=this;var i=t.getResourceBundle();var s=new h(e);s.attachPropertyChange(function(e){var t=e.getParameter("context");var a=s.getProperty(t.getPath());var n=i.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_NOTUPDATED");if(a.value!==a.originValue){n=i.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_UPDATED")}var r=false;var o=s.getData();for(var l=0;l<o.translatedLanguages.length;l++){var g=o.translatedLanguages[l];if(g.value!==g.originValue){r=true;break}}s.setProperty(t.getPath("status"),n,null,true);s.setProperty("/isUpdated",r,null,true)});return s};return b});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/BooleanField", ["sap/ui/integration/editor/fields/BaseField","sap/m/CheckBox"],function(e,t){"use strict";var i=e.extend("sap.ui.integration.editor.fields.BooleanField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});i.prototype.initVisualization=function(e){var i=e.visualization;if(!i){i={type:t,settings:{selected:{path:"currentSettings>value"},editable:e.editable}};e.withLabel=true}else if(i.type==="Switch"){i.type="sap/m/Switch"}this._visualization=i};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/DateField", ["sap/ui/integration/editor/fields/BaseField","sap/m/DatePicker","sap/ui/core/date/UI5Date"],function(e,t,a){"use strict";var i=e.extend("sap.ui.integration.editor.fields.DateField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});i.prototype.initVisualization=function(e){var i=e.visualization;var n=e.formatter;if(e.value!==""){e.value=a.getInstance(e.value)}if(!i){i={type:t,settings:{value:{path:"currentSettings>value",type:"sap.ui.model.type.Date",formatOptions:n},editable:e.editable,width:"100%",change:function(e){if(e.getParameters().valid){var t=e.getSource();t.getBinding("value").setValue(t.getDateValue());t.getBinding("value").checkUpdate()}else{var t=e.getSource();t.getBinding("value").setValue("")}}}}}this._visualization=i};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/DateTimeField", ["sap/ui/integration/editor/fields/BaseField","sap/m/DateTimePicker","sap/ui/core/date/UI5Date"],function(e,t,a){"use strict";var i=e.extend("sap.ui.integration.editor.fields.DateTimeField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});i.prototype.initVisualization=function(e){var i=e.visualization;var n=e.formatter;if(e.value!==""){e.value=a.getInstance(e.value)}if(!i){i={type:t,settings:{value:{path:"currentSettings>value",type:"sap.ui.model.type.DateTime",formatOptions:n},editable:e.editable,width:"100%",change:function(e){if(e.getParameters().valid){var t=e.getSource();t.getBinding("value").setValue(t.getDateValue().toISOString());t.getBinding("value").checkUpdate()}else{var t=e.getSource();t.getBinding("value").setValue("");t.getBinding("value").checkUpdate(true)}}}}}this._visualization=i};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/DestinationField", ["sap/ui/integration/editor/fields/BaseField","sap/ui/core/ListItem","sap/m/ComboBox","sap/ui/model/Sorter"],function(t,e,i,a){"use strict";var n=t.extend("sap.ui.integration.editor.fields.DestinationField",{metadata:{library:"sap.ui.integration"},renderer:t.getMetadata().getRenderer()});n.prototype.initVisualization=function(t){var n=t.visualization;if(!n){n={type:i,settings:{busy:{path:"destinations>_loading"},selectedKey:{path:"currentSettings>value"},width:"100%",editable:{path:"currentSettings>editable"},items:{path:"destinations>_values",template:new e({text:"{destinations>name}",key:"{destinations>name}"}),sorter:[new a({path:"name"})]}}}}this._visualization=n};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/GroupField", ["sap/ui/integration/editor/fields/BaseField","sap/m/Panel","sap/m/IconTabBar","sap/m/IconTabFilter","sap/m/MessageStrip","sap/ui/core/Core"],function(e,t,r,i,n,a){"use strict";var s=e.extend("sap.ui.integration.editor.fields.GroupField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});s.prototype.initVisualization=function(e){var i=e.visualization;if(!i||i.type==="Panel"){i={type:t,settings:{headerText:e.label,visible:e.visible,expandable:e.expandable!==false,expanded:"{currentSettings>expanded}",width:"auto",backgroundDesign:"Transparent",objectBindings:{currentSettings:{path:"currentSettings>"+(e._settingspath||"/form/items")},items:{path:"items>/form/items"},context:{path:"context>/"}},expand:function(e){var t=e.getParameter("expand");if(t){var r=e.getSource();var i=this.getConfiguration();if(!r._level){r._level=i.level||0}var n=r._level==="1"&&this.getParent().getParent()?this.getParent().getParent().getAggregation("_messageStrip"):this.getParent().getAggregation("_messageStrip");if(n===null){n=a.byId(this.getAssociation("_messageStrip"))}r.addContent(n);r.focus()}}.bind(this)}}}else if(i.type==="Tab"){i={type:r,settings:{expandable:e.expandable!==false,visible:e.visible,expanded:"{currentSettings>expanded}",objectBindings:{currentSettings:{path:"currentSettings>"+(e._settingspath||"/form/items")},items:{path:"items>/form/items"},context:{path:"context>/"}},select:this.checkErrorsInIconTabBar.bind(this)}}}this._visualization=i;this.attachAfterInit(this._afterInit)};s.prototype._afterInit=function(){var e=this.getConfiguration();var a=this.getAggregation("_field");if(a instanceof t){if(this.getMode()!=="translation"){var s=this.getResourceBundle();var o=new n({id:this.getParameterId()+"_strip",showIcon:false,visible:"{= !${currentSettings>expanded} && ${currentSettings>hasError} === true}",text:{path:"currentSettings>errorType",formatter:function(e){var t="";switch(e){case"Error":t=s.getText("EDITOR_GROUP_ERRORS");break;case"Warning":t=s.getText("EDITOR_GROUP_WARNINGS");break;default:}return t}},type:"{currentSettings>errorType}",objectBindings:{currentSettings:{path:"currentSettings>"+(e._settingspath||"/form/items")}}});if(e.level!=="1"){o.setModel(this._settingsModel,"currentSettings")}o.addStyleClass("sapUiIntegrationEditorPanelMessageStrip");a._messageStrip=o}a._cols=e.cols||2;a._level=e.level||0;var g={onAfterRendering:function(i){var n=i.srcControl;var a=document.getElementById(n.getId());a.setAttribute("aria-label",e.label);if(n._subItems&&n._subItems.length>0){this.checkErrorsInSubItems(this._settingsModel,n)}var s=n._messageStrip;if(n._level!=="1"&&s){s.rerender()}if(n.getExpanded()){var o=n.getContent();o.forEach(function(e){if(e.isA("sap.ui.integration.editor.fields.GroupField")){var i=e.getAggregation("_field");if(i instanceof t&&i._subItems&&i._subItems.length>0){e.checkErrorsInSubItems(e._settingsModel,i)}else if(i instanceof r&&i.getItems().length>0){e.checkErrorsInIconTabBar()}}})}}.bind(this)};a.addEventDelegate(g)}else if(a instanceof r){var l=new i(this.getParameterId()+"_control_icontabfilter",{text:e.label,visible:e.visible,objectBindings:{currentSettings:{path:"currentSettings>"+(e._settingspath||"/form/items")},items:{path:"items>/form/items"},context:{path:"context>/"}}});a.addItem(l);a.setBackgroundDesign("Transparent");a.setHeaderBackgroundDesign("Transparent");a.addStyleClass("sapUiIntegrationEditorSubGroup");if(this.getMode()!=="translation"){var d=new n({id:this.getParameterId()+"_strip",showIcon:false,visible:false,objectBindings:{currentSettings:{path:"currentSettings>"+(e._settingspath||"/form/items")}}});d.addStyleClass("sapUiIntegrationEditorTabMessageStrip");a._messageStrip=d}a._level=e.level||0}};s.prototype.checkErrorsInIconTabBar=function(e){var t=this.getAggregation("_field"),r=t.getSelectedKey(),n=t.getItems(),s=t.getExpanded(),o=false;for(var g=0;g<n.length;g++){if(!s){o=true}else if(n[g].getId()!==r){o=true}else if(n[g].getId()===r){o=false}if(o){var l=false,d="None";if(n[g]._subItems&&n[g]._subItems.length>0){var u=n[g].getModel("currentSettings");var c=this.checkErrorsInSubItems(u,n[g]);l=c.hasError;d=c.errorType}if(l){var p=new i,f=n[g];if(f.getItems().length>0){f.removeAllItems()}f.addItem(p);this._handleITBValidation(f,d);if(f._oExpandButton===undefined){this._delayHandleITBValidation(f,d)}else{this._handleITBValidation(f,d)}}}else if(n[g].getItems().length>0){n[g].removeItem(n[g].getItems()[0]);if(n[g]._oExpandButton){n[g]._oExpandButton.visible=false}var h=this.getParent().getParent().getAggregation("_messageStrip");if(h===null){h=a.byId(this.getAssociation("_messageStrip"))}n[g].addContent(h)}}};s.prototype.checkErrorsInSubItems=function(e,t){var r=false;var i="None";for(var n=0;n<t._subItems.length;n++){var s=t._subItems[n].settingspath;var o=a.byId(t._subItems[n].itemId);if(e.getProperty(s+"/hasError")===true&&o.getVisible()){r=true;var g=e.getProperty(s+"/errorType");if(g==="Error"){i="Error";break}else if(g==="Warning"&&i!=="Error"){i="Warning"}}}e.setProperty("hasError",r,this.getBindingContext("currentSettings"));e.setProperty("errorType",i,this.getBindingContext("currentSettings"));return{hasError:r,errorType:i}};s.prototype._handleITBValidation=function(e,t){var r=this.getResourceBundle();if(e.getItems().length>0&&e._oExpandButton){var i=e._oExpandButton;var n=null;if(t==="Error"){n=r.getText("EDITOR_GROUP_ERRORS");i.setIcon("sap-icon://message-error");i.addStyleClass("errorBTNImage")}else if(t==="Warning"){n=r.getText("EDITOR_GROUP_WARNINGS");i.setIcon("sap-icon://message-warning");i.addStyleClass("warningBTNImage")}i.setTooltip(null);i.addEventDelegate({onAfterRendering:function(e){var t=document.getElementById(i.getId());t.setAttribute("aria-label","With validation errors");t.setAttribute("title","")}});i.setEnabled(false);i.addStyleClass("errorBTN").addStyleClass("errorBTNDisabled");var s=a.byId(this.getParameterId()+"_strip");i.addEventDelegate({onmouseover:function(){s.setVisible(true);s.setType(t);s.setText(n)},onmouseout:function(){s.setVisible(false)}},this)}};s.prototype._delayHandleITBValidation=function(e,t){var r=this;var i=setInterval(function(){if(e._oExpandButton){r._handleITBValidation(e,t);clearInterval(i)}},50)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/IntegerField", ["sap/ui/integration/editor/fields/BaseField","sap/m/Input"],function(e,t){"use strict";var a=e.extend("sap.ui.integration.editor.fields.IntegerField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});a.prototype.initVisualization=function(e){var a=e.visualization;var i=e.formatter;if(!a){a={type:t,settings:{value:{path:"currentSettings>value",type:"sap.ui.model.type.Integer",formatOptions:i},editable:e.editable,type:"Number",parseError:function(e){var t=e.getSource(),a=null;if(t.getValue()!==""){if(e.getParameters()&&e.getParameters().exception&&e.getParameters().exception.message){a=e.getParameters().exception.message}else{a=e.getId()}t.getParent()._showValueState("error",a)}else{t.getParent()._showValueState("none","")}}}}}else if(a.type==="Slider"){a.type="sap/m/Slider"}this._visualization=a};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/NumberField", ["sap/ui/integration/editor/fields/BaseField","sap/m/Input"],function(t,e){"use strict";var i=t.extend("sap.ui.integration.editor.fields.NumberField",{metadata:{library:"sap.ui.integration"},renderer:t.getMetadata().getRenderer()});i.prototype.initVisualization=function(t){var i=t.visualization;var a=t.formatter;if(!i){i={type:e,settings:{value:{path:"currentSettings>value",type:"sap.ui.model.type.Float",formatOptions:a},editable:t.editable,type:"Number"}}}this._visualization=i};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/ObjectField", ["sap/ui/integration/editor/fields/BaseField","sap/m/Text","sap/m/TextArea","sap/m/Input","sap/m/NavContainer","sap/m/Page","sap/m/Popover","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/Button","sap/ui/model/json/JSONModel","sap/ui/table/Table","sap/ui/table/Column","sap/ui/table/rowmodes/Fixed","sap/m/Label","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/base/util/deepEqual","sap/ui/core/Icon","sap/m/Switch","sap/m/CheckBox","sap/m/MessageBox","sap/m/MessageToast","sap/base/util/deepClone","sap/m/Link","sap/ui/layout/form/SimpleForm","sap/base/util/merge","sap/ui/model/Sorter","sap/ui/integration/util/Utils","sap/m/table/columnmenu/Menu","sap/m/ComboBox","sap/ui/core/ListItem"],function(e,t,a,r,o,n,i,l,s,d,u,p,_,c,g,v,f,T,b,h,O,y,P,E,m,I,D,S,L,w,C,x){"use strict";var V=/\{\{(?!parameters.)(?!destinations.)([^\}\}]+)\}\}/g;var A=e.extend("sap.ui.integration.editor.fields.ObjectField",{metadata:{library:"sap.ui.integration",events:{tableUpdated:{}}},renderer:e.getMetadata().getRenderer()});A.prototype.initVisualization=function(e){var t=this;t._newObjectTemplate={_dt:{_selected:true,_uuid:""}};var a=e.visualization;if(!a){if(e.value&&!e.properties&&(!e.values||e.values&&!e.values.metadata)){t.parseValueProperties()}if(e.values){a=t.createTableVisualization(e)}else if(e.properties){a=t.createSimpleFormVisualization(e)}else{a=t.createTextAreaVisualization(e)}e.withLabel=true}this._visualization=a;this.attachAfterInit(this._afterInit)};A.prototype._afterInit=function(){var e=this;var t=this.getAggregation("_field");if(t instanceof I){t.addStyleClass("sapUiIntegrationEditorItemObjectFieldForm");var a=E(e.getConfiguration().value,500)||{};t.setModel(new u({value:a,editMode:"Properties"}))}else if(t instanceof p){t.addStyleClass("sapUiIntegrationEditorItemObjectFieldTable");e._oMenu=new w;var r=t.getColumns();for(var o=0;o<r.length;o++){if(r[o].getFilterProperty()||r[o].getSortProperty()){r[o].setHeaderMenu(e._oMenu.getId())}}}};A.prototype.parseValueProperties=function(){var e=this;var t=e.getConfiguration();if(typeof t.value==="object"&&!T(t.value,{})&&!Array.isArray(t.value)&&!t.properties){var a={};for(var r in t.value){if(r!=="_dt"){var o=typeof t.value[r];var n=o==="string"?{}:{type:o};a[r]=n}}if(!T(a,{})){t.properties=a;t._propertiesParsedFromValue=true}}};A.prototype.createTableVisualization=function(e){var t=this;var a=t.createTableToolbar(e);var r=[];var o=e.values?e.values.data.path||"/":"/value";if(e.values&&e.values.metadata){r={path:"meta>/"+e.values.metadata.namespace+"."+e.values.metadata.entityTypeName,filters:new v({path:"$kind",operator:f.EQ,value1:"Property"}),factory:t.columnFactory.bind(t)}}else{r=t.buildTableColumns()}var n={type:p,settings:{rowMode:new c({rowCount:5}),busy:"{currentSettings>_loading}",busyIndicatorDelay:200,columns:r,selectionBehavior:"RowOnly",rowSelectionChange:t.onTableSelectionChange.bind(t),extension:a,filter:t.onFilter.bind(t)}};if(e.type==="object"){n.settings.rows="{"+o+"}"}else{n.settings.rows="{path: '"+o+"', sorter: {path: '_dt/_position', descending: false}}"}return n};A.prototype.createSimpleFormVisualization=function(e){var t=this;var a=t.getParameterId();var r=t.getResourceBundle();var o=function(){var e=this.getAggregation("_field").getModel();e.checkUpdate(true);var t=e.getProperty("/value")||{};if(!t._dt){t._dt={_uuid:L.generateUuidV4()}}else if(!t._dt._uuid){t._dt._uuid=L.generateUuidV4()}t=E(t,500);this.setValue(t)}.bind(t);var n=t.createFormContents(o,"/value/",false,t.openTranslationPopup);var i=new d(a+"_control_form_editmode_btn",{icon:{path:"/editMode",formatter:function(e){if(e==="Properties"){return"sap-icon://syntax"}else{return"sap-icon://form"}}},tooltip:{path:"/editMode",formatter:function(e){if(e==="Properties"){return r.getText("EDITOR_FIELD_OBJECT_FORM_EDITMODE_JSON")}else{return r.getText("EDITOR_FIELD_OBJECT_FORM_EDITMODE_PROPERTIES")}}},press:function(){var e=t.getAggregation("_field").getModel();var a=e.getProperty("/editMode");if(a==="Properties"){e.setProperty("/editMode","Json")}else{e.setProperty("/editMode","Properties")}}});var u=new d(a+"_control_form_delete_btn",{icon:"sap-icon://delete",tooltip:r.getText("EDITOR_FIELD_OBJECT_DELETE"),visible:e.enabled,enabled:{path:"currentSettings>value",formatter:function(e){if(!e||e===""){return false}return true}},press:function(e){t.setValue(undefined);var a=t.getAggregation("_field").getModel();var r=a.getProperty("/value");if(r&&r._dt&&r._dt._uuid){t.deleteTranslationValueInTexts(undefined,r._dt._uuid)}a.setProperty("/value",{});a.checkUpdate(true)}});var p={type:I,settings:{layout:"ResponsiveGridLayout",visible:e.visible,labelSpanXL:2,labelSpanL:2,labelSpanM:2,labelSpanS:12,emptySpanXL:1,emptySpanL:1,emptySpanM:1,emptySpanS:0,columnsXL:1,columnsL:1,columnsM:1,toolbar:new l({content:[new s,i,u]}).addStyleClass("sapMTB"),content:n}};return p};A.prototype.createTextAreaVisualization=function(e){var t=this;var r={type:a,settings:{value:{path:"currentSettings>value",formatter:function(e){if(!e||e===""){return undefined}e=JSON.stringify(e,null,"\t");if(typeof e==="object"&&!e.length){e=e.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(e){return e.substring(3,e.length-3)})}return e}},editable:"{config/editable}",width:"100%",enabled:"{config/enabled}",placeholder:"{config/placeholder}",visible:e.visible,change:this.onChangeOfTextArea.bind(t),rows:7}};return r};A.prototype.buildSelectionColumnLabels=function(){var e=this;var t=e.getConfiguration();var a=e.getResourceBundle();return new d(e.getParameterId()+"_control_table_column_selection_label_clearall_btn",{icon:"sap-icon://clear-all",type:"Transparent",enabled:typeof t.values==="undefined"?false:"{/_hasSelected}",tooltip:a.getText("EDITOR_FIELD_OBJECT_TABLE_COLUMN_SELECTION_TOOLTIP_REMOVE"),press:e.onUnSelectAll.bind(e)})};A.prototype.buildTableColumns=function(){var e=this;var a=e.getParameterId();var o=e.getConfiguration();var n=[];var i=Object.keys(o.properties);if(i.length>0){var l=e.getResourceBundle();var s=typeof o.values==="undefined"?false:true;if(s){s=typeof o.showSelectionColumn==="undefined"?true:o.showSelectionColumn}var d=e.buildSelectionColumnLabels();var p=new _(a+"_control_table_column_selection",{width:"3.2rem",hAlign:"Center",visible:s,multiLabels:[d],template:new O({selected:"{_dt/_selected}",enabled:typeof o.values==="undefined"?false:true,tooltip:{path:"_dt/_selected",formatter:function(e){if(e){if(o.type==="object"){return l.getText("EDITOR_FIELD_OBJECT_TABLE_COLUMN_SELECTION_CELL_TOOLTIP_UNSELECT")}else{return l.getText("EDITOR_FIELD_OBJECT_LIST_TABLE_COLUMN_SELECTION_CELL_TOOLTIP_REMOVE")}}else if(o.type==="object"){return l.getText("EDITOR_FIELD_OBJECT_TABLE_COLUMN_SELECTION_CELL_TOOLTIP_SELECT")}else{return l.getText("EDITOR_FIELD_OBJECT_LIST_TABLE_COLUMN_SELECTION_CELL_TOOLTIP_ADD")}}},select:e.onSelectionChange.bind(e)})});n.push(p);for(var c in o.properties){var v=a+"_control_table_column_property_"+c;var f=o.properties[c];var T=f.label||c;var y="{"+c+"}";if(f.defaultValue){e._newObjectTemplate[c]=f.defaultValue}var P={width:"7rem",label:T};if(f.column){P=D(P,f.column)}if(P.label.match(V)){P.label="{i18n>"+P.label.substring(2,P.label.length-1)}P.tooltip=P.label;P.label=new g({text:P.label});var I=f.cell&&f.cell.type?f.cell.type:f.type||"Text";var L;var w;var A=E(f.cell)||{};delete A.type;if(I==="string"&&A.values){I="ComboBox"}if(I==="Text"&&A.editable){I="Input"}switch(I){case"int":case"number":w={text:y,wrapping:false};w=D(w,A);L=new t(w);break;case"string":case"Text":w={text:y,wrapping:false};w=D(w,A);var B=w.text;var R=new u({translatable:f.translatable||false,property:c});if(typeof B==="string"){var M=e.getTranslationKey(B);if(M){w.text=l.getText(M)}else if(B.startsWith("{")&&B.endsWith("}")){w.text={path:B.substring(1,B.length-1),formatter:function(t){var a=this.getBindingContext(),r,o=this.getModel("settings").getData(),n=e.getTranslationKey(t);if(o.translatable||n){if(a&&a.getObject()&&a.getObject()._dt){r=e.getTranslationValueInTexts(l.sLocale.replaceAll("_","-"),a.getObject()._dt._uuid,o.property);if(r){return r}}if(n){t=l.getText(n);return t}}return t}}}}w.tooltip=A.tooltip||w.text;L=new t(w);L.setModel(R,"settings");break;case"Icon":w={src:y};w=D(w,A);L=new b(w);break;case"boolean":w={selected:y,enabled:false};w=D(w,A);L=new O(w);break;case"Switch":w={state:y,enabled:false};w=D(w,A);L=new h(w);break;case"Link":w={text:y,target:"_blank",href:y};w=D(w,A);L=new m(w);break;case"ComboBox":w={width:"100%",selectedKey:y,items:{path:"settings>"+A.values.data.path,template:new x(A.values.item)}};if(A.values.sorter){w.items.sorter=[new S({path:A.values.sorter})]}if(A.change){w.change=A.change}var j=new u(A.values.data.json);L=new C(w);L.setModel(j,"settings");break;case"Input":w={value:y};if(A.text){w.value=A.text}w.tooltip=A.tooltip||w.text;L=new r(w);break;default:L=new t({text:y,wrapping:false});break}P.template=L;var U=new _(v,P);n.push(U)}}return n};A.prototype.checkHasFilterDefined=function(e){var t=true;if(e._propertiesParsedFromValue===true){t=false}else{var a=JSON.stringify(e.properties,null,"\t");t=a.indexOf("filterProperty")>-1?true:false}return t};A.prototype.createTableToolbar=function(e){var t=this;var a=t.getParameterId();var r=t.getResourceBundle();var o=t.checkHasFilterDefined(e);var n=e.enabled!==false;var i=e.addButtonText||r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_ADD_TOOLTIP");if(n&&e.values){n=e.values.allowAdd===true}var u=[new s,new d(a+"_control_table_add_btn",{icon:"sap-icon://add",visible:n,tooltip:i,press:t.addNewObject.bind(t)}),new d(a+"_control_table_edit_btn",{icon:"sap-icon://edit",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_EDIT_TOOLTIP"),enabled:"{= !!${/_hasTableSelected}}",visible:t.getAllowPopover(),press:t.onEditOrViewDetail.bind(t)}),new d(a+"_control_table_delete_btn",{icon:"sap-icon://delete",tooltip:r.getText("EDITOR_FIELD_OBJECT_DELETE"),enabled:"{= !!${/_canDelete}}",press:t.onDelete.bind(t)}),new d(a+"_control_table_filter_btn",{icon:"sap-icon://clear-filter",visible:o,enabled:"{= !!${/_hasFilter}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_CLEAR_ALL_FILTERS_TOOLTIP"),press:t.clearAllFilters.bind(t)}),new d(a+"_control_table_multiselect_all_btn",{icon:"sap-icon://multiselect-all",visible:false,enabled:"{= !${/_hasTableAllSelected}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_SELECT_ALL_SELETIONS_TOOLTIP"),press:t.selectAllTableSelections.bind(t)}),new d(a+"_control_table_multiselect_none_btn",{icon:"sap-icon://multiselect-none",visible:false,enabled:"{= !!${/_hasTableSelected}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_CLEAR_ALL_SELETIONS_TOOLTIP"),press:t.clearAllTableSelections.bind(t)})];if(e.type==="object[]"){u=u.concat([new d(a+"_control_table_navigationup_btn",{icon:"sap-icon://navigation-up-arrow",enabled:"{= !!${/_hasOnlyOneRowSelected}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_MOVE_UP_TOOLTIP"),press:t.moveRowUp.bind(t)}),new d(a+"_control_table_navigationdown_btn",{icon:"sap-icon://navigation-down-arrow",enabled:"{= !!${/_hasOnlyOneRowSelected}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_MOVE_DOWN_TOOLTIP"),press:t.moveRowDown.bind(t)})])}return new l({content:u})};A.prototype.onUnSelectAll=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getBindingContext().getPath();var o=a.getModel();var n=o.getProperty(r);n.forEach(function(e){e._dt=e._dt||{};e._dt._selected=false});o.setProperty("/_hasSelected",false);o.checkUpdate(true);t.setValue(undefined)};A.prototype.onEditOrViewDetail=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getSelectedIndices()[0];var o=a.getBinding("rows").getContexts();var n=o[r].getObject();var i=a.getFirstVisibleRow();var l=a.getRows()[r-i];var s=l.getCells()[0];t.openObjectDetailsPopover(n,s,!n._dt||n._dt._editable!==false?"update":"view")};A.prototype.onFilter=function(e){var t=this;var a=t.getAggregation("_field");a.detachEvent("rowsUpdated",t.updateTable,t);a.attachEventOnce("rowsUpdated",t.updateTable,t)};A.prototype.updateTable=function(e){var t=this;t.updateSelectionColumn();t.updateToolbar();t.fireTableUpdated()};A.prototype.updateSelectionColumn=function(){var e=this;var t=e.getAggregation("_field");var a=t.getBinding("rows").getContexts();var r=false;for(var o=0;o<a.length;o++){var n=a[o].getObject();if(n._dt&&n._dt._selected){r=true;break}}t.getModel().setProperty("/_hasSelected",r)};A.prototype.updateToolbar=function(){var e=this;var t=e.getAggregation("_field");var a=t.getColumns();var r=false;for(var o=0;o<a.length;o++){if(a[o].getFiltered()){r=true;break}}t.getModel().setProperty("/_hasFilter",r)};A.prototype.columnFactory=function(e,a){var r=a.getPath();var o=r.substring(a.getPath().lastIndexOf("/")+1);var n=a.getProperty("$Type");var i=a.getProperty("$MaxLength");var l="7rem";i=i?parseInt(i):10;i=i<7?7:i;if(i>50){l="15rem"}else if(i>9){l="10rem"}return new _(e,{visible:true,filterProperty:n&&n.indexOf("String")>=0?o:null,width:l,label:new g({text:o}),hAlign:n&&n.indexOf("Decimal")>=0?"End":"Begin",template:new t({text:{path:o},wrapping:false})})};A.prototype.onTableSelectionChange=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getModel();var o=a.getSelectedIndices();if(o.length>0){r.setProperty("/_hasTableSelected",true);if(o.length===1){r.setProperty("/_hasOnlyOneRowSelected",true)}else{r.setProperty("/_hasOnlyOneRowSelected",false)}}else{r.setProperty("/_hasTableSelected",false);r.setProperty("/_hasOnlyOneRowSelected",false);r.setProperty("/_canDelete",false);return}if(o.length===a.getBinding("rows").getContexts().length){r.setProperty("/_hasTableAllSelected",true)}else{r.setProperty("/_hasTableAllSelected",false)}var n=[];var i=a.getBinding("rows").getContexts();o.forEach(function(e){var t=i[e].getObject();if(t._dt&&t._dt._editable!==false){var a=i[e].getPath();n.push(a)}});if(n.length===0){r.setProperty("/_canDelete",false)}else{r.setProperty("/_canDelete",true)}};A.prototype.selectAllTableSelections=function(e){var t=this;var a=t.getAggregation("_field");a.selectAll();a.getModel().setProperty("/_hasTableAllSelected",true)};A.prototype.clearAllTableSelections=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getModel();a.clearSelection();r.setProperty("/_hasTableSelected",false);r.setProperty("/_hasOnlyOneRowSelected",false);r.setProperty("/_canDelete",false);r.setProperty("/_hasTableAllSelected",false)};A.prototype.moveRowUp=function(e){this.moveSelectedRow("Up")};A.prototype.moveRowDown=function(e){this.moveSelectedRow("Down")};A.prototype.moveSelectedRow=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getModel();var o=a.getSelectedIndices()[0];var n=a.getContextByIndex(o);var i=o+(e==="Up"?-1:1);var l=a.getContextByIndex(i);if(!l){return}var s=l.getProperty("_dt/_position");var d=n.getProperty("_dt/_position");r.setProperty("_dt/_position",s,n);r.setProperty("_dt/_position",d,l);r.refresh(true);a.setSelectedIndex(i);t.refreshValue()};A.prototype.onSelectionChange=function(e){var t=this;var a=e.getSource();var r=e.getParameter("selected");var o=t.getAggregation("_field");var n=o.getBindingContext().getPath();var i=o.getModel();if(r){var l=i.getProperty(n);l.forEach(function(e){e._dt=e._dt||{};e._dt._selected=false});var s=a.getBindingContext().getObject();s._dt._selected=true;var d=E(s);i.setProperty("/_hasSelected",true);t.setValue(d)}else{i.setProperty("/_hasSelected",false);t.setValue(undefined)}};A.prototype.addNewObject=function(e){var t=this;var a=e.getSource();t._newObjectTemplate._dt._uuid=L.generateUuidV4();if(t.getAllowPopover()){t.openObjectDetailsPopover(t._newObjectTemplate,a,"add")}else{t.onAddDirectly(t._newObjectTemplate)}};A.prototype.mergeValueWithRequestResult=function(e){var t=this;var a=t.getConfiguration();var r=t.getAggregation("_field");var o=r.getModel();var n=r.getBinding("rows").getPath();if(a.value&&typeof a.value==="object"&&!T(a.value,{})){var i=E(a.value,500);if(Array.isArray(e)&&e.length>0){if(i._dt&&i._dt._editable===false){var l=i._dt._uuid||L.generateUuidV4();delete i._dt._uuid;e.forEach(function(e){if(T(e,i)){e._dt._selected=true;e._dt._uuid=l}else{e._dt._uuid=L.generateUuidV4()}})}else{e.forEach(function(e){e._dt._uuid=L.generateUuidV4()});i._dt=i._dt||{};i._dt._selected=true;i._dt._uuid=i._dt._uuid||L.generateUuidV4();e.unshift(i)}}else{i._dt=i._dt||{};i._dt._selected=true;i._dt._uuid=i._dt._uuid||L.generateUuidV4();e=[i]}o.setProperty("/_hasSelected",true);o.setProperty(n,e)}else{if(Array.isArray(e)&&e.length>0){e.forEach(function(e){e._dt._uuid=L.generateUuidV4()})}else{o.setProperty(n,{})}o.setProperty("/_hasSelected",false)}o.checkUpdate();t.updateTable()};A.prototype.onChangeOfTextArea=function(e){var t=this;var a=t.getResourceBundle();var r=e.getSource();var o=r.getValue();if(!o||o===""){t.saveValue(undefined,r)}else{try{var n=JSON.parse(o);if(n instanceof Array){r.setValueState("Error");r.setValueStateText(a.getText("EDITOR_VAL_NOT_A_SINGLE_JSONOBJECT"));return}t.saveValue(n,r)}catch(e){r.setValueState("Error");r.setValueStateText(a.getText("EDITOR_VAL_NOT_A_JSONOBJECT"))}}};A.prototype.onChangeOfTextAreaInPopover=function(e){var t=this;var a=t.getResourceBundle();var r=e.getSource();var o=r.getValue();if(!o||o===""){t.saveValue(undefined,r,true)}else{try{var n=JSON.parse(o);if(n instanceof Array){r.setValueState("Error");r.setValueStateText(a.getText("EDITOR_VAL_NOT_A_SINGLE_JSONOBJECT"));return}t.saveValue(n,r,true)}catch(e){r.setValueState("Error");r.setValueStateText(a.getText("EDITOR_VAL_NOT_A_JSONOBJECT"))}}};A.prototype.createFormContents=function(e,t,r,o){var n=this;var i=n.getConfiguration();var l=n.createPropertyContents(e,t,r,o);l.push(new g({visible:false}).addStyleClass("sapFormLabel"));var s=r?n.getParameterId()+"_control_objectdetails_popover_form_textarea":n.getParameterId()+"_control_form_textarea";l.push(new a(s,{value:{path:t,formatter:function(e){if(!e||e===""){return undefined}if(T(e,{})&&!r&&!n._getCurrentProperty("value")){return undefined}e=JSON.stringify(e,null,"\t");if(typeof e==="object"&&!e.length){e=e.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(e){return e.substring(3,e.length-3)})}return e}},editable:i.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",width:"100%",placeholder:"{config/placeholder}",visible:"{= ${/editMode} === 'Json'}",change:r===true?this.onChangeOfTextAreaInPopover.bind(n):this.onChangeOfTextArea.bind(n),rows:r===true?11:7}));return l};A.prototype.createPropertyContents=function(e,t,o,n){var i=this;var l=i.getParameterId();var s=o?l+"_control_objectdetails_popover_form_property_":l+"_control_form_property_";var d=i.getConfiguration();var p=[];if(!t){t="currentSettings>value/"}var _={};if(d.values&&d.values.metadata){var c=i.getModel("meta");var v="/"+d.values.metadata.namespace+"."+d.values.metadata.entityTypeName;var f=c.getProperty(v);for(var b in f){var y=f[b];var P=y["$Type"];if(y["$kind"]==="Property"&&P){if(P.indexOf("Int")>=0){_[b]={type:"int"}}else if(P.indexOf("Boolean")>=0){_[b]={type:"boolean"}}else if(P.indexOf("Decimal")>=0){_[b]={type:"number"}}else{_[b]={type:"string"}}}}}if(T(_,{})){_=d.properties}for(var m in _){var I=_[m];var S=I.label||m;if(S.match(V)){var L=S.substring(2,S.length-2);S="{i18n>"+L+"}"}var w=s+m+"_label";var C=s+m+"_control";var x=new g(w,{text:S,visible:"{= ${/editMode} === 'Properties'}",required:I.required||false});p.push(x);var A;var B=E(I,500);delete B.type;delete B.label;delete B.translatable;delete B.defaultValue;delete B.formatter;delete B.column;delete B.cell;var R;switch(I.type){case"boolean":if(I.cell&&I.cell.type==="Switch"){R={state:"{"+t+m+"}",visible:"{= ${/editMode} === 'Properties'}",enabled:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",change:e};if(I.cell.customTextOn){R.customTextOn=I.cell.customTextOn}if(I.cell.customTextOff){R.customTextOff=I.cell.customTextOff}R=D(R,B);A=new h(C,R)}else{R={selected:"{"+t+m+"}",visible:"{= ${/editMode} === 'Properties'}",enabled:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",select:e};R=D(R,B);A=new O(C,R)}break;case"int":case"integer":R={value:{path:t+m,type:"sap.ui.model.type.Integer",formatOptions:I.formatter},visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",type:"Number",change:e};R=D(R,B);A=new r(C,R);break;case"number":R={value:{path:t+m,type:"sap.ui.model.type.Float",formatOptions:I.formatter},visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",type:"Number",change:e};R=D(R,B);A=new r(C,R);break;case"object":R={value:{path:t+m,formatter:function(e){if(!e||e===""){return undefined}e=JSON.stringify(e,null,"\t");if(typeof e==="object"&&!e.length){e=e.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(e){return e.substring(3,e.length-3)})}return e}},visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",change:e,rows:3};R=D(R,B);A=new a(C,R);break;default:var M=new u({translatable:I.translatable||false,uuidPath:t+"_dt/_uuid",property:m});R={value:"{"+t+m+"}",visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",change:function(t){var a=t.getSource();var r=t.getParameter("value");if(r&&r.match(V)){var o=r.substring(2,r.length-2);r="{i18n>"+o+"}";a.setValue(r);a.fireChange()}else if(e){e(t)}}};R=D(R,B);if(n){R.valueHelpIconSrc="sap-icon://translate";R.valueHelpRequest=n.bind(i,m);if(I.translatable){R.showValueHelp=true}else{R.showValueHelp={path:t+m,formatter:function(e){var t=this.getModel("settings").getData();var a=this.getModel().getProperty(t.uuidPath);var r="translatable";if(i.getTranslationKey(e)){if(!this.getShowValueHelp()&&i.getObjectPropertyConfigValueInDesigntime(a,t.property,r)===false){i.setObjectPropertyConfigValueInDesigntime(a,t.property,r,true)}return true}if(this.getShowValueHelp()){i.deleteTranslationValueInTexts(undefined,a,t.property);i.setObjectPropertyConfigValueInDesigntime(a,t.property,r,false);i._oUpdatedTranslations={}}return false}}}}A=new r(C,R);A.setModel(M,"settings")}p.push(A)}return p};A.prototype.saveValue=function(e,t,a){var r=this;var o;if(!a){r.setValue(e);o=r.getAggregation("_field").getModel();if(o){e=E(e,500);o.setProperty("/value",e||{})}t.setValueState("None");t.setValueStateText("");if(r.getConfiguration()._propertiesParsedFromValue){r.refreshSimpleForm()}}else{o=t.getModel();o.setProperty("/value",e);t.setValueState("None");t.setValueStateText("")}};A.prototype.refreshSimpleForm=function(){var e=this;var t=e.getConfiguration();var a=e.getAggregation("_field");var r=a.removeAllContent().slice(-2);delete t.properties;e.parseValueProperties();var o=function(){var t=a.getModel();t.checkUpdate(true);var r=t.getProperty("/value");r=E(r,500);e.setValue(r)};var n=e.createPropertyContents(o,"/value/");n=n.concat(r);n.forEach(function(e){a.addContent(e)})};A.prototype.getOriginTranslatedValues=function(e){var t=[];var a=this._oEditorResourceBundles.getResourceBundles();for(var r in a){var o=a[r];var n="";var i="";if(e&&o){var l=o.resourceBundle&&o.resourceBundle.getText(e);n=l;i=l}else{n="";i=""}var s={key:r,description:o.language,value:n,originValue:i,editable:true};t.push(s)}return t};A.prototype.buildPropertyTranslationValues=function(e){var t=[];var a=this._oEditorResourceBundles.getResourceBundles();for(var r in a){t.push({key:r,description:a[r].language,value:e,originValue:e,editable:true})}return t};A.prototype.openObjectDetailsPopover=function(e,t,a){var r=this;var p=r.getParameterId();var _=r.getResourceBundle();var c=E(e,500);var g;var v="Right";if(a==="add"){v=this.getPopoverPlacement(t)}if(!r._oObjectDetailsPopover){var f=new d(p+"_control_objectdetails_popover_add_btn",{text:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_ADD"),visible:a==="add",enabled:{path:"/value",formatter:function(e){if(typeof e!=="object"||T(e,{})){return false}else{var t=E(e);delete t._dt;if(T(t,{})){return false}}return true}},press:r.onAdd.bind(r)});var b=new d(p+"_control_objectdetails_popover_update_btn",{text:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_UPDATE"),visible:a==="update",enabled:{path:"/value",formatter:function(e){if(!e||e===""||T(e,{})){return false}return true}},press:r.onUpdate.bind(r)});var h=new d(p+"_control_objectdetails_popover_cancel_btn",{text:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_CANCEL"),visible:a!=="view",press:function(){if(a==="add"){var e=r._oObjectDetailsPopover.getModel().getProperty("/value");r.deleteTranslationValueInTexts(undefined,e._dt._uuid)}r._oObjectDetailsPopover.close()}});var O=new d(p+"_control_objectdetails_popover_close_btn",{text:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_CLOSE"),visible:a==="view",press:function(){r._oObjectDetailsPopover.close()}});var y=new d(p+"_control_objectdetails_popover_editmode_btn",{icon:{path:"/editMode",formatter:function(e){if(e==="Properties"){return"sap-icon://syntax"}else{return"sap-icon://form"}}},tooltip:{path:"/editMode",formatter:function(e){if(e==="Properties"){return _.getText("EDITOR_FIELD_OBJECT_FORM_EDITMODE_JSON")}else{return _.getText("EDITOR_FIELD_OBJECT_FORM_EDITMODE_PROPERTIES")}}},press:function(e){var t=e.getSource();var a=t.getModel();var r=a.getProperty("/editMode");if(r==="Properties"){a.setProperty("/editMode","Json")}else{a.setProperty("/editMode","Properties")}}});var P;r._oNavContainer=new o;r._oObjectDetailsPage=new n({title:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_TITLE"),headerContent:y,footer:new l({content:[new s,f,b,h,O]})});var m=function(e){r._oNavContainer.back();r._oObjectDetailsPage.focus()};var D=r.buildTranslationsList(p+"_control_objectdetails_popover_translation_page_value_list");var S=r.buildTranslationsFooter(D,false);r._oTranslationListPage=new n({title:_.getText("EDITOR_FIELD_OBJECT_TRANSLATION_LIST_TITLE","{languages>/property}"),showNavButton:true,navButtonPress:m,content:D,footer:S});var L=function(e){var t=r._oObjectDetailsPopover.getModel();t.checkUpdate(true);var a=t.getProperty("/value");if(a&&a!==""&&typeof a==="object"&&!T(a,{})){f.setEnabled(true)}else{f.setEnabled(false)}};var w=function(){};if(e._dt&&e._dt._editable===false){P=r.createFormContents(w,"/value/",true,r.navToTranslationPage)}else{P=r.createFormContents(L,"/value/",true,r.navToTranslationPage)}var C=new I({layout:"ResponsiveGridLayout",labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:12,emptySpanXL:1,emptySpanL:1,emptySpanM:1,emptySpanS:0,columnsXL:1,columnsL:1,columnsM:1,content:P});r._oObjectDetailsPage.addContent(C);r._oNavContainer.addPage(r._oObjectDetailsPage);r._oNavContainer.addPage(r._oTranslationListPage);r._oObjectDetailsPopover=new i(p+"_control_objectdetails_popover",{placement:v,showHeader:false,contentWidth:"300px",contentHeight:"345px",modal:true,content:r._oNavContainer}).addStyleClass("sapUiIntegrationEditorItemObjectFieldDetailsPopover");g=new u({value:c,editMode:"Properties"});r._oObjectDetailsPopover.setModel(g);r._oObjectDetailsPopover.setModel(r.getModel("i18n"),"i18n");r._oObjectDetailsPopover._oAddButton=f;r._oObjectDetailsPopover._oUpdateButton=b;r._oObjectDetailsPopover._oCancelButton=h;r._oObjectDetailsPopover._oCloseButton=O;r._oObjectDetailsPopover._openBy=t}else{g=r._oObjectDetailsPopover.getModel();g.setProperty("/value",c);g.checkUpdate(true);if(a==="add"){r._oObjectDetailsPopover._oAddButton.setVisible(true);r._oObjectDetailsPopover._oUpdateButton.setVisible(false);r._oObjectDetailsPopover._oCancelButton.setVisible(true);r._oObjectDetailsPopover._oCloseButton.setVisible(false)}else if(a==="update"){r._oObjectDetailsPopover._oAddButton.setVisible(false);r._oObjectDetailsPopover._oUpdateButton.setVisible(true);r._oObjectDetailsPopover._oCancelButton.setVisible(true);r._oObjectDetailsPopover._oCloseButton.setVisible(false)}else{r._oObjectDetailsPopover._oAddButton.setVisible(false);r._oObjectDetailsPopover._oUpdateButton.setVisible(false);r._oObjectDetailsPopover._oCancelButton.setVisible(false);r._oObjectDetailsPopover._oCloseButton.setVisible(true)}r._oObjectDetailsPopover._openBy=t;r._oObjectDetailsPopover.setPlacement(v);r._oNavContainer.back()}r._oObjectDetailsPopover.openBy(t)};A.prototype.buildTranslationsData=function(e,t,a,r){var o=this;var n=o.getResourceBundle();o._oOriginTranslatedValues=o._oOriginTranslatedValues||{};o._oUpdatedTranslations=o._oUpdatedTranslations||{};var i=a+"_"+r;var l=e;if(t==="key"){if(!o._oOriginTranslatedValues[e]){o._oOriginTranslatedValues[e]=o.getOriginTranslatedValues(e)}}else if(t==="property"){l=i;o._oOriginTranslatedValues[l]=o.buildPropertyTranslationValues(e)}var s=[];o._oOriginTranslatedValues[l].forEach(function(e){var t=E(e,500);t.status=n.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_NOTUPDATED");var i=o.getTranslationValueInTexts(t.key,a,r);if(i){t.value=i;if(Array.isArray(o._oUpdatedTranslations[l])&&o._oUpdatedTranslations[l].includes(t.key)){t.value=o.getTranslationValueInTexts(t.key,a,r);t.status=n.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_UPDATED")}else{t.originValue=t.value}}if(t.key===n.sLocale.replaceAll("_","-")){t.description+=" ("+n.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_CURRENTLANGUAGE")+")";s.unshift(t)}else{s.push(t)}});var d={isUpdated:false,key:e,translationKey:l,translationType:t,uuid:a,property:r,translatedLanguages:s};return d};A.prototype.getTranslationKey=function(e){var t;if(e&&e.match(V)){t=e.substring(2,e.length-2)}else if(e&&e.startsWith("{i18n>")&&e.endsWith("}")){t=e.substring(6,e.length-1)}return t};A.prototype.buildTranslationsFooter=function(e,t){var a=this;var r=a.getParameterId();var o=a.getResourceBundle();var n=o.sLocale.replaceAll("_","-");var i=t?r+"_control_translation_popover":r+"_control_objectdetails_popover_translation_page";var u=new d(i+"_save_btn",{type:"Emphasized",text:o.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_SAVE"),enabled:"{languages>/isUpdated}",press:function(){var r=e.getModel("languages");var o=r.getData();var i=[];var l=o.key;var s=o.translationKey;var d=o.translationType;var u=o.uuid;var p=o.property;o.translatedLanguages.forEach(function(e){if(e.value!==e.originValue){a.setTranslationValueInTexts(e.key,u,p,e.value);i.push(e.key)}});var _=false;if(i.length>0){a._oUpdatedTranslations=a._oUpdatedTranslations||{};a._oUpdatedTranslations[s]=i;if(i.includes(n)){_=true}}o=a.buildTranslationsData(l,d,u,p);r.setData(o);r.checkUpdate(true);if(a.getModel()){a.getModel().checkUpdate(true)}if(_&&a._oValueBinding){a._oValueBinding.fireEvent("change")}if(t){a._oTranslationPopover.close()}}});var p=new d(i+"_reset_btn",{text:o.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_RESET"),enabled:"{languages>/isUpdated}",press:function(t){var a=e.getModel("languages");var r=a.getData();r.translatedLanguages.forEach(function(e){e.value=e.originValue;e.status=o.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_NOTUPDATED")});r.isUpdated=false;a.setData(r);a.checkUpdate(true)}});var _=new d(i+"_cancel_btn",{text:o.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_CANCEL"),visible:t,press:function(){a._oTranslationPopover.close()}});return new l({content:[new s,u,p,_]})};A.prototype.openTranslationPopup=function(e,t){var a=this;var r=t.getSource();var o=a.getResourceBundle();var n=r.getModel().getProperty("/value");if(!n._dt){n._dt={_uuid:L.generateUuidV4()}}else if(!n._dt._uuid){n._dt._uuid=L.generateUuidV4()}var l=r.getValue();var s=a.getTranslationKey(l);var d="property";if(s&&s!==""){d="key"}else{s=l}var u=a.buildTranslationsData(s,d,n._dt._uuid,e);var p;var _=this.getPopoverPlacement(r._oValueHelpIcon);if(!a._oTranslationPopover){var c=a.getParameterId();var g=a.buildTranslationsList(c+"_control_translation_popover_value_list");var v=a.buildTranslationsFooter(g,true);a._oTranslationPopover=new i(c+"_control_translation_popover",{placement:_,contentWidth:"300px",contentHeight:"345px",title:o.getText("EDITOR_FIELD_OBJECT_TRANSLATION_LIST_TITLE","{languages>/property}"),content:g,footer:v}).addStyleClass("sapUiIntegrationFieldTranslation");p=a.buildTranslationsModel(u);a._oTranslationPopover.setModel(p,"languages")}else{a._oTranslationPopover.setPlacement(_);p=a._oTranslationPopover.getModel("languages");p.setData(u);p.checkUpdate(true)}a._oTranslationPopover.openBy(r._oValueHelpIcon)};A.prototype.navToTranslationPage=function(e,t){var a=this;var r=a._oObjectDetailsPopover.getModel().getProperty("/value");var o=r[e];var n=a.getTranslationKey(o);var i="property";if(n&&n!==""){i="key"}else{n=o}var l=a.buildTranslationsData(n,i,r._dt._uuid,e);var s=a._oTranslationListPage.getModel("languages");if(!s){s=a.buildTranslationsModel(l);a._oTranslationListPage.setModel(s,"languages")}else{s.setData(l)}a._oNavContainer.to(a._oTranslationListPage);a._oTranslationListPage.focus()};A.prototype.onAdd=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getModel();var o=t._oObjectDetailsPopover.getModel().getProperty("/value");var n=a.getBinding("rows").getPath();var i=r.getProperty(n);i.forEach(function(e){if(e._dt._selected){e._dt._selected=false}});i.push(o);r.setProperty("/_hasSelected",true);r.setProperty("/_hasTableAllSelected",false);r.setProperty("/_hasTableSelected",false);r.setProperty("/_hasOnlyOneRowSelected",false);r.checkUpdate();t.refreshValue();t.updateTable();t._oObjectDetailsPopover.close()};A.prototype.onAddDirectly=function(e){var t=this;var a=E(e,500);var r=t.getAggregation("_field");var o=r.getModel();var n=r.getBinding("rows").getPath();var i=o.getProperty(n);var l=1;i.unshift(a);i.forEach(function(e){e._dt=e._dt||{};e._dt._selected=false;e._dt._position=l;l++});o.checkUpdate();t.refreshValue();t.updateTable()};A.prototype.onUpdate=function(e){var t=this;var a=t.getAggregation("_field");var r=t._oObjectDetailsPopover.getModel().getProperty("/value");var o=a.getModel();var n=t._oObjectDetailsPopover._openBy.getParent();var i=n.getIndex();var l=a.getBinding("rows").getContexts();var s=l[i].getPath();o.setProperty(s,E(r,500));o.checkUpdate();if(r._dt&&r._dt._selected){t.refreshValue()}t.updateTable();t._oObjectDetailsPopover.close()};A.prototype.onDelete=function(e){var t=this;var a=t.getAggregation("_field");var r=t.getResourceBundle();var o=a.getSelectedIndices();var n=[];var i=a.getBinding("rows").getContexts();o.forEach(function(e){var t=i[e].getObject();if(t._dt&&t._dt._editable!==false){var a=i[e].getPath();var r=a.substring(a.lastIndexOf("/")+1);n.push(r)}});if(n.length===0){y.error(r.getText("EDITOR_FIELD_OBJECT_DELETE_ERROR_MSG"));return}if(t.getAllowPopover()){y.confirm(r.getText("EDITOR_FIELD_OBJECT_DELETE_CONFIRM_MSG"),{title:r.getText("EDITOR_FIELD_OBJECT_DELETE_CONFIRM_TITLE"),onClose:function(e){if(e===y.Action.OK){var o=a.getBindingContext().getPath();var i=a.getModel();var l=i.getProperty(o);var s=[];for(var d=0;d<l.length;d++){if(n.includes(d+"")){t.deleteTranslationValueInTexts(undefined,l[d]._dt._uuid)}else{s.push(l[d])}}i.setProperty(o,s);i.checkUpdate(true);t.refreshValue();t.updateTable()}else{P.show(r.getText("EDITOR_FIELD_OBJECT_DELETE_CONFIRM_CANCLE"))}}})}else{var l=a.getBinding("rows").getPath();var s=a.getModel();var d=s.getProperty(l);var u=[];for(var p=0;p<d.length;p++){if(n.includes(p+"")){t.deleteTranslationValueInTexts(undefined,d[p]._dt._uuid)}else{u.push(d[p])}}s.setProperty(l,u);s.checkUpdate(true);t.refreshValue();t.updateTable()}};A.prototype.refreshValue=function(){var e=this;var t=e.getAggregation("_field");var a=t.getModel();var r=t.getBinding("rows").getPath();var o=a.getProperty(r);var n;for(var i=0;i<o.length;i++){var l=o[i];if(l._dt._selected){n=E(l);break}}e.setValue(n)};A.prototype.resetControl=function(){var e=this;var t=e.getAggregation("_field");var a=e._getCurrentProperty("value");var r=t.getModel();if(t instanceof I){var o=r.getProperty("/value");if(o&&o._dt&&o._dt._uuid){e.deleteTranslationValueInTexts(undefined,o._dt._uuid)}a=a||{};r.setProperty("/value",a);r.checkUpdate(true)}else if(t instanceof p){var n=e.getConfiguration();var i;if(n.values){var l=t.getBinding("rows").getPath();i=r.getProperty(l);i.forEach(function(e){delete e._dt._selected})}e.mergeValueWithRequestResult(i)}};A.prototype.clearAllFilters=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getColumns();for(var o=0;o<r.length;o++){var n=r[o];if(o<r.length-1){n._applySelection=false}a.filter(n,undefined)}};A.prototype.setValue=function(e){var t=this;t.cleanDT(e);t._setCurrentProperty("value",e)};A.prototype.cleanDT=function(e){if(e&&e._dt&&e._dt._selected){delete e._dt._selected}if(e&&e._dt&&T(e._dt,{})){delete e._dt}};A.prototype.getTranslationValueInTexts=function(e,t,a){var r=this;var o=r.getConfiguration();var n="/texts/"+e;var i=this._settingsModel.getProperty(n)||{};var l=i[o.manifestpath];var s;if(l&&l[t]){s=l[t][a]}return s};A.prototype.setObjectPropertyConfigValueInDesigntime=function(e,t,a,r){var o=this;var n=o.getConfiguration();var i="/:designtime";var l=this._settingsModel.getData();if(!l){return}var s;if(!l.hasOwnProperty(":designtime")){s={}}else{s=E(l[":designtime"],500)}if(!s.hasOwnProperty(n.manifestpath)){s[n.manifestpath]={}}if(!s[n.manifestpath].hasOwnProperty(e)){s[n.manifestpath][e]={}}if(!s[n.manifestpath][e].hasOwnProperty(t)){s[n.manifestpath][e][t]={}}s[n.manifestpath][e][t][a]=r;this._settingsModel.setProperty(i,s)};A.prototype.getObjectPropertyConfigValueInDesigntime=function(e,t,a){var r=this;var o;var n=r.getConfiguration();var i=this._settingsModel.getData();if(i&&i[":designtime"]&&i[":designtime"][n.manifestpath]&&i[":designtime"][n.manifestpath][e]&&i[":designtime"][n.manifestpath][e][t]&&i[":designtime"][n.manifestpath][e][t].hasOwnProperty(a)){o=i[":designtime"][n.manifestpath][e][t][a]}return o};A.prototype.setTranslationValueInTexts=function(e,t,a,r){var o=this;var n=o.getConfiguration();var i="/texts";var l=this._settingsModel.getData();if(!l){return}var s;if(!l.hasOwnProperty("texts")){s={}}else{s=E(l.texts,500)}if(!s.hasOwnProperty(e)){s[e]={}}if(!s[e].hasOwnProperty(n.manifestpath)){s[e][n.manifestpath]={}}if(!s[e][n.manifestpath].hasOwnProperty(t)){s[e][n.manifestpath][t]={}}s[e][n.manifestpath][t][a]=r;this._settingsModel.setProperty(i,s)};A.prototype.deleteTranslationValueInTexts=function(e,t,a){var r=this;var o=r._settingsModel.getData();if(!o||!o.texts||!t){return}var n=r.getConfiguration();var i="/texts";var l=E(o.texts,500);if(e){if(l[e]&&l[e][n.manifestpath]&&l[e][n.manifestpath][t]){if(a){if(l[e][n.manifestpath][t].hasOwnProperty(a)){delete l[e][n.manifestpath][t][a];if(T(l[e][n.manifestpath][t],{})){delete l[e][n.manifestpath][t]}this._settingsModel.setProperty(i,l)}}else{delete l[e][n.manifestpath][t];if(T(l[e][n.manifestpath],{})){delete l[e][n.manifestpath];if(T(l[e],{})){delete l[e]}}this._settingsModel.setProperty(i,l)}}}else{for(var s in l){r.deleteTranslationValueInTexts(s,t,a)}}};return A});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/ObjectListField", ["sap/ui/integration/editor/fields/ObjectField","sap/ui/model/json/JSONModel","sap/ui/table/Table","sap/m/CheckBox","sap/base/util/deepEqual","sap/base/util/deepClone","sap/ui/integration/util/Utils","sap/m/table/columnmenu/Menu"],function(e,t,r,a,i,o,n,l){"use strict";var s=e.extend("sap.ui.integration.editor.fields.ObjectListField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});s.prototype.initVisualization=function(e){var t=this;t._positionCount=1;t._newObjectTemplate={_dt:{_selected:true,_uuid:""}};var r=e.visualization;if(!r){if(e.value&&!e.properties&&(!e.values||e.values&&!e.values.metadata)){t.parseValueProperties()}if(e.values||e.properties){r=t.createTableVisualization(e)}else{r=t.createTextAreaVisualization(e)}e.withLabel=true}this._visualization=r;this.attachAfterInit(this._afterInit)};s.prototype._afterInit=function(){var e=this;var a=e.getAggregation("_field");if(a instanceof r){a.addStyleClass("sapUiIntegrationEditorItemObjectListFieldTable");e._oMenu=new l;var i=a.getColumns();for(var s=0;s<i.length;s++){if(i[s].getFilterProperty()||i[s].getSortProperty()){i[s].setHeaderMenu(e._oMenu.getId())}}var u=e.getConfiguration();if(!u.values){var d=[];if(Array.isArray(u.value)){d=o(u.value,500);d.forEach(function(t){t._dt=t._dt||{};t._dt._selected=true;t._dt._uuid=t._dt._uuid||n.generateUuidV4();t._dt._position=e._positionCount;e._positionCount++})}e.setModel(new t({value:d,_allSelected:true}));e.bindObject({path:"/value"})}}};s.prototype.parseValueProperties=function(){var e=this;var t=e.getConfiguration();if(Array.isArray(t.value)&&t.value.length>0&&!t.properties){var r={};t.value.forEach(function(e){for(var t in e){if(!r[t]&&t!=="_dt"){var a=typeof e[t];var i=a==="string"?{}:{type:a};r[t]=i}}});if(!i(r,{})){t.properties=r;t._propertiesParsedFromValue=true}}};s.prototype.buildSelectionColumnLabels=function(){var e=this;var t=e.getConfiguration();var r=e.getResourceBundle();return new a(e.getParameterId()+"_control_table_column_selection_label_all_checkbox",{selected:"{/_allSelected}",visible:typeof t.values!=="undefined",tooltip:{path:"/_allSelected",formatter:function(e){if(!e){return r.getText("EDITOR_FIELD_OBJECT_LIST_TABLE_COLUMN_SELECTION_TOOLTIP_ADDALL")}else{return r.getText("EDITOR_FIELD_OBJECT_LIST_TABLE_COLUMN_SELECTION_TOOLTIP_REMOVEALL")}}},select:e.onSelectionColumnClick.bind(e)})};s.prototype.onSelectionColumnClick=function(e){var t=this;var r=e.getParameter("selected");var a=t.getAggregation("_field");var i=a.getBinding("rows").getContexts();i.forEach(function(e){var t=e.getObject();t._dt=t._dt||{};t._dt._selected=r});var n=a.getModel();var l=a.getBinding("rows").getPath();var s=n.getProperty(l);var u;s.forEach(function(e){if(e._dt&&e._dt._selected){var t=o(e,500);u=u||[];u.push(t)}});n.checkUpdate(true);t.setValue(u)};s.prototype.updateSelectionColumn=function(){var e=this;var t=e.getAggregation("_field");var r=t.getBinding("rows").getContexts();var a=true;if(r.length===0){a=false}else{for(var i=0;i<r.length;i++){var o=r[i].getObject();if(!o._dt||o._dt._selected!==true){a=false;break}}}t.getModel().setProperty("/_allSelected",a)};s.prototype.onAdd=function(e){var t=this;var r=t.getAggregation("_field");var a=t._oObjectDetailsPopover.getModel().getProperty("/value");a._dt._position=t._positionCount;var i=r.getBinding("rows").getPath();var o=r.getModel();var n=o.getProperty(i);n.push(a);o.setProperty("/_hasTableAllSelected",false);o.setProperty("/_hasTableSelected",false);o.checkUpdate();t.refreshValue();t._oObjectDetailsPopover.close();t._positionCount++};s.prototype.refreshValue=function(){var e=this;var t=e.getAggregation("_field");var r=t.getModel();var a=t.getBinding("rows").getPath();var i=r.getProperty(a);var n=[];i.forEach(function(e){if(e._dt._selected){var t=o(e);n.push(t)}});e.setValue(n)};s.prototype.onSelectionChange=function(e){var t=this;var r=e.getParameter("selected");var a=this._getCurrentProperty("value");var i=t.getAggregation("_field");var o=i.getModel();if(r||a.length>1){t.refreshValue();t.updateSelectionColumn()}else{o.setProperty("/_allSelected",false);t.setValue(undefined)}};s.prototype.mergeValueWithRequestResult=function(e){var t=this;var r=t.getConfiguration();var a=t.getAggregation("_field");var l=a.getModel();var s=a.getBinding("rows").getPath();if(Array.isArray(r.value)&&r.value.length>0){var u=o(r.value,500);if(Array.isArray(e)&&e.length>0){t._positionCount=r.value.length+1;var d=[];u.forEach(function(e){var t;if(!e._dt){t=n.generateUuidV4()}else{t=e._dt._uuid||n.generateUuidV4();delete e._dt._uuid;delete e._dt._position}d.push(t)});var _=[];for(var g=0;g<e.length;g++){var p=e[g];var f=false;for(var c=0;c<u.length;c++){if(i(p,u[c])){f=true;break}}if(!f){p._dt._uuid=n.generateUuidV4();p._dt._position=t._positionCount;t._positionCount++;_.push(p)}}for(var v=0;v<u.length;v++){var h=u[v];h._dt=h._dt||{};h._dt._selected=true;h._dt._uuid=d[v];h._dt._position=v+1}if(_.length>0){l.setProperty("/_allSelected",false);u=u.concat(_)}else{l.setProperty("/_allSelected",true)}}else{u.forEach(function(e){e._dt=e._dt||{};e._dt._selected=true;e._dt._uuid=e._dt._uuid||n.generateUuidV4();e._dt._position=t._positionCount;t._positionCount++});l.setProperty("/_allSelected",true)}l.setProperty(s,u)}else{if(Array.isArray(e)&&e.length>0){e.forEach(function(e){e._dt._uuid=n.generateUuidV4();e._dt._position=t._positionCount;t._positionCount++})}else{l.setProperty(s,[])}l.setProperty("/_allSelected",false)}l.checkUpdate();t.updateTable()};s.prototype.onChangeOfTextArea=function(e){var t=this;var r=t.getResourceBundle();var a=e.getSource();var i=a.getValue();if(!i||i===""){t.saveValue(undefined,a)}else{try{var o=JSON.parse(i);if(!(o instanceof Array)){a.setValueState("Error");a.setValueStateText(r.getText("EDITOR_VAL_NOT_AN_ARRAY_OF_JSONOBJECTS"));return}t.saveValue(o,a)}catch(e){a.setValueState("Error");a.setValueStateText(r.getText("EDITOR_VAL_NOT_A_JSONOBJECT"))}}};s.prototype.saveValue=function(e,t,r){var a=this;var i;if(!r){a.setValue(e)}else{i=t.getModel();i.setProperty("/value",e)}t.setValueState("None");t.setValueStateText("")};s.prototype.cleanDT=function(e){if(e){e.forEach(function(e){if(e&&e._dt&&e._dt._selected){delete e._dt._selected}if(e&&e._dt&&i(e._dt,{})){delete e._dt}})}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/StringField", ["sap/ui/integration/editor/fields/BaseField","sap/m/Input","sap/m/Text","sap/m/Title","sap/m/Select","sap/m/ComboBox","sap/m/Popover","sap/m/Button","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/ui/core/ListItem","sap/m/VBox","sap/base/util/each","sap/base/util/restricted/_debounce","sap/ui/core/Core","sap/base/util/deepClone"],function(e,t,a,n,s,i,r,l,o,u,g,p,d,c,v,h){"use strict";var _=/parameters\.([^\}\}]+)/g;var f=["TODAY_ISO","NOW_ISO","LOCALE"];var T=e.extend("sap.ui.integration.editor.fields.StringField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});T.prototype.initVisualization=function(e){var n=e.visualization;var r;if(!n){var l=e.value?e.value.match(_):undefined;var o,u,p;if(l&&l.length>0){l=l.filter(function(e){var t=e.substring(11);return!f.includes(t)})}if(l&&l.length>0){o=l.map(function(e){if(this.isOrigLangField){return"items>"+e.substring(11)+"/_language/value"}return"items>"+e.substring(11)+"/value"}.bind(this));o.unshift("currentSettings>value");u={parts:o,formatter:function(e){var t=Array.prototype.slice.call(arguments,1);for(var a=0;a<t.length;a++){if(t[a]){e=e.replaceAll("{{"+l[a]+"}}",t[a])}}return e}};p=function(e){var t=e.getSource().getValue();var a=this.getBindingContext("currentSettings").sPath;this._settingsModel.setProperty(a+"/value",t);var n=this._settingsModel.getBindings();var s=a.substring(a.lastIndexOf("/")+1);d(n,function(e,t){if(t.sPath==="/form/items/"+s+"/value"){t.checkUpdate(true)}})}.bind(this)}if(this.getMode()==="translation"){if(e.editable){n={type:t,settings:{value:{path:"currentSettings>value"},tooltip:{path:"currentSettings>value"},editable:e.editable,visible:e.visible,maxLength:e.maxLength,placeholder:e.placeholder}}}else{n={type:a,settings:{text:{path:"currentSettings>value"},tooltip:{path:"currentSettings>value"},visible:e.visible,wrapping:false}}}}else if(e.enum){r=new g({key:{path:"currentSettings>"},text:{path:"currentSettings>"}});n={type:s,settings:{selectedKey:{path:"currentSettings>value"},forceSelection:false,editable:e.editable,visible:e.visible,showSecondaryValues:false,width:"100%",items:{path:"currentSettings>enum",template:r}}}}else if(e.values){r=this.formatListItem(e.values.item);if(!e.values.item.key){e.values.item.key=e.values.item.text}n={type:i,settings:{busy:{path:"currentSettings>_loading"},selectedKey:{path:"currentSettings>value"},editable:e.editable,visible:e.visible,showSecondaryValues:true,width:"100%",items:{path:"",template:r}}};if(this.isFilterBackend()){n.settings.selectedKey={parts:["currentSettings>value","currentSettings>suggestValue"],formatter:function(e,t){if((!e||e==="")&&t){return t.replaceAll("''","'")}else{return e}}}}}else if(this.getMode()!=="translation"&&e.translatable){n={type:t,settings:{value:{path:"currentSettings>value"},tooltip:{path:"currentSettings>value"},editable:e.editable,visible:e.visible,maxLength:e.maxLength,placeholder:e.placeholder,valueHelpIconSrc:"sap-icon://translate",showValueHelp:true,valueHelpRequest:this.openTranslationListPopup.bind(this),change:function(t){var a=t.getSource();var n=a.getValue();var s=v.getConfiguration().getLanguage().replaceAll("_","-");a.getParent().setTranslationValueInTexts(s,e.manifestpath,n)}}};if(o){delete n.settings.tooltip;n.settings.value=u;n.settings.change=p;n.settings.showValueHelp=false;delete n.settings.valueHelpRequest}}else{n={type:t,settings:{value:{path:"currentSettings>value"},tooltip:{path:"currentSettings>value"},editable:e.editable,visible:e.visible,maxLength:e.maxLength,placeholder:e.placeholder}};if(o){delete n.settings.tooltip;n.settings.value=u;n.settings.change=p}}}else if(n.type==="TextArea"){n.type="sap/m/TextArea"}else if(n.type==="Select"&&e.values){r=this.formatListItem(e.values.item);var c=Object.assign({selectedKey:{path:"currentSettings>value"},forceSelection:false,editable:e.editable,visible:e.visible,showSecondaryValues:false,width:"100%",items:{path:"",template:r}},n.settings||{});n={type:s,settings:c}}this._visualization=n;this.attachAfterInit(this._afterInit)};T.prototype._afterInit=function(){var e=this.getAggregation("_field");if(e instanceof i){if(this.isFilterBackend()){this.onInput=c(this.onInput,500);e.oninput=this.onInput.bind(this);e.attachSelectionChange(this.onSelectionChange.bind(this))}}};T.prototype.onSelectionChange=function(e){var t=e.getParameter("selectedItem")||{};var a=t.getKey();var n=this.getBindingContext("currentSettings").sPath;this._settingsModel.setProperty(n+"/value",a)};T.prototype.onInput=function(e){var t=e.target.value;var a=this.getBindingContext("currentSettings").sPath;this._settingsModel.setProperty(a+"/suggestValue",t.replaceAll("'","''"));this._settingsModel.setProperty(a+"/_loading",true);this._settingsModel.setProperty(a+"/value","");var n=this._settingsModel.getBindings();var s=a.substring(a.lastIndexOf("/")+1);d(n,function(e,t){if(t.sPath==="/form/items/"+s+"/value"){t.checkUpdate(true)}});var i=e.srcControl;i.open();i.setValue(t);i.setSelection(null)};T.prototype.getOriginTranslatedValues=function(e){var t=[];var a=this._oEditorResourceBundles.getResourceBundles();var n;if(e._translatedDefaultPlaceholder&&e._translatedDefaultPlaceholder.startsWith("{i18n>")&&e._translatedDefaultPlaceholder.endsWith("}")){n=e._translatedDefaultPlaceholder.substring(6,e._translatedDefaultPlaceholder.length-1)}else if(e._translatedDefaultPlaceholder&&e._translatedDefaultPlaceholder.startsWith("{{")&&e._translatedDefaultPlaceholder.endsWith("}}")){n=e._translatedDefaultPlaceholder.substring(2,e._translatedDefaultPlaceholder.length-2)}for(var s in a){var i=a[s];var r="";var l="";if(n&&i){var o=i.resourceBundle&&i.resourceBundle.getText(n,[],true);if(o!==undefined){r=o;l=o}else{r=e._translatedValue||"";l=e._translatedValue||""}}else{r=e._translatedDefaultPlaceholder||"";l=e._translatedDefaultPlaceholder||""}var u={key:s,description:i.language,value:r,originValue:l,editable:true};t.push(u)}return t};T.prototype.getTranslationValueInTexts=function(e,t){var a="/texts/"+e;var n=this._settingsModel.getProperty(a)||{};return n[t]};T.prototype.setTranslationValueInTexts=function(e,t,a){var n="/texts";var s=this._settingsModel.getData();if(!s){return}if(!s.hasOwnProperty("texts")){var i={};i[e]={};i[e][t]=a;this._settingsModel.setProperty(n,i)}else{n="/texts/"+e;var r;if(!s.texts.hasOwnProperty(e)){r={}}else{r=s.texts[e]}r[t]=a;this._settingsModel.setProperty(n,r)}};T.prototype.openTranslationListPopup=function(e){var s=this;var i=e.getSource();var g=i.getParent();var d=g.getParameterId();var c=g.getConfiguration();var v=g.getResourceBundle();var h=s.buildTranslationsData(g,i);var _;var f=g.getPopoverPlacement(i._oValueHelpIcon);if(!s._oTranslationPopover){var T=s.buildTranslationsList(d+"_translation_popover_value_list");s._oTranslationPopover=new r(d+"_translation_popover",{placement:f,contentWidth:"300px",contentHeight:"345px",customHeader:new p({items:[new n({text:v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_TITLE")}).addStyleClass("sapMPopoverTitle"),new n({text:v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_CURRENTLANGUAGE")}).addStyleClass("sapMHeaderTitle"),new p({items:[new a(d+"_translation_popover_currentlanguage_description_label",{text:"{languages>/currentLanguage/description}"}),new t(d+"_translation_popover_currentlanguage_value_input",{value:"{languages>/currentLanguage/value}",editable:false})]}).addStyleClass("sapMCurrentLanguageVBox"),new n({text:v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_OTHERLANGUAGES")}).addStyleClass("sapMHeaderTitle")]}),content:T,footer:new o({content:[new u,new l(d+"_translation_popover_save_btn",{type:"Emphasized",text:v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_SAVE"),enabled:"{languages>/isUpdated}",press:function(){var e=s._oTranslationPopover.getModel("languages").getData();var t=[];e.translatedLanguages.forEach(function(e){if(e.value!==e.originValue){g.setTranslationValueInTexts(e.key,c.manifestpath,e.value);t.push(e.key)}});if(e.currentLanguage.value!=e.currentLanguage.originValue){g.setTranslationValueInTexts(e.currentLanguage.key,c.manifestpath,e.currentLanguage.value);t.push(e.currentLanguage.key)}if(t.length>0){s._aUpdatedLanguages=t}s._oTranslationPopover.close()}}),new l(d+"_translation_popover_cancel_btn",{text:v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_CANCEL"),press:function(){s._oTranslationPopover.close()}})]})}).addStyleClass("sapUiIntegrationFieldTranslation");_=s.buildTranslationsModel(h);s._oTranslationPopover.setModel(_,"languages")}else{s._oTranslationPopover.setPlacement(f);_=s._oTranslationPopover.getModel("languages");_.setData(h);_.checkUpdate(true)}s._oTranslationPopover.openBy(i._oValueHelpIcon)};T.prototype.buildTranslationsData=function(e,t){var a=this;var n=e.getConfiguration();if(!a._aOriginTranslatedValues){a._aOriginTranslatedValues=e.getOriginTranslatedValues(n)}var s=h(a._aOriginTranslatedValues,500);var i=e.getResourceBundle();s.forEach(function(t){var s=e.getTranslationValueInTexts(t.key,n.manifestpath);if(s){t.value=s;if(Array.isArray(a._aUpdatedLanguages)&&!a._aUpdatedLanguages.includes(t.key)){t.originValue=t.value}}else if(n._beforeLayerChange){t.value=n._beforeLayerChange;if(Array.isArray(a._aUpdatedLanguages)&&!a._aUpdatedLanguages.includes(t.key)){t.originValue=t.value}}t.status=i.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_NOTUPDATED");if(t.key===i.sLocale.replaceAll("_","-")){t.editable=false}});var r={currentLanguage:{},isUpdated:false,translatedLanguages:[]};if(s){s.forEach(function(s){if(Array.isArray(a._aUpdatedLanguages)&&a._aUpdatedLanguages.includes(s.key)){s.value=e.getTranslationValueInTexts(s.key,n.manifestpath);s.status=i.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_UPDATED")}if(s.key===i.sLocale.replaceAll("_","-")){s.value=t.getValue();r.currentLanguage=s}else{r.translatedLanguages.push(s)}})}return r};return T});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/StringListField", ["sap/ui/integration/editor/fields/BaseField","sap/m/Input","sap/m/MultiComboBox","sap/m/MultiInput","sap/base/util/restricted/_debounce","sap/base/util/restricted/_isEqual","sap/base/util/ObjectPath","sap/base/util/merge","sap/ui/core/SeparatorItem","sap/ui/model/Sorter","sap/m/Token","sap/m/Tokenizer","sap/base/util/deepClone","sap/ui/model/json/JSONModel","sap/ui/integration/util/BindingResolver"],function(e,t,r,a,i,n,s,o,u,l,g,v,c,h,p){"use strict";var d=e.extend("sap.ui.integration.editor.fields.StringListField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});d.prototype.initVisualization=function(e){var i=this,n;var s=e.visualization;if(!s){if(e.values){n=this.formatListItem(e.values.item);s={type:r,settings:{selectedKeys:{path:"currentSettings>value"},busy:{path:"currentSettings>_loading"},editable:e.editable,visible:e.visible,showSecondaryValues:true,width:"100%",items:{path:"",template:n,sorter:[new l({path:"Selected",descending:false,group:true})],groupHeaderFactory:i.getGroupHeader}}};if(this.isFilterBackend()){s.settings.selectedKeys={parts:["currentSettings>value","currentSettings>suggestValue"],formatter:function(e,t){if(t){i.setSuggestValue()}return e}}}}else{s={type:t,settings:{value:{path:"currentSettings>value",formatter:function(e){e=e||[];return e.join(",")}},change:function(e){var t=e.getSource();t.getBinding("value").setRawValue(t.getValue().split(","))},editable:e.editable,visible:e.visible,placeholder:e.placeholder}}}}else if(e.values&&this.isFilterBackend()&&s.type==="MultiInput"){n=this.formatListItem(e.values.item);var u={busy:{path:"currentSettings>_loading"},placeholder:e.placeholder,editable:e.editable,visible:e.visible,showSuggestion:true,autocomplete:false,showValueHelp:false,filterSuggests:false,width:"100%",suggestionItems:{path:"",template:n,sorter:[new l({path:"Selected",descending:false,group:true})],groupHeaderFactory:i.getGroupHeader}};if(s.settings){u=o(u,s.settings)}s={type:a,settings:u}}this._visualization=s;this.attachAfterInit(this._afterInit)};d.prototype._afterInit=function(){var e=this.getAggregation("_field");var t=this.getModel();if(e instanceof r){if(this.isFilterBackend()){this.onInputForMultiComboBox=i(this.onInputForMultiComboBox,500);e.oninput=this.onInputForMultiComboBox;e.attachSelectionChange(this.onSelectionChangeForFilterBackend);e.attachSelectionFinish(this.onSelectionFinishForFilterBackend);t.attachPropertyChange(this.onPropertyChangeForFilterBackend,this)}else{e.attachSelectionChange(this.onSelectionChange);t.attachPropertyChange(this.onPropertyChange,this)}}else if(e instanceof a){this.initTokens();this.onInputForMultiInput=i(this.onInputForMultiInput,500);e.oninput=this.onInputForMultiInput;t.attachPropertyChange(this.onPropertyChangeForFilterBackend,this);t.attachPropertyChange(this.initTokens,this);e.attachTokenChange(this.onTokenChange)}};d.prototype.initTokens=function(){var e=this.getAggregation("_field");var t=this.getConfiguration();var r=[];if(Array.isArray(t.valueTokens)&&t.valueTokens.length>0){t.valueTokens.forEach(function(e){var t=new g(e);r.push(t)})}else if(Array.isArray(t.value)&&t.value.length>0&&Array.isArray(t.valueItems)&&t.valueItems.length>0){t.valueTokens=[];t.valueItems.forEach(function(e){var a=new h;a.setData(e);var i=p.resolveValue(t.values.item.key,a);if(t.value.includes(i)){var n=p.resolveValue(t.values.item.text,a);var s={key:i,text:n};var o=new g(s);r.push(o);t.valueTokens.push(s)}})}e.setTokens(r)};d.prototype.getKeyFromItem=function(e){var t=this.getConfiguration();var r=new h;r.setData(e);return p.resolveValue(t.values.item.key,r)};d.prototype.onPropertyChangeForFilterBackend=function(e){var t=this.getConfiguration();if(!t.valueItems){t.valueItems=[]}var r=t.values.data.path||"/";var a=this.getModel();var i=a.getData();if(r!=="/"){if(r.startsWith("/")){r=r.substring(1)}if(r.endsWith("/")){r=r.substring(0,r.length-1)}var n=r.split("/");var o=s.get(n,i);o=this.mergeSelectedItems(t,o);s.set(n,o,i)}else{i=this.mergeSelectedItems(t,i)}a.setData(i);this.setSuggestValue()};d.prototype.onPropertyChange=function(e){var t=this.getAggregation("_field");var r=t.getSelectedItems().map(function(e){return e.getKey()});var a=this.getBindingContext("currentSettings").sPath;var i=this.getModel("currentSettings");i.setProperty(a+"/value",r)};d.prototype.mergeSelectedItems=function(e,t){var r=this;var a=r.getResourceBundle();if(Array.isArray(t)){var i=e.valueItems.map(function(e){return this.getKeyFromItem(e)}.bind(this));var s=t.filter(function(e){var t=this.getKeyFromItem(e);return!i.includes(t)}.bind(this));var o=s.filter(function(e){return e.Selected===a.getText("EDITOR_ITEM_SELECTED")});e.valueItems=e.valueItems.concat(o);var u=s.filter(function(e){return e.Selected!==a.getText("EDITOR_ITEM_SELECTED")});t=e.valueItems.concat(u);var l=this.getAggregation("_field");if(l.isOpen&&l.isOpen()){i=e.valueItems.map(function(e){return this.getKeyFromItem(e)}.bind(this));var g=l.getSelectedKeys();if(!n(i,g)){l.setSelectedKeys(i)}}}else{t=e.valueItems}return t};d.prototype.setSuggestValue=function(){var e=this.getAggregation("_field");var t=this.getBindingContext("currentSettings").sPath;var r=this.getModel("currentSettings");var a=r.getProperty(t+"/suggestValue");if(a&&a!==""){e.setValue(a.replaceAll("''","'"))}};d.prototype.getSuggestValue=function(){var e=this.getBindingContext("currentSettings").sPath;var t=this.getModel("currentSettings");return t.getProperty(e+"/suggestValue")};d.prototype.getGroupHeader=function(e){return new u({text:e.key})};d.prototype.onSelectionChangeForFilterBackend=function(e){var t=e.getSource().getParent();var r=t.getConfiguration();var a=t.getResourceBundle();var i=e.getParameter("changedItem");var n=i.getKey();var o=e.getParameter("selected");var u=this.getModel().getData();var l=r.values.data.path||"/";var g,v;if(l!=="/"){if(l.startsWith("/")){l=l.substring(1)}if(l.endsWith("/")){l=l.substring(0,l.length-1)}g=l.split("/");v=s.get(g,u)}else{v=u}if(v){if(!r.valueItems){r.valueItems=[]}var h=[];v.forEach(function(e){var i=c(e,500);var s=t.getKeyFromItem(i);if(s===n){if(o){i.Selected=a.getText("EDITOR_ITEM_SELECTED");r.valueItems=r.valueItems.concat([i])}else{i.Selected=a.getText("EDITOR_ITEM_UNSELECTED");r.valueItems=r.valueItems.filter(function(e){var r=t.getKeyFromItem(e);return r!==n})}}h.push(i)});if(g!==undefined){s.set(g,h,u);this.getModel().checkUpdate(true)}else{this.getModel().setData(h)}}};d.prototype.onTokenChange=function(e){var t=this.getParent();var r=t.getConfiguration();var a=t.getResourceBundle();var i=t.getModel("currentSettings");var n=t.getBindingContext("currentSettings").sPath;var o=i.getProperty(n+"/value");var u=e.getParameter("token");if(u){var l=u.getKey();if(!r.valueTokens){r.valueTokens=[]}if(!o){o=[]}var g=e.getParameter("type");switch(g){case v.TokenChangeType.Removed:o=o.filter(function(e){return e!==l});r.value=o;r.valueTokens=r.valueTokens.filter(function(e){return e.key!==l});break;case v.TokenChangeType.Added:if(!o.includes(l)){o=o.concat([l]);r.value=o}var h=r.valueTokens.map(function(e){return e.key});if(!h.includes(l)){r.valueTokens=r.valueTokens.concat([{key:l,text:u.getText()}])}break;case v.TokenChangeType.RemovedAll:r.value=[];r.valueItems=[];r.valueTokens=[];break;default:break}var p=t.getModel().getData();var d;var f=r.values.data.path||"/";var m;if(f!=="/"){if(f.startsWith("/")){f=f.substring(1)}if(f.endsWith("/")){f=f.substring(0,f.length-1)}m=f.split("/");d=c(s.get(m,p),10)}else{d=c(p,10)}if(Array.isArray(d)){r.valueItems=[];d.forEach(function(e){var i=t.getKeyFromItem(e);if(r.value.includes(i)){e.Selected=a.getText("EDITOR_ITEM_SELECTED");r.valueItems.push(e)}else{e.Selected=a.getText("EDITOR_ITEM_UNSELECTED")}});if(f!=="/"){s.set(m,d,p)}else{p=d}t.getModel().setData(p);t.getModel().checkUpdate(true)}i.setProperty(n+"/value",r.value);i.setProperty(n+"/valueItems",r.valueItems);i.setProperty(n+"/valueTokens",r.valueTokens)}};d.prototype.onSelectionChange=function(e){var t=e.oSource.getParent();var r=t.getConfiguration();var a=t.getResourceBundle();var i=e.getParameter("changedItem");var n=i.getKey();var o=e.getParameter("selected");var u=this.getModel().getData();var l=r.values.data.path||"/";if(l!=="/"){if(l.startsWith("/")){l=l.substring(1)}if(l.endsWith("/")){l=l.substring(0,l.length-1)}var g=l.split("/");var v=s.get(g,u);if(Array.isArray(v)){for(var c in v){var h=t.getKeyFromItem(v[c]);if(h===n){if(o){v[c].Selected=a.getText("EDITOR_ITEM_SELECTED")}else{v[c].Selected=a.getText("EDITOR_ITEM_UNSELECTED")}}}s.set(g,v,u)}}else if(Array.isArray(u)){for(var c in u){var h=t.getKeyFromItem(u[c]);if(h===n){if(o){u[c].Selected=a.getText("EDITOR_ITEM_SELECTED")}else{u[c].Selected=a.getText("EDITOR_ITEM_UNSELECTED")}}}}this.getModel().setData(u);this.getModel().checkUpdate(true)};d.prototype.onSelectionFinishForFilterBackend=function(e){var t=this.getParent();var r=t.getConfiguration();var a=e.getParameter("selectedItems").map(function(e){return e.getKey()});var i=this.getModel().getData();var n=r.values.data.path||"/";if(n!=="/"){if(n.startsWith("/")){n=n.substring(1)}if(n.endsWith("/")){n=n.substring(0,n.length-1)}var o=n.split("/");i=s.get(o,i)}if(i){r.valueItems=i.filter(function(e){var r=t.getKeyFromItem(e);return a.includes(r)})}var u=this.getBindingContext("currentSettings").sPath;var l=this.getModel("currentSettings");l.setProperty(u+"/value",a);var g=t.getSuggestValue();if(g&&g!==""){l.setProperty(u+"/suggestValue","")}};d.prototype.onInputForMultiComboBox=function(e){var t=e.target.value;var r=this.getBindingContext("currentSettings").sPath;var a=this.getModel("currentSettings");a.setProperty(r+"/suggestValue",t.replaceAll("'","''"));a.setProperty(r+"/_loading",true);e.srcControl.open();e.srcControl._getSuggestionsPopover()._sTypedInValue=t};d.prototype.onInputForMultiInput=function(e){var t=e.srcControl;a.prototype.oninput.apply(t,arguments);var r=e.target.value;if(r===""){return}var i=this.getBindingContext("currentSettings").sPath;var n=this.getModel("currentSettings");var s=n.getProperty(i+"/suggestValue");if(s!==r.replaceAll("'","''")){n.setProperty(i+"/suggestValue",r.replaceAll("'","''"));n.setProperty(i+"/_loading",true)}};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/fragment/Controller", ["sap/ui/core/mvc/Controller","sap/ui/core/Core"],function(t,e){"use strict";var i=t.extend("sap.ui.integration.editor.fields.fragment.Controller",{});i.prototype.init=function(){};i.prototype.setField=function(t){this._oField=t};i.prototype.saveValue=function(t){var i=e.getConfiguration().getLanguage().replaceAll("_","-");var n=this._oField.getConfiguration();if(n.type==="string"&&n.translatable){this._oField.setTranslationValueInTexts(i,n.manifestpath,t)}else{this._oField._settingsModel.setProperty(n.manifestpath,t)}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/viz/ColorSelect", ["sap/ui/integration/editor/fields/viz/VizBase","sap/m/ColorPalettePopover","sap/m/Button","sap/ui/core/Core","sap/base/util/merge","sap/ui/core/theming/Parameters"],function(e,t,o,a,n,r){"use strict";var l=e.extend("sap.ui.integration.editor.fields.viz.ColorSelect",{metadata:{library:"sap.ui.integration",properties:{enumValue:{type:"string",defaultValue:""},colorValue:{type:"string",defaultValue:""},colorEnum:{type:"string",defaultValue:"sap.m.AvatarColor"},background:{type:"boolean",defaultValue:true},allowCustomColors:{type:"boolean",defaultValue:false}},aggregations:{_colorpalette:{type:"sap.m.ColorPalettePopover",multiple:false,visibility:"hidden"}}},renderer:{apiVersion:2}});var c={};function i(){var e=["sapUiAccent1","sapUiAccent2","sapUiAccent3","sapUiAccent4","sapUiAccent5","sapUiAccent6","sapUiAccent7","sapUiAccent8","sapUiAccent9","sapUiAccent10","sapUiTileIconColor","sapUiContentImagePlaceholderBackground"];var t=r.get({name:e,callback:function(e){}});if(t){c={"sap.m.AvatarColor":{Accent1:t["sapUiAccent1"],Accent2:t["sapUiAccent2"],Accent3:t["sapUiAccent3"],Accent4:t["sapUiAccent4"],Accent5:t["sapUiAccent5"],Accent6:t["sapUiAccent6"],Accent7:t["sapUiAccent7"],Accent8:t["sapUiAccent8"],Accent9:t["sapUiAccent9"],Accent10:t["sapUiAccent10"],TileIcon:t["sapUiTileIconColor"],Transparent:"transparent",Placeholder:t["sapUiContentImagePlaceholderBackground"]}}}}i();a.attachThemeChanged(i);var s,p=new t("oColorPalettePopoverFull",{colorSelect:function(e){var t=e.getParameter("value"),o=c[s.getColorEnum()],a=Object.values(o).indexOf(t);s.setEnumValue(Object.keys(o)[a]);s.setColorValue(t);s._colorValue=t}});l.prototype.onInit=function(){this._oControl=new o({icon:"sap-icon://color-fill",press:function(){this._openPalette()}.bind(this)});this._colorValue="transparent"};l.prototype.applyStyle=function(e){e.class("sapUiIntegrationColorSelect");if(!this._colorValue||this._colorValue==="transparent"){e.class("noColorValueOrTransparentValue")}else{e.class("hasColorValue")}if(this._colorValue){e.style("--colorValue",this._colorValue)}};l.prototype._openPalette=function(){s=this;p.setShowDefaultColorButton(true);p.setShowMoreColorsButton(false);p.setDefaultColor("");var e=c[this.getColorEnum()];if(e){var t=[];for(var o in e){t.push(e[o])}p.setColors(t)}p.openBy(this._oControl)};l.prototype.setEnumValue=function(e){this.setProperty("enumValue",e,true);this._colorValue=c[this.getColorEnum()][e];this.rerender()};l.prototype.bindPropertyToControl=function(e,t){if(e==="editable"){var o=n({},t);this._oControl.bindProperty("enabled",o)}};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/viz/IconSelect", ["sap/ui/integration/editor/fields/viz/VizBase","sap/m/Select","sap/ui/core/ListItem","sap/ui/model/json/JSONModel","sap/ui/core/IconPool","sap/ui/core/_IconRegistry","sap/base/util/merge","sap/ui/core/Core","sap/base/util/deepClone","sap/base/util/deepEqual","sap/ui/integration/formatters/IconFormatter","sap/m/Popover","sap/m/Image","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/Text","sap/m/CheckBox","sap/m/SegmentedButton","sap/m/SegmentedButtonItem"],function(e,t,o,i,n,s,l,a,r,c,p,d,u,h,f,g,_,I,y){"use strict";var S=a.getLibraryResourceBundle("sap.ui.integration"),C,m,b=false;var T=e.extend("sap.ui.integration.editor.fields.viz.IconSelect",{metadata:{library:"sap.ui.integration",properties:{value:{type:"string",defaultValue:"sap-icon://accept"},allowFile:{type:"boolean",defaultValue:true},allowNone:{type:"boolean",defaultValue:true},allowDefaultIcons:{type:"boolean",defaultValue:true}}},renderer:{apiVersion:2}});T.prototype._initDefaultIcons=function(){C=[];var e=n.getIconNames();e=e.sort(function(e,t){return e.toLowerCase().localeCompare(t.toLowerCase())});e.filter(function(e){var t=n.getIconInfo(e).text||("-"+e).replace(/-(.)/gi,function(e,t){return" "+t.toUpperCase()}).substring(1);C.push({icon:"sap-icon://"+e,key:"sap-icon://"+e,text:t,additionalText:"sap-icon://"+e,tooltip:t,enabled:true,type:"UI5"})});if(!b){return}var t=s.getFontRegistry();if(!t["SAP-icons-TNT"]){n.registerFont({fontFamily:"SAP-icons-TNT",collectionName:"SAP-icons-TNT",fontURI:sap.ui.require.toUrl("sap/tnt/themes/base/fonts")})}if(!t["BusinessSuiteInAppSymbols"]){n.registerFont({fontFamily:"BusinessSuiteInAppSymbols",collectionName:"BusinessSuiteInAppSymbols",fontURI:sap.ui.require.toUrl("sap/ushell/themes/base/fonts/")})}m=Promise.all([n.fontLoaded("SAP-icons-TNT"),n.fontLoaded("BusinessSuiteInAppSymbols")]).then(function(){e=n.getIconNames("SAP-icons-TNT");e=e.filter(function(e){var t=e.substring(0,1).charCodeAt();return e.indexOf(" ")<0&&t>=97&&t<=122});e.sort();e.filter(function(e){var t=n.getIconInfo(e,"SAP-icons-TNT").text||("-"+e).replace(/-(.)/gi,function(e,t){return" "+t.toUpperCase()}).substring(1);C.push({icon:"sap-icon://SAP-icons-TNT/"+e,key:"sap-icon://SAP-icons-TNT/"+e,text:t,additionalText:"sap-icon://SAP-icons-TNT/"+e,tooltip:t,enabled:true,type:"SAP-icons-TNT"})});e=n.getIconNames("BusinessSuiteInAppSymbols");e.sort();e.filter(function(e){var t=n.getIconInfo(e,"BusinessSuiteInAppSymbols").text||("-"+e).replace(/-(.)/gi,function(e,t){return" "+t.toUpperCase()}).substring(1);C.push({icon:"sap-icon://BusinessSuiteInAppSymbols/"+e,key:"sap-icon://BusinessSuiteInAppSymbols/"+e,text:t,additionalText:"sap-icon://BusinessSuiteInAppSymbols/"+e,tooltip:t,enabled:true,type:"BusinessSuiteInAppSymbols"})})})};T.prototype._initIconModel=function(){var e=[{icon:"",text:S.getText("EDITOR_ICON_NONE"),tooltip:"",key:p.SRC_FOR_HIDDEN_ICON,enabled:true,type:"Action"},{icon:"sap-icon://upload",text:S.getText("EDITOR_ICON_CHOOSE"),tooltip:"",key:"file",enabled:true,type:"Action"},{icon:"sap-icon://download",text:S.getText("EDITOR_ICON_SELECTED"),tooltip:"",key:"selected",enabled:false,type:"Action"}];this._oIconModel=new i(e);this._oIconModel.setSizeLimit(e.length)};T.prototype._initConfigModel=function(){var e={icons:{layout:"Grid",types:{Action:true,UI5:true,"SAP-icons-TNT":true,BusinessSuiteInAppSymbols:true}}};this._oConfigModel=new i(e)};T.prototype.onInit=function(){if(S&&S.sLocale!==a.getConfiguration().getLanguage()){S=a.getLibraryResourceBundle("sap.ui.integration")}if(!this._oIconModel){this._initIconModel()}if(!C){this._initDefaultIcons()}if(m){m.then(function(){if(this.getAllowDefaultIcons()){var e=this._oIconModel.getData();e=e.concat(r(C,500));this._oIconModel.setData(e);this._oIconModel.setSizeLimit(e.length);this._oIconModel.checkUpdate(true);this._oControl&&this._oControl.setSelectedKey(this.getValue())}m=undefined}.bind(this))}else if(this.getAllowDefaultIcons()){var e=this._oIconModel.getData();e=e.concat(r(C,500));this._oIconModel.setData(e);this._oIconModel.setSizeLimit(e.length)}if(!this._oConfigModel){this._initConfigModel()}var i=new o({icon:"{iconlist>icon}",text:"{iconlist>text}",tooltip:"{iconlist>tooltip}",key:"{iconlist>key}",additionalText:"{iconlist>additionalText}",enabled:{parts:["config>/icons/types","iconlist>type","iconlist>enabled"],formatter:function(e,t,o){return o&&e[t]}}});this._oFileUpload=document.createElement("INPUT");this._oFileUpload.type="file";this._oFileUpload.accept=".png,.jpg,.jpeg,.svg";this._boundFileUploadChange=this._fileUploadChange.bind(this);this._oFileUpload.addEventListener("change",this._boundFileUploadChange);this._oControl=new t({width:"100%",items:{path:"iconlist>/",template:i},change:function(e){var t=e.getSource(),o=e.getSource().getSelectedKey();if(o==="file"){t._customImage=null;this._oFileUpload.click();this._boundFocusBack=this._focusBack.bind(this);t.getDomRef("hiddenSelect").addEventListener("focus",this._boundFocusBack)}else{this.setValue(o)}}.bind(this)});this._oControl.setModel(this._oIconModel,"iconlist");this._oControl.setModel(this._oConfigModel,"config");this._oControl._fnOpen=this._oControl.open;if(this.getAllowDefaultIcons()){var n=this;this._oControl.open=function(){this._fnOpen&&this._fnOpen.apply(this,arguments);n._oPicker=this.getPicker();var e=false;if(!n._oPicker.getFooter()&&e){var t=new h({content:[new I({selectedKey:"{config>/icons/layout}",items:[new y({icon:"sap-icon://grid",tooltip:"Grid View",key:"Grid"}),new y({icon:"sap-icon://list",tooltip:"Details View",key:"Details"})],select:function(e){var t=e.getSource();var o=t.getSelectedKey();if(o==="Grid"){this._oPicker.addStyleClass("sapUiIntegrationIconSelectList");this._oControl.setShowSecondaryValues(false)}else if(o==="Details"){this._oPicker.removeStyleClass("sapUiIntegrationIconSelectList");this._oControl.setShowSecondaryValues(true)}}.bind(n)}),new f,new g({text:"Icon Types:"}),new _({selected:"{config>/icons/types/UI5}",text:"UI5",select:n.onIconTypeChanged.bind(n)}),new _({selected:"{config>/icons/types/SAP-icons-TNT}",text:"Fiori",select:n.onIconTypeChanged.bind(n)}),new _({selected:"{config>/icons/types/BusinessSuiteInAppSymbols}",text:"Business Suite",select:n.onIconTypeChanged.bind(n)})]});n._oPicker.setFooter(t)}if(!c(n._oConfigModel.getProperty("/icons/types"),{Action:true,UI5:false,"SAP-icons-TNT":false,BusinessSuiteInAppSymbols:false})){n._oPicker.addStyleClass("sapUiIntegrationIconSelectList");n._oPicker.setContentHeight("400px")}}}this._oControl.addDelegate({onAfterRendering:this.onAfterRenderingSelect.bind(this)});this._oControl.addDelegate({onsappageup:function(){if(this._oControl.isOpen()){var e=this._oControl.getSelectedIndex();this._oControl.setSelectedIndex(e-50)}}.bind(this),onsappagedown:function(){if(this._oControl.isOpen()){var e=this._oControl.getSelectedIndex();if(e<3){this._oControl.setSelectedIndex(29)}else{this._oControl.setSelectedIndex(e+50)}}}.bind(this),onsapup:function(){if(this._oControl.isOpen()){var e=this.getAllowFile();var t=this.getAllowNone();var o=this._oIconModel.getProperty("/2/enabled");var i=this._oControl.getSelectedIndex();if(i>11+2){this._oControl.setSelectedIndex(i-11)}else if(i>=3){if(t&&!e){this._oControl.setSelectedIndex(0)}else if(o){this._oControl.setSelectedIndex(2)}else{this._oControl.setSelectedIndex(3)}}}}.bind(this),onsapdown:function(){if(this._oControl.isOpen()){var e=this._oControl.getSelectedIndex();if(e>1){this._oControl.setSelectedIndex(e+11)}}}.bind(this),onsapleft:function(){if(this._oControl.isOpen()){this._oControl.onsapup.apply(this._oControl,arguments)}}.bind(this),onsapright:function(){if(this._oControl.isOpen()){this._oControl.onsapdown.apply(this._oControl,arguments)}}.bind(this)},true)};T.prototype.applyStyle=function(e){e.class("sapUiIntegrationIconSelect");if(this._oControl&&this._oControl.getWidth){e.style("width",this._oControl.getWidth())}};T.prototype.onIconTypeChanged=function(e){this._oConfigModel.checkUpdate(true);var t=this._oConfigModel.getProperty("/icons/types");if(c(t,{Action:true,UI5:false,"SAP-icons-TNT":false,BusinessSuiteInAppSymbols:false})){this._oPicker.setContentHeight("")}else{this._oPicker.setContentHeight("400px")}var o=this.getValue();if(o&&o.indexOf("data:image/")===0){this._oControl._customImage=o;this._oIconModel.setProperty("/2/enabled",true);this._oControl.setSelectedKey("selected")}else{this._oControl.setSelectedKey(o)}};T.prototype._fileUploadChange=function(){var e=new window.FileReader;e.onload=function(){this.setValue(e.result);this._oControl.invalidate()}.bind(this);if(this._oFileUpload.files.length===1){e.readAsDataURL(this._oFileUpload.files[0])}};T.prototype._focusBack=function(){this._oControl.getDomRef("hiddenSelect").removeEventListener("focus",this._boundFocusBack);setTimeout(function(){this.setValue(this.getValue())}.bind(this),150)};T.prototype.bindPropertyToControl=function(e,t){if(e==="editable"){var o=l({},t);this._oControl.bindProperty("editable",o)}};T.prototype.setValue=function(e){this.setProperty("value",e,true);if(e&&e.indexOf("data:image/")===0){this._oControl._customImage=e;this._oIconModel.setProperty("/2/enabled",true);this._oControl.setSelectedKey("selected")}else{this._oControl._customImage=null;this._oIconModel.setProperty("/2/enabled",false);this._oControl.setSelectedKey(e)}this._oControl.invalidate();return this};T.prototype.setAllowFile=function(e){this.setProperty("allowFile",e,true);e=this.getAllowFile();this._oIconModel.setProperty("/1/enabled",e);return this};T.prototype.setAllowNone=function(e){this.setProperty("allowNone",e,true);e=this.getAllowNone();this._oIconModel.setProperty("/0/enabled",e);return this};T.prototype.onAfterRenderingSelect=function(){var e=this._oControl.getDomRef("labelIcon");if(e){var t=this._oControl._customImage;var o=a.byId(e.id);if(t){e.style.backgroundImage="url('"+t+"')";e.classList.add("sapMSelectListItemIconCustom");e.children[0].title=S.getText("EDITOR_IMAGE_CUSTOMICON_TOOLTIP");o.onclick=function(e){e.stopImmediatePropagation();o._oImagePopover=new d(o.getId()+"-imagePopover",{placement:"Right",showHeader:false,content:new u(o.getId()+"-imagePopover-image",{src:t}).addStyleClass("image")}).addStyleClass("sapUiIntegrationImageSelect");o._oImagePopover.openBy(o)}}else{e.style.backgroundImage="unset";e.classList.remove("sapMSelectListItemIconCustom");o.onclick=undefined}}};T.prototype.setAllowDefaultIcons=function(e){if(typeof e==="boolean"&&this.getAllowDefaultIcons()!==e){var t=this._oIconModel.getData();if(e){t=t.concat(r(C,500));var o=this._oConfigModel.getProperty("/icons/types");this._oControl.open=function(){this._fnOpen&&this._fnOpen.apply(this,arguments);if(!c(o,{Action:true,UI5:false,"SAP-icons-TNT":false,BusinessSuiteInAppSymbols:false})){this._oPicker.addStyleClass("sapUiIntegrationIconSelectList");this._oPicker.setContentHeight("400px")}}}else{t=t.slice(0,3);this._oControl.open=function(){this._fnOpen&&this._fnOpen.apply(this,arguments);this.getPicker().removeStyleClass("sapUiIntegrationIconSelectList")}}this._oIconModel.setData(t);this._oIconModel.setSizeLimit(t.length)}};return T});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/viz/ImageSelect", ["sap/ui/integration/editor/fields/viz/IconSelect"],function(e){"use strict";var i=e.extend("sap.ui.integration.editor.fields.viz.ImageSelect",{metadata:{library:"sap.ui.integration",properties:{allowDefaultIcons:{type:"boolean",defaultValue:false}}},renderer:{apiVersion:2}});return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/viz/ShapeSelect", ["sap/ui/integration/editor/fields/viz/VizBase","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/base/util/merge"],function(e,t,i,n){"use strict";var o=e.extend("sap.ui.integration.editor.fields.viz.ShapeSelect",{metadata:{library:"sap.ui.integration",properties:{value:{type:"string",defaultValue:"Circle"}}},renderer:{apiVersion:2}});o.prototype.onInit=function(){this._oControl=new t({items:[new i({icon:"sap-icon://circle-task",key:"Circle"}),new i({icon:"sap-icon://border",key:"Square"})]})};o.prototype.applyStyle=function(e){e.class("sapUiIntegrationShapeSelect")};o.prototype.bindPropertyToControl=function(e,t){if(e==="editable"){var i=n({},t);this._oControl.bindProperty("enabled",i)}if(e==="value"){var i=n({},t);this._oControl.bindProperty("selectedKey",i)}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/viz/VizBase", ["sap/ui/core/Control","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/base/util/merge"],function(t,e,o,n){"use strict";var i=t.extend("sap.ui.integration.editor.fields.viz.VizBase",{metadata:{library:"sap.ui.integration",properties:{value:{type:"string",defaultValue:""},editable:{type:"boolean",defaultValue:true}},aggregations:{_control:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}},renderer:{apiVersion:1,render:function(t,e){var o=e.getAggregation("_control");t.openStart("div",e);e.applyStyle(t);t.openEnd();t.renderControl(o);t.close("div")}}});i.prototype.init=function(){this.onInit();this.setAggregation("_control",this._oControl)};i.prototype.bindProperty=function(e,o){t.prototype.bindProperty.apply(this,arguments);this.bindPropertyToControl(e,o);return this};i.prototype.onInit=function(){};i.prototype.applyStyle=function(t){};i.prototype.bindPropertyToControl=function(t,e){};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/formatters/DateTimeFormatter", ["sap/ui/core/format/DateFormat","sap/ui/core/date/UniversalDate","sap/ui/integration/util/Utils"],function(e,t,a){"use strict";const r={dateTime(r,n,s){const i=a.processFormatArguments(n,s);const o=e.getDateTimeInstance(i.formatOptions,i.locale);let m;if(Array.isArray(r)){m=r.map(e=>new t(a.parseJsonDateTime(e)))}else if(r!==undefined){m=new t(a.parseJsonDateTime(r))}if(m){return o.format(m)}return""},date(r,n,s){const i=a.processFormatArguments(n,s);const o=e.getDateInstance(i.formatOptions,i.locale);let m;if(Array.isArray(r)){m=r.map(e=>new t(a.parseJsonDateTime(e)))}else if(r!==undefined){m=new t(a.parseJsonDateTime(r))}if(m){return o.format(m)}return""}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/formatters/IconFormatter", ["sap/ui/base/ManagedObject","sap/ui/core/Core","sap/ui/core/IconPool"],function(t,r,e){"use strict";var a=t.extend("sap.ui.integration.formatters.IconFormatter",{metadata:{library:"sap.ui.integration",associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}}});a.SRC_FOR_HIDDEN_ICON="SRC_FOR_HIDDEN_ICON";a.prototype.formatSrc=function(t){if(!t){return t}if(t===a.SRC_FOR_HIDDEN_ICON){return a.SRC_FOR_HIDDEN_ICON}if(t.startsWith("data:")||e.isIconURI(t)){return t}return this._format(t)};a.prototype._format=function(t){return this._getCardInstance().getRuntimeUrl(t)};a.prototype._getCardInstance=function(){return r.byId(this.getCard())};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/formatters/InitialsFormatter", [],function(){"use strict";var t={initials:function(t,n){var r=t.split(" "),n=!n?2:n,i="";r.forEach(function(t){i+=t.substring(0,1)});i=n===2?i.charAt(0)+i.charAt(i.length-1):i.substring(0,n);return i.toUpperCase()}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/formatters/NumberFormatter", ["sap/ui/core/format/NumberFormat","sap/ui/integration/util/Utils"],function(t,r){"use strict";var n={currency:function(n,e,o,a){var s=r.processFormatArguments(o,a),c=t.getCurrencyInstance(s.formatOptions,s.locale);return c.format(n,e)},float:function(n,e,o){var a=r.processFormatArguments(e,o),s=t.getFloatInstance(a.formatOptions,a.locale);return s.format(n)},integer:function(n,e,o){var a=r.processFormatArguments(e,o),s=t.getIntegerInstance(a.formatOptions,a.locale);return s.format(n)},percent:function(n,e,o){var a=r.processFormatArguments(e,o),s=t.getPercentInstance(a.formatOptions,a.locale);return s.format(n)},unit:function(n,e,o,a){var s=r.processFormatArguments(o,a),c=t.getUnitInstance(s.formatOptions,s.locale);return c.format(n,e)}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/formatters/TextFormatter", ["sap/base/strings/formatMessage"],function(t){"use strict";var e={text:function(e,s){return t(e,s)}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/library", ["sap/ui/base/DataType","sap/ui/core/Core","sap/ui/Global","sap/ui/core/library","sap/m/library","sap/f/library","sap/ui/unified/library","sap/ui/layout/library"],function(a,t){"use strict";var e=t.initLibrary({name:"sap.ui.integration",version:"1.120.31",dependencies:["sap.ui.core","sap.f","sap.m","sap.ui.unified","sap.ui.layout"],types:["sap.ui.integration.CardActionType","sap.ui.integration.CardDataMode","sap.ui.integration.CardMenuAction","sap.ui.integration.CardDesign","sap.ui.integration.CardDisplayVariant","sap.ui.integration.CardBlockingMessageType"],controls:["sap.ui.integration.widgets.Card","sap.ui.integration.cards.filters.FilterBar","sap.ui.integration.cards.Header","sap.ui.integration.cards.NumericHeader","sap.ui.integration.controls.ListContentItem","sap.ui.integration.controls.BlockingMessage"],elements:["sap.ui.integration.ActionDefinition","sap.ui.integration.Host","sap.ui.integration.Extension"],extensions:{"sap.ui.integration":{customElements:{card:"sap/ui/integration/customElements/CustomElementCard"}}}});e.CardActionType={Navigation:"Navigation",Submit:"Submit",Custom:"Custom",DateChange:"DateChange",MonthChange:"MonthChange",ShowCard:"ShowCard",HideCard:"HideCard"};e.CardDataMode={Active:"Active",Inactive:"Inactive",Auto:"Auto"};e.CardDesign={Solid:"Solid",Transparent:"Transparent"};e.CardDisplayVariant={Standard:"Standard",TileStandard:"TileStandard",TileStandardWide:"TileStandardWide",TileFlat:"TileFlat",TileFlatWide:"TileFlatWide"};e.CardActionArea={None:"None",Content:"Content",ContentItem:"ContentItem",ActionsStrip:"ActionsStrip",ContentItemDetail:"ContentItemDetail",Header:"Header"};e.CardBlockingMessageType={Error:"Error",NoData:"NoData",Information:"Information"};e.CardArea={Header:"Header",Filters:"Filters",Content:"Content"};e.CardPreviewMode={Off:"Off",MockData:"MockData",Abstract:"Abstract"};e.AttributesLayoutType={OneColumn:"OneColumn",TwoColumns:"TwoColumns"};e.CardMenuAction=a.createType("sap.ui.integration.CardMenuAction",{isValid:function(a){var t=["type","text","icon","tooltip","buttonType","enabled","visible","action","parameters","target","url"];return Object.keys(a).every(function(a){return t.indexOf(a)!==-1})}},"object");return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/model/ContextModel", ["sap/ui/model/json/JSONModel","sap/base/Log","sap/ui/integration/util/Utils"],function(t,e,s){"use strict";var i=t.extend("sap.ui.integration.model.ContextModel",{constructor:function(e,s){t.apply(this,arguments);this._aPendingPromises=[]}});i.prototype.setHost=function(t){this._oHost=t;this.resetHostProperties()};i.prototype.getProperty=function(i,o){if(i&&!i.startsWith("/")&&!o){i="/"+i}var n=this._oHost,r=this.resolve(i,o),a,u=n&&n.getContextValue;if(u){this._mValues=this._mValues||{};if(this._mValues.hasOwnProperty(r)){return this._mValues[r]}a=s.timeoutPromise(n.getContextValue(r.substring(1)));a=a.then(function(t){this._mValues[r]=t;this.checkUpdate()}.bind(this)).catch(function(t){this._mValues[r]=null;this.checkUpdate();e.error("Path "+r+" could not be resolved. Reason: "+t)}.bind(this));this._aPendingPromises.push(a);return null}else{return t.prototype.getProperty.apply(this,arguments)}};i.prototype.resetHostProperties=function(){this._mValues={}};i.prototype.waitForPendingProperties=function(){var t=Promise.all(this._aPendingPromises);this._aPendingPromises=[];return t};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/model/ObservableModel", ["sap/ui/model/json/JSONModel","sap/ui/model/ClientPropertyBinding","./PagingModelListBinding"],function(i,e,t){"use strict";var n=i.extend("sap.ui.integration.model.ObservableModel",{constructor:function(t,n){i.apply(this,arguments);this._observedBinding=new e(this,"/",this.getContext("/"));this._observedBinding.attachChange(this._handleChange.bind(this));this._fireChangeBound=this._fireChange.bind(this)}});n.prototype.destroy=function(){this._observedBinding.destroy();this._observedBinding=null;clearTimeout(this._iFireChangeCallId)};n.prototype._handleChange=function(){this._scheduleFireChange()};n.prototype._scheduleFireChange=function(){if(this._iFireChangeCallId){clearTimeout(this._iFireChangeCallId)}this._iFireChangeCallId=setTimeout(this._fireChangeBound,0)};n.prototype._fireChange=function(){this.fireEvent("change")};n.prototype.bindList=function(i,e,n,s,o){var h=this._oListBinding=new t(this,i,e,n,s,o);return h};n.prototype.sliceData=function(i,e){this._oListBinding._iStartIndex=i;this._oListBinding._iEndIndex=e;this._oListBinding.checkUpdate(true)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/model/PagingModelListBinding", ["sap/ui/model/json/JSONListBinding"],function(i){"use strict";var t=i.extend("sap.ui.integration.model.PagingModelListBinding",{});t.prototype.update=function(){i.prototype.update.call(this);if(this._iStartIndex!==undefined){this.aIndices=this.aIndices.slice(this._iStartIndex,this._iEndIndex)}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/services/Data", ["./Service"],function(t){"use strict";var e=t.extend();e.prototype.attachDataChanged=function(t,e){};e.prototype.detachDataChanged=function(t){};e.prototype.getData=function(t){return Promise.resolve(false)};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/services/Navigation", ["./Service"],function(e){"use strict";var t=e.extend();t.prototype.navigate=function(e){};t.prototype.enabled=function(e){return Promise.resolve(false)};t.prototype.hidden=function(e){return Promise.resolve(false)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/services/Service", [],function(){"use strict";var t=function(){};t.extend=function(t){if(!t){var e=this;t=function(){e.apply(this,arguments)}}t.prototype=Object.create(this.prototype);t.prototype.constructor=t;t.extend=this.extend.bind(t);return t};t.prototype.getInterface=function(){return this};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/BaseFactory", ["./BindingHelper","sap/base/util/merge","sap/ui/base/Object"],function(t,e,a){"use strict";var i=a.extend("sap.ui.integration.util.BaseFactory",{constructor:function(t){a.call(this);this._oCard=t}});i.prototype.createBindingInfos=function(a){var i=e({},a),n=i.data;delete i.data;i=t.createBindingInfos(i,this._oCard.getBindingNamespaces());if(n){i.data=n}return i};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/BindingHelper", ["sap/ui/base/BindingParser","sap/base/util/extend","sap/base/util/isPlainObject","sap/ui/integration/formatters/DateTimeFormatter","sap/ui/integration/formatters/NumberFormatter","sap/ui/integration/formatters/TextFormatter","sap/ui/integration/bindingFeatures/DateRange","sap/ui/integration/formatters/InitialsFormatter"],function(e,r,t,n,a,i,o,s){"use strict";var f=/\{\{([^}]+)\}\}/g,u=/\{\{(parameters\.[^}]+)\}\}/g,p=/\{\{(dataSources\.[^}]+)\}\}/g;var c={};var d={date:n.date,dateTime:n.dateTime,currency:a.currency,float:a.float,integer:a.integer,percent:a.percent,text:i.text,unit:a.unit,initials:s.initials};c.mLocals={format:d,dateRange:o};c.extractBindingInfo=function(t,n){t=c.escapeCardPlaceholders(t);return e.complexParser(t,undefined,true,undefined,undefined,undefined,r({},c.mLocals,n))};c.createBindingInfos=function(e,r){if(!e){return e}if(Array.isArray(e)){return e.map(function(e){return c.createBindingInfos(e,r)})}if(t(e)){var n={};for(var a in e){n[a]=c.createBindingInfos(e[a],r)}return n}if(typeof e==="string"){var i=c.extractBindingInfo(e,r);return c.escapeParametersAndDataSources(i||e)}return e};c.formattedProperty=function(e,t){if(e===undefined){return e}var n={};if(Array.isArray(e)){n.parts=e.map(function(e){return typeof e==="object"?r({},e):{value:e}});n.formatter=t}else if(typeof e==="object"){n=r({},e);if(e.formatter){var a=n.formatter;n.formatter=function(){var e=a.apply(this,arguments);return t(e)}}else{n.formatter=t}}else{n={value:e,formatter:t}}return n};c.escapeCardPlaceholders=function(e){if(typeof e!=="string"){return e}return e.replace(f,"\\{\\{$1\\}\\}")};c.escapeParametersAndDataSources=function(e){if(typeof e!=="string"){return e}return e.replace(u,"\\{\\{$1\\}\\}").replace(p,"\\{\\{$1\\}\\}")};c.isAbsolutePath=function(e){return e.startsWith("/")};c.prependRelativePaths=function(e,t){if(!e){return e}if(c.isBindingInfo(e)){var n=r({},e);if(n.path&&!this.isAbsolutePath(n.path)){n.path=t+"/"+n.path}if(n.parts){n.parts=n.parts.map(function(e){return c.prependRelativePaths(e,t)})}return n}if(Array.isArray(e)){return e.map(function(e){return c.prependRelativePaths(e,t)})}if(typeof e==="object"){var a={};for(var i in e){a[i]=c.prependRelativePaths(e[i],t)}return a}return e};c.propagateModels=function(e,t){var n=r({},e.oPropagatedProperties.oModels,e.oModels),a=Object.keys(n),i=e.getModel();if(i){t.setModel(i)}a.forEach(function(r){if(r==="undefined"){return}var n=e.getModel(r);if(n){t.setModel(n,r)}})};c.reuse=function(e){if(typeof e==="object"){return r({},e)}return e};c.isBindingInfo=function(e){if(!e){return false}return e.hasOwnProperty("path")||e.hasOwnProperty("parts")&&(e.hasOwnProperty("formatter")||e.hasOwnProperty("binding"))};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/BindingResolver", ["sap/ui/base/ManagedObject","sap/base/Log","sap/ui/model/Model","sap/ui/integration/util/BindingHelper","sap/base/util/extend","sap/base/util/isPlainObject"],function(e,r,n,i,t,a){"use strict";var s=e.extend("sap.ui.integration.util.SimpleControl",{metadata:{library:"sap.ui.integration",properties:{resolved:{type:"any"}}}});var o=new s;var u={};function l(e,n,t,s,o,u){if(s===o){r.warning("BindingResolver maximum level processing reached. Please check for circular dependencies.");return e}if(Array.isArray(e)){return e.map(function(e){return l(e,n,t,s+1,o,u)})}if(e&&a(e)&&!i.isBindingInfo(e)){var f={};for(var p in e){f[p]=l(e[p],n,t,s+1,o,u)}return f}if(typeof e==="string"&&!u){return d(e,n,t)}if(typeof e==="object"&&i.isBindingInfo(e)){return d(e,n,t)}return e}function d(r,a,s){if(!r){return r}var u=typeof r==="string"?e.bindingParser(r):t({},r);if(!u){return r}if(!s){s="/"}o.unbindProperty("resolved");o.unbindObject();o.setModel(null);if(a instanceof n){o.setModel(a)}else{i.propagateModels(a,o)}o.bindObject(s);o.bindProperty("resolved",u);var l=o.getResolved();return l}u.resolveValue=function(e,r,n,i){var t=0,a=30;if(r){return l(e,r,n,t,a,i)}else{return e}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/CacheAndRequestDataProvider", ["sap/ui/integration/util/RequestDataProvider","sap/base/Log","sap/ui/core/Core","sap/base/util/deepExtend","sap/ui/core/date/UI5Date"],function(e,t,a,s,i){"use strict";var r=31536e3;function n(e){var t=e.url,a=e.data,s,i;if(e.method!=="GET"){return e.url}s=new URL(t,window.location.href);for(i in a){s.searchParams.set(i,a[i])}return s.href}var o=e.extend("sap.ui.integration.util.CacheAndRequestDataProvider");o.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oRefreshWithoutCacheBound=this.refreshWithoutCache.bind(this)};o.prototype.destroy=function(){this._unsubscribeFromHostMessages();this._detachTimestampPress();e.prototype.destroy.apply(this,arguments)};o.prototype.getHostInstance=function(){return a.byId(this.getHost())};o.prototype.getCardInstance=function(){return a.byId(this.getCard())};o.prototype.getCardInstanceHeader=function(){var e=this.getCardInstance();if(!e){return null}return e.getCardHeader()};o.prototype.onDataRequestComplete=function(){var e;if(this._iUpdateIntervalTimeout){clearTimeout(this._iUpdateIntervalTimeout);this._iUpdateIntervalTimeout=null}if(!this.getSettings()||!this.getSettings().updateInterval){return}e=parseInt(this.getSettings().updateInterval);if(isNaN(e)){return}this._iUpdateIntervalTimeout=setTimeout(function(){this.refreshWithoutCache()}.bind(this),e*1e3)};o.prototype._request=function(t){var a,s=this.getCardInstanceHeader();this._sCurrentRequestFullUrl=n(t.url);this._subscribeToHostMessages();a=e.prototype._request.apply(this,arguments);a.then(function(e){var t=e[1],a=t.headers.get("Date");if(a&&s){this._attachTimestampPress();s.setDataTimestamp(i.getInstance(a).toISOString())}}.bind(this));return a};o.prototype.refreshWithoutCache=function(){var e=this.getCardInstanceHeader();if(e){e.setDataTimestampUpdating(true)}setTimeout(function(){this._bCacheOnly=false;this._bNoCache=true;this._triggerDataUpdate()}.bind(this),200)};o.prototype.refreshFromCache=function(){var e=this.getCardInstanceHeader();if(e){e.setDataTimestampUpdating(true)}setTimeout(function(){this._bCacheOnly=true;this._bNoCache=false;this._triggerDataUpdate()}.bind(this),200)};o.prototype._modifyRequestBeforeSent=function(t,a){a.request=this._addCacheSettings(a.request);return e.prototype._modifyRequestBeforeSent.call(this,t,a)};o.prototype._addCacheSettings=function(e){var t={cache:{enabled:true,maxAge:0,staleWhileRevalidate:true}},a=s(t,e),i=a.cache;if(i.noStore){i.enabled=false}if(i.enabled){if(this._bCacheOnly){i.maxAge=r;i.staleWhileRevalidate=false}else if(this._bNoCache){i.maxAge=0;i.staleWhileRevalidate=false}}return a};o.prototype._getRequestSettings=function(){return this._addCacheSettings(this.getSettings().request)};o.prototype._subscribeToHostMessages=function(){var e=this.getHostInstance();if(this._bIsSubscribed){return}if(!e){return}e.attachMessage(this._handleHostMessage,this);this._bIsSubscribed=true};o.prototype._unsubscribeFromHostMessages=function(){var e=this.getHostInstance();if(!e){return}e.detachMessage(this._handleHostMessage,this);this._bIsSubscribed=false};o.prototype._handleHostMessage=function(e){var a=e.getParameter("data");if(a.type!=="ui-integration-card-update"){return}if(a.url!==this._sCurrentRequestFullUrl){return}t.info("[CARDS CACHE] message ui-integration-card-update received for "+a.url);this.refreshFromCache()};o.prototype._attachTimestampPress=function(e){var t=this.getCardInstance(),a=this.getCardInstanceHeader();if(this._oHeaderDelegate){return}if(!a){return}this._oHeaderDelegate={onBeforeRendering:function(){var e=t.$().find(".sapFCardDataTimestamp");e.off("click",this._oRefreshWithoutCacheBound)}.bind(this),onAfterRendering:function(){var e=t.$().find(".sapFCardDataTimestamp");e.on("click",this._oRefreshWithoutCacheBound)}.bind(this)};a.addEventDelegate(this._oHeaderDelegate)};o.prototype._detachTimestampPress=function(e){var t=this.getCardInstance(),a=this.getCardInstanceHeader(),s=t&&t.$().find(".sapFCardDataTimestamp");if(!a){return}s.off("click",this._oRefreshWithoutCacheBound);a.removeEventDelegate(this._oHeaderDelegate);this._oHeaderDelegate=null};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/CardMerger", ["sap/base/util/merge","sap/ui/model/json/JSONModel","sap/ui/core/Core","sap/base/util/deepClone"],function(e,t,r,a){"use strict";var n={layers:{admin:0,content:5,translation:10,all:20},mergeManifestPathChanges:function(e,t){Object.keys(t).forEach(function(r){if(r.charAt(0)==="/"){var a=t[r];e.setProperty(r,a)}})},mergeTextsChanges:function(e,t,a){var i=r.getConfiguration().getLanguage().replaceAll("_","-");if(t&&t.hasOwnProperty(i)){var o=t[i];for(var s in o){var f=o[s];if(typeof f==="object"){n.translateObject(e,s,f,a)}else{var l=e.getProperty(s);var c=true;if(l&&typeof l==="string"&&(l.indexOf("{context>")===0||l.indexOf("{{parameters")===0)){c=false}if(c){e.setProperty(s,f)}}}}},mergeCardDelta:function(a,i,o){var s=e({},a);if(typeof o==="undefined"){o="sap.card"}if(Array.isArray(i)&&i.length>0){var f,l,c;i.forEach(function(a){if(a.content){e(s[o],a.content)}else{var i=a.hasOwnProperty(":layer")?a[":layer"]:1e3;if(i===n.layers["translation"]){var u=r.getConfiguration().getLanguage().replaceAll("_","-");var p={texts:{}};p.texts[u]={};delete a.texts;Object.keys(a).forEach(function(e){if(e.charAt(0)==="/"){p.texts[u][e]=a[e]}else{p[e]=a[e]}});a=p}l=e(l,a.texts);c=e(c,a[":designtime"]);f=f||new t(s);n.mergeManifestPathChanges(f,a)}});n.mergeTextsChanges(f,l,c)}return s},mergeCardDesigntimeMetadata:function(t,r){var a=e({},t);r.forEach(function(e){var t=e.content.entityPropertyChange||[];t.forEach(function(e){var t=e.propertyPath;switch(e.operation){case"UPDATE":if(a.hasOwnProperty(t)){a[t]=e.propertyValue}break;case"DELETE":delete a[t];break;case"INSERT":if(!a.hasOwnProperty(t)){a[t]=e.propertyValue}break;default:break}})});return a},translateObject:function(t,r,n,i){var o=t.getProperty(r);if(!o||typeof o!=="object"){return}o=a(o,500);if(!Array.isArray(o)){var s=(o._dt||{})._uuid;if(s&&n[s]){if(i&&i[r]&&i[r][s]){for(var f in i[r][s]){if(i[r][s][f].translatable===false){delete n[s][f]}}}e(o,n[s]);t.setProperty(r,o)}}else{o.forEach(function(t){var a=(t._dt||{})._uuid;if(a&&n[a]){if(i&&i[r]&&i[r][a]){for(var o in i[r][a]){if(i[r][a][o].translatable===false){delete n[a][o]}}}e(t,n[a])}});t.setProperty(r,o);return}}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/CardObserver", ["sap/ui/integration/library","sap/ui/base/Object"],function(e,t){"use strict";var r=e.CardDataMode;var s=t.extend("sap.ui.integration.util.CardObserver",{constructor:function(e){t.call(this);this._oCard=e;this._oObservedDomRef=null}});s.prototype.destroy=function(){t.prototype.destroy.apply(this,arguments);this._oCard=null;if(this._oObserver){this._oObserver.disconnect();this._oObserver=null}};s.prototype._createObserver=function(){if(!this._oObserver){this._oObserver=new window.IntersectionObserver(function(e){e.forEach(function(e){if(e.isIntersecting){this.loadManifest()}}.bind(this),{threshold:[.1]})}.bind(this))}};s.prototype.observe=function(e){if(!this._oObserver){this._createObserver()}if(e!==this._oObservedDomRef){if(this._oObservedDomRef){this._oObserver.unobserve(this._oObservedDomRef)}this._oObserver.observe(e);this._oObservedDomRef=e}};s.prototype.unobserve=function(e){if(this._oObserver&&this._oObservedDomRef===e){this._oObserver.unobserve(e);this._oObservedDomRef=null}};s.prototype.loadManifest=function(){var e=this._oCard.getDomRef();this._oCard.setDataMode(r.Active);this.unobserve(e)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/ContentFactory", ["./BaseFactory","sap/m/IllustratedMessageType","sap/ui/integration/cards/actions/CardActions","sap/ui/integration/cards/AdaptiveContent","sap/ui/integration/cards/AnalyticalContent","sap/ui/integration/cards/AnalyticsCloudContent","sap/ui/integration/cards/CalendarContent","sap/ui/integration/cards/ComponentContent","sap/ui/integration/cards/ListContent","sap/ui/integration/cards/ObjectContent","sap/ui/integration/cards/TableContent","sap/ui/integration/cards/TimelineContent","sap/ui/integration/cards/WebPageContent"],function(e,t,n,a,r,i,o,s,c,d,u,p,l){"use strict";var g=e.extend("sap.ui.integration.util.ContentFactory");g.prototype.create=function(e){var r=this._oCard,i=e.cardType,o=r.getAggregation("_extension");var s=this.getClass(i);if(!s){throw new Error(i.toUpperCase()+" content type is not supported.")}var c=new s({card:r});if(c instanceof a){c.setCardDataProvider(r._oDataProvider)}c.setServiceManager(e.serviceManager);c.setDataProviderFactory(e.dataProviderFactory);c.setIconFormatter(e.iconFormatter);c.setActions(new n({card:r}));c.setConfiguration(e.contentManifest);c.setNoDataConfiguration(e.noDataConfiguration);if(!(c instanceof a)){c.setDataConfiguration(e.contentManifest.data)}c.setLoadDependenciesPromise(Promise.all([c.loadDependencies(e.cardManifest),o?o.loadDependencies():Promise.resolve()]).then(function(){return true}).catch(function(e){if(e){r._handleError({type:t.ErrorScreen,title:r.getTranslatedText("CARD_DATA_LOAD_DEPENDENCIES_ERROR"),description:r.getTranslatedText("CARD_ERROR_REQUEST_DESCRIPTION"),details:e})}return false}));c.getLoadDependenciesPromise().then(function(e){if(e&&!c.isDestroyed()){c.applyConfiguration()}});return c};g.prototype.getClass=function(e){switch(e.toLowerCase()){case"adaptivecard":return a;case"analytical":return r;case"analyticscloud":return i;case"calendar":return o;case"component":return s;case"list":return c;case"object":return d;case"table":return u;case"timeline":return p;case"webpage":return l;default:return null}};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/CsrfTokenHandler", ["sap/ui/base/Object","sap/base/util/isPlainObject","sap/base/util/merge","sap/ui/model/json/JSONModel"],function(e,t,r,o){"use strict";var n=/\{\{csrfTokens.([^\}]+)/;var i="X-CSRF-Token";var s=e.extend("sap.ui.integration.util.CsrfTokenHandler",{metadata:{library:"sap.ui.integration"},constructor:function(t){e.call(this);t=t||{};this._oHost=t.host;this._oConfiguration=t.configuration}});s._mTokens=new Map;s.prototype.resolveToken=function(e){var t,o;e=r({},e);t=this._findCsrfPlaceholder(e);if(!t){return Promise.resolve(e)}o=this._getCsrfConfig(t.tokenName);if(this._oHost){return this._oHost.getCsrfToken(o).then(function(r){if(!r){return this._resolveTokenByUrl(e,t)}this._replaceCsrfPlaceholder(t,r);return e}.bind(this)).catch(function(e){return Promise.reject(e)})}return this._resolveTokenByUrl(e,t)};s.prototype._resolveTokenByUrl=function(e,t){var r=t.tokenName,o=this._getCsrfConfig(r).data.request.url;if(s._mTokens.has(o)){return s._mTokens.get(o).then(function(r){this._replaceCsrfPlaceholder(t,r);return e}.bind(this))}if(r){return this._requestToken(e,t)}return Promise.resolve(e)};s.prototype.setDataProviderFactory=function(e){this._oDataProviderFactory=e};s.prototype.setHost=function(e){this._oHost=e};s.prototype.isExpiredToken=function(e){if(!e){return false}var t=e.headers.get(i);return t&&t.toLowerCase()==="required"&&e.status===403};s.prototype._requestToken=function(e,t){var r=t.tokenName,n=this._getCsrfConfig(r);if(!r||!n){return Promise.reject("CSRF definition is incorrect")}var s=new Promise(function(e,t){var r=this._oDataProviderFactory.create(n.data);r.getData().then(function(t){var s,a;if(n.data.path){a=new o(t);s=a.getProperty(n.data.path);a.destroy()}else{s=r.getLastResponse().headers.get(i)}e(s)}).catch(function(){t("CSRF token cannot be resolved")})}.bind(this));this._registerToken(n,s);return s.then(function(r){this._replaceCsrfPlaceholder(t,r);return e}.bind(this))};s.prototype.resetTokenByRequest=function(e){var t=this._findCsrfPlaceholder(e);if(!t){return}this._deleteRegisteredToken(this._getCsrfConfig(t.tokenName))};s.prototype._getCsrfConfig=function(e){return this._oConfiguration[e]};s.prototype._replaceCsrfPlaceholder=function(e,t){var r=e.object[e.key];e.object[e.key]=r.replace("{{csrfTokens."+e.tokenName+"}}",t)};s.prototype._findCsrfPlaceholder=function(e){var r,o,n;for(o in e){r=e[o];if(typeof r==="string"){n=this._getCsrfTokenName(r);if(n){return{object:e,key:o,tokenName:n}}}if(t(r)){r=this._findCsrfPlaceholder(r);if(r){return r}}}return null};s.prototype._getCsrfTokenName=function(e){var t=e.match(n);if(!t){return""}return t[1]};s.prototype._registerToken=function(e,t){s._mTokens.set(e.data.request.url,t);if(this._oHost){this._oHost.csrfTokenFetched(e,t)}};s.prototype._deleteRegisteredToken=function(e){s._mTokens.delete(e.data.request.url);if(this._oHost){this._oHost.csrfTokenExpired(e)}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/DataProvider", ["sap/ui/base/ManagedObject","sap/ui/integration/util/Measurement"],function(t,e){"use strict";var i=t.extend("sap.ui.integration.util.DataProvider",{metadata:{library:"sap.ui.integration",properties:{settings:{type:"object"},settingsJson:{type:"string"},baseRuntimeUrl:{type:"string"}},events:{dataRequested:{parameters:{}},dataChanged:{parameters:{data:{type:"object"}}},error:{parameters:{message:{type:"string"}}}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}}});i.prototype.init=function(){this._iCurrentRequestNumber=0};i.prototype.setDestinations=function(t){this._oDestinations=t};i.prototype.setCsrfTokenHandler=function(t){this._oCsrfTokenHandler=t};i.prototype.setDependencies=function(t){this._aDependencies=t};i.prototype.setSettingsJson=function(t){this.setProperty("settingsJson",t);this.setSettings(JSON.parse(t));if(this._bActive){this._scheduleDataUpdate(0)}};i.prototype._getRuntimeUrl=function(t){if(t.startsWith("http://")||t.startsWith("https://")||t.startsWith("//")){return t}var e=t&&t.trim().replace(/^\//,"");return this.getBaseRuntimeUrl()+e};i.prototype.triggerDataUpdate=function(){var t,e;this.fireDataRequested();t=this._waitDependencies();e=t.then(this._triggerDataUpdate.bind(this));if(!this._pInitialRequestPromise){this._pInitialRequestPromise=e}return e};i.prototype._triggerDataUpdate=function(){var t=this.getCard(),i;this._bActive=true;this._iCurrentRequestNumber++;if(t){i="UI5 Integration Cards "+t+" "+this.getId()+" getData#"+this._iCurrentRequestNumber;e.start(i,this.getDetails())}return this.getData().then(function(a){if(t){e.end(i)}this.fireDataChanged({data:a});this.onDataRequestComplete()}.bind(this)).catch(function(a){if(t){e.end(i)}if(Array.isArray(a)&&a.length>0){this.fireError({message:a[0],response:a[1],responseText:a[2],settings:a[3]})}else{this.fireError({message:a})}this.onDataRequestComplete()}.bind(this))};i.prototype.getData=function(){var t=this.getSettings();return new Promise(function(e,i){if(t.json){e(t.json)}else{i("Could not get card data.")}})};i.prototype.destroy=function(){if(this._iIntervalId){clearInterval(this._iIntervalId);this._iIntervalId=null}if(this._iDataUpdateCallId){clearTimeout(this._iDataUpdateCallId);this._iDataUpdateCallId=null}t.prototype.destroy.apply(this,arguments)};i.prototype.getInitialRequestPromise=function(){return this._pInitialRequestPromise};i.prototype.onDataRequestComplete=function(){var t;var e=this.getSettings();if(!e||!e.updateInterval){return}t=parseInt(e.updateInterval);if(isNaN(t)){return}this._scheduleDataUpdate(t*1e3)};i.prototype._scheduleDataUpdate=function(t){if(this._iDataUpdateCallId){clearTimeout(this._iDataUpdateCallId)}this._iDataUpdateCallId=setTimeout(this.triggerDataUpdate.bind(this),t)};i.prototype._waitDependencies=function(){var t=this._aDependencies||[],e=[];t.forEach(function(t){e.push(t.getInitialRequestPromise())});return Promise.all(e)};i.prototype.getDetails=function(){return"Static JSON data provided in the manifest."};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/DataProviderFactory", ["sap/ui/base/EventProvider","sap/base/Log","sap/ui/integration/library","sap/ui/integration/util/ServiceDataProvider","sap/ui/integration/util/RequestDataProvider","sap/ui/integration/util/CacheAndRequestDataProvider","sap/ui/integration/util/DataProvider","sap/ui/integration/util/ExtensionDataProvider","sap/ui/integration/util/JSONBindingHelper","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/CsrfTokenHandler"],function(e,t,i,s,r,n,o,a,d,u,l){"use strict";var f=i.CardPreviewMode;var c=e.extend("sap.ui.integration.util.DataProviderFactory",{constructor:function(t){e.call(this);t=t||{};this._oDestinations=t.destinations;this._oExtension=t.extension;this._oCsrfTokenHandler=t.csrfTokenHandler;this._oCard=t.card;this._oEditor=t.editor;this._oHost=t.host;if(t.csrfTokensConfig){this._oCsrfTokenHandler=new l({host:t.host,configuration:t.csrfTokensConfig})}this._aDataProviders=[];this._aFiltersProviders=[]}});c.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments);if(this._aDataProviders){this._aDataProviders.forEach(function(e){if(!e.bIsDestroyed){e.destroy()}});this._aDataProviders=null;this._aFiltersProviders=null}if(this._oCsrfTokenHandler){this._oCsrfTokenHandler.destroy();this._oCsrfTokenHandler=null}this._oCard=null;this._oExtension=null;this._bIsDestroyed=true};c.prototype.isDestroyed=function(){return this._bIsDestroyed};c.prototype.create=function(e,t,i,d){var l=this._oCard;if(!c.isProvidingConfiguration(e)||l&&l.getPreviewMode()===f.Abstract){return null}if(l&&l.getPreviewMode()===f.MockData){e=this._applyMockDataConfiguration(e)}var h=this._oEditor,g=this._oHost||l&&l.getHostInstance()||h&&h.getHostInstance(),p=g&&g.bUseExperimentalCaching,v=this._createDataProviderSettings(e,d),_;if(e.request&&p){_=new n(v);_.setHost(g)}else if(e.request){_=new r(v);if(g){_.setHost(g)}}else if(e.service){_=new s(v)}else if(e.json){_=new o(v)}else if(e.extension){_=new a(v,this._oExtension)}if(l){_.setCard(l);u.propagateModels(l,_)}else if(h){u.propagateModels(h,_)}_.bindObject("/");_.setDestinations(this._oDestinations);if(this._oCsrfTokenHandler){_.setCsrfTokenHandler(this._oCsrfTokenHandler);this._oCsrfTokenHandler.setDataProviderFactory(this)}if(_.isA("sap.ui.integration.util.IServiceDataProvider")){_.createServiceInstances(t)}this._aDataProviders.push(_);if(i){this._aFiltersProviders.push(_)}else{_.setDependencies(this._aFiltersProviders)}return _};c.prototype.remove=function(e){var t=this._aDataProviders.indexOf(e);if(t>-1){this._aDataProviders.splice(t,1)}if(e&&!e.bDestroyed&&e._bIsDestroyed){e.destroy()}};c.prototype.setHost=function(e){this._oHost=e;if(this._oCsrfTokenHandler){this._oCsrfTokenHandler.setHost(e)}};c.prototype._createDataProviderSettings=function(e,t){var i=this._oCard;var s=this._oEditor;var r={};if(i){r.baseRuntimeUrl=i.getRuntimeUrl("/");if(t){r.settings=e}else{r.settingsJson=d.createJsonWithBindingInfos(e,i.getBindingNamespaces())}}else if(s){r.baseRuntimeUrl=s.getRuntimeUrl("/");r.settingsJson=d.createJsonWithBindingInfos(e,s.getBindingNamespaces())}else{r.settingsJson=d.createJsonWithBindingInfos(e,{})}return r};c.prototype._applyMockDataConfiguration=function(e){if(!e.mockData||!c.isProvidingConfiguration(e.mockData)){t.error("There is no mock data configured.","sap.ui.integration.widgets.Card");return null}var i=Object.assign({},e);delete i.request;delete i.service;delete i.json;delete i.extension;return Object.assign(i,e.mockData)};c.isProvidingConfiguration=function(e){return e&&(e.request||e.service||e.json||e.extension)};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/DateRangeHelper", ["sap/m/DynamicDateRange","sap/m/DatePicker","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/BindingHelper","sap/ui/core/date/UI5Date"],function(t,e,a,r,n){"use strict";var o=n.getInstance(-864e13);var s=n.getInstance("1753-01-01");var i=n.getInstance(864e13);var T=n.getInstance("9999-12-31");var u={DATE:"date",TODAY:"today",YESTERDAY:"yesterday",TOMORROW:"tomorrow",DATERANGE:"dateRange",DATETIMERANGE:"dateTimeRange",FROM:"from",TO:"to",FROMDATETIME:"fromDateTime",TODATETIME:"toDateTime",YEARTODATE:"yearToDate",LASTDAYS:"lastDays",LASTWEEKS:"lastWeeks",LASTMONTHS:"lastMonths",LASTQUARTERS:"lastQuarters",LASTYEARS:"lastYears",NEXTDAYS:"nextDays",NEXTWEEKS:"nextWeeks",NEXTMONTHS:"nextMonths",NEXTQUARTERS:"nextQuarters",NEXTYEARS:"nextYears",TODAYFROMTO:"todayFromTo",THISWEEK:"thisWeek",LASTWEEK:"lastWeek",NEXTWEEK:"nextWeek",SPECIFICMONTH:"specificMonth",THISMONTH:"thisMonth",LASTMONTH:"lastMonth",NEXTMONTH:"nextMonth",THISQUARTER:"thisQuarter",LASTQUARTER:"lastQuarter",NEXTQUARTER:"nextQuarter",QUARTER1:"quarter1",QUARTER2:"quarter2",QUARTER3:"quarter3",QUARTER4:"quarter4",THISYEAR:"thisYear",LASTYEAR:"lastYear",NEXTYEAR:"nextYear",DATETIME:"dateTime"};function E(t){return u[t]}function l(t){return t.getFullYear().toString().padStart(4,"0")+"-"+(t.getMonth()+1).toString().padStart(2,"0")+"-"+t.getDate().toString().padStart(2,"0")}var S={};S.createInput=function(a,r,n){var o;var s=a.options.map(function(t){return t.toUpperCase()});if(s.length===1&&s[0]==="DATE"&&n){o=new e}else{o=new t({standardOptions:s})}S.setValue(o,a.value,r);return o};S.setValue=function(t,e,r){if(!e){return}var o=a.resolveValue(e,r);if(t.isA("sap.m.DatePicker")){var s;if(o.values){s=o.values[0]}t.setValue(s)}else{var i=o.option.toUpperCase();var T=t.getOption(i).getValueTypes();t.setValue({operator:i,values:o.values.map(function(t,e){if(T[e]==="date"||T[e]==="datetime"){return n.getInstance(t)}return t})})}};S.getValueForModel=function(e){var a;var r;var u;var S;if(e.isA("sap.m.DatePicker")&&e.getValue()&&e.isValidValue()){S={operator:"DATE",values:[n.getInstance(e.getValue())]}}else if(e.isA("sap.m.DynamicDateRange")){S=e.getValue()}if(S){a={option:E(S.operator),values:S.values.slice()};var A=t.toDates(S),D=A[0],R=S.operator==="TO"||S.operator==="TODATETIME",g=S.operator==="FROM"||S.operator==="FROMDATETIME",p=R||g?0:1,c=A[p];r={start:D.toISOString(),end:c.toISOString(),startLocalDate:l(D),endLocalDate:l(c)};u={start:D.toISOString(),end:c.toISOString(),startLocalDate:l(D),endLocalDate:l(c)};if(R){r.start=o.toISOString();u.start=s.toISOString();r.startLocalDate=l(o);u.startLocalDate=l(s)}if(g){r.end=i.toISOString();u.end=T.toISOString();r.endLocalDate=l(i);u.endLocalDate=l(T)}}return{value:a,range:r,rangeOData:u}};S.getAllOptions=function(){return u};return S});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/Destinations", ["sap/ui/base/Object","sap/base/Log","sap/base/util/isPlainObject","sap/ui/integration/util/Utils"],function(t,e,i,r){"use strict";var n=/\{\{destinations.([^\}]+)/;var o=t.extend("sap.ui.integration.util.Destinations",{metadata:{library:"sap.ui.integration"},constructor:function(e){t.call(this);this._oHost=e.host;this._oCard=e.card;this._oConfiguration=e.manifestConfig;this._mResolved=new Map}});o.prototype.setHost=function(t){this._oHost=t;this._mResolved.clear()};o.prototype.process=function(t){var i=[];this._processObject(t,undefined,i);return Promise.all(i).then(function(){return t}).catch(function(i){e.error(i,"sap.ui.integration.util.Destinations");return t})};o.prototype._processObject=function(t,e,r){if(!t){return Promise.resolve(t)}var n=t.hasOwnProperty(e)?t[e]:t;if(typeof n==="string"){r.push(this.processString(n).then(function(i){if(e!==undefined){t[e]=i}}).catch(function(){if(e!==undefined){t[e]=""}}))}if(i(n)){Object.keys(n).forEach(function(t){this._processObject(n,t,r)}.bind(this))}if(Array.isArray(n)){n.forEach(function(t,e){this._processObject(n,e,r)}.bind(this))}};o.prototype.getUrl=function(t){var e;if(this._mResolved.has(t)){return this._mResolved.get(t)}e=this._resolveUrl(t);this._mResolved.set(t,e);return e};o.prototype._resolveUrl=function(t){var i=this._oConfiguration?this._oConfiguration[t]:null,n,o,s;if(!i){return Promise.reject("Configuration for destination '"+t+"' was not found in the manifest.")}n=i.name;o=i.defaultUrl;if(!n&&!o){return Promise.reject("Can not resolve destination '"+t+"'. Neither 'name' nor 'defaultUrl' is configured.")}if(!n&&o){return Promise.resolve(o)}if(!this._oHost&&!o){return Promise.reject("Can not resolve destination '"+t+"'. There is no 'host' and no defaultUrl specified.")}if(!this._oHost&&o){return Promise.resolve(o)}s=r.timeoutPromise(this._oHost.getDestination(n,this._oCard));if(o){return s.catch(function(t){e.info(t+" Fallback to default url.","sap.ui.integration.util.Destinations");return o})}return s};o.prototype.hasDestination=function(t){return!!t.match(n)};o.prototype.processString=function(t){var e=t.match(n),i;if(!e){return Promise.resolve(t)}i=e[1];return this.getUrl(i).then(function(e){return this._replaceUrl(t,i,e)}.bind(this))};o.prototype._replaceUrl=function(t,e,i){var r=i.trim().replace(/\/$/,"");return t.replace("{{destinations."+e+"}}",r)};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/Duration", ["sap/base/Log","sap/base/strings/formatMessage"],function(r,a){"use strict";var t=/(\d+Y)?(\d+M)?(\d+W)?(\d+D)?/;var e=/(?:T(?=.)(\d+H)?(\d+M)?(\d+S)?)?/;var n=new RegExp("^P(?=.)"+t.source+e.source+"$");var i={};i._INVALID_DURATION="Invalid duration: {0}";i._UNSUPPORTED_DATE="Duration {0} contains unsupported date part";i._UNSUPPORTED_SECONDS="Duration {0} contains unsupported seconds part";i._MINUTES_OUT_OF_RANGE="Minutes of duration {0} are out of supported range [0-59]";i._HOURS_OUT_OF_RANGE="Hours of duration {0} are out of supported range [0-24]";i.fromISO=function(t){if(!t){return""}var e=n.exec(t);if(!e){r.error(a(i._INVALID_DURATION,t),"sap.ui.integration.widgets.Card");return""}var o=e[1];var s=e[2];var u=e[3];var d=e[4];var _=e[5];var p=e[6];var O=e[7];if(o||s||u||d){r.error(a(i._UNSUPPORTED_DATE,t),"sap.ui.integration.widgets.Card");return""}if(O){r.error(a(i._UNSUPPORTED_SECONDS,t),"sap.ui.integration.widgets.Card");return""}var f=_?parseInt(_):0;var v=p?parseInt(p):0;if(f>24){r.error(a(i._HOURS_OUT_OF_RANGE,t),"sap.ui.integration.widgets.Card");return""}if(v>59){r.error(a(i._MINUTES_OUT_OF_RANGE,t),"sap.ui.integration.widgets.Card");return""}return f+":"+v.toString().padStart(2,"0")};i.toISO=function(r){var a=r.split(":");var t=parseInt(a[0]);var e=parseInt(a[1]);var n="PT";if(t){n+=t+"H"}if(e){n+=e+"M"}if(!t&&!e){n+="0S"}return n};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/ErrorHandler", ["./Utils","../library","sap/m/IllustratedMessageType","sap/ui/base/BindingParser"],function(e,t,r,s){"use strict";var a=t.CardBlockingMessageType;function n(e){return s.complexParser.escape(JSON.stringify(e,null,4))}function T(e){if(e.options){e.options.body=e.body&&e.body.toString();e.options.headers=Object.fromEntries(e.options.headers)}return n(e)}var E={};E.configureDataRequestErrorInfo=function(t,E){var R=t.requestErrorParams.response,o=t.requestErrorParams.responseText,i=r.ErrorScreen,_=R?R.status+" "+R.statusText:E.getTranslatedText("CARD_ERROR_OCCURED"),l=R?E.getTranslatedText("CARD_ERROR_REQUEST_DESCRIPTION"):t.requestErrorParams.message.toString(),d=t.requestSettings,u=d.request?d.request.url:"",S=E.getTranslatedText("CARD_ERROR_REQUEST_DETAILS",[u]);if(R){switch(R.status){case 0:switch(R.statusText){case"timeout":i=r.ReloadScreen;_="408 "+E.getTranslatedText("CARD_ERROR_REQUEST_TIMEOUT_TITLE");S=E.getTranslatedText("CARD_ERROR_REQUEST_TIMEOUT_DETAILS",[u]);break;default:i=r.PageNotFound;_="404 "+E.getTranslatedText("CARD_ERROR_REQUEST_NOTFOUND_TITLE");break}break;case 404:i=r.PageNotFound;if(!R.statusText){_="404 "+E.getTranslatedText("CARD_ERROR_REQUEST_NOTFOUND_TITLE")}break;case 408:i=r.ReloadScreen;S=E.getTranslatedText("CARD_ERROR_REQUEST_TIMEOUT_DETAILS",[u]);break;case 401:case 403:case 511:l=E.getTranslatedText("CARD_ERROR_REQUEST_ACCESS_DENIED_DESCRIPTION");break}}S=_+"\n"+l+"\n\n";if(R){S+=E.getTranslatedText("CARD_LOG_MSG")+"\n"+R.statusText+"\n\n"}S+=E.getTranslatedText("CARD_REQUEST_SETTINGS")+"\n"+n(d)+"\n\n";if(R){S+=E.getTranslatedText("CARD_REQUEST")+"\n"+T(t.requestErrorParams.settings)+"\n\n"+E.getTranslatedText("CARD_RESPONSE_HEADERS")+"\n"+n(Object.fromEntries(R.headers))+"\n\n"}if(R&&o){S+=E.getTranslatedText("CARD_RESPONSE")+"\n";if(e.isJson(o)){S+=n(JSON.parse(o))}else{S+=s.complexParser.escape(o)}S+="\n\n"}S+=E.getTranslatedText("CARD_MANIFEST")+"\n"+n(E._oCardManifest.getJson())+"\n\n";S+=E.getTranslatedText("CARD_STACK_TRACE")+"\n"+(new Error).stack;return{type:a.Error,illustrationType:i,title:_,description:l,details:S,httpResponse:R}};E.configureErrorInfo=function(e,t){var r=t.getTranslatedText("CARD_MANIFEST")+"\n"+n(t._oCardManifest.getJson())+"\n\n"+t.getTranslatedText("CARD_STACK_TRACE")+"\n"+(new Error).stack;return{type:a.Error,illustrationType:e.illustrationType,title:e.title,description:e.description,details:r}};return E});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/ExtensionDataProvider", ["sap/ui/integration/util/DataProvider"],function(t){"use strict";var e=t.extend("sap.ui.integration.util.ExtensionDataProvider",{metadata:{library:"sap.ui.integration"},constructor:function(e,o){t.call(this,e);this._oExtension=o}});e.prototype.destroy=function(){t.prototype.destroy.apply(this,arguments);this._oExtension=null};e.prototype.getData=function(){var t=this.getSettings().extension;if(!this._oExtension){return Promise.reject("The extension module is not loaded properly or doesn't export a correct value.")}if(!this._oExtension[t.method]){return Promise.reject("Extension doesn't implement "+t.method+" method.")}return this._oExtension[t.method].apply(this._oExtension,t.args)};e.prototype.getDetails=function(){return"Load data from Extension. Method: "+this.getSettings().extension.method};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/Form", ["sap/ui/base/ManagedObject","sap/ui/core/library","sap/ui/core/Core","sap/base/Log","sap/base/util/deepExtend","./Validators","./BindingHelper","./BindingResolver","./DateRangeHelper","./Duration"],function(e,t,r,i,o,a,n,s,l,u){"use strict";var d=t.ValueState;var p=e.extend("sap.ui.integration.util.Form",{constructor:function(t){e.apply(this);this._oCard=t},metadata:{library:"sap.ui.integration"}});p.prototype.init=function(){this._mControls=new Map};p.prototype.exit=function(){this._mControls.clear();delete this._mControls;delete this._oCard};p.prototype.addControl=function(e,t,r,i){if(!this._isValidControlId(r.id)){return}this._syncToFormModelOn(e,t,r,i)};p.prototype.validate=function(e,t){var r=false;this._mControls.forEach(function(t){if(this._validateControl(t,e)){r=true}}.bind(this));if(r&&!t){this._oCard.scheduleFireStateChanged()}};p.prototype.resolveControl=function(e){var t={},r=this.getModel("form").getProperty("/"+e.id),i=this.getModel("messages").getProperty("/records"),o=i.find(function(t){return t.bindingPath==="/"+e.id}),a=this._mControls.get(e.id);if(o&&(a&&a._bShowValueState)){t.valueState={message:o.message,type:o.type}}switch(e.type){case"ComboBox":t.selectedKey=r.key;r=r.value;break;case"DateRange":r=r.value;break;default:break}t.value=r;return t};p.prototype.setControlValue=function(e){if(!this._isControlDataValid(e)){return}var t=e.id,r=this._mControls.get(t),i=e.value;if(r.isA("sap.m.ComboBox")){this._setComboBoxValue(r,e)}else if(i){if(r.isA("sap.m.DatePicker")||r.isA("sap.m.DynamicDateRange")){l.setValue(r,i,this._oCard)}else if(r.isA("sap.m.TimePicker")){r.setValue(u.fromISO(i))}else{r.setValue(i)}}this._validateAndUpdate(r)};p.prototype.updateModel=function(){this._mControls.forEach(this._updateModel.bind(this))};p.prototype._setComboBoxValue=function(e,t){var r;if("key"in t){e.setSelectedKey(t.key);r=e.getItems().find(function(e){return e.getKey()===t.key});e.setValue(r?r.getText():"")}if("value"in t&&!("key"in t)){r=e.getItems().find(function(e){return e.getText()===t.value});if(r){e.setSelectedItem(r)}else{e.setSelectedKey("");e.setValue(t.value)}}};p.prototype._isValidControlId=function(e){if(!e){i.error("Each input control must have an ID.","sap.ui.integration.widgets.Card");return false}if(this._mControls.has(e)){i.error("Duplicate form control ID - '"+e+"'","sap.ui.integration.widgets.Card");return false}return true};p.prototype._syncToFormModelOn=function(e,t,r,i){this._prepareValidationForControl(t,r,i);t.attachEvent(e,this._validateAndUpdate,this);if(r.value&&!n.isBindingInfo(r.value)){this._updateModel(t)}this._mControls.set(r.id,t)};p.prototype._updateModel=function(e){this.getModel("form").setProperty("/"+e._oItem.id,f(e))};p.prototype._validateAndUpdate=function(e){var t=e.getSource?e.getSource():e;this._validateControl(t,true);this._updateModel(t);this._oCard.scheduleFireStateChanged()};p.prototype._isControlDataValid=function(e){if(!e){return false}var t=e.id;if(!t){i.error("Form control data is missing property 'id'.","sap.ui.integration.widgets.Card");return false}var r=this._mControls.get(t);if(!r){i.error("Form control with ID - '"+t+"' does not exist.","sap.ui.integration.widgets.Card");return false}if(r.isA(["sap.m.TextArea","sap.m.Input"])&&!("value"in e)){i.error("Form data for control ID - '"+t+"' is missing property 'value'.","sap.ui.integration.widgets.Card");return false}if(r.isA("sap.m.ComboBox")){if("value"in e||"key"in e){return true}i.error("Form data for control ID - '"+t+"' requires properties 'key' or 'value'.","sap.ui.integration.widgets.Card");return false}return true};p.prototype._prepareValidationForControl=function(e,t,r){var i=o({},t);if(i.validations){i.validations.forEach(function(e,t){if(e.pattern){e.pattern=this._oCard.getManifestEntry(r+"/validations/"+t)["pattern"]}}.bind(this))}e._oItem=i};p.prototype._validateControl=function(e,t){var r=this._oCard.getAggregation("_extension"),i=e._oItem,o=e.getBindingContext(),a=o?o.getPath():"",n=false,l;this._removeMessageFromControl(e);if(!i){return n}n=!this._checkBuiltInValidations(e,i,t);if(!n&&i.validations){l=s.resolveValue(i.validations,e,a);n=!l.every(function(o){return this._checkValidationItem(o,e,i,t,r)}.bind(this))}this._updateMessageModel();return n};p.prototype._checkValidationItem=function(e,t,r,i,o){var n=a[this._getFormControlType(r)],s,l,u,p,c=this.getModel("i18n").getResourceBundle(),g=true;for(var h in e){s=e[h];if(h==="validate"){u=this._getExtensionFunctionName(s,o);if(u){p=o[u]}}else{p=n[h]}if(typeof p!=="function"){continue}l=p(f(t),s);if(!l){this._addMessageToControl(t,i,{type:e.type||d.Error,message:e.message||c.getText(n[h+"Txt"],s),bindingPath:"/"+r.id});g=false;break}}return g};p.prototype._checkBuiltInValidations=function(e,t,i){var o=true;if(e.isA("sap.m.DatePicker")&&!e.isValidValue()){this._addMessageToControl(e,i,{type:d.Error,message:r.getLibraryResourceBundle("sap.ui.core").getText("VALUE_STATE_ERROR"),bindingPath:"/"+t.id});o=false}return o};p.prototype._addMessageToControl=function(e,t,r){var i=this.getModel("messages"),o=i.getData();o.records.push(r);i.setData(o);if(t||e._bShowValueState){e._bShowValueState=true;e.setValueState(r.type);e.setValueStateText(r.message)}this._updateMessageModel()};p.prototype._removeMessageFromControl=function(e){var t=this.getModel("messages"),r="/"+e._oItem.id,i=t.getData(),o=false;e.setValueState(d.None);for(var a=0;a<i.records.length;a++){if(i.records[a].bindingPath===r){i.records.splice(a,1);o=true;break}}if(o){t.setData(i)}this._updateMessageModel()};p.prototype._updateMessageModel=function(){var e=this.getModel("messages"),t=e.getProperty("/records");e.setProperty("/hasErrors",t.some(function(e){return e.type===d.Error}));e.setProperty("/hasWarnings",t.some(function(e){return e.type===d.Warning}))};p.prototype.getRequiredValidationValue=function(e){var t=e.validations||[],r,i,o;for(i=0;i<t.length;i++){r=t[i];for(o in r){if(o==="required"){return r[o]}}}return false};p.prototype._getExtensionFunctionName=function(e,t){if(!e.startsWith("extension.")){i.error("Validation function should start with 'extension'.");return false}if(!t){i.error("Extension is not defined.");return false}var r=e.replace("extension.","");if(!t[r]){i.error("No such function.",r,"sap.ui.integration.widgets.Card");return false}return r};p.prototype._getFormControlType=function(e){switch(e.type){case"ComboBox":return"keyValuePair";case"DateRange":return"dateRange";default:return"string"}};function f(e){if(e.isA("sap.m.ComboBox")){e.synchronizeSelection();return{key:e.getSelectedKey(),value:e.getValue()}}else if(e.isA("sap.m.DynamicDateRange")||e.isA("sap.m.DatePicker")){return l.getValueForModel(e)}else if(e.isA("sap.m.TimePicker")){return u.toISO(e.getValue())}else{return e.getValue()}}return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/HeaderFactory", ["sap/ui/core/Core","./BaseFactory","sap/base/Log","sap/base/util/isEmptyObject","sap/ui/integration/cards/actions/CardActions","sap/ui/integration/library","sap/m/library","sap/ui/integration/cards/NumericHeader","sap/ui/integration/cards/Header","sap/ui/integration/util/Utils","sap/m/Button"],function(t,e,a,i,r,s,n,o,u,c,d){"use strict";var l=s.CardActionArea;var p=n.ButtonType;var f=s.CardDisplayVariant;var g=t.getLibraryResourceBundle("sap.ui.integration");var y=e.extend("sap.ui.integration.util.HeaderFactory");y.prototype.create=function(t,e){if(i(t)){a.warning("Card sap.card/header entry in the manifest is mandatory","sap.ui.integration.widgets.Card");return null}var s=this._oCard,n=s.getId()+"-header",d=s.getOpener(),p,f;t=this.createBindingInfos(t,s.getBindingNamespaces());if(d){e=this._createCloseButton(t)}switch(t.type){case"Numeric":f=new o(n,t,e,s._oIconFormatter);break;default:f=new u(n,t,e,s._oIconFormatter);break}f.setCard(s);if(t.status&&t.status.text&&t.status.text.format){p=c.getStatusTextBindingInfo(t.status.text.format,f);if(p){f.bindProperty("statusText",p)}}f.setServiceManager(s._oServiceManager);f.setDataProviderFactory(s._oDataProviderFactory);f._setDataConfiguration(t.data);if(s.isTileDisplayVariant()){this._setTileDefaults(f,t)}var g=new r({card:s});g.attach({area:l.Header,enabledPropertyName:"interactive",actions:t.actions,control:f});f._oActions=g;if(d){f.setProperty("focusable",false)}return f};y.prototype._createCloseButton=function(t){var e=true;if(t.closeButton&&"visible"in t.closeButton){e=t.closeButton.visible}var a=new d({type:p.Transparent,tooltip:g.getText("CARD_DIALOG_CLOSE_BUTTON"),visible:e,icon:"sap-icon://decline",press:function(){this._oCard.hide()}.bind(this)});return a};y.prototype._setTileDefaults=function(t,e){t.setProperty("useTileLayout",true);const a=this._oCard;const i=[f.TileFlat,f.TileFlatWide].indexOf(a.getDisplayVariant())>-1;if(!e.titleMaxLines){t.setTitleMaxLines(i?1:2)}if(i){t.setIconSize("XS");if(t.isA("sap.f.cards.NumericHeader")){t.setNumberSize("S")}if(!e.subtitleMaxLines){t.setSubtitleMaxLines(1)}}};return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/JSONBindingHelper", ["sap/ui/base/BindingParser","sap/ui/integration/util/BindingHelper"],function(n,i){"use strict";var e=[["ESCAPED_BINDING_START",/\\{/g,"\\{"],["ESCAPED_BINDING_END",/\\}/g,"\\}"],["BINDING_START",/{/g,"{"],["BINDING_END",/}/g,"}"]];var r={};r.createJsonWithBindingInfos=function(n,e){if(!n){return n}var r=this._createBindableJson(n),t=i.createBindingInfos(r,e);if(typeof t==="string"){t=this._escape(t)}return t};r._createBindableJson=function(n){var i;i=JSON.stringify(n,function(n,i){if(typeof i==="string"){return this._encodeBindingString(i)}return i}.bind(this));i=this._escape(i);i=this._decodeBindingString(i);return i};r._escape=function(i){return n.complexParser.escape(i)};r._encodeBindingString=function(n){e.forEach(function(i){var e=i[0],r=i[1];n=n.replace(r,e)});return n};r._decodeBindingString=function(n){e.forEach(function(i){var e=i[0],r=i[2];n=n.replace(new RegExp(e,"g"),r)});return n};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/LoadingProvider", ["sap/ui/core/Element"],function(t){"use strict";var i=t.extend("sap.ui.integration.util.LoadingProvider",{metadata:{library:"sap.ui.integration",properties:{loading:{type:"boolean",defaultValue:false}}}});i.prototype.setLoading=function(t){if(this._bAwaitPagination&&!t){return this}return this.setProperty("loading",t)};i.prototype.setAwaitPagination=function(t){this._bAwaitPagination=t};i.prototype.getAwaitPagination=function(){return this._bAwaitPagination};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/Manifest", ["sap/ui/base/Object","sap/base/util/LoaderExtensions","sap/ui/core/Manifest","sap/base/util/deepClone","sap/base/util/deepExtend","sap/base/util/each","sap/base/util/isPlainObject","sap/base/util/isEmptyObject","sap/base/Log","./ParameterMap","sap/ui/integration/util/CardMerger"],function(e,t,s,i,r,n,o,a,f,u,h){"use strict";var c="/{SECTION}/configuration/parameters",p="/{SECTION}/configuration/filters",l="/{SECTION}",d="/sap.app/dataSources",g=/\{\{(?!parameters.)(?!destinations.)(?!csrfTokens.)([^\}\}]+)\}\}|\{i18n>([^\}]+)\}/g;var y=e.extend("sap.ui.integration.util.Manifest",{constructor:function(t,r,n,o){e.call(this);this._sBaseUrl=n;this._aChanges=o;this._sSection=t;this.PARAMETERS=c.replace("{SECTION}",t);this.FILTERS=p.replace("{SECTION}",t);this.CONFIGURATION=l.replace("{SECTION}",t);if(r){var a={},u;a.process=false;this._oInitialJson=i(r,500);if(n){a.baseUrl=n}else{f.error("If baseUrl is not provided when the manifest is an object, the relative resources cannot be loaded.","sap.ui.integration.widgets.Card")}this._registerManifestModulePath(r,n||"/");if(this._aChanges){u=this.mergeDeltaChanges(r)}else{u=r}this._oManifest=new s(u,a);this.oJson=this._oManifest.getRawJson()}}});y.prototype.mergeDeltaChanges=function(e){return h.mergeCardDelta(e,this._aChanges,this._sSection)};y.prototype.getJson=function(){return this._unfreeze(this.oJson)};y.prototype.setJson=function(e){_(e);this.oJson=e};y.prototype.getInitialJson=function(){return this._oInitialJson};y.prototype.get=function(e){return this._unfreeze(O(this.oJson,e))};y.prototype.getUrl=function(){return this._oManifest.resolveUri("./","manifest")};y.prototype.getResourceBundle=function(){return this.oResourceBundle};y.prototype._unfreeze=function(e){if(typeof e==="object"){return JSON.parse(JSON.stringify(e))}return e};y.prototype.destroy=function(){this.oJson=null;this.oResourceBundle=null;if(this._oManifest){this._oManifest.destroy()}this._bIsDestroyed=true};y.prototype.isDestroyed=function(){return this._bIsDestroyed};y.prototype.load=function(e){if(!e||!e.manifestUrl){if(this._sBaseUrl&&this._oManifest){return this.loadI18n().then(function(){this.processManifest()}.bind(this))}else{if(this._oManifest){this.processManifest()}return new Promise(function(e){e()})}}return s.load({manifestUrl:e.manifestUrl,async:true,processJson:function(t){var s=this._sBaseUrl||e.manifestUrl.replace(/\/+[^\/]*$/,"")||"/";this._registerManifestModulePath(t,s);this._oInitialJson=i(t,500);if(this._aChanges){return this.mergeDeltaChanges(t)}return t}.bind(this)}).then(function(e){this._oManifest=e;this.oJson=this._oManifest.getRawJson();return this.loadI18n().then(function(){this.processManifest()}.bind(this))}.bind(this))};y.prototype.loadDependenciesAndIncludes=function(){return this._oManifest.loadDependenciesAndIncludes(true)};y.prototype.loadI18n=function(){var e=false;s.processObject(this._oManifest.getJson(),function(t,s,i){if(!e&&i.match(g)){e=true}});if(this.get("/sap.app/i18n")){e=true}if(!e){return Promise.resolve()}return this._oManifest._loadI18n(true).then(function(e){this.oResourceBundle=e}.bind(this))};y.prototype.processManifest=function(){var e=0,t=15,s=r({},this._oManifest.getRawJson()),i=this.get(d);v(s,this.oResourceBundle,e,t,this._oCombinedParams,i,this._oCombinedFilters);this.setJson(s)};function _(e){if(e&&typeof e==="object"&&!Object.isFrozen(e)){Object.freeze(e);for(var t in e){if(e.hasOwnProperty(t)){_(e[t])}}}}function b(e){return typeof e==="string"&&e.match(g)&&e.indexOf("{{")===0&&e.indexOf("}}")===e.length-2}function m(e){return typeof e==="string"&&(e.indexOf("{{parameters.")>-1||e.indexOf("{{dataSources")>-1||e.indexOf("{{filters.")>-1)}y._processPlaceholder=function(e,t,s,i){var r=u.processPredefinedParameter(e),n,o;if(!a(t)){for(var f in t){n=t[f].value;o="{{parameters."+f;r=M(r,n,o)}}if(s){r=M(r,s,"{{dataSources")}if(i){r=M(r,i,"{{filters")}return r};function M(e,t,s){if(o(t)||Array.isArray(t)){for(var i in t){e=M(e,t[i],s+"."+i)}}else if(e.includes(s+"}}")){e=e.replace(new RegExp(s+"}}","g"),t)}return e}function v(e,t,s,i,r,n,o){if(s===i){return}if(Array.isArray(e)){e.forEach(function(e,a,f){if(typeof e==="object"){v(e,t,s+1,i,r,n,o)}else if(m(e)){f[a]=y._processPlaceholder(e,r,n,o)}else if(b(e)&&t){f[a]=t.getText(e.substring(2,e.length-2))}},this)}else{for(var a in e){if(typeof e[a]==="object"){v(e[a],t,s+1,i,r,n,o)}else if(m(e[a])){e[a]=y._processPlaceholder(e[a],r,n,o)}else if(b(e[a])&&t){e[a]=t.getText(e[a].substring(2,e[a].length-2))}}}}function O(e,t){if(t==="/"){return e}if(e&&t&&typeof t==="string"&&t[0]==="/"){var s=t.substring(1).split("/"),i;for(var r=0,n=s.length;r<n;r++){i=s[r];e=e.hasOwnProperty(i)?e[i]:undefined;if(e===null||typeof e!=="object"){if(r+1<n&&e!==undefined){e=undefined}break}}return e}return e&&e[t]}y.prototype.processFilters=function(e){if(!this._oManifest){return}var t=this.get(this.FILTERS),s={};if(e.size&&!t){f.error("If runtime filters are set, they have to be defined in the manifest configuration as well.");return}n(t,function(t,i){var r=e.get(t)||i.value;s[t]=r});this._oCombinedFilters=s;this.processManifest()};y.prototype.processParameters=function(e){if(!this._oManifest){return}var t=this.get(this.PARAMETERS);if(!a(e)&&!t){f.error("If parameters property is set, parameters should be described in the manifest");return}this._oCombinedParams=this._syncParameters(e,t);this.processManifest()};y.prototype.getProcessedParameters=function(e){var t=this.get(this.PARAMETERS),s=this._syncParameters(e,t);v(s,this.oResourceBundle,0,15,e);return s};y.prototype._syncParameters=function(e,t){if(a(e)){return t}var s=i(t||{},500),r=Object.getOwnPropertyNames(e),n=Object.getOwnPropertyNames(s);for(var o=0;o<n.length;o++){for(var f=0;f<r.length;f++){if(n[o]===r[f]){s[n[o]].value=e[r[f]]}}}return s};y.prototype.findDataSections=function(e){var t=[],s;if(!e){e=this.get(this.CONFIGURATION)}if(!o(e)){return[]}if(e.data){t.push(e.data)}for(s in e){if(e[s]){t=t.concat(this.findDataSections(e[s]))}}return t};y.prototype._registerManifestModulePath=function(e,s){var i=e&&e["sap.app"]&&e["sap.app"].id;if(!i){return}t.registerResourcePath(i.replace(/\./g,"/"),s)};return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/ManifestResolver", ["sap/ui/core/Core","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/Utils","sap/m/IllustratedMessageType","sap/m/IllustratedMessageSize","sap/base/Log"],function(e,t,r,n,a,i,o){"use strict";var s={};s.resolveCard=function(e){e.startManifestProcessing();return s._awaitReadyEvent(e).then(function(){return e.getModel("context").waitForPendingProperties()}).then(function(){return s._handleCardReady(e)}).catch(function(t){return s._handleCardSevereError(e,t)})};s._awaitReadyEvent=function(e){if(e.isReady()){return Promise.resolve(e)}return new Promise(function(t,r){e.attachEvent("_ready",function(r){t(e)})})};s._handleCardReady=function(e){var a=e.getManifestEntry("/"),i=[],o=e.getSevereErrors(),s=e.getContentMessage();if(o.length){return Promise.reject(o.join(" "))}try{a=t.createBindingInfos(a,e.getBindingNamespaces());if(e.getAggregation("_filterBar")){i=e.getAggregation("_filterBar")._getFilters().map(function(e){return["/sap.card/configuration/filters/"+e.getKey(),e]})}i.concat([["/sap.card/content",e.getCardContent()],["/sap.card/header",e.getCardHeader()],["/sap.card/footer",e.getCardFooter()],["/sap.card",e]]).filter(function(t){return!!e.getManifestEntry(t[0])}).forEach(function(e){var t=e[0];var i=e[1];var o;var u;if(s&&t==="/sap.card/content"){o={message:s}}else if(i.getStaticConfiguration){o=i.getStaticConfiguration(n.getNestedPropertyValue(a,t))}else{o=n.getNestedPropertyValue(a,t)}if(i.extendStaticConfiguration){i.extendStaticConfiguration(o)}if(o.data){u=o.data.path;delete o.data}o=r.resolveValue(o,i,u,true);n.setNestedPropertyValue(a,t,o)});return Promise.resolve(JSON.parse(JSON.stringify(a)))}catch(e){return Promise.reject(e)}};s._handleCardSevereError=function(t,r){var n=t.getManifestEntry("/"),s=e.getLibraryResourceBundle("sap.ui.integration");o.error(r,"sap.ui.integration.util.ManifestResolver");if(n===null){n={}}n["sap.card"]={content:{message:{type:"error",title:s.getText("CARD_ERROR_CONFIGURATION_TITLE"),description:s.getText("CARD_ERROR_CONFIGURATION_DESCRIPTION"),details:r.toString(),illustrationType:a.SimpleError,illustrationSize:i.Spot}}};return JSON.parse(JSON.stringify(n))};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/Measurement", ["sap/base/config"],function(e){"use strict";var r=performance&&performance.mark;var t=performance&&performance.measure;var a={start:function(e,r){if(!this.getActive()){return null}return performance.mark(e+"-start",{detail:r})},end:function(e){if(!this.getActive()){return null}var r=performance.getEntriesByName(e+"-start")[0],t,a="";if(r){a=r.detail}t=performance.mark(e+"-end",{start:e,detail:a});performance.measure(e,{start:e+"-start",end:e+"-end",detail:a});return t},hasEnded:function(e){if(!this.getActive()){return false}var r=performance.getEntriesByName(e+"-end")[0];return!!r},getActive:function(){var a=e.get({name:"sapUiXxMeasureCards",type:e.Type.Boolean,external:true});return a&&r&&t}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/ParameterMap", ["sap/ui/core/Core","sap/ui/core/date/UI5Date"],function(e,r){"use strict";var n={};var t={"{{parameters.NOW_ISO}}":a,"{{parameters.TODAY_ISO}}":i,"{{parameters.LOCALE}}":o};function a(){return r.getInstance().toISOString()}function i(){return r.getInstance().toISOString().slice(0,10)}function o(){return e.getConfiguration().getLocale().toString()}n.processPredefinedParameter=function(e){var r;Object.keys(t).forEach(function(n){r=new RegExp(n,"g");if(e.indexOf(n)>-1){e=e.replace(r,t[n]())}});return e};n.getParamsForModel=function(){var e={};for(var r in t){var n=r.indexOf("."),a=r.indexOf("}");e[r.substring(n+1,a)]=t[r]()}return e};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/RequestDataProvider", ["sap/ui/integration/util/DataProvider","sap/base/Log","sap/ui/model/odata/v4/ODataUtils","sap/ui/core/Core","sap/ui/core/Configuration","sap/base/util/fetch","sap/base/util/deepClone"],function(e,t,r,i,s,n,o){"use strict";var a=[429,503];var u=["no-cors","same-origin","cors"];var f=["GET","POST","HEAD","PUT","PATCH","DELETE","OPTIONS"];var d={json:"application/json, */*",xml:"application/xml, text/xml, */*"};function p(e,t){var r=Object.entries(t).map(function(e){return encodeURIComponent(e[0])+"="+encodeURIComponent(e[1])});return e+(e.indexOf("?")!==-1?"&":"?")+r.join("&")}function h(e){var t=e.headers.get("Content-Type");if(!t){return false}return t.indexOf("application/json")!==-1}function l(e){var t=e.headers.get("Content-Type");if(!t){return false}return t.indexOf("application/xml")!==-1||t.indexOf("text/xml")!==-1}var c=e.extend("sap.ui.integration.util.RequestDataProvider",{metadata:{library:"sap.ui.integration",properties:{allowCustomDataType:{type:"boolean",defaultValue:false}},associations:{host:{type:"sap.ui.integration.Host",multiple:false}}}});c.prototype.destroy=function(){if(this._iRetryAfterTimeout){clearTimeout(this._iRetryAfterTimeout)}e.prototype.destroy.apply(this,arguments)};c.prototype.getLastResponse=function(){return this._lastResponse};c.prototype.getData=function(){var e=this.getSettings().request,t=Promise.resolve(e);if(this._oDestinations){t=this._oDestinations.process(e)}if(this._oCsrfTokenHandler){t=t.then(function(e){return this._oCsrfTokenHandler.resolveToken(e)}.bind(this))}t=t.then(this._fetch.bind(this));if(this._oCsrfTokenHandler){t=t.catch(this._handleExpiredToken.bind(this))}return t};c.prototype._handleExpiredToken=function(e){if(this._oCsrfTokenHandler.isExpiredToken(this.getLastResponse())){this._oCsrfTokenHandler.resetTokenByRequest(this.getSettings().request);return this.getData().catch(function(e){throw e})}throw e};c.prototype._fetch=function(e){var i="Invalid request";if(!e||!e.url){t.error(i);return Promise.reject(i)}if(!this.getAllowCustomDataType()&&e.dataType){t.error("To specify dataType property in the Request Configuration, first set allowCustomDataType to 'true'.")}var s=e.url,n=e.parameters,o=this.getAllowCustomDataType()&&e.dataType||"json",a=e.headers||{},u=e.batch,f,h,l,c=e.method&&e.method.toUpperCase()||"GET",y=this._hasHeader(e,"Content-Type","application/json"),g=["GET","HEAD"].includes(c);if(!s.startsWith("/")){s=this._getRuntimeUrl(e.url)}if(n){if(y){l=JSON.stringify(n)}else if(g){s=p(s,n)}else{l=new URLSearchParams(n)}}if(u){f=r.serializeBatchRequest(Object.values(u));l=f.body;a=Object.assign({},a,f.headers)}h={url:s,options:{mode:e.mode||"cors",method:c,headers:new Headers(a)}};if(l){h.options.body=l}if(e.withCredentials){h.options.credentials="include"}if(!h.options.headers.get("Accept")&&d[o]){h.options.headers.set("Accept",d[o])}h=this._modifyRequestBeforeSent(h,this.getSettings());if(!this._isValidRequest(h)){t.error(i);return Promise.reject(i)}return this._request(h).then(function(e){var t=e[0];if(u){return this._deserializeBatchResponse(u,t)}return t}.bind(this))};c.prototype._request=function(e,t){var r=this._getFetchMethod(this._getRequestSettings());return r(e.url,e.options).then(function(r){if(this.bIsDestroyed){return Promise.reject("RequestDataProvider is already destroyed before the response is received.")}this._lastResponse=r;if(!r.ok){return r.text().then(function(i){var s=[r.status+" "+r.statusText,r,i,e];if(t){return Promise.reject(s)}return this._retryRequest(s)}.bind(this))}return r.text().then(function(t){if(h(r)){try{t=JSON.parse(t)}catch(t){return Promise.reject([t.toString(),null,null,e])}}else if(l(r)){t=(new window.DOMParser).parseFromString(t,"text/xml")}return[t,r]})}.bind(this),function(t){return Promise.reject([t.toString(),null,null,e])})};c.prototype._retryRequest=function(e){var r=e[1],i=e[3],s=this._getRetryAfter(r);if(!a.includes(r.status)){return Promise.reject(e)}if(!s){t.warning("Request could be retried, but Retry-After header or configuration parameter retryAfter are missing.");return Promise.reject(e)}if(this._iRetryAfterTimeout){e[0]="The retry was already scheduled.";return Promise.reject(e)}return new Promise(function(e,t){this._iRetryAfterTimeout=setTimeout(function(){this._request(i,true).then(e,t);this._iRetryAfterTimeout=null}.bind(this),s*1e3)}.bind(this))};c.prototype._getRetryAfter=function(e){var r=this.getSettings().request,i=e.headers.get("Retry-After")||r.retryAfter;if(!i){return 0}if(Number.isInteger(i)){return i}if(!i.match(/^\d+$/)){t.error("Only number of seconds is supported as value of retry-after. Given '"+i+"'.");return 0}return parseInt(i)};c.prototype._getFetchMethod=function(e){var t=i.byId(this.getCard()),r=t&&t.getAggregation("_extension"),s=i.byId(this.getHost());if(r){return function(t,i){return r.fetch(t,i,o(e,1e3))}}if(s){return function(r,i){return s.fetch(r,i,o(e,1e3),t)}}return n};c.prototype._getRequestSettings=function(){return this.getSettings().request};c.prototype._hasHeader=function(e,t,r){if(!e.headers){return false}for(var i in e.headers){if(i.toLowerCase()===t.toLowerCase()&&e.headers[i]===r){return true}}return false};c.prototype._isValidRequest=function(e){if(!e){t.error("Request is not valid. Request object is missing.");return false}if(!e.url){t.error("Request is not valid. URL is missing.");return false}if(!e.options){t.error("Request is not valid. Options are missing.");return false}if(u.indexOf(e.options.mode)===-1){t.error("Request is not valid. Mode is not among "+u.toString());return false}if(f.indexOf(e.options.method)===-1){t.error("Request is not valid. Method is not among "+u.toString());return false}if(e.options.headers&&!(e.options.headers instanceof Headers)){t.error("Request is not valid. The headers option is not instance of Headers interface.");return false}if(typeof e.url!=="string"){return false}return true};c.prototype._deserializeBatchResponse=function(e,t){return new Promise(function(i,s){var n=this.getLastResponse().headers.get("Content-Type"),o=r.deserializeBatchResponse(n,t,false),a=Object.keys(e),u={};a.forEach(function(e,t){var r=o[t],i;if(!r){s("Batch responses do not match the batch requests.");return}i=new Response(r.responseText,r);if(!i.ok){s("One of batch requests fails with '"+i.status+" "+i.statusText+"'");return}u[e]=r.responseText?JSON.parse(r.responseText):{}});i(u)}.bind(this))};c.prototype._modifyRequestBeforeSent=function(e,t){var r=i.byId(this.getCard()),s=i.byId(this.getHost());if(!s){return e}if(s.modifyRequestHeaders){e.options.headers=new Headers(s.modifyRequestHeaders(Object.fromEntries(e.options.headers),t,r))}if(s.modifyRequest){e=s.modifyRequest(e,t,r)}return e};c.prototype.getDetails=function(){return"Backend interaction - load data from URL: "+this.getSettings().request.url};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/ServiceDataProvider", ["sap/ui/integration/util/DataProvider"],function(t){"use strict";var e=t.extend("sap.ui.integration.util.ServiceDataProvider",{metadata:{library:"sap.ui.integration",interfaces:["sap.ui.integration.util.IServiceDataProvider"]}});e.prototype.destroy=function(){this._oDataServicePromise=null;if(this._oServiceManager){this._oServiceManager=null}t.prototype.destroy.apply(this,arguments)};e.prototype.createServiceInstances=function(t){this._oServiceManager=t;if(!this.getSettings()||!this.getSettings().service){return}var e=this.getSettings().service;if(e&&typeof e==="object"){e=e.name}this._createServiceInstance(e)};e.prototype._createServiceInstance=function(t){var e=this.getSettings();this._oDataServicePromise=this._oServiceManager.getService(t).then(function(t){t.attachDataChanged(function(t){this.fireDataChanged({data:t.data})}.bind(this),e.service.parameters);return t}.bind(this))};e.prototype.getData=function(){var t=this.getSettings();var e=t.service;return new Promise(function(t,i){if(e&&this._oDataServicePromise){this._oDataServicePromise.then(function(e){e.getData().then(function(e){t(e)}).catch(function(){i("Card data service failed to get data.")})}).catch(function(){i("Card data service unavailable.")})}else{i("Could not get card data.")}}.bind(this))};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/ServiceManager", ["sap/ui/base/EventProvider","sap/base/Log"],function(e,r){"use strict";var t=e.extend("sap.ui.integration.util.ServiceManager",{constructor:function(r,t){if(!r){throw new Error("Missing manifest services reference!")}if(!t){throw new Error("Missing context object")}e.call(this);this._mServiceFactoryReferences=r;this._mServices={};this._oServiceContext=t;this._initAllServices()}});t.prototype._initAllServices=function(){for(var e in this._mServiceFactoryReferences){this._initService(e)}};t.prototype._initService=function(e){var i=this._mServices[e]||{};i.promise=t._getService(this._oServiceContext,e,this._mServiceFactoryReferences).then(function(e){i.instance=e}).catch(function(e){r.error(e.message)});this._mServices[e]=i};t.prototype.getService=function(e){var r="Invalid service";return new Promise(function(t,i){if(!e||!this._mServices[e]||!Object.keys(this._mServices[e])){i(r);return}this._mServices[e].promise.then(function(){if(this._mServices[e].instance){t(this._mServices[e].instance)}else{i(r)}}.bind(this)).catch(i)}.bind(this))};t.prototype.destroy=function(){this._mServices=null};t._getService=function(e,r,t){return new Promise(function(i,n){var c,s;if(e.bIsDestroyed){n(new Error("Service "+r+" could not be loaded as the requestor "+e.getMetadata().getName()+" was destroyed."));return}if(!t){n(new Error("No Services declared"));return}else{c=t[r]}if(!c||!c.factoryName){n(new Error("No Service '"+r+"' declared or factoryName missing"));return}else{s=c.factoryName}sap.ui.require(["sap/ui/core/service/ServiceFactoryRegistry"],function(t){var o=t.get(s);if(o){o.createInstance({scopeObject:e,scopeType:"component",settings:c.settings||{}}).then(function(e){if(e.getInterface){i(e.getInterface())}else{i(e)}}).catch(n)}else{var a=new Error("ServiceFactory '"+s+"' for Service '"+r+"' not found in ServiceFactoryRegistry");a._optional=c.optional;n(a)}})})};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/SkeletonCard", ["sap/ui/integration/library","sap/ui/integration/widgets/Card","sap/ui/integration/util/ManifestResolver"],function(t,e,i){"use strict";var r=t.CardDataMode;var n=e.extend("sap.ui.integration.util.SkeletonCard",{metadata:{library:"sap.ui.integration"}});n.prototype.init=function(){e.prototype.init.apply(this,arguments);this.setDataMode(r.Active)};n.prototype.resolveManifest=function(){return i.resolveCard(this)};n.prototype.isSkeleton=function(){return true};n.prototype.refresh=function(){e.prototype.refresh.apply(this);this.startManifestProcessing()};n.prototype._createCard=function(t){return new n(t)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/Utils", ["sap/ui/core/getCompatibilityVersion","sap/ui/core/Locale","sap/base/strings/formatMessage","sap/base/util/isPlainObject","sap/base/Log","sap/ui/core/date/UI5Date"],function(e,t,n,r,i,a){"use strict";var s={};s.isJson=function(e){if(typeof e!=="string"){return false}try{JSON.parse(e);return true}catch(e){return false}};s.processFormatArguments=function(e,n){var i=r(e)?e:{},a=typeof e==="string"?new t(e):n&&new t(n);return{formatOptions:i,locale:a}};s.parseJsonDateTime=function(e){var t=1,n=2,r=3;var s=/^\/Date\((-?\d+)(\+|-)?(\d+)?\)\/$/,o;if(typeof e==="string"){o=s.exec(e)}if(o){var u=a.getInstance(parseInt(o[t]));if(o[n]){var f=parseInt(o[r]);if(o[n]==="-"){f=-f}var l=u.getUTCMinutes();u.setUTCMinutes(l-f)}if(isNaN(u.valueOf())){i.error("Invalid JSON Date format - "+e)}else{e=u}}return e};s.DEFAULT_PROMISE_TIMEOUT=5e3;s.timeoutPromise=function(e,t){var n;if(t===undefined){t=s.DEFAULT_PROMISE_TIMEOUT}n=new Promise(function(e,n){setTimeout(function(){n("The promise was not resolved after "+t+" ms so it timed out.")},t)});return Promise.race([e,n])};s.hasFalsyValueAsString=function(e){return typeof e=="string"&&["null","false","undefined",""].indexOf(e.trim())>-1};s.setNestedPropertyValue=function(e,t,n){var r=t.substring(1).split("/"),i;for(var a=0;a<r.length-1;a++){i=r[a];e=e.hasOwnProperty(i)?e[i]:undefined;if(e===null||typeof e!=="object"){break}}e[r[r.length-1]]=n};s.getNestedPropertyValue=function(e,t){var n=t.substring(1).split("/"),r;for(var i=0;i<n.length;i++){r=n[i];e=e.hasOwnProperty(r)?e[r]:undefined;if(e===null||typeof e!=="object"){break}}return e};s.makeUndefinedValuesNull=function(e){if(Array.isArray(e)){return e.map(function(e){if(e===undefined){return null}if(typeof e==="object"){return s.makeUndefinedValuesNull(e)}return e})}for(var t in e){if(e.hasOwnProperty(t)){if(e[t]===undefined){e[t]=null}else if(typeof e[t]==="object"){e[t]=s.makeUndefinedValuesNull(e[t])}}}return e};s.isBindingSyntaxComplex=function(){if(s._isBindingSyntaxComplex===undefined){s._isBindingSyntaxComplex=e("sapCoreBindingSyntax").compareTo("1.26")>=0}return s._isBindingSyntaxComplex};s.generateUuidV4=function(){var e="xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(e){var t=Math.random()*16|0;if(e==="y"){t=t&3|8}return t.toString(16)});return e};s.getStatusTextBindingInfo=function(e){var t;if(e.parts&&e.translationKey&&e.parts.length===2){t={parts:[e.translationKey,e.parts[0].toString(),e.parts[1].toString()],formatter:function(t,r,i){var a=r||e.parts[0];var s=i||e.parts[1];if(Array.isArray(r)){a=r.length}if(Array.isArray(i)){s=i.length}var o=parseFloat(a)||0;var u=parseFloat(s)||0;return n(t,[o,u])}}}return t};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/Validators", [],function(){"use strict";var t={string:{maxLength:function(t,e){return t.length<=e},maxLengthTxt:"EDITOR_VAL_MAXLENGTH",minLength:function(t,e){return t.length>=e},minLengthTxt:"EDITOR_VAL_MINLENGTH",pattern:function(t,e){var i=new RegExp(e);return i.test(t)},patternTxt:"EDITOR_VAL_NOMATCH",required:function(t,e){return!e||!!t},requiredTxt:"EDITOR_VAL_TEXTREQ",validateTxt:"EDITOR_VAL_NOMATCH"},"string[]":{maxLength:function(t,e){return Array.isArray(t)&&t.length<=e},maxLengthTxt:"EDITOR_VAL_LISTMAXLENGTH",minLength:function(t,e){return Array.isArray(t)&&t.length>=e},minLengthTxt:"EDITOR_VAL_LISTMINLENGTH",required:function(t,e){return Array.isArray(t)&&t.length>0},requiredTxt:"EDITOR_VAL_LISTREQ"},integer:{maximum:function(t,e,i){if(i.exclusiveMaximum){i._txt="maximumExclusiveTxt";return t<e}return t<=e},maximumTxt:"EDITOR_VAL_MAX",maximumExclusiveTxt:"EDITOR_VAL_MAX_E",minimum:function(t,e,i){if(i.exclusiveMinimum){i._txt="minimumExclusiveTxt";return t>e}return t>=e},minimumTxt:"EDITOR_VAL_MIN",minimumExclusiveTxt:"EDITOR_VAL_MIN_E",multipleOf:function(t,e){return t%e===0},multipleOfTxt:"EDITOR_VAL_MULTIPLE",required:function(t,e){return!isNaN(t)&&t!==""},requiredTxt:"EDITOR_VAL_NUMBERREQ",validateTxt:"EDITOR_VAL_NOMATCH"},number:{maximum:function(t,e,i){if(i.exclusiveMaximum){i._txt="maximumExclusiveTxt";return t<e}return t<=e},maximumTxt:"EDITOR_VAL_MAX",maximumExclusiveTxt:"EDITOR_VAL_MAX_E",minimum:function(t,e,i){if(i.exclusiveMinimum){i._txt="minimumExclusiveTxt";return t>e}return t>=e},minimumTxt:"EDITOR_VAL_MIN",minimumExclusiveTxt:"EDITOR_VAL_MAX_E",multipleOf:function(t,e){return t%e===0},multipleOfTxt:"EDITOR_VAL_MULTIPLE",required:function(t,e){return!isNaN(t)&&t!==""},requiredTxt:"EDITOR_VAL_NUMBERREQ",validateTxt:"EDITOR_VAL_NOMATCH"},keyValuePair:{required:function(t,e){return!e||!!t.value},requiredTxt:"EDITOR_VAL_FIELDREQ",restrictToPredefinedOptions:function(t,e){return e&&!t.value&&!t.key||e&&!!t.key},restrictToPredefinedOptionsTxt:"EDITOR_ONLY_LISTED_VALUES_ALLOWED"},dateRange:{required:function(t,e){return!e||!!t.value},requiredTxt:"EDITOR_VAL_FIELDREQ"}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/loadCardEditor", ["sap/ui/dom/includeScript"],function(i){"use strict";function n(){return new Promise(function(i,n){sap.ui.require(["sap/ui/integration/designtime/cardEditor/BASEditor"],i,n)})}return function(){return i({url:"sap-ui-integration-cardEditor.js"}).then(n).catch(n)}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/widgets/Card", ["./CardRenderer","../cards/Footer","../controls/ActionsToolbar","../controls/BlockingMessage","sap/ui/base/Interface","sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/core/library","sap/ui/integration/util/Manifest","sap/ui/integration/util/ServiceManager","sap/base/Log","sap/base/util/merge","sap/base/util/deepEqual","sap/base/util/each","sap/ui/integration/util/DataProviderFactory","sap/ui/model/json/JSONModel","sap/ui/integration/model/ObservableModel","sap/ui/model/resource/ResourceModel","sap/ui/integration/model/ContextModel","sap/f/CardBase","sap/f/library","sap/ui/integration/library","sap/ui/integration/util/Destinations","sap/ui/integration/util/LoadingProvider","sap/ui/integration/util/HeaderFactory","sap/ui/integration/util/ContentFactory","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/ErrorHandler","sap/ui/integration/formatters/IconFormatter","sap/ui/integration/cards/filters/FilterBarFactory","sap/ui/integration/cards/actions/CardActions","sap/ui/integration/util/CardObserver","sap/m/IllustratedMessageType","sap/ui/integration/util/Utils","sap/ui/integration/util/ParameterMap","sap/ui/integration/util/Measurement"],function(t,e,i,a,r,jQuery,s,n,o,d,h,f,g,l,p,c,u,_,y,C,v,M,m,P,A,D,b,R,E,S,T,I,w,F,L,O){"use strict";var x={TYPE:"/sap.card/type",DATA:"/sap.card/data",HEADER:"/sap.card/header",HEADER_POSITION:"/sap.card/headerPosition",CONTENT:"/sap.card/content",FOOTER:"/sap.card/footer",SERVICES:"/sap.ui5/services",APP_TYPE:"/sap.app/type",PARAMS:"/sap.card/configuration/parameters",DESTINATIONS:"/sap.card/configuration/destinations",CSRF_TOKENS:"/sap.card/configuration/csrfTokens",FILTERS:"/sap.card/configuration/filters",NO_DATA_MESSAGES:"/sap.card/configuration/messages/noData",MODEL_SIZE_LIMIT:"/sap.card/configuration/modelSizeLimit"};var B=["visibleItems","allItems"];var N=v.cards.HeaderPosition;var H=M.CardArea;var k=M.CardDataMode;var V=M.CardDesign;var z=M.CardDisplayVariant;var U=M.CardPreviewMode;var W=M.CardBlockingMessageType;var q="Card is destroyed!";var j="module:";var J=n.MessageType;var G=1e3;var Y=C.extend("sap.ui.integration.widgets.Card",{metadata:{library:"sap.ui.integration",properties:{referenceId:{type:"string",defaultValue:""},manifest:{type:"any",defaultValue:""},parameters:{type:"object",defaultValue:null},dataMode:{type:"sap.ui.integration.CardDataMode",group:"Behavior",defaultValue:k.Auto},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},manifestChanges:{type:"object[]"},useMockData:{type:"boolean",defaultValue:false,visibility:"hidden"},design:{type:"sap.ui.integration.CardDesign",group:"Appearance",defaultValue:V.Solid},displayVariant:{type:"sap.ui.integration.CardDisplayVariant",group:"Appearance",defaultValue:z.Standard},previewMode:{type:"sap.ui.integration.CardPreviewMode",group:"Behavior",defaultValue:U.Off}},aggregations:{actionDefinitions:{type:"sap.ui.integration.ActionDefinition",multiple:true,forwarding:{getter:"_getActionsToolbar",aggregation:"actionDefinitions"}},_header:{type:"sap.f.cards.IHeader",multiple:false,visibility:"hidden"},_filterBar:{type:"sap.ui.integration.cards.filters.FilterBar",multiple:false,visibility:"hidden"},_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_footer:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_extension:{type:"sap.ui.integration.Extension",multiple:false,visibility:"hidden"},_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},events:{action:{allowPreventDefault:true,parameters:{actionSource:{type:"sap.ui.core.Control"},manifestParameters:{type:"object"},parameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}},configurationChange:{parameters:{changes:{type:"object"}}},manifestReady:{},manifestApplied:{},stateChanged:{}},associations:{host:{},openerReference:{visibility:"hidden"}}},renderer:t});Y.prototype.init=function(){C.prototype.init.call(this);this.setAggregation("_loadingProvider",new P);this._oIntegrationRb=s.getLibraryResourceBundle("sap.ui.integration");this._iModelSizeLimit=G;this._initModels();this._oContentFactory=new D(this);this._oCardObserver=new I(this);this._aSevereErrors=[];this._sPerformanceId="UI5 Integration Cards "+this.getId()+" ";this._aActiveLoadingProviders=[];this._fnOnDataReady=function(){this._bDataReady=true}.bind(this);this._fireStateChangedBound=this._fireStateChanged.bind(this);this._oLimitedInterface=new r(this,["getDomRef","setVisible","getParameters","getCombinedParameters","getManifestEntry","resolveDestination","request","refresh","refreshData","showMessage","getBaseUrl","getRuntimeUrl","getTranslatedText","getModel","triggerAction","addActionDefinition","removeActionDefinition","insertActionDefinition","getActionDefinition","indexOfActionDefinition","destroyActionDefinition","showLoadingPlaceholders","hideLoadingPlaceholders","showCard","hide","getOpener","validateControls","showBlockingMessage","hideBlockingMessage","getBlockingMessage"])};Y.prototype._initModels=function(){this._INTERNAL_MODELS={default:{init:()=>this.setModel(new c),reset:()=>this.getModel().setData({})},parameters:{init:()=>this.setModel(new c(L.getParamsForModel()),"parameters")},filters:{init:()=>this.setModel(new c,"filters"),reset:()=>this.getModel("filters").setData({})},paginator:{init:()=>this.setModel(new c({skip:0}),"paginator"),reset:()=>this.getModel("paginator").setData({skip:0})},form:{init:()=>this.setModel(new c,"form")},messages:{init:()=>this.setModel(new c({hasErrors:false,hasWarnings:false,records:[]}),"messages")},context:{init:()=>this.setModel(new y,"context")},i18n:{init:()=>this.setModel(new _({bundle:this._oIntegrationRb}),"i18n")}};for(const t in this._INTERNAL_MODELS){this._INTERNAL_MODELS[t].init()}};Y.prototype.clone=function(){var t=C.prototype.clone.apply(this,arguments);t._initModels();return t};Y.prototype._initReadyState=function(){this._aReadyPromises=[];this._awaitEvent("_dataReady");this._awaitEvent("_dataPassedToContent");this._awaitEvent("_headerReady");this._awaitEvent("_filterBarReady");this._awaitEvent("_contentReady");Promise.all(this._aReadyPromises).then(function(){this._onReady()}.bind(this));this.attachEventOnce("_dataReady",this._fnOnDataReady)};Y.prototype._clearReadyState=function(){this._bReady=false;this._bDataReady=false;this._aReadyPromises=[];this.detachEvent("_dataReady",this._fnOnDataReady)};Y.prototype.onBeforeRendering=function(){var t=this.getCardContent();if(t&&t.isA("sap.ui.integration.cards.BaseContent")){t.setDesign(this.getDesign())}if(this.getDataMode()!==k.Active){return}this.startManifestProcessing()};Y.prototype.onAfterRendering=function(){if(this._isManifestReady){if(!O.hasEnded(this._sPerformanceId+"firstRenderingWithStaticData")){O.end(this._sPerformanceId+"firstRenderingWithStaticData")}if(this._bDataReady&&!O.hasEnded(this._sPerformanceId+"firstRenderingWithDynamicData")){O.end(this._sPerformanceId+"firstRenderingWithDynamicData")}}var t=this.getDomRef();if(this.getDataMode()===k.Auto){this._oCardObserver.observe(t)}else{this._oCardObserver.unobserve(t)}};Y.prototype.startManifestProcessing=function(){if(!F.isBindingSyntaxComplex()){this._logSevereError("Cannot parse manifest. Complex binding syntax is not enabled - "+"To enable it, set the 'compatVersion' configuration option to 'edge', e.g.: data-sap-ui-compatVersion='edge' - "+"sap.ui.integration.widgets.Card")}if(this._bApplyManifest||this._bApplyParameters){this._clearReadyState();this._initReadyState()}var t=this.getManifest();if(t&&this._bApplyManifest){this._cleanupOldManifest();this.createManifest(t,this.getBaseUrl())}if(!this._bApplyManifest&&this._bApplyParameters){this._oCardManifest.processParameters(this._getContextAndRuntimeParams());this._applyManifestSettings()}this._bApplyManifest=false;this._bApplyParameters=false;this._refreshActionsMenu()};Y.prototype.setManifest=function(t){if(!g(this.getProperty("manifest"),t)){this.destroyActionDefinitions()}if(!t){this._destroyManifest()}this._bApplyManifest=true;this.setProperty("manifest",t);return this};Y.prototype.setManifestChanges=function(t){this.setProperty("manifestChanges",t);this._bApplyManifest=true;return this};Y.prototype.setParameters=function(t){this.setProperty("parameters",t);this._bApplyParameters=true;return this};Y.prototype.setParameter=function(t,e){var i=this.getParameters()||{};i[t]=e;this.setParameters(i);return this};Y.prototype.setHost=function(t){this.setAssociation("host",t);var e=this.getHostInstance();if(t&&!e){h.error("Host with id '"+t+"' is not available during card initialization. It must be available for host specific features to work.","Make sure that the host already exists, before assigning it to the card.","sap.ui.integration.widgets.Card");return this}this.getModel("context").setHost(e);if(this._oDestinations){this._oDestinations.setHost(e)}if(this._oDataProviderFactory){this._oDataProviderFactory.setHost(e)}if(e&&e.bUseExperimentalCaching){this.addStyleClass("sapFCardExperimentalCaching")}else{this.removeStyleClass("sapFCardExperimentalCaching")}return this};Y.prototype.createManifest=function(t,e){var i={};this._isManifestReady=false;if(typeof t==="string"){i.manifestUrl=t;t=null}if(this._oCardManifest){this._oCardManifest.destroy()}O.start(this._sPerformanceId+"initManifest","Load and initialize manifest.");O.start(this._sPerformanceId+"firstRenderingWithStaticData","First rendering with static data (includes initManifest).");O.start(this._sPerformanceId+"firstRenderingWithDynamicData","First rendering with dynamic card level data (includes firstRenderingWithStaticData).");this._oCardManifest=new o("sap.card",t,e,this.getManifestChanges());this._oCardManifest.load(i).then(function(){if(this.isDestroyed()){throw new Error(q)}if(!this._oCardManifest.get("/sap.app/id")){this._logSevereError("Card sap.app/id entry in the manifest is mandatory")}return this._oCardManifest.loadDependenciesAndIncludes()}.bind(this)).then(function(){if(this.isDestroyed()){throw new Error(q)}O.end(this._sPerformanceId+"initManifest");this._isManifestReady=true;this.fireManifestReady();return this._loadExtension()}.bind(this)).then(this._applyManifest.bind(this)).catch(function(t){if(t.message===q){return}this._logSevereError(t.message);this._applyManifest()}.bind(this))};Y.prototype._loadExtension=function(){var t=this._oCardManifest.get("/sap.card/extension"),e;if(!t){return null}if(t.startsWith(j)){e=t.replace(j,"")}else{e=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+t}return new Promise(function(t,i){sap.ui.require([e],function(e){var i=new e;i._setCard(this,this._oLimitedInterface);this.setAggregation("_extension",i);t()}.bind(this),function(t){this._logSevereError("Failed to load "+e+". Check if the path is correct. Reason: "+t);i(t)}.bind(this))}.bind(this))};Y.prototype._logSevereError=function(t){h.error(t);this._aSevereErrors.push(t)};Y.prototype.getSevereErrors=function(){return this._aSevereErrors};Y.prototype.validateControls=function(){this._validateContentControls(true);return!this.getModel("messages").getProperty("/hasErrors")};Y.prototype.getModelSizeLimit=function(){return this._iModelSizeLimit};Y.prototype._validateContentControls=function(t,e){var i=this.getCardContent();if(i&&i.isA("sap.ui.integration.cards.BaseContent")){i.validateControls(t,e)}};Y.prototype._applyManifest=function(){var t=this._oCardManifest;if(!t.get("/sap.card")){this._logSevereError("There must be a 'sap.card' section in the manifest.")}if(t&&t.getResourceBundle()){this._enhanceI18nModel(t.getResourceBundle())}this.getModel("context").resetHostProperties();if(this._hasContextParams()){this._resolveContextParams().then(function(t){this._oContextParameters=t;this._applyManifestWithParams()}.bind(this));return}this._applyManifestWithParams()};Y.prototype._applyManifestWithParams=function(){var t=this._oCardManifest,e=this._getContextAndRuntimeParams();t.processParameters(e);this._prepareToApplyManifestSettings().then(function(){this._applyManifestSettings()}.bind(this))};Y.prototype._enhanceI18nModel=function(t){var e=this.getModel("i18n"),i;i=new _({bundle:t,enhanceWith:[this._oIntegrationRb]});this.setModel(i,"i18n");e.destroy()};Y.prototype._hasContextParams=function(){var t=this._oCardManifest.get(x.PARAMS),e,i;for(e in t){i=t[e].value;if(typeof i==="string"&&i.indexOf("{context>")!==-1){return true}}return false};Y.prototype._resolveContextParams=function(){var t=this.getModel("context"),e=this._oCardManifest.get(x.PARAMS),i={},a,r;for(a in e){r=e[a].value;if(typeof r==="string"&&r.indexOf("{context>")!==-1){i[a]=r}}b.resolveValue(i,this,"/");return t.waitForPendingProperties().then(function(){return b.resolveValue(i,this,"/")}.bind(this))};Y.prototype._getContextAndRuntimeParams=function(){var t=this._oContextParameters||{},e=this.getParameters()||{};return f(t,e)};Y.prototype._awaitEvent=function(t){this._aReadyPromises.push(new Promise(function(e){this.attachEventOnce(t,function(){e()})}.bind(this)))};Y.prototype.isReady=function(){return this._bReady};Y.prototype.refresh=function(){if(this.getDataMode()===k.Active){this._bApplyManifest=true;this.invalidate()}};Y.prototype.setFilterValue=function(t,e){var i=this._oCardManifest.get(x.FILTERS);if(!i.hasOwnProperty(t)){h.error("Filter with key '"+t+"' does not exist in the manifest section 'filters'.","sap.ui.integration.widgets.Card");return}var a=this.getAggregation("_filterBar");if(!a){return}var r=a._getFilters().find(function(e){return e.getKey()===t});r.setValueFromOutside(e)};Y.prototype.setFormValues=function(t){var e=this.getCardContent();if(e&&!e.isA("sap.ui.integration.cards.ObjectContent")){h.error("Setting form element values is available only on an Object card","sap.ui.integration.widgets.Card");return}t.forEach(function(t){e.setFormFieldValue(t)})};Y.prototype.refreshData=function(){if(!this.isReady()){return}this.refreshAllData();this.resetPaginator()};Y.prototype.refreshAllData=function(){var t=this.getCardHeader(),e=this.getCardContent(),i=this.getAggregation("_filterBar");if(this._oDataProvider){this._oDataProvider.triggerDataUpdate()}if(t){t.refreshData()}if(e&&e.isA("sap.ui.integration.cards.BaseContent")){e.refreshData()}else{this._applyContentManifestSettings()}if(i){i.refreshData()}};Y.prototype._refreshActionsMenu=function(){var t=this.getCardHeader(),e=this.getHostInstance(),i=this.getAggregation("_extension"),a=[];if(!t){return}if(e){a=a.concat(e.getActions()||[])}if(i){a=a.concat(i.getActions()||[])}if(g(a,this._getActionsToolbar()._aActions)){return}this._getActionsToolbar().initializeContent(this)};Y.prototype.exit=function(){C.prototype.exit.call(this);this._destroyManifest();this._oCardObserver.destroy();this._oCardObserver=null;this._oContentFactory=null;this._oIntegrationRb=null;this._aActiveLoadingProviders=null;this._oContentMessage=null;this._oMessage=null;clearTimeout(this._iFireStateChangedCallId);if(this._oActionsToolbar){this._oActionsToolbar.destroy();this._oActionsToolbar=null}};Y.prototype._destroyManifest=function(){if(this._oCardManifest){this._oCardManifest.destroy();this._oCardManifest=null}if(this._oServiceManager){this._oServiceManager.destroy();this._oServiceManager=null}if(this._oDestinations){this._oDestinations.destroy();this._oDestinations=null}if(this._oIconFormatter){this._oIconFormatter.destroy();this._oIconFormatter=null}if(this._oActionsToolbar){this._oActionsToolbar.destroy();this._oActionsToolbar=null}this.destroyAggregation("_header");this.destroyAggregation("_content");this.destroyAggregation("_filterBar");this.destroyAggregation("_footer");this._cleanupOldManifest()};Y.prototype._cleanupOldManifest=function(){this._aReadyPromises=null;if(this._fnOnModelChange){this.getModel().detachEvent("change",this._fnOnModelChange,this);delete this._fnOnModelChange}for(const t in this._INTERNAL_MODELS){if(this._INTERNAL_MODELS[t].reset){this._INTERNAL_MODELS[t].reset()}}this._oContextParameters=null;this._deregisterCustomModels();this.destroyAggregation("_extension");if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;this._oDataProvider=null}this._setLoadingProviderState(false)};Y.prototype.getManifest=function(){var t=this.getProperty("manifest");if(t&&typeof t==="object"){return jQuery.extend(true,{},t)}return t};Y.prototype.getParameters=function(){var t=this.getProperty("parameters");if(t&&typeof t==="object"){return jQuery.extend(true,{},t)}return t};Y.prototype.getCombinedParameters=function(){if(!this._isManifestReady){h.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null}var t=this._oCardManifest.getProcessedParameters(this._getContextAndRuntimeParams()),e={},i;for(i in t){e[i]=t[i].value}return e};Y.prototype.getManifestEntry=function(t){if(!this._isManifestReady){h.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null}return this._oCardManifest.get(t)};Y.prototype.getManifestRawJson=function(){if(!this._oCardManifest||!this._oCardManifest){h.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return{}}return this._oCardManifest.getInitialJson()};Y.prototype.getManifestWithMergedChanges=function(){if(!this._oCardManifest||!this._oCardManifest._oManifest){h.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return{}}return jQuery.extend(true,{},this._oCardManifest._oManifest.getRawJson())};Y.prototype.extendStaticConfiguration=function(t){if(this._oMessage){t.messageStrip=b.resolveValue(this._oMessage,this)}};Y.prototype.resolveDestination=function(t){return this._oDestinations.getUrl(t)};Y.prototype.processDestinations=function(t){return this._oDestinations.process(t)};Y.prototype.showMessage=function(t,e){var i=this.getCardContent();if(i&&i.isA("sap.ui.integration.cards.BaseContent")){i.showMessage(t,e);this._oMessage={text:t,type:e};this.scheduleFireStateChanged()}else{h.error("'showMessage' cannot be used before the card instance is ready. Consider using the event 'manifestApplied' event.","sap.ui.integration.widgets.Card")}};Y.prototype.hideMessage=function(){var t=this.getCardContent();if(t&&t.isA("sap.ui.integration.cards.BaseContent")){t.hideMessage();this._oMessage=null;this.scheduleFireStateChanged()}else{h.error("'showMessage' cannot be used before the card instance is ready. Consider using the event 'manifestApplied' event.","sap.ui.integration.widgets.Card")}};Y.prototype.showBlockingMessage=function(t){var e=this.getCardContent();if(e){e.showBlockingMessage(t);this.scheduleFireStateChanged()}};Y.prototype.getBlockingMessage=function(){var t=this.getCardContent();if(t&&t.isA("sap.ui.integration.cards.BaseContent")){return t.getBlockingMessage()}else if(t&&t.isA("sap.ui.integration.controls.BlockingMessage")){return{type:t.getType(),illustrationType:t.getIllustrationType(),illustrationSize:t.getIllustrationSize(),title:t.getTitle(),description:t.getDescription()}}return null};Y.prototype.hideBlockingMessage=function(){var t=this.getCardContent();if(t){t.hideBlockingMessage()}};Y.prototype.getTranslatedText=function(t,e,i){var a=this.getModel("i18n"),r;if(!a){h.warning("There are no translations available. Either the i18n configuration is missing or the method is called too early.");return null}r=a.getResourceBundle();return r.getText(t,e,i)};Y.prototype.getDataProviderFactory=function(){if(!this._oDataProviderFactory){h.error("The DataProviderFactory instance is not ready yet. Consider using the event 'manifestApplied'.","sap.ui.integration.widgets.Card");return null}return this._oDataProviderFactory};Y.prototype.getRuntimeUrl=function(t){var e=this._oCardManifest?this._oCardManifest.get("/sap.app/id"):null,i,a=t&&t.trim().replace(/^\//,"");if(e===null){h.error("The manifest is not ready so the URL can not be resolved. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null}if(!e||t.startsWith("http://")||t.startsWith("https://")||t.startsWith("//")){return t}i=e.replace(/\./g,"/");return sap.ui.require.toUrl(i)+"/"+a};Y.prototype._prepareToApplyManifestSettings=function(){var t=this._oCardManifest.get(x.APP_TYPE),e=this.getAggregation("_extension");if(t&&t!=="card"){h.error("sap.app/type entry in manifest is not 'card'")}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy()}this._oDestinations=new m({host:this.getHostInstance(),card:this,manifestConfig:this._oCardManifest.get(x.DESTINATIONS)});this._oIconFormatter=new E({card:this});return this.processDestinations(this._oCardManifest.getJson()).then(function(t){this._oCardManifest.setJson(t);this._oDataProviderFactory=new p({host:this.getHostInstance(),extension:e,csrfTokensConfig:this._oCardManifest.get(x.CSRF_TOKENS),card:this});this._registerCustomModels();if(e){e.onCardReady()}}.bind(this))};Y.prototype._applyManifestSettings=function(){this._setParametersModelData();this._checkMockPreviewMode();this._applyModelSizeLimit();this._applyServiceManifestSettings();this._applyFilterBarManifestSettings();this._applyDataManifestSettings();this._applyHeaderManifestSettings();this._applyContentManifestSettings();this._applyFooterManifestSettings();this.fireManifestApplied()};Y.prototype._setParametersModelData=function(){var t=L.getParamsForModel(),e={},i=this.getCombinedParameters(),a;for(a in i){if(B.indexOf(a)>=0){h.warning("The parameter name '"+a+"' is reserved for cards. Can not be used for creating custom parameter.")}else{e[a]={value:i[a]}}}this.getModel("parameters").setData(f(t,e))};Y.prototype._applyDataManifestSettings=function(){var t=this._oCardManifest.get(x.DATA),e;if(!t){this.fireEvent("_dataReady");this.fireEvent("_dataPassedToContent");return}this.bindObject(b.resolveValue(t.path||"/",this));if(this._oDataProvider){this._oDataProvider.destroy()}this._oDataProvider=this._oDataProviderFactory.create(t,this._oServiceManager);if(t.name){e=this.getModel(t.name)}else if(this._oDataProvider){e=new u;e.setSizeLimit(this.getModelSizeLimit());this.setModel(e)}if(!e){this.fireEvent("_dataReady");this.fireEvent("_dataPassedToContent");return}this._fnOnModelChange=function(){var t=this.getCardContent();if(t&&t.isA("sap.ui.integration.cards.BaseContent")){t.onCardDataChanged()}this.fireEvent("_dataPassedToContent");this.onDataRequestComplete()};e.attachEvent("change",this._fnOnModelChange,this);if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this._setLoadingProviderState(true)}.bind(this));this._oDataProvider.attachDataChanged(function(t){this.fireEvent("_dataReady");e.setData(t.getParameter("data"))}.bind(this));this._oDataProvider.attachError(function(t){this.fireEvent("_dataReady");this.fireEvent("_dataPassedToContent");this._handleError({requestErrorParams:t.getParameters(),requestSettings:this._oDataProvider.getSettings()});this.onDataRequestComplete()}.bind(this));this._oDataProvider.triggerDataUpdate()}else{this.fireEvent("_dataReady");this.fireEvent("_dataPassedToContent")}};Y.prototype._applyServiceManifestSettings=function(){var t=this._oCardManifest.get(x.SERVICES);if(!t){return}if(!this._oServiceManager){this._oServiceManager=new d(t,this)}};Y.prototype._applyModelSizeLimit=function(){var t=this._oCardManifest.get(x.MODEL_SIZE_LIMIT);this._iModelSizeLimit=t!==undefined?t:G};Y.prototype.getCardHeader=function(){return this.getAggregation("_header")};Y.prototype.getCardHeaderPosition=function(){if(!this._oCardManifest){return"Top"}return this._oCardManifest.get(x.HEADER_POSITION)||N.Top};Y.prototype.getCardContent=function(){return this.getAggregation("_content")};Y.prototype.getCardFooter=function(){return this.getAggregation("_footer")};Y.prototype._getActionsToolbar=function(){if(!this._oActionsToolbar){this._oActionsToolbar=new i;this._oActionsToolbar.setCard(this);this._oActionsToolbar.setEnabled(false)}return this._oActionsToolbar};Y.prototype._applyHeaderManifestSettings=function(){var t=this.getAggregation("_header");if(t){t.setToolbar(null);this.destroyAggregation("_header")}var e=this.createHeader();if(!e){this.fireEvent("_headerReady");return}e.attachEvent("_error",function(t){this._handleError(t.getParameter("errorInfo"))}.bind(this));this.setAggregation("_header",e);if(e.isReady()){this.fireEvent("_headerReady")}else{e.attachEvent("_ready",function(){this.fireEvent("_headerReady")}.bind(this))}};Y.prototype._applyFilterBarManifestSettings=function(){var t=this.createFilterBar();this.destroyAggregation("_filterBar");if(!t){this.fireEvent("_filterBarReady");return}t.attachEventOnce("_filterBarDataReady",function(){this.fireEvent("_filterBarReady")}.bind(this));this.setAggregation("_filterBar",t)};Y.prototype._applyFooterManifestSettings=function(){var t=this.createFooter();this.destroyAggregation("_footer");if(t){this.setAggregation("_footer",t)}this.fireEvent("_footerReady")};Y.prototype.getHostInstance=function(){var t=this.getHost();if(!t){return null}return s.byId(t)};Y.prototype._applyContentManifestSettings=function(){var t=this._oCardManifest.get(x.TYPE),e=this.getContentManifest(),i=t+" "+this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD"),a;this.destroyAggregation("_content");this._ariaText.setText(i);if(!e||this.isTileDisplayVariant()){this.fireEvent("_contentReady");return}try{a=this.createContent({cardType:t,contentManifest:e,serviceManager:this._oServiceManager,dataProviderFactory:this._oDataProviderFactory,iconFormatter:this._oIconFormatter,noDataConfiguration:this._oCardManifest.get(x.NO_DATA_MESSAGES)})}catch(t){this._handleError({illustrationType:w.ErrorScreen,title:this.getTranslatedText("CARD_ERROR_CONFIGURATION_TITLE"),description:this.getTranslatedText("CARD_ERROR_CONFIGURATION_DESCRIPTION"),details:t.message});return}this._setCardContent(a)};Y.prototype.isTileDisplayVariant=function(){const t=[z.TileStandard,z.TileStandardWide,z.TileFlat,z.TileFlatWide];return t.indexOf(this.getDisplayVariant())>-1};Y.prototype.createHeader=function(){var t=this._oCardManifest.get(x.HEADER),e=new A(this);return e.create(t,this._getActionsToolbar())};Y.prototype.createFilterBar=function(){var t=this._oCardManifest.get(x.FILTERS),e=new S(this);return e.create(t,this.getModel("filters"))};Y.prototype.createFooter=function(){var t=this._oCardManifest.get(x.FOOTER);if(!t){return null}return e.create(this,t)};Y.prototype.getContentManifest=function(){var t=this._oCardManifest.get(x.TYPE),e=t&&t.toLowerCase()==="component",i=this._oCardManifest.get(x.CONTENT),a=!!i;if(a&&!t){this._logSevereError("Card type property is mandatory!");return null}if(!a&&!e){return null}if(e){i=f(i,{componentManifest:this._oCardManifest.getJson()})}return i};Y.prototype.createContent=function(t){t.cardManifest=this._oCardManifest;return this._oContentFactory.create(t)};Y.prototype._setCardContent=function(t){t.attachEvent("_error",function(t){this._handleError(t.getParameter("errorInfo"))}.bind(this));this.setAggregation("_content",t);if(t.isReady()){this.fireEvent("_contentReady")}else{t.attachReady(function(){this.fireEvent("_contentReady")}.bind(this))}};Y.prototype._handleError=function(t){var e=t.requestErrorParams?t.requestErrorParams.message:t.description,i=this._oCardManifest.get(x.CONTENT),r=this._oCardManifest.get(x.TYPE)==="Component",s=this.getCardContent(),n;h.error(e,null,"sap.ui.integration.widgets.Card");this.fireEvent("_error",{message:e});if(t.requestErrorParams){n=R.configureDataRequestErrorInfo(t,this)}else{n=R.configureErrorInfo(t,this)}if(!this.isTileDisplayVariant()&&(i||r)){if(s&&s.isA("sap.ui.integration.cards.BaseContent")){this.showBlockingMessage(n)}else{this.destroyAggregation("_content");this.setAggregation("_content",a.create(n,this));this.fireEvent("_contentReady")}}else{this.getCardHeader().setAggregation("_error",a.create(n,this))}};Y.prototype.getContentMessage=function(){return this._oContentMessage};Y.prototype.setDataMode=function(t){if(this._oDataProviderFactory&&t===k.Inactive){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null}this.setProperty("dataMode",t);if(this.getProperty("dataMode")===k.Active){this.refresh()}return this};Y.prototype.loadDesigntime=function(){if(this._oDesigntime){return Promise.resolve(this._oDesigntime)}if(!this._oCardManifest){return new Promise(function(t,e){this.attachManifestReady(function(){this.loadDesigntime().then(t,e)}.bind(this))}.bind(this))}var t=this._oCardManifest.get("/sap.app/id");if(!t){return Promise.reject("App id not maintained")}return new Promise(function(t,e){var i=this._oCardManifest.get("/sap.card/configuration/editor");if(i===undefined){i=this._oCardManifest.get("/sap.card/designtime")}var a=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+i;if(a){sap.ui.require([a],function(e){e=new e;e._readyPromise(this._oLimitedInterface,this).then(function(){this._oDesigntime=e;t(e)}.bind(this))}.bind(this),function(){e({error:a+" not found"})})}else{e()}}.bind(this))};Y.prototype.showLoadingPlaceholders=function(t){var e;switch(t){case H.Header:e=this.getCardHeader();if(e){e.showLoadingPlaceholders()}break;case H.Filters:e=this.getAggregation("_filterBar");if(e){e.showLoadingPlaceholders()}break;case H.Content:e=this.getCardContent();if(e&&e.isA("sap.ui.integration.cards.BaseContent")){e.showLoadingPlaceholders()}break;default:this.showLoadingPlaceholders(H.Header);this.showLoadingPlaceholders(H.Filters);this.showLoadingPlaceholders(H.Content);this._setLoadingProviderState(true)}return this};Y.prototype.hideLoadingPlaceholders=function(t){var e;switch(t){case H.Header:e=this.getCardHeader();if(e){e.hideLoadingPlaceholders()}break;case H.Filters:e=this.getAggregation("_filterBar");if(e){e.hideLoadingPlaceholders()}break;case H.Content:e=this.getCardContent();if(e&&e.isA("sap.ui.integration.cards.BaseContent")){e.hideLoadingPlaceholders()}break;default:this.hideLoadingPlaceholders(H.Header);this.hideLoadingPlaceholders(H.Filters);this.hideLoadingPlaceholders(H.Content);this._setLoadingProviderState(false)}return this};Y.prototype.isLoading=function(){return this.getAggregation("_loadingProvider").getLoading()};Y.prototype.getFocusDomRef=function(){var t=this.getCardHeader();if(t&&t.getFocusDomRef()){return t.getFocusDomRef()}return this.getDomRef()};Y.prototype.onDataRequestComplete=function(){var t=this.getCardContent();this.hideLoadingPlaceholders(H.Header);this.hideLoadingPlaceholders(H.Filters);if(t&&t.isA("sap.ui.integration.cards.BaseContent")&&t.isReady()){this.hideLoadingPlaceholders(H.Content)}this._setLoadingProviderState(false);this._fireContentDataChange()};Y.prototype.request=function(t){return this.processDestinations(t).then(function(t){return this._oDataProviderFactory.create({request:t}).setAllowCustomDataType(true).getData()}.bind(this))};Y.prototype.triggerAction=function(t){T.fireAction({card:this,host:this.getHostInstance(),action:t,parameters:t.parameters,source:this})};Y.prototype.hasNoData=function(){return this.getBlockingMessage()&&this.getBlockingMessage().type===W.NoData};Y.prototype.showNoData=function(t){this.showBlockingMessage({type:W.NoData,illustrationType:t.type,illustrationSize:t.size,title:t.title,description:t.description})};Y.prototype._setPreviewMode=function(t){if(t){this.setPreviewMode(U.Abstract)}else{this.setPreviewMode(U.Off)}};Y.prototype.setPreviewMode=function(t){var e=this.getPreviewMode();this.setProperty("previewMode",t);if(e!==this.getPreviewMode()){this._bApplyManifest=true}return this};Y.prototype.getBindingNamespaces=function(){var t={},e=this.getAggregation("_extension");if(e){t.extension={formatters:e.getFormatters()}}return t};Y.prototype._registerCustomModels=function(){var t=this._oCardManifest.findDataSections();if(!this._aCustomModels){this._aCustomModels=[]}this._deregisterCustomModels();t.forEach(function(t){var e=t&&t.name;if(!e){return}if(this._INTERNAL_MODELS[e]){h.error("The model name (data section name) '"+e+"' is reserved for cards. Can not be used for creating a custom model.");return}if(this._aCustomModels.indexOf(e)>-1){h.error("The model name (data section name) '"+e+"' is already used.");return}var i=new u;i.setSizeLimit(this.getModelSizeLimit());this.setModel(i,e);this._aCustomModels.push(e)}.bind(this))};Y.prototype._deregisterCustomModels=function(){if(!this._aCustomModels){return}this._aCustomModels.forEach(function(t){this.getModel(t).destroy();this.setModel(null,t)}.bind(this));this._aCustomModels=[]};Y.prototype._fireConfigurationChange=function(t){var e=this.getHostInstance();if(!this.isReady()){return}this.fireConfigurationChange({changes:t});if(e){e.fireCardConfigurationChange({card:this,changes:t})}};Y.prototype.scheduleFireStateChanged=function(){if(this._iFireStateChangedCallId){clearTimeout(this._iFireStateChangedCallId)}this._iFireStateChangedCallId=setTimeout(this._fireStateChangedBound,0)};Y.prototype._fireStateChanged=function(){var t=this.getHostInstance();if(!this.isReady()){return}this.fireStateChanged();if(t){t.fireCardStateChanged({card:this})}};Y.prototype._fireInitialized=function(){if(this._bInitializedFired){return}var t=this.getHostInstance();this.fireEvent("_initialized");this._bInitializedFired=true;if(t){t.fireCardInitialized({card:this})}};Y.prototype._fireDataChange=function(){this.fireEvent("_dataChange");this.scheduleFireStateChanged()};Y.prototype._fireContentDataChange=function(){this.fireEvent("_contentDataChange");this._fireDataChange()};Y.prototype._onReady=function(){this._bReady=true;this._setActionButtonsEnabled(true);this._validateContentControls(false,true);this.fireEvent("_ready");this._fireInitialized();this.scheduleFireStateChanged()};Y.prototype._setLoadingProviderState=function(t){var e=this.getAggregation("_loadingProvider");if(this._isDataProviderJson()){return}e.setLoading(t);if(t){this.addActiveLoadingProvider(e)}else{this.removeActiveLoadingProvider(e)}};Y.prototype.addActiveLoadingProvider=function(t){if(!this.isReady()){return}if(!this.hasActiveLoadingProvider()){this._setActionButtonsEnabled(false)}if(this._aActiveLoadingProviders.indexOf(t)===-1){this._aActiveLoadingProviders.push(t)}};Y.prototype.removeActiveLoadingProvider=function(t){if(!this.isReady()){return}var e=this._aActiveLoadingProviders,i=e.indexOf(t);e.splice(i,1);if(!this.hasActiveLoadingProvider()){this._setActionButtonsEnabled(true)}};Y.prototype._setActionButtonsEnabled=function(t){var e=this.getAggregation("_footer");if(e){e.setEnabled(t)}if(this._oActionsToolbar){this._oActionsToolbar.setEnabled(t)}};Y.prototype.hasActiveLoadingProvider=function(){return this._aActiveLoadingProviders.length>0};Y.prototype.isSkeleton=function(){return false};Y.prototype.getContentPageSize=function(t){var e,i,a=this.getCardFooter();if(a&&a.getPaginator()){return a.getPaginator().getPageSize()}e=b.resolveValue(t.maxItems,this);if(e==null){return null}i=parseInt(e);if(isNaN(i)){h.error("Value for maxItems must be integer.");return null}return i};Y.prototype.getContentMinItems=function(t){var e=b.resolveValue(t.minItems,this),i;if(e==null){return this.getContentPageSize(t)}i=parseInt(e);if(isNaN(i)){h.error("Value for minItems must be integer.");return null}return i};Y.prototype.hasPaginator=function(){var t=this._oCardManifest.get(x.FOOTER);return t&&t.paginator};Y.prototype.resetPaginator=function(){if(this.hasPaginator()){this.getCardFooter().getPaginator().reset()}};Y.prototype.showCard=function(t){var e=this._createChildCard(t);t._cardId=e.getId();this.triggerAction({type:"ShowCard",parameters:t});return Promise.resolve(e)};Y.prototype.hide=function(){this.triggerAction({type:"HideCard"})};Y.prototype.getOpener=function(){var t=s.byId(this.getAssociation("openerReference"));if(!t){return null}return t._oLimitedInterface};Y.prototype._createChildCard=function(t){var e=t.manifest,i=t.baseUrl,a=t.data,r=this._createCard({width:t.width,host:this.getHostInstance(),parameters:t.parameters,referenceId:this.getReferenceId()});r.setAssociation("openerReference",this);if(a){l(a,function(t,e){var i=new c(e);i.setSizeLimit(this.getModelSizeLimit());r.setModel(i,t)}.bind(this))}if(typeof e==="string"){r.setManifest(this.getRuntimeUrl(e));if(i){r.setBaseUrl(i)}}else{r.setManifest(e);r.setBaseUrl(i||this.getRuntimeUrl("/"))}return r};Y.prototype._createCard=function(t){return new Y(t)};Y.prototype._isDataProviderJson=function(){return this._oDataProvider&&this._oDataProvider.getSettings()&&this._oDataProvider.getSettings()["json"]};Y.prototype._checkMockPreviewMode=function(){if(this.getPreviewMode()!==U.MockData){return}var t=this._oCardManifest.findDataSections(),e;e=t.some(function(t){if(!p.isProvidingConfiguration(t)){return false}return!(t.mockData&&p.isProvidingConfiguration(t.mockData))});if(e){h.warning("'mockData' configuration is missing, but the card 'previewMode' is 'MockData'. Abstract mode will be used instead.",this);this.setProperty("previewMode",U.Abstract);this.attachEventOnce("manifestApplied",function(){this.showMessage(this._oIntegrationRb.getText("CARD_MISSING_PREVIEW_CONFIGURATION"),J.Information)}.bind(this))}};return Y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/widgets/CardRenderer", ["sap/f/CardRenderer","sap/ui/integration/library"],function(e,r){"use strict";var t={TYPE:"/sap.card/type"};var a=r.CardDesign;var n=r.CardPreviewMode;return e.extend("sap.ui.integration.widgets.CardRenderer",{apiVersion:2,renderContainerAttributes:function(r,i){e.renderContainerAttributes.apply(this,arguments);r.class("sapUiIntCard");var s=i._oCardManifest;if(s&&s.get(t.TYPE)&&s.get(t.TYPE).toLowerCase()==="analytical"){r.class("sapUiIntCardAnalytical")}if(i.getCardFooter()&&i.getCardFooter().getVisible()){r.class("sapUiIntCardWithFooter")}if(i.getDesign()===a.Transparent){r.class("sapFCardTransparent")}if(i.getPreviewMode()===n.Abstract){r.class("sapFCardPreview")}r.class("sapUiIntCard"+i.getDisplayVariant())},renderContentSection:function(r,t){var a=t.getAggregation("_filterBar");if(a){r.renderControl(a)}e.renderContentSection.apply(this,arguments)},renderFooterSection:function(e,r){var t=r.getAggregation("_footer");if(t){e.renderControl(t)}}})});
sap.ui.require.preload({
	"sap/ui/integration/customElements/CustomElementCard.js":function(){
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.require(["sap/ui/integration/widgets/Card","sap/ui/integration/customElements/CustomElementBase","sap/m/BadgeCustomData"],function(t,e,i){"use strict";var n=e.extend(t,{privateProperties:["width","height"],customProperties:{badge:{set:function(t,e){t.addCustomData(new i({value:e}))}}}});n.prototype.refresh=function(){this._getControl().refresh()};n.prototype.loadDesigntime=function(){return this._getControl().loadDesigntime()};e.define("ui-integration-card",n)});
},
	"sap/ui/integration/customElements/CustomElementCardEditor.js":function(){
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.require(["sap/ui/integration/designtime/editor/CardEditor","sap/ui/integration/customElements/CustomElementBase"],function(t,e){"use strict";var r=e.extend(t,{});r.prototype.getCurrentSettings=function(){return this._getControl().getCurrentSettings()};r.prototype.getSeparatePreview=function(){return this._getControl().getSeparatePreview()};var i=["ui-integration-card"];e.define("ui-integration-card-editor",r,i)});
},
	"sap/ui/integration/customElements/CustomElementEditor.js":function(){
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.require(["sap/ui/integration/editor/Editor","sap/ui/integration/customElements/CustomElementBase"],function(t,e){"use strict";var r=e.extend(t,{});r.prototype.getCurrentSettings=function(){return this._getControl().getCurrentSettings()};r.prototype.getSeparatePreview=function(){return this._getControl().getSeparatePreview()};e.define("ui-integration-editor",r)});
},
	"sap/ui/integration/library-bootstrap.js":function(){
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
(function(t){"use strict";var i;var e=document.currentScript||document.querySelector("script[src*='/sap-ui-integration.js']");function n(){if(t.sap&&t.sap.ui&&t.sap.ui.getCore){i=t.sap.ui.getCore();return u()}t.sap.ui.require(["sap/ui/core/Core"],function(t){t.boot();i=t;t.attachInit(function(){u()})})}function r(n){var r=i.getLoadedLibraries()[n],u=r.extensions["sap.ui.integration"].customElements,a=Object.keys(u),o=e.getAttribute("tags");if(o){a=o.split(",")}t.sap.ui.require(a.map(function(t,i){return u[a[i]]}))}function u(){i.loadLibrary("sap.ui.integration",{async:true}).then(function(){r("sap.ui.integration")})}n()})(window);
},
	"sap/ui/integration/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.integration","type":"library","embeds":[],"applicationVersion":{"version":"1.120.31"},"title":"SAPUI5 library with integration-related controls.","description":"SAPUI5 library with integration-related controls.","ach":"CA-UI5-CTR","resources":"resources.json","offline":true,"openSourceComponents":[{"name":"ui5-web-components","packagedWithMySelf":true,"version":"1.7.0"},{"name":"adaptive-cards","packagedWithMySelf":true,"version":"2.9.0"},{"name":"adaptive-cards-templating","packagedWithMySelf":true,"version":"2.2.0"},{"name":"adaptive-expressions","packagedWithMySelf":true,"version":"4.15.0"},{"name":"markdown-it","packagedWithMySelf":true,"version":"12.3.2"},{"name":"@cfworker/json-schema","packagedWithMySelf":true,"version":"1.6.8"}]},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.120","libs":{"sap.ui.core":{"minVersion":"1.120.31"},"sap.f":{"minVersion":"1.120.31"},"sap.m":{"minVersion":"1.120.31"},"sap.ui.unified":{"minVersion":"1.120.31"},"sap.ui.layout":{"minVersion":"1.120.31"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.integration.widgets.Card","sap.ui.integration.cards.filters.FilterBar","sap.ui.integration.cards.Header","sap.ui.integration.cards.NumericHeader","sap.ui.integration.controls.ListContentItem","sap.ui.integration.controls.BlockingMessage"],"elements":["sap.ui.integration.ActionDefinition","sap.ui.integration.Host","sap.ui.integration.Extension"],"types":["sap.ui.integration.CardActionType","sap.ui.integration.CardDataMode","sap.ui.integration.CardMenuAction","sap.ui.integration.CardDesign","sap.ui.integration.CardDisplayVariant","sap.ui.integration.CardBlockingMessageType"],"interfaces":[]}}}}',
	"sap/ui/integration/sap-ui-integration-config.js":function(){
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
window["sap-ui-config"]=window["sap-ui-config"]||{};window["sap-ui-config"].bindingSyntax="complex";window["sap-ui-config"].compatVersion="edge";window["sap-ui-config"].async=true;window["sap-ui-config"]["xx-waitForTheme"]=true;
},
	"sap/ui/integration/sap-ui-integration-define-nojQuery.js":function(){
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
(function(){"use strict";var e={"sap/ui/thirdparty/jquery":"jQuery","sap/ui/thirdparty/jqueryui/jquery-ui-core":"jQuery.ui","sap/ui/thirdparty/jqueryui/jquery-ui-widget":"jQuery.widget","sap/ui/thirdparty/jqueryui/jquery-ui-mouse":"jQuery.ui.mouse","sap/ui/thirdparty/jqueryui/jquery-ui-datepicker":"jQuery.ui.datepicker","sap/ui/thirdparty/jqueryui/jquery-ui-draggable":"jQuery.ui.draggable","sap/ui/thirdparty/jqueryui/jquery-ui-droppable":"jQuery.ui.droppable","sap/ui/thirdparty/jqueryui/jquery-ui-position":"jQuery.ui.position","sap/ui/thirdparty/jqueryui/jquery-ui-resizable":"jQuery.ui.resizable","sap/ui/thirdparty/jqueryui/jquery-ui-selectable":"jQuery.ui.selectable","sap/ui/thirdparty/jqueryui/jquery-ui-sortable":"jQuery.ui.sortable","sap/ui/thirdparty/jqueryui/jquery-ui-effect":"jQuery.effects.effect","sap/ui/thirdparty/jqueryui/jquery-ui-effect-blind":"jQuery.effects.effect.blind","sap/ui/thirdparty/jqueryui/jquery-ui-effect-bounce":"jQuery.effects.effect.bounce","sap/ui/thirdparty/jqueryui/jquery-ui-effect-clip":"jQuery.effects.effect.clip","sap/ui/thirdparty/jqueryui/jquery-ui-effect-drop":"jQuery.effects.effect.drop","sap/ui/thirdparty/jqueryui/jquery-ui-effect-explode":"jQuery.effects.effect.explode","sap/ui/thirdparty/jqueryui/jquery-ui-effect-fade":"jQuery.effects.effect.fade","sap/ui/thirdparty/jqueryui/jquery-ui-effect-fold":"jQuery.effects.effect.fold","sap/ui/thirdparty/jqueryui/jquery-ui-effect-highlight":"jQuery.effects.effect.highlight","sap/ui/thirdparty/jqueryui/jquery-ui-effect-pulsate":"jQuery.effects.effect.pulsate","sap/ui/thirdparty/jqueryui/jquery-ui-effect-scale":"jQuery.effects.effect.scale","sap/ui/thirdparty/jqueryui/jquery-ui-effect-shake":"jQuery.effects.effect.shake","sap/ui/thirdparty/jqueryui/jquery-ui-effect-slide":"jQuery.effects.effect.slide","sap/ui/thirdparty/jqueryui/jquery-ui-effect-transfer":"jQuery.effects.effect.transfer"};for(var u in e){r(u,e[u])}function r(e,u){if(!i(u)){return}sap.ui.define(e,function(){return jQuery})}function i(e){var u=e.split("."),r=window,i;i=u.some(function(e){r=r[e];return r===undefined});return!i}})();
}
});
//# sourceMappingURL=library-preload.js.map
