/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/EventProvider","sap/base/Log","sap/ui/integration/library","sap/ui/integration/util/ServiceDataProvider","sap/ui/integration/util/RequestDataProvider","sap/ui/integration/util/CacheAndRequestDataProvider","sap/ui/integration/util/DataProvider","sap/ui/integration/util/ExtensionDataProvider","sap/ui/integration/util/JSONBindingHelper","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/CsrfTokenHandler"],function(e,t,i,s,r,n,o,a,d,u,l){"use strict";var f=i.CardPreviewMode;var c=e.extend("sap.ui.integration.util.DataProviderFactory",{constructor:function(t){e.call(this);t=t||{};this._oDestinations=t.destinations;this._oExtension=t.extension;this._oCsrfTokenHandler=t.csrfTokenHandler;this._oCard=t.card;this._oEditor=t.editor;this._oHost=t.host;if(t.csrfTokensConfig){this._oCsrfTokenHandler=new l({host:t.host,configuration:t.csrfTokensConfig})}this._aDataProviders=[];this._aFiltersProviders=[]}});c.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments);if(this._aDataProviders){this._aDataProviders.forEach(function(e){if(!e.bIsDestroyed){e.destroy()}});this._aDataProviders=null;this._aFiltersProviders=null}if(this._oCsrfTokenHandler){this._oCsrfTokenHandler.destroy();this._oCsrfTokenHandler=null}this._oCard=null;this._oExtension=null;this._bIsDestroyed=true};c.prototype.isDestroyed=function(){return this._bIsDestroyed};c.prototype.create=function(e,t,i,d){var l=this._oCard;if(!c.isProvidingConfiguration(e)||l&&l.getPreviewMode()===f.Abstract){return null}if(l&&l.getPreviewMode()===f.MockData){e=this._applyMockDataConfiguration(e)}var h=this._oEditor,g=this._oHost||l&&l.getHostInstance()||h&&h.getHostInstance(),p=g&&g.bUseExperimentalCaching,v=this._createDataProviderSettings(e,d),_;if(e.request&&p){_=new n(v);_.setHost(g)}else if(e.request){_=new r(v);if(g){_.setHost(g)}}else if(e.service){_=new s(v)}else if(e.json){_=new o(v)}else if(e.extension){_=new a(v,this._oExtension)}if(l){_.setCard(l);u.propagateModels(l,_)}else if(h){u.propagateModels(h,_)}_.bindObject("/");_.setDestinations(this._oDestinations);if(this._oCsrfTokenHandler){_.setCsrfTokenHandler(this._oCsrfTokenHandler);this._oCsrfTokenHandler.setDataProviderFactory(this)}if(_.isA("sap.ui.integration.util.IServiceDataProvider")){_.createServiceInstances(t)}this._aDataProviders.push(_);if(i){this._aFiltersProviders.push(_)}else{_.setDependencies(this._aFiltersProviders)}return _};c.prototype.remove=function(e){var t=this._aDataProviders.indexOf(e);if(t>-1){this._aDataProviders.splice(t,1)}if(e&&!e.bDestroyed&&e._bIsDestroyed){e.destroy()}};c.prototype.setHost=function(e){this._oHost=e;if(this._oCsrfTokenHandler){this._oCsrfTokenHandler.setHost(e)}};c.prototype._createDataProviderSettings=function(e,t){var i=this._oCard;var s=this._oEditor;var r={};if(i){r.baseRuntimeUrl=i.getRuntimeUrl("/");if(t){r.settings=e}else{r.settingsJson=d.createJsonWithBindingInfos(e,i.getBindingNamespaces())}}else if(s){r.baseRuntimeUrl=s.getRuntimeUrl("/");r.settingsJson=d.createJsonWithBindingInfos(e,s.getBindingNamespaces())}else{r.settingsJson=d.createJsonWithBindingInfos(e,{})}return r};c.prototype._applyMockDataConfiguration=function(e){if(!e.mockData||!c.isProvidingConfiguration(e.mockData)){t.error("There is no mock data configured.","sap.ui.integration.widgets.Card");return null}var i=Object.assign({},e);delete i.request;delete i.service;delete i.json;delete i.extension;return Object.assign(i,e.mockData)};c.isProvidingConfiguration=function(e){return e&&(e.request||e.service||e.json||e.extension)};return c});
//# sourceMappingURL=DataProviderFactory.js.map