/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/base/Log","sap/base/util/isPlainObject","sap/ui/integration/util/Utils"],function(t,e,i,r){"use strict";var n=/\{\{destinations.([^\}]+)/;var o=t.extend("sap.ui.integration.util.Destinations",{metadata:{library:"sap.ui.integration"},constructor:function(e){t.call(this);this._oHost=e.host;this._oCard=e.card;this._oConfiguration=e.manifestConfig;this._mResolved=new Map}});o.prototype.setHost=function(t){this._oHost=t;this._mResolved.clear()};o.prototype.process=function(t){var i=[];this._processObject(t,undefined,i);return Promise.all(i).then(function(){return t}).catch(function(i){e.error(i,"sap.ui.integration.util.Destinations");return t})};o.prototype._processObject=function(t,e,r){if(!t){return Promise.resolve(t)}var n=t.hasOwnProperty(e)?t[e]:t;if(typeof n==="string"){r.push(this.processString(n).then(function(i){if(e!==undefined){t[e]=i}}).catch(function(){if(e!==undefined){t[e]=""}}))}if(i(n)){Object.keys(n).forEach(function(t){this._processObject(n,t,r)}.bind(this))}if(Array.isArray(n)){n.forEach(function(t,e){this._processObject(n,e,r)}.bind(this))}};o.prototype.getUrl=function(t){var e;if(this._mResolved.has(t)){return this._mResolved.get(t)}e=this._resolveUrl(t);this._mResolved.set(t,e);return e};o.prototype._resolveUrl=function(t){var i=this._oConfiguration?this._oConfiguration[t]:null,n,o,s;if(!i){return Promise.reject("Configuration for destination '"+t+"' was not found in the manifest.")}n=i.name;o=i.defaultUrl;if(!n&&!o){return Promise.reject("Can not resolve destination '"+t+"'. Neither 'name' nor 'defaultUrl' is configured.")}if(!n&&o){return Promise.resolve(o)}if(!this._oHost&&!o){return Promise.reject("Can not resolve destination '"+t+"'. There is no 'host' and no defaultUrl specified.")}if(!this._oHost&&o){return Promise.resolve(o)}s=r.timeoutPromise(this._oHost.getDestination(n,this._oCard));if(o){return s.catch(function(t){e.info(t+" Fallback to default url.","sap.ui.integration.util.Destinations");return o})}return s};o.prototype.hasDestination=function(t){return!!t.match(n)};o.prototype.processString=function(t){var e=t.match(n),i;if(!e){return Promise.resolve(t)}i=e[1];return this.getUrl(i).then(function(e){return this._replaceUrl(t,i,e)}.bind(this))};o.prototype._replaceUrl=function(t,e,i){var r=i.trim().replace(/\/$/,"");return t.replace("{{destinations."+e+"}}",r)};return o});
//# sourceMappingURL=Destinations.js.map