/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/core/library","sap/ui/core/Core","sap/base/Log","sap/base/util/deepExtend","./Validators","./BindingHelper","./BindingResolver","./DateRangeHelper","./Duration"],function(e,t,r,i,o,a,n,s,l,u){"use strict";var d=t.ValueState;var p=e.extend("sap.ui.integration.util.Form",{constructor:function(t){e.apply(this);this._oCard=t},metadata:{library:"sap.ui.integration"}});p.prototype.init=function(){this._mControls=new Map};p.prototype.exit=function(){this._mControls.clear();delete this._mControls;delete this._oCard};p.prototype.addControl=function(e,t,r,i){if(!this._isValidControlId(r.id)){return}this._syncToFormModelOn(e,t,r,i)};p.prototype.validate=function(e,t){var r=false;this._mControls.forEach(function(t){if(this._validateControl(t,e)){r=true}}.bind(this));if(r&&!t){this._oCard.scheduleFireStateChanged()}};p.prototype.resolveControl=function(e){var t={},r=this.getModel("form").getProperty("/"+e.id),i=this.getModel("messages").getProperty("/records"),o=i.find(function(t){return t.bindingPath==="/"+e.id}),a=this._mControls.get(e.id);if(o&&(a&&a._bShowValueState)){t.valueState={message:o.message,type:o.type}}switch(e.type){case"ComboBox":t.selectedKey=r.key;r=r.value;break;case"DateRange":r=r.value;break;default:break}t.value=r;return t};p.prototype.setControlValue=function(e){if(!this._isControlDataValid(e)){return}var t=e.id,r=this._mControls.get(t),i=e.value;if(r.isA("sap.m.ComboBox")){this._setComboBoxValue(r,e)}else if(i){if(r.isA("sap.m.DatePicker")||r.isA("sap.m.DynamicDateRange")){l.setValue(r,i,this._oCard)}else if(r.isA("sap.m.TimePicker")){r.setValue(u.fromISO(i))}else{r.setValue(i)}}this._validateAndUpdate(r)};p.prototype.updateModel=function(){this._mControls.forEach(this._updateModel.bind(this))};p.prototype._setComboBoxValue=function(e,t){var r;if("key"in t){e.setSelectedKey(t.key);r=e.getItems().find(function(e){return e.getKey()===t.key});e.setValue(r?r.getText():"")}if("value"in t&&!("key"in t)){r=e.getItems().find(function(e){return e.getText()===t.value});if(r){e.setSelectedItem(r)}else{e.setSelectedKey("");e.setValue(t.value)}}};p.prototype._isValidControlId=function(e){if(!e){i.error("Each input control must have an ID.","sap.ui.integration.widgets.Card");return false}if(this._mControls.has(e)){i.error("Duplicate form control ID - '"+e+"'","sap.ui.integration.widgets.Card");return false}return true};p.prototype._syncToFormModelOn=function(e,t,r,i){this._prepareValidationForControl(t,r,i);t.attachEvent(e,this._validateAndUpdate,this);if(r.value&&!n.isBindingInfo(r.value)){this._updateModel(t)}this._mControls.set(r.id,t)};p.prototype._updateModel=function(e){this.getModel("form").setProperty("/"+e._oItem.id,f(e))};p.prototype._validateAndUpdate=function(e){var t=e.getSource?e.getSource():e;this._validateControl(t,true);this._updateModel(t);this._oCard.scheduleFireStateChanged()};p.prototype._isControlDataValid=function(e){if(!e){return false}var t=e.id;if(!t){i.error("Form control data is missing property 'id'.","sap.ui.integration.widgets.Card");return false}var r=this._mControls.get(t);if(!r){i.error("Form control with ID - '"+t+"' does not exist.","sap.ui.integration.widgets.Card");return false}if(r.isA(["sap.m.TextArea","sap.m.Input"])&&!("value"in e)){i.error("Form data for control ID - '"+t+"' is missing property 'value'.","sap.ui.integration.widgets.Card");return false}if(r.isA("sap.m.ComboBox")){if("value"in e||"key"in e){return true}i.error("Form data for control ID - '"+t+"' requires properties 'key' or 'value'.","sap.ui.integration.widgets.Card");return false}return true};p.prototype._prepareValidationForControl=function(e,t,r){var i=o({},t);if(i.validations){i.validations.forEach(function(e,t){if(e.pattern){e.pattern=this._oCard.getManifestEntry(r+"/validations/"+t)["pattern"]}}.bind(this))}e._oItem=i};p.prototype._validateControl=function(e,t){var r=this._oCard.getAggregation("_extension"),i=e._oItem,o=e.getBindingContext(),a=o?o.getPath():"",n=false,l;this._removeMessageFromControl(e);if(!i){return n}n=!this._checkBuiltInValidations(e,i,t);if(!n&&i.validations){l=s.resolveValue(i.validations,e,a);n=!l.every(function(o){return this._checkValidationItem(o,e,i,t,r)}.bind(this))}this._updateMessageModel();return n};p.prototype._checkValidationItem=function(e,t,r,i,o){var n=a[this._getFormControlType(r)],s,l,u,p,c=this.getModel("i18n").getResourceBundle(),g=true;for(var h in e){s=e[h];if(h==="validate"){u=this._getExtensionFunctionName(s,o);if(u){p=o[u]}}else{p=n[h]}if(typeof p!=="function"){continue}l=p(f(t),s);if(!l){this._addMessageToControl(t,i,{type:e.type||d.Error,message:e.message||c.getText(n[h+"Txt"],s),bindingPath:"/"+r.id});g=false;break}}return g};p.prototype._checkBuiltInValidations=function(e,t,i){var o=true;if(e.isA("sap.m.DatePicker")&&!e.isValidValue()){this._addMessageToControl(e,i,{type:d.Error,message:r.getLibraryResourceBundle("sap.ui.core").getText("VALUE_STATE_ERROR"),bindingPath:"/"+t.id});o=false}return o};p.prototype._addMessageToControl=function(e,t,r){var i=this.getModel("messages"),o=i.getData();o.records.push(r);i.setData(o);if(t||e._bShowValueState){e._bShowValueState=true;e.setValueState(r.type);e.setValueStateText(r.message)}this._updateMessageModel()};p.prototype._removeMessageFromControl=function(e){var t=this.getModel("messages"),r="/"+e._oItem.id,i=t.getData(),o=false;e.setValueState(d.None);for(var a=0;a<i.records.length;a++){if(i.records[a].bindingPath===r){i.records.splice(a,1);o=true;break}}if(o){t.setData(i)}this._updateMessageModel()};p.prototype._updateMessageModel=function(){var e=this.getModel("messages"),t=e.getProperty("/records");e.setProperty("/hasErrors",t.some(function(e){return e.type===d.Error}));e.setProperty("/hasWarnings",t.some(function(e){return e.type===d.Warning}))};p.prototype.getRequiredValidationValue=function(e){var t=e.validations||[],r,i,o;for(i=0;i<t.length;i++){r=t[i];for(o in r){if(o==="required"){return r[o]}}}return false};p.prototype._getExtensionFunctionName=function(e,t){if(!e.startsWith("extension.")){i.error("Validation function should start with 'extension'.");return false}if(!t){i.error("Extension is not defined.");return false}var r=e.replace("extension.","");if(!t[r]){i.error("No such function.",r,"sap.ui.integration.widgets.Card");return false}return r};p.prototype._getFormControlType=function(e){switch(e.type){case"ComboBox":return"keyValuePair";case"DateRange":return"dateRange";default:return"string"}};function f(e){if(e.isA("sap.m.ComboBox")){e.synchronizeSelection();return{key:e.getSelectedKey(),value:e.getValue()}}else if(e.isA("sap.m.DynamicDateRange")||e.isA("sap.m.DatePicker")){return l.getValueForModel(e)}else if(e.isA("sap.m.TimePicker")){return u.toISO(e.getValue())}else{return e.getValue()}}return p});
//# sourceMappingURL=Form.js.map