/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Core","sap/m/OverflowToolbar","sap/m/OverflowToolbarRenderer","sap/m/ToolbarSpacer","sap/m/ToolbarSeparator","sap/m/library","sap/ui/mdc/enums/ActionToolbarActionAlignment","sap/ui/mdc/p13n/subcontroller/ActionToolbarController","sap/m/p13n/Engine"],function(t,e,o,n,r,i,s,a,g){"use strict";const p=i.OverflowToolbarPriority;const l=e.extend("sap.ui.mdc.ActionToolbar",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/actiontoolbar/ActionToolbar.designtime",defaultAggregation:"actions",properties:{useAsHeader:{type:"boolean",group:"Behavior",defaultValue:true},_endOrder:{type:"string[]",defaultValue:[],visibility:"hidden"}},aggregations:{begin:{type:"sap.ui.core.Control",multiple:true},between:{type:"sap.ui.core.Control",multiple:true},actions:{type:"sap.ui.mdc.actiontoolbar.ActionToolbarAction",multiple:true},end:{type:"sap.ui.core.Control",multiple:true}}},renderer:o});const c=["begin","between","actions","end"];const d=function(){const t={canOverflow:true,getCustomImportance:function(){return p.NeverOverflow}};return t};l.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oBeginSeparator=new r({visible:false});this._oBeginSeparator.getOverflowToolbarConfig=d;this._oEndActionsBeginSeparator=new r({visible:false});this._oEndActionsBeginSeparator.getOverflowToolbarConfig=d;this._oEndActionsEndSeparator=new r({visible:false});this._oEndActionsEndSeparator.getOverflowToolbarConfig=d;this._oSpacer=new n;this.setUseAsHeader(true);g.getInstance().register(this,{controller:{actionsKey:new a({control:this})}})};l.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oBeginSeparator){this._oBeginSeparator.destroy()}if(this._oEndActionsBeginSeparator){this._oEndActionsBeginSeparator.destroy()}if(this._oEndActionsEndSeparator){this._oEndActionsEndSeparator.destroy()}if(this._oSpacer){this._oSpacer.destroy()}};l.prototype.setProperty=function(t){if(t==="_endOrder"){this._bEnforceEndOrder=true}return e.prototype.setProperty.apply(this,arguments)};l.prototype.addAggregation=function(t,o){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}if(t==="end"){this._bEnforceEndOrder=true}const n=arguments;if(c.includes(t)){this._registerControlListener(o);this._resetAndInvalidateToolbar(false);if(o){this._moveControlInSuitableCollection(o,this._getControlPriority(o))}this._informNewFlexibleContentAdded(o);const t=this._callToolbarMethod("addAggregation",n);this._updateSeparators();return t}return e.prototype.addAggregation.apply(this,arguments)};l.prototype.destroyAggregation=function(t){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}if(c.includes(t)){const e=this.removeAllAggregation(t);for(let t=0;t<e.length;t++){e[t].destroy()}this._updateSeparators();return this}return e.prototype.destroyAggregation.apply(this,arguments)};l.prototype.insertAggregation=function(t,o,n){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}if(t==="end"){this._bEnforceEndOrder=true}if(c.includes(t)){this._registerControlListener(o);this._resetAndInvalidateToolbar(false);if(o){this._moveControlInSuitableCollection(o,this._getControlPriority(o))}this._informNewFlexibleContentAdded(o);const t=this._callToolbarMethod("insertAggregation",arguments);this._updateSeparators();return t}return e.prototype.insertAggregation.apply(this,arguments)};l.prototype.removeAllAggregation=function(t){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}return e.prototype.removeAllAggregation.apply(this,arguments)};l.prototype.removeAggregation=function(t,o){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}if(c.includes(t)){const t=this._callToolbarMethod("removeAggregation",arguments);if(t){this._getPopover().removeAssociatedContent(t.getId())}this._resetAndInvalidateToolbar(false);this._deregisterControlListener(t);this._removeContentFromControlsCollections(t);this._updateSeparators();return t}return e.prototype.removeAggregation.apply(this,arguments)};l.prototype.setUseAsHeader=function(t){this.setProperty("useAsHeader",t,true);this.toggleStyleClass("sapMTBHeader-CTX",!!t);return this};l.prototype.getEndActionsBegin=function(){return this.getActionsWithLayoutInformation({aggregationName:"end",alignment:s.Begin})};l.prototype.getEndActionsEnd=function(){return this.getActionsWithLayoutInformation({aggregationName:"end",alignment:s.End})};l.prototype.getActionsWithLayoutInformation=function(t){return this.getActions().filter(function(e){const o=e.getLayoutInformation();return o.aggregationName===t.aggregationName&&o.alignment===t.alignment})};l.prototype.onBeforeRendering=function(){e.prototype.onBeforeRendering.apply(this,arguments);if(this._bEnforceEndOrder){this.getProperty("_endOrder").reduce((e,o)=>{const n=t.byId(o);if(!n){return e}const r=this.indexOfEnd(n);if(r!=e){this.insertEnd(this.removeEnd(n),e)}return e+1},0);this._bEnforceEndOrder=false}};l.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments);this._updateSeparators()};l.prototype._onContentPropertyChangedOverflowToolbar=function(t){if(this._bIsBeingDestroyed){return}e.prototype._onContentPropertyChangedOverflowToolbar.apply(this,arguments);if(t.getParameter("name")==="visible"||t.getParameter("name")==="width"&&t.getSource()!=this._oBeginSeparator){this._updateSeparators()}};l.prototype._hasVisible=function(t){const e=this.getAggregation("_popover")?this.getAggregation("_popover")._getAllContent():[];const o=t.filter(function(t){return e.indexOf(t)===-1});return o.some(function(t){const e=t.getWidth?t.getWidth()!=="0px":true;return t.getVisible()&&e})};l.prototype._updateSeparators=function(){const t=this._hasVisible(this.getEnd());if(this._oBeginSeparator){const t=this._hasVisible(this.getBegin());const e=this._hasVisible(this.getBetween());this._oBeginSeparator.setVisible(t&&e)}if(this._oEndActionsBeginSeparator){const e=this._hasVisible(this.getEndActionsBegin());this._oEndActionsBeginSeparator.setVisible(t&&e)}if(this._oEndActionsEndSeparator){const e=this._hasVisible(this.getEndActionsEnd());this._oEndActionsEndSeparator.setVisible(t&&e)}};l.prototype.indexOfContent=function(t){return this.getContent().indexOf(t)};l.prototype.getContent=function(){let t=this.getBegin();t.push(this._oBeginSeparator);t=t.concat(this.getBetween());t.push(this._oSpacer);t=t.concat(this.getEndActionsBegin());t.push(this._oEndActionsBeginSeparator);t=t.concat(this.getEnd());t.push(this._oEndActionsEndSeparator);t=t.concat(this.getEndActionsEnd());return t};l.prototype.getCurrentState=function(){const t=[];let e;this.getActions().forEach(function(o,n){e=o&&o.getId();if(o.getVisible()){t.push({name:e,alignment:o.getLayoutInformation().alignment})}});return{items:t}};l.prototype.initPropertyHelper=function(){return Promise.resolve({getProperties:function(){const t=[];this.getActions().forEach(function(e){t.push({name:e.getId(),alignment:e.getLayoutInformation().alignment,label:e.getLabel(),visible:true})});return t}.bind(this)})};return l});
//# sourceMappingURL=ActionToolbar.js.map