/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/field/FieldBase","sap/ui/mdc/field/FieldBaseRenderer","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/condition/Condition","sap/base/util/deepEqual","sap/base/util/merge","sap/ui/model/BindingMode","sap/ui/model/Context"],function(t,e,i,n,a,o,s,l,r,p){"use strict";const d=t.extend("sap.ui.mdc.Field",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/field/Field.designtime",properties:{value:{type:"any",defaultValue:null,bindable:"bindable"},additionalValue:{type:"any",defaultValue:null,bindable:"bindable"}},events:{change:{parameters:{value:{type:"string"},valid:{type:"boolean"},promise:{type:"Promise"}}}},defaultProperty:"value"},renderer:e});d.prototype.init=function(){this._vValue=null;this._vAdditionalValue=null;t.prototype.init.apply(this,arguments);this.setMaxConditions(1);this.setProperty("_operators",[a.EQ],true);this._oObserver.observe(this,{properties:["value","additionalValue","valueState"]})};d.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this._iConditionUpdateTimer){clearTimeout(this._iConditionUpdateTimer);delete this._iConditionUpdateTimer;delete this._bPendingConditionUpdate}this._oBindingContext=undefined};d.prototype.bindProperty=function(e,i){let n;let a;let o=0;if(e==="value"&&!i.formatter){i.targetType="raw";n=this.getContentFactory().getDataType();if(i.type&&(!n||n.getMetadata().getName()!==i.type.getMetadata().getName()||!s(n.getFormatOptions(),i.type.getFormatOptions())||!s(n.getConstraints(),i.type.getConstraints())||n._bCreatedByOperator!==i.type._bCreatedByOperator)){this.getContentFactory().setDataType(i.type);this.getContentFactory().setDateOriginalType(undefined);this.getContentFactory().setUnitOriginalType(undefined);this.getContentFactory().setIsMeasure(false);if(i.type.isA("sap.ui.model.CompositeType")&&i.parts){a=[];for(o=0;o<i.parts.length;o++){a.push(i.parts[o].type)}this.getContentFactory().setCompositeTypes(a)}this.getContentFactory().updateConditionType();this.invalidate()}}else if(e==="additionalValue"&&!i.formatter){i.targetType="raw";n=this.getContentFactory().getAdditionalDataType();if(i.type&&(!n||n.getMetadata().getName()!==i.type.getMetadata().getName()||!s(n.getFormatOptions(),i.type.getFormatOptions())||!s(n.getConstraints(),i.type.getConstraints())||n._bCreatedByOperator!==i.type._bCreatedByOperator)){this.getContentFactory().setAdditionalDataType(i.type);if(i.type.isA("sap.ui.model.CompositeType")&&i.parts){a=[];for(o=0;o<i.parts.length;o++){a.push(i.parts[o].type)}this.getContentFactory().setAdditionalCompositeTypes(a)}this.getContentFactory().updateConditionType();this.invalidate()}}t.prototype.bindProperty.apply(this,arguments)};d.prototype.handleModelContextChange=function(e){t.prototype.handleModelContextChange.apply(this,arguments);const i=this.getBinding("value");if(i){const t=i.isA("sap.ui.model.CompositeBinding")?i.getBindings()[0].getContext():i.getContext();if(p.hasChanged(this._oBindingContext,t)){this._oBindingContext=t;this.getContentFactory().updateConditionType();if(this.isInvalidInput()||this._getValueHelp()){if(this._oManagedObjectModel){this._oManagedObjectModel.checkUpdate(true,true)}this.resetInvalidInput()}}if(!this.getContentFactory().getDataType()){this.getContentFactory().setDataType(i.getType());this.invalidate()}}};d.prototype.initDataType=function(){t.prototype.initDataType.apply(this,arguments);const e=this.getBinding("value");if(e){this.getContentFactory().setDataType(e.getType())}};d.prototype.setProperty=function(e,i,n){if(e==="value"&&this.isInvalidInput()&&s(this.getValue(),this.validateProperty(e,i))){if(this._oManagedObjectModel){this._oManagedObjectModel.checkUpdate(true,true)}this.resetInvalidInput()}return t.prototype.setProperty.apply(this,arguments)};d.prototype.setMaxConditions=function(t){if(t!==1){throw new Error("Only one condition allowed for Field "+this)}return this.setProperty("maxConditions",t,true)};d.prototype.observeChanges=function(e){t.prototype.observeChanges.apply(this,arguments);if(e.name==="value"){const t=c.call(this,e.current,e.old);if(this._vAdditionalValue!==null&&F.call(this)&&!f.call(this,t,this._vValue,true)){this._vAdditionalValue=this.getAdditionalValue()}this._vValue=t;T.call(this,e.current);g.call(this)}if(e.name==="additionalValue"){this._vAdditionalValue=e.current;g.call(this)}if(e.name==="valueState"){if(this._bPendingConditionUpdate){this._bKeepValueState=true}}if(e.name==="conditions"){if(this.getCurrentContent().length<=1){m.call(this,e.current)}}};function h(){return this._vValue}function u(){return this._vAdditionalValue}function g(){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){if(!this.isFieldDestroyed()){g.call(this)}}.bind(this));this._bPendingConditionUpdate=true;return}if(this.getDisplay()===i.Value){y.call(this,h.call(this),u.call(this))}else if(!this._iConditionUpdateTimer){this._iConditionUpdateTimer=setTimeout(function(){y.call(this,h.call(this),u.call(this));this._iConditionUpdateTimer=undefined}.bind(this),0);this._bPendingConditionUpdate=true}}function y(t,e){const i=this.getConditions();if(this.checkValueInitial(t)&&!e){if(i.length>0){this.setConditions([])}}else{const n=i[0];const s=n&&n.values[0];const l=n&&n.values[1]?n.values[1]:null;if(!n||n.operator!==a.EQ||!f.call(this,s,t)||!C.call(this,e,l)){const i=this.getControlDelegate();const a=i.createCondition(this,this,[t,e],n);if(!o.compareConditions(n,a)){this.setConditions(a?[a]:[])}}}this._bPendingConditionUpdate=false;this._bKeepValueState=false}function c(t,e){const i=this.getContentFactory().getDataType()?this.getContentFactory().getDataType().getMetadata().getName():this.getDataType();if(t&&e&&(i==="sap.ui.model.odata.type.Unit"||i==="sap.ui.model.odata.type.Currency")&&!t[2]&&e[2]!==undefined){t=l([],t);t[2]=e[2];if(this._bPendingChange){const i=this.getConditions()[0];if(i){if(t[0]===e[0]&&t[0]!==i.values[0][0]){t[0]=i.values[0][0]}if(t[1]===e[1]&&t[1]!==i.values[0][1]){t[1]=i.values[0][1]}}}}return t}function f(t,e,i){let a=t===e;const o=this.getContentFactory().getDataType()?this.getContentFactory().getDataType().getMetadata().getName():this.getDataType();if(!a&&this.getTypeMap().getBaseType(o)===n.Unit&&Array.isArray(t)&&Array.isArray(e)){const n=t[0];const o=t[1];const l=t.length>=3?t[2]:null;const r=e[0];const p=e[1];const d=e.length>=3?e[2]:null;if(n===r&&o===p&&((this._bUnitSet||i)&&(!l||!d)||s(l,d))){a=true}if((l||d)&&!i){this._bUnitSet=true}}return a}function C(t,e,i){let n=t===e;if(!n&&(t===null||t===undefined||t==="")&&(e===null||e===undefined||e==="")){n=true}return n}function T(t){if(!this._oTypeInitialization){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){if(!this.isFieldDestroyed()){T.call(this,t)}}.bind(this));return}const e=this.getBinding("value");const i=e?e.getType():this.getContentFactory().getDataType();if(i){this._oTypeInitialization=this.getTypeMap().initializeTypeFromValue(i,t);if(this._oTypeInitialization&&this.getContentFactory().getUnitOriginalType()){this.getTypeMap().initializeInternalType(this.getContentFactory().getDataType(),this._oTypeInitialization);this.getTypeMap().initializeInternalType(this.getContentFactory().getUnitType(),this._oTypeInitialization)}}}}d.prototype.fireChangeEvent=function(t,e,i,n){let a;if(t){if(e){a=this.getResultForChangePromise(t)}else{a=i}}if(this.getCurrentContent().length>1){if(t){m.call(this,this.getConditions())}else if(n){n=n.then(function(t){m.call(this,this.getConditions());return t}.bind(this))}}this.fireChange({value:a,valid:e,promise:n})};d.prototype.getResultForChangePromise=function(t){let e;if(t.length===0&&this.getContentFactory().getDataType()){e=this.getContentFactory().getDataType().parseValue("","string",[])}else if(t.length===1){e=t[0].values[0]}return e};function m(t){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){if(!this.isFieldDestroyed()){m.call(this,t)}}.bind(this));return}let e=null;let i=null;const n=this.getValue();const a=this.getAdditionalValue();if(t.length===0&&b(n)&&b(a)){return}e=this.getResultForChangePromise(t);e=v.call(this,e,n);if(t.length===0||t[0].values.length===1){if(a){const t=this.getContentFactory().getAdditionalDataType();if(t){i=t.parseValue("","string")}}else{i=a}}else if(t.length===1&&t[0].values.length>1){i=t[0].values[1]}this._vValue=e;this._vAdditionalValue=i;if(!f.call(this,e,n,true)){this.setProperty("value",e,true)}if(!C.call(this,i,a,true)&&!F.call(this)){this.setProperty("additionalValue",i,true)}}function v(t,e){const i=this.getContentFactory().getDataType()?this.getContentFactory().getDataType().getMetadata().getName():this.getDataType();if(this.getTypeMap().getBaseType(i)===n.Unit&&Array.isArray(t)&&Array.isArray(e)&&!this.checkValueInitial(t)&&this.checkValueInitial(e)){for(let i=0;i<t.length;i++){if(t[i]===null&&e[i]!==undefined){t[i]=e[i]}}}return t}d.prototype.getSupportedOperators=function(){return this.getProperty("_operators",[])};function F(){const t=this.getBinding("additionalValue");if(t&&t.getBindingMode()===r.OneWay){return true}return false}d.prototype.checkCreateInternalContent=function(){if(!this.isFieldDestroyed()&&this.getContentFactory().getDataType()&&!this.isFieldPropertyInitial("editMode")&&!this.isFieldPropertyInitial("multipleLines")){t.prototype.checkCreateInternalContent.apply(this,arguments)}};d.prototype.getOverflowToolbarConfig=function(){const e=t.prototype.getOverflowToolbarConfig.apply(this,arguments);e.propsUnrelatedToSize.push("value");e.propsUnrelatedToSize.push("additionalValue");return e};d.prototype.isSearchField=function(){return false};function b(t){let e=false;if(t===null){e=true}else if(Array.isArray(t)){e=true;for(let i=0;i<t.length;i++){if(t[i]!==null){e=false;break}}}return e}d.prototype.getAdditionalDataTypeConfiguration=function(){const t=this.getBinding("additionalValue");return t&&t.getType()};return d});
//# sourceMappingURL=Field.js.map