/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/field/FieldBase","sap/ui/mdc/field/FieldBaseRenderer","sap/ui/mdc/enums/FieldDisplay","sap/base/util/merge","sap/base/util/deepEqual"],function(t,e,r,i,o){"use strict";const n=t.extend("sap.ui.mdc.FilterField",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/field/FilterField.designtime",properties:{operators:{type:"string[]",group:"Data",defaultValue:[]},defaultOperator:{type:"string",group:"Data",defaultValue:null},propertyKey:{type:"string",group:"Data",defaultValue:""},additionalDataType:{type:"object",group:"Data",defaultValue:null}},events:{change:{parameters:{value:{type:"string"},valid:{type:"boolean"},conditions:{type:"object[]"},promise:{type:"boolean"}}}}},renderer:e});n.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oObserver.observe(this,{properties:["operators","propertyKey","additionalDataType"]})};n.prototype.exit=function(){t.prototype.exit.apply(this,arguments)};n.prototype.getPropertyKey=function(){let t=this.getProperty("propertyKey");if(!t){t=this.getFieldPath()}return t};n.prototype.setProperty=function(e,r,i){if(e==="conditions"&&this.isInvalidInput()&&o(this.getConditions(),this.validateProperty(e,r))){if(this._oManagedObjectModel){this._oManagedObjectModel.checkUpdate(true,true)}this.resetInvalidInput()}return t.prototype.setProperty.apply(this,arguments)};n.prototype.observeChanges=function(e){t.prototype.observeChanges.apply(this,arguments);if(e.name==="operators"){if(e.current.length===0){t.prototype.getSupportedOperators.apply(this,[])}else{this.setProperty("_operators",e.current,true)}this.updateInternalContent()}else if(e.name==="propertyKey"){this.updateInternalContent()}else if(e.name==="additionalDataType"){p.call(this,e.current)}};n.prototype.fireChangeEvent=function(t,e,r,o){let n;if(t){if(e){if(t.length==1){n=t[0].values[0]}}else{n=r}}this.fireChange({value:n,valid:e,conditions:i([],t),promise:o})};n.prototype.getSupportedOperators=function(){let e=this.getOperators();if(e.length===0){e=t.prototype.getSupportedOperators.apply(this,arguments)}else{this.setProperty("_operators",e,true)}return e};n.prototype.setOperators=function(t){const e=[];if(!Array.isArray(t)){t=t.split(",")}t.forEach(function(t){if(typeof t==="string"){e.push(t)}else{e.push(t.name)}});this.setProperty("operators",e);return this};n.prototype.addOperator=function(t){const e=this.getSupportedOperators();let r=t;if(typeof t!=="string"){r=t.name}if(e.indexOf(r)<0){e.push(r);this.setOperators(e)}return this};n.prototype.addOperators=function(t){if(!Array.isArray(t)){t=[t]}t.forEach(function(t){this.addOperator(t)}.bind(this));return this};n.prototype.removeOperator=function(t){const e=this.getSupportedOperators();let r=t;if(typeof t!=="string"){r=t.name}if(e.indexOf(r)>-1){e.splice(e.indexOf(r),1);this.setOperators(e)}};n.prototype.removeOperators=function(t){if(!Array.isArray(t)){t=[t]}t.forEach(function(t){this.removeOperator(t)}.bind(this))};n.prototype.removeAllOperators=function(){this.setOperators([])};n.prototype.setDefaultOperator=function(t){let e=t;if(t&&typeof t!=="string"){e=t.name}this.setProperty("defaultOperator",e);return this};n.prototype.checkCreateInternalContent=function(){if(!this.isFieldDestroyed()&&!this.isPropertyInitial("dataType")){const e=this._getValueHelp();const i=sap.ui.getCore().byId(e);const o=this.getBindingInfo("conditions");const n=this.getBinding("conditions");if(this.getDisplay()!==r.Value&&e&&(!i||o&&!n)){return}t.prototype.checkCreateInternalContent.apply(this,arguments)}};n.prototype.handleModelContextChange=function(e){t.prototype.handleModelContextChange.apply(this,arguments);if(this.getCurrentContent().length===0){this.triggerCheckCreateInternalContent()}};n.prototype.isSearchField=function(){if(this.isPropertyInitial("propertyKey")){return t.prototype.isSearchField.apply(this,arguments)}else{const t=this.getPropertyKey();const e=new RegExp("^\\*(.*)\\*|\\$search$");return e.test(t)&&this.getMaxConditions()===1}};function p(t){if(!t){this.getContentFactory().setAdditionalDataType()}else if(t.isA&&t.isA("sap.ui.model.Type")){this.getContentFactory().setAdditionalDataType(t)}else if(t.name){this.getContentFactory().setAdditionalDataType()}else{throw new Error("invalid type configuration")}}n.prototype.getAdditionalDataTypeConfiguration=function(){return this.getAdditionalDataType()};return n});
//# sourceMappingURL=FilterField.js.map