/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/field/FieldInfoBase","sap/ui/thirdparty/jquery","sap/ui/model/BindingMode","sap/ui/model/json/JSONModel","sap/ui/mdc/link/Log","sap/base/Log","sap/ui/mdc/link/Panel","sap/ui/mdc/link/PanelItem","sap/ui/layout/form/SimpleForm","sap/ui/core/Title","sap/ui/layout/library","sap/ui/mdc/enums/LinkType"],function(t,jQuery,e,n,i,o,r,s,a,l,d,u){"use strict";const c=d.form.SimpleFormLayout.ResponsiveGridLayout;const p=t.extend("sap.ui.mdc.Link",{metadata:{library:"sap.ui.mdc",properties:{enablePersonalization:{type:"boolean",defaultValue:true},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/LinkDelegate",payload:{}}}},associations:{sourceControl:{type:"sap.ui.core.Control",multiple:false}}}});p.prototype.applySettings=function(){t.prototype.applySettings.apply(this,arguments);this.initControlDelegate()};p.prototype.init=function(){const i=new n({contentTitle:undefined,linkItems:[]});i.setDefaultBindingMode(e.TwoWay);i.setSizeLimit(1e3);this.setModel(i,"$sapuimdcLink");this.attachEvent("modelContextChange",this.fireDataUpdate,this);this._oLinkType=null;this._bLinkItemsFetched=false;this._aLinkItems=[];t.prototype.init.apply(this,arguments)};p.prototype.exit=function(){this._bLinkItemsFetched=undefined;this._oLinkType=undefined;this._oUseDelegateItemsPromise=undefined;this._oUseDelegateAdditionalContentPromise=undefined;if(this._aLinkItems){this._aLinkItems.forEach(function(t){t.destroy()});this._aLinkItems=undefined}if(this._aAdditionalContent){this._aAdditionalContent.forEach(function(t){t.destroy()});this._aAdditionalContent=undefined}t.prototype.exit.apply(this,arguments)};p.prototype.isTriggerable=function(){return this.retrieveLinkType().then(function(t){if(!t){return false}const e=t.runtimeType;const n=t.initialType?t.initialType:t;if(e&&e instanceof Promise){e.then(function(t){if(!this._oLinkType||t.linkType!==this._oLinkType.linkType){this._oLinkType=t;this.fireDataUpdate()}}.bind(this))}return this._oLinkType?this._oLinkType.type===u.DirectLink||this._oLinkType.type===u.Popover:n.type===u.DirectLink||n.type===u.Popover}.bind(this))};p.prototype.getTriggerHref=function(){return this.getDirectLinkHrefAndTarget().then(function(t){return t?t.href:null})};p.prototype.getDirectLinkHrefAndTarget=function(){return this._retrieveDirectLinkItem().then(function(t){if(this.isDestroyed()){return null}this.addDependent(t);return t?{target:t.getTarget(),href:t.getHref()}:null}.bind(this))};p.prototype._retrieveDirectLinkItem=function(){return this.retrieveLinkType().then(function(t){if(!t){return null}if(this._linkTypeHasDirectLink(this._oLinkType)){return this._oLinkType.directLink}const e=t.initialType?t.initialType:t;if(this._linkTypeHasDirectLink(e)){return e.directLink}return null}.bind(this))};p.prototype._linkTypeHasDirectLink=function(t){return t&&t.type===u.DirectLink&&t.directLink};p.prototype.getContent=function(t){const e=this.retrieveLinkItems();const i=this.retrieveAdditionalContent();return Promise.all([e,i]).then(function(e){const i=e[0];const o=e[1];return new Promise(function(e){sap.ui.require(["sap/ui/fl/Utils","sap/ui/fl/apply/api/FlexRuntimeInfoAPI"],function(a,l){this._setConvertedLinkItems(i);const d=this._getInternalModel().getProperty("/linkItems");const u=this._getInternalModel().getProperty("/baselineLinkItems");const c=!o.length&&!d.length?this._getNoContent():o;const p=this._createPanelId(a,l);const h=sap.ui.getCore().byId(p);if(h){if(h.getParent()&&h.getParent().close){h.getParent().close()}h.destroy()}const f=new r(p,{enablePersonalization:this.getEnablePersonalization(),items:u.map(function(t){return new s(t.key,{text:t.text,description:t.description,href:t.href,internalHref:t.internalHref,target:t.target,icon:t.icon,visible:true})}),additionalContent:c,beforeSelectionDialogOpen:function(){if(t&&t()){t().setModal(true)}},afterSelectionDialogClose:function(){if(t&&t()){t().setModal(false)}},beforeNavigationCallback:this._beforeNavigationCallback.bind(this),metadataHelperPath:"sap/ui/mdc/Link"});f.setModel(new n({metadata:jQuery.extend(true,[],this._getInternalModel().getProperty("/linkItems")),baseline:jQuery.extend(true,[],this._getInternalModel().getProperty("/baselineLinkItems"))}),"$sapuimdcLink");this._setAdditionalContent(undefined);return e(f)}.bind(this))}.bind(this))}.bind(this))};p.prototype.checkDirectNavigation=function(){const t=this.retrieveLinkItems();const e=this.retrieveAdditionalContent();return Promise.all([t,e]).then(function(t){const e=t[0];const n=t[1];this._setConvertedLinkItems(e);const i=this._getInternalModel().getProperty("/linkItems");if(i.length===1&&!n.length){r.navigate(i[0].href);return Promise.resolve(true)}return Promise.resolve(false)}.bind(this))};p.prototype._setConvertedLinkItems=function(t){const e=this._getInternalModel();const n=t.map(function(t){if(!t.getKey()){o.error("sap.ui.mdc.Link: undefined 'key' property of the LinkItem "+t.getId()+". The mandatory 'key' property should be defined due to personalization reasons.")}return{key:t.getKey(),text:t.getText(),description:t.getDescription(),href:t.getHref(),internalHref:t.getInternalHref(),target:t.getTarget(),icon:t.getIcon(),initiallyVisible:t.getInitiallyVisible(),visible:false}});e.setProperty("/linkItems/",n);const i=n.filter(function(t){return t.initiallyVisible});e.setProperty("/baselineLinkItems/",i)};p.prototype._getNoContent=function(){const t=new a({layout:c,content:[new l({text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("info.POPOVER_MSG_NO_CONTENT")})]});t.addStyleClass("mdcbaseinfoPanelDefaultAdditionalContent");return t};p.prototype._createPanelId=function(t,e){let n;if(this.getParent()){n=this.getParent()}let i=this._getSourceControl();if(!i){this.setSourceControl(n);i=n}if(!e.isFlexSupported({element:this})||!e.isFlexSupported({element:i})){o.error("Invalid component. The mandatory 'sourceControl' association should be assigned to the app component due to personalization reasons.");return this.getId()+"-idInfoPanel"}const r=t.getAppComponentForControl(i)||t.getAppComponentForControl(n);return r.createId("idInfoPanel")};p.retrieveAllMetadata=function(t){if(!t.getModel||!t.getModel("$sapuimdcLink")){return[]}const e=t.getModel("$sapuimdcLink");return e.getProperty("/metadata").map(function(t){return{id:t.key,text:t.text,description:t.description,href:t.href,internalHref:t.internalHref,target:t.target,visible:t.visible}})};p.retrieveBaseline=function(t){if(!t.getModel||!t.getModel("$sapuimdcLink")){return[]}const e=t.getModel("$sapuimdcLink");return e.getProperty("/baseline").map(function(t){return{id:t.key,visible:true}})};p.prototype._getInfoLog=function(){if(this.getPayload()&&this.getPayload().semanticObjects){if(this._oInfoLog){return this._oInfoLog}if(o.getLevel()>=o.Level.INFO){this._oInfoLog=new i;this._oInfoLog.initialize(this.getPayload().semanticObjects,this._getContextObject(this._getControlBindingContext()));return this._oInfoLog}}return undefined};p.prototype._getContextObject=function(t){return t?t.getObject(t.getPath()):undefined};p.prototype.retrieveAdditionalContent=function(){if(this._aAdditionalContent){return Promise.resolve(this._aAdditionalContent)}else{this._oUseDelegateAdditionalContentPromise=this._useDelegateAdditionalContent();return this._oUseDelegateAdditionalContentPromise.then(function(){return Promise.resolve(this._aAdditionalContent)}.bind(this))}};p.prototype._useDelegateAdditionalContent=function(){if(this.awaitControlDelegate()){return this.awaitControlDelegate().then(function(){return new Promise(function(t){this.getControlDelegate().fetchAdditionalContent(this,this).then(function(e){this._setAdditionalContent(e===null?[]:e);t()}.bind(this))}.bind(this))}.bind(this))}o.error("mdc.Link retrieveAdditionalContent: control delegate is not set - could not load AdditionalContent from delegate.");return Promise.resolve([])};p.prototype._setAdditionalContent=function(t){this._aAdditionalContent=t};p.prototype.retrieveLinkType=function(){if(this.awaitControlDelegate()){return this.awaitControlDelegate().then(function(){return this._bIsBeingDestroyed?Promise.resolve():this.getControlDelegate().fetchLinkType(this)}.bind(this))}o.error("mdc.Link retrieveLinkType: control delegate is not set - could not load LinkType from delegate.");return Promise.resolve(null)};p.prototype.retrieveLinkItems=function(){const t=this._getControlBindingContext();return this._retrieveUnmodifiedLinkItems().then(function(e){return this.getControlDelegate().modifyLinkItems(this,t,e).then(function(t){return t})}.bind(this))};p.prototype._retrieveUnmodifiedLinkItems=function(){if(this._bLinkItemsFetched){return Promise.resolve(this._aLinkItems)}else{this._oUseDelegateItemsPromise=this._useDelegateItems();return this._oUseDelegateItemsPromise.then(function(){return Promise.resolve(this._aLinkItems)}.bind(this))}};p.prototype._useDelegateItems=function(){if(this.awaitControlDelegate()){return this.awaitControlDelegate().then(function(){const t=this._getControlBindingContext();const e=this._getInfoLog();return new Promise(function(n){this.getControlDelegate().fetchLinkItems(this,t,e).then(function(t){this._setLinkItems(t===null?[]:t);this._bLinkItemsFetched=t!==null;n()}.bind(this))}.bind(this))}.bind(this))}o.error("mdc.Link _useDelegateItems: control delegate is not set - could not load LinkItems from delegate.");return Promise.resolve()};p.prototype._setLinkItems=function(t){const e=t.filter(function(t){return t.getParent()===null});e.forEach(function(t){this.addDependent(t)}.bind(this));this._aLinkItems=t};p.prototype._beforeNavigationCallback=function(t){if(this.awaitControlDelegate()){return this.getControlDelegate().beforeNavigationCallback(this,t)}o.error("mdc.Link _beforeNavigationCallback: control delegate is not set - could not load beforeNavigationCallback from delegate.");return Promise.resolve()};p.prototype._getControlBindingContext=function(){const t=this._getSourceControl();return t&&t.getBindingContext()||this.getBindingContext()};p.prototype._getInternalModel=function(){return this.getModel("$sapuimdcLink")};p.prototype._getSourceControl=function(){return typeof this.getSourceControl()==="string"?sap.ui.getCore().byId(this.getSourceControl()):this.getSourceControl()};return p});
//# sourceMappingURL=Link.js.map