/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/model/SimpleType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/type/String","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/ConditionValidateException","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/ConditionValidated","sap/base/util/merge","sap/base/strings/whitespaceReplacer","sap/ui/base/SyncPromise"],function(t,e,n,i,a,s,o,l,r,u,c,f,d,h,p,m){"use strict";const g="sap.ui.mdc.raw";const y="sap.ui.mdc.raw:";const v=t.extend("sap.ui.mdc.field.ConditionType",{constructor:function(e,n){t.apply(this,arguments);this.sName="Condition";this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._oCalls={active:0,last:0,condition:undefined,exception:undefined}}});v.prototype.destroy=function(){t.prototype.destroy.apply(this,arguments);if(this._oDefaultType){this._oDefaultType.destroy();delete this._oDefaultType}this._bDestroyed=true};v.prototype.formatValue=function(t,n){if(t==undefined||t==null||this._bDestroyed){return null}if(typeof t!=="object"||!t.operator||!t.values||!Array.isArray(t.values)){throw new e("No valid condition provided")}if(!n){n="string"}let i=b.call(this);const a=P.call(this);const o=Q(i);const l=this.oFormatOptions.preventGetDescription;B.call(this,t,i);let u,c,f,p,y;switch(this.getPrimitiveType(n)){case"string":case"any":u=T.call(this);c=E.call(this);f=r.getEQOperator(c);if(!this.oFormatOptions.maxConditions||this.oFormatOptions.maxConditions===1){this._oCalls.active++;this._oCalls.last++}p=this._oCalls.last;if(!l&&u!==s.Value&&t.validated===d.Validated&&(o||t.operator===f.name&&!t.values[1])){const n=this.oFormatOptions.bindingContext;const s=o?t.values[0][1]:t.values[0];return m.resolve().then(function(){return K.call(this,s,t,i,a,n)}.bind(this)).then(function(e){if(e){t=h({},t);if(o){i=x.call(this);t.operator=f.name;if(typeof e!=="object"){e={key:s,description:e}}}if(typeof e==="object"){t=R.call(this,t,e)}else if(t.values.length===1){t.values.push(e)}else{t.values[1]=e}}return O.call(this,t,undefined,p,true,i,a)}.bind(this)).catch(function(n){let s;if(!(n instanceof e)||!q.call(this)){s=n}return O.call(this,t,s,p,true,i,a)}.bind(this)).unwrap()}return O.call(this,t,undefined,p,true,i,a);default:y=G(n);if(y>=0){if(I.call(this,i)){return t.values.length>=1?t.values[0][y]:null}}else if(n===g){return t.values.length>=1?t.values[0]:null}else if(i&&t.values.length>=1){return i.formatValue(t.values[0],n)}throw new e("Don't know how to format Condition to "+n)}};function C(t,n,i){const a=T.call(this);const l=Q(n);if(l&&t.values.length>1&&t.values[0][1]===t.values[1][1]){t=h({},t);t.operator=o.EQ;t.values.splice(1)}const u=this.oFormatOptions.hideOperator&&t.values.length===1||l;const c=r.getOperator(t.operator);const d=A.call(this);const m=k.call(this);if(!c){throw new e("No valid condition provided, Operator wrong.")}let g=c.format(t,n,a,u,d,i,m);const y=this.oFormatOptions.convertWhitespaces;if(y&&(j.call(this,n)===f.String||a!==s.Value)){g=p(g)}return g}function O(t,e,n,i,a,s){if(this._oCalls.active>0){this._oCalls.active--}if(n<this._oCalls.last&&(this._oCalls.condition!==undefined||this._oCalls.exception!==undefined)){t=this._oCalls.condition;e=this._oCalls.exception}if(n===this._oCalls.last&&this._oCalls.active>0){this._oCalls.condition=h({},t);this._oCalls.exception=e}else if(this._oCalls.active===0&&this._oCalls.last>0){this._oCalls={active:0,last:0,condition:undefined,exception:undefined}}if(e){throw e}let o;if(i){o=C.call(this,t,a,s)}else{o=V.call(this,t,a)}return o}v.prototype.parseValue=function(t,e){const n=L.call(this);if(!e){e="string"}else if(e==="any"&&typeof t==="string"){e="string"}return this._parseValue(t,e,n)};v.prototype._parseValue=function(t,e,i){if(this._bDestroyed){return null}const a=this.oFormatOptions.navigateCondition;if(a){const n=this.formatValue(a,e);if(n===t){return h({},a)}}const s=T.call(this);const o=b.call(this);const l=D.call(this);const c=E.call(this);const f=Q(o);let p;if(t===null||t===undefined||t===""&&!i){if(!I.call(this,o)){return null}}M.call(this,o);let m,y,v;switch(this.getPrimitiveType(e)){case"string":m;y=false;v=false;if(c.length===1){m=r.getOperator(c[0]);v=true}else{const e=r.getMatchingOperators(c,t);if(e.length===0){m=W.call(this,c,o);if(i&&!I.call(this,o)){const t=r.getEQOperator(c);if(c.indexOf(t.name)>=0){y=!!m&&m.name!==t.name;m=t}}v=true}else{const t=e.filter(function(t){return t.valueTypes.length===0});if(t.length>=1){m=t[0]}else{m=e[0]}}}if(m){if(f&&m!==r.getEQOperator(c)){throw new n("unsupported operator")}let e;const a=I.call(this,o);const h=A.call(this);const p=P.call(this);const g=k.call(this);this._oCalls.active++;this._oCalls.last++;const C=this._oCalls.last;if((!a||f)&&m.validateInput&&i){e=w.call(this,m,t,o,p,v,y,c,s,true);if(e instanceof Promise){return U.call(this,e)}else{return e}}else{try{if(t===""&&a&&v){e=u.createCondition(m.name,[o.parseValue(t,"string",o._aCurrentValue)],undefined,undefined,d.NotValidated)}else{e=m.getCondition(t,o,s,v,h,p,g)}}catch(e){let i=e;if(i instanceof n&&l&&!a){try{l.parseValue(t,"string",l._aCurrentValue)}catch(t){i=t}}return O.call(this,undefined,i,C,false,o)}}if(e){return O.call(this,e,undefined,C,false,o)}}throw new n("Cannot parse value "+t);default:if(o){if(c.length===1){p=c[0]}else{p=W.call(this,c,o).name;if(c.indexOf(p)<0){p=undefined}}if(p){const n=G(e);if(n>=0){if(I.call(this,o)){const e=h([],o._aCurrentValue);e[n]=t;return u.createCondition(p,[e],undefined,undefined,d.NotValidated)}}else if(e===g){return u.createCondition(p,[t],undefined,undefined,d.NotValidated)}else{return u.createCondition(p,[o.parseValue(t,e)],undefined,undefined,d.NotValidated)}}}throw new n("Don't know how to parse Condition from "+e)}};function V(t,e){const n=Q(e);const i=I.call(this,e);if(t&&!n&&i){const n=D.call(this)||e;const i=n.getMetadata().getName();const a=n.getFormatOptions();const s=n.getConstraints();const l=this.oFormatOptions.delegate;const r=this.oFormatOptions.control;const u=l&&l.getTypeMap(r).getBaseType(i,a,s);if((u===f.Unit||u===f.DateTime)&&!t.values[0][1]&&e._aCurrentValue){const n=e._aCurrentValue[1]===undefined?null:e._aCurrentValue[1];t.values[0][1]=n;if(t.operator===o.BT){t.values[1][1]=n}}}B.call(this,t,e);return t}function w(t,a,r,c,f,h,p,g,y){let v;let C;let V=true;let T=false;let b;let P;const D=this.oFormatOptions.bindingContext;let N;if(a===""){N=[];v=a;b=a}else{N=t.getValues(a,g,f);v=y?N[0]:N[1];C=y?N[1]:N[0];T=g!==s.Value;b=v||C}const E=function(i){if(i&&!(i instanceof n)&&!(i instanceof e)){throw i}if(!i._bNotUnique){if(a===""){return null}if(y&&N[0]&&N[1]){return w.call(this,t,a,r,c,f,h,p,g,false)}if(h){return _.call(this,r,p,a,g)}}if(q.call(this)){return F.call(this,r,p,a,g)}throw new n(i.message)};const S=function(e){if(e){const n=[e.key];if(t.valueTypes.length>1&&t.valueTypes[1]!==l.Static){n.push(e.description)}return u.createCondition(t.name,n,e.inParameters,e.outParameters,d.Validated,e.payload)}else if(a===""){return null}else{return E.call(this,new n(this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[a])))}};const I=this._oCalls.last;const B=function(e,i){let s;let l;try{s=i.call(this,e);if(Q(r)){if(s){if(s.operator!==o.EQ){throw new n("unsupported operator")}const t=r._aCurrentValue&&r._aCurrentValue[0]!==undefined?r._aCurrentValue[0]:null;const e=s.values[0];s.values=[[t,e]]}else if(a===""){s=u.createCondition(t.name,[r.parseValue(a,"string",r._aCurrentValue)],undefined,undefined,d.NotValidated)}}}catch(t){l=t}return O.call(this,s,l,I,false,r)};const M=function(t,e,a,s){let o;try{if(Q(t)){const t=e&&e.length>1?e[1]:x.call(this);o=t.parseValue(a,"string");t.validateValue(o)}else{o=t.parseValue(a,"string");t.validateValue(o)}}catch(t){if(t&&!(s&&(t instanceof n||t instanceof i))){throw t}o=undefined}return o}.bind(this);const R=M(r,A.call(this),v||b,T);V=R!==undefined;if(T){P=M(c,k.call(this),C||b,V);T=P!==undefined}return m.resolve().then(function(){return z.call(this,b,R,P,r,c,D,V,T)}.bind(this)).then(function(t){return B.call(this,t,S)}.bind(this)).catch(function(t){return B.call(this,t,E)}.bind(this)).unwrap()}function _(t,e,n,i){const a=W.call(this,e,t);let o;if(a&&e.indexOf(a.name)>=0){o=a.getCondition(n,t,s.Value,true);o.validated=d.NotValidated}return o}function F(t,e,i,a){let o;if(Q(t)){o=r.getEQOperator()}else if(e.length===1){o=r.getOperator(e[0])}else{o=r.getEQOperator(e);if(e.indexOf(o.name)<0){o=undefined}}if(!o){throw new n("Cannot parse value "+i)}const l=o.getCondition(i,t,s.Value,true);if(l){l.validated=d.NotValidated;if(Q(t)&&Array.isArray(l.values[0])){l.values[0]=l.values[0][1]}}return l}v.prototype.validateValue=function(t){const e=b.call(this);const n=D.call(this);const a=E.call(this);const s=Q(e);const o=I.call(this,e);const l=A.call(this);let u=0;const f=P.call(this);const d=k.call(this);if(t===undefined||this._bDestroyed){return null}else if(t===null){if(r.onlyEQ(a)){let t=null;try{if(e.hasOwnProperty("_sParsedEmptyString")&&e._sParsedEmptyString!==null){t=e._sParsedEmptyString}e.validateValue(t)}catch(e){if(e instanceof i){try{if(n&&!o){n.validateValue(t)}throw e}catch(t){if(t instanceof i){throw new c(t.message,t.violatedConstraints,null)}throw t}}else{return null}}}return null}if(typeof t!=="object"||!t.operator||!t.values||!Array.isArray(t.values)){throw new c(this._oResourceBundle.getText("field.VALUE_NOT_VALID"),undefined,typeof t==="object"?h({},t):t)}let p=r.getOperator(t.operator);if(s){p=r.getEQOperator();u=1}if(!p||a.indexOf(p.name)===-1){throw new c("No valid condition provided, Operator wrong.",undefined,h({},t))}try{p.validate(t.values,e,l,u,f,d)}catch(e){try{if(e instanceof i&&n&&!o){p.validate(t.values,n,l,u,f,d)}throw e}catch(e){if(e instanceof i){throw new c(e.message,e.violatedConstraints,h({},t))}throw e}}};function T(){let t=this.oFormatOptions.display;if(!t){t=s.Value}return t}function b(){let t=this.oFormatOptions.valueType;if(!t){t=x.call(this)}return t}function P(){let t=this.oFormatOptions.additionalValueType;if(!t){t=x.call(this)}return t}function x(){if(!this._oDefaultType){this._oDefaultType=new a}return this._oDefaultType}function D(){return this.oFormatOptions.originalDateType}function N(){return this.oFormatOptions.additionalType}function E(){let t=this.oFormatOptions.operators;if(!t||t.length===0){t=r.getOperatorsForType(f.String)}return t}function S(){const t=this.oFormatOptions.valueHelpID;if(t){const e=sap.ui.getCore().byId(t);if(e&&e.isValidationSupported()){return e}}return null}function I(t){return t&&t.isA("sap.ui.model.CompositeType")}function A(){return this.oFormatOptions.compositeTypes}function k(){return this.oFormatOptions.ASdditionalCompositeTypes}function Q(t){if(I(t)){const e=t.getFormatOptions();const n=!e||!e.hasOwnProperty("showMeasure")||e.showMeasure;const i=!e||!e.hasOwnProperty("showNumber")||e.showNumber;const a=!e||!e.hasOwnProperty("showTimezone")||e.showTimezone;const s=!e||!e.hasOwnProperty("showDate")||e.showDate;const o=!e||!e.hasOwnProperty("showTime")||e.showTime;if(n&&!i||a&&!s&&!o){return true}}return false}function B(t,e){if(I.call(this,e)&&t&&t.values[0]){e._aCurrentValue=h([],t.values[0]);const n=N.call(this);if(I.call(this,n)){n._aCurrentValue=h([],t.values[0])}const i=D.call(this);if(I.call(this,i)){i._aCurrentValue=h([],t.values[0])}}}function M(t){if(I.call(this,t)){const e=N.call(this);if(I.call(this,e)){if(!e._aCurrentValue){e._aCurrentValue=[]}t._aCurrentValue=e._aCurrentValue}}}function R(t,e){t.values=[e.key,e.description];if(e.inParameters){t.inParameters=e.inParameters}if(e.outParameters){t.outParameters=e.outParameters}if(e.payload){t.payload=e.payload}return t}function U(t){if(this.oFormatOptions.asyncParsing){this.oFormatOptions.asyncParsing(t)}return t}function j(t){const e=t.getMetadata().getName();const n=t.getFormatOptions();const i=t.getConstraints();const a=this.oFormatOptions.delegate;const s=this.oFormatOptions.control;let o=a?a.getTypeMap(s).getBaseType(e,n,i):f.String;if(o===f.Unit){o=f.Numeric}return o}function L(){const t=S.call(this);const e=this.oFormatOptions.delegate;if(e){return e.isInputValidationEnabled(this.oFormatOptions.control,t)}else{return!!t}}function q(){const t=S.call(this);const e=this.oFormatOptions.delegate;if(e){return e.isInvalidInputAllowed(this,t)}else if(t){return!t.getValidateInput()}else{return true}}function z(t,e,i,a,s,o,l,r){const u=S.call(this);const c=this.oFormatOptions.delegate;const f=this.oFormatOptions.control;const d={value:t,parsedValue:e,parsedDescription:i,dataType:a,bindingContext:o,checkKey:l,checkDescription:r,exception:n,control:f};if(c){return c.getItemForValue(f,u,d)}else if(u){return u.getItemForValue(d)}}function K(t,n,i,a,s){const o=S.call(this);const l=this.oFormatOptions.delegate;const r=this.oFormatOptions.control;if(l){return l.getDescription(r,o,t,n.inParameters,n.outParameters,s,undefined,undefined,n.payload,r,i)}else if(o){const a={value:t,parsedValue:t,parsedDescription:undefined,dataType:i,context:{inParameters:n.inParameters,outParameters:n.outParameters,payload:n.payload},bindingContext:s,checkKey:true,checkDescription:false,caseSensitive:true,exception:e,control:r};return o.getItemForValue(a)}}function W(t,e){const n=this.oFormatOptions.defaultOperatorName;let i;if(n){i=r.getOperator(n)}else{i=r.getDefaultOperator(j.call(this,e))}if(i&&t.indexOf(i.name)<0){for(let e=0;e<t.length;e++){i=r.getOperator(t[e]);if(i.exclude||!i.hasRequiredValues()){i=undefined}else{break}}}return i}function G(t){let e=-1;if(t.startsWith(y)){e=parseInt(t[y.length])}return e}return v});
//# sourceMappingURL=ConditionType.js.map