/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/field/ConditionType","sap/ui/mdc/condition/ConditionValidateException","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/field/splitValue","sap/ui/mdc/enums/OperatorName","sap/ui/model/SimpleType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/base/util/merge","sap/ui/base/SyncPromise"],function(t,e,n,o,i,s,r,a,l,u,p){"use strict";const h=s.extend("sap.ui.mdc.field.ConditionsType",{constructor:function(e,n){s.apply(this,arguments);this.sName="Conditions";e=c(e);this._oConditionType=new t(e,this.oConstraints);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc")}});h.prototype.destroy=function(){s.prototype.destroy.apply(this,arguments);if(this._oConditionType){this._oConditionType.destroy();this._oConditionType=undefined}this._bDestroyed=true};h.prototype.setFormatOptions=function(t){s.prototype.setFormatOptions.apply(this,arguments);t=c(t);if(this._oConditionType){this._oConditionType.setFormatOptions(t)}};function c(t){t=u({},t);if(t.asyncParsing){delete t.asyncParsing}return t}h.prototype.setConstraints=function(t){s.prototype.setConstraints.apply(this,arguments);if(this._oConditionType){this._oConditionType.setConstraints(this.oConstraints)}};h.prototype.formatValue=function(t,e){if(t==undefined||t==null||this._bDestroyed){return null}if(!Array.isArray(t)){throw new r("No valid conditions provided")}let n;if(!e||e==="string"||e==="any"){n=""}else if(e==="float"||e==="int"){n=0}if(T.call(this)){return v.call(this)||n}const o=O.call(this);const i=[];const s=function(t,e){return p.resolve().then(function(){return this._oConditionType.formatValue(t,e)}.bind(this))};for(let n=0;n<t.length;n++){i.push(s.call(this,t[n],e));if(o>0&&n>=o-1){break}}return p.all(i).then(function(t){return f.call(this,t,n)}.bind(this)).unwrap()};function f(t,e){for(let n=0;n<t.length;n++){if(e){e=e+this._oResourceBundle.getText("field.SEPARATOR")+t[n]}else{e=t[n]}}return e}h.prototype.parseValue=function(t,e){if(this._bDestroyed){return null}if(T.call(this)&&t===""){return this.oFormatOptions.getConditions?this.oFormatOptions.getConditions():[]}return this._parseValueToIndex(t,e,-1)};h.prototype._parseValueToIndex=function(t,e,n){const s=this.oFormatOptions.operators||[];const r=s.indexOf(i.BT)>=0||s.length===0;const a=F.call(this);const l=a?[t]:o(t,!r);if(l.length>1||r&&l.length===1&&typeof l[0]==="string"&&l[0].search(/\t/)>=0){return m.call(this,l,e,n)}else{return d.call(this,t,e,n)}};function d(t,e,n){const o=function(t,e){return this._oConditionType.parseValue(t,e)};const i=function(t){throw t};return y.call(this,[t],e,n,o,i)}function m(t,e,o){const s=this.oFormatOptions.operators||[];const r=s.indexOf(i.BT)>=0||s.length===0;const l=r&&n.getOperator(i.BT);const u=function(t,e){return p.resolve().then(function(){t=t.trim();if(r){const e=t.split(/\t/g);if(e.length==2&&e[0]&&e[1]){t=l.tokenFormat;for(let n=0;n<2;n++){t=t.replace(new RegExp("\\{"+n+"\\}","g"),e[n])}}}return this._oConditionType._parseValue(t,"string",false)}.bind(this))};const h=function(t){if(t instanceof a){throw new a(this._oResourceBundle.getText("field.PASTE_ERROR"))}throw t};return y.call(this,t,e,o,u,h)}function y(t,e,n,o,i){const s=[];for(let n=0;n<t.length;n++){s.push(o.call(this,t[n],e))}const r=p.all(s).then(function(t){let e=this.oFormatOptions.getConditions&&this.oFormatOptions.getConditions();for(let o=0;o<t.length;o++){e=g.call(this,t[o],e,n);if(n>=0){n++}}return e}.bind(this)).catch(function(t){i.call(this,t)}.bind(this)).unwrap();if(r instanceof Promise&&this.oFormatOptions.asyncParsing){this.oFormatOptions.asyncParsing(r)}return r}function g(t,e,o){const s=w(this.oFormatOptions.valueType);const r=O.call(this);if(r!==1&&this.oFormatOptions.getConditions){if(t){if(C(this.oFormatOptions.valueType)&&!s&&e.length===1&&(e[0].values[0][0]===null||e[0].values[0][0]===undefined||e[0].values[0][1]===null||e[0].values[0][1]===undefined)&&(t.values[0][0]!==null&&t.values[0][0]!==undefined&&t.values[0][1]!==null&&t.values[0][1]!==undefined)){e.splice(0,1)}if(n.indexOfCondition(t,e)===-1){if(o>=0&&e.length>o){e.splice(o,0,t)}else{e.push(t)}}else{throw new a(this._oResourceBundle.getText("field.CONDITION_ALREADY_EXIST",[t.values[0]]))}if(r>0&&r<e.length){e.splice(0,e.length-r)}}return e}else if(s&&this.oFormatOptions.getConditions&&e.length>1){const n=t&&t.values[0][1];const o=t&&t.inParameters;const s=t&&t.outParameters;const r=t&&t.payload;for(let a=0;a<e.length;a++){e[a].values[0][1]=n;if(n===undefined){e[a].values[0][0]=t.values[0][0]}e[a].values[0].splice(2);if(e[a].operator===i.BT){e[a].values[1][1]=n;if(n===undefined){e[a].values[1][0]=t.values[0][0]}e[a].values[1].splice(2)}if(o||e[a].inParameters){e[a].inParameters=o}if(s||e[a].outParameters){e[a].outParameters=s}if(r||e[a].payload){e[a].payload=r}}if(e.length===0){e.push(t)}return e}else if(t){return[t]}else{return[]}}h.prototype.validateValue=function(t){if(t===undefined||t===null||this._bDestroyed){return}if(!Array.isArray(t)){throw new e("No valid conditions provided",undefined,undefined,t)}let n;try{for(let e=0;e<t.length;e++){n=t[e];this._oConditionType.validateValue(n)}const e=O.call(this);if(t.length===0&&e===1){this._oConditionType.validateValue(null)}}catch(o){if(o instanceof e){o.setConditions(t)}else if(o instanceof l){throw new e(o.message,o.violatedConstraints,u({},n))}throw o}};function O(){let t=1;if(this.oFormatOptions.hasOwnProperty("maxConditions")){t=this.oFormatOptions.maxConditions}return t}function w(t){if(C(t)){const e=t.getFormatOptions();const n=!e||!e.hasOwnProperty("showMeasure")||e.showMeasure;const o=!e||!e.hasOwnProperty("showNumber")||e.showNumber;const i=!e||!e.hasOwnProperty("showTimezone")||e.showTimezone;const s=!e||!e.hasOwnProperty("showDate")||e.showDate;const r=!e||!e.hasOwnProperty("showTime")||e.showTime;if(n&&!o||i&&!s&&!r){return true}}return false}function C(t){return t&&t.isA("sap.ui.model.CompositeType")}function T(){let t=false;if(this.oFormatOptions.hasOwnProperty("noFormatting")){t=this.oFormatOptions.noFormatting}return t}function v(){if(this.oFormatOptions.hasOwnProperty("keepValue")){return this.oFormatOptions.keepValue}return null}function F(){if(this.oFormatOptions.hasOwnProperty("multipleLines")){return this.oFormatOptions.multipleLines}return false}return h});
//# sourceMappingURL=ConditionsType.js.map