/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/field/ConditionsType","sap/ui/mdc/condition/ConditionValidateException","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/condition/Condition","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/util/DateUtil","sap/ui/model/SimpleType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/m/library","sap/base/util/merge"],function(e,t,o,i,n,a,s,r,l,p,u,c,d,f){"use strict";const y=e.extend("sap.ui.mdc.field.DynamicDateRangeConditionsType",{constructor:function(e,t){l.apply(this,arguments);this.sName="ConditionsDateRange";this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc")}});y.prototype.destroy=function(){l.prototype.destroy.apply(this,arguments);this._bDestroyed=true};y.prototype.formatValue=function(e,t){if(e==undefined||e==null||this._bDestroyed){return null}if(!Array.isArray(e)){throw new p("No valid conditions provided")}const i=h.call(this);let n;if(i!==1){throw new p("MaxConditions must be 1")}if(e.length===1){const t=e[0];const i=o.getOperator(t.operator);if(!t.operator||!i){throw new p("No valid condition provided, Operator wrong.")}const l=[];const u=T.call(this);let c=o.getDynamicDateOptionForOperator(i,d.StandardDynamicDateRangeKeys,u);for(let e=0;e<i.valueTypes.length;e++){if(i.valueTypes[e]&&i.valueTypes[e]!==s.Static){if(c){if(i.valueTypes[e]===s.Self){l.push(r.typeToDate(t.values[e],m.call(this),u))}else{const o=g.call(this,i.valueTypes[e]);if(o===a.Date||o===a.DateTime){l.push(r.typeToDate(t.values[e],O.call(this,i,e),o))}else{l.push(t.values[e])}}}else{l.push(t.values[e])}}}if(!c){c=o.getCustomDynamicDateOptionForOperator(i,u)}n={operator:c,values:l}}return n};y.prototype.parseValue=function(e,t){if(this._bDestroyed){return null}if(h.call(this)!==1){throw new u("Only one condition supported for parsing")}const l=v.call(this);const p=[];if(e&&e.operator){if(e.operator==="PARSEERROR"){throw new u(e.values[0])}const t=e.operator;const c=o.getOperatorForDynamicDateOption(t,T.call(this));if(c){const u=T.call(this);const f=[];for(let o=0;o<c.valueTypes.length;o++){if(c.valueTypes[o]&&c.valueTypes[o]!==s.Static){if(d.StandardDynamicDateRangeKeys[t]){if(c.valueTypes[o]===s.Self){f.push(r.dateToType(e.values[o],m.call(this),u))}else{const t=c.valueTypes[o]===s.Self?u:g.call(this,c.valueTypes[o]);if(t===a.Date||t===a.DateTime){f.push(r.dateToType(e.values[o],O.call(this,c,o),t))}else{f.push(e.values[o])}}}else{f.push(e.values[o])}}}const y=i.createCondition(c.name,f,undefined,undefined,n.NotValidated);o.updateConditionValues(y);o.checkConditionsEmpty(y,l);p.push(y)}}return p};y.prototype.validateValue=function(e){if(e===undefined||e===null||this._bDestroyed){return}if(!Array.isArray(e)){throw new t("No valid conditions provided",undefined,undefined,e)}const i=m.call(this);const n=v.call(this);for(let a=0;a<e.length;a++){const s=e[a];if(typeof s!=="object"||!s.operator||!s.values||!Array.isArray(s.values)){throw new t(this._oResourceBundle.getText("field.VALUE_NOT_VALID"),undefined,typeof s==="object"?f({},s):s,e)}const r=o.getOperator(s.operator);if(!r||n.indexOf(r.name)===-1){throw new t("No valid condition provided, Operator wrong.",undefined,f({},s),e)}try{r.validate(s.values,i)}catch(o){if(o instanceof c){throw new t(o.message,o.violatedConstraints,f({},s),e)}throw o}}};function h(){let e=1;if(this.oFormatOptions.hasOwnProperty("maxConditions")){e=this.oFormatOptions.maxConditions}return e}function m(){const e=this.oFormatOptions.valueType;if(!e){throw new Error("Type missing")}return e}function v(){let e=this.oFormatOptions.operators;if(!e||e.length===0){e=o.getOperatorsForType(T.call(this))}return e}function T(){const e=m.call(this);const t=e.getMetadata().getName();const o=e.getFormatOptions();const i=e.getConstraints();return g.call(this,{name:t,formatOptions:o,constraints:i})}function g(e){const t=this.oFormatOptions.delegate;const o=this.oFormatOptions.control;const i=t?t.getTypeMap(o).getBaseType(e.name,e.formatOptions,e.constraints):a.Date;return i}function O(e,t){return e._createLocalType(e.valueTypes[t])}return y});
//# sourceMappingURL=DynamicDateRangeConditionsType.js.map