/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/library","sap/ui/mdc/enums/ContentMode"],function(e,t){"use strict";const i=e.EmptyIndicatorMode;const a=e.TokenizerRenderMode;const l={getDisplay:function(){return["sap/m/Text"]},getDisplayMultiValue:function(){return["sap/ui/mdc/field/TokenizerDisplay","sap/ui/mdc/field/TokenDisplay"]},getDisplayMultiLine:function(){return["sap/m/ExpandableText"]},getEdit:function(){return["sap/ui/mdc/field/FieldInput"]},getEditMultiValue:function(){return["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"]},getEditMultiLine:function(){return["sap/m/TextArea"]},getEditOperator:function(){return[null]},getEditForHelp:function(){return this.getEdit()},getUseDefaultEnterHandler:function(){return true},getUseDefaultValueHelp:function(){return{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:false,single:true,multi:true}},getControlNames:function(e,i){let a;switch(e){case t.Display:a=this.getDisplay();break;case t.DisplayMultiValue:a=this.getDisplayMultiValue();break;case t.DisplayMultiLine:a=this.getDisplayMultiLine();break;case t.EditMultiValue:a=this.getEditMultiValue();break;case t.EditMultiLine:a=this.getEditMultiLine();break;case t.EditOperator:if(this.getEditOperator()){a=this.getEditOperator()[i]?this.getEditOperator()[i].name:[null]}else{a=[null]}break;case t.EditForHelp:a=this.getEditForHelp();break;default:a=this.getEdit()}if(a){return Array.isArray(a)?a:[a]}throw new Error("No control defined for content mode "+e)},getNoFormatting:function(e){if(e===t.EditMultiValue){return true}else{return false}},create:function(e,i,a,l,n){switch(i){case t.Display:return this.createDisplay(e,l,n);case t.DisplayMultiValue:return this.createDisplayMultiValue(e,l,n);case t.DisplayMultiLine:return this.createDisplayMultiLine(e,l,n);case t.EditMultiValue:return this.createEditMultiValue(e,l,n);case t.EditMultiLine:return this.createEditMultiLine(e,l,n);case t.EditOperator:if(this.getEditOperator()){return this.getEditOperator()[a]?this.getEditOperator()[a].create.call(this,e,l,n):[null]}return[null];case t.EditForHelp:return this.createEditForHelp(e,l,n);default:return this.createEdit(e,l,n)}},createEdit:function(e,t,i){const a=t[0];const l=e.getConditionsType();const n=new a(i,{value:{path:"$field>/conditions",type:l},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",valueHelpIconSrc:e.getValueHelpIcon(),showValueHelp:"{$field>/_valueHelpEnabled}",ariaAttributes:"{$field>/_ariaAttributes}",width:"100%",tooltip:"{$field>/tooltip}",autocomplete:false,change:e.getHandleContentChange(),liveChange:e.getHandleContentLiveChange(),valueHelpRequest:e.getHandleValueHelpRequest()});n._setPreferUserInteraction(true);e.setAriaLabelledBy(n);return[n]},createEditMultiValue:function(e,t,i){const a=t[0];const l=t[1];const n=e.getConditionType();const o=e.getConditionsType();const r=new l(i+"-token",{text:{path:"$field>",type:n}});const d=new a(i,{value:{path:"$field>/conditions",type:o},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:"{$field>/_valueHelpEnabled}",valueHelpIconSrc:e.getValueHelpIcon(),ariaAttributes:"{$field>/_ariaAttributes}",width:"100%",tooltip:"{$field>/tooltip}",tokens:{path:"$field>/conditions",template:r},dependents:[r],autocomplete:false,showSuggestion:false,change:e.getHandleContentChange(),liveChange:e.getHandleContentLiveChange(),tokenUpdate:e.getHandleTokenUpdate(),valueHelpRequest:e.getHandleValueHelpRequest()});d._setPreferUserInteraction(true);e.setAriaLabelledBy(d);return[d]},createEditMultiLine:function(e,t,i){const a=t[0];const l=e.getConditionsType();const n=new a(i,{value:{path:"$field>/conditions",type:l},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",rows:4,tooltip:"{$field>/tooltip}",change:e.getHandleContentChange(),liveChange:e.getHandleContentLiveChange()});n._setPreferUserInteraction(true);e.setAriaLabelledBy(n);return[n]},createDisplay:function(e,t,a){const l=t[0];const n=e.getConditionsType();const o=new l(a,{text:{path:"$field>/conditions",type:n},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",wrapping:"{$field>/multipleLines}",width:"100%",tooltip:"{$field>/tooltip}",emptyIndicatorMode:i.Auto});return[o]},createDisplayMultiLine:function(e,t,a){const l=t[0];const n=e.getConditionsType();const o=new l(a,{text:{path:"$field>/conditions",type:n},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",tooltip:"{$field>/tooltip}",emptyIndicatorMode:i.Auto});return[o]},createDisplayMultiValue:function(e,t,l){const n=t[0];const o=t[1];const r=e.getConditionType();const d=new o(l+"-token",{text:{path:"$field>",type:r}});const s=new n(l,{editable:false,emptyIndicatorMode:i.Auto,renderMode:a.Narrow,width:"100%",tooltip:"{$field>/tooltip}",tokens:{path:"$field>/conditions",template:d},dependents:[d]});return[s]},createEditForHelp:function(e,t,i){if(e.getDataType()&&e.getDataType().isA("sap.ui.model.CompositeType")){e.setIsMeasure(true)}return this.createEdit(e,t,i)}};return l});
//# sourceMappingURL=DefaultContent.js.map