/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/library","sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/mdc/p13n/subcontroller/AdaptFiltersController","sap/ui/mdc/filterbar/p13n/GroupContainer","sap/ui/mdc/filterbar/p13n/FilterColumnLayout","sap/ui/mdc/filterbar/p13n/FilterGroupLayout","sap/ui/mdc/filterbar/p13n/TableContainer","sap/ui/mdc/filterbar/FilterBarBase","sap/ui/mdc/filterbar/FilterBarBaseRenderer","sap/base/util/merge","sap/ui/core/Core","sap/m/p13n/enum/PersistenceMode"],function(t,e,i,n,o,r,a,s,l,p,h,c){"use strict";const u=t.ValueState;const d=s.extend("sap.ui.mdc.filterbar.p13n.AdaptationFilterBar",{metadata:{library:"sap.ui.mdc",properties:{_useFixedWidth:{type:"boolean",defaultValue:false,visibility:"hidden"}},associations:{adaptationControl:{type:"sap.ui.mdc.Control",multiple:false}},events:{change:{}}},renderer:l});d.prototype.WIDTH="30rem";d.prototype.getVerticalScrolling=function(){return this._oFilterBarLayout.getInner().getVerticalScrolling instanceof Function?this._oFilterBarLayout.getInner().getVerticalScrolling():false};d.prototype.init=function(){s.prototype.init.apply(this,arguments);this.addStyleClass("sapUIAdaptationFilterBar");this.getEngine().defaultProviderRegistry.attach(this,c.Transient);this._fnResolveAdaptationControlPromise=null;this._oAdaptationControlPromise=new Promise(function(t,e){this._fnResolveAdaptationControlPromise=t}.bind(this))};d.prototype.keepAlive=function(){return true};d.prototype._onModifications=function(){const t=s.prototype._onModifications.apply(this,arguments);if(this._oFilterBarLayout.getInner().isA("sap.ui.mdc.p13n.panels.FilterPanel")){const t=this._oFilterBarLayout.getInner().getP13nData();this._updateActiveStatus(t);this._oFilterBarLayout.setP13nData({items:t})}this.fireChange();return t};d.prototype.getInitialFocusedControl=function(){return this._oFilterBarLayout.getInitialFocusedControl()};d.prototype.getWidth=function(){return this.WIDTH};d.prototype.applySettings=function(){s.prototype._applySettings.apply(this,arguments);this._waitForAdaptControlAndPropertyHelper().then(function(){this._initControlDelegate()}.bind(this))};d.prototype.setVisibleFields=function(t){const e=this._getAdaptationControlInstance();if(this._checkAdvancedParent(e)){throw new Error("Only supported for simple parents")}this._aVisibleKeys=t};d.prototype._getPropertyByName=function(t){let e=s.prototype._getPropertyByName.apply(this,arguments);const i=this.getPropertyHelper();if(!e||e.filterable===false){e=i.getProperties().find(function(e){return e.path===t&&e.filterable})}return e};d.prototype._waitForAdaptControlAndPropertyHelper=function(){return this._oAdaptationControlPromise.then(function(){return this._getAdaptationControlInstance().awaitPropertyHelper().then(function(t){this._oPropertyHelper=t}.bind(this))}.bind(this))};d.prototype._initControlDelegate=function(){return this.initControlDelegate().then(function(){if(!this._bIsBeingDestroyed){this._applyInitialFilterConditions()}}.bind(this))};d.prototype.getControlDelegate=function(){return this._getAdaptationControlInstance().getControlDelegate()};d.prototype.initControlDelegate=function(){return this._oAdaptationControlPromise.then(function(){return this._getAdaptationControlInstance().initControlDelegate()}.bind(this))};d.prototype.awaitControlDelegate=function(){return this._oAdaptationControlPromise.then(function(){return this._getAdaptationControlInstance().awaitControlDelegate()}.bind(this))};d.prototype.initPropertyHelper=function(){return this._oAdaptationControlPromise.then(function(){return this._getAdaptationControlInstance().initPropertyHelper()}.bind(this))};d.prototype.finalizePropertyHelper=function(){return this._oAdaptationControlPromise.then(function(){return this._getAdaptationControlInstance().finalizePropertyHelper()}.bind(this))};d.prototype.getTypeUtil=function(){return this.getTypeMap()};d.prototype.getTypeMap=function(){if(!this._getAdaptationControlInstance()){throw new Error("No adaptation control assigned yet.")}return this._getAdaptationControlInstance().getTypeMap()};d.prototype.setMessageStrip=function(t){this._oFilterBarLayout.setMessageStrip(t)};d.prototype.setLiveMode=function(t,e){s.prototype.setLiveMode.apply(this,arguments);this._oConditionModel.attachPropertyChange(function(t){const e=t.getParameter("path").substring(12);if(this.oAdaptationData){const t=this.oAdaptationData.items;const i=t.find(function(t){return t.name==e});if(i&&this._checkAdvancedParent(this._getAdaptationControlInstance())){i.active=this._getConditionModel().getConditions(e).length>0?true:false}}}.bind(this));return this};d.prototype._retrieveMetadata=function(){return this._oAdaptationControlPromise.then(function(){return this._getAdaptationControlInstance().awaitPropertyHelper().then(function(t){if(!this._getAdaptationControlInstance().isPropertyHelperFinal()){return this.finalizePropertyHelper()}return s.prototype._retrieveMetadata.apply(this,arguments)}.bind(this))}.bind(this))};d.prototype.isControlDelegateInitialized=function(){return this._getAdaptationControlInstance().isControlDelegateInitialized()};d.prototype.createConditionChanges=function(){return Promise.all([this._oAdaptationControlPromise,this.awaitControlDelegate()]).then(function(){const t=this._getModelConditions(this._getConditionModel(),false,true);return this.getEngine().createChanges({control:this._getAdaptationControlInstance(),applyAbsolute:true,key:"Filter",state:t,suppressAppliance:true})}.bind(this))};d.prototype.setP13nData=function(t){this.oAdaptationData=t;this._getConditionModel().checkUpdate(true);this._updateActiveStatus(this.oAdaptationData.items);this._oFilterBarLayout.update(t)};d.prototype._updateActiveStatus=function(t){const e=this.getFilterConditions();t.forEach(function(t){const i=this.mFilterFields&&this.mFilterFields[t.name];if(i){const n=i.getPropertyKey();if(e[n]&&e[n].length>0){t.active=true}}}.bind(this))};d.prototype.getP13nData=function(){if(this._aVisibleKeys&&this._aVisibleKeys.length>0){this.oAdaptationData.items.forEach(function(t){if(this._aVisibleKeys.indexOf(t.name)>-1){t.active=true}},this)}return this.oAdaptationData};d.prototype._handleFilterItemSubmit=function(){return};d.prototype._getWaitForChangesPromise=function(){return this.getEngine().waitForChanges(this._getAdaptationControlInstance())};d.prototype.createFilterFields=function(){return this.initializedWithMetadata().then(function(){const t=this._getAdaptationControlInstance().getFilterConditions();this.setFilterConditions(t);const e=this._setXConditions(t);if(this._bFilterFieldsCreated){return e.then(function(){this._oFilterBarLayout.setP13nData(this.getP13nData());return this}.bind(this))}const i=this._getAdaptationControlInstance();const n=i.getControlDelegate();const o=this._checkAdvancedParent(i)?n:n.getFilterDelegate();this._mOriginalsForClone={};this.mFilterFields={};const r=[];this.getP13nData().items.forEach(function(t,e){const n=this._checkExisting(t,o);n.then(function(e){let o;if(this._checkAdvancedParent(i)){if(e._bTemporaryOriginal){delete n._bTemporaryOriginal;this._mOriginalsForClone[e.getPropertyKey()]=e}o=e.clone();if(i._handleFilterItemChanges){o.detachChange(i._handleFilterItemChanges,i)}if(i._handleFilterItemSubmit){o.detachSubmit(i._handleFilterItemSubmit,i)}if(o.getValueState()!==u.None){o.setValueState(u.None);o.setValueStateText()}}else{o=e}this.mFilterFields[t.name]=o}.bind(this));r.push(n)}.bind(this));return Promise.all(r).then(function(){const t=this.getP13nData();t.items.forEach(function(t){this.addAggregation("filterItems",this.mFilterFields[t.name])}.bind(this));this._updateActiveStatus(t.items);this._oFilterBarLayout.setP13nData(t);this._bFilterFieldsCreated=true;return this}.bind(this))}.bind(this))};d.prototype._checkExisting=function(t,e){let i;const n=this._getAdaptationControlInstance();const o=this._checkAdvancedParent(n)?n.getFilterItems():[];const r=o.reduce(function(t,e){t[e.getPropertyKey()]=e;return t},{});if(r[t.name]){i=Promise.resolve(r[t.name])}else{i=e.addItem(this._getAdaptationControlInstance(),t.name);i=i.then(function(e){if(!e){throw new Error("No FilterField could be created for property: '"+t.name+"'.")}e._bTemporaryOriginal=true;return e})}return i};d.prototype.executeRemoves=function(){const t=this._oFilterBarLayout.getInner().getSelectedFields();const e=[];Object.keys(this._mOriginalsForClone).forEach(function(i){const n=this._getAdaptationControlInstance().getControlDelegate();if(t.indexOf(i)<0){const t=n.removeItem.call(n,this._getAdaptationControlInstance(),i).then(function(t){if(t&&this._mOriginalsForClone[i]){this._mOriginalsForClone[i].destroy();delete this._mOriginalsForClone[i]}}.bind(this));e.push(t)}}.bind(this));return Promise.all(e)};d.prototype._checkAdvancedParent=function(t){if(!t.isA("sap.ui.mdc.IFilterSource")&&!t.isA("sap.ui.mdc.IFilter")){throw new Error("The 'adaptationControl' needs to implement the IFilterSource or IFilter interface")}return t.isA("sap.ui.mdc.IFilter")};d.prototype.setAdaptationControl=function(t,e){if(this._fnResolveAdaptationControlPromise){this._fnResolveAdaptationControlPromise();this._fnResolveAdaptationControlPromise=null}this.setAssociation("adaptationControl",t,e);this._cLayoutItem=r;this._oFilterBarLayout=this._checkAdvancedParent(t)?new n:new a;this._oFilterBarLayout.getInner().setParent(this);this.setAggregation("layout",this._oFilterBarLayout,true);if(this._oFilterBarLayout.getInner().attachChange){this._oFilterBarLayout.getInner().attachChange(function(t){if(t.getParameter("reason")==="Remove"){const e=t.getParameter("item");const i={};i[this.mFilterFields[e.name].getPropertyKey()]=[];return this.getEngine().createChanges({control:this,applyAbsolute:true,key:"Filter",state:i})}this.fireChange()}.bind(this))}return this};d.prototype._getAdaptationControlInstance=function(){const t=this.getAdaptationControl();return t&&h.byId(t)};d.prototype.exit=function(){this.getEngine().defaultProviderRegistry.detach(this);s.prototype.exit.apply(this,arguments);for(const t in this._mOriginalsForClone){this._mOriginalsForClone[t].destroy()}this._mOriginalsForClone=null;this.oAdaptationData=null;this.mFilterFields=null;this._fnResolveAdaptationControlPromise=null;this._oAdaptationControlPromise=null};return d});
//# sourceMappingURL=AdaptationFilterBar.js.map