//@ui5-bundle sap/ui/mdc/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/ActionToolbar", ["sap/ui/core/Core","sap/m/OverflowToolbar","sap/m/OverflowToolbarRenderer","sap/m/ToolbarSpacer","sap/m/ToolbarSeparator","sap/m/library","sap/ui/mdc/enums/ActionToolbarActionAlignment","sap/ui/mdc/p13n/subcontroller/ActionToolbarController","sap/m/p13n/Engine"],function(t,e,o,n,r,i,s,a,g){"use strict";const p=i.OverflowToolbarPriority;const l=e.extend("sap.ui.mdc.ActionToolbar",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/actiontoolbar/ActionToolbar.designtime",defaultAggregation:"actions",properties:{useAsHeader:{type:"boolean",group:"Behavior",defaultValue:true},_endOrder:{type:"string[]",defaultValue:[],visibility:"hidden"}},aggregations:{begin:{type:"sap.ui.core.Control",multiple:true},between:{type:"sap.ui.core.Control",multiple:true},actions:{type:"sap.ui.mdc.actiontoolbar.ActionToolbarAction",multiple:true},end:{type:"sap.ui.core.Control",multiple:true}}},renderer:o});const c=["begin","between","actions","end"];const d=function(){const t={canOverflow:true,getCustomImportance:function(){return p.NeverOverflow}};return t};l.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oBeginSeparator=new r({visible:false});this._oBeginSeparator.getOverflowToolbarConfig=d;this._oEndActionsBeginSeparator=new r({visible:false});this._oEndActionsBeginSeparator.getOverflowToolbarConfig=d;this._oEndActionsEndSeparator=new r({visible:false});this._oEndActionsEndSeparator.getOverflowToolbarConfig=d;this._oSpacer=new n;this.setUseAsHeader(true);g.getInstance().register(this,{controller:{actionsKey:new a({control:this})}})};l.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oBeginSeparator){this._oBeginSeparator.destroy()}if(this._oEndActionsBeginSeparator){this._oEndActionsBeginSeparator.destroy()}if(this._oEndActionsEndSeparator){this._oEndActionsEndSeparator.destroy()}if(this._oSpacer){this._oSpacer.destroy()}};l.prototype.setProperty=function(t){if(t==="_endOrder"){this._bEnforceEndOrder=true}return e.prototype.setProperty.apply(this,arguments)};l.prototype.addAggregation=function(t,o){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}if(t==="end"){this._bEnforceEndOrder=true}const n=arguments;if(c.includes(t)){this._registerControlListener(o);this._resetAndInvalidateToolbar(false);if(o){this._moveControlInSuitableCollection(o,this._getControlPriority(o))}this._informNewFlexibleContentAdded(o);const t=this._callToolbarMethod("addAggregation",n);this._updateSeparators();return t}return e.prototype.addAggregation.apply(this,arguments)};l.prototype.destroyAggregation=function(t){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}if(c.includes(t)){const e=this.removeAllAggregation(t);for(let t=0;t<e.length;t++){e[t].destroy()}this._updateSeparators();return this}return e.prototype.destroyAggregation.apply(this,arguments)};l.prototype.insertAggregation=function(t,o,n){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}if(t==="end"){this._bEnforceEndOrder=true}if(c.includes(t)){this._registerControlListener(o);this._resetAndInvalidateToolbar(false);if(o){this._moveControlInSuitableCollection(o,this._getControlPriority(o))}this._informNewFlexibleContentAdded(o);const t=this._callToolbarMethod("insertAggregation",arguments);this._updateSeparators();return t}return e.prototype.insertAggregation.apply(this,arguments)};l.prototype.removeAllAggregation=function(t){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}return e.prototype.removeAllAggregation.apply(this,arguments)};l.prototype.removeAggregation=function(t,o){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}if(c.includes(t)){const t=this._callToolbarMethod("removeAggregation",arguments);if(t){this._getPopover().removeAssociatedContent(t.getId())}this._resetAndInvalidateToolbar(false);this._deregisterControlListener(t);this._removeContentFromControlsCollections(t);this._updateSeparators();return t}return e.prototype.removeAggregation.apply(this,arguments)};l.prototype.setUseAsHeader=function(t){this.setProperty("useAsHeader",t,true);this.toggleStyleClass("sapMTBHeader-CTX",!!t);return this};l.prototype.getEndActionsBegin=function(){return this.getActionsWithLayoutInformation({aggregationName:"end",alignment:s.Begin})};l.prototype.getEndActionsEnd=function(){return this.getActionsWithLayoutInformation({aggregationName:"end",alignment:s.End})};l.prototype.getActionsWithLayoutInformation=function(t){return this.getActions().filter(function(e){const o=e.getLayoutInformation();return o.aggregationName===t.aggregationName&&o.alignment===t.alignment})};l.prototype.onBeforeRendering=function(){e.prototype.onBeforeRendering.apply(this,arguments);if(this._bEnforceEndOrder){this.getProperty("_endOrder").reduce((e,o)=>{const n=t.byId(o);if(!n){return e}const r=this.indexOfEnd(n);if(r!=e){this.insertEnd(this.removeEnd(n),e)}return e+1},0);this._bEnforceEndOrder=false}};l.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments);this._updateSeparators()};l.prototype._onContentPropertyChangedOverflowToolbar=function(t){if(this._bIsBeingDestroyed){return}e.prototype._onContentPropertyChangedOverflowToolbar.apply(this,arguments);if(t.getParameter("name")==="visible"||t.getParameter("name")==="width"&&t.getSource()!=this._oBeginSeparator){this._updateSeparators()}};l.prototype._hasVisible=function(t){const e=this.getAggregation("_popover")?this.getAggregation("_popover")._getAllContent():[];const o=t.filter(function(t){return e.indexOf(t)===-1});return o.some(function(t){const e=t.getWidth?t.getWidth()!=="0px":true;return t.getVisible()&&e})};l.prototype._updateSeparators=function(){const t=this._hasVisible(this.getEnd());if(this._oBeginSeparator){const t=this._hasVisible(this.getBegin());const e=this._hasVisible(this.getBetween());this._oBeginSeparator.setVisible(t&&e)}if(this._oEndActionsBeginSeparator){const e=this._hasVisible(this.getEndActionsBegin());this._oEndActionsBeginSeparator.setVisible(t&&e)}if(this._oEndActionsEndSeparator){const e=this._hasVisible(this.getEndActionsEnd());this._oEndActionsEndSeparator.setVisible(t&&e)}};l.prototype.indexOfContent=function(t){return this.getContent().indexOf(t)};l.prototype.getContent=function(){let t=this.getBegin();t.push(this._oBeginSeparator);t=t.concat(this.getBetween());t.push(this._oSpacer);t=t.concat(this.getEndActionsBegin());t.push(this._oEndActionsBeginSeparator);t=t.concat(this.getEnd());t.push(this._oEndActionsEndSeparator);t=t.concat(this.getEndActionsEnd());return t};l.prototype.getCurrentState=function(){const t=[];let e;this.getActions().forEach(function(o,n){e=o&&o.getId();if(o.getVisible()){t.push({name:e,alignment:o.getLayoutInformation().alignment})}});return{items:t}};l.prototype.initPropertyHelper=function(){return Promise.resolve({getProperties:function(){const t=[];this.getActions().forEach(function(e){t.push({name:e.getId(),alignment:e.getLayoutInformation().alignment,label:e.getLabel(),visible:true})});return t}.bind(this)})};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/AggregationBaseDelegate", ["sap/ui/mdc/BaseDelegate","sap/ui/core/library"],function(e,t){"use strict";const n=Object.assign({},e);n.fetchProperties=function(e){return Promise.resolve([])};n.addItem=function(e,t,n){return Promise.resolve()};n.removeItem=function(e,t,n){return Promise.resolve(true)};n.validateState=function(e,n){const i=t.MessageType.None;return{validation:i,message:undefined}};n.onAfterXMLChangeProcessing=function(e,t){};n.determineValidationState=function(e){return e.checkValidationState?e.checkValidationState():-1};n.visualizeValidationState=function(e,t){};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/BaseDelegate", ["sap/ui/mdc/enums/BaseType","sap/ui/mdc/DefaultTypeMap","sap/base/Log"],function(e,t,i){"use strict";const p={};p.getTypeUtil=function(e){return this.getTypeMap(e)};p.getTypeMap=function(e){if(this.getTypeUtil&&this.getTypeUtil!==p.getTypeUtil){return this.getTypeUtil(e)}return t};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/Chart", ["sap/ui/core/Core","sap/ui/mdc/Control","./ChartRenderer","sap/base/Log","./chart/ChartToolbar","./chart/PropertyHelper","sap/ui/mdc/mixin/FilterIntegrationMixin","sap/ui/model/base/ManagedObjectModel","sap/ui/mdc/p13n/subcontroller/ChartItemController","sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/mdc/p13n/subcontroller/SortController","sap/ui/mdc/p13n/subcontroller/ChartTypeController","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/chart/DrillBreadcrumbs","sap/ui/mdc/actiontoolbar/ActionToolbarAction","sap/ui/core/library","sap/ui/events/KeyCodes","sap/ui/mdc/util/InfoBar","sap/ui/core/format/ListFormat","sap/ui/mdc/enums/ProcessingStrategy","sap/ui/mdc/enums/ChartP13nMode"],function(t,e,i,o,r,n,s,a,l,h,p,u,g,c,d,f,y,b,C,m,_){"use strict";let I;const D=f.TitleLevel;const T=e.extend("sap.ui.mdc.Chart",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/chart/Chart.designtime",interfaces:["sap.ui.mdc.IFilterSource","sap.ui.mdc.IxState"],defaultAggregation:"items",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%",invalidate:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%",invalidate:true},delegate:{type:"object",group:"Data",defaultValue:{name:"sap/ui/mdc/ChartDelegate"}},header:{type:"string",group:"Misc",defaultValue:null},noDataText:{type:"string",defaultValue:"No data"},p13nMode:{type:"sap.ui.mdc.enums.ChartP13nMode[]",defaultValue:[]},legendVisible:{type:"boolean",group:"Misc",defaultValue:true},ignoreToolbarActions:{type:"sap.ui.mdc.enums.ChartToolbarActionType[]",defaultValue:[]},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"240px",invalidate:true},minHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"400px",invalidate:true},sortConditions:{type:"object"},filterConditions:{type:"object",defaultValue:{}},showChartTooltip:{type:"boolean",group:"Misc",defaultValue:true},autoBindOnInit:{type:"boolean",group:"Misc",defaultValue:true},chartType:{type:"string",group:"Misc",defaultValue:"column"},showSelectionDetails:{type:"boolean",group:"Misc",defaultValue:true},propertyInfo:{type:"object",defaultValue:[]},headerLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:D.Auto},headerStyle:{type:"sap.ui.core.TitleLevel",group:"Appearance"},headerVisible:{type:"boolean",group:"Misc",defaultValue:true}},aggregations:{items:{type:"sap.ui.mdc.chart.Item",multiple:true},actions:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getToolbar",aggregation:"actions"}},selectionDetailsActions:{type:"sap.ui.mdc.chart.SelectionDetailsActions",multiple:false},_toolbar:{type:"sap.ui.mdc.chart.ChartToolbar",multiple:false,visibility:"hidden"},_breadcrumbs:{type:"sap.m.Breadcrumbs",multiple:false,visibility:"hidden"},_innerChart:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_infoToolbar:{type:"sap.ui.mdc.util.InfoBar",multiple:false,visibility:"hidden"},variant:{type:"sap.ui.fl.variants.VariantManagement",multiple:false},noData:{type:"sap.ui.core.Control",multiple:false}},associations:{filter:{type:"sap.ui.mdc.IFilter",multiple:false}},events:{selectionDetailsActionPressed:{parameters:{action:{type:"sap.ui.core.Item"},itemContexts:{type:"sap.ui.model.Context"},level:{type:"sap.m.SelectionDetailsActionLevel"}}}}},renderer:i});const v=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");s.call(T.prototype);T.prototype.init=function(){this._oManagedObjectModel=new a(this);this.setModel(this._oManagedObjectModel,"$mdcChart");e.prototype.init.apply(this,arguments);this._setupPropertyInfoStore("propertyInfo");this._setPropertyHelperClass(n)};T.prototype.setP13nMode=function(t){let e=null;if(t&&t.length>=1){e=[];const i=t.reduce(function(t,e,i){t[e]=true;return t},{});if(i.Item){e.push(_.Item)}if(i.Sort){e.push(_.Sort)}if(i.Filter){e.push(_.Filter)}if(i.Type){this._typeBtnActive=true;e.push(_.Type)}else{this._typeBtnActive=false}}else{e=t}this.setProperty("p13nMode",e,true);this._updateAdaptation(this.getP13nMode());return this};T.prototype._updateAdaptation=function(t){const e={controller:{}};const i={Item:new l({control:this}),Sort:new p({control:this}),Filter:new h({control:this}),Type:new u({control:this})};if(t&&t.length>0){t.forEach(function(t){const o=t;const r=i[t];if(r){e.controller[o]=r}});this.getEngine().register(this,e)}};T.prototype.setFilterConditions=function(t){this.setProperty("filterConditions",t,true);const e=this.getInbuiltFilter();if(e){e.setFilterConditions(t)}this._updateInfoToolbar();return this};T.prototype.getConditions=function(){return this.getInbuiltFilter()?this.getInbuiltFilter().getConditions():[]};T.prototype._registerInnerFilter=function(t){t.attachSearch(function(){this._rebind()},this)};T.prototype.applySettings=function(t,i){this._setPropertyHelperClass(n);e.prototype.applySettings.apply(this,arguments);this.initializedPromise=new Promise(function(t,e){this._fnResolveInitialized=t;this._fnRejectInitialized=e}.bind(this));this.innerChartBoundPromise=new Promise(function(t,e){this._fnResolveInnerChartBound=t;this._fnRejectInnerChartBound=e}.bind(this));const o=this.initControlDelegate();const r=[o];if(this.isFilteringEnabled()){r.push(this.retrieveInbuiltFilter())}Promise.all(r).then(function(){if(!this.isDestroyed()){this._initInnerControls()}}.bind(this))};T.prototype._initInnerControls=function(){this.getControlDelegate().initializeInnerChart(this).then(function(t){this.setBusyIndicatorDelay(0);this.getControlDelegate().createInitialChartContent(this);this._renderOverlay(true);if(this.getAutoBindOnInit()){this.setBusy(true);this._createContentfromPropertyInfos(t)}this.setAggregation("_innerChart",t);if(this.getP13nMode().includes("Filter")){this._initInfoToolbar()}this._bInnerChartReady=true;this._fnResolveInitialized();this.invalidate()}.bind(this)).catch(function(t){this._fnRejectInitialized(t)}.bind(this));this._getToolbar().createToolbarContent(this)};T.prototype._initInfoToolbar=function(){this.setAggregation("_infoToolbar",new b(this.getId()+"--infoToolbar",{infoText:this._getFilterInfoText(),press:function(){this.finalizePropertyHelper().then(function(){return this.getEngine().show(this,"Filter")}.bind(this)).then(function(t){t.attachEventOnce("afterClose",function(){const t=this.getFilterConditions();const e=!Object.keys(t).find(function(e){return t[e]&&t[e].length>0});if(e&&this.getAggregation("_toolbar")){this.getAggregation("_toolbar").getSettingsButton().focus()}}.bind(this))}.bind(this))}.bind(this),removeAllFilters:function(t){this.getEngine().createChanges({control:this,key:"Filter",state:{},applyAbsolute:m.FullReplace});this._getToolbar().getSettingsButton().focus()}.bind(this)}));if(this.getDomRef()){this.getDomRef().setAttribute("aria-labelledby",this.getAggregation("_infoToolbar").getACCTextId())}};T.prototype._updateInfoToolbar=function(){if(this.getP13nMode().includes("Filter")&&this.getAggregation("_infoToolbar")){this.getAggregation("_infoToolbar").setInfoText(this._getFilterInfoText())}};T.prototype._getFilterInfoText=function(){if(this.getInbuiltFilter()){let t;const e=this._getLabelsFromFilterConditions();const i=C.getInstance();if(e.length>0){if(e.length>1){t=v.getText("chart.MULTIPLE_FILTERS_ACTIVE",[e.length,i.format(e)])}else{t=v.getText("chart.ONE_FILTER_ACTIVE",e[0])}}return t}return undefined};T.prototype._createContentfromPropertyInfos=function(t){this.getControlDelegate().checkAndUpdateMDCItems(this).then(function(){this.getControlDelegate().createInnerChartContent(this,this._innerChartDataLoadComplete.bind(this)).then(function(){this._createBreadcrumbs();this._oObserver=new g(this._propagateItemChangeToInnerChart.bind(this));this._oObserver.observe(this,{aggregations:["items"]});this._propagatePropertiesToInnerChart();this._fnResolveInnerChartBound()}.bind(this))}.bind(this))};T.prototype._createBreadcrumbs=function(){if(!this._oBreadcrumbs&&!this._bIsDestroyed){this._oBreadcrumbs=new c(this.getId()+"--breadcrumbs");this._oBreadcrumbs.updateDrillBreadcrumbs(this,this.getControlDelegate().getDrillableItems(this));this.setAggregation("_breadcrumbs",this._oBreadcrumbs)}};T.prototype._loadDelegate=function(){return new Promise(function(t){const e=[this.getDelegate().name];function i(e){t(e)}sap.ui.require(e,i)}.bind(this))};T.prototype.isFilteringEnabled=function(){return this.getP13nMode().indexOf("Filter")>-1};T.prototype.getAdaptationUI=function(){return this.getControlDelegate().getAdaptionUI(this)};T.prototype._propagateItemChangeToInnerChart=function(t){if(this._bIsDestroyed){return}this.setBusy(true);let e;switch(t.mutation){case"insert":if(t.child&&t.child.getType()){e=this.getItems().filter(function(e){return e.getType()===t.child.getType()}).indexOf(t.child)}else{e=this.getItems().indexOf(t.child)}this.getControlDelegate().insertItemToInnerChart(this,t.child,e);break;case"remove":this.getControlDelegate().removeItemFromInnerChart(this,t.child);break;default:o.error("Unknown mutation on MDC Chart Item Aggregation. This will not sync to inner chart!");break}this._rebind();this._oBreadcrumbs.updateDrillBreadcrumbs(this,this.getControlDelegate().getDrillableItems(this))};T.prototype._rebind=function(t){if(!this._bInnerChartReady){this.initialized().then(function(){this._rebind(t)}.bind(this));return}this.setBusy(true);if(!this.getControlDelegate().getInnerChartBound(this)){this._createContentfromPropertyInfos();return}const e=this.getControlDelegate();let i;if(e._getBindingInfo){i=e._getBindingInfo(this);o.warning("mdc Chart","calling the private delegate._getBindingInfo. Please make the function public!")}else{i=e.getBindingInfo(this)}e.updateBindingInfo(this,i);e.rebind(this,i)};T.prototype._getToolbar=function(){if(this.getAggregation("_toolbar")){return this.getAggregation("_toolbar")}else if(!this._bIsDestroyed){const t=new r(this.getId()+"--toolbar",{design:"Transparent"});this.setAggregation("_toolbar",t);return t}};T.prototype._updateToolbar=function(){if(this.getAggregation("_toolbar")){this.getAggregation("_toolbar").updateToolbar(this)}else{o.warning("Trying to uipdate Chart Toolbar, but toolbar is not yet initialized. This will not work!")}};T.prototype._getInnerChart=function(){if(this._bInnerChartReady){return this.getControlDelegate().getInnerChart(this)}else{o.error("Trying to acces inner chart while inner chart is not yet initialized!")}};T.prototype.initialized=function(){return this.initializedPromise};T.prototype.innerChartBound=function(){return this.innerChartBoundPromise};T.prototype.zoomIn=function(){this.getControlDelegate().zoomIn(this)};T.prototype.zoomOut=function(){this.getControlDelegate().zoomOut(this)};T.prototype.getZoomState=function(){return this.getControlDelegate().getZoomState(this)};T.prototype.getSelectionHandler=function(){return this.getControlDelegate().getInnerChartSelectionHandler(this)};T.prototype.getChartTypeLayoutConfig=function(){return this.getControlDelegate().getChartTypeLayoutConfig()};T.prototype.getAllowedRolesForKinds=function(){return this.getControlDelegate().getAllowedRolesForKinds()};T.prototype.setLegendVisible=function(t){this.setProperty("legendVisible",t);try{this.getControlDelegate().setLegendVisible(this,t)}catch(t){o.info("Trying to set legend visiblity for Chart before delegate was initialized")}return this};T.prototype.setShowChartTooltip=function(t){this.setProperty("showChartTooltip",t);try{this.getControlDelegate().setChartTooltipVisibility(this,t)}catch(t){o.info("Trying to set tooltip visibility before delegate was initialized")}return this};T.prototype.destroy=function(){this._bIsDestroyed=true;e.prototype.destroy.apply(this,arguments)};T.prototype._showDrillDown=function(t){if(!this.oDrillPopover){if(I){this.oDrillPopover=I.createDrillDownPopover(this);this.oDrillPopover.attachAfterClose(function(){delete this.oDrillPopover}.bind(this));return I.showDrillDownPopover(this,t)}return new Promise(function(e,i){sap.ui.require(["sap/ui/mdc/chart/DrillStackHandler"],function(i){I=i;this.oDrillPopover=I.createDrillDownPopover(this);this.oDrillPopover.attachAfterClose(function(){delete this.oDrillPopover}.bind(this));I.showDrillDownPopover(this,t).then(function(t){e(t)})}.bind(this))}.bind(this))}else if(this.oDrillPopover){this.oDrillPopover.close()}};T.prototype._propagatePropertiesToInnerChart=function(){this.setLegendVisible(this.getLegendVisible());this.setShowChartTooltip(this.getShowChartTooltip());this.setChartType(this.getChartType())};T.prototype.getChartTypeInfo=function(){return this.getControlDelegate().getChartTypeInfo(this)};T.prototype.getAvailableChartTypes=function(){return this.getControlDelegate().getAvailableChartTypes(this)};T.prototype.setChartType=function(t){this.setProperty("chartType",t);try{this.getControlDelegate().setChartType(this,t)}catch(t){o.info("Trying to set chart type for Chart before delegate was initialized")}return this};T.prototype.setNoData=function(t){this.setAggregation("noData",t);try{this.getControlDelegate().changedNoDataStruct(this)}catch(t){}return this};T.prototype.getManagedObjectModel=function(){return this._oManagedObjectModel};T.prototype._innerChartDataLoadComplete=function(t){this._checkStyleClassesForDimensions();this.setBusy(false);this._renderOverlay(false);this.getControlDelegate().requestToolbarUpdate(this)};T.prototype._checkStyleClassesForDimensions=function(){const t=this._oBreadcrumbs&&this._oBreadcrumbs.getVisible()&&this.getItems().some(function(t){return t.getType()==="groupable"});if(!t&&this.hasStyleClass("sapUiMDCChartGrid")){this.removeStyleClass("sapUiMDCChartGrid");this.addStyleClass("sapUiMDCChartGridNoBreadcrumbs")}else if(t&&this.hasStyleClass("sapUiMDCChartGridNoBreadcrumbs")){this.removeStyleClass("sapUiMDCChartGridNoBreadcrumbs");this.addStyleClass("sapUiMDCChartGrid")}};T.prototype.getCurrentState=function(){const t={};const e=this.getP13nMode();if(e){if(e.indexOf("Item")>-1){t.items=this._getVisibleProperties()}if(e.indexOf("Sort")>-1){t.sorters=this._getSortedProperties()}if(e.indexOf("Filter")>-1){t.filter=this.getFilterConditions()}if(e.indexOf("Type")>-1){t.chartType=this.getChartType()}}return t};T.prototype._getVisibleProperties=function(){const t=[];this.getItems().forEach(function(e){t.push({name:e.getPropertyKey(),role:e.getRole()})});return t};T.prototype._getSortedProperties=function(){return this.getSortConditions()?this.getSortConditions().sorters:[]};T.prototype._getTypeBtnActive=function(){return!!this._typeBtnActive};T.prototype.setNoDataText=function(t){this.setProperty("noDataText",t);try{this.getControlDelegate().setNoDataText(this,t)}catch(t){}return this};T.prototype._onFiltersChanged=function(t){if(this._bInnerChartReady&&this.getControlDelegate()&&this.getControlDelegate().getInnerChartBound(this)&&t.getParameter("conditionsBased")){this._renderOverlay(true)}};const A=function(t){let e=false;if(t&&(t.indexOf("Sort")>-1||t.indexOf("Item")>-1||t.indexOf("Filter")>-1)){e=true}return e};T.prototype._onModifications=function(t){if(A(t)){this.rebind()}};T.prototype.setVariant=function(t){this.setAggregation("variant",t);if(this.getAggregation("_toolbar")){this.getAggregation("_toolbar").addVariantManagement(t)}return this};T.prototype._renderOverlay=function(t){try{this.getControlDelegate().showOverlay(this,t)}catch(t){o.error("sap.ui.mdc.Chart: Tried to render overlay on not initiailized chart. This will not work!")}};T.prototype.addAction=function(t){if(t.getMetadata().getName()!=="sap.ui.mdc.actiontoolbar.ActionToolbarAction"){t=new d(t.getId()+"-action",{action:t})}return e.prototype.addAggregation.apply(this,["actions",t])};T.prototype.setHeader=function(t){this.setProperty("header",t);if(this.getAggregation("_toolbar")){this.getAggregation("_toolbar")._setHeader(t)}return this};T.prototype.setHeaderLevel=function(t){this.setProperty("headerLevel",t);if(this.getAggregation("_toolbar")){this.getAggregation("_toolbar")._setHeaderLevel(t)}return this};T.prototype.setHeaderStyle=function(t){this.setProperty("headerStyle",t);if(this.getAggregation("_toolbar")){this.getAggregation("_toolbar")._setHeaderStyle(t)}return this};T.prototype.setHeaderVisible=function(t){this.setProperty("headerVisible",t,true);if(this.getAggregation("_toolbar")){this.getAggregation("_toolbar")._setHeaderVisible(t)}return this};T.prototype.getVariant=function(){const t=this.getAggregation("_toolbar");return t?t._getVariantReference():this.getAggregation("variant")};T.prototype.onkeydown=function(t){if(t.isMarked()){return}if((t.metaKey||t.ctrlKey)&&t.which===y.COMMA){const e=this._getToolbar()._oSettingsBtn;if(e&&e.getVisible()&&e.getEnabled()){e.firePress();t.setMarked();t.preventDefault()}}};return T});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/ChartDelegate", ["sap/ui/mdc/AggregationBaseDelegate"],function(n){"use strict";const t=Object.assign({},n);t.zoomIn=function(n){};t.zoomOut=function(n){};t.getZoomState=function(n){};t.getFilterDelegate=function(){return{addItem:function(n,t){return Promise.resolve()},addCondition:function(n,t,e){return Promise.resolve()},removeCondition:function(n,t,e){return Promise.resolve()}}};t.addItem=function(n,t,e,o){return Promise.resolve(null)};t.removeItem=function(n,t,e){return Promise.resolve(true)};t.getInnerChartSelectionHandler=function(n){};t.setLegendVisible=function(n,t){};t.insertItemToInnerChart=function(n,t,e){};t.removeItemFromInnerChart=function(n,t){};t.initializeInnerChart=function(n){return Promise.reject()};t.createInitialChartContent=function(n){};t.getInnerChart=function(n){};t.getChartTypeInfo=function(n){};t.getAvailableChartTypes=function(n){};t.getChartTypeLayoutConfig=function(){};t.getDrillStack=function(n){};t.getSortedDimensions=function(n){};t.getDrillableItems=function(n){};t.setChartType=function(n){};t.changedNoDataStruct=function(n){};t.setNoDataText=function(n,t){};t.createInnerChartContent=function(n,t){};t.rebind=function(n,t){};t.getInnerChartBound=function(n){};t.getBindingInfo=function(n){};t.updateBindingInfo=function(n,t){};t.setChartTooltipVisibility=function(n,t){};t.getInternalChartNameFromPropertyNameAndKind=function(n,t,e){};t.getPropertyFromNameAndKind=function(n,t,e){};t.fetchProperties=function(n){};t.showOverlay=function(n,t){};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/ChartRenderer", ["./library"],function(e){"use strict";const r={apiVersion:2};r.CSS_CLASS="sapUiMDCChart";r.render=function(e,n){e.openStart("div",n);e.class(r.CSS_CLASS);e.style("height",n.getHeight());e.style("width",n.getWidth());e.style("min-height",n.getMinHeight());e.style("min-width",n.getMinWidth());e.openEnd();e.openStart("div");e.openEnd();this.renderToolbar(e,n.getAggregation("_toolbar"));this.renderInfoToolbar(e,n.getAggregation("_infoToolbar"));e.close("div");this.renderBreadcrumbs(e,n.getAggregation("_breadcrumbs"));this.renderInnerStructure(e,n.getAggregation("_innerChart"));e.close("div")};r.renderNoDataStruct=function(e,r){if(r){}};r.renderToolbar=function(e,r){if(r){e.openStart("div");e.openEnd();e.renderControl(r);e.close("div")}};r.renderBreadcrumbs=function(e,r){if(r){e.renderControl(r)}};r.renderInfoToolbar=function(e,r){if(r){e.renderControl(r)}};r.renderInnerStructure=function(e,r){e.renderControl(r)};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/Control", ["sap/ui/core/Control","sap/ui/mdc/mixin/DelegateMixin","sap/ui/mdc/mixin/PropertyHelperMixin","sap/ui/mdc/mixin/AdaptationMixin"],function(e,i,t,r){"use strict";const a=e.extend("sap.ui.mdc.Control",{metadata:{library:"sap.ui.mdc",properties:{delegate:{type:"object",group:"Data"}}},renderer:e.renderer});i.call(a.prototype);r.call(a.prototype);t.call(a.prototype);return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/DefaultTypeMap", ["sap/ui/mdc/util/TypeMap","sap/ui/mdc/enums/BaseType"],function(e,t){"use strict";const s=Object.assign({},e);s.getUnitBaseType=function(e,s){if(!e||(!e.hasOwnProperty("showMeasure")||e.showMeasure)&&(!e.hasOwnProperty("showNumber")||e.showNumber)){return t.Unit}else if(!e.hasOwnProperty("showNumber")||e.showNumber){return t.Numeric}else{return t.String}};s.getUnitOptions=function(e,t,s){if(s){e=Object.assign({},e,{strictParsing:true,showNumber:!!s.showNumber,showMeasure:!!s.showMeasure})}if(e&&e.hasOwnProperty("unitOptional")){delete e.unitOptional}return[e,t]};s.set("sap.ui.model.type.Boolean",t.Boolean);s.set("sap.ui.model.type.Currency",s.getUnitBaseType,s.getUnitOptions);s.set("sap.ui.model.type.Date",t.Date);s.set("sap.ui.model.type.DateTime",t.DateTime);s.set("sap.ui.model.type.Float",t.Numeric);s.set("sap.ui.model.type.Integer",t.Numeric);s.set("sap.ui.model.type.String",t.String);s.set("sap.ui.model.type.Time",t.Time);s.set("sap.ui.model.type.Unit",s.getUnitBaseType,s.getUnitOptions);s.setAlias("Boolean","sap.ui.model.type.Boolean");s.setAlias("Currency","sap.ui.model.type.Currency");s.setAlias("Date","sap.ui.model.type.Date");s.setAlias("DateTime","sap.ui.model.type.DateTime");s.setAlias("Float","sap.ui.model.type.Float");s.setAlias("Integer","sap.ui.model.type.Integer");s.setAlias("String","sap.ui.model.type.String");s.setAlias("Time","sap.ui.model.type.Time");s.setAlias("Unit","sap.ui.model.type.Unit");s.freeze();return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/Element", ["sap/ui/core/Element","sap/ui/mdc/mixin/DelegateMixin","sap/ui/mdc/mixin/PropertyHelperMixin","sap/ui/mdc/mixin/AdaptationMixin"],function(e,i,t,r){"use strict";const a=e.extend("sap.ui.mdc.Element",{metadata:{library:"sap.ui.mdc",properties:{delegate:{type:"object",group:"Data"}}},renderer:e.renderer});i.call(a.prototype);r.call(a.prototype);t.call(a.prototype);return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/Field", ["sap/ui/mdc/field/FieldBase","sap/ui/mdc/field/FieldBaseRenderer","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/condition/Condition","sap/base/util/deepEqual","sap/base/util/merge","sap/ui/model/BindingMode","sap/ui/model/Context"],function(t,e,i,n,a,o,s,l,r,p){"use strict";const d=t.extend("sap.ui.mdc.Field",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/field/Field.designtime",properties:{value:{type:"any",defaultValue:null,bindable:"bindable"},additionalValue:{type:"any",defaultValue:null,bindable:"bindable"}},events:{change:{parameters:{value:{type:"string"},valid:{type:"boolean"},promise:{type:"Promise"}}}},defaultProperty:"value"},renderer:e});d.prototype.init=function(){this._vValue=null;this._vAdditionalValue=null;t.prototype.init.apply(this,arguments);this.setMaxConditions(1);this.setProperty("_operators",[a.EQ],true);this._oObserver.observe(this,{properties:["value","additionalValue","valueState"]})};d.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this._iConditionUpdateTimer){clearTimeout(this._iConditionUpdateTimer);delete this._iConditionUpdateTimer;delete this._bPendingConditionUpdate}this._oBindingContext=undefined};d.prototype.bindProperty=function(e,i){let n;let a;let o=0;if(e==="value"&&!i.formatter){i.targetType="raw";n=this.getContentFactory().getDataType();if(i.type&&(!n||n.getMetadata().getName()!==i.type.getMetadata().getName()||!s(n.getFormatOptions(),i.type.getFormatOptions())||!s(n.getConstraints(),i.type.getConstraints())||n._bCreatedByOperator!==i.type._bCreatedByOperator)){this.getContentFactory().setDataType(i.type);this.getContentFactory().setDateOriginalType(undefined);this.getContentFactory().setUnitOriginalType(undefined);this.getContentFactory().setIsMeasure(false);if(i.type.isA("sap.ui.model.CompositeType")&&i.parts){a=[];for(o=0;o<i.parts.length;o++){a.push(i.parts[o].type)}this.getContentFactory().setCompositeTypes(a)}this.getContentFactory().updateConditionType();this.invalidate()}}else if(e==="additionalValue"&&!i.formatter){i.targetType="raw";n=this.getContentFactory().getAdditionalDataType();if(i.type&&(!n||n.getMetadata().getName()!==i.type.getMetadata().getName()||!s(n.getFormatOptions(),i.type.getFormatOptions())||!s(n.getConstraints(),i.type.getConstraints())||n._bCreatedByOperator!==i.type._bCreatedByOperator)){this.getContentFactory().setAdditionalDataType(i.type);if(i.type.isA("sap.ui.model.CompositeType")&&i.parts){a=[];for(o=0;o<i.parts.length;o++){a.push(i.parts[o].type)}this.getContentFactory().setAdditionalCompositeTypes(a)}this.getContentFactory().updateConditionType();this.invalidate()}}t.prototype.bindProperty.apply(this,arguments)};d.prototype.handleModelContextChange=function(e){t.prototype.handleModelContextChange.apply(this,arguments);const i=this.getBinding("value");if(i){const t=i.isA("sap.ui.model.CompositeBinding")?i.getBindings()[0].getContext():i.getContext();if(p.hasChanged(this._oBindingContext,t)){this._oBindingContext=t;this.getContentFactory().updateConditionType();if(this.isInvalidInput()||this._getValueHelp()){if(this._oManagedObjectModel){this._oManagedObjectModel.checkUpdate(true,true)}this.resetInvalidInput()}}if(!this.getContentFactory().getDataType()){this.getContentFactory().setDataType(i.getType());this.invalidate()}}};d.prototype.initDataType=function(){t.prototype.initDataType.apply(this,arguments);const e=this.getBinding("value");if(e){this.getContentFactory().setDataType(e.getType())}};d.prototype.setProperty=function(e,i,n){if(e==="value"&&this.isInvalidInput()&&s(this.getValue(),this.validateProperty(e,i))){if(this._oManagedObjectModel){this._oManagedObjectModel.checkUpdate(true,true)}this.resetInvalidInput()}return t.prototype.setProperty.apply(this,arguments)};d.prototype.setMaxConditions=function(t){if(t!==1){throw new Error("Only one condition allowed for Field "+this)}return this.setProperty("maxConditions",t,true)};d.prototype.observeChanges=function(e){t.prototype.observeChanges.apply(this,arguments);if(e.name==="value"){const t=c.call(this,e.current,e.old);if(this._vAdditionalValue!==null&&F.call(this)&&!f.call(this,t,this._vValue,true)){this._vAdditionalValue=this.getAdditionalValue()}this._vValue=t;T.call(this,e.current);g.call(this)}if(e.name==="additionalValue"){this._vAdditionalValue=e.current;g.call(this)}if(e.name==="valueState"){if(this._bPendingConditionUpdate){this._bKeepValueState=true}}if(e.name==="conditions"){if(this.getCurrentContent().length<=1){m.call(this,e.current)}}};function h(){return this._vValue}function u(){return this._vAdditionalValue}function g(){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){if(!this.isFieldDestroyed()){g.call(this)}}.bind(this));this._bPendingConditionUpdate=true;return}if(this.getDisplay()===i.Value){y.call(this,h.call(this),u.call(this))}else if(!this._iConditionUpdateTimer){this._iConditionUpdateTimer=setTimeout(function(){y.call(this,h.call(this),u.call(this));this._iConditionUpdateTimer=undefined}.bind(this),0);this._bPendingConditionUpdate=true}}function y(t,e){const i=this.getConditions();if(this.checkValueInitial(t)&&!e){if(i.length>0){this.setConditions([])}}else{const n=i[0];const s=n&&n.values[0];const l=n&&n.values[1]?n.values[1]:null;if(!n||n.operator!==a.EQ||!f.call(this,s,t)||!C.call(this,e,l)){const i=this.getControlDelegate();const a=i.createCondition(this,this,[t,e],n);if(!o.compareConditions(n,a)){this.setConditions(a?[a]:[])}}}this._bPendingConditionUpdate=false;this._bKeepValueState=false}function c(t,e){const i=this.getContentFactory().getDataType()?this.getContentFactory().getDataType().getMetadata().getName():this.getDataType();if(t&&e&&(i==="sap.ui.model.odata.type.Unit"||i==="sap.ui.model.odata.type.Currency")&&!t[2]&&e[2]!==undefined){t=l([],t);t[2]=e[2];if(this._bPendingChange){const i=this.getConditions()[0];if(i){if(t[0]===e[0]&&t[0]!==i.values[0][0]){t[0]=i.values[0][0]}if(t[1]===e[1]&&t[1]!==i.values[0][1]){t[1]=i.values[0][1]}}}}return t}function f(t,e,i){let a=t===e;const o=this.getContentFactory().getDataType()?this.getContentFactory().getDataType().getMetadata().getName():this.getDataType();if(!a&&this.getTypeMap().getBaseType(o)===n.Unit&&Array.isArray(t)&&Array.isArray(e)){const n=t[0];const o=t[1];const l=t.length>=3?t[2]:null;const r=e[0];const p=e[1];const d=e.length>=3?e[2]:null;if(n===r&&o===p&&((this._bUnitSet||i)&&(!l||!d)||s(l,d))){a=true}if((l||d)&&!i){this._bUnitSet=true}}return a}function C(t,e,i){let n=t===e;if(!n&&(t===null||t===undefined||t==="")&&(e===null||e===undefined||e==="")){n=true}return n}function T(t){if(!this._oTypeInitialization){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){if(!this.isFieldDestroyed()){T.call(this,t)}}.bind(this));return}const e=this.getBinding("value");const i=e?e.getType():this.getContentFactory().getDataType();if(i){this._oTypeInitialization=this.getTypeMap().initializeTypeFromValue(i,t);if(this._oTypeInitialization&&this.getContentFactory().getUnitOriginalType()){this.getTypeMap().initializeInternalType(this.getContentFactory().getDataType(),this._oTypeInitialization);this.getTypeMap().initializeInternalType(this.getContentFactory().getUnitType(),this._oTypeInitialization)}}}}d.prototype.fireChangeEvent=function(t,e,i,n){let a;if(t){if(e){a=this.getResultForChangePromise(t)}else{a=i}}if(this.getCurrentContent().length>1){if(t){m.call(this,this.getConditions())}else if(n){n=n.then(function(t){m.call(this,this.getConditions());return t}.bind(this))}}this.fireChange({value:a,valid:e,promise:n})};d.prototype.getResultForChangePromise=function(t){let e;if(t.length===0&&this.getContentFactory().getDataType()){e=this.getContentFactory().getDataType().parseValue("","string",[])}else if(t.length===1){e=t[0].values[0]}return e};function m(t){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){if(!this.isFieldDestroyed()){m.call(this,t)}}.bind(this));return}let e=null;let i=null;const n=this.getValue();const a=this.getAdditionalValue();if(t.length===0&&b(n)&&b(a)){return}e=this.getResultForChangePromise(t);e=v.call(this,e,n);if(t.length===0||t[0].values.length===1){if(a){const t=this.getContentFactory().getAdditionalDataType();if(t){i=t.parseValue("","string")}}else{i=a}}else if(t.length===1&&t[0].values.length>1){i=t[0].values[1]}this._vValue=e;this._vAdditionalValue=i;if(!f.call(this,e,n,true)){this.setProperty("value",e,true)}if(!C.call(this,i,a,true)&&!F.call(this)){this.setProperty("additionalValue",i,true)}}function v(t,e){const i=this.getContentFactory().getDataType()?this.getContentFactory().getDataType().getMetadata().getName():this.getDataType();if(this.getTypeMap().getBaseType(i)===n.Unit&&Array.isArray(t)&&Array.isArray(e)&&!this.checkValueInitial(t)&&this.checkValueInitial(e)){for(let i=0;i<t.length;i++){if(t[i]===null&&e[i]!==undefined){t[i]=e[i]}}}return t}d.prototype.getSupportedOperators=function(){return this.getProperty("_operators",[])};function F(){const t=this.getBinding("additionalValue");if(t&&t.getBindingMode()===r.OneWay){return true}return false}d.prototype.checkCreateInternalContent=function(){if(!this.isFieldDestroyed()&&this.getContentFactory().getDataType()&&!this.isFieldPropertyInitial("editMode")&&!this.isFieldPropertyInitial("multipleLines")){t.prototype.checkCreateInternalContent.apply(this,arguments)}};d.prototype.getOverflowToolbarConfig=function(){const e=t.prototype.getOverflowToolbarConfig.apply(this,arguments);e.propsUnrelatedToSize.push("value");e.propsUnrelatedToSize.push("additionalValue");return e};d.prototype.isSearchField=function(){return false};function b(t){let e=false;if(t===null){e=true}else if(Array.isArray(t)){e=true;for(let i=0;i<t.length;i++){if(t[i]!==null){e=false;break}}}return e}d.prototype.getAdditionalDataTypeConfiguration=function(){const t=this.getBinding("additionalValue");return t&&t.getType()};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/FilterBar", ["sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/mdc/p13n/subcontroller/AdaptFiltersController","sap/ui/mdc/filterbar/aligned/FilterContainer","sap/ui/mdc/filterbar/aligned/FilterItemLayout","sap/ui/mdc/filterbar/FilterBarBase","sap/ui/mdc/filterbar/FilterBarBaseRenderer","sap/m/library","sap/m/Button","sap/base/util/merge","sap/base/Log","sap/ui/core/library","sap/ui/mdc/enums/FilterBarP13nMode"],function(t,e,i,r,n,o,s,a,l,p,u,d){"use strict";const h=u.aria.HasPopup;const _=n.extend("sap.ui.mdc.FilterBar",{metadata:{designtime:"sap/ui/mdc/designtime/filterbar/FilterBar.designtime",properties:{showAdaptFiltersButton:{type:"boolean",defaultValue:true},showClearButton:{type:"boolean",defaultValue:false},p13nMode:{type:"sap.ui.mdc.enums.FilterBarP13nMode[]"},_p13nModeItem:{type:"boolean",visibility:"hidden",defaultValue:false}}},renderer:o});const c=s.ButtonType;_.prototype._createInnerLayout=function(){this._cLayoutItem=r;this._oFilterBarLayout=new i;this._oFilterBarLayout.getInner().setParent(this);this._oFilterBarLayout.getInner().addStyleClass("sapUiMdcFilterBarBaseAFLayout");this.setAggregation("layout",this._oFilterBarLayout,true);this._addButtons()};_.prototype.setP13nMode=function(i){this.setProperty("p13nMode",i||[],false);const r={helper:this.getPropertyHelper(),controller:{}};let n=false;i&&i.forEach(function(t){if(t=="Item"){n=true;r.controller["Item"]=new e({control:this})}}.bind(this));this._setP13nModeItem(n);r.controller["Filter"]=new t({control:this});this.getEngine().register(this,r);return this};_.prototype.setFilterConditions=function(e,i){t.checkConditionOperatorSanity(e);if(this._oP13nFB){this._oP13nFB.setFilterConditions(l({},e))}this.setProperty("filterConditions",e,i);return this};_.prototype._getP13nModeItem=function(){return this._oModel.getProperty("/_p13nModeItem")};_.prototype._setP13nModeItem=function(t){this._oModel.setProperty("/_p13nModeItem",t,true)};_.prototype._addButtons=function(){if(this._oFilterBarLayout){this.setProperty("_filterCount",this._oRb.getText("filterbar.ADAPT"),false);this._btnAdapt=new a(this.getId()+"-btnAdapt",{type:c.Transparent,text:"{"+n.INNER_MODEL_NAME+">/_filterCount}",press:this.onAdaptFilters.bind(this)});this._btnAdapt.setAriaHasPopup(h.ListBox);this._btnAdapt.setModel(this._oModel,n.INNER_MODEL_NAME);this._btnAdapt.bindProperty("visible",{parts:[{path:"/showAdaptFiltersButton",model:n.INNER_MODEL_NAME},{path:"/_p13nModeItem",model:n.INNER_MODEL_NAME}],formatter:function(t,e){return t&&e}});this._btnSearch=this._getSearchButton();this._btnSearch.setModel(this._oModel,n.INNER_MODEL_NAME);this._btnSearch.bindProperty("visible",{parts:[{path:"/showGoButton",model:n.INNER_MODEL_NAME},{path:"/liveMode",model:n.INNER_MODEL_NAME}],formatter:function(t,e){return t&&(this._isPhone()?true:!e)}.bind(this)});this._btnSearch.addStyleClass("sapUiMdcFilterBarBaseButtonPaddingRight");this._btnClear=new a(this.getId()+"-btnClear",{type:c.Transparent,visible:"{"+n.INNER_MODEL_NAME+">/showClearButton}",text:this._oRb.getText("filterbar.CLEAR"),press:function(t){this.onClear()}.bind(this)});this._btnClear.setModel(this._oModel,n.INNER_MODEL_NAME);this._oFilterBarLayout.addButton(this._btnSearch);this._oFilterBarLayout.addButton(this._btnClear);this._oFilterBarLayout.addButton(this._btnAdapt)}};_.prototype.onClear=function(){this._btnClear.setEnabled(false);this.awaitControlDelegate().then(function(t){t.clearFilters(this).catch(function(t){p.error(t)}).finally(function(){this._btnClear.setEnabled(true)}.bind(this))}.bind(this))};_.prototype.retrieveInbuiltFilter=function(){const t=n.prototype.retrieveInbuiltFilter.apply(this,arguments);return t.then(function(t){return t})};_.prototype.onAdaptFilters=function(t){return this._retrieveMetadata().then(function(){return this.getEngine().show(this,"Item",{reset:function(){this.getEngine().reset(this);this._getConditionModel().checkUpdate(true)}.bind(this)}).then(function(t){return t})}.bind(this))};_.prototype.getCurrentState=function(){const t=n.prototype.getCurrentState.apply(this,arguments);if(!this.getProperty("_p13nModeItem")){delete t.items}return t};_.prototype.setFocusOnFirstErroneousField=function(){return this._setFocusOnFirstErroneousField()};_.prototype.exit=function(){n.prototype.exit.apply(this,arguments);this._btnClear=undefined};return _});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/FilterBarDelegate", ["sap/ui/mdc/AggregationBaseDelegate","sap/ui/mdc/enums/FilterBarValidationStatus"],function(e,t){"use strict";const s=Object.assign({},e);s.addItem=function(t,s,r){return e.addItem(t,s,r)};s.removeItem=function(t,s,r){return e.removeItem(t,s,r)};s.addCondition=function(e,t,s){return Promise.resolve()};s.removeCondition=function(e,t,s){return Promise.resolve()};s.fetchProperties=function(t){return e.fetchProperties(t)};s.clearFilters=function(e){return Promise.resolve()};s.determineValidationState=function(e){return e.checkFilters()};s.visualizeValidationState=function(e,s){let r;if(s.status===t.NoError){return}if(s.status===t.RequiredHasNoValue){r=e.getText("filterbar.REQUIRED_CONDITION_MISSING")}else if(s.status===t.FieldInErrorState){r=e.getText("filterbar.VALIDATION_ERROR")}if(e.getShowMessages()&&!e._isLiveMode()&&!e._hasOpenMessageBox){sap.ui.require(["sap/m/MessageBox","sap/base/Log"],function(t,s){try{if(e._bIsBeingDestroyed){return}e._hasOpenMessageBox=true;t.error(r,{styleClass:this.$()&&this.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":"",onClose:function(){delete e._hasOpenMessageBox;e.setFocusOnFirstErroneousField()}})}catch(e){s.error(e.message)}})}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/FilterField", ["sap/ui/mdc/field/FieldBase","sap/ui/mdc/field/FieldBaseRenderer","sap/ui/mdc/enums/FieldDisplay","sap/base/util/merge","sap/base/util/deepEqual"],function(t,e,r,i,o){"use strict";const n=t.extend("sap.ui.mdc.FilterField",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/field/FilterField.designtime",properties:{operators:{type:"string[]",group:"Data",defaultValue:[]},defaultOperator:{type:"string",group:"Data",defaultValue:null},propertyKey:{type:"string",group:"Data",defaultValue:""},additionalDataType:{type:"object",group:"Data",defaultValue:null}},events:{change:{parameters:{value:{type:"string"},valid:{type:"boolean"},conditions:{type:"object[]"},promise:{type:"boolean"}}}}},renderer:e});n.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oObserver.observe(this,{properties:["operators","propertyKey","additionalDataType"]})};n.prototype.exit=function(){t.prototype.exit.apply(this,arguments)};n.prototype.getPropertyKey=function(){let t=this.getProperty("propertyKey");if(!t){t=this.getFieldPath()}return t};n.prototype.setProperty=function(e,r,i){if(e==="conditions"&&this.isInvalidInput()&&o(this.getConditions(),this.validateProperty(e,r))){if(this._oManagedObjectModel){this._oManagedObjectModel.checkUpdate(true,true)}this.resetInvalidInput()}return t.prototype.setProperty.apply(this,arguments)};n.prototype.observeChanges=function(e){t.prototype.observeChanges.apply(this,arguments);if(e.name==="operators"){if(e.current.length===0){t.prototype.getSupportedOperators.apply(this,[])}else{this.setProperty("_operators",e.current,true)}this.updateInternalContent()}else if(e.name==="propertyKey"){this.updateInternalContent()}else if(e.name==="additionalDataType"){p.call(this,e.current)}};n.prototype.fireChangeEvent=function(t,e,r,o){let n;if(t){if(e){if(t.length==1){n=t[0].values[0]}}else{n=r}}this.fireChange({value:n,valid:e,conditions:i([],t),promise:o})};n.prototype.getSupportedOperators=function(){let e=this.getOperators();if(e.length===0){e=t.prototype.getSupportedOperators.apply(this,arguments)}else{this.setProperty("_operators",e,true)}return e};n.prototype.setOperators=function(t){const e=[];if(!Array.isArray(t)){t=t.split(",")}t.forEach(function(t){if(typeof t==="string"){e.push(t)}else{e.push(t.name)}});this.setProperty("operators",e);return this};n.prototype.addOperator=function(t){const e=this.getSupportedOperators();let r=t;if(typeof t!=="string"){r=t.name}if(e.indexOf(r)<0){e.push(r);this.setOperators(e)}return this};n.prototype.addOperators=function(t){if(!Array.isArray(t)){t=[t]}t.forEach(function(t){this.addOperator(t)}.bind(this));return this};n.prototype.removeOperator=function(t){const e=this.getSupportedOperators();let r=t;if(typeof t!=="string"){r=t.name}if(e.indexOf(r)>-1){e.splice(e.indexOf(r),1);this.setOperators(e)}};n.prototype.removeOperators=function(t){if(!Array.isArray(t)){t=[t]}t.forEach(function(t){this.removeOperator(t)}.bind(this))};n.prototype.removeAllOperators=function(){this.setOperators([])};n.prototype.setDefaultOperator=function(t){let e=t;if(t&&typeof t!=="string"){e=t.name}this.setProperty("defaultOperator",e);return this};n.prototype.checkCreateInternalContent=function(){if(!this.isFieldDestroyed()&&!this.isPropertyInitial("dataType")){const e=this._getValueHelp();const i=sap.ui.getCore().byId(e);const o=this.getBindingInfo("conditions");const n=this.getBinding("conditions");if(this.getDisplay()!==r.Value&&e&&(!i||o&&!n)){return}t.prototype.checkCreateInternalContent.apply(this,arguments)}};n.prototype.handleModelContextChange=function(e){t.prototype.handleModelContextChange.apply(this,arguments);if(this.getCurrentContent().length===0){this.triggerCheckCreateInternalContent()}};n.prototype.isSearchField=function(){if(this.isPropertyInitial("propertyKey")){return t.prototype.isSearchField.apply(this,arguments)}else{const t=this.getPropertyKey();const e=new RegExp("^\\*(.*)\\*|\\$search$");return e.test(t)&&this.getMaxConditions()===1}};function p(t){if(!t){this.getContentFactory().setAdditionalDataType()}else if(t.isA&&t.isA("sap.ui.model.Type")){this.getContentFactory().setAdditionalDataType(t)}else if(t.name){this.getContentFactory().setAdditionalDataType()}else{throw new Error("invalid type configuration")}}n.prototype.getAdditionalDataTypeConfiguration=function(){return this.getAdditionalDataType()};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/Link", ["sap/ui/mdc/field/FieldInfoBase","sap/ui/thirdparty/jquery","sap/ui/model/BindingMode","sap/ui/model/json/JSONModel","sap/ui/mdc/link/Log","sap/base/Log","sap/ui/mdc/link/Panel","sap/ui/mdc/link/PanelItem","sap/ui/layout/form/SimpleForm","sap/ui/core/Title","sap/ui/layout/library","sap/ui/mdc/enums/LinkType"],function(t,jQuery,e,n,i,o,r,s,a,l,d,u){"use strict";const c=d.form.SimpleFormLayout.ResponsiveGridLayout;const p=t.extend("sap.ui.mdc.Link",{metadata:{library:"sap.ui.mdc",properties:{enablePersonalization:{type:"boolean",defaultValue:true},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/LinkDelegate",payload:{}}}},associations:{sourceControl:{type:"sap.ui.core.Control",multiple:false}}}});p.prototype.applySettings=function(){t.prototype.applySettings.apply(this,arguments);this.initControlDelegate()};p.prototype.init=function(){const i=new n({contentTitle:undefined,linkItems:[]});i.setDefaultBindingMode(e.TwoWay);i.setSizeLimit(1e3);this.setModel(i,"$sapuimdcLink");this.attachEvent("modelContextChange",this.fireDataUpdate,this);this._oLinkType=null;this._bLinkItemsFetched=false;this._aLinkItems=[];t.prototype.init.apply(this,arguments)};p.prototype.exit=function(){this._bLinkItemsFetched=undefined;this._oLinkType=undefined;this._oUseDelegateItemsPromise=undefined;this._oUseDelegateAdditionalContentPromise=undefined;if(this._aLinkItems){this._aLinkItems.forEach(function(t){t.destroy()});this._aLinkItems=undefined}if(this._aAdditionalContent){this._aAdditionalContent.forEach(function(t){t.destroy()});this._aAdditionalContent=undefined}t.prototype.exit.apply(this,arguments)};p.prototype.isTriggerable=function(){return this.retrieveLinkType().then(function(t){if(!t){return false}const e=t.runtimeType;const n=t.initialType?t.initialType:t;if(e&&e instanceof Promise){e.then(function(t){if(!this._oLinkType||t.linkType!==this._oLinkType.linkType){this._oLinkType=t;this.fireDataUpdate()}}.bind(this))}return this._oLinkType?this._oLinkType.type===u.DirectLink||this._oLinkType.type===u.Popover:n.type===u.DirectLink||n.type===u.Popover}.bind(this))};p.prototype.getTriggerHref=function(){return this.getDirectLinkHrefAndTarget().then(function(t){return t?t.href:null})};p.prototype.getDirectLinkHrefAndTarget=function(){return this._retrieveDirectLinkItem().then(function(t){if(this.isDestroyed()){return null}this.addDependent(t);return t?{target:t.getTarget(),href:t.getHref()}:null}.bind(this))};p.prototype._retrieveDirectLinkItem=function(){return this.retrieveLinkType().then(function(t){if(!t){return null}if(this._linkTypeHasDirectLink(this._oLinkType)){return this._oLinkType.directLink}const e=t.initialType?t.initialType:t;if(this._linkTypeHasDirectLink(e)){return e.directLink}return null}.bind(this))};p.prototype._linkTypeHasDirectLink=function(t){return t&&t.type===u.DirectLink&&t.directLink};p.prototype.getContent=function(t){const e=this.retrieveLinkItems();const i=this.retrieveAdditionalContent();return Promise.all([e,i]).then(function(e){const i=e[0];const o=e[1];return new Promise(function(e){sap.ui.require(["sap/ui/fl/Utils","sap/ui/fl/apply/api/FlexRuntimeInfoAPI"],function(a,l){this._setConvertedLinkItems(i);const d=this._getInternalModel().getProperty("/linkItems");const u=this._getInternalModel().getProperty("/baselineLinkItems");const c=!o.length&&!d.length?this._getNoContent():o;const p=this._createPanelId(a,l);const h=sap.ui.getCore().byId(p);if(h){if(h.getParent()&&h.getParent().close){h.getParent().close()}h.destroy()}const f=new r(p,{enablePersonalization:this.getEnablePersonalization(),items:u.map(function(t){return new s(t.key,{text:t.text,description:t.description,href:t.href,internalHref:t.internalHref,target:t.target,icon:t.icon,visible:true})}),additionalContent:c,beforeSelectionDialogOpen:function(){if(t&&t()){t().setModal(true)}},afterSelectionDialogClose:function(){if(t&&t()){t().setModal(false)}},beforeNavigationCallback:this._beforeNavigationCallback.bind(this),metadataHelperPath:"sap/ui/mdc/Link"});f.setModel(new n({metadata:jQuery.extend(true,[],this._getInternalModel().getProperty("/linkItems")),baseline:jQuery.extend(true,[],this._getInternalModel().getProperty("/baselineLinkItems"))}),"$sapuimdcLink");this._setAdditionalContent(undefined);return e(f)}.bind(this))}.bind(this))}.bind(this))};p.prototype.checkDirectNavigation=function(){const t=this.retrieveLinkItems();const e=this.retrieveAdditionalContent();return Promise.all([t,e]).then(function(t){const e=t[0];const n=t[1];this._setConvertedLinkItems(e);const i=this._getInternalModel().getProperty("/linkItems");if(i.length===1&&!n.length){r.navigate(i[0].href);return Promise.resolve(true)}return Promise.resolve(false)}.bind(this))};p.prototype._setConvertedLinkItems=function(t){const e=this._getInternalModel();const n=t.map(function(t){if(!t.getKey()){o.error("sap.ui.mdc.Link: undefined 'key' property of the LinkItem "+t.getId()+". The mandatory 'key' property should be defined due to personalization reasons.")}return{key:t.getKey(),text:t.getText(),description:t.getDescription(),href:t.getHref(),internalHref:t.getInternalHref(),target:t.getTarget(),icon:t.getIcon(),initiallyVisible:t.getInitiallyVisible(),visible:false}});e.setProperty("/linkItems/",n);const i=n.filter(function(t){return t.initiallyVisible});e.setProperty("/baselineLinkItems/",i)};p.prototype._getNoContent=function(){const t=new a({layout:c,content:[new l({text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("info.POPOVER_MSG_NO_CONTENT")})]});t.addStyleClass("mdcbaseinfoPanelDefaultAdditionalContent");return t};p.prototype._createPanelId=function(t,e){let n;if(this.getParent()){n=this.getParent()}let i=this._getSourceControl();if(!i){this.setSourceControl(n);i=n}if(!e.isFlexSupported({element:this})||!e.isFlexSupported({element:i})){o.error("Invalid component. The mandatory 'sourceControl' association should be assigned to the app component due to personalization reasons.");return this.getId()+"-idInfoPanel"}const r=t.getAppComponentForControl(i)||t.getAppComponentForControl(n);return r.createId("idInfoPanel")};p.retrieveAllMetadata=function(t){if(!t.getModel||!t.getModel("$sapuimdcLink")){return[]}const e=t.getModel("$sapuimdcLink");return e.getProperty("/metadata").map(function(t){return{id:t.key,text:t.text,description:t.description,href:t.href,internalHref:t.internalHref,target:t.target,visible:t.visible}})};p.retrieveBaseline=function(t){if(!t.getModel||!t.getModel("$sapuimdcLink")){return[]}const e=t.getModel("$sapuimdcLink");return e.getProperty("/baseline").map(function(t){return{id:t.key,visible:true}})};p.prototype._getInfoLog=function(){if(this.getPayload()&&this.getPayload().semanticObjects){if(this._oInfoLog){return this._oInfoLog}if(o.getLevel()>=o.Level.INFO){this._oInfoLog=new i;this._oInfoLog.initialize(this.getPayload().semanticObjects,this._getContextObject(this._getControlBindingContext()));return this._oInfoLog}}return undefined};p.prototype._getContextObject=function(t){return t?t.getObject(t.getPath()):undefined};p.prototype.retrieveAdditionalContent=function(){if(this._aAdditionalContent){return Promise.resolve(this._aAdditionalContent)}else{this._oUseDelegateAdditionalContentPromise=this._useDelegateAdditionalContent();return this._oUseDelegateAdditionalContentPromise.then(function(){return Promise.resolve(this._aAdditionalContent)}.bind(this))}};p.prototype._useDelegateAdditionalContent=function(){if(this.awaitControlDelegate()){return this.awaitControlDelegate().then(function(){return new Promise(function(t){this.getControlDelegate().fetchAdditionalContent(this,this).then(function(e){this._setAdditionalContent(e===null?[]:e);t()}.bind(this))}.bind(this))}.bind(this))}o.error("mdc.Link retrieveAdditionalContent: control delegate is not set - could not load AdditionalContent from delegate.");return Promise.resolve([])};p.prototype._setAdditionalContent=function(t){this._aAdditionalContent=t};p.prototype.retrieveLinkType=function(){if(this.awaitControlDelegate()){return this.awaitControlDelegate().then(function(){return this._bIsBeingDestroyed?Promise.resolve():this.getControlDelegate().fetchLinkType(this)}.bind(this))}o.error("mdc.Link retrieveLinkType: control delegate is not set - could not load LinkType from delegate.");return Promise.resolve(null)};p.prototype.retrieveLinkItems=function(){const t=this._getControlBindingContext();return this._retrieveUnmodifiedLinkItems().then(function(e){return this.getControlDelegate().modifyLinkItems(this,t,e).then(function(t){return t})}.bind(this))};p.prototype._retrieveUnmodifiedLinkItems=function(){if(this._bLinkItemsFetched){return Promise.resolve(this._aLinkItems)}else{this._oUseDelegateItemsPromise=this._useDelegateItems();return this._oUseDelegateItemsPromise.then(function(){return Promise.resolve(this._aLinkItems)}.bind(this))}};p.prototype._useDelegateItems=function(){if(this.awaitControlDelegate()){return this.awaitControlDelegate().then(function(){const t=this._getControlBindingContext();const e=this._getInfoLog();return new Promise(function(n){this.getControlDelegate().fetchLinkItems(this,t,e).then(function(t){this._setLinkItems(t===null?[]:t);this._bLinkItemsFetched=t!==null;n()}.bind(this))}.bind(this))}.bind(this))}o.error("mdc.Link _useDelegateItems: control delegate is not set - could not load LinkItems from delegate.");return Promise.resolve()};p.prototype._setLinkItems=function(t){const e=t.filter(function(t){return t.getParent()===null});e.forEach(function(t){this.addDependent(t)}.bind(this));this._aLinkItems=t};p.prototype._beforeNavigationCallback=function(t){if(this.awaitControlDelegate()){return this.getControlDelegate().beforeNavigationCallback(this,t)}o.error("mdc.Link _beforeNavigationCallback: control delegate is not set - could not load beforeNavigationCallback from delegate.");return Promise.resolve()};p.prototype._getControlBindingContext=function(){const t=this._getSourceControl();return t&&t.getBindingContext()||this.getBindingContext()};p.prototype._getInternalModel=function(){return this.getModel("$sapuimdcLink")};p.prototype._getSourceControl=function(){return typeof this.getSourceControl()==="string"?sap.ui.getCore().byId(this.getSourceControl()):this.getSourceControl()};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/LinkDelegate", ["sap/ui/mdc/BaseDelegate","sap/ui/mdc/enums/LinkType"],function(e,n){"use strict";const i=Object.assign({},e);i.fetchLinkItems=function(e,n,i){return Promise.resolve(null)};i.fetchLinkType=function(e){return Promise.resolve({initialType:{type:n.Popover,directLink:undefined},runtimeType:null})};i.fetchAdditionalContent=function(e){return Promise.resolve([])};i.modifyLinkItems=function(e,n,i){return Promise.resolve(i)};i.beforeNavigationCallback=function(e,n){return Promise.resolve(true)};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/MultiValueField", ["sap/ui/mdc/library","sap/ui/mdc/field/FieldBase","sap/ui/mdc/field/FieldBaseRenderer","sap/ui/mdc/condition/Condition","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName"],function(t,e,i,n,o,a){"use strict";const s=e.extend("sap.ui.mdc.MultiValueField",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/field/MultiValueField.designtime",properties:{delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/field/MultiValueFieldDelegate",payload:{}}}},aggregations:{items:{type:"sap.ui.mdc.field.MultiValueFieldItem",multiple:true,singularName:"item",bindable:"bindable"}},defaultAggregation:"items",events:{change:{parameters:{items:{type:"sap.ui.mdc.field.MultiValueFieldItem[]"},valid:{type:"boolean"},promise:{type:"Promise"}}}}},renderer:i});s.prototype.init=function(){e.prototype.init.apply(this,arguments);this.setProperty("_operators",[a.EQ],true);this._oObserver.observe(this,{aggregations:["items"]})};s.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._iConditionUpdateTimer){clearTimeout(this._iConditionUpdateTimer);delete this._iConditionUpdateTimer}};s.prototype.bindAggregation=function(t,i){if(t==="items"&&!i.formatter){r.call(this,i)}e.prototype.bindAggregation.apply(this,arguments)};function r(t){if(t.template){let e;if(t.template.mBindingInfos.key){const i=t.template.mBindingInfos.key;e=this.getContentFactory().getDataType();if(i.type&&(!e||e.getMetadata().getName()!==i.type.getMetadata().getName())){this._oContentFactory.setDataType(i.type);this.invalidate()}}if(t.template.mBindingInfos.description){const i=t.template.mBindingInfos.description;e=this.getContentFactory().getAdditionalDataType();if(i.type&&(!e||e.getMetadata().getName()!==i.type.getMetadata().getName())){this._oContentFactory.setAdditionalDataType(i.type);this.invalidate()}}}}s.prototype.handleModelContextChange=function(t){e.prototype.handleModelContextChange.apply(this,arguments);if(!this._oDataType){const t=this.getBinding("items");if(t){r.call(this,t)}}};s.prototype.initDataType=function(){e.prototype.initDataType.apply(this,arguments);const t=this.getBindingInfo("items");if(t){r.call(this,t)}};s.prototype.setMaxConditions=function(t){if(t===1){throw new Error("Multiple Conditions needed on MultiValueField "+this)}return this.setProperty("maxConditions",t,true)};s.prototype.observeChanges=function(t){e.prototype.observeChanges.apply(this,arguments);if(t.name==="items"){p.call(this,t.child,t.mutation)}if(t.name==="key"){l.call(this)}if(t.name==="description"){l.call(this)}if(t.name==="conditions"){d.call(this,t.current)}};function p(t,e){if(e==="insert"){this._oObserver.observe(t,{properties:true})}else{this._oObserver.unobserve(t)}if(!this._bMyItemUpdate){l.call(this)}}function d(t){if(this._bConditionsUpdateFromItems){return}if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){if(!this.bIsDestroyed){d.call(this.getConditions())}}.bind(this));return}this.getControlDelegate().updateItems(this.getPayload(),t,this)}function l(){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){if(!this.bIsDestroyed){l.call(this)}}.bind(this));return}if(!this._iConditionUpdateTimer){this._iConditionUpdateTimer=setTimeout(function(){h.call(this);this._iConditionUpdateTimer=undefined}.bind(this),0)}}function h(){const t=this.getItems();const e=[];for(let i=0;i<t.length;i++){const a=t[i];const s=n.createItemCondition(u(a,"key"),u(a,"description"));s.validated=o.Validated;e.push(s)}this._bConditionsUpdateFromItems=true;this.setConditions(e);this._bConditionsUpdateFromItems=false}function u(t,e){const i=t.getBinding(e);if(i){return i.getInternalValue()}else{return t.getProperty(e)}}s.prototype.fireChangeEvent=function(t,e,i,n){this.fireChange({items:this.getItems(),valid:e,promise:n})};s.prototype.getResultForChangePromise=function(t){return this.getItems()};s.prototype.getSupportedOperators=function(){return this.getProperty("_operators",[])};s.prototype.checkCreateInternalContent=function(){if(!this.bIsDestroyed&&this._oContentFactory.getDataType()&&!this.isFieldPropertyInitial("editMode")){e.prototype.checkCreateInternalContent.apply(this,arguments)}};s.prototype.isSearchField=function(){return false};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/Table", ["./Control","./ActionToolbar","./table/TableSettings","./table/GridTableType","./table/TreeTableType","./table/ResponsiveTableType","./table/PropertyHelper","./table/utils/Personalization","./mixin/FilterIntegrationMixin","sap/m/Text","sap/m/ToolbarSpacer","sap/m/Button","sap/m/Title","sap/m/OverflowToolbar","sap/m/library","sap/m/table/Util","sap/m/table/columnmenu/Menu","sap/m/MessageBox","sap/m/plugins/PluginBase","sap/ui/core/Core","sap/ui/core/format/NumberFormat","sap/ui/core/format/ListFormat","sap/ui/core/library","sap/ui/events/KeyCodes","sap/ui/model/base/ManagedObjectModel","sap/base/strings/capitalize","sap/base/util/deepEqual","sap/base/util/Deferred","sap/ui/core/InvisibleText","sap/ui/mdc/p13n/subcontroller/ColumnController","sap/ui/mdc/p13n/subcontroller/SortController","sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/mdc/p13n/subcontroller/GroupController","sap/ui/mdc/p13n/subcontroller/AggregateController","sap/m/table/ColumnWidthController","sap/ui/mdc/actiontoolbar/ActionToolbarAction","sap/ui/mdc/table/menu/QuickActionContainer","sap/ui/mdc/table/menu/ItemContainer","sap/ui/mdc/enums/ProcessingStrategy","sap/ui/core/theming/Parameters","sap/base/Log","sap/ui/performance/trace/FESRHelper","sap/ui/mdc/enums/TableMultiSelectMode","sap/ui/mdc/enums/TableSelectionMode","sap/ui/mdc/enums/TableP13nMode","sap/ui/mdc/enums/TableType","sap/ui/mdc/enums/TableGrowingMode","sap/ui/mdc/enums/TableRowAction","sap/ui/mdc/enums/TableRowCountMode"],function(t,e,i,o,n,s,r,a,l,u,p,h,d,c,g,f,_,y,b,m,T,C,x,E,B,P,I,A,S,M,D,w,R,v,F,z,H,O,L,N,V,k,j,G,U,K){"use strict";const W=g.ToolbarDesign;const q=g.ToolbarStyle;const Q=g.IllustratedMessageType;const X=x.TitleLevel;const $=x.SortOrder;const Y=new window.WeakMap;const J=function(t){if(!Y.has(t)){Y.set(t,{oFilterInfoBar:null})}return Y.get(t)};const Z={Table:o,TreeTable:n,ResponsiveTable:s,null:o};const tt=t.extend("sap.ui.mdc.Table",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/table/Table.designtime",interfaces:["sap.ui.mdc.IFilterSource","sap.ui.mdc.IxState"],defaultAggregation:"columns",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null,invalidate:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null,invalidate:true},p13nMode:{type:"sap.ui.mdc.enums.TableP13nMode[]",defaultValue:[]},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/TableDelegate",payload:{}}},headerLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:X.Auto},headerStyle:{type:"sap.ui.core.TitleLevel",group:"Appearance"},autoBindOnInit:{type:"boolean",group:"Misc",defaultValue:true},header:{type:"string",group:"Misc",defaultValue:null},headerVisible:{type:"boolean",group:"Misc",defaultValue:true},useColumnLabelsAsTooltips:{type:"boolean",group:"Misc",defaultValue:false},selectionMode:{type:"sap.ui.mdc.enums.TableSelectionMode",defaultValue:G.None},showRowCount:{type:"boolean",group:"Misc",defaultValue:true},threshold:{type:"int",group:"Appearance",defaultValue:-1},sortConditions:{type:"object"},filterConditions:{type:"object",defaultValue:{}},groupConditions:{type:"object"},aggregateConditions:{type:"object"},enableExport:{type:"boolean",defaultValue:false},busyIndicatorDelay:{type:"int",defaultValue:100},enableColumnResize:{type:"boolean",group:"Behavior",defaultValue:true},showPasteButton:{type:"boolean",group:"Behavior",defaultValue:false},enablePaste:{type:"boolean",group:"Behavior",defaultValue:true},multiSelectMode:{type:"sap.ui.mdc.enums.TableMultiSelectMode",group:"Behavior",defaultValue:j.Default},enableAutoColumnWidth:{type:"boolean",group:"Behavior",defaultValue:false},propertyInfo:{type:"object",defaultValue:[]}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},type:{type:"sap.ui.mdc.table.TableTypeBase",altTypes:["sap.ui.mdc.enums.TableType"],multiple:false},columns:{type:"sap.ui.mdc.table.Column",multiple:true},creationRow:{type:"sap.ui.mdc.table.CreationRow",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_createToolbar",aggregation:"actions"}},variant:{type:"sap.ui.fl.variants.VariantManagement",multiple:false},quickFilter:{type:"sap.ui.core.Control",multiple:false},rowSettings:{type:"sap.ui.mdc.table.RowSettings",multiple:false},dataStateIndicator:{type:"sap.m.plugins.DataStateIndicator",multiple:false},noData:{type:"sap.ui.core.Control",multiple:false,altTypes:["string"]},copyProvider:{type:"sap.m.plugins.CopyProvider",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false},cellSelector:{type:"sap.m.plugins.CellSelector",multiple:false}},associations:{filter:{type:"sap.ui.mdc.IFilter",multiple:false}},events:{rowPress:{parameters:{bindingContext:{type:"sap.ui.model.Context"}}},selectionChange:{parameters:{selectAll:{type:"boolean"}}},beforeExport:{parameters:{exportSettings:{type:"object"},userExportSettings:{type:"object"},filterSettings:{type:"object[]"}}},paste:{parameters:{data:{type:"string[][]"}}},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{bindingContext:{type:"sap.ui.model.Context"},column:{type:"sap.ui.mdc.table.Column"}}}}},constructor:function(){this._createInitPromises();t.apply(this,arguments);this.bCreated=true;this._updateAdaptation();this._initializeContent()},renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e);t.class("sapUiMdcTable");t.style("width",e.getWidth());e._getType().getTableStyleClasses().forEach(e=>{t.class(e)});t.openEnd();t.renderControl(e.getAggregation("_content"));t.close("div")}}});const et=["variant","quickFilter"];l.call(tt.prototype);et.forEach(function(t){const e=P(t),i="_o"+e,o="get"+e,n="set"+e,s="destroy"+e;tt.prototype[o]=function(){return this[i]};tt.prototype[s]=function(){const t=this[i];this[n]();if(t){t.destroy()}return this};tt.prototype[n]=function(e){this.validateAggregation(t,e,false);const n=this._createToolbar(),s=e!==this[i];if(!e||s){n.removeBetween(this[o]());this[i]=e}if(s&&e){this._setToolbarBetween(n)}if(t==="variant"){this._updateVariantManagementStyle()}return this}});tt.prototype.init=function(){t.prototype.init.apply(this,arguments);this.mSkipPropagation={rowSettings:true};this._bForceRebind=true;this._setPropertyHelperClass(r);this._setupPropertyInfoStore("propertyInfo");this._oManagedObjectModel=new B(this);this.setModel(this._oManagedObjectModel,"$sap.ui.mdc.Table")};tt.prototype.applySettings=function(e,i){if(e&&"type"in e){const o={type:e.type};if("delegate"in e){o.delegate=e.delegate;delete e.delegate}delete e.type;t.prototype.applySettings.call(this,o,i)}t.prototype.applySettings.call(this,e,i);this.initControlDelegate()};tt.prototype._setToolbarBetween=function(t){[this._oVariant,this._oQuickFilter].forEach(function(e){if(e){t.addBetween(e)}})};tt.prototype.initialized=function(){return this._oTableReady.promise};tt.prototype._fullyInitialized=function(){return this._oFullInitialize.promise};["CopyProvider","CellSelector","DataStateIndicator"].forEach(t=>{tt.prototype[`get${t}PluginOwner`]=function(){return this._oTable||this._oFullInitialize?.promise}});tt.prototype.setCopyProvider=function(t){this.setAggregation("copyProvider",t,true);if(window.isSecureContext&&t&&!m.byId(this.getId()+"-copy")){this._oToolbar?.insertEnd(this._getCopyButton(),0)}return this};tt.prototype.attachEvent=function(e){t.prototype.attachEvent.apply(this,arguments);if(e=="rowPress"){this._getType().prepareRowPress()}return this};tt.prototype.detachEvent=function(e){t.prototype.detachEvent.apply(this,arguments);if(e=="rowPress"){this._getType().cleanupRowPress()}return this};tt.prototype.getColumnClipboardSettings=function(t){return this.getPropertyHelper().getColumnClipboardSettings(t)};tt.prototype.setDataStateIndicator=function(t){this._handleDataStateEvents(this.getDataStateIndicator(),"detach");this.setAggregation("dataStateIndicator",t,true);this._handleDataStateEvents(this.getDataStateIndicator(),"attach");return this};tt.prototype._handleDataStateEvents=function(t,e){if(t){t[e+"ApplyFilter"](this._onApplyMessageFilter,this);t[e+"ClearFilter"](this._onClearMessageFilter,this);t[e+"Event"]("filterInfoPress",function(){a.openFilterDialog(this)},this)}};tt.prototype._onApplyMessageFilter=function(t){this._oMessageFilter=t.getParameter("filter");t.preventDefault();if(this.isTableBound()){this.rebind()}};tt.prototype._onClearMessageFilter=function(t){this._oMessageFilter=null;t.preventDefault();if(this.isTableBound()){this.rebind()}};tt.prototype._isOfType=function(t,e){const i=this._getType();if(e){return i.isA(Z[t].getMetadata().getName())}else{return i.constructor===Z[t]}};tt.prototype.setContextMenu=function(t){this._oContextMenu=this.validateAggregation("contextMenu",t,false);if(!this._oTable){return this}this._oTable.setAggregation("contextMenu",t,true);if(!t){this._oTable.detachBeforeOpenContextMenu(this._onBeforeOpenContextMenu,this);return this}if(!this._oTable.hasListeners("beforeOpenContextMenu")){this._oTable.attachBeforeOpenContextMenu(this._onBeforeOpenContextMenu,this)}return this};tt.prototype._onBeforeOpenContextMenu=function(t){const e=this._getType().getContextMenuParameters(t);this.fireBeforeOpenContextMenu(e)};tt.prototype.getContextMenu=function(){return this._oContextMenu&&!this._oContextMenu.isDestroyed()?this._oContextMenu:null};tt.prototype.destroyContextMenu=function(){if(this._oTable){this._oTable.destroyContextMenu()}else if(this._oContextMenu){this._oContextMenu.destroy()}this._oContextMenu=null;return this};tt.prototype.scrollToIndex=function(t){if(typeof t!=="number"){return Promise.reject("The iIndex parameter has to be a number")}return this._getType().scrollToIndex(t)};tt.prototype.focusRow=function(t,e){return this.scrollToIndex(t).then(function(){return this._oTable._setFocus(t,e)}.bind(this))};tt.prototype.setType=function(t){if(!this.bCreated||this.getType()==t){return this.setAggregation("type",t,true)}if(this._oToolbar){this._getType().removeToolbar()}this._destroyDefaultType();this.setAggregation("type",t);if(this._oTable){const t=this.getNoData();this.setNoData();this._vNoData=t;const e=this.getContextMenu();this.setContextMenu();this._oContextMenu=e;this._oTable.destroy("KeepDom");this._oTable=null}else{this._onAfterInitialization("Type changed");this._onAfterFullInitialization("Type changed")}if(this._oRowTemplate){this._oRowTemplate.destroy();this._oRowTemplate=null}this._createInitPromises();this._initializeContent();return this};tt.prototype._getType=function(){const t=this.getType();if(!this._oDefaultType&&(typeof t==="string"||t===null)){this._oDefaultType=new Z[t];this.addDependent(this._oDefaultType)}return this._oDefaultType||this.getType()};tt.prototype._destroyDefaultType=function(){if(this._oDefaultType){this._oDefaultType.destroy();delete this._oDefaultType}};tt.prototype.setRowSettings=function(t){this.setAggregation("rowSettings",t,true);this._getType().updateRowSettings();if(this.isTableBound()){this._bForceRebind=true;this.rebind()}return this};tt.prototype.setHeaderLevel=function(t){if(this.getHeaderLevel()===t){return this}this.setProperty("headerLevel",t,true);this._oTitle&&this._oTitle.setLevel(t);this._updateVariantManagementStyle();return this};tt.prototype.setHeaderStyle=function(t){if(this.getHeaderStyle()===t){return this}this.setProperty("headerStyle",t,true);this._oTitle&&this._oTitle.setTitleStyle(this.getHeaderStyle()||X.H4);this._updateVariantManagementStyle();return this};tt.prototype.focus=function(t){if(this._oTable){this._oTable.focus(t)}};tt.prototype.setBusy=function(t){this.setProperty("busy",t,true);if(this._oTable){this._oTable.setBusy(t)}return this};tt.prototype.setBusyIndicatorDelay=function(t){this.setProperty("busyIndicatorDelay",t,true);if(this._oTable){this._oTable.setBusyIndicatorDelay(t)}return this};tt.prototype.setCreationRow=function(t){this.setAggregation("creationRow",t,true);if(t){t.update()}return this};tt.prototype.setEnableColumnResize=function(t){const e=this.getEnableColumnResize();this.setProperty("enableColumnResize",t,true);if(this.getEnableColumnResize()!==e){this._updateColumnResize();this._updateAdaptation()}return this};const it=function(t){let e=false;if(t&&(t.indexOf("Sort")>-1||t.indexOf("Column")>-1||t.indexOf("Group")>-1||t.indexOf("Aggregate")>-1||t.indexOf("Filter")>-1)){e=true}return e};tt.prototype._onModifications=function(t){if(it(t)&&this.isTableBound()){this.rebind()}if(!this.isPropertyHelperFinal()){this._bFinalzingPropertiesOnModification=true;this.finalizePropertyHelper().then(function(){delete this._bFinalzingPropertiesOnModification}.bind(this))}this.getColumns().forEach(function(t){t._onModifications()})};tt.prototype.setP13nMode=function(t){const e=this.getP13nMode();let i=[];if(t&&t.length>1){const e=t.reduce(function(t,e,i){t[e]=true;return t},{});if(e.Column){i.push("Column")}if(e.Sort){i.push("Sort")}if(e.Filter){i.push("Filter")}if(e.Group){i.push("Group")}if(e.Aggregate){i.push("Aggregate")}}else{i=t}this.setProperty("p13nMode",i,true);this._updateAdaptation();if(!I(e.sort(),this.getP13nMode().sort())){ot(this)}return this};tt.prototype._updateAdaptation=function(){const t={controller:{}};const e=[];if(this.getColumns().length>0&&this._isOfType(K.TreeTable)){e.push(this.getColumns()[0].getPropertyKey())}const i={Column:new M({control:this,stableKeys:e}),Sort:new D({control:this}),Group:new R({control:this}),Filter:new w({control:this}),Aggregate:new v({control:this}),ColumnWidth:new F({control:this,exposeXConfig:true})};this.getActiveP13nModes().forEach(function(e){t.controller[e]=i[e]});if(this.getEnableColumnResize()){t.controller["ColumnWidth"]=i["ColumnWidth"]}this.getEngine().register(this,t)};function ot(t){t._updateP13nButton();if(t._oTable){const e=t._oTable.getDragDropConfig()[0];if(e){e.setEnabled(t.getActiveP13nModes().indexOf("Column")>-1)}}if(t.isFilteringEnabled()){st(t)}nt(t)}tt.prototype.setFilterConditions=function(t){this.setProperty("filterConditions",t,true);const e=this.getInbuiltFilter();if(e){e.setFilterConditions(t)}nt(this);return this};function nt(t){const e=lt(t);const i=ut(t);const o=pt(t);if(!e){return}if(o.length===0){const i=e.getDomRef();if(i&&i.contains(document.activeElement)){t.focus()}e.setVisible(false);rt(t).setText("");return}t._fullyInitialized().then(function(){const n=t.getPropertyHelper();const s=o.map(function(t){return n.hasProperty(t)?n.getProperty(t).label:""});const r=m.getLibraryResourceBundle("sap.ui.mdc");const a=C.getInstance();let l;if(s.length>1){l=r.getText("table.MULTIPLE_FILTERS_ACTIVE",[s.length,a.format(s)])}else{l=r.getText("table.ONE_FILTER_ACTIVE",s[0])}if(!e.getVisible()){e.setVisible(true)}i.setText(l);rt(t).setText(l)})}function st(t){if(!t._oTable){return}let e=lt(t);const i=rt(t);if(!e){e=at(t)}t._getType().insertFilterInfoBar(e,i.getId())}function rt(t){if(!t._oFilterInfoBarInvisibleText){t._oFilterInfoBarInvisibleText=(new S).toStatic()}return t._oFilterInfoBarInvisibleText}function at(t){const e=t.getId()+"-filterInfoBar";let i=J(t).oFilterInfoBar;const o=m.getLibraryResourceBundle("sap.ui.mdc");if(i&&!i.isDestroyed()){i.destroy()}i=new c({id:e,active:true,design:W.Info,visible:false,content:[new u({id:e+"-text",wrapping:false}),new p,new h({type:g.ButtonType.Transparent,tooltip:o.getText("infobar.REMOVEALLFILTERS"),icon:"sap-icon://decline",press:function(){a.createFilterChange(t,{conditions:[],strategy:L.FullReplace});t.focus()}})],press:function(){a.openFilterDialog(t,function(){if(pt(t).length===0){t.focus()}})}});J(t).oFilterInfoBar=i;nt(t);return i}function lt(t){const e=J(t).oFilterInfoBar;if(e?.isDestroyStarted()){return null}return e}function ut(t){const e=lt(t);return e?e.getContent()[0]:null}tt.prototype.setThreshold=function(t){this.setProperty("threshold",t,true);if(!this._oTable){return this}t=this.getThreshold()>-1?this.getThreshold():undefined;if(this._isOfType(K.ResponsiveTable)){this._oTable.setGrowingThreshold(t)}else{this._oTable.setThreshold(t)}return this};tt.prototype._onFilterProvided=function(t){this._updateInnerTableNoData()};tt.prototype._onFilterRemoved=function(t){this._updateInnerTableNoData()};tt.prototype._onFiltersChanged=function(t){if(this.isTableBound()&&t.getParameter("conditionsBased")){this._oTable.setShowOverlay(true)}};tt.prototype._onFilterSearch=function(t){this._bAnnounceTableUpdate=true};tt.prototype.setNoData=function(t){this._vNoData=this.validateAggregation("noData",t,false);if(!this._oTable){return this}if(t&&t.isA&&t.isA("sap.m.IllustratedMessage")){this._sLastNoDataTitle="";t.setEnableVerticalResponsiveness(!this._isOfType(K.ResponsiveTable));let e=this._oTable.getAggregation("_noColumnsMessage");if(!e){e=f.getNoColumnsIllustratedMessage(function(){a.openSettingsDialog(this)}.bind(this));e.setEnableVerticalResponsiveness(!this._isOfType(K.ResponsiveTable));this._oTable.setAggregation("_noColumnsMessage",e)}}this._oTable.setNoData(t);this._updateInnerTableNoData();return this};tt.prototype.getNoData=function(){return this._vNoData&&!this._vNoData.isDestroyed?.()?this._vNoData:null};tt.prototype.destroyNoData=function(){if(this._oTable){this._oTable.destroyNoData(true)}else if(this._vNoData){this._vNoData.destroy?.()}this._vNoData=null;return this};tt.prototype._updateInnerTableNoData=function(){const t=this.getNoData();if(!t||typeof t=="string"){return this._updateInnerTableNoDataText()}if(!t.isA("sap.m.IllustratedMessage")||this._sLastNoDataTitle!=t.getTitle()){return}const e=m.getLibraryResourceBundle("sap.ui.mdc");if(!this.isTableBound()){t.setDescription(" ");if(this.getFilter()){t.setTitle(e.getText("table.NO_DATA_WITH_FILTERBAR"));t.setIllustrationType(Q.SearchEarth)}else{t.setIllustrationType(Q.EmptyList);t.setTitle(e.getText("table.NO_DATA"))}}else if(dt(this)){t.setTitle(e.getText("table.NO_RESULTS_TITLE"));t.setDescription(e.getText("table.NO_RESULTS_DESCRIPTION"));t.setIllustrationType(Q.NoFilterResults)}else{t.setTitle(e.getText("table.NO_DATA")).setDescription(" ");t.setIllustrationType(Q.NoEntries)}this._sLastNoDataTitle=t.getTitle()};tt.prototype._updateInnerTableNoDataText=function(){if(this._oTable){this._oTable.setNoData(this._getNoDataText())}};tt.prototype._getNoDataText=function(){const t=this.getNoData();if(t&&typeof t=="string"){return t}const e=m.getLibraryResourceBundle("sap.ui.mdc");if(!this.isTableBound()){return e.getText(this.getFilter()?"table.NO_DATA_WITH_FILTERBAR":"table.NO_DATA")}if(dt(this)){return e.getText("table.NO_RESULTS")}return e.getText("table.NO_DATA")};tt.prototype._updateRowActions=function(){this._getType().updateRowActions()};tt.prototype._initializeContent=function(){const t=this._getType();const e=[this.awaitControlDelegate(),t.loadModules()];if(this.isFilteringEnabled()){e.push(this.retrieveInbuiltFilter())}Promise.all(e).then(()=>{if(this.isDestroyed()){return Promise.reject("Destroyed")}this._updateAdaptation();const e=this.getControlDelegate();if(e.preInit){e.preInit(this)}if(!this._oTable&&t.constructor===this._getType().constructor){return this._createContent()}else{return Promise.resolve()}}).catch(t=>{this._onAfterInitialization(t||"");this._onAfterFullInitialization(t||"")})};tt.prototype._createInitPromises=function(){this._oTableReady=new A;this._oFullInitialize=new A;this._oFullInitialize.promise.catch(()=>{});this._bFullyInitialized=false};tt.prototype._onAfterInitialization=function(t){if(this._oTableReady){if(t!=null){this._oTableReady.reject(t)}else{this._oTableReady.resolve(this)}}};tt.prototype._onAfterFullInitialization=function(t){if(this._oFullInitialize){if(t!=null){this._oFullInitialize.reject(t)}else{this._bFullyInitialized=true;this._oFullInitialize.resolve(this)}}};tt.prototype._createContent=function(){this._createToolbar();this._createTable();this._updateColumnResize();this._updateRowActions();this._updateExpandAllButton();this._updateCollapseAllButton();this._updateExportButton();this.getColumns().forEach(this._insertInnerColumn,this);return this.getControlDelegate().initializeContent(this).then(()=>{if(this.isDestroyed()){return Promise.reject("Destroyed")}this.setAggregation("_content",this._oTable);this._onAfterInitialization();return Promise.all([this.getPropertyInfo().length===0?this.finalizePropertyHelper():this.awaitPropertyHelper(),this.initialized()])}).then(()=>{if(this.isDestroyed()){return Promise.reject("Destroyed")}const t=this.getCreationRow();if(t){t.update()}if(this.getAutoBindOnInit()){const t=this.getEngine();t.isModificationSupported(this).then(e=>{if(e){t.waitForChanges(this).then(()=>{this.rebind()})}else{this.rebind()}})}this._onAfterFullInitialization()})};tt.prototype.setHeader=function(t){this.setProperty("header",t,true);this._updateHeaderText();return this};tt.prototype.setHeaderVisible=function(t){this.setProperty("headerVisible",t,true);if(this._oTitle){this._oTitle.setWidth(this.getHeaderVisible()?undefined:"0px")}this._updateVariantManagementStyle();return this};tt.prototype.setShowRowCount=function(t){this.setProperty("showRowCount",t,true);this._updateHeaderText();return this};tt.prototype.setEnableExport=function(t){this.setProperty("enableExport",t,true);this._updateExportButton();return this};tt.prototype.setShowPasteButton=function(t){if((t=!!t)==this.getShowPasteButton()){return this}this.setProperty("showPasteButton",t,true);if(t&&!this._oPasteButton&&this._oToolbar){this._oToolbar.insertEnd(this._getPasteButton(),0);this._oPasteButton.setEnabled(this.getEnablePaste())}else if(this._oPasteButton){this._oPasteButton.setVisible(t);this._oPasteButton.setEnabled(this.getEnablePaste())}return this};tt.prototype.setEnablePaste=function(t){this.setProperty("enablePaste",t,true);if(this._oPasteButton){this._oPasteButton.setEnabled(this.getEnablePaste())}return this};tt.prototype._setShowP13nButton=function(t){this._bHideP13nButton=!t;this._updateP13nButton()};tt.prototype._isP13nButtonHidden=function(){return this._bHideP13nButton};tt.prototype._createToolbar=function(){if(this.isDestroyStarted()){return}if(!this._oToolbar){this._oTitle=new d(this.getId()+"-title",{text:this.getHeader(),width:this.getHeaderVisible()?undefined:"0px",level:this.getHeaderLevel(),titleStyle:this.getHeaderStyle()||X.H4});this._oToolbar=new e(this.getId()+"-toolbar",{design:W.Transparent,begin:[this._oTitle],end:[this._getCopyButton(),this._getPasteButton(),this._getP13nButton()]});this._oToolbar.setProperty("_endOrder",["copy","paste","showHideDetails","collapseAll","expandAll","settings","export"].map(t=>this.getId()+"-"+t))}this._oToolbar.setStyle(this._isOfType(K.ResponsiveTable)?q.Standard:q.Clear);return this._oToolbar};tt.prototype._getVisibleProperties=function(){const t=[];let e;this.getColumns().forEach(function(i,o){e=i&&i.getPropertyKey();if(e){t.push({name:e})}});return t};tt.prototype.getConditions=function(){return this.getInbuiltFilter()?this.getInbuiltFilter().getConditions():[]};tt.prototype._getSortedProperties=function(){return this.getSortConditions()?this.getSortConditions().sorters:[]};tt.prototype._getGroupedProperties=function(){return this.getGroupConditions()?this.getGroupConditions().groupLevels:[]};tt.prototype._getAggregatedProperties=function(){return this.getAggregateConditions()?this.getAggregateConditions():{}};tt.prototype._getXConfig=function(){return this.getEngine().readXConfig(this)};function pt(t){return t.isFilteringEnabled()?ct(t.getFilterConditions()):[]}function ht(t){const e=m.byId(t.getFilter());return e?ct(e.getConditions()):[]}function dt(t){const e=m.byId(t.getFilter());return pt(t).length>0||ht(t).length>0||e&&e.getSearch()!==""}function ct(t){return Object.keys(t||{}).filter(function(e){return t[e].length>0})}tt.prototype.getCurrentState=function(){const t={};const e=this.getActiveP13nModes();if(e.indexOf("Column")>-1){t.items=this._getVisibleProperties()}if(this.isSortingEnabled()){t.sorters=this._getSortedProperties()}if(this.isFilteringEnabled()){t.filter=this.getFilterConditions()}if(this.isGroupingEnabled()){t.groupLevels=this._getGroupedProperties()}if(this.isAggregationEnabled()){t.aggregations=this._getAggregatedProperties()}if(this.getEnableColumnResize()){t.xConfig=this._getXConfig()}return t};tt.prototype.isFilteringEnabled=function(){return this.getActiveP13nModes().includes(U.Filter)};tt.prototype.isSortingEnabled=function(){return this.getActiveP13nModes().includes(U.Sort)};tt.prototype.isGroupingEnabled=function(){return this.getActiveP13nModes().includes(U.Group)};tt.prototype.isAggregationEnabled=function(){return this.getActiveP13nModes().includes(U.Aggregate)};tt.prototype.getSupportedP13nModes=function(){let t=gt(Object.keys(U),this._getType().getSupportedP13nModes());if(this.isControlDelegateInitialized()){t=gt(t,this.getControlDelegate().getSupportedP13nModes(this))}return t};tt.prototype.getActiveP13nModes=function(){return gt(this.getP13nMode(),this.getSupportedP13nModes())};function gt(t,e){return t.filter(function(t){return e.includes(t)})}tt.prototype._getP13nButton=function(){if(!this._oP13nButton){this._oP13nButton=i.createSettingsButton(this.getId(),[function(){a.openSettingsDialog(this)},this])}this._updateP13nButton();return this._oP13nButton};tt.prototype._updateP13nButton=function(){if(this._oP13nButton){const t=this.getActiveP13nModes();const e=t.length===1&&t[0]==="Aggregate";this._oP13nButton.setVisible(t.length>0&&!e&&!this._bHideP13nButton)}};tt.prototype._getCopyButton=function(){if(window.isSecureContext){return this.getCopyProvider()?.getCopyButton({id:this.getId()+"-copy"})}};tt.prototype._getPasteButton=function(){if(this.getShowPasteButton()){if(!this._oPasteButton){this._oPasteButton=i.createPasteButton(this.getId())}return this._oPasteButton}};tt.prototype._isExportEnabled=function(){return this.getEnableExport()&&this.isControlDelegateInitialized()&&this.getControlDelegate().getSupportedFeatures(this).export};tt.prototype._updateExportButton=function(){const t=this._oToolbar!=null&&this._isExportEnabled();if(t&&!this._oExportButton){this._oExportButton=this._createExportButton()}if(!this._oExportButton){return}if(this._oToolbar&&!this._oToolbar.getEnd().includes(this._oExportButton)){this._oToolbar.addEnd(this._oExportButton)}this._oExportButton.setEnabled(!f.isEmpty(this.getRowBinding()));this._oExportButton.setVisible(this._isExportEnabled())};tt.prototype._createExportButton=function(){return i.createExportButton(this.getId(),{default:[function(){this._onExport()},this],exportAs:[function(){this._onExport(true)},this]})};tt.prototype._createExportColumnConfiguration=function(){const t=this.getColumns();return this._fullyInitialized().then(function(){return this.finalizePropertyHelper()}.bind(this)).then(function(){const e=this.getPropertyHelper();let i=[];t.forEach(function(t){const o=e.getColumnExportSettings(t);i=i.concat(o)},this);return i}.bind(this))};tt.prototype._isCollapseAllEnabled=function(){return this.isControlDelegateInitialized()&&this.getControlDelegate().getSupportedFeatures(this).collapseAll};tt.prototype._updateCollapseAllButton=function(){const t=this._oToolbar!=null&&this._isCollapseAllEnabled();if(t&&!this._oCollapseAllButton){this._oCollapseAllButton=i.createExpandCollapseAllButton(this.getId(),[function(){this.getControlDelegate().collapseAll(this)},this],false)}if(!this._oCollapseAllButton){return}if(this._oToolbar&&!this._oToolbar.getEnd().includes(this._oCollapseAllButton)){this._oToolbar.insertEnd(this._oCollapseAllButton,0)}this._oCollapseAllButton.setEnabled(!f.isEmpty(this.getRowBinding()));this._oCollapseAllButton.setVisible(this._isCollapseAllEnabled())};tt.prototype._isExpandAllEnabled=function(){return this.isControlDelegateInitialized()&&this.getControlDelegate().getSupportedFeatures(this).expandAll};tt.prototype._updateExpandAllButton=function(){const t=this._oToolbar!=null&&this._isExpandAllEnabled();if(t&&!this._oExpandAllButton){this._oExpandAllButton=i.createExpandCollapseAllButton(this.getId(),[function(){this.getControlDelegate().expandAll(this)},this],true)}if(!this._oExpandAllButton){return}if(this._oToolbar&&!this._oToolbar.getEnd().includes(this._oExpandAllButton)){this._oToolbar.insertEnd(this._oExpandAllButton,0)}this._oExpandAllButton.setEnabled(!f.isEmpty(this.getRowBinding()));this._oExpandAllButton.setVisible(this._isExpandAllEnabled())};tt.prototype._getColumnLabel=function(t){const e=this.getPropertyHelper();const i=e.getProperty(t);return i&&i.label};tt.prototype._onExport=function(t){const e=this;return this._createExportColumnConfiguration().then(function(i){if(!i||!i.length){sap.ui.require(["sap/m/MessageBox"],function(t){t.error(m.getLibraryResourceBundle("sap.ui.mdc").getText("table.NO_COLS_EXPORT"),{styleClass:this.$()&&this.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""})}.bind(e));return}const o=e.getRowBinding();const n=e._getColumnLabel.bind(e);const s=t?"exportAs":"export";const r={workbook:{columns:i,context:{title:e.getHeader()}},dataSource:o,fileName:e.getHeader()};e._getExportHandler().then(function(t){t[s](r,n)})})};tt.prototype._getExportHandler=function(){const t=this;if(this._oExportHandler){return Promise.resolve(this._oExportHandler)}return new Promise(function(e,i){Promise.all([t._loadExportLibrary(),t.getControlDelegate().fetchExportCapabilities(t)]).then(function(i){const o=i[1];sap.ui.require(["sap/ui/export/ExportHandler"],function(i){t._oExportHandler=new i(o);t._oExportHandler.attachBeforeExport(t._onBeforeExport,t);e(t._oExportHandler)})}).catch(function(t){if(!sap.ui.getCore().getLoadedLibraries().hasOwnProperty("sap.ui.export")){y.error(m.getLibraryResourceBundle("sap.ui.mdc").getText("ERROR_MISSING_EXPORT_LIBRARY"))}i(t)})})};tt.prototype._onBeforeExport=function(t){const e=t.getParameter("filterSettings");const i=this.getPropertyHelper();e.forEach(function(t){const e=i.getProperties().find(function(e){return e.path===t.getProperty()});if(e){t.setLabel(e.label);t.setType(e.typeConfig.typeInstance)}});this.fireBeforeExport({exportSettings:t.getParameter("exportSettings"),userExportSettings:t.getParameter("userExportSettings"),filterSettings:e})};tt.prototype._loadExportLibrary=function(){if(!this._oExportLibLoadPromise){this._oExportLibLoadPromise=m.loadLibrary("sap.ui.export",true)}return this._oExportLibLoadPromise};tt.prototype.onkeydown=function(t){if(t.isMarked()){return}if((t.metaKey||t.ctrlKey)&&t.shiftKey&&t.which===E.E){if(this._oExportButton&&this._oExportButton.getEnabled()&&this._isExportEnabled()){this._onExport(true);t.setMarked();t.preventDefault()}}if((t.metaKey||t.ctrlKey)&&t.which===E.COMMA){if(this._oP13nButton&&this._oP13nButton.getVisible()){this._oP13nButton.firePress();t.setMarked();t.preventDefault()}}};tt.prototype._createTable=function(){const t=this._getType();this._oTable=t.createTable(this.getId()+"-innerTable");this._oRowTemplate=t.createRowTemplate(this.getId()+"-innerTableRow");t.updateTable();if(this.getNoData()){this.setNoData(this.getNoData())}if(this.getContextMenu()){this.setContextMenu(this.getContextMenu())}if(this.isFilteringEnabled()){st(this)}if(!this._oColumnHeaderMenu){this._oQuickActionContainer=new H({table:this});this._oItemContainer=new O({table:this});this._oColumnHeaderMenu=new _({id:this.getId()+"-columnHeaderMenu",_quickActions:[this._oQuickActionContainer],_items:[this._oItemContainer]});this.addDependent(this._oColumnHeaderMenu);k.setSemanticStepname(this._oColumnHeaderMenu,"beforeOpen","mdc:tbl:p13n:col");this._oColumnHeaderMenu.attachBeforeOpen(this._createColumnMenuContent,this)}};tt.prototype._createColumnMenuContent=function(t){const e=t.getParameter("openBy");const i=this.getColumns()[e.getParent().indexOfColumn(e)];t.preventDefault();this._oQuickActionContainer.setColumn(i);this._oItemContainer.setColumn(i);this._fullyInitialized().then(function(){return this.finalizePropertyHelper()}.bind(this)).then(function(){Promise.all([this._oQuickActionContainer.initializeQuickActions(),this._oItemContainer.initializeItems()]).then(function(){if(this._oQuickActionContainer.hasQuickActions()||this._oItemContainer.hasItems()){this._oColumnHeaderMenu.openBy(e,true);a.detectUserPersonalizationCompletion(this,this._oColumnHeaderMenu)}}.bind(this))}.bind(this))};tt.prototype._updateColumnResize=function(){const t=this._getType();if(this.getEnableColumnResize()){t.enableColumnResize()}else{t.disableColumnResize()}};tt.prototype._onColumnMove=function(t){a.createColumnReorderChange(this,{column:t.column,index:t.newIndex})};tt.prototype._onCustomSort=function(t,e){const i=t.getParameter("property");this.getCurrentState().sorters.forEach(function(t){if(t.name===i){if(t.descending&&e===$.Descending||!t.descending&&e===$.Ascending){e=$.None}}});a.createSortChange(this,{property:i,sortOrder:e})};tt.prototype._onRowPress=function(t){if(this.getSelectionMode()!==G.SingleMaster){this.fireRowPress({bindingContext:t.bindingContext})}};tt.prototype._onSelectionChange=function(t){if(!this._bSelectionChangedByAPI){this.fireSelectionChange({selectAll:t.selectAll})}};tt.prototype._onColumnResize=function(t){a.createColumnWidthChange(this,{column:t.column,width:t.width})};tt.prototype._onCustomGroup=function(t){a.createGroupChange(this,{property:t})};tt.prototype._onCustomAggregate=function(t){a.createAggregateChange(this,{property:t})};tt.prototype._insertInnerColumn=function(t,e){if(!this._oTable){return}const i=t.getInnerColumn();this._setMobileColumnTemplate(t,e);this._bForceRebind=true;if(e===undefined){this._oTable.addColumn(i)}else{this._oTable.insertColumn(i,e)}this._getType()._onColumnInsert(t)};tt.prototype.moveColumn=function(t,e){t._bIsBeingMoved=true;this.removeAggregation("columns",t,true);this.insertAggregation("columns",t,e,true);delete t._bIsBeingMoved;if(this._oTable){const i=t.getInnerColumn();this._oTable.removeColumn(i);this._oTable.insertColumn(i,e);this._updateMobileColumnTemplate(t,e)}};tt.prototype.removeColumn=function(t){t=this.removeAggregation("columns",t,true);this._updateMobileColumnTemplate(t,-1);return t};tt.prototype.addColumn=function(t){this.addAggregation("columns",t,true);this._insertInnerColumn(t);return this};tt.prototype.insertColumn=function(t,e){this.insertAggregation("columns",t,e,true);this._insertInnerColumn(t,e);return this};tt.prototype._setMobileColumnTemplate=function(t,e){if(!this._oRowTemplate){return}const i=t.getTemplateClone();if(e>=0){this._oRowTemplate.insertCell(i,e);this._oTable.getItems().forEach(function(t){if(t.isA("sap.m.GroupHeaderListItem")){return}t.insertAggregation("cells",new S,e,true)})}else{this._oRowTemplate.addCell(i)}};tt.prototype._updateMobileColumnTemplate=function(t,e){if(!this._oRowTemplate){return}let i,o;if(this._oRowTemplate){i=t.getTemplateClone();o=this._oRowTemplate.indexOfCell(i);ft(this._oRowTemplate,o,e)}if(o>-1){this._oTable.getItems().forEach(function(t){if(t.removeCell){ft(t,o,e)}})}};function ft(t,e,i){const o=t.removeCell(e);if(o){if(i>-1){t.insertCell(o,i)}else{o.destroy()}}}tt.prototype.getSelectedContexts=function(){if(this.isControlDelegateInitialized()){return this.getControlDelegate().getSelectedContexts(this)}return[]};tt.prototype.clearSelection=function(){if(this.isControlDelegateInitialized()){this._bSelectionChangedByAPI=true;this.getControlDelegate().clearSelection(this);this._bSelectionChangedByAPI=false}};tt.prototype._registerInnerFilter=function(t){t.attachSearch(this._rebind,this)};tt.prototype.isTableBound=function(){return this._getType().isTableBound()};tt.prototype.bindRows=function(t){if(!this.isControlDelegateInitialized()||!this._oTable){return}if(this._bFinalzingPropertiesOnModification){this.propertiesFinalized().then(function(){this.bindRows()}.bind(this));return}const e={};this.getControlDelegate().updateBindingInfo(this,e);if(!e.path){return}if(this._oRowTemplate){e.template=this._oRowTemplate}else{delete e.template}tt._addBindingListener(e,"dataRequested",this._onDataRequested.bind(this));tt._addBindingListener(e,"dataReceived",this._onDataReceived.bind(this));tt._addBindingListener(e,"change",this._onBindingChange.bind(this));this._oTable.setShowOverlay(false);this._updateColumnsBeforeBinding();this.getControlDelegate().updateBinding(this,e,this._bForceRebind?null:this.getRowBinding(),{forceRefresh:t});this._updateInnerTableNoData();this._bForceRebind=false};tt.prototype._onDataRequested=function(){this._bIgnoreChange=true};tt.prototype._onDataReceived=function(){this._bIgnoreChange=false;this._updateTableHeaderState()};tt.prototype._onBindingChange=function(){this.fireEvent("_bindingChange");this._updateExpandAllButton();this._updateCollapseAllButton();this._updateExportButton();if(this._bIgnoreChange){return}this._updateTableHeaderState()};tt.prototype._updateTableHeaderState=function(){this._updateHeaderText()};tt.prototype._updateHeaderText=function(){let t,e;if(!this._oNumberFormatInstance){this._oNumberFormatInstance=T.getFloatInstance()}if(this._oTitle&&this.getHeader()){t=this.getHeader();if(this.getShowRowCount()){e=this.getRowBinding()?this.getRowBinding().getCount():0;if(e>0){const i=this._oNumberFormatInstance.format(e);t+=" ("+i+")"}}this._oTitle.setText(t)}if(!this._bIgnoreChange&&this._bAnnounceTableUpdate){this._bAnnounceTableUpdate=false;f.announceTableUpdate(this.getHeader(),e)}};tt.prototype._updateColumnsBeforeBinding=function(){const t=this.getColumns();const e=this.getPropertyHelper();t.forEach(function(t){const i=e.getProperty(t.getPropertyKey());const o=i?i.getSortableProperties().map(function(t){return t.name}):[];const n=this._getSortedProperties().find(function(t){return o.includes(t.name)});let s=$.None;if(n){s=n.descending?$.Descending:$.Ascending}this._getType().updateSortIndicator(t,s)},this)};tt.prototype.getRowBinding=function(){return this._getType().getRowBinding()};tt.prototype._getRowBinding=function(){V.error(this+": The method '_getRowBinding' must not be used will be deleted soon. Use 'getRowBinding' instead.");return this.getRowBinding()};tt._addBindingListener=function(t,e,i){if(!t.events){t.events={}}if(!t.events[e]){t.events[e]=i}else{const o=t.events[e];t.events[e]=function(){i.apply(this,arguments);o.apply(this,arguments)}}};tt.prototype._rebind=function(t){if(this._bFullyInitialized){this.bindRows(t)}else{this._fullyInitialized().then(this._rebind.bind(this,t))}};tt.prototype._onPaste=function(t){if(this.getEnablePaste()){this.firePaste({data:t.data})}};tt.prototype.exit=function(){this._onAfterInitialization("Destroyed");this._onAfterFullInitialization("Destroyed");["_oTable","_oTitle","_vNoData","_oContextMenu","_oNumberFormatInstance","_oTableReady","_oFullInitialize","_oPasteButton","_oP13nButton","_oRowTemplate","_oToolbar","_oFilterInfoBarInvisibleText","_oColumnHeaderMenu","_oManagedObjectModel","_oDefaultType"].concat((()=>et.map(t=>"_o"+P(t)))()).forEach(t=>{this[t]?.destroy?.();delete this[t]});t.prototype.exit.apply(this,arguments)};tt.prototype.addAction=function(e){if(e.getMetadata().getName()!=="sap.ui.mdc.actiontoolbar.ActionToolbarAction"){e=new z(e.getId()+"-action",{action:e})}return t.prototype.addAggregation.apply(this,["actions",e])};tt.prototype.onThemeChanged=function(){if(this._oExportButton){const t=g.ButtonType[N.get({name:"_sap_ui_mdc_Table_ExportButtonType"})];this._oExportButton.setType(t)}};tt.prototype._enableV4LegacySelection=function(){this._bV4LegacySelectionEnabled=true;if(this._oTable&&this._isOfType("Table",true)){const t=b.getPlugin(this._oTable,"sap.ui.table.plugins.ODataV4Selection");if(t){t.destroy();return this.getControlDelegate().initializeSelection(this)}}};tt.prototype._setSelectedContexts=function(t){this.getControlDelegate().setSelectedContexts(this,t)};tt.prototype._updateVariantManagementStyle=function(){const t=this.getVariant();if(t){t.setShowAsText(this.getHeaderVisible());t.setHeaderLevel(this.getHeaderLevel());t.setTitleStyle(this.getHeaderStyle()||X.H4)}};return tt});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/TableDelegate", ["./AggregationBaseDelegate","./util/loadModules","sap/m/plugins/PluginBase","sap/ui/model/Sorter","sap/ui/core/library","sap/ui/core/Core","sap/ui/mdc/enums/TableP13nMode","sap/ui/mdc/enums/TableType","sap/ui/mdc/util/FilterUtil"],function(e,t,n,r,o,i,l,s,a){"use strict";const u=Object.assign({},e);u.updateBindingInfo=function(e,t){t.parameters={};t.sorter=[];if(e._oMessageFilter){t.filters=[e._oMessageFilter]}else{t.filters=this.getFilters(e)}const n=this.getGroupSorter(e);if(n){t.sorter.push(n)}const r=this.getSorters(e);t.sorter=t.sorter.concat(t.sorter.length===1?r.filter(function(e){return e.sPath!==t.sorter[0].sPath}):r)};u.getFilters=function(e){const t=e.isFilteringEnabled();let n=[],r=[];if(t){const t=e.getConditions()||{};const r=e.getPropertyHelper().getProperties();const o=a.getFilterInfo(e,t,r).filters;n=o?[o]:[]}const o=i.byId(e.getFilter());if(o){const t=o.getConditions()||{};const n=e.getPropertyHelper().getProperties();const i=a.getFilterInfo(e,t,n).filters;r=i?[i]:[]}return n.concat(r)};u.getGroupSorter=function(e){const t=e._getGroupedProperties()[0];if(!t||!e._isOfType(s.ResponsiveTable)){return undefined}const n=e._getSortedProperties().find(function(e){return e.name===t.name});const o=e.getPropertyHelper().getProperty(t.name).path;const i=n?n.descending:false;if(!e._mFormatGroupHeaderInfo||e._mFormatGroupHeaderInfo.propertyName!==t.name){e._mFormatGroupHeaderInfo={propertyName:t.name,formatter:function(n){return this.formatGroupHeader(e,n,t.name)}.bind(this)}}return new r(o,i,e._mFormatGroupHeaderInfo.formatter)};u.getSorters=function(e){const t=e._getSortedProperties();const n=e.getPropertyHelper();const o=[];t.forEach(function(e){if(n.hasProperty(e.name)){const t=n.getProperty(e.name).path;o.push(new r(t,e.descending))}});return o};u.updateBinding=function(e,t,n,r){this.rebind(e,t)};u.formatGroupHeader=function(e,t,n){const r=e.getPropertyHelper().getProperty(n);const o=r.textProperty;const l=i.getLibraryResourceBundle("sap.ui.mdc");let s="table.ROW_GROUP_TITLE";const a=[r.label,t.getProperty(r.path,true)];if(o){s="table.ROW_GROUP_TITLE_FULL";a.push(t.getProperty(o.path,true))}return l.getText(s,a)};u.validateState=function(t,n,r){if(r=="Filter"&&t._oMessageFilter){const e=i.getLibraryResourceBundle("sap.ui.mdc");return{validation:o.MessageType.Information,message:e.getText("table.PERSONALIZATION_DIALOG_FILTER_MESSAGESTRIP")}}return e.validateState.apply(this,arguments)};u.rebind=function(e,t){e._getType().bindRows(t)};u.getFilterDelegate=function(){return{addItem:function(e,t){return Promise.resolve(null)},addCondition:function(e,t,n){return Promise.resolve()},removeCondition:function(e,t,n){return Promise.resolve()}}};u.fetchExportCapabilities=function(e){return Promise.resolve({XLSX:{}})};u.expandAll=function(e){throw Error("Unsupported operation: TableDelegate does not support #expandAll")};u.collapseAll=function(e){throw Error("Unsupported operation: TableDelegate does not support #collapseAll")};u.initializeContent=function(e){return this.initializeSelection(e)};u.initializeSelection=function(e){if(e._isOfType(s.Table,true)){return c(e)}else if(e._isOfType(s.ResponsiveTable)){return p(e)}else{return Promise.resolve()}};function c(e){const n={Single:"Single",SingleMaster:"Single",Multi:"MultiToggle"};return t("sap/ui/table/plugins/MultiSelectionPlugin").then(function(t){const r=t[0];if(e.isDestroyed()){return Promise.reject("Destroyed")}e._oTable.addDependent(new r({limit:"{$sap.ui.mdc.Table#type>/selectionLimit}",enableNotification:true,showHeaderSelector:"{$sap.ui.mdc.Table#type>/showHeaderSelector}",selectionMode:{path:"$sap.ui.mdc.Table>/selectionMode",formatter:function(e){return n[e]}},enabled:{path:"$sap.ui.mdc.Table>/selectionMode",formatter:function(e){return e in n}},selectionChange:function(t){e._onSelectionChange({selectAll:t.getParameter("selectAll")})}}))})}function p(e){const t={Single:"SingleSelectLeft",SingleMaster:"SingleSelectMaster",Multi:"MultiSelect"};const n={Default:"SelectAll",ClearAll:"ClearAll"};e._oTable.bindProperty("mode",{path:"$sap.ui.mdc.Table>/selectionMode",formatter:function(e){return t[e]}});e._oTable.bindProperty("multiSelectMode",{path:"$sap.ui.mdc.Table>/multiSelectMode",formatter:function(e){return n[e]||"SelectAll"}});e._oTable.attachSelectionChange(function(t){e._onSelectionChange({selectAll:t.getParameter("selectAll")})});return Promise.resolve()}u.getSelectedContexts=function(e){if(!e._oTable){return[]}if(e._isOfType(s.Table,true)){const t=e._oTable;const r=n.getPlugin(t,"sap.ui.table.plugins.MultiSelectionPlugin");if(!r){return[]}return r.getSelectedIndices().map(function(e){return t.getContextByIndex(e)},this)}if(e._isOfType(s.ResponsiveTable)){return e._oTable.getSelectedContexts()}return[]};function f(e,t){const n=t.map(function(e){return e.getPath()});e._oTable.removeSelections(true);e._oTable.setSelectedContextPaths(n);e._oTable.getItems().forEach(function(e){const t=e.getBindingContextPath();if(t&&n.indexOf(t)>-1){e.setSelected(true)}})}u.setSelectedContexts=function(e,t){if(e._isOfType(s.ResponsiveTable)){f(e,t)}else{throw Error("Unsupported operation: TableDelegate does not support #setSelectedContexts for the given TableType")}};u.clearSelection=function(e){if(!e._oTable){return}if(e._isOfType(s.Table,true)){const t=n.getPlugin(e._oTable,"sap.ui.table.plugins.SelectionPlugin");if(t){t.clearSelection()}}if(e._isOfType(s.ResponsiveTable)){e._oTable.removeSelections(true)}};u.getSupportedFeatures=function(e){return{export:true,expandAll:false,collapseAll:false}};u.getSupportedP13nModes=function(e){const t=[l.Column,l.Sort,l.Filter];if(e._isOfType(s.ResponsiveTable)){t.push(l.Group)}return t};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/ValueHelp", ["sap/ui/mdc/Element","sap/ui/mdc/mixin/PromiseMixin","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/enums/ValueHelpSelectionType","sap/ui/model/base/ManagedObjectModel","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/enums/ValueHelpPropagationReason"],function(e,t,i,n,o,s,a,r){"use strict";const l=e.extend("sap.ui.mdc.ValueHelp",{metadata:{library:"sap.ui.mdc",properties:{conditions:{type:"object[]",defaultValue:[],byValue:true},delegate:{type:"object",group:"Data",defaultValue:{name:"sap/ui/mdc/ValueHelpDelegate"}},filterValue:{type:"string",defaultValue:""},validateInput:{type:"boolean",defaultValue:true},_config:{type:"object",defaultValue:{},visibility:"hidden"},_valid:{type:"boolean",group:"Appearance",defaultValue:true,visibility:"hidden"}},aggregations:{dialog:{type:"sap.ui.mdc.valuehelp.IDialogContainer",multiple:false},typeahead:{type:"sap.ui.mdc.valuehelp.ITypeaheadContainer",multiple:false}},events:{select:{parameters:{conditions:{type:"object[]"},add:{type:"boolean"},close:{type:"boolean"}}},disconnect:{},closed:{},open:{parameters:{container:{type:"sap.ui.mdc.valuehelp.base.Container"}}},opened:{parameters:{container:{type:"sap.ui.mdc.valuehelp.base.Container"},itemId:{type:"string"}}},navigated:{parameters:{leaveFocus:{type:"boolean"},condition:{type:"object"},itemId:{type:"string"}}},switchToValueHelp:{},typeaheadSuggested:{parameters:{condition:{type:"object"},filterValue:{type:"string"},itemId:{type:"string"}}}},defaultProperty:"filterValue"}});l.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oObserver=new a(C.bind(this));this._oObserver.observe(this,{aggregations:["typeahead","dialog"]});this.setBindingContext(null);this._oConditions={}};l.prototype.exit=function(){if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();delete this._oManagedObjectModel}};l.prototype.invalidate=function(e){return};l.prototype.connect=function(e,t){if(this._oControl&&this._oControl!==e){this.close();this.setFilterValue("");this.setConditions([]);const e=this.getTypeahead();const t=this.getDialog();if(e){e.onConnectionChange()}if(t){t.onConnectionChange()}this.fireDisconnect()}this._oControl=e;this.setProperty("_config",t,true);O.call(this);return this};l.prototype.getControl=function(){return this._oControl};l.prototype.getDomRef=function(){const e=this.getTypeahead();const t=this.getDialog();if(e&&(e.isOpen()||e.isOpening())){return e.getDomRef()}else if(t&&(t.isOpen()||t.isOpening())){return t.getDomRef()}};l.prototype.getAriaAttributes=function(e){const t=this.getTypeahead();let i=this.getDialog();if(!i&&t&&t.getUseAsValueHelp()){i=t}const n=t&&t.isOpen();const o=i&&i.isOpen();const s=t&&t.getAriaAttributes(e);const a=i&&i.getAriaAttributes(e);let r;if(n){r=s.contentId}else if(o){r=a.contentId}const l=t&&s.ariaHasPopup||i&&a.ariaHasPopup;const c=t&&s.role||i&&a.role;const p=t&&s.roleDescription||i&&a.roleDescription;const u=!!i&&a.valueHelpEnabled;const g=t&&s.autocomplete||i&&a.autocomplete;return{contentId:r,ariaHasPopup:l,role:c,roleDescription:p,valueHelpEnabled:u,autocomplete:g}};l.prototype._retrieveDelegateContent=function(e,t){let i;if(!t){const i=e.getSelectedContent();t=i&&i.getId()}i=this._retrievePromise("delegateContent");const n=this.isOpen();if(!i||i&&n||i&&i.aggregation!==e.sParentAggregationName){const n=function(){return this._getControlDelegatePromise().then(function(i){return i.retrieveContent(this,e,t)}.bind(this))}.bind(this);const o=i&&i.isPending();i=this._addPromise("delegateContent",o?i.getInternalPromise().then(n):n);i.aggregation=e.sParentAggregationName}return i.getInternalPromise()};l.prototype._getControlDelegatePromise=function(e){return this._retrievePromise("delegate",this.initControlDelegate.bind(this))};l.prototype.open=function(e){const t=e?this.getTypeahead():b.call(this);const i=e?this.getDialog():this.getTypeahead();if(i&&t!==i&&(i.isOpen()||i.isOpening())){i.close()}if(t&&!t.isOpen()&&!t.isOpening()){t.open(this._retrieveDelegateContent(t),e);this.fireOpen({container:t})}};function c(e){const t=e.getSource();this._retrieveDelegateContent(t,e.getParameter("contentId"))}function p(e){this.fireSwitchToValueHelp()}l.prototype.close=function(){const e=this.getTypeahead();const t=this.getDialog();if(e&&e.isOpen()){e.close()}if(t&&t.isOpen()){t.close()}};l.prototype.toggleOpen=function(e){const t=this.getTypeahead();let i=this.getDialog();if(!e&&!i&&t&&t.getUseAsValueHelp()){i=t}const n=t&&t.isOpen();const o=i&&i.isOpen();if(e&&n||!e&&o){this.close()}else if(e&&t||!e&&i){this.open(e)}};l.prototype.isOpen=function(){const e=this.getTypeahead();const t=this.getDialog();return!!(e&&(e.isOpen()||e.isOpening())||t&&(t.isOpen()||t.isOpening()))};l.prototype.skipOpening=function(){const e=this.getTypeahead();const t=this.getDialog();if(e&&e.isOpening()){e.close()}if(t&&t.isOpening()){t.close()}};l.prototype.initBeforeOpen=function(e){};l.prototype.isTypeaheadSupported=function(){const e=this.getTypeahead();if(e){return this._retrieveDelegateContent(e).then(function(){return!!e&&e.isTypeaheadSupported()})}else{return Promise.resolve(false)}};l.prototype.shouldOpenOnFocus=function(){const e=b.call(this,true);return e&&e.shouldOpenOnFocus()};l.prototype.shouldOpenOnClick=function(){const e=b.call(this,true);return e&&e.shouldOpenOnClick()};l.prototype.isFocusInHelp=function(){const e=b.call(this);return e&&e.isFocusInHelp()};l.prototype.removeFocus=function(){const e=this.getTypeahead();if(e){e.removeFocus()}};l.prototype.navigate=function(e){const t=this.getTypeahead();if(t){const i=function(){if(t.shouldOpenOnNavigate()&&!t.isOpening()&&!t.isOpen()){return t.open(true).then(function(){t.navigate(e)})}return t.navigate(e)};const n=this._retrievePromise("navigate");const o=n&&!n.isSettled()&&n.getInternalPromise();this._addPromise("navigate",o?o.then(i):this._retrieveDelegateContent(t).then(i))}};l.prototype.isNavigationEnabled=function(e){const t=this.getTypeahead();if(t){const i=this.getDialog();const n=t.isOpen();if(n||!i){return t.isNavigationEnabled(e)}}return false};l.prototype.getItemForValue=function(e){const t=this.getTypeahead();if(t){return this._retrieveDelegateContent(t).then(function(){e.caseSensitive=e.hasOwnProperty("caseSensitive")?e.caseSensitive:false;const i=t.getItemForValue(e);return i})}else{return Promise.reject("No Typeahead")}};l.prototype.isValidationSupported=function(){const e=this.getTypeahead();return e&&e.isValidationSupported()};l.prototype.onControlChange=function(){if(this.isDestroyed()){return}u.call(this,r.ControlChange);O.call(this)};l.prototype.getIcon=function(){const e=this.getTypeahead();const t=this.getDialog();if(t){return t.getValueHelpIcon()}else if(e){return e.getValueHelpIcon()}};l.prototype.getMaxConditions=function(){const e=this.getProperty("_config");return e&&e.maxConditions||-1};l.prototype.getDisplay=function(){};l.prototype.getDataType=function(){};function u(e,t){const i=this.bDelegateInitialized&&this.getControlDelegate();if(i){i.onConditionPropagation(this,e,t||this.getProperty("_config"))}}function g(e){const t=e.getParameter("condition");this.fireNavigated({condition:t,itemId:e.getParameter("itemId"),leaveFocus:e.getParameter("leaveFocus")})}function d(e){const t=e.getParameter("condition");const i=e.getParameter("filterValue");const n=e.getParameter("itemId");this.fireTypeaheadSuggested({condition:t,filterValue:i,itemId:n})}function h(e){const t=e.getParameter("type");const i=e.getParameter("conditions")||[];let s;const a=this.getMaxConditions()===1;if(a){s=t===o.Remove?[]:i.slice(0,1)}if(t===o.Set){s=[].concat(a?i.slice(0,1):i)}if(t===o.Add){if(a){s=i.slice(0,1)}else{s=this.getConditions();for(let e=0;e<i.length;e++){s.push(i[e])}}}if(t===o.Remove){if(a){s=[]}else{s=this.getConditions();for(let e=0;e<i.length;e++){const t=n.indexOfCondition(i[e],s);if(t>=0){s.splice(t,1)}}}}if(s){this.setProperty("conditions",s,true)}}function f(e){if(this.getProperty("_valid")){const t=this.getMaxConditions()===1;const o=e.getParameter("close");const s=typeof o!=="undefined"?o:t;let a=this.getConditions();const l=!t&&!e.getSource().isMultiSelect();if(s){this.close()}a=i._removeEmptyConditions(a);a=i._removeInitialFlags(a);n.updateConditionsValues(a);this.fireSelect({conditions:a,add:l,close:s});u.call(this,r.Select)}}function y(e){this.close()}function m(e){this.fireOpened({container:e.getSource(),itemId:e.getParameter("itemId")})}function v(e){this._removePromise("delegateContent");this._removePromise("navigate");this.fireClosed()}function C(e){if(["typeahead","dialog"].indexOf(e.name)!==-1){const t=e.child;const i=e.mutation==="insert";const n=i?t.attachEvent.bind(t):t.detachEvent.bind(t);n("select",h,this);n("requestDelegateContent",c,this);n("confirm",f,this);n("cancel",y,this);n("opened",m,this);n("closed",v,this);if(t.attachRequestSwitchToDialog){n("requestSwitchToDialog",p,this)}if(t.attachNavigated){n("navigated",g,this)}if(t.attachTypeaheadSuggested){n("typeaheadSuggested",d,this)}if(i){if(!this._oManagedObjectModel){this._oManagedObjectModel=new s(this)}t.setModel(this._oManagedObjectModel,"$valueHelp")}}}function O(){const e=this._oControl?this._oControl.getBindingContext():null;this.setBindingContext(e)}function b(e){const t=this.getTypeahead();const i=!!t&&t.getUseAsValueHelp();const n=this.getDialog();if(e){return(i||n)&&t||n}else{return n||i&&t}}l.prototype._getFieldGroupIds=function(){const t=this.getControl();if(t){return t.getFieldGroupIds()}else{return e.prototype._getFieldGroupIds.apply(this,arguments)}};t.call(l.prototype);return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/ValueHelpDelegate", ["sap/ui/mdc/BaseDelegate","sap/ui/model/FilterType","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/FilterConverter"],function(t,e,n,i,o,r){"use strict";const s=Object.assign({},t);s.retrieveContent=function(t,e,n){return Promise.resolve()};s.isSearchSupported=function(t,e,n){return false};s.showTypeahead=function(t,e){if(!e||e.isA("sap.ui.mdc.valuehelp.base.FilterableListContent")&&!e.getFilterValue()){return false}else if(e.isA("sap.ui.mdc.valuehelp.base.ListContent")){const t=e.getListBinding();const n=t&&t.getAllCurrentContexts().length;return n>0}return true};s.updateBindingInfo=function(t,e,s){s.parameters={};s.filters=[];const u=e.getFilterFields();const a=e._getPriorityFilterValue();const c=e._getPriorityFilterBar();const l=c?c.getInternalConditions():e._oInitialFilterConditions||{};if(!c&&a&&u&&u!=="$search"){const t=o.createCondition(i.Contains,[a],undefined,undefined,n.NotValidated);l[u]=[t]}const d=l&&e._getTypesForConditions(l);const f=l&&r.createFilters(l,d,undefined,e.getCaseSensitive());if(f){s.filters=[f]}};s.updateBinding=function(t,n,i,o){n.filter(i.filters,e.Application);if(n.isSuspended()){n.resume()}};s.adjustSearch=function(t,e,n){return n};s.executeFilter=function(t,e,n){return Promise.resolve(e)};s.checkListBindingPending=function(t,e,n){if(!e||e.isSuspended()){return false}return Promise.resolve(e.getContexts(0,n)).then(function(t){return t.length===0})};s.onConditionPropagation=function(t,e,n){};s.getInitialFilterConditions=function(t,e,n){const i={};return i};s.findConditionsForContext=function(t,e,i,o){const r=i.getObject(e.getKeyPath());return o.filter(function(t){return t.validated===n.Validated&&r===t.values[0]})};s.modifySelectionBehaviour=function(t,e,n){return n};s.createConditionPayload=function(t,e,n,i){return undefined};s.getTypesForConditions=function(t,e,n){const i={};const o=e&&e.getListBindingInfo();if(o&&o.template){o.template.mAggregations.cells.forEach(function(t){Object.values(t.mBindingInfos).forEach(function(t){t.parts.forEach(function(t){i[t.path]={type:t.type||null}})})},{})}return i};s.getFilterConditions=function(t,e,n){if(this.getInitialFilterConditions){return this.getInitialFilterConditions(t,e,n&&n.control||e&&e.getControl())}return{}};s.getFirstMatch=function(t,e,n){return e.getRelevantContexts(n)[0]};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/actiontoolbar/ActionToolbarAction", ["sap/ui/core/Control","sap/ui/mdc/actiontoolbar/ActionToolbarActionRenderer","sap/ui/mdc/enums/ActionToolbarActionAlignment"],function(t,e,o){"use strict";const n=t.extend("sap.ui.mdc.actiontoolbar.ActionToolbarAction",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/actiontoolbar/ActionToolbarAction.designtime",interfaces:["sap.m.IOverflowToolbarContent"],properties:{layoutInformation:{type:"object",defaultValue:{aggregationName:"end",alignment:o.Begin}}},defaultAggregation:"action",aggregations:{action:{type:"sap.ui.core.Control",multiple:false}}},renderer:e});n.prototype.getDomRef=function(){return this.getAction()&&this.getAction().getDomRef()};n.prototype.getLayoutData=function(){const e=t.prototype.getLayoutData.apply(this);return e?e:this.getAction()&&this.getAction().getLayoutData()};n.prototype.getOverflowToolbarConfig=function(){const t=this.getAction()&&this.getAction().getOverflowToolbarConfig?this.getAction().getOverflowToolbarConfig():{canOverflow:true};t.onBeforeEnterOverflow=this._getOnBeforeEnterOverflow(t);t.onAfterExitOverflow=this._getOnAfterExitOverflow(t);return t};n.prototype._getOnBeforeEnterOverflow=function(t){const e=t.onBeforeEnterOverflow;return function(t){if(e){e(t.getAction())}if(t.getParent()&&t.getParent()._updateSeparators){t.getParent()._updateSeparators()}}};n.prototype._getOnAfterExitOverflow=function(t){const e=t.onAfterExitOverflow;return function(t){if(e){e(t.getAction())}if(t.getParent()&&t.getParent()._updateSeparators){t.getParent()._updateSeparators()}}};n.prototype.getLabel=function(){const t=this.getAction();return t&&t.getText?t.getText():this.getId()};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/actiontoolbar/ActionToolbarActionRenderer", [],function(){"use strict";const e={apiVersion:2};e.render=function(e,n){const s=n.getAction();if(s){if(n.hasStyleClass("sapMBarChild")){s.addStyleClass("sapMBarChild")}e.renderControl(s)}};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/ChartImplementationContainer", ["sap/ui/core/Control","./ChartImplementationContainerRenderer","sap/ui/core/Core","sap/ui/thirdparty/jquery"],function(t,e,i,jQuery){"use strict";const o=t.extend("sap.ui.mdc.chart.ChartImplementationContainer",{metadata:{library:"sap.ui.mdc",interfaces:[],properties:{showNoDataStruct:{type:"boolean",group:"Misc",defaultValue:true}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false},noDataContent:{type:"sap.ui.core.Control",multiple:false}},associations:{chartNoDataContent:{type:"sap.ui.core.Control",multiple:false}},events:{}},renderer:e});o.prototype.init=function(){this._updateVisibilities()};o.prototype.setShowNoDataStruct=function(t){this.setProperty("showNoDataStruct",t);this._updateVisibilities();return this};o.prototype.setContent=function(t){this.setAggregation("content",t);this._updateVisibilities();return this};o.prototype.setNoDataContent=function(t){this.setAggregation("noDataContent",t);this._updateVisibilities();return this};o.prototype.setChartNoDataContent=function(t){this.setAssociation("chartNoDataContent",t);this._updateVisibilities();return this};o.prototype.showOverlay=function(t){const e=this.$();let i=e.find(".sapUiMdcChartOverlay");if(t&&i.length===0){i=jQuery("<div>").addClass("sapUiOverlay sapUiMdcChartOverlay").css("z-index","1");e.append(i)}else if(!t){i.remove()}};o.prototype._getChartNoDataForRenderer=function(){return i.byId(this.getChartNoDataContent())};o.prototype._updateVisibilities=function(){const t=this.getShowNoDataStruct();if(this.getContent()){this.getContent().setVisible(!t)}if(this.getChartNoDataContent()){if(this.getNoDataContent()){this.getNoDataContent().setVisible(false)}i.byId(this.getChartNoDataContent()).setVisible(t)}else if(this.getNoDataContent()){this.getNoDataContent().setVisible(t)}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/ChartImplementationContainerRenderer", [],function(){"use strict";const e={apiVersion:2};e.CSS_CLASS="sapUiMDCChart";e.render=function(e,t){e.openStart("div",t);e.style("height","100%");e.style("width","100%");e.style("min-height","200px");e.openEnd();e.renderControl(t.getContent());e.renderControl(t.getNoDataContent());e.renderControl(t._getChartNoDataForRenderer());e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/ChartSelectionDetails", ["sap/m/SelectionDetails","sap/m/SelectionDetailsItem","sap/m/SelectionDetailsItemLine","sap/m/SelectionDetailsRenderer"],function(t,e,i,n){"use strict";const a=t.extend("sap.ui.mdc.chart.ChartSelectionDetails",{metadata:{library:"sap.ui.mdc",interfaces:[],defaultAggregation:"",properties:{},aggregations:{},associations:{},events:{}},renderer:n});a.prototype.init=function(){t.prototype.init.apply(this,arguments);this._registerTemplate();this._attachEvents()};a.prototype._registerTemplate=function(){this.registerSelectionDetailsItemFactory([],function(t,n,a,r){const s=[];for(let e=0;e<t.length;e++){s.push(new i({label:t[e].label,value:this._formatValue(t[e].value),unit:t[e].unit}))}return new e({enableNav:this._hasNavigationTargets(n),lines:s}).setBindingContext(a)}.bind(this))};a.prototype._formatValue=function(t){if(t){return t instanceof Object?t:t.toString()}else{return t}};a.prototype._hasNavigationTargets=function(t){return false};a.prototype._attachEvents=function(){this.attachActionPress(function(t){const e=this.getParent().getParent();const i=[];t.getParameter("items").forEach(function(t){i.push(t.getBindingContext())});e.fireSelectionDetailsActionPressed({id:t.getParameter("id"),action:t.getParameter("action"),itemContexts:i,level:t.getParameter("level")})})};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/ChartToolbar", ["sap/ui/core/Core","sap/ui/mdc/ActionToolbar","sap/m/OverflowToolbarRenderer","sap/m/OverflowToolbarButton","sap/m/OverflowToolbarToggleButton","sap/m/Title","sap/ui/mdc/chart/ChartTypeButton","./ChartSelectionDetails","sap/ui/core/InvisibleText","sap/m/OverflowToolbarLayoutData","sap/ui/core/library","sap/ui/Device","sap/ui/core/ShortcutHintsMixin","sap/ui/mdc/enums/ChartToolbarActionType"],function(t,e,n,o,i,a,s,r,l,h,c,d,g,u){"use strict";const p=c.aria.HasPopup;const _=e.extend("sap.ui.mdc.chart.ChartToolbar",{metadata:{library:"sap.ui.mdc",interfaces:[],defaultAggregation:"",properties:{},aggregations:{},associations:{},events:{}},renderer:n});const T=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");_.prototype.init=function(){e.prototype.init.apply(this,arguments)};_.prototype.createToolbarContent=function(t){this._oChart=t;this._chartInternalButtonsToEnable=[];this._oInvTitle=new l(t.getId()+"-invTitle",{text:t.getHeader()});this._oInvTitle.toStatic();this.addAriaLabelledBy(this._oInvTitle);this._oTitle=new a(t.getId()+"-title",{text:t.getHeader(),level:t.getHeaderLevel(),titleStyle:t.getHeaderStyle(),visible:t.getHeaderVisible()});this.addBegin(this._oTitle);if(t.getAggregation("variant")){this.addVariantManagement(t.getAggregation("variant"))}if(t.getShowSelectionDetails()){this._oChartSelectionDetails=new r(t.getId()+"-selectionDetails",{});this._oChartSelectionDetails.attachBeforeOpen(function(e){this._updateSelectionDetailsActions(t)}.bind(this));this.addEnd(this._oChartSelectionDetails)}const e=t.getP13nMode()||[];if(e.indexOf("Item")>-1&&(!t.getIgnoreToolbarActions().length||t.getIgnoreToolbarActions().indexOf(u.DrillDownUp)<0)){this._oDrillDownBtn=new o(t.getId()+"-drillDown",{icon:"sap-icon://drill-down",tooltip:T.getText("chart.CHART_DRILLDOWN_TITLE"),text:T.getText("chart.CHART_DRILLDOWN_TITLE"),enabled:false,ariaHasPopup:p.ListBox,layoutData:new h({closeOverflowOnInteraction:false}),press:function(e){t._showDrillDown(this._oDrillDownBtn)}.bind(this)});this.addEnd(this._oDrillDownBtn);this._chartInternalButtonsToEnable.push(this._oDrillDownBtn)}if(!t.getIgnoreToolbarActions().length||t.getIgnoreToolbarActions().indexOf(u.Legend)<0){this._oLegendBtn=new i(t.getId()+"btnLegend",{type:"Transparent",text:T.getText("chart.LEGENDBTN_TEXT"),tooltip:T.getText("chart.LEGENDBTN_TOOLTIP"),icon:"sap-icon://legend",pressed:"{$mdcChart>/legendVisible}",enabled:false});this.addEnd(this._oLegendBtn);this._chartInternalButtonsToEnable.push(this._oLegendBtn)}if(!t.getIgnoreToolbarActions().length||t.getIgnoreToolbarActions().indexOf(u.ZoomInOut)){this.oZoomInButton=new o(t.getId()+"btnZoomIn",{icon:"sap-icon://zoom-in",tooltip:T.getText("chart.TOOLBAR_ZOOM_IN"),text:T.getText("chart.TOOLBAR_ZOOM_IN"),enabled:false,press:function e(n){t.zoomIn();this.toggleZoomButtons(t)}.bind(this)});this.oZoomOutButton=new o(t.getId()+"btnZoomOut",{icon:"sap-icon://zoom-out",tooltip:T.getText("chart.TOOLBAR_ZOOM_OUT"),text:T.getText("chart.TOOLBAR_ZOOM_OUT"),enabled:false,press:function e(n){t.zoomOut();this.toggleZoomButtons(t)}.bind(this)});this.addEnd(this.oZoomInButton);this.addEnd(this.oZoomOutButton)}if(e.indexOf("Sort")>-1||e.indexOf("Item")>-1||e.indexOf("Filter")>-1){this._oSettingsBtn=new o(t.getId()+"-chart_settings",{icon:"sap-icon://action-settings",tooltip:T.getText("chart.SETTINGS"),text:T.getText("chart.SETTINGS"),enabled:false,press:function(e){const n=t.getP13nMode();const o=n.indexOf("Type");if(o>-1){n.splice(o,1)}if(t.isPropertyHelperFinal()){t.getEngine().show(t,n)}else{t.finalizePropertyHelper().then(function(){t.getEngine().show(t,n)})}}});g.addConfig(this._oSettingsBtn,{addAccessibilityLabel:true,messageBundleKey:d.os.macintosh?"mdc.PERSONALIZATION_SHORTCUT_MAC":"mdc.PERSONALIZATION_SHORTCUT"},this);this.addEnd(this._oSettingsBtn);this._chartInternalButtonsToEnable.push(this._oSettingsBtn)}if(t._getTypeBtnActive()){this._oChartTypeBtn=new s(this.getId()+"-btnChartType",{type:"Transparent",enabled:false,ariaHasPopup:p.ListBox,layoutData:new h({closeOverflowOnInteraction:false}),chart:t});this.addEnd(this._oChartTypeBtn);this._chartInternalButtonsToEnable.push(this._oChartTypeBtn)}this._updateVariantManagement()};_.prototype.addVariantManagement=function(t){if(t){if(this._oVariantManagement){this.removeBetween(this._oVariantManagement)}this._oVariantManagement=t;this.addBetween(this._oVariantManagement);this._updateVariantManagement()}};_.prototype.toggleZoomButtons=function(t){const e=this._getZoomEnablement(t);if(e.enabled){this.oZoomInButton.setEnabled(e.enabledZoomIn);this.oZoomOutButton.setEnabled(e.enabledZoomOut)}else{this.oZoomInButton.setEnabled(false);this.oZoomOutButton.setEnabled(false)}};_.prototype.updateToolbar=function(t){this.toggleZoomButtons(t);if(!this._toolbarInitialUpdated){this.setEnabled(true);this._chartInternalButtonsToEnable.forEach(function(t){t.setEnabled(true)});this._toolbarInitialUpdated=true}const e=t.getSelectionHandler();if(e&&t.getShowSelectionDetails()){this._oChartSelectionDetails.attachSelectionHandler(e.eventId,e.listener)}};_.prototype._getVariantReference=function(){return this._oVariantManagement};_.prototype._getZoomEnablement=function(t){let e;try{e=t.getZoomState()}catch(t){e={enabled:false}}if(e&&e.hasOwnProperty("currentZoomLevel")&&e.currentZoomLevel!=null&&e.enabled){const t={enabled:true};t.enabledZoomOut=e.currentZoomLevel>0;t.enabledZoomIn=e.currentZoomLevel<1;return t}else{return{enabled:false}}};_.prototype._updateSelectionDetailsActions=function(t){if(!t.getShowSelectionDetails()){return}const e=t.getSelectionDetailsActions();let n;if(e){const t=this._oChartSelectionDetails.getItems();t.forEach(function(t){const o=e.getDetailsItemActions();o.forEach(function(e){n=e.clone();t.addAction(n)})});const o=e.getDetailsActions();this._oChartSelectionDetails.removeAllActions();o.forEach(function(t){n=t.clone();this._oChartSelectionDetails.addAction(n)}.bind(this));const i=e.getActionGroups();this._oChartSelectionDetails.removeAllActionGroups();i.forEach(function(t){n=t.clone();this._oChartSelectionDetails.addActionGroup(n)}.bind(this))}};_.prototype._setHeader=function(t){this._oTitle?.setText(t);this._oInvTitle?.setText(t)};_.prototype._setHeaderLevel=function(t){this._oTitle?.setLevel(t);this._updateVariantManagement()};_.prototype._setHeaderStyle=function(t){this._oTitle?.setTitleStyle(t);this._updateVariantManagement()};_.prototype._setHeaderVisible=function(t){this._oTitle?.setVisible(t);this._updateVariantManagement()};_.prototype._updateVariantManagement=function(){if(this._oVariantManagement&&this._oChart){this._oVariantManagement.setShowAsText(this._oChart.getHeaderVisible());this._oVariantManagement.setTitleStyle(this._oChart.getHeaderStyle());this._oVariantManagement.setHeaderLevel(this._oChart.getHeaderLevel())}};_.prototype.getSettingsButton=function(){return this._oSettingsBtn};_.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oInvTitle){this._oInvTitle.destroy();this._oInvTitle=null}};return _});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/ChartTypeButton", ["sap/m/OverflowToolbarButton","sap/m/ButtonRenderer","sap/ui/base/ManagedObjectObserver","sap/m/library","sap/m/IllustratedMessage","sap/m/library","sap/ui/model/Filter","sap/ui/model/json/JSONModel"],function(e,t,a,s,i,o,r,n){"use strict";const c=s.PlacementType;let p,l,h,d,u,b,y;const f=e.extend("sap.ui.mdc.chart.ChartTypeButton",{metadata:{library:"sap.ui.mdc",associations:{chart:{type:"sap.ui.mdc.Chart",multiple:false}}},renderer:t});f.prototype.init=function(){e.prototype.init.apply(this,arguments);this.bindProperty("icon","$chart>/ChartTypeInfo/icon");this.bindProperty("tooltip","$chart>/ChartTypeInfo/text");this.bindProperty("text","$chart>/ChartTypeInfo/text");this.attachPress(this.displayChartTypes.bind(this))};f.prototype._updateChart=function(e){if(e){const t=new n;t.setProperty("/ChartTypeInfo",e.getChartTypeInfo());this.setModel(t,"$chart");this._oObserver=new a(function(a){if(a.name==="chartType"){t.setProperty("/ChartTypeInfo",e.getChartTypeInfo())}});this._oObserver.observe(e,{aggregations:["items"],properties:["chartType"]})}else{this.setModel(null,"$chart");if(this._oObserver){this._oObserver.disconnect();this._oObserver.destroy();delete this._oObserver}}};f.prototype.setChart=function(e){this.setAssociation("chart",e);this._updateChart(e);return this};f.prototype._getChart=function(){let e;const t=this.getChart();if(t){e=sap.ui.getCore().byId(t)}return e};f.mMatchingIcon={bar:"sap-icon://horizontal-bar-chart",bullet:"sap-icon://horizontal-bullet-chart",bubble:"sap-icon://bubble-chart",column:"sap-icon://vertical-bar-chart",combination:"sap-icon://business-objects-experience",dual_bar:"sap-icon://horizontal-bar-chart",dual_column:"sap-icon://vertical-bar-chart",dual_combination:"sap-icon://business-objects-experience",dual_horizontal_combination:"sap-icon://business-objects-experience",dual_horizontal_stacked_combination:"sap-icon://business-objects-experience",dual_line:"sap-icon://line-chart",dual_stacked_bar:"sap-icon://full-stacked-chart",dual_stacked_column:"sap-icon://vertical-stacked-chart",dual_stacked_combination:"sap-icon://business-objects-experience",donut:"sap-icon://donut-chart",heatmap:"sap-icon://heatmap-chart",horizontal_stacked_combination:"sap-icon://business-objects-experience",line:"sap-icon://line-chart",pie:"sap-icon://pie-chart",scatter:"sap-icon://scatter-chart",stacked_bar:"sap-icon://full-stacked-chart",stacked_column:"sap-icon://vertical-stacked-chart",stacked_combination:"sap-icon://business-objects-experience",treemap:"sap-icon://Chart-Tree-Map",vertical_bullet:"sap-icon://vertical-bullet-chart","100_dual_stacked_bar":"sap-icon://full-stacked-chart","100_dual_stacked_column":"sap-icon://vertical-stacked-chart","100_stacked_bar":"sap-icon://full-stacked-chart","100_stacked_column":"sap-icon://full-stacked-column-chart",waterfall:"sap-icon://vertical-waterfall-chart",horizontal_waterfall:"sap-icon://horizontal-waterfall-chart"};f.prototype.displayChartTypes=function(e){const t=this._getChart();const a=e.getSource();if(!t||!a){return}if(!this.oReadyPromise){this.oReadyPromise=new Promise(function(e){if(p){e(true)}else{sap.ui.require(["sap/m/ResponsivePopover","sap/m/List","sap/m/SearchField","sap/m/StandardListItem","sap/ui/core/InvisibleText","sap/ui/Device"],function(t,a,s,i,o,r){p=t;l=a;h=s;d=i;u=o;b=r;if(!y){sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc",true).then(function(t){y=t;e(true)})}else{e(true)}})}})}this.oReadyPromise.then(function(){if(!this.oPopover){this.oPopover=this._createPopover(t);this.oPopover.attachAfterClose(function(){this.oPopover.destroy();delete this.oPopover}.bind(this));return this.oPopover.openBy(a)}else if(this.oPopover){this.oPopover.close()}}.bind(this))};f.prototype._createPopover=function(e){const t=new d({title:"{$chartTypes>text}",icon:"{$chartTypes>icon}",selected:"{$chartTypes>selected}"});const a=new l({mode:"SingleSelectMaster",noData:new i({title:y.getText("chart.NO_CHART_TYPES_AVAILABLE"),description:y.getText("chart.NO_CHART_TYPES_AVAILABLE_ACTION"),illustrationType:o.IllustratedMessageType.AddDimensions}),items:{path:"$chartTypes>/AvailableChartTypes",template:t},selectionChange:function(t){if(t&&t.mParameters&&t.mParameters.listItem){const a=t.mParameters.listItem.getBinding("title");if(a){const t=a.getContext();if(t){const a=t.getObject();if(a&&a.key){sap.ui.require(["sap/ui/mdc/flexibility/Chart.flexibility"],function(t){e.getEngine().createChanges({control:e,key:"Type",state:{properties:{chartType:a.key}}}).then(function(t){e.getControlDelegate().requestToolbarUpdate(e)})})}}}}r.close()}});const s=new h({placeholder:y.getText("chart.CHART_TYPE_SEARCH"),liveChange:function(t){if(e){this._triggerSearchInPopover(t,a)}}.bind(this)});const r=new p({id:e.getId()+"-btnChartTypePopover",placement:c.VerticalPreferredBottom,contentWidth:"25rem"});if(!b.system.phone){r.setSubHeader(s)}else{r.addContent(s)}const f=new n;f.setProperty("/AvailableChartTypes",this._getChart().getAvailableChartTypes());r.setModel(f,"$chartTypes");if(b.system.desktop){const e=new u({text:y.getText("chart.CHART_TYPELIST_TEXT")});r.setShowHeader(false);r.addContent(e);r.addAriaLabelledBy(e)}else{r.setTitle(y.getText("chart.CHART_TYPELIST_TEXT"))}r.addContent(a);if(a.getItems().length<7){s.setVisible(false)}return r};f.prototype._triggerSearchInPopover=function(e,t){if(!e||!t){return}const a=e.getParameter("newValue");let s=[];if(a){s=new r("text","Contains",a)}t.getBinding("items").filter(s)};f.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this.oPopover){this.oPopover.destroy();this.oPopover=null}if(this._oObserver){this._oObserver.disconnect();this._oObserver.destroy();delete this._oObserver}};return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/DrillBreadcrumbs", ["sap/m/Breadcrumbs","sap/m/Link"],function(e,t){"use strict";const s=e.extend("sap.ui.mdc.chart.DrillBreadcrumbs",{renderer:{apiVersion:2}});s.prototype.init=function(){e.prototype.init.apply(this,arguments);this.addStyleClass("sapUiMDCChartBreadcrumbs")};s.prototype.updateDrillBreadcrumbs=function(e,t){const s=[];if(t){t.reverse();if(t.length>0){t.forEach(function(t,i,n){this.setVisible(true);const r=t.getLabel();const o=t.getPropertyKey();if(i==0){this.setCurrentLocationText(r)}else{const t={dimensionKey:o,dimensionText:r};const i=this._createCrumb(e,t);s.push(i)}},this)}else{this.setVisible(false)}}const i=this.getLinks();s.reverse();let n=false;if(i.length!==s.length){n=true}else{for(let e=0;e<s.length;e++){if(s[e].getText()!=i[e].getText()){n=true;break}}}if(n){if(this.getLinks()){this.destroyLinks()}for(let e=0;e<s.length;e++){this.addLink(s[e])}}return this};s.prototype._createCrumb=function(e,s){const i=new t({text:s.dimensionText,press:function t(s){const i=this.indexOfLink(s.getSource());const n=e.getControlDelegate().getDrillableItems(e),r=n.slice(i+1);const o=r.map(function(e){return{name:e.getPropertyKey(),visible:false}});e.getEngine().createChanges({control:e,key:"Item",state:o})}.bind(this)});i.data("key",s.dimensionKey);return i};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/DrillStackHandler", ["sap/ui/core/Core","sap/m/ResponsivePopover","sap/m/List","sap/m/Bar","sap/m/StandardListItem","sap/ui/core/InvisibleText","sap/m/library","sap/ui/Device","sap/base/Log","sap/m/IllustratedMessage","sap/m/SearchField","sap/ui/model/json/JSONModel","sap/ui/model/Filter"],function(e,t,n,o,i,s,r,a,l,c,d,u,m){"use strict";const p=r.PlacementType;const f=r.ListMode;function g(e){const t=e.getControlDelegate().getDrillStack(e);const n=[];t.forEach(function(e){e.dimension.forEach(function(e){if(e!=null&&e!=""&&n.indexOf(e)==-1){n.push(e)}})});return n}const D=function(){};D.createDrillDownPopover=function(o){let l=null;const u=e.getLibraryResourceBundle("sap.ui.mdc");const g=new d({placeholder:u.getText("chart.CHART_DRILLDOWN_SEARCH"),liveChange:function(e){if(!l){return}const t=e.getParameter("newValue");let n=[];if(t){n=new m("text","Contains",t)}l.getBinding("items").filter(n)}});const D=new t({id:o.getId()+"-drilldownPopover",contentWidth:"25rem",contentHeight:"20rem",placement:p.VerticalPreferredBottom,afterClose:function(){D.destroy()}});if(!a.system.phone){D.setSubHeader(g)}else{D.addContent(g)}const h=new i({title:"{$ChartDrilldown>text}"});l=new n({noData:new c({enableVerticalResponsiveness:true,title:u.getText("chart.NO_DRILLABLE_DIMENSION"),description:u.getText("chart.NO_DRILLABLE_DIMENSION_DESC"),illustrationType:r.IllustratedMessageType.NoDimensionsSet}),mode:f.SingleSelectMaster,items:{path:"$ChartDrilldown>/items",template:h},selectionChange:function(e){const t=e.getParameter("listItem");if(t){const e=t.getBindingContext("$ChartDrilldown");const n=e.getObject().id;o.getEngine().createChanges({control:o,key:"Item",state:[{name:n,position:o.getItems().length}]})}D.close()}});if(a.system.desktop){const e=new s({text:u.getText("chart.CHART_DRILLDOWN_TITLE")});D.setShowHeader(false);D.addContent(e);D.addAriaLabelledBy(e)}else{D.setTitle(u.getText("chart.CHART_DRILLDOWN_TITLE"))}D.addContent(l);o._oDrillDownPopover=D;return D};D.showDrillDownPopover=function(e,t){const n=e.getControlDelegate().getSortedDimensions(e);return n.then(function(n){const o=e._oDrillDownPopover;const i=g(e);n=n.filter(function(e){return i.indexOf(e.name)<0});const s={items:[]};n.forEach(function(e){s.items.push({text:e.label,id:e.name})});o.setModel(new u(s),"$ChartDrilldown");if(s.items.length<7){const e=o.getSubHeader()||o.getContent()[0];e.setVisible(false)}return new Promise(function(e,n){o.attachEventOnce("afterOpen",function t(n){e(o)});o.openBy(t)})})};return D});
/*
 * !OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/Item", ["sap/ui/core/Element","sap/base/Log"],function(t,e){"use strict";const r=t.extend("sap.ui.mdc.chart.Item",{metadata:{abstract:false,library:"sap.ui.mdc",properties:{name:{type:"string"},propertyKey:{type:"string"},label:{type:"string"},type:{type:"string",defaultValue:""},role:{type:"string"}}}});r.prototype.getPropertyKey=function(){const t=this.getProperty("propertyKey");return t||this.getName()};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/PropertyHelper", ["../util/PropertyHelper","sap/ui/mdc/enums/ChartItemRoleType"],function(t,e){"use strict";const r=t.extend("sap.ui.mdc.chart.PropertyHelper",{constructor:function(e,r){t.call(this,e,r,{filterable:true,sortable:true,propertyInfos:true,groupable:{type:"boolean"},aggregatable:{type:"boolean"},propertyPath:{type:"string"},aggregationMethod:{type:"string"},role:{type:"string"},datapoint:{type:"object"},criticality:{type:"object"},textProperty:{type:"string"},availableRoles:{type:"object"},kind:{type:"string"}})}});r.prototype.prepareProperty=function(e){if(e.groupable){e.availableRoles=this._getLayoutOptionsForType("groupable");e.kind="Groupable"}else if(e.aggregatable){e.availableRoles=this._getLayoutOptionsForType("aggregatable");e.kind="Aggregatable"}if(!e.typeConfig&&e.dataType){const t=e.formatOptions?e.formatOptions:null;const r=e.constraints?e.constraints:{};e.typeConfig=this.getParent().getTypeMap().getTypeConfig(e.dataType,t,r)}t.prototype.prepareProperty.apply(this,arguments);e.isAggregatable=function(){if(e){return e.isComplex()?false:e.aggregatable}}};r.prototype._getLayoutOptionsForType=function(t){const r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");const a={groupable:[{key:e.category,text:r.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY")},{key:e.category2,text:r.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY2")},{key:e.series,text:r.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_SERIES")}],aggregatable:[{key:e.axis1,text:r.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS1")},{key:e.axis2,text:r.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS2")},{key:e.axis3,text:r.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS3")}]};return a[t]};r.prototype.getAllAggregatableProperties=function(){return this.getProperties().filter(function(t){return t.isAggregatable()})};return r});
/*
 * !OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/SelectionDetailsActions", ["sap/ui/core/Element"],function(e){"use strict";const t=e.extend("sap.ui.mdc.chart.SelectionDetailsActions",{metadata:{library:"sap.ui.mdc",aggregations:{detailsItemActions:{type:"sap.ui.core.Item",multiple:true},detailsActions:{type:"sap.ui.core.Item",multiple:true},actionGroups:{type:"sap.ui.core.Item",multiple:true}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/condition/Condition", ["sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName"],function(n,t){"use strict";const e=function(n){return JSON.stringify(Object.assign({},n,{isEmpty:undefined}),function(n,t){return t===undefined?"[undefined]":t})};const i={createItemCondition:function(e,i,o,r,a){let s=n.NotValidated;const u=[e,i];if(i===null||i===undefined){u.pop()}else{s=n.Validated}return this.createCondition(t.EQ,u,o,r,s,a)},createCondition:function(n,t,e,i,o,r){const a={operator:n,values:t,isEmpty:null,validated:o};if(e){a.inParameters=e}if(i){a.outParameters=i}if(r){a.payload=r}return a},compareConditions:function(n,t){const i=e(n);const o=e(t);return i===o},_removeEmptyConditions:function(n){for(let t=n.length-1;t>-1;t--){if(n[t].isEmpty){n.splice(parseInt(t),1)}}return n},_removeInitialFlags:function(n){for(let t=n.length-1;t>-1;t--){if(n[t].isInitial){delete n[t].isInitial}}return n}};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/condition/ConditionConverter", ["sap/ui/mdc/condition/Condition","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/condition/FilterOperatorUtil","sap/base/util/merge"],function(e,t,a,n,r){"use strict";const o={toString:function(t,a,o){const u=n.getOperator(t.operator);const l=a.typeInstance?a.typeInstance:a;const c=s(t.values,i(l,u),u,o);let p;let d;let f;if(t.inParameters){p=r({},t.inParameters)}if(t.outParameters){d=r({},t.outParameters)}if(t.payload){f=r({},t.payload)}const y=e.createCondition(t.operator,c,p,d,t.validated,f);return y},toType:function(a,o,s){const l=n.getOperator(a.operator);const c=o.typeInstance?o.typeInstance:o;const p=u(a.values,i(c,l),s);let d;let f;let y;if(a.inParameters){d=r({},a.inParameters)}if(a.outParameters){f=r({},a.outParameters)}if(a.payload){y=r({},a.payload)}const m=e.createCondition(a.operator,p,d,f,a.validated,y);if(m.validated!==t.Validated&&l.validateInput){l.checkValidated(m)}return m}};function i(e,t){if(t&&t.valueTypes[0]&&(t.valueTypes[0]!==a.Self&&t.valueTypes[0]!==a.Static)){return t._createLocalType(t.valueTypes[0],e)}return e}function s(e,t,n,r){const o=[];for(let i=0;i<e.length;i++){if(!n||n.valueTypes[i]&&n.valueTypes[i]!==a.Static){const a=e[i];o.push(r.externalizeValue(a,t))}}return o}function u(e,t,a){const n=[];for(let r=0;r<e.length;r++){const o=e[r];n.push(a.internalizeValue(o,t))}return n}return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/condition/ConditionModel", ["sap/ui/mdc/condition/ConditionModelPropertyBinding","sap/ui/model/json/JSONModel","sap/ui/model/ChangeReason","sap/ui/mdc/condition/FilterOperatorUtil","sap/base/util/merge","sap/base/Log","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/FilterConverter","sap/ui/core/date/UI5Date"],function(t,e,i,n,o,s,r,d,c){"use strict";const l=e.extend("sap.ui.mdc.condition.ConditionModel",{constructor:function(){e.apply(this,arguments);this.setSizeLimit(1e3);if(!this.getProperty("/conditions")){this.setProperty("/conditions",{})}if(!this.getProperty("/fieldPath")){this.setProperty("/fieldPath",{})}}});l.prototype.bindProperty=function(e,i,n){let o=e;if(e.startsWith("/conditions/")){let t=e.slice(12);this._getFieldPathProperty(t);t=p.call(this,t);o="/conditions/"+t}const s=new t(this,o,i,n);s._sOriginapPath=e;return s};l.prototype.getContext=function(t){if(t.startsWith("/conditions/")){let e=t.slice(12);e=p.call(this,e);t="/conditions/"+e}return e.prototype.getContext.apply(this,[t])};l.prototype.bindList=function(t,i,n,o,s){const r=e.prototype.bindList.apply(this,arguments);r.enableExtendedChangeDetection(true);return r};l.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments)};l.prototype.clone=function(t){const e=new l;e._sName=this._sName+"_clone";let i={};if(typeof t==="string"){const e=this.getConditions(t);for(let n=0;n<e.length;n++){const s=e[n];const r=p.call(this,t);if(!i[r]){i[r]=[]}i[r].push(o({},s))}}else{i=o({},this.getAllConditions())}e.setConditions(i);return e};l.prototype.merge=function(t,e,i){this.removeAllConditions(t);const n=o({},e.getAllConditions());for(const t in n){if(!(typeof i==="string")||t===i){const e=r._removeEmptyConditions(n[t]);for(let i=0;i<e.length;i++){const n=e[i];this.addCondition(t,n)}}}this.checkUpdate(true,true)};l.prototype.getConditions=function(t){return h.call(this,t)};function h(t,e){const i=this.getProperty("/conditions");let n;if(typeof t=="string"){t=p.call(this,t);if(!i[t]&&e){i[t]=[]}n=i[t]||[]}else{throw new Error("ConditionModel","getConditions without FieldPath is not supported!")}return n}l.prototype.getAllConditions=function(t){const e=this.getProperty("/conditions");const i={};for(const n in e){const s=this.getProperty("/fieldPath");const r=s[n];const d=r?r.fieldPath:n;if(t&&[].concat(t).indexOf(d)===-1){continue}i[d]=o([],e[n])}return i};l.prototype.indexOf=function(t,e,i){if(typeof t!=="string"){throw new Error("sFieldPath must be a string "+this)}const o=this.getConditions(t);const s=i?[i(e),o.map(i)]:[e,o];const r=n.indexOfCondition.apply(n,s);return r};l.prototype.exist=function(t,e){if(typeof e==="string"){return this.indexOf(e,t)>=0}else{throw new Error("sFieldPath must be provided "+this)}};l.prototype.setConditions=function(t){let e=0;let s;if(Array.isArray(t)){throw new Error("setConditions with an Array of condition is not supported! "+this)}else{this._bNoSingleEvent=true;let r=false;let d;let c;const l=o({},this.getProperty("/conditions"));for(d in t){this._getFieldPathProperty(d);c=p.call(this,d);const o=l[c]||[];const h=t[d]||[];if(!n.compareConditionsArray(o,h)){r=true;this.removeAllConditions(d);for(e=0;e<t[d].length;e++){s=t[d][e];this.insertCondition(d,-1,s,true)}this.firePropertyChange({reason:i.Binding,path:"/conditions/"+d,context:undefined,value:t[d]})}delete l[c]}const h=this.getProperty("/fieldPath");for(c in l){if(l[c].length>0){r=true;d=h[c].fieldPath;this.removeAllConditions(d);this.firePropertyChange({reason:i.Binding,path:"/conditions/"+d,context:undefined,value:[]})}}if(r){this.checkUpdate(false,true)}this._bNoSingleEvent=false}return this};l.prototype.addCondition=function(t,e,i){if(typeof t!=="string"){throw new Error("sFieldPath must be a string "+this)}return this.insertCondition(t,-1,e,i)};l.prototype.insertCondition=function(t,e,o,s){if(typeof t!=="string"){throw new Error("sFieldPath must be a string "+this)}if(!o){return this}n.checkConditionsEmpty(o);n.updateConditionsValues(o);this._getFieldPathProperty(t);if(!s){const e=this.indexOf(t,o);if(e>=0){return this}}const r=h.call(this,t,true);if(e==-1){r.push(o)}else{r.splice(e,0,o)}if(!this._bNoSingleEvent){this.checkUpdate(false,true);this.firePropertyChange({reason:i.Binding,path:"/conditions/"+t,context:undefined,value:r})}return this};l.prototype.createItemCondition=function(t,e,i){s.error("ConditionModel","createItemCondition is deprecated");return r.createItemCondition(e,i)};l.prototype.createCondition=function(t,e,i){s.error("ConditionModel","createCondition is deprecated");return r.createCondition(e,i)};l.prototype.removeCondition=function(t,e){if(typeof t!=="string"){throw new Error("sFieldPath must be a string "+this)}let n=-1;if(typeof e==="object"){n=this.indexOf(t,e)}else if(typeof e==="number"){n=e}if(n>=0){const e=this.getConditions(t);if(e.length>n){e.splice(n,1);this.checkUpdate(false,true);this.firePropertyChange({reason:i.Binding,path:"/conditions/"+t,context:undefined,value:e});return true}}return false};l.prototype.removeAllConditions=function(t){const e=this.getProperty("/conditions");if(typeof t==="string"){const n=p.call(this,t);if(e[n]&&e[n].length>0){e[n]=[];if(!this._bNoSingleEvent){this.firePropertyChange({reason:i.Binding,path:"/conditions/"+t,context:undefined,value:e[n]})}}}else{for(const t in e){if(e[t]&&e[t].length>0){e[t]=[];if(!this._bNoSingleEvent){const n=this.getProperty("/fieldPath");const o=n[t].fieldPath;this.firePropertyChange({reason:i.Binding,path:"/conditions/"+o,context:undefined,value:e[t]})}}}}if(!this._bNoSingleEvent){this.checkUpdate(false,true)}return this};l.prototype._getFieldPathProperty=function(t){const e=p.call(this,t);const i=this.getProperty("/fieldPath");if(!i[e]){i[e]={fieldPath:t}}const n=this.getProperty("/conditions");if(!n[e]){n[e]=[]}return i[e]};l.prototype.getFilters=function(t){s.error("ConditionModel","usage or deprecated getFilters() function! Please use the FilterConverter.createFilters() function instead.");return d.createFilters(this.getAllConditions(),{})};l.prototype.serialize=function(){const t=o({},this.getAllConditions());for(const e in t){const i=t[e];i.forEach(function(t){delete t.isEmpty},this);if(i.length===0){delete t[e]}}return'{"conditions":'+JSON.stringify(t)+"}"};l.prototype.parse=function(t){const e=function(t,e){let i;if(!isNaN(parseInt(t))&&typeof e==="string"){i=/^(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2}).(\d{3})Z$/.exec(e);if(i){return c.getInstance(e)}}return e};this.setConditions(JSON.parse(t,e).conditions)};function p(t){if(t){const e=t.split("/");if(e.length>1){t="";for(let i=0;i<e.length;i++){const n=e[i];if(i>0){if(!isNaN(n)||!isNaN(e[i-1])){t=t+"/"}else{t=t+"\\"}}t=t+n}}}return t}return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/condition/ConditionModelPropertyBinding", ["sap/ui/model/ChangeReason","sap/ui/model/json/JSONPropertyBinding","sap/base/util/merge","sap/base/util/deepEqual","sap/ui/core/date/UI5Date"],function(t,e,i,s,a){"use strict";const o=e.extend("sap.ui.mdc.condition.ConditionModelPropertyBinding",{constructor:function(t,i,s,a){e.apply(this,arguments);this.oValue=n.call(this,this._getValue())}});o.prototype.getValue=function(){return n.call(this,this.oValue)};o.prototype.setValue=function(e){if(this.bSuspended){return}if(!s(this.oValue,e)){if(this.oModel.setProperty(this.sPath,e,this.oContext,true)){this.oValue=n.call(this,e);this.getDataState().setValue(this.oValue);this.oModel.firePropertyChange({reason:t.Binding,path:this._sOriginapPath,context:this.oContext,value:e})}}};o.prototype.checkUpdate=function(e){if(this.bSuspended&&!e){return}const i=this._getValue();if(!s(i,this.oValue)||e){this.oValue=n.call(this,i);this.getDataState().setValue(this.oValue);this.checkDataState();this._fireChange({reason:t.Change})}};function n(t){let e;if(!t){e=t}else if(Array.isArray(t)){e=i([],t)}else if(t instanceof Date){e=a.getInstance(t)}else if(typeof t==="object"){e=i({},t)}else{e=t}return e}return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/condition/ConditionValidateException", ["sap/ui/model/ValidateException"],function(t){"use strict";const o=function(o,i,n,e){t.call(this,o,i);this.condition=n;this.conditions=e};o.prototype=Object.create(t.prototype);o.prototype.getCondition=function(){return this.condition};o.prototype.setCondition=function(t){this.condition=t};o.prototype.getConditions=function(){return this.conditions};o.prototype.setConditions=function(t){this.conditions=t};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/mdc/condition/FilterConverter", ["sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/base/Log"],function(e,t,r,n){"use strict";const i={createConditionTypesMapFromFilterBar:function(e,t){const r={};for(const n in e){if(t){const e=t._getPropertyByName(n);let i;if(e&&e.typeConfig){i=e.typeConfig.typeInstance}else{const e=t._getFilterField(n);if(e){const t=e.getFormatOptions();if(t.originalDateType){i=t.originalDateType}else{i=t.valueType}}}r[n]={type:i}}}return r},createFilters:function(o,s,l,a){let f,p,u,c,h,d,g,y;const F=[];const P=function(e,t,r){const n="L1";let i,o,s;if(e.sPath&&e.sPath.indexOf(r)>-1){i=e.sPath.split(r);if(i.length===2){o=i[0];s=i[1];e.sPath=n+"/"+s;return{path:o,operator:t,variable:n}}else{throw new Error("FilterConverter: not supported binding "+e.sPath)}}return false};const v=function(e){const t=P(e,r.Any,"*/");if(t){return t}else{return P(e,r.All,"+/")}};for(const r in o){p=[];u=[];y=null;const i=o[r];if(r==="$search"){continue}let l;let P=true;let O;if(s){if(s[r]){l=s[r].type;P=s[r].caseSensitive;O=s[r].baseType;if(!l){n.warning("FilterConverter","Not able to retrieve the type of path '"+r+"!")}}}for(f=0;f<i.length;f++){g=i[f];c=e.getOperator(g.operator);if(!c){continue}try{h=c.getModelFilter(g,r,l,P,O)}catch(e){if(e){n.error("FilterConverter",e)}else{n.error("FilterConverter","Not able to convert the condition for path '"+r+"' into a filter! The type is missing!")}continue}if(!c.exclude){if(h.sPath==="$search"){continue}const e=/^\*(.+)\*$/.exec(h.sPath);if(e){const r=e[1].split(",");for(let e=0;e<r.length;e++){p.push(new t({path:r[e],operator:h.sOperator,value1:h.oValue1,caseSensitive:a}))}continue}y=v(h);p.push(h)}else{y=v(h);u.push(h)}}h=undefined;if(p.length===1){h=p[0]}else if(p.length>1){h=new t({filters:p,and:false})}if(h){u.unshift(h)}d=undefined;if(u.length===1){d=u[0]}else if(u.length>1){d=new t({filters:u,and:true})}if(y){y.condition=d;d=new t(y)}if(d){F.push(d)}}if(F.length===1){h=F[0]}else if(F.length>1){h=new t({filters:F,and:true})}else{h=null}n.info("FilterConverter",i.prettyPrintFilters(h));return h},prettyPrintFilters:function(e){let t;if(!e){return"no filters set"}if(e._bMultiFilter){t="";const r=e.bAnd;e.aFilters.forEach(function(e,n,o){t+=i.prettyPrintFilters(e);if(o.length-1!=n){t+=r?" and ":" or "}},this);return"("+t+")"}else{if(e.sOperator===r.Any||e.sOperator===r.All){t=e.sPath+" "+e.sOperator+" "+i.prettyPrintFilters(e.oCondition)}else{if(e.bCaseSensitive===false){t="tolower("+e.sPath+") "+e.sOperator+" tolower('"+e.oValue1+"')"}else{t=e.sPath+" "+e.sOperator+" '"+e.oValue1+"'"}if([r.BT,r.NB].indexOf(e.sOperator)>=0){t+="...'"+e.oValue2+"'"}}return t}}};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/mdc/condition/FilterOperatorUtil", ["sap/ui/model/FilterOperator","sap/ui/model/Filter","sap/ui/model/ValidateException","sap/base/Log","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/OperatorName","./Operator","./RangeOperator","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/util/loadModules","sap/ui/core/date/UniversalDate","sap/ui/core/date/UniversalDateUtils","sap/ui/core/format/DateFormat","sap/ui/core/StaticArea","sap/ui/model/json/JSONModel","sap/ui/model/type/Integer"],function(e,t,a,r,n,s,o,l,i,u,p,m,c,f,O,y,T,g){"use strict";let d=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");sap.ui.getCore().attachLocalizationChanged(function(){d=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc")});const h={_mOperators:{equal:new o({name:s.EQ,alias:{Date:"DATE",DateTime:"DATETIME"},filterOperator:e.EQ,tokenParse:"^=([^=].*)$",tokenFormat:"{1} ({0})",valueTypes:[p.Self,null],displayFormats:{DescriptionValue:"{1} ({0})",ValueDescription:"{0} ({1})",Description:"{1}",Value:"{0}"},format:function(e,t,a,r,s,o,l){a=a||n.DescriptionValue;let i=this.valueTypes.length;const p=e.values;const m=e&&e.validated===u.Validated||p.length===2||r?"":"=";let c=m+this.displayFormats[a];if(!p[1]){c=m+this.displayFormats["Value"];i=1}for(let e=0;e<i;e++){let a,r=p[e];if(r===null||r===undefined){r=""}if(e===0){a=this._formatValue(r,t,s)}else{a=this._formatValue(r,o,l)}if(a===null){c=null;break}if(typeof a==="string"){a=a.replace(/\$/g,"$$$")}c=c.replace(new RegExp("\\$"+e+"|"+e+"\\$"+"|"+"\\{"+e+"\\}","g"),a)}return c},parse:function(e,t,a,r,s,l,i){a=a||n.DescriptionValue;let u=o.prototype.parse.apply(this,[e,t,a,r,s,l,i]);if(r&&(!u||u[0]===null||u[0]===undefined)&&a!==n.Value){a=n.Value;u=o.prototype.parse.apply(this,[e,t,a,r,s,l,i])}if(u&&(u[1]===null||u[1]===undefined)&&a===n.Value){u=[u[0]]}return u},getValues:function(e,t,a){const r=e.match(this.tokenParseRegExp);let n;if(r||a&&e){let s;const o=this.displayFormats[t];const l=o.indexOf("{0}");const i=o.indexOf("{1}");let u;let p;if(r){s=r[1]}else if(a){s=e}if(l>=0&&i>=0){if(s.lastIndexOf("(")>0&&(s.lastIndexOf(")")===s.length-1||s.lastIndexOf(")")===-1)){let e=s.length;if(s[e-1]===")"){e--}let t=s.substring(0,s.lastIndexOf("("));if(t[t.length-1]===" "){t=t.substring(0,t.length-1)}const a=s.substring(s.lastIndexOf("(")+1,e);if(l<i){u=t;p=a}else{u=a;p=t}}else if(l<i){u=s}else{p=s}}else if(l>=0){u=s}else{p=s}n=[u];if(i>=0){n.push(p)}}return n},isEmpty:function(e,t){let a=false;const r=e.values[0];if((r===null||r===undefined||r==="")&&!e.values[1]){a=true}return a},getCheckValue:function(e){return{value:e.values[0]}},checkValidated:function(e){if(e.values.length===2&&e.values[0]!==undefined&&e.values[1]!==null&&e.values[1]!==undefined){e.validated=u.Validated}else{e.validated=u.NotValidated}},validateInput:true}),between:new o({name:s.BT,alias:{Date:"DATERANGE",DateTime:"DATETIMERANGE"},filterOperator:e.BT,tokenParse:"^([^!].*)\\.\\.\\.(.+)$",tokenFormat:"{0}...{1}",valueTypes:[p.Self,p.Self],validate:function(e,t){if(e.length===2){if(E(e[0])&&E(e[1])){return}else if(E(e[0])||E(e[1])){throw new a(d.getText("operator.between.validate.missingValue"))}else if(e[0]===e[1]){throw new a(d.getText("operator.between.validate.sameValues"))}}o.prototype.validate.apply(this,[e,t])}}),notBetween:new o({name:s.NOTBT,filterOperator:e.NB,tokenParse:"^!(.+)\\.\\.\\.(.+)$",tokenFormat:"!({0}...{1})",valueTypes:[p.Self,p.Self],exclude:true,validate:function(e,t){h._mOperators.between.validate(e,t)}}),lessThan:new o({name:s.LT,filterOperator:e.LT,tokenParse:"^<([^=].*)$",tokenFormat:"<{0}",valueTypes:[p.Self]}),notLessThan:new o({name:s.NOTLT,filterOperator:e.GE,tokenParse:"^!<([^=].*)$",tokenFormat:"!(<{0})",valueTypes:[p.Self],exclude:true}),greaterThan:new o({name:s.GT,filterOperator:e.GT,tokenParse:"^>([^=].*)$",tokenFormat:">{0}",valueTypes:[p.Self]}),notGreaterThan:new o({name:s.NOTGT,filterOperator:e.LE,tokenParse:"^!>([^=].*)$",tokenFormat:"!(>{0})",valueTypes:[p.Self],exclude:true}),lessEqual:new o({name:s.LE,alias:{Date:"TO",DateTime:"TODATETIME"},filterOperator:e.LE,tokenParse:"^<=(.+)$",tokenFormat:"<={0}",valueTypes:[p.Self]}),notLessEqual:new o({name:s.NOTLE,filterOperator:e.GT,tokenParse:"^!<=(.+)$",tokenFormat:"!(<={0})",valueTypes:[p.Self],exclude:true}),greaterEqual:new o({name:s.GE,alias:{Date:"FROM",DateTime:"FROMDATETIME"},filterOperator:e.GE,tokenParse:"^>=(.+)$",tokenFormat:">={0}",valueTypes:[p.Self]}),notGreaterEqual:new o({name:s.NOTGE,filterOperator:e.LT,tokenParse:"^!>=(.+)$",tokenFormat:"!(>={0})",valueTypes:[p.Self],exclude:true}),startsWith:new o({name:s.StartsWith,filterOperator:e.StartsWith,tokenParse:"^([^!\\*]+.*)\\*$",tokenFormat:"{0}*",valueTypes:[p.SelfNoParse]}),notStartsWith:new o({name:s.NotStartsWith,filterOperator:e.NotStartsWith,tokenParse:"^!([^\\*].*)\\*$",tokenFormat:"!({0}*)",valueTypes:[p.SelfNoParse],exclude:true}),endsWith:new o({name:s.EndsWith,filterOperator:e.EndsWith,tokenParse:"^\\*(.*[^\\*])$",tokenFormat:"*{0}",valueTypes:[p.SelfNoParse]}),notEndsWith:new o({name:s.NotEndsWith,filterOperator:e.NotEndsWith,tokenParse:"^!\\*(.*[^\\*])$",tokenFormat:"!(*{0})",valueTypes:[p.SelfNoParse],exclude:true}),contains:new o({name:s.Contains,filterOperator:e.Contains,tokenParse:"^\\*(.*)\\*$",tokenFormat:"*{0}*",valueTypes:[p.SelfNoParse]}),notContains:new o({name:s.NotContains,filterOperator:e.NotContains,tokenParse:"^!\\*(.*)\\*$",tokenFormat:"!(*{0}*)",valueTypes:[p.SelfNoParse],exclude:true}),notEqual:new o({name:s.NE,filterOperator:e.NE,tokenParse:"^!=(.+)$",tokenFormat:"!(={0})",valueTypes:[p.Self],exclude:true}),empty:new o({name:s.Empty,filterOperator:e.EQ,tokenParse:"^<#tokenText#>$",tokenFormat:"<#tokenText#>",valueTypes:[],getModelFilter:function(a,r,n,s,o){let l=false;if(n){const e=n.parseValue("","string");try{n.validateValue(e);l=e===null}catch(e){l=false}}if(l){return new t({filters:[new t({path:r,operator:e.EQ,value1:""}),new t({path:r,operator:e.EQ,value1:null})],and:false})}else{return new t({path:r,operator:this.filterOperator,value1:""})}}}),notEmpty:new o({name:s.NotEmpty,filterOperator:e.NE,tokenParse:"^!<#tokenText#>$",tokenFormat:"!(<#tokenText#>)",valueTypes:[],exclude:true,getModelFilter:function(a,r,n,s,o){let l=false;if(n){const e=n.parseValue("","string");try{n.validateValue(e);l=e===null}catch(e){l=false}}if(l){return new t({filters:[new t({path:r,operator:e.NE,value1:""}),new t({path:r,operator:e.NE,value1:null})],and:true})}else{return new t({path:r,operator:this.filterOperator,value1:""})}}}),yesterday:new l({name:s.YESTERDAY,valueTypes:[p.Static],calcRange:function(){return f.ranges.yesterday()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),today:new l({name:s.TODAY,valueTypes:[p.Static],calcRange:function(){return f.ranges.today()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),tomorrow:new l({name:s.TOMORROW,valueTypes:[p.Static],calcRange:function(){return f.ranges.tomorrow()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDays:new l({name:s.LASTDAYS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.lastDays(e)}}),firstDayWeek:new l({name:s.FIRSTDAYWEEK,valueTypes:[p.Static],calcRange:function(){return f.ranges.firstDayOfWeek()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDayWeek:new l({name:s.LASTDAYWEEK,valueTypes:[p.Static],calcRange:function(){return f.ranges.lastDayOfWeek()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),firstDayMonth:new l({name:s.FIRSTDAYMONTH,valueTypes:[p.Static],calcRange:function(){return f.ranges.firstDayOfMonth()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDayMonth:new l({name:s.LASTDAYMONTH,valueTypes:[p.Static],calcRange:function(){return f.ranges.lastDayOfMonth()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),firstDayQuarter:new l({name:s.FIRSTDAYQUARTER,valueTypes:[p.Static],calcRange:function(){return f.ranges.firstDayOfQuarter()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDayQuarter:new l({name:s.LASTDAYQUARTER,valueTypes:[p.Static],calcRange:function(){return f.ranges.lastDayOfQuarter()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),firstDayYear:new l({name:s.FIRSTDAYYEAR,valueTypes:[p.Static],calcRange:function(){return f.ranges.firstDayOfYear()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDayYear:new l({name:s.LASTDAYYEAR,valueTypes:[p.Static],calcRange:function(){return f.ranges.lastDayOfYear()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),todayFromTo:new l({name:s.TODAYFROMTO,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}},{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}}],paramTypes:["([-+]?\\d+)","([-+]?\\d+)"],additionalInfo:"",calcRange:function(e,t){let a=e>=0?f.ranges.lastDays(e)[0]:f.ranges.nextDays(-e)[1];let r=t>=0?f.ranges.nextDays(t)[1]:f.ranges.lastDays(-t)[0];if(a.oDate.getTime()>r.oDate.getTime()){r=[a,a=r][0]}return[f.resetStartTime(a),f.resetEndTime(r)]}}),nextDays:new l({name:s.NEXTDAYS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.nextDays(e)}}),lastWeek:new l({name:s.LASTWEEK,valueTypes:[p.Static],calcRange:function(){return f.ranges.lastWeek()}}),thisWeek:new l({name:s.THISWEEK,valueTypes:[p.Static],calcRange:function(){return f.ranges.currentWeek()}}),nextWeek:new l({name:s.NEXTWEEK,valueTypes:[p.Static],calcRange:function(){return f.ranges.nextWeek()}}),lastWeeks:new l({name:s.LASTWEEKS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.lastWeeks(e)}}),nextWeeks:new l({name:s.NEXTWEEKS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.nextWeeks(e)}}),lastMonth:new l({name:s.LASTMONTH,valueTypes:[p.Static],calcRange:function(){return f.ranges.lastMonth()}}),thisMonth:new l({name:s.THISMONTH,valueTypes:[p.Static],calcRange:function(){return f.ranges.currentMonth()}}),nextMonth:new l({name:s.NEXTMONTH,valueTypes:[p.Static],calcRange:function(){return f.ranges.nextMonth()}}),lastMonths:new l({name:s.LASTMONTHS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.lastMonths(e)}}),nextMonths:new l({name:s.NEXTMONTHS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.nextMonths(e)}}),lastQuarter:new l({name:s.LASTQUARTER,valueTypes:[p.Static],calcRange:function(){return f.ranges.lastQuarter()}}),thisQuarter:new l({name:s.THISQUARTER,valueTypes:[p.Static],calcRange:function(){return f.ranges.currentQuarter()}}),nextQuarter:new l({name:s.NEXTQUARTER,valueTypes:[p.Static],calcRange:function(){return f.ranges.nextQuarter()}}),lastQuarters:new l({name:s.LASTQUARTERS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.lastQuarters(e)}}),nextQuarters:new l({name:s.NEXTQUARTERS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.nextQuarters(e)}}),quarter1:new l({name:s.QUARTER1,valueTypes:[p.Static],calcRange:function(){return f.ranges.quarter(1)}}),quarter2:new l({name:s.QUARTER2,valueTypes:[p.Static],calcRange:function(){return f.ranges.quarter(2)}}),quarter3:new l({name:s.QUARTER3,valueTypes:[p.Static],calcRange:function(){return f.ranges.quarter(3)}}),quarter4:new l({name:s.QUARTER4,valueTypes:[p.Static],calcRange:function(){return f.ranges.quarter(4)}}),lastYear:new l({name:s.LASTYEAR,valueTypes:[p.Static],calcRange:function(){return f.ranges.lastYear()}}),thisYear:new l({name:s.THISYEAR,valueTypes:[p.Static],calcRange:function(){return f.ranges.currentYear()}}),nextYear:new l({name:s.NEXTYEAR,valueTypes:[p.Static],calcRange:function(){return f.ranges.nextYear()}}),lastYears:new l({name:s.LASTYEARS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.lastYears(e)}}),nextYears:new l({name:s.NEXTYEARS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.nextYears(e)}}),specificMonth:new l({name:s.SPECIFICMONTH,valueTypes:[{name:"sap.ui.model.type.Integer",constraints:{minimum:0,maximum:11}}],paramTypes:["(.+)"],additionalInfo:"",label:[d.getText("operators.SPECIFICMONTH_MONTH.label")],defaultValues:function(){const e=new c;return[e.getMonth()]},calcRange:function(e){let t=new c;t.setMonth(e);t=f.getMonthStartDate(t);return f.getRange(0,"MONTH",t)},format:function(e,t,a,r,n,s,o){const l=e.values[0];const i=this.tokenFormat;const u=v.apply(this)[l];if(r){return u}else{return u==null?null:i.replace(new RegExp("\\$"+0+"|"+0+"\\$"+"|"+"\\{"+0+"\\}","g"),u)}},getValues:function(e,t,a){const r=e.match(this.tokenParseRegExp);let n;if(r||a&&e){n=[];for(let t=0;t<this.valueTypes.length;t++){let s;if(r){s=r[t+1]}else if(a&&e){s=e}n.push(s)}return[w.call(this,n[0])]}return null},createControl:function(e,t,a,n){const s=sap.ui.require("sap/ui/mdc/Field");const o=D.call(this);if(s&&o){const a=new s(n,{value:{path:t,type:e,mode:"TwoWay",targetType:"raw"},display:"Description",width:"100%",valueHelp:o});return a}else{r.warning("Operator.createControl","not able to create the control for the operator "+this.name);return null}}}),specificMonthInYear:new l({name:s.SPECIFICMONTHINYEAR,valueTypes:[{name:"sap.ui.model.type.Integer",constraints:{minimum:0,maximum:11}},{name:"sap.ui.model.type.Integer",constraints:{minimum:1,maximum:9999}}],paramTypes:["(.+)","(.+)"],additionalInfo:"",label:[d.getText("operators.SPECIFICMONTHINYEAR_MONTH.label"),d.getText("operators.SPECIFICMONTHINYEAR_YEAR.label")],defaultValues:function(){const e=new c;return[e.getMonth(),e.getFullYear()]},calcRange:function(e,t){let a=new c;a.setMonth(e);a.setYear(t);a=f.getMonthStartDate(a);return f.getRange(0,"MONTH",a)},format:function(e,t,a,r,n,s,o){const l=e.values[0];const i=e.values[1];let u=this.tokenFormat;const p=v.apply(this)[l];if(r){return p+","+i}else{const e=new RegExp("\\$"+0+"|"+0+"\\$"+"|"+"\\{"+0+"\\}","g");const t=new RegExp("\\$"+1+"|"+1+"\\$"+"|"+"\\{"+1+"\\}","g");u=p==null?null:u.replace(e,p);return u.replace(t,i)}},getValues:function(e,t,a){const r=e.match(this.tokenParseRegExp);let n;if(r||a&&e){n=[];for(let t=0;t<this.valueTypes.length;t++){let s;if(r){s=r[t+1]}else if(a&&e){s=e}n.push(s)}return[w.call(this,n[0]),n[1]]}return null},createControl:function(e,t,a,n){let s;const o=sap.ui.require("sap/ui/mdc/Field");if(!o){r.warning("Operator.createControl","not able to create the control for the operator "+this.name);return null}if(a==0){const a=D.call(this);if(a){s=new o(n,{value:{path:t,type:e,mode:"TwoWay",targetType:"raw"},display:"Description",width:"100%",valueHelp:a})}else{r.warning("Operator.createControl","not able to create the control for the operator "+this.name)}}if(a==1){s=new o(n,{value:{path:"$this>",type:e,mode:"TwoWay",targetType:"raw"},width:"100%"})}return s}}),yearToDate:new l({name:s.YEARTODATE,valueTypes:[p.Static],calcRange:function(){return f.ranges.yearToDate()}}),dateToYear:new l({name:s.DATETOYEAR,valueTypes:[p.Static],calcRange:function(){return f.ranges.dateToYear()}}),lastMinutes:new l({name:s.LASTMINUTES,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.lastMinutes(e)}}),nextMinutes:new l({name:s.NEXTMINUTES,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.nextMinutes(e)}}),lastHours:new l({name:s.LASTHOURS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.lastHours(e)}}),nextHours:new l({name:s.NEXTHOURS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.nextHours(e)}})},_mDefaultOpsForType:{},addOperator:function(e){h._mOperators[e.name]=e},addOperators:function(e){if(!Array.isArray(e)){e=[e]}e.forEach(function(e){h.addOperator(e)})},removeOperators:function(e){if(!Array.isArray(e)){e=[e]}e.forEach(function(e){h.removeOperator(e)})},removeOperator:function(e){if(typeof e==="string"){delete h._mOperators[e]}else{delete h._mOperators[e.name]}},setOperatorsForType:function(e,t,a){if(!Array.isArray(t)){t=[t]}if(!h._mDefaultOpsForType[e]){h._mDefaultOpsForType[e]={}}h._mDefaultOpsForType[e].operators=[];t.forEach(function(t){h.addOperatorForType(e,t)});if(a){h.setDefaultOperatorForType(e,a)}},setDefaultOperatorForType:function(e,t){if(!h._mDefaultOpsForType[e]){h._mDefaultOpsForType[e]={}}if(typeof t==="string"){t=h.getOperator(t)}h._mDefaultOpsForType[e].defaultOperator=t},addOperatorForType:function(e,t){h.insertOperatorForType(e,t)},insertOperatorForType:function(e,t,a){if(!h._mDefaultOpsForType[e]){h._mDefaultOpsForType[e]={operators:[]}}a=a===undefined?h._mDefaultOpsForType[e].operators.length:a;if(typeof t==="string"){t=h.getOperator(t)}h._mDefaultOpsForType[e].operators.splice(a,0,t)},removeOperatorForType:function(e,t){let a;if(typeof t==="string"){a=t}else{a=t.name}for(let t=0;t<h._mDefaultOpsForType[e].operators.length;t++){if(h._mDefaultOpsForType[e].operators[t].name===a){h._mDefaultOpsForType[e].operators.splice(t,1);return}}},getOperatorsForType:function(e){const t=[];for(let a=0;a<h._mDefaultOpsForType[e].operators.length;a++){t.push(h._mDefaultOpsForType[e].operators[a].name)}return t},getDefaultOperator:function(e){return h._mDefaultOpsForType[e].defaultOperator||h._mOperators.equal},getMatchingOperators:function(e,t){const a=[];for(let t=0;t<e.length;t++){const r=this.getOperator(e[t]);if(r){a.push(r)}}return _.call(this,a,t)},getOperator:function(e){for(const t in h._mOperators){const a=h._mOperators[t];if(a.name===e){return a}}return undefined},getEQOperator:function(e){if(e){for(let t=0;t<e.length;t++){const a=this.getOperator(e[t]);if(a&&a.validateInput&&!a.exclude&&a.valueTypes[0]&&a.valueTypes[0]!==p.Static){return a}}}return h._mOperators.equal},onlyEQ:function(e){if(e.length===1&&e[0]===s.EQ){return true}else{return false}},checkConditionsEmpty:function(e){if(!Array.isArray(e)){e=[e]}e.forEach(function(e){const t=this.getOperator(e.operator);if(t){e.isEmpty=t.isEmpty(e)}}.bind(this))},updateConditionsValues:function(e){if(!Array.isArray(e)){e=[e]}for(let t=0;t<e.length;t++){this.updateConditionValues(e[t])}},updateConditionValues:function(e){const t=this.getOperator(e.operator);if(t&&e.validated!==u.Validated){let a=t.valueTypes.length;if(t.valueTypes.length===2&&t.valueTypes[1]===null&&(e.values.length<2||e.values[1]===null||e.values[1]===undefined)){a=a-1}if(t.valueTypes[0]==="static"){e.values=[]}else{while(e.values.length!=a){if(e.values.length<a){e.values.push(null)}if(e.values.length>a){e.values=e.values.slice(0,e.values.length-1)}}}}},indexOfCondition:function(e,t){let a=-1;for(let r=0;r<t.length;r++){if(this.compareConditions(e,t[r])){a=r;break}}return a},compareConditions:function(e,t){let a=false;if(e.operator===t.operator){const r=this.getOperator(e.operator);if(r){a=r.compareConditions(e,t)}}return a},compareConditionsArray:function(e,t){let a=false;if(e.length===t.length){a=true;for(let r=0;r<e.length;r++){if(!this.compareConditions(e[r],t[r])){a=false;break}}}return a},checkConditionValidated:function(e){const t=this.getOperator(e.operator);if(!e.validated&&t&&t.checkValidated){t.checkValidated(e)}},getOperatorForDynamicDateOption:function(e,t){let a;if(t&&e.startsWith(t)){a=this.getOperator(e.slice(t.length+1))}else{a=this.getOperator(e)}if(!a&&t){for(const r in h._mOperators){const n=h._mOperators[r];if(n.alias&&n.alias[t]===e){a=n;break}}}return a},getDynamicDateOptionForOperator:function(e,t,a){let r;if(e){if(t[e.name]){r=e.name}else if(e.alias&&t[e.alias[a]]){r=e.alias[a]}}return r},getCustomDynamicDateOptionForOperator:function(e,t){return t+"-"+e.name}};h.setOperatorsForType(i.String,[h._mOperators.contains,h._mOperators.equal,h._mOperators.between,h._mOperators.startsWith,h._mOperators.endsWith,h._mOperators.lessThan,h._mOperators.lessEqual,h._mOperators.greaterThan,h._mOperators.greaterEqual,h._mOperators.empty,h._mOperators.notContains,h._mOperators.notEqual,h._mOperators.notBetween,h._mOperators.notStartsWith,h._mOperators.notEndsWith,h._mOperators.notLessThan,h._mOperators.notLessEqual,h._mOperators.notGreaterThan,h._mOperators.notGreaterEqual,h._mOperators.notEmpty],h._mOperators.equal);h.setOperatorsForType(i.Date,[h._mOperators.equal,h._mOperators.between,h._mOperators.lessThan,h._mOperators.lessEqual,h._mOperators.greaterThan,h._mOperators.greaterEqual,h._mOperators.notEqual,h._mOperators.notBetween,h._mOperators.notLessThan,h._mOperators.notLessEqual,h._mOperators.notGreaterThan,h._mOperators.notGreaterEqual,h._mOperators.today,h._mOperators.yesterday,h._mOperators.tomorrow,h._mOperators.firstDayWeek,h._mOperators.lastDayWeek,h._mOperators.firstDayMonth,h._mOperators.lastDayMonth,h._mOperators.firstDayQuarter,h._mOperators.lastDayQuarter,h._mOperators.firstDayYear,h._mOperators.lastDayYear,h._mOperators.todayFromTo,h._mOperators.lastDays,h._mOperators.nextDays,h._mOperators.thisWeek,h._mOperators.lastWeek,h._mOperators.lastWeeks,h._mOperators.nextWeek,h._mOperators.nextWeeks,h._mOperators.specificMonth,h._mOperators.specificMonthInYear,h._mOperators.thisMonth,h._mOperators.lastMonth,h._mOperators.lastMonths,h._mOperators.nextMonth,h._mOperators.nextMonths,h._mOperators.thisQuarter,h._mOperators.lastQuarter,h._mOperators.lastQuarters,h._mOperators.nextQuarter,h._mOperators.nextQuarters,h._mOperators.quarter1,h._mOperators.quarter2,h._mOperators.quarter3,h._mOperators.quarter4,h._mOperators.thisYear,h._mOperators.lastYear,h._mOperators.lastYears,h._mOperators.nextYear,h._mOperators.nextYears,h._mOperators.yearToDate,h._mOperators.dateToYear]);h.setOperatorsForType(i.DateTime,[h._mOperators.equal,h._mOperators.between,h._mOperators.lessThan,h._mOperators.lessEqual,h._mOperators.greaterThan,h._mOperators.greaterEqual,h._mOperators.notEqual,h._mOperators.notBetween,h._mOperators.notLessThan,h._mOperators.notLessEqual,h._mOperators.notGreaterThan,h._mOperators.notGreaterEqual,h._mOperators.lastMinutes,h._mOperators.nextMinutes,h._mOperators.lastHours,h._mOperators.nextHours,h._mOperators.today,h._mOperators.yesterday,h._mOperators.tomorrow,h._mOperators.firstDayWeek,h._mOperators.lastDayWeek,h._mOperators.firstDayMonth,h._mOperators.lastDayMonth,h._mOperators.firstDayQuarter,h._mOperators.lastDayQuarter,h._mOperators.firstDayYear,h._mOperators.lastDayYear,h._mOperators.todayFromTo,h._mOperators.lastDays,h._mOperators.nextDays,h._mOperators.thisWeek,h._mOperators.lastWeek,h._mOperators.lastWeeks,h._mOperators.nextWeek,h._mOperators.nextWeeks,h._mOperators.specificMonth,h._mOperators.specificMonthInYear,h._mOperators.thisMonth,h._mOperators.lastMonth,h._mOperators.lastMonths,h._mOperators.nextMonth,h._mOperators.nextMonths,h._mOperators.thisQuarter,h._mOperators.lastQuarter,h._mOperators.lastQuarters,h._mOperators.nextQuarter,h._mOperators.nextQuarters,h._mOperators.quarter1,h._mOperators.quarter2,h._mOperators.quarter3,h._mOperators.quarter4,h._mOperators.thisYear,h._mOperators.lastYear,h._mOperators.lastYears,h._mOperators.nextYear,h._mOperators.nextYears,h._mOperators.yearToDate,h._mOperators.dateToYear]);h.setOperatorsForType(i.Numeric,[h._mOperators.equal,h._mOperators.between,h._mOperators.lessThan,h._mOperators.lessEqual,h._mOperators.greaterThan,h._mOperators.greaterEqual,h._mOperators.notEqual,h._mOperators.notBetween,h._mOperators.notLessThan,h._mOperators.notLessEqual,h._mOperators.notGreaterThan,h._mOperators.notGreaterEqual]);h.setOperatorsForType(i.Time,[h._mOperators.equal,h._mOperators.between,h._mOperators.lessThan,h._mOperators.lessEqual,h._mOperators.greaterThan,h._mOperators.greaterEqual,h._mOperators.notEqual,h._mOperators.notBetween,h._mOperators.notLessThan,h._mOperators.notLessEqual,h._mOperators.notGreaterThan,h._mOperators.notGreaterEqual]);h.setOperatorsForType(i.Boolean,[h._mOperators.equal,h._mOperators.notEqual]);function _(e,t){const a=[];for(let r=0;r<e.length;r++){const n=e[r];if(n&&n.test&&n.test(t)){a.push(n)}}return a}function E(e){return e===null||e===undefined||e===""}function v(){if(!this._aMonths){const e=new c,t=O.getDateInstance({pattern:"LLLL"});e.setDate(15);e.setMonth(0);const a=[];for(let r=0;r<12;r++){a.push(t.format(e));e.setMonth(e.getMonth()+1)}this._aMonths=a}return this._aMonths}function w(e){const t=e.toLowerCase();const a=v.apply(this);let r=-1;a.some(function(e,a){if(e.toLowerCase()==t){r=a;return true}});return r}let S=false;function D(){const e="LFHForSpecificMonth";if(!S){S=true;m(["sap/ui/mdc/valuehelp/content/FixedList","sap/ui/mdc/valuehelp/content/FixedListItem","sap/ui/mdc/ValueHelp","sap/ui/mdc/valuehelp/Popover","sap/ui/core/Control"]).then(function(t){const a=t[0];const n=t[1];const s=t[2];const o=t[3];const l=t[4];const i=function(){if(!this._aMonthsItems){const e=v.apply(this);this._aMonthsItems=[];for(let t=0;t<12;t++){this._aMonthsItems.push({text:e[t],key:t})}}return this._aMonthsItems}.bind(this);const u=new s(e,{typeahead:new o(e+"-pop",{content:[new a(e+"-FL",{filterList:false,useFirstMatch:true,items:{path:"$items>/",template:new n({text:"{$items>text}",key:"{$items>key}"}),templateShareable:false}})]})}).setModel(new T(i()),"$items");try{const t=y.getUIArea();const a=new l(e+"-parent",{dependents:[u]});t.addContent(a,true)}catch(e){r.error(e);throw new Error("MonthValueHelp cannot be assigned because static UIArea cannot be determined.")}}.bind(this))}return e}return h},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/mdc/condition/Operator", ["sap/ui/base/Object","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/ParseException","sap/base/Log","sap/base/util/merge","sap/base/util/deepEqual","./Condition","sap/ui/mdc/enums/ConditionValidated","sap/base/strings/escapeRegExp","sap/ui/mdc/enums/OperatorOverwrite","sap/ui/mdc/enums/OperatorValueType"],function(e,t,a,i,s,r,o,n,l,u,p,f){"use strict";let h=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");sap.ui.getCore().attachLocalizationChanged(function(){h=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc")});const d=e.extend("sap.ui.mdc.condition.Operator",{constructor:function(t){e.apply(this,arguments);if(!t){throw new Error("Operator configuration missing")}if(!t.name){s.warning("Operator configuration expects a name property")}if(!t.filterOperator&&!t.getModelFilter){throw new Error("Operator configuration for "+t.name+" needs a default filter operator from sap.ui.model.FilterOperator or the function getModelFilter")}this._enableOverwrites(t);this.name=t.name;if(t.alias){this.alias=t.alias}this.filterOperator=t.filterOperator;this.valueTypes=t.valueTypes;this.paramTypes=t.paramTypes;this.displayFormats=t.displayFormats;const a="operators."+this.name;const i=a+".longText";const r=a+".tokenText";this.longText=t.longText||c(i)||"";this.tokenText=t.tokenText||c(r)||"";if(this.longText===i){this.longText=this.tokenText.replace(/\{0\}/g,"X").replace(/\{1\}/g,"Y")}if(this.tokenText===r){this.tokenText=this.longText}if(this.tokenText){let e;let a;if(t.tokenParse){a=u(this.tokenText);this.tokenParse=t.tokenParse.replace(/#tokenText#/g,a);for(let e=0;e<this.valueTypes.length;e++){const t=this.paramTypes?this.paramTypes[e]:this.valueTypes[e];this.tokenParse=this.tokenParse.replace(new RegExp("\\\\\\$"+e+"|"+e+"\\\\\\$"+"|"+"\\\\\\{"+e+"\\\\\\}","g"),t)}e=this.tokenParse}else{e=u(this.tokenText)}this.tokenParseRegExp=new RegExp(e,"i");if(t.tokenFormat){a=this.tokenText;this.tokenFormat=t.tokenFormat.replace(/\#tokenText\#/g,a)}else{this.tokenFormat=this.tokenText}}if(t.additionalInfo!==undefined){this.additionalInfo=t.additionalInfo}this.exclude=!!t.exclude;this.validateInput=!!t.validateInput;if(t.group){this.group=t.group}else{this.group={id:!this.exclude?"1":"2"};if(!this.group.text){this.group.text=h.getText("VALUEHELP.OPERATOR.GROUP"+this.group.id)}}},destroy:function(){this._oMethodOverwrites=null;e.protoype.destroy.apply(this,arguments)}});d.ValueType={Self:"self",Static:"static",SelfNoParse:"selfNoParse"};function c(e,t){if(t==="time"||t==="datetime"){t="date"}const a=e+(t?"."+t:"");let i;i=h.getText(a,undefined,true);if(i===a||i===undefined){if(t){i=h.getText(e,undefined,true);if(i===a||i===undefined){i=e}}else{i=a}}return i}d.prototype.getLongText=function(e){const t=this.textKey||"operators."+this.name+".longText";let a=c(t,e.toLowerCase());if(a===t){a=this.longText}return a};d.prototype.getModelFilter=function(e,i,s,r,o){let n=e.values[0];let u;let p;const f=i.split(",");if(Array.isArray(n)&&f.length>1){n=n[0];i=f[0];p=new t({path:f[1],operator:a.EQ,value1:e.values[0][1]})}if(p&&n===undefined){u=p;p=undefined}else if(!this.valueTypes[1]){if(!r&&e.validated===l.Validated){r=true}u=new t({path:i,operator:this.filterOperator,value1:n,caseSensitive:r===false?false:undefined})}else{let a=e.values[1];if(Array.isArray(a)&&f.length>1){a=a[0]}u=new t({path:i,operator:this.filterOperator,value1:n,value2:a,caseSensitive:r===false?false:undefined})}if(p){u=new t({filters:[u,p],and:true})}if(e.inParameters){const i=[u];for(const s in e.inParameters){if(s.startsWith("conditions/")){i.push(new t({path:s.slice(11),operator:a.EQ,value1:e.inParameters[s]}))}}if(i.length>1){u=new t({filters:i,and:true})}}return u};d.prototype.isEmpty=function(e,t){let a=false;if(e){for(let t=0;t<this.valueTypes.length;t++){if(this.valueTypes[t]!==f.Static){const i=e.values[t];if(i===null||i===undefined||i===""){a=true;break}}}}return a};d.prototype.format=function(e,t,a,i,s,r,o){const n=e.values;const l=this.valueTypes.length;let u=i&&l===1?"{0}":this.tokenFormat;for(let e=0;e<l;e++){let a;let i;if(this.valueTypes[e]!==f.Static){if(this.valueTypes[e]===f.Self){a=t;i=s}else if(this.valueTypes[e]===null){a=r;i=o}else{a=this._createLocalType(this.valueTypes[e],t)}let l=n[e];if(l===undefined||l===null){l=a?a.parseValue("","string"):""}let p=this._formatValue(l,a,i);if(typeof p==="string"){p=p.replace(/\$/g,"$$$")}u=u.replace(new RegExp("\\$"+e+"|"+e+"\\$"+"|"+"\\{"+e+"\\}","g"),p)}}return u};d.prototype._formatValue=function(e,t,a){let i;if(t){if(t.isA("sap.ui.model.CompositeType")&&t.getUseInternalValues()&&Array.isArray(e)&&a){e=r([],e);for(let t=0;t<e.length;t++){if(a[t]){const i=a[t].getModelFormat();if(i&&typeof i.parse==="function"){e[t]=i.parse(e[t])}}}}i=t.formatValue(e,"string")}else{i=e}return i};d.prototype.parse=function(e,t,a,i,r,o,n){const l=this.getValues(e,a,i);let u;if(l){u=[];for(let e=0;e<this.valueTypes.length;e++){let a;let i;if(this.valueTypes[e]===f.Self){a=t;i=r}else if(this.valueTypes[e]===null){a=o;i=n}else if(this.valueTypes[e]&&this.valueTypes[e]!==f.Static){a=this._createLocalType(this.valueTypes[e],t)}try{if(this.valueTypes[e]!==f.Static){let t;if(a&&l[e]!==undefined){t=this._parseValue(l[e],a,i)}else{t=l[e]}u.push(t)}}catch(e){s.warning(e.message);throw e}}}return u};d.prototype._parseValue=function(e,t,a){if(e===undefined){return e}let i;if(t&&t.isA("sap.ui.model.CompositeType")&&t._aCurrentValue&&t.getParseWithValues()){i=t._aCurrentValue}const s=t?t.parseValue(e,"string",i):e;if(t&&t.isA("sap.ui.model.CompositeType")&&Array.isArray(s)&&(t._aCurrentValue||t.getUseInternalValues()&&a)){for(let e=0;e<s.length;e++){if(s[e]===undefined&&t._aCurrentValue){s[e]=t._aCurrentValue[e]===undefined?null:t._aCurrentValue[e]}else if(t.getUseInternalValues()&&a&&a[e]){const t=a[e].getModelFormat();if(t&&typeof t.format==="function"){s[e]=t.format(s[e])}}}}return s};d.prototype.validate=function(e,t,a,i,s,o){const n=this.valueTypes.length;for(let l=0;l<n;l++){if((this.valueTypes[l]||this.valueTypes[l]===null)&&this.valueTypes[l]!==f.Static){let n;let u;if(this.valueTypes[l]===f.Self){n=t;u=a}else if(this.valueTypes[l]===null){n=s;u=o}else{n=this._createLocalType(this.valueTypes[l],t)}if(e.length<l+1&&this.valueTypes[l]){throw new Error("value "+l+" for operator "+this.name+" missing")}if(n&&e.length>l){let t=e[l];if(t===undefined||t===null){t=n?n.parseValue("","string"):""}if(n.isA("sap.ui.model.CompositeType")&&Array.isArray(t)&&u){t=r([],t);for(let e=0;e<t.length;e++){if(u[e]){if(i===undefined||e===i){u[e].validateValue(t[e])}if(n.getUseInternalValues()){const a=u[e].getModelFormat();if(a&&typeof a.parse==="function"){t[e]=a.parse(t[e])}}}}}n.validateValue(t)}}}};d.prototype._createLocalType=function(e,t){if(!this._aTypes){this._aTypes=[]}let a;let i;let s;let n;if(e===f.SelfNoParse){a=t.getMetadata().getName();i=r({},t.getFormatOptions());s=r(t.getConstraints())}else if(typeof e==="string"){a=e}else if(e&&typeof e==="object"){a=e.name;i=e.formatOptions;s=e.constraints}for(let e=0;e<this._aTypes.length;e++){const t=this._aTypes[e];if(t.name===a&&o(t.formatOptions,i)&&o(t.constraints,s)){n=t.type;break}}if(!n){const t=sap.ui.require(a.replace(/\./g,"/"));n=new t(i,s);n._bCreatedByOperator=true;if(e===f.SelfNoParse){n.parseValue=function(e,a){t.prototype.parseValue.apply(this,arguments);return e};n.validateValue=function(e){const a=t.prototype.parseValue.apply(this,[e,"string"]);t.prototype.validateValue.apply(this,[a])};n.formatValue=function(e,a){t.prototype.formatValue.apply(this,arguments);return e}}this._aTypes.push({name:a,formatOptions:i,constraints:s,type:n})}return n};d.prototype.test=function(e){return this.tokenParseRegExp.test(e)};d.prototype.getValues=function(e,t,a){const i=e.match(this.tokenParseRegExp);let s;if(i||a&&e){s=[];for(let t=0;t<this.valueTypes.length;t++){let r;if(i){r=i[t+1]}else if(a){if(t>0){break}r=e}s.push(r)}}return s};d.prototype.getCondition=function(e,t,a,s,r,o,l){if(this.test(e)||s&&e&&this.hasRequiredValues()){const u=this.parse(e,t,a,s,r,o,l);if(u.length==this.valueTypes.length||this.valueTypes[0]===f.Static||u.length===1&&this.valueTypes.length===2&&!this.valueTypes[1]){const e=n.createCondition(this.name,u);this.checkValidated(e);return e}else{throw new i("Parsed value don't meet operator")}}return null};d.prototype.isSingleValue=function(){if(this.valueTypes.length>1&&this.valueTypes[1]){return false}return true};d.prototype.getCheckValue=function(e){if(this.valueTypes[0]&&this.valueTypes[0]===f.Static){return{}}else{return{values:e.values}}};d.prototype.hasRequiredValues=function(){if(this.valueTypes[0]&&this.valueTypes[0]!==f.Static){return true}else{return false}};d.prototype.compareConditions=function(e,t){let a=false;if(e.operator===this.name&&e.operator===t.operator){const i=this.getCheckValue(e);const s=this.getCheckValue(t);if(e.inParameters&&t.inParameters){i.inParameters=e.inParameters;s.inParameters=t.inParameters}if(e.outParameters&&t.outParameters){i.outParameters=e.outParameters;s.outParameters=t.outParameters}if(e.payload||t.payload){i.payload=e.payload;s.payload=t.payload}if(e.validated&&t.validated){i.validated=e.validated;s.validated=t.validated}if(o(i,s)){a=true}}return a};d.prototype.checkValidated=function(e){e.validated=l.NotValidated};d.prototype._enableOverwrites=function(e){this._oMethodOverwrites={};["format","parse","validate","getModelFilter","isEmpty","createControl","getCheckValue","getValues","checkValidated","getLongText"].forEach(function(t){Object.defineProperty(this,t,{get:function(){return this._oMethodOverwrites&&this._oMethodOverwrites[t]||Object.getPrototypeOf(this)[t]}});if(e&&e[t]){this._oMethodOverwrites[t]=e[t]}}.bind(this))};const y=Object.values(p);d.prototype.overwrite=function(e,t){if(y.indexOf(e)>=0){const a=this[e];this._oMethodOverwrites[e]=t;return a.bind(this)}throw"Operator: Illegal overwrite detected. Please see sap.ui.mdc.enums.OperatorOverwrite"};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/condition/OperatorDynamicDateOption", ["sap/m/DynamicDateOption","sap/m/DynamicDateValueHelpUIType","sap/m/Input","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/util/DateUtil","sap/ui/mdc/util/loadModules","sap/ui/model/json/JSONModel","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/core/library"],function(e,t,o,s,a,r,i,n,p,l,u,y,c){"use strict";const h=c.ValueState;let f;let d;const g=e.extend("sap.ui.mdc.condition.OperatorDynamicDateOption",{metadata:{library:"sap.ui.mdc",properties:{operator:{type:"object"},type:{type:"object"},baseType:{type:"sap.ui.mdc.enums.BaseType"}}}});g.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oModel){this._oModel.destroy();this._oModel=undefined;this._mChangeHandler=undefined}if(this._aUITypes){for(let e=0;e<this._aUITypes.length;e++){this._aUITypes[e].destroy()}this._aUITypes=undefined}};g.prototype.applySettings=function(){e.prototype.applySettings.apply(this,arguments);const t=[];const o=this.getBaseType();if(o===s.DateTime){if(!d){t.push("sap/m/DateTimePicker")}}else if(!f){t.push("sap/m/DatePicker")}if(t.length>0){return n(t).then(function(e){if(o===s.DateTime){d=e[0]}else{f=e[0]}})}};g.prototype.validateProperty=function(t,o){if(t==="operator"&&o&&(typeof o!=="object"||!o.isA||!o.isA("sap.ui.mdc.condition.Operator"))){throw new Error('"'+o+'" is of type '+typeof o+", expected "+'sap.ui.mdc.condition.Operator for property "'+t+'" of '+this)}else if(t==="type"&&o&&(typeof o!=="object"||!o.isA||!o.isA("sap.ui.model.Type"))){throw new Error('"'+o+'" is of type '+typeof o+", expected "+'sap.ui.model.Type for property "'+t+'" of '+this)}return e.prototype.validateProperty.apply(this,arguments)};g.prototype.isRange=function(){const e=this.getOperator();return e.isA("sap.ui.mdc.condition.RangeOperator")};g.prototype.getText=function(e){const t=this.getOperator();const o=this.getBaseType();return t.getLongText(o)};g.prototype.getValueHelpUITypes=function(e){if(!this._aUITypes){const e=this.getOperator();let o=this.getType();const a=this.getBaseType();this._aUITypes=[];for(let i=0;i<e.valueTypes.length;i++){const n=e.valueTypes[i];if(n===r.Self){let e;if(a===s.DateTime){e="datetime"}else{e="date"}this._aUITypes.push(new t({type:e}))}else if(!n||n===r.Static){continue}else{o=e._createLocalType(n,o);if(o.isA("sap.ui.model.type.Integer")||o.isA("sap.ui.model.odata.type.Int")){this._aUITypes.push(new t({type:"int"}))}else{this._aUITypes.push(new t({type:"custom"}))}}}}return this._aUITypes};g.prototype.createValueHelpUI=function(e,t){let a=e.getValue();const n=this.getOperator();let l=this.getType();const u=this.getKey();const y=e.getId();if(!a||a.operator!==u){a={operator:u,values:[]};if(n.valueDefaults){a.values=n.valueDefaults}}m.call(this,e);if(!e.aControlsByParameters){e.aControlsByParameters={}}e.aControlsByParameters[u]=[];let c=function(e){t(this)}.bind(this);for(let h=0;h<n.valueTypes.length;h++){const g=n.valueTypes[h];const m=this.getBaseType();let T;if(!g){continue}if(!e.aControlsByParameters[u][h]){if(n.createControl){if(!this._oModel){c=function(e){const t=e.getParameter("path");const o=t.split("/");const s=o[0]||o[1];if(this._mChangeHandler&&this._mChangeHandler[s]){this._mChangeHandler[s](this)}}.bind(this);this._oModel=new p;this._oModel.attachPropertyChange({},c,this);this._mChangeHandler={}}const o=this._oModel.getData();o[y]={value0:a&&a.values[0],value1:a&&a.values[1]};this._mChangeHandler[y]=t;if(g!==r.Self){l=n._createLocalType(g,l)}const s=n.createControl(l,"internal>/"+y+"/value"+h,h,y+"-"+h);s.setModel(this._oModel,"internal");e.aControlsByParameters[u].push(s)}else if(g===r.Self){if(a&&a.values[h]){T=i.typeToDate(a.values[h],l,m)}const t=l.getFormatOptions();let o;if(m===s.DateTime){o=d}else{o=f}const r=new o(y+"-"+h,{dateValue:T,displayFormat:t.style||t.pattern,displayFormatType:t.calendarType,change:c});e.aControlsByParameters[u].push(r)}else if(typeof g==="object"){l=n._createLocalType(n.valueTypes[h],l);const t=l.formatValue(a&&a.values[h],"string");const s=new o(y+"-"+h,{value:t,change:c});e.aControlsByParameters[u].push(s)}}}return e.aControlsByParameters[u]};g.prototype.validateValueHelpUI=function(e){const t=this.getKey();const o=this.getOperator();const s=this.getType();let a;let r=true;let i=h.None;let n;let p=0;try{a=this.getValueHelpOutput(e);for(p=0;p<a.values.length;p++){const e=a.values[p];if(e===undefined||e===null){r=false}}o.validate(a.values,s)}catch(e){r=false;i=h.Error;n=e.message;if(e&&!(e instanceof u)&&!(e instanceof y)){throw e}}if(!o.createControl){for(p=0;p<e.aControlsByParameters[t].length;p++){const o=e.aControlsByParameters[t][p];if(o.setValueState){o.setValueState(i);o.setValueStateText(n)}}}return r};g.prototype.getValueHelpOutput=function(e){const t=this.getKey();const o={operator:t,values:[]};const s=this.getOperator();let a=this.getType();const n=this.getBaseType();const p=e.getId();for(let l=0;l<s.valueTypes.length;l++){if(!s.valueTypes[l]){continue}const y=e.aControlsByParameters[t][l];if(y){let e;if(s.createControl){e=this._oModel?this._oModel.getProperty("/"+p+"/value"+l):null}else if(s.valueTypes[l]===r.Self){if(!y.isValidValue()){throw new u}e=y.getDateValue();if(e){e=i.dateToType(e,a,n)}}else{e=y.getValue();a=s._createLocalType(s.valueTypes[l],a);e=a.parseValue(e,"string")}o.values.push(e)}}return o};g.prototype.getGroupHeader=function(){const t=this.getOperator();if(t.group&&t.group.text){return t.group.text}return e.prototype.getGroupHeader.apply(this,arguments)};g.prototype.getGroup=function(){const t=this.getOperator();if(t.group){return t.group.id}return e.prototype.getGroup.apply(this,arguments)};g.prototype.toDates=function(e){const t=this.getOperator();const o=this.getType();const s=this.getBaseType();let a;let n=0;if(t.isA("sap.ui.mdc.condition.RangeOperator")){a=t._getRange(e&&e.values,o,s);for(n=0;n<a.length;n++){a[n]=i.typeToDate(a[n],o,s)}}else if(t.valueTypes.length===0){a=[]}else if(t.valueTypes[0]===r.Self){a=[];for(n=0;n<e.values.length;n++){a.push(e.values[n]?i.typeToDate(e.values[n],o,s):e.values[n])}if(a.length===1){a.push(a[0])}}else if([r.Self,r.Static].indexOf(t.valueTypes[0])===-1){throw new Error("Cannot convert to date, use RangeOperator")}return a};g.prototype.format=function(e){const t=this.getOperator();const o=this.getType();return t.format(e,o,a.Value)};g.prototype.parse=function(e){const t=this.getOperator();const o=this.getType();if(e&&t.parse(e)){const s={};s.operator=this.getKey();s.values=t.parse(e,o,a.Value);return s}};g.prototype.enhanceFormattedValue=function(e,t){return false};function m(e){const t=this.getKey();if(e&&e.aControlsByParameters&&e.aControlsByParameters[t]){for(let o=0;o<e.aControlsByParameters[t].length;o++){const s=e.aControlsByParameters[t][o];if(!s.bIsDestroyed){s.destroy()}}delete e.aControlsByParameters[t]}}return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/mdc/condition/RangeOperator", ["sap/ui/mdc/condition/Operator","sap/ui/mdc/util/DateUtil","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/base/Log"],function(e,t,a,i,n){"use strict";const s=e.extend("sap.ui.mdc.condition.RangeOperator",{constructor:function(t){t.filterOperator="RANGE";t.tokenParse=t.tokenParse||"^#tokenText#$";t.tokenFormat=t.tokenFormat||"#tokenText#";e.apply(this,arguments);if(this.paramTypes){if(t.defaultValues!==undefined){if(Array.isArray(t.defaultValues)){this.valueDefaults=t.defaultValues}else{this.valueDefaults=t.defaultValues()}}else{this.paramTypes.forEach(function(e){if(!this.valueDefaults){this.valueDefaults=[]}this.valueDefaults.push(1)}.bind(this))}}if(t.label!==undefined){this.aLabels=t.label}if(t.calcRange){this.calcRange=t.calcRange}if(t.formatRange){this.formatRange=t.formatRange}else if(this.calcRange){this.formatRange=function(e,t){return t.formatValue(e[0],"string")+" - "+t.formatValue(e[1],"string")}}}});s.prototype.getModelFilter=function(e,t,n,s,l){const r=this._getRange(e.values,n,l);return new a({path:t,operator:i.BT,value1:r[0],value2:r[1]})};s.prototype._getRange=function(e,a,i){let n;if(e){if(e.length===2){n=this.calcRange(e[0],e[1])}else{n=this.calcRange(e[0])}}else{n=this.calcRange()}for(let e=0;e<2;e++){n[e]=t.dateToType(n[e].getJSDate(),a,i)}return n};s.prototype.getStaticText=function(e){const t=this._getRange(null,e);return this.formatRange(t,e)};return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/ActionToolbarActionAlignment", function(){"use strict";const n={Begin:"Begin",End:"End"};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/BaseType", function(){"use strict";const e={String:"String",Numeric:"Numeric",Boolean:"Boolean",Date:"Date",Time:"Time",DateTime:"DateTime",Unit:"Unit"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/ConditionValidated", function(){"use strict";const t={NotValidated:"NotValidated",Validated:"Validated"};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/ContentMode", function(){"use strict";const i={Display:"Display",DisplayMultiValue:"DisplayMultiValue",DisplayMultiLine:"DisplayMultiLine",Edit:"Edit",EditMultiValue:"EditMultiValue",EditMultiLine:"EditMultiLine",EditOperator:"EditOperator",EditForHelp:"EditForHelp"};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/EditMode", function(){"use strict";const a={Display:"Display",Editable:"Editable",ReadOnly:"ReadOnly",Disabled:"Disabled",EditableReadOnly:"EditableReadOnly",EditableDisplay:"EditableDisplay"};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/FieldDisplay", function(){"use strict";const e={Value:"Value",Description:"Description",ValueDescription:"ValueDescription",DescriptionValue:"DescriptionValue"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/FilterBarValidationStatus", function(){"use strict";const e={NoError:-1,RequiredHasNoValue:0,FieldInErrorState:1,AsyncValidation:2,OngoingChangeAppliance:3};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/LinkType", function(){"use strict";const e={Text:0,DirectLink:1,Popover:2};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/OperatorOverwrite", function(){"use strict";const e={getModelFilter:"getModelFilter",getLongText:"getLongText"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/OperatorValueType", function(){"use strict";const e={Self:"self",Static:"static",SelfNoParse:"selfNoParse"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/ProcessingStrategy", function(){"use strict";const e={Add:false,PartialReplace:true,FullReplace:"FullReplace"};return e},true);
/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/PropagationReason", function(){"use strict";const e={ControlChange:"ControlChange",Select:"Select",Info:"Info"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/ReasonMode", function(){"use strict";const n={Variant:"Variant",Enter:"Enter",Go:"Go",Unclear:""};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/SelectType", function(){"use strict";const e={Set:"Set",Add:"Add",Remove:"Remove"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ActionToolbarActionAlignment", ["sap/ui/base/DataType"],function(n){"use strict";const e={Begin:"Begin",End:"End"};n.registerEnum("sap.ui.mdc.enums.ActionToolbarActionAlignment",e);return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/BaseType", ["sap/ui/base/DataType"],function(e){"use strict";const i={String:"String",Numeric:"Numeric",Boolean:"Boolean",Date:"Date",Time:"Time",DateTime:"DateTime",Unit:"Unit"};e.registerEnum("sap.ui.mdc.enums.BaseType",i);return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ChartItemRoleType", ["sap/ui/base/DataType"],function(e){"use strict";const s={category:"category",series:"series",category2:"category2",axis1:"axis1",axis2:"axis2",axis3:"axis3"};e.registerEnum("sap.ui.mdc.enums.ChartItemRoleType",s);return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ChartItemType", ["sap/ui/base/DataType"],function(e){"use strict";const s={Dimension:"Dimension",Measure:"Measure"};e.registerEnum("sap.ui.mdc.enums.ChartItemType",s);return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ChartP13nMode", ["sap/ui/base/DataType"],function(e){"use strict";const t={Item:"Item",Sort:"Sort",Type:"Type",Filter:"Filter"};e.registerEnum("sap.ui.mdc.enums.ChartP13nMode",t);return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ChartToolbarActionType", ["sap/ui/base/DataType"],function(e){"use strict";const n={ZoomInOut:"ZoomInOut",DrillDownUp:"DrillDownUp",Legend:"Legend",FullScreen:"FullScreen"};e.registerEnum("sap.ui.mdc.enums.ChartToolbarActionType",n);return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ConditionValidated", function(){"use strict";const t={NotValidated:"NotValidated",Validated:"Validated"};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ContentMode", ["sap/ui/base/DataType"],function(i){"use strict";const t={Display:"Display",DisplayMultiValue:"DisplayMultiValue",DisplayMultiLine:"DisplayMultiLine",Edit:"Edit",EditMultiValue:"EditMultiValue",EditMultiLine:"EditMultiLine",EditOperator:"EditOperator",EditForHelp:"EditForHelp"};i.registerEnum("sap.ui.mdc.enums.ContentMode",t);return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/FieldDisplay", ["sap/ui/base/DataType"],function(e){"use strict";const i={Value:"Value",Description:"Description",ValueDescription:"ValueDescription",DescriptionValue:"DescriptionValue"};e.registerEnum("sap.ui.mdc.enums.FieldDisplay",i);return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/FieldEditMode", ["sap/ui/base/DataType"],function(e){"use strict";const a={Display:"Display",Editable:"Editable",ReadOnly:"ReadOnly",Disabled:"Disabled",EditableReadOnly:"EditableReadOnly",EditableDisplay:"EditableDisplay"};e.registerEnum("sap.ui.mdc.enums.FieldEditMode",a);return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/FilterBarP13nMode", ["sap/ui/base/DataType"],function(e){"use strict";const t={Item:"Item",Value:"Value"};e.registerEnum("sap.ui.mdc.enums.FilterBarP13nMode",t);return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/FilterBarValidationStatus", function(){"use strict";const e={NoError:-1,RequiredHasNoValue:0,FieldInErrorState:1,AsyncValidation:2,OngoingChangeAppliance:3};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/LinkType", ["sap/ui/base/DataType"],function(e){"use strict";const i={Text:"Text",DirectLink:"DirectLink",Popover:"Popover"};e.registerEnum("sap.ui.mdc.enums.LinkType",i);return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/OperatorName", function(){"use strict";const T={EQ:"EQ",NE:"NE",BT:"BT",NOTBT:"NOTBT",LT:"LT",NOTLT:"NOTLT",GT:"GT",NOTGT:"NOTGT",LE:"LE",NOTLE:"NOTLE",GE:"GE",NOTGE:"NOTGE",StartsWith:"StartsWith",NotStartsWith:"NotStartsWith",EndsWith:"EndsWith",NotEndsWith:"NotEndsWith",Contains:"Contains",NotContains:"NotContains",Empty:"Empty",NotEmpty:"NotEmpty",YESTERDAY:"YESTERDAY",TODAY:"TODAY",TOMORROW:"TOMORROW",LASTDAYS:"LASTDAYS",FIRSTDAYWEEK:"FIRSTDAYWEEK",LASTDAYWEEK:"LASTDAYWEEK",FIRSTDAYMONTH:"FIRSTDAYMONTH",LASTDAYMONTH:"LASTDAYMONTH",FIRSTDAYQUARTER:"FIRSTDAYQUARTER",LASTDAYQUARTER:"LASTDAYQUARTER",FIRSTDAYYEAR:"FIRSTDAYYEAR",LASTDAYYEAR:"LASTDAYYEAR",TODAYFROMTO:"TODAYFROMTO",NEXTDAYS:"NEXTDAYS",LASTWEEK:"LASTWEEK",THISWEEK:"THISWEEK",NEXTWEEK:"NEXTWEEK",LASTWEEKS:"LASTWEEKS",NEXTWEEKS:"NEXTWEEKS",LASTMONTH:"LASTMONTH",THISMONTH:"THISMONTH",NEXTMONTH:"NEXTMONTH",LASTMONTHS:"LASTMONTHS",NEXTMONTHS:"NEXTMONTHS",LASTQUARTER:"LASTQUARTER",THISQUARTER:"THISQUARTER",NEXTQUARTER:"NEXTQUARTER",LASTQUARTERS:"LASTQUARTERS",NEXTQUARTERS:"NEXTQUARTERS",QUARTER1:"QUARTER1",QUARTER2:"QUARTER2",QUARTER3:"QUARTER3",QUARTER4:"QUARTER4",LASTYEAR:"LASTYEAR",THISYEAR:"THISYEAR",NEXTYEAR:"NEXTYEAR",LASTYEARS:"LASTYEARS",NEXTYEARS:"NEXTYEARS",SPECIFICMONTH:"SPECIFICMONTH",SPECIFICMONTHINYEAR:"SPECIFICMONTHINYEAR",YEARTODATE:"YEARTODATE",DATETOYEAR:"DATETOYEAR",LASTMINUTES:"LASTMINUTES",NEXTMINUTES:"NEXTMINUTES",LASTHOURS:"LASTHOURS",NEXTHOURS:"NEXTHOURS"};return T},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/OperatorOverwrite", function(){"use strict";const e={getModelFilter:"getModelFilter",getLongText:"getLongText"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/OperatorValueType", ["sap/ui/base/DataType"],function(e){"use strict";const s={Self:"self",Static:"static",SelfNoParse:"selfNoParse"};e.registerEnum("sap.ui.mdc.enums.OperatorValueType",s);return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ProcessingStrategy", function(){"use strict";const e={Add:false,PartialReplace:true,FullReplace:"FullReplace"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ReasonMode", ["sap/ui/base/DataType"],function(e){"use strict";const n={Variant:"Variant",Enter:"Enter",Go:"Go",Unclear:""};e.registerEnum("sap.ui.mdc.enums.ReasonMode",n);return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/TableGrowingMode", ["sap/ui/base/DataType"],function(e){"use strict";const s={None:"None",Basic:"Basic",Scroll:"Scroll"};e.registerEnum("sap.ui.mdc.enums.TableGrowingMode",s);return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/TableMultiSelectMode", ["sap/ui/base/DataType"],function(e){"use strict";const t={Default:"Default",ClearAll:"ClearAll"};e.registerEnum("sap.ui.mdc.enums.TableMultiSelectMode",t);return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/TableP13nMode", ["sap/ui/base/DataType"],function(e){"use strict";const r={Column:"Column",Sort:"Sort",Filter:"Filter",Group:"Group",Aggregate:"Aggregate"};e.registerEnum("sap.ui.mdc.enums.TableP13nMode",r);return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/TableRowAction", ["sap/ui/base/DataType"],function(i){"use strict";const a={Navigation:"Navigation"};i.registerEnum("sap.ui.mdc.enums.TableRowAction",a);return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/TableRowCountMode", ["sap/ui/base/DataType"],function(e){"use strict";const u={Auto:"Auto",Fixed:"Fixed"};e.registerEnum("sap.ui.mdc.enums.TableRowCountMode",u);return u},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/TableSelectionMode", ["sap/ui/base/DataType"],function(e){"use strict";const i={None:"None",Single:"Single",SingleMaster:"SingleMaster",Multi:"Multi"};e.registerEnum("sap.ui.mdc.enums.TableSelectionMode",i);return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/TableType", ["sap/ui/base/DataType"],function(e){"use strict";const a={Table:"Table",TreeTable:"TreeTable",ResponsiveTable:"ResponsiveTable"};e.registerEnum("sap.ui.mdc.enums.TableType",a);return a},true);
/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ValueHelpPropagationReason", function(){"use strict";const e={ControlChange:"ControlChange",Select:"Select",Info:"Info"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ValueHelpSelectionType", ["sap/ui/base/DataType"],function(e){"use strict";const t={Set:"Set",Add:"Add",Remove:"Remove"};e.registerEnum("sap.ui.mdc.enums.ValueHelpSelectionType",t);return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/ConditionType", ["sap/ui/model/SimpleType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/type/String","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/ConditionValidateException","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/ConditionValidated","sap/base/util/merge","sap/base/strings/whitespaceReplacer","sap/ui/base/SyncPromise"],function(t,e,n,i,a,s,o,l,r,u,c,f,d,h,p,m){"use strict";const g="sap.ui.mdc.raw";const y="sap.ui.mdc.raw:";const v=t.extend("sap.ui.mdc.field.ConditionType",{constructor:function(e,n){t.apply(this,arguments);this.sName="Condition";this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._oCalls={active:0,last:0,condition:undefined,exception:undefined}}});v.prototype.destroy=function(){t.prototype.destroy.apply(this,arguments);if(this._oDefaultType){this._oDefaultType.destroy();delete this._oDefaultType}this._bDestroyed=true};v.prototype.formatValue=function(t,n){if(t==undefined||t==null||this._bDestroyed){return null}if(typeof t!=="object"||!t.operator||!t.values||!Array.isArray(t.values)){throw new e("No valid condition provided")}if(!n){n="string"}let i=b.call(this);const a=P.call(this);const o=Q(i);const l=this.oFormatOptions.preventGetDescription;B.call(this,t,i);let u,c,f,p,y;switch(this.getPrimitiveType(n)){case"string":case"any":u=T.call(this);c=E.call(this);f=r.getEQOperator(c);if(!this.oFormatOptions.maxConditions||this.oFormatOptions.maxConditions===1){this._oCalls.active++;this._oCalls.last++}p=this._oCalls.last;if(!l&&u!==s.Value&&t.validated===d.Validated&&(o||t.operator===f.name&&!t.values[1])){const n=this.oFormatOptions.bindingContext;const s=o?t.values[0][1]:t.values[0];return m.resolve().then(function(){return K.call(this,s,t,i,a,n)}.bind(this)).then(function(e){if(e){t=h({},t);if(o){i=x.call(this);t.operator=f.name;if(typeof e!=="object"){e={key:s,description:e}}}if(typeof e==="object"){t=R.call(this,t,e)}else if(t.values.length===1){t.values.push(e)}else{t.values[1]=e}}return O.call(this,t,undefined,p,true,i,a)}.bind(this)).catch(function(n){let s;if(!(n instanceof e)||!q.call(this)){s=n}return O.call(this,t,s,p,true,i,a)}.bind(this)).unwrap()}return O.call(this,t,undefined,p,true,i,a);default:y=G(n);if(y>=0){if(I.call(this,i)){return t.values.length>=1?t.values[0][y]:null}}else if(n===g){return t.values.length>=1?t.values[0]:null}else if(i&&t.values.length>=1){return i.formatValue(t.values[0],n)}throw new e("Don't know how to format Condition to "+n)}};function C(t,n,i){const a=T.call(this);const l=Q(n);if(l&&t.values.length>1&&t.values[0][1]===t.values[1][1]){t=h({},t);t.operator=o.EQ;t.values.splice(1)}const u=this.oFormatOptions.hideOperator&&t.values.length===1||l;const c=r.getOperator(t.operator);const d=A.call(this);const m=k.call(this);if(!c){throw new e("No valid condition provided, Operator wrong.")}let g=c.format(t,n,a,u,d,i,m);const y=this.oFormatOptions.convertWhitespaces;if(y&&(j.call(this,n)===f.String||a!==s.Value)){g=p(g)}return g}function O(t,e,n,i,a,s){if(this._oCalls.active>0){this._oCalls.active--}if(n<this._oCalls.last&&(this._oCalls.condition!==undefined||this._oCalls.exception!==undefined)){t=this._oCalls.condition;e=this._oCalls.exception}if(n===this._oCalls.last&&this._oCalls.active>0){this._oCalls.condition=h({},t);this._oCalls.exception=e}else if(this._oCalls.active===0&&this._oCalls.last>0){this._oCalls={active:0,last:0,condition:undefined,exception:undefined}}if(e){throw e}let o;if(i){o=C.call(this,t,a,s)}else{o=V.call(this,t,a)}return o}v.prototype.parseValue=function(t,e){const n=L.call(this);if(!e){e="string"}else if(e==="any"&&typeof t==="string"){e="string"}return this._parseValue(t,e,n)};v.prototype._parseValue=function(t,e,i){if(this._bDestroyed){return null}const a=this.oFormatOptions.navigateCondition;if(a){const n=this.formatValue(a,e);if(n===t){return h({},a)}}const s=T.call(this);const o=b.call(this);const l=D.call(this);const c=E.call(this);const f=Q(o);let p;if(t===null||t===undefined||t===""&&!i){if(!I.call(this,o)){return null}}M.call(this,o);let m,y,v;switch(this.getPrimitiveType(e)){case"string":m;y=false;v=false;if(c.length===1){m=r.getOperator(c[0]);v=true}else{const e=r.getMatchingOperators(c,t);if(e.length===0){m=W.call(this,c,o);if(i&&!I.call(this,o)){const t=r.getEQOperator(c);if(c.indexOf(t.name)>=0){y=!!m&&m.name!==t.name;m=t}}v=true}else{const t=e.filter(function(t){return t.valueTypes.length===0});if(t.length>=1){m=t[0]}else{m=e[0]}}}if(m){if(f&&m!==r.getEQOperator(c)){throw new n("unsupported operator")}let e;const a=I.call(this,o);const h=A.call(this);const p=P.call(this);const g=k.call(this);this._oCalls.active++;this._oCalls.last++;const C=this._oCalls.last;if((!a||f)&&m.validateInput&&i){e=w.call(this,m,t,o,p,v,y,c,s,true);if(e instanceof Promise){return U.call(this,e)}else{return e}}else{try{if(t===""&&a&&v){e=u.createCondition(m.name,[o.parseValue(t,"string",o._aCurrentValue)],undefined,undefined,d.NotValidated)}else{e=m.getCondition(t,o,s,v,h,p,g)}}catch(e){let i=e;if(i instanceof n&&l&&!a){try{l.parseValue(t,"string",l._aCurrentValue)}catch(t){i=t}}return O.call(this,undefined,i,C,false,o)}}if(e){return O.call(this,e,undefined,C,false,o)}}throw new n("Cannot parse value "+t);default:if(o){if(c.length===1){p=c[0]}else{p=W.call(this,c,o).name;if(c.indexOf(p)<0){p=undefined}}if(p){const n=G(e);if(n>=0){if(I.call(this,o)){const e=h([],o._aCurrentValue);e[n]=t;return u.createCondition(p,[e],undefined,undefined,d.NotValidated)}}else if(e===g){return u.createCondition(p,[t],undefined,undefined,d.NotValidated)}else{return u.createCondition(p,[o.parseValue(t,e)],undefined,undefined,d.NotValidated)}}}throw new n("Don't know how to parse Condition from "+e)}};function V(t,e){const n=Q(e);const i=I.call(this,e);if(t&&!n&&i){const n=D.call(this)||e;const i=n.getMetadata().getName();const a=n.getFormatOptions();const s=n.getConstraints();const l=this.oFormatOptions.delegate;const r=this.oFormatOptions.control;const u=l&&l.getTypeMap(r).getBaseType(i,a,s);if((u===f.Unit||u===f.DateTime)&&!t.values[0][1]&&e._aCurrentValue){const n=e._aCurrentValue[1]===undefined?null:e._aCurrentValue[1];t.values[0][1]=n;if(t.operator===o.BT){t.values[1][1]=n}}}B.call(this,t,e);return t}function w(t,a,r,c,f,h,p,g,y){let v;let C;let V=true;let T=false;let b;let P;const D=this.oFormatOptions.bindingContext;let N;if(a===""){N=[];v=a;b=a}else{N=t.getValues(a,g,f);v=y?N[0]:N[1];C=y?N[1]:N[0];T=g!==s.Value;b=v||C}const E=function(i){if(i&&!(i instanceof n)&&!(i instanceof e)){throw i}if(!i._bNotUnique){if(a===""){return null}if(y&&N[0]&&N[1]){return w.call(this,t,a,r,c,f,h,p,g,false)}if(h){return _.call(this,r,p,a,g)}}if(q.call(this)){return F.call(this,r,p,a,g)}throw new n(i.message)};const S=function(e){if(e){const n=[e.key];if(t.valueTypes.length>1&&t.valueTypes[1]!==l.Static){n.push(e.description)}return u.createCondition(t.name,n,e.inParameters,e.outParameters,d.Validated,e.payload)}else if(a===""){return null}else{return E.call(this,new n(this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[a])))}};const I=this._oCalls.last;const B=function(e,i){let s;let l;try{s=i.call(this,e);if(Q(r)){if(s){if(s.operator!==o.EQ){throw new n("unsupported operator")}const t=r._aCurrentValue&&r._aCurrentValue[0]!==undefined?r._aCurrentValue[0]:null;const e=s.values[0];s.values=[[t,e]]}else if(a===""){s=u.createCondition(t.name,[r.parseValue(a,"string",r._aCurrentValue)],undefined,undefined,d.NotValidated)}}}catch(t){l=t}return O.call(this,s,l,I,false,r)};const M=function(t,e,a,s){let o;try{if(Q(t)){const t=e&&e.length>1?e[1]:x.call(this);o=t.parseValue(a,"string");t.validateValue(o)}else{o=t.parseValue(a,"string");t.validateValue(o)}}catch(t){if(t&&!(s&&(t instanceof n||t instanceof i))){throw t}o=undefined}return o}.bind(this);const R=M(r,A.call(this),v||b,T);V=R!==undefined;if(T){P=M(c,k.call(this),C||b,V);T=P!==undefined}return m.resolve().then(function(){return z.call(this,b,R,P,r,c,D,V,T)}.bind(this)).then(function(t){return B.call(this,t,S)}.bind(this)).catch(function(t){return B.call(this,t,E)}.bind(this)).unwrap()}function _(t,e,n,i){const a=W.call(this,e,t);let o;if(a&&e.indexOf(a.name)>=0){o=a.getCondition(n,t,s.Value,true);o.validated=d.NotValidated}return o}function F(t,e,i,a){let o;if(Q(t)){o=r.getEQOperator()}else if(e.length===1){o=r.getOperator(e[0])}else{o=r.getEQOperator(e);if(e.indexOf(o.name)<0){o=undefined}}if(!o){throw new n("Cannot parse value "+i)}const l=o.getCondition(i,t,s.Value,true);if(l){l.validated=d.NotValidated;if(Q(t)&&Array.isArray(l.values[0])){l.values[0]=l.values[0][1]}}return l}v.prototype.validateValue=function(t){const e=b.call(this);const n=D.call(this);const a=E.call(this);const s=Q(e);const o=I.call(this,e);const l=A.call(this);let u=0;const f=P.call(this);const d=k.call(this);if(t===undefined||this._bDestroyed){return null}else if(t===null){if(r.onlyEQ(a)){let t=null;try{if(e.hasOwnProperty("_sParsedEmptyString")&&e._sParsedEmptyString!==null){t=e._sParsedEmptyString}e.validateValue(t)}catch(e){if(e instanceof i){try{if(n&&!o){n.validateValue(t)}throw e}catch(t){if(t instanceof i){throw new c(t.message,t.violatedConstraints,null)}throw t}}else{return null}}}return null}if(typeof t!=="object"||!t.operator||!t.values||!Array.isArray(t.values)){throw new c(this._oResourceBundle.getText("field.VALUE_NOT_VALID"),undefined,typeof t==="object"?h({},t):t)}let p=r.getOperator(t.operator);if(s){p=r.getEQOperator();u=1}if(!p||a.indexOf(p.name)===-1){throw new c("No valid condition provided, Operator wrong.",undefined,h({},t))}try{p.validate(t.values,e,l,u,f,d)}catch(e){try{if(e instanceof i&&n&&!o){p.validate(t.values,n,l,u,f,d)}throw e}catch(e){if(e instanceof i){throw new c(e.message,e.violatedConstraints,h({},t))}throw e}}};function T(){let t=this.oFormatOptions.display;if(!t){t=s.Value}return t}function b(){let t=this.oFormatOptions.valueType;if(!t){t=x.call(this)}return t}function P(){let t=this.oFormatOptions.additionalValueType;if(!t){t=x.call(this)}return t}function x(){if(!this._oDefaultType){this._oDefaultType=new a}return this._oDefaultType}function D(){return this.oFormatOptions.originalDateType}function N(){return this.oFormatOptions.additionalType}function E(){let t=this.oFormatOptions.operators;if(!t||t.length===0){t=r.getOperatorsForType(f.String)}return t}function S(){const t=this.oFormatOptions.valueHelpID;if(t){const e=sap.ui.getCore().byId(t);if(e&&e.isValidationSupported()){return e}}return null}function I(t){return t&&t.isA("sap.ui.model.CompositeType")}function A(){return this.oFormatOptions.compositeTypes}function k(){return this.oFormatOptions.ASdditionalCompositeTypes}function Q(t){if(I(t)){const e=t.getFormatOptions();const n=!e||!e.hasOwnProperty("showMeasure")||e.showMeasure;const i=!e||!e.hasOwnProperty("showNumber")||e.showNumber;const a=!e||!e.hasOwnProperty("showTimezone")||e.showTimezone;const s=!e||!e.hasOwnProperty("showDate")||e.showDate;const o=!e||!e.hasOwnProperty("showTime")||e.showTime;if(n&&!i||a&&!s&&!o){return true}}return false}function B(t,e){if(I.call(this,e)&&t&&t.values[0]){e._aCurrentValue=h([],t.values[0]);const n=N.call(this);if(I.call(this,n)){n._aCurrentValue=h([],t.values[0])}const i=D.call(this);if(I.call(this,i)){i._aCurrentValue=h([],t.values[0])}}}function M(t){if(I.call(this,t)){const e=N.call(this);if(I.call(this,e)){if(!e._aCurrentValue){e._aCurrentValue=[]}t._aCurrentValue=e._aCurrentValue}}}function R(t,e){t.values=[e.key,e.description];if(e.inParameters){t.inParameters=e.inParameters}if(e.outParameters){t.outParameters=e.outParameters}if(e.payload){t.payload=e.payload}return t}function U(t){if(this.oFormatOptions.asyncParsing){this.oFormatOptions.asyncParsing(t)}return t}function j(t){const e=t.getMetadata().getName();const n=t.getFormatOptions();const i=t.getConstraints();const a=this.oFormatOptions.delegate;const s=this.oFormatOptions.control;let o=a?a.getTypeMap(s).getBaseType(e,n,i):f.String;if(o===f.Unit){o=f.Numeric}return o}function L(){const t=S.call(this);const e=this.oFormatOptions.delegate;if(e){return e.isInputValidationEnabled(this.oFormatOptions.control,t)}else{return!!t}}function q(){const t=S.call(this);const e=this.oFormatOptions.delegate;if(e){return e.isInvalidInputAllowed(this,t)}else if(t){return!t.getValidateInput()}else{return true}}function z(t,e,i,a,s,o,l,r){const u=S.call(this);const c=this.oFormatOptions.delegate;const f=this.oFormatOptions.control;const d={value:t,parsedValue:e,parsedDescription:i,dataType:a,bindingContext:o,checkKey:l,checkDescription:r,exception:n,control:f};if(c){return c.getItemForValue(f,u,d)}else if(u){return u.getItemForValue(d)}}function K(t,n,i,a,s){const o=S.call(this);const l=this.oFormatOptions.delegate;const r=this.oFormatOptions.control;if(l){return l.getDescription(r,o,t,n.inParameters,n.outParameters,s,undefined,undefined,n.payload,r,i)}else if(o){const a={value:t,parsedValue:t,parsedDescription:undefined,dataType:i,context:{inParameters:n.inParameters,outParameters:n.outParameters,payload:n.payload},bindingContext:s,checkKey:true,checkDescription:false,caseSensitive:true,exception:e,control:r};return o.getItemForValue(a)}}function W(t,e){const n=this.oFormatOptions.defaultOperatorName;let i;if(n){i=r.getOperator(n)}else{i=r.getDefaultOperator(j.call(this,e))}if(i&&t.indexOf(i.name)<0){for(let e=0;e<t.length;e++){i=r.getOperator(t[e]);if(i.exclude||!i.hasRequiredValues()){i=undefined}else{break}}}return i}function G(t){let e=-1;if(t.startsWith(y)){e=parseInt(t[y.length])}return e}return v});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/ConditionsType", ["sap/ui/mdc/field/ConditionType","sap/ui/mdc/condition/ConditionValidateException","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/field/splitValue","sap/ui/mdc/enums/OperatorName","sap/ui/model/SimpleType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/base/util/merge","sap/ui/base/SyncPromise"],function(t,e,n,o,i,s,r,a,l,u,p){"use strict";const h=s.extend("sap.ui.mdc.field.ConditionsType",{constructor:function(e,n){s.apply(this,arguments);this.sName="Conditions";e=c(e);this._oConditionType=new t(e,this.oConstraints);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc")}});h.prototype.destroy=function(){s.prototype.destroy.apply(this,arguments);if(this._oConditionType){this._oConditionType.destroy();this._oConditionType=undefined}this._bDestroyed=true};h.prototype.setFormatOptions=function(t){s.prototype.setFormatOptions.apply(this,arguments);t=c(t);if(this._oConditionType){this._oConditionType.setFormatOptions(t)}};function c(t){t=u({},t);if(t.asyncParsing){delete t.asyncParsing}return t}h.prototype.setConstraints=function(t){s.prototype.setConstraints.apply(this,arguments);if(this._oConditionType){this._oConditionType.setConstraints(this.oConstraints)}};h.prototype.formatValue=function(t,e){if(t==undefined||t==null||this._bDestroyed){return null}if(!Array.isArray(t)){throw new r("No valid conditions provided")}let n;if(!e||e==="string"||e==="any"){n=""}else if(e==="float"||e==="int"){n=0}if(T.call(this)){return v.call(this)||n}const o=O.call(this);const i=[];const s=function(t,e){return p.resolve().then(function(){return this._oConditionType.formatValue(t,e)}.bind(this))};for(let n=0;n<t.length;n++){i.push(s.call(this,t[n],e));if(o>0&&n>=o-1){break}}return p.all(i).then(function(t){return f.call(this,t,n)}.bind(this)).unwrap()};function f(t,e){for(let n=0;n<t.length;n++){if(e){e=e+this._oResourceBundle.getText("field.SEPARATOR")+t[n]}else{e=t[n]}}return e}h.prototype.parseValue=function(t,e){if(this._bDestroyed){return null}if(T.call(this)&&t===""){return this.oFormatOptions.getConditions?this.oFormatOptions.getConditions():[]}return this._parseValueToIndex(t,e,-1)};h.prototype._parseValueToIndex=function(t,e,n){const s=this.oFormatOptions.operators||[];const r=s.indexOf(i.BT)>=0||s.length===0;const a=F.call(this);const l=a?[t]:o(t,!r);if(l.length>1||r&&l.length===1&&typeof l[0]==="string"&&l[0].search(/\t/)>=0){return m.call(this,l,e,n)}else{return d.call(this,t,e,n)}};function d(t,e,n){const o=function(t,e){return this._oConditionType.parseValue(t,e)};const i=function(t){throw t};return y.call(this,[t],e,n,o,i)}function m(t,e,o){const s=this.oFormatOptions.operators||[];const r=s.indexOf(i.BT)>=0||s.length===0;const l=r&&n.getOperator(i.BT);const u=function(t,e){return p.resolve().then(function(){t=t.trim();if(r){const e=t.split(/\t/g);if(e.length==2&&e[0]&&e[1]){t=l.tokenFormat;for(let n=0;n<2;n++){t=t.replace(new RegExp("\\{"+n+"\\}","g"),e[n])}}}return this._oConditionType._parseValue(t,"string",false)}.bind(this))};const h=function(t){if(t instanceof a){throw new a(this._oResourceBundle.getText("field.PASTE_ERROR"))}throw t};return y.call(this,t,e,o,u,h)}function y(t,e,n,o,i){const s=[];for(let n=0;n<t.length;n++){s.push(o.call(this,t[n],e))}const r=p.all(s).then(function(t){let e=this.oFormatOptions.getConditions&&this.oFormatOptions.getConditions();for(let o=0;o<t.length;o++){e=g.call(this,t[o],e,n);if(n>=0){n++}}return e}.bind(this)).catch(function(t){i.call(this,t)}.bind(this)).unwrap();if(r instanceof Promise&&this.oFormatOptions.asyncParsing){this.oFormatOptions.asyncParsing(r)}return r}function g(t,e,o){const s=w(this.oFormatOptions.valueType);const r=O.call(this);if(r!==1&&this.oFormatOptions.getConditions){if(t){if(C(this.oFormatOptions.valueType)&&!s&&e.length===1&&(e[0].values[0][0]===null||e[0].values[0][0]===undefined||e[0].values[0][1]===null||e[0].values[0][1]===undefined)&&(t.values[0][0]!==null&&t.values[0][0]!==undefined&&t.values[0][1]!==null&&t.values[0][1]!==undefined)){e.splice(0,1)}if(n.indexOfCondition(t,e)===-1){if(o>=0&&e.length>o){e.splice(o,0,t)}else{e.push(t)}}else{throw new a(this._oResourceBundle.getText("field.CONDITION_ALREADY_EXIST",[t.values[0]]))}if(r>0&&r<e.length){e.splice(0,e.length-r)}}return e}else if(s&&this.oFormatOptions.getConditions&&e.length>1){const n=t&&t.values[0][1];const o=t&&t.inParameters;const s=t&&t.outParameters;const r=t&&t.payload;for(let a=0;a<e.length;a++){e[a].values[0][1]=n;if(n===undefined){e[a].values[0][0]=t.values[0][0]}e[a].values[0].splice(2);if(e[a].operator===i.BT){e[a].values[1][1]=n;if(n===undefined){e[a].values[1][0]=t.values[0][0]}e[a].values[1].splice(2)}if(o||e[a].inParameters){e[a].inParameters=o}if(s||e[a].outParameters){e[a].outParameters=s}if(r||e[a].payload){e[a].payload=r}}if(e.length===0){e.push(t)}return e}else if(t){return[t]}else{return[]}}h.prototype.validateValue=function(t){if(t===undefined||t===null||this._bDestroyed){return}if(!Array.isArray(t)){throw new e("No valid conditions provided",undefined,undefined,t)}let n;try{for(let e=0;e<t.length;e++){n=t[e];this._oConditionType.validateValue(n)}const e=O.call(this);if(t.length===0&&e===1){this._oConditionType.validateValue(null)}}catch(o){if(o instanceof e){o.setConditions(t)}else if(o instanceof l){throw new e(o.message,o.violatedConstraints,u({},n))}throw o}};function O(){let t=1;if(this.oFormatOptions.hasOwnProperty("maxConditions")){t=this.oFormatOptions.maxConditions}return t}function w(t){if(C(t)){const e=t.getFormatOptions();const n=!e||!e.hasOwnProperty("showMeasure")||e.showMeasure;const o=!e||!e.hasOwnProperty("showNumber")||e.showNumber;const i=!e||!e.hasOwnProperty("showTimezone")||e.showTimezone;const s=!e||!e.hasOwnProperty("showDate")||e.showDate;const r=!e||!e.hasOwnProperty("showTime")||e.showTime;if(n&&!o||i&&!s&&!r){return true}}return false}function C(t){return t&&t.isA("sap.ui.model.CompositeType")}function T(){let t=false;if(this.oFormatOptions.hasOwnProperty("noFormatting")){t=this.oFormatOptions.noFormatting}return t}function v(){if(this.oFormatOptions.hasOwnProperty("keepValue")){return this.oFormatOptions.keepValue}return null}function F(){if(this.oFormatOptions.hasOwnProperty("multipleLines")){return this.oFormatOptions.multipleLines}return false}return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/CustomFieldInfo", ["sap/ui/mdc/field/FieldInfoBase","sap/ui/core/Control","sap/ui/base/ManagedObjectObserver"],function(e,t,o){"use strict";const i=e.extend("sap.ui.mdc.field.CustomFieldInfo",{metadata:{library:"sap.ui.mdc",properties:{},aggregations:{content:{type:"sap.ui.core.Control",multiple:false}},defaultAggregation:"content"}});i._oBox=undefined;i.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oObserver=new o(n.bind(this));this._oObserver.observe(this,{aggregations:["content"]})};i.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oMyBox){this._oMyBox.destroy();this._oMyBox=undefined}};i.prototype.isTriggerable=function(){return Promise.resolve(!!this.getAggregation("content"))};i.prototype.getTriggerHref=function(){return Promise.resolve(null)};i.prototype.getDirectLinkHrefAndTarget=function(){return Promise.resolve(null)};i.prototype.getContent=function(){if(!i._oBox){i._oBox=t.extend("sap.ui.mdc.field.CustomFieldInfoBox",{metadata:{},renderer:{apiVersion:2,render:function(e,t){const o=t._oInfo.getAggregation("content");e.openStart("div",t);e.openEnd();if(o){e.renderControl(o)}e.close("div")}}})}if(!this._oMyBox||this._oMyBox._bIsBeingDestroyed){this._oMyBox=new i._oBox(this.getId()+"-box");this._oMyBox._oInfo=this}return Promise.resolve(this._oMyBox)};i.prototype.checkDirectNavigation=function(){return Promise.resolve(false)};function n(e){if(e.object==this&&!this._bIsBeingDestroyed){if(e.name=="content"){this.fireDataUpdate()}}}return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/DynamicDateRangeConditionsType", ["sap/ui/mdc/field/ConditionsType","sap/ui/mdc/condition/ConditionValidateException","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/condition/Condition","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/util/DateUtil","sap/ui/model/SimpleType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/m/library","sap/base/util/merge"],function(e,t,o,i,n,a,s,r,l,p,u,c,d,f){"use strict";const y=e.extend("sap.ui.mdc.field.DynamicDateRangeConditionsType",{constructor:function(e,t){l.apply(this,arguments);this.sName="ConditionsDateRange";this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc")}});y.prototype.destroy=function(){l.prototype.destroy.apply(this,arguments);this._bDestroyed=true};y.prototype.formatValue=function(e,t){if(e==undefined||e==null||this._bDestroyed){return null}if(!Array.isArray(e)){throw new p("No valid conditions provided")}const i=h.call(this);let n;if(i!==1){throw new p("MaxConditions must be 1")}if(e.length===1){const t=e[0];const i=o.getOperator(t.operator);if(!t.operator||!i){throw new p("No valid condition provided, Operator wrong.")}const l=[];const u=T.call(this);let c=o.getDynamicDateOptionForOperator(i,d.StandardDynamicDateRangeKeys,u);for(let e=0;e<i.valueTypes.length;e++){if(i.valueTypes[e]&&i.valueTypes[e]!==s.Static){if(c){if(i.valueTypes[e]===s.Self){l.push(r.typeToDate(t.values[e],m.call(this),u))}else{const o=g.call(this,i.valueTypes[e]);if(o===a.Date||o===a.DateTime){l.push(r.typeToDate(t.values[e],O.call(this,i,e),o))}else{l.push(t.values[e])}}}else{l.push(t.values[e])}}}if(!c){c=o.getCustomDynamicDateOptionForOperator(i,u)}n={operator:c,values:l}}return n};y.prototype.parseValue=function(e,t){if(this._bDestroyed){return null}if(h.call(this)!==1){throw new u("Only one condition supported for parsing")}const l=v.call(this);const p=[];if(e&&e.operator){if(e.operator==="PARSEERROR"){throw new u(e.values[0])}const t=e.operator;const c=o.getOperatorForDynamicDateOption(t,T.call(this));if(c){const u=T.call(this);const f=[];for(let o=0;o<c.valueTypes.length;o++){if(c.valueTypes[o]&&c.valueTypes[o]!==s.Static){if(d.StandardDynamicDateRangeKeys[t]){if(c.valueTypes[o]===s.Self){f.push(r.dateToType(e.values[o],m.call(this),u))}else{const t=c.valueTypes[o]===s.Self?u:g.call(this,c.valueTypes[o]);if(t===a.Date||t===a.DateTime){f.push(r.dateToType(e.values[o],O.call(this,c,o),t))}else{f.push(e.values[o])}}}else{f.push(e.values[o])}}}const y=i.createCondition(c.name,f,undefined,undefined,n.NotValidated);o.updateConditionValues(y);o.checkConditionsEmpty(y,l);p.push(y)}}return p};y.prototype.validateValue=function(e){if(e===undefined||e===null||this._bDestroyed){return}if(!Array.isArray(e)){throw new t("No valid conditions provided",undefined,undefined,e)}const i=m.call(this);const n=v.call(this);for(let a=0;a<e.length;a++){const s=e[a];if(typeof s!=="object"||!s.operator||!s.values||!Array.isArray(s.values)){throw new t(this._oResourceBundle.getText("field.VALUE_NOT_VALID"),undefined,typeof s==="object"?f({},s):s,e)}const r=o.getOperator(s.operator);if(!r||n.indexOf(r.name)===-1){throw new t("No valid condition provided, Operator wrong.",undefined,f({},s),e)}try{r.validate(s.values,i)}catch(o){if(o instanceof c){throw new t(o.message,o.violatedConstraints,f({},s),e)}throw o}}};function h(){let e=1;if(this.oFormatOptions.hasOwnProperty("maxConditions")){e=this.oFormatOptions.maxConditions}return e}function m(){const e=this.oFormatOptions.valueType;if(!e){throw new Error("Type missing")}return e}function v(){let e=this.oFormatOptions.operators;if(!e||e.length===0){e=o.getOperatorsForType(T.call(this))}return e}function T(){const e=m.call(this);const t=e.getMetadata().getName();const o=e.getFormatOptions();const i=e.getConstraints();return g.call(this,{name:t,formatOptions:o,constraints:i})}function g(e){const t=this.oFormatOptions.delegate;const o=this.oFormatOptions.control;const i=t?t.getTypeMap(o).getBaseType(e.name,e.formatOptions,e.constraints):a.Date;return i}function O(e,t){return e._createLocalType(e.valueTypes[t])}return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/FieldBase", ["sap/ui/mdc/Control","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/FieldEditMode","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/field/FieldBaseRenderer","sap/ui/mdc/field/ConditionType","sap/ui/mdc/field/ConditionsType","sap/ui/mdc/field/splitValue","sap/ui/mdc/field/content/ContentFactory","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/ConditionValidateException","sap/ui/mdc/util/loadModules","sap/ui/core/library","sap/ui/core/LabelEnablement","sap/ui/core/message/MessageMixin","sap/base/util/deepEqual","sap/base/util/merge","sap/base/util/restricted/_debounce","sap/ui/dom/containsOrEquals","sap/ui/model/BindingMode","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/base/ManagedObjectModel","sap/ui/base/ManagedObjectObserver","sap/ui/events/KeyCodes"],function(t,e,i,n,a,o,s,l,r,h,c,d,g,u,p,f,y,C,v,m,_,F,b,I,D,T,V,P,E){"use strict";const M=f.ValueState;const O=f.TextAlign;const A=f.TextDirection;const S=t.extend("sap.ui.mdc.field.FieldBase",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.ui.core.ISemanticFormContent","sap.m.IOverflowToolbarContent"],designtime:"sap/ui/mdc/designtime/field/FieldBase.designtime",library:"sap.ui.mdc",properties:{dataType:{type:"string",group:"Data",defaultValue:"sap.ui.model.type.String"},dataTypeConstraints:{type:"object",group:"Data",defaultValue:null},dataTypeFormatOptions:{type:"object",group:"Data",defaultValue:null},editMode:{type:"sap.ui.mdc.enums.FieldEditMode",group:"Data",defaultValue:i.Editable},required:{type:"boolean",group:"Data",defaultValue:false},display:{type:"sap.ui.mdc.enums.FieldDisplay",defaultValue:n.Value},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:O.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:A.Inherit},placeholder:{type:"string",group:"Misc",defaultValue:""},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:M.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},multipleLines:{type:"boolean",group:"Appearance",defaultValue:false},maxConditions:{type:"int",group:"Behavior",defaultValue:-1},conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true,bindable:"bindable"},label:{type:"string",group:"Misc",defaultValue:""},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/field/FieldBaseDelegate",payload:{}}},showEmptyIndicator:{type:"boolean",group:"Appearance",defaultValue:false},_valueHelpEnabled:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"},_ariaAttributes:{type:"object",defaultValue:{},byValue:true,visibility:"hidden"},_operators:{type:"string[]",defaultValue:[],visibility:"hidden"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false},contentEdit:{type:"sap.ui.core.Control",multiple:false},contentDisplay:{type:"sap.ui.core.Control",multiple:false},_content:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},fieldInfo:{type:"sap.ui.mdc.field.FieldInfoBase",multiple:false}},associations:{fieldHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false},valueHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},press:{},submit:{parameters:{promise:{type:"Promise"}}}},publicMethods:[],defaultAggregation:"content"},renderer:s,_oManagedObjectModel:null,_oInvalidInput:null});C.call(S.prototype);const H={onsapup:at,onsapdown:at,onsaphome:at,onsapend:at,onsappageup:at,onsappagedown:at,onsapbackspace:at,onkeydown:at,onchange:Nt,onsapfocusleave:wt,onpaste:j};const x={onsapenter:R};let B;S._init=function(){if(B&&B.bool&&B.bool.control){B.bool.control.destroy()}if(B&&B.defineConditions&&B.defineConditions.control){B.defineConditions.control.destroy()}B={bool:{modules:["sap/ui/mdc/ValueHelp","sap/ui/mdc/valuehelp/Popover","sap/ui/mdc/valuehelp/content/Bool"],id:"BoolDefaultHelp",contentProperties:{},dialog:false,control:undefined,updateTitle:function(t,e){}},defineConditions:{modules:["sap/ui/mdc/ValueHelp","sap/ui/mdc/valuehelp/Dialog","sap/ui/mdc/valuehelp/content/Conditions"],id:"Field-DefineConditions-Help",contentProperties:{},dialog:true,control:undefined,updateTitle:function(t,e){t.getDialog().setTitle(e);t.getDialog().getContent()[0].setLabel(e)}}}};S._init();S.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oObserver=new P(this.observeChanges.bind(this));this._oObserver.observe(this,{properties:["display","editMode","dataType","dataTypeFormatOptions","dataTypeConstraints","multipleLines","maxConditions","conditions","delegate"],aggregations:["fieldInfo","content","contentEdit","contentDisplay"],associations:["fieldHelp","valueHelp","ariaLabelledBy"]});this.attachEvent("modelContextChange",this.handleModelContextChange,this);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._aAsyncChanges=[];this._bPreventGetDescription=false;this._oContentFactory=this.getContentFactory();this._oCreateContentPromise=undefined;this._sFilterValue=""};S.prototype.getContentFactory=function(){if(this.isFieldDestroyed()){return}if(!this._oContentFactory){this._oContentFactory=new c(this.getId()+"-contentFactory",{field:this,handleTokenUpdate:mt.bind(this),handleContentChange:pt.bind(this),handleContentLiveChange:yt.bind(this),handleValueHelpRequest:Dt.bind(this),handleEnter:R.bind(this),handleContentPress:vt.bind(this)})}return this._oContentFactory};const w=function(t){const e=bt.call(this);if(this.getEditMode()===i.Editable&&e&&!this._iFocusTimer&&e.shouldOpenOnFocus()&&!e.isOpen()){this._iFocusTimer=setTimeout(function(){if(!this.isFieldDestroyed()&&!e.isOpen()){Dt.call(this,t,true);this._redirectFocus(t,e)}this._iFocusTimer=null}.bind(this),300)}};const N=function(){if(this._iFocusTimer){clearTimeout(this._iFocusTimer);this._iFocusTimer=null}};S.prototype.exit=function(){N.call(this);const t=this.getFieldInfo();if(t){t.detachEvent("dataUpdate",kt,this)}const e=this.getContent();if(e){Z.call(this,e)}const i=this.getContentEdit();if(i){Z.call(this,i)}const n=this.getContentDisplay();if(n){Z.call(this,n)}if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();delete this._oManagedObjectModel}this._oObserver.disconnect();this._oObserver=undefined;this._oCreateContentPromise=undefined;const a=bt.call(this);if(a){a.detachEvent("dataUpdate",St,this);if(this._bConnected){xt.call(this,a);a.connect()}}if(this._oContentFactory){this._oContentFactory.destroy();this._oContentFactory=undefined}Ct.call(this);delete this._fnLiveChangeTimer};S.prototype.applySettings=function(){t.prototype.applySettings.apply(this,arguments);if(!this.bDelegateInitialized&&!this.bDelegateLoading){this.initControlDelegate()}this.triggerCheckCreateInternalContent();this._bSettingsApplied=true;return this};S.prototype.setProperty=function(e,n,a){if(e==="editMode"){const t=this.getEditMode();if(t!==i.Display&&t!==i.EditableDisplay&&n!==i.Display&&n!==i.EditableDisplay){a=true}}else if(e!=="width"&&e!=="multipleLines"&&e!=="showEmptyIndicator"){a=true}return t.prototype.setProperty.apply(this,[e,n,a])};S.prototype.onBeforeRendering=function(){tt.call(this)};S.prototype.onAfterRendering=function(){};S.prototype.focus=function(e){this._oFocusInfo=e;t.prototype.focus.call(this,e);delete this._oFocusInfo};S.prototype.onfocusin=function(t){Bt.call(this);if(!this._oFocusInfo?.targetInfo?.silent){w.call(this,t)}};S.prototype.onsapfocusleave=function(t){N.call(this);Ct.call(this);if(this._aAsyncChanges.length===0&&!this._bPendingChange){this._bDirty=false}};function L(t){const e=t.getParameter("fieldGroupIds");t.cancelBubble();t.preventDefault();const i=e.indexOf(this.getId());if(i>-1){if(this._bPendingChange){const t=bt.call(this);if(!(t&&Gt.call(t))){const t=Rt.call(this);if(t){U.call(this,undefined,undefined,undefined,t)}else{U.call(this,this.getConditions(),!this.isInvalidInput())}}}if(e.length>1){e.splice(i,1);this.fireValidateFieldGroup({fieldGroupIds:e})}}else{this.fireValidateFieldGroup({fieldGroupIds:e})}}S.prototype.onsapup=function(t){this._handleNavigate(t,-1)};S.prototype.onsapdown=function(t){this._handleNavigate(t,1)};S.prototype.onsaphome=function(t){this._handleNavigate(t,-9999)};S.prototype.onsappageup=function(t){this._handleNavigate(t,-10)};S.prototype.onsappagedown=function(t){this._handleNavigate(t,10)};S.prototype.onsapend=function(t){this._handleNavigate(t,9999)};S.prototype._handleNavigate=function(t,e){if(this.getEditMode()===i.Editable){const i=bt.call(this);const n=t.srcControl;if(i){if(i.isNavigationEnabled(e)&&(!this.getContentFactory().isMeasure()||n.getShowValueHelp())){const n=this.getControlForSuggestion();const a=n.hasStyleClass("sapMFocus");t.preventDefault();t.stopPropagation();i.setFilterValue(this._sFilterValue);i.navigate(i.isOpen()&&a&&e===1?0:e)}}}};S.prototype.onsapenter=function(t){const e=bt.call(this);if(e&&e.isOpen()){e.close()}this._sFilterValue="";if(this._oNavigateCondition){const e=t.srcControl;this._oNavigateCondition=undefined;this.getContentFactory().updateConditionType();if(e.selectText&&e.getDOMValue){e.selectText(e.getDOMValue().length,e.getDOMValue().length)}}};S.prototype.onsapescape=function(t){this.onsapenter(t)};S.prototype._redirectFocus=function(t,e){const i=t.srcControl;if(e.isOpen()&&(!this.getContentFactory().isMeasure()||i.getShowValueHelp&&i.getShowValueHelp())){i.addStyleClass("sapMFocus");e.removeFocus()}};S.prototype.ontap=function(t){const e=bt.call(this);if(this.getEditMode()===i.Editable&&e){if(e.shouldOpenOnClick()&&!e.isOpen()){Dt.call(this,t,true)}this._redirectFocus(t,e)}};S.prototype.clone=function(e,i){this.detachEvent("modelContextChange",this.handleModelContextChange,this);const n=this.getContent();if(n){Z.call(this,n)}const a=this.getContentEdit();if(a){Z.call(this,a)}const o=this.getContentDisplay();if(o){Z.call(this,o)}const s=this.getFieldInfo();if(s){s.detachEvent("dataUpdate",kt,this)}const l=t.prototype.clone.apply(this,arguments);this.attachEvent("modelContextChange",this.handleModelContextChange,this);if(n){X.call(this,n)}if(a){X.call(this,a)}if(o){X.call(this,o)}if(s){s.attachEvent("dataUpdate",kt,this)}if(this._bTriggerable){l._bTriggerable=this._bTriggerable}return l};S.prototype.getFieldPath=function(){const t=this.getBindingPath("conditions");if(t&&t.startsWith("/conditions/")){return t.slice(12)}else{return""}};function k(t,e,i,n){if(this.getCurrentContent().length>1){this._bPendingChange=true}else{U.call(this,t,e,i,n)}}function U(t,e,i,n){if(!n){if(e){n=Promise.resolve(this.getResultForChangePromise(t))}else{const t=this._getInvalidInputException();if(t){n=Promise.reject(t)}else{n=Promise.reject(i)}}}if(this._aAsyncChanges.length===0){this._bDirty=false}this.fireChangeEvent(t,e,i,n);this._bPendingChange=false}S.prototype.fireChangeEvent=function(t,e,i,n){};function R(t){const e=this.getEditMode();if(this._aAsyncChanges.length===0){this._bDirty=false}if(c._getEditable(e)&&(this.hasListeners("submit")||this._bPendingChange)){let t=Rt.call(this);let e=false;if(t){e=true}else if(this.isInvalidInput()){t=Promise.reject()}else{t=Promise.resolve(this.getResultForChangePromise(this.getConditions()))}if(this._bPendingChange){if(e){U.call(this,undefined,undefined,undefined,t)}else{U.call(this,this.getConditions(),!this.isInvalidInput(),undefined,t)}}this.fireSubmit({promise:t})}}function j(t){const e=this.getMaxConditions();if(e===1){return}const i=t.originalEvent.clipboardData.getData("text/plain");const n=h(i,true);if(n.length<=1){return}const a=t.srcControl;let o;for(const t in a.getMetadata().getAllProperties()){if(a.getBindingPath(t)==="/conditions"){o=t;break}}a.updateModelProperty(o,i,a.getProperty(o));t.stopImmediatePropagation(true);t.preventDefault();t.source=t.srcControl;t.parameters={};const s=this._aAsyncChanges.length;let l;let r;let c;if(s>0){this._aAsyncChanges[s-1].changeFired=true;this._aAsyncChanges[s-1].changeEvent=t;l=this._aAsyncChanges[s-1].promise}else{r=!this._bParseError;c=this.getConditions()}k.call(this,c,r,undefined,l)}S.prototype.initDataType=function(){if(this.getContentFactory().getDataType()){this.getContentFactory().getDataType().destroy();this.getContentFactory().setDataType(undefined)}if(this.getContentFactory().getDateOriginalType()){if(this.getContentFactory().getDateOriginalType()._bCreatedByField){this.getContentFactory().getDateOriginalType().destroy()}this.getContentFactory().setDateOriginalType(undefined)}if(this.getContentFactory().getUnitOriginalType()){if(this.getContentFactory().getUnitOriginalType()._bCreatedByField){this.getContentFactory().getUnitOriginalType().destroy()}this.getContentFactory().setUnitOriginalType(undefined)}this.getContentFactory().setIsMeasure(false)};function $(){const t=this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType()||this.getContentFactory().getDataType();if(t&&typeof t==="object"){return t.getMetadata().getName()}else if(this.bDelegateInitialized){return this.getTypeMap().getDataTypeClassName(this.getDataType())}else{return this.getDataType()}}function q(){const t=this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType()||this.getContentFactory().getDataType();if(t&&typeof t==="object"&&t.getConstraints()){return t.getConstraints()}else{return this.getDataTypeConstraints()}}function G(){const t=this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType()||this.getContentFactory().getDataType();if(t&&typeof t==="object"&&t.getFormatOptions()){return t.getFormatOptions()}else{return this.getDataTypeFormatOptions()}}S.prototype.getBaseType=function(){const t=$.call(this);const e=q.call(this);const i=G.call(this);const n=this.getTypeMap().getBaseType(t,i,e);return n};function z(t,e){const i=bt.call(this);if(i&&this._bConnected){It.call(this,t,i)}}S.prototype.getCurrentContent=function(){let t=this.getContent();if(!t){if(this.getEditMode()===i.Display){t=this.getContentDisplay()}else{t=this.getContentEdit()}}if(t){return[t]}else{return this.getAggregation("_content",[])}};S.prototype.handleModelContextChange=function(t){};function Q(t){this.setValueState(M.Error);this.setValueStateText(t)}S.prototype._removeUIMessage=function(){this.setValueState(M.None);this.setValueStateText()};S.prototype.observeChanges=function(t){if(t.name==="dataType"){if(this.getContentFactory().getDataType()){const e=function(t){this.getContentFactory().checkDataTypeChanged(t).then(function(t){if(t&&!this.isFieldDestroyed()){this.initDataType();this.destroyAggregation("_content");this.getContentFactory().updateConditionType()}}.bind(this)).catch(function(t){throw t})}.bind(this);if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){e.call(this,t.current)}.bind(this));return}e.call(this,t.current)}}if(t.name==="dataTypeFormatOptions"||t.name==="dataTypeConstraints"){if(this.getContentFactory().getDataType()){this.initDataType();this.destroyAggregation("_content");this.getContentFactory().updateConditionType()}}if(t.name==="maxConditions"){this.updateInternalContent()}if(t.name==="conditions"){this.resetInvalidInput(!this._bKeepValueState);z.call(this,t.current,t.old);let e=false;let n=0;for(n=0;n<this._aAsyncChanges.length;n++){const i=this._aAsyncChanges[n];if(i.waitForUpdate&&v(i.result,t.current)){ft.call(this,i);e=true;break}}if(e){this._aAsyncChanges.splice(n,1)}if((t.current.length===0||t.old.length===0)&&this.getShowEmptyIndicator()&&this.getEditMode()===i.Display&&!this.getContent()&&!this.getContentDisplay()){this.invalidate()}}if(t.name==="display"){this.destroyInternalContent();this.getContentFactory().updateConditionType()}if((t.name==="fieldHelp"||t.name==="valueHelp")&&t.ids){_t.call(this,t.ids,t.mutation);this.getContentFactory().updateConditionType()}if(t.name==="fieldInfo"&&t.child){Lt.call(this,t.child,t.mutation)}if(t.name==="content"&&t.child){Y.call(this,t.child,t.mutation,t.name)}if(t.name==="contentEdit"&&t.child){Y.call(this,t.child,t.mutation,t.name)}if(t.name==="contentDisplay"&&t.child){Y.call(this,t.child,t.mutation,t.name)}if(t.name==="delegate"&&!this.bDelegateInitialized&&!this.bDelegateLoading){this.initControlDelegate.call(this)}if(t.name==="ariaLabelledBy"&&t.ids){W.call(this,t.ids,t.mutation)}if(t.name==="editMode"){J.call(this);if(this._bSettingsApplied&&(t.old===i.Display||t.old===i.EditableDisplay||t.current===i.Display||t.current===i.EditableDisplay)){this.triggerCheckCreateInternalContent()}}};S.prototype.updateInternalContent=function(){if(this.getAggregation("_content",[]).length>0){tt.call(this);this.getContentFactory().updateConditionType()}};S.prototype.getFocusDomRef=function(){const t=this.getCurrentContent();if(t.length>0){return t[0].getFocusDomRef()}else{return this.getDomRef()}};S.prototype.getIdForLabel=function(){let t;const e=this.getCurrentContent();if(e.length>0){t=e[0].getIdForLabel()}else{t=it.call(this)}return t};S.prototype.getEditable=function(){return c._getEditable(this.getEditMode())};S.prototype.getControlForSuggestion=function(){const t=this.getCurrentContent();if(t.length>0){if(this.getContentFactory().isMeasure()&&t.length>1){return t[1]}else{return t[0]}}else{return this}};S.prototype.getFocusElementForValueHelp=function(t){const e=this.getControlForSuggestion();const i=e&&e.getMetadata().getAllPrivateAggregations()._endIcon&&e.getAggregation("_endIcon",[]);let n;if(i){for(let t=0;t<i.length;t++){if(i[t].getVisible()){n=i[t];break}}}return t||!n?e:n};S.prototype.getMaxConditionsForHelp=function(){if(this.getContentFactory().isMeasure()){return 1}else{return this.getMaxConditions()}};S.prototype.getFormFormattedValue=function(){const t=this.getConditions();const e=this.getShowEmptyIndicator()&&t.length===0&&!this.getContent()&&!this.getContentDisplay();if(e){if(!this._oResourceBundleM){this._oResourceBundleM=sap.ui.getCore().getLibraryResourceBundle("sap.m")}return this._oResourceBundleM.getText("EMPTY_INDICATOR")}else if(this.getContentFactory().isMeasure()&&this.getContentFactory().getUnitOriginalType(true)){const e=t.length>0?t[0].values[0]:[0,null];return this.getContentFactory().getUnitOriginalType().formatValue(e,"string")}else if(this.getContentFactory().getDateOriginalType(true)){const e=t.length>0?t[0].values[0]:null;return this.getContentFactory().getDateOriginalType().formatValue(e,"string")}else{const e=this.getContentFactory().getConditionsType();const i=e.getFormatOptions();const n=i.noFormatting;i.noFormatting=false;e.setFormatOptions(i);const a=e.formatValue(t);i.noFormatting=n;e.setFormatOptions(i);return a}};S.prototype.getFormValueProperty=function(){return"conditions"};S.prototype.getOverflowToolbarConfig=function(){return{canOverflow:true,invalidationEvents:[],propsUnrelatedToSize:["conditions","editMode","display","valueState","valueStateText"]}};S.prototype.enhanceAccessibilityState=function(t,e){const i=this.getParent();if(i&&i.enhanceAccessibilityState){i.enhanceAccessibilityState(t,e)}};S.prototype.getAccessibilityInfo=function(){const t=this.getCurrentContent();if(t.length===1&&t[0].getAccessibilityInfo){return t[0].getAccessibilityInfo()}else if(t.length>0){return{children:t}}else{return{}}};function W(t,e){const i=this.getAggregation("_content",[]);let n=this.getContent();if(n){i.push(n)}n=this.getContentDisplay();if(n){i.push(n)}n=this.getContentEdit();if(n){i.push(n)}for(let a=0;a<i.length;a++){n=i[a];if(n.getMetadata().getAllAssociations().ariaLabelledBy){if(e==="remove"){n.removeAriaLabelledBy(t)}else if(e==="insert"){n.addAriaLabelledBy(t)}}}}function K(t,e){const i={aria:{}};const n=bt.call(this);if(n){const a=n.getAriaAttributes(this.getMaxConditionsForHelp());const o=a.roleDescription;i["role"]=a.role;if(o){i.aria["roledescription"]=o}i.aria["haspopup"]=a.ariaHasPopup;i["autocomplete"]="off";if(t){if(a.role){i.aria["expanded"]="true"}i.aria["controls"]=a.contentId;if(e){i.aria["activedescendant"]=e}}else if(a.role){i.aria["expanded"]="false"}i["valueHelpEnabled"]=a.valueHelpEnabled;if(a.autocomplete&&a.autocomplete!=="none"){i.aria["autocomplete"]=a.autocomplete}}this.setProperty("_ariaAttributes",i,true)}S.prototype.connectLabel=function(t){nt.call(this,t);t.bindProperty("text",{path:"$field>/label"});t.setLabelFor(this);return this};function J(){const t=y.getReferencingLabels(this);for(let e=0;e<t.length;e++){const i=sap.ui.getCore().byId(t[e]);i.invalidate()}}function Y(t,e,i){if(e==="remove"){Z.call(this,t);st.call(this,t);if(this.getContentFactory().getContentConditionTypes()){delete this.getContentFactory().getContentConditionTypes()[i]}t.setModel(null,"$field")}else if(e==="insert"){if(!t.isA("sap.ui.core.IFormContent")){throw new Error(t+" is not a valid content! Only use valid content in "+this)}ot.call(this,t,true);X.call(this,t);if(this.getAggregation("_content",[]).length>0){this.destroyInternalContent()}if(!this.getContentFactory().getContentConditionTypes()){this.getContentFactory().setContentConditionTypes({})}if(!this.getContentFactory().getContentConditionTypes()[i]){this.getContentFactory().getContentConditionTypes()[i]={}}this.getContentFactory().setNoFormatting(false);this.awaitControlDelegate().then(function(){if(!this.isFieldDestroyed()){const t=ct.call(this,this.getSupportedOperators());if(t!==this.getContentFactory().getHideOperator()){this.getContentFactory().setHideOperator(t);this.getContentFactory()._setUsedConditionType(this.getContent(),this.getContentEdit(),this.getContentDisplay(),this.getEditMode())}}}.bind(this));let e;let n;let a=false;for(n in t.getMetadata().getAllProperties()){if(t.getBindingPath(n)==="/conditions"){e=t.getBindingInfo(n);if(e&&e.type&&e.type instanceof r){this.getContentFactory().getContentConditionTypes()[i].oConditionsType=e.type}a=true}if(n==="editable"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/editMode",formatter:c._getEditable})}if(n==="enabled"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/editMode",formatter:c._getEnabled})}if(n==="displayOnly"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/editMode",formatter:c._getDisplayOnly})}if(n==="required"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/required"})}if(n==="textAlign"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/textAlign"})}if(n==="textDirection"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/textDirection"})}if(n==="valueState"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/valueState"})}if(n==="valueStateText"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/valueStateText"})}if(n==="placeholder"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/placeholder"})}if(n==="showValueHelp"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/_valueHelpEnabled"})}if(n==="valueHelpIconSrc"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.setValueHelpIconSrc(this._getValueHelpIcon())}}for(const o in t.getMetadata().getAllAggregations()){if(t.getBindingPath(o)==="/conditions"){e=t.getBindingInfo(o);if(e&&e.template){for(n in e.template.getMetadata().getAllProperties()){const t=e.template.getBindingInfo(n);if(t&&t.type&&t.type instanceof l){this.getContentFactory().getContentConditionTypes()[i].oConditionType=t.type;if(a){this.getContentFactory().setNoFormatting(true)}break}}}}if(o==="tooltip"&&!t.getBindingPath(o)&&!t.getAggregation(o)){t.bindProperty(o,{path:"$field>/tooltip"})}}if(t.getMetadata().getAllAssociations().ariaLabelledBy){this.getContentFactory().setAriaLabelledBy(t)}}}function X(t){if(t.getMetadata().getEvents().change){t.attachEvent("change",pt,this)}if(t.getMetadata().getEvents().liveChange){t.attachEvent("liveChange",yt,this)}if(t.getMetadata().getEvents().press){t.attachEvent("press",vt,this)}if(t.getMetadata().getEvents().valueHelpRequest){t.attachEvent("valueHelpRequest",Dt,this)}if(t.getMetadata().getEvents().tokenUpdate){t.attachEvent("tokenUpdate",mt,this)}if(t.getMetadata().getEvents().validateFieldGroup){t.attachEvent("validateFieldGroup",L,this)}}function Z(t){if(t.getMetadata().getEvents().change){t.detachEvent("change",pt,this)}if(t.getMetadata().getEvents().liveChange){t.detachEvent("liveChange",yt,this)}if(t.getMetadata().getEvents().press){t.detachEvent("press",vt,this)}if(t.getMetadata().getEvents().valueHelpRequest){t.detachEvent("valueHelpRequest",Dt,this)}if(t.getMetadata().getEvents().tokenUpdate){t.detachEvent("tokenUpdate",mt,this)}if(t.getMetadata().getEvents().validateFieldGroup){t.detachEvent("validateFieldGroup",L,this)}}function tt(){const t=function(){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){tt.call(this)}.bind(this))}else{et.call(this)}};if(this._oCreateContentPromise){this._oCreateContentPromise.then(function(){tt.call(this)}.bind(this))}else{t.call(this)}}S.prototype.checkCreateInternalContent=function(){if(!this.isFieldDestroyed()&&this.getVisible()){tt.call(this)}};S.prototype.triggerCheckCreateInternalContent=function(){if(!this._oCheckCreateInternalContentPromise){this._oCheckCreateInternalContentPromise=this.awaitControlDelegate().then(function(){delete this._oCheckCreateInternalContentPromise;this.checkCreateInternalContent()}.bind(this))}};function et(){if(this.isFieldDestroyed()){return}const t=this.getEditMode();const e=this.getContent();const n=this.getContentEdit();const a=this.getContentDisplay();this.getContentFactory()._setUsedConditionType(e,n,a,t);Ft.call(this,this._getValueHelp());K.call(this,false);if(e||t===i.Display&&a||t!==i.Display&&n){this.destroyInternalContent();const t=this.getCurrentContent();if(t.length===1){nt.call(this,t[0])}return}const o=this.getMaxConditions();const s=this.getSupportedOperators();const l=this.getAggregation("_content",[]);let r;let h;const c=this.getMultipleLines();const d=this._bTriggerable;const g=this.getContentFactory().getContentType(this.getBaseType(),this.getMaxConditions(),d);if(l.length>0){r=l[0];h=r.getMetadata().getName().replace(/\./g,"/")}const u=this.getContentFactory().getContentMode(g,t,o,c,s);const p=g.getControlNames(u,s[0]);const f=p[0];if(f!==h){this.getContentFactory().setHideOperator(ct.call(this,s));if(r){this.destroyInternalContent();if(r.isA("sap.m.DateTimeField")){this.initDataType()}this.getContentFactory().updateConditionType()}if(ht.call(this,g,s,t,o)){lt.call(this,g.getUseDefaultValueHelp().name)}else if(this._sDefaultValueHelp){delete this._sDefaultValueHelp}const e=it.call(this);this._oCreateContentPromise=this.getContentFactory().createContent(g,u,e);this._oCreateContentPromise.then(function(t){delete this._oCreateContentPromise;for(let e=0;e<t.length;e++){const i=t[e];i.attachEvent("parseError",dt,this);i.attachEvent("validationError",gt,this);i.attachEvent("validationSuccess",ut,this);i.attachEvent("validateFieldGroup",L,this);ot.call(this,i,g.getUseDefaultEnterHandler());nt.call(this,i);this.addAggregation("_content",i)}J.call(this)}.bind(this)).catch(function(t){delete this._oCreateContentPromise;throw t}.bind(this))}}function it(){return this.getId()+"-inner"}S.prototype.destroyInternalContent=function(){this.destroyAggregation("_content");if(this.getContentFactory().getDateOriginalType()){this.getContentFactory().setDataType(this.getContentFactory().getDateOriginalType());this.getContentFactory().setDateOriginalType(undefined)}else if(this.getContentFactory().getUnitOriginalType()){this.getContentFactory().setDataType(this.getContentFactory().getUnitOriginalType());this.getContentFactory().setUnitOriginalType(undefined)}if(this.isInvalidInput()){this.resetInvalidInput(true)}if(this.getContentFactory().isMeasure()){this.getContentFactory().setIsMeasure(false)}};function nt(t){if(!this._oManagedObjectModel&&!this.isFieldDestroyed()){this._oManagedObjectModel=new V(this)}t.setModel(this._oManagedObjectModel,"$field")}function at(t){let e=false;const i=bt.call(this);if(!i){return}else{switch(t.type){case"sapup":e=i.isNavigationEnabled(-1);break;case"sapdown":e=i.isNavigationEnabled(1);break;case"saphome":e=i.isNavigationEnabled(-9999);break;case"sapend":e=i.isNavigationEnabled(9999);break;case"sappageup":e=i.isNavigationEnabled(-10);break;case"sappagedown":e=i.isNavigationEnabled(10);break;case"sapbackspace":e=i.isOpen();this._bPreventAutocomplete=true;break;case"keydown":if(t.which!==E.BACKSPACE&&t.which!==E.DELETE){this._bPreventAutocomplete=false}break;default:e=i.isOpen();break}}if(e){t.stopPropagation();t.stopImmediatePropagation(true);switch(t.type){case"sapup":this.onsapup(t);break;case"sapdown":this.onsapdown(t);break;case"saphome":this.onsaphome(t);break;case"sapend":this.onsapend(t);break;case"sappageup":this.onsappageup(t);break;case"sappagedown":this.onsappagedown(t);break;default:break}}}function ot(t,e){t.addDelegate(H,true,this);if(e){t.addDelegate(x,false,this)}}function st(t){t.removeDelegate(H);t.removeDelegate(x)}function lt(t){this._sDefaultValueHelp=B[t].id;let e=B[t].control;if(e&&e.isDestroyed()){B[t].control=undefined;e=undefined}if(!e){if(B[t].promise){B[t].promise.then(rt.bind(this,B[t].id))}else{B[t].promise=p(B[t].modules).catch(function(e){throw new Error("loadModules promise rejected in sap.ui.mdc.field.FieldBase:_createDefaultValueHelp function call - could not load controls "+JSON.stringify(B[t].modules))}).then(function(i){const n=i[0];const a=i[1];const o=i[2];e=new n(B[t].id,{delegate:{name:"sap/ui/mdc/ValueHelpDelegate",payload:{isDefaultHelp:true}}});const s=new a(B[t].id+"-container",{content:[new o(B[t].id+"-content",B[t].contentProperties)]});e._bIsDefaultHelp=true;e._sDefaultHelpType=t;B[t].control=e;if(B[t].dialog){e.setDialog(s)}else{e.setTypeahead(s)}e.connect(this);rt.call(this,B[t].id)}.bind(this)).unwrap()}}else{rt.call(this,B[t].id)}K.call(this,false)}function rt(t){_t.call(this,t,"insert")}function ht(t,e,n,a){const o=t.getUseDefaultValueHelp();if(o&&!this._getValueHelp()&&n!==i.Display){if(a===1&&o.single||a!==1&&o.multi){if(e.length===1){const i=ct.call(this,e);if(a===1){if(!(t.getEditOperator()&&t.getEditOperator()[e[0]])&&(o.oneOperatorSingle||!i)){return true}}else if(o.oneOperatorMulti||!i){return true}}else{return true}}}return false}function ct(t){if(t.length===1){const e=d.getOperator(t[0]);return!e||e.isSingleValue()}else{return false}}S.prototype._setInvalidInput=function(t,e,i,n){const a=n?n.getId():this.getId();if(!this._oInvalidInput){this._oInvalidInput={}}this._oInvalidInput[a]={exception:t,value:e,reason:i}};S.prototype._getInvalidInputException=function(t){let e;if(this._oInvalidInput){if(t){if(this._oInvalidInput[t.getId()]){return this._oInvalidInput[t.getId()].exception}else if(this._oInvalidInput[this.getId()]){return this._oInvalidInput[this.getId()].exception}}else{for(const t in this._oInvalidInput){e=this._oInvalidInput[t].exception;if(e){break}}}}return e};S.prototype.resetInvalidInput=function(t){if(this._oInvalidInput){this._oInvalidInput=null;if(t){this._removeUIMessage()}}};S.prototype.isInvalidInput=function(){return!!this._oInvalidInput};S.prototype._isInvalidInputForContent=function(t){return this._oInvalidInput&&(this._oInvalidInput[t.getId()]||this._oInvalidInput[this.getId()])};function dt(t){const e=t.getParameter("newValue");const i=t.getParameter("exception");const n=t.getSource();this._setInvalidInput(i,e,"ParseError",n);this._sFilterValue="";const a=n.getBinding("valueState");if(a&&a.getBindingMode()===b.OneWay){Q.call(this,t.getParameter("message"))}}function gt(t){const e=t.getParameter("newValue");const i=t.getParameter("exception");const n=t.getSource();this._setInvalidInput(i,e,"ValidationError",n);this._sFilterValue="";const a=i&&i instanceof u&&i.getConditions();let o=false;let s=0;for(s=0;s<this._aAsyncChanges.length;s++){const n=this._aAsyncChanges[s];if(n.waitForUpdate&&Array.isArray(n.result)){if(n.result.length===0&&e===""){n.reject(t.getParameter("exception"));o=true;break}else if(v(n.result,a)){n.reject(i);o=true;break}}}if(o){this._aAsyncChanges.splice(s,1)}const l=n.getBinding("valueState");if(l&&l.getBindingMode()===b.OneWay){Q.call(this,t.getParameter("message"))}}function ut(t){const e=t.getSource();if(this._isInvalidInputForContent(e)){const t=e.getBinding("valueState");let i=false;if(t&&t.getBindingMode()===b.OneWay){i=true}this.resetInvalidInput(i)}}function pt(t){const e={parameters:m({},t.getParameters()),source:t.getSource()};const i=this._aAsyncChanges.length;if(i>0&&!this._aAsyncChanges[i-1].changeFired){this._aAsyncChanges[i-1].changeFired=true;this._aAsyncChanges[i-1].changeEvent=e;k.call(this,undefined,undefined,undefined,this._aAsyncChanges[i-1].promise);return}const n={changeEvent:e};ft.call(this,n)}function ft(t){const e=this.getConditions();let i=true;let n;const a=t.changeEvent.source;if(t.changeEvent.parameters.hasOwnProperty("valid")){i=t.changeEvent.parameters["valid"]}else if(this.isInvalidInput()){i=false}if(!i&&t.changeEvent.parameters.hasOwnProperty("value")){n=t.changeEvent.parameters["value"]}const o=bt.call(this);if(o&&this._bConnected){if(sap.ui.getCore().getCurrentFocusedControlId()===a.getId()){o.close()}this._sFilterValue="";if(i){It.call(this,e,o);o.onControlChange()}Ct.call(this)}if(this._oNavigateCondition){this._oNavigateCondition=undefined;this.getContentFactory().updateConditionType();const t=a.getDOMValue?.();if(a.selectText&&t){a.selectText(t.length,t.length)}}if(t.resolve){jt.call(this,t)}else{k.call(this,e,i,n)}}function yt(t){let e;let i;let n=false;const a=t.getSource();this._oNavigateCondition=undefined;this.getContentFactory().updateConditionType();if("value"in t.getParameters()){e=t.getParameter("value")}else if("newValue"in t.getParameters()){e=t.getParameter("newValue")}if("escPressed"in t.getParameters()){n=t.getParameter("escPressed")}if("previousValue"in t.getParameters()){i=t.getParameter("previousValue")}else{const t=this.getConditions();i=t[0]&&t[0].values[0]}const o=bt.call(this);if(o&&(!this.getContentFactory().isMeasure()||a.getShowValueHelp())){if(n){if(o.isOpen()){o.close();It.call(this,this.getConditions(),o);Ct.call(this);this._sFilterValue=""}}else{const t=this.getSupportedOperators();let i=false;for(let e=0;e<t.length;e++){const n=d.getOperator(t[e]);if(n.validateInput){i=true;break}}if(i){this._bIgnoreInputValue=false;this._vLiveChangeValue=e;if(!this._fnLiveChangeTimer){N.call(this);this._fnLiveChangeTimer=_(function(){const t=this.getDisplay();if(typeof this._vLiveChangeValue!=="undefined"){this._sFilterValue=""}if(this._vLiveChangeValue){const e=d.getEQOperator();const i=e.getValues(this._vLiveChangeValue,t,true);if(i[0]){this._sFilterValue=i[0];if(i[1]){this._sFilterValue=this._sFilterValue+" "}}if(i[1]){this._sFilterValue=this._sFilterValue+i[1]}}const e=function(){if(Gt.call(this)){const t=o.isOpen();if(this.getMaxConditionsForHelp()===1&&o.getConditions().length>0){o.setConditions([])}o.setFilterValue(this._sFilterValue);if(!t){o.open(true)}else{Tt.call(this,false)}delete this._vLiveChangeValue}}.bind(this);if(this._bConnected&&this.getCurrentContent()[0]){o.isTypeaheadSupported().then(function(t){return!!t&&e()});delete this._vLiveChangeValue}}.bind(this),300,{leading:false,trailing:true});o.initBeforeOpen(true)}const t=o.isTypeaheadSupported();if(t instanceof Promise){t.then(function(t){if(Gt.call(this)&&this._fnLiveChangeTimer){this._fnLiveChangeTimer()}this._bOpenByTyping=t}.bind(this))}this._fnLiveChangeTimer()}}}this._bDirty=true;this.fireLiveChange({value:e,escPressed:n,previousValue:i})}function Ct(){if(this._fnLiveChangeTimer){this._fnLiveChangeTimer.cancel();delete this._vLiveChangeValue}}function vt(t){const e=this.getFieldInfo();if(e){e.getTriggerHref().then(function(t){if(!t){e.open(this.getCurrentContent()[0]);K.call(this,true)}}.bind(this))}this.firePress()}function mt(t){if(t.getParameter("type")==="removed"){const e=t.getParameter("removedTokens");let i=this.getConditions();let n;let a;let o;for(o=0;o<e.length;o++){const t=e[o];const n=t.getBindingContext("$field").sPath;const a=parseInt(n.slice(n.lastIndexOf("/")+1));i[a].delete=true}for(o=i.length-1;o>=0;o--){if(i[o].delete){if(this.getContentFactory().isMeasure()){n=i[o].values[0][1];a=i[o].payload}i.splice(o,1)}}if(this.getContentFactory().isMeasure()&&n&&i.length===0){i=[g.createItemCondition([undefined,n],undefined,undefined,undefined,a)]}this.setProperty("conditions",i,true);U.call(this,i,true);t.preventDefault(true)}}function _t(t,e){let i;if(e==="remove"){i=sap.ui.getCore().byId(t);if(i){xt.call(this,i);i.detachEvent("dataUpdate",St,this)}this.resetProperty("_valueHelpEnabled")}else if(e==="insert"){if(this._sDefaultValueHelp&&t!==this._sDefaultValueHelp){_t.call(this,this._sDefaultValueHelp,"remove");delete this._sDefaultValueHelp}Ft.call(this,t);const e=this.getCurrentContent()[0];if(e&&e.setValueHelpIconSrc){e.setValueHelpIconSrc(this._getValueHelpIcon())}}z.call(this,this.getConditions())}function Ft(t){if(t&&this.isPropertyInitial("_valueHelpEnabled")){const e=sap.ui.getCore().byId(t);if(e){e.attachEvent("dataUpdate",St,this);if(e.getIcon()){this.setProperty("_valueHelpEnabled",true,true)}}}}S.prototype._getValueHelp=function(){return this.getValueHelp()||this.getFieldHelp&&this.getFieldHelp()};function bt(){let t=this._getValueHelp();let e;if(!t&&this._sDefaultValueHelp){t=this._sDefaultValueHelp}if(t){e=sap.ui.getCore().byId(t)}return e}function It(t,e){if(!e){e=bt.call(this)}let i;if(this.isInvalidInput()&&this.getMaxConditionsForHelp()===1){i=[]}else if(this.getContentFactory().isMeasure()){i=[];for(let e=0;e<t.length;e++){const n=t[e];if(n.values[0]&&n.values[0][1]){const t=g.createItemCondition(n.values[0][1],undefined,n.inParameters,n.outParameters,n.payload);i.push(t)}}}else{i=t}e.setConditions(i)}function Dt(t,e){const i=bt.call(this);if(i){if(this._fnLiveChangeTimer){this._fnLiveChangeTimer.flush()}i.setFilterValue(this._sFilterValue);const n=this.getConditions();It.call(this,n,i);i.toggleOpen(!!e);const a=i.isFocusInHelp();this._bFocusOnValueHelp=!!t.getSource&&!a;const o=t.srcControl||t.getSource();if(!a){if(o.bValueHelpRequested){o.bValueHelpRequested=false}}}}function Tt(t){this.getCurrentContent().forEach(function(e){if(e.closeValueStateMessage&&!t){e.closeValueStateMessage()}if(e.setShowValueStateMessage){e.setShowValueStateMessage(t)}})}function Vt(t){let e=this.getConditions();const i=t.getParameter("conditions");const n=t.getParameter("add");const s=t.getParameter("close");const l=t.oSource;const r=this.getMaxConditions();let h;const c=this.getControlForSuggestion();let u;let p=0;if(this.getContentFactory().isMeasure()){if(i.length>1){throw new Error("Only one item must be selected! "+this)}if(i[0].operator!==o.EQ){throw new Error("Only EQ allowed! "+this)}if(e.length>0){for(p=0;p<e.length;p++){e[p].values[0][1]=i[0].values[0];if(e[p].operator===o.BT){e[p].values[1][1]=i[0].values[0]}if(i[0].inParameters){e[p].inParameters=i[0].inParameters}if(i[0].outParameters){e[p].outParameters=i[0].outParameters}if(i[0].payload){e[p].payload=i[0].payload}}}else{const t=d.getEQOperator(this.getSupportedOperators());const n=[null,i[0].values[0]];h=g.createCondition(t.name,[n],i[0].inParameters,i[0].outParameters,a.NotValidated,i[0].payload);e.push(h);const o=this.getContentFactory().getConditionType(true);const s=this.getContentFactory().getUnitConditionsType(true);if(o){u=o.formatValue(h)}else if(s){u=s.formatValue(e)}}}else{if(!n){e=[]}for(p=0;p<i.length;p++){h=i[p];if(!qt.call(this,h.operator)){continue}const t=n?d.indexOfCondition(h,e):-1;if(t===-1){e.push(h)}else if(h.validated===a.Validated&&h.values.length>1&&(e[t].values.length===1||h.values[1]!==e[t].values[1])){e[t].values=h.values}}}if(r>0&&r<e.length){e.splice(0,e.length-r)}let f=false;if(c&&c.setDOMValue){if(this.getMaxConditionsForHelp()===1&&e.length>0){if(this.getContentFactory().isMeasure()&&this.getContentFactory().getUnitConditionsType(true)){u=this.getContentFactory().getUnitConditionsType().formatValue(e)}else if(this.getContentFactory().getConditionType(true)){u=this.getContentFactory().getConditionType().formatValue(e[0])}else if(this.getContentFactory().getConditionsType(true)){u=this.getContentFactory().getConditionsType().formatValue(e)}const t=function(t){const i=c.getDOMValue();c.setDOMValue("");c.setDOMValue(t);if(i!==t&&r===1){this.fireLiveChange({value:e[0].values[0]})}}.bind(this);if(u instanceof Promise){u.then(function(e){t(e)})}else{t(u)}this._sFilterValue=""}else if(s){c.setDOMValue("");this._sFilterValue="";this._bIgnoreInputValue=false}else{this._bIgnoreInputValue=true}if(this.isInvalidInput()){this.resetInvalidInput(true);f=true}}const y=this.getConditions();if(!v(e,y)){this._oNavigateCondition=undefined;this.getContentFactory().updateConditionType();this.setProperty("conditions",e,true);if(!d.compareConditionsArray(e,y)){l.onControlChange();k.call(this,e,true)}}else if(f){k.call(this,e,true)}}function Pt(t){let e=t.getParameter("value");let i=t.getParameter("key");let s=t.getParameter("condition");const l=t.getParameter("itemId");const r=t.getParameter("leaveFocus");if(!s&&i){s=g.createItemCondition(i,e)}let h;let c;const u=this.getControlForSuggestion();const p=d.getEQOperator(this.getSupportedOperators());const f=bt.call(this);if(r){u.addStyleClass("sapMFocus");u.focus();f.removeFocus();return}if(s){this._oNavigateCondition=m({},s);this._oNavigateCondition.operator=p.name;i=s.values[0];e=s.values[1]}else{this._oNavigateCondition=g.createCondition(p.name,[i,e],undefined,undefined,a.Validated)}if(this.getContentFactory().isMeasure()){const t=this.getConditions();if(t.length>0){this._oNavigateCondition.operator=t[0].operator;this._oNavigateCondition.values[0]=[t[0].values[0][0],i];if(t[0].operator===o.BT){this._oNavigateCondition.values[1]=[t[0].values[1][0],this._oNavigateCondition.values[0][1]]}else if(this._oNavigateCondition.values.length>1){this._oNavigateCondition.values.splice(1)}}else{this._oNavigateCondition.values=[[null,i]]}}this._bPreventGetDescription=true;this.getContentFactory().updateConditionType();if(this.getDisplay()!==n.Value){h=i}else if(e){h=e}else{h=i}const y=f.isOpen();if(u&&u.setDOMValue){if(!c){if(this.getContentFactory().isMeasure()&&this.getContentFactory().getUnitConditionsType(true)&&this._oNavigateCondition){c=this.getContentFactory().getUnitConditionsType().formatValue([this._oNavigateCondition])}else if(this.getContentFactory().getConditionType(true)&&this._oNavigateCondition){c=this.getContentFactory().getConditionType().formatValue(this._oNavigateCondition)}else if(this.getContentFactory().getConditionsType(true)&&this._oNavigateCondition){c=this.getContentFactory().getConditionsType().formatValue([this._oNavigateCondition])}else{c=e||i}}u.setDOMValue(c);if(u._doSelect){u._doSelect()}if(y){u.removeStyleClass("sapMFocus")}}this._bPreventGetDescription=false;this.getContentFactory().updateConditionType();K.call(this,y,l);this._bIgnoreInputValue=false;this._bDirty=true;this.fireLiveChange({value:h})}function Et(t){const e=t.getParameter("condition");const i=t.getParameter("filterValue");const n=this.getControlForSuggestion();const a=d.getEQOperator(this.getSupportedOperators());if(Gt.call(this)&&n&&n.setDOMValue&&n.selectText&&!this._bPreventAutocomplete&&(!n.isComposingCharacter||!n.isComposingCharacter())){const t=this.getContentFactory();const s=t.isMeasure();const l=this.getControlDelegate();let r;if(s){const t=this.getContentFactory().getCompositeTypes();if(t&&t.length>1){r=t[1]}}else{r=t.getDataType()}const h=l.getAutocomplete(this,e,this._vLiveChangeValue||this._sFilterValue,i,r,t.getAdditionalDataType());if(h&&h.text){this._oNavigateCondition=m({},e);this._oNavigateCondition.operator=a.name;if(s){const t=this.getConditions();if(t.length>0){this._oNavigateCondition.operator=t[0].operator;this._oNavigateCondition.values[0]=[t[0].values[0][0],e.values[0]];if(t[0].operator===o.BT){this._oNavigateCondition.values[1]=[t[0].values[1][0],this._oNavigateCondition.values[0][1]]}else if(this._oNavigateCondition.values.length>1){this._oNavigateCondition.values.splice(1)}}else{this._oNavigateCondition.values=[[null,e.values[0]]]}}n.setDOMValue(h.text);n.selectText(h.selectionStart,h.selectionEnd);t.updateConditionType();K.call(this,true,null)}}}function Mt(t){const e=this.getControlForSuggestion();if(this._bIgnoreInputValue){this._bIgnoreInputValue=false;e.setDOMValue("");this._sFilterValue="";this.getContentFactory().updateConditionType();if(this.getMaxConditions()!==1){this._oManagedObjectModel.checkUpdate(true)}}Tt.call(this,true);K.call(this,false);const i=t.getSource();const n=this.getConditions();It.call(this,n,i);if(Gt.call(this)){e.addStyleClass("sapMFocus")}delete this._bFocusOnValueHelp}function Ot(t){let e;if(this._bFocusOnValueHelp){if(this.getMaxConditionsForHelp()===1||this._sFilterValue){e=t.getParameter("itemId")}}K.call(this,true,e);Tt.call(this,false);delete this._bFocusOnValueHelp}function At(t){const e=this.getControlForSuggestion();e.focus();if(e.fireValueHelpRequest){e.bValueHelpRequested=true;e.fireValueHelpRequest()}}function St(t){const e=this.getEditMode()===i.Editable&&this.getCurrentContent().length>0&&sap.ui.getCore().getCurrentFocusedControlId()===this.getCurrentContent()[0].getId();if(!e&&!this._bPendingConditionUpdate&&this.getConditions().length>0&&(this.getMaxConditions()!==1||this.getDisplay()!==n.Value&&!this.isInvalidInput())&&this._oManagedObjectModel){this._oManagedObjectModel.checkUpdate(true)}}function Ht(t){const e=bt.call(this);xt.call(this,e)}function xt(t){if(this._bConnected){t.detachEvent("select",Vt,this);t.detachEvent("navigated",Pt,this);t.detachEvent("disconnect",Ht,this);t.detachEvent("afterClose",Mt,this);t.detachEvent("switchToValueHelp",At,this);t.detachEvent("closed",Mt,this);t.detachEvent("opened",Ot,this);t.detachEvent("typeaheadSuggested",Et,this);this._bConnected=false}}function Bt(){const t=bt.call(this);if(t){let e;const i=this.getContentFactory().isMeasure();if(i){const t=this.getContentFactory().getCompositeTypes();if(t&&t.length>1){e=t[1]}}else{e=this.getContentFactory().getDataType()}const a={maxConditions:this.getMaxConditions(),dataType:e,additionalDataType:this.getContentFactory().getAdditionalDataType(),operators:this.getSupportedOperators(),display:i?n.Value:this.getDisplay(),delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),defaultOperatorName:this.getDefaultOperator?this.getDefaultOperator():null};t.connect(this,a);if(!this._bConnected){this._bConnected=true;t.attachEvent("select",Vt,this);t.attachEvent("navigated",Pt,this);t.attachEvent("disconnect",Ht,this);t.attachEvent("afterClose",Mt,this);t.attachEvent("switchToValueHelp",At,this);t.attachEvent("closed",Mt,this);t.attachEvent("opened",Ot,this);t.attachEvent("typeaheadSuggested",Et,this);const e=this.getConditions();It.call(this,e,t);if(t._bIsDefaultHelp){B[t._sDefaultHelpType].updateTitle(t,this.getLabel())}}}}function wt(t){const e=bt.call(this);const i=this.getControlForSuggestion();const n=t.srcControl;if(e&&i===n){const n=sap.ui.getCore().byId(t.relatedControlId);if(n){if(F(e.getDomRef(),n.getFocusDomRef())){t.stopPropagation();t.stopImmediatePropagation(true);if(i.bValueHelpRequested){i.bValueHelpRequested=false}if(this._sFilterValue){i.setDOMValue(this._sFilterValue)}}else{e.skipOpening()}}}}function Nt(t){if(bt.call(this)){t.stopImmediatePropagation(true)}}S.prototype._getValueHelpIcon=function(){const t=bt.call(this);if(t){return t.getIcon()}};function Lt(t,e){if(e==="remove"){t.detachEvent("dataUpdate",kt,this)}else if(e==="insert"){t.attachEvent("dataUpdate",kt,this);kt.call(this)}}function kt(){const t=this.getFieldInfo();const e=this;t.isTriggerable().then(function(n){e._bTriggerable=n;let a=e.getAggregation("_content",[]);if(a.length>0&&e.getEditMode()===i.Display){tt.call(e);if(e._bTriggerable){a=e.getAggregation("_content",[]);const i=a[0];t.getDirectLinkHrefAndTarget().then(function(t){c._updateLink(i,t)})}}})}S.prototype.getFormatOptions=function(){if(!this._asyncParsingCall){this._asyncParsingCall=Ut.bind(this)}return{valueType:this.getContentFactory().retrieveDataType(),originalDateType:this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType(),additionalType:this.getContentFactory().getUnitType(),compositeTypes:this.getContentFactory().getCompositeTypes(),additionalValueType:this.getContentFactory().retrieveAdditionalDataType(),additionalCompositeTypes:this.getContentFactory().getAdditionalCompositeTypes(),display:this.getContentFactory().isMeasure()?n.Value:this.getDisplay(),valueHelpID:this.getContentFactory().isMeasure()?undefined:this._getValueHelp()||this._sDefaultValueHelp,operators:this.getSupportedOperators(),hideOperator:this.getContentFactory().getHideOperator(),maxConditions:this.getMaxConditions(),bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),preventGetDescription:this._bPreventGetDescription,convertWhitespaces:this.getEditMode()===i.Display||this.getMaxConditions()!==1,control:this,defaultOperatorName:this.getDefaultOperator?this.getDefaultOperator():null,getConditions:this.getConditions.bind(this),noFormatting:this.getContentFactory().getNoFormatting(),keepValue:this._bIgnoreInputValue?this._sFilterValue:null,multipleLines:this.getMultipleLines()}};S.prototype.checkValueInitial=function(t){if(t===null||t===undefined){return true}if(t===""||typeof t==="string"&&t.match(/^0+$/)){const e=this.getContentFactory().retrieveDataType();const i=e.parseValue("","string");if(i===t){return true}else{try{e.validateValue(i)}catch(t){return true}}}else{const i=$.call(this);if(this.getTypeMap().getBaseType(i)===e.Unit&&Array.isArray(t)&&t.length>1&&(t[0]===undefined||t[0]===null)&&!t[1]){return true}}return false};S.prototype.getUnitFormatOptions=function(){if(!this._asyncParsingCall){this._asyncParsingCall=Ut.bind(this)}return{valueType:this.getContentFactory().getUnitType(),originalDateType:this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType(),additionalType:this.getContentFactory().retrieveDataType(),compositeTypes:this.getContentFactory().getCompositeTypes(),additionalValueType:this.getContentFactory().retrieveAdditionalDataType(),additionalCompositeTypes:this.getContentFactory().getAdditionalCompositeTypes(),display:this.getDisplay(),valueHelpID:this._getValueHelp()||this._sDefaultValueHelp,operators:[o.EQ],hideOperator:true,maxConditions:1,bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),preventGetDescription:this._bPreventGetDescription,convertWhitespaces:this.getEditMode()===i.Display||this.getEditMode()===i.EditableDisplay,control:this,getConditions:this.getConditions.bind(this),noFormatting:false,multipleLines:false}};function Ut(t){const e=bt.call(this);if(e&&e.isOpen()&&(Gt.call(this)||Gt.call(e))){e.close()}const i={};const n=new Promise(function(e,n){i.resolve=e;i.reject=n;t.then(function(t){i.result=t;this.resetInvalidInput();const e=this.getConditions();if(v(t,e)){jt.call(this,i);$t.call(this,i)}else{i.waitForUpdate=true}}.bind(this)).catch(function(t){if(t&&!(t instanceof D)&&!(t instanceof I)&&!(t instanceof T)){throw t}const e=this.getControlForSuggestion();this._setInvalidInput(t,undefined,"AsyncParsing",e);n(t);$t.call(this,i)}.bind(this))}.bind(this));i.promise=n;this._aAsyncChanges.push(i)}function Rt(){const t=[];for(let e=0;e<this._aAsyncChanges.length;e++){t.push(this._aAsyncChanges[e].promise)}if(t.length>0){return Promise.all(t).then(function(){return this.getResultForChangePromise(this.getConditions())}.bind(this))}return null}S.prototype.getResultForChangePromise=function(t){return t};function jt(t){if(this._aAsyncChanges.length<=1){this._bDirty=false}t.resolve(this.getResultForChangePromise(t.result))}function $t(t){let e=false;let i=0;for(i=0;i<this._aAsyncChanges.length;i++){if(t===this._aAsyncChanges[i]){e=true;break}}if(e){this._aAsyncChanges.splice(i,1)}if(this._aAsyncChanges.length===0){this._bDirty=false}return e}S.prototype.getSupportedOperators=function(){let t;if(this.isSearchField()){t=[o.Contains]}else{let i=this.getBaseType();if(i===e.Unit){i=e.Numeric}t=d.getOperatorsForType(i)}this.setProperty("_operators",t,true);return t};S.prototype.isSearchField=function(){const t=new RegExp("^\\*(.*)\\*|\\$search$");const e=this.getFieldPath();return t.test(e)&&this.getMaxConditions()===1};function qt(t){const e=this.getSupportedOperators();for(let i=0;i<e.length;i++){if(t===e[i]){return true}}return false}S.prototype.isFieldPropertyInitial=function(t){if(this.isBound(t)&&!this.getBinding(t)){return!Object.hasOwn(this.mProperties,t)}else{return this.isPropertyInitial(t)}};S.prototype.isFieldDestroyed=function(){return this.isDestroyed()||this.isDestroyStarted()};S.prototype.hasPendingUserInput=function(){return!!this._bDirty};S.prototype.getAdditionalDataTypeConfiguration=function(){return null};function Gt(){const t=document.activeElement;return t&&F(this.getDomRef(),t)}return S});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/FieldBaseDelegate", ["sap/ui/mdc/BaseDelegate","sap/ui/mdc/DefaultTypeMap","sap/ui/model/FormatException","sap/ui/mdc/condition/Condition","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/FieldDisplay"],function(e,t,i,n,a,u){"use strict";const l=Object.assign({},e);l.getTypeMap=function(){return t};l.createConditionPayload=function(e,t,i){return undefined};l.createCondition=function(e,t,i,u){const l=n.createItemCondition(i[0],i[1],undefined,undefined,this.createConditionPayload(e,t,i));l.validated=a.Validated;return l};l.isInputValidationEnabled=function(e,t){if(t&&t.isValidationSupported()){return true}else{return false}};l.isInvalidInputAllowed=function(e,t){if(t){return!t.getValidateInput()}else{return true}};l.getItemForValue=function(e,t,i){if(t){return t.getItemForValue(i)}};l.getDescription=function(e,t,n,a,u,l,s,r,o,c,d){const f={value:n,parsedValue:n,parsedDescription:undefined,dataType:d,context:{inParameters:a,outParameters:u,payload:o},bindingContext:l,checkKey:true,checkDescription:false,caseSensitive:true,exception:i,control:c};return t&&t.getItemForValue(f)};l.getAutocomplete=function(e,t,i,n,a,l){if(i!==n){return null}const s=e.getDisplay();let r;let o;let c;let d;let f;if(a){r=a.formatValue(t.values[0],"string")}else{r=t.values[0]}const p=r.startsWith(i);let m=false;if(t.values.length>1){if(l){o=l.formatValue(t.values[1],"string")}else{o=t.values[1]}m=o.startsWith(i)}if(s===u.Value){if(p){c=r}}else if(s===u.Description){if(m){c=o}}else if(s===u.ValueDescription){if(p){c=r}else if(m){c=o}}else if(s===u.DescriptionValue){if(m){c=o}else if(p){c=r}}if(c){d=i.length;f=c.length;return{text:c,selectionStart:d,selectionEnd:f}}return null};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/FieldBaseRenderer", ["sap/ui/core/Renderer","sap/ui/mdc/enums/FieldEditMode"],function(e,t){"use strict";let n=e.extend("sap.ui.mdc.field.FieldBaseRenderer");n=Object.assign(n,{apiVersion:2});n.render=function(e,n){const s=n.getCurrentContent();const i=n.getWidth();const d=n.getConditions();const o=n.getEditMode();const c=n.getShowEmptyIndicator()&&d.length===0&&o===t.Display&&!n.getContent()&&!n.getContentDisplay();e.openStart("div",n);e.class("sapUiMdcFieldBase");if(s.length>1){e.class("sapUiMdcFieldBaseMoreFields")}if(c){e.class("sapMShowEmpty-CTX")}e.style("width",i);e.openEnd();for(let t=0;t<s.length;t++){const n=s[t];e.renderControl(n)}e.close("div")};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/FieldInfoBase", ["sap/ui/Device","sap/ui/mdc/Element","sap/m/library","sap/m/ResponsivePopover"],function(e,t,n,i){"use strict";const o=n.PlacementType;const r=t.extend("sap.ui.mdc.field.FieldInfoBase",{metadata:{library:"sap.ui.mdc",events:{dataUpdate:{},popoverAfterOpen:{}}}});r.prototype.isTriggerable=function(){throw new Error("sap.ui.mdc.field.FieldInfoBase: method isTriggerable must be redefined")};r.prototype.getTriggerHref=function(){throw new Error("sap.ui.mdc.field.FieldInfoBase: method getTriggerHref must be redefined")};r.prototype.getDirectLinkHrefAndTarget=function(){throw new Error("sap.ui.mdc.field.FieldInfoBase: method getDirectLinkHrefAndTarget must be redefined")};r.prototype.open=function(e){e=e?e:this.getParent();if(!e){throw new Error("sap.ui.mdc.field.FieldInfoBase: popover can not be open because the control is undefined")}const t=this.getDependents().find(function(e){return e.isA("sap.m.ResponsivePopover")});if(t&&t.isOpen()){return Promise.resolve()}return this.checkDirectNavigation().then(function(t){return t?Promise.resolve():this.createPopover().then(function(t){if(t){t.openBy(e);t.attachAfterOpen(function(){this.firePopoverAfterOpen()}.bind(this))}}.bind(this))}.bind(this))};r.prototype.getContent=function(e){throw new Error("sap.ui.mdc.field.FieldInfoBase: method getContent must be redefined")};r.prototype.checkDirectNavigation=function(){throw new Error("sap.ui.mdc.field.FieldInfoBase: method checkDirectNavigation must be redefined")};r.prototype.getSourceControl=function(){return this.getParent()};r.prototype.createPopover=function(){let t;return this.getContent(function(){return t}).then(function(n){t=new i(this.getId()+"-popover",{contentWidth:"380px",horizontalScrolling:false,showHeader:e.system.phone,placement:o.Auto,content:[n],afterClose:function(e){if(e.getSource()){e.getSource().destroy()}}});this.addDependent(t);return new Promise(function(e,i){sap.ui.require(["sap/ui/fl/apply/api/FlexRuntimeInfoAPI"],function(i){if(i.isFlexSupported({element:n})){i.waitForChanges({element:n}).then(function(){t.addAriaLabelledBy(n.getContentTitle?n.getContentTitle():"");e(t)})}else if(n){t.addAriaLabelledBy(n.getContentTitle?n.getContentTitle():"");e(t)}})})}.bind(this))};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/FieldInput", ["sap/m/Input","sap/ui/mdc/field/FieldInputRenderer","sap/ui/base/ManagedObjectObserver"],function(e,t,i){"use strict";const r=e.extend("sap.ui.mdc.field.FieldInput",{metadata:{library:"sap.ui.mdc",properties:{ariaAttributes:{type:"object",defaultValue:{},byValue:true}}},renderer:t});r.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oObserver=new i(a.bind(this));this._oObserver.observe(this,{properties:["ariaAttributes"]})};r.prototype.exit=function(){e.prototype.exit.apply(this,arguments);this._oObserver.disconnect();this._oObserver=undefined};function a(e){if(e.name==="ariaAttributes"){if(e.current.aria?.activedescendant!==e.old.aria?.activedescendant){const t=this.getFocusDomRef();if(!e.current.aria?.activedescendant){t.removeAttribute("aria-activedescendant")}else{t.setAttribute("aria-activedescendant",e.current.aria.activedescendant)}}}}return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/FieldInputRenderUtil", ["sap/ui/core/InvisibleText"],function(t){"use strict";const e={getAriaRole:function(t,e){const i=t.getAriaAttributes();if(i.role){return i.role}else{return e.getAriaRole.apply(this,arguments)}},getAccessibilityState:function(e,i){const r=e.getAriaAttributes();const s=i.getAccessibilityState.apply(this,arguments);if(r.aria){for(const t in r.aria){s[t]=r.aria[t]}}if(!r.valueHelpEnabled&&s.describedby){const e=t.getStaticId("sap.m","INPUT_VALUEHELP");const i=s.describedby.value.split(" ");let r="";for(let t=0;t<i.length;t++){const s=i[t];if(s!==e){r=r?r+" "+s:s}}if(r){s.describedby.value=r}else{delete s.describedby}}return s},writeInnerAttributes:function(t,e,i){i.writeInnerAttributes.apply(this,arguments);const r=e.getAriaAttributes();for(const e in r){if(e!=="aria"&&e!=="role"&&e!=="valueHelpEnabled"){t.attr(e,r[e])}}}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/FieldInputRenderer", ["sap/ui/core/Renderer","sap/m/InputRenderer","sap/ui/mdc/field/FieldInputRenderUtil"],function(e,t,i){"use strict";const n=e.extend(t);n.apiVersion=2;n.addOuterClasses=function(e,i){t.addOuterClasses.apply(this,arguments);e.class("sapUiMdcFieldInput")};n.getAriaRole=function(e){return i.getAriaRole.call(this,e,t)};n.getAccessibilityState=function(e){return i.getAccessibilityState.call(this,e,t)};n.writeInnerAttributes=function(e,n){return i.writeInnerAttributes.call(this,e,n,t)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/FieldMultiInput", ["sap/m/MultiInput","sap/ui/mdc/field/FieldMultiInputRenderer","sap/ui/base/ManagedObjectObserver"],function(e,t,i){"use strict";const r=e.extend("sap.ui.mdc.field.FieldMultiInput",{metadata:{library:"sap.ui.mdc",properties:{ariaAttributes:{type:"object",defaultValue:{},byValue:true}}},renderer:t});r.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oObserver=new i(a.bind(this));this._oObserver.observe(this,{properties:["ariaAttributes"]})};r.prototype.exit=function(){e.prototype.exit.apply(this,arguments);this._oObserver.disconnect();this._oObserver=undefined};function a(e){if(e.name==="ariaAttributes"){if(e.current.aria?.activedescendant!==e.old.aria?.activedescendant){const t=this.getFocusDomRef();if(!e.current.aria?.activedescendant){t.removeAttribute("aria-activedescendant")}else{t.setAttribute("aria-activedescendant",e.current.aria.activedescendant)}}}}return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/FieldMultiInputRenderer", ["sap/ui/core/Renderer","sap/m/MultiInputRenderer","sap/ui/mdc/field/FieldInputRenderUtil"],function(t,e,i){"use strict";const n=t.extend(e);n.apiVersion=2;n.addOuterClasses=function(t,i){e.addOuterClasses.apply(this,arguments);t.class("sapUiMdcFieldMultiInput")};n.getAriaRole=function(t){return i.getAriaRole.call(this,t,e)};n.getAccessibilityState=function(t){return i.getAccessibilityState.call(this,t,e)};n.writeInnerAttributes=function(t,n){return i.writeInnerAttributes.call(this,t,n,e)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/ListFieldHelpItem", ["sap/ui/mdc/valuehelp/content/FixedListItem"],function(e){"use strict";const t=e.extend("sap.ui.mdc.field.ListFieldHelpItem",{metadata:{library:"sap.ui.mdc"}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/MultiValueFieldDelegate", ["sap/ui/mdc/field/FieldBaseDelegate"],function(e){"use strict";const t=Object.assign({},e);t.updateItems=function(e,t,i){};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/MultiValueFieldItem", ["sap/ui/core/Element"],function(e){"use strict";const t=e.extend("sap.ui.mdc.field.MultiValueFieldItem",{metadata:{library:"sap.ui.mdc",properties:{key:{type:"any",byValue:true},description:{type:"string"}},defaultProperty:"key"}});t.prototype.bindProperty=function(t,r){if(t==="key"&&!r.formatter){r.targetType="raw"}e.prototype.bindProperty.apply(this,arguments)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/TokenDisplay", ["sap/m/Token","sap/ui/mdc/field/TokenDisplayRenderer"],function(e,t){"use strict";const i=e.extend("sap.ui.mdc.field.TokenDisplay",{metadata:{library:"sap.ui.mdc",properties:{_delimiter:{type:"string",defaultValue:"·",visibility:"hidden"}}},renderer:t});i.prototype.init=function(){e.prototype.init.apply(this,arguments);if(!this._oResourceBundle){this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc")}this.setProperty("_delimiter",this._oResourceBundle.getText("field.SEPARATOR").trim())};i.prototype.getSelected=function(){return false};i.prototype.focus=function(){return};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/TokenDisplayRenderer", ["sap/ui/core/Renderer","sap/m/TokenRenderer"],function(e,t){"use strict";const r=e.extend(t);r.apiVersion=2;r._setAttributes=function(e,r){t._setAttributes(e,r);e.attr("delimiter",r.getProperty("_delimiter"))};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/TokenizerDisplay", ["sap/m/Tokenizer","sap/ui/mdc/field/TokenizerDisplayRenderer","sap/ui/events/KeyCodes","sap/m/library"],function(t,e,n,o){"use strict";const i=o.EmptyIndicatorMode;const r=t.extend("sap.ui.mdc.field.TokenizerDisplay",{metadata:{library:"sap.ui.mdc",properties:{emptyIndicatorMode:{type:"sap.m.EmptyIndicatorMode",group:"Appearance",defaultValue:i.Off}}},renderer:e});r.prototype.init=function(){t.prototype.init.apply(this,arguments);this.setShouldRenderTabIndex(false);this.allowTextSelection(true);this.addStyleClass("sapUiMdcTokenizerDisplay")};r.prototype.onkeydown=function(e){t.prototype.onkeydown.call(this,e);if(!this.getEnabled()){return}if(e.which===n.ENTER){if(this.getHiddenTokensCount()>0){this._handleNMoreIndicatorPress()}}};r.prototype.ontouchstart=function(e){if(!this.hasOneTruncatedToken()&&!e.target.classList.contains("sapMTokenizerIndicator")){return}t.prototype.ontouchstart.apply(this,arguments)};r.prototype.ontap=function(e){const n=e.getMark("tokenTap");if(n&&!this.hasOneTruncatedToken()){return}t.prototype.ontap.apply(this,arguments)};r.prototype.getAccessibilityInfo=function(){const t=this.getTokens().map(function(t){return t.getText()}).join(" ");return{description:t}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/TokenizerDisplayRenderer", ["sap/ui/core/Renderer","sap/m/TokenizerRenderer","sap/m/library","sap/ui/core/Core"],function(e,t,n,r){"use strict";const a=n.EmptyIndicatorMode;const o=r.getLibraryResourceBundle("sap.m");const s=e.extend(t);s.apiVersion=2;s._renderIndicator=function(e,n){t._renderIndicator.apply(this,arguments);if(n.getEmptyIndicatorMode()!==a.Off&&n.getTokens().length==0){this._renderEmptyIndicator(e,n)}};s._renderIndicatorTabIndex=function(e,t){e.attr("tabindex","0")};s._renderEmptyIndicator=function(e,t){e.openStart("span");e.class("sapMEmptyIndicator");if(t.getEmptyIndicatorMode()===a.Auto){e.class("sapMEmptyIndicatorAuto")}e.openEnd();e.openStart("span");e.attr("aria-hidden",true);e.openEnd();e.text(o.getText("EMPTY_INDICATOR"));e.close("span");e.openStart("span");e.class("sapUiPseudoInvisibleText");e.openEnd();e.text(o.getText("EMPTY_INDICATOR_TEXT"));e.close("span");e.close("span")};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/content/BooleanContent", ["sap/ui/mdc/field/content/DefaultContent"],function(e){"use strict";const t=Object.assign({},e,{getDisplayMultiValue:function(){return[null]},getDisplayMultiLine:function(){return[null]},getEditMultiValue:function(){return[null]},getEditMultiLine:function(){return[null]},getUseDefaultValueHelp:function(){return{name:"bool",oneOperatorSingle:true,oneOperatorMulti:true,single:true,multi:true}},createEditMultiValue:function(){throw new Error("sap.ui.mdc.field.content.BooleanContent - createEditMultiValue not defined!")},createEditMultiLine:function(){throw new Error("sap.ui.mdc.field.content.BooleanContent - createEditMultiLine not defined!")},createDisplayMultiValue:function(){throw new Error("sap.ui.mdc.field.content.BooleanContent - createDisplayMultiValue not defined!")},createDisplayMultiLine:function(){throw new Error("sap.ui.mdc.field.content.BooleanContent - createDisplayMultiLine not defined!")}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/content/ContentFactory", ["sap/ui/base/Object","sap/ui/mdc/enums/FieldEditMode","sap/ui/mdc/enums/ContentMode","sap/ui/mdc/util/loadModules","sap/ui/mdc/field/content/DefaultContent","sap/ui/mdc/field/content/SearchContent","sap/ui/mdc/field/content/DateContent","sap/ui/mdc/field/content/TimeContent","sap/ui/mdc/field/content/DateTimeContent","sap/ui/mdc/field/content/LinkContent","sap/ui/mdc/field/content/BooleanContent","sap/ui/mdc/field/content/UnitContent","sap/ui/mdc/field/ConditionType","sap/ui/mdc/field/ConditionsType","sap/ui/base/SyncPromise"],function(t,e,n,i,o,s,a,r,p,d,l,y,u,c,h){"use strict";const f=t.extend("sap.ui.mdc.field.content.ContentFactory",{metadata:{library:"sap.ui.mdc"},constructor:function(e,n){this.init();this._oField=n?n.field:null;this._fnHandleTokenUpdate=n?n.handleTokenUpdate:null;this._fnHandleContentChange=n?n.handleContentChange:null;this._fnHandleContentLiveChange=n?n.handleContentLiveChange:null;this._fnHandleValueHelpRequest=n?n.handleValueHelpRequest:null;this._fnHandleEnter=n?n.handleEnter:null;this._fnHandleContentPress=n?n.handleContentPress:null;t.prototype.constructor.apply(this,arguments)}});const C={Default:o,Search:s,Date:a,Time:r,DateTime:p,Link:d,Boolean:l,Unit:y};f.prototype.init=function(){this._oContentTypeClass=undefined;this._sOperator=undefined;this._bNoFormatting=false;this._bHideOperator=false};f.prototype.exit=function(){this._oField=undefined;this._fnHandleTokenUpdate=undefined;this._fnHandleContentChange=undefined;this._fnHandleContentLiveChange=undefined;this._fnHandleValueHelpRequest=undefined;this._fnHandleEnter=undefined;this._fnHandleContentPress=undefined;this._oContentTypeClass=undefined;this._sOperator=undefined;if(this._oConditionType&&this._oConditionType._bCreatedByField){this._oConditionType.destroy();this._oConditionType=undefined}if(this._oConditionsType&&this._oConditionsType._bCreatedByField){this._oConditionsType.destroy();this._oConditionsType=undefined}};f.prototype.createContent=function(t,e,n){const o=t.getControlNames(e,this._sOperator);let s;this.setNoFormatting(t.getNoFormatting(e));if(o.every(function(t){return!t})){return Promise.resolve([])}if(!this.getDataType()){let t=this.getField().getDataType();if(t){t=this.getField().getTypeMap().getDataTypeClassName(t);o.push(t.replaceAll(".","/"))}}try{s=i(o).catch(function(t){throw new Error("loadModules promise rejected in sap.ui.mdc.field.content.ContentFactory:createContent function call - could not load data type "+JSON.stringify(o))}).then(function(i){if(this.getField()&&!this.getField().isFieldDestroyed()){this.updateConditionType();return t.create(this,e,this._sOperator,i,n)}else{return[]}}.bind(this)).unwrap()}catch(t){throw new Error("Error in sap.ui.mdc.field.content.ContentFactory:createContent function call ErrorMessage: '"+t.message+"'")}if(s.then){s.catch(function(t){throw new Error("Error in sap.ui.mdc.field.content.ContentFactory:createContent function call ErrorMessage: '"+t.message+"'")});return s}return h.resolve(s)};f.prototype.getContentMode=function(t,i,o,s,a){let r=n.Edit;if(i===e.Display){if(o!==1){r=n.DisplayMultiValue}else if(s){r=n.DisplayMultiLine}else{r=n.Display}}else if(o!==1){r=n.EditMultiValue}else if(s){r=n.EditMultiLine}else if(this.getField()._getValueHelp()){r=n.EditForHelp}else if(a.length===1&&t.getEditOperator()&&t.getEditOperator()[a[0]]){this._sOperator=a[0];r=n.EditOperator}return r};f.prototype.getContentType=function(t,e,n){const i=this.getField();let o=C[t]?C[t]:null;if(!o){if(i.getFieldInfo()&&n){o=C.Link}else if(i.isSearchField()){o=C.Search}else{o=C.Default}}return o};f._updateLink=function(t,e){if(e){t.setHref(e.href);t.setTarget(e.target)}};f._getEnabled=function(t){return t&&t!==e.Disabled};f._getEditable=function(t){return t===e.Editable||t===e.EditableReadOnly||t===e.EditableDisplay};f._getDisplayOnly=function(t){return t&&t!==e.Editable};f._getEditableUnit=function(t){return t===e.Editable};f.prototype.getField=function(){return this._oField};f.prototype.getValueHelpIcon=function(){return this.getField()._getValueHelpIcon()};f.prototype.getHandleTokenUpdate=function(){return this._fnHandleTokenUpdate};f.prototype.getHandleContentChange=function(){return this._fnHandleContentChange};f.prototype.getHandleContentLiveChange=function(){return this._fnHandleContentLiveChange};f.prototype.getHandleValueHelpRequest=function(){return this._fnHandleValueHelpRequest};f.prototype.getHandleEnter=function(){return this._fnHandleEnter};f.prototype.getHandleContentPress=function(){return this._fnHandleContentPress};f.prototype.setAriaLabelledBy=function(t){if(t.addAriaLabelledBy){const e=this.getField().getAriaLabelledBy();for(let n=0;n<e.length;n++){const i=e[n];t.addAriaLabelledBy(i)}}};f.prototype.setHideOperator=function(t){this._bHideOperator=t};f.prototype.getHideOperator=function(){return this._bHideOperator};function T(t,e,n,i){if(!i){if(this[t]&&this[t].getMetadata().getName()!==e.getMetadata().getName()){this[t].destroy();this[t]=undefined}if(!this[t]){const i=n();this[t]=new e(i);this[t]._bCreatedByField=true}}return this[t]}f.prototype.getConditionType=function(t){return T.call(this,"_oConditionType",u,this.getField().getFormatOptions.bind(this.getField()),t)};f.prototype.setConditionType=function(t){this._oConditionType=t};f.prototype.getConditionsType=function(t,e){const n=e||c;return T.call(this,"_oConditionsType",n,this.getField().getFormatOptions.bind(this.getField()),t)};f.prototype.setConditionsType=function(t){this._oConditionsType=t};f.prototype.getUnitConditionsType=function(t){return T.call(this,"_oUnitConditionsType",c,this.getField().getUnitFormatOptions.bind(this.getField()),t)};f.prototype.getContentConditionTypes=function(){return this._oContentConditionTypes};f.prototype.setContentConditionTypes=function(t){this._oContentConditionTypes=t};f.prototype._setUsedConditionType=function(t,n,o,s){if(this._oConditionType&&!this._oConditionType._bCreatedByField){this._oConditionType=undefined}if(this._oConditionsType&&!this._oConditionsType._bCreatedByField){this._oConditionsType=undefined}let a;let r;if(t){if(this._oContentConditionTypes.content){a=this._oContentConditionTypes.content.oConditionType;r=this._oContentConditionTypes.content.oConditionsType}}else if(s===e.Display&&o){if(this._oContentConditionTypes.contentDisplay){a=this._oContentConditionTypes.contentDisplay.oConditionType;r=this._oContentConditionTypes.contentDisplay.oConditionsType}}else if(s!==e.Display&&n){if(this._oContentConditionTypes.contentEdit){a=this._oContentConditionTypes.contentEdit.oConditionType;r=this._oContentConditionTypes.contentEdit.oConditionsType}}if(a){if(this._oConditionType&&this._oConditionType._bCreatedByField){this._oConditionType.destroy()}this._oConditionType=a}if(r){if(this._oConditionsType&&this._oConditionsType._bCreatedByField){this._oConditionsType.destroy()}this._oConditionsType=r}if(a||r){if(!this.getDataType()){let t=this.getField().getDataType();if(t){t=this.getField().getTypeMap().getDataTypeClassName(t);t=t.replaceAll(".","/");try{i([t]).catch(function(e){throw new Error("loadModules promise rejected in sap.ui.mdc.field.content.ContentFactory:_setUsedConditionType function call - could not load controls "+t)}).then(function(t){if(this.getField()&&!this.getField().isFieldDestroyed()){this.updateConditionType()}}.bind(this)).unwrap()}catch(t){throw new Error("Error in sap.ui.mdc.field.content.ContentFactory:_setUsedConditionType function call ErrorMessage: '"+t.message+"'")}}}else{this.updateConditionType()}}};f.prototype.getDataType=function(){return this._oDataType};f.prototype.setDataType=function(t){this._oDataType=t};f.prototype.checkDataTypeChanged=function(t){t=this.getField().getTypeMap().getDataTypeClassName(t);try{return i([t.replaceAll(".","/")]).catch(function(e){throw new Error("loadModules promise rejected in sap.ui.mdc.field.content.ContentFactory:checkDataTypeChanged function call - could not load data type "+t)}).then(function(e){return!this._oDataType||this._oDataType.getMetadata().getName()!==t}.bind(this))}catch(t){throw new Error("Error in sap.ui.mdc.field.content.ContentFactory:checkDataTypeChanged function call ErrorMessage: '"+t.message+"'")}};f.prototype.retrieveDataType=function(){if(!this._oDataType){const t=this.getField().getDataType();if(typeof t==="string"){this._oDataType=this.getField().getTypeMap().getDataTypeInstance(t,this.getField().getDataTypeFormatOptions(),this.getField().getDataTypeConstraints());this._oDataType._bCreatedByField=true}}return this._oDataType};f.prototype.getAdditionalDataType=function(){return this._oAdditionalDataType};f.prototype.setAdditionalDataType=function(t){this._oAdditionalDataType=t};f.prototype.retrieveAdditionalDataType=function(){if(!this._oAdditionalDataType){const t=this.getField().getAdditionalDataTypeConfiguration();if(t){if(t.isA&&t.isA("sap.ui.model.Type")){this._oAdditionalDataType=t}else if(t.name){this._oAdditionalDataType=this.getField().getTypeMap().getDataTypeInstance(t.name,t.formatOptions,t.constraints);this._oAdditionalDataType._bCreatedByField=true}}}return this._oAdditionalDataType};f.prototype.getDateOriginalType=function(){return this._oDateOriginalType};f.prototype.setDateOriginalType=function(t){this._oDateOriginalType=t};f.prototype.getUnitOriginalType=function(){return this._oUnitOriginalType};f.prototype.setUnitOriginalType=function(t){this._oUnitOriginalType=t};f.prototype.getUnitType=function(){return this._oUnitType};f.prototype.setUnitType=function(t){this._oUnitType=t};f.prototype.getCompositeTypes=function(){return this._aCompositeTypes};f.prototype.setCompositeTypes=function(t){this._aCompositeTypes=t};f.prototype.getAdditionalCompositeTypes=function(){return this._aAdditionalCompositeTypes};f.prototype.setAdditionalCompositeTypes=function(t){this._aAdditionalCompositeTypes=t};f.prototype.isMeasure=function(){return this._bIsMeasure};f.prototype.setIsMeasure=function(t){this._bIsMeasure=t};f.prototype.getDisplayFormat=function(){return this._sDisplayFormat};f.prototype.setDisplayFormat=function(t){this._sDisplayFormat=t};f.prototype.getValueFormat=function(){return this._sValueFormat};f.prototype.setValueFormat=function(t){this._sValueFormat=t};f.prototype.getCalendarType=function(){return this._sCalendarType};f.prototype.setCalendarType=function(t){this._sCalendarType=t};f.prototype.getSecondaryCalendarType=function(){return this._sSecondaryCalendarType};f.prototype.setSecondaryCalendarType=function(t){this._sSecondaryCalendarType=t};f.prototype.getFieldTypeInitialization=function(){return this.getField()._oTypeInitialization};f.prototype.updateConditionType=function(){const t=this._oConditionType;const e=this._oConditionsType;if(t||e){let n=this.getField().getFormatOptions();if(t){t.setFormatOptions(n)}if(e){e.setFormatOptions(n)}if(this._oUnitConditionsType){n=this.getField().getUnitFormatOptions();this._oUnitConditionsType.setFormatOptions(n)}}};f.prototype.setNoFormatting=function(t){this._bNoFormatting=t};f.prototype.getNoFormatting=function(){return this._bNoFormatting};return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/content/DateContent", ["sap/ui/mdc/field/content/DefaultContent","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/util/DateUtil","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/core/library","sap/ui/model/Filter"],function(e,t,a,n,i,r,o,l){"use strict";const s=o.CalendarType;let d;let p;const c=Object.assign({},e,{getEditMultiLine:function(){return[null]},getEdit:function(){return["sap/m/DynamicDateRange","sap/ui/mdc/condition/OperatorDynamicDateOption","sap/ui/mdc/field/DynamicDateRangeConditionsType","sap/m/library","sap/m/DynamicDateFormat"]},getEditOperator:function(){return{[n.EQ]:{name:"sap/m/DatePicker",create:this._createDatePickerControl},[n.BT]:{name:"sap/m/DateRangeSelection",create:this._createDateRangePickerControl}}},getEditForHelp:function(){return e.getEdit.apply(this,arguments)},getUseDefaultValueHelp:function(){return{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:true,single:false,multi:true}},createEditMultiLine:function(){throw new Error("sap.ui.mdc.field.content.DateContent - createEditMultiLine not defined!")},_createDatePickerControl:function(e,t,a){const n=t[0];const i=e.getConditionsType();e.setHideOperator(true);this._adjustDataTypeForDate(e);const r=new n(a,{value:{path:"$field>/conditions",type:i},displayFormat:e.getDisplayFormat(),valueFormat:e.getValueFormat(),placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",tooltip:"{$field>/tooltip}",liveChange:e.getHandleContentLiveChange(),change:e.getHandleContentChange()});if(r.setDisplayFormatType){r.setDisplayFormatType(e.getCalendarType())}if(r.setSecondaryCalendarType){r.setSecondaryCalendarType(e.getSecondaryCalendarType())}r._setPreferUserInteraction(true);e.setAriaLabelledBy(r);return[r]},_createDateRangePickerControl:function(e,t,a){const n=t[0];const i=e.getConditionsType();this._adjustDataTypeForDate(e);const r=new n(a,{value:{path:"$field>/conditions",type:i},displayFormat:e.getDisplayFormat(),valueFormat:e.getValueFormat(),delimiter:"...",displayFormatType:e.getCalendarType(),secondaryCalendarType:e.getSecondaryCalendarType(),placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",tooltip:"{$field>/tooltip}",liveChange:e.getHandleContentLiveChange(),change:e.getHandleContentChange()});r._setPreferUserInteraction(true);e.setAriaLabelledBy(r);return[r]},_adjustDataTypeForDate:function(e){const t=e.retrieveDataType();const a=t.getFormatOptions();this._getDatePattern(e,a);if(!a||a.style||!a.pattern||a.pattern!==e.getValueFormat()||!a.calendarType||a.calendarType!==s.Gregorian){e.setDateOriginalType(e.getDataType());e.setDataType(i.createInternalType(t,e.getValueFormat()));e.updateConditionType()}},_getDatePattern:function(e,a){const n=e.getField().getBaseType();switch(n){case t.Date:e.setValueFormat("yyyy-MM-dd");break;case t.DateTime:e.setValueFormat("yyyy-MM-dd'T'HH:mm:ss");break;case t.Time:e.setValueFormat("HH:mm:ss");break;default:return}e.setDisplayFormat("medium");if(a){if(a.style){e.setDisplayFormat(a.style)}else if(a.pattern){e.setDisplayFormat(a.pattern)}if(a.calendarType){e.setCalendarType(a.calendarType)}if(a.secondaryCalendarType){e.setSecondaryCalendarType(a.secondaryCalendarType)}}},createEdit:function(e,t,a){const n=t[0];const i=t[1];const r=t[2];const o=t[3];if(!d||!p){d=o.StandardDynamicDateRangeKeys;p=t[4]}const s=e.getConditionsType(false,r);const c=function(t){return this._getDateRangeStandardOptions(t,e)}.bind(this);const u=new l({path:"/",test:function(t){const a=e.getField().getBaseType();return!this._getDateRangeStandardOption(t,a)}.bind(this)});const y=function(t,n){const r=e.getField().getBaseType();const o=n.getObject();return this._createOperatorDynamicDateOption(o,e,i,r,a)}.bind(this);const g=new n(a,{value:{path:"$field>/conditions",type:s},formatter:this._getDateRangeFormatter(e),placeholder:"{$field>/placeholder}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",tooltip:"{$field>/tooltip}",standardOptions:{path:"$field>/_operators",formatter:c},customOptions:{path:"$field>/_operators",filters:u,factory:y},change:e.getHandleContentChange()});e.setAriaLabelledBy(n);return[g]},createEditForHelp:function(t,a,n){if(t.getDataType()&&t.getDataType().isA("sap.ui.model.CompositeType")){t.setIsMeasure(true)}return e.createEdit.apply(this,arguments)},_getDateRangeStandardOptions:function(e,t){if(!e||e.length===0){e=t.getField().getSupportedOperators()}const a=[];const n=t.getField().getBaseType();for(let t=0;t<e.length;t++){const i=e[t];const r=this._getDateRangeStandardOption(i,n);if(r){a.push(r)}}return a},_getDateRangeStandardOption:function(e,t){const a=r.getOperator(e);return r.getDynamicDateOptionForOperator(a,d,t)},_createOperatorDynamicDateOption:function(e,t,n,i,o){const l=r.getOperator(e);let s;if(l){const e=r.getCustomDynamicDateOptionForOperator(l,i);const d=t.retrieveDataType();const p=[];for(let e=0;e<l.valueTypes.length;e++){if(l.valueTypes[e]&&l.valueTypes[e]!==a.Static){p.push("custom")}}s=new n(o+"--"+e,{key:e,operator:l,type:d,baseType:i,valueTypes:p})}return s},_getDateRangeFormatter:function(e){const a=e.retrieveDataType();const n=e.getField().getBaseType();const i=a.getFormatOptions();const r={};const o={};if(i.style){r.style=i.style}else if(i.pattern){r.pattern=i.pattern}if(n===t.DateTime){o.datetime=r}o.date=r;return p.getInstance(o)}});return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/content/DateTimeContent", ["sap/ui/mdc/field/content/DefaultContent","sap/ui/mdc/field/content/DateContent","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/util/DateUtil","sap/base/util/merge"],function(e,t,a,n,i){"use strict";const o=Object.assign({},t,{getEditOperator:function(){return{[a.EQ]:{name:"sap/m/DateTimePicker",create:this._createDatePickerControl}}},createEditMultiLine:function(){throw new Error("sap.ui.mdc.field.content.DateTimeContent - createEditMultiLine not defined!")},_createDatePickerControl:function(e,a,i){const o=t._createDatePickerControl.apply(this,arguments);const r=e.getDateOriginalType()||e.getDataType();if(n.showTimezone(r)){const t=e.getUnitConditionsType();o[0].bindProperty("timezone",{path:"$field>/conditions",type:t,targetType:"sap.ui.mdc.raw:1"});o[0].setShowTimezone(true)}return o},_adjustDataTypeForDate:function(e){const a=e.retrieveDataType();let o=a.getFormatOptions();if(n.showTimezone(a)){this._getDatePattern(e,o);e.setDateOriginalType(e.getDataType());e.setDataType(n.createInternalType(a,e.getValueFormat()));e.updateConditionType();o=i({},o);delete o.pattern;o.showDate=false;o.showTime=false;o.showTimezone=true;const t=a.getConstraints();const r=a.getMetadata().getClass();e.setUnitType(new r(o,t))}else{t._adjustDataTypeForDate.apply(this,arguments)}}});return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/content/DefaultContent", ["sap/m/library","sap/ui/mdc/enums/ContentMode"],function(e,t){"use strict";const i=e.EmptyIndicatorMode;const a=e.TokenizerRenderMode;const l={getDisplay:function(){return["sap/m/Text"]},getDisplayMultiValue:function(){return["sap/ui/mdc/field/TokenizerDisplay","sap/ui/mdc/field/TokenDisplay"]},getDisplayMultiLine:function(){return["sap/m/ExpandableText"]},getEdit:function(){return["sap/ui/mdc/field/FieldInput"]},getEditMultiValue:function(){return["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"]},getEditMultiLine:function(){return["sap/m/TextArea"]},getEditOperator:function(){return[null]},getEditForHelp:function(){return this.getEdit()},getUseDefaultEnterHandler:function(){return true},getUseDefaultValueHelp:function(){return{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:false,single:true,multi:true}},getControlNames:function(e,i){let a;switch(e){case t.Display:a=this.getDisplay();break;case t.DisplayMultiValue:a=this.getDisplayMultiValue();break;case t.DisplayMultiLine:a=this.getDisplayMultiLine();break;case t.EditMultiValue:a=this.getEditMultiValue();break;case t.EditMultiLine:a=this.getEditMultiLine();break;case t.EditOperator:if(this.getEditOperator()){a=this.getEditOperator()[i]?this.getEditOperator()[i].name:[null]}else{a=[null]}break;case t.EditForHelp:a=this.getEditForHelp();break;default:a=this.getEdit()}if(a){return Array.isArray(a)?a:[a]}throw new Error("No control defined for content mode "+e)},getNoFormatting:function(e){if(e===t.EditMultiValue){return true}else{return false}},create:function(e,i,a,l,n){switch(i){case t.Display:return this.createDisplay(e,l,n);case t.DisplayMultiValue:return this.createDisplayMultiValue(e,l,n);case t.DisplayMultiLine:return this.createDisplayMultiLine(e,l,n);case t.EditMultiValue:return this.createEditMultiValue(e,l,n);case t.EditMultiLine:return this.createEditMultiLine(e,l,n);case t.EditOperator:if(this.getEditOperator()){return this.getEditOperator()[a]?this.getEditOperator()[a].create.call(this,e,l,n):[null]}return[null];case t.EditForHelp:return this.createEditForHelp(e,l,n);default:return this.createEdit(e,l,n)}},createEdit:function(e,t,i){const a=t[0];const l=e.getConditionsType();const n=new a(i,{value:{path:"$field>/conditions",type:l},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",valueHelpIconSrc:e.getValueHelpIcon(),showValueHelp:"{$field>/_valueHelpEnabled}",ariaAttributes:"{$field>/_ariaAttributes}",width:"100%",tooltip:"{$field>/tooltip}",autocomplete:false,change:e.getHandleContentChange(),liveChange:e.getHandleContentLiveChange(),valueHelpRequest:e.getHandleValueHelpRequest()});n._setPreferUserInteraction(true);e.setAriaLabelledBy(n);return[n]},createEditMultiValue:function(e,t,i){const a=t[0];const l=t[1];const n=e.getConditionType();const o=e.getConditionsType();const r=new l(i+"-token",{text:{path:"$field>",type:n}});const d=new a(i,{value:{path:"$field>/conditions",type:o},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:"{$field>/_valueHelpEnabled}",valueHelpIconSrc:e.getValueHelpIcon(),ariaAttributes:"{$field>/_ariaAttributes}",width:"100%",tooltip:"{$field>/tooltip}",tokens:{path:"$field>/conditions",template:r},dependents:[r],autocomplete:false,showSuggestion:false,change:e.getHandleContentChange(),liveChange:e.getHandleContentLiveChange(),tokenUpdate:e.getHandleTokenUpdate(),valueHelpRequest:e.getHandleValueHelpRequest()});d._setPreferUserInteraction(true);e.setAriaLabelledBy(d);return[d]},createEditMultiLine:function(e,t,i){const a=t[0];const l=e.getConditionsType();const n=new a(i,{value:{path:"$field>/conditions",type:l},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",rows:4,tooltip:"{$field>/tooltip}",change:e.getHandleContentChange(),liveChange:e.getHandleContentLiveChange()});n._setPreferUserInteraction(true);e.setAriaLabelledBy(n);return[n]},createDisplay:function(e,t,a){const l=t[0];const n=e.getConditionsType();const o=new l(a,{text:{path:"$field>/conditions",type:n},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",wrapping:"{$field>/multipleLines}",width:"100%",tooltip:"{$field>/tooltip}",emptyIndicatorMode:i.Auto});return[o]},createDisplayMultiLine:function(e,t,a){const l=t[0];const n=e.getConditionsType();const o=new l(a,{text:{path:"$field>/conditions",type:n},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",tooltip:"{$field>/tooltip}",emptyIndicatorMode:i.Auto});return[o]},createDisplayMultiValue:function(e,t,l){const n=t[0];const o=t[1];const r=e.getConditionType();const d=new o(l+"-token",{text:{path:"$field>",type:r}});const s=new n(l,{editable:false,emptyIndicatorMode:i.Auto,renderMode:a.Narrow,width:"100%",tooltip:"{$field>/tooltip}",tokens:{path:"$field>/conditions",template:d},dependents:[d]});return[s]},createEditForHelp:function(e,t,i){if(e.getDataType()&&e.getDataType().isA("sap.ui.model.CompositeType")){e.setIsMeasure(true)}return this.createEdit(e,t,i)}};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/content/LinkContent", ["sap/ui/mdc/field/content/DefaultContent","sap/m/library"],function(t,e){"use strict";const n=e.EmptyIndicatorMode;const i=Object.assign({},t,{getDisplay:function(){return["sap/m/Link"]},getDisplayMultiValue:function(){return[null]},getDisplayMultiLine:function(){return["sap/m/Link"]},getUseDefaultValueHelp:function(){return false},createDisplay:function(t,e,i){const l=e[0];const a=t.getConditionsType();const o=new l(i,{text:{path:"$field>/conditions",type:a},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",tooltip:"{$field>/tooltip}",press:t.getHandleContentPress(),wrapping:"{$field>/multipleLines}",emptyIndicatorMode:n.Auto});const r=t.getField().getFieldInfo();if(r){r.getDirectLinkHrefAndTarget().then(function(e){t.getMetadata()._oClass._updateLink(o,e)})}t.setAriaLabelledBy(o);return[o]},createDisplayMultiValue:function(){throw new Error("sap.ui.mdc.field.content.LinkContent - createDisplayMultiValue not defined!")},createDisplayMultiLine:function(t,e,n){return i.createDisplay(t,e,n)}});return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/content/SearchContent", ["sap/ui/mdc/field/content/DefaultContent","sap/ui/model/BindingMode","sap/ui/model/ParseException","sap/ui/model/ValidateException"],function(e,t,n,i){"use strict";const r=Object.assign({},e,{getDisplayMultiValue:function(){return[null]},getDisplayMultiLine:function(){return[null]},getEdit:function(){return["sap/m/SearchField"]},getEditMultiValue:function(){return[null]},getEditMultiLine:function(){return[null]},getEditForHelp:function(){return[null]},getUseDefaultEnterHandler:function(){return false},getUseDefaultValueHelp:function(){return false},createEdit:function(e,r,a){const l=r[0];const o=e.getConditionsType();e.setHideOperator(true);e.updateConditionType();const u=new l(a,{value:{path:"$field>/conditions",type:o,mode:t.OneWay},placeholder:"{$field>/placeholder}",width:"100%",tooltip:"{$field>/tooltip}",search:function(t){if(t.getParameters().clearButtonPressed||t.getParameters().escPressed){return}e.getHandleEnter().call(this,t)},change:function(t){const r=t.getSource();const a=t.getParameter("value");const l=r.getBinding("value");try{l.setExternalValue(a);const e={element:r,property:"value",type:l.getType(),newValue:a,oldValue:""};r.fireValidationSuccess(e,false,true)}catch(e){const t={element:r,property:"value",type:l.getType(),newValue:a,oldValue:"",exception:e,message:e.message};if(e instanceof n){r.fireParseError(t,false,true)}else if(e instanceof i){r.fireValidationError(t,false,true)}else{throw e}}e.getHandleContentChange().call(this,t)},liveChange:e.getHandleContentLiveChange()});e.setAriaLabelledBy(u);return[u]},createEditMultiValue:function(){throw new Error("sap.ui.mdc.field.content.SearchContent - createEditMultiValue not defined!")},createEditMultiLine:function(){throw new Error("sap.ui.mdc.field.content.SearchContent - createEditMultiLine not defined!")},createDisplayMultiValue:function(){throw new Error("sap.ui.mdc.field.content.SearchContent - createDisplayMultiValue not defined!")},createDisplayMultiLine:function(){throw new Error("sap.ui.mdc.field.content.SearchContent - createDisplayMultiLine not defined!")},createEditForHelp:function(){throw new Error("sap.ui.mdc.field.content.SearchContent - createEditForHelp not defined!")}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/content/TimeContent", ["sap/ui/mdc/field/content/DefaultContent","sap/ui/mdc/field/content/DateContent","sap/ui/mdc/enums/OperatorName"],function(t,e,n){"use strict";const i=Object.assign({},e,{getEditOperator:function(){return{[n.EQ]:{name:"sap/m/TimePicker",create:this._createDatePickerControl}}},getEdit:function(){return t.getEdit.apply(this,arguments)},createEditMultiLine:function(){throw new Error("sap.ui.mdc.field.content.TimeContent - createEditMultiLine not defined!")},createEdit:function(e,n,i){return t.createEdit.apply(this,arguments)}});return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/content/UnitContent", ["sap/ui/mdc/field/content/DefaultContent","sap/ui/core/library","sap/ui/model/Filter","sap/base/util/isEmptyObject","sap/base/util/merge","sap/ui/mdc/enums/FieldEditMode"],function(e,t,i,a,n,l){"use strict";const d=t.ValueState;const o=function(e,t,i,a,n,l){return e.getUnitTypeInstance?e.getUnitTypeInstance(t,n,l):e.getDataTypeInstance(t.getMetadata().getName(),i,a,{showNumber:n,showMeasure:l})};const s=Object.assign({},e,{getEdit:function(){return["sap/ui/mdc/field/FieldInput","sap/ui/core/InvisibleText"]},getEditMultiValue:function(){return["sap/ui/mdc/field/FieldMultiInput","sap/ui/mdc/field/FieldInput","sap/m/Token","sap/ui/core/InvisibleText"]},getEditMultiLine:function(){return[null]},getUseDefaultValueHelp:function(){return false},createEdit:function(e,t,i){e.setIsMeasure(true);const a=t[0];const n=t[1];const l=e.getConditionsType();this._adjustDataTypeForUnit(e);const d=n.getStaticId("sap.ui.mdc","field.NUMBER");let o=[];const s=new a(i,{value:{path:"$field>/conditions",type:l},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",valueHelpIconSrc:"sap-icon://slim-arrow-down",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:{path:"$field>/valueState",formatter:r},valueStateText:{path:"$field>/valueStateText",formatter:u},showValueHelp:false,width:"70%",tooltip:"{$field>/tooltip}",autocomplete:false,fieldGroupIds:{path:"$field>/fieldGroupIds",formatter:p},ariaDescribedBy:[d],change:e.getHandleContentChange(),liveChange:e.getHandleContentLiveChange()});s._setPreferUserInteraction(true);e.setAriaLabelledBy(s);o.push(s);o=this._addUnitControl(e,o,i,a,n);return o},createEditMultiValue:function(e,t,a){e.setIsMeasure(true);const n=t[0];const l=t[2];const d=t[1];const o=t[3];const s=e.getConditionType();const c=e.getConditionsType();this._adjustDataTypeForUnit(e);let f=[];const g=new l(a+"-token",{text:{path:"$field>",type:s}});const h=new i({path:"values",test:function(e){if(!Array.isArray(e[0])||e[0][0]){return true}else{return false}}});const I=o.getStaticId("sap.ui.mdc","field.NUMBER");const m=new n(a,{value:{path:"$field>/conditions",type:c},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:{path:"$field>/valueState",formatter:r},valueStateText:{path:"$field>/valueStateText",formatter:u},showValueHelp:false,width:"70%",tooltip:"{$field>/tooltip}",fieldGroupIds:{path:"$field>/fieldGroupIds",formatter:p},ariaDescribedBy:[I],tokens:{path:"$field>/conditions",template:g,filters:[h]},dependents:[g],autocomplete:false,change:e.getHandleContentChange(),liveChange:e.getHandleContentLiveChange(),tokenUpdate:e.getHandleTokenUpdate()});m._setPreferUserInteraction(true);e.setAriaLabelledBy(m);f.push(m);f=this._addUnitControl(e,f,a,d,o);return f},createEditMultiLine:function(){throw new Error("sap.ui.mdc.field.content.UnitContent - createEditMultiLine not defined!")},_addUnitControl:function(e,t,i,a,n){const d=e.getUnitConditionsType();if(e.getField().getEditMode()===l.EditableDisplay){t[0].bindProperty("description",{path:"$field>/conditions",type:d});t[0].setWidth("100%");t[0].setFieldWidth("70%")}else{let l;const o=e.getUnitOriginalType();const s=o&&o.getMetadata().getName();if(s&&s.indexOf("Currency")>=0){l=n.getStaticId("sap.ui.mdc","field.CURRENCY")}else{l=n.getStaticId("sap.ui.mdc","field.UNIT")}const c=new a(i+"-unit",{value:{path:"$field>/conditions",type:d},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditableUnit},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:{path:"$field>/valueState",formatter:r},valueStateText:{path:"$field>/valueStateText",formatter:u},valueHelpIconSrc:e.getValueHelpIcon(),showValueHelp:"{$field>/_valueHelpEnabled}",ariaAttributes:"{$field>/_ariaAttributes}",width:"30%",tooltip:"{$field>/tooltip}",autocomplete:false,fieldGroupIds:{path:"$field>/fieldGroupIds",formatter:p},ariaDescribedBy:[l],change:e.getHandleContentChange(),liveChange:e.getHandleContentLiveChange(),valueHelpRequest:e.getHandleValueHelpRequest()});c._setPreferUserInteraction(true);e.setAriaLabelledBy(c);t.push(c)}return t},_adjustDataTypeForUnit:function(e){const t=e.getField();const i=t.getTypeMap();const l=e.retrieveDataType();const d=l.getFormatOptions();const s=l.getConstraints();const r=!d||!d.hasOwnProperty("showMeasure")||d.showMeasure;const u=!d||!d.hasOwnProperty("showNumber")||d.showNumber;if(r&&u){const t=n({},d);const r=a(s)?undefined:n({},s);let u=o(i,l,t,r,true,false);e.setUnitOriginalType(e.getDataType());i.initializeInternalType(u,e.getFieldTypeInitialization());e.setDataType(u);u=o(i,l,t,r,false,true);i.initializeInternalType(u,e.getFieldTypeInitialization());e.setUnitType(u);e.updateConditionType()}}});function r(e){const t=this.getParent();if(!t||!t.isInvalidInput()||t._isInvalidInputForContent(this)){return e}else{return d.None}}function u(e){const t=this.getParent();if(!t||!t.isInvalidInput()){return e}else if(t._isInvalidInputForContent(this)){const e=t._getInvalidInputException(this);return e.message}else{return""}}function p(e){const t=this.getParent();if(t){e.push(t.getId())}else{let t=this.getId();const i=t.lastIndexOf("-inner");t=t.slice(0,i);e.push(t)}return e}return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/splitValue", [],function(){"use strict";const n=function(n,t){let e;if(typeof n==="string"){if(n.length&&n.endsWith("\r\n")){n=n.substring(0,n.lastIndexOf("\r\n"))}if(t){e=n.split(/\r\n|\r|\n|\t/g)}else{e=n.split(/\r\n|\r|\n/g)}}else{e=[n]}return e};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/FilterBarBase", ["sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/core/library","sap/ui/core/ShortcutHintsMixin","sap/ui/Device","sap/ui/mdc/Control","sap/base/Log","sap/base/util/merge","sap/ui/model/base/ManagedObjectModel","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/condition/ConditionModel","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/ConditionConverter","sap/ui/mdc/util/IdentifierUtil","sap/ui/mdc/util/FilterUtil","sap/ui/mdc/filterbar/PropertyHelper","sap/ui/mdc/enums/ReasonMode","sap/ui/mdc/enums/FilterBarValidationStatus","sap/ui/mdc/enums/OperatorName","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/m/library","sap/m/Button","./FilterBarBaseRenderer"],function(t,e,i,n,r,o,s,a,l,h,d,c,p,u,f,g,_,y,m,F,b,C){"use strict";const I=e.ValueState;const S=r.extend("sap.ui.mdc.filterbar.FilterBarBase",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/filterbar/FilterBarBase.designtime",defaultAggregation:"filterItems",interfaces:["sap.ui.mdc.IFilterSource","sap.ui.mdc.IFilter","sap.ui.mdc.IxState"],properties:{delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/FilterBarDelegate",payload:{modelName:undefined,collectionName:""}}},liveMode:{type:"boolean",defaultValue:false},showMessages:{type:"boolean",group:"Misc",defaultValue:true},showGoButton:{type:"boolean",defaultValue:true},filterConditions:{type:"object",defaultValue:{}},propertyInfo:{type:"object",defaultValue:[]},suspendSelection:{type:"boolean",defaultValue:false},_filterCount:{type:"string",visibility:"hidden"}},aggregations:{filterItems:{type:"sap.ui.mdc.FilterField",multiple:true},basicSearchField:{type:"sap.ui.mdc.FilterField",multiple:false},layout:{type:"sap.ui.mdc.filterbar.IFilterContainer",multiple:false,visibility:"hidden"}},associations:{variantBackreference:{type:"sap.ui.fl.variants.VariantManagement",multiple:false}},events:{search:{parameters:{reason:{type:"sap.ui.mdc.enums.ReasonMode"}}},filtersChanged:{parameters:{conditionsBased:{type:"boolean"},filtersText:{type:"string"},filtersTextExpanded:{type:"string"}}}}},renderer:C});const P=F.ButtonType;S.INNER_MODEL_NAME="$sap.ui.filterbar.mdc.FilterBarBase";S.CONDITION_MODEL_NAME="$filters";S.prototype.init=function(){r.prototype.init.apply(this,arguments);this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._createInnerModel();this._oObserver=new l(this._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["filterItems","basicSearchField"]});this._createInnerLayout();this.getEngine().register(this,{controller:{Filter:new t({control:this})}});this._fResolveInitialFiltersApplied=undefined;this._oInitialFiltersAppliedPromise=new Promise(function(t){this._fResolveInitialFiltersApplied=t}.bind(this));this._bIgnoreChanges=false;this._aOngoingChangeAppliance=[];this._bSearchTriggered=false;this._bIgnoreQueuing=false};S.prototype._createInnerLayout=function(){this._cLayoutItem=null;this._oFilterBarLayout=null;this._btnAdapt=null;this.setAggregation("layout",this._oFilterBarLayout,true)};S.prototype._isPhone=function(){return n.system.phone?true:false};S.prototype._isLiveMode=function(){if(this._isPhone()){return false}return this.getLiveMode()};S.prototype._getConditionModel=function(){return this._oConditionModel};S.prototype._getSearchButton=function(){if(!this._btnSearch){this._btnSearch=new b(this.getId()+"-btnSearch",{text:this._oRb.getText("filterbar.GO"),press:this.onSearch.bind(this),type:P.Emphasized});i.addConfig(this._btnSearch,{addAccessibilityLabel:true,message:this._oRb.getText("filterbar.GoBtnShortCutHint")},this)}return this._btnSearch};S.prototype.getConditionModelName=function(){return this._getConditionModelName()};S.prototype._getConditionModelName=function(){return S.CONDITION_MODEL_NAME};S.prototype._createConditionModel=function(){this._oConditionModel=new h;this.setModel(this._oConditionModel,this._getConditionModelName())};S.prototype.applySettings=function(t,e){this._setPropertyHelperClass(f);this._setupPropertyInfoStore("propertyInfo");this._applySettings(t,e);Promise.all([this.awaitPropertyHelper()]).then(function(){if(!this._bIsBeingDestroyed){this._applyInitialFilterConditions()}}.bind(this))};S.prototype._applySettings=function(t,e){r.prototype.applySettings.apply(this,arguments);this._createConditionModel();this._oConditionModel.attachPropertyChange(this._handleConditionModelPropertyChange,this)};S.prototype._waitForMetadata=function(){return this._retrieveMetadata().then(function(){this._applyInitialFilterConditions()}.bind(this))};S.prototype.setIgnoreQueuing=function(t){this._bIgnoreQueuing=t};S.prototype.getIgnoreQueuing=function(){return this._bIgnoreQueuing};S.prototype.setSuspendSelection=function(t){this.setProperty("suspendSelection",t);if(!t){if(this._bSearchTriggered&&!this.getIgnoreQueuing()){this.triggerSearch()}this._bSearchTriggered=false;this.setIgnoreQueuing(false)}return this};S.prototype._createInnerModel=function(){this._oModel=new a(this);this.setModel(this._oModel,S.INNER_MODEL_NAME);return this};S.prototype.getCurrentState=function(){const t={};t.filter=s({},this.getFilterConditions());const e=this.getFilterItems();const i=[];e.forEach(function(t){i.push({name:t.getPropertyKey()})});t.items=i;return t};S.prototype.getAssignedFilterNames=function(){let t,e=null;const i=this._getConditionModel();if(i){e=[];const n=i.getConditions("$search");if(n&&n.length>0){e.push(this._oRb.getText("filterbar.ADAPT_SEARCHTERM"))}this._getNonHiddenPropertyInfoSet().forEach(function(n){t=p.getPropertyKey(n);const r=i.getConditions(t);if(r&&r.length>0){e.push(n.label||t)}})}return e};S.prototype._getAssignedFiltersText=function(){const t={};t.filtersText=this._getAssignedFiltersCollapsedText(this.getAssignedFilterNames());t.filtersTextExpanded=this._getAssignedFiltersExpandedText();return t};S.prototype._getAssignedFiltersExpandedText=function(){let t=0,e=0;const i=this._getConditionModel();if(i){const n=i.getAllConditions();for(const i in n){const r=this._getPropertyByName(i);if(r&&!r.hiddenFilter&&n[i].length>0){++t;if(!(i==="$search"&&this.getAggregation("basicSearchField")||this._getFilterField(i))){++e}}}}if(!t&&!e){return this._oRb.getText("filterbar.ADAPT_NOTFILTERED")}if(!e){if(t===1){return this._oRb.getText("filterbar.ADAPT_FILTER_WITH_NON_HIDDEN",[t])}return this._oRb.getText("filterbar.ADAPT_FILTERS_WITH_NON_HIDDEN",[t])}if(t===1){return this._oRb.getText("filterbar.ADAPT_FILTER_WITH_HIDDEN",[t,e])}return this._oRb.getText("filterbar.ADAPT_FILTERS_WITH_HIDDEN",[t,e])};S.prototype._getAssignedFiltersCollapsedText=function(t){let e;t=t||[];if(t.length){e=Object.keys(t).map(function(e){return t[e]}).join(", ");if(t.length===1){return this._oRb.getText("filterbar.ADAPT_FILTER_COLLAPSED",[t.length,e])}return this._oRb.getText("filterbar.ADAPT_FILTERS_COLLAPSED",[t.length,e])}return this._oRb.getText("filterbar.ADAPT_NOTFILTERED")};S.prototype.getAssignedFiltersText=function(){return this._getAssignedFiltersText()};S.prototype._reportModelChange=function(t){if(t.triggerFilterUpdate){this._handleAssignedFilterNames(false)}if(this.getLiveMode()||t.triggerSearch||this._bExecuteOnSelect){this._bExecuteOnSelect=false;this.triggerSearch()}else if(t.recheckMissingRequired){this._recheckMissingRequiredFields()}};S.prototype.getPropertyInfoSet=function(){return this.getPropertyHelper()?this.getPropertyHelper().getProperties():[]};S.prototype._addConditionChange=function(t){this._aOngoingChangeAppliance.push(this.getEngine().createChanges({control:this,applySequentially:true,applyAbsolute:true,key:"Filter",state:t}))};S.prototype._handleConditionModelPropertyChange=function(t){let e;const i=function(t,e){const i={};i[t]=this._stringifyConditions(t,s([],e));this._cleanupConditions(i[t]);return i}.bind(this);if(!this._bIgnoreChanges){const n=t.getParameter("path");if(n.indexOf("/conditions/")===0){const r=n.substring("/conditions/".length);const o=t.getParameter("value");if(this._getPropertyByName(r)){e=i(r,o)}else{e=this._retrieveMetadata().then(function(){return i(r,o)})}}}if(e){this._addConditionChange(e)}};S.prototype._toExternal=function(t,e){let i=s({},e);i=c.toString(i,t.typeConfig.typeInstance,this.getTypeMap());this._cleanupCondition(i);this._convertInOutParameters(e,i,"inParameters",c.toString);this._convertInOutParameters(e,i,"outParameters",c.toString);return i};S.prototype._toInternal=function(t,e){let i=s({},e);i=c.toType(i,t.typeConfig.typeInstance,this.getTypeMap());this._convertInOutParameters(e,i,"inParameters",c.toType);this._convertInOutParameters(e,i,"outParameters",c.toType);return i};S.prototype._convertInOutParameters=function(t,e,i,n){if(t[i]&&Object.keys(t[i]).length>0){Object.keys(t[i]).forEach(function(r){const s=r.startsWith("conditions/")?r.slice(11):r;const a=this._getPropertyByName(s);if(a){const o=d.createCondition(y.EQ,[t[i][r]]);const l=n(o,a.typeConfig.typeInstance,this.getTypeMap());if(!e[i]){e[i]={}}if(!r.startsWith("conditions/")){delete e[i][r];r="conditions/"+s}e[i][r]=l.values[0]}else{o.error("mdc.FilterBar._convertInOutParameters: could not find property for '"+s+"'")}}.bind(this))}};S.prototype._cleanupCondition=function(t){if(t){if(t.hasOwnProperty("isEmpty")){delete t.isEmpty}}};S.prototype._cleanupConditions=function(t){if(t){t.forEach(function(t){this._cleanupCondition(t)},this)}};S.prototype._stringifyCondition=function(t,e){let i=e;if(e&&e.values){if(e.values.length>0){i=this._toExternal(t,e)}else{i=s({},e);this._cleanupCondition(i)}}return i};S.prototype._stringifyConditions=function(t,e){const i=this._getPropertyByName(t);let n=e;if(i&&e){n=[];e.forEach(function(t){n.push(this._stringifyCondition(i,t))},this)}return n};S.prototype._internalizeConditions=function(t){const e=s({},t);Object.keys(e).forEach(function(t){e[t].forEach(function(i,n){const r=this._getPropertyByName(t);if(r){try{e[t][n]=this._toInternal(r,i)}catch(t){o.error(t.message)}}else{o.error("Property '"+t+"' does not exist")}},this)},this);return e};S.prototype._handleAssignedFilterNames=function(t){if(this._bIsBeingDestroyed){return}if(!t){if(this._btnAdapt){const t=this.getAssignedFilterNames();this.setProperty("_filterCount",this._oRb.getText(t.length?"filterbar.ADAPT_NONZERO":"filterbar.ADAPT",[t.length]),false)}}const e=this._getAssignedFiltersText();const i={conditionsBased:!t&&!this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch,filtersText:e.filtersText,filtersTextExpanded:e.filtersTextExpanded};this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch=false;this.fireFiltersChanged(i)};S.prototype.onReset=function(t){this._getConditionModel().removeAllConditions()};S.prototype.onSearch=function(t){if(!this._bSearchPressed){this._bSearchPressed=true;this._sReason=g.Go;this.triggerSearch().then(function(){this._bSearchPressed=false}.bind(this),function(){this._bSearchPressed=false}.bind(this))}};S.prototype.triggerSearch=function(){if(this.getSuspendSelection()){this._bSearchTriggered=true;return Promise.resolve()}return this.validate()};S.prototype._hasRetrieveMetadataToBeCalled=function(){return this.getPropertyHelper()===null||this.getPropertyHelper().getProperties().length===0&&!this.isPropertyHelperFinal()};S.prototype.validate=function(t){const e=!t;const i=function(){if(!this._oValidationPromise){this._oValidationPromise=new Promise(function(t,e){this._fResolvedSearchPromise=t;this._fRejectedSearchPromise=e}.bind(this));const t=function(){this._validate(e)};setTimeout(t.bind(this),0)}return this._oValidationPromise}.bind(this);return this.waitForInitialization().then(function(){if(this._hasRetrieveMetadataToBeCalled()){return this._retrieveMetadata().then(function(){return i()})}else{return i()}}.bind(this))};S.prototype._clearDelayedSearch=function(){if(this._iDelayedSearchId){clearTimeout(this._iDelayedSearchId);this._iDelayedSearchId=null}};S.prototype._checkAsyncValidation=function(){let t=_.NoError;if(this._aFIChanges&&this._aFIChanges.length>0){t=_.AsyncValidation}return t};S.prototype._checkOngoingChangeAppliance=function(){let t=_.NoError;if(this._aOngoingChangeAppliance&&this._aOngoingChangeAppliance.length>0){t=_.OngoingChangeAppliance}return t};S.prototype._getRequiredFilterFieldValueText=function(t){if(t){return this._oRb.getText("filterbar.REQUIRED_FILTER_VALUE_MISSING",[t.getLabel()])}else{return""}};S.prototype._recheckMissingRequiredFields=function(){this.getFilterItems().forEach(function(t){let e;if(t){if(t.getValueState()!==I.None&&t.getValueStateText()===this._getRequiredFilterFieldValueText(t)){if(!e){e=u.getRequiredFieldNamesWithoutValues(this)}if(e.indexOf(t.getPropertyKey())<0){t.setValueState(I.None)}}}}.bind(this))};S.prototype._checkRequiredFields=function(){let t=_.NoError;const e=u.getRequiredFieldNamesWithoutValues(this);e.forEach(function(e){const i=this._getFilterField(e);if(i){if(i.getValueState()===I.None){i.setValueState(I.Error);i.setValueStateText(this._getRequiredFilterFieldValueText(i))}}else{o.error("Mandatory filter field '"+e+"' not visible on FilterBarBase has no value.")}t=_.RequiredHasNoValue}.bind(this));return t};S.prototype._checkFieldsInErrorState=function(){let t=_.NoError;if(this._bFieldInErrorState){return _.FieldInErrorState}this.getFilterItems().some(function(e){if(e&&e.getValueState()!==I.None){if(e.getValueStateText()!==this._getRequiredFilterFieldValueText(e)){t=_.FieldInErrorState}}return t!==_.NoError}.bind(this));return t};S.prototype._hasAppliancePromises=function(){return this._aOngoingChangeAppliance&&this._aOngoingChangeAppliance.length>0?this._aOngoingChangeAppliance.slice():null};S.prototype._handleFilterItemSubmit=function(t){const e=t.getParameter("promise");if(e){this._sReason=g.Enter;e.then(function(){const t=this._hasAppliancePromises();if(!t){this.triggerSearch()}else{Promise.all(t).then(function(){if(!this.getLiveMode()){this.triggerSearch()}}.bind(this))}}.bind(this)).catch(function(t){o.error(t);this.triggerSearch().catch(function(t){})}.bind(this))}};S.prototype._handleFilterItemChanges=function(t){if(this._bIgnoreChanges){return}const e=t.oSource;if(e.getRequired()&&e.getValueState()===I.Error&&t.getParameter("valid")){e.setValueState(I.None);return}if(!this._aFIChanges){this._aFIChanges=[]}const i=e.getPropertyKey();this._aFIChanges.some(function(t,e){if(t.name===i){this._aFIChanges.splice(e,1);return true}return false}.bind(this));this._aFIChanges.push({name:i,promise:t.getParameter("promise")})};S.prototype.checkFilters=function(){let t=this._checkAsyncValidation();if(t!==_.NoError){return t}t=this._checkOngoingChangeAppliance();if(t!==_.NoError){return t}t=this._checkFieldsInErrorState();if(t!==_.NoError){return t}t=this._checkRequiredFields();if(t!==_.NoError){return t}return t};S.prototype._setFocusOnFirstErroneousField=function(){let t=null;this.getFilterItems().some(function(e){if(e.getValueState()!==I.None){t=e;setTimeout(e["focus"].bind(e),0)}return t!=null});return t};S.prototype._handleAsyncValidation=function(t,e){if(!e){e=this._validate.bind(this)}if(this._aFIChanges&&this._aFIChanges.length>0){const i=this._aFIChanges.slice();this._aFIChanges=null;const n=[];i.forEach(function(t){n.push(t.promise)});Promise.all(n).then(function(n){n.forEach(function(t,e){const n=this._getFilterField(i[e].name);if(n&&n.getRequired()&&n.getValueState()===I.Error){n.setValueState(I.None)}},this);e(t)}.bind(this),function(){this._bFieldInErrorState=true;e(t)}.bind(this)).catch(function(i){this._bFieldInErrorState=true;e(t)}.bind(this))}};S.prototype._handleOngoingChangeAppliance=function(t,e){if(!e){e=this._validate.bind(this)}if(this._aOngoingChangeAppliance&&this._aOngoingChangeAppliance.length>0){const i=this._aOngoingChangeAppliance.slice();this._aOngoingChangeAppliance=[];Promise.all(i).then(function(){const i=this._oApplyingChanges?this._oApplyingChanges:Promise.resolve();i.then(()=>e(t))}.bind(this),function(){this._bFieldInErrorState=true;e(t)}.bind(this)).catch(function(i){this._bFieldInErrorState=true;e(t)}.bind(this))}};S.prototype._determineValidationState=function(){return this.awaitControlDelegate().then(function(t){return t.determineValidationState(this,this.checkFilters())}.bind(this))};S.prototype._visualizeValidationState=function(t){if(this._oDelegate){this._oDelegate.visualizeValidationState(this,{status:t})}};S.prototype.getText=function(t){return this._oRb.getText(t)};S.prototype._restartCheckAndNotify=function(t){const e=this.checkFilters();this._checkAndNotify(t,e)};S.prototype._checkAndNotify=function(t,e){const i=function(){if(t){const t={reason:this._sReason?this._sReason:g.Unclear};this._sReason=g.Unclear;this.fireSearch(t)}}.bind(this);const n=function(){this._bFieldInErrorState=false;this._oValidationPromise=null;this._fRejectedSearchPromise=null;this._fResolvedSearchPromise=null}.bind(this);if(e===_.AsyncValidation){this._handleAsyncValidation(t,this._restartCheckAndNotify.bind(this));return}if(e===_.OngoingChangeAppliance){this._handleOngoingChangeAppliance(t,this._restartCheckAndNotify.bind(this));return}if(e===_.NoError){if(this._fResolvedSearchPromise){i();this._fResolvedSearchPromise()}}else if(this._fRejectedSearchPromise){this._setFocusOnFirstErroneousField();this._fRejectedSearchPromise()}this._visualizeValidationState(e);n()};S.prototype._validate=function(t){const e=function(){this._oValidationPromise=null;this._fRejectedSearchPromise=null;this._fResolvedSearchPromise=null}.bind(this);if(this.bIsDestroyed){e();return}this._determineValidationState().then(function(e){this._checkAndNotify(t,e)}.bind(this))};S.prototype.setInternalConditions=function(t){const e=this._getConditionModel();if(e){e.setConditions(t)}};S.prototype.getInternalConditions=function(){return this._getModelConditions(this._getConditionModel(),true)};S.prototype.waitForInitialization=function(){return Promise.all([this._oInitialFiltersAppliedPromise,this._oMetadataAppliedPromise])};S.prototype.initialized=function(){return this.waitForInitialization()};S.prototype.initializedWithMetadata=function(){if(!this._oMetadataAppliedPromise){this._retrieveMetadata()}return this.waitForInitialization()};S.prototype._getModelConditions=function(t,e,i){const n={};if(t){const r=s({},t.getAllConditions());for(const t in r){if(r[t]&&(i||r[t].length>0)){n[t]=r[t];if(!e){this._cleanupConditions(n[t]);const e=this._stringifyConditions(t,n[t]);n[t]=e}}}}return n};S.prototype._isPathKnown=function(t,e){let i,n;if(!this._getPropertyByName(t)){return false}for(i in e["inParameters"]){n=i.startsWith("conditions/")?i.slice(11):i;if(!this._getPropertyByName(n)){return false}}for(i in e["outParameters"]){n=i.startsWith("conditions/")?i.slice(11):i;if(!this._getPropertyByName(n)){return false}}return true};S.prototype._onModifications=function(t){if(t&&t.indexOf("Filter")===-1){return Promise.resolve()}let e;if(!this._oApplyingChanges){this._oApplyingChanges=new Promise(function(t){e=t})}return this._setXConditions(this.getFilterConditions()).then(function(){this._reportModelChange({triggerSearch:false,triggerFilterUpdate:true,recheckMissingRequired:true});e();this._oApplyingChanges=null}.bind(this))};S.prototype._setXConditions=function(t){if(t){let e=true;for(const i in t){const n=t[i];if(!this._isPathKnown(i,n)){e=false;break}}const i=e?Promise.resolve():this._retrieveMetadata();const n=this._getConditionModel();return i.then(function(){const e=this._internalizeConditions(t);const i=this._getModelConditions(n,true);n.detachPropertyChange(this._handleConditionModelPropertyChange,this);try{return this.getEngine().diffState(this,{Filter:i},{Filter:e}).then(function(t){Object.keys(t.Filter).forEach(function(e){t.Filter[e].forEach(function(t){if(t.filtered!==false){n.addCondition(e,t)}else{n.removeCondition(e,t)}})});n.attachPropertyChange(this._handleConditionModelPropertyChange,this)}.bind(this))}catch(t){o.error(t.message);n.attachPropertyChange(this._handleConditionModelPropertyChange,this)}}.bind(this))}else{return Promise.resolve()}};S.prototype._getXConditions=function(){return this._getModelConditions(this._getConditionModel(),false)};S.prototype._getRequiredPropertyNames=function(){const t=[];this._getNonHiddenPropertyInfoSet().forEach(function(e){if(e.required){t.push(p.getPropertyKey(e))}});return t};S.prototype._getNonRequiredPropertyNames=function(){const t=[];this._getNonHiddenPropertyInfoSet().forEach(function(e){if(!e.required){t.push(p.getPropertyKey(e))}});return t};S.prototype._insertFilterFieldtoContent=function(t,e){if(!this._cLayoutItem){return}const i=this._cLayoutItem;const n=new i;n.setFilterField(t);this._oFilterBarLayout.insertFilterField(n,e)};S.prototype._filterItemInserted=function(t){if(!t.getVisible()){return}if(t.setWidth){t.setWidth("")}this._applyFilterItemInserted(t);this._handleAssignedFilterNames(true)};S.prototype._applyFilterItemInserted=function(t){let e;e=this.indexOfAggregation("filterItems",t);if(this.getAggregation("basicSearchField")){e++}const i=e;const n=this.getFilterItems();for(let t=0;t<i;t++){if(!n[t].getVisible()){e--}}this._insertFilterFieldtoContent(t,e);if(!this._oObserver.isObserved(t,{properties:["visible"]})){this._oObserver.observe(t,{properties:["visible"]})}};S.prototype._filterItemRemoved=function(t){this._applyFilterItemRemoved(t.getPropertyKey());this._handleAssignedFilterNames(true)};S.prototype._applyFilterItemRemoved=function(t){this._removeFilterFieldFromContentByName(t)};S.prototype._removeFilterFieldFromContent=function(t){this._removeFilterFieldFromContentByName(t.getPropertyKey())};S.prototype._removeFilterFieldFromContentByName=function(t){const e=this._getFilterItemLayoutByName(t);if(e){this._oFilterBarLayout.removeFilterField(e);e.destroy()}};S.prototype._observeChanges=function(t){if(t.type==="aggregation"){if(t.name==="filterItems"){switch(t.mutation){case"insert":t.child.attachChange(this._handleFilterItemChanges,this);t.child.attachSubmit(this._handleFilterItemSubmit,this);this._filterItemInserted(t.child);break;case"remove":t.child.detachChange(this._handleFilterItemChanges,this);t.child.detachSubmit(this._handleFilterItemSubmit,this);this._filterItemRemoved(t.child);break;default:o.error("operation "+t.mutation+" not yet implemented")}}else if(t.name==="basicSearchField"){switch(t.mutation){case"insert":t.child.attachSubmit(this._handleFilterItemSubmit,this);this._insertFilterFieldtoContent(t.child,0);break;case"remove":t.child.detachSubmit(this._handleFilterItemSubmit,this);this._removeFilterFieldFromContent(t.child);break;default:o.error("operation "+t.mutation+" not yet implemented")}}}else if(t.type==="property"){let e;if(t.object.isA&&t.object.isA("sap.ui.mdc.FilterField")){e=t.object;if(e){if(t.current){this._filterItemInserted(e)}else{this._filterItemRemoved(e)}this._oFilterBarLayout.invalidate()}}}};S.prototype._getFilterItemLayout=function(t){return this._getFilterItemLayoutByName(t.getPropertyKey())};S.prototype._getFilterItemLayoutByName=function(t){let e=null;if(this._oFilterBarLayout){this._oFilterBarLayout.getFilterFields().some(function(i){if(i._getFieldPath()===t){e=i}return e!==null})}return e};S.prototype._getFilterField=function(t){let e=null;this.getFilterItems().some(function(i){if(i&&i.getPropertyKey()===t){e=i}return e!==null});return e};S.prototype._retrieveMetadata=function(){if(this.isPropertyHelperFinal()){return Promise.resolve()}if(this._oMetadataAppliedPromise){return this._oMetadataAppliedPromise}this._fResolveMetadataApplied=undefined;this._oMetadataAppliedPromise=new Promise(function(t,e){this._fResolveMetadataApplied=t;this._fRejectMetadataApplied=e}.bind(this));this.initControlDelegate().then(function(){if(!this._bIsBeingDestroyed){const t=function(t){t?this._fResolveMetadataApplied():this._fRejectMetadataApplied();this._fResolveMetadataApplied=null;this._fRejectMetadataApplied=null}.bind(this);if(this.isControlDelegateInitialized()){this.finalizePropertyHelper().then(function(){t(true)})}else{o.error("Delegate not initialized.");t(false)}}}.bind(this));return this._oMetadataAppliedPromise};S.prototype.setBasicSearchField=function(t){const e=this.getAggregation("basicSearchField");if(e){this.removeAggregation("basicSearchField",e)}this.setAggregation("basicSearchField",t);if(t){if(!this._oObserver.isObserved(t,{properties:["visible"]})){this._oObserver.observe(t,{properties:["visible"]})}}return this};S.prototype._getNonHiddenPropertyInfoSet=function(){const t=[];this.getPropertyInfoSet().every(function(e){if(!e.hiddenFilter){if(p.getPropertyKey(e)!=="$search"){t.push(e)}}return true});return t};S.prototype._getNonHiddenPropertyByName=function(t){let e=null;this._getNonHiddenPropertyInfoSet().some(function(i){if(p.getPropertyKey(i)===t){e=i}return e!=null});return e};S.prototype._cleanUpFilterFieldInErrorStateByName=function(t){let e=null;const i=this.getFilterItems();i.some(function(i){if(i.getPropertyKey()===t){e=i}return e!=null});if(e){this._cleanUpFilterFieldInErrorState(e)}};S.prototype.cleanUpAllFilterFieldsInErrorState=function(){this._getConditionModel().checkUpdate(true);const t=this.getFilterItems();t.forEach(function(t){this._cleanUpFilterFieldInErrorState(t)}.bind(this))};S.prototype._cleanUpFilterFieldInErrorState=function(t){if(t&&t.getValueState()!==I.None){t.setValueState(I.None)}};S.prototype._applyInitialFilterConditions=function(){this._bIgnoreChanges=true;this._applyFilterConditionsChanges().then(function(){this._bIgnoreChanges=false;this._reportModelChange({triggerFilterUpdate:true,triggerSearch:false});this._bInitialFiltersApplied=true;this._fResolveInitialFiltersApplied();this._fResolveInitialFiltersApplied=null}.bind(this))};S.prototype._applyFilterConditionsChanges=function(){let t;const e=this.getProperty("filterConditions");if(Object.keys(e).length>0){t=s({},e);return this._setXConditions(t)}return Promise.resolve()};S.prototype.setVariantBackreference=function(t){if(!this._hasAssignedVariantManagement()){this.setAssociation("variantBackreference",t);m.attachVariantApplied({selector:this,vmControlId:this.getVariantBackreference(),callback:this._handleVariantSwitch.bind(this),callAfterInitialVariant:true})}else{o.error("the association 'variant' may only be assigned once and may not change afterwards.")}};S.prototype._handleVariantSwitch=function(t){this._bExecuteOnSelect=this._getExecuteOnSelectionOnVariant(t);this._sReason=this._bExecuteOnSelect?g.Variant:g.Unclear;this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch=false;if(t.hasOwnProperty("createScenario")&&t.createScenario==="saveAs"){this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch=true}return this.awaitPendingModification().then(function(t){this.cleanUpAllFilterFieldsInErrorState();if(this._bInitialFiltersApplied&&t.indexOf("Filter")===-1){this._reportModelChange({triggerFilterUpdate:false,triggerSearch:this._bExecuteOnSelect})}}.bind(this))};S.prototype._getExecuteOnSelectionOnVariant=function(t){let e=false;const i=this._getAssignedVariantManagement();if(i){e=i.getApplyAutomaticallyOnVariant(t)}return e};S.prototype._hasAssignedVariantManagement=function(){return this._getAssignedVariantManagement()?true:false};S.prototype._getAssignedVariantManagement=function(){const t=this.getVariantBackreference();if(t){const e=sap.ui.getCore().byId(t);if(e&&e.isA("sap.ui.fl.variants.VariantManagement")){return e}}return null};S.prototype._getView=function(){return p.getView(this)};S.prototype.getConditions=function(){const t=this.getCurrentState().filter;if(t&&t["$search"]){delete t["$search"]}return t};S.prototype.getSearch=function(){const t=this._getConditionModel()?this._getConditionModel().getConditions("$search"):[];return t[0]?t[0].values[0]:""};S.prototype.exit=function(){if(this._hasAssignedVariantManagement()){m.detachVariantApplied({selector:this,vmControlId:this.getVariantBackreference()})}if(this.isControlDelegateInitialized()&&this.getControlDelegate().cleanup){this.getControlDelegate().cleanup(this)}r.prototype.exit.apply(this,arguments);this._clearDelayedSearch();this._oFilterBarLayout=null;this._cLayoutItem=null;this._btnAdapt=undefined;this._btnSearch=undefined;this._oRb=null;if(this._oModel){this._oModel.destroy();this._oModel=null}if(this._oConditionModel){this._oConditionModel.detachPropertyChange(this._handleConditionModelPropertyChange,this);this._oConditionModel.destroy();this._oConditionModel=null}this._oObserver.disconnect();this._oObserver=undefined;this._oDelegate=null;this._oFlexPromise=null;this._fResolveMetadataApplied=undefined;this._oMetadataAppliedPromise=null;this._oInitialFiltersAppliedPromise=null;this._oValidationPromise=null;this._aBindings=null;this._aFIChanges=null;this._aOngoingChangeAppliance=null};return S});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/FilterBarBaseRenderer", [],function(){"use strict";const t={apiVersion:2};t.CSS_CLASS="sapUiMdcFilterBarBase";t.render=function(e,i){e.openStart("div",i);e.class(t.CSS_CLASS);if(i.isA("sap.ui.mdc.filterbar.p13n.AdaptationFilterBar")&&i.getProperty("_useFixedWidth")){e.style("width",i.getWidth())}e.openEnd();const n=i.getAggregation("layout")?i.getAggregation("layout").getInner():null;e.renderControl(n);e.close("div")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/IFilterContainer", ["sap/ui/core/Element"],function(t){"use strict";const o=t.extend("sap.ui.mdc.filterbar.IFilterContainer");o.prototype.init=function(){t.prototype.init.apply(this,arguments);this.oLayout=null};o.prototype.getInner=function(){return this.oLayout};o.prototype.insertFilterField=function(t,o){};o.prototype.removeFilterField=function(t){};o.prototype.getFilterFields=function(){};o.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this.oLayout){this.oLayout.destroy();this.oLayout=null}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/PropertyHelper", ["../util/PropertyHelper"],function(e){"use strict";const t=e.extend("sap.ui.mdc.filterbar.PropertyHelper",{constructor:function(t,r){e.call(this,t,r,{required:{type:"boolean"},hiddenFilter:{type:"boolean"}})}});t.prototype.prepareProperty=function(t){if(!t.typeConfig){const e=this.getParent();if(e&&e._oDelegate){const r=e._oDelegate.getTypeMap(e);try{t.typeConfig=r.getTypeConfig(t.dataType,t.formatOptions,t.constraints)}catch(e){}}}e.prototype.prepareProperty.apply(this,arguments)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/aligned/FilterContainer", ["sap/ui/mdc/filterbar/IFilterContainer","sap/ui/layout/AlignedFlowLayout","sap/ui/layout/VerticalLayout","sap/ui/layout/HorizontalLayout","sap/m/Text","sap/ui/core/Configuration"],function(t,o,i,e,n,a){"use strict";const u=t.extend("sap.ui.mdc.filterbar.aligned.FilterContainer");u.prototype.init=function(){t.prototype.init.apply(this,arguments);this.oLayout=new o};u.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this._oButtonsLayout){this._oButtonsLayout=null}};u.prototype.addButton=function(t){if(!this._oButtonsLayout){this._oButtonsLayout=new i;if(a.getRTL()){this._oButtonsLayout.addStyleClass("sapUiMdcFilterBarBaseFloatLeft")}else{this._oButtonsLayout.addStyleClass("sapUiMdcFilterBarBaseFloatRight")}this._oButtonsLayout.addContent(new n);this._oButtonsLayout.addContent(new e);this.oLayout.addEndContent(this._oButtonsLayout)}this._oButtonsLayout.getContent()[1].addContent(t)};u.prototype.insertFilterField=function(t,o){this.oLayout.insertContent(t,o)};u.prototype.removeFilterField=function(t){this.oLayout.removeContent(t)};u.prototype.getFilterFields=function(){return this.oLayout.getContent()};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/aligned/FilterItemLayout", ["sap/ui/layout/VerticalLayout","sap/ui/layout/VerticalLayoutRenderer","sap/m/Label"],function(e,t,i){"use strict";const l=e.extend("sap.ui.mdc.filterbar.aligned.FilterItemLayout",{metadata:{library:"sap.ui.mdc"},renderer:{apiVersion:2,render:t.render}});l.prototype._setLabel=function(e){this._oLabel=new i(e.getId()+"-label");this._oLabel.setParent(this);e.connectLabel(this._oLabel);if(this._getFieldPath()==="$search"){this._oLabel.setText(" ")}else{this._oLabel.addStyleClass("sapUiMdcFilterBarBaseLabel")}};l.prototype._getFilterField=function(){return this._oFilterField};l.prototype._getFieldPath=function(){return this._oFilterField?this._oFilterField.getPropertyKey():null};l.prototype.setFilterField=function(e){this._oFilterField=e;this._setLabel(e)};l.prototype.getContent=function(){const e=[];e.push(this._oLabel);e.push(this._oFilterField);return e};l.prototype.exit=function(){this._oFilterField=null;if(this._oLabel&&!this._oLabel.bIsDestroyed){this._oLabel.destroy();this._oLabel=undefined}e.prototype.exit.apply(this,arguments)};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/p13n/AdaptationFilterBar", ["sap/ui/core/library","sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/mdc/p13n/subcontroller/AdaptFiltersController","sap/ui/mdc/filterbar/p13n/GroupContainer","sap/ui/mdc/filterbar/p13n/FilterColumnLayout","sap/ui/mdc/filterbar/p13n/FilterGroupLayout","sap/ui/mdc/filterbar/p13n/TableContainer","sap/ui/mdc/filterbar/FilterBarBase","sap/ui/mdc/filterbar/FilterBarBaseRenderer","sap/base/util/merge","sap/ui/core/Core","sap/m/p13n/enum/PersistenceMode"],function(t,e,i,n,o,r,a,s,l,p,h,c){"use strict";const u=t.ValueState;const d=s.extend("sap.ui.mdc.filterbar.p13n.AdaptationFilterBar",{metadata:{library:"sap.ui.mdc",properties:{_useFixedWidth:{type:"boolean",defaultValue:false,visibility:"hidden"}},associations:{adaptationControl:{type:"sap.ui.mdc.Control",multiple:false}},events:{change:{}}},renderer:l});d.prototype.WIDTH="30rem";d.prototype.getVerticalScrolling=function(){return this._oFilterBarLayout.getInner().getVerticalScrolling instanceof Function?this._oFilterBarLayout.getInner().getVerticalScrolling():false};d.prototype.init=function(){s.prototype.init.apply(this,arguments);this.addStyleClass("sapUIAdaptationFilterBar");this.getEngine().defaultProviderRegistry.attach(this,c.Transient);this._fnResolveAdaptationControlPromise=null;this._oAdaptationControlPromise=new Promise(function(t,e){this._fnResolveAdaptationControlPromise=t}.bind(this))};d.prototype.keepAlive=function(){return true};d.prototype._onModifications=function(){const t=s.prototype._onModifications.apply(this,arguments);if(this._oFilterBarLayout.getInner().isA("sap.ui.mdc.p13n.panels.FilterPanel")){const t=this._oFilterBarLayout.getInner().getP13nData();this._updateActiveStatus(t);this._oFilterBarLayout.setP13nData({items:t})}this.fireChange();return t};d.prototype.getInitialFocusedControl=function(){return this._oFilterBarLayout.getInitialFocusedControl()};d.prototype.getWidth=function(){return this.WIDTH};d.prototype.applySettings=function(){s.prototype._applySettings.apply(this,arguments);this._waitForAdaptControlAndPropertyHelper().then(function(){this._initControlDelegate()}.bind(this))};d.prototype.setVisibleFields=function(t){const e=this._getAdaptationControlInstance();if(this._checkAdvancedParent(e)){throw new Error("Only supported for simple parents")}this._aVisibleKeys=t};d.prototype._getPropertyByName=function(t){let e=s.prototype._getPropertyByName.apply(this,arguments);const i=this.getPropertyHelper();if(!e||e.filterable===false){e=i.getProperties().find(function(e){return e.path===t&&e.filterable})}return e};d.prototype._waitForAdaptControlAndPropertyHelper=function(){return this._oAdaptationControlPromise.then(function(){return this._getAdaptationControlInstance().awaitPropertyHelper().then(function(t){this._oPropertyHelper=t}.bind(this))}.bind(this))};d.prototype._initControlDelegate=function(){return this.initControlDelegate().then(function(){if(!this._bIsBeingDestroyed){this._applyInitialFilterConditions()}}.bind(this))};d.prototype.getControlDelegate=function(){return this._getAdaptationControlInstance().getControlDelegate()};d.prototype.initControlDelegate=function(){return this._oAdaptationControlPromise.then(function(){return this._getAdaptationControlInstance().initControlDelegate()}.bind(this))};d.prototype.awaitControlDelegate=function(){return this._oAdaptationControlPromise.then(function(){return this._getAdaptationControlInstance().awaitControlDelegate()}.bind(this))};d.prototype.initPropertyHelper=function(){return this._oAdaptationControlPromise.then(function(){return this._getAdaptationControlInstance().initPropertyHelper()}.bind(this))};d.prototype.finalizePropertyHelper=function(){return this._oAdaptationControlPromise.then(function(){return this._getAdaptationControlInstance().finalizePropertyHelper()}.bind(this))};d.prototype.getTypeUtil=function(){return this.getTypeMap()};d.prototype.getTypeMap=function(){if(!this._getAdaptationControlInstance()){throw new Error("No adaptation control assigned yet.")}return this._getAdaptationControlInstance().getTypeMap()};d.prototype.setMessageStrip=function(t){this._oFilterBarLayout.setMessageStrip(t)};d.prototype.setLiveMode=function(t,e){s.prototype.setLiveMode.apply(this,arguments);this._oConditionModel.attachPropertyChange(function(t){const e=t.getParameter("path").substring(12);if(this.oAdaptationData){const t=this.oAdaptationData.items;const i=t.find(function(t){return t.name==e});if(i&&this._checkAdvancedParent(this._getAdaptationControlInstance())){i.active=this._getConditionModel().getConditions(e).length>0?true:false}}}.bind(this));return this};d.prototype._retrieveMetadata=function(){return this._oAdaptationControlPromise.then(function(){return this._getAdaptationControlInstance().awaitPropertyHelper().then(function(t){if(!this._getAdaptationControlInstance().isPropertyHelperFinal()){return this.finalizePropertyHelper()}return s.prototype._retrieveMetadata.apply(this,arguments)}.bind(this))}.bind(this))};d.prototype.isControlDelegateInitialized=function(){return this._getAdaptationControlInstance().isControlDelegateInitialized()};d.prototype.createConditionChanges=function(){return Promise.all([this._oAdaptationControlPromise,this.awaitControlDelegate()]).then(function(){const t=this._getModelConditions(this._getConditionModel(),false,true);return this.getEngine().createChanges({control:this._getAdaptationControlInstance(),applyAbsolute:true,key:"Filter",state:t,suppressAppliance:true})}.bind(this))};d.prototype.setP13nData=function(t){this.oAdaptationData=t;this._getConditionModel().checkUpdate(true);this._updateActiveStatus(this.oAdaptationData.items);this._oFilterBarLayout.update(t)};d.prototype._updateActiveStatus=function(t){const e=this.getFilterConditions();t.forEach(function(t){const i=this.mFilterFields&&this.mFilterFields[t.name];if(i){const n=i.getPropertyKey();if(e[n]&&e[n].length>0){t.active=true}}}.bind(this))};d.prototype.getP13nData=function(){if(this._aVisibleKeys&&this._aVisibleKeys.length>0){this.oAdaptationData.items.forEach(function(t){if(this._aVisibleKeys.indexOf(t.name)>-1){t.active=true}},this)}return this.oAdaptationData};d.prototype._handleFilterItemSubmit=function(){return};d.prototype._getWaitForChangesPromise=function(){return this.getEngine().waitForChanges(this._getAdaptationControlInstance())};d.prototype.createFilterFields=function(){return this.initializedWithMetadata().then(function(){const t=this._getAdaptationControlInstance().getFilterConditions();this.setFilterConditions(t);const e=this._setXConditions(t);if(this._bFilterFieldsCreated){return e.then(function(){this._oFilterBarLayout.setP13nData(this.getP13nData());return this}.bind(this))}const i=this._getAdaptationControlInstance();const n=i.getControlDelegate();const o=this._checkAdvancedParent(i)?n:n.getFilterDelegate();this._mOriginalsForClone={};this.mFilterFields={};const r=[];this.getP13nData().items.forEach(function(t,e){const n=this._checkExisting(t,o);n.then(function(e){let o;if(this._checkAdvancedParent(i)){if(e._bTemporaryOriginal){delete n._bTemporaryOriginal;this._mOriginalsForClone[e.getPropertyKey()]=e}o=e.clone();if(i._handleFilterItemChanges){o.detachChange(i._handleFilterItemChanges,i)}if(i._handleFilterItemSubmit){o.detachSubmit(i._handleFilterItemSubmit,i)}if(o.getValueState()!==u.None){o.setValueState(u.None);o.setValueStateText()}}else{o=e}this.mFilterFields[t.name]=o}.bind(this));r.push(n)}.bind(this));return Promise.all(r).then(function(){const t=this.getP13nData();t.items.forEach(function(t){this.addAggregation("filterItems",this.mFilterFields[t.name])}.bind(this));this._updateActiveStatus(t.items);this._oFilterBarLayout.setP13nData(t);this._bFilterFieldsCreated=true;return this}.bind(this))}.bind(this))};d.prototype._checkExisting=function(t,e){let i;const n=this._getAdaptationControlInstance();const o=this._checkAdvancedParent(n)?n.getFilterItems():[];const r=o.reduce(function(t,e){t[e.getPropertyKey()]=e;return t},{});if(r[t.name]){i=Promise.resolve(r[t.name])}else{i=e.addItem(this._getAdaptationControlInstance(),t.name);i=i.then(function(e){if(!e){throw new Error("No FilterField could be created for property: '"+t.name+"'.")}e._bTemporaryOriginal=true;return e})}return i};d.prototype.executeRemoves=function(){const t=this._oFilterBarLayout.getInner().getSelectedFields();const e=[];Object.keys(this._mOriginalsForClone).forEach(function(i){const n=this._getAdaptationControlInstance().getControlDelegate();if(t.indexOf(i)<0){const t=n.removeItem.call(n,this._getAdaptationControlInstance(),i).then(function(t){if(t&&this._mOriginalsForClone[i]){this._mOriginalsForClone[i].destroy();delete this._mOriginalsForClone[i]}}.bind(this));e.push(t)}}.bind(this));return Promise.all(e)};d.prototype._checkAdvancedParent=function(t){if(!t.isA("sap.ui.mdc.IFilterSource")&&!t.isA("sap.ui.mdc.IFilter")){throw new Error("The 'adaptationControl' needs to implement the IFilterSource or IFilter interface")}return t.isA("sap.ui.mdc.IFilter")};d.prototype.setAdaptationControl=function(t,e){if(this._fnResolveAdaptationControlPromise){this._fnResolveAdaptationControlPromise();this._fnResolveAdaptationControlPromise=null}this.setAssociation("adaptationControl",t,e);this._cLayoutItem=r;this._oFilterBarLayout=this._checkAdvancedParent(t)?new n:new a;this._oFilterBarLayout.getInner().setParent(this);this.setAggregation("layout",this._oFilterBarLayout,true);if(this._oFilterBarLayout.getInner().attachChange){this._oFilterBarLayout.getInner().attachChange(function(t){if(t.getParameter("reason")==="Remove"){const e=t.getParameter("item");const i={};i[this.mFilterFields[e.name].getPropertyKey()]=[];return this.getEngine().createChanges({control:this,applyAbsolute:true,key:"Filter",state:i})}this.fireChange()}.bind(this))}return this};d.prototype._getAdaptationControlInstance=function(){const t=this.getAdaptationControl();return t&&h.byId(t)};d.prototype.exit=function(){this.getEngine().defaultProviderRegistry.detach(this);s.prototype.exit.apply(this,arguments);for(const t in this._mOriginalsForClone){this._mOriginalsForClone[t].destroy()}this._mOriginalsForClone=null;this.oAdaptationData=null;this.mFilterFields=null;this._fnResolveAdaptationControlPromise=null;this._oAdaptationControlPromise=null};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/p13n/FilterColumnLayout", ["sap/m/ColumnListItem","sap/m/ColumnListItemRenderer","sap/m/Label"],function(t,e,i){"use strict";const r=t.extend("sap.ui.mdc.filterbar.p13n.FilterColumnLayout",{metadata:{library:"sap.ui.mdc"},renderer:e});r.prototype._getFieldPath=function(){return this._oFilterField?this._oFilterField.getPropertyKey():null};r.prototype.setFilterField=function(t){this._oFilterField=t;this._sLabel=t.getLabel()};r.prototype.getCells=function(){const t=[];const e=new i({text:this._sLabel});e.setParent(this);t.push(e);t.push(this._oFilterField);return t};r.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._oFilterField=null};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/p13n/FilterGroupLayout", ["sap/ui/core/Control"],function(t){"use strict";const e=t.extend("sap.ui.mdc.filterbar.p13n.FilterGroupLayout",{renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e);t.style("height","100%");t.openEnd();t.renderControl(e.getItems()[0]);t.close("div")}}});e.prototype._getFieldPath=function(){return this._oFilterField?this._oFilterField.getPropertyKey():null};e.prototype.setFilterField=function(t){this._oFilterField=t};e.prototype.getIdForLabel=function(){return this._oFilterField&&this._oFilterField.getIdForLabel()};e.prototype.getAccessibilityInfo=function(){return{children:this.getItems()}};e.prototype.getItems=function(){const t=[];t.push(this._oFilterField);return t};e.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._oFilterField=null};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/p13n/GroupContainer", ["sap/ui/mdc/filterbar/IFilterContainer","sap/ui/mdc/p13n/panels/AdaptFiltersPanel"],function(t,e){"use strict";const i=t.extend("sap.ui.mdc.filterbar.p13n.GroupContainer");i.prototype.init=function(){t.prototype.init.apply(this,arguments);this.mFilterItems={};this.oLayout=new e;this.oLayout.setItemFactory(function(t){const e=t.getProperty(t.sPath).name;const i=this.mFilterItems[e];return i}.bind(this))};i.prototype.setMessageStrip=function(t){this.oLayout.getCurrentViewContent().setMessageStrip(t)};i.prototype.insertFilterField=function(t,e){this.mFilterItems[t._getFieldPath()]=t};i.prototype.removeFilterField=function(t){this.oLayout.removeItem(t)};i.prototype.getFilterFields=function(){const t=[];Object.keys(this.mFilterItems).forEach(function(e){t.push(this.mFilterItems[e])}.bind(this));return t};i.prototype.update=function(t){this.oLayout.restoreDefaults()};i.prototype.setP13nData=function(t){this.oLayout.setP13nData(t)};i.prototype.exit=function(){this.mFilterItems=null;this.mFilterFields=null;t.prototype.exit.apply(this,arguments)};i.prototype.getInitialFocusedControl=function(){return this.oLayout.getInitialFocusedControl&&this.oLayout.getInitialFocusedControl()};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/p13n/TableContainer", ["sap/ui/mdc/filterbar/IFilterContainer","sap/m/Table","sap/m/Column","sap/m/Text","sap/m/VBox","sap/ui/mdc/p13n/panels/FilterPanel"],function(t,e,i,o,n,r){"use strict";const a=t.extend("sap.ui.mdc.filterbar.p13n.TableContainer");a.prototype.init=function(){t.prototype.init.apply(this,arguments);const n=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._oTable=new e({sticky:["ColumnHeaders"],growing:true,columns:[new i({header:new o({text:n.getText("filter.AdaptationFilterBar_FIELD_COLUMN")})}),new i({header:new o({text:n.getText("filter.AdaptationFilterBar_FIELD_VALUE_COLUMN")})})]});this.oLayout=new r({enableReorder:false,itemFactory:function(t){const e=t.name;const i=this.mFilterItems[e];return i}.bind(this)});this.mFilterItems={}};a.prototype.insertFilterField=function(t,e){const i=t._oFilterField.getParent();const o=i._getPropertyByName(t._getFieldPath());if(o){this.mFilterItems[o.name]=t}};a.prototype.setP13nData=function(t){this.oLayout.setP13nData(t.items)};a.prototype.removeFilterField=function(t){this._oTable.removeItem(t)};a.prototype.setMessageStrip=function(t){this.oLayout.setMessageStrip(t)};a.prototype.getFilterFields=function(){return this._oTable.getItems()};a.prototype.update=function(t){};a.prototype.exit=function(){this._oTable=null};a.prototype.getInitialFocusedControl=function(){return this.oLayout.getInitialFocusedControl&&this.oLayout.getInitialFocusedControl()};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/vh/CollectiveSearchSelect", ["sap/m/VariantManagement"],function(t){"use strict";const e=t.extend("sap.ui.mdc.filterbar.vh.CollectiveSearchSelect",{metadata:{library:"sap.ui.mdc",properties:{title:{type:"string",group:"Misc",defaultValue:null},selectedItemKey:{type:"string",group:"Misc",defaultValue:null}}},renderer:{renderer:function(e,r){t.getMetadata().getRenderer().render(e,r)}}});e.prototype.init=function(){t.prototype.init.apply(this);this.oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc")};e.prototype.applySettings=function(e,r){t.prototype.applySettings.apply(this,arguments);this.setShowFooter(false);this.setProperty("_selectStategyForSameItem",false);this.oVariantPopoverTrigger.setTooltip(this.oRb.getText("COL_SEARCH_TRIGGER_TT"))};e.prototype.setTitle=function(t){this.setProperty("title",t);this.setPopoverTitle(t);return this};e.prototype.getTitle=function(){return this.getProperty("title")};e.prototype.getCurrentText=function(){return t.prototype.getTitle.apply(this,arguments).getText()};e.prototype.setSelectedItemKey=function(t){this.setProperty("selectedItemKey",t);this.setSelectedKey(t);return this};e.prototype.getSelectedItemKey=function(){return this.getSelectedKey()};e.prototype._setInvisibleText=function(t){this.oVariantInvisibleText.setText(this.oRb.getText("COL_SEARCH_SEL_INVISIBLETXT",[t]))};e.prototype.exit=function(){t.prototype.exit.apply(this);this.oRb=undefined};e.prototype.getOverflowToolbarConfig=function(){const e=t.prototype.getOverflowToolbarConfig.apply(this);e.canOverflow=true;return e};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/vh/FilterBar", ["sap/m/library","sap/ui/mdc/filterbar/FilterBarBase","sap/ui/mdc/filterbar/FilterBarBaseRenderer","sap/ui/mdc/filterbar/aligned/FilterItemLayout","sap/ui/mdc/filterbar/vh/FilterContainer","sap/m/Button","sap/m/p13n/enum/PersistenceMode"],function(t,e,i,r,o,s,l){"use strict";const a=e.extend("sap.ui.mdc.filterbar.vh.FilterBar",{metadata:{library:"sap.ui.mdc",properties:{delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/filterbar/vh/FilterBarDelegate",payload:{modelName:undefined,collectionName:""}}},expandFilterFields:{type:"boolean",defaultValue:true},filterFieldThreshold:{type:"int",defaultValue:8}},aggregations:{}},renderer:i});const h=t.ButtonType;a.prototype._createInnerLayout=function(){this._cLayoutItem=r;this._oFilterBarLayout=new o(this.getId()+"-innerLayout",{});this.setAggregation("layout",this._oFilterBarLayout,true);this._oBtnFilters=new s(this.getId()+"-btnShowFilters",{type:h.Transparent,press:this._onToggleFilters.bind(this)});this._oBtnFilters.bindProperty("text",{model:e.INNER_MODEL_NAME,path:"/expandFilterFields",formatter:function(t){return this._oRb.getText("valuehelp."+(t?"HIDE":"SHOW")+"ADVSEARCH")}.bind(this)});this._oBtnFilters.bindProperty("visible",{model:e.INNER_MODEL_NAME,path:"/filterItems",formatter:function(t){return t.length>0}});this._oFilterBarLayout.addControl(this._getSearchButton().bindProperty("visible",{parts:[{path:"/showGoButton",model:e.INNER_MODEL_NAME},{path:"/liveMode",model:e.INNER_MODEL_NAME}],formatter:function(t,e){return t&&(this._isPhone()?true:!e)}.bind(this)}));this._oFilterBarLayout.addControl(this._oBtnFilters);this._oShowAllFiltersBtn=new s(this.getId()+"-btnShowAllFilters",{type:h.Transparent,press:this._onShowAllFilters.bind(this),text:this._oRb.getText("valuehelp.SHOWALLFILTERS"),visible:false});this._oFilterBarLayout.addEndContent(this._oShowAllFiltersBtn)};a.prototype.init=function(){e.prototype.init.apply(this,arguments);this.getEngine().defaultProviderRegistry.attach(this,l.Transient)};a.prototype.exit=function(){this.getEngine().defaultProviderRegistry.detach(this);if(this._oCollectiveSearch){this._oFilterBarLayout.removeControl(this._oCollectiveSearch);this._oCollectiveSearch=null}e.prototype.exit.apply(this,arguments);this._oBasicSearchField=null;this._oBtnFilters=null;this._oShowAllFiltersBtn=null};a.prototype._onToggleFilters=function(t){this.setExpandFilterFields(!this.getExpandFilterFields())};a.prototype._onShowAllFilters=function(t){this._oFilterBarLayout._updateFilterBarLayout(true)};a.prototype.setCollectiveSearch=function(t){if(this._oCollectiveSearch){if(this._oFilterBarLayout){this._oFilterBarLayout.removeControl(this._oCollectiveSearch)}}this._oCollectiveSearch=t;if(this._oFilterBarLayout&&this._oCollectiveSearch){this._oFilterBarLayout.insertControl(this._oCollectiveSearch,0)}return this};a.prototype.getCollectiveSearch=function(){return this._oCollectiveSearch};a.prototype.destroyCollectiveSearch=function(){if(this._oCollectiveSearch&&this._oFilterBarLayout){this._oFilterBarLayout.removeControl(this._oCollectiveSearch);this._oCollectiveSearch.destroy();this._oCollectiveSearch=undefined}return this};a.prototype.setBasicSearchField=function(t){if(this._oBasicSearchField){if(this._oFilterBarLayout){this._oFilterBarLayout.removeControl(this._oBasicSearchField)}this._oBasicSearchField.detachSubmit(this._handleFilterItemSubmit,this)}this._oBasicSearchField=t;if(t){if(this.isPropertyInitial("expandFilterFields")){this.setExpandFilterFields(false)}if(this._oFilterBarLayout){this._oFilterBarLayout.insertControl(t,this._oCollectiveSearch?1:0)}t.attachSubmit(this._handleFilterItemSubmit,this);if(!this._oObserver.isObserved(t,{properties:["visible"]})){this._oObserver.observe(t,{properties:["visible"]})}}return this};a.prototype.getBasicSearchField=function(){return this._oBasicSearchField};a.prototype.destroyBasicSearchField=function(){if(this._oBasicSearchField&&this._oFilterBarLayout){this._oFilterBarLayout.removeControl(this._oBasicSearchField);this._oBasicSearchField.detachSubmit(this._handleFilterItemSubmit,this);if(this._oObserver.isObserved(this._oBasicSearchField,{properties:["visible"]})){this._oObserver.unobserve(this._oBasicSearchField)}this._oBasicSearchField.destroy();this._oBasicSearchField=undefined}return this};a.prototype.getInitialFocusedControl=function(){let t=this.getBasicSearchField();if(!t&&this.getShowGoButton()){t=this._btnSearch}return t};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/vh/FilterBarDelegate", ["sap/ui/mdc/FilterBarDelegate","sap/ui/core/Core"],function(e,t){"use strict";const r=t.getLibraryResourceBundle("sap.ui.mdc");const i=Object.assign({},e);i.fetchProperties=function(e){const t=e.getParent();let i="$search";if(t&&!t.isPropertyInitial("filterFields")){i=t.getFilterFields()}return Promise.resolve([{name:i,label:r.getText("filterbar.SEARCH"),dataType:"sap.ui.model.type.String"}])};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/vh/FilterContainer", ["sap/ui/mdc/filterbar/IFilterContainer","sap/ui/layout/AlignedFlowLayout","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/VBox"],function(t,o,e,i,n){"use strict";const a=t.extend("sap.ui.mdc.filterbar.vh.FilterContainer",{metadata:{aggregations:{_layout:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});a.prototype.init=function(){this.aLayoutItems=[];this.oToolbar=new e(this.getId()+"-tbr",{content:[new i]});this.oAlgnLayout=new o(this.getId()+"-aflayout",{visible:"{$sap.ui.filterbar.mdc.FilterBarBase>/expandFilterFields}"}).addStyleClass("sapUiMdcFilterBarBaseAFLayout");this.oLayout=new n(this.getId()+"-vbox",{items:[this.oToolbar,this.oAlgnLayout]});this.setAggregation("_layout",this.oLayout,true)};a.prototype.exit=function(){this.aLayoutItems.forEach(function(t){t.destroy()});this.aLayoutItems=null};a.prototype.addControl=function(t){this.oToolbar.addContent(t)};a.prototype.insertControl=function(t,o){this.oToolbar.insertContent(t,o)};a.prototype.removeControl=function(t){this.oToolbar.removeContent(t)};a.prototype.addEndContent=function(t){this.oAlgnLayout.addEndContent(t)};a.prototype.insertFilterField=function(t,o){this.aLayoutItems.splice(o,0,t);this._updateFilterBarLayout()};a.prototype.removeFilterField=function(t){let o=-1;this.aLayoutItems.some(function(e,i){if(t===e){o=i;return true}return false});if(o>=0){this.aLayoutItems.splice(o,1);this._updateFilterBarLayout()}};a.prototype.getFilterFields=function(){return this.oAlgnLayout.getContent()};a.prototype._updateFilterBarLayout=function(t){const o=this.aLayoutItems.length;const e=this.getParent().getFilterFieldThreshold();let i=t||o<=e+1;if(!i){const t=this.oAlgnLayout.getContent();t.some(function(t,o){if(t!=this.aLayoutItems[o]){i=true;return true}return false}.bind(this))}if(i){this.oAlgnLayout.removeAllContent();this.aLayoutItems.some(function(i,n){if(t||o<=e||n+1<e){this.oAlgnLayout.insertContent(i,n);return false}return true}.bind(this))}const n=this.oAlgnLayout.getEndContent()[0];n.setVisible(!t&&o>e)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/ActionToolbar.flexibility", ["./ItemBaseFlex","./Util"],function(e,t){"use strict";const n=Object.assign({},e);n.findItem=function(e,t,n){return t.find(function(t){return e.getId(t)===n})};n.determineAggregation=function(e,t){return e.getAggregation(t,"actions").then(function(e){return{name:"actions",items:e}})};n._applyMove=function(e,n,i,r){const o=r===t.REVERT?true:false;const a=i.modifier;if(a.getParent(n)){const e=a.getParent(n);if(a.getControlType(e)==="sap.ui.mdc.Chart"){n=e}else if(a.getParent(e)&&a.getControlType(a.getParent(e))==="sap.ui.mdc.Table"){n=a.getParent(e)}}this.beforeApply(e.getChangeType(),n,o);if(this._bSupressFlickering){this._delayInvalidate(n)}const g=o?e.getRevertData():e.getContent();let s;let c;let u;let f;const h=this.determineAggregation(a,n).then(function(e){c=e;return this._getExistingAggregationItem(g,i,n)}.bind(this)).then(function(e){s=e}).then(function(){if(!s){throw new Error("No corresponding item in "+c.name+" found. Change to move item cannot be "+this._getOperationText(o)+"at this moment")}f=a.getId(s);return a.findIndexInParentAggregation(s)}.bind(this)).then(function(e){u=e;return a.removeAggregation(n,c.name,s).then(function(){return a.insertAggregation(n,c.name,s,g.index)})}).then(function(){if(o){e.resetRevertData()}else{e.setRevertData({name:g.name,index:u,item:f})}this.afterApply(e.getChangeType(),n,o)}.bind(this));return h};return{moveAction:n.createMoveChangeHandler()}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/ActionToolbarAction.flexibility", [],function(){"use strict";return{unhideControl:{changeHandler:"default"},hideControl:{changeHandler:"default"}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/AggregateFlex", ["sap/m/p13n/Engine","sap/ui/mdc/flexibility/Util","sap/ui/fl/changeHandler/condenser/Classification"],function(e,t,n){"use strict";const o=function(e,t,n,o){if(o){e.resetRevertData()}else{e.setRevertData(n)}};const r=function(e,n,r,i){return new Promise(function(a,s){const c=i===t.REVERT;const g=r.modifier;const f=c?e.getRevertData():e.getContent();Promise.resolve().then(g.getProperty.bind(g,n,"aggregateConditions")).then(function(t){const r=t?t:{};r[f.name]={};const i={name:f.name};g.setProperty(n,"aggregateConditions",r);o(e,n,i,c);a()}).catch(function(e){s(e)})})};const i=function(e,n,r,i){return new Promise(function(a,s){const c=i===t.REVERT;const g=r.modifier;const f=c?e.getRevertData():e.getContent();Promise.resolve().then(g.getProperty.bind(g,n,"aggregateConditions")).then(function(t){const r=t?t:{};if(!r){s()}delete r[f.name];g.setProperty(n,"aggregateConditions",r);o(e,n,f,c);a()}).catch(function(e){s(e)})})};const a={};const s=function(e,t){const o=e.getContent();return{classification:n.Reverse,affectedControl:e.getSelector(),uniqueKey:"aggregate"+"_"+o.name}};a.addAggregate=t.createChangeHandler({apply:r,revert:i,getCondenserInfo:s});a.removeAggregate=t.createChangeHandler({apply:i,revert:r,getCondenserInfo:s});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/Chart.flexibility", ["./SortFlex","./ChartItemFlex","./ConditionFlex","./ChartTypeFlex"],function(e,t,o,r){"use strict";return{addItem:t.addItem,removeItem:t.removeItem,moveItem:t.moveItem,setChartType:r.setChartType,removeSort:e.removeSort,addSort:e.addSort,moveSort:e.moveSort,addCondition:o.addCondition,removeCondition:o.removeCondition}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/ChartItemFlex", ["./ItemBaseFlex"],function(e){"use strict";const r=Object.assign({},e);r.beforeAddItem=function(e,r,t,n,o){return e.addItem.call(e,t,r,n,o.role)};r.findItem=function(e,r,t){return r.reduce(function(r,n){return r.then(function(r){if(!r){return Promise.all([e.getProperty(n,"propertyKey"),e.getProperty(n,"key")]).then(function(e){if(e[0]===t||e[1]===t){return n}})}return r})},Promise.resolve())};r.addItem=r.createAddChangeHandler();r.removeItem=r.createRemoveChangeHandler();r.moveItem=r.createMoveChangeHandler();return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/ChartTypeFlex", ["sap/ui/mdc/flexibility/Util","sap/ui/fl/changeHandler/condenser/Classification"],function(e,t){"use strict";const n={};const r=function(e,t,n){const r=n.modifier;return Promise.resolve().then(r.getProperty.bind(r,t,"chartType")).then(function(n){e.setRevertData(n);r.setProperty(t,"chartType",e.getContent().chartType)})};const i=function(e,t,n){n.modifier.setProperty(t,"chartType",e.getRevertData());e.resetRevertData();return Promise.resolve()};const o=function(e,n){return{classification:t.LastOneWins,affectedControl:e.getSelector(),uniqueKey:"chartType"}};n.setChartType=e.createChangeHandler({apply:r,revert:i,getCondenserInfo:o});return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/ColumnFlex", ["sap/m/p13n/Engine","./ItemBaseFlex"],function(e,n){"use strict";const r=Object.assign({},n);r.findItem=function(e,n,r){return n.reduce(function(n,t){return n.then(function(n){if(!n){return Promise.all([e.getProperty(t,"propertyKey"),e.getProperty(t,"dataProperty")]).then(function(e){if(e[0]===r||e[1]===r){return t}})}return n})},Promise.resolve())};r.addColumn=r.createAddChangeHandler();r.removeColumn=r.createRemoveChangeHandler();r.moveColumn=r.createMoveChangeHandler();return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/ConditionFlex", ["sap/base/util/merge","sap/base/Log","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/flexibility/Util","sap/ui/fl/changeHandler/condenser/Classification"],function(e,n,t,i,o){"use strict";const r=function(e,n){const t=function(n){if(e._pQueue===n){delete e._pQueue}};e._pQueue=e._pQueue instanceof Promise?e._pQueue.then(n):n();e._pQueue.then(t.bind(null,e._pQueue));return e._pQueue};const a=function(e){return new Promise(function(n,t){sap.ui.require([e],n,t)}).then(function(e){return e})};const c=function(o,c,u,f){const s=f===i.REVERT;const d=s?o.getRevertData():o.getContent();let l,g=null;const p=u.modifier;return r(c,function(){return p.getProperty(c,"filterConditions").then(function(i){l=e({},i);if(l){for(const e in l){if(e===d.name){g=l[e];break}}}if(!g){l[d.name]=[];g=l[d.name]}if(!s){o.setRevertData({name:d.name,condition:d.condition})}const r=t.indexOfCondition(d.condition,g);if(r<0){g.push(d.condition);p.setProperty(c,"filterConditions",l);return p.getProperty(c,"delegate").then(function(e){return a(e.name)}).then(function(e){const t=e&&(e.getFilterDelegate?e.getFilterDelegate().addCondition:e.addCondition);if(t){return t(c,d.name,u).catch(function(e){n.error("Error during Delegate.addCondition call: "+e)})}}).finally(function(){if(s){o.resetRevertData()}})}})})};const u=function(o,c,u,f){const s=f===i.REVERT;const d=s?o.getRevertData():o.getContent();let l,g,p=-1;const m=u.modifier;return r(c,function(){return m.getProperty(c,"filterConditions").then(function(i){l=e({},i);if(l){for(const e in l){if(e===d.name){g=l[e];break}}}if(!s){o.setRevertData({name:d.name,condition:d.condition})}if(g&&g.length>0){p=t.indexOfCondition(d.condition,g);if(p>=0){g.splice(p,1);m.setProperty(c,"filterConditions",l);return m.getProperty(c,"delegate").then(function(e){return a(e.name)}).then(function(e){const t=e&&(e.getFilterDelegate?e.getFilterDelegate().removeCondition:e.removeCondition);if(t){return t(c,d.name,u).catch(function(e){n.error("Error during Delegate.removeCondition call: "+e)})}}).finally(function(){if(s){o.resetRevertData()}})}}})})};const f=function(e,n){const t=e.getContent();return{classification:o.Reverse,affectedControl:e.getSelector(),uniqueKey:t.name+"_"+JSON.stringify(t.condition)}};const s={};s.addCondition=i.createChangeHandler({apply:c,revert:u,getCondenserInfo:f});s.removeCondition=i.createChangeHandler({apply:u,revert:c,getCondenserInfo:f});return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/FilterBar.flexibility", ["./FilterItemFlex","./ConditionFlex","./PropertyInfoFlex"],function(e,n,o){"use strict";return{addFilter:e.createAddChangeHandler(),removeFilter:e.createRemoveChangeHandler(),moveFilter:e.createMoveChangeHandler(),addCondition:n.addCondition,removeCondition:n.removeCondition,addPropertyInfo:o.addPropertyInfo}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/FilterItemFlex", ["./ItemBaseFlex"],function(e){"use strict";const t=Object.assign({},e);t.findItem=function(e,t,n){return t.find(function(t){let i;if(e.targets==="jsControlTree"){i=t.getPropertyKey()}else{i=t.getAttribute("conditions");if(i){let e;const t=i.indexOf("/conditions/");if(t>=0){i=i.slice(t+12);e=i.indexOf("}");if(e>=0){i=i.slice(0,e)}}}}return i===n})};t.beforeApply=function(e){if(e.applyConditionsAfterChangesApplied){e.applyConditionsAfterChangesApplied()}};t.addFilter=t.createAddChangeHandler();t.removeFilter=t.createRemoveChangeHandler();t.moveFilter=t.createMoveChangeHandler();return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/GroupFlex", ["sap/m/p13n/Engine","sap/ui/mdc/flexibility/Util","sap/ui/fl/changeHandler/Base","sap/ui/fl/changeHandler/condenser/Classification"],function(e,t,n,o){"use strict";const r=function(e,t,n,o){if(o){e.resetRevertData()}else{e.setRevertData(n)}};const i=function(e,n,o,i){return new Promise(function(a,s){const c=i===t.REVERT;const g=o.modifier;const u=c?e.getRevertData():e.getContent();Promise.resolve().then(g.getProperty.bind(g,n,"groupConditions")).then(function(t){const o=t?t.groupLevels:[];const i={name:u.name};o.splice(u.index,0,i);t={groupLevels:o};g.setProperty(n,"groupConditions",t);r(e,n,i,c);a()}).catch(function(e){s(e)})})};const a=function(e,o,i,a){return new Promise(function(s,c){const g=a===t.REVERT;const u=i.modifier;const d=g?e.getRevertData():e.getContent();Promise.resolve().then(u.getProperty.bind(u,o,"groupConditions")).then(function(t){const i=t?t.groupLevels:[];if(!i){c()}const a=i.filter(function(e){return e.name===d.name});const p=i.indexOf(a[0]);if(p>-1){i.splice(p,1)}else{return n.markAsNotApplicable("The specified change is already existing - change appliance ignored",true)}t={groupLevels:i};u.setProperty(o,"groupConditions",t);r(e,o,d,g);s()}).catch(function(e){c(e)})})};const s=function(e,n,o,i){return new Promise(function(a,s){const c=i===t.REVERT;const g=o.modifier;const u=c?e.getRevertData():e.getContent();Promise.resolve().then(g.getProperty.bind(g,n,"groupConditions")).then(function(t){const o=t?t.groupLevels:[];const i=o.filter(function(e){return e.name===u.name});const s=o.indexOf(i[0]);o.splice(u.index,0,o.splice(s,1)[0]);t={groupLevels:o};g.setProperty(n,"groupConditions",t);r(e,n,u,c);a()}).catch(function(e){s(e)})})};const c={};c.addGroup=t.createChangeHandler({apply:i,revert:a,getCondenserInfo:function(e,t){return{affectedControl:{id:e.getContent().name},affectedControlIdProperty:"name",targetContainer:e.getSelector(),targetAggregation:"groupLevels",customAggregation:t.modifier.bySelector(e.getSelector(),t.appComponent).getGroupConditions().groupLevels,classification:o.Create,setTargetIndex:function(e,t){e.getContent().index=t},getTargetIndex:function(e){return e.getContent().index}}}});c.removeGroup=t.createChangeHandler({apply:a,revert:i,getCondenserInfo:function(e,t){return{affectedControl:{id:e.getContent().name},affectedControlIdProperty:"name",targetContainer:e.getSelector(),targetAggregation:"groupLevels",customAggregation:t.modifier.bySelector(e.getSelector(),t.appComponent).getGroupConditions().groupLevels,classification:o.Destroy,sourceIndex:e.getRevertData().index,setIndexInRevertData:function(e,t){const n=e.getRevertData();n.index=t;e.setRevertData(n)}}}});c.moveGroup=t.createChangeHandler({apply:s,revert:s,getCondenserInfo:function(e,t){return{affectedControl:{id:e.getContent().name},affectedControlIdProperty:"name",targetContainer:e.getSelector(),targetAggregation:"groupLevels",classification:o.Move,sourceIndex:e.getRevertData().index,customAggregation:t.modifier.bySelector(e.getSelector(),t.appComponent).getGroupConditions().groupLevels,sourceContainer:e.getSelector(),sourceAggregation:"groupLevels",setTargetIndex:function(e,t){e.getContent().index=t},getTargetIndex:function(e){return e.getContent().index},setIndexInRevertData:function(e,t){const n=e.getRevertData();n.index=t;e.setRevertData(n)}}}});return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/ItemBaseFlex", ["sap/m/p13n/Engine","sap/base/Log","sap/ui/mdc/flexibility/Util","sap/ui/fl/changeHandler/Base","sap/ui/fl/changeHandler/condenser/Classification"],function(e,t,n,i,r){"use strict";const a={beforeAddItem:function(e,t,n,i){return e.addItem(n,t,i)},afterRemoveItem:function(e,t,n,i){return e.removeItem(n,t,i)},findItem:function(e,t,n){return Promise.resolve()},beforeApply:function(e,t,n){return},afterApply:function(e,t,n){return},determineAggregation:function(e,t){let n;return Promise.resolve().then(e.getControlMetadata.bind(e,t)).then(function(i){n=i.getDefaultAggregation().name;return e.getAggregation(t,n)}).then(function(e){return{name:n,items:e}})},_getExistingAggregationItem:function(e,t,n){const i=t.modifier;return this.determineAggregation(i,n).then(function(t){let n;const r=t.items;if(r){n=this.findItem(i,r,e.name)}return n}.bind(this))},_getDelegate:function(e){return new Promise(function(t,n){sap.ui.require([e],t,n)}).then(function(e){return e})},_getOperationText:function(e){return e?"reverted ":"applied "},_getChangeTypeText:function(e){return e?"add":"remove"},_applyAdd:function(e,t,r,a){const o=a===n.REVERT;this.beforeApply(e.getChangeType(),t,o);const g=r.modifier,s=o?e.getRevertData():e.getContent();const d=s.name;let c;let u;let f;let h;const l=this.determineAggregation(g,t).then(function(e){f=e;u=f.items;c=s.index>-1?s.index:u.length;return this._getExistingAggregationItem(s,r,t)}.bind(this)).then(function(e){if(e){return e}else{return g.getProperty(t,"delegate").then(function(e){return this._getDelegate(e.name)}.bind(this)).then(function(e){return this.beforeAddItem(e,d,t,r,s)}.bind(this)).then(function(e){return e})}}.bind(this)).then(function(e){if(!e){throw new Error("No item in"+f.name+"  created. Change to "+this._getChangeTypeText(!o)+"cannot be "+this._getOperationText(o)+"at this moment")}if(u.indexOf(e)<0){g.insertAggregation(t,f.name,e,c)}else{return i.markAsNotApplicable("The specified change is already existing - change appliance ignored",true)}h=e.getId?e.getId():e.id;return e}.bind(this)).then(function(){if(o){e.resetRevertData()}else{e.setRevertData({name:s.name,index:c,item:h})}this.afterApply(e.getChangeType(),t,o)}.bind(this));return l},_applyRemove:function(e,t,r,a){const o=a===n.REVERT;this.beforeApply(e.getChangeType(),t,o);const g=r.modifier,s=o?e.getRevertData():e.getContent();let d;let c;let u;let f;const h=this.determineAggregation(g,t).then(function(e){d=e;return this._getExistingAggregationItem(s,r,t)}.bind(this)).then(function(e){u=e;if(!u){return i.markAsNotApplicable("The specified change is already existing - change appliance ignored",true)}else{return g.findIndexInParentAggregation(u)}}).then(function(e){c=e;return g.removeAggregation(t,d.name,u)}).then(function(){return g.getProperty(t,"delegate").then(function(e){return this._getDelegate(e.name)}.bind(this)).then(function(n){return this.afterRemoveItem(n,u,t,r).then(function(n){if(n&&u){f=g.getId(u);g.destroy(u,"KeepDom")}this.afterApply(e.getChangeType(),t,o)}.bind(this))}.bind(this))}.bind(this)).then(function(){if(o){e.resetRevertData()}else{e.setRevertData({name:s.name,index:c,item:f})}});return h},_applyMove:function(e,t,r,a){let o;const g=a===n.REVERT;this.beforeApply(e.getChangeType(),t,g);if(this._bSupressFlickering){this._delayInvalidate(t)}const s=r.modifier;const d=g?e.getRevertData():e.getContent();let c;let u;let f;const h=this.determineAggregation(s,t).then(function(e){u=e;return this._getExistingAggregationItem(d,r,t)}.bind(this)).then(function(e){c=e}).then(function(){if(!c){return i.markAsNotApplicable("The specified change is already existing - change appliance ignored",true)}else{o=c.getId?c.getId():c.id;return s.findIndexInParentAggregation(c)}}).then(function(e){f=e;if(t.moveColumn){return t.moveColumn(c,d.index)}else{return s.removeAggregation(t,u.name,c).then(function(){return s.insertAggregation(t,u.name,c,d.index)})}}).then(function(){if(g){e.resetRevertData()}else{e.setRevertData({name:d.name,index:f,item:o})}this.afterApply(e.getChangeType(),t,g)}.bind(this));return h},_removeIndexFromChange:function(e){const t=e.getContent();delete t.index;e.setContent(t)},createAddChangeHandler:function(){return n.createChangeHandler({apply:this._applyAdd.bind(this),revert:this._applyRemove.bind(this),getCondenserInfo:function(e,t){const n=t.modifier.bySelector(e.getSelector(),t.appComponent);return this.determineAggregation(t.modifier,n).then(function(t){return{affectedControl:{idIsLocal:false,id:e.getRevertData().item},targetContainer:e.getSelector(),targetAggregation:t.name,classification:r.Create,setTargetIndex:function(e,t){e.getContent().index=t},getTargetIndex:function(e){return e.getContent().index}}})}.bind(this)})},createRemoveChangeHandler:function(){return n.createChangeHandler({apply:this._applyRemove.bind(this),complete:this._removeIndexFromChange.bind(this),revert:this._applyAdd.bind(this),getCondenserInfo:function(e,t){const n=t.modifier.bySelector(e.getSelector(),t.appComponent);return this.determineAggregation(t.modifier,n).then(function(t){return{affectedControl:{idIsLocal:false,id:e.getRevertData().item},targetContainer:e.getSelector(),targetAggregation:t.name,classification:r.Destroy,sourceIndex:e.getRevertData().index,setIndexInRevertData:function(e,t){const n=e.getRevertData();n.index=t;e.setRevertData(n)}}})}.bind(this)})},createMoveChangeHandler:function(){return n.createChangeHandler({apply:this._applyMove.bind(this),revert:this._applyMove.bind(this),getCondenserInfo:function(e,t){const n=t.modifier.bySelector(e.getSelector(),t.appComponent);return this.determineAggregation(t.modifier,n).then(function(t){return{affectedControl:{idIsLocal:false,id:e.getRevertData().item},targetContainer:e.getSelector(),targetAggregation:t.name,classification:r.Move,sourceIndex:e.getRevertData().index,sourceContainer:e.getSelector(),sourceAggregation:t.name,setTargetIndex:function(e,t){e.getContent().index=t},getTargetIndex:function(e){return e.getContent().index},setIndexInRevertData:function(e,t){const n=e.getRevertData();n.index=t;e.setRevertData(n)}}})}.bind(this)})}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/Panel.flexibility", ["sap/ui/fl/changeHandler/Base","./ItemBaseFlex"],function(e,t){"use strict";const n=Object.assign({},t);n.findItem=function(e,t,n){return Promise.resolve(sap.ui.getCore().byId(n))};return{createChanges:function(e,t){const n=t.filter(function(e){return!sap.ui.getCore().byId(e.id)});const r={};return n.reduce(function(e,t){if(!r[t.id]){r[t.id]=true;e.push(t)}return e},[]).map(function(t){return{selectorElement:e,changeSpecificData:{changeType:"createItem",content:{selector:t.id}}}})},createItem:{layers:{USER:true},changeHandler:{applyChange:function(e,t,n){const r=e.getContent().selector;return Promise.resolve().then(function(){t.getModel();return n.modifier.getProperty(t,"metadataHelperPath")}).then(function(e){return new Promise(function(t,n){sap.ui.require(["sap/ui/mdc/link/PanelItem",e],function(e,n){t(n)},function(e){n(e)})})}).then(function(e){const o=n.modifier;if(o.bySelector(r,n.appComponent,n.view)){return undefined}const i=e.retrieveAllMetadata(t);let c;const u=function(e,t){let n=-1;t.some(function(t,r){if(t.getId()===e){n=r;return true}});return n};const s=o.getControlIdBySelector(r,n.appComponent);return Promise.resolve().then(o.getAggregation.bind(o,t,"items")).then(function(e){c=-1;let t=null;i.some(function(n){const r=u(n.id,e);if(r>-1){c=r}if(n.id===s){t=n;return true}});if(!t){return undefined}return o.createControl("sap.ui.mdc.link.PanelItem",n.appComponent,n.view,t.id,{text:t.text,description:t.description,href:t.href,target:t.target,icon:t.icon,visible:true})}).then(function(e){return o.insertAggregation(t,"items",e,c+1)})})},revertChange:function(t,n,r){const o=r.modifier;if(t.getContent()&&t.getContent().selector){const i=t.getContent().selector.id;const c=o.bySelector(i,r.appComponent,r.view);if(!c){return e.markAsNotApplicable("revertChange of createItem: the item with id "+i+" is not existing and therefore can not be removed.",true)}return Promise.resolve().then(o.removeAggregation.bind(o,n,"items",c))}},completeChangeContent:function(e,t,n){if(t.content){const r=n.modifier.getSelector(t.content.selector,n.appComponent);e.setContent({selector:r})}}}}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/PanelItem.flexibility", ["sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/UnhideControl"],function(e,n){"use strict";return{createChanges:function(e){return e.map(function(e){const n=sap.ui.getCore().byId(e.id);if(!n){throw new Error("Invalid 'id'. For the id "+e.id+" no existing control could be found")}return{selectorElement:n,changeSpecificData:{changeType:e.visible?"revealItem":"hideItem"}}})},revealItem:{layers:{USER:true},changeHandler:n},hideItem:{layers:{USER:true},changeHandler:e}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/PropertyInfoFlex", [],function(){"use strict";const n={};n.addPropertyInfo={changeHandler:{applyChange:function(n,e,t){},completeChangeContent:function(n,e,t){},revertChange:function(n,e,t){}},layers:{USER:true}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/SortFlex", ["sap/m/p13n/Engine","sap/ui/mdc/flexibility/Util","sap/ui/fl/changeHandler/Base","sap/ui/fl/changeHandler/condenser/Classification"],function(e,t,n,o){"use strict";const r=function(e,t,n,o){if(o){e.resetRevertData()}else{e.setRevertData(n)}};const i=function(e,n,o,i){return new Promise(function(s,a){const c=i===t.REVERT;const g=o.modifier;const d=c?e.getRevertData():e.getContent();Promise.resolve().then(g.getProperty.bind(g,n,"sortConditions")).then(function(t){const o=t?t.sorters:[];const i={name:d.key||d.name,descending:d.descending};o.splice(d.index,0,i);t={sorters:o};g.setProperty(n,"sortConditions",t);r(e,n,i,c);s()}).catch(function(e){a(e)})})};const s=function(e,o,i,s){return new Promise(function(a,c){const g=i.modifier;const d=s===t.REVERT;const f=d?e.getRevertData():e.getContent();Promise.resolve().then(g.getProperty.bind(g,o,"sortConditions")).then(function(t){const i=t?t.sorters:[];if(!i){c()}const s=i.filter(function(e){return e.name===f.name});const u=i.indexOf(s[0]);if(u>-1){i.splice(u,1)}else{return n.markAsNotApplicable("The specified change is already existing - change appliance ignored",true)}t={sorters:i};g.setProperty(o,"sortConditions",t);r(e,o,f,d);a()}).catch(function(e){c(e)})})};const a=function(e,n,o,i){return new Promise(function(s,a){const c=i===t.REVERT;const g=o.modifier;const d=c?e.getRevertData():e.getContent();Promise.resolve().then(g.getProperty.bind(g,n,"sortConditions")).then(function(t){const o=t?t.sorters:[];const i=o.filter(function(e){return e.name===d.name});const a=o.indexOf(i[0]);o.splice(d.index,0,o.splice(a,1)[0]);t={sorters:o};g.setProperty(n,"sortConditions",t);r(e,n,d,c);s()}).catch(function(e){a(e)})})};const c={};c.addSort=t.createChangeHandler({apply:i,revert:s,getCondenserInfo:function(e,t){return{affectedControl:{id:e.getContent().name},affectedControlIdProperty:"name",targetContainer:e.getSelector(),targetAggregation:"sorters",customAggregation:t.modifier.bySelector(e.getSelector(),t.appComponent).getSortConditions().sorters,classification:o.Create,setTargetIndex:function(e,t){e.getContent().index=t},getTargetIndex:function(e){return e.getContent().index}}}});c.removeSort=t.createChangeHandler({apply:s,revert:i,getCondenserInfo:function(e,t){return{affectedControl:{id:e.getContent().name},affectedControlIdProperty:"name",targetContainer:e.getSelector(),targetAggregation:"sorters",customAggregation:t.modifier.bySelector(e.getSelector(),t.appComponent).getSortConditions().sorters,classification:o.Destroy,sourceIndex:e.getRevertData().index,setIndexInRevertData:function(e,t){const n=e.getRevertData();n.index=t;e.setRevertData(n)}}}});c.moveSort=t.createChangeHandler({apply:a,revert:a,getCondenserInfo:function(e,t){return{affectedControl:{id:e.getContent().name},affectedControlIdProperty:"name",targetContainer:e.getSelector(),targetAggregation:"sorters",classification:o.Move,sourceIndex:e.getRevertData().index,customAggregation:t.modifier.bySelector(e.getSelector(),t.appComponent).getSortConditions().sorters,sourceContainer:e.getSelector(),sourceAggregation:"sorters",setTargetIndex:function(e,t){e.getContent().index=t},getTargetIndex:function(e){return e.getContent().index},setIndexInRevertData:function(e,t){const n=e.getRevertData();n.index=t;e.setRevertData(n)}}}});return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/Table.flexibility", ["./SortFlex","./ColumnFlex","./ConditionFlex","./GroupFlex","./AggregateFlex","./xConfigFlex"],function(e,o,r,d,t,n){"use strict";return{hideControl:"default",unhideControl:"default",addColumn:o.createAddChangeHandler(),removeColumn:o.createRemoveChangeHandler(),moveColumn:o.createMoveChangeHandler(),removeSort:e.removeSort,addSort:e.addSort,moveSort:e.moveSort,addCondition:r.addCondition,removeCondition:r.removeCondition,removeGroup:d.removeGroup,addGroup:d.addGroup,moveGroup:d.moveGroup,removeAggregate:t.removeAggregate,addAggregate:t.addAggregate,setColumnWidth:n.createSetChangeHandler({aggregation:"columns",property:"width"})}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/Util", ["sap/ui/mdc/util/loadModules","sap/m/p13n/Engine"],function(n,e){"use strict";const t={};t.APPLY="apply";t.REVERT="revert";function i(n){const e=n&&n.getUIArea&&n.getUIArea();if(e&&!n._bInvalidationSuppressed){n._bInvalidationSuppressed=e.suppressInvalidationFor(n)}}function o(n){const e=n&&n.getUIArea&&n.getUIArea();if(e&&n._bInvalidationSuppressed){e.resumeInvalidationFor(n);delete n._bInvalidationSuppressed}}function a(n,t){if(n.isA){e.getInstance().trace(n,{selectorElement:n,changeSpecificData:{changeType:t.getChangeType(),content:t.getContent()}});if(!n._pPendingModification&&n._onModifications instanceof Function){n._pPendingModification=e.getInstance().waitForChanges(n).then(function(){const t=e.getInstance().getTrace(n);e.getInstance().clearTrace(n);delete n._pPendingModification;o(n);e.getInstance().fireStateChange(n);return n._onModifications(t)})}}}t.createChangeHandler=function(e){const o=e.apply instanceof Function&&e.apply;const r=e.revert instanceof Function&&e.revert;const c=e.complete instanceof Function&&e.complete;if(!o||!r){throw new Error("Please provide atleast an apply and revert function!")}return{changeHandler:{applyChange:function(n,e,r){i(e);return o(n,e,r,t.APPLY).then(function(){a(e,n)})},completeChangeContent:function(n,e,t){if(c){c(n,e,t)}},revertChange:function(n,e,o){i(e);return r(n,e,o,t.REVERT).then(function(){a(e,n)})},onAfterXMLChangeProcessing:function(e,t){return t.modifier.getProperty(e,"delegate").then(function(i){if(i){return n(i.name).then(function(n){const i=n[0];if(i.onAfterXMLChangeProcessing instanceof Function){i.onAfterXMLChangeProcessing(e,t)}})}})},getCondenserInfo:e.getCondenserInfo},layers:{USER:true}}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/xConfigFlex", ["sap/m/p13n/Engine","sap/ui/mdc/flexibility/Util","sap/ui/fl/changeHandler/condenser/Classification"],function(e,n,t){"use strict";const a={};const r=function(e,n){const t=function(n){if(e._pQueue===n){delete e._pQueue}};e._pQueue=e._pQueue instanceof Promise?e._pQueue.then(n):n();e._pQueue.then(t.bind(null,e._pQueue));return e._pQueue};a.createSetChangeHandler=function(a){if(!a||!a.hasOwnProperty("aggregation")||!a.hasOwnProperty("property")){throw new Error("Please provide a map containing the affected aggregation and property name!")}const o=a.aggregation;const g=a.property;const i=function(n,t,a){return r(t,function(){return e.getInstance().readXConfig(t,{propertyBag:a}).then(function(r){let i=null;if(r&&r.aggregations&&r.aggregations[o]&&r.aggregations[o][n.getContent().name]&&r.aggregations[o][n.getContent().name][g]){i=r.aggregations[o][n.getContent().name][g]}n.setRevertData({name:n.getContent().name,value:i});return e.getInstance().enhanceXConfig(t,{controlMeta:{aggregation:o},property:g,name:n.getContent().name,value:n.getContent().value,propertyBag:a})})})};const u=function(n,t,a){return e.getInstance().enhanceXConfig(t,{controlMeta:{aggregation:o},property:g,name:n.getRevertData().name,value:n.getRevertData().value,propertyBag:a}).then(function(){n.resetRevertData()})};return n.createChangeHandler({apply:i,revert:u,getCondenserInfo:function(e,n){return{classification:t.LastOneWins,affectedControl:e.getSelector(),uniqueKey:e.getContent().name+"_"+a.aggregation+"_"+a.property}}})};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flp/FlpLinkDelegate", ["sap/ui/mdc/LinkDelegate","sap/ui/mdc/link/LinkItem","sap/ui/mdc/link/Factory","sap/ui/mdc/link/Log","sap/base/Log","sap/base/util/isPlainObject","sap/ui/mdc/link/SemanticObjectMapping","sap/ui/mdc/link/SemanticObjectMappingItem","sap/ui/mdc/link/SemanticObjectUnavailableAction","sap/ui/mdc/enums/LinkType"],function(t,e,n,i,a,c,o,r,s,u){"use strict";const l=Object.assign({},t);l.fetchLinkItems=function(t,e,n){const a=t.getPayload();const c=e?e.getObject(e.getPath()):undefined;const o=[];if(n){n.initialize(l._getSemanticObjects(a));o.forEach(function(t){n.addIntent(i.IntentType.API,{text:t.getText(),intent:t.getHref()})})}const r=l._calculateSemanticAttributes(c,a,n);return l._retrieveNavigationTargets("",r,a,n).then(function(t,e){return Promise.resolve(t)})};l.fetchLinkType=function(t){const e={};let i=null;const c=t.getPayload();const o=function(t){return t.filter(function(t){return!e[t]}).length===0};const r=function(t){return t.some(function(t){return e[t]&&e[t].exists===true})};const s=function(){if(!i){i=new Promise(function(t){const c=n.getService("CrossApplicationNavigation");if(!c){a.error("FlpLinkDelegate: Service 'CrossApplicationNavigation' could not be obtained");t({});return}c.getDistinctSemanticObjects().then(function(n){n.forEach(function(t){e[t]={exists:true}});i=null;return t(e)},function(){a.error("FlpLinkDelegate: getDistinctSemanticObjects() of service 'CrossApplicationNavigation' failed");return t({})})})}return i};const l=function(t){if(o(t)){return Promise.resolve(r(t))}return s().then(function(){return r(t)})};if(c&&c.semanticObjects){return l(c.semanticObjects).then(function(t){return Promise.resolve({type:t?u.Popover:u.Text,directLink:undefined})})}else{throw new Error("no payload or semanticObjects found")}};l._calculateSemanticAttributes=function(t,e,n){const i=l._getSemanticObjects(e);const o=l._convertSemanticObjectMapping(l._getSemanticObjectMappings(e));if(!i.length){i.push("")}const r={};i.forEach(function(e){if(n){n.addContextObject(e,t)}r[e]={};for(const i in t){let s=null,u=null;if(n){s=n.getSemanticObjectAttribute(e,i);if(!s){s=n.createAttributeStructure();n.addSemanticObjectAttribute(e,i,s)}}if(t[i]===undefined||t[i]===null){if(s){s.transformations.push({value:undefined,description:"ℹ Undefined and null values have been removed in FlpLinkDelegate."})}continue}if(c(t[i])){if(s){s.transformations.push({value:undefined,description:"ℹ Plain objects has been removed in FlpLinkDelegate."})}continue}const l=o&&o[e]&&o[e][i]?o[e][i]:i;if(s&&i!==l){u={value:undefined,description:"ℹ The attribute "+i+" has been renamed to "+l+" in FlpLinkDelegate.",reason:"🔴 A com.sap.vocabularies.Common.v1.SemanticObjectMapping annotation is defined for semantic object "+e+" with source attribute "+i+" and target attribute "+l+". You can modify the annotation if the mapping result is not what you expected."}}if(r[e][l]){a.error("FlpLinkDelegate: The attribute "+i+" can not be renamed to the attribute "+l+" due to a clash situation. This can lead to wrong navigation later on.")}r[e][l]=t[i];if(s){if(u){s.transformations.push(u);const a=n.createAttributeStructure();a.transformations.push({value:t[i],description:"ℹ The attribute "+l+" with the value "+t[i]+" has been added due to a mapping rule regarding the attribute "+i+" in FlpLinkDelegate."});n.addSemanticObjectAttribute(e,l,a)}}}});return r};l._retrieveNavigationTargets=function(t,i,c,o){if(!c.semanticObjects){return new Promise(function(t){t([])})}const r=c.semanticObjects;const s=c.sourceControl;const u={ownNavigation:undefined,availableActions:[]};return sap.ui.getCore().loadLibrary("sap.ui.fl",{async:true}).then(function(){return new Promise(function(f){sap.ui.require(["sap/ui/fl/Utils"],function(b){const g=n.getService("CrossApplicationNavigation");const p=n.getService("URLParsing");if(!g||!p){a.error("FlpLinkDelegate: Service 'CrossApplicationNavigation' or 'URLParsing' could not be obtained");return f(u.availableActions,u.ownNavigation)}const m=sap.ui.getCore().byId(s);const d=b.getAppComponentForControl(m);const h=r.map(function(e){return[{semanticObject:e,params:i?i[e]:undefined,appStateKey:t,ui5Component:d,sortResultsBy:"text"}]});return new Promise(function(){g.getLinks(h).then(function(t){if(!t||!t.length){return f(u.availableActions,u.ownNavigation)}const n=l._getSemanticObjectUnavailableActions(c);const i=l._convertSemanticObjectUnavailableAction(n);let a=g.hrefForExternal();if(a&&a.indexOf("?")!==-1){a=a.split("?")[0]}if(a){a+="?"}const s=function(t,e){return!!i&&!!i[t]&&i[t].indexOf(e)>-1};const b=function(t){const n=p.parseShellHash(t.intent);if(s(n.semanticObject,n.action)){return}const i=g.hrefForExternal({target:{shellHash:t.intent}},d);if(t.intent&&t.intent.indexOf(a)===0){u.ownNavigation=new e({href:i,text:t.text,internalHref:t.intent});return}const c=new e({key:n.semanticObject&&n.action?n.semanticObject+"-"+n.action:undefined,text:t.text,description:undefined,href:i,internalHref:t.intent,icon:undefined,initiallyVisible:t.tags&&t.tags.indexOf("superiorAction")>-1});u.availableActions.push(c);if(o){o.addSemanticObjectIntent(n.semanticObject,{intent:c.getHref(),text:c.getText()})}};for(let e=0;e<r.length;e++){t[e][0].forEach(b)}return f(u.availableActions,u.ownNavigation)},function(){a.error("FlpLinkDelegate: '_retrieveNavigationTargets' failed executing getLinks method");return f(u.availableActions,u.ownNavigation)})})})})})};l._getSemanticObjects=function(t){return t.semanticObjects?t.semanticObjects:[]};l._getSemanticObjectUnavailableActions=function(t){const e=[];if(t.semanticObjectUnavailableActions){t.semanticObjectUnavailableActions.forEach(function(t){e.push(new s({semanticObject:t.semanticObject,actions:t.actions}))})}return e};l._getSemanticObjectMappings=function(t){const e=[];let n=[];if(t.semanticObjectMappings){t.semanticObjectMappings.forEach(function(t){n=[];if(t.items){t.items.forEach(function(t){n.push(new r({key:t.key,value:t.value}))})}e.push(new o({semanticObject:t.semanticObject,items:n}))})}return e};l._convertSemanticObjectMapping=function(t){if(!t.length){return undefined}const e={};t.forEach(function(t){if(!t.getSemanticObject()){throw Error("FlpLinkDelegate: 'semanticObject' property with value '"+t.getSemanticObject()+"' is not valid")}e[t.getSemanticObject()]=t.getItems().reduce(function(t,e){t[e.getKey()]=e.getValue();return t},{})});return e};l._convertSemanticObjectUnavailableAction=function(t){if(!t.length){return undefined}const e={};t.forEach(function(t){if(!t.getSemanticObject()){throw Error("FlpLinkDelegate: 'semanticObject' property with value '"+t.getSemanticObject()+"' is not valid")}e[t.getSemanticObject()]=t.getActions()});return e};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/library", ["sap/ui/core/Core","sap/ui/core/library","sap/m/library"],function(){"use strict";const e=sap.ui.getCore().initLibrary({version:"1.120.31",name:"sap.ui.mdc",dependencies:["sap.ui.core","sap.m"],designtime:"sap/ui/mdc/designtime/library.designtime",types:["sap.ui.mdc.TableType","sap.ui.mdc.TableP13Mode","sap.ui.mdc.GrowingMode","sap.ui.mdc.RowAction","sap.ui.mdc.RowCountMode","sap.ui.mdc.SelectionMode","sap.ui.mdc.FilterExpression","sap.ui.mdc.MultiSelectMode"],interfaces:["sap.ui.mdc.IFilterSource","sap.ui.mdc.IFilter","sap.ui.mdc.IxState","sap.ui.mdc.valuehelp.ITypeaheadContent","sap.ui.mdc.valuehelp.IDialogContent","sap.ui.mdc.valuehelp.ITypeaheadContainer","sap.ui.mdc.valuehelp.IDialogContainer"],controls:["sap.ui.mdc.Table","sap.ui.mdc.FilterBar","sap.ui.mdc.field.FieldBase","sap.ui.mdc.field.FieldInput","sap.ui.mdc.field.FieldMultiInput","sap.ui.mdc.valuehelp.base.DefineConditionPanel","sap.ui.mdc.Field","sap.ui.mdc.FilterField","sap.ui.mdc.MultiValueField","sap.ui.mdc.link.Panel","sap.ui.mdc.Chart","sap.ui.mdc.p13n.PersistenceProvider"],elements:["sap.ui.mdc.table.Column","sap.ui.mdc.table.CreationRow","sap.ui.mdc.table.DragDropConfig","sap.ui.mdc.table.TableTypeBase","sap.ui.mdc.table.GridTableType","sap.ui.mdc.table.ResponsiveTableType","sap.ui.mdc.table.RowSettings","sap.ui.mdc.chart.Item","sap.ui.mdc.chart.ChartSelectionDetails","sap.ui.mdc.chart.ChartToolbar","sap.ui.mdc.chart.ChartTypeButton","sap.ui.mdc.chart.DrillBreadcrumbs","sap.ui.mdc.chart.SelectionDetailsActions","sap.ui.mdc.field.CustomFieldInfo","sap.ui.mdc.field.FieldInfoBase","sap.ui.mdc.field.ListFieldHelpItem","sap.ui.mdc.filterbar.aligned.FilterItemLayout","sap.ui.mdc.Link","sap.ui.mdc.link.LinkItem","sap.ui.mdc.link.PanelItem","sap.ui.mdc.link.SemanticObjectUnavailableAction","sap.ui.mdc.link.SemanticObjectMapping","sap.ui.mdc.link.SemanticObjectMappingItem","sap.ui.mdc.field.MultiValueFieldItem","sap.ui.mdc.ValueHelp","sap.ui.mdc.valuehelp.Popover","sap.ui.mdc.valuehelp.Dialog","sap.ui.mdc.valuehelp.content.Bool","sap.ui.mdc.valuehelp.content.Conditions","sap.ui.mdc.valuehelp.content.FixedList","sap.ui.mdc.valuehelp.content.FixedListItem","sap.ui.mdc.valuehelp.content.MDCTable","sap.ui.mdc.valuehelp.content.MTable"],extensions:{flChangeHandlers:{"sap.ui.mdc.Table":"sap/ui/mdc/flexibility/Table","sap.ui.mdc.Chart":"sap/ui/mdc/flexibility/Chart","sap.ui.mdc.FilterBar":"sap/ui/mdc/flexibility/FilterBar","sap.ui.mdc.filterbar.p13n.AdaptationFilterBar":"sap/ui/mdc/flexibility/FilterBar","sap.ui.mdc.filterbar.vh.FilterBar":"sap/ui/mdc/flexibility/FilterBar","sap.ui.mdc.link.PanelItem":"sap/ui/mdc/flexibility/PanelItem","sap.ui.mdc.link.Panel":"sap/ui/mdc/flexibility/Panel","sap.ui.mdc.ActionToolbar":"sap/ui/mdc/flexibility/ActionToolbar","sap.ui.mdc.actiontoolbar.ActionToolbarAction":"sap/ui/mdc/flexibility/ActionToolbarAction","sap.ui.mdc.chart.ChartToolbar":"sap/ui/mdc/flexibility/ActionToolbar"}},noLibraryCSS:false});e.FilterBarP13nMode={Item:"Item",Value:"Value"};e.TableType={Table:"Table",TreeTable:"TreeTable",ResponsiveTable:"ResponsiveTable"};e.TableP13nMode={Column:"Column",Sort:"Sort",Filter:"Filter",Group:"Group",Aggregate:"Aggregate"};e.GrowingMode={None:"None",Basic:"Basic",Scroll:"Scroll"};e.RowCountMode={Auto:"Auto",Fixed:"Fixed"};e.ChartToolbarActionType={ZoomInOut:"ZoomInOut",DrillDownUp:"DrillDownUp",Legend:"Legend",FullScreen:"FullScreen"};e.ChartP13nMode={Item:"Item",Sort:"Sort",Type:"Type",Filter:"Filter"};e.SelectionMode={None:"None",Single:"Single",SingleMaster:"SingleMaster",Multi:"Multi"};e.RowAction={Navigation:"Navigation"};e.FilterExpression={Interval:"Interval",Single:"Single",Multi:"Multi"};e.ChartItemType={Dimension:"Dimension",Measure:"Measure"};e.ChartItemRoleType={category:"category",series:"series",category2:"category2",axis1:"axis1",axis2:"axis2",axis3:"axis3"};e.MultiSelectMode={Default:"Default",ClearAll:"ClearAll"};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/link/Factory", [],function(){"use strict";return{getUShellContainer:function(){return sap.ui.require("sap/ushell/Container")},getService:function(e){const n=this.getUShellContainer();if(!n){return null}switch(e){case"CrossApplicationNavigation":return n.getService("CrossApplicationNavigation");case"URLParsing":return n.getService("URLParsing");default:return null}},getServiceAsync:function(e){const n=this.getUShellContainer();if(!n){return Promise.resolve(null)}switch(e){case"CrossApplicationNavigation":return n.getServiceAsync("CrossApplicationNavigation");case"URLParsing":return n.getServiceAsync("URLParsing");default:return Promise.resolve(null)}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/link/LinkItem", ["sap/ui/core/Element"],function(e){"use strict";const t=e.extend("sap.ui.mdc.link.LinkItem",{metadata:{library:"sap.ui.mdc",properties:{key:{type:"string"},text:{type:"string"},description:{type:"string"},href:{type:"string"},internalHref:{type:"string",defaultValue:null},target:{type:"string",defaultValue:"_self"},icon:{type:"string"},initiallyVisible:{type:"boolean",defaultValue:false}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/link/Log", ["sap/ui/base/Object","sap/base/util/isEmptyObject","sap/ui/core/Configuration"],function(t,e,n){"use strict";const i=t.extend("sap.ui.mdc.link.Log",{constructor:function(){this.reset()}});i.prototype.reset=function(){this._oLog={semanticObjects:{},intents:{api:[],breakout:[]}};return this};i.prototype.isEmpty=function(){return!(!e(this._oLog.semanticObjects)||this._oLog.intents.breakout.length||this._oLog.intents.api.length)};i.prototype.initialize=function(t){this.reset();t.forEach(function(t){this.createSemanticObjectStructure(t)}.bind(this))};i.prototype.addContextObject=function(t,e){for(const n in e){const i=this.createAttributeStructure();this.addSemanticObjectAttribute(t,n,i);i.transformations.push({value:e[n],description:"ℹ The attribute "+n+" with the value "+e[n]+" is initially taken from the binding context."})}};i.prototype.createSemanticObjectStructure=function(t){this._oLog.semanticObjects[t]={attributes:{},intents:[]}};i.prototype.createAttributeStructure=function(){return{transformations:[]}};i.prototype.addSemanticObjectIntent=function(t,e){if(!this._oLog.semanticObjects[t]){this.createSemanticObjectStructure(t)}this._oLog.semanticObjects[t].intents.push(e);return this};i.prototype.addSemanticObjectAttribute=function(t,e,n){if(!this._oLog.semanticObjects[t]){this.createSemanticObjectStructure(t)}this._oLog.semanticObjects[t].attributes[e]=n;return this};i.prototype.getSemanticObjectAttribute=function(t,e){return this._oLog.semanticObjects[t]&&this._oLog.semanticObjects[t].attributes[e]?this._oLog.semanticObjects[t].attributes[e]:undefined};i.prototype.addIntent=function(t,e){switch(t){case i.IntentType.API:this._oLog.intents.api.push(e);break;case i.IntentType.BREAKOUT:this._oLog.intents.breakout.push(e);break;default:throw"Intent type "+t+" is not supported yet."}return this};i.prototype.getFormattedText=function(){const t=function(t){return typeof t==="string"?"'"+t+"'":t};const i=function(e,n){const i={value:"• "+n+" : ",description:""};e.forEach(function(e,n){i.value=i.value+(n>0?"  ➜  ":"")+t(e["value"]);i.description=i.description+"…   "+e["description"]+"\n";if(e["reason"]){i.description=i.description+"…   "+e["reason"]+"\n"}});return i};const o=function(t){let e="";t.forEach(function(t){e+="• '"+t.text+"' : "+t.intent+"\n"});return e};const s=function(t){try{const e=n.getLocale().toString();if(typeof window.Intl!=="undefined"){const n=window.Intl.Collator(e,{numeric:true});t.sort(function(t,e){return n.compare(t,e)})}else{t.sort(function(t,n){return t.localeCompare(n,e,{numeric:true})})}}catch(t){}};let r="";for(const t in this._oLog.semanticObjects){r=r+"\n⬤"+" "+t+"\n";if(e(this._oLog.semanticObjects[t].attributes)){r+="……  🔴 No semantic attributes available for semantic object "+t+". Please be aware "+"that without semantic attributes no URL parameters can be created.\n"}else{const e=Object.keys(this._oLog.semanticObjects[t].attributes);s(e);for(let n=0;n<e.length;n++){const o=e[n];const s=i(this._oLog.semanticObjects[t].attributes[o].transformations,o);r+=s.value+"\n";r+=s.description}}if(this._oLog.semanticObjects[t].intents.length){r+="\nIntents returned by FLP for semantic object "+t+":\n";r+=o(this._oLog.semanticObjects[t].intents)}}if(this._oLog.intents.api.length){r+="\nIntents defined in items aggregation:\n";r+=o(this._oLog.intents.api)}if(this._oLog.intents.breakout.length){r+="\nIntents returned by modifyItemsCallback callback:\n";r+=o(this._oLog.intents.breakout)}return r};i.prototype._getLogFormattedText=function(){return!this.isEmpty()?"---------------------------------------------\nsap.ui.mdc.Link:\nBelow you can see detailed information regarding semantic attributes which have been calculated for one or more semantic objects defined in a Link control. Semantic attributes are used to create the URL parameters. Additionally you can see all links containing the URL parameters.\n"+this.getFormattedText():"No logging data available"};i.IntentType={BREAKOUT:"Breakout",API:"Api"};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/link/Panel", ["sap/ui/core/Control","./PanelRenderer","sap/ui/layout/VerticalLayout","sap/base/Log","sap/ui/layout/HorizontalLayout","sap/m/HBox","sap/m/VBox","sap/m/ImageContent","sap/m/Link","sap/m/Label","sap/m/Text","sap/m/Button","sap/m/FlexItemData","sap/ui/model/json/JSONModel","sap/ui/model/BindingMode","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/p13n/subcontroller/LinkPanelController","sap/m/p13n/Engine","sap/ui/mdc/mixin/AdaptationMixin","sap/ui/mdc/link/PanelItem","sap/ui/core/CustomData","./Factory"],function(t,e,n,i,o,r,a,s,l,c,u,p,d,g,m,h,f,I,y,P,b,_){"use strict";const k=t.extend("sap.ui.mdc.link.Panel",{metadata:{library:"sap.ui.mdc",defaultAggregation:"items",properties:{enablePersonalization:{type:"boolean",defaultValue:true,invalidate:true},metadataHelperPath:{type:"string"},beforeNavigationCallback:{type:"function"}},aggregations:{items:{type:"sap.ui.mdc.link.PanelItem",multiple:true,singularName:"item"},additionalContent:{type:"sap.ui.core.Control",multiple:true},_content:{type:"sap.ui.layout.VerticalLayout",visibility:"hidden",multiple:false}},events:{beforeSelectionDialogOpen:{},afterSelectionDialogClose:{}}},renderer:e});k.prototype.init=function(){t.prototype.init.call(this);I.getInstance().register(this,{controller:{LinkItems:new f({control:this})}});y.call(k.prototype);I.getInstance().defaultProviderRegistry.attach(this,"Global");sap.ui.require([this.getMetadataHelperPath()||"sap/ui/mdc/Link"],function(t){this._oMetadataHelper=t}.bind(this));const e=new g({countAdditionalContent:0,countItemsWithIcon:0,countItemsWithoutIcon:0,showResetEnabled:false,runtimeItems:[],contentTitle:""});e.setDefaultBindingMode(m.TwoWay);e.setSizeLimit(1e3);this.setModel(e,"$sapuimdclinkPanel");this._oObserver=new h(W.bind(this));this._oObserver.observe(this,{properties:["enablePersonalization"],aggregations:["items","additionalContent"]})};const C=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");k.prototype.applySettings=function(){this._createContent();t.prototype.applySettings.apply(this,arguments)};k.prototype.exit=function(t){if(this._oObserver){this._oObserver.disconnect();this._oObserver=null}if(this._oMetadataHelper){this._oMetadataHelper=null}};const v=0,A=1,w=2,L=3;k.prototype._createContent=function(){const t=[];t[v]=this._createAdditionalContentArea();t[A]=this._createSeparator();t[w]=this._createLinkArea();t[L]=this._createFooterArea();const e=new n({width:"100%",content:t});this.setAggregation("_content",e)};k.prototype._createAdditionalContentArea=function(){const t=new a({fitContainer:false,items:this.getAdditionalContent()});return t};k.prototype._createSeparator=function(){const t=new a({fitContainer:false,visible:{parts:[{path:"$sapuimdclinkPanel>/countAdditionalContent"},{path:"$sapuimdcLink>/metadata"}],formatter:function(t,e){return t>0&&e.length>0}}});t.addStyleClass("mdcbaseinfoPanelSeparator");t.setModel(this._getInternalModel(),"$sapuimdclinkPanel");t.setModel(this.getModel("$sapuimdcLink"),"$sapuimdcLink");return t};k.prototype._createLinkArea=function(){const t=new a({fitContainer:false,items:{path:"$sapuimdclinkPanel>/runtimeItems",templateShareable:false,factory:this._fnLinkItemFactory.bind(this)}});t.addStyleClass("mdcbaseinfoPanelSectionLinks");t.setModel(this._getInternalModel(),"$sapuimdclinkPanel");return t};k.prototype._fnLinkItemFactory=function(t,e){const n=new s({src:"{$sapuimdclinkPanel>icon}",visible:{path:"$sapuimdclinkPanel>icon",formatter:function(t){return!!t}}});const i=new l({text:"{$sapuimdclinkPanel>text}",href:"{$sapuimdclinkPanel>href}",target:"{$sapuimdclinkPanel>target}",visible:{path:"$sapuimdclinkPanel>href",formatter:function(t){return!!t}},press:this.onPressLink.bind(this),wrapping:true,customData:new b({key:"internalHref",value:"{$sapuimdclinkPanel>internalHref}"})});const p=new c({text:"{$sapuimdclinkPanel>text}",visible:{path:"$sapuimdclinkPanel>href",formatter:function(t){return!t}},wrapping:true});const g=new u({text:"{$sapuimdclinkPanel>description}",visible:{path:"$sapuimdclinkPanel>description",formatter:function(t){return!!t}},wrapping:true});const m=new a({items:[i,p,g]});const h=new r({layoutData:new d({styleClass:e.getProperty("description")?"mdcbaseinfoPanelItemsGroup":"mdcbaseinfoPanelItemsWithoutGroup"}),items:[n,m]});const f=new o({visible:"{$sapuimdclinkPanel>visible}",content:[h]});f.addStyleClass("mdcbaseinfoPanelListItem");return f};k.prototype._createFooterArea=function(){const t=new p(this.getId()+"--idSectionPersonalizationButton",{type:"Transparent",text:C.getText("info.POPOVER_DEFINE_LINKS"),press:this.onPressLinkPersonalization.bind(this)});const e=new r({visible:{path:"$sapuimdcLink>/metadata",formatter:function(t){return t.length>0}},justifyContent:"End",items:[t]});e.addStyleClass("mdcbaseinfoPanelPersonalizationButton");return e};k.prototype.onPressLink=function(t){const e=t.getSource();const n=t.getParameters().ctrlKey||t.getParameters().metaKey;if(this.getBeforeNavigationCallback()&&e&&e.getTarget()!=="_blank"&&!n){const n=e&&e.getCustomData()&&e.getCustomData()[0]&&e.getCustomData()[0].getValue();const i=n?e.getCustomData()[0].getValue():e.getHref();t.preventDefault();this.getBeforeNavigationCallback()(t).then(function(t){if(t){k.navigate(i)}})}};k.oNavigationPromise=undefined;k.navigate=function(t){const e=_.getUShellContainer();if(t.indexOf("#")===0&&e){if(!k.oNavigationPromise){k.oNavigationPromise=_.getServiceAsync("CrossApplicationNavigation").then(function(e){e.toExternal({target:{shellHash:t.substring(1)}});k.oNavigationPromise=undefined})}}else{window.location.href=t}};k.prototype.onPressLinkPersonalization=function(){this._openPersonalizationDialog()};k.prototype._openPersonalizationDialog=function(){return new Promise(function(t,e){sap.ui.require([this.getMetadataHelperPath()||"sap/ui/mdc/Link"],function(e){const n=this._getInternalModel();const i=e.retrieveBaseline(this);const o=i;const r=function(t){let e=t._oListControl.getItems().filter(function(t){return t.getSelected()});e=e.map(function(e){const n=t._getP13nModel().getProperty(e.getBindingContext(t.P13N_MODEL).sPath);return{id:n.name,description:n.description,href:n.href,internalHref:n.internalHref,target:n.target,text:n.text,visible:n.visible}});const n=k._showResetButtonEnabled(o,e);this._getInternalModel().setProperty("/showResetEnabled",n)};const a=this.getParent();if(a.isA("sap.m.Popover")){a.setModal(true)}I.getInstance().uimanager.show(this,"LinkItems",{contentWidth:"28rem",contentHeight:"35rem",close:function(){if(a.isA("sap.m.Popover")){a.setModal(false)}}}).then(function(e){const i=e.getCustomHeader().getContentRight()[0];const o=e.getContent()[0];i.setModel(n,"$sapuimdclinkPanel");i.bindProperty("enabled",{path:"$sapuimdclinkPanel>/showResetEnabled"});r.call(this,o);o.attachChange(function(t){r.call(this,o);o.attachChange(function(t){r.call(this,o)}.bind(this));e.attachAfterClose(function(){if(a.isA("sap.m.Popover")){a.setModal(false)}})}.bind(this));t(e)}.bind(this))}.bind(this))}.bind(this))};k._showResetButtonEnabled=function(t,e){let n=false;const i=k._getVisibleItems(e);const o=k._getVisibleItems(t);if(e.length!==t.length){n=true}else if(o.length&&i.length){const t=k._allItemsIncludedInArray(o,i);const e=k._allItemsIncludedInArray(i,o);n=!t||!e}return n};k._allItemsIncludedInArray=function(t,e){let n=true;t.forEach(function(t){const i=k._getItemsById(t.id,e);if(i.length===0){n=false}});return n};k._getItemsById=function(t,e){return e.filter(function(e){return e.id===t})};k._getItemById=function(t,e){return k._getItemsById(t,e)[0]};k._getVisibleItems=function(t){return t.filter(function(t){return t.id!==undefined&&t.visible})};k.prototype._getInternalModel=function(){return this.getModel("$sapuimdclinkPanel")};k.prototype._propagateDefaultIcon=function(t){if(!t){return}const e=this._getInternalModel();e.getProperty("/runtimeItems").forEach(function(t,n){if(t.icon){return}e.setProperty("/runtimeItems/"+n+"/icon","sap-icon://chain-link")})};let M,x,$,S,B;function W(t){const e=this._getInternalModel();if(t.object.isA("sap.ui.mdc.link.Panel")){switch(t.name){case"additionalContent":M=t.child?[t.child]:t.children;M.forEach(function(e){switch(t.mutation){case"insert":this._getAdditionalContentArea().addItem(e);break;case"remove":break;default:i.error("Mutation '"+t.mutation+"' is not supported yet.")}}.bind(this));e.setProperty("/countAdditionalContent",M.length);break;case"items":x=t.child?[t.child]:t.children;x.forEach(function(n){const o=e.getProperty("/runtimeItems/");switch(t.mutation){case"insert":e.setProperty("/countItemsWithIcon",n.getIcon()?e.getProperty("/countItemsWithIcon")+1:e.getProperty("/countItemsWithIcon"));e.setProperty("/countItemsWithoutIcon",n.getIcon()?e.getProperty("/countItemsWithoutIcon"):e.getProperty("/countItemsWithoutIcon")+1);o.splice(this.indexOfItem(n),0,n.getJson());e.setProperty("/runtimeItems",o);this._propagateDefaultIcon(e.getProperty("/countItemsWithIcon")>0&&e.getProperty("/countItemsWithoutIcon")>0);this._oObserver.observe(n,{properties:["visible"]});break;case"remove":e.setProperty("/countItemsWithIcon",n.getIcon()?e.getProperty("/countItemsWithIcon")-1:e.getProperty("/countItemsWithIcon"));e.setProperty("/countItemsWithoutIcon",n.getIcon()?e.getProperty("/countItemsWithoutIcon"):e.getProperty("/countItemsWithoutIcon")-1);$=o.find(function(t){return t.id===n.getId()});o.splice(o.indexOf($),1);e.setProperty("/runtimeItems",o);this._propagateDefaultIcon(e.getProperty("/countItemsWithIcon")>0&&e.getProperty("/countItemsWithoutIcon")>0);this._oObserver.unobserve(n);n.destroy();this.invalidate();break;default:i.error("Mutation '"+t.mutation+"' is not supported yet.")}},this);break;case"enablePersonalization":this._getPersonalizationButton().setVisible(t.current);break;default:i.error("The property or aggregation '"+t.name+"' has not been registered.")}}else if(t.object.isA("sap.ui.mdc.link.PanelItem")){switch(t.name){case"visible":S=t.object;B=this.indexOfItem(S);if(S.getVisibleChangedByUser()){e.setProperty("/runtimeItems/"+B+"/visible",S.getVisible())}else{e.setProperty("/baselineItems/"+B+"/visible",S.getVisible());e.setProperty("/runtimeItems/"+B+"/visible",S.getVisible())}break;default:i.error("The '"+t.name+"' of PanelItem is not supported yet.")}}this._updateContentTitle()}k.prototype.getContentTitle=function(){const t=this._getInternalModel();const e=t.getProperty("/contentTitle");if(e){return e}else{this._updateContentTitle();return this.getContentTitle()}};k.prototype.getCurrentState=function(){const t=[];let e;this.getItems().forEach(function(n,i){e=n&&n.getId();if(n.getVisible()){t.push({name:e})}});return{items:t}};k.prototype.initPropertyHelper=function(){const t=this._oMetadataHelper.retrieveAllMetadata(this);return Promise.resolve({getProperties:function(){const e=[];t.forEach(function(t){e.push({name:t.id,getName:function(){return t.id},getLabel:function(){return t.text},text:t.text,href:t.href,internalHref:t.internalHref,description:t.description,target:t.target,visible:t.visible})});return e}})};k.prototype._updateContentTitle=function(){const t=this._getInternalModel();const e=this._getAdditionalContentArea().getItems();let n=this._getPersonalizationButton();if(e.length>0){n=e[0]}else{const t=this._getLinkControls();if(t.length>0){n=t[0]}}t.setProperty("/contentTitle",n)};k.prototype._getAdditionalContentArea=function(){return this.getAggregation("_content").getContent()[v]};k.prototype._getSeparator=function(){return this.getAggregation("_content").getContent()[A]};k.prototype._getLinkArea=function(){return this.getAggregation("_content").getContent()[w]};k.prototype._getLinkControls=function(){return this._getLinkArea().getItems().map(t=>t.getContent()[0].getItems()[1].getItems()[0])};k.prototype._getFooterArea=function(){return this.getAggregation("_content").getContent()[L]};k.prototype._getPersonalizationButton=function(){return this._getFooterArea().getItems()[0]};return k});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/link/PanelItem", ["sap/ui/core/Element"],function(e){"use strict";const t=e.extend("sap.ui.mdc.link.PanelItem",{metadata:{library:"sap.ui.mdc",properties:{text:{type:"string"},description:{type:"string"},href:{type:"string"},internalHref:{type:"string",defaultValue:null},target:{type:"string",defaultValue:undefined},icon:{type:"string"},visible:{type:"boolean",defaultValue:true},visibleChangedByUser:{type:"boolean"}}}});t.prototype.getJson=function(){return{id:this.getId(),text:this.getText(),description:this.getDescription(),href:this.getHref(),internalHref:this.getInternalHref(),icon:this.getIcon(),target:this.getTarget(),visible:this.getVisible(),visibleChangedByUser:this.getVisibleChangedByUser()}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/link/PanelRenderer", [],function(){"use strict";const n={apiVersion:2};n.render=function(n,e){const t=e.getAggregation("_content");n.openStart("div",e);n.class("mdcbaseinfoPanel");n.openEnd();n.renderControl(t);n.close("div")};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/link/SemanticObjectMapping", ["sap/ui/core/Element"],function(e){"use strict";const t=e.extend("sap.ui.mdc.link.SemanticObjectMapping",{metadata:{library:"sap.ui.mdc",properties:{semanticObject:{type:"string"}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.mdc.link.SemanticObjectMappingItem",multiple:true,singularName:"item"}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/link/SemanticObjectMappingItem", ["sap/ui/core/Element"],function(e){"use strict";const t=e.extend("sap.ui.mdc.link.SemanticObjectMappingItem",{metadata:{library:"sap.ui.mdc",properties:{key:{type:"string"},value:{type:"any"}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/link/SemanticObjectUnavailableAction", ["sap/ui/core/Element"],function(e){"use strict";const t=e.extend("sap.ui.mdc.link.SemanticObjectUnavailableAction",{metadata:{library:"sap.ui.mdc",properties:{semanticObject:{type:"string"},actions:{type:"string[]",defaultValue:[]}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/mixin/AdaptationMixin", ["sap/m/p13n/Engine"],function(t){"use strict";const i={};i.getEngine=function(){return t.getInstance()};i._onModifications=function(){};i.awaitPendingModification=function(){const i=this._pPendingModification||Promise.resolve();const e=t.getInstance().getTrace(this);return i.then(function(){return e})};i.retrieveInbuiltFilter=function(){if(!this._oInbuiltFilterPromise){this._oInbuiltFilterPromise=new Promise(function(t,i){sap.ui.require(["sap/ui/mdc/filterbar/p13n/AdaptationFilterBar"],function(e){if(this.bIsDestroyed){i("exit");return}if(!this._oP13nFilter){this._oP13nFilter=new e(this.getId()+"-p13nFilter",{adaptationControl:this,filterConditions:this.getFilterConditions()});if(this._registerInnerFilter){this._registerInnerFilter.call(this,this._oP13nFilter)}this.addDependent(this._oP13nFilter);t(this._oP13nFilter)}else{t(this._oP13nFilter)}}.bind(this))}.bind(this))}return this._oInbuiltFilterPromise};i.validateState=function(t,i){if(this.getControlDelegate().validateState instanceof Function){return this.getControlDelegate().validateState(this,t,i)}};i.getInbuiltFilter=function(){return this._oP13nFilter};i.exit=function(t){return function(){if(this._oP13nFilter){this._oP13nFilter.destroy();this._oP13nFilter=null}if(this._oInbuiltFilterPromise){this._oInbuiltFilterPromise=null}if(t){t.apply(this,arguments)}}};i._getWaitForChangesPromise=function(){const t=this.getEngine&&this.getEngine();if(!t){throw"Engine instance not found."}return t.waitForChanges(this)};return function(){this.retrieveInbuiltFilter=i.retrieveInbuiltFilter;this.getInbuiltFilter=i.getInbuiltFilter;this.validateState=i.validateState;this._onModifications=i._onModifications;this.awaitPendingModification=i.awaitPendingModification;this._getWaitForChangesPromise=i._getWaitForChangesPromise;this.getEngine=i.getEngine;this.exit=i.exit(this.exit)}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/mixin/DelegateMixin", ["sap/ui/mdc/util/loadModules","sap/base/Log","sap/ui/mdc/BaseDelegate"],function(e,t,i){"use strict";const a=function(e){if(!e||!e.name){throw new Error("Delegate configuration '"+(e&&JSON.stringify(e))+"' invalid")}};const n=function(e){if(!this.bIsDestroyed){if(e instanceof Error){this.fnRejectDelegate(e)}else{this._oDelegate=e[0];this.fnResolveDelegate(this._oDelegate);this.bDelegateInitialized=true}}this.bDelegateLoading=false;delete this.fnResolveDelegate;delete this.fnRejectDelegate};const l={};l.init=function(e){return function(){this.bDelegateInitialized=false;this.bDelegateLoading=false;this._oDelegateInitialized=new Promise(function(e,t){this.fnResolveDelegate=e;this.fnRejectDelegate=t}.bind(this));if(e){e.apply(this,arguments)}}};l.applySettings=function(e){return function(t){e.apply(this,arguments);this._bDelegateLocked=true;return this}};l.setDelegate=function(e){return function(t){if(this._bDelegateLocked){throw new Error("Runtime delegate configuration is not permitted.")}a(t);e.call(this,t);this._oPayload=t&&t.payload;return this}};l.initControlDelegate=function(i){if(this.bIsDestroyed){t.warning("Delegate module initialization omitted as control is being destroyed.")}else if(!this._oDelegate&&!this.bDelegateLoading){if(i){n.call(this,[i])}else{const t=this.getDelegate();a(t);this.bDelegateLoading=true;e(t.name).then(n.bind(this)).catch(n.bind(this))}}return this._oDelegateInitialized};l.isControlDelegateInitialized=function(){return this.bDelegateInitialized};l.getPayload=function(){if(!this._oPayload){const e=this.getDelegate();this._oPayload=e&&e.payload}return this._oPayload};l.getTypeUtil=function(){return this.getTypeMap()};l.getTypeMap=function(){if(!this._oTypeMap){if(!this._oDelegate){throw new Error("A delegate instance providing a TypeMap is not (yet) available.")}this._oTypeMap=this._oDelegate.getTypeMap(this)}return this._oTypeMap};l.getControlDelegate=function(){if(!this._oDelegate){if(this.isDestroyed()){throw new Error("A delegate instance is not available. The object instance is destroyed.")}else{throw new Error("A delegate instance is not (yet) available. You must call initControlDelegate before calling getControlDelegate.")}}return this._oDelegate};l.awaitControlDelegate=function(){return this._oDelegateInitialized};l.exit=function(e){return function(){this.fnResolveDelegate=null;this.fnRejectDelegate=null;this.bDelegateInitialized=false;this.bDelegateLoading=false;this._oDelegateInitialized=null;this._oDelegate=null;this._oPayload=null;this._oTypeMap=null;if(e){e.apply(this,arguments)}}};return function(){this.applySettings=l.applySettings(this.applySettings);this.exit=l.exit(this.exit);this.init=l.init(this.init);this.setDelegate=l.setDelegate(this.setDelegate);this.awaitControlDelegate=l.awaitControlDelegate;this.isControlDelegateInitialized=l.isControlDelegateInitialized;this.getControlDelegate=l.getControlDelegate;this.getPayload=l.getPayload;this.getTypeUtil=l.getTypeUtil;this.getTypeMap=l.getTypeMap;this.initControlDelegate=l.initControlDelegate}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/mixin/FilterIntegrationMixin", ["sap/ui/core/Core","sap/base/Log","sap/ui/mdc/enums/ReasonMode"],function(t,e,i){"use strict";const n={};const o="sap.ui.mdc.IFilter";n.setFilter=function(e){const i=typeof e==="object"?e.getId():e;const n=this.getFilter();if(n!==i){this._validateFilter(e);const i=t.byId(this.getFilter());if(i){l(this,i)}this.setAssociation("filter",e,true);const n=t.byId(this.getFilter());if(n){a(this,n)}}return this};function r(t){const e=t.getParameter("reason");const n=t.getSource();const o=n.getLiveMode&&(n.getLiveMode()?e===i.Enter:e===i.Go);this._rebind(o);if(this._onFilterSearch){this._onFilterSearch(t)}}function s(t){if(this._onFiltersChanged){this._onFiltersChanged(t)}}function a(t,e){e.attachSearch(r,t);if(e.attachFiltersChanged instanceof Function){e.attachFiltersChanged(s,t)}if(t._onFilterProvided instanceof Function){t._onFilterProvided(e)}}function l(t,e){e.detachSearch(r,t);if(e.detachFiltersChanged instanceof Function){e.detachFiltersChanged(s,t)}if(t._onFilterRemoved instanceof Function){t._onFilterRemoved(e)}}function c(t){if(!(t&&t.getMetadata()&&t.getMetadata().hasAssociation("filter"))){throw new Error("Please add the 'filter' association to your control metadata"+t)}if(!(t.rebind instanceof Function)){throw new Error("Please implement the method 'rebind' for the control "+t)}if(!(t.isFilteringEnabled instanceof Function)){throw new Error("Please implement the method isFilteringEnabled for the control "+t)}}n._validateFilter=function(e){c(this);const i=typeof e==="object"?e:t.byId(e);if(i&&!i.isA(o)){throw new Error('"'+e+'" is not valid for association "filter".'+' Please use an object that implements the "'+o+'" interface')}};n.rebind=function(){if(this.bIsDestroyed){return}let e;let i;const n=t.byId(this.getFilter()),o=this.isFilteringEnabled();if(o||n){if(n){e=n.validate(true)}if(o){i=this.retrieveInbuiltFilter().then(function(t){return t.validate(true)})}Promise.all([e,i]).then(function(){this._rebind()}.bind(this),function(){})}else{this._rebind()}};n._getLabelsFromFilterConditions=function(){const t=[];if(this.getFilterConditions){const i=this.getFilterConditions();Object.keys(i).forEach(function(n){if(!i[n]||i[n].length<1){return}const o=this.getPropertyHelper().getProperty(n)?this.getPropertyHelper().getProperty(n).label:n;if(o){t.push(o)}if(!o||o===n){e.error("No valid property found for filter with key "+n+". Check your metadata.")}}.bind(this))}return t};return function(){this.setFilter=n.setFilter;this._validateFilter=n._validateFilter;this.rebind=n.rebind;this._getLabelsFromFilterConditions=n._getLabelsFromFilterConditions}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/mixin/PromiseMixin", ["sap/ui/mdc/util/PromiseCache"],function(e){"use strict";const i={};i.addPromise=function(e,i){return this.promiseCache.add(e,i)};i.cancelPromise=function(e,i){return this.promiseCache.cancel(e,i)};i.retrievePromise=function(e,i){return this.promiseCache.retrieve(e,i)};i.retrievePromises=function(){return this.promiseCache.retrieveMany.apply(this.promiseCache,arguments)};i.removePromise=function(e){return this.promiseCache.remove(e)};i.resolvePromise=function(e,i){return this.promiseCache.resolve(e,i)};i.rejectPromise=function(e,i){return this.promiseCache.reject(e,i)};i.exit=function(e){return function(){if(this.promiseCache){this.promiseCache.destroy();this.promiseCache=null}if(e){e.apply(this,arguments)}}};return function(){const r=function(i){return function(){if(this.bIsDestroyed){return undefined}if(!this.promiseCache){this.promiseCache=new e}return i.apply(this,arguments)}};this._addPromise=r(i.addPromise);this._cancelPromise=r(i.cancelPromise);this._removePromise=r(i.removePromise);this._resolvePromise=r(i.resolvePromise);this._rejectPromise=r(i.rejectPromise);this._retrievePromise=r(i.retrievePromise);this._retrievePromises=r(i.retrievePromises);this.exit=i.exit(this.exit)}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/mixin/PropertyHelperMixin", ["sap/base/util/Deferred","sap/ui/mdc/util/loadModules","sap/base/Log"],function(e,r,t){"use strict";const i={};i.init=function(r){return function(){this._oPropertyHelper=null;this._oPropertyHelperDeferred=new e;this._oApplySettingsDeferred=new e;this._bPropertyHelperFinal=false;this._oPropertiesFinalizedDeferred=new e;this._bPropertyHelperInitializing=false;this._sPropertyInfoStore=null;if(r){r.apply(this,arguments)}}};i.applySettings=function(e){return function(){if(e){e.apply(this,arguments)}if(!this._bPropertyHelperInitializing&&this._sPropertyInfoStore&&(!arguments[0]||!arguments[0].hasOwnProperty(this._sPropertyInfoStore))){o.call(this,[],false)}this._oApplySettingsDeferred.resolve(this);return this}};i.initPropertyHelper=function(e,r,t){if(e){this._setPropertyHelperClass(e)}return o.call(this,r,t)};i.updatePropertyHelper=function(e,r){return o.call(this,e,r)};i.finalizePropertyHelper=function(){this._pHelperFinalizationPromise=this._pHelperFinalizationPromise||p(this).then(function(e){return o.call(this,e,true)}.bind(this));return this._pHelperFinalizationPromise};i.propertiesFinalized=function(){return this._oPropertiesFinalizedDeferred.promise};i.isPropertyHelperFinal=function(){return this._bPropertyHelperFinal};i.awaitPropertyHelper=function(){if(this._oPropertyHelperDeferred){return this._oPropertyHelperDeferred.promise}else{return Promise.resolve()}};i.getPropertyHelper=function(){return this._oPropertyHelper};i.exit=function(e){return function(){this._oPropertyHelper=null;this._oPropertyHelperDeferred=null;this._oApplySettingsDeferred=null;this._bPropertyHelperFinal=null;this._bPropertyHelperInitializing=null;this._pHelperFinalizationPromise=null;this._oPropertyHelperClass=null;this._sPropertyInfoStore=null;if(this._oPropertyInfoStoreMutatorOverride){this[this._oPropertyInfoStoreMutatorOverride.key]=this._oPropertyInfoStoreMutatorOverride.mutator;this._oPropertyInfoStoreMutatorOverride=null}if(e){e.apply(this,arguments)}}};i._setupPropertyInfoStore=function(e){const r=this.getMetadata().getAllProperties();const t=r&&r[e];if(!t){throw new Error("PropertyHelperMixin: Property '"+e+"' not found.")}const i=this.getMetadata().getJSONKeys()[e];this._oPropertyInfoStoreMutatorOverride={key:i._sMutator,mutator:this[i._sMutator]};this[i._sMutator]=function(){this._oPropertyInfoStoreMutatorOverride.mutator.apply(this,arguments);if(!this._bPropertyHelperFinal){o.call(this,this[i._sGetter](),false)}return this};this._sPropertyInfoStore=e};i._setPropertyHelperClass=function(e){if(this._oPropertyHelper||this._bPropertyHelperInitializing){throw new Error("PropertyHelper already initializing/ed.")}if(e&&(!e.getMetadata||!e.getMetadata().isA("sap.ui.mdc.util.PropertyHelper"))){throw new Error("The custom property helper class must be sap.ui.mdc.util.PropertyHelper or a subclass of it.")}this._oPropertyHelperClass=e};i._getPropertyByName=function(e){return this._oPropertyHelper&&this._oPropertyHelper.getProperty(e)};i._getPropertyByNameAsync=function(e){const r=this._getPropertyByName(e);if(!r){return this.finalizePropertyHelper().then(function(r){return this._getPropertyByName(e)}.bind(this))}return Promise.resolve(r)};function o(e,r){if(!this.bIsDestroyed){if(this._bPropertyHelperInitializing&&typeof e!=="undefined"){return this._oPropertyHelperDeferred.promise.then(function(){return s.call(this,e,r)}.bind(this))}if(this._oPropertyHelper&&typeof e!=="undefined"){s.call(this,e,r)}if(!this._oPropertyHelper){n.call(this,e,r)}}return this._oPropertyHelperDeferred&&this._oPropertyHelperDeferred.promise}function n(e,r){this._bPropertyHelperInitializing=true;if(r||!e){r=true;this._pHelperFinalizationPromise=this._oPropertyHelperDeferred.promise}let t;return this._oApplySettingsDeferred.promise.then(function(){return this.initControlDelegate()}.bind(this)).then(function(i){t=i;return r?p(this):e}.bind(this)).then(function(e){if(this.bIsDestroyed){return[]}return l(this,t).then(function(r){return[e,r]})}.bind(this)).then(function(e){if(this.bIsDestroyed){return undefined}const t=e[0];const i=e[1];this._oPropertyHelper=new i(t,this);this._bPropertyHelperInitializing=false;if(r){this._bPropertyHelperFinal=true;this._oPropertiesFinalizedDeferred.resolve()}return this._oPropertyHelperDeferred.resolve(this._oPropertyHelper)}.bind(this)).catch(function(e){return this._oPropertyHelperDeferred&&this._oPropertyHelperDeferred.reject(e)}.bind(this))}function s(e,r){if(this._bPropertyHelperFinal){throw new Error("This property helper is already final and cannot be updated further.")}this._oPropertyHelper.setProperties(e);this._bPropertyHelperFinal=r||this._bPropertyHelperFinal;if(this._bPropertyHelperFinal){this._oPropertiesFinalizedDeferred.resolve()}return this._oPropertyHelper}function p(e){return e.initControlDelegate().then(function(){const r=e.getControlDelegate(e);return r.fetchProperties(e).then(function(r){if(e.isDestroyed()){return[]}return r})})}function l(e,t){if(t&&typeof t.getPropertyHelperClass==="function"){const r=t.getPropertyHelperClass();const i=e._oPropertyHelperClass?e._oPropertyHelperClass.getMetadata().getName():"sap.ui.mdc.util.PropertyHelper";if(!r||!r.getMetadata||!r.getMetadata().isA(i)){throw new Error("The property helper class must be "+i+" or a subclass of it.")}return Promise.resolve(r)}if(e._oPropertyHelperClass){return Promise.resolve(e._oPropertyHelperClass)}return r("sap/ui/mdc/util/PropertyHelper").then(function(e){return e[0]})}return function(){this.init=i.init(this.init);this.exit=i.exit(this.exit);this.applySettings=i.applySettings(this.applySettings);this.initPropertyHelper=i.initPropertyHelper;this.awaitPropertyHelper=i.awaitPropertyHelper;this.getPropertyHelper=i.getPropertyHelper;this.finalizePropertyHelper=i.finalizePropertyHelper;this.isPropertyHelperFinal=i.isPropertyHelperFinal;this.propertiesFinalized=i.propertiesFinalized;this._getPropertyByName=i._getPropertyByName;this._getPropertyByNameAsync=i._getPropertyByNameAsync;this._setPropertyHelperClass=i._setPropertyHelperClass;this._setupPropertyInfoStore=i._setupPropertyInfoStore}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/TypeMap", ["../DefaultTypeMap","sap/ui/mdc/enums/BaseType"],function(e,t){"use strict";const a=Object.assign({},e);a.getDateTimeBaseType=function(e,a){if(a&&a.displayFormat==="Date"){return t.Date}else{return t.DateTime}};a.import(e);a.set("sap.ui.model.odata.type.Boolean",t.Boolean);a.set("sap.ui.model.odata.type.Byte",t.Numeric);a.set("sap.ui.model.odata.type.Currency",e.getUnitBaseType,e.getUnitOptions);a.set("sap.ui.model.odata.type.Date",t.Date);a.set("sap.ui.model.odata.type.DateTime",a.getDateTimeBaseType);a.set("sap.ui.model.odata.type.DateTimeOffset",t.DateTime);a.set("sap.ui.model.odata.type.DateTimeWithTimezone",t.DateTime);a.set("sap.ui.model.odata.type.Decimal",t.Numeric);a.set("sap.ui.model.odata.type.Double",t.Numeric);a.set("sap.ui.model.odata.type.Guid",t.String);a.set("sap.ui.model.odata.type.Int16",t.Numeric);a.set("sap.ui.model.odata.type.Int32",t.Numeric);a.set("sap.ui.model.odata.type.Int64",t.Numeric);a.set("sap.ui.model.odata.type.SByte",t.Numeric);a.set("sap.ui.model.odata.type.Single",t.Numeric);a.set("sap.ui.model.odata.type.Stream",t.String);a.set("sap.ui.model.odata.type.String",t.String);a.set("sap.ui.model.odata.type.Time",t.Time);a.set("sap.ui.model.odata.type.TimeOfDay",t.Time);a.set("sap.ui.model.odata.type.Unit",e.getUnitBaseType,e.getUnitOptions);a.setAlias("Edm.Binary","sap.ui.model.odata.type.Stream");a.setAlias("Edm.Boolean","sap.ui.model.odata.type.Boolean");a.setAlias("Edm.Byte","sap.ui.model.odata.type.Byte");a.setAlias("Edm.Date","sap.ui.model.odata.type.Date");a.setAlias("Edm.DateTime","sap.ui.model.odata.type.DateTime");a.setAlias("Edm.DateTimeOffset","sap.ui.model.odata.type.DateTimeOffset");a.setAlias("Edm.Decimal","sap.ui.model.odata.type.Decimal");a.setAlias("Edm.Double","sap.ui.model.odata.type.Double");a.setAlias("Edm.Float","sap.ui.model.odata.type.Single");a.setAlias("Edm.Guid","sap.ui.model.odata.type.Guid");a.setAlias("Edm.Int16","sap.ui.model.odata.type.Int16");a.setAlias("Edm.Int32","sap.ui.model.odata.type.Int32");a.setAlias("Edm.Int64","sap.ui.model.odata.type.Int64");a.setAlias("Edm.SByte","sap.ui.model.odata.type.SByte");a.setAlias("Edm.Single","sap.ui.model.odata.type.Single");a.setAlias("Edm.Stream","sap.ui.model.odata.type.Stream");a.setAlias("Edm.String","sap.ui.model.odata.type.String");a.setAlias("Edm.Time","sap.ui.model.odata.type.Time");a.setAlias("Edm.TimeOfDay","sap.ui.model.odata.type.TimeOfDay");a.initializeTypeFromValue=function(e,a){if(e&&this.getBaseType(e.getMetadata().getName())===t.Unit&&Array.isArray(a)&&a.length>2){if(a[2]!==undefined){const t={mCustomUnits:a[2]};this.initializeInternalType(e,t);return t}}else{return{}}return null};a.initializeInternalType=function(e,t){if(t&&t.mCustomUnits!==undefined){e.formatValue([null,null,t.mCustomUnits],"string")}};a.freeze();return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/TypeUtil", ["sap/ui/mdc/util/TypeUtil","sap/ui/mdc/enums/BaseType"],function(e,t){"use strict";const a=Object.assign({},e,{getPrimitiveType:function(e){const t={"Edm.Binary":"boolean","Edm.Boolean":"boolean","Edm.Byte":"boolean","Edm.Date":"date","Edm.DateTimeOffset":"dateTime","Edm.Decimal":"int","Edm.Double":"boolean","Edm.Duration":"float","Edm.Guid":"string","Edm.Int16":"int","Edm.Int32":"int","Edm.Int64":"int","Edm.SByte":"boolean","Edm.Single":"float","Edm.String":"string","Edm.TimeOfDay":"time"};return t[e]||"object"},getDataTypeClassName:function(t){const a={"Edm.Boolean":"sap.ui.model.odata.type.Boolean","Edm.Byte":"sap.ui.model.odata.type.Byte","Edm.DateTime":"sap.ui.model.odata.type.DateTime","Edm.DateTimeOffset":"sap.ui.model.odata.type.DateTimeOffset","Edm.Decimal":"sap.ui.model.odata.type.Decimal","Edm.Double":"sap.ui.model.odata.type.Double","Edm.Float":"sap.ui.model.odata.type.Single","Edm.Guid":"sap.ui.model.odata.type.Guid","Edm.Int16":"sap.ui.model.odata.type.Int16","Edm.Int32":"sap.ui.model.odata.type.Int32","Edm.Int64":"sap.ui.model.odata.type.Int64","Edm.SByte":"sap.ui.model.odata.type.SByte","Edm.Single":"sap.ui.model.odata.type.Single","Edm.String":"sap.ui.model.odata.type.String","Edm.Time":"sap.ui.model.odata.type.Time"};if(a[t]){t=a[t]}else if(t&&t.startsWith("Edm.")){throw new Error("Invalid data type "+t)}else{t=e.getDataTypeClassName.call(this,t)}return t},getBaseType:function(a,i,o){switch(a){case"sap.ui.model.odata.type.DateTime":if(o&&o.displayFormat==="Date"){return t.Date}else{return t.DateTime}case"sap.ui.model.odata.type.DateTimeOffset":case"sap.ui.model.odata.type.DateTimeWithTimezone":return t.DateTime;case"sap.ui.model.odata.type.Time":return t.Time;case"sap.ui.model.odata.type.Boolean":return t.Boolean;case"sap.ui.model.odata.type.Byte":case"sap.ui.model.odata.type.SByte":case"sap.ui.model.odata.type.Decimal":case"sap.ui.model.odata.type.Int16":case"sap.ui.model.odata.type.Int32":case"sap.ui.model.odata.type.Int64":case"sap.ui.model.odata.type.Single":case"sap.ui.model.odata.type.Double":return t.Numeric;default:return e.getBaseType.call(this,a,i,o)}},internalizeValue:function(a,i,o,d){const n=this._normalizeType(i,o,d);if(this.getBaseTypeForType(n)===t.Numeric){if(typeof a!=="string"&&(n.getMetadata().getName()==="sap.ui.model.odata.type.Int64"||n.getMetadata().getName()==="sap.ui.model.odata.type.Decimal")){return a.toString()}}return e.internalizeValue.call(this,a,i,o,d)},externalizeValue:function(a,i,o,d){const n=this._normalizeType(i,o,d);if(this.getBaseTypeForType(n)===t.Numeric){if(typeof a!=="string"&&(n.getMetadata().getName()==="sap.ui.model.odata.type.Int64"||n.getMetadata().getName()==="sap.ui.model.odata.type.Decimal")){return a.toString()}}return e.externalizeValue.call(this,a,i,o,d)},initializeTypeFromValue:function(e,a){if(e&&this.getBaseType(e.getMetadata().getName())===t.Unit&&Array.isArray(a)&&a.length>2){if(a[2]!==undefined){const t={mCustomUnits:a[2]};this.initializeInternalType(e,t);return t}}else{return{}}return null},initializeInternalType:function(e,t){if(t&&t.mCustomUnits!==undefined){e.formatValue([null,null,t.mCustomUnits],"string")}}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/v4/ChartDelegate", ["../../ChartDelegate","sap/ui/mdc/odata/v4/TypeMap"],function(e,t){"use strict";const a=Object.assign({},e);a.getTypeMap=function(e){return t};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/v4/FieldBaseDelegate", ["sap/ui/mdc/field/FieldBaseDelegate","sap/ui/mdc/odata/v4/TypeMap"],function(e,t){"use strict";const a=Object.assign({},e);a.getTypeMap=function(e){return t};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/v4/ODataMetaModelUtil", [],function(){"use strict";const e=function(){};e.fetchAllAnnotations=function(e,t){const r=e.getMetaContext(t);return e.requestObject("@",r).then(function(e){return e})};e.getAllCustomAggregates=function(e){const t={};let r;for(const i in e){if(i.startsWith("@Org.OData.Aggregation.V1.CustomAggregate")){r=i.replace("@Org.OData.Aggregation.V1.CustomAggregate#","");const a=r.split("@");if(a.length==2){if(a[1]=="Org.OData.Aggregation.V1.ContextDefiningProperties"){t[a[0]].contextDefiningProperties=e[i]}if(a[1]=="com.sap.vocabularies.Common.v1.Label"){t[a[0]].label=e[i]}}else if(a.length==1){t[a[0]]={name:a[0],propertyPath:a[0],label:"Custom Aggregate ("+r+")",sortable:true,sortOrder:"both",custom:true}}}}return t};e.getAllAggregatableProperties=function(e){const t={};let r,i;if(e["@com.sap.vocabularies.Analytics.v1.AggregatedProperties"]){r=e["@com.sap.vocabularies.Analytics.v1.AggregatedProperties"];for(let e=0;e<r.length;e++){i=r[e];t[i.Value]={name:i.Value,propertyPath:i.AggregatableProperty.$PropertyPath,aggregationMethod:i.AggregationMethod,label:i["@com.sap.vocabularies.Common.v1.Label"]||"Aggregatable property ("+i.Value+")",sortable:true,sortOrder:"both",custom:false}}}return t};e.getAllDataPoints=function(t){const r={};for(const i in t){if(i.startsWith("@com.sap.vocabularies.UI.v1.DataPoint")){const a=i.replace("@com.sap.vocabularies.UI.v1.DataPoint#","");const n=t[i].Value.$Path;r[n]=r[n]||{};r[n][a]=e.createDataPointProperty(t[i])}}return r};e.createDataPointProperty=function(t){const r={};if(t.TargetValue){r.targetValue=t.TargetValue.$Path}if(t.ForeCastValue){r.foreCastValue=t.ForeCastValue.$Path}let i=null;if(t.Criticality){if(t.Criticality.$Path){i={Calculated:t.Criticality.$Path}}else{i={Static:t.Criticality.$EnumMember.replace("com.sap.vocabularies.UI.v1.CriticalityType/","")}}}else if(t.CriticalityCalculation){const r={};const a=e._buildThresholds(r,t.CriticalityCalculation);if(a){i={ConstantThresholds:r}}else{i={DynamicThresholds:r}}}if(i){r.criticality=i}return r};e._buildThresholds=function(e,t){const r=["AcceptanceRangeLowValue","AcceptanceRangeHighValue","ToleranceRangeLowValue","ToleranceRangeHighValue","DeviationRangeLowValue","DeviationRangeHighValue"];let i=true,a;e.ImprovementDirection=t.ImprovementDirection.$EnumMember.replace("com.sap.vocabularies.UI.v1.ImprovementDirectionType/","");const n={oneSupplied:false,usedMeasures:[]};const s={oneSupplied:false};for(let e=0;e<r.length;e++){a=r[e];n[a]=t[a]?t[a].$Path:undefined;n.oneSupplied=n.oneSupplied||n[a];if(!n.oneSupplied){s[a]=t[a];s.oneSupplied=s.oneSupplied||s[a]}else if(n[a]){n.usedMeasures.push(n[a])}}if(n.oneSupplied){i=false;for(let t=0;t<r.length;t++){if(n[r[t]]){e[r[t]]=n[r[t]]}}e.usedMeasures=n.usedMeasures}else{let i;e.AggregationLevels=[];if(s.oneSupplied){i={VisibleDimensions:null};for(let e=0;e<r.length;e++){if(s[r[e]]){i[r[e]]=s[r[e]]}}e.AggregationLevels.push(i)}if(t.ConstantThresholds&&t.ConstantThresholds.length>0){for(let a=0;a<t.ConstantThresholds.length;a++){const n=t.ConstantThresholds[a];const s=n.AggregationLevel?[]:null;if(n.AggregationLevel&&n.AggregationLevel.length>0){for(let e=0;e<n.AggregationLevel.length;e++){s.push(n.AggregationLevel[e].$PropertyPath)}}i={VisibleDimensions:s};for(let e=0;e<r.length;e++){const t=n[r[e]];if(t){i[r[e]]=t}}e.AggregationLevels.push(i)}}}return i};e.getSortRestrictionsInfo=function(e){let t,r;const i={sortable:true,propertyInfo:{}};if(e){i.sortable=e.Sortable!=null?e.Sortable:true;if(e.NonSortableProperties){for(t=0;t<e.NonSortableProperties.length;t++){r=e.NonSortableProperties[t].$PropertyPath;i[r]={sortable:false}}}if(e.AscendingOnlyProperties){for(t=0;t<e.AscendingOnlyProperties;t++){r=e.AscendingOnlyProperties[t].$PropertyPath;i[r]={sortable:true,sortDirection:"asc"}}}if(e.DescendingOnlyProperties){for(t=0;t<e.DescendingOnlyProperties;t++){r=e.DescendingOnlyProperties[t].$PropertyPath;i[r]={sortable:true,sortDirection:"desc"}}}}return i};e.addSortInfoForProperty=function(e,t){const r=t[e.name];e.sortable=t.sortable&&r?r.sortable:true;if(e.sortable){e.sortDirection=r?r.sortDirection:"both"}};e.getFilterRestrictionsInfo=function(e){let t,r;const i={filterable:true,propertyInfo:{}};if(e){i.filterable=e.Filterable!=null?e.Filterable:true;i.requiresFilter=e.RequiresFilter!=null?e.RequiresFilter:false;i.requiredProperties=[];if(i.RequiredProperties){for(t=0;t<e.NonFilterableProperties;t++){r=e.NonFilterableProperties[t].$PropertyPath;i.requiredProperties.push(r)}}if(e.NonFilterableProperties){for(t=0;t<e.NonFilterableProperties.length;t++){r=e.NonFilterableProperties[t].$PropertyPath;i[r]={filterable:false}}}if(e.FilterExpressionRestrictions){for(t=0;t<e.FilterExpressionRestrictions;t++){r=e.FilterExpressionRestrictions[t].$PropertyPath;i[r]={filterable:true,allowedExpressions:e.FilterExpressionRestrictions[t].AllowedExpressions}}}}return i};e.isMultiValueFilterExpression=function(e){let t=true;switch(e){case"SearchExpression":case"SingleRange":case"SingleValue":t=false;break;default:break}return t};e.addFilterInfoForProperty=function(e,t){const r=t[e.name];e.filterable=t.filterable&&r?r.filterable:true;if(e.filterable){e.allowedExpressions=r?r.allowedExpressions:null}};e.fetchCalendarTag=function(e,t){const r="@com.sap.vocabularies.Common.v1.";return Promise.all([e.requestObject(r+"IsCalendarYear",t),e.requestObject(r+"IsCalendarHalfyear",t),e.requestObject(r+"IsCalendarQuarter",t),e.requestObject(r+"IsCalendarMonth",t),e.requestObject(r+"IsCalendarWeek",t),e.requestObject(r+"IsDayOfCalendarMonth",t),e.requestObject(r+"IsDayOfCalendarYear",t),e.requestObject(r+"IsCalendarYearHalfyear",t),e.requestObject(r+"IsCalendarYearQuarter",t),e.requestObject(r+"IsCalendarYearMonth",t),e.requestObject(r+"IsCalendarYearWeek",t),e.requestObject(r+"IsCalendarDate",t)]).then(function(e){if(e[0]){return"year"}if(e[1]){return"halfYear"}if(e[2]){return"quarter"}if(e[3]){return"month"}if(e[4]){return"week"}if(e[5]){return"dayOfMonth"}if(e[6]){return"dayOfYear"}if(e[7]){return"yearHalfYear"}if(e[8]){return"yearQuarter"}if(e[9]){return"yearMonth"}if(e[10]){return"yearWeek"}if(e[11]){return"date"}return undefined})};e.fetchFiscalTag=function(e,t){const r="@com.sap.vocabularies.Common.v1.";return Promise.all([e.requestObject(r+"IsFiscalYear",t),e.requestObject(r+"IsFiscalPeriod",t),e.requestObject(r+"IsFiscalYearPeriod",t),e.requestObject(r+"IsFiscalQuarter",t),e.requestObject(r+"IsFiscalYearQuarter",t),e.requestObject(r+"IsFiscalWeek",t),e.requestObject(r+"IsFiscalYearWeek",t),e.requestObject(r+"IsDayOfFiscalYear",t),e.requestObject(r+"IsFiscalYearVariant",t)]).then(function(e){if(e[0]){return"year"}if(e[1]){return"period"}if(e[2]){return"yearPeriod"}if(e[3]){return"quarter"}if(e[4]){return"yearQuarter"}if(e[5]){return"week"}if(e[6]){return"yearWeek"}if(e[7]){return"dayOfYear"}if(e[8]){return"yearVariant"}return undefined})};e.fetchCriticality=function(e,t){const r="@com.sap.vocabularies.UI.v1";return e.requestObject(r+".ValueCriticality",t).then(function(e){let t,r;if(e){t={VeryPositive:[],Positive:[],Critical:[],VeryNegative:[],Negative:[],Neutral:[]};for(let i=0;i<e.length;i++){r=e[i];if(r.Criticality.$EnumMember.endsWith("VeryPositive")){t.VeryPositive.push(r.Value)}else if(r.Criticality.$EnumMember.endsWith("Positive")){t.Positive.push(r.Value)}else if(r.Criticality.$EnumMember.endsWith("Critical")){t.Critical.push(r.Value)}else if(r.Criticality.$EnumMember.endsWith("VeryNegative")){t.VeryNegative.push(r.Value)}else if(r.Criticality.$EnumMember.endsWith("Negative")){t.Negative.push(r.Value)}else{t.Neutral.push(r.Value)}}for(const e in t){if(t[e].length==0){delete t[e]}}}return t})};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/v4/TableDelegate", ["../../TableDelegate","../../table/V4AnalyticsPropertyHelper","../../util/loadModules","sap/m/ColumnPopoverSelectListItem","sap/m/MessageBox","sap/m/plugins/PluginBase","sap/ui/core/Item","sap/ui/core/Core","sap/ui/core/library","sap/ui/core/format/ListFormat","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/odata/v4/TypeMap","sap/ui/mdc/enums/TableP13nMode","sap/ui/mdc/enums/TableType"],function(e,t,n,r,i,o,s,a,l,u,g,c,p,f){"use strict";const d=new window.WeakMap;const T=Object.assign({},e);T.getTypeMap=function(e){return c};T.getPropertyHelperClass=function(){return t};T.preInit=function(){return Promise.resolve()};T.initializeContent=function(t){return e.initializeContent.apply(this,arguments).then(function(){if(!d.has(t)){d.set(t,{})}return B(t)}).then(function(){E(t)})};T.initializeSelection=function(t){if(t._bV4LegacySelectionEnabled){return e.initializeSelection.apply(this,arguments)}if(t._isOfType(f.Table,true)){return b(t)}else{return e.initializeSelection.apply(this,arguments)}};function b(t){const r={Single:"Single",SingleMaster:"Single",Multi:"MultiToggle"};return n("sap/ui/table/plugins/ODataV4Selection").then(function(n){const i=n[0];if(t._bV4LegacySelectionEnabled){return e.initializeSelection.call(this,t)}t._oTable.addDependent(new i({limit:"{$sap.ui.mdc.Table#type>/selectionLimit}",enableNotification:true,hideHeaderSelector:"{= !${$sap.ui.mdc.Table#type>/showHeaderSelector} }",selectionMode:{path:"$sap.ui.mdc.Table>/selectionMode",formatter:function(e){return r[e]}},enabled:{path:"$sap.ui.mdc.Table>/selectionMode",formatter:function(e){return e in r}},selectionChange:function(e){t._onSelectionChange({selectAll:e.getParameter("selectAll")})}}))})}function m(e,t){const n=o.getPlugin(e._oTable,"sap.ui.table.plugins.ODataV4Selection");if(n){return n.setSelectedContexts(t)}const r=o.getPlugin(e._oTable,"sap.ui.table.plugins.MultiSelectionPlugin");if(r){r.clearSelection();return t.map(function(e){const t=e.getIndex();return r.addSelectionInterval(t,t)})}throw Error("Unsupported operation: TableDelegate does not support #setSelectedContexts for the given Table configuration")}T.setSelectedContexts=function(t,n){if(t._isOfType(f.Table,true)){m(t,n)}else{e.setSelectedContexts.apply(this,arguments)}};T.getSelectedContexts=function(t){if(!t._oTable){return[]}if(t._bV4LegacySelectionEnabled){return e.getSelectedContexts.apply(this,arguments)}if(t._isOfType(f.Table,true)){const e=o.getPlugin(t._oTable,"sap.ui.table.plugins.ODataV4Selection");return e?e.getSelectedContexts():[]}return e.getSelectedContexts.apply(this,arguments)};T.validateState=function(t,n,r){const i=e.validateState.apply(this,arguments);let o;if(r=="Sort"){o=S(t,n)}else if(r=="Group"){o=y(t,n)}else if(r=="Column"){o=_(t,n)}return v(i,o)};function S(e,t){if(M(e)&&x(e,t.items,t.sorters)){return{validation:l.MessageType.Information,message:a.getLibraryResourceBundle("sap.ui.mdc").getText("table.PERSONALIZATION_DIALOG_SORT_RESTRICTION")}}return null}function y(e,t){const n=a.getLibraryResourceBundle("sap.ui.mdc");if(t.aggregations){const r=Object.keys(t.aggregations);const i=[];const o=u.getInstance();r.forEach(function(t){const n=e.getPropertyHelper().getProperty(t);if(n&&n.groupable){i.push(t)}});if(i.length>0){return{validation:l.MessageType.Information,message:n.getText("table.PERSONALIZATION_DIALOG_GROUP_RESTRICTION_TOTALS",[o.format(i)])}}}else if(e._isOfType(f.ResponsiveTable)){if(x(e,t.items,t.groupLevels)){return{validation:l.MessageType.Information,message:n.getText("table.PERSONALIZATION_DIALOG_GROUP_RESTRICTION_VISIBLE")}}}return null}function _(e,t){const n=a.getLibraryResourceBundle("sap.ui.mdc");const r=t.aggregations&&Object.keys(t.aggregations);let i;if(e._isOfType(f.ResponsiveTable)){if(x(e,t.items,t.groupLevels)){return{validation:l.MessageType.Information,message:n.getText("table.PERSONALIZATION_DIALOG_GROUP_RESTRICTION_VISIBLE")}}}if(x(e,t.items,r)){i=n.getText("table.PERSONALIZATION_DIALOG_TOTAL_RESTRICTION")}if(M(e)&&x(e,t.items,t.sorters)){const e=n.getText("table.PERSONALIZATION_DIALOG_SORT_RESTRICTION");i=i?i+"\n"+e:e}if(i){return{validation:l.MessageType.Information,message:i}}return null}T.updateBinding=function(e,t,n,r){if(!n||n.getPath()!=t.path){this.rebind(e,t);return}const i=n.getRootBinding();let s=i&&!i.isSuspended();try{if(s){i.suspend()}E(e,t);n.changeParameters(t.parameters);n.filter(t.filters,"Application");n.sort(t.sorter);if(r&&r.forceRefresh){n.refresh()}}catch(r){this.rebind(e,t);if(i==n){s=false}}finally{if(s&&i.isSuspended()){i.resume()}}if(e._bV4LegacySelectionEnabled&&e._isOfType(f.Table)){const t=o.getPlugin(e._oTable,"sap.ui.table.plugins.MultiSelectionPlugin");const n=t?t.oInnerSelectionPlugin:null;if(n){n._bInternalTrigger=true}e.clearSelection();if(n){delete n._bInternalTrigger}}};T.rebind=function(t,n){E(t,n);e.rebind.apply(this,arguments)};T.addColumnMenuItems=function(e,t){const n=e.getPropertyHelper();const r=n.getProperty(t.getPropertyKey());const i=[];if(!r){return[]}if(e.isGroupingEnabled()){const e=r.getGroupableProperties();if(e.length>0){i.push(I(e,t))}}if(e.isAggregationEnabled()){const e=r.getAggregatableProperties().filter(function(e){return e.extension.customAggregate!=null});if(e.length>0){i.push(P(e,t))}}const o=e._oPopover;if(o){o.getItems().forEach(function(e,t,n){const r=e.getLabel();const i=a.getLibraryResourceBundle("sap.ui.mdc");if(r===i.getText("table.SETTINGS_GROUP")||r===i.getText("table.SETTINGS_TOTALS")){n[t].destroy()}if(n.length==0){o.destroy()}})}return i};T.getSupportedP13nModes=function(t){const n=e.getSupportedP13nModes.apply(this,arguments);if(t._isOfType(f.Table)){if(!n.includes(p.Group)){n.push(p.Group)}if(!n.includes(p.Aggregate)){n.push(p.Aggregate)}}return n};T.getGroupSorter=function(t){const n=t._getGroupedProperties()[0];if(!n||!t._isOfType(f.ResponsiveTable)){return undefined}if(!G(t).includes(n.name)){return undefined}return e.getGroupSorter.apply(this,arguments)};T.getSorters=function(t){let n=e.getSorters.apply(this,arguments);if(M(t)){const e=t.getPropertyHelper();const r=G(t).map(t=>e.getProperty(t).path);n=n.filter(e=>r.includes(e.sPath))}return n};T.getSupportedFeatures=function(t){const n=e.getSupportedFeatures.apply(this,arguments);const r=t._isOfType(f.TreeTable);return Object.assign(n,{expandAll:r,collapseAll:r})};T.expandAll=function(e){if(!this.getSupportedFeatures(e).expandAll){return}const t=e.getRowBinding();if(t){t.setAggregation(Object.assign(t.getAggregation(),{expandTo:999}))}};T.collapseAll=function(e){if(!this.getSupportedFeatures(e).collapseAll){return}const t=e.getRowBinding();if(t){t.setAggregation(Object.assign(t.getAggregation(),{expandTo:1}))}};function I(e,t){const n=e.map(function(e){return new s({text:e.label,key:e.name})});if(n.length>0){return new r({items:n,label:a.getLibraryResourceBundle("sap.ui.mdc").getText("table.SETTINGS_GROUP"),icon:"sap-icon://group-2",action:[{sName:"Group",oMDCColumn:t},h,this]})}}function P(e,t){const n=e.map(function(e){return new s({text:e.label,key:e.name})});if(n.length>0){return new r({items:n,label:a.getLibraryResourceBundle("sap.ui.mdc").getText("table.SETTINGS_TOTALS"),icon:"sap-icon://sum",action:[{sName:"Aggregate",oMDCColumn:t},h,this]})}}function h(e,t){const n=t.sName,r=t.oMDCColumn.getParent(),o=r.getCurrentState().groupLevels||[],s=r.getCurrentState().aggregations||{},l=Object.keys(s),u=e.getParameter("property"),g=n==="Aggregate"?o:l,c=g.filter(function(e){return n==="Aggregate"?e.name===u:e===u}).length>0;let p=false;if(c){const e=a.getLibraryResourceBundle("sap.ui.mdc");let t;let o;let s;if(n==="Aggregate"){t=e.getText("table.SETTINGS_WARNING_TITLE_TOTALS");o=e.getText("table.SETTINGS_MESSAGE2");s=e.getText("table.SETTINGS_WARNING_BUTTON_TOTALS")}else{t=e.getText("table.SETTINGS_WARNING_TITLE_GROUPS");o=e.getText("table.SETTINGS_MESSAGE1");s=e.getText("table.SETTINGS_WARNING_BUTTON_GROUP")}p=true;i.warning(o,{id:r.getId()+"-messageBox",title:t,actions:[s,e.getText("table.SETTINGS_WARNING_BUTTON_CANCEL")],onClose:function(e){if(e===s){A(n,r,u)}}})}if(n==="Aggregate"&&!p){O(n,r,u)}else if(n==="Group"&&!p){O(n,r,u)}}function O(e,t,n){if(e==="Group"){t._onCustomGroup(n)}else{t._onCustomAggregate(n)}}function A(e,t,n){if(e==="Aggregate"){t._onCustomGroup(n);t._onCustomAggregate(n)}else if(e==="Group"){t._onCustomAggregate(n);t._onCustomGroup(n)}}function E(e,t){const n=d.get(e).plugin;if(!n||n.isDestroyed()){return}const r=e._getGroupedProperties().map(function(e){return e.name});const i=Object.keys(e._getAggregatedProperties());const o=t?t.parameters["$search"]:undefined;if(o){delete t.parameters["$search"]}const s={visible:G(e),groupLevels:r,grandTotal:i,subtotals:i,columnState:N(e,i),search:o};n.setAggregationInfo(s)}function G(e){const t=new Set;e.getColumns().forEach(function(n){const r=e.getPropertyHelper().getProperty(n.getPropertyKey());if(!r){return}r.getSimpleProperties().forEach(function(e){t.add(e.name)})});return Array.from(t)}function N(e,t){const n={};e.getColumns().forEach(function(r){let i=r.getId()+"-innerColumn";const o=R(e,r,t);const s=o.length>0;if(i in n){n[i].subtotals=s||n[i].subtotals;n[i].grandTotal=s||n[i].grandTotal;return}n[i]={subtotals:s,grandTotal:s};L(e,o).forEach(function(e){i=e.getId()+"-innerColumn";if(i in n){n[i].subtotals=s||n[i].subtotals;n[i].grandTotal=s||n[i].grandTotal}else{n[i]={subtotals:s,grandTotal:s}}})});return n}function C(e,t){const n=e.getPropertyHelper().getProperty(t.getPropertyKey());if(!n){return[]}else{return n.getSimpleProperties()}}function R(e,t,n){return C(e,t).filter(function(e){return n.includes(e.name)})}function L(e,t){const n=[];t.forEach(function(e){if(e.unitProperty){n.push(e.unitProperty)}});return e.getColumns().filter(function(t){return C(e,t).some(function(e){return n.includes(e)})})}function x(e,t,n){const r=[];if(t){t.forEach(function(t){e.getPropertyHelper().getProperty(t.name).getSimpleProperties().forEach(function(e){r.push(e.name)})})}const i=n?n.every(function(e){return r.find(function(t){return e.name?e.name===t:e===t})}):true;return!i}function v(e,t){const n={Error:1,Warning:2,Information:3,None:4};if(!t||n[t.validation]-n[e.validation]>0){return e}else{return t}}function M(e){return(e.isGroupingEnabled()||e.isAggregationEnabled())&&e._isOfType(f.Table)}function B(e){if(e._isOfType(f.Table)){return(M(e)?D(e):w(e)).then(function(){return H(e)})}return Promise.resolve()}function D(e){const t=d.get(e);let r=t.plugin;if(r&&!r.isDestroyed()){r.activate();return Promise.resolve()}return Promise.all([e.awaitPropertyHelper(),n("sap/ui/table/plugins/V4Aggregation")]).then(function(n){const i=n[1][0];const o=e.getControlDelegate();r=new i({groupHeaderFormatter:function(t,n){return o.formatGroupHeader(e,t,n)}});r.setPropertyInfos(e.getPropertyHelper().getPropertiesForPlugin());e.propertiesFinalized().then(function(){r.setPropertyInfos(e.getPropertyHelper().getPropertiesForPlugin())});e._oTable.addDependent(r);t.plugin=r})}function w(e){const t=d.get(e);if(t.plugin){t.plugin.deactivate()}return Promise.resolve()}function H(e){const t=d.get(e);if(!t.observer){t.observer=new g(function(t){B(e)});t.observer.observe(e,{properties:["p13nMode"]})}}return T});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/v4/TypeMap", ["../TypeMap","sap/ui/mdc/enums/BaseType"],function(e,t){"use strict";const s=Object.assign({},e);s.addV4Constraint=function(e,t,s){return[e,Object.assign({},t,{V4:true})]};s.import(e);s.set("sap.ui.model.odata.type.DateTimeOffset",t.DateTime,s.addV4Constraint);s.freeze();return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/v4/TypeUtil", ["sap/ui/mdc/odata/TypeUtil","sap/ui/mdc/enums/BaseType","sap/base/util/merge"],function(e,t,a){"use strict";const s=Object.assign({},e);s.getBaseType=function(a,s,i){switch(a){case"sap.ui.model.odata.type.Date":return t.Date;case"sap.ui.model.odata.type.TimeOfDay":return t.Time;case"sap.ui.model.odata.type.Unit":case"sap.ui.model.odata.type.Currency":if(!s||(!s.hasOwnProperty("showMeasure")||s.showMeasure)&&(!s.hasOwnProperty("showNumber")||s.showNumber)){return t.Unit}else if(!s.hasOwnProperty("showNumber")||s.showNumber){return t.Numeric}else{return t.String}default:return e.getBaseType.call(this,a,s,i)}};s.getDataTypeClassName=function(t){const a={"Edm.Date":"sap.ui.model.odata.type.Date","Edm.TimeOfDay":"sap.ui.model.odata.type.TimeOfDay"};if(a[t]){t=a[t]}else{t=e.getDataTypeClassName.call(this,t)}return t};s.getDataTypeInstance=function(e,t,s){switch(e){case"sap.ui.model.odata.type.DateTimeOffset":case"Edm.DateTimeOffset":s=a({},s);s.V4=true;break;default:}const i=this.getDataTypeClass(e);return new i(t,s)};s._adjustUnitFormatOptions=function(t,a,s){e._adjustUnitFormatOptions.call(this,t,a,s);if(t.hasOwnProperty("unitOptional")){delete t.unitOptional}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/v4/ValueHelpDelegate", ["../../ValueHelpDelegate","sap/base/Log","sap/ui/model/FilterType","sap/base/util/deepEqual","sap/ui/mdc/odata/v4/TypeMap"],function(e,t,n,i,r){"use strict";const s=Object.assign({},e);s.getTypeMap=function(e){return r};s.isSearchSupported=function(e,t,n){return!!n.changeParameters};s.updateBindingInfo=function(t,n,i){e.updateBindingInfo(t,n,i);if(n.getFilterFields()==="$search"){const e=n._getPriorityFilterBar();let r=n.isTypeahead()?n._getPriorityFilterValue():e&&e.getSearch();if(this.adjustSearch){r=this.adjustSearch(t,n.isTypeahead(),r)}i.parameters.$search=r||undefined}};s.updateBinding=function(e,t,i){const r=t.getRootBinding()||t;if(!r.isSuspended()){r.suspend()}t.changeParameters(i.parameters);t.filter(i.filters,n.Application);if(r.isSuspended()){r.resume()}};s.executeFilter=function(e,t,n){t.getContexts(0,n);return Promise.resolve(this.checkListBindingPending(e,t,n)).then(function(){return t})};s.checkListBindingPending=function(e,t,n){if(!t||t.isSuspended()){return false}return t.requestContexts(0,n).then(function(e){return e.length===0})};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/v4/util/DelegateUtil", ["sap/ui/mdc/util/FilterUtil","sap/ui/mdc/condition/ConditionConverter","sap/base/Log","sap/base/util/merge","sap/ui/model/FilterOperator","sap/ui/model/odata/v4/ODataUtils"],function(e,t,a,r,n,o){"use strict";const i={_getParameters:function(e){let t=null;if(e&&e.getDelegate()&&e.getDelegate().payload&&e.getDelegate().payload.collectionName){const a=e.getDelegate().payload.collectionName;if(window[e.getId()+"->"+a+"-Parameters"]){t=window[e.getId()+"->"+a+"-Parameters"]}}return t},getParametersInfo:function(e){const t=i._getParameters(e);return i._getParameterPath(e,t)},_getParametersListUrl:function(t,a){const r=[];const i=e.getConditionsMap(t,a);const s=t.getPropertyInfoSet();a.forEach(function(t){const a=e.getPropertyByKey(s,t);if(a&&a.maxConditions===1){i[t].forEach(function(e){if(e.operator===n.EQ){r.push(t+"="+encodeURIComponent(o.formatLiteral(e.values[0],a.typeConfig.className)))}})}});return r},_getParameterPath:function(e,t){if(!e||!e.isA("sap.ui.mdc.FilterBar")){return null}if(!t||t.parameters.length<=0){return null}const a=e.getDelegate().payload.collectionName;const r=i._getParametersListUrl(e,t.parameters);return"/"+a+"("+r.toString()+")/"+t.parameterNavigationName},getParameterNames:function(e){let t=null;const a=i._getParameters(e);if(a){t=a.parameters}return t}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/v4/vizChart/ChartDelegate", ["sap/ui/mdc/odata/v4/ChartDelegate","sap/ui/core/Core","sap/m/Text","sap/base/Log","sap/ui/mdc/util/FilterUtil","sap/ui/mdc/odata/v4/util/DelegateUtil","sap/ui/mdc/chart/ChartTypeButton","sap/ui/mdc/chart/Item","sap/ui/model/Sorter","sap/ui/mdc/chart/ChartImplementationContainer","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/p13n/panels/ChartItemPanel","sap/m/MessageStrip","sap/ui/mdc/FilterBarDelegate","sap/ui/model/Filter","sap/ui/mdc/chart/PropertyHelper","sap/ui/thirdparty/jquery","sap/ui/mdc/enums/ChartItemRoleType"],function(t,e,n,i,r,a,o,s,l,u,g,h,c,d,p,f,jQuery,y){"use strict";const m=Object.assign({},t);const _=new window.WeakMap;let C;let b;let I;let S;m._getState=function(t){if(_.has(t)){return _.get(t)}if(t){i.info("Couldn't get state for "+t.getId())}};m._setState=function(t,e){_.set(t,e)};m.getFilterDelegate=function(){return d};m.addCondition=function(t,e,n){return Promise.resolve()};m.removeCondition=function(t,e,n){return Promise.resolve()};m._deleteState=function(t){if(this._getState(t)){if(this._getState(t).vizTooltip){this._getState(t).vizTooltip.destroy()}if(this._getState(t).observer){this._getState(t).observer.disconnect();this._getState(t).observer=null}}return _.delete(t)};m._getChart=function(t){if(_.has(t)){return _.get(t).innerChart}if(t){i.info("Couldn't get state for "+t.getId())}return undefined};m._setChart=function(t,e){if(_.has(t)){_.get(t).innerChart=e}else{_.set(t,{innerChart:e})}};m._getInnerStructure=function(t){if(_.has(t)){return _.get(t).innerStructure}if(t){i.info("Couldn't get state for "+t.getId())}return undefined};m._setInnerStructure=function(t,e){if(_.has(t)){_.get(t).innerStructure=e}else{_.set(t,{innerStructure:e})}};m._getBindingInfoFromState=function(t){if(_.has(t)){return _.get(t).bindingInfo}if(t){i.info("Couldn't get state for "+t.getId())}return undefined};m._setBindingInfoForState=function(t,e){if(_.has(t)){_.get(t).bindingInfo=e}else{_.set(t,{bindingInfo:e})}};m._setUpChartObserver=function(t){const e=this._getState(t);if(!e.observer){e.observer=new g(function(t){if(t.type==="destroy"){this.exit(t.object)}}.bind(this))}e.observer.observe(t,{destroy:true})};m.exit=function(t){if(this._getInnerStructure(t)){this._getInnerStructure(t).destroy()}this._deleteState(t)};m.zoomIn=function(t){const e=this._getChart(t);if(e){e.zoom({direction:"in"})}};m.zoomOut=function(t){const e=this._getChart(t);if(e){e.zoom({direction:"out"})}};m.getZoomState=function(t){if(this._getChart(t)){return this._getChart(t).getZoomInfo(this)}};m.getInnerChartSelectionHandler=function(t){return{eventId:"_selectionDetails",listener:this._getChart(t)}};m.getChartTypeLayoutConfig=function(){if(this._aChartTypeLayout){return this._aChartTypeLayout}const t=[y.axis1,y.category,y.series];const e=[y.axis1,y.axis2,y.category,y.series];const n=[y.axis1,y.category,y.category2];const i=[y.axis1,y.axis2,y.axis3,y.category,y.series];this._aChartTypeLayout=[{key:"column",allowedLayoutOptions:t},{key:"bar",allowedLayoutOptions:t},{key:"line",allowedLayoutOptions:t},{key:"combination",allowedLayoutOptions:t},{key:"pie",allowedLayoutOptions:t},{key:"donut",allowedLayoutOptions:t},{key:"dual_column",allowedLayoutOptions:e},{key:"dual_bar",allowedLayoutOptions:e},{key:"dual_line",allowedLayoutOptions:e},{key:"stacked_bar",allowedLayoutOptions:t},{key:"scatter",allowedLayoutOptions:e},{key:"bubble",allowedLayoutOptions:i},{key:"heatmap",allowedLayoutOptions:n},{key:"bullet",allowedLayoutOptions:t},{key:"vertical_bullet",allowedLayoutOptions:t},{key:"dual_stacked_bar",allowedLayoutOptions:e},{key:"100_stacked_bar",allowedLayoutOptions:t},{key:"stacked_column",allowedLayoutOptions:t},{key:"dual_stacked_column",allowedLayoutOptions:e},{key:"100_stacked_column",allowedLayoutOptions:t},{key:"dual_combination",allowedLayoutOptions:e},{key:"dual_horizontal_combination",allowedLayoutOptions:e},{key:"dual_horizontal_combination",allowedLayoutOptions:e},{key:"dual_stacked_combination",allowedLayoutOptions:e},{key:"dual_horizontal_stacked_combination",allowedLayoutOptions:e},{key:"stacked_combination",allowedLayoutOptions:t},{key:"100_dual_stacked_bar",allowedLayoutOptions:t},{key:"100_dual_stacked_column",allowedLayoutOptions:t},{key:"horizontal_stacked_combination",allowedLayoutOptions:t},{key:"waterfall",allowedLayoutOptions:n},{key:"horizontal_waterfall",allowedLayoutOptions:n}];return this._aChartTypeLayout};m.getAdaptionUI=function(t){return Promise.resolve(this._setupAdaptionUI(t))};m._setupAdaptionUI=function(t){let e=this.getChartTypeLayoutConfig().find(function(e){return e.key===t.getChartType()});if(!e){const n=[y.axis1,y.axis2,y.axis3,y.category,y.category2,y.series];e={key:t.getChartType(),allowedLayoutOptions:n}}const n=[{kind:"Groupable"},{kind:"Aggregatable"}];e.templateConfig=n;const i={panelConfig:e};const r=new h(i);if(t.getChartType()==="heatmap"){const t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");r.setMessageStrip(new c({text:t.getText("chart.PERSONALIZATION_DIALOG_MEASURE_WARNING"),type:"Warning"}))}return r};m.setLegendVisible=function(t,e){if(this._getChart(t)){this._getChart(t).setVizProperties({legend:{visible:e},sizeLegend:{visible:e}})}else{i.error("Could not set legend visibility since inner chart is not yet initialized!")}};m._getSorterForItem=function(t,e){if(t.getType()==="aggregatable"){return new l(this._getAggregatedMeasureNameForMDCItem(t),e.descending)}else if(t.getType()==="groupable"){return new l(this.getInternalChartNameFromPropertyNameAndKind(e.name,"groupable",t.getParent()),e.descending)}};m.insertItemToInnerChart=function(t,e,n){if(e.getType()==="groupable"){const i=this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",t);const r=this._getChart(t).getDimensionByName(i);if(!r){this.createInnerDimension(t,e)}else{r.setLabel(e.getLabel());r.setRole(e.getRole()?e.getRole():"category")}const a=this._getChart(t).getVisibleDimensions();a.splice(n,0,i);this._getChart(t).setVisibleDimensions(a)}else if(e.getType()==="aggregatable"){this.createInnerMeasure(t,e);const i=this._getChart(t).getVisibleMeasures();i.splice(n,0,this._getAggregatedMeasureNameForMDCItem(e));this._getChart(t).setVisibleMeasures(i)}this._prepareColoringForItem(e).then(function(){this._updateColoring(t,this._getChart(t).getVisibleDimensions(),this._getChart(t).getVisibleMeasures())}.bind(this));this._updateSemanticalPattern(t)};m.removeItemFromInnerChart=function(t,e){if(e.getType()==="groupable"&&this._getChart(t).getVisibleDimensions().includes(this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",t))){const n=this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",t);const i=this._getChart(t).getVisibleDimensions().filter(function(t){return t!==n});if(this._getState(t).inResultDimensions.length>0){this._getChart(t).setInResultDimensions(this._getState(t).inResultDimensions)}this._getChart(t).setVisibleDimensions(i)}else if(e.getType()==="aggregatable"&&this._getChart(t).getVisibleMeasures().includes(this._getAggregatedMeasureNameForMDCItem(e))){const n=[];t.getItems().filter(function(t){return t.getType()==="aggregatable"}).filter(function(t){return t!==e}).forEach(function(t){n.push(this._getAggregatedMeasureNameForMDCItem(t))}.bind(this));this._getChart(t).setVisibleMeasures(n);this._getChart(t).removeMeasure(this._getChart(t).getMeasureByName(this._getAggregatedMeasureNameForMDCItem(e)))}this._updateColoring(t,this._getChart(t).getVisibleDimensions(),this._getChart(t).getVisibleMeasures());this._updateSemanticalPattern(t)};m.addItem=function(t,e,n,i){if(t.getModel){return Promise.resolve(this._createMDCChartItem(e,t,i))}};m.removeItem=function(t,e){return Promise.resolve(true)};m.checkAndUpdateMDCItems=function(t){return new Promise(function(e,n){const i=[];t.getItems().forEach(function(e){const n=e.getPropertyKey()&&e.getLabel()&&e.getType()&&e.getRole();if(!n){i.push(this._getPropertyInfosByName(e.getPropertyKey(),t).then(function(t){e.setLabel(t.label);if(t.groupable){e.setType("groupable");e.setRole(e.getRole()?e.getRole():"category")}else if(t.aggregatable){e.setType("aggregatable");e.setRole(e.getRole()?e.getRole():"axis1")}}))}}.bind(this));Promise.all(i).then(function(){e()})}.bind(this))};m._createMDCChartItem=function(t,e,n){return this._getPropertyInfosByName(t,e).then(function(t){if(!t){return null}return this._createMDCItemFromProperty(t,e.getId(),n)}.bind(this))};m._createMDCItemFromProperty=function(t,e,n){if(t.groupable){return new s(e+"--GroupableItem--"+t.name,{propertyKey:t.name,label:t.label,type:"groupable",role:n?n:"category"})}if(t.aggregatable){return new s(e+"--AggregatableItem--"+t.name,{propertyKey:t.name,label:t.label,type:"aggregatable",role:n?n:"axis1"})}return null};m.initializeInnerChart=function(t){return new Promise(function(e,i){this._loadChart().then(function(i){let r;this._setInnerStructure(t,new u(t.getId()+"--implementationContainer",{}));t.addStyleClass("sapUiMDCChartTempTextOuter");if(t.getNoData()){this._getInnerStructure(t).setChartNoDataContent(t.getNoData())}else{r=new n({text:t.getNoDataText()});this._getInnerStructure(t).addStyleClass("sapUiMDCChartTempText");this._getInnerStructure(t).setNoDataContent(r)}this._setUpChartObserver(t);e(this._getInnerStructure(t))}.bind(this))}.bind(this))};m.changedNoDataStruct=function(t){if(this._getInnerStructure(t)){this._getInnerStructure(t).setChartNoDataContent(t.getNoData());this._getInnerStructure(t).invalidate()}};m._createContentFromItems=function(t){return new Promise(function(e,n){const r=[];const a=[];const o=[];const s=[];t.getItems().forEach(function(e,n){a.push(this._getPropertyInfosByName(e.getPropertyKey(),t).then(function(n){if(!n){i.error("sap.ui.mdc.Chart: Item "+e.getPropertyKey()+" has no property info representing it in the metadata. Make sure the name is correct and the metadata is defined correctly. Skipping the item!");return}switch(e.getType()){case"groupable":o.push(this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",t));this._addInnerDimension(t,e,n);break;case"aggregatable":s.push(this._getAggregatedMeasureNameForMDCItem(e));this._addInnerMeasure(t,e,n);break;default:i.error("MDC Chart Item "+e.getId()+" with label "+e.getLabel()+' has no known type. Supported typed are: "groupable" & "aggregatable"')}r.push(this._prepareColoringForItem(e))}.bind(this)))}.bind(this));Promise.all(a).then(function(){this._getState(t).aColMeasures.forEach(function(e){if(this._getState(t).aInSettings.indexOf(e)==-1){r.push(new Promise(function(n,i){t._getPropertyByNameAsync(e).then(function(i){const r=i.aggregationMethod;const a=i.propertyPath;const o=this.getInternalChartNameFromPropertyNameAndKind(e,"aggregatable",t);const l={name:o,label:i.label,role:"axis1"};if(r&&a){l.analyticalInfo={propertyPath:a,with:r}}const u=new I(l);s.push(u);this._getChart(t).addMeasure(u);n()})}))}}.bind(this));Promise.all(r).then(function(){this._getChart(t).setVisibleDimensions(o);this._getChart(t).setVisibleMeasures(s);const n=t.getDelegate().inResultDimensions;if(n&&n instanceof Array&&n.length!=0){const e=[];n.forEach(function(n){e.push(this._getPropertyInfosByName(n,t).then(function(e){const n=this.getInternalChartNameFromPropertyNameAndKind(e.name,"groupable",t);const i=new b({name:n,label:e.label});this._getState(t).inResultDimensions.push(n);this._getChart(t).addDimension(i)}.bind(this)))}.bind(this));Promise.all(e).then(function(){this._getChart(t).setInResultDimensions(this._getState(t).inResultDimensions)}.bind(this))}this._updateColoring(t,o,s);this._updateSemanticalPattern(t);e()}.bind(this))}.bind(this))}.bind(this))};m.getInnerChart=function(t){return this._getChart(t)};m._prepareColoringForItem=function(t){return this._addCriticality(t).then(function(){this._getState(t.getParent()).aInSettings.push(t.getPropertyKey());if(t.getType()==="aggregatable"){this._getPropertyInfosByName(t.getPropertyKey(),t.getParent()).then(function(e){this._getAdditionalColoringMeasuresForItem(e).forEach(function(e){if(this._getState(t.getParent()).aColMeasures&&this._getState(t.getParent()).aColMeasures.indexOf(e)==-1){this._getState(t.getParent()).aColMeasures.push(e)}}.bind(this))}.bind(this))}}.bind(this))};m._getAdditionalColoringMeasuresForItem=function(t){let e=[];const n=t.datapoint?t.datapoint.criticality:null;if(n&&n.DynamicThresholds){e=n.DynamicThresholds.usedMeasures}return e};m._addCriticality=function(t){return this._getPropertyInfosByName(t.getPropertyKey(),t.getParent()).then(function(e){if(e.criticality||e.datapoint&&e.datapoint.criticality){const n=this._getState(t.getParent()).oColorings||{Criticality:{DimensionValues:{},MeasureValues:{}}};const i={};if(t.getType()=="groupable"){const r=e.criticality?e.criticality:[];for(const t in r){i[t]={Values:r[t]}}const a=this.getInternalChartNameFromPropertyNameAndKind(t.getPropertyKey(),"groupable",t.getParent());n.Criticality.DimensionValues[a]=i}else{const r=e.datapoint&&e.datapoint.criticality?e.datapoint.criticality:[];for(const t in r){i[t]=r[t]}const a=this.getInternalChartNameFromPropertyNameAndKind(t.getPropertyKey(),"aggregatable",t.getParent());n.Criticality.MeasureValues[a]=i}const r=this._getState(t.getParent());r.oColorings=n;this._setState(t.getParent(),r)}}.bind(this))};m._updateColoring=function(t,e,n){const i=jQuery.extend(true,{},this._getState(t).oColorings);let r;if(i&&i.Criticality){let a;for(r=0;r<e.length;r++){if(this._getState(t).oColorings.Criticality.DimensionValues[e[r]]){a={coloring:"Criticality",parameters:{dimension:e[r]}};delete i.Criticality.MeasureValues;break}}if(!a){delete i.Criticality.DimensionValues;for(const t in i.Criticality.MeasureValues){if(n.indexOf(t)==-1){delete i.Criticality.MeasureValues[t]}}a={coloring:"Criticality",parameters:{measure:n}}}if(a){this._getChart(t).setColorings(i);this._getChart(t).setActiveColoring(a)}}};m._updateSemanticalPattern=function(t){const e=this._getChart(t).getVisibleMeasures();e.forEach(function(e){const n=this.getPropertyFromNameAndKind(e,"aggregatable",t);if(!n){return}const r=n.datapoint;if(r){if(r.targetValue||r.foreCastValue){const n=this._getChart(t).getMeasureByName(e);n.setSemantics("actual");if(r.targetValue!=null){const e=this._getChart(t).getMeasureByName(r.targetValue);if(e){e.setSemantics("reference")}else{i.error("sap.ui.mdc.Chart: "+r.targetValue+" is not a valid measure")}}if(r.foreCastValue){const e=this._getChart(t).getMeasureByName(r.foreCastValue);if(e){e.setSemantics("projected")}else{i.error("sap.ui.comp.SmartChart: "+r.ForecastValue.Path+" is not a valid measure")}}n.setSemanticallyRelatedMeasures({referenceValueMeasure:r.targetValue,projectedValueMeasure:r.foreCastValue})}}}.bind(this))};m.getChartTypeInfo=function(t){const n=t.getChartType(),i=e.getLibraryResourceBundle("sap.ui.mdc"),r=e.getLibraryResourceBundle("sap.chart.messages");const a={icon:o.mMatchingIcon[n],text:i.getText("chart.CHART_TYPE_TOOLTIP",[r.getText("info/"+n)])};return a};m.getAvailableChartTypes=function(t){const n=[];if(this._getChart(t)){const i=this._getChart(t).getAvailableChartTypes().available;const r=e.getLibraryResourceBundle("sap.chart.messages");for(let e=0;e<i.length;e++){const a=i[e].chart;n.push({key:a,icon:o.mMatchingIcon[a],text:r.getText("info/"+a),selected:a==t.getChartType()})}}return n};m.getDrillStack=function(t){const e=Object.assign([],this._getChart(t).getDrillStack());e.forEach(function(e){e.dimension=e.dimension.map(function(e){const n=this.getPropertyFromNameAndKind(e,"groupable",t);if(n){return n.name}else{i.error("MDC Chart Delegate: Couldn't map chart dimension to groupable property: "+e);return e}}.bind(this))}.bind(this));return e};m.getSortedDimensions=function(t){return new Promise(function(e,n){if(t.isPropertyHelperFinal()){e(this._sortPropertyDimensions(t.getPropertyHelper().getProperties()))}else{t.finalizePropertyHelper().then(function(){e(this._sortPropertyDimensions(t.getPropertyHelper().getProperties()))}.bind(this))}}.bind(this))};m._sortPropertyDimensions=function(t){const e=t.filter(function(t){return t.groupable});if(e){e.sort(function(t,e){if(t.label&&e.label){return t.label.localeCompare(e.label)}})}return e};m.getDrillableItems=function(t){const e=t.getItems().filter(function(t){return t.getType()==="groupable"});return e};m.setChartType=function(t,e){this._getChart(t).setChartType(e)};m.createInnerChartContent=function(t,e){return new Promise(function(n,r){this._setChart(t,new C({id:t.getId()+"--innerChart",chartType:"column",height:"100%",width:"100%",isAnalytical:true}));this._getChart(t).setCustomMessages({NO_DATA:t.getNoDataText()});this._getState(t).inResultDimensions=[];this._getInnerStructure(t).removeStyleClass("sapUiMDCChartTempText");t.removeStyleClass("sapUiMDCChartTempTextOuter");t.addStyleClass("sapUiMDCChartGrid");const a=this._getState(t);a.aColMeasures=[];a.aInSettings=[];this._setState(t,a);this._createContentFromItems(t).then(function(){this._getChart(t).attachRenderComplete(function(){if(this._getState(t).toolbarUpdateRequested){t._updateToolbar();this._getState(t).toolbarUpdateRequested=false}}.bind(this));this._getInnerStructure(t).setContent(this._getChart(t));this._getInnerStructure(t).setShowNoDataStruct(false);a.dataLoadedCallback=e;this._setState(t,a);let r;if(this._getBindingInfo){r=this._getBindingInfo(t);i.warning("mdc ChartDelegate","calling the private delegate._getBindingInfo. Please make the function public!")}else{r=this.getBindingInfo(t)}this.updateBindingInfo(t,r);this._performInitialBind(t,r);n()}.bind(this))}.bind(this))};m._performInitialBind=function(t,e){if(t&&e&&this._getChart(t)){this._addBindingListener(e,"dataReceived",this._onDataLoadComplete.bind(t));this._getChart(t).bindData(e);this._setBindingInfoForState(t,e);const n=this._getState(t);n.innerChartBound=true;this._checkForMeasureWarning(t)}};m.requestToolbarUpdate=function(t){if(t.getItems().length===0){t._updateToolbar();return}this._getState(t).toolbarUpdateRequested=true};m.createInnerDimension=function(t,e){this._getPropertyInfosByName(e.getPropertyKey(),t).then(function(n){this._addInnerDimension(t,e,n)}.bind(this))};m.createInnerMeasure=function(t,e){this._getPropertyInfosByName(e.getPropertyKey(),t).then(function(n){this._addInnerMeasure(t,e,n)}.bind(this))};m._addInnerDimension=function(t,e,n){const i=this.innerDimensionFactory(t,e,n);this._getChart(t).addDimension(i)};m.innerDimensionFactory=function(t,e,n){const i=new b({name:this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",t),role:e.getRole()?e.getRole():"category",label:e.getLabel()});if(n.textProperty){i.setTextProperty(n.textProperty);i.setDisplayText(true)}if(n.textFormatter){i.setTextFormatter(this.formatText.bind(n))}return i};m._addInnerMeasure=function(t,e,n){const i=this.innerMeasureFactory(t,e,n);this._getChart(t).addMeasure(i)};m.innerMeasureFactory=function(t,e,n){const i=n.aggregationMethod;const r=n.propertyPath;const a={name:this._getAggregatedMeasureNameForMDCItem(e),label:e.getLabel(),role:e.getRole()?e.getRole():"axis1"};if(i&&r){a.analyticalInfo={propertyPath:r,with:i}}return new I(a)};m._getAggregatedMeasureNameForProperty=function(t){return t.aggregationMethod+t.name};m.rebind=function(t,e){if(t&&e&&this._getChart(t)){this._addBindingListener(e,"dataReceived",this._onDataLoadComplete.bind(t));this._getInnerStructure(t).setShowNoDataStruct(false);if(e.binding){e.binding.bHasAnalyticalInfo=true}this._getChart(t).bindData(e);this._setBindingInfoForState(t,e);const n=this._getState(t);n.innerChartBound=true}};m._checkForMeasureWarning=function(t){if(!t.getNoData()){return}const e=t.getItems().filter(function(t){return t.getType()==="aggregatable"});if(e.length===0){this._getInnerStructure(t).setShowNoDataStruct(true);t.setBusy(false)}else{this._getInnerStructure(t).setShowNoDataStruct(false)}};m.getBindingInfo=function(t){if(this._getBindingInfoFromState(t)){return this._getBindingInfoFromState(t)}const e=t.getDelegate().payload;const n="/"+e.collectionName;const i={path:n};return i};m.getInnerChartBound=function(t){const e=this._getState(t);if(!e){return false}return e.innerChartBound?true:false};m.updateBindingInfo=function(t,e){const n=P.call(this,t).concat(D.call(this,t));M(t,e);e.filters=new p(n,true);e.sorter=this.getSorters(t)};function P(t){const e=t.getP13nMode().indexOf("Filter")>-1;const n=[];if(e){const e=t.getPropertyHelper().getProperties();const i=r.getFilterInfo(this.getTypeMap(),t.getConditions(),e);if(i.filters){n.push(i.filters)}}return n}function D(t){const n=e.byId(t.getFilter());const i=[];if(!n){return i}const o=n.getConditions();if(o){const t=n.getPropertyInfoSet?n.getPropertyInfoSet():null;const e=a.getParameterNames(n);const s=r.getFilterInfo(this.getTypeMap(),o,t,e);if(s.filters){i.push(s.filters)}}return i}function M(t,n){const i=e.byId(t.getFilter());if(!i){return}const r=i.getConditions();const o=i.getSearch instanceof Function?i.getSearch():"";if(r){const t=a.getParametersInfo(i,r);if(t){n.path=t}}if(!n.parameters){n.parameters={}}n.parameters["$search"]=o||undefined}m.getSorters=function(t){let e;const n=t.getSortConditions()?t.getSortConditions().sorters:[];n.forEach(function(n){const i=t.getItems().find(function(t){return t.getPropertyKey()===n.name});if(!i){return}const r=this._getSorterForItem(i,n);if(e){e.push(r)}else{e=[r]}}.bind(this));return e};m._getAggregatedMeasureNameForMDCItem=function(t){return this.getInternalChartNameFromPropertyNameAndKind(t.getPropertyKey(),"aggregatable",t.getParent())};m.getInternalChartNameFromPropertyNameAndKind=function(t,e,n){return t};m.getPropertyFromNameAndKind=function(t,e,n){return n.getPropertyHelper().getProperty(t)};m.setChartTooltipVisibility=function(t,e){if(this._getChart(t)){if(e){if(!this._getState(t).vizTooltip){const e=this._getState(t);e.vizTooltip=new S;this._setState(t,e)}this._getState(t).vizTooltip.connect(this._getChart(t).getVizUid())}else if(this._getState(t).vizTooltip){this._getState(t).vizTooltip.destroy()}}else{i.error("Trying to set chart tooltip while inner chart was not yet initialized")}};m._loadChart=function(){return new Promise(function(t){const n=["sap/chart/Chart","sap/chart/data/Dimension","sap/chart/data/Measure","sap/viz/ui5/controls/VizTooltip"];function i(e,n,i,r){C=e;b=n;I=i;S=r;t()}e.loadLibrary("sap.viz",{async:true}).then(function(){sap.ui.require(n,i)})})};m.getPropertyHelperClass=function(){return f};m.formatText=function(t,e){return t};m.setNoDataText=function(t,e){this._getChart(t).setCustomMessages({NO_DATA:e})};m.showOverlay=function(t,e){if(this._getInnerStructure(t)){this._getInnerStructure(t).showOverlay(e)}};m._getPropertyInfosByName=function(t,e){return e._getPropertyByNameAsync(t)};m._getModel=function(t){const e=t.getDelegate().payload;return t.getModel(e.model)};m._addBindingListener=function(t,e,n){if(!t.events){t.events={}}if(!t.events[e]){t.events[e]=n}else{const i=t.events[e];t.events[e]=function(){n.apply(this,arguments);i.apply(this,arguments)}}};m._onDataLoadComplete=function(t){const e=this.getControlDelegate()._getInnerStructure(this);if(this.getNoData()){if(t.getSource()&&t.getSource().getCurrentContexts().length===0){e.setShowNoDataStruct(true)}else{e.setShowNoDataStruct(false)}}this._innerChartDataLoadComplete(t)};return m});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/P13nBuilder", ["./PropertyHelper","sap/m/Button","sap/m/Bar","sap/m/Title","sap/base/util/merge","sap/m/MessageBox","sap/ui/Device","sap/ui/fl/write/api/FieldExtensibility","sap/ui/core/Configuration","sap/ui/core/library"],function(e,t,n,o,i,r,s,a,c,u){"use strict";const l=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");const p=u.TitleLevel;const g={createP13nPopover:function(e,t){return new Promise(function(n,o){sap.ui.require(["sap/m/ResponsivePopover"],function(i){g["_checkSettings"](e,t,o);const r=new i({title:t.title,horizontalScrolling:t.hasOwnProperty("horizontalScrolling")?t.horizontalScrolling:false,verticalScrolling:t.hasOwnProperty("verticalScrolling")?t.verticalScrolling:false,contentWidth:t.contentWidth?t.contentWidth:"24rem",resizable:t.hasOwnProperty("resizable")?t.resizable:true,contentHeight:t.contentHeight?t.contentHeight:"35rem",placement:t.placement?t.placement:"Bottom",content:e,afterClose:t.afterClose?t.afterClose:function(){}});if(t.reset){const e=g._createResetHeader({title:t.title,reset:t.reset.onExecute,idResetButton:t.reset.idButton,warningText:t.reset.warningText});r.setCustomHeader(e)}n(r)},o)})},createP13nDialog:function(e,t){return new Promise(function(n,o){g["_checkSettings"](e,t,o);const i=t.id;sap.ui.require(["sap/m/Dialog","sap/m/Button"],function(r,a){const c=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");const u=new r(i,{title:t.title,horizontalScrolling:t.hasOwnProperty("horizontalScrolling")?t.horizontalScrolling:false,verticalScrolling:t.hasOwnProperty("verticalScrolling")?t.verticalScrolling:true,contentWidth:t.contentWidth?t.contentWidth:"40rem",contentHeight:t.contentHeight?t.contentHeight:"55rem",draggable:true,resizable:true,stretch:s.system.phone,content:e,afterClose:t.afterClose?t.afterClose:function(){},buttons:[new a(i?i+"-confirmBtn":undefined,{text:t.confirm&&t.confirm.text?t.confirm.text:c.getText("p13nDialog.OK"),type:"Emphasized",press:function(){if(t.confirm&&t.confirm.handler){t.confirm.handler.apply(u,arguments)}}}),new a(i?i+"-cancelBtn":undefined,{text:c.getText("p13nDialog.CANCEL"),press:function(){t.cancel.apply(u,arguments)}})]});if(t.reset){const e=g._createResetHeader({title:t.title,idResetButton:t.reset.idButton,reset:t.reset.onExecute,warningText:t.reset.warningText});u.setCustomHeader(e)}const l=t.additionalButtons;if(l instanceof Array){l.forEach(function(e){if(!e.isA("sap.m.Button")){o("Please only provide sap.m.Button instances as 'additionalButtons'")}u.addButton(e)})}n(u)},o)})},_createResetHeader:function(e){const i=new n({contentLeft:[new o({text:e.title,level:p.H1})]});if(e.reset){const n=e.idResetButton;i.addContentRight(new t(n,{text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("p13nDialog.RESET"),press:function(t){const n=t.getSource().getParent().getParent();const o=n.getParent();const i=e.warningText?e.warningText:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("filterbar.ADAPT_RESET_WARNING");r.warning(i,{actions:[r.Action.OK,r.Action.CANCEL],emphasizedAction:r.Action.OK,onClose:function(t){if(t===r.Action.OK){n.getButtons()[0].focus();e.reset(o)}}})}}))}return i},prepareAdaptationData:function(t,n,o){const i=t&&t.getProperties instanceof Function?t:new e(t);const r=[];const s=o?{}:null;const a=n instanceof Function;i.getProperties().forEach(function(e){const t={};t.name=e.name;if(a){const o=n(t,e);if(!o){return}}t.label=e.label||e.name;t.tooltip=e.tooltip;if(s){t.group=e.group?e.group:"BASIC";t.groupLabel=e.groupLabel;s[t.group]=s[t.group]?s[t.group]:[];s[t.group].push(t)}r.push(t)});const c={items:r};if(s){c.itemsGrouped=this._buildGroupStructure(s)}return c},sortP13nData:function(e,t){const n=e;const o=n.position;const i=n.visible;const r=c.getLocale().toString();const s=window.Intl.Collator(r,{});t.sort(function(e,t){if(e[i]&&t[i]){return(e[o]||0)-(t[o]||0)}else if(e[i]){return-1}else if(t[i]){return 1}else if(!e[i]&&!t[i]){return s.compare(e.label,t.label)}})},_buildGroupStructure:function(e){const t=[];Object.keys(e).forEach(function(n){this.sortP13nData("generic",e[n]);t.push({group:n,groupLabel:e[n][0].groupLabel||l.getText("p13nDialog.FILTER_DEFAULT_GROUP"),groupVisible:true,items:e[n]})}.bind(this));return t},_isExcludeProperty:function(e,t){return t.some(function(t){const n=t.ignoreKey;const o=t.ignoreValue;return e[n]===o})},_checkSettings:function(e,t,n){if(!t){n("Please provide a settings object for p13n creation")}if(!t.title&&!t.customHeader){n("Please provide a title or customHeader in the settings object for p13n creation")}},arrayToMap:function(e){return e.reduce(function(e,t,n){e[t.name]=t;e[t.name].position=n;return e},{})},addRTACustomFieldButton:function(e,i){let r=false,s=e.getParent();if(i&&i.isA("sap.ui.comp.smarttable.SmartTable")){s=i}return sap.ui.getCore().loadLibrary("sap.ui.rta",{async:true}).then(function(){return new Promise(function(i){sap.ui.require(["sap/ui/rta/Utils"],function(c){const u=Promise.all([a.onControlSelected(s),c.isServiceUpToDate(s),a.isExtensibilityEnabled(s)]);return u.then(function(e){r=!!e[2]}).then(function(){let u=e.getCustomHeader();const l=s&&s.getId?s.getId():undefined,g=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");if(!u){const t=new n({contentLeft:[new o({text:e.getTitle(),level:p.H1})]});e.setCustomHeader(t);u=e.getCustomHeader()}if(r){u.addContentRight(new t(l+"-addCustomField",{icon:"sap-icon://add",enabled:r,tooltip:g.getText("p13nDialog.rtaAddTooltip"),press:function(e){const t=c.getRtaStyleClassName(),n=e.getSource().getParent().getParent();a.getExtensionData().then(function(e){a.onTriggerCreateExtensionData(e,t);n.close()})}}));e.setCustomHeader(u);i(e)}})})})})}};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/PersistenceProvider", ["sap/m/p13n/PersistenceProvider"],function(e){"use strict";return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/PropertyHelper", ["../util/PropertyHelper"],function(e){"use strict";const t=e.extend("sap.ui.mdc.p13n.PropertyHelper",{constructor:function(t,r){e.call(this,t,r,{filterable:true,sortable:true})}});t.prototype.validateProperties=function(){};t.prototype.prepareProperty=function(t){e.prototype.prepareProperty.apply(this,arguments);t.label=t.label||t.name};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/StateUtil", ["sap/m/p13n/Engine"],function(e){"use strict";const t={applyExternalState:function(t,n){const a=e.getInstance().internalizeKeys(t,n);return e.getInstance().applyState(t,a,false)},retrieveExternalState:function(t){return e.getInstance().retrieveState(t).then(function(n){return e.getInstance().externalizeKeys(t,n)})},resetState:function(t){const n=e.getInstance().getRegisteredControllers(t);return e.getInstance().reset(t,n)},diffState:function(t,n,a){return e.getInstance().diffState(t,e.getInstance().internalizeKeys(t,n),e.getInstance().internalizeKeys(t,a)).then(function(n){return e.getInstance().externalizeKeys(t,n)})},attachStateChange:function(t){e.getInstance().stateHandlerRegistry.attachChange(t)},detachStateChange:function(t){e.getInstance().stateHandlerRegistry.detachChange(t)}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/panels/ActionToolbarPanel", ["sap/m/p13n/SelectionPanel","sap/ui/model/Sorter"],function(t,e){"use strict";const o=t.extend("sap.ui.mdc.p13n.panels.ActionToolbarPanel",{metadata:{library:"sap.ui.mdc"},renderer:{apiVersion:2}});o.prototype._bindListItems=function(t){const o=this.getAggregation("_template");if(o){const o=function(t){return t.getProperty("alignment")};const s=new e({path:"alignment",descending:false,group:o});this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/items",sorter:s,key:"name",templateShareable:false,template:this.getAggregation("_template").clone()},t))}};o.prototype._removeFactoryControl=function(){this._oListControl.getItems().filter(function(t){return!t._bGroupHeader}).forEach(function(t){const e=t.getCells()[0];if(e.getItems().length>1){e.removeItem(e.getItems()[1])}});this.removeStyleClass("sapUiMDCAFLabelMarkingList");return this._aInitializedFields};o.prototype._moveTableItem=function(t,e){const o=this._oListControl.getItems();const s=this._getP13nModel().getProperty("/items");const n=s.indexOf(this._getModelEntry(t));e=e<=0?0:Math.min(e,o.length-1);const i=s.indexOf(o[e].getBindingContext(this.P13N_MODEL).getObject());if(i==n){return}s.splice(i,0,s.splice(n,1)[0]);this._getP13nModel().setProperty("/items",s);this._oSelectedItem=this._oListControl.getItems()[e];this._updateEnableOfMoveButtons(this._oSelectedItem,true);this._handleActivated(this._oSelectedItem);this.fireChange({reason:"Move",item:this._getModelEntry(this._oSelectedItem)})};o.prototype._onPressButtonMoveToTop=function(){let t=this._oListControl.getItems().indexOf(this._oHoveredItem);while(!this._oListControl.getItems()[t-1]._bGroupHeader){t--}this._moveSelectedItem(t)};o.prototype._onPressButtonMoveToBottom=function(){let t=this._oListControl.getItems().indexOf(this._oHoveredItem);while(t<this._oListControl.getItems().length-1&&!this._oListControl.getItems()[t+1]._bGroupHeader){t++}this._moveSelectedItem(t)};o.prototype._onItemPressed=function(t){const e=t.getParameter("srcControl");if(!this._isControlPartOfMoveButtons(e)){const e=t.getParameter("listItem");this._oSelectedItem=e;const o=e.getBindingContext(this.P13N_MODEL);if(this.getEnableReorder()&&o&&o.getProperty(this.PRESENCE_ATTRIBUTE)){this._handleActivated(e);this._updateEnableOfMoveButtons(e,true)}}};o.prototype._isControlPartOfMoveButtons=function(t){const e=this._oSelectedItem?this._oSelectedItem.getCells()[1].getItems():[];let o=false;if(e.length>2){for(let s=2;s<e.length;s++){if(e[s]==t||e[s]==t.getParent()){o=true}}}return o};o.prototype._updateEnableOfMoveButtons=function(t,e){const o=this._oListControl.getItems().indexOf(t);const s=this._oListControl.getItems().length-1;let n=true,i=true;if(o==0){n=false}if(o==s){i=false}const r=this._oListControl.getItems().some(function(t){return t._bGroupHeader});if(r){if(o>0&&this._oListControl.getItems()[o-1]._bGroupHeader){n=false}if(o<s&&this._oListControl.getItems()[o+1]._bGroupHeader){i=false}}this._getMoveTopButton().setEnabled(n);this._getMoveUpButton().setEnabled(n);this._getMoveDownButton().setEnabled(i);this._getMoveBottomButton().setEnabled(i);if(e){t.focus()}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/panels/AdaptFiltersPanel", ["sap/m/p13n/AbstractContainer","sap/m/p13n/AbstractContainerItem","sap/m/p13n/SelectionPanel","./GroupView","sap/ui/model/Filter","sap/m/Button","sap/m/Bar","sap/m/ToolbarSpacer","sap/m/Select","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/m/SearchField","sap/m/OverflowToolbarLayoutData","sap/ui/core/Item","sap/m/library","sap/ui/model/json/JSONModel"],function(t,e,i,n,s,o,r,a,h,c,u,l,p,g,d,_){"use strict";const w=d.BarDesign;const y=t.extend("sap.ui.mdc.p13n.panels.AdaptFiltersPanel",{metadata:{library:"sap.ui.mdc",properties:{itemFactory:{type:"function"},enableReorder:{type:"boolean",defaultValue:true}},events:{change:{}}},renderer:{apiVersion:2}});y.prototype.GROUP_KEY="group";y.prototype.LIST_KEY="list";y.prototype.P13N_MODEL="$p13n";y.prototype.getVerticalScrolling=function(){return true};y.prototype.applySettings=function(s){this.addView(new e({key:this.LIST_KEY,content:new i(this.getId()+"-listView",{activeColumn:this._getResourceText("p13nDialog.LIST_VIEW_ACTIVE"),change:function(t){this.fireChange();this.getP13nModel().setProperty("/items",t.getSource().getP13nData())}.bind(this)})}));this.addView(new e({key:this.GROUP_KEY,content:new n(this.getId()+"-groupView",{change:function(t){this.fireChange();this.getP13nModel().setProperty("/itemsGrouped",t.getSource().getP13nData())}.bind(this)})}));t.prototype.applySettings.apply(this,arguments);this.getView(this.LIST_KEY).getContent().setEnableReorder(this.getEnableReorder());const o=this._getQuickFilter();const h=this._getViewSwitch();const c=this._getShowHideBtn();const u=new r({contentMiddle:[o,new a,c,h]});u.setDesign(w.SubHeader);this.setHeader(u);const l=new r({contentMiddle:[this._getSearchField()]});l.addStyleClass("sapUiMDCAdaptFiltersSearchBar");l.setDesign(w.SubHeader);this.setSubHeader(l);this.addStyleClass("sapUiMDCAdaptFiltersPanel")};y.prototype.setItemFactory=function(t){this.setProperty("itemFactory",t);this.getViews().forEach(function(e){const i=e.getContent();i.setItemFactory(t)});return this};y.prototype.switchView=function(e){const i=e;t.prototype.switchView.call(this,i);this._getShowHideBtn().setVisible(!this._isCustomView());this._getViewSwitch().setSelectedKey(this.getCurrentViewKey());if(!this._isCustomView(e)){this.showFactory(this.getCurrentViewContent()._getShowFactory())}this._filterByModeAndSearch()};y.prototype.addCustomView=function(t){const i=t.item;const n=i.getKey();const s=t.content;const o=t.search;const r=t.selectionChange;const a=t.filterSelect;if(!n){throw new Error("Please provide an item of type sap.m.SegmentedButtonItem with a key")}if(this._oViewSwitch){this._oViewSwitch.attachSelectionChange(function(t){if(r){r(t.getParameter("item").getKey())}if(this._isCustomView()){if(o instanceof Function){o(this._getSearchField().getValue())}if(a instanceof Function){a(this._getQuickFilter().getSelectedKey())}}}.bind(this))}if(o instanceof Function){this._getSearchField().attachLiveChange(function(t){if(this._isCustomView()){o(this._getSearchField().getValue())}}.bind(this))}if(a instanceof Function){this._getQuickFilter().attachChange(function(t){if(this._isCustomView()){a(this._getQuickFilter().getSelectedKey())}}.bind(this))}this.addView(new e({key:n,content:s.addStyleClass("sapUiMDCPanelPadding")}));const h=this._getViewSwitch();h.addItem(i)};y.prototype.showFactory=function(t){if(this.getCurrentViewContent().showFactory){this.getCurrentViewContent().showFactory(t)}};y.prototype.getSelectedFields=function(){return this.getCurrentViewContent().getSelectedFields()};y.prototype.setGroupExpanded=function(t,e){this.getView(this.GROUP_KEY).getContent().setGroupExpanded(t,e)};y.prototype.setP13nModel=function(t){this.setModel(t,this.P13N_MODEL);this.getView(this.LIST_KEY).getContent().setP13nData(t.getProperty("/items"));this.getView(this.GROUP_KEY).getContent().setP13nData(t.getProperty("/itemsGrouped"));this._filterByModeAndSearch()};y.prototype.setP13nData=function(t){const e=this.getP13nModel();if(!e){this.setP13nModel(new _(t))}else{e.setData(t);this.getView(this.LIST_KEY).getContent().setP13nData(e.getProperty("/items"));this.getView(this.GROUP_KEY).getContent().setP13nData(e.getProperty("/itemsGrouped"))}};y.prototype.restoreDefaults=function(){this._getSearchField().setValue("");this._filterByModeAndSearch()};y.prototype.getP13nModel=function(){return this.getModel(this.P13N_MODEL)};y.prototype._getShowHideBtn=function(){const t=this._getResourceText("filterbar.ADAPT_SHOW_VALUE");const e=this._getResourceText("filterbar.ADAPT_HIDE_VALUE");if(!this._oShowHideBtn){this._oShowHideBtn=new o({press:function(i){this.showFactory(!this.getCurrentViewContent()._getShowFactory());const n=i.oSource;const s=n.getText()===t?e:t;n.setText(s)}.bind(this)})}this._oShowHideBtn.setText(!this._isCustomView()&&this.getCurrentViewContent()._getShowFactory()?e:t);return this._oShowHideBtn};y.prototype._getQuickFilter=function(){if(!this._oGroupModeSelect){this._oGroupModeSelect=new h({items:[new g({key:"all",text:this._getResourceText("p13nDialog.GROUPMODE_ALL")}),new g({key:"visible",text:this._getResourceText("p13nDialog.GROUPMODE_VISIBLE")}),new g({key:"active",text:this._getResourceText("p13nDialog.GROUPMODE_ACTIVE")}),new g({key:"visibleactive",text:this._getResourceText("p13nDialog.GROUPMODE_VISIBLE_ACTIVE")}),new g({key:"mandatory",text:this._getResourceText("p13nDialog.GROUPMODE_MANDATORY")})],tooltip:this._getResourceText("p13nDialog.QUICK_FILTER"),change:this._onGroupModeChange.bind(this)})}return this._oGroupModeSelect};y.prototype._getSearchField=function(){if(!this._oSearchField){this._oSearchField=new l(this.getId()+"-searchField",{liveChange:[this._filterByModeAndSearch,this],width:"100%"});this._oSearchField.setPlaceholder(this._getResourceText("p13nDialog.ADAPT_FILTER_SEARCH"))}return this._oSearchField};y.prototype.getInitialFocusedControl=function(){return this._getSearchField()};y.prototype._onGroupModeChange=function(t){this._sModeKey=t.getParameters().selectedItem.getKey();this._filterByModeAndSearch()};y.prototype._getViewSwitch=function(){if(!this._oViewSwitch){this._oViewSwitch=new c({items:[new u({tooltip:this._getResourceText("filterbar.ADAPT_LIST_VIEW"),icon:"sap-icon://list",key:this.LIST_KEY}),new u({tooltip:this._getResourceText("filterbar.ADAPT_GROUP_VIEW"),icon:"sap-icon://group-2",key:this.GROUP_KEY})],selectionChange:function(t){if(this.getCurrentViewKey()===this.LIST_KEY){this.getCurrentViewContent()._removeMoveButtons()}const e=t.getParameter("item").getKey();this.switchView(e)}.bind(this)})}return this._oViewSwitch};y.prototype._isCustomView=function(){return this._sCurrentView!=this.GROUP_KEY&&this._sCurrentView!=this.LIST_KEY};y.prototype._filterByModeAndSearch=function(){if(this._isCustomView(this.getCurrentViewKey())){return}this._sSearchString=this._getSearchField().getValue();const t=this._createFilterQuery();this._getSearchField().setValue(this._sSearchString);this.getCurrentViewContent().filterContent(t);return t};y.prototype._getResourceText=function(t){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText(t)};y.prototype._createFilterQuery=function(){let t=[],e=[],i=[];if(this._sSearchString){t=[new s("label","Contains",this._sSearchString),new s("tooltip","Contains",this._sSearchString)];i=new s(t,false)}switch(this._sModeKey){case"visible":e=new s("visible","EQ",true);break;case"active":e=new s("active","EQ",true);break;case"mandatory":e=new s("required","EQ",true);break;case"visibleactive":e=new s([new s("active","EQ",true),new s("visible","EQ",true)],true);break;default:}const n=new s("visibleInDialog","EQ",true);return new s([].concat(i,e,n),true)};y.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._sModeKey=null;this._sSearchString=null};return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/panels/ChartItemPanel", ["sap/m/p13n/BasePanel","sap/m/Label","sap/m/ColumnListItem","sap/m/Select","sap/m/Text","sap/ui/core/Item","sap/m/Button","sap/m/Column","sap/m/Table","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/m/VBox","sap/m/HBox","sap/m/ComboBox","sap/ui/model/Sorter","sap/base/Log","sap/m/library","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/CustomData","sap/ui/thirdparty/jquery","sap/ui/core/library","sap/ui/events/KeyCodes","sap/ui/mdc/enums/ChartItemRoleType","sap/ui/core/InvisibleMessage"],function(e,t,n,o,i,s,r,a,l,h,u,p,g,c,d,m,_,f,I,M,jQuery,y,b,P,v){"use strict";const O=y.ValueState;const C=_.FlexJustifyContent;const B=sap.ui.getCore();const x=e.extend("sap.ui.mdc.p13n.panels.ChartItemPanel",{metadata:{library:"sap.ui.mdc",properties:{panelConfig:{type:"object"}},events:{changeItems:{}}},init:function(){this._bMobileMode=f.system.phone;e.prototype.init.apply(this,arguments);this._bindListItems()},renderer:{apiVersion:2}});x.prototype._setInnerLayout=function(){this._oInnerControl=new p({items:[this._oListControl]});this.setAggregation("_content",this._oInnerControl);this._fnHandleResize=function(){if(this.getParent){let e=null;const t=this.getParent();if(t&&t.$){e=t.$("cont");if(e.children().length>0){const e=this._oInnerControl.$()[0].clientWidth;const t=570;if(!this._bMobileMode&&e<=t){this._switchMobileMode(true)}else if(this._bMobileMode&&e>t){this._switchMobileMode(false)}}}}};if(f.system.desktop){this._sContainerResizeListener=I.register(this._oInnerControl,this._fnHandleResize.bind(this))}};x.prototype._switchMobileMode=function(e){if(this._bMobileMode==e){return}this._bMobileMode=e;if(this._sContainerResizeListener){I.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null}this._oListControl.destroy();this._oDragDropInfo=null;this._oListControl=this._createInnerListControl();this._setInnerLayout();this._bindListItems()};x.prototype._createInnerListControl=function(){const e=this._bMobileMode?this.getId()+"-innerP13nListMobile":this.getId()+"-innerP13nList";const t=new l(e,Object.assign(this._getListControlConfig(),{}));this.setEnableReorder(true);t.addEventDelegate({onAfterRendering:this._onAfterTableRender.bind(this)});return t};x.prototype._onAfterTableRender=function(){if(this._oFocusInfo){if(this._oFocusInfo.oMoveButton){this._oFocusInfo.oMoveButton.focus()}this._oFocusInfo=null}this._mInvalidMap.forEach(function(e,t){if(this._mNamesMap.has(t)){this._mNamesMap.get(t).setValueState(O.Error);this._mNamesMap.get(t).setValue(e)}}.bind(this))};x.prototype._bindListItems=function(e){let t;const n=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");if(this.getPanelConfig()&&this.getPanelConfig().sorter){t=this.getPanelConfig().sorter}else{const e={text:n.getText("chart.PERSONALIZATION_DIALOG_MEASURE_GROUP_HEADER")};const o={text:n.getText("chart.PERSONALIZATION_DIALOG_DIMENSION_GROUP_HEADER")};const i={Aggregatable:e,Groupable:o,Measure:e,Dimension:o};const s=function(e){const t=e.getProperty("kind");return{key:t,text:i[t].text}};const r=function(e,t){if(e===t){return 0}if(e==="MEASURE"||e==="AGGREGATABLE"){return 1}return-1};t=new d("kind",false,s,r)}let o;this._mTemplatesMap=new Map;this._mNamesMap=new Map;this._mInvalidMap=new Map;if(this._bMobileMode){o=this._createListItemMobile}else{o=this._createListItem}this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/items",key:"name",filters:[new h({filters:[new h("visible",u.EQ,true),new h("template",u.EQ,true)],and:false})],factory:o.bind(this),sorter:t},e))};x.prototype._getTemplateComboBox=function(e){const t=new h("visible",u.EQ,false);const n=new window.Intl.Collator;const o=function(e,t){return n.compare(e,t)};const i=new d("label",false,false,o);const r=new c({id:"p13nPanel-templateComboBox-"+e,width:"100%",placeholder:this._getPlaceholderTextForTemplate(e),items:{path:this.P13N_MODEL+">/items",template:new s({key:"{"+this.P13N_MODEL+">name}",text:"{"+this.P13N_MODEL+">label}"}),templateShareable:false,filters:[t,new h("kind",u.EQ,e)],sorter:i},change:[this.onChangeOfTemplateName,this]});this._mTemplatesMap.set(e,r);return r};x.prototype._getPlaceholderTextForTemplate=function(e){const t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");return t.getText("chart.PERSONALIZATION_DIALOG_TEMPLATE_PLACEHOLDER")};x.prototype._getRoleSelect=function(){return new o({width:"100%",selectedKey:"{"+this.P13N_MODEL+">role}",change:[this.onChangeOfRole,this],forceSelection:false,items:{path:this.P13N_MODEL+">availableRoles",templateShareable:false,template:new s({key:"{"+this.P13N_MODEL+">key}",text:"{"+this.P13N_MODEL+">text}"})},visible:{path:this.P13N_MODEL+">availableRoles",formatter:function(e){if(!e){return false}return e.length>1}}})};x.prototype._getNameComboBox=function(e,t,n){const o=new window.Intl.Collator;const i=function(e,t){return o.compare(e,t)};const r=new d("label",false,false,i);const a=new h({filters:[new h("visible",u.EQ,false),new h("name",u.EQ,n)],and:false});return new c(e+"-combo",{width:"100%",items:{path:this.P13N_MODEL+">/items",factory:function(e,t){return new s({key:t.getObject().name,text:t.getObject().label})},templateShareable:false,filters:[a,new h("kind",u.EQ,t)],sorter:r},change:[this.onChangeOfItemName,this],selectedKey:"{"+this.P13N_MODEL+">tempName}",customData:[new M({key:"prevName",value:n}),new M({key:"prevKind",value:t})]})};x.prototype._createListItem=function(e,t){let o;const i=[];if(t.getObject()&&t.getObject().template){i.push(this._getTemplateComboBox(t.getObject().kind))}else{if(t.getObject().name!=t.getObject().tempName){t.getObject().tempName=t.getObject().name}const n=this._getNameComboBox(e,t.getObject().kind,t.getObject().name);i.push(n);i.push(this._getRoleSelect());o=this.getId()+t.getObject().kind+"-RemoveBtn-"+t.getObject().name;i.push(new g({justifyContent:C.End,items:[new r({id:o,press:[this._onPressHide,this],type:"Transparent",icon:"sap-icon://decline",tooltip:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_REMOVE_ENTRY"),customData:[new M({key:"propertyName",value:"{"+this.P13N_MODEL+">name}"}),new M({key:"propertyKind",value:"{"+this.P13N_MODEL+">kind}"})]})]}));this._mNamesMap.set(t.getObject().name,n)}let s;if(t.getObject()&&t.getObject().template){const e=t.getObject().kind;s=new n({cells:i,visible:{path:this.P13N_MODEL+">/items",formatter:function(t){t=t.filter(function(t){return t.visible===false&&t.template===false&&t.kind===e});return t.length!=0}}})}else{s=new n({cells:i})}s.addEventDelegate({onmouseover:this._hoverHandler.bind(this),onfocusin:this._focusHandler.bind(this),onkeydown:this._keydownHandler.bind(this)});return s};x.prototype._createListItemMobile=function(e,t){let o;const i=[];if(t.getObject()&&t.getObject().template){i.push(this._getTemplateComboBox(t.getObject().kind))}else{const n=new p({items:[this._getNameComboBox(e,t.getObject().kind,t.getObject().name),this._getRoleSelect()]});o=t.getObject().kind+"-RemoveBtn-"+t.getObject().name;i.push(n)}const s=new g({justifyContent:C.End,items:[new r({id:o,press:[this._onPressHide,this],type:"Transparent",icon:"sap-icon://decline",visible:{path:this.P13N_MODEL+">template",formatter:function(e){return!e}},customData:[new M({key:"propertyName",value:"{"+this.P13N_MODEL+">name}"}),new M({key:"propertyKind",value:"{"+this.P13N_MODEL+">kind}"})]})]});i.push(s);let a;if(t.getObject()&&t.getObject().template){const e=t.getObject().kind;a=new n({cells:i,visible:{path:this.P13N_MODEL+">/items",formatter:function(t){t=t.filter(function(t){return t.visible===false&&t.template===false&&t.kind===e});return t.length!=0}}})}else{a=new n({cells:i})}a.addEventDelegate({onmouseover:this._hoverHandler.bind(this),onfocusin:this._focusHandler.bind(this),onkeydown:this._keydownHandler.bind(this)});return a};x.prototype._keydownHandler=function(t){if((t.metaKey||t.ctrlKey)&&t.keyCode===b.D){let e;const n=B.byId(t.currentTarget.id);if(this._bMobileMode){e=n.getCells()[1].getItems()[n.getCells()[1].getItems().length-1]}else{e=n.getCells()[2].getItems()[n.getCells()[2].getItems().length-1]}if(e){this._onPressHide(t,e);t.preventDefault()}}else{e.prototype._keydownHandler.apply(this,arguments)}};x.prototype._focusHandler=function(t){const n=B.byId(t.target.id);if(n instanceof r){return}e.prototype._focusHandler.apply(this,arguments)};x.prototype._handleActivated=function(e){const t=this._getModelItemByTableItem(e);if(t&&t.template){this.removeMoveButtons()}this._oHoveredItem=e;this._updateEnableOfMoveButtons(e,false);this._addMoveButtons(e);this._setMoveButtonVisibility(true)};x.prototype.onChangeOfItemName=function(e){const t=e.getSource().data().prevName;const n=e.getSource().data().prevKind;const o=e.getSource().getSelectedKey();const i=this._getP13nModel().getProperty("/items").find(function(e){return e.name===t&&e.kind===n});const s=this._getP13nModel().getProperty("/items").find(function(e){return e.name===o&&e.kind===n});this.removeMoveButtons();if(i&&s){i.visible=false;s.visible=true;i.tempName=i.name;s.role=i.role;this._moveItemsByIndex(this._getItemIndex(s),this._getItemIndex(i),true);this._refreshP13nModel();this._fireChangeItems();this._updateVisibleIndexes();this._mInvalidMap.delete(t);this._mInvalidMap.delete(o)}else if(e.getSource()&&e.getSource()instanceof c){this._mInvalidMap.set(e.getSource().data("prevName"),e.getSource().getValue());e.getSource().setValueState(O.Error)}};x.prototype._getItemIndexByNameAndKind=function(e,t){const n=this._getP13nModel().getProperty("/items");const o=n.find(function(n){return n.name===e&&n.kind===t&&!n.template});return this._getItemIndex(o)};x.prototype._getItemIndex=function(e){return this._getP13nModel().getProperty("/items").indexOf(e)};x.prototype.removeMoveButtons=function(){const e=this._getMoveButtonContainer();if(e){e.removeItem(this._getMoveBottomButton());e.removeItem(this._getMoveDownButton());e.removeItem(this._getMoveUpButton());e.removeItem(this._getMoveTopButton())}};x.prototype.getP13nData=function(){const e=this._getCleanP13nItems();this._getP13nModel().setProperty("/items",e);return e};x.prototype._getMoveButtonContainer=function(){if(this._oMoveUpButton&&this._oMoveUpButton.getParent()&&this._oMoveUpButton.getParent().isA("sap.m.FlexBox")){return this._oMoveUpButton.getParent()}return undefined};x.prototype._addMoveButtons=function(e){const t=e;if(!t){return}const n=this._getP13nModel().getProperty(t.getBindingContextPath())?this._getP13nModel().getProperty(t.getBindingContextPath()).template:true;if(t.getCells()&&(t.getCells().length===2||t.getCells().length===3)&&!n){if(this._bMobileMode){t.getCells()[1].insertItem(this._getMoveDownButton(),0);t.getCells()[1].insertItem(this._getMoveUpButton(),0)}else{t.getCells()[2].insertItem(this._getMoveBottomButton(),0);t.getCells()[2].insertItem(this._getMoveDownButton(),0);t.getCells()[2].insertItem(this._getMoveUpButton(),0);t.getCells()[2].insertItem(this._getMoveTopButton(),0)}}};x.prototype._moveSelectedItem=function(){this._oSelectedItem=this._getMoveButtonContainer().getParent();e.prototype._moveSelectedItem.apply(this,arguments)};x.prototype._updateAvailableRolesForItems=function(){const e=this._getP13nModel().getProperty("/items");let t=[];if(this.getPanelConfig()&&this.getPanelConfig().allowedLayoutOptions){t=this.getPanelConfig().allowedLayoutOptions}else{m.warning("No allowedLayoutOptions configured for chart type. This will not show any p13n options!")}e.forEach(function(e){if(!e.availableRoles){return}e.availableRoles=e.availableRoles.filter(function(e){return t.indexOf(e.key)!=-1})});this._getP13nModel().setProperty("/items",e);this._refreshP13nModel()};x.prototype._onPressHide=function(e,t){let n;if(t){n=t.data().propertyName}else{n=e.getSource().data().propertyName}const o=jQuery.extend([],this._getP13nModel().getProperty("/items"),true);o.filter(function(e){return e.name===n}).forEach(function(e){e.visible=false;if(this._mTemplatesMap.has(e.kind)&&this._mTemplatesMap.get(e.kind).getVisible()){this._mTemplatesMap.get(e.kind).focus()}}.bind(this));this._announce(this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_REMOVE_ENTRY_ANNOUNCE"));this._getP13nModel().setProperty("/items",o);this._refreshP13nModel();this._fireChangeItems();this._updateVisibleIndexes()};x.prototype._announce=function(e){const t=y.InvisibleMessageMode;const n=v.getInstance();n.announce(e,t.Assertive)};x.prototype.setP13nData=function(t){t=t.filter(function(e){return!e.template});e.prototype.setP13nData.apply(this,arguments);let n=[];const o=[];this.getP13nData().forEach(function(e,t){if(!e.availableRoles){e.availableRoles=this._getChartItemTextByKey(e.kind)}if(this.getPanelConfig()&&this.getPanelConfig().allowedLayoutOptions){const t=this.getPanelConfig().allowedLayoutOptions;if(t&&t.length>=1){e.availableRoles=e.availableRoles.filter(function(e){return t.indexOf(e.key)!=-1});if(t.indexOf(e.role)===-1){e.role=t[0]}}}e.template=false;e.tempName=e.name;if(!e.visible){o.push(e)}if(!e.index){e.index=t}n.push(e)}.bind(this));n=n.concat(this._getTemplateItems());this._getP13nModel().setProperty("/items",n);this._updateVisibleIndexes()};x.prototype._updateVisibleIndexes=function(){this._mVisibleIndexes=new Map;this._getP13nModel().getProperty("/items").forEach(function(e,t){if(e.template||!e.visible){return}if(this._mVisibleIndexes.has(e.kind)){this._mVisibleIndexes.get(e.kind).push(t)}else{const n=[t];this._mVisibleIndexes.set(e.kind,n)}}.bind(this))};x.prototype.onChangeOfTemplateName=function(e){const t=e.getSource().getSelectedKey();const n=this._getCleanP13nItems().find(function(e){return e.name===t});if(n){n.visible=true;e.getSource().setSelectedKey(undefined);this._refreshP13nModel();const t=this._mVisibleIndexes.has(n.kind)?this._mVisibleIndexes.get(n.kind):[];const o=this._getItemIndexByNameAndKind(n.name,n.kind);let i=t[t.length-1];if(o>i){i+=1}if(i&&o!=i){this._moveItemsByIndex(o,i,true)}else{this._fireChangeItems()}this._mInvalidMap.delete(e.getSource().getValue());this._updateVisibleIndexes()}else if(e.getSource()&&e.getSource()instanceof c){if(e.getSource().getValue()!=""){e.getSource().setValueState(O.Error)}else{e.getSource().setValueState(O.None)}}};x.prototype._refreshP13nModel=function(){this._getP13nModel().refresh(true)};x.prototype._getTemplateItems=function(){const e=[];if(!this.getPanelConfig()||!this.getPanelConfig().templateConfig){return[]}this.getPanelConfig().templateConfig.forEach(function(t){const n={template:true,kind:t.kind};e.push(n)});return e};x.prototype._getListControlConfig=function(){const t=e.prototype._getListControlConfig.apply(this,arguments);if(this._bMobileMode){t.columns=[new a({header:new i({text:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION")+" / "+this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_ROLE")})}),new a]}else{const e=new a({header:new i({text:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION")})});const n=new a({header:new i({text:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_ROLE")})});t.columns=[e,n,new a]}t.mode="None";return t};x.prototype._getCleanP13nItems=function(){return this._getP13nModel().getProperty("/items").filter(function(e){return!e.template})};x.prototype._fireChangeItems=function(){this.fireChangeItems({items:this._getCleanP13nItems().map(function(e){return{columnKey:e.name,visible:e.visible,index:e.index,role:e.role}})});this.fireChange()};x.prototype.onChangeOfRole=function(e){const t=e.getParameter("selectedItem");if(t){let t;if(this._bMobileMode){t=e.getSource().getParent().getParent()}else{t=e.getSource().getParent()}this.fireChange();this._updateEnableOfMoveButtons(t)}this._fireChangeItems()};x.prototype._updateEnableOfMoveButtons=function(e,t){if(!e){return}const n=this._getModelItemByTableItem(e);const o=this._getP13nModel().getProperty("/items").indexOf(n);let i=true,s=true;if(!n||n.template){return}const r=this._mVisibleIndexes.has(n.kind)?this._mVisibleIndexes.get(n.kind):[];if(o==0||r.indexOf(o)===0){i=false}if(r.indexOf(o)===r.length-1){s=false}this._getMoveTopButton().setEnabled(i);this._getMoveUpButton().setEnabled(i);this._getMoveDownButton().setEnabled(s);this._getMoveBottomButton().setEnabled(s);if(t&&(!s||!i)){this._oFocusInfo={oMoveButton:!s?this._getMoveUpButton():this._getMoveDownButton()}}};x.prototype._getListItemFromMoveButton=function(e){if(e&&e.getParent()&&e.getParent().getParent()){return e.getParent().getParent()}return undefined};x.prototype._onPressButtonMoveToTop=function(e){const t=this._getListItemFromMoveButton(e.getSource());if(!t){return}const n=this._getP13nModel().getProperty(t.getBindingContextPath());const o=this._mVisibleIndexes.get(n.kind)[0];this._oSelectedItem=t;this._moveSelectedItem(o)};x.prototype._onPressButtonMoveUp=function(e,t){if(!t){t=this._getListItemFromMoveButton(e.getSource())}if(!t){return}const n=this._getP13nModel().getProperty(t.getBindingContextPath());const o=this._mVisibleIndexes.get(n.kind);const i=this._getP13nModel().getProperty("/items").indexOf(n);this._oSelectedItem=t;const s=o[o.indexOf(i)-1];this._moveSelectedItem(s)};x.prototype._onPressButtonMoveDown=function(e,t){if(!t){t=this._getListItemFromMoveButton(e.getSource())}if(!t){return}const n=this._getP13nModel().getProperty(t.getBindingContextPath());const o=this._mVisibleIndexes.get(n.kind);const i=this._getP13nModel().getProperty("/items").indexOf(n);this._oSelectedItem=t;const s=o[o.indexOf(i)+1];this._moveSelectedItem(s)};x.prototype._onPressButtonMoveToBottom=function(e){const t=this._getListItemFromMoveButton(e.getSource());if(!t){return}const n=this._getP13nModel().getProperty(t.getBindingContextPath());const o=this._mVisibleIndexes.get(n.kind)[this._mVisibleIndexes.get(n.kind).length-1];this._oSelectedItem=t;this._moveSelectedItem(o)};x.prototype._moveTableItem=function(e,t){const n=this._getP13nModel().getProperty("/items");const o=n.indexOf(e.getBindingContext(this.P13N_MODEL).getObject());this._moveItemsByIndex(o,t)};x.prototype._moveItemsByIndex=function(e,t,n){const o=this._getP13nModel().getProperty("/items");t=t<=0?0:Math.min(t,o.length-1);if(t==e){return}o.splice(t,0,o.splice(e,1)[0]);o.forEach(function(e,t){if(!e.template){e.index=t}});this._getP13nModel().setProperty("/items",o);if(!n){this._oSelectedItem=this._oListControl.getItems().find(function(e){const n=this._getModelItemByTableItem(e);return n&&n===o[t]}.bind(this));this._updateEnableOfMoveButtons(this._oSelectedItem,!n);this._handleActivated(this._oSelectedItem)}this._fireChangeItems()};x.prototype._getModelItemByTableItem=function(e){return this._getP13nModel().getProperty(e.getBindingContextPath())};x.prototype._getMoveConfigForTableItem=function(e){const t=this._getModelItemByTableItem(e);if(!t){return undefined}return{currentIndex:this._getP13nModel().getProperty("/items").indexOf(t),aggregationRole:t.kind,template:t.template}};x.prototype._getDragDropConfig=function(){if(!this._oDragDropInfo){const t=e.prototype._getDragDropConfig.apply(this,arguments);t.attachDragStart(this._checkDragStart.bind(this));t.attachDragEnter(this._checkDrag.bind(this));t.attachDragEnd(function(){this._oDraggedItem=null}.bind(this));return t}return this._oDragDropInfo};x.prototype._checkDrag=function(e){const t=e.getParameter("target");const n=this._getMoveConfigForTableItem(t);const o=this._getMoveConfigForTableItem(this._oDraggedItem);if(!n||n.template||o.aggregationRole!=n.aggregationRole){e.preventDefault();return}};x.prototype._checkDragStart=function(e){this._oDraggedItem=e.getParameter("target");this._checkDrag(e)};x.prototype._onRearrange=function(e){const t=e.getParameter("draggedControl");const n=e.getParameter("droppedControl");const o=e.getParameter("dropPosition");const i=this._getMoveConfigForTableItem(t);const s=this._getMoveConfigForTableItem(n);if(!i||i.template||!s){e.preventDefault();return}const r=i.currentIndex;let a=s.currentIndex;if(s.template&&o=="After"){e.preventDefault();return}if(!s.template&&(i.aggregationRole!=undefined&&i.aggregationRole!=s.aggregationRole)){e.preventDefault();return}if(r<a){if(o=="Before"&&a!=0){a-=1}}else if(o=="After"){a+=1}this._moveItemsByIndex(r,a);this._refreshP13nModel();this._updateVisibleIndexes()};x.prototype._getMoveTopButton=function(){if(this._oMoveTopButton&&this._oMoveTopButton.isDestroyed()){this._oMoveTopButton=null}return e.prototype._getMoveTopButton.apply(this,arguments)};x.prototype._getMoveUpButton=function(){if(this._oMoveUpButton&&this._oMoveUpButton.isDestroyed()){this._oMoveUpButton=null}return e.prototype._getMoveUpButton.apply(this,arguments)};x.prototype._getMoveDownButton=function(){if(this._oMoveDownButton&&this._oMoveDownButton.isDestroyed()){this._oMoveDownButton=null}return e.prototype._getMoveDownButton.apply(this,arguments)};x.prototype._getMoveBottomButton=function(){if(this._oMoveBottomButton&&this._oMoveBottomButton.isDestroyed()){this._oMoveBottomButton=null}return e.prototype._getMoveBottomButton.apply(this,arguments)};x.prototype._getChartItemTextByKey=function(e){const t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");const n={Dimension:[{key:P.category,text:t.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY")},{key:P.category2,text:t.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY2")},{key:P.series,text:t.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_SERIES")}],Measure:[{key:P.axis1,text:t.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS1")},{key:P.axis2,text:t.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS2")},{key:P.axis3,text:t.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS3")}]};return n[e]};x.prototype._getResourceTextMDC=function(e,t){this.oResourceBundleMDC=this.oResourceBundleMDC?this.oResourceBundleMDC:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");return e?this.oResourceBundleMDC.getText(e,t):this.oResourceBundleMDC};x.prototype.exit=function(){this._fnSort=null;this.oResourceBundleMDC=null;this._bMobileMode=null;return e.prototype.exit.apply(this,arguments)};x.prototype.onReset=function(){};return x});
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/mdc/p13n/panels/FilterPanel", ["sap/m/p13n/QueryPanel","sap/m/VBox","sap/m/Text","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/m/ComboBox","sap/ui/core/library","sap/m/library","sap/m/Label"],function(t,e,o,n,r,s,a,i,c){"use strict";const p=a.ValueState;const u=i.ListKeyboardMode;const l=i.FlexJustifyContent;const y=i.WrappingType;const _=t.extend("sap.ui.mdc.p13n.panels.FilterPanel",{metadata:{library:"sap.ui.mdc",properties:{itemFactory:{type:"function"}}},renderer:{apiVersion:2}});_.prototype.PRESENCE_ATTRIBUTE="active";_.prototype._createInnerListControl=function(){const e=t.prototype._createInnerListControl.apply(this,arguments);return e};_.prototype._createQueryRowGrid=function(t){const e=t.name?this._createRowContainer(t.label,t.key):this._createKeySelect(t.name);const o=[e];if(t.name){const n=this._createFactoryControl(t);o.push(n);this._setLabelForOnBox(n,e)}return new n({containerQuery:true,defaultSpan:"XL4 L4 M4 S4",content:o}).addStyleClass("sapUiTinyMargin")};_.prototype._getPlaceholderText=function(){return this._getResourceText("p13n.FILTER_PLACEHOLDER")};_.prototype._getRemoveButtonTooltipText=function(){return this._getResourceText("p13n.FILTER_REMOVEICONTOOLTIP")};_.prototype._getRemoveButtonAnnouncementText=function(){return this._getResourceText("p13n.FILTER_REMOVEICONANNOUNCE")};_.prototype._createKeySelect=function(t){const e=new s({width:"100%",items:this._getAvailableItems(),placeholder:this._getPlaceholderText(),selectionChange:function(t){const e=t.getSource();this._selectKey(e)}.bind(this),change:function(t){const e=t.getSource();const o=t.getParameter("newValue");e.setValueState(o&&!e.getSelectedItem()?p.Error:p.None);this._selectKey()}.bind(this)});e.setLayoutData(new r({span:"XL4 L4 M4 S11"}));return e};_.prototype._createRemoveButton=function(e){const o=t.prototype._createRemoveButton.apply(this,arguments);o.setJustifyContent(l.Start);o.setLayoutData(new r({span:"XL1 L1 M1 S1"}));return o};_.prototype._createRowContainer=function(t,o){const n=new c({text:t,showColon:true,wrapping:true,wrappingType:y.Hyphenated});const r=new e({items:[n.addStyleClass("sapUiTinyMarginBegin")]});r._key=o;return r};_.prototype._setLabelForOnBox=function(t,e){e.getItems()[0].setLabelFor(t)};_.prototype._selectKey=function(e){let o,n;if(e){this._oComboBox=e;o=e.getParent();n=e.getSelectedKey()}else if(this._oComboBox){e=this._oComboBox;o=e.getParent();n=e.getSelectedKey();let r;if(n){t.prototype._selectKey.call(this,e);const s=o.getContent()[0];o.removeContent(s);const a=n?e.getSelectedItem().getText():"";const i=this._createRowContainer(a,n);o.insertContent(i,0);r=this._createFactoryControl({name:n});this._setLabelForOnBox(r,i);o.insertContent(r,1)}setTimeout(()=>{if(this._oListControl&&!this._oListControl.bIsDestroyed){this._oListControl.setKeyboardMode(u.Edit)}const t=this._getControlToFocus(r);t.focus()},20);delete this._oComboBox}};_.prototype._getControlToFocus=function(t){const e=t?.getMetadata().getName().includes("sap.ui.mdc")?t.getItems()?.[0]:t;return e};_.prototype._getFactoryControlForRow=function(t){return t.getContent()[0].getContent()[1]};_.prototype._createFactoryControl=function(t){const e=this.getItemFactory().call(this,t);e.setLayoutData(new r({span:"XL7 L7 M7 S7"}));return e};return _});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/panels/GroupView", ["sap/m/p13n/BasePanel","sap/m/Label","sap/base/util/deepEqual","sap/m/CustomListItem","sap/m/List","sap/m/Panel","sap/m/Toolbar","sap/m/Text","sap/ui/core/Icon","sap/ui/core/library","sap/m/HBox","sap/m/library","sap/base/util/merge","sap/m/Title"],function(t,e,i,n,o,s,r,a,l,c,h,p,d,u){"use strict";const g=c.IconColor;const _=p.FlexJustifyContent;const f=p.ListKeyboardMode;const C=t.extend("sap.ui.mdc.p13n.panels.GroupView",{metadata:{library:"sap.ui.mdc",properties:{itemFactory:{type:"function"}}},renderer:{apiVersion:2}});C.prototype.init=function(){t.prototype.init.apply(this,arguments);this.addStyleClass("sapUiMDCGroupView");const e=new n({visible:"{"+this.P13N_MODEL+">groupVisible}",accDescription:{path:this.P13N_MODEL+">groupLabel",formatter:function(t){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("p13nDialog.FILTER_GROUP_DESCRIPTION",[t])}},content:[this._createGroupPanelTemplate()]});this._bShowFactory=true;this.displayColumns();this._aInitializedLists=[];this._setTemplate(e);e.setType("Inactive");this._setMoveButtonVisibility(true)};C.prototype._getShowFactory=function(){return this._bShowFactory};C.prototype.getPanels=function(){const t=[];this._oListControl.getItems().forEach(function(e){t.push(e.getContent()[0])});return t};C.prototype._createGroupPanelTemplate=function(){const t=this.P13N_MODEL;return new s({expandable:true,expanded:{path:this.P13N_MODEL+">group",formatter:function(){if(this.getBindingContext(t)){const e=this.getBindingContext(t).sPath.split("/")[2]==="0";return e}else{return false}}},expand:function(t){const e=t.getSource();const i=e.getContent()[0];this._addInitializedList(i);if(this._getShowFactory()){this._addFactoryControl(i);this.filterContent(this._aCurrentFilters)}}.bind(this),width:"100%",headerToolbar:[new r({content:[new u({wrapping:true,text:"{"+this.P13N_MODEL+">groupLabel}"})]})],content:[this._createGroupListTemplate()]})};C.prototype._createGroupListTemplate=function(){const t=new o({keyboardMode:f.Edit,selectionChange:function(t){const e=t.getParameter("listItem").getBindingContext(this.P13N_MODEL).sPath;const i=this._getP13nModel().getProperty(e);const n=this.getModel(this.P13N_MODEL);if(n&&i){n.setProperty(e+"/selected",i.visible)}const o=this._checkSpecialChangeReason(t.getParameter("selectAll"),t.getParameter("listItems"));this.fireChange({reason:o||(i.visible?this.CHANGE_REASON_ADD:this.CHANGE_REASON_REMOVE),item:i})}.bind(this),showSeparators:"None",mode:"MultiSelect"});t.bindItems(this._getItemsBinding());return t};C.prototype._addFactoryControl=function(t){if(t.getItems().length==0||t.getItems()[0].getContent().length<2){t.getItems().forEach(function(t){const e=t.getBindingContext(this.P13N_MODEL);const i=this.getItemFactory().call(this,e);if(i){t.addContent(i);const e=t.getContent()[0].getItems()[0];e.setLabelFor(i)}if(t.getContent()[0].getItems().length>1){t.getContent()[0].removeItem(1)}}.bind(this))}this.addStyleClass("sapUiMDCAFLabelMarking")};C.prototype._createInnerListControl=function(){const t=new o(this.getId()+"-innerGroupViewList",Object.assign(this._getListControlConfig(),{keyboardMode:f.Edit,mode:"None",infoToolbar:new r,updateStarted:function(t){this._checkAllPanels()}.bind(this)}));return t};C.prototype._getItemsBinding=function(){const t=function(){const t=[new h({width:"100%",justifyContent:_.SpaceBetween,items:[new e({required:"{"+this.P13N_MODEL+">required}",text:"{"+this.P13N_MODEL+">label}"})]})];return new n({selected:"{"+this.P13N_MODEL+">visible}",tooltip:"{"+this.P13N_MODEL+">tooltip}",accDescription:"{"+this.P13N_MODEL+">label}",content:t})}.bind(this);return{path:this.P13N_MODEL+">items",templateShareable:false,template:t()}};C.prototype._getIconTemplate=function(){return new h({width:"18.5%",justifyContent:_.Center,items:[new l({src:"sap-icon://circle-task-2",size:"0.5rem",color:g.Neutral,visible:{path:this.P13N_MODEL+">active",formatter:function(t){if(t){return true}else{return false}}}})]})};C.prototype._loopGroupList=function(t){this._oListControl.getItems().forEach(function(e){const i=e.getContent()[0];const n=i.getContent()[0];this._loopItems(n,function(e,i){t(e,i)})}.bind(this))};C.prototype._loopItems=function(t,e){t.getItems().forEach(function(t){const i=t.getBindingContextPath();const n=this._getP13nModel().getProperty(i).name;e.call(this,t,n)}.bind(this))};C.prototype._removeFactoryControl=function(){this._loopGroupList(function(t,e){if(t.getContent()[1]){t.removeContent(t.getContent()[1]);const e=t.getParent();this._addInitializedList(e);const i=this._getIconTemplate();t.getContent()[0].addItem(i)}}.bind(this));this.removeStyleClass("sapUiMDCAFLabelMarking");return this._aInitializedLists||[]};C.prototype._addInitializedList=function(t){const e=t.getId();if(this._aInitializedLists.indexOf(e)<0){this._aInitializedLists.push(e)}};C.prototype._getInitializedLists=function(){const t=[];this._aInitializedLists.forEach(function(e){const i=sap.ui.getCore().byId(e);if(i){t.push(i)}});return t};C.prototype.getSelectedFields=function(){const t=[];this._oListControl.getItems().forEach(function(e){const i=e.getContent()[0];const n=i.getContent()[0];this._loopItems(n,function(e,i){if(e.getSelected()){t.push(i)}})}.bind(this));return t};C.prototype.filterContent=function(t){if(!this._bInitialized||i(t,this._aCurrentFilters)){return}const e=this._removeFactoryControl();this._oListControl.getItems().forEach(function(i){const n=i.getContent()[0];const o=n.getContent()[0];if(o.getBinding("items")){o.getBinding("items").filter(t,true);this._togglePanelVisibility(n)}if(this._getShowFactory()&&e.indexOf(o.getId())>-1){this._addFactoryControl(o)}}.bind(this));this._aCurrentFilters=t};C.prototype.showFactory=function(t){this._bShowFactory=t;this.displayColumns();if(t){this._getInitializedLists().forEach(function(t){this._addFactoryControl(t)}.bind(this))}else{this._removeFactoryControl()}};C.prototype._checkAllPanels=function(){this._oListControl.getItems().forEach(function(t){const e=t.getContent()[0];this._togglePanelVisibility(e)}.bind(this))};C.prototype.setGroupExpanded=function(t,e){this._oListControl.getItems().forEach(function(i){const n=i.getContent()[0];const o=n.getBindingContext(this.P13N_MODEL).sPath;const s=this._getP13nModel().getProperty(o);if(s.group===t){n.setExpanded(e)}},this)};C.prototype._togglePanelVisibility=function(t){const e=t.getContent()[0];const i=t.getBindingContext(this.P13N_MODEL);if(i){const t=i.sPath;const n=this._getP13nModel().getProperty(t);n.groupVisible=e.getVisibleItems().length<1?false:true;this._getP13nModel().setProperty(t,n)}};C.prototype.getItems=function(){return this._oListControl.getItems()};C.prototype._checkFirstGroup=function(){if(!this._bInitialized&&this._oListControl&&this._oListControl.getItems().length>0){this._bInitialized=true;const t=this._oListControl.getItems()[0].getContent()[0].getContent()[0];this._addFactoryControl(t);this._addInitializedList(t)}};C.prototype.displayColumns=function(){const t=this._oListControl.getInfoToolbar().removeAllContent();t.forEach(function(t){t.destroy()});this._oListControl.getInfoToolbar().addContent(new a({width:"75%",text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("p13nDialog.LIST_VIEW_COLUMN")}).addStyleClass("firstColumnPadding"));if(!this._bShowFactory){this._oListControl.getInfoToolbar().addContent(new a({textAlign:"Center",width:"25%",text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("p13nDialog.LIST_VIEW_ACTIVE")}).addStyleClass("firstColumnPadding"))}};C.prototype.setP13nData=function(t){this._getP13nModel().setProperty("/itemsGrouped",t);if(!this._bInitialized){this._bindListItems()}this._checkFirstGroup();this._checkAllPanels()};C.prototype.getP13nData=function(t){let e=this._getP13nModel().getProperty("/itemsGrouped");if(t){e=e.filter(function(t){return t[this.PRESENCE_ATTRIBUTE]}.bind(this))}return e};C.prototype._bindListItems=function(){this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/itemsGrouped",templateShareable:false,key:"group",template:this.getAggregation("_template").clone()}))};C.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._aInitializedLists=null;this._bShowFactory=false;this._bInitialized=false};return C});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/panels/LinkSelectionPanel", ["sap/m/p13n/SelectionPanel","sap/m/ColumnListItem","sap/m/HBox","sap/m/VBox","sap/m/Link","sap/m/Text","sap/ui/core/Icon","sap/m/library","sap/m/OverflowToolbar","sap/ui/model/Filter","sap/ui/core/CustomData"],function(e,t,i,s,n,r,o,a,p,l,c){"use strict";const u=a.ListType;const d=a.MultiSelectMode;const h=e.extend("sap.ui.mdc.p13n.panels.LinkSelectionPanel",{metadata:{properties:{multiSelectMode:{type:"sap.m.MultiSelectMode",defaultValue:d.Default}},library:"sap.ui.mdc",events:{linkPressed:{}}},renderer:{apiVersion:2}});h.prototype._getListTemplate=function(){return new t({selected:"{"+this.P13N_MODEL+">"+this.PRESENCE_ATTRIBUTE+"}",type:u.Active,cells:[new i({items:[new s({items:[new n({tooltip:"{"+this.P13N_MODEL+">tooltip}",text:"{"+this.P13N_MODEL+">text}",href:"{"+this.P13N_MODEL+">href}",target:"{"+this.P13N_MODEL+">target}",press:this._onLinkPressed.bind(this),customData:new c({key:"internalHref",value:"{"+this.P13N_MODEL+">internalHref}"}),wrapping:true}),new r({text:"{"+this.P13N_MODEL+">description}",visible:"{= ${"+this.P13N_MODEL+">description} ? true:false}"})]})]})]})};h.prototype.setShowHeader=function(e){if(e){this._oListControl.setHeaderToolbar(new p({content:[this._getSearchField()]}))}this.setProperty("showHeader",e);return this};h.prototype._getSearchField=function(){const t=e.prototype._getSearchField.apply(this,arguments);t.getLayoutData().setMaxWidth(undefined);return t};h.prototype._onLinkPressed=function(e){const t=e.getParameters().ctrlKey||e.getParameters().metaKey;if(e.getSource().getTarget()!=="_blank"&&!t){e.preventDefault();this.fireLinkPressed(e)}};h.prototype._filterList=function(e,t){let i=[],s=[];if(e){s=new l(this.PRESENCE_ATTRIBUTE,"EQ",true)}if(t){i=new l("text","Contains",t)}this._oListControl.getBinding("items").filter(new l([].concat(s,i),true))};return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/ActionToolbarController", ["./SelectionController","sap/ui/mdc/p13n/panels/ActionToolbarPanel","sap/m/Column","sap/ui/mdc/p13n/P13nBuilder"],function(t,e,n,o){"use strict";const i=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");const a=t.extend("saps.ui.mdc.p13n.subcontroller.ActionToolbarController");a.prototype.initAdaptationUI=function(t){const n=new e({title:i.getText("actiontoolbar.RTA_TITLE"),showHeader:true});n.setFieldColumn(i.getText("actiontoolbar.RTA_COLUMN_HEADER"));const o=this.mixInfoAndState(t);n.setP13nData(o.items);this._oPanel=n;return Promise.resolve(n)};a.prototype.getDelta=function(e){const n=t.prototype.getDelta.apply(this,arguments);n.forEach(function(t){const e=t.changeSpecificData.changeType;if(e==="hideControl"||e==="unhideControl"){t.selectorElement=sap.ui.getCore().byId(t.changeSpecificData.content.name);delete t.changeSpecificData.content}});return n};a.prototype.mixInfoAndState=function(t){const e=this.getCurrentState();const n=this.arrayToMap(e);const o=this.prepareAdaptationData(t,function(t,e){const o=n[e.name];t.visible=!!o;t.position=o?o.position:-1;t.alignment=e.alignment;return e.visible});this.sortP13nData({visible:"visible",position:"position"},o.items);o.items.forEach(function(t){delete t.position});return o};a.prototype.getChangeOperations=function(){return{add:"unhideControl",remove:"hideControl",move:"moveAction"}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/AdaptFiltersController", ["./SelectionController","sap/ui/mdc/p13n/P13nBuilder","sap/base/util/merge"],function(t,e,n){"use strict";const i=t.extend("sap.ui.mdc.p13n.subcontroller.AdaptFiltersController",{constructor:function(){t.apply(this,arguments);this._bResetEnabled=true}});i.prototype.getUISettings=function(){return{verticalScrolling:false,title:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("filterbar.ADAPT_TITLE"),afterClose:function(t){const e=t.getSource();if(e){e.getContent()[0].executeRemoves();e.removeAllContent();e.destroy()}}}};i.prototype.getBeforeApply=function(){const t=this.getAdaptationControl().getInbuiltFilter();const e=t?t.createConditionChanges():Promise.resolve([]);return e};i.prototype.getFilterControl=function(){return this.getAdaptationControl()};i.prototype.getChangeOperations=function(){return{add:"addFilter",remove:"removeFilter",move:"moveFilter"}};i.prototype.initAdaptationUI=function(t){return this.getAdaptationControl().retrieveInbuiltFilter().then(function(e){const n=this.mixInfoAndState(t);e.getTitle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("filterbar.ADAPT_TITLE")};this._oPanel=e;e.setP13nData(n);e.setLiveMode(false);return e.createFilterFields().then(function(){return e})}.bind(this))};i.prototype.getP13nData=function(){return this._oPanel.getP13nData().items};i.prototype.update=function(t){if(this._oPanel){const e=this.mixInfoAndState(t);this._oPanel.setP13nData(e);this.getAdaptationControl().getInbuiltFilter().createFilterFields()}};i.prototype.mixInfoAndState=function(t){const n=this.getAdaptationControl().getCurrentState().filter||{};const i=this.getCurrentState();const o=e.arrayToMap(i);const r=this.prepareAdaptationData(t,function(t,e){const i=o[e.name];const r=n[e.name];t.visible=i?true:false;t.visibleInDialog=true;t.position=i?i.position:-1;t.isFiltered=r&&r.length>0?true:false;t.required=e.required;return!(e.hiddenFilter===true||e.name=="$search")},true);this.sortP13nData({visible:"visible",position:"position"},r.items);return r};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/AggregateController", ["./SelectionController","sap/ui/mdc/p13n/P13nBuilder","sap/base/util/merge"],function(t,e,n){"use strict";const r=t.extend("sap.ui.mdc.p13n.subcontroller.AggregateController");r.prototype.getStateKey=function(){return"aggregations"};r.prototype.getCurrentState=function(){return this.getAdaptationControl().getAggregateConditions()};r.prototype.sanityCheck=function(t){const e=[];Object.keys(t).forEach(function(n){const r={name:n,key:n};if(t[n].hasOwnProperty("aggregated")){r["aggregated"]=t[n].aggregated}e.push(r)});return e};r.prototype.getDelta=function(e){e.existingState=this.sanityCheck(e.existingState);return t.prototype.getDelta.apply(this,arguments)};r.prototype.initAdaptationUI=function(t){return null};r.prototype.getChangeOperations=function(){return{add:"addAggregate",remove:"removeAggregate"}};r.prototype._getPresenceAttribute=function(){return"aggregated"};r.prototype.mixInfoAndState=function(t){const e=this.getCurrentState();const n=this.prepareAdaptationData(t,function(t,n){const r=e[n.name];t.aggregated=!!r;return n.aggregatable});return n};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/ChartItemController", ["./SelectionController"],function(t){"use strict";const e=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");const o=t.extend("sap.ui.mdc.p13n.subcontroller.ChartItemController");o.prototype.initAdaptationUI=function(t){return this.getAdaptationControl().getAdaptationUI().then(function(o){this._oPanel=o;o.setTitle(e.getText("p13nDialog.TAB_Chart"));const i=this.mixInfoAndState(t);o.setP13nData(i.items);return o}.bind(this))};o.prototype.update=function(e){t.prototype.update.apply(this,arguments)};o.prototype.getDelta=function(e){e.deltaAttributes.push("role");return t.prototype.getDelta.apply(this,arguments)};o.prototype.mixInfoAndState=function(t){const e=this.getCurrentState();const o=this.arrayToMap(e);const i=this.prepareAdaptationData(t,function(t,e){const i=o[e.name];t.visible=!!i;t.position=i?i.position:-1;t.role=i?i.role:e.role;t.kind=e.kind;if(e.availableRoles){t.availableRoles=e.availableRoles}return e.visible});this.sortP13nData({visible:"visible",position:"position"},i.items);i.items.forEach(function(t){delete t.position});return i};o.prototype.getChangeOperations=function(){return{add:"addItem",remove:"removeItem",move:"moveItem"}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/ChartTypeController", ["./SelectionController"],function(t){"use strict";const e=t.extend("sap.ui.mdc.p13n.subcontroller.ChartTypeController",{constructor:function(){t.apply(this,arguments);this._bResetEnabled=true}});e.prototype.getCurrentState=function(){return{properties:{chartType:this.getAdaptationControl().getChartType()}}};e.prototype.getStateKey=function(){return"supplementaryConfig"};e.prototype.getDelta=function(t){let e;if(t.changedState&&t.changedState.properties){e=t.changedState.properties.chartType}const n=this.getAdaptationControl().getChartType();let r=[];if(e&&e!==n){r=[{selectorElement:t.control,changeSpecificData:{changeType:"setChartType",content:{chartType:e}}}]}return r};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/ColumnController", ["./SelectionController","sap/m/p13n/SelectionPanel"],function(e,t){"use strict";const n=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");const o=e.extend("sap.ui.mdc.p13n.subcontroller.ColumnController");o.prototype.getUISettings=function(){return{title:n.getText("table.SETTINGS_COLUMN"),tabText:n.getText("p13nDialog.TAB_Column")}};o.prototype.model2State=function(){const e=[];this._oPanel.getP13nData(true).forEach(function(t){if(t.visible){e.push({name:t.name})}});return e};o.prototype.createUI=function(e){const o=new t({showHeader:true,enableCount:true,title:n.getText("fieldsui.COLUMNS"),fieldColumn:n.getText("fieldsui.COLUMNS")});o.setEnableReorder(this._bReorderingEnabled);return o.setP13nData(e.items)};o.prototype.getChangeOperations=function(){return{add:"addColumn",remove:"removeColumn",move:"moveColumn"}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/FilterController", ["sap/ui/mdc/enums/ProcessingStrategy","sap/ui/mdc/condition/FilterOperatorUtil","./SelectionController","sap/ui/mdc/p13n/P13nBuilder","sap/base/Log","sap/base/util/merge","sap/base/util/deepEqual"],function(t,e,n,o,i,r,a){"use strict";const s=n.extend("sap.ui.mdc.p13n.subcontroller.FilterController",{constructor:function(){n.apply(this,arguments);this._bResetEnabled=true}});s.prototype.getStateKey=function(){return"filter"};s.prototype.getUISettings=function(){return{title:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("filter.PERSONALIZATION_DIALOG_TITLE"),tabText:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("p13nDialog.TAB_Filter"),afterClose:function(t){const e=t.getSource();if(e){const t=e.getContent()[0];if(t.isA("sap.m.p13n.Container")){t.removeView("Filter")}else{e.removeAllContent()}}e.destroy()}}};s.prototype.getCurrentState=function(){return this.getAdaptationControl().getCurrentState()[this.getStateKey()]};s.prototype.getSelectorForReset=function(){const t=this.getAdaptationControl(),e=t.getInbuiltFilter();let n=[t];if(e){n=n.concat(e)}return n};s.prototype.getChangeOperations=function(){return{add:"addCondition",remove:"removeCondition"}};s.prototype.getBeforeApply=function(){const t=this.getAdaptationControl().getInbuiltFilter();const e=t?t.createConditionChanges():Promise.resolve([]);return e};s.prototype.getFilterControl=function(){return this.getAdaptationControl().isA("sap.ui.mdc.IFilter")?this.getAdaptationControl():this.getAdaptationControl()._oP13nFilter};s.prototype.sanityCheck=function(t){s.checkConditionOperatorSanity(t);return t};s.checkConditionOperatorSanity=function(t){for(const n in t){const o=t[n];for(let r=0;r<o.length;r++){const a=o[r];const s=a.operator;if(!e.getOperator(s)){o.splice(r,1);if(t[n].length==0){delete t[n]}i.warning("The provided conditions for field '"+n+"' contain unsupported operators - these conditions will be neglected.")}}}};s.prototype._getPresenceAttribute=function(t){return"active"};s.prototype.initAdaptationUI=function(t,e){const n=this.mixInfoAndState(t);return this.getAdaptationControl().retrieveInbuiltFilter().then(function(t){t.setP13nData(n);t.setLiveMode(false);t.setProperty("_useFixedWidth",false);t.getTitle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("filter.PERSONALIZATION_DIALOG_TITLE")};this._oAdaptationFB=t;return t.createFilterFields().then(function(){this._oPanel=t;return t}.bind(this))}.bind(this))};s.prototype.update=function(t){if(this._oPanel){const e=this.mixInfoAndState(t);this._oPanel.setP13nData(e);const n=this.getAdaptationControl();const o=n&&n.getInbuiltFilter();if(o){o.createFilterFields()}}};s.prototype.getDelta=function(e){if(e.applyAbsolute===t.FullReplace){Object.keys(e.existingState).forEach(function(t){if(!e.changedState.hasOwnProperty(t)){e.changedState[t]=[]}})}return c(e)};const c=function(t){let e=[];const n=t.changedState;const o=t.existingState;const r=t.control;const a=t.hasOwnProperty("applyAbsolute")?t.applyAbsolute:true;const s=t.propertyInfo;for(const t in n){const c=l(s,t);if(!c&&r.isA("sap.ui.mdc.Control")&&r.isPropertyHelperFinal()){i.warning("property '"+t+"' not supported");continue}const u=p(t,n[t],o[t],r,a);e=e.concat(u)}return e};const l=function(t,e){return t.some(function(t){let n=t.name===e||e=="$search";n=n?n:t.path===e;return n})};const u=function(t,e,n,o){delete o.filtered;const i={selectorElement:e,changeSpecificData:{changeType:t,content:{name:n,condition:o}}};return i};const p=function(t,n,o,i,s){let c;const l=[];const p=r([],n);const f=o?r([],o):[];if(a(n,f)){return l}const d=function(t,n){let o;do{o=false;for(let i=0;i<t.length;i++){const r=t[i];const a=e.indexOfCondition(r,n);if(a>-1){t.splice(i,1);if(s){n.splice(a,1)}o=true;break}}}while(o)};d(n,f);if(n.length>0||f.length>0){f.forEach(function(n){const o=e.indexOfCondition(n,p);const r=o>-1&&p[o].filtered===false;if(s||r){c=u("removeCondition",i,t,n);l.push(c)}});n.forEach(function(e){if(s||(!e.hasOwnProperty("filtered")||e.filtered!==false)){c=u("addCondition",i,t,e);l.push(c)}})}return l};s.prototype.model2State=function(){const t={},e=this.getCurrentState();this.getP13nData().items.forEach(function(n){if(n.active&&Object.keys(e).includes(n.name)){t[n.name]=e[n.name]}});return t};s.prototype.mixInfoAndState=function(t){const e=this.getCurrentState()||{};const n=this.prepareAdaptationData(t,function(t,n){const o=e[t.name];t.active=o&&o.length>0?true:false;return!(n.filterable===false)});o.sortP13nData({visible:"active",position:undefined},n.items);return n};s.prototype.changesToState=function(t,e,n){const o={};t.forEach(function(t){const e=r({},t.changeSpecificData.content);const n=e.name;if(!o[n]){o[n]=[]}if(t.changeSpecificData.changeType===this.getChangeOperations()["remove"]){e.condition.filtered=false}o[n].push(e.condition)}.bind(this));return o};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/GroupController", ["./SelectionController","sap/ui/mdc/p13n/P13nBuilder","sap/m/p13n/GroupPanel"],function(t,e,o){"use strict";const n=t.extend("sap.ui.mdc.p13n.subcontroller.GroupController");n.prototype.getStateKey=function(){return"groupLevels"};n.prototype.getUISettings=function(){return{tabText:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("p13nDialog.TAB_Group"),title:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("group.PERSONALIZATION_DIALOG_TITLE")}};n.prototype.getDelta=function(e){return t.prototype.getDelta.apply(this,arguments)};n.prototype.initAdaptationUI=function(t){const e=new o;const n=this.mixInfoAndState(t);const r=this.getAdaptationControl();if(r.isA("sap.ui.mdc.Table")&&r._isOfType("ResponsiveTable")){e.setQueryLimit(1)}e.setP13nData(n.items);this._oPanel=e;return Promise.resolve(e)};n.prototype.model2State=function(){const t=[];this._oPanel.getP13nData(true).forEach(function(e){if(e.grouped){t.push({name:e.name})}});return t};n.prototype.getChangeOperations=function(){return{add:"addGroup",remove:"removeGroup",move:"moveGroup"}};n.prototype._getPresenceAttribute=function(){return"grouped"};n.prototype.mixInfoAndState=function(t){const o=this.getCurrentState();const n=e.arrayToMap(o);const r=this.getAdaptationControl();const i=r.getAggregateConditions?r.getAggregateConditions()||{}:{};const p=this.prepareAdaptationData(t,function(t,e){const o=n[e.name];t.grouped=!!o;t.position=o?o.position:-1;return!(e.groupable===false||i[e.name])});e.sortP13nData({visible:"grouped",position:"position"},p.items);p.presenceAttribute=this._getPresenceAttribute();p.items.forEach(function(t){delete t.position});return p};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/LinkPanelController", ["sap/ui/mdc/p13n/P13nBuilder","./SelectionController","sap/ui/mdc/p13n/panels/LinkSelectionPanel","sap/m/MessageBox"],function(e,t,n,o){"use strict";const i=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");const a=t.extend("sap.ui.mdc.p13n.subcontroller.LinkPanelController",{constructor:function(){t.apply(this,arguments);this._bResetEnabled=true}});a.prototype.getUISettings=function(){return{contentWidth:"28rem",contentHeight:"35rem",reset:{warningText:i.getText("info.SELECTION_DIALOG_RESET_WARNING")},title:i.getText("info.SELECTION_DIALOG_ALIGNEDTITLE")}};a.prototype.getSelectorForReset=function(){return this.getAdaptationControl().getItems().concat(this.getAdaptationControl())};a.prototype.initAdaptationUI=function(e){const t=new n({title:i.getText("info.SELECTION_DIALOG_ALIGNEDTITLE"),showHeader:true,fieldColumn:i.getText("info.SELECTION_DIALOG_COLUMNHEADER_WITHOUT_COUNT"),enableCount:true,enableReorder:false,linkPressed:this._onLinkPressed.bind(this)});const o=this.mixInfoAndState(e);t.setP13nData(o.items);this._oPanel=t;return Promise.resolve(t)};a.prototype._onLinkPressed=function(e){const t=e.getParameter("oSource");const n=this.getAdaptationControl();const i=!!(t&&t.getCustomData()&&t.getCustomData()[0].getValue());const a=i?t.getCustomData()[0].getValue():t.getHref();if(n.getBeforeNavigationCallback){n.getBeforeNavigationCallback()(e).then(function(e){if(e){n.getMetadata()._oClass.navigate(a)}})}else{o.show(sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("info.SELECTION_DIALOG_LINK_VALIDATION_QUESTION"),{icon:o.Icon.WARNING,title:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("info.SELECTION_DIALOG_LINK_VALIDATION_TITLE"),actions:[o.Action.YES,o.Action.NO],onClose:function(e){if(e===o.Action.YES){n.getMetadata()._oClass.navigate(a)}},styleClass:this.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""})}};a.prototype._createAddRemoveChange=function(e,t,n){const o=n.name;const i=sap.ui.getCore().byId(o);let a;if(!i){a={selectorElement:e,changeSpecificData:{changeType:"createItem",content:{selector:o}}}}else{a={selectorElement:i,changeSpecificData:{changeType:t==="hideItem"?"hideItem":"revealItem",content:{}}}}return a};a.prototype.mixInfoAndState=function(t){const n=this.getCurrentState();const o=e.arrayToMap(n);const i=this.prepareAdaptationData(t,function(e,t){const n=o[t.name];e.visible=n?true:false;e.position=n?n.position:-1;e.href=t.href;e.internalHref=t.internalHref;e.description=t.description;e.target=t.target;e.text=t.text;return true});this.sortP13nData({visible:"visible",position:"position"},i.items);i.presenceAttribute=this._getPresenceAttribute();i.items.forEach(function(e){delete e.position});return i};a.prototype._createMoveChange=function(e,t,n,o){return{selectorElement:o,changeSpecificData:{changeType:n,content:{index:t,name:e}}}};a.prototype.getChangeOperations=function(){return{add:["createItem","revealItem"],remove:"hideItem",move:"moveItem"}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/SelectionController", ["sap/m/p13n/SelectionController","sap/base/util/merge"],function(e,t){"use strict";const n=e.extend("sap.ui.mdc.p13n.subcontroller.SelectionController");n.prototype._createAddRemoveChange=function(e,t,n){delete n.key;const a={selectorElement:e,changeSpecificData:{changeType:t,content:n}};return a};n.prototype.getCurrentState=function(e){let t=this.getAdaptationControl().getCurrentState()[this.getStateKey()];if(t instanceof Array&&!e){t=t.map(function(e){e.key=e.name;return e})}return t};n.prototype.getDelta=function(n){if(n.changedState instanceof Array){const e=t([],n.changedState);e.map(function(e){e.key=e.name;return e});n.changedState=e}if(n.existingState instanceof Array){const e=t([],n.existingState);e.map(function(e){e.key=e.name;return e});n.existingState=e}n.deltaAttributes.push("name");return e.prototype.getDelta.apply(this,arguments)};n.prototype._createMoveChange=function(e,t,n,a){const r={selectorElement:a,changeSpecificData:{changeType:n,content:{name:e,index:t}}};return r};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/SortController", ["./SelectionController","sap/ui/mdc/p13n/P13nBuilder","sap/m/p13n/SortPanel"],function(t,e,o){"use strict";const n=t.extend("sap.ui.mdc.p13n.subcontroller.SortController",{constructor:function(){t.apply(this,arguments);this._bResetEnabled=true}});n.prototype.getStateKey=function(){return"sorters"};n.prototype.getUISettings=function(){return{tabText:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("p13nDialog.TAB_Sort"),title:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("sort.PERSONALIZATION_DIALOG_TITLE")}};n.prototype.getDelta=function(e){e.deltaAttributes.push("descending");return t.prototype.getDelta.apply(this,arguments)};n.prototype.initAdaptationUI=function(t){const e=new o;const n=this.mixInfoAndState(t);e.setP13nData(n.items);this._oPanel=e;return Promise.resolve(e)};n.prototype.model2State=function(){const t=[];if(this._oPanel){this._oPanel.getP13nData(true).forEach(function(e){if(e.sorted){t.push({name:e.name})}});return t}};n.prototype.getChangeOperations=function(){return{add:"addSort",remove:"removeSort",move:"moveSort"}};n.prototype._getPresenceAttribute=function(t){return"sorted"};n.prototype.mixInfoAndState=function(t){const o=this.getCurrentState();const n=e.arrayToMap(o);const r=this.prepareAdaptationData(t,function(t,e){const o=n[e.name];t.sorted=o?true:false;t.sortPosition=o?o.position:-1;t.descending=o?!!o.descending:false;return!(e.sortable===false)});this.sortP13nData({visible:"sorted",position:"sortPosition"},r.items);r.presenceAttribute=this._getPresenceAttribute();r.items.forEach(function(t){delete t.sortPosition});return r};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/Column", ["./GridTableType","./ResponsiveTableType","sap/base/Log","sap/m/library","sap/m/Label","sap/ui/model/json/JSONModel","sap/ui/model/base/ManagedObjectModel","sap/ui/core/Control","sap/ui/core/Core","sap/ui/mdc/enums/TableType"],function(e,t,n,i,o,a,s,l,r,p){"use strict";const u=l.extend("sap.ui.mdc.table.Column",{metadata:{library:"sap.ui.mdc",defaultAggregation:"template",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minWidth:{type:"float",group:"Behavior",defaultValue:8},header:{type:"string"},headerVisible:{type:"boolean",group:"Misc",defaultValue:true},hAlign:{type:"sap.ui.core.HorizontalAlign",defaultValue:"Begin"},importance:{type:"sap.ui.core.Priority",group:"Behavior",defaultValue:"None"},dataProperty:{type:"string"},propertyKey:{type:"string"},required:{type:"boolean",defaultValue:false}},aggregations:{template:{type:"sap.ui.core.Control",multiple:false},creationTemplate:{type:"sap.ui.core.Control",multiple:false},extendedSettings:{type:"sap.ui.mdc.table.ColumnSettings",multiple:false}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t);e.openEnd();if(t._oColumnHeaderLabel){e.renderControl(t._oColumnHeaderLabel.getLabel())}e.close("div")}}});u.prototype.init=function(){this.mSkipPropagation={template:true,creationTemplate:true};this._oManagedObjectModel=new s(this);this._oSettingsModel=new a({width:this.getWidth(),calculatedWidth:null,p13nWidth:null,resizable:false})};u.prototype.getInnerColumn=function(){const e=this.getTable();if(e&&(!this._oInnerColumn||this._oInnerColumn.isDestroyed())){this._oInnerColumn=this._createInnerColumn()}return this._oInnerColumn};u.prototype._createInnerColumn=function(){const n=this.getTable();let o;const a={parts:[{path:"$this>/width"},{path:"$columnSettings>/calculatedWidth"},{path:"$columnSettings>/p13nWidth"}],formatter:function(e,t,n){return n||t||e}};const s={parts:[{path:"$this>/tooltip"},{path:"$this>/header"},{path:"$this>/headerVisible"},{path:"$sap.ui.mdc.Table>/useColumnLabelsAsTooltips"}],formatter:function(e,t,n,i){if(e||!i){return e}return n?t:""}};this._readP13nValues();if(n._isOfType(p.ResponsiveTable)){o=t.createColumn(this.getId()+"-innerColumn",{width:a,autoPopinWidth:"{$this>/minWidth}",hAlign:"{$this>/hAlign}",header:this._getColumnHeaderLabel(s),importance:{parts:[{path:"$this>/importance"},{path:"$this>/extendedSettings/importance"},{path:"$this>/extendedSettings/@className"}],formatter:function(e,t,n){if(t&&n==="sap.ui.mdc.table.ResponsiveColumnSettings"){return t}else{return e}}},popinDisplay:"{= ${$this>/headerVisible} ? 'Inline' : 'WithoutHeader' }",mergeDuplicates:{parts:[{path:"$this>/extendedSettings/mergeFunction"},{path:"$this>/extendedSettings/@className"}],formatter:function(e,t){return e&&t==="sap.ui.mdc.table.ResponsiveColumnSettings"}},mergeFunctionName:{parts:[{path:"$this>/extendedSettings/mergeFunction"},{path:"$this>/extendedSettings/@className"}],formatter:function(e,t){if(t==="sap.ui.mdc.table.ResponsiveColumnSettings"){return e}}}})}else{o=e.createColumn(this.getId()+"-innerColumn",{width:a,minWidth:{path:"$this>/minWidth",formatter:function(e){return Math.round(e*parseFloat(i.BaseFontSize))}},hAlign:"{$this>/hAlign}",label:this._getColumnHeaderLabel(),resizable:"{$columnSettings>/resizable}",autoResizable:"{$columnSettings>/resizable}",tooltip:s,template:this.getTemplateClone()});o.setCreationTemplate(this.getCreationTemplateClone())}o.setModel(this._oManagedObjectModel,"$this");o.setModel(this._oSettingsModel,"$columnSettings");o.setHeaderMenu(n.getId()+"-columnHeaderMenu");return o};const h=l.extend("sap.ui.mdc.table.ColumnHeaderLabel",{metadata:{final:true,aggregations:{label:{type:"sap.m.Label",multiple:false}},associations:{column:{type:"sap.ui.mdc.table.Column"}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t);e.style("width","100%");e.openEnd();e.renderControl(r.byId(t.getColumn()));e.close("div")}},getText:function(){return this.getLabel().getText()},clone:function(){return this.getLabel().clone()},getRequired:function(){return this.getLabel().getRequired()},getAccessibilityInfo:function(){return this.getLabel().getAccessibilityInfo()}});u.prototype._getColumnHeaderLabel=function(e){const t=this.getTable();if(t&&(!this._oColumnHeaderLabel||this._oColumnHeaderLabel.isDestroyed())){this._oColumnHeaderLabel=new h({column:this,label:new o({width:"{= ${$this>/headerVisible} ? '100%' : '0px' }",text:"{$this>/header}",textAlign:"{$this>/hAlign}",tooltip:e?e:"",wrapping:{parts:[{path:"$this>/headerVisible"},{path:"$columnSettings>/resizable"}],formatter:function(e,n){return t._isOfType(p.ResponsiveTable)&&e&&!n}},wrappingType:t._isOfType(p.ResponsiveTable)?"Hyphenated":null,required:"{$this>/required}"})})}return this._oColumnHeaderLabel};u.prototype.getTemplateClone=function(){const e=this.getTable();const t=this.getTemplate();if(e&&t&&(!this._oTemplateClone||this._oTemplateClone.isDestroyed())){this._oTemplateClone=t.clone();if(!e._isOfType(p.ResponsiveTable)){if(this._oTemplateClone.setWrapping){this._oTemplateClone.setWrapping(false)}if(this._oTemplateClone.setRenderWhitespace){this._oTemplateClone.setRenderWhitespace(false)}}}return this._oTemplateClone};u.prototype.getCreationTemplateClone=function(){const e=this.getTable();const t=this.getCreationTemplate();if(e&&t&&(!this._oCreationTemplateClone||this._oCreationTemplateClone.isDestroyed())){this._oCreationTemplateClone=t.clone();if(!e._isOfType(p.ResponsiveTable)){if(this._oCreationTemplateClone.setWrapping){this._oCreationTemplateClone.setWrapping(false)}if(this._oCreationTemplateClone.setRenderWhitespace){this._oCreationTemplateClone.setRenderWhitespace(false)}}}return this._oCreationTemplateClone};u.prototype.setHeader=function(e){this.setProperty("header",e,true);const t=this.getDomRef();if(t){t.textContent=this.getHeader()}return this};u.prototype.getPropertyKey=function(){const e=this.getProperty("propertyKey");return e||this.getDataProperty()};u.prototype.setTooltip=function(e){if(e&&e.isA&&e.isA("sap.ui.core.TooltipBase")){n.error("The control sap.ui.mdc.table.Column allows only strings as tooltip, but given is "+e);return this}return l.prototype.setTooltip.apply(this,arguments)};u.prototype._onTableChange=function(e){if(e.getParameter("name")==="enableColumnResize"){this._readTableSettings()}};u.prototype._readTableSettings=function(){const e=this.getTable();this._oSettingsModel.setProperty("/resizable",e.getEnableColumnResize())};u.prototype.setParent=function(e){const t=this.getTable();l.prototype.setParent.apply(this,arguments);if(this._bIsBeingMoved){return}this._disconnectFromTable(t);this._connectToTable()};u.prototype._connectToTable=function(){const e=this.getTable();if(!e){return}this._calculateColumnWidth();this._readP13nValues();this._readTableSettings();e.attachEvent("_change",this._onTableChange,this)};u.prototype._disconnectFromTable=function(e){e=e||this.getTable();if(!e){return}if(this._oInnerColumn){this._oInnerColumn.destroy()}};u.prototype._onModifications=function(){this._readP13nValues()};u.prototype._calculateColumnWidth=function(){const e=this.getTable();if(!e||!e.getEnableAutoColumnWidth()||!this.isPropertyInitial("width")){return}const t=e.getPropertyHelper();if(t){t.calculateColumnWidth(this).then(function(e){this._oSettingsModel.setProperty("/calculatedWidth",e)}.bind(this))}else{e._fullyInitialized().then(this._calculateColumnWidth.bind(this))}};u.prototype._readP13nValues=function(){const e=this.getTable();const t=e.getCurrentState().xConfig;const n=this.getPropertyKey();if(t instanceof Promise){t.then(this._readP13nValues.bind(this));return}const i=t&&t.aggregations&&t.aggregations.columns&&t.aggregations.columns[n]&&t.aggregations.columns[n].width;this._oSettingsModel.setProperty("/p13nWidth",i)};u.prototype.getTable=function(){const e=this.getParent();return e&&e.isA("sap.ui.mdc.Table")?e:null};u.prototype.exit=function(){this._disconnectFromTable();["_oManagedObjectModel","_oSettingsModel","_oInnerColumn","_oTemplateClone","_oCreationTemplateClone","_oColumnHeaderLabel"].forEach(function(e){if(this[e]){this[e].destroy();delete this[e]}},this)};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/ColumnSettings", ["sap/ui/core/Element"],function(t){"use strict";const e=t.extend("sap.ui.mdc.table.ColumnSettings",{metadata:{library:"sap.ui.mdc",abstract:true}});return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/CreationRow", ["sap/ui/core/Element","sap/ui/mdc/enums/TableType"],function(e,t){"use strict";const n=e.extend("sap.ui.mdc.table.CreationRow",{metadata:{library:"sap.ui.mdc",properties:{applyEnabled:{type:"boolean",group:"Behavior",defaultValue:true},busy:{type:"boolean",group:"Behavior",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true}},events:{apply:{allowPreventDefault:true}}}});n.prototype.init=function(){this._oInnerCreationRow=null;this._mBindingContexts={}};n.prototype.exit=function(){if(this._oInnerCreationRow){this._oInnerCreationRow.destroy();this._oInnerCreationRow=null}this._mBindingContexts=null};n.prototype.setBusy=function(e){this.setProperty("busy",e,true);if(this._oInnerCreationRow){this._oInnerCreationRow.setBusy(e)}return this};n.prototype.setBindingContext=function(t,n){e.prototype.setBindingContext.call(this,t,n);this._mBindingContexts[n]={context:t,modelName:n};if(this._oInnerCreationRow){this._oInnerCreationRow.setBindingContext(t,n)}return this};n.prototype.setApplyEnabled=function(e){this.setProperty("applyEnabled",e,true);if(this._oInnerCreationRow){this._oInnerCreationRow.setApplyEnabled(e)}return this};n.prototype.setVisible=function(e){this.setProperty("visible",e,true);if(this._oInnerCreationRow){this._oInnerCreationRow.setVisible(e);this._getTable()._oTable.getRowMode().setHideEmptyRows(e)}return this};n.prototype._onInnerApply=function(e){if(!this.fireApply()){e.preventDefault()}};n.prototype.update=function(){return this._updateInnerCreationRow()};n.prototype._updateInnerCreationRow=function(){const e=this._getTable();let n;if(!e||!e._oTable){return Promise.resolve()}if(e._isOfType(t.Table,true)){if(!this._oInnerCreationRow||this._oInnerCreationRow.isDestroyed()){n=this._createGridTableCreationRow();e._oTable.getRowMode().setHideEmptyRows(this.getVisible())}else{n=Promise.resolve()}}else{n=this._createResponsiveTableCreationRow()}return n.then(function(t){i(e,t)})};function o(e){return new Promise(function(t,n){sap.ui.require([e],function(e){t(e)},function(e){n(e)})})}n.prototype._createGridTableCreationRow=function(){return o("sap/ui/table/CreationRow").then(function(e){r(this);this._oInnerCreationRow=new e(this.getId()+"-inner",{visible:this.getVisible(),applyEnabled:this.getApplyEnabled(),apply:[this._onInnerApply,this]});this._getTable()._oTable.getRowMode().setHideEmptyRows(this.getVisible());for(const e in this._mBindingContexts){const t=this._mBindingContexts[e];this._oInnerCreationRow.setBindingContext(t.context,t.modelName)}return this._oInnerCreationRow}.bind(this))};n.prototype._createResponsiveTableCreationRow=function(){r(this);return Promise.resolve()};function i(e,t){if(e&&e._oTable&&t){e._oTable.setCreationRow(t)}}function r(e){if(e&&e._oInnerCreationRow){e._oInnerCreationRow.destroy();e._oInnerCreationRow=null}}n.prototype._getTable=function(){const e=this.getParent();return e&&e.isA("sap.ui.mdc.Table")?e:null};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/DragDropConfig", ["sap/ui/core/dnd/DragDropBase","sap/ui/core/dnd/DragInfo","sap/ui/core/dnd/DropInfo","sap/ui/base/ManagedObjectObserver"],function(t,o,e,r){"use strict";const n=t.extend("sap.ui.mdc.table.DragDropConfig",{metadata:{library:"sap.ui.mdc",properties:{draggable:{type:"boolean",defaultValue:false},droppable:{type:"boolean",defaultValue:false},dropEffect:{type:"sap.ui.core.dnd.DropEffect",defaultValue:"Move"},dropPosition:{type:"sap.ui.core.dnd.DropPosition",defaultValue:"On"}},events:{dragStart:{allowPreventDefault:true,parameters:{bindingContext:{type:"sap.ui.model.Context"}}},dragEnd:{parameters:{bindingContext:{type:"sap.ui.model.Context"}}},dragEnter:{allowPreventDefault:true},dragOver:{},drop:{}}}});n.prototype.init=function(){this._oObserver=new r(this._observeChanges.bind(this))};n.prototype.exit=function(){this._oObserver.destroy();this._oObserver=null};n.prototype.setDraggable=function(t){this.setProperty("draggable",t,true);this.getDraggable()?this._addDragInfoToTable():this._removeDragInfoFromTable();return this};n.prototype.setDroppable=function(t){this.setProperty("droppable",t,true);this.getDroppable()?this._addDropInfoToTable():this._removeDropInfoFromTable();return this};n.prototype.setEnabled=function(t){this.setProperty("enabled",t,true);this._oDragInfo?.setEnabled(t);this._oDropInfo?.setEnabled(t);return this};n.prototype.setGroupName=function(t){this.setProperty("groupName",t,true);this._oDragInfo?.setGroupName(t);this._oDropInfo?.setGroupName(t);return this};n.prototype.setDropEffect=function(t){this.setProperty("dropEffect",t,true);this._oDropInfo?.setDropEffect(t);return this};n.prototype.setDropPosition=function(t){this.setProperty("dropPosition",t,true);this._oDropInfo?.setDropPosition(t);return this};n.prototype.setParent=function(){const o=this.getParent();o&&this._disconnectFromParent(o);t.prototype.setParent.apply(this,arguments);const e=this.getParent();e&&this._connectToParent(e)};n.prototype._connectToParent=function(t){this._oObserver.observe(t,{aggregations:["_content"]});const o=t.getAggregation("_content");o&&this._connectToTable(o)};n.prototype._disconnectFromParent=function(t){this._oObserver?.unobserve(t,{aggregations:["_content"]});this._disconnectFromTable()};n.prototype._observeChanges=function(t){if(t.mutation=="insert"){this._connectToTable(t.child)}else{this._disconnectFromTable()}};n.prototype._connectToTable=function(t){this._oTable=t;this._addDragInfoToTable();this._addDropInfoToTable()};n.prototype._disconnectFromTable=function(){this._removeDragInfoFromTable();this._removeDropInfoFromTable();this._oTable=null};n.prototype._addDragInfoToTable=function(){if(this._oTable&&!this._oDragInfo&&this.getDraggable()){this._oDragInfo=new o({enabled:this.getEnabled(),groupName:this.getGroupName(),sourceAggregation:this._oTable.isA("sap.m.Table")?"items":"rows",dragStart:[this._onDragInfoEvent,this],dragEnd:[this._onDragInfoEvent,this]});this._oTable.addDragDropConfig(this._oDragInfo)}};n.prototype._removeDragInfoFromTable=function(){if(this._oTable&&this._oDragInfo){this._oTable.removeDragDropConfig(this._oDragInfo);this._oDragInfo.destroy();this._oDragInfo=null}};n.prototype._addDropInfoToTable=function(){if(this._oTable&&!this._oDropInfo&&this.getDroppable()){this._oDropInfo=new e({enabled:this.getEnabled(),groupName:this.getGroupName(),dropEffect:this.getDropEffect(),dropPosition:this.getDropPosition(),targetAggregation:this._oTable.isA("sap.m.Table")?"items":"rows",dragEnter:[this._onDropInfoEvent,this],dragOver:[this._onDropInfoEvent,this],drop:[this._onDropInfoEvent,this]});this._oTable.addDragDropConfig(this._oDropInfo)}};n.prototype._removeDropInfoFromTable=function(){if(this._oTable&&this._oDropInfo){this._oTable.removeDragDropConfig(this._oDropInfo);this._oDropInfo.destroy();this._oDropInfo=null}};function s(t){const o=t.isA("sap.m.ListItemBase")?"items":"rows";const e=t.getParent().getBindingInfo(o)||{};return t.getBindingContext(e.model)}function i(t){let o;const e=t.getDragControl();if(e?.isA("sap.m.ListItemBase")){o=s(e)}else if(e?.isA("sap.ui.table.Row")){o=t.getComplexData("sap.ui.table-"+e.getParent().getId()).draggedRowContext}return o||e}n.prototype._onDragInfoEvent=function(t){const o=t.getParameter("dragSession");const e=i(o);const r=t.getId()=="dragStart";const n={bindingContext:e};const s=this.fireEvent(t.getId(),n,r);if(r&&!s){t.preventDefault()}};n.prototype._onDropInfoEvent=function(t){const o=t.getParameter("dragSession");const e=i(o);const r=o.getDropControl();const n=s(r);const a=t.getParameter("dropPosition");const p=t.getId()=="dragEnter";const g={bindingContext:n,dragSource:e};if(a){g.dropPosition=a}const f=this.fireEvent(t.getId(),g,p);if(p&&!f){t.preventDefault()}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/GridTableType", ["./TableTypeBase","sap/m/table/Util","sap/ui/mdc/enums/TableRowCountMode"],function(t,e,o){"use strict";let n,i,s,l,a,r,u;const c=t.extend("sap.ui.mdc.table.GridTableType",{metadata:{library:"sap.ui.mdc",properties:{rowCountMode:{type:"sap.ui.mdc.enums.TableRowCountMode",defaultValue:o.Auto},rowCount:{type:"int",defaultValue:10},selectionLimit:{type:"int",defaultValue:200},showHeaderSelector:{type:"boolean",defaultValue:true},fixedColumnCount:{type:"int",defaultValue:0}}}});c.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this.disableColumnResize()};c.prototype.updateTableByProperty=function(t,e){const n=this.getInnerTable();if(!n){return}if(t==="rowCountMode"){let t=n.getRowMode();let i=false;if(t&&(e===o.Fixed&&!t.isA("sap.ui.table.rowmodes.Fixed")||e===o.Auto&&!t.isA("sap.ui.table.rowmodes.Auto"))){i=t.getHideEmptyRows();t.destroy();t=null}if(!t){const t=e===o.Fixed?a:r;n.setRowMode((new t).setHideEmptyRows(i))}this._updateTableRowCount()}else if(t==="rowCount"){this._updateTableRowCount()}else if(t==="fixedColumnCount"){n.setFixedColumnCount(e)}};c.prototype._updateTableRowCount=function(){const t=this.getInnerTable();if(this.getRowCountMode()===o.Fixed){t.getRowMode().setRowCount(this.getRowCount())}else{t.getRowMode().setMinRowCount(this.getRowCount())}};c.prototype.loadUiTableLibrary=function(){if(!this._oGridTableLibLoaded){this._oGridTableLibLoaded=sap.ui.getCore().loadLibrary("sap.ui.table",true)}return this._oGridTableLibLoaded};c.prototype.loadModules=function(){if(n){return Promise.resolve()}return this.loadUiTableLibrary().then(function(){return new Promise(function(t,e){sap.ui.require(["sap/ui/table/Table","sap/ui/table/Column","sap/ui/table/RowAction","sap/ui/table/RowActionItem","sap/ui/table/rowmodes/Fixed","sap/ui/table/rowmodes/Auto","sap/ui/table/RowSettings"],function(e,o,c,d,p,g,h){n=e;i=o;s=c;l=d;a=p;r=g;u=h;t()},function(){e("Failed to load some modules")})})})};c.prototype.createTable=function(t){const e=this.getTable();if(!e||!n){return null}const o=new n(t,this.getTableSettings());o._setHideStandardTooltips(true);return o};c.prototype.getTableSettings=function(){const e=this.getTable();const o={SingleMaster:"RowOnly"};const n={enableBusyIndicator:true,enableColumnReordering:false,threshold:this.getThreshold(),noData:e._getNoDataText(),extension:[e._oToolbar],ariaLabelledBy:[e._oTitle],rowSettingsTemplate:this.getRowSettingsConfig(),selectionMode:"None",selectionBehavior:{path:"$sap.ui.mdc.Table>/selectionMode",formatter:function(t){return o[t]}}};if(e.hasListeners("rowPress")){n.cellClick=[this._onCellClick,this]}return Object.assign({},t.prototype.getTableSettings.apply(this,arguments),n)};c.prototype._onCellClick=function(t){this.callHook("RowPress",this.getTable(),{bindingContext:t.getParameter("rowBindingContext")})};c.createColumn=function(t,e){return new i(t,e)};c.prototype.enableColumnResize=function(){const t=this.getTable();const e=this.getInnerTable();if(!t||!e){return}e.getColumns().forEach(function(t){t.setResizable(true);t.setAutoResizable(true)});e.detachColumnResize(this._onColumnResize,this);e.attachColumnResize(this._onColumnResize,this)};c.prototype.disableColumnResize=function(){const t=this.getTable();const e=this.getInnerTable();if(!t||!e){return}e.getColumns().forEach(function(t){t.setResizable(false);t.setAutoResizable(false)});e.detachColumnResize(this._onColumnResize,this)};c.prototype._onColumnResize=function(t){const e=this.getTable();const o=this.getInnerTable();const n=t.getParameter("column");const i=t.getParameter("width");const s=o.indexOfColumn(n);const l=e.getColumns()[s];this.callHook("ColumnResize",e,{column:l,width:i})};c.prototype.updateRowSettings=function(){const t=this.getInnerTable();if(!t){return}t.destroyRowSettingsTemplate();t.setRowSettingsTemplate(new u(this.getRowSettingsConfig()));this.updateRowActions()};c.prototype.updateRowActions=function(){const t=this.getInnerTable();if(!t){return}const e=this.getTable().getRowSettings();this._removeRowActions();if(!e||!e.isBound("rowActions")&&(!e.getRowActions()||e.getRowActions().length==0)){return}const o=e.getAllActions();if("templateInfo"in o){const t=o.templateInfo;o.items.template=new l({type:t.type,visible:t.visible,icon:t.icon,text:t.text,press:[this._onRowActionPress,this]});delete o.templateInfo}else{o.items=o.items.map(function(t){const e=new l({type:t.isBound("type")?t.getBindingInfo("type"):t.getType(),visible:t.isBound("visible")?t.getBindingInfo("visible"):t.getVisible(),icon:t.isBound("icon")?t.getBindingInfo("icon"):t._getIcon(),text:t.isBound("text")?t.getBindingInfo("text"):t._getText(),press:[this._onRowActionPress,this]});e.data("rowAction",t);return e},this)}t.setRowActionTemplate(new s(o));t.setRowActionCount(e.getRowActionCount())};c.prototype._removeRowActions=function(){const t=this.getInnerTable();const e=t.getRowActionTemplate();if(e){e.destroy()}t.setRowActionTemplate();t.setRowActionCount()};c.prototype._onRowActionPress=function(t){const e=this.getTable();const o=t.getParameter("item");const n=e.getRowSettings();const i=n.getAllActions();if(n.isBound("rowActions")){const t=i.items.model;const e=o.getBindingContext(t);if(!this._oRowActionItem){this._oRowActionItem=i.items.template.clone()}this._oRowActionItem.setBindingContext(e,i.items.model);this._oRowActionItem.setModel(this.getModel(t),t);n.addDependent(this._oRowActionItem)}else{this._oRowActionItem=o.data("rowAction")}this.callHook("Press",this._oRowActionItem,{bindingContext:t.getParameter("row").getBindingContext()})};c.prototype.prepareRowPress=function(){const t=this.getInnerTable();if(t&&!t.hasListeners("cellClick")){t.attachEvent("cellClick",this._onCellClick,this)}};c.prototype.cleanupRowPress=function(){const t=this.getTable();if(!t.hasListeners("rowPress")){this.getInnerTable()?.detachEvent("cellClick",this._onCellClick,this)}};c.prototype.removeToolbar=function(){const t=this.getInnerTable();if(t){t.removeExtension(this.getTable()._oToolbar)}};c.prototype.scrollToIndex=function(t){const o=this.getTable();const n=this.getInnerTable();if(!n){return Promise.reject()}return new Promise(function(i){if(t===-1){t=e.isEmpty(o.getRowBinding())?0:o.getRowBinding().getLength()}if(n._setFirstVisibleRowIndex(t)){n.attachEventOnce("rowsUpdated",function(){i()})}else{i()}})};c.prototype.getRowBinding=function(){const t=this.getInnerTable();return t?t.getBinding():undefined};c.prototype.bindRows=function(t){const e=this.getInnerTable();if(e){e.bindRows(t)}};c.prototype.isTableBound=function(){const t=this.getInnerTable();return t?t.isBound("rows"):false};c.prototype.insertFilterInfoBar=function(t,e){const o=this.getInnerTable();if(o){o.insertExtension(t,1);if(!o.getAriaLabelledBy().includes(e)){o.addAriaLabelledBy(e)}}};c.prototype.updateSortIndicator=function(t,e){t.getInnerColumn().setSorted(e!=="None");t.getInnerColumn().setSortOrder(e)};c.prototype.getContextMenuParameters=function(t){return{bindingContext:this.getInnerTable().getContextByIndex(t.getParameters().rowIndex),column:this.getTable().getColumns()[t.getParameters().columnIndex]}};c.prototype.getTableStyleClasses=function(){const e=t.prototype.getTableStyleClasses.apply(this,arguments);if(this.getRowCountMode()===o.Auto){e.push("sapUiMdcTableFitContainer")}return e};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/PropertyHelper", ["../util/PropertyHelper","sap/m/table/Util","sap/ui/base/Object"],function(e,t,r){"use strict";const n=e.extend("sap.ui.mdc.table.PropertyHelper",{constructor:function(t,r,n){e.call(this,t,r,Object.assign({filterable:true,sortable:true,propertyInfos:true,groupable:{type:"boolean",forComplexProperty:{valueIfNotAllowed:false}},key:{type:"boolean",forComplexProperty:{valueIfNotAllowed:false}},unit:{type:"PropertyReference"},text:{type:"PropertyReference"},exportSettings:{type:"object",default:{value:{},ignoreIfNull:true},forComplexProperty:{allowed:true}},clipboardSettings:{type:{template:{type:"string"}},default:{value:{},ignoreIfNull:true},forComplexProperty:{allowed:true}},visualSettings:{type:{widthCalculation:{type:{minWidth:{type:"int",default:{value:2}},maxWidth:{type:"int",default:{value:19}},defaultWidth:{type:"int",default:{value:8}},gap:{type:"float",default:{value:0}},includeLabel:{type:"boolean",default:{value:true}},truncateLabel:{type:"boolean",default:{value:true}},verticalArrangement:{type:"boolean",default:{value:false}},excludeProperties:{type:"PropertyReference[]"}},default:{value:{},ignoreIfNull:true}}},default:{value:{}},forComplexProperty:{allowed:true}}},n?{extension:{type:n,default:{value:{}},forComplexProperty:{allowed:true,propagateAllowance:false}}}:{},this._bEnableAggregatableAttribute?{aggregatable:{type:"boolean",forComplexProperty:{valueIfNotAllowed:false}}}:{}))}});n.prototype.prepareProperty=function(t){e.prototype.prepareProperty.apply(this,arguments);if(!t.isComplex()&&!t.typeConfig&&t.dataType&&this.getParent()){const e=this.getParent().getControlDelegate().getTypeMap();t.typeConfig=e.getTypeConfig(t.dataType,t.formatOptions,t.constraints)}Object.defineProperty(t,"getGroupableProperties",{value:function(){return t.getSimpleProperties().filter(function(e){return e.groupable})}})};n.prototype.getGroupableProperties=function(){return this.getProperties().filter(function(e){return e.groupable})};n.prototype.getColumnClipboardSettings=function(e){const t=this.getProperty(e.getPropertyKey());if(!t||t.clipboardSettings===null){return null}const r=t.getSimpleProperties().map(function(e){return e.path});const n=t.getSimpleProperties().map(function(e){return e.typeConfig&&e.typeConfig.typeInstance});const o=t.clipboardSettings.template||Array.from(Array(r.length).keys(),function(e){return"{"+e+"}"}).join(" ");return{properties:r,template:o,types:n}};n.prototype.getColumnExportSettings=function(e){const t=[];if(!r.isObjectA(e,"sap.ui.mdc.table.Column")){return t}const n=this.getProperty(e.getPropertyKey());if(!n){return t}const o=n.exportSettings;if(o===null){return t}const i=[];let p;if(!n.isComplex()){p=l(e,n,o);p.property=n.path;t.push(p);return t}const a=n.getSimpleProperties();if(Object.keys(o).length){p=l(e,n,o);a.forEach(function(e){i.push(e.path)});p.property=i;t.push(p)}else{a.forEach(function(r,n){if(!r.exportSettings){return}const o=l(e,r,r.exportSettings);o.property=r.path;if(n>0){o.columnId=e.getId()+"-additionalProperty"+n}if(r.exportSettings||o.property){t.push(o)}})}return t};function o(e){if(e.indexOf("em")>0){return Math.round(parseFloat(e))}if(e.indexOf("px")>0){return Math.round(parseInt(e)/16)}return""}function l(e,t,r){return Object.assign({columnId:e.getId(),label:t.label,width:o(e.getWidth()),textAlign:e.getHAlign(),type:"String"},r)}n.prototype.calculateColumnWidth=function(e){const t=e.getPropertyKey();const r=e.getTable();return r._getPropertyByNameAsync(t).then(function(t){if(!t){return null}const r=t.visualSettings;if(r&&r.widthCalculation===null){return null}return this._calcColumnWidth(t,e)}.bind(this))};n.prototype._calcColumnWidth=function(e,r){const n=Object.assign({gap:0,includeLabel:true,truncateLabel:true,excludeProperties:[],required:r.getRequired()},e.visualSettings&&e.visualSettings.widthCalculation);const o=r.getParent();if(o&&o._isOfType("TreeTable")&&o.indexOfColumn(r)==0){n.treeColumn=true}let l=[];if(e.isComplex()){l=e.getSimpleProperties().flatMap(function(e){const t=e.visualSettings?e.visualSettings.widthCalculation:undefined;return t===null||n.excludeProperties.includes(e.name)?[]:[[e.typeConfig.typeInstance,t]]})}else{l.push(e.typeConfig.typeInstance)}if(e.unit){n.gap+=2.5}const i=n.includeLabel?r.getHeader()||e.label:"";return t.calcColumnWidth(l,i,n)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/ResponsiveColumnSettings", ["./ColumnSettings"],function(e){"use strict";const t=e.extend("sap.ui.mdc.table.ResponsiveColumnSettings",{metadata:{library:"sap.ui.mdc",final:true,properties:{importance:{type:"sap.ui.core.Priority",group:"Behavior",defaultValue:"None"},mergeFunction:{type:"string",group:"Misc"}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/ResponsiveTableType", ["./TableTypeBase","./utils/Personalization","sap/m/Button","sap/m/plugins/ColumnResizer","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/ui/Device","sap/ui/core/Core","sap/ui/mdc/enums/TableGrowingMode","sap/ui/mdc/enums/TableRowAction"],function(t,e,o,n,i,s,a,l,r,u){"use strict";let p,c,g;const h=t.extend("sap.ui.mdc.table.ResponsiveTableType",{metadata:{library:"sap.ui.mdc",properties:{growingMode:{type:"sap.ui.mdc.enums.TableGrowingMode",defaultValue:r.Basic},showDetailsButton:{type:"boolean",group:"Misc",defaultValue:false},detailsButtonSetting:{type:"sap.ui.core.Priority[]",group:"Behavior"},popinLayout:{type:"sap.m.PopinLayout",group:"Appearance",defaultValue:"Block"}}}});h.prototype.setDetailsButtonSetting=function(t){return this.setProperty("detailsButtonSetting",t,true)};h.prototype.updateTableByProperty=function(t,e){const o=this.getInnerTable();if(!o){return}if(t==="growingMode"){o.setGrowingScrollToLoad(e===r.Scroll);o.setGrowing(e!==r.None)}else if(t==="showDetailsButton"){this._updateShowDetailsButton(o,e)}else if(t==="popinLayout"){o.setPopinLayout(e)}};h.prototype._updateShowDetailsButton=function(t,e){if(e&&!this._oShowDetailsButton){t.getHeaderToolbar().insertEnd(this._getShowDetailsButton(),0);t.attachEvent("popinChanged",this._onPopinChanged,this);t.setHiddenInPopin(this._getImportanceToHide())}else if(!e&&this._oShowDetailsButton){t.detachEvent("popinChanged",this._onPopinChanged,this);t.getHeaderToolbar().removeEnd(this._oShowDetailsButton);t.setHiddenInPopin([]);this._oShowDetailsButton.destroy();delete this._oShowDetailsButton}};h.prototype.loadModules=function(){if(!p){return new Promise(function(t,e){sap.ui.require(["sap/m/Table","sap/m/Column","sap/m/ColumnListItem"],function(e,o,n){p=e;c=o;g=n;t()},function(){e("Failed to load some modules")})})}else{return Promise.resolve()}};h.prototype.createTable=function(t){const e=this.getTable();if(!e||!p){return null}return new p(t,this.getTableSettings())};h.prototype.getTableSettings=function(){const e=this.getTable();return Object.assign({},t.prototype.getTableSettings.apply(this,arguments),{autoPopinMode:true,contextualWidth:"Auto",growing:true,sticky:["ColumnHeaders","HeaderToolbar","InfoToolbar"],itemPress:[this._onItemPress,this],growingThreshold:this.getThreshold(),noData:e._getNoDataText(),headerToolbar:e._oToolbar,ariaLabelledBy:[e._oTitle]})};h.prototype._onItemPress=function(t){this.callHook("RowPress",this.getTable(),{bindingContext:t.getParameter("listItem").getBindingContext()});this._onRowActionPress(t)};h.createColumn=function(t,e){return new c(t,e)};h.prototype.createRowTemplate=function(t){return new g(t,this.getRowSettingsConfig())};h.prototype.updateRowSettings=function(){const t=this.getTable();if(!t||!t._oRowTemplate){return}t._oRowTemplate.unbindProperty("navigated");t._oRowTemplate.unbindProperty("highlight");t._oRowTemplate.unbindProperty("highlightText");t._oRowTemplate.applySettings(this.getRowSettingsConfig());this.updateRowActions()};h.prototype.updateRowActions=function(){const t=this.getTable();const e=this.getRowActionsConfig();const o=t.hasListeners("rowPress")?"Active":"Inactive";t._oRowTemplate.unbindProperty("type");if(!t.getRowSettings()){t._oRowTemplate.setType(o);return}let n,i,s;if("templateInfo"in e){const t=e.templateInfo;s=t.visible.formatter;i=typeof t.visible=="object";n=t.visible}else if(e&&e.items){if(e.items.length==0){t._oRowTemplate.setType(o);return}const a=e.items.find(function(t){return t.getType()=="Navigation"});if(!a&&e.items.length>0){throw new Error("No TableRowAction of type 'Navigation' found. sap.m.Table only accepts TableRowAction of type 'Navigation'.")}t._oRowTemplate.data("rowAction",a);i=a.isBound("visible");n=i?a.getBindingInfo("visible"):a.getVisible();s=n.formatter}if(s){n.formatter=function(t){const e=s(t);return e?u.Navigation:o}}else{n=n?u.Navigation:o}if(i){t._oRowTemplate.bindProperty("type",n)}else{t._oRowTemplate.setProperty("type",n)}};h.prototype.enableColumnResize=function(){const t=this.getTable();const e=this.getInnerTable();if(!t||!e){return}let o=n.getPlugin(e);e.setFixedLayout("Strict");if(!o){o=new n;e.addDependent(o);o.attachColumnResize(this._onColumnResize,this)}else{o.setEnabled(true);o.detachColumnResize(this._onColumnResize,this);o.attachColumnResize(this._onColumnResize,this)}};h.prototype.disableColumnResize=function(){const t=this.getTable();const e=this.getInnerTable();if(!t||!e){return}const o=n.getPlugin(e);if(o){o.setEnabled(false);o.detachColumnResize(this._onColumnResize,this)}};h.prototype._onColumnResize=function(t){const e=this.getTable();const o=this.getInnerTable();const n=t.getParameter("column");const i=t.getParameter("width");const s=o.indexOfColumn(n);const a=e.getColumns()[s];this.callHook("ColumnResize",e,{column:a,width:i})};h.prototype.createColumnResizeMenuItem=function(t,e){const o=n.getPlugin(this.getInnerTable());if(!o){return}if(e.isA("sap.m.table.columnmenu.Menu")){return o.getColumnResizeQuickAction(t.getInnerColumn(),e)}else{return o.getColumnResizeButton(t.getInnerColumn())}};h.prototype._toggleShowDetails=function(t){if(!this._oShowDetailsButton||t===this.bHideDetails){return}const e=this.getInnerTable();this.bHideDetails=t;if(this.bHideDetails){e.setHiddenInPopin(this._getImportanceToHide());this._oShowDetailsButton.setSelectedKey("hideDetails")}else{e.setHiddenInPopin([]);this._oShowDetailsButton.setSelectedKey("showDetails")}};h.prototype._getShowDetailsButton=function(){if(!this._oShowDetailsButton){const t=l.getLibraryResourceBundle("sap.ui.mdc");const e=this.getTable().getId();this.bHideDetails=true;this._oShowDetailsButton=new i(e+"-showHideDetails",{visible:false,selectedKey:"hideDetails",items:[new s({id:e+"-showDetails",icon:"sap-icon://detail-more",key:"showDetails",tooltip:t.getText("table.SHOWDETAILS_TEXT"),press:[function(){this._toggleShowDetails(false)},this]}),new s({id:e+"-hideDetails",icon:"sap-icon://detail-less",key:"hideDetails",tooltip:t.getText("table.HIDEDETAILS_TEXT"),press:[function(){this._toggleShowDetails(true)},this]})]})}return this._oShowDetailsButton};h.prototype.getContextMenuParameters=function(t){const e=t.getParameter("listItem");const o=t.getParameter("column");const n=l.byId(o.getId().replace(/\-innerColumn$/,""));return{bindingContext:e.getBindingContext(this.getInnerTable().getBindingInfo("items").model),column:n}};h.prototype._getImportanceToHide=function(){const t=this.getDetailsButtonSetting()||[];if(t.length){return t}else{return a.system.phone?["Low","Medium"]:["Low"]}};h.prototype._onPopinChanged=function(t){const e=t.getParameter("hasPopin");const o=t.getParameter("hiddenInPopin");const n=t.getSource().getVisibleItems().length;if(n&&(o.length||e&&!this.bHideDetails)){this._oShowDetailsButton.setVisible(true)}else{this._oShowDetailsButton.setVisible(false)}};h.prototype._onRowActionPress=function(t){const e=this.getTable();const o=t.getParameter("listItem");if(o.getType()!=="Navigation"){return}const n=e.getRowSettings();const i=n.getAllActions();if(n.isBound("rowActions")){const t=i.items.model;if(!this._oRowActionItem){this._oRowActionItem=i.items.template.clone()}this._oRowActionItem.setModel(e.getModel(t),t);n.addDependent(this._oRowActionItem)}else{this._oRowActionItem=o.data("rowAction")}this._oRowActionItem.setType("Navigation");this.callHook("Press",this._oRowActionItem,{bindingContext:o.getBindingContext()})};h.prototype.removeToolbar=function(){const t=this.getInnerTable();if(t){t.setHeaderToolbar()}};h.prototype.scrollToIndex=function(t){const e=this.getInnerTable();if(e){return e.scrollToIndex(t)}else{return Promise.reject()}};h.prototype.getRowBinding=function(){const t=this.getInnerTable();return t?t.getBinding("items"):undefined};h.prototype.bindRows=function(t){const e=this.getInnerTable();if(e){e.bindItems(t)}};h.prototype.isTableBound=function(){const t=this.getInnerTable();if(t){return t.isBound("items")}else{return false}};h.prototype.insertFilterInfoBar=function(t,e){const o=this.getInnerTable();if(o){o.setInfoToolbar(t);if(!o.getAriaLabelledBy().includes(e)){o.addAriaLabelledBy(e)}}};h.prototype.updateSortIndicator=function(t,e){t.getInnerColumn().setSortIndicator(e)};h.prototype._onColumnInsert=function(t){const o=this.getTable();const n=this.getInnerTable();if(e.isUserPersonalizationActive(o)&&n.getHiddenInPopin().includes(t.getInnerColumn().getImportance())&&o.getColumns().pop()===t){this._toggleShowDetails(false)}};return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/RowActionItem", ["sap/ui/core/Element","sap/ui/core/IconPool","sap/ui/core/Core","sap/ui/mdc/enums/TableRowAction"],function(t,e,i,n){"use strict";const o=t.extend("sap.ui.mdc.table.RowActionItem",{metadata:{library:"sap.ui.mdc",properties:{type:{type:"sap.ui.mdc.enums.TableRowAction"},text:{type:"string"},icon:{type:"sap.ui.core.URI"},visible:{type:"boolean",defaultValue:true}},events:{press:{parameters:{bindingContext:{type:"sap.ui.model.Context"}}}}}});const s={navigationIcon:"navigation-right-arrow"};o.prototype._getText=function(){let t;if(this.getText()){t=this.getText()}else{const e=i.getLibraryResourceBundle("sap.ui.mdc");if(this.getType()===n.Navigation){t=e.getText("table.ROW_ACTION_ITEM_NAVIGATE")}}return t};o.prototype._getIcon=function(){let t;if(this.getIcon()){t=this.getIcon()}else if(this.getType()===n.Navigation){t=e.getIconURI(s["navigationIcon"])}return t};o.prototype._onPress=function(t){this.firePress({bindingContext:t.bindingContext})};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/RowSettings", ["sap/ui/core/Element"],function(t){"use strict";const i=t.extend("sap.ui.mdc.table.RowSettings",{metadata:{library:"sap.ui.mdc",properties:{highlight:{type:"string",group:"Appearance",defaultValue:"None"},highlightText:{type:"string",group:"Misc",defaultValue:""},navigated:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{rowActions:{type:"sap.ui.mdc.table.RowActionItem",multiple:true}}}});i.prototype.getAllSettings=function(){const t={},i=this.clone();if(this.isBound("navigated")){t.navigated=i.getBindingInfo("navigated")}else{t.navigated=this.getNavigated()}if(this.isBound("highlight")){t.highlight=i.getBindingInfo("highlight")}else{t.highlight=this.getHighlight()}if(this.isBound("highlightText")){t.highlightText=i.getBindingInfo("highlightText")}else{t.highlightText=this.getHighlightText()}return t};i.prototype.getAllActions=function(){const t={},i=this.clone();if(this.isBound("rowActions")){t.items=i.getBindingInfo("rowActions");const e=t.items.template;t.templateInfo={type:e.isBound("type")?e.getBindingInfo("type"):e.getType(),text:e.isBound("text")?e.getBindingInfo("text"):e.getText(),icon:e.isBound("icon")?e.getBindingInfo("icon"):e.getIcon(),visible:e.isBound("visible")?e.getBindingInfo("visible"):e.getVisible()}}else{t.items=this.getRowActions()}return t};i.prototype.getRowActionCount=function(){let t=0;if(this.isBound("rowActions")){t=1}else{t=this.getRowActions().length}return t};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/TableSettings", ["sap/m/OverflowToolbarButton","sap/m/library","sap/m/OverflowToolbarMenuButton","sap/m/Menu","sap/m/MenuItem","sap/ui/core/library","sap/ui/Device","sap/ui/core/ShortcutHintsMixin","sap/ui/core/theming/Parameters","sap/ui/performance/trace/FESRHelper"],function(e,t,n,a,s,o,i,l,c,r){"use strict";const u=o.aria.HasPopup;let p;const T={createSettingsButton:function(e,t){if(!p){this._loadResourceBundle()}const n=this._createButton(e+"-settings",{icon:"sap-icon://action-settings",text:p.getText("table.SETTINGS"),press:t,tooltip:p.getText("table.SETTINGS"),ariaHasPopup:u.Dialog});r.setSemanticStepname(n,"press","mdc:tbl:p13n");l.addConfig(n,{addAccessibilityLabel:true,messageBundleKey:i.os.macintosh?"mdc.PERSONALIZATION_SHORTCUT_MAC":"mdc.PERSONALIZATION_SHORTCUT"},t[1]);return n},createPasteButton:function(e){const t=this._createButton(e+"-paste");r.setSemanticStepname(t,"press","mdc:tbl:paste");sap.ui.require(["sap/m/plugins/PasteProvider"],function(n){t.addDependent(new n({pasteFor:e+"-innerTable"}))});return t},createExportButton:function(e,o){if(!p){this._loadResourceBundle()}const u=c.get({name:"_sap_ui_mdc_Table_ExportButtonType"});const T=new n(e+"-export",{icon:"sap-icon://excel-attachment",text:p.getText("table.QUICK_EXPORT"),tooltip:p.getText("table.EXPORT_BUTTON_TEXT"),type:t.ButtonType[u],buttonMode:t.MenuButtonMode.Split,useDefaultActionOnly:true,defaultAction:o.default});const d=new a({items:[new s({text:p.getText("table.QUICK_EXPORT"),press:o.default}),new s({text:p.getText("table.EXPORT_WITH_SETTINGS"),press:o.exportAs})]});T.setMenu(d);r.setSemanticStepname(T,"defaultAction","OI:QE");r.setSemanticStepname(d.getItems()[0],"press","OI:QE");r.setSemanticStepname(d.getItems()[1],"press","OI:EXP:SETTINGS");l.addConfig(T._getButtonControl(),{addAccessibilityLabel:true,messageBundleKey:i.os.macintosh?"table.SHORTCUT_EXPORT_TO_EXCEL_MAC":"table.SHORTCUT_EXPORT_TO_EXCEL"},o.exportAs[1]);return T},createExpandCollapseAllButton:function(e,t,n){if(!p){this._loadResourceBundle()}const a=n?e+"-expandAll":e+"-collapseAll",s=n?p.getText("table.EXPAND_ALL"):p.getText("table.COLLAPSE_ALL");const o=this._createButton(a,{icon:n?"sap-icon://expand-all":"sap-icon://collapse-all",text:s,press:t,tooltip:s});r.setSemanticStepname(o,"press","mdc:tbl:"+(n?"expandAll":"collapseAll"));return o},_createButton:function(t,n){return new e(t,n)},_loadResourceBundle:function(){p=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc")}};return T});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/TableTypeBase", ["sap/ui/core/Element","sap/ui/core/dnd/DragDropInfo","sap/ui/model/base/ManagedObjectModel","sap/ui/mdc/enums/TableP13nMode"],function(t,e,o,n){"use strict";const r=t.extend("sap.ui.mdc.table.TableTypeBase",{metadata:{library:"sap.ui.mdc",abstract:true,properties:{}}});r.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oManagedObjectModel=new o(this)};r.prototype.exit=function(){this._disconnectFromTable();this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;t.prototype.exit.apply(this,arguments)};r.prototype.setParent=function(){this._disconnectFromTable();t.prototype.setParent.apply(this,arguments);this._connectToTable()};r.prototype._connectToTable=function(){const t=this.getTable();if(t){t.setModel(this._oManagedObjectModel,"$sap.ui.mdc.Table#type")}};r.prototype._disconnectFromTable=function(){const t=this.getTable();if(t&&!t.isDestroyStarted()){t.setModel(null,"$sap.ui.mdc.Table#type")}};r.prototype.getSupportedP13nModes=function(){return Object.keys(n)};r.prototype.callHook=function(t,e,o){const n="_on"+t;if(!e||!(e[n]instanceof Function)){throw new Error(this+": Hook '"+t+"' does not exist on "+e)}e[n].call(e,o)};r.prototype.getTable=function(){const t=this.getParent();return t&&t.isA("sap.ui.mdc.Table")?t:null};r.prototype.getInnerTable=function(){const t=this.getTable();return t?t._oTable:null};r.prototype.setProperty=function(e,o){t.prototype.setProperty.apply(this,arguments);this.updateTableByProperty(e,o);return this};r.prototype.updateTable=function(){for(const t in this.getMetadata().getAllProperties()){this.updateTableByProperty(t,this.getProperty(t))}};r.prototype.getTableSettings=function(){const t=this.getTable();if(!t){return{}}const o=new e({sourceAggregation:"columns",targetAggregation:"columns",dropPosition:"Between",enabled:t.getActiveP13nModes().includes(n.Column),drop:[this._onColumnMove,this]});o.bIgnoreMetadataCheck=true;return{dragDropConfig:[o],busyIndicatorDelay:t.getBusyIndicatorDelay(),paste:[this._onPaste,this]}};r.prototype.getThreshold=function(){const t=this.getTable();const e=t?t.getThreshold():-1;return e>-1?e:undefined};r.prototype.getRowSettingsConfig=function(){const t=this.getTable();const e=t?t.getRowSettings():null;return e?e.getAllSettings():null};r.prototype.getRowActionsConfig=function(){const t=this.getTable();const e=t?t.getRowSettings():null;return e?e.getAllActions():null};r.prototype._onColumnMove=function(t){const e=this.getTable();const o=this.getInnerTable();const n=t.getParameter("draggedControl");const r=t.getParameter("droppedControl");if(n===r){return}const i=t.getParameter("dropPosition");const s=o.indexOfColumn(n);const p=o.indexOfColumn(r);const a=p+(i=="Before"?0:1)+(s<p?-1:0);this.callHook("ColumnMove",e,{column:e.getColumns()[s],newIndex:a})};r.prototype._onPaste=function(t){this.callHook("Paste",this.getTable(),{data:t.getParameter("data")})};r.prototype._onColumnInsert=function(t){};r.prototype.loadModules=function(){return Promise.reject(this+" does not implement #loadModules")};r.prototype.updateTableByProperty=function(t,e){};r.prototype.removeToolbar=function(){};r.prototype.scrollToIndex=function(t){return Promise.reject()};r.prototype.updateRowSettings=function(){};r.prototype.prepareRowPress=function(){};r.prototype.cleanupRowPress=function(){};r.prototype.createTable=function(t){};r.prototype.getRowBinding=function(){};r.prototype.bindRows=function(t){};r.prototype.isTableBound=function(){};r.prototype.createRowTemplate=function(t){};r.prototype.insertFilterInfoBar=function(t,e){};r.prototype.enableColumnResize=function(){};r.prototype.disableColumnResize=function(){};r.prototype.createColumnResizeMenuItem=function(){};r.prototype.updateRowActions=function(){};r.prototype.updateSortIndicator=function(t,e){};r.prototype.getTableStyleClasses=function(){return[]};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/TreeTableType", ["./GridTableType"],function(e){"use strict";let t;const n=e.extend("sap.ui.mdc.table.TreeTableType",{metadata:{library:"sap.ui.mdc"}});n.prototype.loadModules=function(){if(t){return Promise.resolve()}return e.prototype.loadModules.apply(this,arguments).then(function(){return new Promise(function(e,n){sap.ui.require(["sap/ui/table/TreeTable"],function(n){t=n;e()},function(){n("Failed to load some modules")})})})};n.prototype.createTable=function(e){const n=this.getTable();if(!n||!t){return null}const o=new t(e,this.getTableSettings());o._oProxy._bEnableV4=true;return o};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/V4AnalyticsPropertyHelper", ["./PropertyHelper"],function(e){"use strict";const t=e.extend("sap.ui.mdc.table.V4AnalyticsPropertyHelper",{constructor:function(t,r){this._bEnableAggregatableAttribute=true;e.call(this,t,r,{technicallyGroupable:{type:"boolean",default:{value:"attribute:groupable"},forComplexProperty:{valueIfNotAllowed:false}},technicallyAggregatable:{type:"boolean",default:{value:"attribute:aggregatable"},forComplexProperty:{valueIfNotAllowed:false}},customAggregate:{type:{contextDefiningProperties:{type:"PropertyReference[]"}}}})}});t.prototype.validateProperty=function(t,r,o){e.prototype.validateProperty.apply(this,arguments);if(t.groupable&&t.extension&&t.extension.technicallyGroupable===false){throw new Error("Invalid property definition: A property cannot be groupable when not technically groupable.\n"+t)}if(t.aggregatable&&t.extension&&t.extension.technicallyAggregatable===false){throw new Error("Invalid property definition: A property cannot be aggregatable when not technically aggregatable.\n"+t)}};t.prototype.prepareProperty=function(t){e.prototype.prepareProperty.apply(this,arguments);Object.defineProperty(t,"getAggregatableProperties",{value:function(){return t.getSimpleProperties().filter(function(e){return e.aggregatable})}})};t.prototype.getAggregatableProperties=function(){return this.getProperties().filter(function(e){return e.aggregatable})};t.prototype.getPropertiesForPlugin=function(){return this.getProperties().reduce(function(e,t){if(t.isComplex()){return e}const r={name:t.name,path:t.path,key:t.key,text:t.text,unit:t.unit,groupable:t.extension.technicallyGroupable,aggregatable:t.extension.technicallyAggregatable};if(t.extension.customAggregate){r.aggregationDetails={customAggregate:{contextDefiningProperties:t.extension.customAggregate.contextDefiningProperties}}}e.push(r);return e},[])};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/menu/Item", ["sap/ui/core/Core","sap/ui/Device","sap/m/table/columnmenu/Item"],function(t,e,n){"use strict";const i=n.extend("sap.ui.mdc.table.menu.Item",{metadata:{library:"sap.ui.mdc",properties:{key:{type:"string"}}}});i.prototype.initializeContent=function(){const n=this.getTable();const i=t.byId(this.getParent().getAssociation("column"));const o=n.getEngine();const s=this.getKey();const r=o.getController(n,s);if(s==="Filter"){const t=n.getPropertyHelper().getProperty(i.getPropertyKey()).getFilterableProperties();const e=t.map(function(t){return t.name});n.getInbuiltFilter().setVisibleFields(e)}return n.getEngine().uimanager.create(n,[s]).then(function(t){if(!e.system.phone){t[0].setProperty("_useFixedWidth",true)}this.setContent(t[0]);this.setLabel(r.getUISettings().title);t.forEach(t=>{t.attachChange(t=>{this.setResetButtonEnabled(true)})});r.update(n.getPropertyHelper());o.validateP13n(n,s,this.getContent());o.hasChanges(n,s).then(t=>{this.setResetButtonEnabled(t)})}.bind(this))};i.prototype.onPress=function(){const t=this.getTable();t.getEngine().getController(t,this.getKey()).update(t.getPropertyHelper())};i.prototype.onConfirm=function(){const t=this.getTable();t.getEngine().handleP13n(t,[this.getKey()])};i.prototype.onReset=function(){const t=this.getTable();const e=this.getKey();this.setResetButtonEnabled(false);t.getEngine().reset(t,[e]).then(function(){t._oQuickActionContainer.updateQuickActions([e])})};i.prototype.destroyAggregation=function(t){if(this.getKey()==="Filter"&&t==="content"){return this}return n.prototype.destroyAggregation.apply(this,arguments)};i.prototype.getTable=function(){return this.getParent().getTable()};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/menu/ItemContainer", ["sap/m/table/columnmenu/ItemContainer","sap/ui/mdc/table/menu/Item","sap/ui/core/Core"],function(e,t,i){"use strict";const n=e.extend("sap.ui.mdc.table.menu.ItemContainer",{metadata:{library:"sap.ui.mdc",associations:{table:{type:"sap.ui.mdc.Table"},column:{type:"sap.ui.mdc.table.Column"}}}});n.prototype.initializeItems=function(){const e=this.getTable();this.destroyItems();if(e._isP13nButtonHidden()){return Promise.resolve()}if(e.isSortingEnabled()){this.addItem(new t({key:"Sort",icon:"sap-icon://sort"}))}if(e.isFilteringEnabled()){this.addItem(new t({key:"Filter",icon:"sap-icon://filter"}))}if(e.isGroupingEnabled()){this.addItem(new t({key:"Group",icon:"sap-icon://group-2"}))}if(e.getActiveP13nModes().includes("Column")){this.addItem(new t({key:"Column",icon:"sap-icon://table-column"}))}return Promise.all(this.getItems().map(function(e){return e.initializeContent()}))};n.prototype.hasItems=function(){return this.getEffectiveItems().length>0};n.prototype.getTable=function(){return i.byId(this.getAssociation("table"))};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/menu/QuickActionContainer", ["../ResponsiveTableType","../utils/Personalization","sap/m/table/columnmenu/QuickActionContainer","sap/m/table/columnmenu/QuickAction","sap/m/table/columnmenu/QuickSort","sap/m/table/columnmenu/QuickSortItem","sap/m/table/columnmenu/QuickGroup","sap/m/table/columnmenu/QuickGroupItem","sap/m/table/columnmenu/QuickTotal","sap/m/table/columnmenu/QuickTotalItem","sap/m/Button","sap/ui/core/Core","sap/ui/core/library"],function(e,t,n,o,r,i,s,c,a,u,g,l,m){"use strict";const p=n.extend("sap.ui.mdc.table.menu.QuickActionContainer",{metadata:{library:"sap.ui.mdc",associations:{table:{type:"sap.ui.mdc.Table"},column:{type:"sap.ui.mdc.table.Column"}}}});p.prototype.initializeQuickActions=function(){const e=this.getTable();const n=this.getColumn();const o=e.getPropertyHelper();const g=Promise.resolve();this.destroyQuickActions();if(e.isSortingEnabled()){const s=o.getProperty(n.getPropertyKey()).getSortableProperties();const c=e._getSortedProperties();if(s.length>0){this.addQuickAction(new r({items:s.map(function(e){let t=m.SortOrder.None;const n=c.find(function(t){return t.name===e.name});if(n){t=n.descending?m.SortOrder.Descending:m.SortOrder.Ascending}return new i({key:e.name,label:e.label,sortOrder:t})}),change:function(n){const o=n.getParameter("item");t.createSortChange(e,{property:o.getKey(),sortOrder:o.getSortOrder()})}}))}}if(e.isGroupingEnabled()){const r=o.getProperty(n.getPropertyKey()).getGroupableProperties();const i=e._getGroupedProperties();if(r.length>0){this.addQuickAction(new s({items:r.map(function(e){const t=i.some(function(t){return t.name===e.name});return new c({key:e.name,label:e.label,grouped:t})}),change:function(n){t.createGroupChange(e,{property:n.getParameter("item").getKey()})}}))}}if(e.isAggregationEnabled()){const r=o.getProperty(n.getPropertyKey()).getAggregatableProperties().filter(function(e){return e.extension&&e.extension.customAggregate});const i=e._getAggregatedProperties();if(r.length>0){this.addQuickAction(new a({items:r.map(function(e){return new u({key:e.name,label:e.label,totaled:i.hasOwnProperty(e.name)})}),change:function(n){t.createAggregateChange(e,{property:n.getParameter("item").getKey()})}}))}}if(e.getEnableColumnResize()){this.addQuickAction(e._getType().createColumnResizeMenuItem(n,this.getMenu()))}return g};p.prototype.updateQuickActions=function(e){const t=this.getTable();const n=t._getSortedProperties();const o=t._getGroupedProperties();const r=t._getAggregatedProperties();this.getQuickActions().forEach(function(t){if((!e||e.includes("Sort"))&&t.isA("sap.m.table.columnmenu.QuickSort")){t.getItems().forEach(function(e){const t=n.find(function(t){return t.name===e.getProperty("key")});if(t){e.setSortOrder(t.descending?m.SortOrder.Descending:m.SortOrder.Ascending)}else{e.setSortOrder(m.SortOrder.None)}})}else if((!e||e.includes("Group"))&&t.isA("sap.m.table.columnmenu.QuickGroup")){t.getItems().forEach(function(e){const t=o.some(function(t){return t.name===e.getProperty("key")});e.setGrouped(t)})}else if((!e||e.includes("Aggregate"))&&t.isA("sap.m.table.columnmenu.QuickTotal")){t.getItems().forEach(function(e){const t=r.hasOwnProperty(e.getProperty("key"));e.setTotaled(t)})}})};p.prototype.hasQuickActions=function(){return this.getEffectiveQuickActions().length>0};p.prototype.getTable=function(){return l.byId(this.getAssociation("table"))};p.prototype.getColumn=function(){return l.byId(this.getAssociation("column"))};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/utils/Personalization", ["sap/ui/core/library"],function(e){"use strict";const t={};t.isUserPersonalizationActive=function(e){return e._bUserPersonalizationActive===true};t.detectUserPersonalizationCompletion=function(e,t){if(!t.isOpen()){return}e._bUserPersonalizationActive=true;t.attachEventOnce("afterClose",function(){e.getEngine().waitForChanges(e).then(function(){delete e._bUserPersonalizationActive})})};t.openSettingsDialog=function(e){n(e,e.getActiveP13nModes())};t.openFilterDialog=function(e,t){return n(e,["Filter"],t)};function n(e,t,n){return e.finalizePropertyHelper().then(function(){const r=e.getEngine();if(e.getInbuiltFilter()){e.getInbuiltFilter().setVisibleFields(null)}return r.show(e,t,{close:function(){if(n){n()}r.waitForChanges(e).then(function(){delete e._bUserPersonalizationActive})}}).then(function(t){if(t){e._bUserPersonalizationActive=true}return t})})}t.createSortChange=function(t,n){t.getEngine().createChanges({control:t,key:"Sort",state:[{name:n.property,descending:n.sortOrder===e.SortOrder.Descending,sorted:n.sortOrder!==e.SortOrder.None}],applyAbsolute:true})};t.createGroupChange=function(e,t){const n=(e.getCurrentState().groupLevels||[]).some(function(e){return e.name==t.property});e.getEngine().createChanges({control:e,key:"Group",state:[{grouped:!n,name:t.property}],applyAbsolute:e._isOfType("ResponsiveTable")})};t.createFilterChange=function(e,t){e.getEngine().createChanges({control:e,key:"Filter",state:t.conditions,applyAbsolute:t.strategy})};t.createAggregateChange=function(e,t){const n=t.property in(e.getCurrentState().aggregations||{});e.getEngine().createChanges({control:e,key:"Aggregate",state:[{name:t.property,aggregated:!n}],applyAbsolute:false})};t.createColumnWidthChange=function(e,t){e.getEngine().createChanges({control:e,key:"ColumnWidth",state:[{name:t.column.getPropertyKey(),width:t.width}],applyAbsolute:false})};t.createColumnReorderChange=function(e,t){const n=e.indexOfColumn(t.column);if(n===t.index){return}e.getEngine().createChanges({control:e,key:"Column",state:[{name:t.column.getPropertyKey(),position:t.index}]})};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/ushell/LinkDelegate", ["sap/ui/mdc/LinkDelegate","sap/ui/mdc/link/LinkItem","sap/ui/mdc/link/Factory","sap/ui/mdc/link/Log","sap/base/Log","sap/base/util/isPlainObject","sap/ui/mdc/ushell/SemanticObjectMapping","sap/ui/mdc/ushell/SemanticObjectMappingItem","sap/ui/mdc/ushell/SemanticObjectUnavailableAction","sap/ui/mdc/enums/LinkType"],function(t,e,n,i,a,c,o,r,s,u){"use strict";const l=Object.assign({},t);l.fetchLinkItems=function(t,e,n){const a=t.getPayload();const c=e?e.getObject(e.getPath()):undefined;const o=[];if(n){n.initialize(l._getSemanticObjects(a));o.forEach(function(t){n.addIntent(i.IntentType.API,{text:t.getText(),intent:t.getHref()})})}const r=l._calculateSemanticAttributes(c,a,n);return l._retrieveNavigationTargets("",r,a,n).then(function(t,e){return Promise.resolve(t)})};l.fetchLinkType=function(t){const e={};let i=null;const c=t.getPayload();const o=function(t){return t.filter(function(t){return!e[t]}).length===0};const r=function(t){return t.some(function(t){return e[t]&&e[t].exists===true})};const s=function(){if(!i){i=new Promise(function(t){const c=n.getService("CrossApplicationNavigation");if(!c){a.error("LinkDelegate: Service 'CrossApplicationNavigation' could not be obtained");t({});return}c.getDistinctSemanticObjects().then(function(n){n.forEach(function(t){e[t]={exists:true}});i=null;return t(e)},function(){a.error("LinkDelegate: getDistinctSemanticObjects() of service 'CrossApplicationNavigation' failed");return t({})})})}return i};const l=function(t){if(o(t)){return Promise.resolve(r(t))}return s().then(function(){return r(t)})};if(c&&c.semanticObjects){return l(c.semanticObjects).then(function(t){return Promise.resolve({type:t?u.Popover:u.Text,directLink:undefined})})}else{throw new Error("no payload or semanticObjects found")}};l._calculateSemanticAttributes=function(t,e,n){const i=l._getSemanticObjects(e);const o=l._convertSemanticObjectMapping(l._getSemanticObjectMappings(e));if(!i.length){i.push("")}const r={};i.forEach(function(e){if(n){n.addContextObject(e,t)}r[e]={};for(const i in t){let s=null,u=null;if(n){s=n.getSemanticObjectAttribute(e,i);if(!s){s=n.createAttributeStructure();n.addSemanticObjectAttribute(e,i,s)}}if(t[i]===undefined||t[i]===null){if(s){s.transformations.push({value:undefined,description:"ℹ Undefined and null values have been removed in LinkDelegate."})}continue}if(c(t[i])){if(s){s.transformations.push({value:undefined,description:"ℹ Plain objects has been removed in LinkDelegate."})}continue}const l=o&&o[e]&&o[e][i]?o[e][i]:i;if(s&&i!==l){u={value:undefined,description:"ℹ The attribute "+i+" has been renamed to "+l+" in LinkDelegate.",reason:"🔴 A com.sap.vocabularies.Common.v1.SemanticObjectMapping annotation is defined for semantic object "+e+" with source attribute "+i+" and target attribute "+l+". You can modify the annotation if the mapping result is not what you expected."}}if(r[e][l]){a.error("LinkDelegate: The attribute "+i+" can not be renamed to the attribute "+l+" due to a clash situation. This can lead to wrong navigation later on.")}r[e][l]=t[i];if(s){if(u){s.transformations.push(u);const a=n.createAttributeStructure();a.transformations.push({value:t[i],description:"ℹ The attribute "+l+" with the value "+t[i]+" has been added due to a mapping rule regarding the attribute "+i+" in LinkDelegate."});n.addSemanticObjectAttribute(e,l,a)}}}});return r};l._retrieveNavigationTargets=function(t,i,c,o){if(!c.semanticObjects){return new Promise(function(t){t([])})}const r=c.semanticObjects;const s=c.sourceControl;const u={ownNavigation:undefined,availableActions:[]};return sap.ui.getCore().loadLibrary("sap.ui.fl",{async:true}).then(function(){return new Promise(function(f){sap.ui.require(["sap/ui/fl/Utils"],function(b){const g=n.getService("CrossApplicationNavigation");const m=n.getService("URLParsing");if(!g||!m){a.error("LinkDelegate: Service 'CrossApplicationNavigation' or 'URLParsing' could not be obtained");return f(u.availableActions,u.ownNavigation)}const d=sap.ui.getCore().byId(s);const p=b.getAppComponentForControl(d);const h=r.map(function(e){return[{semanticObject:e,params:i?i[e]:undefined,appStateKey:t,ui5Component:p,sortResultsBy:"text"}]});return new Promise(function(){g.getLinks(h).then(function(t){if(!t||!t.length){return f(u.availableActions,u.ownNavigation)}const n=l._getSemanticObjectUnavailableActions(c);const i=l._convertSemanticObjectUnavailableAction(n);let a=g.hrefForExternal();if(a&&a.indexOf("?")!==-1){a=a.split("?")[0]}if(a){a+="?"}const s=function(t,e){return!!i&&!!i[t]&&i[t].indexOf(e)>-1};const b=function(t){const n=m.parseShellHash(t.intent);if(s(n.semanticObject,n.action)){return}const i=g.hrefForExternal({target:{shellHash:t.intent}},p);if(t.intent&&t.intent.indexOf(a)===0){u.ownNavigation=new e({href:i,text:t.text,internalHref:t.intent});return}const c=new e({key:n.semanticObject&&n.action?n.semanticObject+"-"+n.action:undefined,text:t.text,description:undefined,href:i,internalHref:t.intent,icon:undefined,initiallyVisible:t.tags&&t.tags.indexOf("superiorAction")>-1});u.availableActions.push(c);if(o){o.addSemanticObjectIntent(n.semanticObject,{intent:c.getHref(),text:c.getText()})}};for(let e=0;e<r.length;e++){t[e][0].forEach(b)}return f(u.availableActions,u.ownNavigation)},function(){a.error("LinkDelegate: '_retrieveNavigationTargets' failed executing getLinks method");return f(u.availableActions,u.ownNavigation)})})})})})};l._getSemanticObjects=function(t){return t.semanticObjects?t.semanticObjects:[]};l._getSemanticObjectUnavailableActions=function(t){const e=[];if(t.semanticObjectUnavailableActions){t.semanticObjectUnavailableActions.forEach(function(t){e.push(new s({semanticObject:t.semanticObject,actions:t.actions}))})}return e};l._getSemanticObjectMappings=function(t){const e=[];let n=[];if(t.semanticObjectMappings){t.semanticObjectMappings.forEach(function(t){n=[];if(t.items){t.items.forEach(function(t){n.push(new r({key:t.key,value:t.value}))})}e.push(new o({semanticObject:t.semanticObject,items:n}))})}return e};l._convertSemanticObjectMapping=function(t){if(!t.length){return undefined}const e={};t.forEach(function(t){if(!t.getSemanticObject()){throw Error("LinkDelegate: 'semanticObject' property with value '"+t.getSemanticObject()+"' is not valid")}e[t.getSemanticObject()]=t.getItems().reduce(function(t,e){t[e.getKey()]=e.getValue();return t},{})});return e};l._convertSemanticObjectUnavailableAction=function(t){if(!t.length){return undefined}const e={};t.forEach(function(t){if(!t.getSemanticObject()){throw Error("LinkDelegate: 'semanticObject' property with value '"+t.getSemanticObject()+"' is not valid")}e[t.getSemanticObject()]=t.getActions()});return e};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/ushell/SemanticObjectMapping", ["sap/ui/core/Element"],function(e){"use strict";const t=e.extend("sap.ui.mdc.link.SemanticObjectMapping",{metadata:{library:"sap.ui.mdc",properties:{semanticObject:{type:"string"}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.mdc.link.SemanticObjectMappingItem",multiple:true,singularName:"item"}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/ushell/SemanticObjectMappingItem", ["sap/ui/core/Element"],function(e){"use strict";const t=e.extend("sap.ui.mdc.link.SemanticObjectMappingItem",{metadata:{library:"sap.ui.mdc",properties:{key:{type:"string"},value:{type:"any"}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/ushell/SemanticObjectUnavailableAction", ["sap/ui/core/Element"],function(e){"use strict";const t=e.extend("sap.ui.mdc.link.SemanticObjectUnavailableAction",{metadata:{library:"sap.ui.mdc",properties:{semanticObject:{type:"string"},actions:{type:"string[]",defaultValue:[]}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/Common", [],function(){"use strict";const n={cleanup:function(n,t){t.forEach(function(t){const e=n[t];if(e){if(e.destroy&&!e.bIsDestroyed){e.destroy()}n[t]=null}})}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/DateUtil", ["sap/ui/core/library","sap/ui/core/date/UI5Date","sap/ui/mdc/enums/BaseType","sap/base/util/merge"],function(e,t,n,o){"use strict";const s=e.CalendarType;const a={createInternalType:function(e,t){const n=sap.ui.require(e.getMetadata().getName().replace(/\./g,"/"));const a=o({},e.getConstraints());const i=o({},e.getFormatOptions());if(i.style){delete i.style}i.pattern=t;i.calendarType=s.Gregorian;if(this.showTimezone(e)){i.showTimezone=false}return new n(i,a)},showTimezone:function(e){const t=e.getFormatOptions();const n=function(e,t){return!e.hasOwnProperty(t)||e[t]};return e.isA("sap.ui.model.odata.type.DateTimeWithTimezone")&&n(t,"showTimezone")&&(n(t,"showDate")||n(t,"showTime"))},typeToString:function(e,t,n){const o=this.createInternalType(t,n);const s=o.formatValue(e,"string");return s},stringToType:function(e,t,n){const o=this.createInternalType(t,n);const s=o.parseValue(e,"string");return s},typeToISO:function(e,n,o){if(n.getISOStringFromModelValue){return n.getISOStringFromModelValue(e)}else{let s=this.typeToDate(e,n,o);if(n.getFormatOptions().UTC){s=t.getInstance(Date.UTC(s.getFullYear(),s.getMonth(),s.getDate(),s.getHours(),s.getMinutes(),s.getSeconds(),s.getMilliseconds()))}return s.toISOString()}},ISOToType:function(e,n,o){if(n.getModelValueFromISOString){return n.getModelValueFromISOString(e)}else{let s=t.getInstance(e);if(n.getFormatOptions().UTC){s=t.getInstance(s.getUTCFullYear(),s.getUTCMonth(),s.getUTCDate(),s.getUTCHours(),s.getUTCMinutes(),s.getUTCSeconds(),s.getUTCMilliseconds())}return this.dateToType(s,n,o)}},dateToType:function(e,o,s){let a;if(o.getModelValue){a=o.getModelValue(e)}else if(o.isA("sap.ui.model.type.DateTime")&&o.getFormatOptions().UTC){a=t.getInstance(Date.UTC(e.getFullYear(),e.getMonth(),e.getDate(),e.getHours(),e.getMinutes(),e.getSeconds(),e.getMilliseconds()))}else{const t=o.getModelFormat();const i=o.getFormatOptions();const r=s===n.DateTime?!!i.UTC:false;a=t.format(e,r)}return a},typeToDate:function(e,o,s){let a;if(o.getDateValue){a=o.getDateValue(e)}else if(o.isA("sap.ui.model.type.DateTime")&&o.getFormatOptions().UTC){a=t.getInstance(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds())}else{const t=o.getModelFormat();const i=o.getFormatOptions();const r=s===n.DateTime?!!i.UTC:false;a=t.parse(e,r)}return a}};return a});
/*
 * ! OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/DensityHelper", ["sap/ui/thirdparty/jquery","sap/ui/base/Object"],function(jQuery,n){"use strict";const e=["sapUiSizeCozy","sapUiSizeCompact","sapUiSizeCondensed"];const t=e[0];const s=function(n,t){if(!t||!t[n]){return undefined}for(let s=0;s<e.length;s++){if(t[n](e[s])){return e[s]}}return undefined};const i=function(t){const i=!n.isA(t,"sap.ui.core.Control");return i?s("hasClass",jQuery(t).closest("."+e.join(",."))):s("hasStyleClass",t)};const o={};o.syncDensity=function(n,e){if(!i(n)){const s=e&&i(e)||i(document.body)||t;return n.addStyleClass(s)}return undefined};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/FilterUtil", ["sap/ui/mdc/util/IdentifierUtil","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/condition/ConditionConverter","sap/ui/mdc/condition/FilterConverter","sap/base/Log","sap/base/util/merge"],function(e,t,n,i,o,r,s){"use strict";const a=function(e){if(e&&e.getTypeMap){return e.getTypeMap()}if(e&&e.getTypeUtil){return e.getTypeUtil()}return e};const u={getPropertyByKey:function(t,n){let i=null;t.some(function(t){if(e.getPropertyPath(t)===n){i=t}return i!=null});if(!i){t.some(function(t){if(e.getPropertyKey(t)===n){i=t}return i!=null})}return i},getConditionsMap:function(e,i){let o,s;const a={};if(!e||!e.isA("sap.ui.mdc.FilterBar")){r.error("instance of sap.ui.mdc.FilterBar expected");return a}const u=e.getInternalConditions();for(const e in u){if(i.indexOf(e)>=0){o=[];if(u[e]){for(let i=0;i<u[e].length;i++){s={};s.operator=u[e][i].operator;if(s.operator===n.EQ&&u[e][i].validated===t.Validated){s.values=[u[e][i].values[0]]}else{s.values=u[e][i].values}o.push(s)}a[e]=o}}}return a},getFilterInfo:function(e,t,n,c){const l={};let f={};if(n&&n.length>0){Object.keys(t).forEach(function(e){const i=n.find(function(t){return t.name===e});const o=i&&i.path?i.path:e;f[o]=t[e]})}else{f=t}c=c?c:[];let p,d,g;const y={};const m={};if(n&&n.length>0){for(d in f){if(c.indexOf(d)<0){const t=u.getPropertyByKey(n,d);if(t){m[d]={type:t.typeConfig.typeInstance,caseSensitive:t.caseSensitive,baseType:t.typeConfig.baseType};y[d]=[];for(p=0;p<f[d].length;p++){g=s({},f[d][p]);y[d].push(i.toType(g,t.typeConfig.typeInstance,a(e)))}}else{r.error("sap.ui.mdc.util.FilterUitl.js :","could not find propertyMetadata of : "+d)}}}if(Object.keys(y).length>0){l.filters=o.createFilters(y,m)}}return l},getRequiredFieldNamesWithoutValues:function(e){const t=[];if(e&&e._getRequiredPropertyNames&&e._getConditionModel){e._getRequiredPropertyNames().forEach(function(n){const i=e._getConditionModel().getConditions(n);if(!i||i.length===0){t.push(n)}})}return t}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/IdentifierUtil", ["sap/ui/base/DataType"],function(e){"use strict";const t={replace:function(t){const i=e.getType("sap.ui.core.ID");if(!i.isValid(t)){t=t.replace(/[^A-Za-z0-9_.:]+/g,"__mdc__");if(!i.isValid(t)){t="__mdc__"+t}}return t},getFilterFieldId:function(e,i){return e.getId()+"--filter--"+t.replace(i)},getPropertyKey:function(e){return e.name},getPropertyPath:function(e){return e.path},getView:function(e){let t=null;if(e){let i=e.getParent();while(i){if(i.isA("sap.ui.core.mvc.View")){t=i;break}i=i.getParent()}}return t}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/InfoBar", ["sap/ui/core/Control","sap/m/OverflowToolbar","sap/ui/mdc/util/InfoBarRenderer","sap/m/Text","sap/ui/core/InvisibleText","sap/m/Label","sap/m/Button","sap/m/library","sap/m/ToolbarSpacer"],function(t,e,i,s,o,n,r,l,a){"use strict";const p=t.extend("sap.ui.mdc.util.InfoBar",{metadata:{properties:{infoText:{type:"string"}},aggregations:{_toolbar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"}},events:{press:{parameters:{srcControl:{type:"sap.ui.core.Control"}}},removeAllFilters:{parameters:{}}}},renderer:i});p.prototype.applySettings=function(){t.prototype.applySettings.apply(this,arguments);this.setInfoText(this.getInfoText())};p.prototype.init=function(){this.setVisible(false);this.oText=new s({wrapping:false});this.oInvisibleText=(new o).toStatic();this.oRemoveAllFiltersBtn=new r(this.getId()+"-RemoveAllFilters",{type:l.ButtonType.Transparent,press:function(t){this.fireRemoveAllFilters()}.bind(this),icon:"sap-icon://decline",tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("infobar.REMOVEALLFILTERS")});const t=new e(this.getId()+"--bar",{design:"Info",active:true,content:[this.oText,new a,this.oRemoveAllFiltersBtn]});t.attachPress(function(t){this.firePress({srcControl:t})}.bind(this));this.setAggregation("_toolbar",t)};p.prototype.setInfoText=function(t){this.setProperty("infoText",t);this.setVisible(!!t);if(this.oText&&this.oInvisibleText){this.oText.setText(t);this.oInvisibleText.setText(t)}return this};p.prototype.getACCTextId=function(){return this.oInvisibleText.getId()};p.prototype.exit=function(){if(this.oInvisibleText){this.oInvisibleText.destroy();this.oInvisibleText=null}if(this.oText){this.oText.destroy();this.oText=null}if(this.oRemoveAllFiltersBtn){this.oRemoveAllFiltersBtn.destroy();this.oRemoveAllFiltersBtn=null}};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/InfoBarRenderer", ["../library"],function(e){"use strict";const r={apiVersion:2};r.render=function(e,r){e.openStart("div",r);e.attr("id",r.getId());e.openEnd();e.renderControl(r.getAggregation("_toolbar"));e.close("div")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/PromiseCache", ["sap/ui/base/Object"],function(e){"use strict";const t=function(e){if(!e){throw new Error("PromiseCache: Please provide an identifier!")}if(this._oCache&&this._oCache[e]){this.remove.call(this,e)}};const i=function(e){if(typeof e==="object"&&this._oCache){for(const t in this._oCache){if(this._oCache[t].promise===e){return t}}}};const n=function(e,t){const n=typeof e==="string"?e:i.call(this,e);const o=n&&this._oCache&&this._oCache[n];if(t&&!o){throw new Error("PromiseCache: Promise not found!")}return o};const o=e.extend("sap.ui.mdc.util.PromiseCache",{constructor:function(){this._oCache={}},add:function(e,i){t.call(this,e);const n={};this._oCache[e]=n;n.promise=new Promise(function(e,t){n.resolve=function(t){if(!n._isCanceled){n._isSettled=true;e(t)}};n.reject=function(e){if(!n._isCanceled){n._isSettled=true;t(e)}}});n.promise.isSettled=function(){return!!n._isSettled};n.promise.isPending=function(){return!n._isSettled&&!n._isCanceled};n.promise.isCanceled=function(){return!!n._isCanceled};n.promise.getInternalPromise=function(){return n._promise};if(i){const e=typeof i==="function";const t=!e&&typeof i.then==="function";if(!e&&!t){throw new Error("PromiseCache: fnCreate must be a promise or function")}const o=e?i():i;const s=o&&typeof o.then==="function";if(s){n._promise=o;n._promise.then(function(e){if(!n._isCanceled){n._isSettled=true;n.resolve(e)}return e},function(e){if(!n._isCanceled){n._isSettled=true;n.reject(e)}})}else{n.resolve(o)}}return this._oCache[e].promise},cancel:function(e){const t=n.call(this,e,true);if(!t._isSettled){t._isCanceled=true}return t.promise},retrieve:function(e,t){const i=this._oCache&&this._oCache[e];if(!i&&t){return this.add.apply(this,[e,t])}return i&&i.promise},retrieveMany:function(){const e=[];const t=arguments.length?[].slice.call(arguments):Object.keys(this._oCache);for(let i=0;i<t.length;i++){e.push(this.retrieve(t[i].toString()))}return e},remove:function(e){const t=typeof e==="string"?e:i.call(this,e);const n=t&&this._oCache&&this._oCache[t];if(n){n._isCanceled=true;delete this._oCache[t]}},resolve:function(e,t){const i=n.call(this,e,true);i.resolve(t);return i.promise},reject:function(e,t){const i=n.call(this,e,true);i.reject(t);return i.promise},clear:function(){Object.keys(this._oCache).forEach(function(e){this.remove(e)}.bind(this))},destroy:function(){this.clear();this._oCache=null}});return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/PropertyHelper", ["sap/ui/base/Object","sap/ui/base/DataType","sap/ui/core/Core","sap/base/util/merge","sap/base/util/isPlainObject","sap/base/Log"],function(e,t,r,o,n,i){"use strict";const a={name:{type:"string",mandatory:true,forComplexProperty:{allowed:true}},label:{type:"string",mandatory:true,forComplexProperty:{allowed:true}},tooltip:{type:"string",forComplexProperty:{allowed:true}},visible:{type:"boolean",default:{value:true},forComplexProperty:{allowed:true}},path:{type:"string"},dataType:{type:"string",mandatory:true},formatOptions:{type:"object"},constraints:{type:"object"},maxConditions:{type:"int",default:{value:-1}},caseSensitive:{type:"boolean",default:{value:true}},group:{type:"string",forComplexProperty:{allowed:true}},groupLabel:{type:"string",forComplexProperty:{allowed:true}},filterable:{type:"boolean",default:{value:true},forComplexProperty:{valueIfNotAllowed:false}},sortable:{type:"boolean",default:{value:true},forComplexProperty:{valueIfNotAllowed:false}},propertyInfos:{type:"PropertyReference[]",forComplexProperty:{allowed:true}}};const p={isComplex:function(){return A.isPropertyComplex(this)},getSimpleProperties:function(){return this.propertyInfosProperties||[this]},getSortableProperties:function(){return this.getSimpleProperties().filter(function(e){return e.sortable})},getFilterableProperties:function(){return this.getSimpleProperties().filter(function(e){return e.filterable})},getVisibleProperties:function(){return this.getSimpleProperties().filter(function(e){return e.visible})}};const s=["name","label","tooltip","visible","path","dataType","formatOptions","constraints","maxConditions","group","groupLabel","caseSensitive"];const l=new WeakMap;function u(e){return JSON.stringify(e,function(e,t){return t===undefined?null:t})||""}function f(e,t){const o=r.getLoadedLibraries();if(!(window["sap-ui-mdc-config"]&&window["sap-ui-mdc-config"].disableStrictPropertyInfoValidation||new URLSearchParams(window.location.search).get("sap-ui-xx-disableStrictPropertyValidation")=="true")&&!("sap.fe.core"in o||"sap.fe.macros"in o||"sap.sac.df"in o)||new URLSearchParams(window.location.search).get("sap-ui-xx-enableStrictPropertyValidation")=="true"){c(e,t)}if(i.getLevel()<i.WARNING){return}const n=u(t);i.warning("Invalid property definition: "+e+(n?"\n"+n:""))}function c(e,t){const r=t?u(t):null;throw new Error("Invalid property definition: "+e+(r?"\n"+r:""))}function y(e,t){t.map(function(e){Object.keys(p).forEach(function(t){Object.defineProperty(e,t,{value:function(){return p[t].call(this)},writable:true})})})}function d(e){const t=Object.getOwnPropertyNames(e);Object.freeze(e);for(let r=0;r<t.length;r++){const o=e[t[r]];if(typeof o==="function"){Object.freeze(o)}else if(n(o)&&!Object.isFrozen(o)){d(o)}else if(Array.isArray(o)){d(o)}}}function P(e,t){if(!t){return e}return t.split(".").reduce(function(e,t){return e&&e[t]?e[t]:null},e)}function b(e){let r;if(typeof e==="object"){r="object"}else{r=e.replace("PropertyReference","string")}return t.getType(r)}function g(e){const t=b(e);if(t.isArrayType()){return t.getBaseType().getDefaultValue()}else{return t.getDefaultValue()}}function m(e,t){t.forEach(function(t){e.prepareProperty(t)});d(t)}function h(e,t,r,o,n,i){const a=o==null;let p=[];const s=A.isPropertyComplex(t);if(a){i=l.get(e).mAttributeMetadata;n=t}if(!n){return[]}for(const l in i){const u=i[l];const f=a?l:o+"."+l;const c=n[l];if(s&&!u.forComplexProperty.allowed){if("valueIfNotAllowed"in u.forComplexProperty){n[l]=u.forComplexProperty.valueIfNotAllowed}continue}if(c!=null&&typeof u.type==="string"&&u.type.startsWith("PropertyReference")||f==="propertyInfos"){if(s||f!=="propertyInfos"){v(n,l,r)}continue}if(c==null){w(n,u,o,l,p,c)}if(typeof u.type==="object"){p=p.concat(h(e,t,r,f,n[l],u.type))}}return p}function v(e,t,r){const o=e[t];let n;let i=t;if(Array.isArray(o)){n=o.map(function(e){return r[e]});i+="Properties"}else{n=r[o];i+="Property"}Object.defineProperty(e,i,{value:n})}function w(e,t,r,n,i,a){if("default"in t){const p=t.default;if(a===null&&p.ignoreIfNull&&"value"in p){return}if(p.value===undefined){e[n]=g(t.type)}else if(typeof p.value==="string"&&p.value.startsWith("attribute:")){i.push({source:p.value.substring(p.value.indexOf(":")+1),targetPath:r,targetAttribute:n,targetType:t.type})}else if(typeof p.value==="object"){e[n]=o({},p.value)}else{e[n]=p.value}}else{e[n]=g(t.type)}}function x(e){return Object.freeze(e.reduce(function(e,t){e[t.name]=t;return e},{}))}function C(e,t,r){for(const o in e){const n=e[o];const i=t==null?o:t+"."+o;const a=r?r.forComplexProperty:{};n.forComplexProperty=Object.assign({allowed:a.allowed&&a.propagateAllowance,propagateAllowance:true},n.forComplexProperty);if(typeof n.type==="object"){C(n.type,i,n)}}}function j(e,t){if(!Array.isArray(t)){c("Property infos must be an array.")}const r=l.get(e);const n=o([],t);e.validateProperties(n,r.aPreviousRawProperties);r.aProperties=n;r.mProperties=x(n);r.aPreviousRawProperties=o([],t);y(e,n);m(e,n)}const A=e.extend("sap.ui.mdc.util.PropertyHelper",{constructor:function(t,r,o){e.call(this);if(r&&!e.isObjectA(r,"sap.ui.base.ManagedObject")){throw new Error("The type of the parent is invalid.")}Object.keys(o||{}).forEach(function(e){if(e in a&&o[e]!==true){throw new Error("The attribute '"+e+"' is reserved and cannot be overridden by additional attributes.")}});const n={};const i=Object.keys(o||{});n.mAttributeMetadata=s.concat(i).reduce(function(e,t){e[t]=t in a?a[t]:o[t];return e},{});C(n.mAttributeMetadata);n.aMandatoryAttributes=Object.keys(n.mAttributeMetadata).filter(function(e){return n.mAttributeMetadata[e].mandatory});n.oParent=r||null;l.set(this,n);j(this,t)}});A.prototype.validateProperties=function(e,t){const r=new Set;for(let o=0;o<e.length;o++){this.validateProperty(e[o],e,t);r.add(e[o].name)}if(r.size!==e.length){c("Properties do not have unique names.")}};A.prototype.validateProperty=function(e,t,r){if(!n(e)){c("Property info must be a plain object.")}O(this,e,t);if(A.isPropertyComplex(e)){if(!e.propertyInfos||e.propertyInfos.length===0){c("Complex property does not reference existing properties.",e)}}const o=l.get(this);o.aMandatoryAttributes.forEach(function(t){const r=o.mAttributeMetadata[t].forComplexProperty.allowed;if(e[t]==null&&A.isPropertyComplex(e)&&!r){return}if(!(t in e)){f("Property does not contain mandatory attribute '"+t+"'.",e)}else if(e[t]==null){c("Property does not contain mandatory attribute '"+t+"'.",e)}})};function O(e,t,r,o,n,i){const a=o==null;if(a){i=l.get(e).mAttributeMetadata;n=t}for(const p in n){const s=i[p];const l=a?p:o+"."+p;const u=n[p];if(!s){f("Property contains invalid attribute '"+l+"'.",t)}else if(A.isPropertyComplex(t)&&!s.forComplexProperty.allowed){f("Complex property contains invalid attribute '"+l+"'.",t)}else if(typeof s.type==="object"&&u&&typeof u==="object"){O(e,t,r,l,u,s.type)}else if(u!=null&&!b(s.type).isValid(u)){c("The value of '"+l+"' is invalid.",t)}else if(u&&typeof s.type==="string"&&s.type.startsWith("PropertyReference")){I(e,t,r,l,u,s)}}}function I(e,t,r,o,n,i){const a=i.type.endsWith("[]")?n:[n];const p=new Set(a);if(a.indexOf(t.name)>-1){c("Property references itself in the '"+o+"' attribute.",t)}if(p.size!==a.length){c("Property contains duplicate names in the '"+o+"' attribute.",t)}for(let e=0;e<r.length;e++){if(p.has(r[e].name)){if(A.isPropertyComplex(r[e])){c("Property references complex properties in the '"+o+"' attribute.",t)}p.delete(r[e].name)}}if(p.size>0){c("Property references non-existing properties in the '"+o+"' attribute.",t)}}A.prototype.prepareProperty=function(e){const t=this.getPropertyMap();const r=h(this,e,t);r.forEach(function(r){const o=P(e,r.targetPath);if(o){let n=P(e,r.source);if(n==null){n=g(r.targetType)}o[r.targetAttribute]=n;if(typeof r.targetType==="string"&&r.targetType.startsWith("PropertyReference")){v(o,r.targetAttribute,t)}}})};A.prototype.getParent=function(){const e=l.get(this);return e?e.oParent:null};A.prototype.setProperties=function(e){j(this,e)};A.prototype.getProperties=function(){const e=l.get(this);return e?e.aProperties:[]};A.prototype.getPropertyMap=function(){const e=l.get(this);return e?e.mProperties:{}};A.prototype.getProperty=function(e){return this.getPropertyMap()[e]||null};A.prototype.hasProperty=function(e){return e in this.getPropertyMap()};A.isPropertyComplex=function(e){return e!=null&&typeof e==="object"?"propertyInfos"in e:false};A.prototype.getSortableProperties=function(){return this.getProperties().filter(function(e){return e.sortable})};A.prototype.getFilterableProperties=function(){return this.getProperties().filter(function(e){return e.filterable})};A.prototype.getVisibleProperties=function(){return this.getProperties().filter(function(e){return e.visible})};A.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments);l.delete(this)};return A});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/TypeMap", ["sap/ui/mdc/enums/BaseType","sap/ui/model/SimpleType","sap/base/util/ObjectPath","sap/ui/mdc/util/DateUtil","sap/base/util/merge"],function(t,e,n,a,i){"use strict";const s="yyyy-MM-dd";const r="HH:mm:ss";const o=new WeakMap;const u={};u._get=function(t){const e=this._getMap().get(t);if(typeof e==="string"){return this._get(e)}else if(e){return[t,e]}};u._set=function(t,e){const n=this._getMap();if(n._bFrozen){throw"TypeMap: You must not modify a frozen TypeMap"}n.set(t,e)};u._getMap=function(){let t=o.get(this);if(!t){t=new Map;o.set(this,t)}return t};u.set=function(t,e,n){this._set(t,[e,n])};u.setAlias=function(t,e){this._set(t,e)};u._getBaseType=function(t){const e=this._get(t);return e&&e[1][0]};u._getOptions=function(t){const e=this._get(t);return e&&e[1][1]};u._getClass=function(t){const e=this._get(t);return e&&e[0]};u.export=function(){return Array.from(this._getMap())};u.import=function(t){t.export().forEach(function(t){this._getMap().set(t[0],t[1])}.bind(this))};u.freeze=function(){this._getMap()._bFrozen=true};u.getBaseType=function(e,n,a){const i=this._getBaseType(e);return i&&(typeof i==="function"?i(n,a):i)||t.String};u.getBaseTypeForType=function(t){return this.getBaseType(t.getMetadata&&t.getMetadata().getName(),t.getFormatOptions(),t.getConstraints())};u.getDataTypeClassName=function(t){return this._getClass(t)||t};u.getDataTypeClass=function(t){const e=this.getDataTypeClassName(t);let a;if(e){a=sap.ui.require(e.replace(/\./g,"/"));if(!a){a=n.get(e)}}if(!a){throw new Error("DataType '"+t+"' cannot be determined")}return a};u.getDataTypeInstance=function(t,e,n,a){const s=this.getDataTypeClass(t);const r=this._getOptions(s.getMetadata().getName());const o=r&&r(i({},e),i({},n),a);e=o&&o[0]||e;n=o&&o[1]||n;return new s(e,n)};u.getTypeConfig=function(t,e,n){const a=this._normalizeType.call(this,t,e,n);return{className:a.getMetadata().getName(),typeInstance:a,baseType:this.getBaseTypeForType(a)}};u.externalizeValue=function(e,n,i,o){const u=this._normalizeType.call(this,n,i,o);const p=this.getBaseTypeForType(u);switch(p){case t.DateTime:return a.typeToISO(e,u,p);case t.Date:return a.typeToString(e,u,s);case t.Time:return a.typeToString(e,u,r);case t.Boolean:return e;case t.Numeric:if(typeof e!=="string"&&(u.getMetadata().getName()==="sap.ui.model.odata.type.Int64"||u.getMetadata().getName()==="sap.ui.model.odata.type.Decimal")){return e.toString()}return e;default:return u.formatValue(e,"string")}};u.internalizeValue=function(e,n,i,o){const u=this._normalizeType.call(this,n,i,o);const p=this.getBaseTypeForType(u);switch(p){case t.DateTime:return a.ISOToType(e,u,p);case t.Date:if(e.indexOf("T")>=0){e=e.substr(0,e.indexOf("T"))}return a.stringToType(e,u,s);case t.Time:return a.stringToType(e,u,r);case t.Boolean:return e;case t.Numeric:if(typeof e!=="string"&&(u.getMetadata().getName()==="sap.ui.model.odata.type.Int64"||u.getMetadata().getName()==="sap.ui.model.odata.type.Decimal")){return e.toString()}return e;default:return u.parseValue(e,"string")}};u._normalizeType=function(t,n,a){if(t instanceof e){return t}return this.getDataTypeInstance(t,n,a)};u.initializeTypeFromValue=function(t,e){return{}};u.initializeInternalType=function(t,e){};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/TypeUtil", ["sap/ui/mdc/enums/BaseType","sap/base/util/ObjectPath","sap/base/util/isEmptyObject","sap/base/util/merge","sap/ui/model/SimpleType","sap/ui/mdc/util/DateUtil"],function(e,t,a,n,s,r){"use strict";const i="yyyy-MM-dd";const o="HH:mm:ss";const u={getDataTypeClassName:function(e){const t={Boolean:"sap.ui.model.type.Boolean",Currency:"sap.ui.model.type.Currency",Date:"sap.ui.model.type.Date",DateTime:"sap.ui.model.type.DateTime",Float:"sap.ui.model.type.Float",Integer:"sap.ui.model.type.Integer",String:"sap.ui.model.type.String",Time:"sap.ui.model.type.Time",Unit:"sap.ui.model.type.Unit"};if(t[e]){e=t[e]}return e},getBaseType:function(t,a,n){switch(t){case"sap.ui.model.type.Date":return e.Date;case"sap.ui.model.type.DateTime":return e.DateTime;case"sap.ui.model.type.Time":return e.Time;case"sap.ui.model.type.Boolean":return e.Boolean;case"sap.ui.model.type.Unit":case"sap.ui.model.type.Currency":if(!a||(!a.hasOwnProperty("showMeasure")||a.showMeasure)&&(!a.hasOwnProperty("showNumber")||a.showNumber)){return e.Unit}else if(!a.hasOwnProperty("showNumber")||a.showNumber){return e.Numeric}else{return e.String}case"sap.ui.model.type.Integer":case"sap.ui.model.type.Float":return e.Numeric;default:return e.String}},getBaseTypeForType:function(e){return this.getBaseType(e.getMetadata&&e.getMetadata().getName(),e.getFormatOptions(),e.getConstraints())},getDataTypeClass:function(e){const a=this.getDataTypeClassName(e);const n=a?sap.ui.require(a.replace(/\./g,"/"))||t.get(a):undefined;if(!n){throw new Error("DataType '"+e+"' cannot be determined")}return n},getDataTypeInstance:function(e,t,a){const n=this.getDataTypeClass(e);return new n(t,a)},getTypeConfig:function(e,t,a){const n=this._normalizeType(e,t,a);return{className:n.getMetadata().getName(),typeInstance:n,baseType:this.getBaseTypeForType(n)}},internalizeValue:function(t,a,n,s){const u=this._normalizeType(a,n,s);const p=this.getBaseTypeForType(u);switch(p){case e.DateTime:return r.ISOToType(t,u,p);case e.Date:if(t.indexOf("T")>=0){t=t.substr(0,t.indexOf("T"))}return r.stringToType(t,u,i);case e.Time:return r.stringToType(t,u,o);case e.Boolean:return t;case e.Numeric:return t;default:return u.parseValue(t,"string")}},externalizeValue:function(t,a,n,s){const u=this._normalizeType(a,n,s);const p=this.getBaseTypeForType(u);switch(p){case e.DateTime:return r.typeToISO(t,u,p);case e.Date:return r.typeToString(t,u,i);case e.Time:return r.typeToString(t,u,o);case e.Boolean:return t;case e.Numeric:return t;default:return u.formatValue(t,"string")}},_normalizeType:function(e,t,a){if(e instanceof s){return e}return this.getDataTypeInstance(e,t,a)},getUnitTypeInstance:function(e,t,s){const r=e.getMetadata().getClass();const i=n({},e.getFormatOptions());const o=a(e.getConstraints())?undefined:n({},e.getConstraints());this._adjustUnitFormatOptions(i,t,s);return new r(i,o)},_adjustUnitFormatOptions:function(e,t,a){e.showNumber=t;e.showMeasure=a;e.strictParsing=true},initializeTypeFromValue:function(e,t){return{}},initializeInternalType:function(e,t){}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/loadModules", ["sap/ui/base/SyncPromise","sap/base/assert"],function(r,e){"use strict";return function n(t){e(typeof t==="string"||Array.isArray(t),"vModulePaths"+" param either must be a single string or an array of strings. - sap.ui.mdc.util.loadModules");let s;if(typeof t==="string"){s=[t]}else{s=t}const i=new Map;s.forEach(function(r){const e=sap.ui.require(r);i.set(r,e)});const a=s.filter(function(r){return i.get(r)===undefined});if(a.length===0){const e=Array.from(i.values());return r.resolve(e)}return new r(function(r,e){function n(){const e=Array.from(arguments);a.forEach(function(r,n){i.set(r,e[n])});const n=Array.from(i.values());r(n)}sap.ui.require(a,n,e)})}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/Dialog", ["sap/ui/mdc/valuehelp/base/Container","sap/ui/mdc/valuehelp/base/DialogTab","sap/ui/mdc/util/loadModules","sap/ui/Device","sap/m/VBox","sap/m/FlexItemData","sap/ui/model/resource/ResourceModel","sap/ui/mdc/util/Common","sap/ui/mdc/enums/ValueHelpSelectionType","sap/base/strings/formatMessage","sap/ui/core/library","sap/ui/core/InvisibleMessage","sap/ui/mdc/util/DensityHelper"],function(e,t,n,o,i,s,l,a,r,c,u,p,d){"use strict";let h=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");sap.ui.getCore().attachLocalizationChanged(function(){h=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc")});let g,f,C,y,m,b;let _,T,I,S,v;const M=u.InvisibleMessageMode;const k=e.extend("sap.ui.mdc.valuehelp.Dialog",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.IDialogContainer","sap.ui.core.PopupInterface"],properties:{_selectedContentKey:{type:"string",visibility:"hidden"},_quickSelectEnabled:{type:"boolean",visibility:"hidden",defaultValue:false},_selectableContents:{type:"object[]",visibility:"hidden",defaultValue:[]},groupConfig:{type:"object",defaultValue:{}}},defaultAggregation:"content"}});function P(){if(o.system.desktop){return"700px"}if(o.system.tablet){return o.orientation.landscape?"600px":"600px"}}function B(){if(o.system.desktop){return"1080px"}if(o.system.tablet){return o.orientation.landscape?"920px":"600px"}}function x(e){const t=this.getContent();return t.filter(function(t){return!!t.getVisible()&&t.getGroup&&t.getGroup()===e}).length>1}k.prototype._handleContentSelectionChange=function(e){this.fireRequestDelegateContent({container:this.getId(),contentId:e});return this.getRetrieveDelegateContentPromise().then(function(){const t=this.getProperty("_selectedContentKey");const n=this.getContent();const o=t&&n&&n.find(function(e){return e.getId()===t});if(o){if(o.setCollectiveSearchSelect){o.setCollectiveSearchSelect(undefined)}o.onHide();this.unbindContentFromContainer(o)}return this._renderSelectedContent(e)}.bind(this))};k.prototype._onTabBarSelect=function(e){const t=e&&e.getParameter("key");this._handleContentSelectionChange(t)};k.prototype.invalidate=function(t){if(t){const n=this.getContent();const o=n.indexOf(t);if(this._oIconTabBar&&o!==-1&&!this.isDestroyStarted()){const e=this._oIconTabBar.getItems();if(e[o]){e[o].invalidate(t)}}else{e.prototype.invalidate.apply(this,arguments)}}};k.prototype.getUIAreaForContent=function(){const t=this.getAggregation("_container");if(t){return t.getUIArea()}return e.prototype.getUIAreaForContent.apply(this,arguments)};k.prototype.handleConfirmed=function(e){this.fireConfirm({close:true})};k.prototype.handleClosed=function(t){const n=this.getSelectedContent();if(n){n.onHide()}this.getContent().forEach(function(e){e.onContainerClose()});this.setProperty("_selectedContentKey",this._sInitialContentKey);e.prototype.handleClosed.apply(this,arguments)};k.prototype.getContainerControl=function(){if(!this.getModel("$i18n")){this.setModel(new l({bundleName:"sap/ui/mdc/messagebundle",async:false}),"$i18n")}const e=this.getAggregation("_container");if(!e){return this._retrievePromise("dialog",function(){return n(["sap/m/Dialog","sap/m/Button","sap/ui/model/base/ManagedObjectModel","sap/m/library"]).then(function(e){g=e[0];C=e[1];y=e[2];f=e[3];const t=f.ButtonType;if(!this._oResourceBundle){this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc")}this.oButtonOK=new C(this.getId()+"-ok",{text:this._oResourceBundle.getText("valuehelp.OK"),enabled:"{$valueHelp>/_valid}",type:t.Emphasized,press:this.handleConfirmed.bind(this),visible:{parts:["$valueHelp>/_config/maxConditions","$help>/_quickSelectEnabled"],formatter:function(e,t){return e!==1||!t}}});this.oButtonCancel=new C(this.getId()+"-cancel",{text:this._oResourceBundle.getText("valuehelp.CANCEL"),press:this.handleCanceled.bind(this)});this._oManagedObjectModel=new y(this);const n=new g(this.getId()+"-dialog",{contentHeight:P(),contentWidth:B(),horizontalScrolling:false,verticalScrolling:false,title:{parts:["$help>/title","$help>/_selectableContents"],formatter:function(e,t){if(t&&t.length==1){const n=t[0];const o=n.getFormattedShortTitle()?n.getFormattedShortTitle():n.getTitle();if(o){e=this._oResourceBundle.getText("valuehelp.DIALOGSHORTTITLECOLONTITLE",[o,e])}}return e}.bind(this)},stretch:o.system.phone,resizable:true,draggable:true,afterOpen:this.handleOpened.bind(this),afterClose:this.handleClosed.bind(this),buttons:[this.oButtonOK,this.oButtonCancel]});d.syncDensity(n);n.setModel(this._oManagedObjectModel,"$help");this.setAggregation("_container",n,true);n.isPopupAdaptationAllowed=function(){return false};n.addStyleClass("sapMdcValueHelp");n.addStyleClass("sapMdcValueHelpTitle");const s=new i(this.getId()+"-Content",{fitContainer:true});s.addStyleClass("sapMdcValueHelpPanel");n.addContent(s);return n}.bind(this))}.bind(this))}return e};k.prototype.placeContent=function(e){const n=e.getContent()[0];const o=this.getProperty("_selectableContents");if(!o.length){return Promise.resolve(e)}const i=o.length>1;const l=[];if(i){l.push(this._getIconTabBar(e))}else{if(!this._oStandaloneTab){this._oStandaloneTab=new t(this.getId()+"-Standalone-DT",{content:{path:"/_selectableContents/0/displayContent",model:"$help"},layoutData:new s({growFactor:1,minHeight:"0"})})}l.push(this._oStandaloneTab)}if(E(this.getMaxConditions(),this.getContent())){l.push(this._getTokenizerPanel())}return Promise.all(l).then(function(t){n.removeAllItems();t.forEach(function(e){n.addItem(e)});if(i){e.addStyleClass("sapMdcValueHelpTitleShadow")}else{e.removeStyleClass("sapMdcValueHelpTitleShadow")}return e})};k.prototype.handleSelect=function(t){e.prototype.handleSelect.apply(this,arguments);if(this.getProperty("_quickSelectEnabled")&&this.isSingleSelect()){const e=t.getParameter("conditions");const n=[r.Set,r.Add].indexOf(t.getParameter("type"))!==-1;const o=e&&e.length;if(n&&o){this.fireConfirm({close:true})}}};k.prototype.observeChanges=function(t){if(t.name==="content"){const e=this.getContent();this.setProperty("_quickSelectEnabled",e&&e.every(function(e){return e.isQuickSelectSupported()}));this._updateInitialContentKey();if(t.mutation==="insert"&&!this.getProperty("_selectedContentKey")){this.setProperty("_selectedContentKey",this._sInitialContentKey)}this.setProperty("_selectableContents",this._getSelectableContents());if(E(this.getMaxConditions(),this.getContent())){const e=this.getAggregation("_container");if(e&&e.getContent()[0].getItems().length===1){Promise.all([this._getTokenizerPanel()]).then(function(t){t.forEach(function(t){e.getContent()[0].addItem(t)})})}}}e.prototype.observeChanges.apply(this,arguments)};k.prototype._updateInitialContentKey=function(){const e=this.getContent().find(function(e){return!!e.getVisible()});this._sInitialContentKey=e&&e.getId()};k.prototype.getSelectedContent=function(){const e=this.getProperty("_selectedContentKey");return this.getContent().find(function(t){return t.getId()===e})};k.prototype._getSelectableContents=function(){const e=this.getSelectedContent();const t=e&&e.getGroup&&e.getGroup();const n=e?t:"";const o=[n];return this.getContent().filter(function(t){if(!t.getVisible()){return false}const n=t.getGroup&&t.getGroup();const i=n&&x.call(this,n);if(i&&t!==e){if(o.indexOf(n)>=0){return false}else{o.push(n)}}return true}.bind(this))};k.prototype._updateGroupSelectModel=function(){if(this._oGroupSelectModel){const e=this.getSelectedContent();const t=e&&e.getGroup&&e.getGroup();const n=t?this.getContent().filter(function(e){return!!e.getVisible()&&e.getGroup&&e.getGroup()===t}):[];this._oGroupSelectModel.setData(n.reduce(function(e,t){e.entries.push({key:t.getId(),text:t.getFormattedTitle()});return e},{entries:[]}));if(this._oGroupSelect){const e=this._oGroupSelect.getSelectedItemKey();const t=n.map(function(e){return e.getId()});const o=this.getProperty("_selectedContentKey");if(t.indexOf(e)==-1||e!==o){this._oGroupSelect.setSelectedItemKey(n[0].getId())}}}};k.prototype._retrieveGroupSelect=function(){return this._retrievePromise("collectiveSearchSelect",function(){return n(["sap/ui/mdc/filterbar/vh/CollectiveSearchSelect","sap/m/VariantItem","sap/ui/model/json/JSONModel"]).then(function(e){const t=e[0];const n=e[1];const i=e[2];if(!this._oGroupSelectModel){this._oGroupSelectModel=new i}if(!this._oGroupSelect){const e=new n(this.getId()+"-collSearchItem",{key:"{$select>key}",text:"{$select>text}"});this._oGroupSelect=new t(this.getId()+"--Select",{title:"{$i18n>COL_SEARCH_SEL_TITLE}",items:{path:"$select>/entries",template:e},select:function(e){this._handleContentSelectionChange(e.getParameter("key"))}.bind(this),selectedItemKey:this.getSelectedContent().getId(),maxWidth:o.system.phone?"5em":"25rem"});this._oGroupSelect.setModel(this._oGroupSelectModel,"$select")}return this._oGroupSelect}.bind(this))}.bind(this))};k.prototype._getIconTabBar=function(){if(!this._oIconTabBar){return this._retrievePromise("IconTabBar",function(){return n(["sap/m/IconTabBar","sap/m/IconTabFilter"]).then(function(e){m=e[0];b=e[1];const n=f.IconTabHeaderMode;this._oIconTabBar=new m(this.getId()+"-ITB",{expandable:false,upperCase:false,stretchContentHeight:true,headerMode:n.Inline,select:this._onTabBarSelect.bind(this),layoutData:new s({growFactor:1}),selectedKey:"{path: '$help>/_selectedContentKey', mode: 'OneWay'}"});this._oIconTabBar.addStyleClass("sapUiNoContentPadding");const o=new b(this.getId()+"-ITF",{key:{path:"$help>id"},content:new t(this.getId()+"-DT",{content:{path:"$help>displayContent"}}),text:{parts:["$help>","$valueHelp>/conditions"],formatter:function(e,t){let n="none";if(e){const o=e.getGroup&&e.getGroup();const i=e.getCount(t,o);n=o?this._getFormattedContentGroupLabel(o,i):e.getFormattedTitle(i)}return n}.bind(this)}});this._oIconTabBar.bindAggregation("items",{path:"/_selectableContents",model:"$help",templateShareable:false,template:o});return this._oIconTabBar}.bind(this))}.bind(this))}return this._oIconTabBar};k.prototype._getFormattedContentGroupLabel=function(e,t){const n=this.getGroupConfig();const o=n&&n[e];let i=o&&(t?o.label:o.nnLabel);i=i&&c(i,t?t:"");i=i||this._oResourceBundle.getText(t?"valuehelp.SELECTFROMLIST":"valuehelp.SELECTFROMLISTNONUMBER",[t]);return i};k.prototype._getTokenizerPanel=function(e){if(!this.oTokenizerPanel){return this._retrievePromise("TokenizerPanel",function(){return n(["sap/m/Panel","sap/m/HBox","sap/m/VBox","sap/ui/mdc/field/FieldMultiInput","sap/m/Token","sap/ui/model/Filter","sap/ui/mdc/field/ConditionType"]).then(function(e){_=e[0];T=e[1];i=e[2];I=e[3];S=e[4];v=e[5];const t=e[6];const n=f.BackgroundDesign;const o=f.ButtonType;this.oTokenizerPanel=new _(this.getId()+"-TokenPanel",{backgroundDesign:n.Transparent,expanded:true,visible:{parts:["$valueHelp>/_config/maxConditions","$help>/content"],formatter:E},headerText:{parts:["$valueHelp>/conditions","$help>/_selectableContents"],formatter:function(e,t){let n=0;for(let t=0;t<e.length;t++){const o=e[t];if(o.isEmpty!==true){n++}}let o;if(t&&t.length==1){o=t[0].getFormattedTokenizerTitle(n);return o}else{o=this._oResourceBundle.getText("valuehelp.TOKENIZERTITLE");if(n===0){o=this._oResourceBundle.getText("valuehelp.TOKENIZERTITLENONUMBER")}return c(o,n)}}.bind(this)}});this.oTokenizerPanel.addStyleClass("sapMdcTokenizerPanel");const l=new T(this.getId()+"-TokenBox",{fitContainer:true,width:"100%"});const a=w.call(this);this._oConditionType=new t(a);this._oConditionType._bVHTokenizer=true;this.oTokenMultiInput=new I(this.getId()+"-Tokenizer",{width:"100%",showValueHelp:false,editable:true,ariaAttributes:{role:"listbox",aria:{readonly:true,roledescription:this._oResourceBundle.getText("valuehelp.TOKENIZER_ARIA_ROLE_DESCRIPTION")}},ariaLabelledBy:this.oTokenizerPanel,tokenUpdate:function(e){if(e.getParameter("removedTokens")){const t=e.getParameter("removedTokens");const n=this.getModel("$valueHelp").getObject("/conditions");const o=[];t.forEach(function(e,t){const i=e.getBindingContext("$valueHelp").sPath;const s=parseInt(i.slice(i.lastIndexOf("/")+1));o.push(n[s])});this.fireSelect({type:r.Remove,conditions:o})}}.bind(this),layoutData:new s({growFactor:1,maxWidth:"calc(100% - 2rem)"})});this.oTokenMultiInput._setValueVisible=function(e){this.$("inner").css("opacity","0")};const u=this.oTokenMultiInput.onAfterRendering;this.oTokenMultiInput.onAfterRendering=function(){u.apply(this.oTokenMultiInput,arguments);this.oTokenMultiInput._setValueVisible();this.oTokenMultiInput.setValue("")}.bind(this);O.call(this,true);this.oRemoveAllBtn=new C(this.getId()+"-TokenRemoveAll",{press:function(e){this.fireSelect({type:r.Set,conditions:[]});this.oInvisibleMessage.announce(h.getText("valuehelp.REMOVEALLTOKEN_ANNOUNCE"),M.Assertive)}.bind(this),type:o.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.REMOVEALLTOKEN}",layoutData:new s({growFactor:0,baseSize:"2rem"})});this.oRemoveAllBtn.addStyleClass("sapUiTinyMarginBegin");l.addItem(this.oTokenMultiInput);l.addItem(this.oRemoveAllBtn);this.oTokenizerPanel.addContent(l);return this.oTokenizerPanel}.bind(this))}.bind(this))}else{const e=w.call(this);this._oConditionType.setFormatOptions(e)}return this.oTokenizerPanel};function E(e,t){let n=e!==1;if(n&&t&&t.every(function(e){return!e.getRequiresTokenizer()})){n=false}return n}function w(){const e=this.getModel("$valueHelp");const t=e?e.getProperty("/_config"):{};const n=this.getParent();const o=this.getControl();return{maxConditions:-1,valueType:t.dataType,additionalValueType:t.additionalDataType,operators:t.operators,display:t.display,valueHelpID:n&&n.getId(),control:o,delegate:o&&o.getControlDelegate&&o.getControlDelegate(),delegateName:o&&o.getDelegate&&o.getDelegate()&&o.getDelegate().name,payload:o&&o.getPayload&&o.getPayload(),convertWhitespaces:true}}function O(e){if(this.oTokenMultiInput){const t=this.oTokenMultiInput.getBindingInfo("tokens");if(e){if(!t){const e=new v({path:"isEmpty",operator:"NE",value1:true});this._oConditionType.setFormatOptions(w.call(this));const t=new S(this.getId()+"-Token",{text:{path:"$valueHelp>",type:this._oConditionType}});this.oTokenMultiInput.bindAggregation("tokens",{path:"/conditions",model:"$valueHelp",templateShareable:false,template:t,filters:e})}}else if(t){this.oTokenMultiInput.unbindAggregation("tokens")}}}k.prototype.openContainer=function(e){this._mAlreadyShownContents={};if(e){this._updateInitialContentKey();const t=function(){this._renderSelectedContent(this._sInitialContentKey,function(){const t=this.getContent().find(function(e){return e.getId()===this.getProperty("_selectedContentKey")}.bind(this));const n=t.getInitialFocusedControl();if(n){e.setInitialFocus(n)}e.open();this.getContent().forEach(function(e){e.onContainerOpen()})}.bind(this))}.bind(this);if(E(this.getMaxConditions(),this.getContent())&&e.getContent()[0].getItems().length===1){Promise.all([this._getTokenizerPanel()]).then(function(n){n.forEach(function(t){e.getContent()[0].addItem(t)});t()})}else{if(this.oTokenMultiInput){O.call(this,true)}t()}}};k.prototype._renderSelectedContent=function(e,t){const n=this.getContent().find(function(t){return t.getId()===e});if(!n){throw new Error("sap.ui.mdc.ValueHelp: No content found.")}const o=[n.getContent()];const i=n.getGroup&&n.getGroup();let s;if(i&&x.call(this,i)){s=this._retrieveGroupSelect();o.push(s)}const l=!this._mAlreadyShownContents[e];return Promise.all(o).then(function(){this.bindContentToContainer(n)}.bind(this)).then(function(){return Promise.resolve(n.onBeforeShow(l))}).then(function(){this._mAlreadyShownContents[e]=true;this.setProperty("_selectedContentKey",e);this.setProperty("_selectableContents",this._getSelectableContents());this._oManagedObjectModel.checkUpdate(true,false,function(e){if(e.getPath().indexOf("displayContent")>=0){return true}});if(s){this._updateGroupSelectModel()}if(n.setCollectiveSearchSelect){n.setCollectiveSearchSelect(s?this._oGroupSelect:undefined)}if(t){t()}return this._retrievePromise("open").then(function(){return n.onShow(l).then(()=>n)})}.bind(this))};k.prototype.closeContainer=function(){const e=this.getAggregation("_container");if(e){e.close();if(this.oTokenMultiInput){O.call(this,false)}}};k.prototype.getValueHelpIcon=function(){return"sap-icon://value-help"};k.prototype.getAriaAttributes=function(e){return{contentId:null,ariaHasPopup:"dialog",role:null,roleDescription:null,valueHelpEnabled:true,autocomplete:"none"}};k.prototype.isMultiSelect=function(){return this.getMaxConditions()!==1};k.prototype.init=function(){e.prototype.init.apply(this,arguments);this.oInvisibleMessage=p.getInstance()};k.prototype.exit=function(){a.cleanup(this,["_oManagedObjectModel","_oResourceBundle","oButtonOK","oButtonCancel","oTokenizerPanel","oTokenMultiInput","_oIconTabBar","_oGroupSelect","_oGroupSelectModel","_sInitialContentKey","_mAlreadyShownContents","oInvisibleMessage","_oStandaloneTab"]);e.prototype.exit.apply(this,arguments)};return k});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/Popover", ["sap/ui/mdc/valuehelp/base/Container","sap/ui/mdc/util/loadModules","sap/ui/thirdparty/jquery","sap/ui/core/library"],function(t,e,jQuery,n){"use strict";let o,i,s,r,a,l;const p=n.ValueState;const u=t.extend("sap.ui.mdc.valuehelp.Popover",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.ITypeaheadContainer","sap.ui.mdc.valuehelp.IDialogContainer","sap.ui.core.PopupInterface"],properties:{opensOnClick:{type:"boolean",defaultValue:false},opensOnFocus:{type:"boolean",defaultValue:false}},defaultAggregation:"content"}});u.prototype.invalidate=function(e){if(e){const n=this.getAggregation("_container");const o=this._oCurrentContent;if(n&&o&&e===o&&!this.isDestroyStarted()){n.invalidate(e)}else{t.prototype.invalidate.apply(this,arguments)}}};u.prototype.getUIAreaForContent=function(){const e=this.getAggregation("_container");if(e){return e.getUIArea()}return t.prototype.getUIAreaForContent.apply(this,arguments)};u.prototype._getContent=function(){const t=this.getContent();return t&&t[0]};u.prototype.getContainerControl=function(){let t=this.getAggregation("_container");const n=function(t,e){if(t&&t.getValueState&&t.getValueState()!==p.None){e.setText(t.getValueStateText());e.setValueState(t.getValueState());e.setVisible(true)}else{e.setVisible(false)}};if(!t){return e(["sap/m/Popover","sap/m/library","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/ValueStateHeader","sap/ui/core/InvisibleText"]).then(function(e){o=e[0];i=e[1];s=e[2];r=e[3];a=e[4];l=e[5];const p=new a;n(this.getControl(),p);t=new o(this.getId()+"-pop",{contentHeight:"auto",placement:i.PlacementType.VerticalPreferredBottom,showHeader:false,showArrow:false,title:this.getTitle(),titleAlignment:i.TitleAlignment.Center,afterOpen:this.handleOpened.bind(this),afterClose:this.handleClosed.bind(this),customHeader:p}).addStyleClass("sapMdcValueHelpPopover").addStyleClass("sapMComboBoxBasePicker").addStyleClass("sapMComboBoxBasePicker-CTX");this._oInvisibleText=new l({text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("valuehelp.POPOVER_AVALIABLE_VALUES")}).toStatic();t.addAriaLabelledBy(this._oInvisibleText);if(p){p.setPopup(t)}t.isPopupAdaptationAllowed=function(){return false};t.addStyleClass(this.isSingleSelect()?"sapMdcValueHelpSingleSelect":"sapMdcValueHelpMultiSelect");t.addDelegate({onsapshow:this.handleRequestSwitchToDialog.bind(this)});t._getAllContent=function(){const t=this.getParent();const e=[];if(t){if(this._oCurrentContent){e.push(this._oCurrentContent)}}return e}.bind(this);const u=this._getContent();const c=this.getContainerConfig(u);if(c){t.setShowArrow(!!c.showArrow);t.setShowHeader(!!c.showHeader);t.setResizable(!!c.resizable);if(c.getContentWidth){t.setContentWidth(c.getContentWidth())}}this.setAggregation("_container",t,true);return t}.bind(this))}n(this.getControl(),t.getCustomHeader());return t};u.prototype.providesScrolling=function(){return true};u.prototype.observeChanges=function(e){if(e.name==="content"){const t=e.child;if(e.mutation==="remove"){t.detachNavigated(this.handleNavigated,this)}}t.prototype.observeChanges.apply(this,arguments)};u.prototype.placeContent=function(t){const e=this._getContent();const n=e&&e.getContent();const o=this.getContainerConfig(e);const i=o&&o.getFooter&&o.getFooter();return Promise.all([n,i]).then(function(e){this._oCurrentContent=e[0];const n=e[1];if(n&&t.getFooter()!=n&&n.isA&&n.isA("sap.m.Toolbar")){t.setFooter(n);return t}if(n){if(!t.getFooter()){const e=[new r(this.getId()+"-Spacer")].concat(n);const o=new s(this.getId()+"-TB",{content:e}).setModel(this._oManagedObjectModel,"$help");t.setFooter(o)}else{}}else if(t.getFooter()){t.setFooter()}return t}.bind(this))};u.prototype.openContainer=function(e,n){if(e.isOpen()){return}t.prototype.openContainer.apply(this,arguments);const o=this._getContent();const i=this._retrievePromise("open");Promise.resolve(o&&o.onBeforeShow(true)).then(function(){const t=this.getValueHelpDelegate();const e=this.getValueHelp();return Promise.resolve(n?t.showTypeahead(e,o):true).then(function(t){return t&&!i.isCanceled()?true:Promise.reject()})}.bind(this)).then(function(){this._openContainerByTarget(e)}.bind(this)).catch(function(t){const e=this._retrievePromise("open");const n=i===e;if(n){this._cancelPromise(i);if(t&&t instanceof Error){throw t}}}.bind(this))};u.prototype._openContainerByTarget=function(t){const e=this.getControl();const n=e&&e.getFocusElementForValueHelp?e.getFocusElementForValueHelp(this.isTypeahead()):e;if(n&&n.getDomRef()){t.setContentMinWidth(jQuery(n.getDomRef()).outerWidth()+"px");if(!this.isFocusInHelp()){t.setInitialFocus(n)}t.openBy(n)}};u.prototype.closeContainer=function(){t.prototype.closeContainer.apply(this,arguments);const e=this.getAggregation("_container");if(e){e.close()}};u.prototype.handleOpened=function(t){this._resolvePromise("open");const e=this._getContent();if(e){e.onContainerOpen();e.onShow(true).then(t=>{this.fireOpened({itemId:t})})}else{this.fireOpened({itemId:undefined})}};u.prototype.handleConfirmed=function(t){this.fireConfirm({close:t.getParameter("close")||this.isSingleSelect()})};u.prototype.handleClosed=function(e){const n=this._getContent();if(n){n.onHide();n.onContainerClose()}const o=this.getAggregation("_container");if(o){o._oPreviousFocus=null}t.prototype.handleClosed.apply(this,arguments)};u.prototype.removeFocus=function(){const t=this._getContent();if(t){t.removeFocus()}};u.prototype.navigateInContent=function(t){const e=this._getContent();if(e){e.navigate(t)}};u.prototype.getItemForValue=function(t){const e=this._getContent();if(e){return e.getItemForValue(t)}};u.prototype.isValidationSupported=function(t){const e=this._getContent();if(e){return e.isValidationSupported()}};u.prototype.getUseAsValueHelp=function(){const t=this._getContent();return t&&t.getUseAsValueHelp&&t.getUseAsValueHelp()};u.prototype.getValueHelpIcon=function(){const t=this._getContent();return t&&t.getValueHelpIcon()};u.prototype.getAriaAttributes=function(e){const n=this._getContent();const o=n&&n.getAriaAttributes(e);if(o){return{contentId:o.contentId,ariaHasPopup:o.ariaHasPopup,role:this.isDialog()?"combobox":null,roleDescription:o.roleDescription,valueHelpEnabled:o.valueHelpEnabled,autocomplete:o.autocomplete}}return t.prototype.getAriaAttributes.apply(this,arguments)};u.prototype.shouldOpenOnFocus=function(){return this.getOpensOnFocus()};u.prototype.shouldOpenOnClick=function(){const t=this._getContent();return this.isPropertyInitial("opensOnClick")?!!t&&t.shouldOpenOnClick():this.getOpensOnClick()};u.prototype.shouldOpenOnNavigate=function(){const t=this._getContent();this.bindContentToContainer(t);return!!t&&t.shouldOpenOnNavigate()};u.prototype.isNavigationEnabled=function(t){if(this.isOpen()||this.getUseAsValueHelp()){const e=this._getContent();return!!e&&e.isNavigationEnabled(t)}return false};u.prototype.isFocusInHelp=function(){const t=this._getContent();return!!t&&t.isFocusInHelp()};u.prototype.isMultiSelect=function(){const t=this._getContent();return!!t&&t.isMultiSelect()};u.prototype.isTypeaheadSupported=function(){const t=this._getContent();return t&&t.isSearchSupported()};u.prototype.exit=function(){if(this._oCurrentContent){if(!this._oCurrentContent.isDestroyed()){this._oCurrentContent.destroy()}this._oCurrentContent=null}if(this._oInvisibleText){this._oInvisibleText.destroy();delete this._oInvisibleText}t.prototype.exit.apply(this,arguments)};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/base/Container", ["sap/ui/core/Element","sap/ui/mdc/mixin/PromiseMixin","sap/ui/model/BindingMode","sap/ui/base/ManagedObjectObserver"],function(t,e,n,o){"use strict";const i=t.extend("sap.ui.mdc.valuehelp.base.Container",{metadata:{library:"sap.ui.mdc",properties:{title:{type:"string",group:"Appearance",defaultValue:""},localFilterValue:{type:"string"}},aggregations:{_container:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},content:{type:"sap.ui.mdc.valuehelp.base.Content",multiple:true}},events:{select:{parameters:{type:{type:"sap.ui.mdc.enums.ValueHelpSelectionType"},conditions:{type:"object[]"}}},confirm:{parameters:{close:{type:"boolean"}}},opened:{parameters:{itemId:{type:"string"}}},closed:{},cancel:{},requestDelegateContent:{parameters:{contentId:{type:"string"}}},requestSwitchToDialog:{},navigated:{parameters:{leaveFocus:{type:"boolean"},condition:{type:"object"},itemId:{type:"string"}}},typeaheadSuggested:{parameters:{condition:{type:"object"},filterValue:{type:"string"},itemId:{type:"string"}}}}}});i.prototype.init=function(){this._oObserver=new o(this.observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["content"]})};i.prototype.observeChanges=function(t){if(t.name==="content"){const e=t.child;if(t.mutation==="remove"){this.unbindContentFromContainer(e)}}};i.prototype.bindContentToContainer=function(t){if(t&&!t._bContentBound){t.attachConfirm(this.handleConfirmed,this);t.attachCancel(this.handleCanceled,this);t.attachSelect(this.handleSelect,this);if(t.attachNavigated){t.attachNavigated(this.handleNavigated,this)}if(t.attachTypeaheadSuggested){t.attachTypeaheadSuggested(this.handleTypeaheadSuggested,this)}if(t.attachRequestSwitchToDialog){t.attachRequestSwitchToDialog(this.handleRequestSwitchToDialog,this)}t.bindProperty("filterValue",{path:"/filterValue",model:"$valueHelp",mode:n.OneWay});const e={path:"/conditions",model:"$valueHelp",mode:n.OneWay};if(t._formatConditions){e.formatter=t._formatConditions.bind(t)}t.bindProperty("config",{path:"/_config",model:"$valueHelp",mode:n.OneWay});t.bindProperty("conditions",e);t._bContentBound=true}};i.prototype.unbindContentFromContainer=function(t){if(t._bContentBound){t.unbindProperty("filterValue",true);t.unbindProperty("config",true);t.unbindProperty("conditions",true);t.detachConfirm(this.handleConfirmed,this);t.detachCancel(this.handleCanceled,this);t.detachSelect(this.handleSelect,this);if(t.detachNavigated){t.detachNavigated(this.handleNavigated,this)}if(t.detachTypeaheadSuggested){t.detachTypeaheadSuggested(this.handleTypeaheadSuggested,this)}if(t.detachRequestSwitchToDialog){t.detachRequestSwitchToDialog(this.handleRequestSwitchToDialog,this)}t._bContentBound=false}};i.prototype.handleNavigated=function(t){this.fireNavigated(t.mParameters)};i.prototype.handleTypeaheadSuggested=function(t){this.fireTypeaheadSuggested(t.mParameters)};i.prototype.handleRequestSwitchToDialog=function(t){this.fireRequestSwitchToDialog({container:this})};i.prototype.getContainerControl=function(){};i.prototype.getControl=function(){const t=this.getParent();return t&&t.getControl()};i.prototype.getMaxConditions=function(){const t=this.getModel("$valueHelp");return t&&t.getObject("/_config/maxConditions")};i.prototype.isSingleSelect=function(){return this.getMaxConditions()===1};i.prototype.getDomRef=function(){const t=this.getAggregation("_container");return t&&t.getDomRef()};i.prototype.getUIArea=function(){return null};i.prototype.getUIAreaForContent=function(){return this.getUIArea()};i.prototype.open=function(t,e){if(!this.isOpening()){const n=this._addPromise("open");return Promise.all([this.getContainerControl(),t]).then(function(t){return this.placeContent(t[0])}.bind(this)).then(function(t){if(!n.isCanceled()){this.openContainer(t,e)}return n}.bind(this))}return this._retrievePromise("open")};i.prototype.close=function(){const t=this._retrievePromise("open");if(t){if(t.isSettled()){this.closeContainer()}else{this._cancelPromise(t)}}};i.prototype.placeContent=function(t){return t};i.prototype.openContainer=function(t,e){const n=this.getContent();for(let t=0;t<n.length;t++){this.bindContentToContainer(n[t])}};i.prototype.closeContainer=function(){};i.prototype.handleOpened=function(t){this._resolvePromise("open");this.fireOpened()};i.prototype.handleClosed=function(t){this._removePromise("open");const e=this.getContent();for(let t=0;t<e.length;t++){this.unbindContentFromContainer(e[t])}this.fireClosed()};i.prototype.handleConfirmed=function(t){this.fireConfirm()};i.prototype.handleCanceled=function(t){this.fireCancel()};i.prototype.handleSelect=function(t){this.fireSelect({type:t.getParameter("type"),conditions:t.getParameter("conditions")})};i.prototype.isOpen=function(){const t=this._retrievePromise("open");return t&&t.isSettled()};i.prototype.isOpening=function(){const t=this._retrievePromise("open");return t&&!t.isCanceled()&&!t.isSettled()};i.prototype.getItemForValue=function(t){return undefined};i.prototype.isValidationSupported=function(){return false};i.prototype.navigate=function(t){return Promise.all([this.getContainerControl()]).then(function(t){return this.placeContent(t[0])}.bind(this)).then(function(e){this.navigateInContent(t)}.bind(this))};i.prototype.navigateInContent=function(t){};i.prototype.removeFocus=function(){};i.prototype.isTypeahead=function(){const t=this.getParent();return t&&t.getTypeahead()===this};i.prototype.isTypeaheadSupported=function(){return false};i.prototype.isDialog=function(){const t=this.getParent();return t&&(t.getDialog()===this||this.isTypeahead()&&!t.getDialog()&&this.getUseAsValueHelp())};i.prototype.hasDialog=function(){const t=this.getParent();return!!(t&&t.getDialog())};i.prototype.providesScrolling=function(){return false};i.prototype.getValueHelp=function(){const t=this.getParent();return t};i.prototype.getValueHelpDelegate=function(){const t=this.getParent();return t&&t.getControlDelegate()};i.prototype.getValueHelpDelegatePayload=function(){const t=this.getParent();return t&&t.getPayload()};i.prototype.awaitValueHelpDelegate=function(){const t=this.getParent();return t&&t.awaitControlDelegate()};i.prototype.isValueHelpDelegateInitialized=function(){const t=this.getParent();return t&&t.bDelegateInitialized};i.prototype.getUseAsValueHelp=function(){return false};i.prototype.getValueHelpIcon=function(){};i.prototype.getAriaAttributes=function(t){return{contentId:null,ariaHasPopup:"listbox",role:"combobox",roleDescription:null,valueHelpEnabled:false,autocomplete:"none"}};i.prototype.getScrollDelegate=function(t){const e=this.getAggregation("_container");return e&&e.getScrollDelegate&&e.getScrollDelegate()};i.prototype.shouldOpenOnFocus=function(){return false};i.prototype.shouldOpenOnClick=function(){return false};i.prototype.shouldOpenOnNavigate=function(){return false};i.prototype.isNavigationEnabled=function(t){return false};i.prototype.isFocusInHelp=function(){return!this.isTypeahead()};i.prototype.isMultiSelect=function(){return false};i.prototype.getContainerConfig=function(t){const e=t&&t.getContainerConfig();let n=e&&e[this.getMetadata().getName()];if(!n&&e){const t=Object.keys(e);const o=t.find(function(t){return this.isA(t)}.bind(this));if(o){n=e[o]}}return n};i.prototype.getRetrieveDelegateContentPromise=function(){const t=this.getParent();return t&&t._retrievePromise("delegateContent")};i.prototype.getSelectedContent=function(){const t=this.getContent();return t&&t[0]};i.prototype.onConnectionChange=function(){const t=this.getContent();for(let e=0;e<t.length;e++){this.unbindContentFromContainer(t[e]);t[e].onConnectionChange()}};i.prototype.exit=function(){this._oObserver.disconnect();this._oObserver=undefined};e.call(i.prototype);return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/base/Content", ["sap/ui/core/Element","sap/ui/mdc/mixin/PromiseMixin","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorValueType","sap/base/strings/formatMessage"],function(e,t,n,o,i,r,p,a){"use strict";const s=e.extend("sap.ui.mdc.valuehelp.base.Content",{metadata:{library:"sap.ui.mdc",properties:{title:{type:"string",group:"Appearance",defaultValue:""},shortTitle:{type:"string",group:"Appearance",defaultValue:""},tokenizerTitle:{type:"string",group:"Appearance",defaultValue:""},conditions:{type:"object[]",defaultValue:[],byValue:true},filterValue:{type:"string",defaultValue:""},config:{type:"object",defaultValue:{}},visible:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{displayContent:{type:"sap.ui.core.Control",multiple:false}},events:{select:{parameters:{type:{type:"sap.ui.mdc.enums.ValueHelpSelectionType"},conditions:{type:"object[]"}}},confirm:{parameters:{close:{type:"boolean"}}},cancel:{},requestSwitchToDialog:{},navigated:{parameters:{leaveFocus:{type:"boolean"},condition:{type:"object"},itemId:{type:"string"}}},typeaheadSuggested:{parameters:{condition:{type:"object"},filterValue:{type:"string"},itemId:{type:"string"}}}}}});s.prototype.init=function(){this._oObserver=new n(this.observeChanges.bind(this));this._oObserver.observe(this,{properties:["filterValue","conditions","config"]});this._oOperator=i.getEQOperator()};s.prototype.exit=function(){this._oObserver.disconnect();this._oObserver=undefined};s.prototype.setProperty=function(t,n,o){if(t==="conditions"||t==="filterValue"||t==="config"){o=true}return e.prototype.setProperty.apply(this,[t,n,o])};s.prototype.getContent=function(){};s.prototype.getContainerConfig=function(){};s.prototype.onBeforeShow=function(e){};s.prototype.onShow=function(e){this._bVisible=true;this.handleConditionsUpdate();return Promise.resolve(null)};s.prototype.getInitialFocusedControl=function(){return null};s.prototype.onHide=function(){this._bVisible=false};s.prototype.getItemForValue=function(e){return undefined};s.prototype.isValidationSupported=function(){return false};s.prototype.getScrollDelegate=function(){const e=this.getParent();return e&&e.getScrollDelegate()};s.prototype.observeChanges=function(e){if(e.name==="conditions"){this.handleConditionsUpdate(e)}if(e.name==="filterValue"){this.handleFilterValueUpdate(e)}if(e.name==="config"){u.call(this,e.current)}};s.prototype.handleFilterValueUpdate=function(e){if(this.isContainerOpen()&&this.isTypeahead()){const e=this.getValueHelpDelegate();const t=this.getValueHelpInstance();Promise.resolve(!!e&&e.showTypeahead(t,this)).then(function(e){if(!e){this.fireCancel()}}.bind(this))}};s.prototype.handleConditionsUpdate=function(e){};s.prototype.createCondition=function(e,t,n){const i=c.call(this);const a=[e];if(i.valueTypes.length>1&&i.valueTypes[1]!==p.Static&&t!==null&&t!==undefined){a.push(t)}return o.createCondition(i.name,a,undefined,undefined,r.Validated,n)};s.prototype.removeFocus=function(){};s.prototype.navigate=function(e){};s.prototype.getUIArea=function(){const t=this.getParent();if(t&&t.getUIAreaForContent){return t.getUIAreaForContent()}return e.prototype.getUIArea.apply(this,arguments)};s.prototype.isTypeahead=function(){const e=this.getParent();return e&&e.isTypeahead()};s.prototype.isSearchSupported=function(){return false};s.prototype.provideScrolling=function(){const e=this.getParent();return!e||!e.providesScrolling()};s.prototype.isContainerOpen=function(){const e=this.getParent();return e&&e.isOpen()};s.prototype.isContainerOpening=function(){const e=this.getParent();return e&&e.isOpening()};s.prototype.getValueHelpDelegate=function(){const e=this.getParent();return e&&e.getValueHelpDelegate()};s.prototype.getValueHelpInstance=function(){const e=this.getParent();return e&&e.getValueHelp&&e.getValueHelp()};s.prototype.awaitValueHelpDelegate=function(){const e=this.getParent();return e&&e.awaitValueHelpDelegate()};s.prototype.isValueHelpDelegateInitialized=function(){const e=this.getParent();return e&&e.isValueHelpDelegateInitialized()};s.prototype.getControl=function(){const e=this.getParent();return e&&e.getControl()};s.prototype.getCount=function(e){return 0};s.prototype.getValueHelpIcon=function(){};s.prototype.getAriaAttributes=function(e){return{contentId:null,ariaHasPopup:"listbox",roleDescription:null,valueHelpEnabled:false,autocomplete:"none"}};s.prototype.isSingleSelect=function(){return this.getMaxConditions()===1};s.prototype.shouldOpenOnClick=function(){return false};s.prototype.shouldOpenOnNavigate=function(){return!this.isSingleSelect()};s.prototype.isNavigationEnabled=function(e){return false};s.prototype.isFocusInHelp=function(){return!this.isTypeahead()};s.prototype.isMultiSelect=function(){return!this.isSingleSelect()};s.prototype.isQuickSelectSupported=function(){return false};s.prototype.getRequiresTokenizer=function(){return true};function u(e){l.call(this,e.operators)}function l(e){this._oOperator=i.getEQOperator(e)}function c(){return this._oOperator}s.prototype.getFormattedTitle=function(e){let t=this.getTitle();if(t){t=a(t,e?e:"")}return t};s.prototype.getFormattedShortTitle=function(){return this.getShortTitle()};s.prototype.getFormattedTokenizerTitle=function(e){let t=this.getTokenizerTitle();if(t){t=a(t,e?e:"")}return t};s.prototype.getMaxConditions=function(){const e=this.getConfig();return e&&e.maxConditions};s.prototype.onContainerClose=function(){};s.prototype.onContainerOpen=function(){};s.prototype.onConnectionChange=function(){};t.call(s.prototype);return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/base/DefineConditionPanel", ["sap/ui/core/Control","sap/ui/base/ManagedObjectObserver","sap/base/util/merge","sap/base/util/deepEqual","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/field/ConditionsType","sap/ui/mdc/field/splitValue","sap/ui/mdc/enums/FieldEditMode","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/Field","sap/ui/mdc/ValueHelp","sap/ui/mdc/valuehelp/Popover","sap/ui/mdc/valuehelp/content/FixedList","sap/ui/mdc/valuehelp/content/FixedListItem","sap/ui/model/base/ManagedObjectModel","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/model/type/String","sap/ui/model/ParseException","sap/ui/core/library","sap/ui/core/InvisibleText","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/m/library","sap/m/Button","sap/m/Panel","sap/m/OverflowToolbar","sap/m/OverflowToolbarLayoutData","sap/m/ToolbarSpacer","sap/m/Text","sap/m/Title","sap/ui/core/IconPool","sap/ui/core/InvisibleMessage","sap/ui/thirdparty/jquery"],function(t,e,i,n,s,o,a,l,r,d,c,u,h,p,g,f,C,y,v,I,m,b,O,_,T,x,S,w,D,P,V,N,M,E,$,L,B,jQuery){"use strict";let A=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");let F=sap.ui.getCore().getLibraryResourceBundle("sap.m");sap.ui.getCore().attachLocalizationChanged(function(){A=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");F=sap.ui.getCore().getLibraryResourceBundle("sap.m")});const R=w.ButtonType;const H=_.ValueState;const U=_.InvisibleMessageMode;const j=_.TextAlign;const k=w.BackgroundDesign;const G=w.ToolbarDesign;const X=w.OverflowToolbarPriority;const K=t.extend("sap.ui.mdc.valuehelp.base.DefineConditionPanel",{metadata:{library:"sap.ui.mdc",properties:{conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true},config:{type:"object",defaultValue:{}},label:{type:"string",defaultValue:""},inputOK:{type:"boolean",defaultValue:true},_pagination:{type:"boolean",defaultValue:false,visibility:"hidden"}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{fieldHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false},valueHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false}},events:{conditionProcessed:{}}},_oManagedObjectModel:null,renderer:{apiVersion:2,render:function(t,e){t.openStart("section",e);t.class("sapUiMdcDefineConditionPanel");t.openEnd();t.renderControl(e.getAggregation("_content"));t.close("section")}},init:function(){sap.ui.getCore().getMessageManager().registerObject(this,true);t.prototype.init.apply(this,arguments);this.oInvisibleMessage=B.getInstance();this._oManagedObjectModel=new v(this);this._oObserver=new e(W.bind(this));this._oObserver.observe(this,{properties:["conditions","config"]});this._iStartIndex=0;this._iShownConditions=10;this._iShownAdditionalConditions=0;this._sOperatorHelpId=this.getId()+"--rowSelect-help";this._oContentEventDelegate={onpaste:this.onPaste};rt.call(this);this.setModel(this._oManagedObjectModel,"$this");this.setModel(this._oManagedObjectModel,"$condition")},exit:function(){sap.ui.getCore().getMessageManager().unregisterObject(this,true);this._oObserver.disconnect();this._oObserver=undefined;if(this._sConditionsTimer){clearTimeout(this._sConditionsTimer);this._sConditionsTimer=null}if(this._oDefaultType){this._oDefaultType.destroy();delete this._oDefaultType}this._oManagedObjectModel.destroy();delete this._oManagedObjectModel},byId:function(t){return sap.ui.getCore().byId(this.getId()+"--"+t)},onBeforeRendering:function(){if(!this.getModel("$i18n")){this.setModel(new m({bundleName:"sap/ui/mdc/messagebundle",async:false}),"$i18n")}if(this.getConditions().length===0&&!this._sConditionsTimer){this.updateDefineConditions()}},removeCondition:function(t){const e=t.oSource;const i=e.getBindingContext("$this");let n=this.getConditions();const s=i.getPath();const o=s.match(/^.*\/(\d+)\/$/);let a;if(o){a=parseInt(o[1])}if(a>0&&n.length-1===a){this._bFocusLastRemoveBtn=true}this.oInvisibleMessage.announce(A.getText("valuehelp.DEFINECONDITIONS_REMOVECONDITION_ANNOUNCE"),U.Assertive);const l=this.byId("conditions");const r=l.getContent();let d=-1;for(let t=0;t<r.length;t++){const e=r[t];if(e instanceof p&&e.getValueHelp()===this._sOperatorHelpId){d++}if(e instanceof p&&e.hasOwnProperty("_iValueIndex")&&e.getBindingContext("$this").getPath().startsWith(s)){if(e.isInvalidInput()){e.setValue(null)}}}if(n.length===1&&a===0){this.addDummyCondition(1);n=this.getConditions()}if(d===0&&this._iStartIndex>0){this._iStartIndex=this._iStartIndex-this._iShownConditions}n.splice(a,1);this.setProperty("conditions",n,true);Tt.call(this,undefined);this.fireConditionProcessed()},addCondition:function(t){const e=this.getConditions();const i=this.getConfig();const n=i.maxConditions;const s=this.byId("conditions");const o=s.getContent();let a=0;let l=-1;for(let t=0;t<o.length;t++){const e=o[t];if(e instanceof p&&e.getValueHelp()===this._sOperatorHelpId){a++;const t=e.getBindingContext("$this");const i=t.getPath();const n=i.match(/^.*\/(\d+)\/$/);if(n){l=parseInt(n[1])}}}if(n===-1||e.length<n){this.addDummyCondition(l+1);this._bFocusLastCondition=true;if(a>=this._iShownConditions){this._iShownAdditionalConditions++}}this.oInvisibleMessage.announce(A.getText("valuehelp.DEFINECONDITIONS_ADDCONDITION_ANNOUNCE"),U.Assertive)},addDummyCondition:function(t){const e=tt.call(this);const i=Z.call(this);const n=i.name;const a=s.createCondition(n,i.valueDefaults?i.valueDefaults:[],undefined,undefined,u.NotValidated);if(i.valueTypes[0]&&i.valueTypes[0]!==h.Static){a.isInitial=true}o.updateConditionValues(a);o.checkConditionsEmpty(a,e);const l=this.getConditions();if(t!==undefined){l.splice(t,0,a)}else{l.push(a)}this.setProperty("conditions",l,true);if(!a.isInitial){this.fireConditionProcessed()}},updateDefineConditions:function(){const t=xt.call(this);lt.call(this,t,true,false);if(t.length===0){this.addDummyCondition()}if(t.length<this._iStartIndex){this._iStartIndex=0}},onChange:function(t){const e=t&&t.getParameter("promise");const i=t&&t.getSource();const n=function(t){const e=tt.call(this);const i=this.getConditions();o.checkConditionsEmpty(i,e);o.updateConditionsValues(i,e);lt.call(this,i,false,false);if(t){i.forEach(function(t){if(!t.isEmpty){delete t.isInitial}})}this.setProperty("conditions",i,true)}.bind(this);if(e){e.then(function(t){this._bPendingChange=false;n({mParameters:{value:t}});if(this._bPendingValidateCondition){_t.call(this,i);delete this._bPendingValidateCondition}}.bind(this)).catch(function(t){this._bPendingChange=false;if(this._bPendingValidateCondition){_t.call(this,i);delete this._bPendingValidateCondition}}.bind(this));this._bPendingChange=true;return}else{n()}},onSelectChange:function(t){const e=t.getSource();const i=t.getParameter("promise");i.then(function(t){const i=e._sOldKey;const s=o.getOperator(t);const a=i&&o.getOperator(i);const l=e.getBindingContext("$this");let r=l.getObject();const d=l.getPath();const c=parseInt(d.split("/")[2]);const u=this.getConditions();if(c>=0){r=u[c]}if(s&&a){let t=false;if(!n(s.valueTypes[0],a.valueTypes[0])&&s.valueTypes[0]!==h.Static){if(c>=0){r.values.forEach(function(e,i){if(e!==null){if(s.valueTypes[i]===h.Self&&a.valueTypes[i]===h.SelfNoParse||s.valueTypes[i]===h.SelfNoParse&&a.valueTypes[i]===h.Self){const e=Q.call(this,s.name,i);const n=Q.call(this,a.name,i);const o=n.formatValue(r.values[i],"string");const l=e.parseValue(o,"string");if(l!==r.values[i]){r.values[i]=e.parseValue(o,"string");t=true}}else{r.values[i]=null;t=true}}}.bind(this))}}if(c>=0&&s.valueDefaults){r.values.forEach(function(e,i){if(r.isInitial&&e!==s.valueDefaults[i]||e===null){r.values[i]=s.valueDefaults[i];r.isInitial=true;t=true}})}if(!s.valueTypes[1]&&a.valueTypes[1]){if(c>=0){if(r.values.length>1&&r.values[1]){r.values=r.values.slice(0,1);t=true}}}if(r.invalid){delete r.invalid;t=true}if(t){o.checkConditionsEmpty(r,tt.call(this));this.setProperty("conditions",u,true);Tt.call(this,false)}}delete e._sOldKey}.bind(this)).catch(function(t){const i=e.getBindingContext("$this");let n=i.getObject();const s=i.getPath();const o=parseInt(s.split("/")[2]);const a=this.getConditions();if(o>=0){n=a[o]}n.invalid=true;this.setProperty("conditions",a,true);e._sOldKey=e.getValue();Tt.call(this,true)}.bind(this))},onPaste:function(t){const e=t.originalEvent.clipboardData.getData("text/plain");const n=l(e,true);if(n.length>1){const n=t.srcControl;const s=n.getBindingContext("$condition").getPath();const l=parseInt(s.split("/")[2]);const r=this.getConditions();const c=i({},this.getConfig());c.display=d.Value;c.getConditions=function(){return r};c.defaultOperatorName=r[l].operator;c.valueType=c.dataType;delete c.dataType;const u=new a(c);try{r.splice(l,1);const t=u._parseValueToIndex(e,"string",l);u.validateValue(r);o.checkConditionsEmpty(t);this.setProperty("conditions",t,true);this.fireConditionProcessed()}catch(t){const i=new O(A.getText("field.PASTE_ERROR"));const s={element:n,property:"value",type:u,newValue:e,oldValue:"",exception:i,message:i.message};n.fireParseError(s,false,true)}u.destroy();t.stopImmediatePropagation(true);t.preventDefault()}},cleanUp:function(){const t=this.byId("conditions");const e=t.getContent();for(let t=0;t<e.length;t++){const i=e[t];if(i instanceof p&&i.hasOwnProperty("_iValueIndex")){if(i.isInvalidInput()){i.setValue()}}}this.setProperty("inputOK",true,true);if(this._iStartIndex>0||this._iShownAdditionalConditions>0){this._iStartIndex=0;this._iShownAdditionalConditions=0;ut.call(this)}},getInitialFocusedControl:function(){const t=this.getAggregation("_content").getContent()[1];const e=t.getContent()[0];return e},_getValueHelp:function(){return this.getValueHelp()||this.getFieldHelp&&this.getFieldHelp()}});function W(t){if(t.name==="value"){z.call(this,t.object,t.current,t.old)}if(t.name==="config"){const e=this.getConditions();const i=t.current&&t.current.operators;const s=t.old&&t.old.operators;let o=false;if(!n(i,s)){o=true;it.call(this)}const a=t.current&&t.current.dataType;const l=t.old&&t.old.valueType;const r=a&&a.getMetadata().getName();const d=l&&l.getMetadata().getName();const c=a&&a.getFormatOptions();const u=l&&l.getFormatOptions();const h=a&&a.getConstraints();const p=l&&l.getConstraints();if(r!==d||!n(c,u)||!n(h,p)){if(!o){it.call(this)}if(this._sConditionsTimer){this._bUpdateType=true}else if(e.length>0){this._bUpdateType=true;ut.call(this);this._bUpdateType=false;lt.call(this,e,true,true)}}}if(t.name==="conditions"&&!this._bConditionUpdateRunning){if(this._sConditionsTimer){clearTimeout(this._sConditionsTimer);this._sConditionsTimer=null}this._sConditionsTimer=setTimeout(function(){this._sConditionsTimer=null;this._bConditionUpdateRunning=true;this.updateDefineConditions();ut.call(this);this._bUpdateType=false;this._bConditionUpdateRunning=false}.bind(this),0)}}function q(t){return true}function z(t,e,i){t._sOldKey=i;let n=0;if(e&&i){const s=o.getOperator(e);const a=o.getOperator(i);const l=t.getParent();let r;let d;n=l.indexOfContent(t);r=l.getContent()[n+2];if(r&&r.hasOwnProperty("_iValueIndex")&&r._iValueIndex===0){if(r instanceof p&&!r.isInvalidInput()){r.setValueState(H.None);r.setValueStateText()}d=l.getContent()[n+3];if(d&&d.hasOwnProperty("_iValueIndex")&&d._iValueIndex===1){if(d instanceof p&&!d.isInvalidInput()){d.setValueState(H.None);d.setValueStateText()}}else{d=undefined}}else{r=undefined}if(q(e)){const t=this._getValueHelp();r&&r.setValueHelp&&r.setValueHelp(t);d&&d.setValueHelp&&d.setValueHelp(t)}else{r&&r.setValueHelp&&r.setValueHelp();d&&d.setValueHelp&&d.setValueHelp()}if(s.createControl||a.createControl){if(r){r.destroy()}if(d){d.destroy()}}else{if(r&&s.valueTypes[0]!==a.valueTypes[0]){r.unbindProperty("value")}if(d&&s.valueTypes[1]!==a.valueTypes[1]&&a.valueTypes[1]){d.unbindProperty("value")}}}if(!e){let e=t.getBindingContext("$this").getObject();if(e){const t=this.getConditions();n=o.indexOfCondition(e,t);if(n>=0){e=t[n];e.operator=i;this.setProperty("conditions",t,true)}}}const s=this.oOperatorModel.getData();let a;for(let t=0;t<s.length;t++){const i=s[t];if(i.key===e){a=i.text;break}}t.setAdditionalValue(a);this.onChange()}function J(t,e,i,n){const s=o.getOperator(t.operator);if(!s||!s.valueTypes[e]){return null}const a=Q.call(this,s.name,e);const l=this._oManagedObjectModel.getContext(n.getPath()+"values/"+e+"/");let r;if(s.createControl){r=s.createControl(a,"$this>",e,i)}if(!r){r=new p(i,{delegate:at.call(this),value:{path:"$this>",type:a,mode:"TwoWay",targetType:"raw"},editMode:{parts:[{path:"$condition>operator"},{path:"$condition>invalid"}],formatter:ft},multipleLines:false,width:"100%",valueHelp:q(t.operator)?this._getValueHelp():null})}if(r.getMetadata().hasProperty("placeholder")){if(e===0){r.bindProperty("placeholder",{path:"$condition>operator",formatter:It})}else{r.bindProperty("placeholder",{path:"$condition>operator",formatter:mt})}}r._iValueIndex=e;if(r.attachChange){r.attachChange(this.onChange.bind(this))}r.addDelegate(this._oContentEventDelegate,true,this);r.setLayoutData(new S({span:{parts:[{path:"$condition>"},{path:"$this>/config"}],formatter:vt.bind(this)}}));r.setBindingContext(l,"$this");r.setBindingContext(n,"$condition");r.setFieldGroupIds([n.getPath()]);return r}function Q(t,e){let i=nt.call(this);const n=o.getOperator(t);if(n.valueTypes[e]&&[h.Self,h.Static].indexOf(n.valueTypes[e])===-1){i=n._createLocalType(n.valueTypes[e],i)}let s=false;if(n.valueTypes[e]===h.Static){s=true;i=st.call(this)}const a=s?c.String:ot.call(this,i);let l;const r=i.getFormatOptions();switch(a){case c.Numeric:if(r&&r.hasOwnProperty("emptyString")&&r.emptyString===null){l=i}else{l=Y(i,{emptyString:null})}break;case c.Date:case c.Time:case c.DateTime:l=i;break;default:if(i.getConstraints()&&i.getConstraints().hasOwnProperty("nullable")&&i.getConstraints().nullable===false){l=Y(i);if(i._bCreatedByOperator){l=n._createLocalType(n.valueTypes[e],i)}}else{l=i}break}return l}function Y(t,e,n){const s=sap.ui.require(t.getMetadata().getName().replace(/\./g,"/"));const o=i(t.getFormatOptions(),e||{});const a=i(t.getConstraints(),n||{});if(a.hasOwnProperty("nullable")&&a.nullable===false){a.nullable=true}return new s(o,a)}function Z(){const t=tt.call(this);let e;const i=this.getConfig().defaultOperatorName;if(i){e=o.getOperator(i)}else{const t=nt.call(this);const i=ot.call(this,t);e=o.getDefaultOperator(i)}if(e&&t.indexOf(e.name)<0){for(let i=0;i<t.length;i++){e=o.getOperator(t[i]);if(!e||e.exclude||!e.hasRequiredValues()){e=undefined}else{break}}}if(!e){e=o.getOperator(t[0])}return e}function tt(){const t=this.getConfig();let e=t&&t.operators;if(!e||e.length===0){e=o.getOperatorsForType(c.String)}return e}function et(){let t;const e=tt.call(this);for(let i=0;i<e.length;i++){const n=e[i];const s=o.getOperator(n);if(!t){t=s.group.id}else if(t!==s.group.id){return true}}return false}function it(){if(!this.oOperatorModel){return}const t=nt.call(this);const e=tt.call(this);const i=[];const n=et.call(this);const s=this._sOperatorHelpId+"-pop-fl";const a=sap.ui.getCore().byId(s);let l;if(n){l=new y({key:"{om>key}",text:"{om>text}",additionalText:"{om>additionalText}",groupKey:"{om>groupId}",groupText:"{om>groupText}"})}else{l=new y({key:"{om>key}",text:"{om>text}",additionalText:"{om>additionalText}"})}a.bindAggregation("items",{path:"om>/",templateShareable:false,template:l});a.setGroupable(n);for(let s=0;s<e.length;s++){const a=e[s];const l=o.getOperator(a);if(!l||l.showInSuggest!==undefined&&l.showInSuggest==false){continue}const r=l.getLongText(ot.call(this,t));let d=l.additionalInfo;if(d===undefined){if(d!==""&&l.formatRange){d=l.formatRange(l._getRange(undefined,t),t)}else if(!n){d=l.group.text}}i.push({key:l.name,text:r,additionalText:d,groupId:l.group.id,groupText:l.group.text})}this.oOperatorModel.setData(i)}function nt(){const t=this.getConfig();let e=t&&t.dataType;if(!e){e=st.call(this)}return e}function st(){if(!this._oDefaultType){this._oDefaultType=new b}return this._oDefaultType}function ot(t){const e=t.getMetadata().getName();const i=t.getFormatOptions();const n=t.getConstraints();const s=this.getConfig().delegate;const o=this.getConfig().control;let a=s?s.getTypeMap(o).getBaseType(e,i,n):c.String;if(a===c.Unit){a=c.Numeric}return a}function at(){const t=this.getConfig();const e=t.delegateName||"sap/ui/mdc/field/FieldBaseDelegate";const i=t.payload;return{name:e,payload:i}}function lt(t,e,i){const n=nt.call(this);const s=[];let a=0;for(a=0;a<t.length;a++){const e=t[a];const l=o.getOperator(e.operator);if(l&&l.valueTypes[0]===h.Static&&(e.values.length===0||i)){if(l.getStaticText){const t=l.getStaticText(n,ot.call(this,n));if(e.values.length>0){e.values[0]=t}else{e.values.push(t)}s.push(a)}}}if(e&&s.length>0){this.setProperty("conditions",t,true)}}function rt(){const t=new T(this.getId()+"--ivtOperator",{text:"{$i18n>valuehelp.DEFINECONDITIONS_OPERATORLABEL}"});const e=new $(this.getId()+"-title",{text:{path:"$this>/label"}});const i=new D(this.getId()+"--prev",{icon:L.getIconURI("navigation-left-arrow"),tooltip:F.getText("PAGINGBUTTON_PREVIOUS"),visible:{path:"$this>/_pagination"},layoutData:new N({priority:X.NeverOverflow}),press:wt.bind(this)});const n=new D(this.getId()+"--next",{icon:L.getIconURI("navigation-right-arrow"),tooltip:F.getText("PAGINGBUTTON_NEXT"),visible:{path:"$this>/_pagination"},layoutData:new N({priority:X.NeverOverflow}),press:St.bind(this)});const s=new D(this.getId()+"--removeAll",{text:F.getText("CONDITIONPANEL_REMOVE_ALL"),visible:{path:"$this>/_pagination"},layoutData:new N({priority:X.Low}),press:Dt.bind(this)});const o=new D(this.getId()+"--insert",{icon:L.getIconURI("add"),visible:{path:"$this>/_pagination"},layoutData:new N({priority:X.Low}),press:Pt.bind(this)});const a=new E(this.getId()+"--pageCount",{text:Vt.call(this),wrapping:false,textAlign:j.Center,visible:{path:"$this>/_pagination"},layoutData:new N({priority:X.NeverOverflow})});const l=new V(this.getId()+"--toolbar",{width:"100%",design:G.Transparent,content:[e,new M,i,a,n,s,o]});const r=new P(this.getId()+"--panel",{headerToolbar:l,expanded:true,height:"100%",backgroundDesign:k.Transparent}).addStyleClass("sapMdcDefineconditionPanel");r.addDependent(new g(this._sOperatorHelpId,{typeahead:new f(this._sOperatorHelpId+"-pop",{content:[new C(this._sOperatorHelpId+"-pop-fl",{filterList:false,useFirstMatch:true})]})}));const d=new x(this.getId()+"--conditions",{width:"100%",hSpacing:0,vSpacing:0,containerQuery:true}).addStyleClass("sapUiMdcDefineConditionGrid");gt.call(this,undefined,d,0,null,0);r.addContent(t);r.addContent(d);this._oInvisibleAddOperatorButtonText=new T({text:A.getText("valuehelp.DEFINECONDITIONS_ADDCONDITION_DESCRIPTION")});r.addContent(this._oInvisibleAddOperatorButtonText);const c=new D(this.getId()+"--addBtn",{press:this.addCondition.bind(this),type:R.Default,text:"{$i18n>valuehelp.DEFINECONDITIONS_ADDCONDITION}",layoutData:new S({span:"XL2 L3 M3 S3",indent:"XL9 L8 M8 S7",linebreak:true,visibleS:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:dt.bind(this)},visibleM:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:dt.bind(this)},visibleL:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:dt.bind(this)},visibleXL:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:dt.bind(this)}}),ariaDescribedBy:this._oInvisibleAddOperatorButtonText});d.addContent(c);d.attachValidateFieldGroup(Ot,this);this.setAggregation("_content",r)}function dt(t,e){const i=e.hasOwnProperty("maxConditions")?e.maxConditions:-1;return i===-1||t.length<i}function ct(t,e){const i=e.hasOwnProperty("maxConditions")?e.maxConditions:-1;return i!==1}function ut(){const t=this.getConditions();const e=this.byId("conditions");const i=this.byId("prev");const n=this.byId("next");const s=this.byId("pageCount");let a;let l=-1;let r=0;let d=-1;const c=this._iShownConditions+this._iShownAdditionalConditions;for(let i=0;i<t.length&&l<c;i++){const n=t[i];const s=o.getOperator(n.operator);if(n.validated!==u.Validated||s.exclude){d++;if(d>=this._iStartIndex){l++;if(l<c){const t=this._oManagedObjectModel.getContext("/conditions/"+i+"/");if(!this.oOperatorModel){this.oOperatorModel=new I;this.setModel(this.oOperatorModel,"om");it.call(this)}a=e.getContent();if(a[r]&&a[r].isA("sap.ui.mdc.Field")){r=bt.call(this,n,e,r,t,l)}else{r=gt.call(this,n,e,r,t,l)}}}}}a=e.getContent();while(a[r]&&a[r]!==this.byId("addBtn")){a[r].destroy();r++}if(this._bFocusLastCondition){r=pt.call(this,"-operator");setTimeout(function(){a[r].focus()},0);this._bFocusLastCondition=false}if(this._bFocusLastRemoveBtn){r=ht.call(this,["-removeBtnLarge","-removeBtnSmall"]);a[r].focus();this._bFocusLastRemoveBtn=false}s.setText(Vt.call(this));i.setEnabled(this._iStartIndex>0);n.setEnabled(l>=c);this.setProperty("_pagination",d>=c)}function ht(t){const e=this.byId("conditions");const i=e.getContent();let n=i.length-1;if(!Array.isArray(t)){t=[t]}let s=0;let o=t[s];while(n>=0&&o!==undefined){const e=i[n];if(e.getId().endsWith(o)){const i=jQuery(e.getDomRef());if(i.is(":visible")){return n}else{s++;o=t[s]}}n--}return 0}function pt(t){const e=this.byId("conditions");const i=e.getContent();let n=i.length-1;const s=t;while(n>=0){const t=i[n];if(t.getId().endsWith(s)){return n}n--}return 0}function gt(t,e,i,n,s){const o=this.getId()+"--"+s;if(!this._oOperatorFieldType){this._oOperatorFieldType=new b({},{minLength:1})}const a=new p(o+"-operator",{value:{path:"$this>operator",type:this._oOperatorFieldType},width:"100%",display:d.Description,editMode:r.Editable,multipleLines:false,valueHelp:this._sOperatorHelpId,change:this.onSelectChange.bind(this),ariaLabelledBy:this.getId()+"--ivtOperator"}).setLayoutData(new S({span:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:yt.bind(this)},linebreak:true})).setBindingContext(n,"$this");if(n){a.setFieldGroupIds([n.getPath()])}this._oObserver.observe(a,{properties:["value"]});e.insertContent(a,i);i++;const l=new D(o+"--removeBtnSmall",{press:this.removeCondition.bind(this),type:R.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.DEFINECONDITIONS_REMOVECONDITION}"}).setLayoutData(new S({span:"XL1 L1 M1 S2",indent:{path:"$this>operator",formatter:Ct},visibleS:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:ct.bind(this)},visibleM:false,visibleL:false,visibleXL:false})).setBindingContext(n,"$this");if(n){l.setFieldGroupIds([n.getPath()])}e.insertContent(l,i);i++;if(t){for(let s=0;s<t.values.length;s++){const a=J.call(this,t,s,o+"-values"+s,n);if(a){e.insertContent(a,i);i++}}}const c=new D(o+"--removeBtnLarge",{press:this.removeCondition.bind(this),type:R.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.DEFINECONDITIONS_REMOVECONDITION}"}).setLayoutData(new S({span:"XL1 L1 M1 S1",indent:{path:"$this>operator",formatter:Ct},visibleS:false,visibleM:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:ct.bind(this)},visibleL:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:ct.bind(this)},visibleXL:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:ct.bind(this)}})).setBindingContext(n,"$this");e.insertContent(c,i);i++;return i}function ft(t,e){if(!t){return this.getEditMode()}else if(e){return r.ReadOnly}const i=o.getOperator(t);let n=false;if(i&&i.valueTypes[0]===h.Static){n=true}return n?r.Display:r.Editable}function Ct(t){const e=t&&o.getOperator(t);if(!e||!e.valueTypes[0]||e.valueTypes[0]===h.Static&&!e.getStaticText){return"XL8 L8 M8 S0"}else{return""}}function yt(t,e){const i=e.hasOwnProperty("maxConditions")?e.maxConditions:-1;let n="XL3 L3 M3 ";if(i===1){n+="S12"}else{n+="S10"}return n}function vt(t,e){const i=e.hasOwnProperty("maxConditions")?e.maxConditions:-1;const n=t&&o.getOperator(t.operator);let s="";if(n&&n.valueTypes[1]){s="XL4 L4 M4 "}else{s="XL8 L8 M8 "}if(i===1){s+="S12"}else{s+="S10"}return s}function It(t){const e=t&&o.getOperator(t);if(e&&e.aLabels){return e.aLabels[0]}else if(e&&e.valueTypes[1]){return A.getText("valuehelp.DEFINECONDITIONS_FROM")}else{return A.getText("valuehelp.DEFINECONDITIONS_VALUE")}}function mt(t){const e=t&&o.getOperator(t);if(e&&e.aLabels){return e.aLabels[1]}else if(e&&e.valueTypes[1]){return A.getText("valuehelp.DEFINECONDITIONS_TO")}}function bt(t,e,i,n,s){const o=this.getId()+"--"+s;let a=e.getContent();let l;const r=a[i];r.setBindingContext(n,"$this");if(n){r.setFieldGroupIds([n.getPath()])}if(r.getValueState()===H.Error&&!t.invalid){r.setValue(r.getValue())}i++;const d=a[i];d.setBindingContext(n,"$this");if(n){d.setFieldGroupIds([n.getPath()])}i++;let c;let u=a[i];let h;if(u.hasOwnProperty("_iValueIndex")&&u._iValueIndex===0){if(t.values.length>0){c=this._oManagedObjectModel.getContext(n.getPath()+"values/0/");u.setBindingContext(c,"$this");u.setBindingContext(n,"$condition");if(u.getMetadata().hasProperty("value")&&(this._bUpdateType||!u.getBindingInfo("value"))){l=Q.call(this,t.operator,0);u.bindProperty("value",{path:"$this>",type:l})}i++;h=a[i];if(h.hasOwnProperty("_iValueIndex")&&h._iValueIndex===1){if(t.values.length>1){c=this._oManagedObjectModel.getContext(n.getPath()+"values/1/");h.setBindingContext(c,"$this");if(h.getMetadata().hasProperty("value")&&(this._bUpdateType||!h.getBindingInfo("value"))){l=Q.call(this,t.operator,1);h.bindProperty("value",{path:"$this>",type:l})}i++}else{h.destroy()}}else if(t.values.length>1){h=J.call(this,t,1,o+"-values1",n);if(h){e.insertContent(h,i);i++}}}else{u.destroy();u=undefined;h=a[i+1];if(h&&h.hasOwnProperty("_iValueIndex")&&h._iValueIndex===1){h.destroy()}}}else if(t.values.length>0){for(let s=0;s<t.values.length;s++){const a=J.call(this,t,s,o+"-values"+s,n);if(a){e.insertContent(a,i);i++}}}a=e.getContent();const p=a[i];p.setBindingContext(n,"$this");i++;return i}function Ot(t){if(this._bPendingChange){this._bPendingValidateCondition=true;return}let e=t.getSource();while(!(e.getParent()instanceof x)){e=e.getParent()}_t.call(this,e)}function _t(t){const e=t.getParent();let i=e.indexOfContent(t);let n;if(t.getId().endsWith("-operator")){n=t.getBindingContext("$this");i=i+2;t=e.getContent()[i]}else if(t.getId().endsWith("-removeBtnSmall")){n=t.getBindingContext("$this");i=i+1;t=e.getContent()[i]}else{n=t.getBindingContext("$condition")}let s;const a=n.getObject();const l=o.getOperator(a.operator);let r=!!a.invalid;if(!r&&l.valueTypes.length>0&&l.valueTypes[0]!==h.Static){if(l.valueTypes.length>1&&l.valueTypes[1]){if(t.hasOwnProperty("_iValueIndex")&&t._iValueIndex===0){s=e.getContent()[i+1]}else if(t.hasOwnProperty("_iValueIndex")&&t._iValueIndex===1){s=e.getContent()[i-1]}}if(t.getMetadata().getAllProperties().valueState&&!t.isInvalidInput()&&(!s||!s.isInvalidInput())){const e=t.getBinding("value").getType();try{l.validate(a.values,e);t.setValueState(H.None);t.setValueStateText();if(s&&s.getMetadata().getAllProperties().valueState){s.setValueState(H.None);s.setValueStateText()}}catch(e){r=true;t.setValueState(H.Error);t.setValueStateText(e.message);if(s&&s.getMetadata().getAllProperties().valueState){s.setValueState(H.Error);s.setValueStateText(e.message)}}}}Tt.call(this,r);this.fireConditionProcessed()}function Tt(t){let e=0;if(t!==true){const i=this.getConditions();for(e=0;e<i.length;e++){if(i[e].invalid){t=true;break}}}if(t!==true){const i=this.byId("conditions");const n=i.getContent();t=false;for(e=0;e<n.length;e++){const i=n[e];if(i.hasOwnProperty("_iValueIndex")&&i.getValueState&&i.getValueState()===H.Error){t=true;break}}}this.setProperty("inputOK",!t,true)}function xt(){return this.getConditions().filter(function(t){const e=o.getOperator(t.operator);return t.validated!==u.Validated||e.exclude})}function St(t){this._iStartIndex=this._iStartIndex+this._iShownConditions;this._iShownAdditionalConditions=0;ut.call(this)}function wt(t){this._iStartIndex=this._iStartIndex-this._iShownConditions;if(this._iStartIndex<0){this._iStartIndex=0}this._iShownAdditionalConditions=0;ut.call(this)}function Dt(t){const e=this.getConditions().filter(function(t){const e=o.getOperator(t.operator);return t.validated===u.Validated&&!e.exclude});this.addDummyCondition(e.length+1);this._iStartIndex=0;this._iShownAdditionalConditions=0;this.setProperty("conditions",e,true);this.oInvisibleMessage.announce(A.getText("valuehelp.DEFINECONDITIONS_REMOVECONDITION_ANNOUNCE"),U.Assertive);this.fireConditionProcessed()}function Pt(t){const e=this.getConditions();const i=this.getFormatOptions();const n=i.maxConditions;const s=this.byId("conditions");const o=s.getContent();let a=0;let l=-1;for(let t=0;t<o.length;t++){const e=o[t];if(e instanceof p&&e.getValueHelp()===this._sOperatorHelpId){a++;if(a===1){const t=e.getBindingContext("$this");const i=t.getPath();const n=i.match(/^.*\/(\d+)\/$/);if(n){l=parseInt(n[1])}}}}if(n===-1||e.length<n){this.addDummyCondition(l);if(a>=this._iShownConditions){this._iShownAdditionalConditions++}}this.oInvisibleMessage.announce(A.getText("valuehelp.DEFINECONDITIONS_ADDCONDITION_ANNOUNCE"),U.Assertive)}function Vt(){const t=xt.call(this);const e=Math.ceil((t.length-this._iShownAdditionalConditions)/this._iShownConditions);const i=Math.floor(this._iStartIndex/this._iShownConditions)+1;const n=A.getText("valuehelp.PAGE_COUNT",[i,e]);return n}return K});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/base/DialogTab", ["sap/ui/core/Control"],function(e){"use strict";const t=e.extend("sap.ui.mdc.valuehelp.base.DialogTab",{metadata:{library:"sap.ui.mdc",properties:{content:{type:"object"}},events:{select:{parameters:{type:{type:"sap.ui.mdc.enums.ValueHelpSelectionType"},conditions:{type:"object[]"}}},confirm:{parameters:{close:{type:"boolean"}}},cancel:{}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t);e.class("sapUiMdcDialogTab");e.openEnd();const n=t.getContent();if(n){e.renderControl(n)}e.close("div")}}});t.prototype.init=function(){e.prototype.init.apply(this,arguments)};t.prototype.exit=function(){if(this._displayContent){this._displayContent=null}return e.prototype.exit.apply(this,arguments)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/base/FilterableListContent", ["sap/ui/mdc/util/loadModules","sap/ui/mdc/valuehelp/base/ListContent","sap/ui/mdc/condition/Condition","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/util/Common","sap/m/p13n/enum/PersistenceMode","sap/m/p13n/Engine","sap/base/util/merge","sap/ui/mdc/p13n/StateUtil","sap/ui/mdc/condition/FilterOperatorUtil","sap/base/Log"],function(t,e,i,n,r,o,l,s,a,c,u,h){"use strict";const p=e.extend("sap.ui.mdc.valuehelp.base.FilterableListContent",{metadata:{library:"sap.ui.mdc",properties:{filterFields:{type:"string",defaultValue:""},keyPath:{type:"string",defaultValue:""},descriptionPath:{type:"string",defaultValue:""},group:{type:"string",defaultValue:""}},aggregations:{filterBar:{type:"sap.ui.mdc.filterbar.vh.FilterBar",multiple:false},_defaultFilterBar:{type:"sap.ui.mdc.filterbar.vh.FilterBar",multiple:false,visibility:"hidden"}},associations:{},events:{}}});p.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._oObserver.observe(this,{properties:["filterFields"],aggregations:["_defaultFilterBar","filterBar"]});s.getInstance().defaultProviderRegistry.attach(this,l.Transient)};p.prototype.handleFilterValueUpdate=function(t){if((this.isContainerOpening()||this.isContainerOpen())&&this._bContentBound){Promise.resolve(this.applyFilters()).finally(function(){e.prototype.handleFilterValueUpdate.apply(this,arguments)}.bind(this))}};p.prototype.applyFilters=function(){};p.prototype._prettyPrintFilters=function(t){let e;if(!t){return""}if(Array.isArray(t)){e="";t.forEach(function(t,i,n){e+=this._prettyPrintFilters(t);if(n.length-1!=i){e+=" or "}},this);return"("+e+")"}else if(t._bMultiFilter){e="";const i=t.bAnd;t.aFilters.forEach(function(t,n,r){e+=this._prettyPrintFilters(t);if(r.length-1!=n){e+=i?" and ":" or "}},this);return"("+e+")"}else{e=t.sPath+" "+t.sOperator+" '"+t.oValue1+"'";if(t.sOperator==="BT"){e+="...'"+t.oValue2+"'"}return e}};p.prototype.getItemFromContext=function(t,e){const i=e&&e.keyPath||this.getKeyPath();const n=e&&e.descriptionPath||this.getDescriptionPath();let r;let o;if(!i){throw new Error("KeyPath missing")}if(t){r=i?t.getProperty(i):undefined;o=n?t.getProperty(n):undefined}if(r===null||r===undefined){return false}const l=this.createConditionPayload([r,o],t);return{key:r,description:o,payload:l}};p.prototype.createConditionPayload=function(t,e){let i;const n=this.getValueHelpDelegate();if(n){const r=this.getValueHelpInstance();i={};i=n.createConditionPayload(r,this,t,e)}return i};p.prototype._isContextSelected=function(t,e){return!!t&&!!this._findConditionsForContext(t,e).length};p.prototype._findConditionsForContext=function(t,e){const i=this.isValueHelpDelegateInitialized()&&this.getValueHelpDelegate();if(t&&i){if(i.isFilterableListItemSelected){h.warning("MDC.ValueHelp","Delegate method 'isFilterableListItemSelected' is deprecated, please implement 'findConditionsForContext' instead.");const n=i.isFilterableListItemSelected(this.getValueHelpInstance(),this,{getBindingContext:function(){return t}},e);if(n){const i=this.getItemFromContext(t);const n=i&&this.createCondition(i.key,i.description,i.payload);return e.filter(function(t){return u.compareConditions(t,n)})}return[]}return i.findConditionsForContext(this.getValueHelpInstance(),this,t,e)}return[]};p.prototype._createDefaultFilterBar=function(){return t(["sap/ui/mdc/filterbar/vh/FilterBar"]).then(function(t){if(this.isDestroyStarted()){return null}const e=t[0];const i=new e(this.getId()+"-FB",{liveMode:false,showGoButton:true});d.call(this,i);this.setAggregation("_defaultFilterBar",i,true);return i}.bind(this))};p.prototype._handleSearch=function(t){const e=t.getSource();this._setLocalFilterValue(e.getSearch());this.applyFilters()};function d(e){const i=e.getBasicSearchField();const n=this.getFilterFields();if(!i&&n){if(!this._oSearchField){return t(["sap/ui/mdc/FilterField"]).then(function(t){if(!e.isDestroyed()){const i=t[0];this._oSearchField=new i(this.getId()+"-search",{conditions:"{$filters>/conditions/"+n+"}",propertyKey:n,placeholder:"{$i18n>filterbar.SEARCH}",label:"{$i18n>filterbar.SEARCH}",maxConditions:1,width:"50%"});this._oSearchField._bCreatedByValueHelp=true;d.call(this,e)}}.bind(this))}e.setBasicSearchField(this._oSearchField)}else if(i){if(n){i.setConditions([])}else if(i._bCreatedByValueHelp){e.setBasicSearchField()}}}p.prototype.onContainerClose=function(){this._setLocalFilterValue(undefined)};p.prototype._getPriorityFilterBar=function(){return this.getFilterBar()||this.getAggregation("_defaultFilterBar")};p.prototype.observeChanges=function(t){if(t.object==this){let e;if(["_defaultFilterBar","filterBar"].indexOf(t.name)!==-1){e=t.child;let i;if(t.mutation==="insert"){d.call(this,e);this._assignCollectiveSearchSelect();if(t.name!=="_defaultFilterBar"||!this.getFilterBar()){e.attachSearch(this._handleSearch,this)}if(t.name==="filterBar"){i=this.getAggregation("_defaultFilterBar");if(i){i.detachSearch(this._handleSearch,this)}}}else{const n=e.getBasicSearchField();if(n&&n._bCreatedByValueHelp){e.setBasicSearchField()}e.detachSearch(this._handleSearch,this);if(t.name==="filterBar"){i=this.getAggregation("_defaultFilterBar");if(i){i.attachSearch(this._handleSearch,this)}else{this._createDefaultFilterBar()}}}}else if(t.name==="filterFields"){e=this._getPriorityFilterBar();if(e){d.call(this,e)}}}e.prototype.observeChanges.apply(this,arguments)};p.prototype.getCollectiveSearchKey=function(){return this._oCollectiveSearchSelect&&this._oCollectiveSearchSelect.getSelectedItemKey()};p.prototype.getListBindingInfo=function(){throw new Error("FilterableListContent: Every filterable listcontent must implement this method.")};p.prototype._getListItemBindingContext=function(t){const e=this.getListBindingInfo().model;return t&&t.getBindingContext(e)};p.prototype.getInitialFocusedControl=function(){return this._getPriorityFilterBar().getInitialFocusedControl()};p.prototype._getTypesForConditions=function(t){const e=this.getValueHelpDelegate();const i=this.getValueHelpInstance();return e?e.getTypesForConditions(i,this,t):{}};p.prototype.getFormattedTitle=function(t){let i=e.prototype.getFormattedTitle.apply(this,arguments);if(!i){i=this._oResourceBundle.getText(t?"valuehelp.SELECTFROMLIST":"valuehelp.SELECTFROMLISTNONUMBER",[t])}return i};p.prototype.getFormattedShortTitle=function(){let t=this.getShortTitle();if(!t){t=this._oResourceBundle.getText("valuehelp.SELECTFROMLIST.Shorttitle")}return t};p.prototype.getFormattedTokenizerTitle=function(t){let e=this.getTokenizerTitle();if(!e){e=this._oResourceBundle.getText("valuehelp.SELECTFROMLIST.TokenizerTitle"+(t===0?"NoCount":""),[t])}return e};p.prototype.isSearchSupported=function(){const t=this.getFilterFields();let e=!!t;if(t==="$search"){const t=this.getListBinding();const i=this.getValueHelpDelegate();const n=this.getValueHelpInstance();e=i&&i.isSearchSupported(n,this,t)}return e};p.prototype.setCollectiveSearchSelect=function(t){this._oCollectiveSearchSelect=t;this._assignCollectiveSearchSelect()};p.prototype._assignCollectiveSearchSelect=function(){const t=this._getPriorityFilterBar();if(t.setCollectiveSearch){t.setCollectiveSearch(this._oCollectiveSearchSelect)}};p.prototype.onBeforeShow=function(t){if(t){const e=this.getValueHelpDelegate();return Promise.resolve(e&&e.getFilterConditions(this.getValueHelpInstance(),this)).then(function(e){this._oInitialFilterConditions=e;const i=this._getPriorityFilterBar();if(i){const e=this.getFilterFields();const n=a({},this._oInitialFilterConditions);return Promise.resolve(!n[e]&&c.retrieveExternalState(i).then(function(r){if(t){f(n,e,this._getPriorityFilterValue());return c.diffState(i,r,{filter:n})}}.bind(this))).then(function(t){return c.applyExternalState(i,t)})}}.bind(this))}return undefined};p.prototype._fireSelect=function(t){const e=this.getValueHelpDelegate();const i=this.getValueHelpInstance();const n=e&&e.modifySelectionBehaviour?e.modifySelectionBehaviour(i,this,t):t;if(n){this.fireSelect(n)}};p.prototype.exit=function(){s.getInstance().defaultProviderRegistry.detach(this);o.cleanup(this,["_oCollectiveSearchSelect","_oInitialFilterConditions"]);if(this._oSearchField&&!this._oSearchField.getParent()){this._oSearchField.destroy();delete this._oSearchField}e.prototype.exit.apply(this,arguments)};p.prototype.getCount=function(t,i){const n=this.isValueHelpDelegateInitialized()&&this.getValueHelpDelegate();const r=n&&this.getValueHelpInstance();return n&&n.getCount?n.getCount(r,this,t,i):e.prototype.getCount.apply(this,arguments)};p.prototype._getLocalFilterValue=function(){const t=this.getParent();return t&&t.getLocalFilterValue()};p.prototype._setLocalFilterValue=function(t){const e=this.getParent();return e&&e.setLocalFilterValue(t)};p.prototype._getPriorityFilterValue=function(){const t=this._getLocalFilterValue();if(typeof t!=="undefined"){return t}return this.getFilterValue()};p.prototype.getSelectableConditions=function(){return this.getConditions().filter(function(t){return t.validated===n.Validated})};function f(t,e,o){t[e]=o?[i.createCondition(r.Contains,[o],undefined,undefined,n.NotValidated)]:[];return}return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/base/ListContent", ["sap/ui/mdc/valuehelp/base/Content","sap/ui/mdc/enums/ConditionValidated"],function(e,t){"use strict";const n=e.extend("sap.ui.mdc.valuehelp.base.ListContent",{metadata:{library:"sap.ui.mdc",properties:{caseSensitive:{type:"boolean",defaultValue:false},useFirstMatch:{type:"boolean",group:"Behavior",defaultValue:true},useAsValueHelp:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{},events:{}}});n.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oObserver.observe(this,{properties:["caseSensitive"]})};n.prototype.observeChanges=function(t){if(t.name==="caseSensitive"){this.handleFilterValueUpdate(t)}e.prototype.observeChanges.apply(this,arguments)};n.prototype.getCount=function(e){let n=0;for(let i=0;i<e.length;i++){const o=e[i];if(o.isEmpty!==true&&o.validated===t.Validated){n++}}return n};n.prototype.getListBinding=function(){throw new Error("ListContent: Every listcontent must implement this method.")};n.prototype.getRelevantContexts=function(e){throw new Error("ListContent: Every listcontent must implement this method.")};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/content/Bool", ["sap/ui/mdc/valuehelp/content/FixedList","sap/ui/mdc/util/loadModules","sap/ui/model/ParseException"],function(e,t,o){"use strict";const s=e.extend("sap.ui.mdc.valuehelp.content.Bool",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.ITypeaheadContent"]}});s.prototype.init=function(){e.prototype.init.apply(this,arguments);this.setUseFirstMatch(true);this.setUseAsValueHelp(true);this.setFilterList(false);this.setCaseSensitive(false);this._oObserver.observe(this,{properties:["config"]})};s.prototype.exit=function(){if(this._oModel){this._oModel.destroy();this._oModel=undefined}e.prototype.exit.apply(this,arguments)};s.prototype.getContent=function(){return this._retrievePromise("boolContent",function(){return t(["sap/ui/mdc/valuehelp/content/FixedListItem","sap/ui/model/json/JSONModel"]).then(function(t){const o=t[0];const s=t[1];this._oModel=new s({type:"",items:[{key:true,text:"true"},{key:false,text:"false"}]});i.call(this,this.getConfig());const n=new o(this.getId()+"-Item",{key:{path:"$Bool>key"},text:{path:"$Bool>text"}});this.bindAggregation("items",{path:"$Bool>/items",template:n});this.setModel(this._oModel,"$Bool");return e.prototype.getContent.apply(this,arguments)}.bind(this))}.bind(this))};s.prototype.getItemForValue=function(e){return Promise.resolve().then(function(){const t=this.getConfig();const s=e.dataType||t&&t.dataType;if(s){if(e.checkKey){if(e.parsedValue===true||e.parsedValue===false){return{key:e.parsedValue,description:s.formatValue(e.parsedValue,"string")}}else{e.checkDescription=true}}if(e.checkDescription&&e.value){const t=s.formatValue(true,"string");if(t.toLowerCase().startsWith(e.value.toLowerCase())){return{key:true,description:t}}const o=s.formatValue(false,"string");if(o.toLowerCase().startsWith(e.value.toLowerCase())){return{key:false,description:o}}}const t=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[e.value]);const i=e.exception||o;throw new i(t)}else{throw new Error("Type missing")}}.bind(this))};s.prototype.shouldOpenOnClick=function(){return false};s.prototype.isNavigationEnabled=function(e){return true};s.prototype.observeChanges=function(t){if(t.type==="property"&&t.name==="config"){i.call(this,t.current)}e.prototype.observeChanges.apply(this,arguments)};function i(e){if(this._oModel&&e){const t=e.dataType;const o=this._oModel.getData();if(t&&o["type"]!==t.getMetadata().getName()){o["type"]=t.getMetadata().getName();const e=o["items"];for(let o=0;o<e.length;o++){const s=e[o];s["text"]=t.formatValue(s["key"],"string")}this._oModel.checkUpdate(true)}}}return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/content/Conditions", ["sap/ui/mdc/valuehelp/base/Content","sap/ui/mdc/util/loadModules","sap/ui/mdc/enums/ValueHelpSelectionType","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/util/Common"],function(e,t,n,i,o){"use strict";const l=e.extend("sap.ui.mdc.valuehelp.content.Conditions",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.ITypeaheadContent","sap.ui.mdc.valuehelp.IDialogContent"],properties:{label:{type:"string"}},aggregations:{},associations:{fieldHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false},valueHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false}},events:{}}});l.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc")};l.prototype.exit=function(){o.cleanup(this,["_oScrollContainer","_oDefineConditionPanel"]);e.prototype.exit.apply(this,arguments)};l.prototype.getContent=function(){return this._retrievePromise("content",function(){const e=["sap/ui/mdc/valuehelp/base/DefineConditionPanel","sap/ui/model/base/ManagedObjectModel"];if(this.provideScrolling()){e.push("sap/m/ScrollContainer")}return t(e).then(function(e){const t=e[0];const n=e[1];const i=e.length>2&&e[2];this._oManagedObjectModel=new n(this);this._oDefineConditionPanel=new t(this.getId()+"-DCP",{label:"{$help>/label}",conditions:"{$help>/conditions}",inputOK:"{$valueHelp>/_valid}",config:{path:"$help>/config"},conditionProcessed:r.bind(this),valueHelp:this.getValueHelp()||this.getFieldHelp&&this.getFieldHelp()}).setModel(this._oManagedObjectModel,"$help");if(i){this._oScrollContainer=new i(this.getId()+"-SC",{height:"100%",width:"100%",vertical:true,content:[this._oDefineConditionPanel]});this.setAggregation("displayContent",this._oScrollContainer);return this._oScrollContainer}else{this.setAggregation("displayContent",this._oDefineConditionPanel);return this._oDefineConditionPanel}}.bind(this))}.bind(this))};l.prototype.getCount=function(e){let t=0;for(let n=0;n<e.length;n++){const o=e[n];if(o.isEmpty!==true&&o.validated===i.NotValidated){t++}}return t};l.prototype.getUseAsValueHelp=function(){return false};l.prototype.getValueHelpIcon=function(){return"sap-icon://value-help"};l.prototype.isFocusInHelp=function(){return true};l.prototype.getInitialFocusedControl=function(){return this._oDefineConditionPanel.getInitialFocusedControl()};l.prototype.getRequiresTokenizer=function(){return true};l.prototype.getFormattedTitle=function(t){let n=e.prototype.getFormattedTitle.apply(this,arguments);if(!n){n=this._oResourceBundle.getText(t?"valuehelp.DEFINECONDITIONS":"valuehelp.DEFINECONDITIONSNONUMBER",[t])}return n};l.prototype.getFormattedShortTitle=function(){let e=this.getShortTitle();if(!e){e=this._oResourceBundle.getText("valuehelp.DEFINECONDITIONS.Shorttitle")}return e};l.prototype.getFormattedTokenizerTitle=function(e){let t=this.getTokenizerTitle();if(!t){t=this._oResourceBundle.getText("valuehelp.DEFINECONDITIONS.TokenizerTitle"+(e===0?"NoCount":""),[e])}return t};l.prototype.getAriaAttributes=function(e){return{contentId:this.getId()+"-DCP",ariaHasPopup:"dialog",roleDescription:null,valueHelpEnabled:true,autocomplete:"none"}};l.prototype.getContainerConfig=function(){return{"sap.ui.mdc.valuehelp.Popover":{showArrow:true,showHeader:true,getContentWidth:function(){return"500px"},getFooter:function(){return this._retrievePromise("footer",function(){return t(["sap/m/library","sap/m/Button"]).then(function(e){const t=e[0];const n=t.ButtonType;const i=e[1];const o=new i(this.getId()+"-ok",{text:this._oResourceBundle.getText("valuehelp.OK"),enabled:"{$valueHelp>/_valid}",type:n.Emphasized,press:s.bind(this)});const l=new i(this.getId()+"-cancel",{text:this._oResourceBundle.getText("valuehelp.CANCEL"),press:this.fireCancel.bind(this)});return[o,l]}.bind(this))}.bind(this))}.bind(this)}}};l.prototype.onContainerClose=function(){if(this._oDefineConditionPanel){this._oDefineConditionPanel.cleanUp()}};function s(e){this.fireConfirm({close:true})}function r(e){let t=this.getConditions();if(this.getMaxConditions()===1){t=t.filter(function(e){return e.validated==="NotValidated"})}this.fireSelect({type:n.Set,conditions:t})}return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/content/FixedList", ["sap/ui/mdc/valuehelp/base/ListContent","sap/ui/mdc/util/loadModules","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/enums/ValueHelpSelectionType","sap/ui/model/ParseException","sap/base/util/deepEqual"],function(t,e,i,s,n,o,l){"use strict";const a=t.extend("sap.ui.mdc.valuehelp.content.FixedList",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.ITypeaheadContent","sap.ui.mdc.valuehelp.IDialogContent"],properties:{groupable:{type:"boolean",group:"Appearance",defaultValue:false},filterList:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{items:{type:"sap.ui.mdc.valuehelp.content.FixedListItem",multiple:true,singularName:"item"}},defaultAggregation:"items",events:{}}});a.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._iNavigateIndex=-1};a.prototype.exit=function(){if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();delete this._oManagedObjectModel}t.prototype.exit.apply(this,arguments)};a.prototype.getContent=function(){return this._retrievePromise("content",function(){return e(["sap/m/List","sap/m/DisplayListItem","sap/m/library","sap/ui/model/Filter","sap/ui/model/Sorter","sap/ui/model/base/ManagedObjectModel","sap/base/strings/whitespaceReplacer"]).then(function(t){const e=t[0];const i=t[1];const s=t[2];const n=t[3];const o=t[4];const l=t[5];const a=t[6];this._oManagedObjectModel=new l(this);const r=new i(this.getId()+"-item",{type:s.ListType.Active,label:{path:"$help>text",formatter:a},value:{path:"$help>additionalText",formatter:a},valueTextDirection:"{$help>textDirection}"}).addStyleClass("sapMComboBoxNonInteractiveItem");const u=new n({path:"text",test:p.bind(this),caseSensitive:true});let h;if(this.getGroupable()){h=new o("groupKey",false,g.bind(this))}const d=new e(this.getId()+"-List",{width:"100%",showNoData:false,mode:s.ListMode.SingleSelectMaster,rememberSelections:false,items:{path:"$help>/items",template:r,filters:u,sorter:h,templateShareable:false},itemPress:c.bind(this)}).addStyleClass("sapMComboBoxBaseList").addStyleClass("sapMComboBoxList");d.applyAriaRole("listbox");d.setModel(this._oManagedObjectModel,"$help");this.setAggregation("displayContent",d,true);f.call(this,true);return d}.bind(this))}.bind(this))};function r(){return this.getAggregation("displayContent")}function c(t){const e=t.getParameter("listItem");const i=e.getSelected();if(i){const t=y.call(this,e);const i=v.call(this,t);const s=x.call(this,t);u.call(this,i,s);this.fireSelect({type:n.Set,conditions:this.getConditions()});this.fireConfirm()}}function u(t,e){const i=this.createCondition(t,e);const s=this.getConditions();if(l([i],s)){f.call(this)}else{this.setProperty("conditions",[i],true)}return i}function p(t){const e=this.getFilterList();return!e||h.call(this,t,this.getFilterValue())}function h(t,e){return!e||typeof e==="string"&&(this.getCaseSensitive()?t.startsWith(e):t.toLowerCase().startsWith(e.toLowerCase()))}function d(){if(this._iNavigateIndex>=0){this.setProperty("conditions",[],true);this._iNavigateIndex=-1}const t=r.call(this);const e=this.getListBinding();if(t){e.update();t.updateItems();t.invalidate();f.call(this,true)}}function g(t){const e=t.getProperty("groupKey");const i=t.getProperty("groupText");return{key:e,text:i}}function f(t){const e=r.call(this);if(e){const n=this.getConditions();let o,l;const a=this.getFilterValue();const r=this.getUseFirstMatch();let c=false;let u;const p=this.getParent().isOpen();if(n.length>0&&(n[0].validated===i.Validated||n[0].operator===s.EQ)){o=n[0].values[0]}if(r&&a){const t=this.getValueHelpDelegate().getFirstMatch(this.getValueHelpInstance(),this,{checkDescription:true,value:a});if(t){l=I.call(this,t)}}const h=e.getItems();for(let t=0;t<h.length;t++){const i=h[t];if(i.isA("sap.m.DisplayListItem")){const t=y.call(this,i);if(n.length>0&&v.call(this,t)===o){i.setSelected(true);if(p&&!i.hasStyleClass("sapMLIBFocused")){e.setFakeFocus(i)}}else if(n.length===0&&this._iNavigateIndex<0&&!c&&l&&l===t){i.setSelected(true);u=i.getId();c=true}else{i.setSelected(false);if(p&&i.hasStyleClass("sapMLIBFocused")){e.setFakeFocus()}}}}if(t&&c){m.call(this,l,u)}}}function m(t,e){const i=this.getFilterValue();const s=this.getUseFirstMatch();if(s&&i&&t){const s=v.call(this,t);const n=x.call(this,t);const o=this.createCondition(s,n);this.fireTypeaheadSuggested({condition:o,filterValue:i,itemId:e})}}function y(t){return this._oManagedObjectModel.getProperty(t.getBindingContextPath())}function I(t){return this._oManagedObjectModel.getProperty(t.getPath())}function v(t){const e=t.getBinding("key");if(e){return e.getInternalValue()}else{return t.getKey()}}function x(t){const e=t.getBinding("text");if(e){return e.getInternalValue()}else{return t.getText()}}a.prototype.getItemForValue=function(t){return this.getContent().then(function(){if(t.value===null||t.value===undefined){return null}else if(!t.value&&t.checkDescription){return null}const e=this.getItems();let i;let s=0;let n;let a;for(s=0;s<e.length;s++){i=e[s];n=v.call(this,i);a=x.call(this,i);if(t.checkKey&&l(n,t.parsedValue)||t.checkDescription&&(l(a,t.parsedDescription)||i.getText()===t.value)){return{key:n,description:a}}}if(t.checkKey&&t.value===""){return null}if(this.getUseFirstMatch()){const e=this.getValueHelpDelegate().getFirstMatch(this.getValueHelpInstance(),this,t);if(e){const t=I.call(this,e);n=v.call(this,t);a=x.call(this,t);return{key:n,description:a}}}const r=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[t.value]);const c=t.exception||o;throw new c(r)}.bind(this))};a.prototype.isValidationSupported=function(t){return true};a.prototype.isSearchSupported=function(){return true};a.prototype.handleConditionsUpdate=function(t){f.call(this,false)};a.prototype.handleFilterValueUpdate=function(e){d.call(this);t.prototype.handleFilterValueUpdate.apply(this,arguments)};a.prototype.removeFocus=function(){const t=r.call(this);if(t){t.removeStyleClass("sapMListFocus")}};a.prototype.navigate=function(t){const e=r.call(this);if(!e){return}const i=e.getItems();const s=i.length;const n=this._iNavigateIndex>=0?i[this._iNavigateIndex]:e.getSelectedItem();let o=0;const l=this.getFilterList();const a=this.getFilterValue();let c=false;const p=this.getParent().isOpen();if(!l&&!n){let e=0;if(t>=0){for(e=0;e<i.length;e++){if(!i[e].isA("sap.m.GroupHeaderListItem")&&h.call(this,i[e].getLabel(),a)){o=e;break}}}else{for(e=i.length-1;e>=0;e--){if(!i[e].isA("sap.m.GroupHeaderListItem")&&h.call(this,i[e].getLabel(),a)){o=e;break}}}}else if(n){o=e.indexOfItem(n);o=o+t}else if(t>=0){o=t-1}else{o=s+t}if(t===9999){o=s-1}if(t===-9999){o=0}let d;if(o<0){o=0;d=true;c=true}else if(o>=s-1){o=s-1;d=false}else{d=t>=0}const g=function(){while(i[o]&&i[o].isA("sap.m.GroupHeaderListItem")){if(d){o++}else{o--}}};if(!p||t===0){g();if(o<0||o>s-1){d=!d;c=o<0;o=o<0?0:s-1;g()}}const f=i[o];if(f){const t=this.getUseFirstMatch();if(f!==n||t&&!c||this._iNavigateIndex!==o&&!c){let t,i,s;this._iNavigateIndex=o;if(p){e.scrollToIndex(o);e.setFakeFocus(f)}if(f.isA("sap.m.GroupHeaderListItem")){this.setProperty("conditions",[],true);this.fireNavigated({condition:undefined,itemId:f.getId(),leaveFocus:false})}else{t=y.call(this,f);i=v.call(this,t);s=x.call(this,t);const e=u.call(this,i,s);this.fireNavigated({condition:e,itemId:f.getId(),leaveFocus:false})}if(p){e.addStyleClass("sapMListFocus")}}else if(c){this._iNavigateIndex=-1;this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:c})}}};a.prototype.onShow=function(){return t.prototype.onShow.apply(this,arguments).then(()=>{const t=r.call(this);let e;if(!t){return null}const i=t.getSelectedItem();if(i){const s=t.indexOfItem(i);t.scrollToIndex(s);e=i.getId()}return e})};a.prototype.onHide=function(){this.removeFocus();const t=r.call(this);t?.setFakeFocus();this._iNavigateIndex=-1};a.prototype.getValueHelpIcon=function(){if(this.getUseAsValueHelp()){return"sap-icon://slim-arrow-down"}else{return null}};a.prototype.getAriaAttributes=function(t){return{contentId:this.getId()+"-List",ariaHasPopup:"listbox",roleDescription:null,valueHelpEnabled:false,autocomplete:this.getUseFirstMatch()?"both":"none"}};a.prototype.shouldOpenOnClick=function(){return!this.getFilterList()};a.prototype.isFocusInHelp=function(){return false};a.prototype.isSingleSelect=function(t){return true};a.prototype.shouldOpenOnNavigate=function(){return!t.prototype.isSingleSelect.apply(this)};a.prototype.isNavigationEnabled=function(t){return this.getItems().length>0};a.prototype.onConnectionChange=function(){this._iNavigateIndex=-1};a.prototype.getListBinding=function(){const t=r.call(this);return t&&t.getBinding("items")};a.prototype.getRelevantContexts=function(t){const e=this.getListBinding();const i=e.getAllCurrentContexts?e.getAllCurrentContexts():e.getContexts();return i.filter(e=>{const i=t.checkDescription?e.getProperty("text"):e.getProperty("key");return h.call(this,i,t.value)})};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/content/FixedListItem", ["sap/ui/core/ListItem"],function(e){"use strict";const t=e.extend("sap.ui.mdc.valuehelp.content.FixedListItem",{metadata:{library:"sap.ui.mdc",properties:{groupKey:{type:"any",group:"Appearance",defaultValue:null},groupText:{type:"string",group:"Appearance",defaultValue:null}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/content/MDCTable", ["sap/ui/mdc/valuehelp/base/FilterableListContent","sap/ui/mdc/util/loadModules","sap/ui/mdc/util/Common","sap/base/Log","sap/ui/core/Element","sap/ui/mdc/enums/TableSelectionMode","sap/ui/mdc/enums/TableType","sap/ui/mdc/enums/ValueHelpSelectionType","sap/ui/mdc/enums/TableRowCountMode","sap/base/util/restricted/_throttle","sap/ui/mdc/util/DensityHelper"],function(e,t,i,o,n,s,l,a,r,h,p){"use strict";const c=e.extend("sap.ui.mdc.valuehelp.content.MDCTable",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.IDialogContent"],properties:{forceBind:{type:"boolean",defaultValue:false}},aggregations:{table:{type:"sap.ui.mdc.Table",multiple:false}},events:{},defaultAggregation:"table"}});c.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oObserver.observe(this,{aggregations:["table"]});this._bRebindTable=false};c.prototype._setTableSelectionState=function(){this._bSelectionIsUpdating=true;const e=this._getAllCurrentContexts();if(e){this._oTable._setSelectedContexts(e.filter(function(e){return this._isContextSelected(e,this.getConditions())}.bind(this)))}this._bSelectionIsUpdating=false};c.prototype.handleConditionsUpdate=function(){if(!this._bIgnoreNextConditionChange){this._setTableSelectionState()}else{this._bIgnoreNextConditionChange=false}};c.prototype._handleUpdateFinished=function(e){if(this._oTable){this._handleRowBinding();if(!this._bQueryingContexts){this._setTableSelectionState()}}};c.prototype._handleUpdateFinishedThrottled=h(c.prototype._handleUpdateFinished,100,{leading:false});c.prototype._handleRowBinding=function(){const e=this._oTable.getRowBinding();if(e){this._resolvePromise("listBinding",e)}};c.prototype.observeChanges=function(t){if(t.name==="table"){const e=t.child;if(t.mutation==="remove"){this._oTable.detachEvent("_bindingChange",this._handleUpdateFinishedThrottled,this);this._oTable.detachEvent("selectionChange",this._handleSelectionChange,this);this._oTable=null}else{this._oTable=e;p.syncDensity(this._oTable);this._addPromise("listBinding");this._handleRowBinding();if(this._oTable.getAutoBindOnInit()){o.warning("Usage of autobound tables may lead to unnecessary requests.")}else if(this.getForceBind()){this._bRebindTable=true}e.addDelegate({onmouseover:function(e){const t=n.closestTo(e.target);if(t&&t.isA("sap.m.ColumnListItem")){t.setType("Active")}}});this._oTable.initialized().then(function(){this._oTable.attachEvent("_bindingChange",this._handleUpdateFinishedThrottled,this);this._oTable.attachEvent("selectionChange",this._handleSelectionChange,this)}.bind(this))}return}e.prototype.observeChanges.apply(this,arguments)};c.prototype._getAllCurrentContexts=function(){const e=this._oTable&&this._oTable.getRowBinding();if(e){return e.getAllCurrentContexts?e.getAllCurrentContexts():e.getContexts()}return undefined};c.prototype._handleSelectionChange=function(e){if(!this._bSelectionIsUpdating){this._bQueryingContexts=true;const e=this._getAllCurrentContexts();const t=e&&this._oTable.getSelectedContexts();this._bQueryingContexts=false;if(e){const i=this.getConditions();let o=i;let n=false;e.forEach(function(e){const s=this._findConditionsForContext(e,i);const l=!!s.length;const a=t.indexOf(e)>=0;if(!l&&a){const t=this.getItemFromContext(e);const i=t&&this.createCondition(t.key,t.description,t.payload);o=this.isSingleSelect()?[i]:o.concat(i);n=true}else if(l&&!a){o=o.filter(function(e){return s.indexOf(e)===-1});n=true}}.bind(this));if(n){this._prepareSelect(o,a.Set)}}}};c.prototype._prepareSelect=function(e,t){let i=typeof t==="string"&&t;i=i||(t?a.Add:a.Remove);this._bIgnoreNextConditionChange=true;this._fireSelect({type:i,conditions:e})};c.prototype._getTable=function(){return this._oTable};c.prototype.getContent=function(){return this._retrievePromise("wrappedContent",function(){return t(["sap/ui/layout/FixFlex","sap/m/VBox","sap/m/ScrollContainer"]).then(function(e){const t=e[0];const i=e[1];const o=e[2];if(!this._oContentLayout){this._oFilterBarVBox=new i(this.getId()+"-FilterBarBox",{visible:"{$this>/_filterBarVisible}"});this._oFilterBarVBox.addStyleClass("sapMdcValueHelpPanelFilterbar");this._oFilterBarVBox._oWrapper=this;this._oFilterBarVBox.getItems=function(){const e=this._oWrapper._getPriorityFilterBar.call(this._oWrapper);const t=e?[e]:[];return t};this._oTableBox=new i(this.getId()+"-TB",{height:"100%"});this._oTableBox.addStyleClass("sapMdcValueHelpPanelTableBox");this._oTableBox._oWrapper=this;this._oTableBox.getItems=function(){const e=this._oWrapper._oTable._isOfType(l.ResponsiveTable)?this._oWrapper._oScrollContainer:this._oWrapper._oTable;const t=e?[e]:[];return t};this._oContentLayout=new t(this.getId()+"-FF",{minFlexSize:200,fixContent:this._oFilterBarVBox,flexContent:this._oTableBox});this._oScrollContainer=new o(this.getId()+"-SC",{height:"calc(100% - 0.5rem)",width:"100%",vertical:true});this._oScrollContainer._oWrapper=this;this._oScrollContainer.getContent=function(){const e=[];const t=this._oWrapper&&this._oWrapper._oTable;if(t){e.push(t)}return e}}this.setAggregation("displayContent",this._oContentLayout);if(!this._getPriorityFilterBar()){return this._createDefaultFilterBar().then(function(){this._oFilterBarVBox.invalidate();return this._oContentLayout}.bind(this))}return this._oContentLayout}.bind(this))}.bind(this))};c.prototype.getListBinding=function(){const e=this.getTable();return e&&e.getRowBinding()};c.prototype._configureTable=function(){if(this._oTable){const t=e.prototype.isSingleSelect.apply(this);const i=this._oTable._getType();const o=this._getPriorityFilterBar();if(o&&this._oTable.getFilter()!==o.getId()){this._oTable.setFilter(o)}if(!this._oTable.getHeader()){this._oTable.setHeader(this._oResourceBundle.getText("valuehelp.TABLETITLENONUMBER"))}const n=t?s.SingleMaster:s.Multi;if(this._oTable.getSelectionMode()===s.None){this._oTable.setSelectionMode(n)}if(this._oTable.getSelectionMode()!==n){throw new Error("Table selectionMode needs to be "+n)}const a=this._oTable._isOfType(l.Table);if(a){const e=i.getRowCountMode();if(e===r.Auto){i.setRowCount(3)}}}};c.prototype.onShow=function(){return e.prototype.onShow.apply(this,arguments)};c.prototype.onBeforeShow=function(t){this._configureTable();return Promise.resolve(e.prototype.onBeforeShow.apply(this,arguments)).then(function(){const e=this.getTable();if(e){const i=e.isTableBound();const o=i&&e._oTable.getShowOverlay();if(this._bRebindTable||o){e.rebind();this._bRebindTable=false}else if(t){if(e._isOfType(l.ResponsiveTable)){this._oScrollContainer.scrollTo(0,0)}else if(i){return e.scrollToIndex(0)}}}}.bind(this))};c.prototype.getScrollDelegate=function(){if(!this.isTypeahead()&&this._oScrollContainer){return this._oScrollContainer.getScrollDelegate()}return e.prototype.getScrollDelegate.apply(this,arguments)};c.prototype.isQuickSelectSupported=function(){return true};c.prototype.setParent=function(t){e.prototype.setParent.apply(this,arguments)};c.prototype.isSingleSelect=function(){if(this._oTable){if(this._oTable.getSelectionMode()===s.Multi){return false}else{return true}}else{return e.prototype.isSingleSelect.apply(this,arguments)}};c.prototype.exit=function t(o){i.cleanup(this,["_oContentLayout","_oFilterBarVBox","_oTableBox","_oResourceBundle","_oScrollContainer","_oTableHelper","_bSelectionIsUpdating","_sTableType","_oUITableSelectionPlugin","_oTable","_bRebindTable","_mKnownContexts","_bIgnoreNextConditionChange","_bQueryingContexts"]);e.prototype.exit.apply(this,arguments)};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/content/MTable", ["sap/ui/mdc/valuehelp/base/FilterableListContent","sap/ui/mdc/condition/FilterConverter","sap/ui/mdc/util/loadModules","sap/m/library","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/FilterProcessor","sap/ui/mdc/util/Common","sap/base/strings/formatMessage","sap/base/util/merge","sap/ui/mdc/enums/ValueHelpSelectionType","sap/base/Log","sap/ui/core/Element"],function(e,t,i,s,n,o,a,l,r,h,c,u,d){"use strict";const p=s.ListMode;const g=s.Sticky;const f=e.extend("sap.ui.mdc.valuehelp.content.MTable",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.ITypeaheadContent","sap.ui.mdc.valuehelp.IDialogContent"],properties:{},aggregations:{table:{type:"sap.m.Table",multiple:false}},events:{contentUpdated:{}},defaultAggregation:"table"}});f.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oObserver.observe(this,{aggregations:["table"]});this._addPromise("listBinding");this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._oMResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._iNavigateIndex=-1;this._oFirstItemResult={}};f.prototype.getValueHelpIcon=function(){if(this.getUseAsValueHelp()){return"sap-icon://slim-arrow-down"}else{return null}};function m(){if(this._oTable){const t=this._oTable.getItems();const i=this.getConditions();const s=this.isSingleSelect()&&!e.prototype.isSingleSelect.apply(this);const n=this.isTypeahead()&&!!this.getFilterValue()&&this._iNavigateIndex===-1&&!!this._oFirstItemResult.result&&(this.isSingleSelect()&&i.length===0||!this.isSingleSelect());const o=this._oFirstItemResult.result;const a=this.getParent().isOpen();t.forEach(function(e){const t=this._getListItemBindingContext(e);const l=this.isValueHelpDelegateInitialized()?this.getItemFromContext(t):{key:undefined};if(s&&this._oTable.indexOfItem(e)!==this._iNavigateIndex){e.setSelected(false)}else{e.setSelected(this._isContextSelected(t,i))}if(this._oTable.indexOfItem(e)===this._iNavigateIndex||n&&l.key===o.key||e.getSelected()){if(a&&!e.hasStyleClass("sapMLIBFocused")){this._oTable.setFakeFocus(e)}e.addStyleClass("sapMLIBSelected").updateSelectedDOM(true,e.$());this._oFirstItemResult.index=this._oTable.indexOfItem(e)}else{if(a&&e.hasStyleClass("sapMLIBFocused")){this._oTable.setFakeFocus()}if(!e.getSelected()&&e.hasStyleClass("sapMLIBSelected")){e.removeStyleClass("sapMLIBSelected").updateSelectedDOM(false,e.$())}}}.bind(this))}y.call(this)}function _(){if(!this._oUpdateSelectionPromise&&!this.isDestroyed()){this._oUpdateSelectionPromise=new Promise(e=>{this._iUpdateSelectionTimeout=setTimeout(()=>{if(!this.isDestroyed()){m.call(this)}e()},0)})}return this._oUpdateSelectionPromise}function y(){if(this._iUpdateSelectionTimeout){clearTimeout(this._iUpdateSelectionTimeout);this._iUpdateSelectionTimeout=null;delete this._oUpdateSelectionPromise}}f.prototype.onBeforeShow=function(t){if(t){return Promise.resolve(e.prototype.onBeforeShow.apply(this,arguments)).then(function(){const e=this.getListBinding();const t=this.getListBindingInfo();const i=e&&e.isSuspended();const s=!e&&t&&t.suspended;if((i||s)&&!this.isTypeahead()){return undefined}return this.applyFilters()}.bind(this))}return undefined};f.prototype.applyFilters=function(){if(this._iNavigateIndex>=0){this._iNavigateIndex=-1;this.removeFocus();this.setProperty("conditions",[],true)}const e=function(){if(!this.isDestroyed()){return this.applyFilters()}}.bind(this);const t=this.getListBinding();const i=this.isValueHelpDelegateInitialized();let s;if(!t||!i){s=Promise.all([this._retrievePromise("listBinding"),this.awaitValueHelpDelegate()]).then(e)}if(!i||!this.isTypeahead()&&!this.isContainerOpen()&&t.isSuspended()){return undefined}if(!s){const e=this.getValueHelpDelegate();const i=this.getValueHelpInstance();const n=this.getListBindingInfo();const o=n&&n.length;e.updateBindingInfo(i,this,n);e.updateBinding(i,t,n,this);s=Promise.resolve(e.checkListBindingPending(i,t,o))}this._addPromise("applyFilters",s);return s.catch(function(e){if(e.canceled){u.error("sap.ui.mdc.ValueHelp - Error during applyFilters:",e.message);return}throw e}).finally(function(){const e=this._retrievePromise("applyFilters");e?.getInternalPromise().then(e=>{if(!this._bNavigateInitialize){const e=this.getValueHelpDelegate().getFirstMatch(this.getValueHelpInstance(),this);this._oFirstItemResult={result:this.getItemFromContext(e),filterValue:this.getFilterValue(),index:-1};F.call(this,e)}});return e&&e.getInternalPromise()}.bind(this))};f.prototype._handleSelectionChange=function(e){const t=this.isTypeahead();if(!t||!this.isSingleSelect()){const i=e.getParameters();const s=i.listItems||i.listItem&&[i.listItem];const n=s.map(function(e){const t=this._getListItemBindingContext(e);const i=this.getItemFromContext(t);return i&&this.createCondition(i.key,i.description,i.payload)}.bind(this));this._fireSelect({type:i.selected?c.Add:c.Remove,conditions:n});if(t){this.fireConfirm()}}};f.prototype._handleItemPress=function(e){const t=e.getParameter("listItem");const i=this._getListItemBindingContext(t);const s=this.getItemFromContext(i);const n=this._getTable();const o=n.getMode()===p.SingleSelectMaster;const a=o?t.getSelected():!t.getSelected();t.setSelected(a);const l=a?c.Add:c.Remove;const r=this.createCondition(s.key,s.description,s.payload);this._fireSelect({type:l,conditions:[r]});if(this.isTypeahead()){this.fireConfirm({close:true})}};f.prototype._handleUpdateFinished=function(){if(this.getParent().isOpen()){_.apply(this).then(()=>{if(this._bScrollToSelectedItem){const e=this._getTable();if(e&&this.isTypeahead()&&this.isSingleSelect()){const t=this._iNavigateIndex>=0?e.getItems()[this._iNavigateIndex]:e.getSelectedItem();if(t){this._handleScrolling(t)}}this._bScrollToSelectedItem=false}})}};f.prototype._getTable=function(){return this._oTable};f.prototype.onShow=function(t){const i=this._getTable();if(i){if(!i.hasStyleClass("sapMComboBoxList")){i.addStyleClass("sapMComboBoxList")}let t=this.isTypeahead()?p.SingleSelectMaster:p.SingleSelectLeft;if(!e.prototype.isSingleSelect.apply(this)&&i.getMode()!==t){t=p.MultiSelect}if(i.getMode()===p.None){i.setMode(t)}if(i.getMode()!==t){throw new Error("Table selection mode needs to be "+t)}}return e.prototype.onShow.apply(this,arguments).then(e=>Promise.resolve(this._oUpdateSelectionPromise).then(()=>{if(i&&this.isTypeahead()&&this.isSingleSelect()){let e;if(this._iNavigateIndex>=0){e=i.getItems()[this._iNavigateIndex]}else if(this._oFirstItemResult&&this._oFirstItemResult.index>=0){e=i.getItems()[this._oFirstItemResult.index]}else{e=i.getSelectedItem()}if(e){this._handleScrolling(e);return e.getId()}else{this._bScrollToSelectedItem=true}}}))};f.prototype.onHide=function(){e.prototype.onHide.apply(this,arguments);const t=this.getTable();if(t){this.removeFocus();t?.setFakeFocus();if(t.hasStyleClass("sapMComboBoxList")){t.removeStyleClass("sapMComboBoxList")}}this._iNavigateIndex=-1;this._bScrollToSelectedItem=false};f.prototype.handleConditionsUpdate=function(e){_.call(this)};f.prototype.getContent=function(){if(!this.isTypeahead()){return this._retrievePromise("wrappedContent",function(){return i(["sap/ui/layout/FixFlex","sap/m/VBox","sap/m/Panel","sap/m/ScrollContainer","sap/ui/model/resource/ResourceModel"]).then(function(e){const t=e[0];const i=e[1];const s=e[2];const n=e[3];const o=e[4];if(!this._oContentLayout&&!this.isDestroyed()){this._oFilterBarVBox=new i(this.getId()+"-FilterBarBox");this._oFilterBarVBox.addStyleClass("sapMdcValueHelpPanelFilterbar");this._oFilterBarVBox._oWrapper=this;this._oFilterBarVBox.getItems=function(){return[this._oWrapper._getPriorityFilterBar.call(this._oWrapper)]};this.setModel(new o({bundleName:"sap/ui/mdc/messagebundle",async:false}),"$i18n");const e=function(e){const t=0;if(t===0){e=this.getModel("$i18n").getResourceBundle().getText("valuehelp.TABLETITLENONUMBER")}return r(e,t)};this._oTablePanel=new s(this.getId()+"-TablePanel",{expanded:true,height:"100%",headerText:{parts:["$i18n>valuehelp.TABLETITLE"],formatter:e}});this._oTablePanel.addStyleClass("sapMdcTablePanel");this._oContentLayout=new t(this.getId()+"-FF",{minFlexSize:200,fixContent:this._oFilterBarVBox,flexContent:this._oTablePanel});this._oScrollContainer=new n(this.getId()+"-SC",{height:"100%",width:"100%",vertical:true});this._oScrollContainer._oWrapper=this;this._oScrollContainer.getContent=function(){const e=[];const t=this._oWrapper&&this._oWrapper._oTable;if(t){e.push(t)}return e};this._oTablePanel.addContent(this._oScrollContainer)}this.setAggregation("displayContent",this._oContentLayout);const a=this._getPriorityFilterBar();if(!a){return this._createDefaultFilterBar().then(function(){return this._oContentLayout}.bind(this))}return this._oContentLayout}.bind(this))}.bind(this))}return this._oTable};f.prototype.getItemForValue=function(e){if(!e.checkKey&&e.parsedValue&&!e.checkDescription){return null}if(e.checkKey&&!this.getKeyPath()){throw new Error("MTable: KeyPath missing! "+this.getId())}if(e.checkDescription&&!this.getDescriptionPath()){throw new Error("MTable: DescriptionPath missing! "+this.getId())}e.caseSensitive=e.caseSensitive||this.getCaseSensitive();const t=S.call(this);const i=this.getValueHelpDelegate();const s=this.getValueHelpInstance();const n=i&&i.getFilterConditions(s,this,e);return Promise.all([t,n]).then(function(t){const i=t[0];const s=t[1];let n;if(!i){const t=this.getTable();const i=t.getParent()?.getParent();if(t.getItems().length>0&&this.getUseFirstMatch()&&i?.isOpen()){n=this._oFirstItemResult.filterValue===e.value?this._oFirstItemResult.result:undefined}if(!n){n=I.call(this,e,t.getItems(),s)}}if(!n){n=this._loadItemForValue(e,s)}return n}.bind(this))};function I(e,t,i){if(t.length===0){return}const s=function(e,t){const i=e.isA("sap.ui.model.Context")?e:this._getListItemBindingContext(e);return i&&i.getProperty(t)}.bind(this);let n;let o;const l=b.call(this,e,i);const r=a.apply(t,l,s);if(r.length===1||r.length>1&&this.getUseFirstMatch()){const e=this._getListItemBindingContext(r[0]);const t=this.getItemFromContext(e,{inParameters:n,outParameters:o});return{key:t.key,description:t.description,payload:t.payload}}else if(r.length>1){if(!e.caseSensitive){const s=h({},e);s.caseSensitive=true;return I.call(this,s,t,i)}throw T.call(this,e.exception,true,e.parsedValue||e.value)}}function b(e,i){const s=e.caseSensitive;const a=this.getKeyPath();const l=this.getDescriptionPath();const r=[];if(e.checkKey&&e.hasOwnProperty("parsedValue")){r.push(new n({path:a,operator:o.EQ,value1:e.parsedValue,caseSensitive:s}))}if(e.checkDescription){if(e.hasOwnProperty("parsedDescription")&&e.parsedDescription!==undefined){r.push(new n({path:l,operator:o.EQ,value1:e.parsedDescription,caseSensitive:s}))}else if(e.value){r.push(new n({path:l,operator:o.EQ,value1:e.value,caseSensitive:s}))}}let h=r.length>1?new n({filters:r,and:false}):r[0];if(i){const e=this._getTypesForConditions(i);const s=t.createFilters(i,e,undefined,this.getCaseSensitive());if(s){h=new n({filters:[h,s],and:true})}}return h}function S(){return this._retrievePromise("listBinding").then(function(e){const t=this.getValueHelpDelegate();const i=this.getValueHelpInstance();const s=this.getListBindingInfo();const n=s&&s.length;if(e&&t){return t.checkListBindingPending(i,e,n)}else{return true}}.bind(this))}f.prototype.getListBinding=function(){const e=this._getTable();return e&&e.getBinding("items")};f.prototype.getListBindingInfo=function(){const e=this._getTable();return e&&e.getBindingInfo("items")};f.prototype._loadItemForValue=function(e,t){if(!e.checkKey&&e.parsedValue&&!e.checkDescription){return null}const i=this.getKeyPath();const s=this.getDescriptionPath();const n=this.getUseFirstMatch();const o=this._getTable();const a=o&&o.getBinding("items");const l=a&&a.getPath();const r=this.getValueHelpDelegate();const h=this.getValueHelpInstance();const c="loadItemForValue:"+JSON.stringify([l,i,e.parsedValue||e.value,e.context,e.bindingContext&&e.bindingContext.getPath(),t]);return this._retrievePromise(c,function(){const o=b.call(this,e,t);const c=a.getModel().bindList(l,a.getContext(),undefined,o);c.initialize();return r.executeFilter(h,c,2).then(function(t){const o=t.getContexts();setTimeout(function(){c.destroy()},0);if(o.length&&(o.length<2||n)){return this.getItemFromContext(o[0],{keyPath:i,descriptionPath:s,inParameters:undefined})}else if(e.checkKey&&e.parsedValue===""&&o.length===0){return null}else{const t=T.call(this,e.exception,o.length>1,e.value);throw t}}.bind(this))}.bind(this))};function T(e,t,i){let s;if(t){s=this._oResourceBundle.getText("valuehelp.VALUE_NOT_UNIQUE",[i])}else{s=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[i])}const n=new e(s);n._bNotUnique=t;return n}f.prototype.isValidationSupported=function(e){return true};f.prototype.navigate=function(e){const t=this.getParent().isOpen();if(!t&&this._iNavigateIndex<0&&!this._bNavigateInitialize){this._bNavigateInitialize=true;this.onShow(true).then(t=>{this.navigate(e)});return}this._bNavigateInitialize=false;const i=this.getListBinding();if(!i||!i.getLength()){return S.call(this).then(function(t){if(!t&&i.getLength()!==0){return this.navigate(e)}return false}.bind(this))}const s=this.isSingleSelect();const n=this._getTable();const o=n.getItems();const a=this._iNavigateIndex>=0?o[this._iNavigateIndex]:n.getSelectedItem();const l=o.length;let r=0;let h=false;if(a){r=o.indexOf(a);r=r+e}else if(e>=0){r=e-1}else{r=l+e}if(e===9999){r=l-1}if(e===-9999){r=0}if(!s){if(this.getParent().isOpen()&&n.getMode()===p.MultiSelect){n.focus();return}}let c;if(r<0){r=0;c=true;h=true}else if(r>=l-1){r=l-1;c=false}else{c=e>=0}const u=function(){while(o[r]&&o[r].isA("sap.m.GroupHeaderListItem")){if(c){r++}else{r--}}};if(!t){u();if(r<0||r>l-1){c=!c;h=r<0;r=r<0?0:l-1;u()}}const d=o[r];if(d){if(d!==a||this._iNavigateIndex!==r&&!h){let e;const i=[];this._iNavigateIndex=r;if(t){this._handleScrolling(d);n.setFakeFocus(d);n.addStyleClass("sapMListFocus")}if(!d.isA("sap.m.GroupHeaderListItem")){const t=this._getListItemBindingContext(d);const s=this.getItemFromContext(t);e=s&&this.createCondition(s.key,s.description,s.payload);i.push(e)}this.setProperty("conditions",i,true);_.call(this);this.fireNavigated({condition:e,itemId:d.getId(),leaveFocus:false})}else if(h){if(s){this._iNavigateIndex=-1}this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:h})}}};f.prototype.isNavigationEnabled=function(e){if(e===1||e===-1){return true}else{return false}};f.prototype._handleScrolling=function(e){const t=this.getScrollDelegate();if(t){const t=this._getTable();const i=!isNaN(e)?e:t.indexOfItem(e);t.scrollToIndex(i).catch(function(e){});return true}return false};f.prototype.getScrollDelegate=function(){if(this._oScrollContainer){return this._oScrollContainer.getScrollDelegate()}return e.prototype.getScrollDelegate.apply(this,arguments)};f.prototype.removeFocus=function(){const e=this.getTable();if(e){e.removeStyleClass("sapMListFocus")}};f.prototype.getAriaAttributes=function(e){const t=this.getTable();const i=this.isTypeahead();const s=this.getUseAsValueHelp();let n=null;if(e!==1&&(i&&s||!i)){const e=v.apply(this);n=e.getText("MULTICOMBOBOX_ARIA_ROLE_DESCRIPTION")}return{contentId:t&&t.getId(),ariaHasPopup:"listbox",roleDescription:n,valueHelpEnabled:!i,autocomplete:this.getUseFirstMatch()?"both":"none"}};function v(){if(!this._oResourceBundleM){this._oResourceBundleM=sap.ui.getCore().getLibraryResourceBundle("sap.m")}return this._oResourceBundleM}f.prototype.getContainerConfig=function(){return{"sap.ui.mdc.valuehelp.Popover":{getContentHeight:function(){const e=this._getTable();const t=e&&e.getDomRef();return t&&Math.round(t.getBoundingClientRect().height)}.bind(this),getFooter:function(){return this._retrievePromise("footer",function(){return this._retrievePromise("listBinding").then(function(e){const t=this.getListBindingInfo();const s=this.getParent().hasDialog();if(s&&t&&t.length){return i(["sap/m/Button","sap/m/Toolbar","sap/m/ToolbarSpacer"]).then(function(e){const t=e[0];const i=e[1];const s=e[2];const n=new t(this.getId()+"-showAllItems",{text:this._oMResourceBundle.getText("INPUT_SUGGESTIONS_SHOW_ALL"),press:function(){this.fireRequestSwitchToDialog()}.bind(this)});const o=[new s(this.getId()+"-Spacer")].concat(n);const a=new i(this.getId()+"-TB",{content:o});return a}.bind(this))}}.bind(this))}.bind(this))}.bind(this)}}};function C(){if(this._oTable&&this.getParent()){const e=this._oTable.getSticky();if(!e||e.length===0){this._oTable.setSticky([g.ColumnHeaders])}}}f.prototype.setParent=function(t){e.prototype.setParent.apply(this,arguments);C.call(this)};f.prototype.observeChanges=function(t){if(t.name==="config"){C.call(this)}if(t.name==="items"&&t.mutation==="ready"){this._resolvePromise("listBinding",t.bindingInfo.binding)}if(t.name==="table"){const e=t.child;this._oFirstItemResult={};if(t.mutation==="remove"){this._oObserver.unobserve(e);e.removeDelegate(this._oTableDelegate);this._oTable.detachItemPress(this._handleItemPress,this);this._oTable.detachSelectionChange(this._handleSelectionChange,this);this._oTable.detachUpdateFinished(this._handleUpdateFinished,this);this._oTable=null;this._removePromise("footer");this._addPromise("listBinding")}else{this._oTable=e;this._oTable.addStyleClass("sapMdcValueHelpMTable");C.call(this);this._oTable.attachItemPress(this._handleItemPress,this);this._oTable.attachSelectionChange(this._handleSelectionChange,this);this._oTable.attachUpdateFinished(this._handleUpdateFinished,this);this._oTableDelegate=this._oTableDelegate||{onsapprevious:this._handleTableEvent,onsapnext:this._handleTableEvent,cellClick:this._handleTableEvent};e.addDelegate(this._oTableDelegate,true,this);const i=e.getBinding("items");if(i){this._resolvePromise("listBinding",i)}else{this._oObserver.observe(t.child,{bindings:["items"]})}}}e.prototype.observeChanges.apply(this,arguments)};f.prototype._handleTableEvent=function(e){if(!this.isTypeahead()){return}const t=this._getTable();const i=d.closestTo(e.target);switch(e.type){case"sapprevious":if(i.isA("sap.m.ListItemBase")){if(t.indexOfItem(i)===0){this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:true});e.preventDefault();e.stopPropagation();e.stopImmediatePropagation(true)}}break;default:break}};f.prototype.isQuickSelectSupported=function(){return true};f.prototype.isSingleSelect=function(){const t=this._getTable();if(t&&t.getMode()!==p.None){if(t.getMode()===p.MultiSelect){return false}else{return true}}else{return e.prototype.isSingleSelect.apply(this,arguments)}};f.prototype.onConnectionChange=function(){this._iNavigateIndex=-1;this._oFirstItemResult={}};f.prototype.exit=function(){y.call(this);l.cleanup(this,["_sTableWidth","_oTable","_oScrollContainer","_oContentLayout","_oTablePanel","_oFilterBarVBox","_oMResourceBundle","_oResourceBundle","_oTableDelegate","_oFirstItemResult"]);e.prototype.exit.apply(this,arguments)};f.prototype.getRelevantContexts=function(e){const t=this.getListBinding();const i=t.getAllCurrentContexts?t.getAllCurrentContexts():t.getContexts();return i};function F(e){if(!this.getUseFirstMatch()||!this._oFirstItemResult||!this._oFirstItemResult.result||!this._oFirstItemResult.filterValue){return}const t=this.createCondition(this._oFirstItemResult.result.key,this._oFirstItemResult.result.description,this._oFirstItemResult.result.payload);const i=this._oTable.getItems();let s;for(let t=0;t<i.length;t++){const n=i[t];if(this._getListItemBindingContext(n)===e){s=n.getId();break}}this.fireTypeaheadSuggested({condition:t,filterValue:this._oFirstItemResult.filterValue,itemId:s})}return f});
sap.ui.require.preload({
	"sap/ui/mdc/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.mdc","type":"library","embeds":[],"applicationVersion":{"version":"1.120.31"},"title":"UI5 library: sap.ui.mdc","description":"UI5 library: sap.ui.mdc","ach":"CA-UI5-MDC","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.120","libs":{"sap.ui.core":{"minVersion":"1.120.31"},"sap.m":{"minVersion":"1.120.31"},"sap.ui.layout":{"minVersion":"1.120.31","lazy":true}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.mdc.Table","sap.ui.mdc.FilterBar","sap.ui.mdc.field.FieldBase","sap.ui.mdc.field.FieldInput","sap.ui.mdc.field.FieldMultiInput","sap.ui.mdc.valuehelp.base.DefineConditionPanel","sap.ui.mdc.Field","sap.ui.mdc.FilterField","sap.ui.mdc.MultiValueField","sap.ui.mdc.link.Panel","sap.ui.mdc.Chart","sap.ui.mdc.p13n.PersistenceProvider"],"elements":["sap.ui.mdc.table.Column","sap.ui.mdc.table.CreationRow","sap.ui.mdc.table.DragDropConfig","sap.ui.mdc.table.TableTypeBase","sap.ui.mdc.table.GridTableType","sap.ui.mdc.table.ResponsiveTableType","sap.ui.mdc.table.RowSettings","sap.ui.mdc.chart.Item","sap.ui.mdc.chart.ChartSelectionDetails","sap.ui.mdc.chart.ChartToolbar","sap.ui.mdc.chart.ChartTypeButton","sap.ui.mdc.chart.DrillBreadcrumbs","sap.ui.mdc.chart.SelectionDetailsActions","sap.ui.mdc.field.CustomFieldInfo","sap.ui.mdc.field.FieldInfoBase","sap.ui.mdc.field.ListFieldHelpItem","sap.ui.mdc.filterbar.aligned.FilterItemLayout","sap.ui.mdc.Link","sap.ui.mdc.link.LinkItem","sap.ui.mdc.link.PanelItem","sap.ui.mdc.link.SemanticObjectUnavailableAction","sap.ui.mdc.link.SemanticObjectMapping","sap.ui.mdc.link.SemanticObjectMappingItem","sap.ui.mdc.field.MultiValueFieldItem","sap.ui.mdc.ValueHelp","sap.ui.mdc.valuehelp.Popover","sap.ui.mdc.valuehelp.Dialog","sap.ui.mdc.valuehelp.content.Bool","sap.ui.mdc.valuehelp.content.Conditions","sap.ui.mdc.valuehelp.content.FixedList","sap.ui.mdc.valuehelp.content.FixedListItem","sap.ui.mdc.valuehelp.content.MDCTable","sap.ui.mdc.valuehelp.content.MTable"],"types":["sap.ui.mdc.TableType","sap.ui.mdc.TableP13Mode","sap.ui.mdc.GrowingMode","sap.ui.mdc.RowAction","sap.ui.mdc.RowCountMode","sap.ui.mdc.SelectionMode","sap.ui.mdc.FilterExpression","sap.ui.mdc.MultiSelectMode"],"interfaces":["sap.ui.mdc.IFilterSource","sap.ui.mdc.IFilter","sap.ui.mdc.IxState","sap.ui.mdc.valuehelp.ITypeaheadContent","sap.ui.mdc.valuehelp.IDialogContent","sap.ui.mdc.valuehelp.ITypeaheadContainer","sap.ui.mdc.valuehelp.IDialogContainer"]}}}}'
});
//# sourceMappingURL=library-preload.js.map
