/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/p13n/AbstractContainer","sap/m/p13n/AbstractContainerItem","sap/m/p13n/SelectionPanel","./GroupView","sap/ui/model/Filter","sap/m/Button","sap/m/Bar","sap/m/ToolbarSpacer","sap/m/Select","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/m/SearchField","sap/m/OverflowToolbarLayoutData","sap/ui/core/Item","sap/m/library","sap/ui/model/json/JSONModel"],function(t,e,i,n,s,o,r,a,h,c,u,l,p,g,d,_){"use strict";const w=d.BarDesign;const y=t.extend("sap.ui.mdc.p13n.panels.AdaptFiltersPanel",{metadata:{library:"sap.ui.mdc",properties:{itemFactory:{type:"function"},enableReorder:{type:"boolean",defaultValue:true}},events:{change:{}}},renderer:{apiVersion:2}});y.prototype.GROUP_KEY="group";y.prototype.LIST_KEY="list";y.prototype.P13N_MODEL="$p13n";y.prototype.getVerticalScrolling=function(){return true};y.prototype.applySettings=function(s){this.addView(new e({key:this.LIST_KEY,content:new i(this.getId()+"-listView",{activeColumn:this._getResourceText("p13nDialog.LIST_VIEW_ACTIVE"),change:function(t){this.fireChange();this.getP13nModel().setProperty("/items",t.getSource().getP13nData())}.bind(this)})}));this.addView(new e({key:this.GROUP_KEY,content:new n(this.getId()+"-groupView",{change:function(t){this.fireChange();this.getP13nModel().setProperty("/itemsGrouped",t.getSource().getP13nData())}.bind(this)})}));t.prototype.applySettings.apply(this,arguments);this.getView(this.LIST_KEY).getContent().setEnableReorder(this.getEnableReorder());const o=this._getQuickFilter();const h=this._getViewSwitch();const c=this._getShowHideBtn();const u=new r({contentMiddle:[o,new a,c,h]});u.setDesign(w.SubHeader);this.setHeader(u);const l=new r({contentMiddle:[this._getSearchField()]});l.addStyleClass("sapUiMDCAdaptFiltersSearchBar");l.setDesign(w.SubHeader);this.setSubHeader(l);this.addStyleClass("sapUiMDCAdaptFiltersPanel")};y.prototype.setItemFactory=function(t){this.setProperty("itemFactory",t);this.getViews().forEach(function(e){const i=e.getContent();i.setItemFactory(t)});return this};y.prototype.switchView=function(e){const i=e;t.prototype.switchView.call(this,i);this._getShowHideBtn().setVisible(!this._isCustomView());this._getViewSwitch().setSelectedKey(this.getCurrentViewKey());if(!this._isCustomView(e)){this.showFactory(this.getCurrentViewContent()._getShowFactory())}this._filterByModeAndSearch()};y.prototype.addCustomView=function(t){const i=t.item;const n=i.getKey();const s=t.content;const o=t.search;const r=t.selectionChange;const a=t.filterSelect;if(!n){throw new Error("Please provide an item of type sap.m.SegmentedButtonItem with a key")}if(this._oViewSwitch){this._oViewSwitch.attachSelectionChange(function(t){if(r){r(t.getParameter("item").getKey())}if(this._isCustomView()){if(o instanceof Function){o(this._getSearchField().getValue())}if(a instanceof Function){a(this._getQuickFilter().getSelectedKey())}}}.bind(this))}if(o instanceof Function){this._getSearchField().attachLiveChange(function(t){if(this._isCustomView()){o(this._getSearchField().getValue())}}.bind(this))}if(a instanceof Function){this._getQuickFilter().attachChange(function(t){if(this._isCustomView()){a(this._getQuickFilter().getSelectedKey())}}.bind(this))}this.addView(new e({key:n,content:s.addStyleClass("sapUiMDCPanelPadding")}));const h=this._getViewSwitch();h.addItem(i)};y.prototype.showFactory=function(t){if(this.getCurrentViewContent().showFactory){this.getCurrentViewContent().showFactory(t)}};y.prototype.getSelectedFields=function(){return this.getCurrentViewContent().getSelectedFields()};y.prototype.setGroupExpanded=function(t,e){this.getView(this.GROUP_KEY).getContent().setGroupExpanded(t,e)};y.prototype.setP13nModel=function(t){this.setModel(t,this.P13N_MODEL);this.getView(this.LIST_KEY).getContent().setP13nData(t.getProperty("/items"));this.getView(this.GROUP_KEY).getContent().setP13nData(t.getProperty("/itemsGrouped"));this._filterByModeAndSearch()};y.prototype.setP13nData=function(t){const e=this.getP13nModel();if(!e){this.setP13nModel(new _(t))}else{e.setData(t);this.getView(this.LIST_KEY).getContent().setP13nData(e.getProperty("/items"));this.getView(this.GROUP_KEY).getContent().setP13nData(e.getProperty("/itemsGrouped"))}};y.prototype.restoreDefaults=function(){this._getSearchField().setValue("");this._filterByModeAndSearch()};y.prototype.getP13nModel=function(){return this.getModel(this.P13N_MODEL)};y.prototype._getShowHideBtn=function(){const t=this._getResourceText("filterbar.ADAPT_SHOW_VALUE");const e=this._getResourceText("filterbar.ADAPT_HIDE_VALUE");if(!this._oShowHideBtn){this._oShowHideBtn=new o({press:function(i){this.showFactory(!this.getCurrentViewContent()._getShowFactory());const n=i.oSource;const s=n.getText()===t?e:t;n.setText(s)}.bind(this)})}this._oShowHideBtn.setText(!this._isCustomView()&&this.getCurrentViewContent()._getShowFactory()?e:t);return this._oShowHideBtn};y.prototype._getQuickFilter=function(){if(!this._oGroupModeSelect){this._oGroupModeSelect=new h({items:[new g({key:"all",text:this._getResourceText("p13nDialog.GROUPMODE_ALL")}),new g({key:"visible",text:this._getResourceText("p13nDialog.GROUPMODE_VISIBLE")}),new g({key:"active",text:this._getResourceText("p13nDialog.GROUPMODE_ACTIVE")}),new g({key:"visibleactive",text:this._getResourceText("p13nDialog.GROUPMODE_VISIBLE_ACTIVE")}),new g({key:"mandatory",text:this._getResourceText("p13nDialog.GROUPMODE_MANDATORY")})],tooltip:this._getResourceText("p13nDialog.QUICK_FILTER"),change:this._onGroupModeChange.bind(this)})}return this._oGroupModeSelect};y.prototype._getSearchField=function(){if(!this._oSearchField){this._oSearchField=new l(this.getId()+"-searchField",{liveChange:[this._filterByModeAndSearch,this],width:"100%"});this._oSearchField.setPlaceholder(this._getResourceText("p13nDialog.ADAPT_FILTER_SEARCH"))}return this._oSearchField};y.prototype.getInitialFocusedControl=function(){return this._getSearchField()};y.prototype._onGroupModeChange=function(t){this._sModeKey=t.getParameters().selectedItem.getKey();this._filterByModeAndSearch()};y.prototype._getViewSwitch=function(){if(!this._oViewSwitch){this._oViewSwitch=new c({items:[new u({tooltip:this._getResourceText("filterbar.ADAPT_LIST_VIEW"),icon:"sap-icon://list",key:this.LIST_KEY}),new u({tooltip:this._getResourceText("filterbar.ADAPT_GROUP_VIEW"),icon:"sap-icon://group-2",key:this.GROUP_KEY})],selectionChange:function(t){if(this.getCurrentViewKey()===this.LIST_KEY){this.getCurrentViewContent()._removeMoveButtons()}const e=t.getParameter("item").getKey();this.switchView(e)}.bind(this)})}return this._oViewSwitch};y.prototype._isCustomView=function(){return this._sCurrentView!=this.GROUP_KEY&&this._sCurrentView!=this.LIST_KEY};y.prototype._filterByModeAndSearch=function(){if(this._isCustomView(this.getCurrentViewKey())){return}this._sSearchString=this._getSearchField().getValue();const t=this._createFilterQuery();this._getSearchField().setValue(this._sSearchString);this.getCurrentViewContent().filterContent(t);return t};y.prototype._getResourceText=function(t){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText(t)};y.prototype._createFilterQuery=function(){let t=[],e=[],i=[];if(this._sSearchString){t=[new s("label","Contains",this._sSearchString),new s("tooltip","Contains",this._sSearchString)];i=new s(t,false)}switch(this._sModeKey){case"visible":e=new s("visible","EQ",true);break;case"active":e=new s("active","EQ",true);break;case"mandatory":e=new s("required","EQ",true);break;case"visibleactive":e=new s([new s("active","EQ",true),new s("visible","EQ",true)],true);break;default:}const n=new s("visibleInDialog","EQ",true);return new s([].concat(i,e,n),true)};y.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._sModeKey=null;this._sSearchString=null};return y});
//# sourceMappingURL=AdaptFiltersPanel.js.map