/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/p13n/BasePanel","sap/m/Label","sap/m/ColumnListItem","sap/m/Select","sap/m/Text","sap/ui/core/Item","sap/m/Button","sap/m/Column","sap/m/Table","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/m/VBox","sap/m/HBox","sap/m/ComboBox","sap/ui/model/Sorter","sap/base/Log","sap/m/library","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/CustomData","sap/ui/thirdparty/jquery","sap/ui/core/library","sap/ui/events/KeyCodes","sap/ui/mdc/enums/ChartItemRoleType","sap/ui/core/InvisibleMessage"],function(e,t,n,o,i,s,r,a,l,h,u,p,g,c,d,m,_,f,I,M,jQuery,y,b,P,v){"use strict";const O=y.ValueState;const C=_.FlexJustifyContent;const B=sap.ui.getCore();const x=e.extend("sap.ui.mdc.p13n.panels.ChartItemPanel",{metadata:{library:"sap.ui.mdc",properties:{panelConfig:{type:"object"}},events:{changeItems:{}}},init:function(){this._bMobileMode=f.system.phone;e.prototype.init.apply(this,arguments);this._bindListItems()},renderer:{apiVersion:2}});x.prototype._setInnerLayout=function(){this._oInnerControl=new p({items:[this._oListControl]});this.setAggregation("_content",this._oInnerControl);this._fnHandleResize=function(){if(this.getParent){let e=null;const t=this.getParent();if(t&&t.$){e=t.$("cont");if(e.children().length>0){const e=this._oInnerControl.$()[0].clientWidth;const t=570;if(!this._bMobileMode&&e<=t){this._switchMobileMode(true)}else if(this._bMobileMode&&e>t){this._switchMobileMode(false)}}}}};if(f.system.desktop){this._sContainerResizeListener=I.register(this._oInnerControl,this._fnHandleResize.bind(this))}};x.prototype._switchMobileMode=function(e){if(this._bMobileMode==e){return}this._bMobileMode=e;if(this._sContainerResizeListener){I.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null}this._oListControl.destroy();this._oDragDropInfo=null;this._oListControl=this._createInnerListControl();this._setInnerLayout();this._bindListItems()};x.prototype._createInnerListControl=function(){const e=this._bMobileMode?this.getId()+"-innerP13nListMobile":this.getId()+"-innerP13nList";const t=new l(e,Object.assign(this._getListControlConfig(),{}));this.setEnableReorder(true);t.addEventDelegate({onAfterRendering:this._onAfterTableRender.bind(this)});return t};x.prototype._onAfterTableRender=function(){if(this._oFocusInfo){if(this._oFocusInfo.oMoveButton){this._oFocusInfo.oMoveButton.focus()}this._oFocusInfo=null}this._mInvalidMap.forEach(function(e,t){if(this._mNamesMap.has(t)){this._mNamesMap.get(t).setValueState(O.Error);this._mNamesMap.get(t).setValue(e)}}.bind(this))};x.prototype._bindListItems=function(e){let t;const n=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");if(this.getPanelConfig()&&this.getPanelConfig().sorter){t=this.getPanelConfig().sorter}else{const e={text:n.getText("chart.PERSONALIZATION_DIALOG_MEASURE_GROUP_HEADER")};const o={text:n.getText("chart.PERSONALIZATION_DIALOG_DIMENSION_GROUP_HEADER")};const i={Aggregatable:e,Groupable:o,Measure:e,Dimension:o};const s=function(e){const t=e.getProperty("kind");return{key:t,text:i[t].text}};const r=function(e,t){if(e===t){return 0}if(e==="MEASURE"||e==="AGGREGATABLE"){return 1}return-1};t=new d("kind",false,s,r)}let o;this._mTemplatesMap=new Map;this._mNamesMap=new Map;this._mInvalidMap=new Map;if(this._bMobileMode){o=this._createListItemMobile}else{o=this._createListItem}this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/items",key:"name",filters:[new h({filters:[new h("visible",u.EQ,true),new h("template",u.EQ,true)],and:false})],factory:o.bind(this),sorter:t},e))};x.prototype._getTemplateComboBox=function(e){const t=new h("visible",u.EQ,false);const n=new window.Intl.Collator;const o=function(e,t){return n.compare(e,t)};const i=new d("label",false,false,o);const r=new c({id:"p13nPanel-templateComboBox-"+e,width:"100%",placeholder:this._getPlaceholderTextForTemplate(e),items:{path:this.P13N_MODEL+">/items",template:new s({key:"{"+this.P13N_MODEL+">name}",text:"{"+this.P13N_MODEL+">label}"}),templateShareable:false,filters:[t,new h("kind",u.EQ,e)],sorter:i},change:[this.onChangeOfTemplateName,this]});this._mTemplatesMap.set(e,r);return r};x.prototype._getPlaceholderTextForTemplate=function(e){const t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");return t.getText("chart.PERSONALIZATION_DIALOG_TEMPLATE_PLACEHOLDER")};x.prototype._getRoleSelect=function(){return new o({width:"100%",selectedKey:"{"+this.P13N_MODEL+">role}",change:[this.onChangeOfRole,this],forceSelection:false,items:{path:this.P13N_MODEL+">availableRoles",templateShareable:false,template:new s({key:"{"+this.P13N_MODEL+">key}",text:"{"+this.P13N_MODEL+">text}"})},visible:{path:this.P13N_MODEL+">availableRoles",formatter:function(e){if(!e){return false}return e.length>1}}})};x.prototype._getNameComboBox=function(e,t,n){const o=new window.Intl.Collator;const i=function(e,t){return o.compare(e,t)};const r=new d("label",false,false,i);const a=new h({filters:[new h("visible",u.EQ,false),new h("name",u.EQ,n)],and:false});return new c(e+"-combo",{width:"100%",items:{path:this.P13N_MODEL+">/items",factory:function(e,t){return new s({key:t.getObject().name,text:t.getObject().label})},templateShareable:false,filters:[a,new h("kind",u.EQ,t)],sorter:r},change:[this.onChangeOfItemName,this],selectedKey:"{"+this.P13N_MODEL+">tempName}",customData:[new M({key:"prevName",value:n}),new M({key:"prevKind",value:t})]})};x.prototype._createListItem=function(e,t){let o;const i=[];if(t.getObject()&&t.getObject().template){i.push(this._getTemplateComboBox(t.getObject().kind))}else{if(t.getObject().name!=t.getObject().tempName){t.getObject().tempName=t.getObject().name}const n=this._getNameComboBox(e,t.getObject().kind,t.getObject().name);i.push(n);i.push(this._getRoleSelect());o=this.getId()+t.getObject().kind+"-RemoveBtn-"+t.getObject().name;i.push(new g({justifyContent:C.End,items:[new r({id:o,press:[this._onPressHide,this],type:"Transparent",icon:"sap-icon://decline",tooltip:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_REMOVE_ENTRY"),customData:[new M({key:"propertyName",value:"{"+this.P13N_MODEL+">name}"}),new M({key:"propertyKind",value:"{"+this.P13N_MODEL+">kind}"})]})]}));this._mNamesMap.set(t.getObject().name,n)}let s;if(t.getObject()&&t.getObject().template){const e=t.getObject().kind;s=new n({cells:i,visible:{path:this.P13N_MODEL+">/items",formatter:function(t){t=t.filter(function(t){return t.visible===false&&t.template===false&&t.kind===e});return t.length!=0}}})}else{s=new n({cells:i})}s.addEventDelegate({onmouseover:this._hoverHandler.bind(this),onfocusin:this._focusHandler.bind(this),onkeydown:this._keydownHandler.bind(this)});return s};x.prototype._createListItemMobile=function(e,t){let o;const i=[];if(t.getObject()&&t.getObject().template){i.push(this._getTemplateComboBox(t.getObject().kind))}else{const n=new p({items:[this._getNameComboBox(e,t.getObject().kind,t.getObject().name),this._getRoleSelect()]});o=t.getObject().kind+"-RemoveBtn-"+t.getObject().name;i.push(n)}const s=new g({justifyContent:C.End,items:[new r({id:o,press:[this._onPressHide,this],type:"Transparent",icon:"sap-icon://decline",visible:{path:this.P13N_MODEL+">template",formatter:function(e){return!e}},customData:[new M({key:"propertyName",value:"{"+this.P13N_MODEL+">name}"}),new M({key:"propertyKind",value:"{"+this.P13N_MODEL+">kind}"})]})]});i.push(s);let a;if(t.getObject()&&t.getObject().template){const e=t.getObject().kind;a=new n({cells:i,visible:{path:this.P13N_MODEL+">/items",formatter:function(t){t=t.filter(function(t){return t.visible===false&&t.template===false&&t.kind===e});return t.length!=0}}})}else{a=new n({cells:i})}a.addEventDelegate({onmouseover:this._hoverHandler.bind(this),onfocusin:this._focusHandler.bind(this),onkeydown:this._keydownHandler.bind(this)});return a};x.prototype._keydownHandler=function(t){if((t.metaKey||t.ctrlKey)&&t.keyCode===b.D){let e;const n=B.byId(t.currentTarget.id);if(this._bMobileMode){e=n.getCells()[1].getItems()[n.getCells()[1].getItems().length-1]}else{e=n.getCells()[2].getItems()[n.getCells()[2].getItems().length-1]}if(e){this._onPressHide(t,e);t.preventDefault()}}else{e.prototype._keydownHandler.apply(this,arguments)}};x.prototype._focusHandler=function(t){const n=B.byId(t.target.id);if(n instanceof r){return}e.prototype._focusHandler.apply(this,arguments)};x.prototype._handleActivated=function(e){const t=this._getModelItemByTableItem(e);if(t&&t.template){this.removeMoveButtons()}this._oHoveredItem=e;this._updateEnableOfMoveButtons(e,false);this._addMoveButtons(e);this._setMoveButtonVisibility(true)};x.prototype.onChangeOfItemName=function(e){const t=e.getSource().data().prevName;const n=e.getSource().data().prevKind;const o=e.getSource().getSelectedKey();const i=this._getP13nModel().getProperty("/items").find(function(e){return e.name===t&&e.kind===n});const s=this._getP13nModel().getProperty("/items").find(function(e){return e.name===o&&e.kind===n});this.removeMoveButtons();if(i&&s){i.visible=false;s.visible=true;i.tempName=i.name;s.role=i.role;this._moveItemsByIndex(this._getItemIndex(s),this._getItemIndex(i),true);this._refreshP13nModel();this._fireChangeItems();this._updateVisibleIndexes();this._mInvalidMap.delete(t);this._mInvalidMap.delete(o)}else if(e.getSource()&&e.getSource()instanceof c){this._mInvalidMap.set(e.getSource().data("prevName"),e.getSource().getValue());e.getSource().setValueState(O.Error)}};x.prototype._getItemIndexByNameAndKind=function(e,t){const n=this._getP13nModel().getProperty("/items");const o=n.find(function(n){return n.name===e&&n.kind===t&&!n.template});return this._getItemIndex(o)};x.prototype._getItemIndex=function(e){return this._getP13nModel().getProperty("/items").indexOf(e)};x.prototype.removeMoveButtons=function(){const e=this._getMoveButtonContainer();if(e){e.removeItem(this._getMoveBottomButton());e.removeItem(this._getMoveDownButton());e.removeItem(this._getMoveUpButton());e.removeItem(this._getMoveTopButton())}};x.prototype.getP13nData=function(){const e=this._getCleanP13nItems();this._getP13nModel().setProperty("/items",e);return e};x.prototype._getMoveButtonContainer=function(){if(this._oMoveUpButton&&this._oMoveUpButton.getParent()&&this._oMoveUpButton.getParent().isA("sap.m.FlexBox")){return this._oMoveUpButton.getParent()}return undefined};x.prototype._addMoveButtons=function(e){const t=e;if(!t){return}const n=this._getP13nModel().getProperty(t.getBindingContextPath())?this._getP13nModel().getProperty(t.getBindingContextPath()).template:true;if(t.getCells()&&(t.getCells().length===2||t.getCells().length===3)&&!n){if(this._bMobileMode){t.getCells()[1].insertItem(this._getMoveDownButton(),0);t.getCells()[1].insertItem(this._getMoveUpButton(),0)}else{t.getCells()[2].insertItem(this._getMoveBottomButton(),0);t.getCells()[2].insertItem(this._getMoveDownButton(),0);t.getCells()[2].insertItem(this._getMoveUpButton(),0);t.getCells()[2].insertItem(this._getMoveTopButton(),0)}}};x.prototype._moveSelectedItem=function(){this._oSelectedItem=this._getMoveButtonContainer().getParent();e.prototype._moveSelectedItem.apply(this,arguments)};x.prototype._updateAvailableRolesForItems=function(){const e=this._getP13nModel().getProperty("/items");let t=[];if(this.getPanelConfig()&&this.getPanelConfig().allowedLayoutOptions){t=this.getPanelConfig().allowedLayoutOptions}else{m.warning("No allowedLayoutOptions configured for chart type. This will not show any p13n options!")}e.forEach(function(e){if(!e.availableRoles){return}e.availableRoles=e.availableRoles.filter(function(e){return t.indexOf(e.key)!=-1})});this._getP13nModel().setProperty("/items",e);this._refreshP13nModel()};x.prototype._onPressHide=function(e,t){let n;if(t){n=t.data().propertyName}else{n=e.getSource().data().propertyName}const o=jQuery.extend([],this._getP13nModel().getProperty("/items"),true);o.filter(function(e){return e.name===n}).forEach(function(e){e.visible=false;if(this._mTemplatesMap.has(e.kind)&&this._mTemplatesMap.get(e.kind).getVisible()){this._mTemplatesMap.get(e.kind).focus()}}.bind(this));this._announce(this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_REMOVE_ENTRY_ANNOUNCE"));this._getP13nModel().setProperty("/items",o);this._refreshP13nModel();this._fireChangeItems();this._updateVisibleIndexes()};x.prototype._announce=function(e){const t=y.InvisibleMessageMode;const n=v.getInstance();n.announce(e,t.Assertive)};x.prototype.setP13nData=function(t){t=t.filter(function(e){return!e.template});e.prototype.setP13nData.apply(this,arguments);let n=[];const o=[];this.getP13nData().forEach(function(e,t){if(!e.availableRoles){e.availableRoles=this._getChartItemTextByKey(e.kind)}if(this.getPanelConfig()&&this.getPanelConfig().allowedLayoutOptions){const t=this.getPanelConfig().allowedLayoutOptions;if(t&&t.length>=1){e.availableRoles=e.availableRoles.filter(function(e){return t.indexOf(e.key)!=-1});if(t.indexOf(e.role)===-1){e.role=t[0]}}}e.template=false;e.tempName=e.name;if(!e.visible){o.push(e)}if(!e.index){e.index=t}n.push(e)}.bind(this));n=n.concat(this._getTemplateItems());this._getP13nModel().setProperty("/items",n);this._updateVisibleIndexes()};x.prototype._updateVisibleIndexes=function(){this._mVisibleIndexes=new Map;this._getP13nModel().getProperty("/items").forEach(function(e,t){if(e.template||!e.visible){return}if(this._mVisibleIndexes.has(e.kind)){this._mVisibleIndexes.get(e.kind).push(t)}else{const n=[t];this._mVisibleIndexes.set(e.kind,n)}}.bind(this))};x.prototype.onChangeOfTemplateName=function(e){const t=e.getSource().getSelectedKey();const n=this._getCleanP13nItems().find(function(e){return e.name===t});if(n){n.visible=true;e.getSource().setSelectedKey(undefined);this._refreshP13nModel();const t=this._mVisibleIndexes.has(n.kind)?this._mVisibleIndexes.get(n.kind):[];const o=this._getItemIndexByNameAndKind(n.name,n.kind);let i=t[t.length-1];if(o>i){i+=1}if(i&&o!=i){this._moveItemsByIndex(o,i,true)}else{this._fireChangeItems()}this._mInvalidMap.delete(e.getSource().getValue());this._updateVisibleIndexes()}else if(e.getSource()&&e.getSource()instanceof c){if(e.getSource().getValue()!=""){e.getSource().setValueState(O.Error)}else{e.getSource().setValueState(O.None)}}};x.prototype._refreshP13nModel=function(){this._getP13nModel().refresh(true)};x.prototype._getTemplateItems=function(){const e=[];if(!this.getPanelConfig()||!this.getPanelConfig().templateConfig){return[]}this.getPanelConfig().templateConfig.forEach(function(t){const n={template:true,kind:t.kind};e.push(n)});return e};x.prototype._getListControlConfig=function(){const t=e.prototype._getListControlConfig.apply(this,arguments);if(this._bMobileMode){t.columns=[new a({header:new i({text:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION")+" / "+this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_ROLE")})}),new a]}else{const e=new a({header:new i({text:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION")})});const n=new a({header:new i({text:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_ROLE")})});t.columns=[e,n,new a]}t.mode="None";return t};x.prototype._getCleanP13nItems=function(){return this._getP13nModel().getProperty("/items").filter(function(e){return!e.template})};x.prototype._fireChangeItems=function(){this.fireChangeItems({items:this._getCleanP13nItems().map(function(e){return{columnKey:e.name,visible:e.visible,index:e.index,role:e.role}})});this.fireChange()};x.prototype.onChangeOfRole=function(e){const t=e.getParameter("selectedItem");if(t){let t;if(this._bMobileMode){t=e.getSource().getParent().getParent()}else{t=e.getSource().getParent()}this.fireChange();this._updateEnableOfMoveButtons(t)}this._fireChangeItems()};x.prototype._updateEnableOfMoveButtons=function(e,t){if(!e){return}const n=this._getModelItemByTableItem(e);const o=this._getP13nModel().getProperty("/items").indexOf(n);let i=true,s=true;if(!n||n.template){return}const r=this._mVisibleIndexes.has(n.kind)?this._mVisibleIndexes.get(n.kind):[];if(o==0||r.indexOf(o)===0){i=false}if(r.indexOf(o)===r.length-1){s=false}this._getMoveTopButton().setEnabled(i);this._getMoveUpButton().setEnabled(i);this._getMoveDownButton().setEnabled(s);this._getMoveBottomButton().setEnabled(s);if(t&&(!s||!i)){this._oFocusInfo={oMoveButton:!s?this._getMoveUpButton():this._getMoveDownButton()}}};x.prototype._getListItemFromMoveButton=function(e){if(e&&e.getParent()&&e.getParent().getParent()){return e.getParent().getParent()}return undefined};x.prototype._onPressButtonMoveToTop=function(e){const t=this._getListItemFromMoveButton(e.getSource());if(!t){return}const n=this._getP13nModel().getProperty(t.getBindingContextPath());const o=this._mVisibleIndexes.get(n.kind)[0];this._oSelectedItem=t;this._moveSelectedItem(o)};x.prototype._onPressButtonMoveUp=function(e,t){if(!t){t=this._getListItemFromMoveButton(e.getSource())}if(!t){return}const n=this._getP13nModel().getProperty(t.getBindingContextPath());const o=this._mVisibleIndexes.get(n.kind);const i=this._getP13nModel().getProperty("/items").indexOf(n);this._oSelectedItem=t;const s=o[o.indexOf(i)-1];this._moveSelectedItem(s)};x.prototype._onPressButtonMoveDown=function(e,t){if(!t){t=this._getListItemFromMoveButton(e.getSource())}if(!t){return}const n=this._getP13nModel().getProperty(t.getBindingContextPath());const o=this._mVisibleIndexes.get(n.kind);const i=this._getP13nModel().getProperty("/items").indexOf(n);this._oSelectedItem=t;const s=o[o.indexOf(i)+1];this._moveSelectedItem(s)};x.prototype._onPressButtonMoveToBottom=function(e){const t=this._getListItemFromMoveButton(e.getSource());if(!t){return}const n=this._getP13nModel().getProperty(t.getBindingContextPath());const o=this._mVisibleIndexes.get(n.kind)[this._mVisibleIndexes.get(n.kind).length-1];this._oSelectedItem=t;this._moveSelectedItem(o)};x.prototype._moveTableItem=function(e,t){const n=this._getP13nModel().getProperty("/items");const o=n.indexOf(e.getBindingContext(this.P13N_MODEL).getObject());this._moveItemsByIndex(o,t)};x.prototype._moveItemsByIndex=function(e,t,n){const o=this._getP13nModel().getProperty("/items");t=t<=0?0:Math.min(t,o.length-1);if(t==e){return}o.splice(t,0,o.splice(e,1)[0]);o.forEach(function(e,t){if(!e.template){e.index=t}});this._getP13nModel().setProperty("/items",o);if(!n){this._oSelectedItem=this._oListControl.getItems().find(function(e){const n=this._getModelItemByTableItem(e);return n&&n===o[t]}.bind(this));this._updateEnableOfMoveButtons(this._oSelectedItem,!n);this._handleActivated(this._oSelectedItem)}this._fireChangeItems()};x.prototype._getModelItemByTableItem=function(e){return this._getP13nModel().getProperty(e.getBindingContextPath())};x.prototype._getMoveConfigForTableItem=function(e){const t=this._getModelItemByTableItem(e);if(!t){return undefined}return{currentIndex:this._getP13nModel().getProperty("/items").indexOf(t),aggregationRole:t.kind,template:t.template}};x.prototype._getDragDropConfig=function(){if(!this._oDragDropInfo){const t=e.prototype._getDragDropConfig.apply(this,arguments);t.attachDragStart(this._checkDragStart.bind(this));t.attachDragEnter(this._checkDrag.bind(this));t.attachDragEnd(function(){this._oDraggedItem=null}.bind(this));return t}return this._oDragDropInfo};x.prototype._checkDrag=function(e){const t=e.getParameter("target");const n=this._getMoveConfigForTableItem(t);const o=this._getMoveConfigForTableItem(this._oDraggedItem);if(!n||n.template||o.aggregationRole!=n.aggregationRole){e.preventDefault();return}};x.prototype._checkDragStart=function(e){this._oDraggedItem=e.getParameter("target");this._checkDrag(e)};x.prototype._onRearrange=function(e){const t=e.getParameter("draggedControl");const n=e.getParameter("droppedControl");const o=e.getParameter("dropPosition");const i=this._getMoveConfigForTableItem(t);const s=this._getMoveConfigForTableItem(n);if(!i||i.template||!s){e.preventDefault();return}const r=i.currentIndex;let a=s.currentIndex;if(s.template&&o=="After"){e.preventDefault();return}if(!s.template&&(i.aggregationRole!=undefined&&i.aggregationRole!=s.aggregationRole)){e.preventDefault();return}if(r<a){if(o=="Before"&&a!=0){a-=1}}else if(o=="After"){a+=1}this._moveItemsByIndex(r,a);this._refreshP13nModel();this._updateVisibleIndexes()};x.prototype._getMoveTopButton=function(){if(this._oMoveTopButton&&this._oMoveTopButton.isDestroyed()){this._oMoveTopButton=null}return e.prototype._getMoveTopButton.apply(this,arguments)};x.prototype._getMoveUpButton=function(){if(this._oMoveUpButton&&this._oMoveUpButton.isDestroyed()){this._oMoveUpButton=null}return e.prototype._getMoveUpButton.apply(this,arguments)};x.prototype._getMoveDownButton=function(){if(this._oMoveDownButton&&this._oMoveDownButton.isDestroyed()){this._oMoveDownButton=null}return e.prototype._getMoveDownButton.apply(this,arguments)};x.prototype._getMoveBottomButton=function(){if(this._oMoveBottomButton&&this._oMoveBottomButton.isDestroyed()){this._oMoveBottomButton=null}return e.prototype._getMoveBottomButton.apply(this,arguments)};x.prototype._getChartItemTextByKey=function(e){const t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");const n={Dimension:[{key:P.category,text:t.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY")},{key:P.category2,text:t.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY2")},{key:P.series,text:t.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_SERIES")}],Measure:[{key:P.axis1,text:t.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS1")},{key:P.axis2,text:t.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS2")},{key:P.axis3,text:t.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS3")}]};return n[e]};x.prototype._getResourceTextMDC=function(e,t){this.oResourceBundleMDC=this.oResourceBundleMDC?this.oResourceBundleMDC:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");return e?this.oResourceBundleMDC.getText(e,t):this.oResourceBundleMDC};x.prototype.exit=function(){this._fnSort=null;this.oResourceBundleMDC=null;this._bMobileMode=null;return e.prototype.exit.apply(this,arguments)};x.prototype.onReset=function(){};return x});
//# sourceMappingURL=ChartItemPanel.js.map