/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/p13n/BasePanel","sap/m/Label","sap/base/util/deepEqual","sap/m/CustomListItem","sap/m/List","sap/m/Panel","sap/m/Toolbar","sap/m/Text","sap/ui/core/Icon","sap/ui/core/library","sap/m/HBox","sap/m/library","sap/base/util/merge","sap/m/Title"],function(t,e,i,n,o,s,r,a,l,c,h,p,d,u){"use strict";const g=c.IconColor;const _=p.FlexJustifyContent;const f=p.ListKeyboardMode;const C=t.extend("sap.ui.mdc.p13n.panels.GroupView",{metadata:{library:"sap.ui.mdc",properties:{itemFactory:{type:"function"}}},renderer:{apiVersion:2}});C.prototype.init=function(){t.prototype.init.apply(this,arguments);this.addStyleClass("sapUiMDCGroupView");const e=new n({visible:"{"+this.P13N_MODEL+">groupVisible}",accDescription:{path:this.P13N_MODEL+">groupLabel",formatter:function(t){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("p13nDialog.FILTER_GROUP_DESCRIPTION",[t])}},content:[this._createGroupPanelTemplate()]});this._bShowFactory=true;this.displayColumns();this._aInitializedLists=[];this._setTemplate(e);e.setType("Inactive");this._setMoveButtonVisibility(true)};C.prototype._getShowFactory=function(){return this._bShowFactory};C.prototype.getPanels=function(){const t=[];this._oListControl.getItems().forEach(function(e){t.push(e.getContent()[0])});return t};C.prototype._createGroupPanelTemplate=function(){const t=this.P13N_MODEL;return new s({expandable:true,expanded:{path:this.P13N_MODEL+">group",formatter:function(){if(this.getBindingContext(t)){const e=this.getBindingContext(t).sPath.split("/")[2]==="0";return e}else{return false}}},expand:function(t){const e=t.getSource();const i=e.getContent()[0];this._addInitializedList(i);if(this._getShowFactory()){this._addFactoryControl(i);this.filterContent(this._aCurrentFilters)}}.bind(this),width:"100%",headerToolbar:[new r({content:[new u({wrapping:true,text:"{"+this.P13N_MODEL+">groupLabel}"})]})],content:[this._createGroupListTemplate()]})};C.prototype._createGroupListTemplate=function(){const t=new o({keyboardMode:f.Edit,selectionChange:function(t){const e=t.getParameter("listItem").getBindingContext(this.P13N_MODEL).sPath;const i=this._getP13nModel().getProperty(e);const n=this.getModel(this.P13N_MODEL);if(n&&i){n.setProperty(e+"/selected",i.visible)}const o=this._checkSpecialChangeReason(t.getParameter("selectAll"),t.getParameter("listItems"));this.fireChange({reason:o||(i.visible?this.CHANGE_REASON_ADD:this.CHANGE_REASON_REMOVE),item:i})}.bind(this),showSeparators:"None",mode:"MultiSelect"});t.bindItems(this._getItemsBinding());return t};C.prototype._addFactoryControl=function(t){if(t.getItems().length==0||t.getItems()[0].getContent().length<2){t.getItems().forEach(function(t){const e=t.getBindingContext(this.P13N_MODEL);const i=this.getItemFactory().call(this,e);if(i){t.addContent(i);const e=t.getContent()[0].getItems()[0];e.setLabelFor(i)}if(t.getContent()[0].getItems().length>1){t.getContent()[0].removeItem(1)}}.bind(this))}this.addStyleClass("sapUiMDCAFLabelMarking")};C.prototype._createInnerListControl=function(){const t=new o(this.getId()+"-innerGroupViewList",Object.assign(this._getListControlConfig(),{keyboardMode:f.Edit,mode:"None",infoToolbar:new r,updateStarted:function(t){this._checkAllPanels()}.bind(this)}));return t};C.prototype._getItemsBinding=function(){const t=function(){const t=[new h({width:"100%",justifyContent:_.SpaceBetween,items:[new e({required:"{"+this.P13N_MODEL+">required}",text:"{"+this.P13N_MODEL+">label}"})]})];return new n({selected:"{"+this.P13N_MODEL+">visible}",tooltip:"{"+this.P13N_MODEL+">tooltip}",accDescription:"{"+this.P13N_MODEL+">label}",content:t})}.bind(this);return{path:this.P13N_MODEL+">items",templateShareable:false,template:t()}};C.prototype._getIconTemplate=function(){return new h({width:"18.5%",justifyContent:_.Center,items:[new l({src:"sap-icon://circle-task-2",size:"0.5rem",color:g.Neutral,visible:{path:this.P13N_MODEL+">active",formatter:function(t){if(t){return true}else{return false}}}})]})};C.prototype._loopGroupList=function(t){this._oListControl.getItems().forEach(function(e){const i=e.getContent()[0];const n=i.getContent()[0];this._loopItems(n,function(e,i){t(e,i)})}.bind(this))};C.prototype._loopItems=function(t,e){t.getItems().forEach(function(t){const i=t.getBindingContextPath();const n=this._getP13nModel().getProperty(i).name;e.call(this,t,n)}.bind(this))};C.prototype._removeFactoryControl=function(){this._loopGroupList(function(t,e){if(t.getContent()[1]){t.removeContent(t.getContent()[1]);const e=t.getParent();this._addInitializedList(e);const i=this._getIconTemplate();t.getContent()[0].addItem(i)}}.bind(this));this.removeStyleClass("sapUiMDCAFLabelMarking");return this._aInitializedLists||[]};C.prototype._addInitializedList=function(t){const e=t.getId();if(this._aInitializedLists.indexOf(e)<0){this._aInitializedLists.push(e)}};C.prototype._getInitializedLists=function(){const t=[];this._aInitializedLists.forEach(function(e){const i=sap.ui.getCore().byId(e);if(i){t.push(i)}});return t};C.prototype.getSelectedFields=function(){const t=[];this._oListControl.getItems().forEach(function(e){const i=e.getContent()[0];const n=i.getContent()[0];this._loopItems(n,function(e,i){if(e.getSelected()){t.push(i)}})}.bind(this));return t};C.prototype.filterContent=function(t){if(!this._bInitialized||i(t,this._aCurrentFilters)){return}const e=this._removeFactoryControl();this._oListControl.getItems().forEach(function(i){const n=i.getContent()[0];const o=n.getContent()[0];if(o.getBinding("items")){o.getBinding("items").filter(t,true);this._togglePanelVisibility(n)}if(this._getShowFactory()&&e.indexOf(o.getId())>-1){this._addFactoryControl(o)}}.bind(this));this._aCurrentFilters=t};C.prototype.showFactory=function(t){this._bShowFactory=t;this.displayColumns();if(t){this._getInitializedLists().forEach(function(t){this._addFactoryControl(t)}.bind(this))}else{this._removeFactoryControl()}};C.prototype._checkAllPanels=function(){this._oListControl.getItems().forEach(function(t){const e=t.getContent()[0];this._togglePanelVisibility(e)}.bind(this))};C.prototype.setGroupExpanded=function(t,e){this._oListControl.getItems().forEach(function(i){const n=i.getContent()[0];const o=n.getBindingContext(this.P13N_MODEL).sPath;const s=this._getP13nModel().getProperty(o);if(s.group===t){n.setExpanded(e)}},this)};C.prototype._togglePanelVisibility=function(t){const e=t.getContent()[0];const i=t.getBindingContext(this.P13N_MODEL);if(i){const t=i.sPath;const n=this._getP13nModel().getProperty(t);n.groupVisible=e.getVisibleItems().length<1?false:true;this._getP13nModel().setProperty(t,n)}};C.prototype.getItems=function(){return this._oListControl.getItems()};C.prototype._checkFirstGroup=function(){if(!this._bInitialized&&this._oListControl&&this._oListControl.getItems().length>0){this._bInitialized=true;const t=this._oListControl.getItems()[0].getContent()[0].getContent()[0];this._addFactoryControl(t);this._addInitializedList(t)}};C.prototype.displayColumns=function(){const t=this._oListControl.getInfoToolbar().removeAllContent();t.forEach(function(t){t.destroy()});this._oListControl.getInfoToolbar().addContent(new a({width:"75%",text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("p13nDialog.LIST_VIEW_COLUMN")}).addStyleClass("firstColumnPadding"));if(!this._bShowFactory){this._oListControl.getInfoToolbar().addContent(new a({textAlign:"Center",width:"25%",text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("p13nDialog.LIST_VIEW_ACTIVE")}).addStyleClass("firstColumnPadding"))}};C.prototype.setP13nData=function(t){this._getP13nModel().setProperty("/itemsGrouped",t);if(!this._bInitialized){this._bindListItems()}this._checkFirstGroup();this._checkAllPanels()};C.prototype.getP13nData=function(t){let e=this._getP13nModel().getProperty("/itemsGrouped");if(t){e=e.filter(function(t){return t[this.PRESENCE_ATTRIBUTE]}.bind(this))}return e};C.prototype._bindListItems=function(){this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/itemsGrouped",templateShareable:false,key:"group",template:this.getAggregation("_template").clone()}))};C.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._aInitializedLists=null;this._bShowFactory=false;this._bInitialized=false};return C});
//# sourceMappingURL=GroupView.js.map