/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./GridTableType","./ResponsiveTableType","sap/base/Log","sap/m/library","sap/m/Label","sap/ui/model/json/JSONModel","sap/ui/model/base/ManagedObjectModel","sap/ui/core/Control","sap/ui/core/Core","sap/ui/mdc/enums/TableType"],function(e,t,n,i,o,a,s,l,r,p){"use strict";const u=l.extend("sap.ui.mdc.table.Column",{metadata:{library:"sap.ui.mdc",defaultAggregation:"template",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minWidth:{type:"float",group:"Behavior",defaultValue:8},header:{type:"string"},headerVisible:{type:"boolean",group:"Misc",defaultValue:true},hAlign:{type:"sap.ui.core.HorizontalAlign",defaultValue:"Begin"},importance:{type:"sap.ui.core.Priority",group:"Behavior",defaultValue:"None"},dataProperty:{type:"string"},propertyKey:{type:"string"},required:{type:"boolean",defaultValue:false}},aggregations:{template:{type:"sap.ui.core.Control",multiple:false},creationTemplate:{type:"sap.ui.core.Control",multiple:false},extendedSettings:{type:"sap.ui.mdc.table.ColumnSettings",multiple:false}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t);e.openEnd();if(t._oColumnHeaderLabel){e.renderControl(t._oColumnHeaderLabel.getLabel())}e.close("div")}}});u.prototype.init=function(){this.mSkipPropagation={template:true,creationTemplate:true};this._oManagedObjectModel=new s(this);this._oSettingsModel=new a({width:this.getWidth(),calculatedWidth:null,p13nWidth:null,resizable:false})};u.prototype.getInnerColumn=function(){const e=this.getTable();if(e&&(!this._oInnerColumn||this._oInnerColumn.isDestroyed())){this._oInnerColumn=this._createInnerColumn()}return this._oInnerColumn};u.prototype._createInnerColumn=function(){const n=this.getTable();let o;const a={parts:[{path:"$this>/width"},{path:"$columnSettings>/calculatedWidth"},{path:"$columnSettings>/p13nWidth"}],formatter:function(e,t,n){return n||t||e}};const s={parts:[{path:"$this>/tooltip"},{path:"$this>/header"},{path:"$this>/headerVisible"},{path:"$sap.ui.mdc.Table>/useColumnLabelsAsTooltips"}],formatter:function(e,t,n,i){if(e||!i){return e}return n?t:""}};this._readP13nValues();if(n._isOfType(p.ResponsiveTable)){o=t.createColumn(this.getId()+"-innerColumn",{width:a,autoPopinWidth:"{$this>/minWidth}",hAlign:"{$this>/hAlign}",header:this._getColumnHeaderLabel(s),importance:{parts:[{path:"$this>/importance"},{path:"$this>/extendedSettings/importance"},{path:"$this>/extendedSettings/@className"}],formatter:function(e,t,n){if(t&&n==="sap.ui.mdc.table.ResponsiveColumnSettings"){return t}else{return e}}},popinDisplay:"{= ${$this>/headerVisible} ? 'Inline' : 'WithoutHeader' }",mergeDuplicates:{parts:[{path:"$this>/extendedSettings/mergeFunction"},{path:"$this>/extendedSettings/@className"}],formatter:function(e,t){return e&&t==="sap.ui.mdc.table.ResponsiveColumnSettings"}},mergeFunctionName:{parts:[{path:"$this>/extendedSettings/mergeFunction"},{path:"$this>/extendedSettings/@className"}],formatter:function(e,t){if(t==="sap.ui.mdc.table.ResponsiveColumnSettings"){return e}}}})}else{o=e.createColumn(this.getId()+"-innerColumn",{width:a,minWidth:{path:"$this>/minWidth",formatter:function(e){return Math.round(e*parseFloat(i.BaseFontSize))}},hAlign:"{$this>/hAlign}",label:this._getColumnHeaderLabel(),resizable:"{$columnSettings>/resizable}",autoResizable:"{$columnSettings>/resizable}",tooltip:s,template:this.getTemplateClone()});o.setCreationTemplate(this.getCreationTemplateClone())}o.setModel(this._oManagedObjectModel,"$this");o.setModel(this._oSettingsModel,"$columnSettings");o.setHeaderMenu(n.getId()+"-columnHeaderMenu");return o};const h=l.extend("sap.ui.mdc.table.ColumnHeaderLabel",{metadata:{final:true,aggregations:{label:{type:"sap.m.Label",multiple:false}},associations:{column:{type:"sap.ui.mdc.table.Column"}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t);e.style("width","100%");e.openEnd();e.renderControl(r.byId(t.getColumn()));e.close("div")}},getText:function(){return this.getLabel().getText()},clone:function(){return this.getLabel().clone()},getRequired:function(){return this.getLabel().getRequired()},getAccessibilityInfo:function(){return this.getLabel().getAccessibilityInfo()}});u.prototype._getColumnHeaderLabel=function(e){const t=this.getTable();if(t&&(!this._oColumnHeaderLabel||this._oColumnHeaderLabel.isDestroyed())){this._oColumnHeaderLabel=new h({column:this,label:new o({width:"{= ${$this>/headerVisible} ? '100%' : '0px' }",text:"{$this>/header}",textAlign:"{$this>/hAlign}",tooltip:e?e:"",wrapping:{parts:[{path:"$this>/headerVisible"},{path:"$columnSettings>/resizable"}],formatter:function(e,n){return t._isOfType(p.ResponsiveTable)&&e&&!n}},wrappingType:t._isOfType(p.ResponsiveTable)?"Hyphenated":null,required:"{$this>/required}"})})}return this._oColumnHeaderLabel};u.prototype.getTemplateClone=function(){const e=this.getTable();const t=this.getTemplate();if(e&&t&&(!this._oTemplateClone||this._oTemplateClone.isDestroyed())){this._oTemplateClone=t.clone();if(!e._isOfType(p.ResponsiveTable)){if(this._oTemplateClone.setWrapping){this._oTemplateClone.setWrapping(false)}if(this._oTemplateClone.setRenderWhitespace){this._oTemplateClone.setRenderWhitespace(false)}}}return this._oTemplateClone};u.prototype.getCreationTemplateClone=function(){const e=this.getTable();const t=this.getCreationTemplate();if(e&&t&&(!this._oCreationTemplateClone||this._oCreationTemplateClone.isDestroyed())){this._oCreationTemplateClone=t.clone();if(!e._isOfType(p.ResponsiveTable)){if(this._oCreationTemplateClone.setWrapping){this._oCreationTemplateClone.setWrapping(false)}if(this._oCreationTemplateClone.setRenderWhitespace){this._oCreationTemplateClone.setRenderWhitespace(false)}}}return this._oCreationTemplateClone};u.prototype.setHeader=function(e){this.setProperty("header",e,true);const t=this.getDomRef();if(t){t.textContent=this.getHeader()}return this};u.prototype.getPropertyKey=function(){const e=this.getProperty("propertyKey");return e||this.getDataProperty()};u.prototype.setTooltip=function(e){if(e&&e.isA&&e.isA("sap.ui.core.TooltipBase")){n.error("The control sap.ui.mdc.table.Column allows only strings as tooltip, but given is "+e);return this}return l.prototype.setTooltip.apply(this,arguments)};u.prototype._onTableChange=function(e){if(e.getParameter("name")==="enableColumnResize"){this._readTableSettings()}};u.prototype._readTableSettings=function(){const e=this.getTable();this._oSettingsModel.setProperty("/resizable",e.getEnableColumnResize())};u.prototype.setParent=function(e){const t=this.getTable();l.prototype.setParent.apply(this,arguments);if(this._bIsBeingMoved){return}this._disconnectFromTable(t);this._connectToTable()};u.prototype._connectToTable=function(){const e=this.getTable();if(!e){return}this._calculateColumnWidth();this._readP13nValues();this._readTableSettings();e.attachEvent("_change",this._onTableChange,this)};u.prototype._disconnectFromTable=function(e){e=e||this.getTable();if(!e){return}if(this._oInnerColumn){this._oInnerColumn.destroy()}};u.prototype._onModifications=function(){this._readP13nValues()};u.prototype._calculateColumnWidth=function(){const e=this.getTable();if(!e||!e.getEnableAutoColumnWidth()||!this.isPropertyInitial("width")){return}const t=e.getPropertyHelper();if(t){t.calculateColumnWidth(this).then(function(e){this._oSettingsModel.setProperty("/calculatedWidth",e)}.bind(this))}else{e._fullyInitialized().then(this._calculateColumnWidth.bind(this))}};u.prototype._readP13nValues=function(){const e=this.getTable();const t=e.getCurrentState().xConfig;const n=this.getPropertyKey();if(t instanceof Promise){t.then(this._readP13nValues.bind(this));return}const i=t&&t.aggregations&&t.aggregations.columns&&t.aggregations.columns[n]&&t.aggregations.columns[n].width;this._oSettingsModel.setProperty("/p13nWidth",i)};u.prototype.getTable=function(){const e=this.getParent();return e&&e.isA("sap.ui.mdc.Table")?e:null};u.prototype.exit=function(){this._disconnectFromTable();["_oManagedObjectModel","_oSettingsModel","_oInnerColumn","_oTemplateClone","_oCreationTemplateClone","_oColumnHeaderLabel"].forEach(function(e){if(this[e]){this[e].destroy();delete this[e]}},this)};return u});
//# sourceMappingURL=Column.js.map