/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./TableTypeBase","sap/m/table/Util","sap/ui/mdc/enums/TableRowCountMode"],function(t,e,o){"use strict";let n,i,s,l,a,r,u;const c=t.extend("sap.ui.mdc.table.GridTableType",{metadata:{library:"sap.ui.mdc",properties:{rowCountMode:{type:"sap.ui.mdc.enums.TableRowCountMode",defaultValue:o.Auto},rowCount:{type:"int",defaultValue:10},selectionLimit:{type:"int",defaultValue:200},showHeaderSelector:{type:"boolean",defaultValue:true},fixedColumnCount:{type:"int",defaultValue:0}}}});c.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this.disableColumnResize()};c.prototype.updateTableByProperty=function(t,e){const n=this.getInnerTable();if(!n){return}if(t==="rowCountMode"){let t=n.getRowMode();let i=false;if(t&&(e===o.Fixed&&!t.isA("sap.ui.table.rowmodes.Fixed")||e===o.Auto&&!t.isA("sap.ui.table.rowmodes.Auto"))){i=t.getHideEmptyRows();t.destroy();t=null}if(!t){const t=e===o.Fixed?a:r;n.setRowMode((new t).setHideEmptyRows(i))}this._updateTableRowCount()}else if(t==="rowCount"){this._updateTableRowCount()}else if(t==="fixedColumnCount"){n.setFixedColumnCount(e)}};c.prototype._updateTableRowCount=function(){const t=this.getInnerTable();if(this.getRowCountMode()===o.Fixed){t.getRowMode().setRowCount(this.getRowCount())}else{t.getRowMode().setMinRowCount(this.getRowCount())}};c.prototype.loadUiTableLibrary=function(){if(!this._oGridTableLibLoaded){this._oGridTableLibLoaded=sap.ui.getCore().loadLibrary("sap.ui.table",true)}return this._oGridTableLibLoaded};c.prototype.loadModules=function(){if(n){return Promise.resolve()}return this.loadUiTableLibrary().then(function(){return new Promise(function(t,e){sap.ui.require(["sap/ui/table/Table","sap/ui/table/Column","sap/ui/table/RowAction","sap/ui/table/RowActionItem","sap/ui/table/rowmodes/Fixed","sap/ui/table/rowmodes/Auto","sap/ui/table/RowSettings"],function(e,o,c,d,p,g,h){n=e;i=o;s=c;l=d;a=p;r=g;u=h;t()},function(){e("Failed to load some modules")})})})};c.prototype.createTable=function(t){const e=this.getTable();if(!e||!n){return null}const o=new n(t,this.getTableSettings());o._setHideStandardTooltips(true);return o};c.prototype.getTableSettings=function(){const e=this.getTable();const o={SingleMaster:"RowOnly"};const n={enableBusyIndicator:true,enableColumnReordering:false,threshold:this.getThreshold(),noData:e._getNoDataText(),extension:[e._oToolbar],ariaLabelledBy:[e._oTitle],rowSettingsTemplate:this.getRowSettingsConfig(),selectionMode:"None",selectionBehavior:{path:"$sap.ui.mdc.Table>/selectionMode",formatter:function(t){return o[t]}}};if(e.hasListeners("rowPress")){n.cellClick=[this._onCellClick,this]}return Object.assign({},t.prototype.getTableSettings.apply(this,arguments),n)};c.prototype._onCellClick=function(t){this.callHook("RowPress",this.getTable(),{bindingContext:t.getParameter("rowBindingContext")})};c.createColumn=function(t,e){return new i(t,e)};c.prototype.enableColumnResize=function(){const t=this.getTable();const e=this.getInnerTable();if(!t||!e){return}e.getColumns().forEach(function(t){t.setResizable(true);t.setAutoResizable(true)});e.detachColumnResize(this._onColumnResize,this);e.attachColumnResize(this._onColumnResize,this)};c.prototype.disableColumnResize=function(){const t=this.getTable();const e=this.getInnerTable();if(!t||!e){return}e.getColumns().forEach(function(t){t.setResizable(false);t.setAutoResizable(false)});e.detachColumnResize(this._onColumnResize,this)};c.prototype._onColumnResize=function(t){const e=this.getTable();const o=this.getInnerTable();const n=t.getParameter("column");const i=t.getParameter("width");const s=o.indexOfColumn(n);const l=e.getColumns()[s];this.callHook("ColumnResize",e,{column:l,width:i})};c.prototype.updateRowSettings=function(){const t=this.getInnerTable();if(!t){return}t.destroyRowSettingsTemplate();t.setRowSettingsTemplate(new u(this.getRowSettingsConfig()));this.updateRowActions()};c.prototype.updateRowActions=function(){const t=this.getInnerTable();if(!t){return}const e=this.getTable().getRowSettings();this._removeRowActions();if(!e||!e.isBound("rowActions")&&(!e.getRowActions()||e.getRowActions().length==0)){return}const o=e.getAllActions();if("templateInfo"in o){const t=o.templateInfo;o.items.template=new l({type:t.type,visible:t.visible,icon:t.icon,text:t.text,press:[this._onRowActionPress,this]});delete o.templateInfo}else{o.items=o.items.map(function(t){const e=new l({type:t.isBound("type")?t.getBindingInfo("type"):t.getType(),visible:t.isBound("visible")?t.getBindingInfo("visible"):t.getVisible(),icon:t.isBound("icon")?t.getBindingInfo("icon"):t._getIcon(),text:t.isBound("text")?t.getBindingInfo("text"):t._getText(),press:[this._onRowActionPress,this]});e.data("rowAction",t);return e},this)}t.setRowActionTemplate(new s(o));t.setRowActionCount(e.getRowActionCount())};c.prototype._removeRowActions=function(){const t=this.getInnerTable();const e=t.getRowActionTemplate();if(e){e.destroy()}t.setRowActionTemplate();t.setRowActionCount()};c.prototype._onRowActionPress=function(t){const e=this.getTable();const o=t.getParameter("item");const n=e.getRowSettings();const i=n.getAllActions();if(n.isBound("rowActions")){const t=i.items.model;const e=o.getBindingContext(t);if(!this._oRowActionItem){this._oRowActionItem=i.items.template.clone()}this._oRowActionItem.setBindingContext(e,i.items.model);this._oRowActionItem.setModel(this.getModel(t),t);n.addDependent(this._oRowActionItem)}else{this._oRowActionItem=o.data("rowAction")}this.callHook("Press",this._oRowActionItem,{bindingContext:t.getParameter("row").getBindingContext()})};c.prototype.prepareRowPress=function(){const t=this.getInnerTable();if(t&&!t.hasListeners("cellClick")){t.attachEvent("cellClick",this._onCellClick,this)}};c.prototype.cleanupRowPress=function(){const t=this.getTable();if(!t.hasListeners("rowPress")){this.getInnerTable()?.detachEvent("cellClick",this._onCellClick,this)}};c.prototype.removeToolbar=function(){const t=this.getInnerTable();if(t){t.removeExtension(this.getTable()._oToolbar)}};c.prototype.scrollToIndex=function(t){const o=this.getTable();const n=this.getInnerTable();if(!n){return Promise.reject()}return new Promise(function(i){if(t===-1){t=e.isEmpty(o.getRowBinding())?0:o.getRowBinding().getLength()}if(n._setFirstVisibleRowIndex(t)){n.attachEventOnce("rowsUpdated",function(){i()})}else{i()}})};c.prototype.getRowBinding=function(){const t=this.getInnerTable();return t?t.getBinding():undefined};c.prototype.bindRows=function(t){const e=this.getInnerTable();if(e){e.bindRows(t)}};c.prototype.isTableBound=function(){const t=this.getInnerTable();return t?t.isBound("rows"):false};c.prototype.insertFilterInfoBar=function(t,e){const o=this.getInnerTable();if(o){o.insertExtension(t,1);if(!o.getAriaLabelledBy().includes(e)){o.addAriaLabelledBy(e)}}};c.prototype.updateSortIndicator=function(t,e){t.getInnerColumn().setSorted(e!=="None");t.getInnerColumn().setSortOrder(e)};c.prototype.getContextMenuParameters=function(t){return{bindingContext:this.getInnerTable().getContextByIndex(t.getParameters().rowIndex),column:this.getTable().getColumns()[t.getParameters().columnIndex]}};c.prototype.getTableStyleClasses=function(){const e=t.prototype.getTableStyleClasses.apply(this,arguments);if(this.getRowCountMode()===o.Auto){e.push("sapUiMdcTableFitContainer")}return e};return c});
//# sourceMappingURL=GridTableType.js.map