/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["../util/PropertyHelper","sap/m/table/Util","sap/ui/base/Object"],function(e,t,r){"use strict";const n=e.extend("sap.ui.mdc.table.PropertyHelper",{constructor:function(t,r,n){e.call(this,t,r,Object.assign({filterable:true,sortable:true,propertyInfos:true,groupable:{type:"boolean",forComplexProperty:{valueIfNotAllowed:false}},key:{type:"boolean",forComplexProperty:{valueIfNotAllowed:false}},unit:{type:"PropertyReference"},text:{type:"PropertyReference"},exportSettings:{type:"object",default:{value:{},ignoreIfNull:true},forComplexProperty:{allowed:true}},clipboardSettings:{type:{template:{type:"string"}},default:{value:{},ignoreIfNull:true},forComplexProperty:{allowed:true}},visualSettings:{type:{widthCalculation:{type:{minWidth:{type:"int",default:{value:2}},maxWidth:{type:"int",default:{value:19}},defaultWidth:{type:"int",default:{value:8}},gap:{type:"float",default:{value:0}},includeLabel:{type:"boolean",default:{value:true}},truncateLabel:{type:"boolean",default:{value:true}},verticalArrangement:{type:"boolean",default:{value:false}},excludeProperties:{type:"PropertyReference[]"}},default:{value:{},ignoreIfNull:true}}},default:{value:{}},forComplexProperty:{allowed:true}}},n?{extension:{type:n,default:{value:{}},forComplexProperty:{allowed:true,propagateAllowance:false}}}:{},this._bEnableAggregatableAttribute?{aggregatable:{type:"boolean",forComplexProperty:{valueIfNotAllowed:false}}}:{}))}});n.prototype.prepareProperty=function(t){e.prototype.prepareProperty.apply(this,arguments);if(!t.isComplex()&&!t.typeConfig&&t.dataType&&this.getParent()){const e=this.getParent().getControlDelegate().getTypeMap();t.typeConfig=e.getTypeConfig(t.dataType,t.formatOptions,t.constraints)}Object.defineProperty(t,"getGroupableProperties",{value:function(){return t.getSimpleProperties().filter(function(e){return e.groupable})}})};n.prototype.getGroupableProperties=function(){return this.getProperties().filter(function(e){return e.groupable})};n.prototype.getColumnClipboardSettings=function(e){const t=this.getProperty(e.getPropertyKey());if(!t||t.clipboardSettings===null){return null}const r=t.getSimpleProperties().map(function(e){return e.path});const n=t.getSimpleProperties().map(function(e){return e.typeConfig&&e.typeConfig.typeInstance});const o=t.clipboardSettings.template||Array.from(Array(r.length).keys(),function(e){return"{"+e+"}"}).join(" ");return{properties:r,template:o,types:n}};n.prototype.getColumnExportSettings=function(e){const t=[];if(!r.isObjectA(e,"sap.ui.mdc.table.Column")){return t}const n=this.getProperty(e.getPropertyKey());if(!n){return t}const o=n.exportSettings;if(o===null){return t}const i=[];let p;if(!n.isComplex()){p=l(e,n,o);p.property=n.path;t.push(p);return t}const a=n.getSimpleProperties();if(Object.keys(o).length){p=l(e,n,o);a.forEach(function(e){i.push(e.path)});p.property=i;t.push(p)}else{a.forEach(function(r,n){if(!r.exportSettings){return}const o=l(e,r,r.exportSettings);o.property=r.path;if(n>0){o.columnId=e.getId()+"-additionalProperty"+n}if(r.exportSettings||o.property){t.push(o)}})}return t};function o(e){if(e.indexOf("em")>0){return Math.round(parseFloat(e))}if(e.indexOf("px")>0){return Math.round(parseInt(e)/16)}return""}function l(e,t,r){return Object.assign({columnId:e.getId(),label:t.label,width:o(e.getWidth()),textAlign:e.getHAlign(),type:"String"},r)}n.prototype.calculateColumnWidth=function(e){const t=e.getPropertyKey();const r=e.getTable();return r._getPropertyByNameAsync(t).then(function(t){if(!t){return null}const r=t.visualSettings;if(r&&r.widthCalculation===null){return null}return this._calcColumnWidth(t,e)}.bind(this))};n.prototype._calcColumnWidth=function(e,r){const n=Object.assign({gap:0,includeLabel:true,truncateLabel:true,excludeProperties:[],required:r.getRequired()},e.visualSettings&&e.visualSettings.widthCalculation);const o=r.getParent();if(o&&o._isOfType("TreeTable")&&o.indexOfColumn(r)==0){n.treeColumn=true}let l=[];if(e.isComplex()){l=e.getSimpleProperties().flatMap(function(e){const t=e.visualSettings?e.visualSettings.widthCalculation:undefined;return t===null||n.excludeProperties.includes(e.name)?[]:[[e.typeConfig.typeInstance,t]]})}else{l.push(e.typeConfig.typeInstance)}if(e.unit){n.gap+=2.5}const i=n.includeLabel?r.getHeader()||e.label:"";return t.calcColumnWidth(l,i,n)};return n});
//# sourceMappingURL=PropertyHelper.js.map