/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./TableTypeBase","./utils/Personalization","sap/m/Button","sap/m/plugins/ColumnResizer","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/ui/Device","sap/ui/core/Core","sap/ui/mdc/enums/TableGrowingMode","sap/ui/mdc/enums/TableRowAction"],function(t,e,o,n,i,s,a,l,r,u){"use strict";let p,c,g;const h=t.extend("sap.ui.mdc.table.ResponsiveTableType",{metadata:{library:"sap.ui.mdc",properties:{growingMode:{type:"sap.ui.mdc.enums.TableGrowingMode",defaultValue:r.Basic},showDetailsButton:{type:"boolean",group:"Misc",defaultValue:false},detailsButtonSetting:{type:"sap.ui.core.Priority[]",group:"Behavior"},popinLayout:{type:"sap.m.PopinLayout",group:"Appearance",defaultValue:"Block"}}}});h.prototype.setDetailsButtonSetting=function(t){return this.setProperty("detailsButtonSetting",t,true)};h.prototype.updateTableByProperty=function(t,e){const o=this.getInnerTable();if(!o){return}if(t==="growingMode"){o.setGrowingScrollToLoad(e===r.Scroll);o.setGrowing(e!==r.None)}else if(t==="showDetailsButton"){this._updateShowDetailsButton(o,e)}else if(t==="popinLayout"){o.setPopinLayout(e)}};h.prototype._updateShowDetailsButton=function(t,e){if(e&&!this._oShowDetailsButton){t.getHeaderToolbar().insertEnd(this._getShowDetailsButton(),0);t.attachEvent("popinChanged",this._onPopinChanged,this);t.setHiddenInPopin(this._getImportanceToHide())}else if(!e&&this._oShowDetailsButton){t.detachEvent("popinChanged",this._onPopinChanged,this);t.getHeaderToolbar().removeEnd(this._oShowDetailsButton);t.setHiddenInPopin([]);this._oShowDetailsButton.destroy();delete this._oShowDetailsButton}};h.prototype.loadModules=function(){if(!p){return new Promise(function(t,e){sap.ui.require(["sap/m/Table","sap/m/Column","sap/m/ColumnListItem"],function(e,o,n){p=e;c=o;g=n;t()},function(){e("Failed to load some modules")})})}else{return Promise.resolve()}};h.prototype.createTable=function(t){const e=this.getTable();if(!e||!p){return null}return new p(t,this.getTableSettings())};h.prototype.getTableSettings=function(){const e=this.getTable();return Object.assign({},t.prototype.getTableSettings.apply(this,arguments),{autoPopinMode:true,contextualWidth:"Auto",growing:true,sticky:["ColumnHeaders","HeaderToolbar","InfoToolbar"],itemPress:[this._onItemPress,this],growingThreshold:this.getThreshold(),noData:e._getNoDataText(),headerToolbar:e._oToolbar,ariaLabelledBy:[e._oTitle]})};h.prototype._onItemPress=function(t){this.callHook("RowPress",this.getTable(),{bindingContext:t.getParameter("listItem").getBindingContext()});this._onRowActionPress(t)};h.createColumn=function(t,e){return new c(t,e)};h.prototype.createRowTemplate=function(t){return new g(t,this.getRowSettingsConfig())};h.prototype.updateRowSettings=function(){const t=this.getTable();if(!t||!t._oRowTemplate){return}t._oRowTemplate.unbindProperty("navigated");t._oRowTemplate.unbindProperty("highlight");t._oRowTemplate.unbindProperty("highlightText");t._oRowTemplate.applySettings(this.getRowSettingsConfig());this.updateRowActions()};h.prototype.updateRowActions=function(){const t=this.getTable();const e=this.getRowActionsConfig();const o=t.hasListeners("rowPress")?"Active":"Inactive";t._oRowTemplate.unbindProperty("type");if(!t.getRowSettings()){t._oRowTemplate.setType(o);return}let n,i,s;if("templateInfo"in e){const t=e.templateInfo;s=t.visible.formatter;i=typeof t.visible=="object";n=t.visible}else if(e&&e.items){if(e.items.length==0){t._oRowTemplate.setType(o);return}const a=e.items.find(function(t){return t.getType()=="Navigation"});if(!a&&e.items.length>0){throw new Error("No TableRowAction of type 'Navigation' found. sap.m.Table only accepts TableRowAction of type 'Navigation'.")}t._oRowTemplate.data("rowAction",a);i=a.isBound("visible");n=i?a.getBindingInfo("visible"):a.getVisible();s=n.formatter}if(s){n.formatter=function(t){const e=s(t);return e?u.Navigation:o}}else{n=n?u.Navigation:o}if(i){t._oRowTemplate.bindProperty("type",n)}else{t._oRowTemplate.setProperty("type",n)}};h.prototype.enableColumnResize=function(){const t=this.getTable();const e=this.getInnerTable();if(!t||!e){return}let o=n.getPlugin(e);e.setFixedLayout("Strict");if(!o){o=new n;e.addDependent(o);o.attachColumnResize(this._onColumnResize,this)}else{o.setEnabled(true);o.detachColumnResize(this._onColumnResize,this);o.attachColumnResize(this._onColumnResize,this)}};h.prototype.disableColumnResize=function(){const t=this.getTable();const e=this.getInnerTable();if(!t||!e){return}const o=n.getPlugin(e);if(o){o.setEnabled(false);o.detachColumnResize(this._onColumnResize,this)}};h.prototype._onColumnResize=function(t){const e=this.getTable();const o=this.getInnerTable();const n=t.getParameter("column");const i=t.getParameter("width");const s=o.indexOfColumn(n);const a=e.getColumns()[s];this.callHook("ColumnResize",e,{column:a,width:i})};h.prototype.createColumnResizeMenuItem=function(t,e){const o=n.getPlugin(this.getInnerTable());if(!o){return}if(e.isA("sap.m.table.columnmenu.Menu")){return o.getColumnResizeQuickAction(t.getInnerColumn(),e)}else{return o.getColumnResizeButton(t.getInnerColumn())}};h.prototype._toggleShowDetails=function(t){if(!this._oShowDetailsButton||t===this.bHideDetails){return}const e=this.getInnerTable();this.bHideDetails=t;if(this.bHideDetails){e.setHiddenInPopin(this._getImportanceToHide());this._oShowDetailsButton.setSelectedKey("hideDetails")}else{e.setHiddenInPopin([]);this._oShowDetailsButton.setSelectedKey("showDetails")}};h.prototype._getShowDetailsButton=function(){if(!this._oShowDetailsButton){const t=l.getLibraryResourceBundle("sap.ui.mdc");const e=this.getTable().getId();this.bHideDetails=true;this._oShowDetailsButton=new i(e+"-showHideDetails",{visible:false,selectedKey:"hideDetails",items:[new s({id:e+"-showDetails",icon:"sap-icon://detail-more",key:"showDetails",tooltip:t.getText("table.SHOWDETAILS_TEXT"),press:[function(){this._toggleShowDetails(false)},this]}),new s({id:e+"-hideDetails",icon:"sap-icon://detail-less",key:"hideDetails",tooltip:t.getText("table.HIDEDETAILS_TEXT"),press:[function(){this._toggleShowDetails(true)},this]})]})}return this._oShowDetailsButton};h.prototype.getContextMenuParameters=function(t){const e=t.getParameter("listItem");const o=t.getParameter("column");const n=l.byId(o.getId().replace(/\-innerColumn$/,""));return{bindingContext:e.getBindingContext(this.getInnerTable().getBindingInfo("items").model),column:n}};h.prototype._getImportanceToHide=function(){const t=this.getDetailsButtonSetting()||[];if(t.length){return t}else{return a.system.phone?["Low","Medium"]:["Low"]}};h.prototype._onPopinChanged=function(t){const e=t.getParameter("hasPopin");const o=t.getParameter("hiddenInPopin");const n=t.getSource().getVisibleItems().length;if(n&&(o.length||e&&!this.bHideDetails)){this._oShowDetailsButton.setVisible(true)}else{this._oShowDetailsButton.setVisible(false)}};h.prototype._onRowActionPress=function(t){const e=this.getTable();const o=t.getParameter("listItem");if(o.getType()!=="Navigation"){return}const n=e.getRowSettings();const i=n.getAllActions();if(n.isBound("rowActions")){const t=i.items.model;if(!this._oRowActionItem){this._oRowActionItem=i.items.template.clone()}this._oRowActionItem.setModel(e.getModel(t),t);n.addDependent(this._oRowActionItem)}else{this._oRowActionItem=o.data("rowAction")}this._oRowActionItem.setType("Navigation");this.callHook("Press",this._oRowActionItem,{bindingContext:o.getBindingContext()})};h.prototype.removeToolbar=function(){const t=this.getInnerTable();if(t){t.setHeaderToolbar()}};h.prototype.scrollToIndex=function(t){const e=this.getInnerTable();if(e){return e.scrollToIndex(t)}else{return Promise.reject()}};h.prototype.getRowBinding=function(){const t=this.getInnerTable();return t?t.getBinding("items"):undefined};h.prototype.bindRows=function(t){const e=this.getInnerTable();if(e){e.bindItems(t)}};h.prototype.isTableBound=function(){const t=this.getInnerTable();if(t){return t.isBound("items")}else{return false}};h.prototype.insertFilterInfoBar=function(t,e){const o=this.getInnerTable();if(o){o.setInfoToolbar(t);if(!o.getAriaLabelledBy().includes(e)){o.addAriaLabelledBy(e)}}};h.prototype.updateSortIndicator=function(t,e){t.getInnerColumn().setSortIndicator(e)};h.prototype._onColumnInsert=function(t){const o=this.getTable();const n=this.getInnerTable();if(e.isUserPersonalizationActive(o)&&n.getHiddenInPopin().includes(t.getInnerColumn().getImportance())&&o.getColumns().pop()===t){this._toggleShowDetails(false)}};return h});
//# sourceMappingURL=ResponsiveTableType.js.map