/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["../ResponsiveTableType","../utils/Personalization","sap/m/table/columnmenu/QuickActionContainer","sap/m/table/columnmenu/QuickAction","sap/m/table/columnmenu/QuickSort","sap/m/table/columnmenu/QuickSortItem","sap/m/table/columnmenu/QuickGroup","sap/m/table/columnmenu/QuickGroupItem","sap/m/table/columnmenu/QuickTotal","sap/m/table/columnmenu/QuickTotalItem","sap/m/Button","sap/ui/core/Core","sap/ui/core/library"],function(e,t,n,o,r,i,s,c,a,u,g,l,m){"use strict";const p=n.extend("sap.ui.mdc.table.menu.QuickActionContainer",{metadata:{library:"sap.ui.mdc",associations:{table:{type:"sap.ui.mdc.Table"},column:{type:"sap.ui.mdc.table.Column"}}}});p.prototype.initializeQuickActions=function(){const e=this.getTable();const n=this.getColumn();const o=e.getPropertyHelper();const g=Promise.resolve();this.destroyQuickActions();if(e.isSortingEnabled()){const s=o.getProperty(n.getPropertyKey()).getSortableProperties();const c=e._getSortedProperties();if(s.length>0){this.addQuickAction(new r({items:s.map(function(e){let t=m.SortOrder.None;const n=c.find(function(t){return t.name===e.name});if(n){t=n.descending?m.SortOrder.Descending:m.SortOrder.Ascending}return new i({key:e.name,label:e.label,sortOrder:t})}),change:function(n){const o=n.getParameter("item");t.createSortChange(e,{property:o.getKey(),sortOrder:o.getSortOrder()})}}))}}if(e.isGroupingEnabled()){const r=o.getProperty(n.getPropertyKey()).getGroupableProperties();const i=e._getGroupedProperties();if(r.length>0){this.addQuickAction(new s({items:r.map(function(e){const t=i.some(function(t){return t.name===e.name});return new c({key:e.name,label:e.label,grouped:t})}),change:function(n){t.createGroupChange(e,{property:n.getParameter("item").getKey()})}}))}}if(e.isAggregationEnabled()){const r=o.getProperty(n.getPropertyKey()).getAggregatableProperties().filter(function(e){return e.extension&&e.extension.customAggregate});const i=e._getAggregatedProperties();if(r.length>0){this.addQuickAction(new a({items:r.map(function(e){return new u({key:e.name,label:e.label,totaled:i.hasOwnProperty(e.name)})}),change:function(n){t.createAggregateChange(e,{property:n.getParameter("item").getKey()})}}))}}if(e.getEnableColumnResize()){this.addQuickAction(e._getType().createColumnResizeMenuItem(n,this.getMenu()))}return g};p.prototype.updateQuickActions=function(e){const t=this.getTable();const n=t._getSortedProperties();const o=t._getGroupedProperties();const r=t._getAggregatedProperties();this.getQuickActions().forEach(function(t){if((!e||e.includes("Sort"))&&t.isA("sap.m.table.columnmenu.QuickSort")){t.getItems().forEach(function(e){const t=n.find(function(t){return t.name===e.getProperty("key")});if(t){e.setSortOrder(t.descending?m.SortOrder.Descending:m.SortOrder.Ascending)}else{e.setSortOrder(m.SortOrder.None)}})}else if((!e||e.includes("Group"))&&t.isA("sap.m.table.columnmenu.QuickGroup")){t.getItems().forEach(function(e){const t=o.some(function(t){return t.name===e.getProperty("key")});e.setGrouped(t)})}else if((!e||e.includes("Aggregate"))&&t.isA("sap.m.table.columnmenu.QuickTotal")){t.getItems().forEach(function(e){const t=r.hasOwnProperty(e.getProperty("key"));e.setTotaled(t)})}})};p.prototype.hasQuickActions=function(){return this.getEffectiveQuickActions().length>0};p.prototype.getTable=function(){return l.byId(this.getAssociation("table"))};p.prototype.getColumn=function(){return l.byId(this.getAssociation("column"))};return p});
//# sourceMappingURL=QuickActionContainer.js.map