/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/mdc/mixin/PromiseMixin","sap/ui/model/BindingMode","sap/ui/base/ManagedObjectObserver"],function(t,e,n,o){"use strict";const i=t.extend("sap.ui.mdc.valuehelp.base.Container",{metadata:{library:"sap.ui.mdc",properties:{title:{type:"string",group:"Appearance",defaultValue:""},localFilterValue:{type:"string"}},aggregations:{_container:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},content:{type:"sap.ui.mdc.valuehelp.base.Content",multiple:true}},events:{select:{parameters:{type:{type:"sap.ui.mdc.enums.ValueHelpSelectionType"},conditions:{type:"object[]"}}},confirm:{parameters:{close:{type:"boolean"}}},opened:{parameters:{itemId:{type:"string"}}},closed:{},cancel:{},requestDelegateContent:{parameters:{contentId:{type:"string"}}},requestSwitchToDialog:{},navigated:{parameters:{leaveFocus:{type:"boolean"},condition:{type:"object"},itemId:{type:"string"}}},typeaheadSuggested:{parameters:{condition:{type:"object"},filterValue:{type:"string"},itemId:{type:"string"}}}}}});i.prototype.init=function(){this._oObserver=new o(this.observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["content"]})};i.prototype.observeChanges=function(t){if(t.name==="content"){const e=t.child;if(t.mutation==="remove"){this.unbindContentFromContainer(e)}}};i.prototype.bindContentToContainer=function(t){if(t&&!t._bContentBound){t.attachConfirm(this.handleConfirmed,this);t.attachCancel(this.handleCanceled,this);t.attachSelect(this.handleSelect,this);if(t.attachNavigated){t.attachNavigated(this.handleNavigated,this)}if(t.attachTypeaheadSuggested){t.attachTypeaheadSuggested(this.handleTypeaheadSuggested,this)}if(t.attachRequestSwitchToDialog){t.attachRequestSwitchToDialog(this.handleRequestSwitchToDialog,this)}t.bindProperty("filterValue",{path:"/filterValue",model:"$valueHelp",mode:n.OneWay});const e={path:"/conditions",model:"$valueHelp",mode:n.OneWay};if(t._formatConditions){e.formatter=t._formatConditions.bind(t)}t.bindProperty("config",{path:"/_config",model:"$valueHelp",mode:n.OneWay});t.bindProperty("conditions",e);t._bContentBound=true}};i.prototype.unbindContentFromContainer=function(t){if(t._bContentBound){t.unbindProperty("filterValue",true);t.unbindProperty("config",true);t.unbindProperty("conditions",true);t.detachConfirm(this.handleConfirmed,this);t.detachCancel(this.handleCanceled,this);t.detachSelect(this.handleSelect,this);if(t.detachNavigated){t.detachNavigated(this.handleNavigated,this)}if(t.detachTypeaheadSuggested){t.detachTypeaheadSuggested(this.handleTypeaheadSuggested,this)}if(t.detachRequestSwitchToDialog){t.detachRequestSwitchToDialog(this.handleRequestSwitchToDialog,this)}t._bContentBound=false}};i.prototype.handleNavigated=function(t){this.fireNavigated(t.mParameters)};i.prototype.handleTypeaheadSuggested=function(t){this.fireTypeaheadSuggested(t.mParameters)};i.prototype.handleRequestSwitchToDialog=function(t){this.fireRequestSwitchToDialog({container:this})};i.prototype.getContainerControl=function(){};i.prototype.getControl=function(){const t=this.getParent();return t&&t.getControl()};i.prototype.getMaxConditions=function(){const t=this.getModel("$valueHelp");return t&&t.getObject("/_config/maxConditions")};i.prototype.isSingleSelect=function(){return this.getMaxConditions()===1};i.prototype.getDomRef=function(){const t=this.getAggregation("_container");return t&&t.getDomRef()};i.prototype.getUIArea=function(){return null};i.prototype.getUIAreaForContent=function(){return this.getUIArea()};i.prototype.open=function(t,e){if(!this.isOpening()){const n=this._addPromise("open");return Promise.all([this.getContainerControl(),t]).then(function(t){return this.placeContent(t[0])}.bind(this)).then(function(t){if(!n.isCanceled()){this.openContainer(t,e)}return n}.bind(this))}return this._retrievePromise("open")};i.prototype.close=function(){const t=this._retrievePromise("open");if(t){if(t.isSettled()){this.closeContainer()}else{this._cancelPromise(t)}}};i.prototype.placeContent=function(t){return t};i.prototype.openContainer=function(t,e){const n=this.getContent();for(let t=0;t<n.length;t++){this.bindContentToContainer(n[t])}};i.prototype.closeContainer=function(){};i.prototype.handleOpened=function(t){this._resolvePromise("open");this.fireOpened()};i.prototype.handleClosed=function(t){this._removePromise("open");const e=this.getContent();for(let t=0;t<e.length;t++){this.unbindContentFromContainer(e[t])}this.fireClosed()};i.prototype.handleConfirmed=function(t){this.fireConfirm()};i.prototype.handleCanceled=function(t){this.fireCancel()};i.prototype.handleSelect=function(t){this.fireSelect({type:t.getParameter("type"),conditions:t.getParameter("conditions")})};i.prototype.isOpen=function(){const t=this._retrievePromise("open");return t&&t.isSettled()};i.prototype.isOpening=function(){const t=this._retrievePromise("open");return t&&!t.isCanceled()&&!t.isSettled()};i.prototype.getItemForValue=function(t){return undefined};i.prototype.isValidationSupported=function(){return false};i.prototype.navigate=function(t){return Promise.all([this.getContainerControl()]).then(function(t){return this.placeContent(t[0])}.bind(this)).then(function(e){this.navigateInContent(t)}.bind(this))};i.prototype.navigateInContent=function(t){};i.prototype.removeFocus=function(){};i.prototype.isTypeahead=function(){const t=this.getParent();return t&&t.getTypeahead()===this};i.prototype.isTypeaheadSupported=function(){return false};i.prototype.isDialog=function(){const t=this.getParent();return t&&(t.getDialog()===this||this.isTypeahead()&&!t.getDialog()&&this.getUseAsValueHelp())};i.prototype.hasDialog=function(){const t=this.getParent();return!!(t&&t.getDialog())};i.prototype.providesScrolling=function(){return false};i.prototype.getValueHelp=function(){const t=this.getParent();return t};i.prototype.getValueHelpDelegate=function(){const t=this.getParent();return t&&t.getControlDelegate()};i.prototype.getValueHelpDelegatePayload=function(){const t=this.getParent();return t&&t.getPayload()};i.prototype.awaitValueHelpDelegate=function(){const t=this.getParent();return t&&t.awaitControlDelegate()};i.prototype.isValueHelpDelegateInitialized=function(){const t=this.getParent();return t&&t.bDelegateInitialized};i.prototype.getUseAsValueHelp=function(){return false};i.prototype.getValueHelpIcon=function(){};i.prototype.getAriaAttributes=function(t){return{contentId:null,ariaHasPopup:"listbox",role:"combobox",roleDescription:null,valueHelpEnabled:false,autocomplete:"none"}};i.prototype.getScrollDelegate=function(t){const e=this.getAggregation("_container");return e&&e.getScrollDelegate&&e.getScrollDelegate()};i.prototype.shouldOpenOnFocus=function(){return false};i.prototype.shouldOpenOnClick=function(){return false};i.prototype.shouldOpenOnNavigate=function(){return false};i.prototype.isNavigationEnabled=function(t){return false};i.prototype.isFocusInHelp=function(){return!this.isTypeahead()};i.prototype.isMultiSelect=function(){return false};i.prototype.getContainerConfig=function(t){const e=t&&t.getContainerConfig();let n=e&&e[this.getMetadata().getName()];if(!n&&e){const t=Object.keys(e);const o=t.find(function(t){return this.isA(t)}.bind(this));if(o){n=e[o]}}return n};i.prototype.getRetrieveDelegateContentPromise=function(){const t=this.getParent();return t&&t._retrievePromise("delegateContent")};i.prototype.getSelectedContent=function(){const t=this.getContent();return t&&t[0]};i.prototype.onConnectionChange=function(){const t=this.getContent();for(let e=0;e<t.length;e++){this.unbindContentFromContainer(t[e]);t[e].onConnectionChange()}};i.prototype.exit=function(){this._oObserver.disconnect();this._oObserver=undefined};e.call(i.prototype);return i});
//# sourceMappingURL=Container.js.map