/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/valuehelp/base/ListContent","sap/ui/mdc/util/loadModules","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/enums/ValueHelpSelectionType","sap/ui/model/ParseException","sap/base/util/deepEqual"],function(t,e,i,s,n,o,l){"use strict";const a=t.extend("sap.ui.mdc.valuehelp.content.FixedList",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.ITypeaheadContent","sap.ui.mdc.valuehelp.IDialogContent"],properties:{groupable:{type:"boolean",group:"Appearance",defaultValue:false},filterList:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{items:{type:"sap.ui.mdc.valuehelp.content.FixedListItem",multiple:true,singularName:"item"}},defaultAggregation:"items",events:{}}});a.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._iNavigateIndex=-1};a.prototype.exit=function(){if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();delete this._oManagedObjectModel}t.prototype.exit.apply(this,arguments)};a.prototype.getContent=function(){return this._retrievePromise("content",function(){return e(["sap/m/List","sap/m/DisplayListItem","sap/m/library","sap/ui/model/Filter","sap/ui/model/Sorter","sap/ui/model/base/ManagedObjectModel","sap/base/strings/whitespaceReplacer"]).then(function(t){const e=t[0];const i=t[1];const s=t[2];const n=t[3];const o=t[4];const l=t[5];const a=t[6];this._oManagedObjectModel=new l(this);const r=new i(this.getId()+"-item",{type:s.ListType.Active,label:{path:"$help>text",formatter:a},value:{path:"$help>additionalText",formatter:a},valueTextDirection:"{$help>textDirection}"}).addStyleClass("sapMComboBoxNonInteractiveItem");const u=new n({path:"text",test:p.bind(this),caseSensitive:true});let h;if(this.getGroupable()){h=new o("groupKey",false,g.bind(this))}const d=new e(this.getId()+"-List",{width:"100%",showNoData:false,mode:s.ListMode.SingleSelectMaster,rememberSelections:false,items:{path:"$help>/items",template:r,filters:u,sorter:h,templateShareable:false},itemPress:c.bind(this)}).addStyleClass("sapMComboBoxBaseList").addStyleClass("sapMComboBoxList");d.applyAriaRole("listbox");d.setModel(this._oManagedObjectModel,"$help");this.setAggregation("displayContent",d,true);f.call(this,true);return d}.bind(this))}.bind(this))};function r(){return this.getAggregation("displayContent")}function c(t){const e=t.getParameter("listItem");const i=e.getSelected();if(i){const t=y.call(this,e);const i=v.call(this,t);const s=x.call(this,t);u.call(this,i,s);this.fireSelect({type:n.Set,conditions:this.getConditions()});this.fireConfirm()}}function u(t,e){const i=this.createCondition(t,e);const s=this.getConditions();if(l([i],s)){f.call(this)}else{this.setProperty("conditions",[i],true)}return i}function p(t){const e=this.getFilterList();return!e||h.call(this,t,this.getFilterValue())}function h(t,e){return!e||typeof e==="string"&&(this.getCaseSensitive()?t.startsWith(e):t.toLowerCase().startsWith(e.toLowerCase()))}function d(){if(this._iNavigateIndex>=0){this.setProperty("conditions",[],true);this._iNavigateIndex=-1}const t=r.call(this);const e=this.getListBinding();if(t){e.update();t.updateItems();t.invalidate();f.call(this,true)}}function g(t){const e=t.getProperty("groupKey");const i=t.getProperty("groupText");return{key:e,text:i}}function f(t){const e=r.call(this);if(e){const n=this.getConditions();let o,l;const a=this.getFilterValue();const r=this.getUseFirstMatch();let c=false;let u;const p=this.getParent().isOpen();if(n.length>0&&(n[0].validated===i.Validated||n[0].operator===s.EQ)){o=n[0].values[0]}if(r&&a){const t=this.getValueHelpDelegate().getFirstMatch(this.getValueHelpInstance(),this,{checkDescription:true,value:a});if(t){l=I.call(this,t)}}const h=e.getItems();for(let t=0;t<h.length;t++){const i=h[t];if(i.isA("sap.m.DisplayListItem")){const t=y.call(this,i);if(n.length>0&&v.call(this,t)===o){i.setSelected(true);if(p&&!i.hasStyleClass("sapMLIBFocused")){e.setFakeFocus(i)}}else if(n.length===0&&this._iNavigateIndex<0&&!c&&l&&l===t){i.setSelected(true);u=i.getId();c=true}else{i.setSelected(false);if(p&&i.hasStyleClass("sapMLIBFocused")){e.setFakeFocus()}}}}if(t&&c){m.call(this,l,u)}}}function m(t,e){const i=this.getFilterValue();const s=this.getUseFirstMatch();if(s&&i&&t){const s=v.call(this,t);const n=x.call(this,t);const o=this.createCondition(s,n);this.fireTypeaheadSuggested({condition:o,filterValue:i,itemId:e})}}function y(t){return this._oManagedObjectModel.getProperty(t.getBindingContextPath())}function I(t){return this._oManagedObjectModel.getProperty(t.getPath())}function v(t){const e=t.getBinding("key");if(e){return e.getInternalValue()}else{return t.getKey()}}function x(t){const e=t.getBinding("text");if(e){return e.getInternalValue()}else{return t.getText()}}a.prototype.getItemForValue=function(t){return this.getContent().then(function(){if(t.value===null||t.value===undefined){return null}else if(!t.value&&t.checkDescription){return null}const e=this.getItems();let i;let s=0;let n;let a;for(s=0;s<e.length;s++){i=e[s];n=v.call(this,i);a=x.call(this,i);if(t.checkKey&&l(n,t.parsedValue)||t.checkDescription&&(l(a,t.parsedDescription)||i.getText()===t.value)){return{key:n,description:a}}}if(t.checkKey&&t.value===""){return null}if(this.getUseFirstMatch()){const e=this.getValueHelpDelegate().getFirstMatch(this.getValueHelpInstance(),this,t);if(e){const t=I.call(this,e);n=v.call(this,t);a=x.call(this,t);return{key:n,description:a}}}const r=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[t.value]);const c=t.exception||o;throw new c(r)}.bind(this))};a.prototype.isValidationSupported=function(t){return true};a.prototype.isSearchSupported=function(){return true};a.prototype.handleConditionsUpdate=function(t){f.call(this,false)};a.prototype.handleFilterValueUpdate=function(e){d.call(this);t.prototype.handleFilterValueUpdate.apply(this,arguments)};a.prototype.removeFocus=function(){const t=r.call(this);if(t){t.removeStyleClass("sapMListFocus")}};a.prototype.navigate=function(t){const e=r.call(this);if(!e){return}const i=e.getItems();const s=i.length;const n=this._iNavigateIndex>=0?i[this._iNavigateIndex]:e.getSelectedItem();let o=0;const l=this.getFilterList();const a=this.getFilterValue();let c=false;const p=this.getParent().isOpen();if(!l&&!n){let e=0;if(t>=0){for(e=0;e<i.length;e++){if(!i[e].isA("sap.m.GroupHeaderListItem")&&h.call(this,i[e].getLabel(),a)){o=e;break}}}else{for(e=i.length-1;e>=0;e--){if(!i[e].isA("sap.m.GroupHeaderListItem")&&h.call(this,i[e].getLabel(),a)){o=e;break}}}}else if(n){o=e.indexOfItem(n);o=o+t}else if(t>=0){o=t-1}else{o=s+t}if(t===9999){o=s-1}if(t===-9999){o=0}let d;if(o<0){o=0;d=true;c=true}else if(o>=s-1){o=s-1;d=false}else{d=t>=0}const g=function(){while(i[o]&&i[o].isA("sap.m.GroupHeaderListItem")){if(d){o++}else{o--}}};if(!p||t===0){g();if(o<0||o>s-1){d=!d;c=o<0;o=o<0?0:s-1;g()}}const f=i[o];if(f){const t=this.getUseFirstMatch();if(f!==n||t&&!c||this._iNavigateIndex!==o&&!c){let t,i,s;this._iNavigateIndex=o;if(p){e.scrollToIndex(o);e.setFakeFocus(f)}if(f.isA("sap.m.GroupHeaderListItem")){this.setProperty("conditions",[],true);this.fireNavigated({condition:undefined,itemId:f.getId(),leaveFocus:false})}else{t=y.call(this,f);i=v.call(this,t);s=x.call(this,t);const e=u.call(this,i,s);this.fireNavigated({condition:e,itemId:f.getId(),leaveFocus:false})}if(p){e.addStyleClass("sapMListFocus")}}else if(c){this._iNavigateIndex=-1;this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:c})}}};a.prototype.onShow=function(){return t.prototype.onShow.apply(this,arguments).then(()=>{const t=r.call(this);let e;if(!t){return null}const i=t.getSelectedItem();if(i){const s=t.indexOfItem(i);t.scrollToIndex(s);e=i.getId()}return e})};a.prototype.onHide=function(){this.removeFocus();const t=r.call(this);t?.setFakeFocus();this._iNavigateIndex=-1};a.prototype.getValueHelpIcon=function(){if(this.getUseAsValueHelp()){return"sap-icon://slim-arrow-down"}else{return null}};a.prototype.getAriaAttributes=function(t){return{contentId:this.getId()+"-List",ariaHasPopup:"listbox",roleDescription:null,valueHelpEnabled:false,autocomplete:this.getUseFirstMatch()?"both":"none"}};a.prototype.shouldOpenOnClick=function(){return!this.getFilterList()};a.prototype.isFocusInHelp=function(){return false};a.prototype.isSingleSelect=function(t){return true};a.prototype.shouldOpenOnNavigate=function(){return!t.prototype.isSingleSelect.apply(this)};a.prototype.isNavigationEnabled=function(t){return this.getItems().length>0};a.prototype.onConnectionChange=function(){this._iNavigateIndex=-1};a.prototype.getListBinding=function(){const t=r.call(this);return t&&t.getBinding("items")};a.prototype.getRelevantContexts=function(t){const e=this.getListBinding();const i=e.getAllCurrentContexts?e.getAllCurrentContexts():e.getContexts();return i.filter(e=>{const i=t.checkDescription?e.getProperty("text"):e.getProperty("key");return h.call(this,i,t.value)})};return a});
//# sourceMappingURL=FixedList.js.map