/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BindingMode","./ChangeReason","./CompositeDataState","./CompositeType","./Context","./PropertyBinding","sap/base/Log","sap/base/util/deepEqual","sap/ui/base/DataType","sap/ui/base/SyncPromise"],function(e,t,n,a,i,s,r,u,o,h){"use strict";var l=s.extend("sap.ui.model.CompositeBinding",{constructor:function(e,t,n){var a;s.apply(this,[null,""]);this.aBindings=e;this.aValues=null;this.bRawValues=t;this.bPreventUpdate=false;this.bInternalValues=n;this.bMultipleModels=this.aBindings.some(function(e){var t=e.getModel();a=a||t;return a&&t&&t!==a});this.aOriginalValues=undefined;this.fnChangeHandler=undefined;this.fnDataStateChangeHandler=undefined},metadata:{publicMethods:["getBindings","attachChange","detachChange"]}});l.prototype.destroy=function(){this.aBindings.forEach(function(e){e.destroy()});s.prototype.destroy.apply(this)};l.prototype.getPath=function(){return null};l.prototype.getModel=function(){return null};l.prototype.getContext=function(){return null};l.prototype.isResolved=function(){return this.aBindings.every(function(e){return e.isResolved()})};l.prototype.setType=function(e,t){const n=this;function i(){n.oType?.processPartTypes(n.aBindings.map(function(e){return e.getType()}))}if(e&&!(e instanceof a)){throw new Error("Only CompositeType can be used as type for composite bindings!")}s.prototype.setType.apply(this,arguments);if(this.oType){e.getPartsIgnoringMessages().forEach(function(e){var t=n.aBindings[e];if(t&&t.supportsIgnoreMessages()&&t.getIgnoreMessages()===undefined){t.setIgnoreMessages(true)}});this.bRawValues=this.oType.getUseRawValues();this.bInternalValues=this.oType.getUseInternalValues();i();e.getPartsListeningToTypeChanges().forEach(e=>{this.aBindings[e].registerTypeChanged(i)});if(this.bRawValues&&this.bInternalValues){throw new Error(this.oType+" has both 'bUseRawValues' & 'bUseInternalValues' set to true. Only one of them is allowed to be true")}}};l.prototype.setContext=function(e,t){var n,a,s=this.aBindings,r=e&&e.getModel(),u=t&&t.fnIsBindingRelevant?t.fnIsBindingRelevant:function(t){return!e||r&&r===s[t].getModel()};s.forEach(function(t,s){var r;if(u(s)){r=t.getContext();n=n||t.isRelative()&&i.hasChanged(r,e);a=a||n&&r!==e;t.setContext(e)}});if(n){this.checkUpdate(a&&this.getDataState().getControlMessages().length)}};l.prototype.setValue=function(t){if(this.bSuspended){return}this.aBindings.forEach(function(n,a){var i=t[a],s=n.getBindingMode();if(i!==undefined&&s!==e.OneWay&&s!==e.OneTime){n.setValue(i)}});this.getDataState().setValue(this.getValue())};l.prototype.getValue=function(){return this.aBindings.map(function(e){return e.getValue()})};l.prototype.getOriginalValue=function(){return this.aBindings.map(function(e){return e.getDataState().getOriginalValue()})};l.prototype.getExternalValue=function(){var e=[],t,n;switch(this.sInternalType){case"raw":return this.getRawValue();case"internal":return this.getInternalValue();default:t=this.sInternalType&&o.getType(this.sInternalType);e=this.getCurrentValues();if(this.fnFormatter){n=this.fnFormatter.apply(this,e)}else if(this.oType){n=this.oType.formatValue(e,this.sInternalType)}else if(t instanceof o&&t.isArrayType()){n=e}else if(e.length>1){n=e.join(" ")}else{n=e[0]}return n}};l.prototype.setExternalValue=function(t){var n,a,i,s,u=this;if(this.sInternalType==="raw"){this.setRawValue(t);return undefined}else if(this.sInternalType==="internal"){this.setInternalValue(t);return undefined}n=this.sInternalType&&o.getType(this.sInternalType);if(this.fnFormatter){r.warning("Tried to use twoway binding, but a formatter function is used");return undefined}a=this.getDataState();if(this.oType){s=h.resolve().then(function(){var e;if(u.oType.getParseWithValues()){e=u.getCurrentValues()}return u.oType.parseValue(t,u.sInternalType,e)}).then(function(e){var t=u.getValidateValues(e);return h.all([e,u.oType.validateValue(t)])}).then(function(e){return e[0]}).catch(function(e){a.setInvalidValue(t);u.checkDataState();throw e})}else if(Array.isArray(t)&&n instanceof o&&n.isArrayType()){s=h.resolve(t)}else if(typeof t=="string"){s=h.resolve(t.split(" "))}else{s=h.resolve([t])}i=s.then(function(n){u.aBindings.forEach(function(a,i){var s=a.getBindingMode();t=n[i];if(t!==undefined&&s!==e.OneWay&&s!==e.OneTime){if(u.bRawValues){a.setRawValue(t)}else if(u.bInternalValues){a.setInternalValue(t)}else{a.setExternalValue(t)}}});a.setValue(u.getValue());a.setInvalidValue(undefined)});i.catch(function(){});return i.unwrap()};l.prototype.getInternalValue=function(){return this.aBindings.map(function(e){return e.getInternalValue()})};l.prototype.setInternalValue=function(t){var n=this.getDataState(),a,i=this;if(this.oType){a=h.resolve(t).then(function(e){if(!i.bInternalValues){e=i.aBindings.map(function(t,n){return t._internalToRaw(e[n])});if(!i.bRawValues){e=i.aBindings.map(function(t,n){return t._rawToExternal(e[n])})}}return i.oType.validateValue(e)}).then(function(){return t}).catch(function(e){n.setInvalidValue(t);i.checkDataState();throw e})}else{a=h.resolve(t)}return a.then(function(){i.aBindings.forEach(function(n,a){var i=t[a],s=n.getBindingMode();if(i!==undefined&&s!==e.OneWay&&s!==e.OneTime){n.setInternalValue(i)}});n.setValue(i.getValue());n.setInvalidValue(undefined)}).unwrap()};l.prototype.getRawValue=function(){return this.aBindings.map(function(e){return e.getRawValue()})};l.prototype.setRawValue=function(t){var n=this.getDataState(),a,i=this;if(this.oType){a=h.resolve(t).then(function(e){if(!i.bRawValues){if(i.bInternalValues){e=i.aBindings.map(function(t,n){return t._rawToInternal(e[n])})}else{e=i.aBindings.map(function(t,n){return t._rawToExternal(e[n])})}}return i.oType.validateValue(e)}).then(function(){return t}).catch(function(e){n.setInvalidValue(t);i.checkDataState();throw e})}else{a=h.resolve(t)}return a.then(function(){i.aBindings.forEach(function(n,a){var i=t[a],s=n.getBindingMode();if(i!==undefined&&s!==e.OneWay&&s!==e.OneTime){n.setRawValue(i)}});n.setValue(i.getValue());n.setInvalidValue(undefined)}).unwrap()};l.prototype.getCurrentValues=function(){if(this.bRawValues){return this.getRawValue()}else if(this.bInternalValues){return this.getInternalValue()}else{return this.aBindings.map(function(e){return e.getExternalValue()})}};l.prototype.getValidateValues=function(e){var t,n,a=e;n=this.aBindings.some(function(t,n){return e[n]===undefined});if(n){t=this.getCurrentValues();a=t.map(function(t,n){return e[n]===undefined?t:e[n]})}return a};l.prototype.getBindings=function(){return this.aBindings};l.prototype.hasValidation=function(){if(this.getType()){return true}var e=this.getBindings();for(var t=0;t<e.length;++t){if(e[t].hasValidation()){return true}}return false};l.prototype.attachChange=function(t,n){var a=this;this.fnChangeHandler=function(t){if(a.bSuspended){return}var n=t.getSource();if(n.getBindingMode()==e.OneTime){n.detachChange(a.fnChangeHandler)}a.checkUpdate(true)};this.attachEvent("change",t,n);if(this.aBindings){this.aBindings.forEach(function(e){e.attachChange(a.fnChangeHandler)})}};l.prototype.detachChange=function(e,t){var n=this;this.detachEvent("change",e,t);if(this.aBindings){this.aBindings.forEach(function(e){e.detachChange(n.fnChangeHandler)})}};l.prototype.attachDataStateChange=function(t,n){var a=this;this.fnDataStateChangeHandler=function(t){var n=t.getSource();if(n.getBindingMode()==e.OneTime){n.detachDataStateChange(a.fnChangeHandler)}a.checkDataState()};this.attachEvent("DataStateChange",t,n);if(this.aBindings){this.aBindings.forEach(function(e){e.attachEvent("DataStateChange",a.fnDataStateChangeHandler)})}};l.prototype.detachDataStateChange=function(e,t){var n=this;this.detachEvent("DataStateChange",e,t);if(this.aBindings){this.aBindings.forEach(function(e){e.detachEvent("DataStateChange",n.fnDataStateChangeHandler)})}};l.prototype.attachAggregatedDataStateChange=function(t,n){var a=this;if(!this.fnDataStateChangeHandler){this.fnDataStateChangeHandler=function(t){var n=t.getSource();if(n.getBindingMode()==e.OneTime){n.detachDataStateChange(a.fnChangeHandler)}a.checkDataState()}}this.attachEvent("AggregatedDataStateChange",t,n);if(this.aBindings){this.aBindings.forEach(function(e){e.attachEvent("DataStateChange",a.fnDataStateChangeHandler)})}};l.prototype.detachAggregatedDataStateChange=function(e,t){var n=this;this.detachEvent("AggregatedDataStateChange",e,t);if(this.aBindings){this.aBindings.forEach(function(e){e.detachEvent("DataStateChange",n.fnDataStateChangeHandler)})}};l.prototype.updateRequired=function(e){var t=false;this.aBindings.forEach(function(n){t=t||n.updateRequired(e)});return t};l.prototype.initialize=function(){this.bPreventUpdate=true;if(this.aBindings){this.aBindings.forEach(function(e){e.initialize()})}this.bPreventUpdate=false;if(!this.bSuspended){this.checkUpdate(true)}return this};l.prototype.getDataState=function(){if(!this.oDataState){this.oDataState=new n(this.aBindings.map(function(e){return e.getDataState()}))}return this.oDataState};l.prototype.suspend=function(){this.bSuspended=true;this.aBindings.forEach(function(e){e.suspend()})};l.prototype.resume=function(){this.aBindings.forEach(function(e){e.resume()});this.bSuspended=false;this.checkUpdate(true)};l.prototype.checkUpdate=function(e){var n=false;if(this.bPreventUpdate||this.bSuspended&&!e){return}if(this.bMultipleModels&&this.aBindings.some(function(e){var t=e.getModel();return t&&t.bDestroyed})){return}var a=this.getDataState();var i=this.getOriginalValue();if(e||!u(i,this.aOriginalValues)){this.aOriginalValues=i;a.setOriginalValue(i);n=true}var s=this.getValue();if(!u(s,this.aValues)||e){this.aValues=s;a.setValue(s);this._fireChange({reason:t.Change});n=true}if(n){this.checkDataState()}};return l});
//# sourceMappingURL=CompositeBinding.js.map