/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/assert","sap/base/Log"],function(e,t){"use strict";var n=function(e,t){this._oControl=e;this._sAggregation=t;var n=new URLSearchParams(window.location.search);this._bEnableV4=n.get("sap-ui-xx-v4tree")==="true"};n.prototype.isTreeBinding=function(){var e=this._oControl.getModel(this._oControl.getBindingInfo(this._sAggregation).model);if(e.isA("sap.ui.model.odata.v4.ODataModel")){return false}return true};n.prototype.isLeaf=function(e){var n=this._oControl.getBinding();var i=this._getBindingName(n);switch(i){case undefined:return true;case"sap.ui.model.odata.v4.ODataListBinding":if(!this._bEnableV4){t.error("UnsupportedOperationException: OData V4 is not supported");return false}var r=this.getContextByIndex(e);return r?r.getProperty("@$ui5.node.isExpanded")===undefined:true;default:var o=this.getNodeByIndex(e);return!n.nodeHasChildren(o)}};n.prototype.getNodeByIndex=function(e){var n=this._oControl.getBinding();var i=this._getBindingName(n);var r=null;if(e<0){return r}switch(i){case undefined:break;case"sap.ui.model.odata.v4.ODataListBinding":if(!this._bEnableV4){t.error("UnsupportedOperationException: OData V4 is not supported")}else{r=this.getContextByIndex(e)}break;default:r=n.getNodeByIndex(e)}return r||null};n.prototype.getContextByIndex=function(e){var n=this._oControl.getBinding();var i=this._getBindingName(n);var r=null;if(e<0){return r}switch(i){case undefined:break;case"sap.ui.model.odata.v4.ODataListBinding":if(!this._bEnableV4){t.error("UnsupportedOperationException: OData V4 is not supported")}else{r=n.getContexts(e,1,0,true)[0]}break;default:r=n.getContextByIndex(e)}return r||null};n.prototype.isExpanded=function(e){var n=this._oControl.getBinding();var i=this._getBindingName(n);switch(i){case undefined:return false;case"sap.ui.model.odata.v4.ODataListBinding":if(!this._bEnableV4){t.error("UnsupportedOperationException: OData V4 is not supported");return false}var r=this.getContextByIndex(e);return r?!!r.getProperty("@$ui5.node.isExpanded"):false;default:return n?n.isExpanded(e):false}};n.prototype.expand=function(e){var n=this._oControl.getBinding();var o=this._getBindingName(n);var a={proxy:this,binding:n,indices:e,expanded:true};if(typeof a.indices==="number"){a.indices=[e]}switch(o){case undefined:break;case"sap.ui.model.odata.v4.ODataListBinding":if(!this._bEnableV4){t.error("UnsupportedOperationException: OData V4 is not supported");return}r(a);break;default:i(a)}};n.prototype.collapse=function(e){var n=this._oControl.getBinding();var o=this._getBindingName(n);var a={proxy:this,binding:n,indices:e,expanded:false};if(typeof a.indices==="number"){a.indices=[e]}switch(o){case undefined:break;case"sap.ui.model.odata.v4.ODataListBinding":if(!this._bEnableV4){t.error("UnsupportedOperationException: OData V4 is not supported");return}r(a);break;default:i(a)}};function i(e){var t=e.indices.filter(function(t){return t>=0&&t<e.binding.getLength()&&!e.proxy.isLeaf(t)&&e.expanded!==e.proxy.isExpanded(t)}).sort(function(e,t){return e-t});if(t.length===0){return}for(var n=t.length-1;n>0;n--){if(e.expanded){e.binding.expand(t[n],true)}else{e.binding.collapse(t[n],true)}}if(e.expanded){e.binding.expand(t[0],false)}else{e.binding.collapse(t[0],false)}}function r(e){for(var t=0;t<e.indices.length;t++){var n=e.proxy.getContextByIndex(e.indices[t]);if(n){if(e.expanded){n.expand()}else{n.collapse()}}}}n.prototype.toggleExpandedState=function(e){if(this.isExpanded(e)){this.collapse(e)}else{this.expand(e)}};n.prototype.getContexts=function(e,n,i,r){var a=this._oControl.getBinding();var s=this._getBindingName(a);var d=[];switch(s){case undefined:break;case"sap.ui.model.odata.v4.ODataListBinding":if(!this._bEnableV4){t.error("UnsupportedOperationException: OData V4 is not supported");return[]}d=a.getContexts(e,n,i,r);d.forEach(function(e){if(!e){return}e._mProxyInfo={};e._mProxyInfo.level=o(e,false);e._mProxyInfo.isLeaf=e.getProperty("@$ui5.node.isExpanded")===undefined;e._mProxyInfo.isExpanded=!!e.getProperty("@$ui5.node.isExpanded")},this);break;default:var p=a?a.getNodes(e,n,i):[];p.forEach(function(t,n){if(!t){return}var i=n+e;var r=t.context;if(r){r._mProxyInfo={};if(t.nodeState){r._mProxyInfo.nodeState=t.nodeState}r._mProxyInfo.level=o(t,true);r._mProxyInfo.isLeaf=!a.nodeHasChildren(t);r._mProxyInfo.isExpanded=a.isExpanded(i);d.push(t.context)}},this);break}return d};function o(e,t){if(e){return t?e.level+1:e.getProperty("@$ui5.node.level")}}function a(e,t){var n=Object.assign(e.getAggregation(),{expandTo:t});e.setAggregation(n)}n.prototype.collapseAll=function(){var e=this._oControl.getBinding();var n=this._getBindingName(e);switch(n){case undefined:break;case"sap.ui.model.odata.v4.ODataListBinding":if(!this._bEnableV4){t.error("UnsupportedOperationException: OData V4 is not supported");return}a(e,1);break;default:e.collapseToLevel(0)}};n.prototype.expandToLevel=function(n){var i=this._oControl.getBinding();var r=this._getBindingName(i);switch(r){case undefined:break;case"sap.ui.model.odata.v4.ODataListBinding":if(!this._bEnableV4){t.error("UnsupportedOperationException: OData V4 is not supported");return}a(i,n);break;default:if(i.expandToLevel){i.expandToLevel(n)}else{e(i.expandToLevel,"Expanding all nodes to a certain level"+" is not supported with your current binding.")}}};n.prototype.setRootLevel=function(n){var i=this._oControl.getBinding();var r=this._getBindingName(i);switch(r){case undefined:break;case"sap.ui.model.odata.v4.ODataListBinding":if(!this._bEnableV4){t.error("UnsupportedOperationException: OData V4 is not supported");return}throw Error("Setting the root level is not supported with your current binding.");default:if(i.setRootLevel){i.setRootLevel(n)}else{e(i.setRootLevel,"Setting the root level is not supported with"+" your current binding.")}}};n.prototype.setCollapseRecursive=function(n){var i=this._oControl.getBinding();var r=this._getBindingName(i);switch(r){case undefined:break;case"sap.ui.model.odata.v4.ODataListBinding":if(!this._bEnableV4){t.error("UnsupportedOperationException: OData V4 is not supported");return}throw Error("Setting 'collapseRecursive' is not supported with your"+" current binding.");default:if(i.setCollapseRecursive){i.setCollapseRecursive(n)}else{e(i.setCollapseRecursive,"Setting 'collapseRecursive' is"+" not supported with your current binding.")}}};n.prototype.getLevel=function(e){var n=this._oControl.getBinding();var i=this._getBindingName(n);switch(i){case undefined:return undefined;case"sap.ui.model.odata.v4.ODataListBinding":if(!this._bEnableV4){t.error("UnsupportedOperationException: OData V4 is not supported");return 0}var r=this.getContextByIndex(e);return o(r,false);default:var a=this.getNodeByIndex(e);return o(a,true)}};n.prototype.getSiblingCount=function(e){var n=this._oControl.getBinding();var i=this._getBindingName(n);switch(i){case undefined:return 0;case"sap.ui.model.odata.v4.ODataListBinding":if(!this._bEnableV4){t.error("UnsupportedOperationException: OData V4 is not supported");return 0}throw Error("The number of siblings of a node cannot be determined"+" with your current binding.");default:var r=this.getNodeByIndex(e);return r&&r.parent?r.parent.children.length:0}};n.prototype.getPositionInParent=function(e){var n=this._oControl.getBinding();var i=this._getBindingName(n);switch(i){case undefined:return-1;case"sap.ui.model.odata.v4.ODataListBinding":if(!this._bEnableV4){t.error("UnsupportedOperationException: OData V4 is not supported");return-1}throw Error("The position of a node in its parent cannot be determined"+" with your current binding.");default:var r=this.getNodeByIndex(e);return r?r.positionInParent:-1}};n.prototype.isSelectionSupported=function(){var e=this._oControl.getBinding();var t=this._getBindingName(e);switch(t){case undefined:case"sap.ui.model.odata.v4.ODataListBinding":return false;default:return true}};n.prototype.applyLegacySettingsToBindingInfo=function(e,t){if(!e.parameters){e.parameters={}}if(!("rootLevel"in e.parameters)&&t.rootLevel!==undefined){e.parameters.rootLevel=t.rootLevel}if(!("collapseRecursive"in e.parameters)&&t.collapseRecursive!==undefined){e.parameters.collapseRecursive=t.collapseRecursive}if(!("numberOfExpandedLevels"in e.parameters)&&t.numberOfExpandedLevels!==undefined){e.parameters.numberOfExpandedLevels=t.numberOfExpandedLevels}};n.prototype._getBindingName=function(t){e(t,"Control does not have a binding.");return t?t.getMetadata().getName():undefined};return n});
//# sourceMappingURL=TreeBindingProxy.js.map