/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/util/extend","sap/ui/core/CalendarType","sap/ui/core/date/UI5Date","sap/ui/core/format/DateFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/odata/type/ODataType"],function(t,e,a,r,n,o,i,s,l){"use strict";var u=/\d{4}-(?:0[1-9]|1[0-2])-(?:0[1-9]|[12]\d|3[01])/,p;function f(){if(!p){p=n.getDateInstance({calendarType:a.Gregorian,pattern:"yyyy-MM-dd",strictParsing:true,UTC:true})}return p}function g(e,a){var r;e.oConstraints=undefined;if(a){r=a.nullable;if(r===false||r==="false"){e.oConstraints={nullable:false}}else if(r!==undefined&&r!==true&&r!=="true"){t.warning("Illegal nullable: "+r,null,e.getName())}}}var c=l.extend("sap.ui.model.odata.type.Date",{constructor:function(t,e){l.apply(this,arguments);this.oFormatOptions=t;g(this,e)}});c.prototype._handleLocalizationChange=function(){this.oFormat=null};c.prototype.formatValue=function(t,e){var a;if(t===undefined||t===null){return null}switch(this.getPrimitiveType(e)){case"any":return t;case"object":return t instanceof Date?r.getInstance(t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate()):f().parse(t,false);case"string":a=t instanceof Date?t:f().parse(t);return a?this.getFormat().format(a):t;default:throw new o("Don't know how to format "+this.getName()+" to "+e)}};c.prototype._getErrorMessage=function(){var t=r.getInstance().getFullYear()+"-12-31";return sap.ui.getCore().getLibraryResourceBundle().getText("EnterDate",[this.formatValue(t,"string")])};c.prototype.getDateValue=function(t){return t?r.getInstance(t+"T00:00"):null};c.prototype.getFormat=function(){if(!this.oFormat){var t=e({strictParsing:true},this.oFormatOptions);t.UTC=true;this.oFormat=n.getDateInstance(t)}return this.oFormat};c.prototype.getISOStringFromModelValue=function(t){return t?t:null};c.prototype.getModelFormat=function(){return f()};c.prototype.getModelValue=function(t){var e;if(t===null){e=null}else{r.checkDate(t);e=r.getInstance(0);e.setUTCFullYear(t.getFullYear(),t.getMonth(),t.getDate());e=this.getModelFormat().format(e)}this.validateValue(e);return e};c.prototype.getModelValueFromISOString=function(t){return t?t:null};c.prototype.getName=function(){return"sap.ui.model.odata.type.Date"};c.prototype.parseValue=function(t,e){var a;if(t===""||t===null){return null}switch(this.getPrimitiveType(e)){case"object":return f().format(t,false);case"string":a=this.getFormat().parse(t);if(!a){throw new i(this._getErrorMessage())}return f().format(a);default:throw new i("Don't know how to parse "+this.getName()+" from "+e)}};c.prototype.validateValue=function(t){if(t===null){if(this.oConstraints&&this.oConstraints.nullable===false){throw new s(this._getErrorMessage())}}else if(typeof t!=="string"||!u.test(t)){throw new s("Illegal "+this.getName()+" value: "+t)}};c._resetModelFormatter=function(){p=undefined};return c});
//# sourceMappingURL=Date.js.map