/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/util/extend","sap/ui/core/date/UI5Date","sap/ui/core/format/DateFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/odata/type/ODataType"],function(t,e,a,n,o,r,s,i){"use strict";function l(t){return t.oConstraints&&t.oConstraints.isDateOnly}function u(e,a){var n,o;e.oConstraints=undefined;if(a){n=a.nullable;if(n===false||n==="false"){e.oConstraints={nullable:false}}else if(n!==undefined&&n!==true&&n!=="true"){t.warning("Illegal nullable: "+n,null,e.getName())}if(a.isDateOnly===true){e.oConstraints=e.oConstraints||{};e.oConstraints.isDateOnly=true}o=a.precision;if(o!==undefined){if(o===Math.floor(o)&&o>=1&&o<=12){e.oConstraints=e.oConstraints||{};e.oConstraints.precision=o}else if(o!==0){t.warning("Illegal precision: "+o,null,e.getName())}}}e._handleLocalizationChange()}var g=i.extend("sap.ui.model.odata.type.DateTimeBase",{constructor:function(t,e){i.apply(this,arguments);u(this,e);this.oFormat=null;this.oFormatOptions=t},metadata:{abstract:true}});g.prototype.getDateValue=function(t){var e;if(!t){return null}e=a.getInstance(t);if(l(this)){e.setFullYear(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate());e.setHours(0,0,0,0)}else if(this.oFormatOptions&&this.oFormatOptions.UTC){e.setFullYear(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate());e.setHours(e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds())}return e};g.prototype.formatValue=function(t,e){if(t===null||t===undefined){return null}switch(this.getPrimitiveType(e)){case"any":return t;case"object":if(l(this)){return this.getDateValue(t)}return t;case"string":if(!(t instanceof Date)){throw new o("Illegal "+this.getName()+" value: "+t)}return this.getFormat().format(t);default:throw new o("Don't know how to format "+this.getName()+" to "+e)}};g.prototype.getFormat=function(){if(!this.oFormat){var t=e({strictParsing:true},this.oFormatOptions);if(l(this)){t.UTC=true;this.oFormat=n.getDateInstance(t)}else{this.oFormat=n.getDateTimeInstance(t)}}return this.oFormat};g.prototype._getErrorMessage=function(){var t=a.getInstance().getFullYear(),e=l(this)?new Date(Date.UTC(t,11,31)):a.getInstance(t,11,31,23,59,58),n=l(this)?"EnterDate":"EnterDateTime",o=sap.ui.getCore().getLibraryResourceBundle();return o.getText(n,[this.formatValue(e,"string")])};g.prototype.parseValue=function(t,e){var a;if(t===null||t===""){return null}switch(this.getPrimitiveType(e)){case"object":if(l(this)){return this._getModelValue(t)}return t;case"string":a=this.getFormat().parse(t);if(!a){throw new r(this._getErrorMessage())}return a;default:throw new r("Don't know how to parse "+this.getName()+" from "+e)}};g.prototype._handleLocalizationChange=function(){this.oFormat=null};g.prototype.validateValue=function(t){if(t===null){if(this.oConstraints&&this.oConstraints.nullable===false){throw new s(this._getErrorMessage())}return}else if(t instanceof Date){if(t.getFullYear()===0){throw new s(this._getErrorMessage())}return}throw new s("Illegal "+this.getName()+" value: "+t)};g.prototype._getModelValue=function(t){var e;if(t===null){return null}a.checkDate(t);e=a.getInstance(t);if(l(this)){e.setUTCFullYear(t.getFullYear(),t.getMonth(),t.getDate());e.setUTCHours(0,0,0,0)}else if(this.oFormatOptions&&this.oFormatOptions.UTC){e.setUTCFullYear(t.getFullYear(),t.getMonth(),t.getDate());e.setUTCHours(t.getHours(),t.getMinutes(),t.getSeconds(),t.getMilliseconds())}return e};return g});
//# sourceMappingURL=DateTimeBase.js.map