/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_CreatedContextsCache","./Context","./ODataAnnotations","./ODataContextBinding","./ODataListBinding","./ODataTreeBinding","sap/base/assert","sap/base/Log","sap/base/security/encodeURL","sap/base/util/deepEqual","sap/base/util/deepExtend","sap/base/util/each","sap/base/util/extend","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/util/merge","sap/base/util/uid","sap/base/util/UriParameters","sap/ui/base/SyncPromise","sap/ui/core/Configuration","sap/ui/core/library","sap/ui/core/Messaging","sap/ui/core/message/Message","sap/ui/core/message/MessageParser","sap/ui/core/Supportability","sap/ui/model/_Helper","sap/ui/model/BindingMode","sap/ui/model/Context","sap/ui/model/FilterProcessor","sap/ui/model/Model","sap/ui/model/odata/CountMode","sap/ui/model/odata/MessageScope","sap/ui/model/odata/ODataMetadata","sap/ui/model/odata/ODataMetaModel","sap/ui/model/odata/ODataMessageParser","sap/ui/model/odata/ODataPropertyBinding","sap/ui/model/odata/ODataUtils","sap/ui/model/odata/OperationMode","sap/ui/model/odata/UpdateMethod","sap/ui/thirdparty/datajs","sap/ui/thirdparty/URI","sap/ui/util/isCrossOriginURL"],function(e,t,a,s,r,i,n,o,d,u,h,f,c,p,l,g,_,m,y,v,b,C,P,q,M,R,E,S,T,x,A,U,I,D,O,k,H,B,L,F,w,G){"use strict";var j="sap.ui.model.odata.v2.ODataModel",N=["context","properties"],W=b.MessageType,$={},K=["groupId","urlParameters"];const z=/\/~[\w\-]+~[A-Z0-9]?/;$[W.Error]=0;$[W.Warning]=1;$[W.Success]=2;$[W.Information]=3;$[W.None]=4;var Q=x.extend("sap.ui.model.odata.v2.ODataModel",{constructor:function(t,s){x.apply(this,arguments);var r,i,n,o,d,u,h,f,c,p,l,g,_,m,y,b,C,P,q,R,S,T,D,O,k,F,w,j,N,W,$,K=this;if(typeof t==="object"){s=t;this.sServiceUrl=s.serviceUrl}else{this.sServiceUrl=t}this.mCodeListModelParams=this.createCodeListModelParameters(s);if(s){r=s.user;i=s.password;n=s.headers;o=s.tokenHandling;d=s.withCredentials;u=s.maxDataServiceVersion;h=s.useBatch;f=s.refreshAfterChange;c=s.annotationURI;p=s.loadAnnotationsJoined;_=s.defaultBindingMode;l=s.defaultCountMode;g=s.preliminaryContext;m=s.defaultOperationMode;y=s.metadataNamespaces;b=s.serviceUrlParams;C=s.metadataUrlParams;P=s.json;q=s.messageParser;R=s.skipMetadataAnnotationParsing;S=s.defaultUpdateMethod;T=s.disableHeadRequestForToken;D=s.sequentializeRequests;O=s.disableSoftStateHeader;k=s.bindableResponseHeaders;F=s.warmupUrl;w=s.canonicalRequests;j=s.tokenHandlingForGet;N=s.earlyTokenRequest;W=s.persistTechnicalMessages;$=s.ignoreAnnotationsFromMetadata}this.mPathCache={};this.mInvalidatedPaths={};this.bCanonicalRequests=!!w;this.bTokenHandlingForGet=!!j;this.sMessageScope=U.RequestedObjects;this.sWarmupUrl=F;this.bWarmup=!!F;this.mSupportedBindingModes={OneWay:true,OneTime:true,TwoWay:true};this.mUnsupportedFilterOperators={Any:true,All:true};this.sDefaultBindingMode=_||E.OneWay;this.bIsMessageScopeSupported=false;this.iPendingDeferredRequests=0;this.bJSON=P!==false;this.aPendingRequestHandles=[];this.aCallAfterUpdate=[];this.mRequests={};this.mDeferredRequests={};this.mChangedEntities={};this.mChangeHandles={};this.mDeferredGroups={};this.mLaunderingState={};this.sDefaultUpdateMethod=S||L.Merge;this.bTokenHandling=o!==false;this.bWithCredentials=d===true;this.bUseBatch=h!==false;this.bRefreshAfterChange=f!==false;this.sMaxDataServiceVersion=u;this.bLoadAnnotationsJoined=p!==false;this.sAnnotationURI=c;this.sDefaultCountMode=l||A.Request;this.sDefaultOperationMode=m||B.Default;this.sMetadataLoadEvent=null;this.oMetadataFailedEvent=null;this.sRefreshGroupId=undefined;this.bIncludeInCurrentBatch=false;this.bSkipMetadataAnnotationParsing=!!R;this.bDisableHeadRequestForToken=!!T;this.bSequentializeRequests=!!D;this.bDisableSoftStateHeader=!!O;this.aBindableResponseHeaders=k?k:null;this.bPreliminaryContext=g||false;this.mMetadataUrlParams=C||{};this.mChangedEntities4checkUpdate={};this.bPersistTechnicalMessages=W===undefined?undefined:!!W;this.oCreatedContextsCache=new e;this.aSideEffectCleanUpFunctions=[];this.oTransitionMessagesOnlyGroups=new Set;this.bIgnoreAnnotationsFromMetadata=!!$;if(q){q.setProcessor(this)}this.oMessageParser=q;this.setDeferredGroups(["changes"]);this.setChangeGroups({"*":{groupId:"changes"}});this.oData={};this.oMetadata=null;this.oAnnotations=null;this.aUrlParams=[];this.pSequentialRequestCompleted=Promise.resolve();this.pReadyForRequest=Promise.resolve();var z=this.sServiceUrl.split("?");if(z.length>1){this.sServiceUrl=z[0];if(z[1]){this.aUrlParams.push(z[1])}}this.sServiceUrl=this.sServiceUrl.replace(/\/$/,"");this.sUser=r;this.sPassword=i;if(M.isStatisticsEnabled()){this.aUrlParams.push("sap-statistics=true")}this.oHeaders={};this.setHeaders(n);if(!this.bDisableSoftStateHeader){this.oHeaders["sap-contextid-accept"]="header";this.mCustomHeaders["sap-contextid-accept"]="header"}this.sMetadataUrl=this.sWarmupUrl||this._createMetadataUrl("/$metadata");this.oSharedServerData=o==="skipServerCache"?undefined:Q._getSharedData("server",this._getServerUrl());this.oSharedServiceData=Q._getSharedData("service",this.sServiceUrl);this.oSharedMetaData=Q._getSharedData("meta",this.sMetadataUrl);this.bUseCache=this._cacheSupported(this.sMetadataUrl);if(!this.oSharedMetaData.oMetadata||this.oSharedMetaData.oMetadata.bFailed){this.oMetadata=new I(this.sMetadataUrl,{async:true,cacheKey:this.bUseCache?this.sMetadataUrl:undefined,user:this.sUser,password:this.sPassword,headers:this.mCustomHeaders,namespaces:y,withCredentials:this.bWithCredentials});if(!this.bWarmup){this.oSharedMetaData.oMetadata=this.oMetadata}}else{this.oMetadata=this.oSharedMetaData.oMetadata}this.oAnnotations=new a(this.oMetadata,{source:this.sAnnotationURI,skipMetadata:this.bSkipMetadataAnnotationParsing||this.bIgnoreAnnotationsFromMetadata,headers:this.mCustomHeaders,combineEvents:true,cacheKey:this._getAnnotationCacheKey(this.sMetadataUrl),useCache:this.bUseCache});if(!this.bDisableSoftStateHeader){delete this.mCustomHeaders["sap-contextid-accept"]}this.oAnnotations.attachAllFailed(this.onAnnotationsFailed,this);this.oAnnotations.attachSomeLoaded(this.onAnnotationsLoaded,this);this.pAnnotationsLoaded=this.oAnnotations.loaded();if(b){this.aUrlParams=this.aUrlParams.concat(H._createUrlParamsArray(b))}this.onMetadataFailed=function(e){K.fireMetadataFailed(e.getParameters())};if(!this.oMetadata.isLoaded()){this.oMetadata.attachFailed(this.onMetadataFailed)}this.oMetadata.loaded().then(function(){K._initializeMetadata()});if(this.bJSON){if(this.sMaxDataServiceVersion==="3.0"){this.oHeaders["Accept"]="application/json;odata=fullmetadata"}else{this.oHeaders["Accept"]="application/json"}}else{this.oHeaders["Accept"]="application/atom+xml,application/atomsvc+xml,application/xml"}if(this.bTokenHandling){if(this.oSharedServiceData.securityToken){this.oHeaders["x-csrf-token"]=this.oSharedServiceData.securityToken}else if(this.oSharedServerData&&this.oSharedServerData.securityToken){this.oSharedServiceData.securityToken=this.oSharedServerData.securityToken;this.oHeaders["x-csrf-token"]=this.oSharedServiceData.securityToken}if(N){this.securityTokenAvailable()}}this.oHeaders["Accept-Language"]=v.getLanguageTag();this.oHeaders["DataServiceVersion"]="2.0";this.oHeaders["MaxDataServiceVersion"]="2.0";if(this.sMaxDataServiceVersion){this.oHeaders["MaxDataServiceVersion"]=this.sMaxDataServiceVersion}if(!this.mCustomHeaders["X-Requested-With"]&&!G(this.sServiceUrl)){this.oHeaders["X-Requested-With"]="XMLHttpRequest"}},metadata:{publicMethods:["read","create","update","remove","submitChanges","getServiceMetadata","metadataLoaded","hasPendingChanges","getPendingChanges","refresh","refreshMetadata","resetChanges","setDefaultCountMode","setDefaultBindingMode","getDefaultBindingMode","getDefaultCountMode","setProperty","getSecurityToken","refreshSecurityToken","setHeaders","getHeaders","setUseBatch","setDeferredBatchGroups","getDeferredBatchGroups","setChangeBatchGroups","getChangeBatchGroups"]}});Q.M_EVENTS={MetadataLoaded:"metadataLoaded",MetadataFailed:"metadataFailed",AnnotationsLoaded:"annotationsLoaded",AnnotationsFailed:"annotationsFailed",BatchRequestFailed:"batchRequestFailed",BatchRequestSent:"batchRequestSent",BatchRequestCompleted:"batchRequestCompleted"};Q.prototype.attachBatchRequestFailed=function(e,t,a){this.attachEvent("batchRequestFailed",e,t,a);return this};Q.prototype.detachBatchRequestFailed=function(e,t){this.detachEvent("batchRequestFailed",e,t);return this};Q.prototype.fireBatchRequestFailed=function(e){this.fireEvent("batchRequestFailed",e);return this};Q.prototype.attachBatchRequestSent=function(e,t,a){this.attachEvent("batchRequestSent",e,t,a);return this};Q.prototype.detachBatchRequestSent=function(e,t){this.detachEvent("batchRequestSent",e,t);return this};Q.prototype.fireBatchRequestSent=function(e){this.fireEvent("batchRequestSent",e);return this};Q.prototype.attachBatchRequestCompleted=function(e,t,a){this.attachEvent("batchRequestCompleted",e,t,a);return this};Q.prototype.detachBatchRequestCompleted=function(e,t){this.detachEvent("batchRequestCompleted",e,t);return this};Q.prototype.fireBatchRequestCompleted=function(e){this.fireEvent("batchRequestCompleted",e);return this};Q.mSharedData={server:{},service:{},meta:{}};Q._getSharedData=function(e,t){var a=this.mSharedData[e][t];if(!a){a={};this.mSharedData[e][t]=a}return a};Q.prototype._initializeMetadata=function(){if(this.bDestroyed){return}this.bIsMessageScopeSupported=this.oMetadata._isMessageScopeSupported();var e=function(){this.fireMetadataLoaded({metadata:this.oMetadata});o.debug(this+" - metadataloaded fired")}.bind(this);this.initialize();if(this.bLoadAnnotationsJoined){this.oAnnotations.loaded().then(e,this.fireMetadataFailed.bind(this))}else{e()}};Q.prototype.refreshMetadata=function(){if(this.oMetadata&&this.oMetadata.refresh){return this.oMetadata.refresh()}return undefined};Q.prototype.fireAnnotationsLoaded=function(e){this.fireEvent("annotationsLoaded",e);return this};Q.prototype.attachAnnotationsLoaded=function(e,t,a){this.attachEvent("annotationsLoaded",e,t,a);return this};Q.prototype.detachAnnotationsLoaded=function(e,t){this.detachEvent("annotationsLoaded",e,t);return this};Q.prototype.fireAnnotationsFailed=function(e){this.fireEvent("annotationsFailed",e);o.debug(this+" - annotationsfailed fired");return this};Q.prototype.attachAnnotationsFailed=function(e,t,a){this.attachEvent("annotationsFailed",e,t,a);return this};Q.prototype.detachAnnotationsFailed=function(e,t){this.detachEvent("annotationsFailed",e,t);return this};Q.prototype.fireMetadataLoaded=function(e){this.fireEvent("metadataLoaded",e);return this};Q.prototype.attachMetadataLoaded=function(e,t,a){this.attachEvent("metadataLoaded",e,t,a);return this};Q.prototype.detachMetadataLoaded=function(e,t){this.detachEvent("metadataLoaded",e,t);return this};Q.prototype.fireMetadataFailed=function(e){this.fireEvent("metadataFailed",e);return this};Q.prototype.attachMetadataFailed=function(e,t,a){this.attachEvent("metadataFailed",e,t,a);return this};Q.prototype.detachMetadataFailed=function(e,t){this.detachEvent("metadataFailed",e,t);return this};Q.prototype._createEventInfo=function(e,t,a){var s,r,i={};i.url=e.requestUri;i.method=e.method;i.async=e.async;i.headers=e.headers;if(a){i.requests=[];for(var n=0;n<a.length;n++){r={};if(Array.isArray(a[n])){var o=a[n];for(var d=0;d<o.length;d++){e=o[d].request;s=a[n][d].response;r={};r.url=e.requestUri;r.method=e.method;r.headers=e.headers;if(s){r.response={};if(e._aborted){r.success=false;r.response.statusCode=0;r.response.statusText="abort"}else{r.success=true;if(s.message){r.response.message=s.message;s=s.response;r.response.responseText=s.body;r.success=false}r.response.headers=s.headers;r.response.statusCode=s.statusCode;r.response.statusText=s.statusText}}i.requests.push(r)}}else{e=a[n].request;s=a[n].response;r.url=e.requestUri;r.method=e.method;r.headers=e.headers;if(s){r.response={};if(e._aborted){r.success=false;r.response.statusCode=0;r.response.statusText="abort"}else{r.success=true;if(s.message){r.response.message=s.message;s=s.response;r.response.responseText=s.body;r.success=false}r.response.headers=s.headers;r.response.statusCode=s.statusCode;r.response.statusText=s.statusText}}i.requests.push(r)}}}if(t){i.response={};i.success=true;if(t.message){i.response.message=t.message;i.success=false}if(t.response){t=t.response}if(t&&t.statusCode!=undefined){i.response.headers=t.headers;i.response.statusCode=t.statusCode;i.response.statusText=t.statusText;i.response.responseText=t.body!==undefined?t.body:t.responseText;if(t.expandAfterCreateFailed){i.response.expandAfterCreateFailed=true}if(t.expandAfterFunctionCallFailed){i.response.expandAfterFunctionCallFailed=true}}}i.ID=e.requestID;return i};Q.prototype._createRequestID=function(){var e;e=_();return e};Q.prototype._getServerUrl=function(){var e,t;e=new w(this.sServiceUrl).absoluteTo(document.baseURI);t=new w("/").absoluteTo(e).toString();return t};Q.prototype._createMetadataUrl=function(e){if(e.indexOf(this.sServiceUrl)==-1){if(!e.startsWith("/")){e="/"+e}e=this.sServiceUrl+e}var t=m.fromURL(e||window.location.href);var a=Object.assign({},this.mMetadataUrlParams);Array.from(t.keys()).forEach(function(e){a[e]=t.get(e)});var s=H._createUrlParamsArray(a);var r=e.split("?");if(r.length>1){e=r[0]}return this._addUrlParams(e,s)};Q.prototype._addUrlParams=function(e,t){var a=[];if(this.aUrlParams){a=a.concat(this.aUrlParams)}if(t){a=a.concat(t)}if(a.length>0){e+="?"+a.join("&")}return e};Q.prototype._createRequestUrl=function(e,t,a,s){return this._createRequestUrlWithNormalizedPath(this._normalizePath(e,t),a,s)};Q.prototype._createRequestUrlWithNormalizedPath=function(e,t,a){var s="";if(!a){s=this.sServiceUrl+e}else{s=e.substr(e.indexOf("/")+1)}return this._addUrlParams(s,t)};Q.prototype._importData=function(e,t,a,s,r,i,n,o,d,u){var h=this,c,l,g,_;r=r||"";n=n||"";if(e.results&&Array.isArray(e.results)){c=[];f(e.results,function(e,s){var n=h._getKey(s);n=h._importData(s,t,a,undefined,r.substr(0,r.lastIndexOf("/")),i,n,undefined,undefined,u);if(n){c.push(n)}});return c}else{if(n){r="/"+n;i+=n.substr(n.indexOf("("))}else{n=this._getKey(e)}if(!n){return n}g=this._getEntity(n);_=g;if(!g||g.__metadata&&g.__metadata.invalid){if(!_){_=e}g=e;n=this._addEntity(g)}if(this.aBindableResponseHeaders){var m={};for(var y in a.headers){var v=y.toLowerCase();if(this.aBindableResponseHeaders.indexOf(v)>-1){m[v]=a.headers[y]}}if(!p(m)){if(!e.__metadata){e.__metadata={}}e.__metadata.headers=m}}f(e,function(e,s){if(s&&(s.__metadata&&s.__metadata.uri||s.results)&&!s.__deferred){var o=r+"/"+e;var d=i+"/"+e;l=h._importData(s,t,a,undefined,o,d,undefined,false,"/"+n+"/"+e,u);if(Array.isArray(l)){g[e]={__list:l};if(u){g[e].__list.sideEffects=true;h.aSideEffectCleanUpFunctions.push(function(){delete g[e]})}}else{if(_[e]&&_[e].__ref){if(_[e].__ref!==l){h.mInvalidatedPaths[r.substr(r.lastIndexOf("("))+"/"+e]="/"+l}}g[e]={__ref:l}}}else if(!s||!s.__deferred){if(_[e]&&s===null){h.mInvalidatedPaths[r.substr(r.lastIndexOf("("))+"/"+e]=null}g[e]=s}});if(this.hasContext("/"+n)&&this.getContext("/"+n).isPreliminary()){var b=this.getContext("/"+n);b.setUpdated(true);this.callAfterUpdate(function(){b.setUpdated(false)});b.setPreliminary(false)}if(s&&s.created&&s.key){this._cleanupAfterCreate(s,n)}this._updateChangedEntity(n,g);t[n]=true;r=r||"/"+n;i=i||r;var C=this.resolveFromCache(i);if(C==="/"+n||C&&C.split("/").length>2){this._writePathCache(C,"/"+n,o)}this._writePathCache(r,"/"+n,o);this._writePathCache(i,"/"+n,o,true);if(d){this._writePathCache(d,"/"+n,o)}return n}};Q.prototype._writePathCache=function(e,t,a,s){var r,i,n,o,d,u;if(e&&t){if(!this.mPathCache[e]){this.mPathCache[e]={}}if(!a&&e.lastIndexOf("/")===0){t=e}this.mPathCache[e].canonicalPath=t;if(s){d=e.split("/");for(u=3;u<d.length;u+=1){n=d.slice(0,u).join("/");o=this.mPathCache[n];if(o){r=o.canonicalPath+e.slice(n.length);i=this.mPathCache[r];if(i){i.canonicalPath=t}}}}}};Q.prototype._removeReferences=function(e){var t=this,a;if(!e){return e}if(e.results){a=[];f(e.results,function(e,s){a.push(t._removeReferences(s))});return a}else{f(e,function(t,a){if(a){if(a["__ref"]||a["__list"]){delete e[t]}}});return e}};Q.prototype._restoreReferences=function(e,t){var a=this,s,r,i;function o(e){var s=t[e];if(!s){s=a._getObject("/"+e);n(s,"ODataModel inconsistent: "+e+" not found!");if(s){s=g({},s);t[e]=s;a._restoreReferences(s,t)}}return s}if(!t){t={}}f(e,function(t,a){if(a){if(a.__ref){s=a.__ref;r=o(s);if(r){e[t]=r}delete a.__ref}else if(a.__list){i=[];f(a.__list,function(e,t){r=o(t);if(r){i.push(r)}});delete a.__list;a.results=i}}});return e};Q.prototype.removeData=function(){this.oData={}};Q.prototype.initialize=function(){var e=this.getBindings();e.forEach(function(e){e.initialize()})};Q.prototype.invalidate=function(e){var t;for(var a in this.oData){t=this.oData[a];if(!e||e(a,t)){t.__metadata.invalid=true}}};Q.prototype.invalidateEntry=function(e){var t;if(typeof e==="string"){if(e.indexOf("/")===0){t=this._getObject(e)}else{t=this.oData[e]}}else if(e instanceof S){t=this._getObject(e.getPath())}if(t&&t.__metadata){t.__metadata.invalid=true}};Q.prototype.invalidateEntityType=function(e){var t;for(var a in this.oData){t=this.oData[a];if(t.__metadata.type===e){t.__metadata.invalid=true}}};Q.prototype.refresh=function(e,t,a){if(typeof e==="string"){a=e;e=false;t=false}if(t){this.removeData()}this._refresh(e,a)};Q.prototype._refresh=function(e,t,a,s){var r=this.getBindings();this.sRefreshGroupId=t;r.forEach(function(t){t._refresh(e,a,s)});this.sRefreshGroupId=undefined};Q.prototype.checkUpdate=function(e,t,a,s){if(t){this.bForceUpdate=this.bForceUpdate||e;Object.assign(this.mChangedEntities4checkUpdate,a);if(!this.sUpdateTimer){this.sUpdateTimer=setTimeout(function(){this.checkUpdate(this.bForceUpdate,false,this.mChangedEntities4checkUpdate)}.bind(this),0)}return}e=this.bForceUpdate||e;if(this.sUpdateTimer){clearTimeout(this.sUpdateTimer);this.sUpdateTimer=null;this.bForceUpdate=undefined;this.mChangedEntities4checkUpdate={}}var r=this.getBindings();r.forEach(function(t){if(!s||this.isMetaModelPath(t.getPath())){t.checkUpdate(e,a)}}.bind(this));this._processAfterUpdate()};Q.prototype.checkDataState=function(e){var t=this.getBindings();t.forEach(function(t){if(t.checkDataState){t.checkDataState(e)}})};Q.prototype.bindProperty=function(e,t,a){var s=new k(this,e,t,a);return s};Q.prototype.bindList=function(e,t,a,s,i){var n=new r(this,e,t,a,s,i);return n};Q.prototype.bindTree=function(e,t,a,s,r){var n=new i(this,e,t,a,s,r);return n};Q.prototype.createBindingContext=function(e,t,a,s,r){var i,n,o,d,u,h,f,c,p,l=this;if(t!==null&&typeof t==="object"&&!(t instanceof S)){r=s;s=a;a=t;t=undefined}if(typeof t=="function"){r=a;s=t;a=undefined;t=undefined}if(typeof t=="boolean"){r=t;s=undefined;a=undefined;t=undefined}if(typeof a=="function"){r=s;s=a;a=undefined}if(typeof a=="boolean"){r=a;s=undefined;a=undefined}if(typeof s=="boolean"){r=s;s=undefined}if(a){i=a.canonicalRequest}i=this._isCanonicalRequestNeeded(i);p=this.resolve(e,t,i);if(!p&&i){p=this.resolve(e,t)}d=this.resolveDeep(e,t);if(!p){if(s){s(null)}return null}if(r===undefined){r=this._isReloadNeeded(p,a)}if(!r){n=this.resolve(e,t,true);if(n){f=this.getContext(n,d)}else{f=null}if(s){s(f)}return f}function g(a){var r=a?l._getKey(a):null,i=!(e===""||e.indexOf("/")>0),n=null,o,u;f=null;if(r){f=l.getContext("/"+r,d);n={__ref:r}}if(t&&h&&i){o=t.getPath();o=o.substr(1);u=l._getEntity(o);if(u){u[e]=n}}s(f)}function _(a){var r;if(a.statusCode=="404"&&t&&h){var i=t.getPath();i=i.substr(1);r=l._getEntity(i);if(r){r[e]={__ref:null}}}s(null)}if(s){h=!e.startsWith("/");c=[];o=this.createCustomParams(a);if(o){c.push(o)}if(a&&(a.batchGroupId||a.groupId)){u=a.groupId||a.batchGroupId}this.read(e,{canonicalRequest:i,context:t,error:_,groupId:u,success:g,updateAggregatedMessages:true,urlParameters:c})}if(a&&a.createPreliminaryContext){p=this.resolve(e,t,i);if(!p&&i){p=this.resolve(e,t)}f=this.getContext(p,d);return f}return undefined};Q.prototype._updateContext=function(e,t,a){e.sPath=t;if(a!==undefined){e.sDeepPath=a}this.mContexts[t]=e};Q.prototype._splitEntries=function(e){return e.replace(/\s/g,"").split(",").map(function(e){return e.split("/")})};Q.prototype._filterOwnSelect=function(e,t){var a,s;if(!t){return[]}s=t.map(function(e){return e.name});a=e.filter(function(e){return e.length===1}).map(function(e){return e[0]});if(e.length===0||a.indexOf("*")!==-1||a.indexOf("**")!==-1){return s}else{return a.filter(function(e){return s.indexOf(e)!==-1})}};Q.prototype._filterOwnExpand=function(e,t){return e.map(function(e){return e[0]}).filter(function(e,t,a){return a.indexOf(e)===t}).filter(function(e){return t.length===0||t.some(function(t){return t.indexOf(e)===0||t.indexOf("**")===0})})};Q.prototype._filterSelectByNavProp=function(e,t){return e.filter(function(e){return e[0]===t}).map(function(e){return e.length>1?e.slice(1):["**"]})};Q.prototype._filterExpandByNavProp=function(e,t){return e.filter(function(e){return e.length>1&&e[0]===t}).map(function(e){return e.slice(1)})};Q.prototype._isReloadNeeded=function(e,t){var a=this,s=this.oMetadata,r,i=[],n=[];if(!this.oMetadata.isLoaded()){return true}var o;if(t){o=t.canonicalRequest}o=this._isCanonicalRequestNeeded(o);if(o){e=this.resolve(e,undefined,o)||e}var d=this._getObject(e);r=this.oMetadata._getEntityTypeByPath(e);if(this._isCreatedEntity(d)){return false}function u(e,t,r,i){var n,o,d,h,f,c,p,l,g,_;if(!e){return false}if(t===null){return false}if(!t){return true}if(t.__metadata&&t.__metadata.invalid){return true}g=a._filterOwnSelect(r,e.property);for(o=0;o<g.length;o++){_=g[o];if(t[_]===undefined){return true}}l=a._filterOwnExpand(i,r);for(o=0;o<l.length;o++){n=l[o];d=t[n];if(d===null){continue}if(d===undefined||d.__deferred){return true}f=s._getEntityTypeByNavProperty(e,n);p=a._filterSelectByNavProp(r,n);c=a._filterExpandByNavProp(i,n);if(d.__ref){h=a._getEntity(d.__ref);if(u(f,h,p,c)){return true}}if(d.__list){for(var m=0;m<d.__list.length;m++){h=a._getEntity(d.__list[m]);if(u(f,h,p,c)){return true}}}}return false}if(t){if(t.select){n=this._splitEntries(t.select)}if(t.expand){i=this._splitEntries(t.expand)}}return u(r,d,n,i)};Q.prototype.createCustomParams=function(e){var t=[],a,s={expand:true,select:true};for(var r in e){if(r in s){t.push("$"+r+"="+d(e[r]))}if(r==="custom"){a=e[r];for(r in a){if(r.indexOf("$")===0){o.warning(this+" - Trying to set OData parameter '"+r+"' as custom query option!")}else if(typeof a[r]==="string"){t.push(r+"="+d(a[r]))}else{t.push(r)}}}}return t.join("&")};Q.prototype.bindContext=function(e,t,a){var r=new s(this,e,t,a);return r};Q.prototype.setDefaultCountMode=function(e){this.sDefaultCountMode=e};Q.prototype.getDefaultCountMode=function(){return this.sDefaultCountMode};Q.prototype._addEntity=function(e){var t=this._getKey(e);this.oData[t]=e;return t};Q.prototype._removeEntity=function(e){e=e&&H._normalizeKey(e);delete this.oData[e];delete this.mChangedEntities[e];delete this.mContexts["/"+e]};Q.prototype._getEntity=function(e){var t=this.oData[e];if(!t){e=e&&H._normalizeKey(e);t=this.oData[e]}return t};Q.prototype._getKey=function(e){var t,a;if(e instanceof S){t=e.getPath().substr(1)}else if(e&&e.__metadata&&e.__metadata.uri){a=e.__metadata.uri;t=a.substr(a.lastIndexOf("/")+1)}else if(typeof e==="string"){t=e.substr(e.lastIndexOf("/")+1)}if(!this.oData[t]){t=t&&H._normalizeKey(t)}return t};Q.prototype.getKey=function(e){return this._getKey(e)};Q.prototype.createKey=function(e,t){var a=this.oMetadata._getEntityTypeByPath(e),s=e,r=this,i,o;n(a,'Could not find entity type of collection "'+e+'" in service metadata!');s+="(";if(a.key.propertyRef.length===1){i=a.key.propertyRef[0].name;n(i in t,'Key property "'+i+'" is missing in object!');o=this.oMetadata._getPropertyMetadata(a,i);s+=encodeURIComponent(H.formatValue(t[i],o.type))}else{f(a.key.propertyRef,function(e,d){if(e>0){s+=","}i=d.name;n(i in t,'Key property "'+i+'" is missing in object!');o=r.oMetadata._getPropertyMetadata(a,i);s+=i;s+="=";s+=encodeURIComponent(H.formatValue(t[i],o.type))})}s+=")";return s};Q.prototype.getProperty=function(e,t,a){var s=this._getObject(e,t);if(!a){return s}if(!l(s)){return s}s=g({},s);if(a===true){return this._restoreReferences(s)}else{return this._removeReferences(s)}};Q.prototype.getObject=function(e,t,a){if(l(t)){a=t;t=undefined}var s=this,r=this.resolve(e,t),i=this._getObject(r),n=this.oMetadata._getEntityTypeByPath(r),d=[],u=[];if(!n||!l(i)||!i.__metadata||!i.__metadata.uri){return i}if(!a||!(a.select||a.expand)){return g({},i)}function h(e,t,a,r){var i,n,d,u,f,c,p,l,g,_,m,y,v,b;if(!t){return undefined}if(!e){return undefined}m=s._filterOwnSelect(a,e.property);v={};for(n=0;n<m.length;n++){b=m[n];if(t[b]!==undefined||t.__metadata.created){v[b]=t[b]}else{o.fatal("No data loaded for select property: "+b+" of entry: "+s.getKey(t));return undefined}}if(t.__metadata){v.__metadata=t.__metadata}g=s._filterOwnExpand(r,a);for(n=0;n<g.length;n++){i=g[n];d=t[i];u=s.oMetadata._getEntityTypeByNavProperty(e,i);p=s._filterSelectByNavProp(a,i);f=s._filterExpandByNavProp(r,i);if(d&&d.__ref){c=s._getObject("/"+d.__ref);l=h(u,c,p,f);if(l!==undefined){v[i]=l}else{o.fatal("No data loaded for expand property: "+i+" of entry: "+s.getKey(l));return undefined}}if(d&&d.__list){y=[];for(var C=0;C<d.__list.length;C++){c=s._getObject("/"+d.__list[C]);l=h(u,c,p,f);if(l!==undefined){y.push(l)}else{o.fatal("No data loaded for expand property: "+i+" of entry: "+s.getKey(l));return undefined}}v[i]=y}}_=s._filterOwnSelect(a,e.navigationProperty);for(var P=0;P<_.length;P++){i=_[P];if(g.indexOf(i)===-1){var q=v.__metadata.uri+"/"+i;v[i]={__deferred:{uri:q}}}}return v}if(a.select){u=this._splitEntries(a.select)}if(a.expand){d=this._splitEntries(a.expand)}i=h(n,i,u,d);return i};Q.prototype._getObject=function(e,t,a,s){var r,i,n,o,d,u,h,f,c,p,_,m=s?undefined:null,y=this.isLegacySyntax()?this.oData:m;p=this.resolve(e,t,this.bCanonicalRequests);if(!p&&this.bCanonicalRequests){p=this.resolve(e,t)}if(!p){return y}if(e&&e.startsWith("@$ui5.")){return this._getInstanceAnnotationValue(e,t)}if(this._isMetadataPath(p)){if(this.oMetadata&&this.oMetadata.isLoaded()){if(this.isMetaModelPath(p)){h=this.getMetaModel();n=D.getCodeListTerm(p);if(n){i=h.fetchCodeList(n);if(i.isFulfilled()){return i.getResult()}if(i.isRejected()){i.caught()}return undefined}if(!this.bMetaModelLoaded){return null}_=p.indexOf("/##");o=p.substr(0,_);f=p.substr(_+3);u=h.getMetaContext(o);y=h.getProperty(f,u)}else{y=this.oMetadata._getAnnotation(p)}}else if(D.getCodeListTerm(p)){return undefined}}else{if(p==="/"){return this.oData}var v=p.split("/"),b=0;d=v[1];v.splice(0,2);r=this.mChangedEntities[d];c=this._getEntity(d);y=a?c:r||c;while(y&&v[b]){var C=r&&r.hasOwnProperty(v[b]);r=r&&r[v[b]];c=c&&c[v[b]];y=a||!C?c:r;if(y){if(y.__ref){r=this.mChangedEntities[y.__ref];c=this._getEntity(y.__ref);y=a?c:r||c}else if(y.__list){y=y.__list}else if(y.__deferred){y=undefined}}b++}}if(l(r)){y=a?c:g({},c,r)}return y};Q.prototype._getInstanceAnnotationValue=function(e,t){if(e==="@$ui5.context.isInactive"){return t.isInactive()}if(e==="@$ui5.context.isTransient"){return t.isTransient()}throw new Error("Unsupported instance annotation: "+e)};Q.prototype.updateSecurityToken=function(){if(this.bTokenHandling){if(!this.oSharedServiceData.securityToken){this.refreshSecurityToken()}if(this.bTokenHandling){this.oHeaders["x-csrf-token"]=this.oSharedServiceData.securityToken}}};Q.prototype.resetSecurityToken=function(){delete this.oSharedServiceData.securityToken;delete this.oHeaders["x-csrf-token"];delete this.pSecurityToken};Q.prototype.getSecurityToken=function(){var e=this.oSharedServiceData.securityToken;if(!e){this.refreshSecurityToken();e=this.oSharedServiceData.securityToken}return e};Q.prototype.securityTokenAvailable=function(){if(!this.pSecurityToken){if(this.oSharedServiceData.securityToken){this.pSecurityToken=Promise.resolve(this.oSharedServiceData.securityToken)}else{this.pSecurityToken=new Promise(function(e,t){this.refreshSecurityToken(function(){e(this.oSharedServiceData.securityToken)}.bind(this),function(){t()},true)}.bind(this))}}return this.pSecurityToken};Q.prototype.refreshSecurityToken=function(e,t,a){var s,r,i={abort:function(){this.request.abort()}},n=this._createRequestUrlWithNormalizedPath("/"),o=this;function d(t,a){if(a){r=o._getHeader("x-csrf-token",a.headers);o._setSessionContextIdHeader(o._getHeader("sap-contextid",a.headers));if(r){if(o.oSharedServerData){o.oSharedServerData.securityToken=r}o.oSharedServiceData.securityToken=r;o.pSecurityToken=Promise.resolve(r);o.oHeaders["x-csrf-token"]=r}else{o.resetSecurityToken();o.bTokenHandling=false}}if(e){e(t,a)}}function u(e){o.resetSecurityToken();o.bTokenHandling=false;o._handleError(e,s);if(t){t(e)}}function h(e){i.request=f("GET",u)}function f(e,t){s=o._createRequest(n,"",e,o._getHeaders(undefined,true),null,null,!!a);s.headers["x-csrf-token"]="Fetch";return o._request(s,d,t,undefined,undefined,o.getServiceMetadata())}if(this.bDisableHeadRequestForToken){i.request=f("GET",u)}else{i.request=f("HEAD",h)}return i};Q.prototype._submitRequest=function(e,t,a){var s=this,r,i,n,o,d;o=new Promise(function(e,t){d=e});function u(e,a){if(t){t(e,a)}s.aSideEffectCleanUpFunctions.forEach(function(e){e()});s.aSideEffectCleanUpFunctions=[];d()}function h(t){if(s.bTokenHandling&&t.response){var r=s._getHeader("x-csrf-token",t.response.headers);if(!e.bTokenReset&&t.response.statusCode=="403"&&r&&r.toLowerCase()==="required"){s.resetSecurityToken();e.bTokenReset=true;p();return}}if(a){a(t)}d()}function c(e){if(s.bTokenHandling&&(e.method!=="GET"||s.bTokenHandlingForGet)){s.pReadyForRequest=s.securityTokenAvailable()}return s.pReadyForRequest}function p(){if(s.bTokenHandling){delete e.headers["x-csrf-token"]}c(e).then(function(t){if(s.bTokenHandling&&(e.method!=="GET"||s.bTokenHandlingForGet)){e.headers["x-csrf-token"]=t}g()},function(){g()})}function l(e,t,a){var r,i=t.eventInfo.requests;if(i){f(i,function(t,a){if(Array.isArray(a)){a.forEach(function(t){f(t.parts,function(a,i){r=s._createEventInfo(t.request,i.fnError);s["fireRequest"+e](r)})})}else if(a.parts){f(a.parts,function(t,i){r=s._createEventInfo(a.request,i.fnError);s["fireRequest"+e](r)})}else{r=s._createEventInfo(a.request,a.fnError);s["fireRequest"+e](r)}});if(t.eventInfo.batch){r=s._createEventInfo(t,a,i);s["fireBatchRequest"+e](r)}}}function g(){if(s.sSessionContextId){e.headers["sap-contextid"]=s.sSessionContextId}i=s._request(e,u,h,r,undefined,s.getServiceMetadata());if(e.eventInfo){l("Sent",e,null);delete e.eventInfo}if(n&&i){i.abort()}}r=s._getODataHandler(e.requestUri);if(this.bSequentializeRequests){this.pSequentialRequestCompleted.then(function(){p()});this.pSequentialRequestCompleted=o}else{p()}return{abort:function(){if(i){i.abort()}n=true}}};Q.prototype._setSessionContextIdHeader=function(e){if(e){this.sSessionContextId=e}};Q.prototype._submitSingleRequest=function(e){var t=this,a,s={},r={},i={};function n(a,n){if(a===undefined&&n.statusCode===200){o({message:"Response did not contain a valid OData result",response:n});return}function d(a,n){for(var o=0;o<e.parts.length;o++){if(e.parts[o].request._aborted){t._processAborted(e.parts[o].request,n)}else if(e.parts[o].fnSuccess){e.parts[o].fnSuccess(a,n)}}if(e.request.requestUri.indexOf("$count")===-1){t.checkUpdate(false,false,r);if(e.bRefreshAfterChange){t._refresh(false,undefined,s,i)}}}t._processSuccess(e.request,n,d,r,s,i);t._invalidatePathCache();t._setSessionContextIdHeader(t._getHeader("sap-contextid",n.headers))}function o(a){var s;if(a.message=="Request aborted"){for(s=0;s<e.parts.length;s++){t._processAborted(e.parts[s].request,a)}}else{for(s=0;s<e.parts.length;s++){t._processError(e.parts[s].request,a,e.parts[s].fnError)}}t._processAfterUpdate()}e.request.eventInfo={requests:e.parts,batch:false};a=this._submitRequest(e.request,n,o);return a};Q.prototype._submitBatchRequest=function(e,t,a,s){var r=this,i={},n={},o={},d={};function u(e,t,a){var s,u,h;for(h=0;h<e.parts.length;h++){var f,c;if(a||e.parts[h].request._aborted){r._processAborted(e.parts[h].request,t)}else if(t.message){r._processError(e.parts[h].request,t,e.parts[h].fnError)}else{if(e.request.contentID){s=e.request.contentID;if(e.request.created||e.request.functionMetadata){u=r._getKey(t.data);n[s]={key:u,functionImport:!!e.request.functionMetadata,deepPath:e.request.deepPath.replace("('"+s+"')",u.slice(u.indexOf("(")))}}else{u=n[s].key;if(n[s].functionImport){f=e.request.deepPath;c=e.request.requestUri}e.request.requestUri=e.request.requestUri.replace("$"+s,u);e.request.deepPath=n[s].deepPath}}r._processSuccess(e.parts[h].request,t,e.parts[h].fnSuccess,o,i,d,false,undefined,n);if(c){e.request.deepPath=f;e.request.requestUri=c}}}}function h(s,n){if(s===undefined&&n.statusCode===200){c({message:"Response did not contain a valid OData batch result",response:n});return}var h,f,p,l=s.__batchResponses;if(l){var g,_;for(g=0;g<l.length;g++){h=l[g];if(Array.isArray(t[g])){if(h.message){for(_=0;_<t[g].length;_++){h.$reported=false;f=t[g][_];u(f,h);f.response=h}}else{p=h.__changeResponses;for(_=0;_<p.length;_++){var m=p[_];f=t[g][_];u(f,m);f.response=m}}}else{f=t[g];u(f,h);f.response=h}}r._invalidatePathCache();r.checkUpdate(false,false,o)}r._processSuccess(e,n,a,o,i,d,true,t);r._setSessionContextIdHeader(r._getHeader("sap-contextid",n.headers))}function c(a){var i=a.message=="Request aborted";a.$reported=true;f(t,function(e,t){if(Array.isArray(t)){t.forEach(function(e){u(e,a,i)})}else{u(t,a,i)}});r._processAfterUpdate();if(i){r._processAborted(e,a,true)}else{a.$reported=false;r._processError(e,a,s,true,t)}}e.eventInfo={requests:t,batch:true};var p=this._submitRequest(e,h,c);function l(e){var t;for(var a=0;a<e.parts.length;a++){t=e.parts[a].fnError;if(!e.parts[a].request._aborted&&t){t(Q._createAbortedError())}}}var g={abort:function(e){f(t,function(e,t){if(Array.isArray(t)){t.forEach(function(e){l(e)})}else{l(t)}});if(s&&!e){s(Q._createAbortedError())}p.abort()}};return g};Q.prototype._invalidatePathCache=function(){var e=this,t;if(Object.keys(this.mInvalidatedPaths).length>0){Object.keys(this.mPathCache).forEach(function(a){for(var s in e.mInvalidatedPaths){t=a.indexOf(s);if(t>-1){if(t+s.length!==a.length){var r=a.substr(t+s.length);e.mPathCache[a].canonicalPath=e.mInvalidatedPaths[s]===null?null:e.mInvalidatedPaths[s]+r}else{e.mPathCache[a].canonicalPath=e.mInvalidatedPaths[s]}}}})}this.mInvalidatedPaths={}};Q.prototype._createBatchRequest=function(e){var t,a,s={},r={},i="true";r.__batchRequests=e;for(var n in e){if(e[n]&&e[n].__changeRequests||e[n]&&e[n].headers&&e[n].headers["sap-cancel-on-close"]!=="true"){i="false";break}}t=this.sServiceUrl+"/$batch";if(this.aUrlParams.length>0){t+="?"+this.aUrlParams.join("&")}c(s,this.mCustomHeaders,this.oHeaders);s["Accept"]="multipart/mixed";delete s["Content-Type"];s["sap-cancel-on-close"]=i;a={headers:s,requestUri:t,method:"POST",data:r,user:this.sUser,password:this.sPassword,async:true};a.withCredentials=this.bWithCredentials;return a};Q.prototype.abortInternalRequest=function(e,t){var a=this.mRequests;var s,r;if(t){s=t.requestKey;r=t.path}if(e in this.mDeferredGroups){a=this.mDeferredRequests}var i=function(e){for(var t=0;t<e.parts.length;t++){e.parts[t].requestHandle.abort()}};var n=a[e];if(n){if(s in n.map){i(n.map[s])}else if(r){f(n.map,function(e,t){if(e.indexOf(r)>=0){i(t)}})}else if(e&&!t){f(n.map,function(e,t){i(t)})}}};Q.prototype._pushToRequestQueue=function(e,t,a,s,r,i,n,o){var d,u=e[t],h=s.key?s.key:s.method+":"+s.requestUri;if(this.bWarmup){return}if(!u){u={};u.map={};u.requests=[];e[t]=u}if(h in u.map&&(s.key||s.method==="GET")){d=u.map[h];var f=d.request;s.deepPath=f.deepPath;if(d.bRefreshAfterChange===undefined){d.bRefreshAfterChange=o}if(!s.key){d.parts.push({request:s,fnSuccess:r,fnError:i,requestHandle:n})}if(s.method==="GET"){delete f.data}else{f.method=s.method;f.headers=s.headers;f.data=s.data;f.sideEffects=s.sideEffects;if(s.method==="PUT"){delete f.headers["x-http-method"]}if(f._aborted){delete f._aborted}}if(f.functionMetadata){f.requestUri=s.requestUri;f.functionTarget=s.functionTarget}}else{d={request:s,bRefreshAfterChange:o,parts:[{request:s,fnSuccess:r,fnError:i,requestHandle:n}]};if(s.method==="GET"){u.requests.push(d)}else{if(!u.changes){u.changes={}}var c=u.changes[a];if(!c){c=[];u.changes[a]=c}d.changeSetId=a;c.push(d)}u.map[h]=d}};Q.prototype._collectChangedEntities=function(e,t,a){var s=this;if(e.changes){f(e.changes,function(e,r){for(var i=0;i<r.length;i++){if(r[i].bRefreshAfterChange){var n=r[i].request,o="/"+n.requestUri.split("?")[0],d,u;if(n.method==="POST"||n.method==="DELETE"){var h=s.oMetadata._getEntityTypeByPath(o);if(h){a[h.entityType]=true}}else{d=s._getObject(o);if(d){u=s._getKey(d)}else if(o.lastIndexOf("/")===0){u=s._getKey(o)}if(u){t[u]=true}}}}})}};Q.prototype._processRequestQueue=function(e,t,a,s,r){var i=this,n,o=[];function d(e,t){for(var a=0;a<e.parts.length;a++){var s=e.parts[a];if(s.request._aborted){i._processAborted(e.request,null);e.parts.splice(a,1);a--}else if(t){s.request._handle=t;t.iRelevantRequests++}}}function u(){return{iRelevantRequests:0,oRequestHandle:{},abort:function(){this.iRelevantRequests--;if(this.iRelevantRequests===0&&this.oRequestHandle){this.oRequestHandle.abort(true);if(a){a({},undefined)}}}}}if(this.bUseBatch){f(e,function(e,a){if(e===t||!t){var s={},r={};i._collectChangedEntities(a,s,r);if(Object.keys(s).length||Object.keys(r).length){i.bIncludeInCurrentBatch=true;i._refresh(false,e,s,r);i.bIncludeInCurrentBatch=false}}});f(e,function(h,c){if(h===t||!t){var p=[],l=[],g,_;var m=u();if(c.changes){f(c.changes,function(t,a){var s,o,u;g={__changeRequests:[]};_=[];for(o=0;o<a.length;o++){s=a[o].request;R.extend(s.headers,r);n="/"+i.getKey(s.data);i.increaseLaundering(n,s.data);d(a[o],m);if(a[o].parts.length>0){i.removeInternalMetadata(s.data);g.__changeRequests.push(s);if(s.expandRequest){u=a[o].parts[0];i._pushToRequestQueue(e,h,undefined,s.expandRequest,u.fnSuccess,u.fnError,u.requestHandle,false)}_.push(a[o])}}if(g.__changeRequests&&g.__changeRequests.length>0){p.push(g);l.push(_)}})}if(c.requests){var y=c.requests;for(var v=0;v<y.length;v++){d(y[v],m);if(y[v].parts.length>0){p.push(y[v].request);l.push(y[v])}}}if(p.length>0){var b=i._createBatchRequest(p);m.oRequestHandle=i._submitBatchRequest(b,l,a,s);o.push(m.oRequestHandle)}delete e[h]}})}else{f(e,function(a,s){if(a===t||!t){if(s.changes){f(s.changes,function(e,t){for(var a=0;a<t.length;a++){var s=u();n="/"+i.getKey(t[a].request.data);i.increaseLaundering(n,t[a].request.data);d(t[a],s);if(t[a].parts.length>0){i.removeInternalMetadata(t[a].request.data);s.oRequestHandle=i._submitSingleRequest(t[a]);o.push(s.oRequestHandle)}}})}if(s.requests){var r=s.requests;for(var h=0;h<r.length;h++){var c=u();d(r[h],c);if(r[h].parts.length>0){c.oRequestHandle=i._submitSingleRequest(r[h]);o.push(c.oRequestHandle)}}}delete e[a]}})}this.checkDataState(this.mLaunderingState);return o.length==1?o[0]:o};Q.prototype._processRequestQueueAsync=function(e){var t=this;if(!this.pCallAsync){this.pCallAsync=this.oMetadata.loaded().then(function(){return Promise.resolve().then(function(){t._processRequestQueue(e);t.pCallAsync=undefined})})}};Q.prototype._processSuccess=function(e,t,a,s,r,i,n,d,u){var h,p,l,_,m,y,v,b,C,P,q,M,R,E={},S={},T=t.data,x=this;if(!n){p=!["204","205"].includes(String(t.statusCode));R=e.requestUri;q=R.replace(this.sServiceUrl,"");if(!q.startsWith("/")){q="/"+q}C=this._normalizePath(q);m=this.oMetadata._getEntityTypeByPath(C);b=m&&m.isFunction;q=this._normalizePath(q,undefined,!b);this.decreaseLaundering(q,e.data);this._decreaseDeferredRequestCount(e);if(e.functionMetadata){if(t.headers&&t.headers.location){y=t.headers.location;M=y.lastIndexOf(this.sServiceUrl);if(M>-1){h=H._normalizeKey(y.slice(M+this.sServiceUrl.length));if(e.functionTarget===h){l=this.getDeepPathForCanonicalPath(h);if(l){e.deepPath=l}}e.functionTarget=h}}if(e.adjustDeepPath){e.deepPath=e.adjustDeepPath({deepPath:l||e.functionTarget,response:g({},t)})}else if(!l){if(!y){l=this.getDeepPathForCanonicalPath(e.functionTarget)}e.deepPath=l||e.functionTarget}if(u&&e.contentID){u[e.contentID].deepPath=e.deepPath}}if(p&&T===undefined&&t){this._parseResponse(t,e);o.fatal(this+" - No data was retrieved by service: '"+t.requestUri+"'");x.fireRequestCompleted({url:t.requestUri,type:"GET",async:t.async,info:"Accept headers:"+this.oHeaders["Accept"],infoObject:{acceptHeaders:this.oHeaders["Accept"]},success:false});return false}if(T&&!T.__metadata&&T.results&&!Array.isArray(T.results)){T=T.results}if(!t._imported&&T&&(Array.isArray(T)||typeof T=="object")){v=g({},T);if(e.key||e.created){x._importData(v,S,t,e,undefined,undefined,undefined,b,undefined,e.sideEffects)}else{x._importData(v,S,t,e,q,e.deepPath,undefined,b,undefined,e.sideEffects)}t._imported=true}_=this._getEntity(e.key);if(_&&_.__metadata.created&&_.__metadata.created.functionImport){var A=[];var U=_["$result"];if(U&&U.__list){f(S,function(e){A.push(e)});U.__list=A}else if(U&&U.__ref){f(S,function(e){U.__ref=e})}}if(!p){P=q.split("/");if(P[1]){E[P[1]]=e;this._updateChangedEntity(P[1],e.data)}if(e.method==="DELETE"&&P[2]!=="$links"){this._removeEntity(P[1])}}if(p&&e.method==="POST"||e.functionMetadata){if(m){i[m.entityType]=true}if(e.key){if(e.created){this._removeEntity(e.key)}else{delete this.mChangedEntities[e.key]}}}if(!t.$reported){this._parseResponse(t,e,S,E);t.$reported=true}c(s,S);c(r,E);this._updateETag(e,t)}if(a){a(T,t)}var I=this._createEventInfo(e,t,d);if(n){this.fireBatchRequestCompleted(I)}else{this.fireRequestCompleted(I)}return true};Q.prototype._cleanupAfterCreate=function(e,t){var a,s,r,i=this.getContext("/"+e.key),n=e.deepPath,o=this._getEntity(t);if(i.isTransient()&&n.endsWith(")")){e.deepPath=n.slice(0,n.lastIndexOf("("))+t.slice(t.indexOf("("))}this._updateContext(i,"/"+t,e.deepPath);i.setUpdated(true);this.callAfterUpdate(function(){i.setUpdated(false)});delete o.__metadata.created;a=this.mChangedEntities[e.key];if(a){s=this.oMetadata._getNavigationPropertyNames(this.oMetadata._getEntityTypeByPath(t));a=R.merge({},a);a.__metadata=R.merge({},o.__metadata);a.__metadata.deepPath=e.deepPath;for(r in e.data){if(R.deepEqual(e.data[r],a[r])||s.includes(r)){delete a[r]}}this.mChangedEntities[t]=a;this.abortInternalRequest(this._resolveGroup(e.key).groupId,{requestKey:e.key})}};Q.prototype._processError=function(e,t,a,s,r){var i,n;if(e.functionMetadata){e.deepPath=e.functionTarget}i=this._handleError(t,e);if(!s){n="/"+this.getKey(e.data);this.decreaseLaundering(n,e.data);this._decreaseDeferredRequestCount(e)}if(a){a(i)}var o=this._createEventInfo(e,i,r);if(s){this.fireBatchRequestCompleted(o);this.fireBatchRequestFailed(o)}else{this.fireRequestCompleted(o);this.fireRequestFailed(o)}};Q.prototype._processAborted=function(e,t,a){var s,r;if(!a){r="/"+this.getKey(e.data);this.decreaseLaundering(r,e.data);this._decreaseDeferredRequestCount(e)}if(t){s=this._createEventInfo(e,Q._createAbortedError());s.success=false;if(a){this.fireBatchRequestCompleted(s)}else{this.fireRequestCompleted(s)}}};Q.prototype._processAfterUpdate=function(){var e=this.aCallAfterUpdate;this.aCallAfterUpdate=[];for(var t=0;t<e.length;t++){e[t]()}};Q.prototype._processChange=function(e,t,a,s){var r,i,n,o,d,h,c,p,l,_,m,y,v,b,C,P="/"+e,q=this;d=this.oMetadata._getEntityTypeByPath(e);if(!s){s=this.sDefaultUpdateMethod}m=g({},this._getObject(P),t);o=m.__metadata.deepPath;n=m.__metadata.created;if(n){_=n.method?n.method:"POST";e=n.key;c=n.expandRequest;r=n.contentID;p=n.functionImport;if(p){n.urlParameters=this._createFunctionImportParameters(n.key,_,m);m=undefined}else{delete m.__metadata["uri"]}}else if(s==="MERGE"){_="MERGE";v=this._getEntity(e)}else{_="PUT"}if(m&&m.__metadata){for(var M in m.__metadata){if(M!=="type"&&M!=="uri"&&M!=="etag"&&M!=="content_type"&&M!=="media_src"){delete m.__metadata[M]}}}if(m&&d){var R=this.oMetadata._getNavigationPropertyNames(d);R.forEach(function(e){delete m[e]})}if(_==="MERGE"&&d&&v){f(m,function(t,a){if(t!=="__metadata"){if(u(v[t],a)&&!q.isLaundering("/"+e+"/"+t)){delete m[t]}}});var E="/"+e,S;f(m,function(e,t){if(e!=="__metadata"){S=q.getProperty(E+"/"+e+"/#@sap:unit");if(S){if(m[S]===undefined){m[S]=v[S]}}}});if(v.__metadata.etag){m.__metadata.etag=v.__metadata.etag}}m=this._removeReferences(m);C=n&&n.urlParameters?H._createUrlParamsArray(n.urlParameters):undefined;l=n?this._getHeaders(n.headers):this._getHeaders();if(!p&&this._isTransitionMessagesOnly(a)){l["sap-messages"]="transientOnly"}h=n&&n.eTag?n.eTag:this.getETag(m);b=this._createRequestUrl("/"+e,null,C,this.bUseBatch);i=this.getContext(P);y=this._createRequest(b,o,_,l,m,h,undefined,true,i.hasSubContexts());if(n){if(c){y.expandRequest=c;y.contentID=r}if(p){y.functionTarget=this.oMetadata._getCanonicalPathOfFunctionImport(n.functionMetadata,n.urlParameters);y.functionMetadata=n.functionMetadata}else{y.created=true;this._addSubEntitiesToPayload(i,m)}}if(this.bUseBatch){y.requestUri=y.requestUri.replace(this.sServiceUrl+"/","")}return y};Q.prototype._resolveGroup=function(e){var t,a,s,r,i,n,o=e.startsWith("/")?e:"/"+e;r=this._getObject(o);s=r&&r.__metadata&&r.__metadata.created;if(s){return{groupId:s.groupId,changeSetId:s.changeSetId}}i=this.oMetadata._getEntityTypeByPath(o);if(this.mChangeGroups[i.name]){t=this.mChangeGroups[i.name];n=t.groupId;a=t.single?_():t.changeSetId}else if(this.mChangeGroups["*"]){t=this.mChangeGroups["*"];n=t.groupId;a=t.single?_():t.changeSetId}return{groupId:n,changeSetId:a}};Q.prototype._updateETag=function(e,t){var a,s,r;a=e.requestUri.replace(this.sServiceUrl+"/","");if(!a.startsWith("/")){a="/"+a}s=this._getObject(a.split("?")[0],undefined,true);r=this._getHeader("etag",t.headers);if(s&&s.__metadata&&r){s.__metadata.etag=r}};Q.prototype._handleError=function(e,t,a){var s,r={message:e.message};if(e.response){if(!e.$reported){this._parseResponse(e.response,t);if(this.bTokenHandling){s=this._getHeader("x-csrf-token",e.response.headers);if(e.response.statusCode=="403"&&s&&s.toLowerCase()==="required"){this.resetSecurityToken()}}}r.statusCode=e.response.statusCode;r.statusText=e.response.statusText;r.headers=e.response.headers;r.responseText=e.response.body}else if(!e.$reported){o.error("The following problem occurred: "+e.message,e.stack,a||j)}e.$reported=true;return r};Q.prototype.getReporter=function(e){var t=this;return function(a){t._handleError(a,undefined,e)}};Q.prototype.getData=function(e,t,a){return this.getProperty(e,t,a)};Q.prototype._getODataHandler=function(e){if(e.indexOf("$batch")>-1){return F.batchHandler}else if(e.indexOf("$count")>-1){return undefined}else if(this.bJSON){return F.jsonHandler}else{return F.atomHandler}};Q.prototype.getETag=function(e,t,a){if(typeof e=="object"){a=e;e=""}return this._getETag(e,t,a)};Q.prototype._getETag=function(e,t,a){if(!a||!a.__metadata){a=this._getObject(e,t)}if(a&&a.__metadata){return a.__metadata.etag}return null};Q.prototype.forceEntityUpdate=function(e){var t=this.mChangedEntities[e];if(t&&t.__metadata){t.__metadata.etag="*"}else{o.error(this+" - Entity with key "+e+" does not exist or has no change")}};Q.prototype._createRequest=function(e,t,a,s,r,i,n,d,u){var h;n=n!==false;if(i&&a!=="GET"){s["If-Match"]=i}if(!s["Content-Type"]&&a!=="DELETE"&&a!=="GET"){if(this.bJSON){s["Content-Type"]="application/json"}else{s["Content-Type"]="application/atom+xml"}}if(e.indexOf("$count")>-1){s["Accept"]="text/plain, */*;q=0.5"}if(a==="MERGE"&&!this.bUseBatch){s["x-http-method"]="MERGE";a="POST"}if(this.sMessageScope===U.BusinessObject&&s["sap-messages"]!=="transientOnly"){if(this.bIsMessageScopeSupported){s["sap-message-scope"]=this.sMessageScope}else{o.error("Message scope 'sap.ui.model.odata.MessageScope.BusinessObject' is not"+" supported by the service: "+this.sServiceUrl,undefined,j)}}d=d&&this.sMessageScope===U.BusinessObject&&this.bIsMessageScopeSupported;if(this.bUseBatch&&a!=="GET"&&a!=="HEAD"&&!s["Content-ID"]){s["Content-ID"]=_()}h={async:n,deepPath:t,headers:s,method:a,password:this.sPassword,requestUri:e,updateAggregatedMessages:d,user:this.sUser};if(u){h.sideEffects=true}if(r){h.data=r}if(this.bWithCredentials){h.withCredentials=this.bWithCredentials}h.requestID=this._createRequestID();return h};Q.prototype._processRequest=function(e,t,a){var s,r,i=false,n=this;if(this.bWarmup){return{abort:function(){}}}if(a){this.iPendingDeferredRequests+=1}r={abort:function(){if(a&&!i){n.iPendingDeferredRequests-=1}if(!i&&t){t(Q._createAbortedError())}if(s){s._aborted=true;if(s._handle){s._handle.abort()}}i=true}};this.oMetadata.loaded().then(function(){s=e(r);if(s){s.deferred=!!a}n._processRequestQueueAsync(n.mRequests);if(i){r.abort()}});return r};Q.prototype.update=function(e,t,a){var s,r,i,n,o,d,u,h,f,c,p,l,g,_,m,y=this,v,b,C;if(a){h=a.groupId||a.batchGroupId;f=a.changeSetId;o=a.context;s=a.success;r=a.error;d=a.eTag;p=a.headers;c=a.urlParameters;_=a.refreshAfterChange;C=a.canonicalRequest;if(a.merge!==undefined){l=a.merge?"MERGE":"PUT"}}C=this._isCanonicalRequestNeeded(C);m=h in y.mDeferredGroups;_=this._getRefreshAfterChange(_,h);u=H._createUrlParamsArray(c);p=this._getHeaders(p);l=l?l:this.sDefaultUpdateMethod;d=d||this._getETag(e,o,t);v=this._normalizePath(e,o,C);b=this.resolveDeep(e,o);return this._processRequest(function(e){n=y._createRequestUrlWithNormalizedPath(v,u,y.bUseBatch);i=y._createRequest(n,b,l,p,t,d);g=y.mRequests;if(m){g=y.mDeferredRequests}y._pushToRequestQueue(g,h,f,i,s,r,e,_);return i},r,m)};Q.prototype.create=function(e,t,a){var s,r,i,n,o,d,u,h,f,c,p,l,g,_,m,y,v=this,b,C,P;if(a){n=a.context;u=a.urlParameters;o=a.success;d=a.error;l=a.groupId||a.batchGroupId;_=a.changeSetId;p=a.eTag;f=a.headers;m=a.refreshAfterChange;P=a.canonicalRequest}P=this._isCanonicalRequestNeeded(P);m=this._getRefreshAfterChange(m,l);c=H._createUrlParamsArray(u);f=this._getHeaders(f);g="POST";y=l in v.mDeferredGroups;b=v._normalizePath(e,n,P);C=this.resolveDeep(e,n);return this._processRequest(function(e){r=v._createRequestUrlWithNormalizedPath(b,c,v.bUseBatch);s=v._createRequest(r,C,g,f,t,p);s.created=true;i=v.oMetadata._getEntityTypeByPath(b);s.entityTypes={};if(i){s.entityTypes[i.entityType]=true}h=v.mRequests;if(y){h=v.mDeferredRequests}v._pushToRequestQueue(h,l,_,s,o,d,e,m);return s},d,y)};Q.prototype.remove=function(e,t){var a,s,r,i,n,o,d,u,h,f,c,p,l,g,_,m,y,v,b,C=this.bCanonicalRequests,P=this;if(t){u=t.groupId||t.batchGroupId;a=t.changeSetId;s=t.context;m=t.success;o=t.error;d=t.eTag;h=t.headers;b=t.urlParameters;l=t.refreshAfterChange;C=t.canonicalRequest}C=this._isCanonicalRequestNeeded(C);l=this._getRefreshAfterChange(l,u);v=H._createUrlParamsArray(b);h=this._getHeaders(h);c="DELETE";d=d||this._getETag(e,s);n=u in P.mDeferredGroups;p=this._normalizePath(e,s,C);i=this.resolveDeep(e,s);function q(e,t){P._removeEntity(f);if(r&&r.isTransient()===false){P.oCreatedContextsCache.findAndRemoveContext(r)}if(m){m(e,t)}}return this._processRequest(function(e){y=P._createRequestUrlWithNormalizedPath(p,v,P.bUseBatch);f=y.substr(y.lastIndexOf("/")+1);f=f.split("?")[0];r=P.mContexts["/"+f];g=P._createRequest(y,i,c,h,undefined,d,undefined,true);_=P.mRequests;if(n){_=P.mDeferredRequests}P._pushToRequestQueue(_,u,a,g,q,o,e,l);return g},o,n)};Q.prototype.callFunction=function(e,t){var a,s,r,i,n,d,u,h,f,c,p,l,g,m,y=this;if(!e.startsWith("/")){o.fatal("callFunction: sFunctionName has to be absolute, but the given '"+e+"' is not absolute",this,j);return undefined}t=t||{};a=t.changeSetId;r=t.error;i=t.eTag;n=t.expand;d=t.groupId||t.batchGroupId;u=t.headers;h=t.method||"GET";f=t.refreshAfterChange;g=t.success;m=Object.assign({},t.urlParameters);if(n){if(!this.bUseBatch){throw new Error("Use 'expand' parameter only with 'useBatch' set to 'true'")}if(h!=="POST"){throw new Error("Use 'expand' parameter only with HTTP method 'POST'")}}f=this._getRefreshAfterChange(f,d);s=new Promise(function(e,t){l=e;c=t});p=this._processRequest(function(s){var p,v,b,C,P,q,M,R,E,S,T,x={},A=r,U=false,I=g;function D(){P=undefined;C=undefined;U=false}b=y.oMetadata._getFunctionImportMetadata(e,h);if(!b){o.error("Function '"+e+"' not found in the metadata",y,j);c();return undefined}if(b.entitySet||b.entitySetPath){x.$result={__list:[]};if(b.returnType&&!b.returnType.startsWith("Collection")){x.$result={__ref:{}}}}if(n&&(!x.$result||!x.$result.__ref)){c(new Error("Use 'expand' parameter only for functions returning a single"+" entity"));return undefined}if(b.parameter!=null){b.parameter.forEach(function(t){if(m[t.name]!==undefined){x[t.name]=m[t.name];m[t.name]=H.formatValue(m[t.name],t.type)}else{x[t.name]=undefined;o.warning("No value given for parameter '"+t.name+"' of function import '"+e+"'",y,j)}})}E=_();if(n){u=Object.assign({},u,{"Content-ID":E,"sap-messages":"transientOnly"});g=function(e,t){if(!P){P=e;C=t;return}if(I){e=Object.assign({},P,e);I(e,C)}D()};r=function(t){if(P){C.expandAfterFunctionCallFailed=true;t.expandAfterFunctionCallFailed=true;o.error("Function '"+e+"' was called successfully, but"+" expansion of navigation properties ("+n+") failed",t,j);if(I){I(P,C)}D();return}if(!U){U=true;if(A){A(t)}}else{t.expandAfterFunctionCallFailed=true;D()}}}x.__metadata={uri:y.sServiceUrl+e+"('"+E+"')",created:{changeSetId:a,error:r,eTag:i,functionImport:true,groupId:d,headers:Object.assign({},u),key:e.substring(1),method:h,success:g},deepPath:e};q=y._addEntity(x);p=y.getContext("/"+q);y._writePathCache("/"+q,"/"+q);l(p);T=H._createUrlParamsArray(m);S=y._createRequestUrlWithNormalizedPath(e,T,y.bUseBatch);M=y._createRequest(S,e,h,y._getHeaders(u),undefined,i,undefined,true);M.adjustDeepPath=t.adjustDeepPath;M.functionMetadata=b;x.__metadata.created.functionMetadata=b;M.functionTarget=y.oMetadata._getCanonicalPathOfFunctionImport(b,m);M.key=q;if(n){v=y._createRequest("$"+E+"?"+H._encodeURLParameters({$expand:n,$select:n}),"/$"+E,"GET",y._getHeaders(undefined,true),undefined,undefined,undefined,true);v.contentID=E;M.expandRequest=v;M.contentID=E;x.__metadata.created.expandRequest=v;x.__metadata.created.contentID=v.contentID}R=y.mRequests;if(d in y.mDeferredGroups){R=y.mDeferredRequests}y._pushToRequestQueue(R,d,a,M,g,r,s,f);return M},r);p.contextCreated=function(){return s};return p};Q.prototype._createFunctionImportParameters=function(e,t,a){var s=h({},a);delete s.__metadata;delete s["$result"];var r=this.oMetadata._getFunctionImportMetadata(e,t);n(r,this+": Function "+e+" not found in the metadata !");if(!r){return undefined}if(r.parameter!=null){f(r.parameter,function(e,t){if(s&&s[t.name]!==undefined){s[t.name]=H.formatValue(s[t.name],t.type)}})}return s};Q.prototype._getResourcePath=function(e,t,a,s){var r,i,n,o;if(!e){return this.resolve(a,s)}n=this.oMetadata._splitByLastNavigationProperty(t);i=n.pathBeforeLastNavigationProperty;r=n.lastNavigationProperty;if(r.includes("(")&&n.addressable){o=this.resolve(i+r,undefined,true);if(o){return o+n.pathAfterLastNavigationProperty}}o=this.resolve(i,undefined,true)||i;return o+r+n.pathAfterLastNavigationProperty};Q.prototype.read=function(e,t){return this._read(e,t)};Q.prototype._read=function(e,t,a){var s,r,i,n,o,d,u,h,f,c,p,l,g,_,m=this;if(t){s=t.canonicalRequest;r=t.context;i=t.error;o=t.filters;d=t.groupId||t.batchGroupId;u=t.headers;c=t.sorters;p=t.success;l=t.updateAggregatedMessages;_=t.urlParameters}s=this._isCanonicalRequestNeeded(s);if(e&&e.indexOf("?")!==-1){e=e.slice(0,e.indexOf("?"))}if(this.sRefreshGroupId){d=this.sRefreshGroupId}g=H._createUrlParamsArray(_);u=this._getHeaders(u,true);h="GET";n=this._getETag(e,r);var y={abort:function(){if(f){f._aborted=true}}};function v(t){var _,y,v,b,C,P,q=m.resolveDeep(e,r),M=m._getResourcePath(s,q,e,r);C=H.createSortParams(c);if(C){g.push(C)}_=m.oMetadata._getEntityTypeByPath(M);y=T.groupFilters(o);v=H.createFilterParams(y,m.oMetadata,_);if(v){g.push(v)}P=m._createRequestUrlWithNormalizedPath(M,g,m.bUseBatch);f=m._createRequest(P,q,h,u,null,n,undefined,l,a);b=m.mRequests;if(d in m.mDeferredGroups){b=m.mDeferredRequests}m._pushToRequestQueue(b,d,null,f,p,i,t,false);return f}if(this.bUseBatch&&this.bIncludeInCurrentBatch){f=v(y);return y}else{return this._processRequest(v,i)}};Q.prototype.requestSideEffects=function(e,t){var a,s=this;t=t||{};for(a in t){if(!K.includes(a)){throw new Error("Parameter '"+a+"' is not supported")}}return new Promise(function(a,r){var i=new Set,n=[],o=t.urlParameters&&t.urlParameters["$expand"];s._read("",{context:e,error:r,groupId:t.groupId,success:function(){a(n)},updateAggregatedMessages:true,urlParameters:t.urlParameters},true);if(o){o.split(",").forEach(function(t){var a=s.oMetadata._getEntityTypeByPath(s.resolve(t,e));i.add(a)});s.getBindings().forEach(function(e){if(e.isA("sap.ui.model.odata.v2.ODataListBinding")){if(e._refreshForSideEffects(i,t.groupId)){n.push(e)}}})}})};Q.prototype.getServiceMetadata=function(){if(this.oMetadata&&this.oMetadata.isLoaded()){return this.oMetadata.getServiceMetadata()}return undefined};Q.prototype.metadataLoaded=function(e){var t=this.oMetadata.loaded(e);if(this.bLoadAnnotationsJoined){if(e){return Promise.all([t,this.pAnnotationsLoaded])}var a=function(){return t};return this.pAnnotationsLoaded.then(a,a)}else{return t}};Q.prototype.annotationsLoaded=function(){return this.pAnnotationsLoaded};Q.prototype.isMetadataLoadingFailed=function(){return this.oMetadata.isFailed()};Q.prototype.getServiceAnnotations=function(){var e=this.oAnnotations.getData();return p(e)?null:e};Q.prototype.onAnnotationsFailed=function(e){this.fireAnnotationsFailed(e.getParameters())};Q.prototype.onAnnotationsLoaded=function(e){this.fireAnnotationsLoaded(e.getParameters())};Q.prototype.addAnnotationUrl=function(e){var t=[].concat(e),a=[],s=[],r=[],i=this;t.forEach(function(e){var t=e.indexOf("$metadata");if(t>=0){e=i._createMetadataUrl(e);a.push(e)}else{s.push(e)}});return this.oMetadata._addUrl(a).then(function(e){return Promise.all(e.map(function(e){r=r.concat(e.entitySets);return i.oAnnotations.addSource({type:"xml",data:e["metadataString"]})}))}).then(function(){return i.oAnnotations.addSource(s)}).then(function(e){return{annotations:i.oAnnotations.getData(),entitySets:r}})};Q.prototype.addAnnotationXML=function(e,t){return this.oAnnotations.addSource({type:"xml",data:e})};Q.prototype.submitChanges=function(e){return this.submitChangesWithChangeHeaders(e&&{batchGroupId:e.batchGroupId,error:e.error,groupId:e.groupId,merge:e.merge,success:e.success})};Q.prototype.submitChangesWithChangeHeaders=function(e){var t,a,s,r,i,n,d,u,h=false,c=this.bRefreshAfterChange,p=this;e=e||{};s=e.groupId||e.batchGroupId;u=e.success;a=e.error;if(e.merge!==undefined){r=e.merge?"MERGE":"PUT"}i=Object.keys(e.changeHeaders||{}).find(function(e){return p._isHeaderPrivate(e)});if(i){throw new Error("Must not use private header: "+i)}this.getBindings().forEach(function(e){if(e._submitChanges){var t=u||function(){},a={groupId:s};e._submitChanges(a);if(a.success){u=function(){t.apply(null,arguments);a.success.apply(null,arguments)}}}});if(s&&!this.mDeferredGroups[s]){o.fatal(this+' submitChanges: "'+s+'" is not a deferred group!')}t=g({},p.mChangedEntities);this.oMetadata.loaded().then(function(){var i,o,l,g,_,m;f(t,function(e,t){var a,i,n,o=p.getContext("/"+e),d=p._resolveGroup(e);if(o.hasTransientParent()||o.isInactive()){return}if(d.groupId===s||!s){i=p._processChange(e,t,d.groupId,r);i.key=e;a=t.__metadata&&t.__metadata.created?t.__metadata.created:{};n={abort:function(){i._aborted=true}};if(d.groupId in p.mDeferredGroups){p._pushToRequestQueue(p.mDeferredRequests,d.groupId,d.changeSetId,i,a.success,a.error,n,a.refreshAfterChange===undefined?c:a.refreshAfterChange)}}});for(_ in p.mDeferredRequests){m=p.mDeferredRequests[_];for(l in m.changes){o=m.changes[l];for(g=o.length-1;g>=0;g--){i=o[g];if(i.bRefreshAfterChange===undefined){i.bRefreshAfterChange=c}}}}d=p._processRequestQueue(p.mDeferredRequests,s,u,a,e.changeHeaders);if(h){n.abort()}if(Array.isArray(d)&&d.length==0&&u){u({},undefined)}});n={abort:function(){if(d){if(Array.isArray(d)){d.forEach(function(e){e.abort()})}else{d.abort()}}else{h=true}}};return n};Q.prototype._updateChangedEntity=function(e,t){var a,s,r,i,n,o,d=this;function h(e,t,a){f(t,function(s){var i=a+"/"+s;if(l(t[s])&&l(e[s])){h(e[s],t[s],i);if(p(t[s])){delete t[s]}}else if(a.endsWith("__metadata")||u(t[s],e[s])&&!d.isLaundering(i)){delete t[s];if(a===o){r=d.oMetadata._getEntityTypeByPath(o);n=r&&d.oMetadata._getNavPropertyRefInfo(r,s);if(n&&t[n.name]){e[n.name]=t[n.name];delete t[n.name]}}}})}if(e in d.mChangedEntities){i=d._getObject("/"+e,null,true);a=d._getObject("/"+e);g(i,t);o="/"+e;s=d.removeInternalMetadata(a).deepPath;h(i,a,o);if(p(a)){delete d.mChangedEntities[e];d.abortInternalRequest(d._resolveGroup(e).groupId,{requestKey:e})}else{d.mChangedEntities[e]=a;a.__metadata={deepPath:s};c(a.__metadata,i.__metadata)}}};Q.prototype._discardEntityChanges=function(e,t){var a,s,r=this._resolveGroup(e).groupId,i=this.oMetadata.loaded(),n=this;i.then(function(){n.abortInternalRequest(r,{requestKey:e})});if(t){a=this.getContext("/"+e);a.removeFromTransientParent();this.oCreatedContextsCache.findAndRemoveContext(a);s=this.mChangedEntities[e]&&this.mChangedEntities[e].__metadata.created;this._removeEntity(e);if(s&&s.abort){s.abort(Q._createAbortedError())}}else{delete this.mChangedEntities[e]}C.removeMessages(this.getMessagesByEntity(e,true));return i};Q.prototype.resetChanges=function(e,t,a){var s,r=this.oMetadata.loaded(),i=[],n=this;if(t){r.then(function(){f(n.mDeferredGroups,function(t){if(e){e.forEach(function(e){n.abortInternalRequest(t,{path:e.substring(1)})})}else{n.abortInternalRequest(t)}})})}if(e){f(e,function(e,t){var a,s,r,o,d,u={};if(n.getEntityByPath(t,null,u)){d=u.propertyPath.split("/");o=d[d.length-1];r=u.key;a=n.mChangedEntities[r];if(a){for(s=0;s<d.length-1;s+=1){if(a&&a.hasOwnProperty(d[s])){a=a[d[s]]}else{a=undefined;break}}if(a&&a.hasOwnProperty(o)){delete a[o]}a=n.mChangedEntities[r];if(Q._isChangedEntityEmpty(a)||!u.propertyPath){i.push(r)}}}});s=i;i.forEach(function(e){s=s.concat(n.getContext("/"+e).getSubContextsAsKey(true))});new Set(s).forEach(function(e){n._discardEntityChanges(e,n.mChangedEntities[e].__metadata.created&&a)})}else{f(this.mChangedEntities,function(e,t){var s=n.getContext("/"+e).isInactive()?false:t.__metadata.created&&a;n._discardEntityChanges(e,s)})}this.getBindings().forEach(function(t){if(t._resetChanges){t._resetChanges(e)}});this.checkUpdate(true);return r};Q.prototype.setProperty=function(e,t,a,s){var r,i,n,o,d,h,c,g,_,m,y,v,b,C,P,q,M,E,S,T,x,A,U,I,D,O={},k={},H=false,B=this;function L(e,t){f(t,function(a){if(l(t[a])&&l(e[a])){L(e[a],t[a]);if(p(t[a])){delete t[a]}}else if(u(t[a],e[a])){delete t[a]}})}D=this.resolve(e,a);o=this.resolveDeep(e,a);c=this.getEntityByPath(D,null,k);if(!c){return false}E=D.substring(D.lastIndexOf("/")+1);if(E.startsWith("@$ui5.")){throw new Error("Setting a value for an instance annotation starting with '@$ui5' is "+"not allowed: "+E)}y=k.key;C=this._getObject("/"+y,null,true);P=this._getObject(e,a,true);H=C.__metadata.created&&C.__metadata.created.functionImport;if(!this.mChangedEntities[y]){d=c.__metadata;c={};c.__metadata=Object.assign({},d);if(!H&&k.propertyPath.length>0){var F=o.lastIndexOf(k.propertyPath);c.__metadata.deepPath=o.substring(0,F-1)}this.mChangedEntities[y]=c}i=this.mChangedEntities[y];M=k.propertyPath.split("/");for(var w=0;w<M.length-1;w++){if(!i.hasOwnProperty(M[w])){i[M[w]]={}}i=i[M[w]]}i[E]=R.isPlainObject(t)?R.merge({},t):t;if(a&&a.hasTransientParent&&a.hasTransientParent()){O[y]=true;this.checkUpdate(false,s,O);return true}h=this.oMetadata._getEntityTypeByPath(k.key);b=h&&this.oMetadata._getNavPropertyRefInfo(h,E);m=b&&C[b.name]&&C[b.name].__ref;if(m&&b.keys.length===1&&this.oMetadata._getEntityTypeByPath(b.entitySet).key.propertyRef.length===1){if(t===null){S=null}else{v={};b.keys.forEach(function(e){v[e]=c[e]!==undefined?c[e]:C[e]});v[b.keys[0]]=t;S=this.createKey(b.entitySet,v)}i[b.name]={__ref:S}}I=this.oMetadata.loaded();if(c.__metadata.created&&!H){r=this.oCreatedContextsCache.findCreatedContext(D);if(r&&r.isInactive()){r.startActivation();I=Promise.all([I,r.fetchActivated()])}}if(u(t,P)&&!this.isLaundering("/"+y)&&!H){d=this.mChangedEntities[y].__metadata;n=d&&d.created;delete this.mChangedEntities[y].__metadata;if(!n){L(C,this.mChangedEntities[y])}if(p(this.mChangedEntities[y])){delete this.mChangedEntities[y];O[y]=true;this.checkUpdate(false,s,O);I.then(function(){B.abortInternalRequest(B._resolveGroup(y).groupId,{requestKey:y})});return true}this.mChangedEntities[y].__metadata=d}_=this._resolveGroup(y);g=_.groupId;A=this.mRequests;if(g in this.mDeferredGroups){A=this.mDeferredRequests}x=this._processChange(y,this._getObject("/"+y),g);x.key=y;q=i.__metadata&&i.__metadata.created?i.__metadata.created:{};T=this._getRefreshAfterChange(undefined,g);I.then(function(){U={abort:function(){x._aborted=true}};B._pushToRequestQueue(A,g,_.changeSetId,x,q.success,q.error,U,T);B._processRequestQueueAsync(B.mRequests)});O[y]=true;this.checkUpdate(false,s,O);return true};Q.prototype._isHeaderPrivate=function(e){switch(e.toLowerCase()){case"accept":case"accept-language":case"maxdataserviceversion":case"dataserviceversion":return true;case"x-csrf-token":return this.bTokenHandling;case"sap-contextid-accept":case"sap-contextid":return!this.bDisableSoftStateHeader;default:return false}};Q.prototype.setHeaders=function(e){var t={},a=this;this.mCustomHeaders={};if(e){f(e,function(e,s){if(a._isHeaderPrivate(e)){o.warning(this+" - modifying private header: '"+e+"' not allowed!")}else{t[e]=s}});this.mCustomHeaders=t}if(this.oAnnotations){this.oAnnotations.setHeaders(this.mCustomHeaders)}};Q.prototype._getHeaders=function(e,t){var a={},s=this;if(e){f(e,function(e,t){if(s._isHeaderPrivate(e)){o.warning(this+" - modifying private header: '"+e+"' not allowed!")}else{a[e]=t}})}return c({"sap-cancel-on-close":String(!!t)},this.mCustomHeaders,a,this.oHeaders)};Q.prototype.getHeaders=function(){return c({},this.mCustomHeaders,this.oHeaders)};Q.prototype._getHeader=function(e,t){var a;for(a in t){if(a.toLowerCase()===e.toLowerCase()){return t[a]}}return null};Q.prototype.hasPendingChanges=function(e){var t,a=Object.keys(this.mChangedEntities);t=this.getBindings().some(function(e){return e._hasPendingChanges&&e._hasPendingChanges(a)});t=t||a.length>0;if(!t&&e){t=this.iPendingDeferredRequests>0}return t};Q.prototype.hasPendingRequests=function(){return this.aPendingRequestHandles.length>0};Q.prototype.getPendingChanges=function(){var e,t=R.merge({},this.mChangedEntities);this.getBindings().forEach(function(e){if(e._getPendingChanges){R.merge(t,e._getPendingChanges())}});for(e in t){if(!t[e]){delete t[e]}}return t};Q.prototype.updateBindings=function(e){this.checkUpdate(e)};Q.prototype.setTokenHandlingEnabled=function(e){this.bTokenHandling=e};Q.prototype.setUseBatch=function(e){this.bUseBatch=e};Q.prototype.formatValue=function(e,t){return H.formatValue(e,t)};Q.prototype.deleteCreatedEntry=function(e){var t,a,s=this;if(e){a=e.getPath().substr(1);t=this._resolveGroup(a).groupId;s.oMetadata.loaded().then(function(){s.abortInternalRequest(t,{requestKey:a})});s._removeEntity(a);C.removeMessages(this.getMessagesByEntity(e.getPath(),true))}};Q.prototype.createEntry=function(e,t){var a,s,r,i,d,u,h,f,c,p,l,m,v,b,C,P,q,M,R,E,S,T,x,A,U,I,D={},O="POST",k=this;function B(e){q=k._addEntity(g({},D));if(!C){k.mChangedEntities[q]=D}return k.getContext("/"+q,f,d,C,e)}function L(){var t;if(h){t=k.oMetadata._getEntityTypeByPath(r.getPath());if(!k.oMetadata._getNavigationPropertyNames(t).includes(e)){throw new Error("Cannot create entity; path '"+e+"' is not a navigation property of '"+t.name+"'")}if(!P){throw new Error("Cannot create entity; deep create on navigation property '"+e+"' with single cardinality is not supported")}}}function F(){var t,i,C,F,w,G,N,W,$,K,z,Q,V=false,J=p,X=x;a=k._isCanonicalRequestNeeded(a);b=Object.assign({},b);U=H._createUrlParamsArray(I);if(!e.startsWith("/")&&!r){e="/"+e}M=k._normalizePath(e,r,a);f=k.resolveDeep(e,r);P=k.oMetadata._isCollection(f);L();c=k.oMetadata._getEntityTypeByPath(M);if(!c){n(c,"No Metadata for collection "+M+" found");return undefined}if(typeof R==="object"&&!Array.isArray(R)){D=g({},R)}w=""+c.entityType;F=k.oMetadata._getEntitySetByType(c);Q=_();q=F.name+"('"+Q+"')";G=k.sServiceUrl+"/"+q;if(f&&P){f=f+"('"+Q+"')"}if(h){K=k._getObject(r.getPath());s=K.__metadata.created.changeSetId;v=K.__metadata.created.groupId;D.__metadata={type:w,uri:G,created:{changeSetId:s,groupId:v}};i=B(r);r.addSubContext(e,i,P);return i}if(m){b["Content-ID"]=Q;x=function(e,a){if(!t){t=e;C=a;return}if(X){e=Object.assign({},t,e);X(e,C)}u()};p=function(e){if(t){C.expandAfterCreateFailed=true;e.expandAfterCreateFailed=true;o.error("Entity creation was successful but expansion of navigation"+" properties failed",e,j);if(X){X(t,C)}u();return}if(!V){V=true;if(J){J(e)}}else{e.expandAfterCreateFailed=true;V=false}}}else{x=function(e,t){if(X){X(e,t)}u()}}$=k._resolveGroup(M);v=v||$.groupId;s=s||$.changeSetId;E=k._getRefreshAfterChange(E,v);z=k._isTransitionMessagesOnly(v);if(z||m){b["sap-messages"]="transientOnly"}D.__metadata={type:w,uri:G,created:{changeSetId:s,error:p,eTag:l,groupId:v,headers:b,key:M.substring(1),refreshAfterChange:E,success:x,urlParameters:I},deepPath:f};d=new y(function(e,t){u=function(){if(!k.oCreatedContextsCache.getCacheInfo(i)){i.resetCreatedPromise()}if(i.hasSubContexts()){k.resetChanges(i.getSubContextsAsPath(),undefined,true)}e()};D.__metadata.created.abort=t});d.catch(function(){});i=B();A=k._createRequestUrlWithNormalizedPath(M,U,k.bUseBatch);S=k._createRequest(A,f,O,b,D,l);if(m){N=k._getHeaders(undefined,true);if(z){N["sap-messages"]="transientOnly"}W=k._createRequest("$"+Q+"?"+H._encodeURLParameters({$expand:m,$select:m}),"/$"+Q,"GET",N,null,undefined,undefined,true);W.contentID=Q;S.expandRequest=W;S.contentID=Q;D.__metadata.created.expandRequest=W;D.__metadata.created.contentID=Q}S.key=q;S.created=true;T=k.mRequests;if(v in k.mDeferredGroups){T=k.mDeferredRequests}k.oMetadata.loaded().then(function(){i.fetchActivated().then(function(){var e={abort:function(){if(S){S._aborted=true;if(S.expandRequest){S.expandRequest._aborted=true}}}};k._pushToRequestQueue(T,v,s,S,x,p,e,E);k._processRequestQueueAsync(k.mRequests)})});return i}if(t){R=t.properties;v=t.groupId||t.batchGroupId;s=t.changeSetId;r=e.startsWith("/")?undefined:t.context;x=t.success;p=t.error;i=t.created;l=t.eTag;b=t.headers;I=t.urlParameters;E=t.refreshAfterChange;a=t.canonicalRequest;m=t.expand;C=t.inactive}if(m&&!this.bUseBatch){throw new Error("The 'expand' parameter is only supported if batch mode is used")}h=r&&r.isTransient&&r.isTransient();if(h){Object.keys(t).forEach(function(e){if(!N.includes(e)){throw new Error("deep create, unsupported parameter: "+e)}});if(r.isInactive()){throw new Error("deep create, context must not be inactive")}}if(i){this.oMetadata.loaded().then(function(){i(F())})}else if(this.oMetadata.isLoaded()){return F()}else{o.error("Tried to use createEntry without created-callback, before metadata is "+"available!")}return undefined};Q.prototype._isCreatedEntity=function(e){return!!(e&&e.__metadata&&e.__metadata.created)};Q.prototype._normalizePath=function(e,t,a){if(e&&e.indexOf("?")!==-1){e=e.substr(0,e.indexOf("?"))}if(!t&&!e.startsWith("/")){o.fatal(this+" path "+e+" must be absolute if no Context is set")}return this.resolve(e,t,a)||this.resolve(e,t)};Q.prototype.getRefreshAfterChange=function(){return this.bRefreshAfterChange};Q.prototype.setRefreshAfterChange=function(e){this.bRefreshAfterChange=e};Q.prototype.isList=function(e,t){e=this.resolve(e,t);return e&&e.substr(e.lastIndexOf("/")).indexOf("(")===-1};Q.prototype._isMetadataPath=function(e){var t=false;if(e&&e.indexOf("/#")>-1){t=true}return t};Q.prototype.isMetaModelPath=function(e){return e.indexOf("##")==0||e.indexOf("/##")>-1};Q.prototype._request=function(e,t,a,s,r,i){var n;if(this.bDestroyed){return{abort:function(){}}}var o=this;function d(e){return function(){if(o.aPendingRequestHandles){var t=o.aPendingRequestHandles.indexOf(n);if(t>-1){o.aPendingRequestHandles.splice(t,1)}}if(!(n&&n.bSuppressErrorHandlerCall)){e.apply(this,arguments)}}}n=F.request(e,d(t||F.defaultSuccess),d(a||F.defaultError),s,r,i);if(e.async!==false){this.aPendingRequestHandles.push(n)}return n};Q.prototype.destroy=function(){this.bDestroyed=true;x.prototype.destroy.apply(this,arguments);if(this.aPendingRequestHandles){for(var e=this.aPendingRequestHandles.length-1;e>=0;e--){var t=this.aPendingRequestHandles[e];if(t&&t.abort){t.bSuppressErrorHandlerCall=true;t.abort()}}delete this.aPendingRequestHandles}if(this.sMetadataLoadEvent){clearTimeout(this.sMetadataLoadEvent)}if(this.oMetadataFailedEvent){clearTimeout(this.oMetadataFailedEvent)}if(this.oMetadata){this.oMetadata.detachFailed(this.onMetadataFailed);if(!this.oMetadata.isLoaded()&&!this.oMetadata.hasListeners("loaded")){this.oMetadata.destroy();delete this.oSharedMetaData.oMetadata}delete this.oMetadata;delete this.pMetadataLoaded}if(this.oMetaModel){this.oMetaModel.destroy();delete this.oMetaModel}if(this.oAnnotations){this.oAnnotations.detachSomeLoaded(this.onAnnotationsLoaded);this.oAnnotations.detachAllFailed(this.onAnnotationsFailed);this.oAnnotations.destroy();delete this.oAnnotations;delete this.pAnnotationsLoaded}if(this.oMessageParser){this.oMessageParser.destroy();delete this.oMessageParser}};Q.prototype.setDeferredBatchGroups=function(e){this.setDeferredGroups(e)};Q.prototype.setDeferredGroups=function(e){var t=this;this.mDeferredGroups={};f(e,function(e,a){t.mDeferredGroups[a]=a})};Q.prototype.getDeferredBatchGroups=function(){return this.getDeferredGroups()};Q.prototype.getDeferredGroups=function(){return Object.keys(this.mDeferredGroups)};Q.prototype.setChangeBatchGroups=function(e){f(e,function(e,t){t.groupId=t.batchGroupId});this.setChangeGroups(e)};Q.prototype.setChangeGroups=function(e){this.mChangeGroups=e};Q.prototype.getChangeBatchGroups=function(){return this.getChangeGroups()};Q.prototype.getChangeGroups=function(){return this.mChangeGroups};Q.prototype.setMessageParser=function(e){if(!(e instanceof q)){o.error("Given MessageParser is not of type sap.ui.core.message.MessageParser");return this}e.setProcessor(this);this.oMessageParser=e;return this};Q.prototype._parseResponse=function(e,t,a,s){try{if(!this.oMessageParser){this.oMessageParser=new O(this.sServiceUrl,this.oMetadata,!!this.bPersistTechnicalMessages);this.oMessageParser.setProcessor(this)}this.oMessageParser.parse(e,t,a,s,this.bIsMessageScopeSupported)}catch(e){o.error("Error parsing OData messages: "+e)}};Q.prototype.callAfterUpdate=function(e){this.aCallAfterUpdate.push(e)};Q.prototype.getMetaModel=function(){var e=this;if(!this.oMetaModel){this.oMetaModel=new D(this.oMetadata,this.oAnnotations,this);this.oMetaModel.loaded().then(function(){e.bMetaModelLoaded=true;e.checkUpdate(false,false,null,true)},function(e){var t=e.message,a;if(!t&&e.xmlDoc&&e.xmlDoc.parseError){t=e.xmlDoc.parseError.reason;a=e.xmlDoc.parseError.srcText}o.error("error in ODataMetaModel.loaded(): "+t,a,j)})}return this.oMetaModel};Q.prototype.getOriginalProperty=function(e,t){return this._getObject(e,t,true)};Q.prototype.getEntityByPath=function(e,t,a){var s,r=x.prototype.resolve.call(this,e,t);if(!r){return null}var i=r.split("/"),n=null,o=[];while(i.length>0){var d=i.join("/"),u=this._getObject(d);if(l(u)){s=this._getKey(u);if(s){n=u;break}}o.unshift(i.pop())}if(n){a.propertyPath=o.join("/");a.key=s;return n}return null};Q.prototype.resolveFromCache=function(e){if(!this.mPathCache){return undefined}var t,a="",s,r,i;s=this.mPathCache[e]?this.mPathCache[e].canonicalPath:undefined;if(e&&s!==e){t=s||e;if(!s){i=t.lastIndexOf("/");a=t.substr(i);t=t.substr(0,i)}r=this.resolveFromCache(t);if(r&&r!==t){s=r+a}}return s};Q.prototype.resolve=function(e,t,a){var s=x.prototype.resolve.call(this,e,t);if(s&&!this._isMetadataPath(s)&&a){var r=this.resolveFromCache(s);if(!r){r=this.oMetadata._calculateCanonicalPath(s);r=this.resolveFromCache(r)||r}this._writePathCache(s,r);return r}return s};Q.prototype.resolveDeep=function(e,t){var a=x.prototype.resolve.call(this,e,t);if(e&&!e.startsWith("/")){a=t?t.sDeepPath+"/"+e:a}if(e===""){a=t?t.sDeepPath:a}return a};Q.prototype.isLaundering=function(e,t){var a=this.resolve(e,t);return a in this.mLaunderingState&&this.mLaunderingState[a]>0};Q.prototype.increaseLaundering=function(e,t){if(!l(t)){return}for(var a in t){if(a==="__metadata"){continue}var s=t[a];if(l(s)){this.increaseLaundering(e+"/"+a,s)}else{var r=e+"/"+a;if(!(r in this.mLaunderingState)){this.mLaunderingState[r]=0}this.mLaunderingState[r]++}}if(!(e in this.mLaunderingState)){this.mLaunderingState[e]=0}this.mLaunderingState[e]++};Q.prototype.decreaseLaundering=function(e,t){if(!l(t)){return}for(var a in t){if(a==="__metadata"){continue}var s=t[a],r=e+"/"+a;if(l(s)){this.decreaseLaundering(r,s)}else if(r in this.mLaunderingState){this.mLaunderingState[r]--;if(this.mLaunderingState[r]===0){delete this.mLaunderingState[r]}}}this.mLaunderingState[e]--;if(this.mLaunderingState[e]===0){delete this.mLaunderingState[e]}};Q.prototype._getRefreshAfterChange=function(e,t){if(e===undefined&&!(t in this.mDeferredGroups)){return this.bRefreshAfterChange}return e};Q.prototype.getMessagesByEntity=function(e,t){var a=e,s=[],r;function i(e){var a=[];for(var s=0;s<e.length;s++){if(!t||t&&!e[s].persistent){a.push(e[s])}}return a}if(!a.startsWith("/")){a="/"+a}if(this.mMessages){for(r in this.mMessages){if(typeof a=="string"&&a.length>0&&r.startsWith(a)){s=s.concat(i(this.mMessages[r]))}}return s}return null};Q.prototype._cacheSupported=function(e){const t=e.includes("sap-context-token");if(this.sAnnotationURI&&!Array.isArray(this.sAnnotationURI)){this.sAnnotationURI=[this.sAnnotationURI]}const a=this.sAnnotationURI??[];return t&&a.every(e=>e.includes("sap-context-token")||z.test(e))};Q.prototype._getAnnotationCacheKey=function(e){var t=this.bSkipMetadataAnnotationParsing||this.bIgnoreAnnotationsFromMetadata,a;if(this.bUseCache){if(!t){a=e+"#annotations"}if(this.sAnnotationURI){if(!Array.isArray(this.sAnnotationURI)){this.sAnnotationURI=[this.sAnnotationURI]}this.sAnnotationURI=this.sAnnotationURI.map(function(e){return e+"#annotations"});a=t?this.sAnnotationURI.join("_"):a+"_"+this.sAnnotationURI.join("_")}}return a};Q.prototype.canonicalRequestsEnabled=function(){return this.bCanonicalRequests};Q.prototype._decreaseDeferredRequestCount=function(e){if(e.deferred){this.iPendingDeferredRequests--}};Q.prototype.enableCanonicalRequests=function(e){this.bCanonicalRequests=!!e};Q.prototype.getMessageScope=function(){return this.sMessageScope};Q.prototype.setMessageScope=function(e){if(e!==U.RequestedObjects&&e!==U.BusinessObject){throw new Error("Unsupported message scope: "+e)}this.sMessageScope=e};Q.prototype.messageScopeSupported=function(){var e=this;return this.metadataLoaded().then(function(){return e.bIsMessageScopeSupported})};Q.prototype.getContext=function(e,a,s,r,i){var n=this.mContexts[e];if(!n){n=this.mContexts[e]=new t(this,e,a,s,r,i)}else{n.setDeepPath(a||n.getDeepPath()||e)}return n};Q.prototype.hasContext=function(e){return this.mContexts[e]};Q.prototype.removeInternalMetadata=function(e){var t,a,s,r,i;if(e&&e.__metadata){t=e.__metadata.created;a=e.__metadata.deepPath;s=e.__metadata.invalid;delete e.__metadata.created;delete e.__metadata.deepPath;delete e.__metadata.invalid}for(r in e){i=e[r];if(Array.isArray(i)){i.forEach(Q.prototype.removeInternalMetadata)}else if(typeof i==="object"){Q.prototype.removeInternalMetadata(i)}}return{created:t,deepPath:a,invalid:s}};Q.prototype._isCanonicalRequestNeeded=function(e){if(e!==undefined){return!!e}else{return!!this.bCanonicalRequests}};Q.prototype.filterMatchingMessages=function(e,t){var a=this;return this.mMessages[e].filter(function(e){return a.isMessageMatching(e,t)})};Q.prototype.isMessageMatching=function(e,t){var a=t.length;return e.aFullTargets.some(function(e){return e===t||e.startsWith(t)&&(t==="/"||e[a]==="/"||e[a]==="(")})};Q.prototype.getMessages=function(e){return this.getMessagesByPath(e.sDeepPath,true).sort(P.compare)};Q.prototype.getDeepPathForCanonicalPath=function(e){var t,a,i,n,o,d,u,h=e.slice(e.indexOf("("));o=this.aBindings.filter(function(e){return(e instanceof s||e instanceof r)&&e.isResolved()});for(d=0,u=o.length;d<u;d+=1){t=o[d];i=this.resolveDeep(t instanceof r?t.sPath+h:t.sPath,t.oContext);a=this.resolveFromCache(i);if(a===e){if(n&&n!==i){return undefined}n=i}}return n};Q.prototype.getPersistTechnicalMessages=function(){return this.bPersistTechnicalMessages};Q.prototype.setPersistTechnicalMessages=function(e){e=!!e;if(this.bPersistTechnicalMessages===e){return}if(this.bPersistTechnicalMessages!==undefined){o.warning("The flag whether technical messages should always be treated as persistent"+" has been overwritten to "+e,undefined,j)}this.bPersistTechnicalMessages=e;if(this.oMessageParser){this.oMessageParser._setPersistTechnicalMessages(e)}};Q.prototype.createCodeListModelParameters=function(e){e=e||{};return{defaultCountMode:A.None,disableSoftStateHeader:true,headers:e.headers&&Object.assign({},e.headers),json:e.json,metadataUrlParams:e.metadataUrlParams&&Object.assign({},e.metadataUrlParams),persistTechnicalMessages:e.persistTechnicalMessages,serviceUrl:this.sServiceUrl,serviceUrlParams:e.serviceUrlParams&&Object.assign({},e.serviceUrlParams),tokenHandling:false,useBatch:false,warmupUrl:e.warmupUrl}};Q.prototype.getCodeListModelParameters=function(){return this.mCodeListModelParams};Q.prototype.getMetadataUrl=function(){return this.sMetadataUrl};Q._createAbortedError=function(){return{aborted:true,headers:{},message:"Request aborted",responseText:"",statusCode:0,statusText:"abort"}};Q.prototype._getCreatedContextsCache=function(){return this.oCreatedContextsCache};Q._isChangedEntityEmpty=function(e){return Object.keys(e).every(function(e){return e==="__metadata"})};Q.prototype._addSubEntitiesToPayload=function(e,t){var a,s,r,i,n=e.getSubContexts(),o=this;function d(e){var t=R.merge({},o._getObject(e.getPath()));delete t.__metadata;return t}for(s in n){r=n[s];if(Array.isArray(r)){t[s]=[];for(a=0;a<r.length;a+=1){i=d(r[a]);t[s].push(i);this._addSubEntitiesToPayload(r[a],i)}}else{i=d(r);t[s]=i;this._addSubEntitiesToPayload(r,i)}}};Q.prototype._isTransitionMessagesOnly=function(e){return this.oTransitionMessagesOnlyGroups.has(e)};Q.prototype.setTransitionMessagesOnlyForGroup=function(e,t){var a=t?"add":"delete";this.oTransitionMessagesOnlyGroups[a](e)};return Q});
//# sourceMappingURL=ODataModel.js.map