/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Namespace for TypeScript type definitions of the OData V4 model.
 *
 * @name sap.ui.model.odata.v4.ts
 * @namespace
 * @public
 * @since 1.118.0
 */

/**
 * An object representing a "14.5.11 Expression edm:NavigationPropertyPath". Its shape corresponds
 * exactly to the shape of such an expression in the
 * {@link topic:87aac894a40640f89920d7b2a414499b OData V4 Metadata JSON Format} as returned by
 * {@link sap.ui.model.odata.v4.ODataMetaModel#requestObject}.
 *
 * @typedef {object} sap.ui.model.odata.v4.ts.NavigationPropertyPathExpression
 * @property {string} $NavigationPropertyPath
 *   A value of type <code>Edm.NavigationPropertyPath</code>.
 *
 * @public
 * @see {@link sap.ui.model.odata.v4.Context#requestSideEffects}
 * @since 1.118.0
 */

/**
 * An object representing a "14.5.13 Expression edm:PropertyPath". Its shape corresponds exactly to
 * the shape of such an expression in the
 * {@link topic:87aac894a40640f89920d7b2a414499b OData V4 Metadata JSON Format} as returned by
 * {@link sap.ui.model.odata.v4.ODataMetaModel#requestObject}.
 *
 * @typedef {object} sap.ui.model.odata.v4.ts.PropertyPathExpression
 * @property {string} $PropertyPath
 *   A value of type <code>Edm.PropertyPath</code>.
 *
 * @public
 * @see {@link sap.ui.model.odata.v4.Context#requestSideEffects}
 * @since 1.118.0
 */
