/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/isEmptyObject","sap/ui/core/date/UI5Date","sap/ui/core/format/DateFormat","sap/ui/model/CompositeType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException"],function(t,e,o,a,i,r,n){"use strict";var s=a.extend("sap.ui.model.type.DateInterval",{constructor:function(){a.apply(this,arguments);this.sName="DateInterval";this.bUseInternalValues=true}});s.prototype.formatValue=function(t,o){var a=this;if(!Array.isArray(t)){throw new i("Cannot format date interval: "+t+" is expected as an Array but given the wrong format")}switch(this.getPrimitiveType(o)){case"string":case"any":if(!t[0]||!t[1]&&!this.oFormatOptions.singleIntervalValue){return""}if(this.oInputFormat){t=t.map(function(t){if(a.oFormatOptions.source.pattern==="timestamp"){if(typeof t!=="number"){if(isNaN(t)){throw new i("Cannot format date: "+t+" is not a valid Timestamp")}else{t=parseInt(t)}}t=e.getInstance(t)}else{t=a.oInputFormat.parse(t);if(t==null){throw new i("Cannot format date: "+t+" has the wrong format")}}return t})}return this.oOutputFormat.format(t);default:throw new i("Don't know how to format Date to "+o)}};s.prototype.parseValue=function(t,e){var o,a,i=this;switch(this.getPrimitiveType(e)){case"string":if(t===""){return[null,null]}a=this.oOutputFormat.parse(t);if(!a[0]||!a[1]&&!this.oFormatOptions.singleIntervalValue){o=sap.ui.getCore().getLibraryResourceBundle();throw new r(o.getText(this.sName+".Invalid"))}if(a[1]&&this.sName==="DateInterval"){if(this.oFormatOptions.UTC){a[1].setUTCHours(23,59,59,0)}else{a[1].setHours(23,59,59,0)}}if(this.oInputFormat){a=a.map(function(t){return i.oFormatOptions.source.pattern==="timestamp"?t.getTime():i.oInputFormat.format(t)})}return a;default:throw new r("Don't know how to parse a date interval from "+e)}};s.prototype.validateValue=function(t){var e,o,a=sap.ui.getCore().getLibraryResourceBundle(),i=[],r=[],s=this;if(this.oInputFormat&&this.oFormatOptions.source.pattern!="timestamp"){t=t.map(function(t){return s.oInputFormat.parse(t)})}e=!this.oFormatOptions.singleIntervalValue||t[1]!==null;if(this.oConstraints.minimum){o=this.oConstraints.minimum;if(t[0]<o||e&&t[1]<o){i.push("minimum");r.push(a.getText("Date.Minimum",[o]))}}if(this.oConstraints.maximum){o=this.oConstraints.maximum;if(t[0]>o||e&&t[1]>o){i.push("maximum");r.push(a.getText("Date.Maximum",[o]))}}if(i.length>0){throw new n(this.combineMessages(r),i)}};s.prototype.setFormatOptions=function(t){this.oFormatOptions=t;this._createFormats()};s.prototype._handleLocalizationChange=function(){this._createFormats()};s.prototype._createFormats=function(){var e=this.oFormatOptions.source;this.oFormatOptions.interval=true;this.oOutputFormat=o.getDateInstance(this.oFormatOptions);if(e){if(t(e)){e={pattern:"yyyy-MM-dd"}}this.oInputFormat=o.getDateInstance(e)}};s.prototype.getPlaceholderText=function(){return this.oOutputFormat.getPlaceholderText()};return s});
//# sourceMappingURL=DateInterval.js.map