/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/util/each","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/SimpleType","sap/ui/model/ValidateException"],function(t,e,s,n,a,i){"use strict";var r=a.extend("sap.ui.model.type.String",{constructor:function(){a.apply(this,arguments);this.sName="String";if(this.oConstraints.search&&typeof this.oConstraints.search=="string"){this.oConstraints.search=new RegExp(this.oConstraints.search)}}});r.prototype.formatValue=function(t,e){if(t==undefined||t==null){return null}switch(this.getPrimitiveType(e)){case"string":case"any":return t;case"int":var n=parseInt(t);if(isNaN(n)){throw new s(t+" is not a valid int value")}return n;case"float":var a=parseFloat(t);if(isNaN(a)){throw new s(t+" is not a valid float value")}return a;case"boolean":if(t.toLowerCase()=="true"||t=="X"){return true}if(t.toLowerCase()=="false"||t==""){return false}throw new s(t+" is not a valid boolean value");default:throw new s("Don't know how to format String to "+e)}};r.prototype.parseValue=function(t,e){switch(this.getPrimitiveType(e)){case"string":return t;case"boolean":case"int":case"float":return t.toString();default:throw new n("Don't know how to parse String from "+e)}};r.prototype.validateValue=function(s){if(this.oConstraints){var n=sap.ui.getCore().getLibraryResourceBundle(),a=[],r=[];if(s===null){s=""}e(this.oConstraints,function(e,i){switch(e){case"maxLength":if(s.length>i){a.push("maxLength");r.push(n.getText("String.MaxLength",[i]))}break;case"minLength":if(s.length<i){a.push("minLength");r.push(n.getText("String.MinLength",[i]))}break;case"startsWith":if(!(typeof i=="string"&&i.length>0&&s.startsWith(i))){a.push("startsWith");r.push(n.getText("String.StartsWith",[i]))}break;case"startsWithIgnoreCase":if(!(typeof i=="string"&&i!=""?s.toLowerCase().startsWith(i.toLowerCase()):false)){a.push("startsWithIgnoreCase");r.push(n.getText("String.StartsWith",[i]))}break;case"endsWith":if(!(typeof i=="string"&&i.length>0&&s.endsWith(i))){a.push("endsWith");r.push(n.getText("String.EndsWith",[i]))}break;case"endsWithIgnoreCase":if(!(typeof i=="string"&&i!=""?s.toLowerCase().endsWith(i.toLowerCase()):false)){a.push("endsWithIgnoreCase");r.push(n.getText("String.EndsWith",[i]))}break;case"contains":if(s.indexOf(i)==-1){a.push("contains");r.push(n.getText("String.Contains",[i]))}break;case"equals":if(s!=i){a.push("equals");r.push(n.getText("String.Equals",[i]))}break;case"search":if(s.search(i)==-1){a.push("search");r.push(n.getText("String.Search",[i]))}break;default:t.warning("Ignoring unknown constraint: '"+e+"'",null,"sap.ui.model.type.String")}});if(a.length>0){throw new i(this.combineMessages(r),a)}}};return r});
//# sourceMappingURL=String.js.map