/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/strings/hash","sap/base/util/each","sap/base/util/extend","sap/base/util/isEmptyObject","sap/ui/core/Configuration","sap/ui/core/LocaleData","sap/ui/core/format/NumberFormat","sap/ui/model/CompositeType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException"],function(t,e,a,i,s,n,r,o,u,c,p){"use strict";var m=o.extend("sap.ui.model.type.Unit",{constructor:function(t,e,a){o.apply(this,arguments);this.sName="Unit";this.bShowMeasure=!t||!("showMeasure"in t)||t.showMeasure;this.bShowNumber=!t||!("showNumber"in t)||t.showNumber;this.bUseRawValues=true;this.aDynamicFormatOptionNames=a}});m.prototype._getInstance=function(e,i){var o=this.createFormatOptions(e);if(i&&!this.oFormatOptions.customUnits&&!o.customUnits){var u=s.getFormatSettings().getFormatLocale();var c=n.getInstance(u);var p=c.getUnitFromMapping(i)||i;var h=c.getUnitFormat(p);if(h){var l=a({},h);l.decimals=o.decimals!=undefined?o.decimals:l.decimals;l.precision=o.precision!=undefined?o.precision:l.precision;o.customUnits={};o.customUnits[i]=l}}var f=o;if(this.oFormatOptions){f=a({},this.oFormatOptions,o)}if(this.iScale>=0){f=a({},{maxFractionDigits:this.iScale},f)}if(this.getMetadata().getClass()!==m){var g=this.getMetadata();g._mTypeInstanceCache=g._mTypeInstanceCache||{};var y=t(JSON.stringify(f)||"");var d=g._mTypeInstanceCache[y];if(!d){d=r.getUnitInstance(f);g._mTypeInstanceCache[y]=d}return d}else{return r.getUnitInstance(f)}};m.prototype._clearInstances=function(){if(this.getMetadata().getClass()!==m){var t=this.getMetadata();if(t._mTypeInstanceCache){t._mTypeInstanceCache={}}}};m.prototype.createFormatOptions=function(t){var e={};if(this.aDynamicFormatOptionNames&&t.length>=this.aDynamicFormatOptionNames.length){this.aDynamicFormatOptionNames.forEach(function(a,i){if(a){e[a]=t[i]}})}return e};m.prototype.extractArguments=function(t){return Array.isArray(t)&&t.length>2?t.slice(2):[]};m.prototype.formatValue=function(t,e){var a=t;if(t==undefined||t==null){return null}if(this.oInputFormat){a=this.oInputFormat.parse(t)}if(!Array.isArray(a)){throw new u("Cannot format Unit: "+t+" has the wrong format")}if((a[0]==undefined||a[0]==null)&&this.bShowNumber){return null}switch(this.getPrimitiveType(e)){case"string":this.aDynamicValues=this.extractArguments(a);this.oOutputFormat=this._getInstance(this.aDynamicValues,a[1]);return this.oOutputFormat.format(a);case"int":case"float":case"any":default:throw new u("Don't know how to format Unit to "+e)}};m.prototype.getPartsListeningToTypeChanges=function(){return this.bShowNumber?[0]:[]};m.prototype.parseValue=function(t,e){var a;switch(this.getPrimitiveType(e)){case"string":this.oOutputFormat=this._getInstance(this.aDynamicValues);a=this.oOutputFormat.parse(t);if(!Array.isArray(a)||this.bShowNumber&&isNaN(a[0])){throw this.getParseException()}break;case"int":case"float":default:throw new c("Don't know how to parse Unit from "+e)}if(this.oInputFormat){a=this.oInputFormat.format(a)}return a};m.prototype.processPartTypes=function(t){const e=t[0];if(e?.isA("sap.ui.model.odata.type.Decimal")){this.iScale=e.oConstraints?.scale||0}};m.prototype.validateValue=function(t){if(this.oConstraints){var a=sap.ui.getCore().getLibraryResourceBundle(),i=[],s=[],n=t,o;if(this.oInputFormat){n=this.oInputFormat.parse(t)}o=n[0];e(this.oConstraints,function(t,e){switch(t){case"minimum":if(o<e){i.push("minimum");s.push(a.getText("Unit.Minimum",[e]))}break;case"maximum":if(o>e){i.push("maximum");s.push(a.getText("Unit.Maximum",[e]))}break;case"decimals":var n=r._shiftDecimalPoint(o,e);if(Math.floor(n)!==n){i.push("decimals");s.push(a.getText("Unit.Decimals",[e]))}break;default:break}});if(i.length>0){throw new p(s.join(" "),i)}}};m.prototype.setFormatOptions=function(t){this.oFormatOptions=Object.assign(t.style!=="short"&&t.style!=="long"?{preserveDecimals:true}:{},t);this._clearInstances();this._createInputFormat()};m.prototype._handleLocalizationChange=function(){this._clearInstances();this._createInputFormat()};m.prototype._createInputFormat=function(){var t=this.oFormatOptions.source;if(t){if(i(t)){t={groupingEnabled:false,groupingSeparator:",",decimalSeparator:"."}}this.oInputFormat=r.getUnitInstance(t)}};m.prototype.getParseException=function(){var t=sap.ui.getCore().getLibraryResourceBundle(),e;if(!this.bShowNumber){e=t.getText("Unit.InvalidMeasure")}else if(!this.bShowMeasure){e=t.getText("EnterNumber")}else{e=t.getText("Unit.Invalid")}return new c(e)};m.prototype.getPartsIgnoringMessages=function(){if(!this.bShowMeasure){return[1]}else if(!this.bShowNumber){return[0]}return[]};return m});
//# sourceMappingURL=Unit.js.map