/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/strings/capitalize","sap/base/util/isPlainObject","sap/base/Log","sap/m/MessageBox","sap/m/MessageToast","sap/ui/base/ManagedObject","sap/ui/core/BusyIndicator","sap/ui/core/Lib","sap/ui/dt/DesignTime","sap/ui/dt/DOMUtil","sap/ui/dt/ElementUtil","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/events/KeyCodes","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/initial/api/Version","sap/ui/fl/registry/Settings","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/fl/write/api/ControlPersonalizationWriteAPI","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/write/api/ReloadInfoAPI","sap/ui/fl/write/api/TranslationAPI","sap/ui/fl/write/api/VersionsAPI","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/model/json/JSONModel","sap/ui/performance/Measurement","sap/ui/rta/appVariant/Feature","sap/ui/rta/command/BaseCommand","sap/ui/rta/command/LREPSerializer","sap/ui/rta/command/Stack","sap/ui/rta/service/index","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/FioriLike","sap/ui/rta/toolbar/Personalization","sap/ui/rta/toolbar/Standalone","sap/ui/rta/util/changeVisualization/ChangeVisualization","sap/ui/rta/util/PluginManager","sap/ui/rta/util/PopupManager","sap/ui/rta/util/ReloadManager","sap/ui/rta/util/ServiceEventBus","sap/ui/rta/util/validateFlexEnabled","sap/ui/rta/Utils","sap/ui/thirdparty/jquery","sap/ui/Device"],function(e,t,i,n,a,o,r,s,l,d,h,c,u,g,p,f,v,m,S,b,y,C,_,A,R,E,P,T,M,I,D,w,O,L,V,x,N,B,U,k,F,G,z,K,j,H,$,jQuery,W){"use strict";var q="STARTING";var Y="STARTED";var Z="STOPPED";var J="FAILED";var Q="SERVICE_STARTING";var X="SERVICE_STARTED";var ee="SERVICE_FAILED";var te=o.extend("sap.ui.rta.RuntimeAuthoring",{metadata:{library:"sap.ui.rta",associations:{rootControl:{type:"sap.ui.base.ManagedObject"}},properties:{showToolbars:{type:"boolean",defaultValue:true},triggeredFromDialog:{type:"boolean",defaultValue:false},showWindowUnloadDialog:{type:"boolean",defaultValue:true},commandStack:{type:"any"},flexSettings:{type:"object",defaultValue:{layer:T.CUSTOMER,developerMode:true}},mode:{type:"string",defaultValue:"adaptation"},metadataScope:{type:"string",defaultValue:"default"}},events:{start:{parameters:{editablePluginsCount:{type:"int"}}},stop:{},failed:{parameters:{error:{type:"any"}}},selectionChange:{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},modeChanged:{},undoRedoStackModified:{}}},_sAppTitle:null,_dependents:null,_sStatus:Z,_bNavigationModeWarningShown:false,constructor:function(...e){o.apply(this,e);this._dependents={};this._mServices={};this._mUShellServices={};this._pElementModified=Promise.resolve();this.addDependent(new G,"pluginManager");this.addDependent(new z,"popupManager");if(this.getShowToolbars()){this.getPopupManager().attachOpen(ae,this);this.getPopupManager().attachClose(oe,this);this.addDependent(new F,"changeVisualization")}if(window.parent!==window){this.startService("receiver")}this.startService("supportTools");this._loadUShellServicesPromise=M.getUShellServices(["URLParsing","AppLifeCycle","CrossApplicationNavigation"]).then(function(e){this._mUShellServices=e;K.setUShellServices(e)}.bind(this))}});te.needsRestart=function(e){return K.needsAutomaticStart(e)};te.enableRestart=function(e,t){K.enableAutomaticStart(e,t)};te.disableRestart=function(e){K.disableAutomaticStart(e)};te.willRTAStartAfterReload=function(e){return K.needsAutomaticStart(e||T.CUSTOMER)};te.prototype.addDependent=function(t,i,n){n=typeof n==="undefined"?true:!!n;if(!(i in this._dependents)){if(i&&n){this[`get${e(i,0)}`]=this.getDependent.bind(this,i)}this._dependents[i||t.getId()]=t}else{throw g.createError("RuntimeAuthoring#addDependent",`Can't add dependency with same key '${i}'`,"sap.ui.rta")}};te.prototype.getDependent=function(e){return this._dependents[e]};te.prototype.getDependents=function(){return this._dependents};te.prototype.removeDependent=function(e){delete this._dependents[e]};te.prototype.setPlugins=function(e){if(this._sStatus!==Z){throw new Error("Cannot replace plugins: runtime authoring already started")}this.getPluginManager().setPlugins(e)};te.prototype.getPlugins=function(){return this.getPluginManager&&this.getPluginManager()&&this.getPluginManager().getPlugins()};te.prototype.getDefaultPlugins=function(){return this.getPluginManager().getDefaultPlugins(this.getFlexSettings())};te.prototype.setFlexSettings=function(e){var t=new URLSearchParams(window.location.search);var i=t.get("sap-ui-layer");e=Object.assign({},this.getFlexSettings(),e);if(i){e.layer=i.toUpperCase()}if(e.scenario||e.baseId){var n=M.buildLrepRootNamespace(e.baseId,e.scenario,e.projectId);e.rootNamespace=n;e.namespace=`${n}changes/`}$.setRtaStyleClassName(e.layer);this.setProperty("flexSettings",e)};te.prototype.getLayer=function(){return this.getFlexSettings().layer};te.prototype.getRootControlInstance=function(){this._oRootControl||=h.getElementInstance(this.getRootControl());return this._oRootControl};te.prototype._getTextResources=function(){return s.getResourceBundleFor("sap.ui.rta")};te.prototype.start=function(){var e=te.needsRestart(this.getLayer());var t;var n;if(this._sStatus===Z){this._sStatus=q;var a=this.getRootControlInstance();if(!a){n=new Error("Root control not found");i.error(n);return Promise.reject(n)}return this._loadUShellServicesPromise.then(Le.bind(this)).then(Ve.bind(this,e)).then(function(){return K.handleReloadOnStart({layer:this.getLayer(),selector:this.getRootControlInstance(),versioningEnabled:this._oVersionsModel.getProperty("/versioningEnabled"),developerMode:this.getFlexSettings().developerMode,adaptationId:this._oContextBasedAdaptationsModel.getProperty("/displayedAdaptation/id")})}.bind(this)).then(function(e){if(e){return Promise.reject("Reload triggered")}var i=A.getResetAndPublishInfoFromSession(this.getRootControlInstance());this.bInitialResetEnabled=!!i.isResetEnabled;this._oSerializer=new L({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});this.getPluginManager().preparePlugins(this.getFlexSettings(),Fe.bind(this),this.getCommandStack());var n=this.getPluginManager().getPluginList();t=new Promise(function(e,t){D.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new l({scope:this.getMetadataScope(),plugins:n});le(this.getRootControlInstance(),true);this._oDesignTime.addRootElement(this._oRootControl);c.getOverlayContainer().get(0).classList.add("sapUiRta");if(this.getLayer()===T.USER){c.getOverlayContainer().get(0).classList.add("sapUiRtaPersonalize")}else{document.body.classList.add("sapUiRtaMode")}this._oDesignTime.getSelectionManager().attachChange(function(e){this.fireSelectionChange({selection:e.getParameter("selection")})},this);this._oDesignTime.attachEventOnce("synced",function(){e();D.end("rta.dt.startup","Measurement of RTA: DesignTime start up")},this);this._oDesignTime.attachEventOnce("syncFailed",function(e){t(e.getParameter("error"))})}.bind(this));this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);return undefined}.bind(this)).then(function(){if(this.getShowToolbars()){return he(this.getRootControlInstance(),this.getLayer(),this._oSerializer).then(xe.bind(this))}return undefined}.bind(this)).then(ue.bind(this)).then(function(){c.getOverlayContainer().get(0).style.setProperty("--sap-ui-rta-scrollbar-scrollWidth",`${d.getScrollbarWidth()}px`);c.getOverlayContainer().get(0).style.setProperty("--sap-ui-rta-scrollbar-scrollWidthPlusTwo",`${d.getScrollbarWidth()+2}px`);return t}).then(function(){this.getPopupManager().setRta(this);if(this.getShowToolbars()){return this.getToolbar().show()}return undefined}.bind(this)).then(function(){if(W.browser.name==="ff"){jQuery(document).on("contextmenu",de)}}).then(function(){this.fnKeyDown=fe.bind(this);jQuery(document).on("keydown",this.fnKeyDown);this.fnOnPersonalizationChangeCreation=re.bind(this);C.attachChangeCreation(this.getRootControlInstance(),this.fnOnPersonalizationChangeCreation)}.bind(this)).then(ne).then(function(e){if(e){H(this)}this._sStatus=Y;te.disableRestart(this.getLayer());this.fireStart({editablePluginsCount:this.getPluginManager().getEditableOverlaysCount()})}.bind(this)).catch(function(e){if(e==="Reload triggered"){this.destroy()}else{this._sStatus=J;this.fireFailed({error:e})}return Promise.reject(e)}.bind(this))}return Promise.reject("RuntimeAuthoring is already started")};function ie(){var e=this._oVersionsModel.getProperty("/versioningEnabled");var t=e?"MSG_UNSAVED_DRAFT_CHANGES_ON_CLOSE":"MSG_UNSAVED_CHANGES_ON_CLOSE";var i=e?"BTN_UNSAVED_DRAFT_CHANGES_ON_CLOSE_SAVE":"BTN_UNSAVED_CHANGES_ON_CLOSE_SAVE";return $.showMessageBox("warning",t,{titleKey:"TIT_UNSAVED_CHANGES_ON_CLOSE",actionKeys:[i,"BTN_UNSAVED_CHANGES_ON_CLOSE_DONT_SAVE"],emphasizedActionKey:"BTN_UNSAVED_CHANGES_ON_CLOSE_SAVE",showCancel:true})}te.prototype.stop=function(e,t){var i;var a;ge.call(this,"setBusy",true);return pe.call(this).then(function(){var t=this.getLayer();if(t!==T.USER&&!e&&this.canSave()){return ie.call(this).then(function(e){if(e===n.Action.CANCEL){i=true;return Promise.reject()}if(e===this._getTextResources().getText("BTN_UNSAVED_CHANGES_ON_CLOSE_DONT_SAVE")){return this._oSerializer.clearCommandStack(true)}return undefined}.bind(this))}return undefined}.bind(this)).then(function(){if(t){return{}}return K.checkReloadOnExit({layer:this.getLayer(),selector:this.getRootControlInstance(),isDraftAvailable:this._oVersionsModel.getProperty("/draftAvailable"),versioningEnabled:this._oVersionsModel.getProperty("/versioningEnabled"),activeVersion:this._oVersionsModel.getProperty("/activeVersion"),changesNeedReloadPromise:this._bSavedChangesNeedReload?Promise.resolve(true):this._oSerializer.needsReload()})}.bind(this)).then(function(t){a=t;if(!e){return this._serializeToLrep(false,true)}return undefined}.bind(this)).then(function(){ge.call(this,"hide",e);this.fireStop();if(!t){R.removeInfoSessionStorage(this.getRootControlInstance());if(a.allContexts){const e=v.getFlexReferenceForControl(this.getRootControlInstance());f.clearState(e)}K.handleUrlParametersOnExit(a)}P.clearInstances()}.bind(this)).catch(function(e){if(!i){return ce(e)}return undefined}).then(function(){ge.call(this,"setBusy",false);if(!i){this._sStatus=Z;document.body.classList.remove("sapUiRtaMode")}}.bind(this))};te.prototype.setCommandStack=function(e){var t=this.getProperty("commandStack");if(t){t.detachModified(ue,this)}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack}var i=this.setProperty("commandStack",e);if(e){e.attachModified(ue,this)}if(this.getPluginManager&&this.getPluginManager()){this.getPluginManager().provideCommandStack("settings",e)}return i};te.prototype.getCommandStack=function(){var e=this.getProperty("commandStack");if(!e){e=new V;this._oInternalCommandStack=e;this.setCommandStack(e)}return e};te.prototype.setMode=function(e){var t=this.getMode();if(t!==e){var i=this.getPluginManager().getPlugin("tabHandling");var n=this.getPluginManager().getPlugin("selection");if(t==="navigation"||e==="navigation"){this._oDesignTime.setEnabled(e!=="navigation");i[e==="navigation"?"restoreTabIndex":"removeTabIndex"]()}var a=this.getChangeVisualization&&this.getChangeVisualization();if(e==="visualization"||t==="visualization"){g.waitForSynced(this._oDesignTime)().then(function(){return a.triggerModeChange(this.getRootControl(),this.getToolbar())}.bind(this))}if(t==="adaptation"){this.getPluginManager().handleStopCutPaste()}i[e==="adaptation"?"restoreOverlayTabIndex":"removeOverlayTabIndex"]();n.setIsActive(!(e==="visualization"));c.getOverlayContainer().toggleClass("sapUiRtaVisualizationMode",e==="visualization");if(e==="visualization"){document.querySelectorAll(".sapUiDtOverlayMovable").forEach(function(e){e.style.cursor="default"})}else{document.querySelectorAll(".sapUiDtOverlayMovable").forEach(function(e){e.style.cursor="move"})}this._oToolbarControlsModel.setProperty("/modeSwitcher",e);this.setProperty("mode",e);this.fireModeChanged({mode:e})}};te.prototype.setMetadataScope=function(e){if(this._sStatus!==Z){i.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return}this.setProperty("metadataScope",e)};te.prototype.destroy=function(...e){var t=Object.keys(this._dependents);t.forEach(function(e){this._dependents[e].destroy(true);this.removeDependent(e)}.bind(this));Object.keys(this._mServices).forEach(function(e){this.stopService(e)},this);if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;jQuery(document).off("keydown",this.fnKeyDown);if(this.fnOnPersonalizationChangeCreation){C.detachChangeCreation(this.getRootControlInstance(),this.fnOnPersonalizationChangeCreation)}}if(this.getRootControlInstance()){le(this.getRootControlInstance(),false)}this.setCommandStack(null);if(this._oServiceEventBus){this._oServiceEventBus.destroy()}if(W.browser.name==="ff"){jQuery(document).off("contextmenu",de)}window.onbeforeunload=this._oldUnloadHandler;o.prototype.destroy.apply(this,e)};te.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get()}return[]};te.prototype.restore=function(){var e=this.getLayer();var t=e===T.USER?"FORM_PERS_RESET_MESSAGE_PERSONALIZATION":"FORM_PERS_RESET_MESSAGE";var i=e===T.USER?"BTN_RESTORE":"FORM_PERS_RESET_TITLE";this.getPluginManager().handleStopCutPaste();return $.showMessageBox("warning",t,{titleKey:i,actions:[n.Action.OK,n.Action.CANCEL],emphasizedAction:n.Action.OK}).then(function(t){if(t===n.Action.OK){te.enableRestart(e,this.getRootControlInstance());return Ne.call(this)}return undefined}.bind(this))};te.prototype.undo=function(){this.getPluginManager().handleStopCutPaste();return this.getCommandStack().undo()};te.prototype.redo=function(){this.getPluginManager().handleStopCutPaste();return this.getCommandStack().redo()};te.prototype.canUndo=function(){return this.getCommandStack().canUndo()};te.prototype.canSave=function(){return this.getCommandStack().canSave()};te.prototype.canRedo=function(){return this.getCommandStack().canRedo()};te.prototype.save=function(){return pe.call(this).then(this._serializeToLrep.bind(this))};te.prototype._serializeToLrep=function(e,t){if(!this._bSavedChangesNeedReload){return this._oSerializer.needsReload().then(function(i){this._bSavedChangesNeedReload=i;return me.call(this,undefined,e,t)}.bind(this))}return me.call(this,undefined,e,t)};te.prototype.condenseAndSaveChanges=function(...e){return this._serializeToLrep(...e)};te.prototype._onUnload=function(){if(this.canSave()&&this.getShowWindowUnloadDialog()){return this._getTextResources().getText("MSG_UNSAVED_CHANGES")}window.onbeforeunload=this._oldUnloadHandler;return undefined};function ne(){var e=new URLSearchParams(window.location.search).get("sap-ui-rta-skip-flex-validation");return b.getInstance().then(function(t){return!t.isCustomerSystem()&&e!=="true"})}function ae(e){var t=e.getParameters().getSource();if(t.isA("sap.m.Dialog")&&this.getToolbar().type==="fiori"){this.getToolbar().setColor("contrast")}this.getToolbar().bringToFront()}function oe(e){if(e.getParameters().isA("sap.m.Dialog")){this.getToolbar().setColor()}}function re(){if(this.getMode()==="navigation"&&!this._bNavigationModeWarningShown){se.call(this,"MSG_NAVIGATION_MODE_CHANGES_WARNING",{duration:5e3});this._bNavigationModeWarningShown=true}}function se(e,t){var i=this._getTextResources().getText(e);a.show(i,t||{})}function le(e,t){if(e.isA("sap.ui.core.UIComponent")){e=e.getRootControl()}if(e){e[t?"addStyleClass":"removeStyleClass"]("sapUiRtaRoot")}}function de(){return false}function he(e,t,i){return Promise.all([_.isPublishAvailable(),w.isSaveAsAvailable(e,t,i),_.isContextBasedAdaptationAvailable(t),M.getUShellService("AppLifeCycle").then(function(e){if(e){var t=e.getCurrentApplication();return t?t.homePage:false}return false})]).then(function(t){var i=t[0];var n=t[1];var a=t[2];var o=t[3];var r=M.getAppDescriptor(e);var s=r&&!v.getOvpEntry(r);return{publishAvailable:i,saveAsAvailable:!o&&i&&n,contextBasedAdaptationAvailable:!o&&s&&a}})}function ce(e){r.hide();var t=e.userMessage||e.stack||e.message||e.status||e;var a=s.getResourceBundleFor("sap.ui.rta");i.error("Failed to transfer changes",t);var o=`${a.getText("MSG_LREP_TRANSFER_ERROR")}\n\t\t\t${a.getText("MSG_ERROR_REASON",[t])}`;n.error(o,{styleClass:$.getRtaStyleClassName()})}function ue(){var e=!this.getShowToolbars()||!this.getCommandStack().canUndo();$.checkDraftOverwrite(this._oVersionsModel,e).then(()=>{if(this.getShowToolbars()){var e=this.getCommandStack();var t=e.canUndo();var i=e.canRedo();var n=e.canSave();var a=e.getSaved();var o=this._oToolbarControlsModel.getProperty("/translation/visible")&&E.hasTranslationRelevantDirtyChanges({layer:T.CUSTOMER,selector:this.getRootControlInstance()});this._oVersionsModel.setDirtyChanges(A.hasDirtyChanges({selector:this.getRootControlInstance()}));this._oToolbarControlsModel.setProperty("/undo/enabled",t);this._oToolbarControlsModel.setProperty("/redo/enabled",i);this._oToolbarControlsModel.setProperty("/save/enabled",n);this._oToolbarControlsModel.setProperty("/restore/enabled",this.bInitialResetEnabled||n||a);this._oToolbarControlsModel.setProperty("/translation/enabled",this.bPersistedDataTranslatable||o)}this.fireUndoRedoStackModified()}).catch(()=>{this.undo()})}function ge(e,t){if(this.getShowToolbars()&&this.getToolbar&&this.getToolbar()){return this.getToolbar()[e](t)}return undefined}function pe(){return Promise.resolve(this._oDesignTime&&this._oDesignTime.waitForBusyPlugins()).then(function(){return this._pElementModified}.bind(this))}function fe(e){var t=W.os.macintosh;var i=c.getOverlayContainer().get(0).contains(document.activeElement);var n=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);var a=false;document.querySelectorAll(".sapUiDtContextMenu").forEach(function(e){if(e.contains(document.activeElement)){a=true}});var o=document.body===document.activeElement;var r=d.getParents(document.activeElement,".sapUiRtaEditableField").length>0;if((i||n||a||o)&&!r){var s=t?e.metaKey:e.ctrlKey;if(e.keyCode===p.Z&&e.shiftKey===false&&e.altKey===false&&s===true){this.undo().then(e.stopPropagation.bind(e))}else if((t&&e.keyCode===p.Z&&e.shiftKey===true||!t&&e.keyCode===p.Y&&e.shiftKey===false)&&e.altKey===false&&s===true){this.redo().then(e.stopPropagation.bind(e))}}}function ve(e){var t=e.getParameter("callback")||function(){};var i=this._oVersionsModel.getProperty("/versioningEnabled");return this.save().then(function(){se.call(this,i?"MSG_SAVE_DRAFT_SUCCESS":"MSG_SAVE_SUCCESS",{duration:5e3})}.bind(this)).catch(function(e){return ce(e)}).then(t)}function me(e,t,i){if(this.getShowToolbars()){this.bPersistedDataTranslatable=this._oToolbarControlsModel.getProperty("/translation/enabled")}var n={layer:this.getLayer(),removeOtherLayerChanges:true,condenseAnyLayer:t};if(this._oVersionsModel.getProperty("/versioningEnabled")){var a=e?this._oVersionsModel.getProperty("/displayedVersion"):undefined;a||=i?undefined:S.Number.Draft;n.version=a;n.saveAsDraft=this.getLayer()===T.CUSTOMER}if(this._oContextBasedAdaptationsModel.getProperty("/contextBasedAdaptationsEnabled")){n.adaptationId=i?undefined:this._oContextBasedAdaptationsModel.getProperty("/displayedAdaptation/id")}return this._oSerializer.saveCommands(n).then(function(){if(!i){var e=this.getToolbar();var t=this.getChangeVisualization();t.updateAfterSave(e)}}.bind(this))}function Se(e){var t=e.getParameter("versionTitle");if(we.call(this)&&Oe.call(this)){return $.showMessageBox("warning","MSG_DRAFT_DISCARD_ON_REACTIVATE_DIALOG",{titleKey:"TIT_DRAFT_DISCARD_ON_REACTIVATE_DIALOG",actions:[n.Action.OK,n.Action.CANCEL],emphasizedAction:n.Action.OK}).then(function(e){if(e===n.Action.OK){return be.call(this,t)}return undefined}.bind(this))}return be.call(this,t)}function be(e){var t=this.getLayer();var i=this.getRootControlInstance();var n=this._oVersionsModel.getProperty("/displayedVersion");return me.call(this,true).then(function(){return P.activate({layer:t,control:i,title:e,displayedVersion:n})}).then(function(){se.call(this,"MSG_DRAFT_ACTIVATION_SUCCESS");this.bInitialResetEnabled=true;this._oToolbarControlsModel.setProperty("/restore/enabled",true);this.getCommandStack().removeAllCommands()}.bind(this)).catch(function(e){$.showMessageBox("error","MSG_DRAFT_ACTIVATION_FAILED",{error:e})})}function ye(){return $.showMessageBox("warning","MSG_DRAFT_DISCARD_DIALOG",{actions:[n.Action.OK,n.Action.CANCEL],emphasizedAction:n.Action.OK}).then(function(e){if(e===n.Action.OK){return P.discardDraft({layer:this.getLayer(),control:this.getRootControlInstance(),updateState:true}).then(Ce.bind(this))}return undefined}.bind(this))}function Ce(){var e=this.getLayer();var t={layer:e,removeDraft:true,selector:this.getRootControlInstance()};te.enableRestart(e,this.getRootControlInstance());this.getCommandStack().removeAllCommands();K.triggerReload(t);return this.stop(true,true)}function _e(){if(this.canSave()){Ae.call(this,"DAC_DATA_LOSS_DIALOG_DESCRIPTION","DAC_DIALOG_HEADER",true)}else{Ae.call(this,"DAC_DIALOG_DESCRIPTION","DAC_DIALOG_HEADER")}}function Ae(e,t,i){$.showMessageBox("confirm",e,{titleKey:t}).then(function(e){if(e===n.Action.OK){r.show();if(i){this.getCommandStack().removeAllCommands(true)}Re.call(this)}}.bind(this))}function Re(){D.start("onCBADeleteAdaptation","Measurement of deleting a context-based adaptation");y.remove({control:this.getRootControlInstance(),layer:this.getLayer(),adaptationId:this._oContextBasedAdaptationsModel.getProperty("/displayedAdaptation/id")}).then(function(){r.hide();var e=this._oContextBasedAdaptationsModel.deleteAdaptation();Te.call(this,e);D.end("onCBADeleteAdaptation");if(D.getActive()){i.info(`onCBADeleteAdaptation: ${D.getMeasurement("onCBADeleteAdaptation").time} ms`)}}.bind(this)).catch(function(e){r.hide();i.error(e.stack);var t="MSG_LREP_TRANSFER_ERROR";var n={titleKey:"DAC_DIALOG_HEADER"};n.details=e.userMessage;$.showMessageBox("error",t,n)})}function Ee(e,t,i){if(this.canSave()){$.showMessageBox("warning",e,{titleKey:t,actions:[n.Action.YES,n.Action.NO,n.Action.CANCEL],emphasizedAction:n.Action.YES}).then(function(e){if(e===n.Action.YES){return this._serializeToLrep().then(i)}else if(e===n.Action.NO){this.getCommandStack().removeAllCommands(true);return i()}return Promise.resolve()}.bind(this));return Promise.resolve()}return i()}function Pe(e){D.start("onCBASwitchAdaptation","Measurement of switching a context-based adaptation");var t=e.getParameter("callback")||function(){};if(e.getParameter("trigger")==="SaveAs"){this.getCommandStack().removeAllCommands(true)}var n=e.getParameter("adaptationId");this._sSwitchToAdaptationId=n;return Ee.call(this,"MSG_SWITCH_VERSION_DIALOG","BTN_SWITCH_ADAPTATIONS",Te.bind(this,this._sSwitchToAdaptationId)).then(function(){t();D.end("onCBASwitchAdaptation");if(D.getActive()){i.info(`onCBASwitchAdaptation: ${D.getMeasurement("onCBASwitchAdaptation").time} ms`)}}).catch(function(e){$.showMessageBox("error","MSG_SWITCH_ADAPTATION_FAILED",{error:e});i.error(`sap.ui.rta: ${e.stack||e.message||e}`)})}function Te(e){var t=this._oVersionsModel.getProperty("/displayedVersion");return Ie.call(this,t,e)}function Me(e){var t=e.getParameter("callback")||function(){};var n=e.getParameter("version");var a=this._oVersionsModel.getProperty("/displayedVersion");if(n===a){return}this._sSwitchToVersion=n;Ee.call(this,"MSG_SWITCH_VERSION_DIALOG","TIT_SWITCH_VERSION_DIALOG",Ie.bind(this,this._sSwitchToVersion)).then(t).catch(function(e){$.showMessageBox("error","MSG_SWITCH_VERSION_FAILED",{error:e});i.error(`sap.ui.rta: ${e.stack||e.message||e}`)})}function Ie(e,t){te.enableRestart(this.getLayer(),this.getRootControlInstance());return P.loadVersionForApplication({control:this.getRootControlInstance(),layer:this.getLayer(),version:e,adaptationId:t}).then(function(){var t={versionSwitch:true,version:e,selector:this.getRootControlInstance()};K.triggerReload(t)}.bind(this))}function De(){this.getPluginManager().handleStopCutPaste();return P.publish({selector:this.getRootControlInstance(),styleClass:$.getRtaStyleClassName(),layer:this.getLayer(),version:this._oVersionsModel.getProperty("/displayedVersion")}).then(function(e){if(e!=="Error"&&e!=="Cancel"){a.show(e)}})}function we(){return P.isOldVersionDisplayed({control:this.getRootControlInstance(),layer:this.getLayer()})}function Oe(){return P.isDraftAvailable({control:this.getRootControlInstance(),layer:this.getLayer()})}function Le(){return P.initialize({control:this.getRootControlInstance(),layer:this.getLayer()}).then(function(e){this._oVersionsModel=e}.bind(this))}function Ve(e){if(!e){y.clearInstances()}return y.initialize({control:this.getRootControlInstance(),layer:this.getLayer()}).then(function(e){this._oContextBasedAdaptationsModel=e}.bind(this))}function xe(e){if(!this.getDependent("toolbar")){var t=this.getLayer()===T.USER;var i={rtaInformation:{flexSettings:this.getFlexSettings(),rootControl:this.getRootControlInstance(),commandStack:this.getCommandStack()},textResources:this._getTextResources(),restore:this.restore.bind(this),exit:this.stop.bind(this,false,t)};if(!t){i.publishVersion=De.bind(this);i.undo=this.undo.bind(this);i.redo=this.redo.bind(this);i.modeChange=Ge.bind(this);i.activate=Se.bind(this);i.discardDraft=ye.bind(this);i.switchVersion=Me.bind(this);i.switchAdaptation=Pe.bind(this);i.deleteAdaptation=_e.bind(this);i.openChangeCategorySelectionPopover=this.getChangeVisualization?this.getChangeVisualization().openChangeCategorySelectionPopover.bind(this.getChangeVisualization()):function(){};i.save=ve.bind(this)}var n;if(t){n=new U(i)}else if($.isOriginalFioriToolbarAccessible()){n=new N(i)}else if($.getFiori2Renderer()){n=new B(i)}else{n=new k(i)}this.addDependent(n,"toolbar");return Promise.all([n.onFragmentLoaded(),_.isKeyUserTranslationEnabled(this.getLayer())]).then(function(t){var i=t[1];var n=e.saveAsAvailable;var a=n&&w.isOverviewExtended();var o=new URLSearchParams(window.location.search);var r;r=!o.has("fiori-tools-rta-mode")||o.get("fiori-tools-rta-mode")==="false";var s=m.getConfiguredFlexServices().some(function(e){return e.connector!=="LocalStorageConnector"});this.bPersistedDataTranslatable=false;this._oToolbarControlsModel=new I({modeSwitcher:this.getMode(),undo:{enabled:false},redo:{enabled:false},save:{enabled:false},translation:{visible:i,enabled:this.bPersistedDataTranslatable},appVariantMenu:{visible:n,enabled:n,overview:{visible:n&&a,enabled:n&&a},manageApps:{visible:n&&!a,enabled:n&&!a},saveAs:{visible:n,enabled:n}},restore:{visible:!this._oVersionsModel.getProperty("/versioningEnabled"),enabled:this.bInitialResetEnabled},contextBasedAdaptation:{visible:e.contextBasedAdaptationAvailable,enabled:e.contextBasedAdaptationAvailable},actionsMenuButton:{enabled:true},visualizationButton:{visible:r,enabled:r},feedbackButton:{visible:s}});this._oVersionsModel.setProperty("/publishVersionVisible",e.publishAvailable);var l=new Promise(function(e){if(!i){e();return}E.getSourceLanguages({selector:this.getRootControlInstance(),layer:this.getLayer()}).then(function(e){this.bPersistedDataTranslatable=e.length>0;this._oToolbarControlsModel.setProperty("/translation/enabled",this.bPersistedDataTranslatable)}.bind(this)).finally(e)}.bind(this));var d=new Promise(function(e){if(!n){e();return}w.isManifestSupported().then(function(e){if(M.isVariantByStartupParameter(this.getRootControlInstance())){e=false}this._oToolbarControlsModel.setProperty("/appVariantMenu/saveAs/enabled",e);this._oToolbarControlsModel.setProperty("/appVariantMenu/overview/enabled",e);this._oToolbarControlsModel.setProperty("/appVariantMenu/manageApps/enabled",e)}.bind(this)).finally(e)}.bind(this));this.getToolbar().setModel(this._oVersionsModel,"versions");this.getToolbar().setModel(this._oContextBasedAdaptationsModel,"contextBasedAdaptations");this.getToolbar().setModel(this._oToolbarControlsModel,"controls");return Promise.all([l,d])}.bind(this))}return Promise.resolve()}function Ne(){var e=this.getLayer();var t=M.getAppComponentForControl(this.getRootControlInstance());return A.reset({selector:t,layer:e}).then(function(){this.getCommandStack().removeAllCommands(true);R.removeInfoSessionStorage(t);var i={layer:e,ignoreMaxLayerParameter:true,triggerHardReload:true};return K.triggerReload(i)}.bind(this)).catch(function(e){if(e!=="cancel"){$.showMessageBox("error","MSG_RESTORE_FAILED",{error:e})}})}function Be(e,t){function i(n){var a=n.getParameter("elementOverlay");if(a.getElement().getId()===e){this._oDesignTime.detachEvent("elementOverlayCreated",i,this);t(a)}}this._oDesignTime.attachEvent("elementOverlayCreated",i,this)}function Ue(e,t){function i(e){var n=e.getSource();if(n.getGeometry()&&n.getGeometry().visible){n.detachEvent("geometryChanged",i);t(n)}}function n(e){if(!e.getGeometry()||!e.getGeometry().visible){e.attachEvent("geometryChanged",i)}else{t(e)}}Be.call(this,e,function(e){if(e.isRendered()){n(e)}else{e.attachEventOnce("afterRendering",function(e){n(e.getSource())})}})}function ke(e,t,i){var n=function(e){e.setSelected(true);this.getPluginManager().getPlugin("rename").startEdit(e)}.bind(this);Ue.call(this,t,function(t){var a=this.getPluginManager().getPlugin("createContainer").getCreatedContainerId(e,t.getElement().getId());var o=u.getOverlay(a);if(o){if(i){this.getPluginManager().getPlugin("rename").createRenameCommand(o,i).then(function(){this.getCommandStack().compositeLastTwoCommands()}.bind(this))}else{n(o)}}else{Ue.call(this,a,n)}}.bind(this))}function Fe(e){var t=e.getParameter("command");var n=e.getParameter("newControlId");var a=e.getParameter("action");var o=e.getParameter("title");this._pElementModified=this._pElementModified.then(function(){this.getPluginManager().handleStopCutPaste();if(t instanceof O){if(n){Be.call(this,n,function(e){var t=e.getDesignTimeMetadata();var i=t.getData().select;if(typeof i==="function"){i(e.getElement())}});if(a){ke.call(this,a,n,o)}}return this.getCommandStack().pushAndExecute(t).catch(function(e){if(e?.message?.indexOf?.("The following Change cannot be applied because of a dependency")>-1){$.showMessageBox("error","MSG_DEPENDENCY_ERROR",{error:e})}i.error("sap.ui.rta:",e.message,e.stack)})}return undefined}.bind(this));return this._pElementModified}function Ge(e){this.setMode(e.getParameter("item").getKey())}function ze(e){if(x.hasOwnProperty(e)){return x[e].replace(/\./g,"/")}return undefined}te.prototype.startService=function(e){if(this._sStatus!==Y){return new Promise(function(e,t){this.attachEventOnce("start",e);this.attachEventOnce("failed",t)}.bind(this)).then(function(){return this.startService(e)}.bind(this),function(){return Promise.reject(g.createError("RuntimeAuthoring#startService",`Can't start the service '${e}' because RTA startup failed`,"sap.ui.rta"))})}var i=ze(e);var n;if(!i){return Promise.reject(g.createError("RuntimeAuthoring#startService",`Unknown service. Can't find any registered service by name '${e}'`,"sap.ui.rta"))}n=this._mServices[e];if(n){switch(n.status){case X:{return Promise.resolve(n.exports)}case Q:{return n.initPromise}case ee:{return n.initPromise}default:{return Promise.reject(g.createError("RuntimeAuthoring#startService",`Unknown service status. Service name = '${e}'`,"sap.ui.rta"))}}}else{this._mServices[e]=n={};n.status=Q;n.location=i;n.initPromise=new Promise(function(a,o){sap.ui.require([i],function(i){n.factory=i;this._oServiceEventBus||=new j;g.wrapIntoPromise(i)(this,this._oServiceEventBus.publish.bind(this._oServiceEventBus,e)).then(function(i){if(this.bIsDestroyed){throw g.createError("RuntimeAuthoring#startService",`RuntimeAuthoring instance is destroyed while initializing the service '${e}'`,"sap.ui.rta")}if(!t(i)){throw g.createError("RuntimeAuthoring#startService",`Invalid service format. Service should return simple javascript object after initialization. Service name = '${e}'`,"sap.ui.rta")}n.service=i;n.exports={};if(Array.isArray(i.events)&&i.events.length>0){Object.assign(n.exports,{attachEvent:this._oServiceEventBus.subscribe.bind(this._oServiceEventBus,e),detachEvent:this._oServiceEventBus.unsubscribe.bind(this._oServiceEventBus,e),attachEventOnce:this._oServiceEventBus.subscribeOnce.bind(this._oServiceEventBus,e)})}var o=i.exports||{};Object.assign(n.exports,Object.keys(o).reduce(function(e,t){var i=o[t];e[t]=typeof i==="function"?g.waitForSynced(this._oDesignTime,i):i;return e}.bind(this),{}));n.status=X;a(Object.freeze(n.exports))}.bind(this)).catch(o)}.bind(this),function(t){n.status=ee;o(g.propagateError(t,"RuntimeAuthoring#startService",`Can't load service '${e}' by its name: ${i}`,"sap.ui.rta"))})}.bind(this)).catch(function(t){n.status=ee;return Promise.reject(g.propagateError(t,"RuntimeAuthoring#startService",`Error initializing service '${e}'`,"sap.ui.rta"))});return n.initPromise}};te.prototype.stopService=function(e){var t=this._mServices[e];if(t){if(t.status===X){if(typeof t.service.destroy==="function"){t.service.destroy()}}delete this._mServices[e]}else{throw g.createError("RuntimeAuthoring#stopService",`Can't destroy service: unable to find service with name '${e}'`,"sap.ui.rta")}};te.prototype.getService=function(e){return this.startService(e)};return te});
//# sourceMappingURL=RuntimeAuthoring.js.map