/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/core/BusyIndicator","sap/ui/core/EventBus","sap/ui/core/Lib","sap/base/util/uid","sap/base/Log","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/write/api/AppVariantWriteAPI","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/_internal/connectors/LrepConnector"],function(e,t,n,r,a,i,s,o,u,p,c,l){"use strict";var g={};var d=56;g._newAppVariantId=null;g.getManifirstSupport=function(e){return l.appVariant.getManifirstSupport({appId:e})};g.getNewAppVariantId=function(){return g._newAppVariantId};g.setNewAppVariantId=function(e){g._newAppVariantId=e};g.trimIdIfRequired=function(e){if(e.length>d){var t=e.split(".");var n;var r=t[t.length-1].length;var a=t.pop();n=t.join(".");if(n.length>r){n=n.substring(0,n.length-r)}else{return e.substr(0,d)}if(n[n.length-1]==="."){n=n+a}else{n=`${n}.${a}`}return this.trimIdIfRequired(n)}return e};g.getId=function(e){var t;var n=e.split(".");if(n[0]!=="customer"){n[0]=`customer.${n[0]}`}var r=false;var a=/^id.*/i;n.forEach(function(e,t,n){if(e.match(a)){e=e.replace(a,s().replace(/-/g,"_"));n[t]=e;r=true}});t=n.join(".");if(!r){t=`${t}.${s().replace(/-/g,"_")}`}t=this.trimIdIfRequired(t);this.setNewAppVariantId(t);return t};g.createAppVariant=function(e,t){t.version="1.0.0";return p.saveAs(Object.assign({selector:e},t))};g.getInlineChangeInput=function(e,t){return{type:"XTIT",maxLength:50,comment:t,value:{"":e}}};g.prepareTextsChange=function(e,t){var n=`New ${e} entered by a key user via RTA tool`;return this.getInlineChangeInput(t,n)};g.getInlineChangeInputIcon=function(e){return{content:{icon:e}}};g.prepareRemoveAllInboundsExceptOneChange=function(e){return{content:{inboundId:e}}};g.getInboundInfo=function(t){var n={};if(!t){n.currentRunningInbound="customer.savedAsAppVariant";n.addNewInboundRequired=true;return Promise.resolve(n)}return e.getUShellService("URLParsing").then(function(t){return e.getParsedURLHash(t)}).then(function(e){var r=Object.keys(t);var a=[];if(r.length===1&&r[0]==="customer.savedAsAppVariant"){return{currentRunningInbound:"customer.savedAsAppVariant",addNewInboundRequired:false}}r.forEach(function(n){if(t[n].action===e.action&&t[n].semanticObject===e.semanticObject){a.push(n)}});switch(a.length){case 0:n.currentRunningInbound="customer.savedAsAppVariant";n.addNewInboundRequired=true;break;case 1:[n.currentRunningInbound]=a;n.addNewInboundRequired=false;break;default:n.currentRunningInbound="customer.savedAsAppVariant";n.addNewInboundRequired=true;break}return n})};g.getInboundPropertiesKey=function(e,t,n){return`${e}_sap.app.crossNavigation.inbounds.${t}.${n}`};g.getInlineChangeForInboundPropertySaveAs=function(e,t){return{inboundId:e,entityPropertyChange:{propertyPath:"signature/parameters/sap-appvar-id",operation:"UPSERT",propertyValue:{required:true,filter:{value:t,format:"plain"},launcherValue:{value:t}}}}};g.prepareAddNewInboundChange=function(t,n,r){return e.getUShellService("URLParsing").then(function(t){return e.getParsedURLHash(t)}).then(function(e){var a={content:{inbound:{}},texts:{}};var i=this.getInboundPropertiesKey(r.referenceAppId,t,"title");var s=this.getInboundPropertiesKey(r.referenceAppId,t,"subTitle");a.content.inbound[t]={semanticObject:e.semanticObject,action:e.action,title:`{{${i}}}`,subTitle:`{{${s}}}`,icon:r.icon,signature:{parameters:{"sap-appvar-id":{required:true,filter:{value:n,format:"plain"},launcherValue:{value:n}}},additionalParameters:"ignored"}};a.texts[i]=this.prepareTextsChange("title",r.title);a.texts[s]=this.prepareTextsChange("subTitle",r.subTitle);return a}.bind(this))};g.prepareChangeInboundChange=function(e,t,n){var r={content:{},texts:{}};var a=this.getInboundPropertiesKey(n.referenceAppId,e,"title");var i=this.getInboundPropertiesKey(n.referenceAppId,e,"subTitle");r.content={inboundId:e,entityPropertyChange:[{propertyPath:"signature/parameters/sap-appvar-id",operation:"UPSERT",propertyValue:{required:true,filter:{value:t,format:"plain"},launcherValue:{value:t}}},{propertyPath:"title",operation:"UPSERT",propertyValue:`{{${a}}}`},{propertyPath:"subTitle",operation:"UPSERT",propertyValue:`{{${i}}}`},{propertyPath:"icon",operation:"UPSERT",propertyValue:n.icon}]};r.texts[a]=this.prepareTextsChange("title",n.title);r.texts[i]=this.prepareTextsChange("subTitle",n.subTitle);return r};g.createInlineChange=function(e,t,n){var r={changeType:t,content:e.content};if(e.texts){r.texts=e.texts}return c.create({changeSpecificData:r,selector:n})};g.addChangesToPersistence=function(e,t){u.add({flexObjects:e,selector:t});return Promise.resolve()};g.getTransportInput=function(e,t,n,r){return{getPackage(){return e},getNamespace(){return t},getId(){return n},getDefinition(){return{fileType:r}}}};g.triggerCatalogAssignment=function(e,t,n){return p.assignCatalogs({selector:{appId:e},action:"assignCatalogs",assignFromAppId:n,layer:t})};g.triggerCatalogUnAssignment=function(e,t){return p.unassignCatalogs({selector:{appId:e},action:"unassignCatalogs",layer:t})};g.isS4HanaCloud=function(e){return e.isAtoEnabled()&&e.isAtoAvailable()};g.copyId=function(e){var t=document.createElement("textarea");t.value=e;document.body.appendChild(t);t.select();document.execCommand("copy");document.body.removeChild(t);return true};g.getTextResources=function(){return i.getResourceBundleFor("sap.ui.rta")};g.getText=function(e,t){var n=this.getTextResources();return t?n.getText(e,[t]):n.getText(e)};g._getErrorMessageText=function(e){var t;if(e.messages&&e.messages.length){t=e.messages.map(function(e){return e.text}).join("\n")}else if(e.userMessage){t=e.userMessage}else if(e.iamAppId){t=`IAM App Id: ${e.iamAppId}`}else{t=e.stack||e.message||e.status||e}return t};g.buildErrorInfo=function(e,t,n){var r=this._getErrorMessageText(t);var a=`${g.getText(e)}\n\n`;if(n){a+=`${g.getText("MSG_APP_VARIANT_ID",n)}\n`}a+=g.getText("MSG_TECHNICAL_ERROR",r);o.error("App variant error: ",r);return{text:a,appVariantId:n,error:true}};g.buildSuccessInfo=function(e,t,n){var r=n?"CLOUD":"ON_PREMISE";var a=t?"":"_OVERVIEW_LIST";var i=n?undefined:e;var s=`${g.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE")}\n\n`;s+=g.getText(`SAVE_APP_VARIANT_SUCCESS_S4HANA_${r}_MESSAGE${a}`,i);return{text:s,appVariantId:e,copyId:!n}};g.buildFinalSuccessInfoS4HANACloud=function(){var e=g.getText("MSG_SAVE_APP_VARIANT_NEW_TILE_AVAILABLE");return{text:e}};g.buildDeleteSuccessMessage=function(e,t){var n=t?"DELETE_APP_VARIANT_SUCCESS_MESSAGE_CLOUD":"DELETE_APP_VARIANT_SUCCESS_MESSAGE";var r=g.getText(n,e);return{text:r}};g.showRelevantDialog=function(e,a){r.hide();var i;var s;var o;var u;var p=[];if(a){i=this.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE_TITLE");s=this.getText("SAVE_APP_VARIANT_OK_TEXT")}else{i=this.getText("HEADER_SAVE_APP_VARIANT_FAILED");s=this.getText("SAVE_APP_VARIANT_CLOSE_TEXT")}if(e&&e.copyId){u=this.getText("SAVE_APP_VARIANT_COPY_ID_TEXT");p.push(u)}else if(e&&e.deleteAppVariant){i=this.getText("DELETE_APP_VARIANT_INFO_MESSAGE_TITLE");o=this.getText("DELETE_APP_VARIANT_OK_TEXT");p.push(o);s=this.getText("DELETE_APP_VARIANT_CLOSE_TEXT")}p.push(s);return new Promise(function(r,c){var l=function(t){if(t===u){g.copyId(e.appVariantId)}if(a){r()}else if(e.overviewDialog){r(false)}else if(e.deleteAppVariant&&t===o){r()}else if(e.deleteAppVariant&&t===s){c(e.deleteAppVariant)}else if(e.error){c(e.error)}else{r()}};t.show(e.text,{icon:a||e.deleteAppVariant?t.Icon.INFORMATION:t.Icon.ERROR,onClose:l,title:i,actions:p,styleClass:n.getRtaStyleClassName()})})};g.closeOverviewDialog=function(){a.getInstance().publish("sap.ui.rta.appVariant.manageApps.controller.ManageApps","navigate")};g.navigateToFLPHomepage=function(){var t=e.getUshellContainer();var n;if(t){return t.getServiceAsync("AppLifeCycle").then(function(e){var r=e.getCurrentApplication();n=r.componentInstance;if(n){return t.getServiceAsync("CrossApplicationNavigation")}return undefined}).then(function(e){if(e&&e.toExternal){e.toExternal({target:{shellHash:"#"}},n)}}).catch(function(e){throw new Error(`Error navigating to FLP Homepage: ${e}`)})}return Promise.resolve()};g.deleteAppVariant=function(e,t){r.hide();return p.deleteAppVariant({selector:e,layer:t})};g.handleBeforeUnloadEvent=function(){return g.getText("MSG_DO_NOT_CLOSE_BROWSER")};g.showMessage=function(e){var t=g.getText(e);var n={text:t,copyId:false};return g.showRelevantDialog(n,true)};g.catchErrorDialog=function(e,t,n){r.hide();var a=g.buildErrorInfo(t,e,n);return g.showRelevantDialog(a,false)};return g},true);
//# sourceMappingURL=AppVariantUtils.js.map