/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/UIComponent","sap/ui/core/ComponentContainer","sap/ui/core/Core","sap/ui/core/mvc/XMLView","sap/ui/rta/command/CommandFactory","sap/ui/rta/util/changeVisualization/ChangeCategories","sap/ui/rta/util/changeVisualization/ChangeVisualization","sap/ui/dt/DesignTime","sap/ui/dt/DesignTimeStatus","sap/ui/dt/OverlayRegistry","sap/ui/fl/ChangePersistence","sap/ui/model/Model","sap/ui/fl/registry/Settings","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Layer","sap/ui/thirdparty/sinon-4","sap/ui/fl/library"],function(e,t,n,i,o,a,r,s,c,h,u,d,l,m,f,g){"use strict";function p(v,C){if(p._only&&v.indexOf(p._only)<0){return}if(typeof C.xmlView==="string"){C.xmlView={viewContent:C.xmlView}}var y=g.createSandbox();C.before||=function(){};C.after||=function(){};QUnit.module(v,function(){QUnit.test("When using the 'elementActionTest' function to test if your control is ready for UI adaptation at runtime",function(e){e.ok(C.afterAction,"then you implement a function to check if your action has been successful: See the afterAction parameter.");e.ok(C.afterUndo,"then you implement a function to check if the undo has been successful: See the afterUndo parameter.");e.ok(C.afterRedo,"then you implement a function to check if the redo has been successful: See the afterRedo parameter.");e.ok(C.xmlView,"then you provide an XML view to test on: See the.xmlView parameter.");var t=(new DOMParser).parseFromString(C.xmlView.viewContent,"application/xml").documentElement;e.ok(t.tagName.match("View$"),"then you use the sap.ui.core.mvc View tag as the first tag in your view");e.ok(C.action,"then you provide an action: See the action parameter.");e.ok(C.action.name,"then you provide an action name: See the action.name parameter.");e.ok(C.action.controlId||C.action.control,"then you provide the control or control's id to operate the action on: See the action.controlId.")})});var b="sap.ui.rta.control.enabling.comp";var w=false;var V=true;var A=e.extend(b,{metadata:{interfaces:["sap.ui.core.IAsyncContentCreation"],manifest:{"sap.app":{id:b,type:"application"}}},createContent(){var e=Object.assign({},C.xmlView);e.id=this.createId("view");if(e.async===undefined){e.async=this.getComponentData().async}e.definition=e.viewContent;this.oViewPromise=i.create(e);return this.oViewPromise}});function I(e){this.oUiComponent=new A({id:"comp",componentData:{async:e}});return this.oUiComponent.oViewPromise.then(function(){this.oUiComponentContainer=new t({component:this.oUiComponent,height:"100%"});this.oUiComponentContainer.placeAt(C.placeAt||"qunit-fixture");this.oView=this.oUiComponent.getRootControl();if(C.model instanceof d){this.oView.setModel(C.model)}n.applyChanges();return C.model&&C.model.getMetaModel()&&C.model.getMetaModel().loaded()}.bind(this))}function x(e){var t=[].concat(C.previousActions||[],C.action);var n=[];return t.reduce(function(t,i){return t.then(M.bind(this,e,i)).then(function(e){n.push(e);return e.execute()})}.bind(this),Promise.resolve()).then(function(){return n})}function U(e){if(typeof e.control==="function"){return e.control(this.oView)}return this.oView.byId(e.controlId)}function P(e){return e.designtimeActionControl?e.designtimeActionControl(this.oView):undefined}function E(){this.oDesignTime=new s({rootElements:[this.oView]});return new Promise(function(e){this.oDesignTime.attachEventOnce("synced",e)}.bind(this))}function k(e){if(e){return typeof e==="function"?e(this.oView):e}return{}}function D(e,t,n,i,o,a){if(Array.isArray(t.name)){var r=o.getAction(t.name[0],n,t.name[1]);e.ok(r,`the ${t[0]} via ${t.name[1]} action is available in the designtime`)}else if(t.name==="createContainer"||t.name==="addIFrame"){e.ok(a.getAction(t.name,n),`the ${t.name}action is available in the calculated designtime metadata during execution`)}else if(t.name==="move"){e.ok(o.getAction(t.name,i),`the ${t.name}action is available in the calculated designtime metadata during execution`)}else{e.ok(o.getAction(t.name,n),`the ${t.name}action is available in the calculated designtime metadata during execution`)}}function M(e,t){var n;var i;var a;var r;var s;var c=t.name;var u;return Promise.resolve().then(U.bind(this,t)).then(function(e){n=e;a=k.call(this,t.parameter);return P.call(this,t)}.bind(this)).then(function(e){i=e;return E.call(this)}.bind(this)).then(function(){var o=h.getOverlay(i||n);if(!o){throw new Error(`The provided control ${n.getId()}does not have any overlay existing during test execution. `+`With this testsetup it is no possible to check for designtime action definition. In some cases it is not `+`possible to identify the control with the designtime metadata automatically just by the given 'action.control'. `+`In this case please provide the 'action.designtimeActionControl' property with a valid control containing `+`the designtime metadata definition for this check.`)}r=o.getDesignTimeMetadata();var d=r.getResponsibleElement(n);var l;if(C.label){e.strictEqual(r.getLabel(n),C.label,"then the control label is correct")}if(t.name==="move"){u=a.movedElements[0].element||a.movedElements[0].id;var m=h.getOverlay(u);var f=m.getRelevantContainer();n=f;r=m.getParentAggregationOverlay().getDesignTimeMetadata()}else if(Array.isArray(t.name)){var g=r.getActionDataFromAggregations(t.name[0],n,undefined,t.name[1]);l=o.getAggregationOverlay(g[0].aggregation);r=l.getDesignTimeMetadata();c="addDelegateProperty"}else if(t.name==="createContainer"||t.name==="addIFrame"){var p=r.getActionDataFromAggregations(t.name,i||n);l=o.getAggregationOverlay(p[0].aggregation);s=l.getDesignTimeMetadata()}else if(d){if(t.name==="reveal"){n=t.revealedElement(this.oView);o=h.getOverlay(t.revealedElement(this.oView));r=o.getDesignTimeMetadata();if(t.label){var v=r.getAction("reveal");e.strictEqual(v.getLabel(n),t.label,"then the control label is correct")}}else{n=d;o=h.getOverlay(n);r=o.getDesignTimeMetadata();n.getMetadata().loadDesignTime(n)}}}.bind(this)).then(function(){return D.call(this,e,t,n,u,r,s)}.bind(this)).then(function(){var e=new o({flexSettings:{layer:C.layer||f.CUSTOMER}});return e.getCommandFor(n,c,a,r)}).then(function(t){e.ok(t,`then the registration for action to change type, the registration for change and `+`control type to change handler is available and ${C.action.name} is a valid action`);return t}).catch(function(e){throw new Error(e)})}function S(e){return e.reduce(function(e,t){return e.then(t.execute.bind(t))},Promise.resolve())}function T(e){var t=e.slice().reverse();return t.reduce(function(e,t){return e.then(t.undo.bind(t))},Promise.resolve())}function R(e){e.forEach(function(e){e.destroy()})}function O(e,t,n){var i={remainingCommands:[],deletedCommands:[]};if(t.length===1){i.remainingCommands.push(t[0]);return Promise.resolve(i)}var o=t.map(function(e){return e.getPreparedChange()});return m._condense({selector:e,changes:o}).then(function(e){if(C.changesAfterCondensing!==undefined){n.equal(e.length,C.changesAfterCondensing,"after condensing the amount of changes is correct")}var o=e.map(function(e){return e.getId()});t.forEach(function(e){if(o.indexOf(e.getPreparedChange().getId())>-1){i.remainingCommands.push(e)}else{i.deletedCommands.push(e)}});return i})}function z(e,t,n){if(!C.changeVisualization){return Promise.resolve()}var i;if(typeof C.changeVisualization==="function"){i=C.changeVisualization(e)}else{i=C.changeVisualization}var o=new r({rootControlId:e.getId(),isActive:true});y.stub(o,"_updateChangeIndicators");var s=t.map(function(e){return e.getPreparedChange()});y.stub(o,"_collectChanges").resolves(s);return o._updateChangeRegistry().then(function(){return o._selectChangeCategory(a.ALL)}).then(function(){var t=o._oChangeIndicatorRegistry;var a=t.getSelectorsWithRegisteredChanges();var r=i.displayElementId;var s=r?e.createId(r):e.getId();n.ok(a[s]&&a[s].length,"there is a change indicator at the correct element");var c=t.getAllRegisteredChanges()[0];var h=i.info;function u(t){return t.map(function(t){return e.createId(t)})}if(h){if(h.affectedControls){var d=u(h.affectedControls);n.deepEqual(d,c.visualizationInfo.affectedElementIds,"then the affected control ids are correct")}if(h.dependentControls){var l=u(h.dependentControls);n.deepEqual(l,c.visualizationInfo.dependentElementIds,"then the dependent control ids are correct")}if(h.displayControls){var m=u(h.displayControls);n.deepEqual(m,c.visualizationInfo.displayElementIds,"then the display control ids are correct")}if(h.descriptionPayload){n.deepEqual(h.descriptionPayload,c.visualizationInfo.descriptionPayload,"then the descriptionPayload is correct")}}})}function _(e){var t=[];e.forEach(function(e){var n=e.getPreparedChange();if(e.getAppComponent){t.push(m.remove({change:n,selector:e.getAppComponent()}))}});return Promise.all(t)}function L(e){var t=[];y.stub(u.prototype,"getChangesForView").resolves(t);return I.call(this,w).then(Q.bind(this,e,t))}function Q(e,t){var n=[].concat(C.previousActions||[],C.action);var i=[];return n.reduce(function(n,o){return n.then(M.bind(this,e,o)).then(function(e){i.push(e);t.push(e.getPreparedChange());this.oUiComponentContainer.destroy();return I.call(this,V)}.bind(this))}.bind(this),Promise.resolve()).then(function(){this.aCommands=i}.bind(this))}if(!C.jsOnly){QUnit.module(`${v} on async views`,{before(e){this.hookContext={};return C.before.call(this.hookContext,e)},after(e){return C.after.call(this.hookContext,e)},beforeEach(){y.stub(l,"getInstance").resolves({_oSettings:{}})},afterEach(){this.oUiComponentContainer.destroy();this.oDesignTime.destroy();R(this.aCommands);y.restore()}},function(){QUnit.test("When applying the change directly on the XMLView",function(e){return L.call(this,e).then(function(){return z(this.oView,this.aCommands,e)}.bind(this)).then(function(){return C.afterAction(this.oUiComponent,this.oView,e)}.bind(this))});QUnit.test("When executing on XML and reverting the change in JS (e.g. variant switch)",function(e){return L.call(this,e).then(function(){return T(this.aCommands)}.bind(this)).then(function(){return _(this.aCommands)}.bind(this)).then(function(){n.applyChanges();C.afterUndo(this.oUiComponent,this.oView,e)}.bind(this))});QUnit.test("When executing on XML, reverting the change in JS (e.g. variant switch) and applying again",function(e){return L.call(this,e).then(function(){return O(this.oView,this.aCommands,e)}.bind(this)).then(function(e){this.aRemainingCommands=e.remainingCommands;return T(this.aCommands)}.bind(this)).then(function(){return _(this.aCommands)}.bind(this)).then(function(){return S(this.aRemainingCommands)}.bind(this)).then(function(){n.applyChanges();C.afterRedo(this.oUiComponent,this.oView,e)}.bind(this))})})}function W(e){if(e.getStatus()!==c.SYNCED){return new Promise(function(t){e.attachEventOnce("synced",t)})}return Promise.resolve()}QUnit.module(v,{before(e){this.hookContext={};return C.before.call(this.hookContext,e)},after(e){return C.after.call(this.hookContext,e)},beforeEach(e){y.stub(u.prototype,"getChangesForComponent").returns(Promise.resolve([]));y.stub(l,"getInstance").returns(Promise.resolve({_oSettings:{}}));return I.call(this,w).then(x.bind(this,e)).then(function(e){this.aCommands=e}.bind(this))},afterEach(){this.oDesignTime.destroy();this.oUiComponentContainer.destroy();R(this.aCommands);y.restore()}},function(){QUnit.test("When executing the underlying command on the control at runtime",function(e){return W(this.oDesignTime).then(function(){return z(this.oView,this.aCommands,e)}.bind(this)).then(function(){n.applyChanges();return C.afterAction(this.oUiComponent,this.oView,e)}.bind(this))});QUnit.test("When executing and undoing the command",function(e){return W(this.oDesignTime).then(T.bind(null,this.aCommands)).then(_.bind(null,this.aCommands)).then(function(){n.applyChanges();return C.afterUndo(this.oUiComponent,this.oView,e)}.bind(this))});QUnit.test("When executing, undoing and redoing the command",function(e){return W(this.oDesignTime).then(O.bind(this,this.oView,this.aCommands,e)).then(function(e){this.aRemainingCommands=e.remainingCommands;return T(this.aCommands)}.bind(this)).then(_.bind(null,this.aCommands)).then(function(){return S(this.aRemainingCommands)}.bind(this)).then(function(){n.applyChanges();return C.afterRedo(this.oUiComponent,this.oView,e)}.bind(this))})})}p.skip=function(){};p.only=function(e){p._only=e};return p});
//# sourceMappingURL=elementActionTest.js.map