//@ui5-bundle sap/ui/rta/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/Client", ["sap/ui/base/ManagedObject","sap/ui/core/postmessage/Bus","sap/ui/core/Lib","sap/base/util/uid","sap/base/util/merge","sap/ui/rta/util/ServiceEventBus","sap/ui/thirdparty/URI"],function(e,t,s,i,r,n,a){"use strict";var o="sap.ui.rta.service.receiver";var u="pending";var h="accepted";var c="declined";var d=e.extend("sap.ui.rta.Client",{metadata:{library:"sap.ui.rta",properties:{window:"object",origin:"string"}},_bInit:false,constructor:function(...i){e.apply(this,i);if(!this.getWindow()){throw new TypeError("sap.ui.rta.Client: window parameter is required")}if(!this.getOrigin()){throw new TypeError("sap.ui.rta.Client: origin parameter is required")}this._oPostMessageBus=t.getInstance();this._sStatus=u;this._mPendingRequests={};this._aRequestQueue=[];this._oServiceEventBus=null;this._mEventHandlerIds={};this._oPostMessageBus.subscribeOnce(o,t.event.READY,function(e){if(!this._isValidMessage(e)){return}this._oPostMessageBus.subscribeOnce(o,t.event.ACCEPTED,function(e){if(!this._isValidMessage(e)){return}this._sStatus=h;var t=this._aRequestQueue.slice();this._aRequestQueue=[];t.forEach(this._sendRequest,this);this._oPostMessageBus.subscribe(o,"getService",this._receiverMethods,this);this._oPostMessageBus.subscribe(o,"callMethod",this._receiverMethods,this);this._oPostMessageBus.subscribe(o,"subscribe",this._receiverMethods,this);this._oPostMessageBus.subscribe(o,"unsubscribe",this._receiverMethods,this);this._oPostMessageBus.subscribe(o,"event",this._receiverEvents,this)},this);this._oPostMessageBus.subscribeOnce(o,t.event.DECLINED,function(e){if(!this._isValidMessage(e)){return}this._sStatus=c;var t=this._aRequestQueue.slice();this._aRequestQueue=[];t.forEach(function(e){e.reject(new Error("sap.ui.rta.Client.getService(): connection to RuntimeAuthoring instance has been refused"))})},this);this._oPostMessageBus.publish({target:this.getWindow(),origin:this.getOrigin(),channelId:o,eventId:t.event.CONNECT,data:s.getResourceBundleFor("sap.ui.rta").getText("SERVICE_NAME")})},this);this._bInit=true}});d.prototype.destroy=function(...t){this._oPostMessageBus.unsubscribe(o,"getService",this._receiverMethods,this);this._oPostMessageBus.unsubscribe(o,"callMethod",this._receiverMethods,this);this._oPostMessageBus.unsubscribe(o,"subscribe",this._receiverMethods,this);this._oPostMessageBus.unsubscribe(o,"unsubscribe",this._receiverMethods,this);this._oPostMessageBus.unsubscribe(o,"event",this._receiverEvents,this);e.prototype.destroy.apply(this,t)};d.prototype.getService=function(e){if(typeof e!=="string"){throw new TypeError("sap.ui.rta.Client.getService(): invalid service name specified")}return this._sendRequest(this._createRequest({target:this.getWindow(),origin:this.getOrigin(),channelId:o,eventId:"getService",data:{arguments:[e]}}))};d.prototype._createRequest=function(e){var t=i();var s={id:t,request:{target:e.target,origin:e.origin,channelId:o,eventId:e.eventId,data:{id:t,type:"request",body:e.data}}};s.promise=new Promise(function(e,t){s.resolve=e;s.reject=t});return s};d.prototype._sendRequest=function(e){switch(this._sStatus){case h:this._mPendingRequests[e.id]=e;this._oPostMessageBus.publish(e.request);break;case u:this._aRequestQueue.push(e);break;case c:e.reject(new Error("sap.ui.rta.Client.getService(): connection to RuntimeAuthoring instance has been refused"));break;default:}return e.promise};d.prototype._isValidMessage=function(e){return this.getWindow()===e.source&&this.getOrigin()===e.origin};d.prototype._receiverMethods=function(e){if(!this._isValidMessage(e)){return}var t=e.data;if(t.type!=="response"){return}var s=this._mPendingRequests[t.id];switch(e.eventId){case"getService":var i=s.request.data.body.arguments[0];var a=t.body.methods||[];var u=t.body.events;var h=r(a.reduce(function(t,s){t[s]=function(...t){return this._sendRequest(this._createRequest({target:e.source,origin:e.origin,channelId:o,eventId:"callMethod",data:{service:i,method:s,arguments:t}}))}.bind(this);return t}.bind(this),{}),t.body.properties);if(Array.isArray(u)&&u.length>0){this._oServiceEventBus||=new n;r(h,{attachEvent:function(t,s,r){if(typeof t!=="string"||!t){throw new TypeError("sap.ui.rta.Client: sEventName must be a non-empty string when calling attachEvent() for a service")}if(typeof s!=="function"){throw new TypeError("sap.ui.rta.Client: fnFunction must be a function when calling attachEvent() for a service")}var n=this._oServiceEventBus.getChannel(i);var a=!n||!n.hasListeners(t);this._oServiceEventBus.subscribe(i,t,s,r);if(a){this._sendRequest(this._createRequest({target:e.source,origin:e.origin,channelId:o,eventId:"subscribe",data:{service:i,event:t}})).then(function(e){this._mEventHandlerIds[`${i},${t}`]=e.id;this._checkIfEventAlive(i,t)}.bind(this))}}.bind(this),detachEvent:function(e,t,s){if(typeof e!=="string"||!e){throw new TypeError("sap.ui.rta.Client: sEventName must be a non-empty string when calling detachEvent() for a service")}if(typeof t!=="function"){throw new TypeError("sap.ui.rta.Client: fnFunction must be a function when calling detachEvent() for a service")}this._oServiceEventBus.unsubscribe(i,e,t,s);this._checkIfEventAlive(i,e)}.bind(this),attachEventOnce(e,t,s){function i(...r){h.detachEvent(e,i);t.apply(s,r)}h.attachEvent(e,i)}})}s.resolve(h);delete this._mPendingRequests[t.id];break;case"callMethod":if(t.status==="success"){s.resolve(t.body)}else{s.reject(t.body)}delete this._mPendingRequests[t.id];break;case"subscribe":case"unsubscribe":s.resolve(t.body);delete this._mPendingRequests[t.id];break;default:}};d.prototype._checkIfEventAlive=function(e,t){var s=this._oServiceEventBus.getChannel(e);var i=this._mEventHandlerIds[`${e},${t}`];if((!s||!s.hasListeners(t))&&i){this._sendRequest(this._createRequest({target:this.getWindow(),origin:this.getOrigin(),channelId:o,eventId:"unsubscribe",data:{service:e,event:t,id:i}}))}};d.prototype._receiverEvents=function(e){if(!this._isValidMessage(e)){return}var t=e.data.body;this._oServiceEventBus.publish(t.service,t.event,t.data)};d.prototype.setWindow=function(e){if(this._bInit){throw new TypeError("sap.ui.rta.Client: Window parameter cannot be changed at runtime; recreate instance of the Client.")}if(!e){throw new TypeError("sap.ui.rta.Client: Window parameter is required")}if(e===window){throw new TypeError("sap.ui.rta.Client: Window object has to be different from the one where Client is running")}this.setProperty("window",e);return this};d.prototype.setOrigin=function(e){if(this._bInit){throw new TypeError("sap.ui.rta.Client: Cannot change origin parameter at runtime; recreate instance of the Client.")}if(!e){throw new TypeError("sap.ui.rta.Client: Origin parameter is required")}if(typeof e!=="string"){throw new TypeError("sap.ui.rta.Client: Origin parameter has to be a string")}if(new a(e).origin()!==e){throw new TypeError("sap.ui.rta.Client: Origin string is invalid")}this.setProperty("origin",e);return this};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/RuntimeAuthoring", ["sap/base/strings/capitalize","sap/base/util/isPlainObject","sap/base/Log","sap/m/MessageBox","sap/m/MessageToast","sap/ui/base/ManagedObject","sap/ui/core/BusyIndicator","sap/ui/core/Lib","sap/ui/dt/DesignTime","sap/ui/dt/DOMUtil","sap/ui/dt/ElementUtil","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/events/KeyCodes","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/initial/api/Version","sap/ui/fl/registry/Settings","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/fl/write/api/ControlPersonalizationWriteAPI","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/write/api/ReloadInfoAPI","sap/ui/fl/write/api/TranslationAPI","sap/ui/fl/write/api/VersionsAPI","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/model/json/JSONModel","sap/ui/performance/Measurement","sap/ui/rta/appVariant/Feature","sap/ui/rta/command/BaseCommand","sap/ui/rta/command/LREPSerializer","sap/ui/rta/command/Stack","sap/ui/rta/service/index","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/FioriLike","sap/ui/rta/toolbar/Personalization","sap/ui/rta/toolbar/Standalone","sap/ui/rta/util/changeVisualization/ChangeVisualization","sap/ui/rta/util/PluginManager","sap/ui/rta/util/PopupManager","sap/ui/rta/util/ReloadManager","sap/ui/rta/util/ServiceEventBus","sap/ui/rta/util/validateFlexEnabled","sap/ui/rta/Utils","sap/ui/thirdparty/jquery","sap/ui/Device"],function(e,t,i,n,a,o,r,s,l,d,h,c,u,g,p,f,v,m,S,b,y,C,_,A,R,E,P,T,M,I,D,w,O,L,V,x,N,B,U,k,F,G,z,K,j,H,$,jQuery,W){"use strict";var q="STARTING";var Y="STARTED";var Z="STOPPED";var J="FAILED";var Q="SERVICE_STARTING";var X="SERVICE_STARTED";var ee="SERVICE_FAILED";var te=o.extend("sap.ui.rta.RuntimeAuthoring",{metadata:{library:"sap.ui.rta",associations:{rootControl:{type:"sap.ui.base.ManagedObject"}},properties:{showToolbars:{type:"boolean",defaultValue:true},triggeredFromDialog:{type:"boolean",defaultValue:false},showWindowUnloadDialog:{type:"boolean",defaultValue:true},commandStack:{type:"any"},flexSettings:{type:"object",defaultValue:{layer:T.CUSTOMER,developerMode:true}},mode:{type:"string",defaultValue:"adaptation"},metadataScope:{type:"string",defaultValue:"default"}},events:{start:{parameters:{editablePluginsCount:{type:"int"}}},stop:{},failed:{parameters:{error:{type:"any"}}},selectionChange:{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},modeChanged:{},undoRedoStackModified:{}}},_sAppTitle:null,_dependents:null,_sStatus:Z,_bNavigationModeWarningShown:false,constructor:function(...e){o.apply(this,e);this._dependents={};this._mServices={};this._mUShellServices={};this._pElementModified=Promise.resolve();this.addDependent(new G,"pluginManager");this.addDependent(new z,"popupManager");if(this.getShowToolbars()){this.getPopupManager().attachOpen(ae,this);this.getPopupManager().attachClose(oe,this);this.addDependent(new F,"changeVisualization")}if(window.parent!==window){this.startService("receiver")}this.startService("supportTools");this._loadUShellServicesPromise=M.getUShellServices(["URLParsing","AppLifeCycle","CrossApplicationNavigation"]).then(function(e){this._mUShellServices=e;K.setUShellServices(e)}.bind(this))}});te.needsRestart=function(e){return K.needsAutomaticStart(e)};te.enableRestart=function(e,t){K.enableAutomaticStart(e,t)};te.disableRestart=function(e){K.disableAutomaticStart(e)};te.willRTAStartAfterReload=function(e){return K.needsAutomaticStart(e||T.CUSTOMER)};te.prototype.addDependent=function(t,i,n){n=typeof n==="undefined"?true:!!n;if(!(i in this._dependents)){if(i&&n){this[`get${e(i,0)}`]=this.getDependent.bind(this,i)}this._dependents[i||t.getId()]=t}else{throw g.createError("RuntimeAuthoring#addDependent",`Can't add dependency with same key '${i}'`,"sap.ui.rta")}};te.prototype.getDependent=function(e){return this._dependents[e]};te.prototype.getDependents=function(){return this._dependents};te.prototype.removeDependent=function(e){delete this._dependents[e]};te.prototype.setPlugins=function(e){if(this._sStatus!==Z){throw new Error("Cannot replace plugins: runtime authoring already started")}this.getPluginManager().setPlugins(e)};te.prototype.getPlugins=function(){return this.getPluginManager&&this.getPluginManager()&&this.getPluginManager().getPlugins()};te.prototype.getDefaultPlugins=function(){return this.getPluginManager().getDefaultPlugins(this.getFlexSettings())};te.prototype.setFlexSettings=function(e){var t=new URLSearchParams(window.location.search);var i=t.get("sap-ui-layer");e=Object.assign({},this.getFlexSettings(),e);if(i){e.layer=i.toUpperCase()}if(e.scenario||e.baseId){var n=M.buildLrepRootNamespace(e.baseId,e.scenario,e.projectId);e.rootNamespace=n;e.namespace=`${n}changes/`}$.setRtaStyleClassName(e.layer);this.setProperty("flexSettings",e)};te.prototype.getLayer=function(){return this.getFlexSettings().layer};te.prototype.getRootControlInstance=function(){this._oRootControl||=h.getElementInstance(this.getRootControl());return this._oRootControl};te.prototype._getTextResources=function(){return s.getResourceBundleFor("sap.ui.rta")};te.prototype.start=function(){var e=te.needsRestart(this.getLayer());var t;var n;if(this._sStatus===Z){this._sStatus=q;var a=this.getRootControlInstance();if(!a){n=new Error("Root control not found");i.error(n);return Promise.reject(n)}return this._loadUShellServicesPromise.then(Le.bind(this)).then(Ve.bind(this,e)).then(function(){return K.handleReloadOnStart({layer:this.getLayer(),selector:this.getRootControlInstance(),versioningEnabled:this._oVersionsModel.getProperty("/versioningEnabled"),developerMode:this.getFlexSettings().developerMode,adaptationId:this._oContextBasedAdaptationsModel.getProperty("/displayedAdaptation/id")})}.bind(this)).then(function(e){if(e){return Promise.reject("Reload triggered")}var i=A.getResetAndPublishInfoFromSession(this.getRootControlInstance());this.bInitialResetEnabled=!!i.isResetEnabled;this._oSerializer=new L({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});this.getPluginManager().preparePlugins(this.getFlexSettings(),Fe.bind(this),this.getCommandStack());var n=this.getPluginManager().getPluginList();t=new Promise(function(e,t){D.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new l({scope:this.getMetadataScope(),plugins:n});le(this.getRootControlInstance(),true);this._oDesignTime.addRootElement(this._oRootControl);c.getOverlayContainer().get(0).classList.add("sapUiRta");if(this.getLayer()===T.USER){c.getOverlayContainer().get(0).classList.add("sapUiRtaPersonalize")}else{document.body.classList.add("sapUiRtaMode")}this._oDesignTime.getSelectionManager().attachChange(function(e){this.fireSelectionChange({selection:e.getParameter("selection")})},this);this._oDesignTime.attachEventOnce("synced",function(){e();D.end("rta.dt.startup","Measurement of RTA: DesignTime start up")},this);this._oDesignTime.attachEventOnce("syncFailed",function(e){t(e.getParameter("error"))})}.bind(this));this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);return undefined}.bind(this)).then(function(){if(this.getShowToolbars()){return he(this.getRootControlInstance(),this.getLayer(),this._oSerializer).then(xe.bind(this))}return undefined}.bind(this)).then(ue.bind(this)).then(function(){c.getOverlayContainer().get(0).style.setProperty("--sap-ui-rta-scrollbar-scrollWidth",`${d.getScrollbarWidth()}px`);c.getOverlayContainer().get(0).style.setProperty("--sap-ui-rta-scrollbar-scrollWidthPlusTwo",`${d.getScrollbarWidth()+2}px`);return t}).then(function(){this.getPopupManager().setRta(this);if(this.getShowToolbars()){return this.getToolbar().show()}return undefined}.bind(this)).then(function(){if(W.browser.name==="ff"){jQuery(document).on("contextmenu",de)}}).then(function(){this.fnKeyDown=fe.bind(this);jQuery(document).on("keydown",this.fnKeyDown);this.fnOnPersonalizationChangeCreation=re.bind(this);C.attachChangeCreation(this.getRootControlInstance(),this.fnOnPersonalizationChangeCreation)}.bind(this)).then(ne).then(function(e){if(e){H(this)}this._sStatus=Y;te.disableRestart(this.getLayer());this.fireStart({editablePluginsCount:this.getPluginManager().getEditableOverlaysCount()})}.bind(this)).catch(function(e){if(e==="Reload triggered"){this.destroy()}else{this._sStatus=J;this.fireFailed({error:e})}return Promise.reject(e)}.bind(this))}return Promise.reject("RuntimeAuthoring is already started")};function ie(){var e=this._oVersionsModel.getProperty("/versioningEnabled");var t=e?"MSG_UNSAVED_DRAFT_CHANGES_ON_CLOSE":"MSG_UNSAVED_CHANGES_ON_CLOSE";var i=e?"BTN_UNSAVED_DRAFT_CHANGES_ON_CLOSE_SAVE":"BTN_UNSAVED_CHANGES_ON_CLOSE_SAVE";return $.showMessageBox("warning",t,{titleKey:"TIT_UNSAVED_CHANGES_ON_CLOSE",actionKeys:[i,"BTN_UNSAVED_CHANGES_ON_CLOSE_DONT_SAVE"],emphasizedActionKey:"BTN_UNSAVED_CHANGES_ON_CLOSE_SAVE",showCancel:true})}te.prototype.stop=function(e,t){var i;var a;ge.call(this,"setBusy",true);return pe.call(this).then(function(){var t=this.getLayer();if(t!==T.USER&&!e&&this.canSave()){return ie.call(this).then(function(e){if(e===n.Action.CANCEL){i=true;return Promise.reject()}if(e===this._getTextResources().getText("BTN_UNSAVED_CHANGES_ON_CLOSE_DONT_SAVE")){return this._oSerializer.clearCommandStack(true)}return undefined}.bind(this))}return undefined}.bind(this)).then(function(){if(t){return{}}return K.checkReloadOnExit({layer:this.getLayer(),selector:this.getRootControlInstance(),isDraftAvailable:this._oVersionsModel.getProperty("/draftAvailable"),versioningEnabled:this._oVersionsModel.getProperty("/versioningEnabled"),activeVersion:this._oVersionsModel.getProperty("/activeVersion"),changesNeedReloadPromise:this._bSavedChangesNeedReload?Promise.resolve(true):this._oSerializer.needsReload()})}.bind(this)).then(function(t){a=t;if(!e){return this._serializeToLrep(false,true)}return undefined}.bind(this)).then(function(){ge.call(this,"hide",e);this.fireStop();if(!t){R.removeInfoSessionStorage(this.getRootControlInstance());if(a.allContexts){const e=v.getFlexReferenceForControl(this.getRootControlInstance());f.clearState(e)}K.handleUrlParametersOnExit(a)}P.clearInstances()}.bind(this)).catch(function(e){if(!i){return ce(e)}return undefined}).then(function(){ge.call(this,"setBusy",false);if(!i){this._sStatus=Z;document.body.classList.remove("sapUiRtaMode")}}.bind(this))};te.prototype.setCommandStack=function(e){var t=this.getProperty("commandStack");if(t){t.detachModified(ue,this)}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack}var i=this.setProperty("commandStack",e);if(e){e.attachModified(ue,this)}if(this.getPluginManager&&this.getPluginManager()){this.getPluginManager().provideCommandStack("settings",e)}return i};te.prototype.getCommandStack=function(){var e=this.getProperty("commandStack");if(!e){e=new V;this._oInternalCommandStack=e;this.setCommandStack(e)}return e};te.prototype.setMode=function(e){var t=this.getMode();if(t!==e){var i=this.getPluginManager().getPlugin("tabHandling");var n=this.getPluginManager().getPlugin("selection");if(t==="navigation"||e==="navigation"){this._oDesignTime.setEnabled(e!=="navigation");i[e==="navigation"?"restoreTabIndex":"removeTabIndex"]()}var a=this.getChangeVisualization&&this.getChangeVisualization();if(e==="visualization"||t==="visualization"){g.waitForSynced(this._oDesignTime)().then(function(){return a.triggerModeChange(this.getRootControl(),this.getToolbar())}.bind(this))}if(t==="adaptation"){this.getPluginManager().handleStopCutPaste()}i[e==="adaptation"?"restoreOverlayTabIndex":"removeOverlayTabIndex"]();n.setIsActive(!(e==="visualization"));c.getOverlayContainer().toggleClass("sapUiRtaVisualizationMode",e==="visualization");if(e==="visualization"){document.querySelectorAll(".sapUiDtOverlayMovable").forEach(function(e){e.style.cursor="default"})}else{document.querySelectorAll(".sapUiDtOverlayMovable").forEach(function(e){e.style.cursor="move"})}this._oToolbarControlsModel.setProperty("/modeSwitcher",e);this.setProperty("mode",e);this.fireModeChanged({mode:e})}};te.prototype.setMetadataScope=function(e){if(this._sStatus!==Z){i.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return}this.setProperty("metadataScope",e)};te.prototype.destroy=function(...e){var t=Object.keys(this._dependents);t.forEach(function(e){this._dependents[e].destroy(true);this.removeDependent(e)}.bind(this));Object.keys(this._mServices).forEach(function(e){this.stopService(e)},this);if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;jQuery(document).off("keydown",this.fnKeyDown);if(this.fnOnPersonalizationChangeCreation){C.detachChangeCreation(this.getRootControlInstance(),this.fnOnPersonalizationChangeCreation)}}if(this.getRootControlInstance()){le(this.getRootControlInstance(),false)}this.setCommandStack(null);if(this._oServiceEventBus){this._oServiceEventBus.destroy()}if(W.browser.name==="ff"){jQuery(document).off("contextmenu",de)}window.onbeforeunload=this._oldUnloadHandler;o.prototype.destroy.apply(this,e)};te.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get()}return[]};te.prototype.restore=function(){var e=this.getLayer();var t=e===T.USER?"FORM_PERS_RESET_MESSAGE_PERSONALIZATION":"FORM_PERS_RESET_MESSAGE";var i=e===T.USER?"BTN_RESTORE":"FORM_PERS_RESET_TITLE";this.getPluginManager().handleStopCutPaste();return $.showMessageBox("warning",t,{titleKey:i,actions:[n.Action.OK,n.Action.CANCEL],emphasizedAction:n.Action.OK}).then(function(t){if(t===n.Action.OK){te.enableRestart(e,this.getRootControlInstance());return Ne.call(this)}return undefined}.bind(this))};te.prototype.undo=function(){this.getPluginManager().handleStopCutPaste();return this.getCommandStack().undo()};te.prototype.redo=function(){this.getPluginManager().handleStopCutPaste();return this.getCommandStack().redo()};te.prototype.canUndo=function(){return this.getCommandStack().canUndo()};te.prototype.canSave=function(){return this.getCommandStack().canSave()};te.prototype.canRedo=function(){return this.getCommandStack().canRedo()};te.prototype.save=function(){return pe.call(this).then(this._serializeToLrep.bind(this))};te.prototype._serializeToLrep=function(e,t){if(!this._bSavedChangesNeedReload){return this._oSerializer.needsReload().then(function(i){this._bSavedChangesNeedReload=i;return me.call(this,undefined,e,t)}.bind(this))}return me.call(this,undefined,e,t)};te.prototype.condenseAndSaveChanges=function(...e){return this._serializeToLrep(...e)};te.prototype._onUnload=function(){if(this.canSave()&&this.getShowWindowUnloadDialog()){return this._getTextResources().getText("MSG_UNSAVED_CHANGES")}window.onbeforeunload=this._oldUnloadHandler;return undefined};function ne(){var e=new URLSearchParams(window.location.search).get("sap-ui-rta-skip-flex-validation");return b.getInstance().then(function(t){return!t.isCustomerSystem()&&e!=="true"})}function ae(e){var t=e.getParameters().getSource();if(t.isA("sap.m.Dialog")&&this.getToolbar().type==="fiori"){this.getToolbar().setColor("contrast")}this.getToolbar().bringToFront()}function oe(e){if(e.getParameters().isA("sap.m.Dialog")){this.getToolbar().setColor()}}function re(){if(this.getMode()==="navigation"&&!this._bNavigationModeWarningShown){se.call(this,"MSG_NAVIGATION_MODE_CHANGES_WARNING",{duration:5e3});this._bNavigationModeWarningShown=true}}function se(e,t){var i=this._getTextResources().getText(e);a.show(i,t||{})}function le(e,t){if(e.isA("sap.ui.core.UIComponent")){e=e.getRootControl()}if(e){e[t?"addStyleClass":"removeStyleClass"]("sapUiRtaRoot")}}function de(){return false}function he(e,t,i){return Promise.all([_.isPublishAvailable(),w.isSaveAsAvailable(e,t,i),_.isContextBasedAdaptationAvailable(t),M.getUShellService("AppLifeCycle").then(function(e){if(e){var t=e.getCurrentApplication();return t?t.homePage:false}return false})]).then(function(t){var i=t[0];var n=t[1];var a=t[2];var o=t[3];var r=M.getAppDescriptor(e);var s=r&&!v.getOvpEntry(r);return{publishAvailable:i,saveAsAvailable:!o&&i&&n,contextBasedAdaptationAvailable:!o&&s&&a}})}function ce(e){r.hide();var t=e.userMessage||e.stack||e.message||e.status||e;var a=s.getResourceBundleFor("sap.ui.rta");i.error("Failed to transfer changes",t);var o=`${a.getText("MSG_LREP_TRANSFER_ERROR")}\n\t\t\t${a.getText("MSG_ERROR_REASON",[t])}`;n.error(o,{styleClass:$.getRtaStyleClassName()})}function ue(){var e=!this.getShowToolbars()||!this.getCommandStack().canUndo();$.checkDraftOverwrite(this._oVersionsModel,e).then(()=>{if(this.getShowToolbars()){var e=this.getCommandStack();var t=e.canUndo();var i=e.canRedo();var n=e.canSave();var a=e.getSaved();var o=this._oToolbarControlsModel.getProperty("/translation/visible")&&E.hasTranslationRelevantDirtyChanges({layer:T.CUSTOMER,selector:this.getRootControlInstance()});this._oVersionsModel.setDirtyChanges(A.hasDirtyChanges({selector:this.getRootControlInstance()}));this._oToolbarControlsModel.setProperty("/undo/enabled",t);this._oToolbarControlsModel.setProperty("/redo/enabled",i);this._oToolbarControlsModel.setProperty("/save/enabled",n);this._oToolbarControlsModel.setProperty("/restore/enabled",this.bInitialResetEnabled||n||a);this._oToolbarControlsModel.setProperty("/translation/enabled",this.bPersistedDataTranslatable||o)}this.fireUndoRedoStackModified()}).catch(()=>{this.undo()})}function ge(e,t){if(this.getShowToolbars()&&this.getToolbar&&this.getToolbar()){return this.getToolbar()[e](t)}return undefined}function pe(){return Promise.resolve(this._oDesignTime&&this._oDesignTime.waitForBusyPlugins()).then(function(){return this._pElementModified}.bind(this))}function fe(e){var t=W.os.macintosh;var i=c.getOverlayContainer().get(0).contains(document.activeElement);var n=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);var a=false;document.querySelectorAll(".sapUiDtContextMenu").forEach(function(e){if(e.contains(document.activeElement)){a=true}});var o=document.body===document.activeElement;var r=d.getParents(document.activeElement,".sapUiRtaEditableField").length>0;if((i||n||a||o)&&!r){var s=t?e.metaKey:e.ctrlKey;if(e.keyCode===p.Z&&e.shiftKey===false&&e.altKey===false&&s===true){this.undo().then(e.stopPropagation.bind(e))}else if((t&&e.keyCode===p.Z&&e.shiftKey===true||!t&&e.keyCode===p.Y&&e.shiftKey===false)&&e.altKey===false&&s===true){this.redo().then(e.stopPropagation.bind(e))}}}function ve(e){var t=e.getParameter("callback")||function(){};var i=this._oVersionsModel.getProperty("/versioningEnabled");return this.save().then(function(){se.call(this,i?"MSG_SAVE_DRAFT_SUCCESS":"MSG_SAVE_SUCCESS",{duration:5e3})}.bind(this)).catch(function(e){return ce(e)}).then(t)}function me(e,t,i){if(this.getShowToolbars()){this.bPersistedDataTranslatable=this._oToolbarControlsModel.getProperty("/translation/enabled")}var n={layer:this.getLayer(),removeOtherLayerChanges:true,condenseAnyLayer:t};if(this._oVersionsModel.getProperty("/versioningEnabled")){var a=e?this._oVersionsModel.getProperty("/displayedVersion"):undefined;a||=i?undefined:S.Number.Draft;n.version=a;n.saveAsDraft=this.getLayer()===T.CUSTOMER}if(this._oContextBasedAdaptationsModel.getProperty("/contextBasedAdaptationsEnabled")){n.adaptationId=i?undefined:this._oContextBasedAdaptationsModel.getProperty("/displayedAdaptation/id")}return this._oSerializer.saveCommands(n).then(function(){if(!i){var e=this.getToolbar();var t=this.getChangeVisualization();t.updateAfterSave(e)}}.bind(this))}function Se(e){var t=e.getParameter("versionTitle");if(we.call(this)&&Oe.call(this)){return $.showMessageBox("warning","MSG_DRAFT_DISCARD_ON_REACTIVATE_DIALOG",{titleKey:"TIT_DRAFT_DISCARD_ON_REACTIVATE_DIALOG",actions:[n.Action.OK,n.Action.CANCEL],emphasizedAction:n.Action.OK}).then(function(e){if(e===n.Action.OK){return be.call(this,t)}return undefined}.bind(this))}return be.call(this,t)}function be(e){var t=this.getLayer();var i=this.getRootControlInstance();var n=this._oVersionsModel.getProperty("/displayedVersion");return me.call(this,true).then(function(){return P.activate({layer:t,control:i,title:e,displayedVersion:n})}).then(function(){se.call(this,"MSG_DRAFT_ACTIVATION_SUCCESS");this.bInitialResetEnabled=true;this._oToolbarControlsModel.setProperty("/restore/enabled",true);this.getCommandStack().removeAllCommands()}.bind(this)).catch(function(e){$.showMessageBox("error","MSG_DRAFT_ACTIVATION_FAILED",{error:e})})}function ye(){return $.showMessageBox("warning","MSG_DRAFT_DISCARD_DIALOG",{actions:[n.Action.OK,n.Action.CANCEL],emphasizedAction:n.Action.OK}).then(function(e){if(e===n.Action.OK){return P.discardDraft({layer:this.getLayer(),control:this.getRootControlInstance(),updateState:true}).then(Ce.bind(this))}return undefined}.bind(this))}function Ce(){var e=this.getLayer();var t={layer:e,removeDraft:true,selector:this.getRootControlInstance()};te.enableRestart(e,this.getRootControlInstance());this.getCommandStack().removeAllCommands();K.triggerReload(t);return this.stop(true,true)}function _e(){if(this.canSave()){Ae.call(this,"DAC_DATA_LOSS_DIALOG_DESCRIPTION","DAC_DIALOG_HEADER",true)}else{Ae.call(this,"DAC_DIALOG_DESCRIPTION","DAC_DIALOG_HEADER")}}function Ae(e,t,i){$.showMessageBox("confirm",e,{titleKey:t}).then(function(e){if(e===n.Action.OK){r.show();if(i){this.getCommandStack().removeAllCommands(true)}Re.call(this)}}.bind(this))}function Re(){D.start("onCBADeleteAdaptation","Measurement of deleting a context-based adaptation");y.remove({control:this.getRootControlInstance(),layer:this.getLayer(),adaptationId:this._oContextBasedAdaptationsModel.getProperty("/displayedAdaptation/id")}).then(function(){r.hide();var e=this._oContextBasedAdaptationsModel.deleteAdaptation();Te.call(this,e);D.end("onCBADeleteAdaptation");if(D.getActive()){i.info(`onCBADeleteAdaptation: ${D.getMeasurement("onCBADeleteAdaptation").time} ms`)}}.bind(this)).catch(function(e){r.hide();i.error(e.stack);var t="MSG_LREP_TRANSFER_ERROR";var n={titleKey:"DAC_DIALOG_HEADER"};n.details=e.userMessage;$.showMessageBox("error",t,n)})}function Ee(e,t,i){if(this.canSave()){$.showMessageBox("warning",e,{titleKey:t,actions:[n.Action.YES,n.Action.NO,n.Action.CANCEL],emphasizedAction:n.Action.YES}).then(function(e){if(e===n.Action.YES){return this._serializeToLrep().then(i)}else if(e===n.Action.NO){this.getCommandStack().removeAllCommands(true);return i()}return Promise.resolve()}.bind(this));return Promise.resolve()}return i()}function Pe(e){D.start("onCBASwitchAdaptation","Measurement of switching a context-based adaptation");var t=e.getParameter("callback")||function(){};if(e.getParameter("trigger")==="SaveAs"){this.getCommandStack().removeAllCommands(true)}var n=e.getParameter("adaptationId");this._sSwitchToAdaptationId=n;return Ee.call(this,"MSG_SWITCH_VERSION_DIALOG","BTN_SWITCH_ADAPTATIONS",Te.bind(this,this._sSwitchToAdaptationId)).then(function(){t();D.end("onCBASwitchAdaptation");if(D.getActive()){i.info(`onCBASwitchAdaptation: ${D.getMeasurement("onCBASwitchAdaptation").time} ms`)}}).catch(function(e){$.showMessageBox("error","MSG_SWITCH_ADAPTATION_FAILED",{error:e});i.error(`sap.ui.rta: ${e.stack||e.message||e}`)})}function Te(e){var t=this._oVersionsModel.getProperty("/displayedVersion");return Ie.call(this,t,e)}function Me(e){var t=e.getParameter("callback")||function(){};var n=e.getParameter("version");var a=this._oVersionsModel.getProperty("/displayedVersion");if(n===a){return}this._sSwitchToVersion=n;Ee.call(this,"MSG_SWITCH_VERSION_DIALOG","TIT_SWITCH_VERSION_DIALOG",Ie.bind(this,this._sSwitchToVersion)).then(t).catch(function(e){$.showMessageBox("error","MSG_SWITCH_VERSION_FAILED",{error:e});i.error(`sap.ui.rta: ${e.stack||e.message||e}`)})}function Ie(e,t){te.enableRestart(this.getLayer(),this.getRootControlInstance());return P.loadVersionForApplication({control:this.getRootControlInstance(),layer:this.getLayer(),version:e,adaptationId:t}).then(function(){var t={versionSwitch:true,version:e,selector:this.getRootControlInstance()};K.triggerReload(t)}.bind(this))}function De(){this.getPluginManager().handleStopCutPaste();return P.publish({selector:this.getRootControlInstance(),styleClass:$.getRtaStyleClassName(),layer:this.getLayer(),version:this._oVersionsModel.getProperty("/displayedVersion")}).then(function(e){if(e!=="Error"&&e!=="Cancel"){a.show(e)}})}function we(){return P.isOldVersionDisplayed({control:this.getRootControlInstance(),layer:this.getLayer()})}function Oe(){return P.isDraftAvailable({control:this.getRootControlInstance(),layer:this.getLayer()})}function Le(){return P.initialize({control:this.getRootControlInstance(),layer:this.getLayer()}).then(function(e){this._oVersionsModel=e}.bind(this))}function Ve(e){if(!e){y.clearInstances()}return y.initialize({control:this.getRootControlInstance(),layer:this.getLayer()}).then(function(e){this._oContextBasedAdaptationsModel=e}.bind(this))}function xe(e){if(!this.getDependent("toolbar")){var t=this.getLayer()===T.USER;var i={rtaInformation:{flexSettings:this.getFlexSettings(),rootControl:this.getRootControlInstance(),commandStack:this.getCommandStack()},textResources:this._getTextResources(),restore:this.restore.bind(this),exit:this.stop.bind(this,false,t)};if(!t){i.publishVersion=De.bind(this);i.undo=this.undo.bind(this);i.redo=this.redo.bind(this);i.modeChange=Ge.bind(this);i.activate=Se.bind(this);i.discardDraft=ye.bind(this);i.switchVersion=Me.bind(this);i.switchAdaptation=Pe.bind(this);i.deleteAdaptation=_e.bind(this);i.openChangeCategorySelectionPopover=this.getChangeVisualization?this.getChangeVisualization().openChangeCategorySelectionPopover.bind(this.getChangeVisualization()):function(){};i.save=ve.bind(this)}var n;if(t){n=new U(i)}else if($.isOriginalFioriToolbarAccessible()){n=new N(i)}else if($.getFiori2Renderer()){n=new B(i)}else{n=new k(i)}this.addDependent(n,"toolbar");return Promise.all([n.onFragmentLoaded(),_.isKeyUserTranslationEnabled(this.getLayer())]).then(function(t){var i=t[1];var n=e.saveAsAvailable;var a=n&&w.isOverviewExtended();var o=new URLSearchParams(window.location.search);var r;r=!o.has("fiori-tools-rta-mode")||o.get("fiori-tools-rta-mode")==="false";var s=m.getConfiguredFlexServices().some(function(e){return e.connector!=="LocalStorageConnector"});this.bPersistedDataTranslatable=false;this._oToolbarControlsModel=new I({modeSwitcher:this.getMode(),undo:{enabled:false},redo:{enabled:false},save:{enabled:false},translation:{visible:i,enabled:this.bPersistedDataTranslatable},appVariantMenu:{visible:n,enabled:n,overview:{visible:n&&a,enabled:n&&a},manageApps:{visible:n&&!a,enabled:n&&!a},saveAs:{visible:n,enabled:n}},restore:{visible:!this._oVersionsModel.getProperty("/versioningEnabled"),enabled:this.bInitialResetEnabled},contextBasedAdaptation:{visible:e.contextBasedAdaptationAvailable,enabled:e.contextBasedAdaptationAvailable},actionsMenuButton:{enabled:true},visualizationButton:{visible:r,enabled:r},feedbackButton:{visible:s}});this._oVersionsModel.setProperty("/publishVersionVisible",e.publishAvailable);var l=new Promise(function(e){if(!i){e();return}E.getSourceLanguages({selector:this.getRootControlInstance(),layer:this.getLayer()}).then(function(e){this.bPersistedDataTranslatable=e.length>0;this._oToolbarControlsModel.setProperty("/translation/enabled",this.bPersistedDataTranslatable)}.bind(this)).finally(e)}.bind(this));var d=new Promise(function(e){if(!n){e();return}w.isManifestSupported().then(function(e){if(M.isVariantByStartupParameter(this.getRootControlInstance())){e=false}this._oToolbarControlsModel.setProperty("/appVariantMenu/saveAs/enabled",e);this._oToolbarControlsModel.setProperty("/appVariantMenu/overview/enabled",e);this._oToolbarControlsModel.setProperty("/appVariantMenu/manageApps/enabled",e)}.bind(this)).finally(e)}.bind(this));this.getToolbar().setModel(this._oVersionsModel,"versions");this.getToolbar().setModel(this._oContextBasedAdaptationsModel,"contextBasedAdaptations");this.getToolbar().setModel(this._oToolbarControlsModel,"controls");return Promise.all([l,d])}.bind(this))}return Promise.resolve()}function Ne(){var e=this.getLayer();var t=M.getAppComponentForControl(this.getRootControlInstance());return A.reset({selector:t,layer:e}).then(function(){this.getCommandStack().removeAllCommands(true);R.removeInfoSessionStorage(t);var i={layer:e,ignoreMaxLayerParameter:true,triggerHardReload:true};return K.triggerReload(i)}.bind(this)).catch(function(e){if(e!=="cancel"){$.showMessageBox("error","MSG_RESTORE_FAILED",{error:e})}})}function Be(e,t){function i(n){var a=n.getParameter("elementOverlay");if(a.getElement().getId()===e){this._oDesignTime.detachEvent("elementOverlayCreated",i,this);t(a)}}this._oDesignTime.attachEvent("elementOverlayCreated",i,this)}function Ue(e,t){function i(e){var n=e.getSource();if(n.getGeometry()&&n.getGeometry().visible){n.detachEvent("geometryChanged",i);t(n)}}function n(e){if(!e.getGeometry()||!e.getGeometry().visible){e.attachEvent("geometryChanged",i)}else{t(e)}}Be.call(this,e,function(e){if(e.isRendered()){n(e)}else{e.attachEventOnce("afterRendering",function(e){n(e.getSource())})}})}function ke(e,t,i){var n=function(e){e.setSelected(true);this.getPluginManager().getPlugin("rename").startEdit(e)}.bind(this);Ue.call(this,t,function(t){var a=this.getPluginManager().getPlugin("createContainer").getCreatedContainerId(e,t.getElement().getId());var o=u.getOverlay(a);if(o){if(i){this.getPluginManager().getPlugin("rename").createRenameCommand(o,i).then(function(){this.getCommandStack().compositeLastTwoCommands()}.bind(this))}else{n(o)}}else{Ue.call(this,a,n)}}.bind(this))}function Fe(e){var t=e.getParameter("command");var n=e.getParameter("newControlId");var a=e.getParameter("action");var o=e.getParameter("title");this._pElementModified=this._pElementModified.then(function(){this.getPluginManager().handleStopCutPaste();if(t instanceof O){if(n){Be.call(this,n,function(e){var t=e.getDesignTimeMetadata();var i=t.getData().select;if(typeof i==="function"){i(e.getElement())}});if(a){ke.call(this,a,n,o)}}return this.getCommandStack().pushAndExecute(t).catch(function(e){if(e?.message?.indexOf?.("The following Change cannot be applied because of a dependency")>-1){$.showMessageBox("error","MSG_DEPENDENCY_ERROR",{error:e})}i.error("sap.ui.rta:",e.message,e.stack)})}return undefined}.bind(this));return this._pElementModified}function Ge(e){this.setMode(e.getParameter("item").getKey())}function ze(e){if(x.hasOwnProperty(e)){return x[e].replace(/\./g,"/")}return undefined}te.prototype.startService=function(e){if(this._sStatus!==Y){return new Promise(function(e,t){this.attachEventOnce("start",e);this.attachEventOnce("failed",t)}.bind(this)).then(function(){return this.startService(e)}.bind(this),function(){return Promise.reject(g.createError("RuntimeAuthoring#startService",`Can't start the service '${e}' because RTA startup failed`,"sap.ui.rta"))})}var i=ze(e);var n;if(!i){return Promise.reject(g.createError("RuntimeAuthoring#startService",`Unknown service. Can't find any registered service by name '${e}'`,"sap.ui.rta"))}n=this._mServices[e];if(n){switch(n.status){case X:{return Promise.resolve(n.exports)}case Q:{return n.initPromise}case ee:{return n.initPromise}default:{return Promise.reject(g.createError("RuntimeAuthoring#startService",`Unknown service status. Service name = '${e}'`,"sap.ui.rta"))}}}else{this._mServices[e]=n={};n.status=Q;n.location=i;n.initPromise=new Promise(function(a,o){sap.ui.require([i],function(i){n.factory=i;this._oServiceEventBus||=new j;g.wrapIntoPromise(i)(this,this._oServiceEventBus.publish.bind(this._oServiceEventBus,e)).then(function(i){if(this.bIsDestroyed){throw g.createError("RuntimeAuthoring#startService",`RuntimeAuthoring instance is destroyed while initializing the service '${e}'`,"sap.ui.rta")}if(!t(i)){throw g.createError("RuntimeAuthoring#startService",`Invalid service format. Service should return simple javascript object after initialization. Service name = '${e}'`,"sap.ui.rta")}n.service=i;n.exports={};if(Array.isArray(i.events)&&i.events.length>0){Object.assign(n.exports,{attachEvent:this._oServiceEventBus.subscribe.bind(this._oServiceEventBus,e),detachEvent:this._oServiceEventBus.unsubscribe.bind(this._oServiceEventBus,e),attachEventOnce:this._oServiceEventBus.subscribeOnce.bind(this._oServiceEventBus,e)})}var o=i.exports||{};Object.assign(n.exports,Object.keys(o).reduce(function(e,t){var i=o[t];e[t]=typeof i==="function"?g.waitForSynced(this._oDesignTime,i):i;return e}.bind(this),{}));n.status=X;a(Object.freeze(n.exports))}.bind(this)).catch(o)}.bind(this),function(t){n.status=ee;o(g.propagateError(t,"RuntimeAuthoring#startService",`Can't load service '${e}' by its name: ${i}`,"sap.ui.rta"))})}.bind(this)).catch(function(t){n.status=ee;return Promise.reject(g.propagateError(t,"RuntimeAuthoring#startService",`Error initializing service '${e}'`,"sap.ui.rta"))});return n.initPromise}};te.prototype.stopService=function(e){var t=this._mServices[e];if(t){if(t.status===X){if(typeof t.service.destroy==="function"){t.service.destroy()}}delete this._mServices[e]}else{throw g.createError("RuntimeAuthoring#stopService",`Can't destroy service: unable to find service with name '${e}'`,"sap.ui.rta")}};te.prototype.getService=function(e){return this.startService(e)};return te});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/Utils", ["sap/base/util/restricted/_omit","sap/m/MessageBox","sap/ui/core/Element","sap/ui/core/EventBus","sap/ui/core/Fragment","sap/ui/core/Lib","sap/ui/dt/DOMUtil","sap/ui/dt/ElementUtil","sap/ui/dt/MetadataPropagationUtil","sap/ui/dt/OverlayUtil","sap/ui/fl/initial/api/Version","sap/ui/fl/write/api/FieldExtensibility","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils","sap/ui/model/json/JSONModel","sap/ui/rta/util/BindingsExtractor","sap/ui/rta/util/hasStableId"],function(e,t,n,r,i,a,o,l,s,u,c,g,d,f,v,y,m,p){"use strict";var h={};h.RESOLVED_PROMISE=Promise.resolve(true);h._sFocusableOverlayClass=".sapUiDtOverlaySelectable";h._sRtaStyleClassName="";h.getRtaStyleClassName=function(){return h._sRtaStyleClassName};h.setRtaStyleClassName=function(e){if(e===d.USER){h._sRtaStyleClassName=""}else if(f.getLayerIndex(e)>-1){h._sRtaStyleClassName="sapUiRTABorder"}};h.isServiceUpToDate=function(e){return g.isExtensibilityEnabled(e).then(function(t){if(t){var n=e.getModel();if(n&&n.sServiceUrl){return g.isServiceOutdated(n.sServiceUrl).then(function(e){if(e){g.setServiceValid(n.sServiceUrl);r.getInstance().publish("sap.ui.core.UnrecoverableClientStateCorruption","RequestReload",{})}})}}return undefined})};h.openRemoveConfirmationDialog=function(e,t){var n=a.getResourceBundleFor("sap.ui.rta");var r;return new Promise(function(e){r=n.getText("CTX_REMOVE_TITLE");var a={messageText:t,titleText:r,icon:"sap-icon://question-mark",removeText:n.getText("BTN_FREP_REMOVE"),cancelText:n.getText("BTN_FREP_CANCEL")};var o=new y;o.setData(a);var l;var s=function(){if(l){l.close();l.destroy();l=null}};var u={removeField(){s();e(true)},closeDialog(){s();e(false)}};if(!l){i.load({name:"sap.ui.rta.view.RemoveElementDialog",controller:u}).then(function(e){l=e;l.setModel(o);l.addStyleClass(h.getRtaStyleClassName());l.open()})}else{l.addStyleClass(h.getRtaStyleClassName());l.open()}})};h.isOverlaySelectable=function(e){return e.isSelectable()&&o.isVisible(e.getDomRef())};h.getPropertyValue=function(e,t){var n=e.getMetadata().getPropertyLikeSetting(t);var r=n._sGetter;return e[r]()};h.getOverlayInstanceForDom=function(e){var t=e.getAttribute("id");if(t){return n.getElementById(t)}return undefined};h.getFocusedOverlay=function(){if(document.activeElement){var e=n.getElementById(document.activeElement.id);if(e&&e.isA("sap.ui.dt.ElementOverlay")){return e}}return undefined};h.getFocusableParentOverlay=function(e){if(!e){return undefined}var t=e.getParentElementOverlay();while(t&&!t.getSelectable()){t=t.getParentElementOverlay()}return t};h.getFirstFocusableDescendantOverlay=function(e){return u.getFirstDescendantByCondition(e,this.isOverlaySelectable)};h.getLastFocusableDescendantOverlay=function(e){return u.getLastDescendantByCondition(e,this.isOverlaySelectable)};h.getNextFocusableSiblingOverlay=function(e){var t=true;var n=u.getNextSiblingOverlay(e);while(n&&!this.isOverlaySelectable(n)){n=u.getNextSiblingOverlay(n)}n||=this._findSiblingOverlay(e,t);return n};h.getPreviousFocusableSiblingOverlay=function(e){var t=false;var n=u.getPreviousSiblingOverlay(e);while(n&&!this.isOverlaySelectable(n)){n=u.getPreviousSiblingOverlay(n)}n||=this._findSiblingOverlay(e,t);return n};h._findSiblingOverlay=function(e,t){var n=e.getParentElementOverlay();if(n){var r=t?u.getNextSiblingOverlay(n):u.getPreviousSiblingOverlay(n);if(!r){return this._findSiblingOverlay(n,t)}var i=t?this.getFirstFocusableDescendantOverlay(r):this.getLastFocusableDescendantOverlay(r);return i}return undefined};h.getIndex=function(e,t,n,r){var i;if(r&&typeof r==="function"){i=r(e,t)}else{var a=e.getMetadata();var o=a.getAggregation(n);var l=o._sGetter;var s=e[l]();if(Array.isArray(s)&&t){i=s.indexOf(t)+1}else{i=0}}return i};h.createFieldLabelId=function(e,t,n){return`${e.getId()}_${t}_${n}`.replace("/","_")};h.getElementBindingPaths=function(e){var t={};if(e.mBindingInfos){for(var n in e.mBindingInfos){var r=e.mBindingInfos[n].parts[0].path?e.mBindingInfos[n].parts[0].path:"";r=r.split("/")[r.split("/").length-1];t[r]={valueProperty:n}}}return t};h.isOriginalFioriToolbarAccessible=function(){var e=h.getFiori2Renderer();return e&&e.getRootControl&&e.getRootControl().getShellHeader()};h.getFiori2Renderer=function(){var e=v.getUshellContainer()||{};return typeof e.getRenderer==="function"?e.getRenderer("fiori2"):undefined};h.extendWith=function(e,t,n){if(!(typeof n==="function")){throw new Error("In order to use extendWith() utility function fnCustomizer should be provided!")}for(var r in t){if(t.hasOwnProperty(r)){if(n(e[r],t[r],r,e,t)){e[r]=t[r]}}}};h.isElementInViewport=function(e){e=e.jquery?e.get(0):e;var t=e.getBoundingClientRect();return t.top>=0&&t.left>=0&&t.bottom<=(window.innerHeight||document.documentElement.clientHeight)&&t.right<=(window.innerWidth||document.documentElement.clientWidth)};h.showMessageBox=function(n,r,i){var o=a.getResourceBundleFor("sap.ui.rta");i||={};var l=o.getText(r,i.error?[i.error.userMessage||i.error.message||i.error]:undefined);var s=i.titleKey&&o.getText(i.titleKey);var u=i.actionKeys&&i.actionKeys.map(function(e){return o.getText(e)});var c=i.emphasizedActionKey?o.getText(i.emphasizedActionKey):undefined;var g=i.showCancel;var d=e(i,["titleKey","error","actionKeys","emphasizedAction","emphasizedActionKey","showCancel"]);d.title=s;d.styleClass=h.getRtaStyleClassName();d.actions||=u;d.emphasizedAction=c||i.emphasizedAction;if(g){d.actions.push(t.Action.CANCEL)}return b(n,l,d)};function b(e,n,r){return new Promise(function(i){r.onClose=i;t[e](n,r)})}h.checkSourceTargetBindingCompatibility=function(e,t,n){n||=e.getModel();var r=m.collectBindingPaths(e,n);var i;var a;if(r.bindingPaths.length===0){return true}i=m.getBindingContextPath(e);a=m.getBindingContextPath(t);if(i===a){return true}return false};h.doIfAllControlsAreAvailable=function(e,t){if(e.every(function(e){return e&&!e._bIsBeingDestroyed})){return t()}return undefined};h.buildHashMapFromArray=function(e,t,n){return e.reduce(function(e,r){e[r[t]]=r[n];return e},{})};h.checkTargetZone=function(e,t,n,r){function i(e,t,n,r){var i=e.getDesignTimeMetadata();var a=i.getAction("move",t);if(!a){return Promise.resolve(false)}return r.hasChangeHandler(a.changeType,n)}return l.checkTargetZone(e,t,r).then(function(r){if(!r){return false}var a=t.getElement();var o=e.getParent();var l=t.getRelevantContainer();if(!a||!o){return false}var u=o.getElement();var c=e.getDesignTimeMetadata();var g=s.getRelevantContainerForPropagation(c.getData(),a);g||=u;if(!l||!g||!p(o)||l!==g){return false}if(t.getParent().getElement()!==u&&!h.checkSourceTargetBindingCompatibility(a,u)){return false}return i(e,a,g,n)})};h.checkDraftOverwrite=function(e,n){var r=e.getProperty("/backendDraft");var i=e.getProperty("/displayedVersion")===c.Number.Draft;if(i||!r||n){return Promise.resolve(false)}return h.showMessageBox("warning","MSG_DRAFT_DISCARD_AND_CREATE_NEW_DIALOG",{titleKey:"TIT_DRAFT_DISCARD_DIALOG",actions:[t.Action.OK,t.Action.CANCEL],emphasizedAction:t.Action.OK}).then(function(e){if(e!==t.Action.OK){throw"cancel"}return true})};return h},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/api/startAdaptation", ["sap/ui/rta/util/adaptationStarter","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/base/util/merge"],function(e,i,t,r){"use strict";function a(e){if(!t.isValidLayer(e)){throw new Error("An invalid layer is passed")}}function s(t,s,n,l,u){var f={flexSettings:{developerMode:false,layer:i.CUSTOMER}};t=r(f,t);return Promise.resolve().then(a.bind(this,t.flexSettings.layer)).then(e.bind(this,t,s,n,l,u))}return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/api/startKeyUserAdaptation", ["sap/ui/rta/util/adaptationStarter","sap/ui/fl/Layer"],function(t,r){"use strict";function e(e){var o={rootControl:e.rootControl,flexSettings:{developerMode:false,layer:r.CUSTOMER}};return t(o)}return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/AppVariantDialog", ["sap/m/Button","sap/m/Dialog","sap/m/DialogRenderer","sap/m/GenericTile","sap/m/ImageContent","sap/m/Input","sap/m/Label","sap/m/SelectDialog","sap/m/StandardListItem","sap/m/TextArea","sap/m/TileContent","sap/m/VBox","sap/ui/core/Element","sap/ui/core/library","sap/ui/core/Lib","sap/ui/core/IconPool","sap/ui/core/Title","sap/ui/layout/form/SimpleForm","sap/ui/layout/library","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/json/JSONModel","sap/ui/rta/Utils","sap/ui/layout/form/ResponsiveGridLayout"],function(e,t,a,n,i,l,s,r,o,u,p,c,d,g,A,m,T,_,v,I,L,y,f){"use strict";var{SimpleFormLayout:S}=v.form;var{ValueState:h}=g;var C=A.getResourceBundleFor("sap.ui.rta");var E;var x;var P;var V;var w;var b;var O;var N;var B;var D;var R;var G;var M;function U(){E=new n("tile",{header:"{/title}",subheader:"{/subtitle}",ariaLabel:C.getText("APP_VARIANT_TILE_ARIA_LABEL"),tileContent:[new p({content:[new i({src:"{/icon}"})]})]}).addStyleClass("sapUiMediumMarginBegin").addStyleClass("sapUiTinyMarginTop").addStyleClass("sapUiTinyMarginBottom")}function X(e){var t=e.getParameter("value");var a=new I("name",L.Contains,t);var n=e.getSource().getBinding("items");n.filter([a])}function F(e){var t=e.getParameter("selectedContexts");if(t&&t.length){t.forEach(function(e){var t=e.getObject().name;B.setValue(t);G.setProperty("/icon",e.getObject().icon)})}e.getSource().getBinding("items").filter([])}function j(){R||=new r("selectDialog",{noDataText:C.getText("APP_VARIANT_ICON_NO_DATA"),title:C.getText("APP_VARIANT_ICON_SELECT_ICON"),search(e){X(e)},confirm(e){F(e)},cancel(e){F(e)}});R.addStyleClass(f.getRtaStyleClassName());R.bindAggregation("items",{path:"/icons",template:new o({title:"{name}",description:"",icon:"{icon}",iconDensityAware:false,iconInset:false,type:"Active"})});var e=m.getIconNames();var t=[];e.forEach(function(e){var a=m.getIconInfo(e);t.push({icon:a.uri,name:a.text===""?e.toLowerCase():a.text})});M.setProperty("/icons",t);R.setModel(M);R.getBinding("items").filter([]);R.open()}function H(){x=new s({required:true,text:C.getText("APP_DIALOG_TITLE_TEXT"),textAlign:"Left"});P=new l("titleInput",{value:"{/title}",valueLiveUpdate:true,placeholder:C.getText("SAVE_AS_DIALOG_PLACEHOLDER_TITLE_TEXT"),liveChange(){var e=d.getElementById("saveButton");if(this.getValue()===""){this.setValueState(h.Error);e.setEnabled(false)}else{this.setValueState(h.None);e.setEnabled(true)}}});V=new s({text:C.getText("APP_DIALOG_SUB_TITLE_TEXT"),textAlign:"Left"});w=new l({value:"{/subtitle}",valueLiveUpdate:true});b=new s({text:C.getText("APP_DIALOG_DESCRIPTION_TEXT"),textAlign:"Left"});O=new u({rows:4});N=new s({text:C.getText("APP_DIALOG_ICON_TEXT"),textAlign:"Left"});B=new l("selectInput",{showValueHelp:true,liveChange(e){j(e)},valueHelpRequest(e){j(e)},value:"{/iconname}",valueLiveUpdate:true})}function q(){D=new _({editable:true,layout:S.ResponsiveGridLayout,labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:4,adjustLabelSpan:false,emptySpanXL:0,emptySpanL:0,emptySpanM:0,emptySpanS:0,columnsXL:2,columnsL:2,columnsM:2,singleContainerFullSize:false,content:[new T("title1"),x,P,V,w,N,B,b,O,new T("title2"),E]});return D}function z(){var e=new c({items:[q()]}).addStyleClass("sapUISmallMargin");return e}var J=t.extend("sap.ui.rta.appVariant.AppVariantDialog",{metadata:{library:"sap.ui.rta",events:{create:{},cancel:{}}},init(){t.prototype.init.apply(this);this.setTitle(C.getText("CREATE_APP_VARIANT_DIALOG_TITLE"));this.setContentWidth("860px");this.setContentHeight("250px");G=new y({title:null,subtitle:null,icon:" ",iconname:null});M=new y({icons:null});sap.ui.getCore().setModel(G);U();H();this.addContent(z());this._createButtons();this.addStyleClass(f.getRtaStyleClassName())},onAfterRendering(){document.getElementById("title1").style.height="0px";document.getElementById("title2").style.height="0px";document.getElementById("tile").style.float="left"},_onCreate(){var e=P.getValue()||" ";var t=w.getValue()||" ";var a=O.getValue()||" ";var n=B.getValue()?m.getIconInfo(B.getValue()).uri:" ";this.fireCreate({title:e,subTitle:t,description:a,icon:n});this.close();this.destroy()},_createButtons(){this.addButton(new e("saveButton",{text:C.getText("APP_VARIANT_DIALOG_SAVE"),tooltip:C.getText("TOOLTIP_APP_VARIANT_DIALOG_SAVE"),enabled:false,press:function(){this._onCreate()}.bind(this)}));this.addButton(new e({text:C.getText("SAVE_AS_APP_VARIANT_DIALOG_CANCEL"),tooltip:C.getText("TOOLTIP_SAVE_AS_APP_VARIANT_DIALOG_CANCEL"),press:function(){this.fireCancel();this.close();this.destroy()}.bind(this)}))},destroy(...e){if(G){G.destroy()}t.prototype.destroy.apply(this,e)},renderer:a});return J});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/AppVariantManager", ["sap/ui/base/ManagedObject","sap/ui/rta/appVariant/AppVariantDialog","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/rta/appVariant/Feature","sap/ui/rta/appVariant/S4HanaCloudBackend"],function(e,t,a,n,r){"use strict";var i=e.extend("sap.ui.rta.appVariant.AppVariantManager",{metadata:{library:"sap.ui.rta",properties:{commandSerializer:{type:"object"},layer:{type:"string"}}}});i.prototype._openDialog=function(e,a){var n=new t("appVariantDialog");n.attachCreate(e);n.attachCancel(a);n.attachAfterClose(function(){this.destroy()});n.open();return n};i.prototype._prepareAppVariantData=function(e,t){return{referenceAppId:e["sap.app"].id,title:t.title,subTitle:t.subTitle,description:t.description,icon:t.icon,inbounds:e["sap.app"].crossNavigation&&e["sap.app"].crossNavigation.inbounds?e["sap.app"].crossNavigation.inbounds:null}};i.prototype.createAllInlineChanges=function(e,t){var n=a.getId(e.referenceAppId);var r=[];var i={};i.content=a.prepareTextsChange("title",e.title);r.push(a.createInlineChange(i,"appdescr_app_setTitle",t));i.content=a.prepareTextsChange("subtitle",e.subTitle);r.push(a.createInlineChange(i,"appdescr_app_setSubTitle",t));i.content=a.prepareTextsChange("description",e.description);r.push(a.createInlineChange(i,"appdescr_app_setDescription",t));i=a.getInlineChangeInputIcon(e.icon);r.push(a.createInlineChange(i,"appdescr_ui_setIcon",t));return a.getInboundInfo(e.inbounds).then(function(p){var o=p.currentRunningInbound;if(p.addNewInboundRequired){var s=a.prepareAddNewInboundChange(o,n,e).then(function(e){return a.createInlineChange(e,"appdescr_app_addNewInbound",t)});r.push(s)}else{i=a.prepareChangeInboundChange(o,n,e);r.push(a.createInlineChange(i,"appdescr_app_changeInbound",t))}i=a.prepareRemoveAllInboundsExceptOneChange(o);r.push(a.createInlineChange(i,"appdescr_app_removeAllInboundsExceptOne",t));return Promise.all(r)})};i.prototype.createAppVariant=function(e,t){var n={id:e,layer:this.getLayer()};return a.createAppVariant(t,n)};i.prototype.deleteAppVariant=function(e){return a.deleteAppVariant({appId:e},this.getLayer())};i.prototype.processSaveAsDialog=function(e,t){return new Promise(function(a,r){var i=function(t){var n=t.getParameters();var r=this._prepareAppVariantData(e,n);a(r)}.bind(this);var p=function(){if(!t){return n.onGetOverview(true,this.getLayer())}r()}.bind(this);return this._openDialog(i,p)}.bind(this))};i.prototype._clearRTACommandStack=function(){return this.getCommandSerializer().clearCommandStack()};i.prototype.clearRTACommandStack=function(e){var t=this.getCommandSerializer().getCommandStack();if(e&&t.getAllExecutedCommands().length){return this._clearRTACommandStack()}return Promise.resolve()};i.prototype.triggerCatalogPublishing=function(e,t,n){var r=n?a.triggerCatalogAssignment:a.triggerCatalogUnAssignment;return r(e,this.getLayer(),t).catch(function(t){var r=n?"MSG_CATALOG_ASSIGNMENT_FAILED":"MSG_DELETE_APP_VARIANT_FAILED";return a.catchErrorDialog(t,r,e)})};i.prototype.notifyKeyUserWhenPublishingIsReady=function(e,t,n){var i=new r;return i.notifyFlpCustomizingIsReady(e,n).catch(function(e){var r=n?"MSG_TILE_CREATION_FAILED":"MSG_DELETE_APP_VARIANT_FAILED";if(!n&&e.error==="locked"){r="MSG_CATALOGS_LOCKED"}return a.catchErrorDialog(e,r,t)})};i.prototype.showSuccessMessage=function(e){return a.showRelevantDialog(e,true)};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/AppVariantOverviewDialog", ["sap/ui/core/ComponentContainer","sap/ui/core/Lib","sap/m/Button","sap/m/Dialog","sap/m/DialogRenderer","sap/ui/rta/appVariant/manageApps/webapp/Component","sap/ui/rta/Utils"],function(t,e,n,s,a,i,o){"use strict";var p=s.extend("sap.ui.rta.appVariant.AppVariantOverviewDialog",{metadata:{library:"sap.ui.rta",properties:{idRunningApp:"string",isOverviewForKeyUser:{type:"boolean"},layer:"string"},events:{cancel:{}}},constructor:function(...n){s.prototype.constructor.apply(this,n);this._oTextResources=e.getResourceBundleFor("sap.ui.rta");this.oManageAppsComponent=new i("sap.ui.rta.appVariant.manageApps",{idRunningApp:this.getIdRunningApp(),isOverviewForKeyUser:this.getIsOverviewForKeyUser(),layer:this.getLayer()});this.oManageAppsComponentContainer=new t({component:this.oManageAppsComponent});this.addContent(this.oManageAppsComponentContainer);this._createButton();this.setContentWidth("1000px");this.setContentHeight("450px");this.setHorizontalScrolling(false);this.setTitle(this._oTextResources.getText("APP_VARIANT_OVERVIEW_DIALOG_TITLE"));this.addStyleClass(o.getRtaStyleClassName())},destroy(...t){s.prototype.destroy.apply(this,t)},renderer:a});p.prototype._createButton=function(){this.addButton(new n({text:this._oTextResources.getText("APP_VARIANT_DIALOG_CLOSE"),press:function(){this.close();this.fireCancel()}.bind(this)}))};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/AppVariantUtils", ["sap/ui/fl/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/core/BusyIndicator","sap/ui/core/EventBus","sap/ui/core/Lib","sap/base/util/uid","sap/base/Log","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/write/api/AppVariantWriteAPI","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/_internal/connectors/LrepConnector"],function(e,t,n,r,a,i,s,o,u,p,c,l){"use strict";var g={};var d=56;g._newAppVariantId=null;g.getManifirstSupport=function(e){return l.appVariant.getManifirstSupport({appId:e})};g.getNewAppVariantId=function(){return g._newAppVariantId};g.setNewAppVariantId=function(e){g._newAppVariantId=e};g.trimIdIfRequired=function(e){if(e.length>d){var t=e.split(".");var n;var r=t[t.length-1].length;var a=t.pop();n=t.join(".");if(n.length>r){n=n.substring(0,n.length-r)}else{return e.substr(0,d)}if(n[n.length-1]==="."){n=n+a}else{n=`${n}.${a}`}return this.trimIdIfRequired(n)}return e};g.getId=function(e){var t;var n=e.split(".");if(n[0]!=="customer"){n[0]=`customer.${n[0]}`}var r=false;var a=/^id.*/i;n.forEach(function(e,t,n){if(e.match(a)){e=e.replace(a,s().replace(/-/g,"_"));n[t]=e;r=true}});t=n.join(".");if(!r){t=`${t}.${s().replace(/-/g,"_")}`}t=this.trimIdIfRequired(t);this.setNewAppVariantId(t);return t};g.createAppVariant=function(e,t){t.version="1.0.0";return p.saveAs(Object.assign({selector:e},t))};g.getInlineChangeInput=function(e,t){return{type:"XTIT",maxLength:50,comment:t,value:{"":e}}};g.prepareTextsChange=function(e,t){var n=`New ${e} entered by a key user via RTA tool`;return this.getInlineChangeInput(t,n)};g.getInlineChangeInputIcon=function(e){return{content:{icon:e}}};g.prepareRemoveAllInboundsExceptOneChange=function(e){return{content:{inboundId:e}}};g.getInboundInfo=function(t){var n={};if(!t){n.currentRunningInbound="customer.savedAsAppVariant";n.addNewInboundRequired=true;return Promise.resolve(n)}return e.getUShellService("URLParsing").then(function(t){return e.getParsedURLHash(t)}).then(function(e){var r=Object.keys(t);var a=[];if(r.length===1&&r[0]==="customer.savedAsAppVariant"){return{currentRunningInbound:"customer.savedAsAppVariant",addNewInboundRequired:false}}r.forEach(function(n){if(t[n].action===e.action&&t[n].semanticObject===e.semanticObject){a.push(n)}});switch(a.length){case 0:n.currentRunningInbound="customer.savedAsAppVariant";n.addNewInboundRequired=true;break;case 1:[n.currentRunningInbound]=a;n.addNewInboundRequired=false;break;default:n.currentRunningInbound="customer.savedAsAppVariant";n.addNewInboundRequired=true;break}return n})};g.getInboundPropertiesKey=function(e,t,n){return`${e}_sap.app.crossNavigation.inbounds.${t}.${n}`};g.getInlineChangeForInboundPropertySaveAs=function(e,t){return{inboundId:e,entityPropertyChange:{propertyPath:"signature/parameters/sap-appvar-id",operation:"UPSERT",propertyValue:{required:true,filter:{value:t,format:"plain"},launcherValue:{value:t}}}}};g.prepareAddNewInboundChange=function(t,n,r){return e.getUShellService("URLParsing").then(function(t){return e.getParsedURLHash(t)}).then(function(e){var a={content:{inbound:{}},texts:{}};var i=this.getInboundPropertiesKey(r.referenceAppId,t,"title");var s=this.getInboundPropertiesKey(r.referenceAppId,t,"subTitle");a.content.inbound[t]={semanticObject:e.semanticObject,action:e.action,title:`{{${i}}}`,subTitle:`{{${s}}}`,icon:r.icon,signature:{parameters:{"sap-appvar-id":{required:true,filter:{value:n,format:"plain"},launcherValue:{value:n}}},additionalParameters:"ignored"}};a.texts[i]=this.prepareTextsChange("title",r.title);a.texts[s]=this.prepareTextsChange("subTitle",r.subTitle);return a}.bind(this))};g.prepareChangeInboundChange=function(e,t,n){var r={content:{},texts:{}};var a=this.getInboundPropertiesKey(n.referenceAppId,e,"title");var i=this.getInboundPropertiesKey(n.referenceAppId,e,"subTitle");r.content={inboundId:e,entityPropertyChange:[{propertyPath:"signature/parameters/sap-appvar-id",operation:"UPSERT",propertyValue:{required:true,filter:{value:t,format:"plain"},launcherValue:{value:t}}},{propertyPath:"title",operation:"UPSERT",propertyValue:`{{${a}}}`},{propertyPath:"subTitle",operation:"UPSERT",propertyValue:`{{${i}}}`},{propertyPath:"icon",operation:"UPSERT",propertyValue:n.icon}]};r.texts[a]=this.prepareTextsChange("title",n.title);r.texts[i]=this.prepareTextsChange("subTitle",n.subTitle);return r};g.createInlineChange=function(e,t,n){var r={changeType:t,content:e.content};if(e.texts){r.texts=e.texts}return c.create({changeSpecificData:r,selector:n})};g.addChangesToPersistence=function(e,t){u.add({flexObjects:e,selector:t});return Promise.resolve()};g.getTransportInput=function(e,t,n,r){return{getPackage(){return e},getNamespace(){return t},getId(){return n},getDefinition(){return{fileType:r}}}};g.triggerCatalogAssignment=function(e,t,n){return p.assignCatalogs({selector:{appId:e},action:"assignCatalogs",assignFromAppId:n,layer:t})};g.triggerCatalogUnAssignment=function(e,t){return p.unassignCatalogs({selector:{appId:e},action:"unassignCatalogs",layer:t})};g.isS4HanaCloud=function(e){return e.isAtoEnabled()&&e.isAtoAvailable()};g.copyId=function(e){var t=document.createElement("textarea");t.value=e;document.body.appendChild(t);t.select();document.execCommand("copy");document.body.removeChild(t);return true};g.getTextResources=function(){return i.getResourceBundleFor("sap.ui.rta")};g.getText=function(e,t){var n=this.getTextResources();return t?n.getText(e,[t]):n.getText(e)};g._getErrorMessageText=function(e){var t;if(e.messages&&e.messages.length){t=e.messages.map(function(e){return e.text}).join("\n")}else if(e.userMessage){t=e.userMessage}else if(e.iamAppId){t=`IAM App Id: ${e.iamAppId}`}else{t=e.stack||e.message||e.status||e}return t};g.buildErrorInfo=function(e,t,n){var r=this._getErrorMessageText(t);var a=`${g.getText(e)}\n\n`;if(n){a+=`${g.getText("MSG_APP_VARIANT_ID",n)}\n`}a+=g.getText("MSG_TECHNICAL_ERROR",r);o.error("App variant error: ",r);return{text:a,appVariantId:n,error:true}};g.buildSuccessInfo=function(e,t,n){var r=n?"CLOUD":"ON_PREMISE";var a=t?"":"_OVERVIEW_LIST";var i=n?undefined:e;var s=`${g.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE")}\n\n`;s+=g.getText(`SAVE_APP_VARIANT_SUCCESS_S4HANA_${r}_MESSAGE${a}`,i);return{text:s,appVariantId:e,copyId:!n}};g.buildFinalSuccessInfoS4HANACloud=function(){var e=g.getText("MSG_SAVE_APP_VARIANT_NEW_TILE_AVAILABLE");return{text:e}};g.buildDeleteSuccessMessage=function(e,t){var n=t?"DELETE_APP_VARIANT_SUCCESS_MESSAGE_CLOUD":"DELETE_APP_VARIANT_SUCCESS_MESSAGE";var r=g.getText(n,e);return{text:r}};g.showRelevantDialog=function(e,a){r.hide();var i;var s;var o;var u;var p=[];if(a){i=this.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE_TITLE");s=this.getText("SAVE_APP_VARIANT_OK_TEXT")}else{i=this.getText("HEADER_SAVE_APP_VARIANT_FAILED");s=this.getText("SAVE_APP_VARIANT_CLOSE_TEXT")}if(e&&e.copyId){u=this.getText("SAVE_APP_VARIANT_COPY_ID_TEXT");p.push(u)}else if(e&&e.deleteAppVariant){i=this.getText("DELETE_APP_VARIANT_INFO_MESSAGE_TITLE");o=this.getText("DELETE_APP_VARIANT_OK_TEXT");p.push(o);s=this.getText("DELETE_APP_VARIANT_CLOSE_TEXT")}p.push(s);return new Promise(function(r,c){var l=function(t){if(t===u){g.copyId(e.appVariantId)}if(a){r()}else if(e.overviewDialog){r(false)}else if(e.deleteAppVariant&&t===o){r()}else if(e.deleteAppVariant&&t===s){c(e.deleteAppVariant)}else if(e.error){c(e.error)}else{r()}};t.show(e.text,{icon:a||e.deleteAppVariant?t.Icon.INFORMATION:t.Icon.ERROR,onClose:l,title:i,actions:p,styleClass:n.getRtaStyleClassName()})})};g.closeOverviewDialog=function(){a.getInstance().publish("sap.ui.rta.appVariant.manageApps.controller.ManageApps","navigate")};g.navigateToFLPHomepage=function(){var t=e.getUshellContainer();var n;if(t){return t.getServiceAsync("AppLifeCycle").then(function(e){var r=e.getCurrentApplication();n=r.componentInstance;if(n){return t.getServiceAsync("CrossApplicationNavigation")}return undefined}).then(function(e){if(e&&e.toExternal){e.toExternal({target:{shellHash:"#"}},n)}}).catch(function(e){throw new Error(`Error navigating to FLP Homepage: ${e}`)})}return Promise.resolve()};g.deleteAppVariant=function(e,t){r.hide();return p.deleteAppVariant({selector:e,layer:t})};g.handleBeforeUnloadEvent=function(){return g.getText("MSG_DO_NOT_CLOSE_BROWSER")};g.showMessage=function(e){var t=g.getText(e);var n={text:t,copyId:false};return g.showRelevantDialog(n,true)};g.catchErrorDialog=function(e,t,n){r.hide();var a=g.buildErrorInfo(t,e,n);return g.showRelevantDialog(a,false)};return g},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/Feature", ["sap/ui/fl/Utils","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/core/BusyIndicator","sap/ui/core/EventBus","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/appVariant/AppVariantFactory","sap/ui/fl/write/api/FeaturesAPI","sap/base/util/merge"],function(e,n,r,a,t,i,s,o){"use strict";var u;var p;var c;var l;var v;var f=function(){return e.getAppDescriptor(c)};var h=function(){return t.getInstance()};var d=function(){window.onbeforeunload=v};var g=function(e){var r=e?"MSG_DO_NOT_CLOSE_BROWSER_CURRENTLY_ADAPTING":"MSG_DO_NOT_CLOSE_BROWSER";v=window.onbeforeunload;window.onbeforeunload=n.handleBeforeUnloadEvent;return n.showMessage(r)};var A=function(e,n){return p.triggerCatalogPublishing(e,n,true)};var w=function(e){return p.triggerCatalogPublishing(e,null,false)};var b=function(e,a){if(u){n.closeOverviewDialog();return this.onGetOverview(true,a)}else if(!u&&e){r.hide();return this.onGetOverview(true,a)}return Promise.resolve()};var S=function(e,r,a){return e?n.navigateToFLPHomepage():b.call(this,!r,a)};var I=function(e,n){if(e&&e.response&&e.response.IAMId){return p.notifyKeyUserWhenPublishingIsReady(e.response.IAMId,n,true)}return Promise.resolve()};var m=function(e,n){if(e&&e.response&&e.response.IAMId&&e.response.inProgress){return p.notifyKeyUserWhenPublishingIsReady(e.response.IAMId,n,false)}return Promise.resolve()};a.getInstance().subscribe("sap.ui.rta.appVariant.manageApps.controller.ManageApps","navigate",function(){if(u){u.destroy();u=null}});return{onGetOverview(e,r){var a=f();return new Promise(function(t){var i=function(){n.closeOverviewDialog()};var s="sap/ui/rta/appVariant/AppVariantOverviewDialog";var o={idRunningApp:a["sap.app"].id,isOverviewForKeyUser:e,layer:r};sap.ui.require([s],function(e){u||=new e(o);u.attachCancel(i);u.oPopup.attachOpened(function(){t(u)});u.open()})})},isOverviewExtended(){var e=new URLSearchParams(window.location.search);var n=e.get("sap-ui-xx-app-variant-overview-extended");if(!n){return false}return n.toLowerCase()==="true"},isManifestSupported(){var e=f();return n.getManifirstSupport(e["sap.app"].id)},isSaveAsAvailable(e,r,a){c=e;l=a;var t=f();if(t["sap.app"]&&t["sap.app"].id){return s.isSaveAsAvailable(r).then(function(e){if(e){if(t["sap.app"].crossNavigation&&t["sap.app"].crossNavigation.inbounds){return n.getInboundInfo(t["sap.app"].crossNavigation.inbounds)}return n.getInboundInfo()}return undefined}).then(function(e){return!!e})}return Promise.resolve(false)},getAppVariantDescriptor(e){c=e;var n=f();if(n["sap.app"]&&n["sap.app"].id){return i.load({id:n["sap.app"].id})}return Promise.resolve(false)},_determineSelector(e,n){return e?c:{appId:n["sap.app"].id,appVersion:n["sap.app"].applicationVersion.version}},onSaveAs(a,t,i,s){var u;var c;var v=f();var w=true;if(s&&s["sap.app"].id===v["sap.app"].id){t=true;v=o({},s);s=null}else if(s){w=false;v=o({},s);s=null}var b=this._determineSelector(w,v);return new Promise(function(s){var f=function(){return p.processSaveAsDialog(v,a)};var w=function(e){r.show();return p.createAllInlineChanges(e,b)};var m=function(e){var r=e.slice();return n.addChangesToPersistence(r,b)};var P=function(){var e=n.getNewAppVariantId();return p.createAppVariant(e,b).catch(function(r){var a=r.messageKey;a||="MSG_SAVE_APP_VARIANT_FAILED";return n.catchErrorDialog(r,a,e)})};var O=function(e){c=null;c=o({},e.response);return p.clearRTACommandStack(t)};var _=function(){var n=e.getUshellContainer();if(n&&t){n.setDirtyFlag(false)}};var D=function(e){_();u=n.isS4HanaCloud(e);var r=n.buildSuccessInfo(c.id,a,u);return p.showSuccessMessage(r)};var V=function(){var e=n.buildFinalSuccessInfoS4HANACloud();return p.showSuccessMessage(e)};var M=function(){r.show();if(u){var e;return g().then(function(){return A(c.id,c.reference)}).then(function(n){e=Object.assign({},n);r.hide();return S.call(this,a,null,i)}.bind(this)).then(function(){return I(e,c.id)}).then(function(){d();return V()}).then(function(){return a?s():S.call(this,a,u,i)}.bind(this))}r.hide();return S.call(this,a,u,i)};sap.ui.require(["sap/ui/rta/appVariant/AppVariantManager"],function(e){p||=new e({commandSerializer:l,layer:i});return f().then(w).then(m).then(P).then(O).then(h).then(D).then(M.bind(this)).then(s).catch(function(e){if(!e){return false}if(u){d()}return S.call(this,null,u,i).then(s)}.bind(this))}.bind(this))}.bind(this))},onDeleteFromOverviewDialog(e,a,t){var i;return new Promise(function(s){sap.ui.require(["sap/ui/rta/appVariant/AppVariantManager"],function(o){p||=new o({rootControl:c,commandSerializer:l,layer:t});var u=function(){return p.deleteAppVariant(e).catch(function(r){if(r==="cancel"){return Promise.reject("cancel")}var a=r.messageKey;a||="MSG_DELETE_APP_VARIANT_FAILED";return n.catchErrorDialog(r,a,e)})};var v=function(){n.closeOverviewDialog();var r=n.buildDeleteSuccessMessage(e,i);return p.showSuccessMessage(r)};var f=function(s){i=n.isS4HanaCloud(s);if(i){var o;return g(a).then(function(){return w(e)}).then(function(e){o=Object.assign({},e);return b.call(this,!a,t)}.bind(this)).then(function(){return m(o,e)})}r.show();return Promise.resolve()};var A=function(){if(i){d()}r.hide();return a?s():b.call(this,!i,i,t).then(s)};if(a){n.closeOverviewDialog();n.navigateToFLPHomepage()}return h().then(f.bind(this)).then(u).then(v).then(A.bind(this)).catch(function(e){if(e==="cancel"){return false}if(i){d()}return b.call(this,null,i,t).then(s)}.bind(this))}.bind(this))}.bind(this))}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/S4HanaCloudBackend", ["sap/ui/base/ManagedObject","sap/ui/model/odata/v2/ODataModel","sap/base/Log"],function(t,a,e){"use strict";var n;var r=t.extend("sap.ui.rta.appVariant.S4HanaCloudBackend",{metadata:{library:"sap.ui.rta"},constructor:function(...a){t.apply(this,a)}});r.prototype.notifyFlpCustomizingIsReady=function(t,a,n,r){var i=this;return new Promise(function(o,u){function s(t){return!isNaN(parseFloat(t))&&isFinite(t)}var c=s(n)?n:2500;var d=s(r)?r:-1;function p(){if(d===0){o({iamAppId:t,customizingIsReady:false});return}else if(d>0){d=d-1}this.checkCatalogCustomizingIsReady(t,a).then(function(a){if(a){o({iamAppId:t,customizingIsReady:true})}else{setTimeout(p.bind(i),c)}}).catch(function(n){var r=a?"creation":"deletion";e.error(`Catalog publishing failed for app variant ${r}. AppVarStatus is ${n.message}`);u({iamAppId:t,error:n.message})})}setTimeout(p.bind(i),c)})};r._isAppReady=function(t,a){var e=t.data.results;if(!Array.isArray(e)){throw new Error(`${t.requestUri} returned unexpected result: ${t}`)}var n=e.every(function(t){return t.ActualStatus===1});var r=e.every(function(t){return t.ActualStatus===2});var i=e.some(function(t){return t.ActualStatus===5});var o=e.some(function(t){return t.ActualStatus===4});if(i||o){var u=i?"error":"locked";throw new Error(u)}return a?r:n};r._getODataModel=function(){n||=new Promise(function(t,e){var r=new a("/sap/opu/odata/sap/APS_IAM_APP_SRV");r.attachMetadataFailed(function(t){e(t);n=null});r.metadataLoaded().then(function(){t(r)})});return n};r._readODataModel=function(t,a){return new Promise(function(e,n){var r=function(t,a){e(a)};var i=function(t){n(t)};t.read(`/aps_iam_app_ddl('${a}')/to_BusinessCatalogAssignment`,{success:r,error:i})})};r.prototype.checkCatalogCustomizingIsReady=function(t,a){return r._getODataModel().then(function(a){return r._readODataModel(a,t)}).then(function(t){return r._isAppReady(t,a)})};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/Utils", ["sap/ui/rta/appVariant/AppVariantUtils","sap/ui/fl/registry/Settings","sap/ui/fl/Utils","sap/base/i18n/ResourceBundle","sap/ui/fl/write/api/AppVariantWriteAPI","sap/ui/core/IconPool"],function(t,e,a,i,r,n){"use strict";var s={};var p=`${sap.ui.require.toUrl("sap/ui/rta/appVariant/manageApps/")}webapp`;var u=i.create({url:`${p}/i18n/i18n.properties`});s._checkNavigationSupported=function(t){var e=a.getUshellContainer();return e.getServiceAsync("CrossApplicationNavigation").then(function(e){return e.getLinks(t)}).catch(function(t){throw new Error(`Error retrieving ushell service CrossApplicationNavigation: ${t}`)})};s._checkAppType=function(t,e){if(t&&e){return u.getText("MAA_ORIGINAL_TYPE")}else if(e){return u.getText("MAA_APP_VARIANT_TYPE")}else if(t){return u.getText("MAA_ORIGINAL_TYPE")}return undefined};s._calculateCurrentStatus=function(e,a){var i=t.getNewAppVariantId();if(a==="R"){return u.getText("MAA_OPERATION_IN_PROGRESS")}else if(i===e){t.setNewAppVariantId(null);if(a!=="E"){return u.getText("MAA_NEW_APP_VARIANT")}}};s._checkMenuItemOptions=function(t,e){var a={};if(t.isKeyUser){if(t.isOriginal){a.delAppVarButtonVisibility=false;a.adaptUIButtonVisibility=false;return a}if(t.appVarStatus==="U"||t.appVarStatus==="E"||t.appVarStatus==="R"){a.saveAsButtonEnabled=false}a.adaptUIButtonVisibility=true;if(e){if(t.isS4HanaCloud){a.delAppVarButtonEnabled=true;a.delAppVarButtonVisibility=true}else{a.delAppVarButtonEnabled=false;a.delAppVarButtonVisibility=true}}else{a.delAppVarButtonVisibility=true;if(t.appVarStatus==="R"){a.delAppVarButtonEnabled=false}else{a.delAppVarButtonEnabled=true}}}else{a.delAppVarButtonVisibility=false;a.adaptUIButtonVisibility=false}return a};s._getNavigationInfo=function(t){var e={};var a=t.startWith.semanticObject;var i=t.startWith.action;var r=t.startWith.parameters;var n={semanticObject:a,action:i,params:r};return this._checkNavigationSupported(n).then(function(n){var s;if(n.length&&t.isKeyUser){e.adaptUIButtonEnabled=true;if(t.appVarStatus==="R"||t.appVarStatus==="U"||t.appVarStatus==="E"){e.adaptUIButtonEnabled=false;e.appVarStatus=t.appVarStatus}}else{e.adaptUIButtonEnabled=false}s=this._checkMenuItemOptions(t,e.adaptUIButtonEnabled);e.semanticObject=a;e.action=i;if(r){Object.keys(r).forEach(function(t){if(r[t].value){r[t]=r[t].value}});e.params=r}e=Object.assign({},e,s);return e}.bind(this))};s._prepareAppVariantAttributes=function(t){return{appId:t.appId,title:t.title||"",subTitle:t.subTitle||"",description:t.description||"",icon:t.iconUrl||"",iconText:t.iconText,isOriginal:t.isOriginal,isAppVariant:t.isAppVariant,descriptorUrl:t.descriptorUrl,appVarStatus:t.appVarStatus}};s.getAppVariantOverviewAttributes=function(a,i){var r;var s=a.iconUrl;if(s&&n.isIconURI(s)){a.iconText=s.split("//")[1]}r=this._prepareAppVariantAttributes(a);r.isKeyUser=i;r.typeOfApp=this._checkAppType(a.isOriginal,a.isAppVariant);r.currentStatus=this._calculateCurrentStatus(a.appId,a.appVarStatus);var p;return e.getInstance().then(function(e){p=t.isS4HanaCloud(e);r.isS4HanaCloud=p;var n={isKeyUser:i,isOriginal:a.isOriginal,isS4HanaCloud:p,appVarStatus:a.appVarStatus};if(a.hasStartableIntent){n.startWith=a.startWith;return this._getNavigationInfo(n).then(function(t){r=Object.assign({},r,t);return r})}r.adaptUIButtonEnabled=false;var s=this._checkMenuItemOptions(n,false);r=Object.assign({},r,s);return Promise.resolve(r)}.bind(this))};s.getAppVariantOverview=function(t,e){var a=e?"CUSTOMER*":"VENDOR";var i={selector:{appId:t},layer:a};return r.listAllAppVariants(i).then(function(t){var a=[];var i;if(t.response&&t.response.items){i=t.response.items}else{return Promise.resolve([])}i.forEach(function(t){if(!t.isDescriptorVariant){a.push(this.getAppVariantOverviewAttributes(t,e))}},this);return Promise.all(a).then(function(t){return t})}.bind(this))};s.getDescriptor=function(t){return r.getManifest(t).then(function(t){return t.response})};return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/manageApps/webapp/Component", ["sap/ui/core/UIComponent"],function(e){"use strict";var t;var r;var i;return e.extend("sap.ui.rta.appVariant.manageApps.webapp.Component",{metadata:{manifest:"json",library:"sap.ui.rta",version:"0.9",properties:{idRunningApp:"string",isOverviewForKeyUser:{type:"boolean"},layer:"string"}},constructor:function(...n){t=n[1].idRunningApp;r=n[1].isOverviewForKeyUser;i=n[1].layer;e.prototype.constructor.apply(this,n)},init(...n){this.setIdRunningApp(t);this.setIsOverviewForKeyUser(r);this.setLayer(i);e.prototype.init.apply(this,n)}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/manageApps/webapp/controller/ManageApps.controller", ["sap/ui/core/mvc/Controller","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/rta/appVariant/manageApps/webapp/model/models","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/rta/appVariant/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/rta/appVariant/Feature","sap/ui/rta/RuntimeAuthoring","sap/ui/core/BusyIndicator","sap/base/i18n/ResourceBundle","sap/m/MessageToast","sap/m/MenuItem"],function(e,t,r,n,a,i,o,s,u,p,A,g,l,_){"use strict";var c;var T;var d;var h;var f;var I;return e.extend("sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps",{onInit(){c=this.getOwnerComponent().getIdRunningApp();T=this.getOwnerComponent().getIsOverviewForKeyUser();d=this.getOwnerComponent().getLayer();var e=r.getUshellContainer();if(!I){this._createResourceBundle()}A.show();return Promise.resolve().then(function(){if(e){return e.getServiceAsync("CrossApplicationNavigation").then(function(e){h=e})}return undefined}).then(i.getAppVariantOverview.bind(i,c,T)).then(function(e){A.hide();if(e.length){return this._arrangeOverviewDataAndBindToModel(e).then(function(e){return this._highlightNewCreatedAppVariant(e)}.bind(this))}a.closeOverviewDialog();return this._showMessageWhenNoAppVariantsExist()}.bind(this)).catch(function(e){a.closeOverviewDialog();var t=a.buildErrorInfo("MSG_MANAGE_APPS_FAILED",e);t.overviewDialog=true;A.hide();return a.showRelevantDialog(t,false)})},_createResourceBundle(){f=`${sap.ui.require.toUrl("sap/ui/rta/appVariant/manageApps/")}webapp`;I=g.create({url:`${f}/i18n/i18n.properties`})},_showMessageWhenNoAppVariantsExist(){return s.showMessageBox(o.Icon.INFORMATION,"MSG_APP_VARIANT_OVERVIEW_SAP_DEVELOPER",{titleKey:"TITLE_APP_VARIANT_OVERVIEW_SAP_DEVELOPER"})},_highlightNewCreatedAppVariant(e){var t=this.byId("Table1");t.focus();e.forEach(function(e,r){if(e.currentStatus===I.getText("MAA_NEW_APP_VARIANT")||e.currentStatus===I.getText("MAA_OPERATION_IN_PROGRESS")){if(t.getItems().length>=r){t.getItems()[r].focus()}}});return Promise.resolve()},_arrangeOverviewDataAndBindToModel(e){var t=e.filter(function(e){return e.appId===c});var r=t[0];if(r&&r.appVarStatus!=="R"){r.currentStatus=I.getText("MAA_CURRENTLY_ADAPTING")}e=e.filter(function(e){return e.appId!==c});e.unshift(r);var a=e.filter(function(e){return e.isOriginal});var i=a[0];e=e.filter(function(e){return!e.isOriginal});e.unshift(i);var o={appVariants:e};var s=n.createModel(o);this.getView().setModel(s);return Promise.resolve(e)},formatRowHighlight(e){if(e===I.getText("MAA_CURRENTLY_ADAPTING")){return"Success"}else if(e===I.getText("MAA_NEW_APP_VARIANT")){return"Information"}else if(e===I.getText("MAA_OPERATION_IN_PROGRESS")){return"Warning"}return"None"},formatDelButtonTooltip(e,t){if(!I){this._createResourceBundle()}if(!e&&!t){return I.getText("TOOLTIP_DELETE_APP_VAR")}return undefined},formatAdaptUIButtonTooltip(e,t){if(!I){this._createResourceBundle()}if(!e){switch(t){case"R":return I.getText("TOOLTIP_ADAPTUI_STATUS_RUNNING");case"U":return I.getText("TOOLTIP_ADAPTUI_STATUS_UNPBLSHD_ERROR");case"E":return I.getText("TOOLTIP_ADAPTUI_STATUS_UNPBLSHD_ERROR");case"P":return I.getText("TOOLTIP_ADAPTUI_STATUS_PUBLISHED");case undefined:return I.getText("TOOLTIP_ADAPTUI_ON_PREMISE");default:}}},formatAdaptUIButtonVisibility(e,t){return e&&t},getModelProperty(e,t){return this.getView().getModel().getProperty(e,t)},onMenuAction(e){var t=e.getParameter("item");var r="";while(t instanceof _){r=`${t.getText()} > ${r}`;t=t.getParent()}r=r.substr(0,r.lastIndexOf(" > "));if(!I){this._createResourceBundle()}if(r===I.getText("MAA_DIALOG_ADAPT_UI")){return this.handleUiAdaptation(e)}else if(r===I.getText("MAA_DIALOG_COPY_ID")){return this.copyId(e)}else if(r===I.getText("MAA_DIALOG_DELETE_APPVAR")){return this.deleteAppVariant(e)}return undefined},handleUiAdaptation(e){var r=this.getModelProperty("semanticObject",e.getSource().getBindingContext());var n=this.getModelProperty("action",e.getSource().getBindingContext());var i=this.getModelProperty("params",e.getSource().getBindingContext());var o;if(r&&n&&i){o={target:{semanticObject:r,action:n},params:i,writeHistory:false};p.enableRestart(t.CUSTOMER);if(h){h.toExternal(o)}a.closeOverviewDialog();return true}return false},copyId(e){var t=this.getModelProperty("appId",e.getSource().getBindingContext());a.copyId(t);l.show(I.getText("MAA_COPY_ID_SUCCESS"))},deleteAppVariant(e){var t={};if(!I){this._createResourceBundle()}var r=I.getText("MSG_APP_VARIANT_DELETE_CONFIRMATION");t.text=r;t.deleteAppVariant=true;var n=this.getModelProperty("appId",e.getSource().getBindingContext());var i=this.getModelProperty("currentStatus",e.getSource().getBindingContext());var o=i===I.getText("MAA_CURRENTLY_ADAPTING");return a.showRelevantDialog(t).then(function(){return u.onDeleteFromOverviewDialog(n,o,d)}).catch(function(){return true})}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/manageApps/webapp/model/models", ["sap/ui/model/json/JSONModel"],function(e){"use strict";return{createModel(n){var t=new e(n);t.setDefaultBindingMode("OneWay");return t}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/AddIFrame", ["sap/ui/rta/command/FlexCommand"],function(t){"use strict";var e=t.extend("sap.ui.rta.command.AddIFrame",{metadata:{library:"sap.ui.rta",properties:{baseId:{type:"string",group:"content"},targetAggregation:{type:"string",group:"content"},index:{type:"int",group:"content"},url:{type:"string",group:"content"},width:{type:"string",group:"content"},height:{type:"string",group:"content"},title:{type:"string",group:"content"},useLegacyNavigation:{type:"boolean",defaultValue:false,group:"content"},advancedSettings:{type:"object",defaultValue:{},group:"content"},changeType:{type:"string",defaultValue:"addIFrame"}},associations:{},events:{}}});e.prototype.applySettings=function(...e){const n=e[0];var a={};Object.keys(n).filter(function(t){return t!=="url"}).forEach(function(t){a[t]=n[t]});e[0]=a;t.prototype.applySettings.apply(this,e);this.setUrl(n.url)};e.prototype._getChangeSpecificData=function(){var e=t.prototype._getChangeSpecificData.call(this);var n=e.changeType;delete e.changeType;return{changeType:n,content:e}};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/AddProperty", ["sap/ui/rta/command/FlexCommand"],function(t){"use strict";var e=t.extend("sap.ui.rta.command.AddProperty",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int"},newControlId:{type:"string"},bindingString:{type:"string"},entityType:{type:"string"},parentId:{type:"string"},oDataServiceVersion:{type:"string"},oDataServiceUri:{type:"string"},modelType:{type:"string"},relevantContainerId:{type:"string"},propertyName:{type:"string"}}}});e.prototype._getChangeSpecificData=function(){return{changeType:this.getChangeType(),index:this.getIndex(),newControlId:this.getNewControlId(),bindingPath:this.getBindingString(),parentId:this.getParentId(),modelType:this.getModelType(),relevantContainerId:this.getRelevantContainerId(),oDataServiceVersion:this.getODataServiceVersion(),oDataInformation:{oDataServiceUri:this.getODataServiceUri(),propertyName:this.getPropertyName(),entityType:this.getEntityType()}}};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/AddXML", ["sap/ui/rta/command/FlexCommand"],function(t){"use strict";var e=t.extend("sap.ui.rta.command.AddXML",{metadata:{library:"sap.ui.rta",properties:{fragment:{type:"string",group:"content"},fragmentPath:{type:"string",group:"content"},targetAggregation:{type:"string",group:"content"},index:{type:"int",group:"content"},changeType:{type:"string",defaultValue:"addXML"}},associations:{},events:{}}});e.prototype.bindProperty=function(...e){const[n,r]=e;if(n==="fragment"){return this.setFragment(r.bindingString)}return t.prototype.bindProperty.apply(this,e)};e.prototype._applyChange=function(...e){const n=e[0];var r={};r[n.getFlexObjectMetadata().moduleName]=this.getFragment();sap.ui.require.preload(r);return t.prototype._applyChange.apply(this,e)};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/AddXMLAtExtensionPoint", ["sap/ui/rta/command/FlexCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/api/ExtensionPointRegistryAPI","sap/ui/fl/Utils"],function(e,t,n,r,i){"use strict";var o=e.extend("sap.ui.rta.command.AddXMLAtExtensionPoint",{metadata:{library:"sap.ui.rta",properties:{fragment:{type:"string",group:"content"},fragmentPath:{type:"string",group:"content"},changeType:{type:"string",defaultValue:"addXMLAtExtensionPoint"}},associations:{},events:{}}});o.prototype.bindProperty=function(...t){const[n,r]=t;if(n==="fragment"){return this.setFragment(r.bindingString)}return e.prototype.bindProperty.apply(this,t)};o.prototype.getAppComponent=function(){var e=this.getSelector().view;return i.getAppComponentForControl(e)};o.prototype._applyChange=function(e){var i={};i[e.getFlexObjectMetadata().moduleName]=this.getFragment();sap.ui.require.preload(i);var o=e.change||e;var a=this.getAppComponent();var p=o.getSelector();var s=t.bySelector(p.viewSelector,a);var u=r.getExtensionPointInfo({name:p.name,view:s});var g=u.targetControl;o.setExtensionPointInfo(u);var c={modifier:t,appComponent:a,view:s};return n.apply(Object.assign({change:o,element:g},c)).then(function(e){if(!e.success){return Promise.reject(e.error)}return undefined})};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/AppDescriptorCommand", ["sap/ui/rta/command/BaseCommand","sap/ui/fl/write/_internal/appVariant/AppVariantInlineChangeFactory","sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory"],function(e,t,r){"use strict";var n=e.extend("sap.ui.rta.command.AppDescriptorCommand",{metadata:{library:"sap.ui.rta",properties:{reference:{type:"string"},appComponent:{type:"object"},layer:{type:"string"},changeType:{type:"string"},parameters:{type:"object"},texts:{type:"object"}},events:{}}});n.prototype.needsReload=true;n.prototype.prepare=function(e){this.setLayer(e.layer);return true};n.prototype.getPreparedChange=function(){return this._oPreparedChange};n.prototype.setCompositeId=function(e){this._sCompositeId=e};n.prototype.createAndStoreChange=function(){return t.createDescriptorInlineChange({changeType:this.getChangeType(),content:this.getParameters(),texts:this.getTexts(),support:{compositeCommand:this._sCompositeId||""}}).then(function(e){return(new r).createNew(this.getReference(),e,this.getLayer(),this.getAppComponent(),"sap.ui.rta.AppDescriptorCommand")}.bind(this)).then(function(e){var t=e.store();this._oPreparedChange=t}.bind(this))};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/BaseCommand", ["sap/ui/base/ManagedObject","sap/ui/core/Element"],function(e,t){"use strict";var n=e.extend("sap.ui.rta.command.BaseCommand",{metadata:{library:"sap.ui.rta",properties:{name:{type:"string"},runtimeOnly:{type:"boolean"},relevantForSave:{type:"boolean",defaultValue:true}},associations:{element:{type:"sap.ui.core.Element"}},events:{}}});n.prototype.getElement=function(){var e=this.getAssociation("element");return t.getElementById(e)};n.prototype.prepare=function(){return true};n.prototype.execute=function(){return Promise.resolve()};n.prototype.getVariantChange=function(){return this._oVariantChange};n.prototype.undo=function(){return Promise.resolve()};n.prototype.isEnabled=function(){return true};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/BindProperty", ["sap/ui/rta/command/FlexCommand"],function(e){"use strict";var t=e.extend("sap.ui.rta.command.BindProperty",{metadata:{library:"sap.ui.rta",properties:{propertyName:{type:"string"},newBinding:{type:"string"},changeType:{type:"string",defaultValue:"propertyBindingChange"}},associations:{},events:{}}});t.prototype.bindProperty=function(...t){const[n,i]=t;if(n==="newBinding"){return this.setNewBinding(i.bindingString)}return e.prototype.bindProperty.apply(this,t)};t.prototype._getChangeSpecificData=function(){var e=this.getElement();var t={changeType:this.getChangeType(),selector:{id:e.getId(),type:e.getMetadata().getName()},content:{property:this.getPropertyName(),newBinding:this.getNewBinding()}};return t};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Combine", ["sap/ui/rta/command/FlexCommand"],function(e){"use strict";var t=e.extend("sap.ui.rta.command.Combine",{metadata:{library:"sap.ui.rta",properties:{newElementId:{type:"string"},source:{type:"any"},combineElements:{type:"any[]"}},associations:{},events:{}}});t.prototype._getChangeSpecificData=function(){var e=[];this.getCombineElements().forEach(function(t){e.push(t.getId())});var t={newElementId:this.getNewElementId(),changeType:this.getChangeType(),sourceControlId:this.getSource().getId(),combineElementIds:e};return t};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/CommandFactory", ["sap/base/util/merge","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/Layer"],function(e,t,n,a,r,i,o,m,c){"use strict";function d(e){var t=r.getAggregationInformation(e.getElement());if(t.elementId){var n=i.getOverlay(t.elementId);var a=n.getParentElementOverlay();var m=a?!!r.getAggregationInformation(a.getElement()).templateId:false;if(m){throw o.createError("CommandFactory#evaluateTemplateBinding","Multiple template bindings are not supported","sap.ui.rta")}var c=r.extractTemplateId(t);if(c){return{templateSelector:t.elementId,originalSelector:c,content:{boundAggregation:t.aggregation}}}}return undefined}function l(e,t){var n=typeof e==="string"?a.getElementById(e):e;var o=i.getOverlay(n);if(o){var m=r.getAggregationInformation(n);if(typeof t==="number"){m.stack[0].index=t}return r.extractTemplateId(m)}return n.getId()}function u(e){if(!e){throw new Error("adjustment for template failed")}}function s(e,n){var a;var r=false;var i=false;if(typeof n==="string"){a=n}else if(n){a=n.changeType;r=n.jsOnly===true;i=n.CAUTION_variantIndependent===true}if(!a){return false}e.setChangeType(a);e.setJsOnly(r);if(e.setVariantIndependent){e.setVariantIndependent(i)}else if(i){t.error("the variant independent Flag is not available for the action",a)}return true}function g(e,t,n){var a;if(n){a=n.getAction(t.name,e)}var r=a||{};Object.assign(r,{changeType:t.name});return r}function p(e){e.element=a.getElementById(l(e.element));u(e.element)}function f(e,t,n){var r=t.element||a.getElementById(t.element.id);var i=n.getActionDataFromAggregations("createContainer",r)[0];return i}function v(e){e.element=a.getElementById(l(e.element));u(e.element);e.parentId=l(e.parentId);u(e.parentId)}function y(e,t,n){var r=t.movedElements[0].element||a.getElementById(t.movedElements[0].id);var i=n.getAction("move",r);return i}function z(e){var t=e.movedElements.map(function(e){var t=a.getElementById(l(e.element,e.sourceIndex));u(t);return t});e.movedElements.forEach(function(e,n){e.element=t[n]});e.element=a.getElementById(l(e.element));u(e.element);e.source.parent=a.getElementById(l(e.source.parent));u(e.source.parent);e.target.parent=a.getElementById(l(e.target.parent));u(e.target.parent)}function E(e,t,n){return n.getAction("localReset",e)}function I(e,t,n){var a=t.renamedElement;var r=n.getAction("rename",a);return r}function C(e){e.element=a.getElementById(l(e.element));u(e.element);e.renamedElement=a.getElementById(l(e.renamedElement));u(e.renamedElement)}function B(e,t,a){var r=t.removedElement;if(!r){r=e}else if(!(r instanceof n)){throw new Error("No valid 'removedElement' found")}var i=a.getAction("remove",r);return i}function A(e){e.element=a.getElementById(l(e.element));u(e.element);e.removedElement=a.getElementById(l(e.removedElement));u(e.removedElement)}function h(e,t,n){var a=t.source;var r=n.getAction("combine",a);return r}function F(e){e.element=a.getElementById(l(e.element));u(e.element);e.source=a.getElementById(l(e.source));u(e.source);var t=e.combineElements.map(function(e){e=a.getElementById(l(e));u(e);return e});e.combineElements=t}function b(e,t,n){var a=t.source;var r=n.getAction("split",a);return r}function j(e){e.element=a.getElementById(l(e.element));u(e.element);e.parentElement=a.getElementById(l(e.parentElement));u(e.parentElement);e.source=a.getElementById(l(e.source));u(e.source)}function S(e,t,n){var a=t.element;return n.getAction("add",a,"delegate")}function O(e){e.element=a.getElementById(l(e.element));u(e.element);e.parentId=l(e.parentId);u(e.parentId)}function V(e,t,n){var a=t.element;var r=n.getAction("reveal",a);return r}function P(e){e.element=a.getElementById(l(e.element));u(e.element);if(e.revealedElementId){e.revealedElementId=l(e.revealedElementId);u(e.revealedElementId)}if(e.directParent){e.directParent=a.getElementById(l(e.directParent));u(e.directParent)}}function R(e,t,n){var a=n.getAction("add",t.element);if(a&&a.custom&&typeof a.custom.getItems==="function"){var r=Object.assign(a.custom,{changeOnRelevantContainer:t.changeOnRelevantContainer,changeType:t.changeType});delete t.changeOnRelevantContainer;return r}return undefined}function x(e,t,n){return n.getAction("addIFrame",t.element)||n.getActionDataFromAggregations("addIFrame",t.element)[0]}function T(){return"propertyBindingChange"}function w(){return"propertyChange"}var L={composite:{clazz:"sap/ui/rta/command/CompositeCommand",noSelector:true},property:{clazz:"sap/ui/rta/command/Property",adjustForBinding:p,configure:w},bindProperty:{clazz:"sap/ui/rta/command/BindProperty",configure:T},addXML:{clazz:"sap/ui/rta/command/AddXML",configure:g,adjustForBinding:p},addXMLAtExtensionPoint:{clazz:"sap/ui/rta/command/AddXMLAtExtensionPoint",configure:g,adjustForBinding:p},createContainer:{clazz:"sap/ui/rta/command/CreateContainer",configure:f,adjustForBinding:v},move:{clazz:"sap/ui/rta/command/Move",configure:y,adjustForBinding:z},remove:{clazz:"sap/ui/rta/command/Remove",configure:B,adjustForBinding:A},localReset:{clazz:"sap/ui/rta/command/LocalReset",configure:E},rename:{clazz:"sap/ui/rta/command/Rename",configure:I,adjustForBinding:C},addDelegateProperty:{clazz:"sap/ui/rta/command/AddProperty",configure:S,adjustForBinding:O},reveal:{clazz:"sap/ui/rta/command/Reveal",configure:V,adjustForBinding:P},customAdd:{clazz:"sap/ui/rta/command/CustomAdd",configure:R},combine:{clazz:"sap/ui/rta/command/Combine",configure:h,adjustForBinding:F},split:{clazz:"sap/ui/rta/command/Split",configure:b,adjustForBinding:j},resize:{clazz:"sap/ui/rta/command/Resize"},switch:{clazz:"sap/ui/rta/command/ControlVariantSwitch"},save:{clazz:"sap/ui/rta/command/ControlVariantSave"},saveAs:{clazz:"sap/ui/rta/command/ControlVariantSaveAs"},setTitle:{clazz:"sap/ui/rta/command/ControlVariantSetTitle"},configure:{clazz:"sap/ui/rta/command/ControlVariantConfigure"},settings:{clazz:"sap/ui/rta/command/Settings"},addLibrary:{clazz:"sap/ui/rta/command/appDescriptor/AddLibrary",noSelector:true},appDescriptor:{clazz:"sap/ui/rta/command/AppDescriptorCommand",noSelector:true},addIFrame:{clazz:"sap/ui/rta/command/AddIFrame",configure:x},compVariantContent:{clazz:"sap/ui/rta/command/compVariant/CompVariantContent"},compVariantSaveAs:{clazz:"sap/ui/rta/command/compVariant/CompVariantSaveAs"},compVariantSwitch:{clazz:"sap/ui/rta/command/compVariant/CompVariantSwitch"},compVariantUpdate:{clazz:"sap/ui/rta/command/compVariant/CompVariantUpdate"}};function M(t,a,r,m,c,l){var u;a=a[0].toLowerCase()+a.slice(1);var g=L[a];var p=c;if(!g){return Promise.reject(o.createError("CommandFactory#getCommandFor",`Command '${a}' doesn't exist, check typing`,"sap.ui.rta"))}return new Promise(function(e){var t=g.clazz;sap.ui.require([t],function(t){e(t)})}).then(function(o){var c=t instanceof n;if(!g.noSelector){r=Object.assign({},r,!c&&{selector:t})}r=Object.assign({},r,{element:c?t:undefined,name:a});var f;if(g.configure){f=g.configure(t,r,m)}var v;if(c){v=i.getOverlay(t)}if(f&&f.changeOnRelevantContainer){Object.assign(r,{element:v.getRelevantContainer()});t=r.element;v=i.getOverlay(t)}var y;if(v&&t.sParentAggregationName){y=d(v)}if(y){if(g.adjustForBinding){g.adjustForBinding(r)}p=e(y,p)}u=new o(r);var z=true;if(g.configure){z=s(u,f)}if(z){return u.prepare(p,l,a)}return undefined}).then(function(e){if(e){return u}u.destroy();return undefined})}var U=n.extend("sap.ui.rta.command.CommandFactory",{metadata:{library:"sap.ui.rta",properties:{flexSettings:{type:"object"}}}});U.prototype.init=function(){this.setProperty("flexSettings",{layer:c.CUSTOMER,developerMode:true})};U.prototype.setFlexSettings=function(e){this.setProperty("flexSettings",Object.assign(this.getFlexSettings(),e))};U.prototype.getCommandFor=function(e,t,n,a,r){return M(e,t,n,a,this.getFlexSettings(),r)};U.getCommandFor=function(e,t,n,a,r){r||={layer:c.CUSTOMER,developerMode:true};if(r.scenario||r.baseId){var i=m.buildLrepRootNamespace(r.baseId,r.scenario,r.projectId);r.rootNamespace=i;r.namespace=`${i}changes/`}return M(e,t,n,a,r)};return U},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/CompositeCommand", ["sap/ui/rta/command/BaseCommand","sap/ui/rta/command/FlexCommand","sap/ui/fl/Utils"],function(t,e,o){"use strict";var n=t.extend("sap.ui.rta.command.CompositeCommand",{metadata:{library:"sap.ui.rta",properties:{},aggregations:{commands:{type:"sap.ui.rta.command.BaseCommand",multiple:true}},events:{}}});n.prototype.execute=function(){var t=[];this._forEachCommand(function(e){t.push(e.execute.bind(e))});return o.execPromiseQueueSequentially(t,true).catch(function(t){var o=this.getCommands();o.forEach(function(t){if(t instanceof e){this.removeCommand(t)}}.bind(this));return this.undo().then(function(){return Promise.reject(t)})}.bind(this))};n.prototype.undo=function(){var t=[];this._forEachCommandInReverseOrder(function(e){t.push(e.undo.bind(e))});return o.execPromiseQueueSequentially(t)};n.prototype._forEachCommand=function(t){var e=this.getCommands();e.forEach(t,this)};n.prototype._forEachCommandInReverseOrder=function(t){var e=this.getCommands();for(var o=e.length-1;o>=0;o--){t.call(this,e[o])}};n.prototype._addCompositeIdToChange=function(t){this._sCompositeId||=o.createDefaultFileName("composite");var e=t.getPreparedChange&&t.getPreparedChange();if(e){var n=e.getSupportInformation();if(!n.compositeCommand){n.compositeCommand=this._sCompositeId;e.setSupportInformation(n)}}else if(t.setCompositeId){t.setCompositeId(this._sCompositeId)}};n.prototype.addCommand=function(t,e){this._addCompositeIdToChange(t);return this.addAggregation("commands",t,e)};n.prototype.insertCommand=function(t,e,o){this._addCompositeIdToChange(t);return this.insertAggregation("commands",t,e,o)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/ControlVariantConfigure", ["sap/ui/rta/command/BaseCommand","sap/ui/rta/library","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/Utils"],function(e,t,a,n,r){"use strict";var i=e.extend("sap.ui.rta.command.ControlVariantConfigure",{metadata:{library:"sap.ui.rta",properties:{control:{type:"any"},changes:{type:"array"}},associations:{},events:{}}});i.prototype.prepare=function(e){this.sLayer=e.layer;return true};i.prototype.getPreparedChange=function(){if(!this._aPreparedChanges){return undefined}return this._aPreparedChanges};i.prototype.execute=async function(){var e=this.getControl();this.oAppComponent=r.getAppComponentForControl(e);this.oModel=this.oAppComponent.getModel(n.getVariantModelName());this.sVariantManagementReference=a.getSelector(e,this.oAppComponent).id;this._aPreparedChanges=[];if(this.getChanges().some(e=>{if(e.visible===false&&e.variantReference===this.oModel.getCurrentVariantReference(this.sVariantManagementReference)){this._sOldVReference=e.variantReference;return true}return false})){await this.oModel.updateCurrentVariant({variantManagementReference:this.sVariantManagementReference,newVariantReference:this.sVariantManagementReference})}this.getChanges().forEach(function(e){e.appComponent=this.oAppComponent;e.generator=t.GENERATOR_NAME;this._aPreparedChanges.push(this.oModel.addVariantChange(this.sVariantManagementReference,e))}.bind(this));return Promise.resolve()};i.prototype.undo=function(){var e;this.getChanges().forEach(function(t,a){e={};Object.keys(t).forEach(function(a){var n=`original${a.charAt(0).toUpperCase()}${a.substr(1)}`;if(a==="visible"){e[a]=true}else if(t[n]){e[a]=t[n];e[n]=t[a]}else if(a.indexOf("original")===-1){e[a]=t[a]}});var n=this._aPreparedChanges[a];this.oModel.deleteVariantChange(this.sVariantManagementReference,e,n)}.bind(this));this._aPreparedChanges=null;if(this._sOldVReference){return this.oModel.updateCurrentVariant({variantManagementReference:this.sVariantManagementReference,newVariantReference:this._sOldVReference}).then(()=>{delete this._sOldVReference})}return Promise.resolve()};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/ControlVariantSave", ["sap/ui/rta/command/BaseCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils"],function(e,t,a){"use strict";var n=e.extend("sap.ui.rta.command.ControlVariantSave",{metadata:{library:"sap.ui.rta",properties:{model:{type:"object"}},associations:{},events:{}}});n.prototype.prepare=function(){this.oAppComponent=a.getAppComponentForControl(this.getElement());this.sVariantManagementReference=t.getSelector(this.getElement(),this.oAppComponent).id;return true};n.prototype.execute=function(){var e=this.getModel().getCurrentVariantReference(this.sVariantManagementReference);this._aControlChanges=this.getModel().getVariant(e,this.sVariantManagementReference).controlChanges;this._aDirtyChanges=this.getModel()._getDirtyChangesFromVariantChanges(this._aControlChanges);this._aDirtyChanges.forEach(function(e){if(e.getFileType()==="change"){e.setSavedToVariant(true)}});this.getModel().invalidateMap();return Promise.resolve()};n.prototype.undo=function(){this._aDirtyChanges.forEach(function(e){if(e.getFileType()==="change"){e.setSavedToVariant(false)}});this.getModel().invalidateMap();return Promise.resolve()};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/ControlVariantSaveAs", ["sap/ui/core/Core","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils","sap/ui/fl/write/api/ContextSharingAPI","sap/ui/rta/command/BaseCommand","sap/ui/rta/library","sap/ui/rta/Utils"],function(e,t,a,n,r,i,o){"use strict";var s=r.extend("sap.ui.rta.command.ControlVariantSaveAs",{metadata:{library:"sap.ui.rta",properties:{sourceVariantReference:{type:"string"},sourceDefaultVariant:{type:"string"},model:{type:"object"},newVariantParameters:{type:"object"}},associations:{},events:{}}});s.prototype.prepare=function(e){this.oVariantManagementControl=this.getElement();this.oAppComponent=a.getAppComponentForControl(this.oVariantManagementControl);this.sVariantManagementReference=t.getSelector(this.oVariantManagementControl,this.oAppComponent).id;this.oModel=this.getModel();this.setSourceDefaultVariant(this.oModel.getData()[this.sVariantManagementReference].defaultVariant);this.sLayer=e.layer;var r=e;r.variantManagementControl=this.oVariantManagementControl;function i(e,t){var a=e.getParameters();this.setNewVariantParameters(a);this.oVariantManagementControl.detachSave(i,this);this.oVariantManagementControl.detachCancel(s,this);t.resolve(true)}function s(e,t){this.oVariantManagementControl.detachSave(i,this);this.oVariantManagementControl.detachCancel(s,this);t.resolve(false)}return new Promise(function(e){this.oVariantManagementControl.attachSave({resolve:e},i,this);this.oVariantManagementControl.attachCancel({resolve:e},s,this);this.oVariantManagementControl.openSaveAsDialogForKeyUser(o.getRtaStyleClassName(),n.createComponent(r))}.bind(this)).then(function(e){return e})};s.prototype.getPreparedChange=function(){if(!this._aPreparedChanges){return undefined}return this._aPreparedChanges};s.prototype.execute=function(){var e=this.getSourceVariantReference();this._aControlChanges=this.oModel.getVariant(e,this.sVariantManagementReference).controlChanges;var t=this.getNewVariantParameters();t.layer=this.sLayer;t.newVariantReference=this.sNewVariantReference;t.generator=i.GENERATOR_NAME;return this.oModel._handleSave(this.oVariantManagementControl,t).then(function(e){this._aPreparedChanges=e;[this._oVariantChange]=e;this.sNewVariantReference=this._oVariantChange.getId();this._aPreparedChanges.forEach(function(e){if(e.getFileType()==="change"){e.setSavedToVariant(true)}});this.getModel().invalidateMap()}.bind(this))};s.prototype.undo=function(){if(this._oVariantChange){var e=[];this._aPreparedChanges.forEach(function(t){if(t.getFileType()==="ctrl_variant_management_change"){e.push(t)}});this.oModel.oChangePersistence.deleteChanges(e);var t={variant:this._oVariantChange,sourceVariantReference:this.getSourceVariantReference(),variantManagementReference:this.sVariantManagementReference,component:this.oAppComponent};return this.oModel.removeVariant(t,true).then(function(){return this.oModel.addAndApplyChangesOnVariant(this._aControlChanges)}.bind(this)).then(function(){this._aPreparedChanges=null;this._oVariantChange=null}.bind(this))}return Promise.resolve()};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/ControlVariantSetTitle", ["sap/ui/rta/command/BaseCommand","sap/ui/rta/library","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/Utils"],function(e,t,n,a,r){"use strict";var i=e.extend("sap.ui.rta.command.ControlVariantSetTitle",{metadata:{library:"sap.ui.rta",properties:{oldText:{type:"string"},newText:{type:"string"}},associations:{},events:{}}});i.prototype.prepare=function(e){this.sLayer=e.layer;return true};i.prototype.getPreparedChange=function(){this._oPreparedChange=this.getVariantChange();if(!this._oPreparedChange){return undefined}return this._oPreparedChange};i.prototype.execute=function(){var e=this.getElement();this.oAppComponent=r.getAppComponentForControl(e);this.oModel=this.oAppComponent.getModel(a.getVariantModelName());this.sVariantManagementReference=n.getSelector(e,this.oAppComponent).id;this.sCurrentVariant=this.oModel.getCurrentVariantReference(this.sVariantManagementReference);var i=this.oModel.getVariantTitle(this.sCurrentVariant,this.sVariantManagementReference);this.setOldText(i);var o={appComponent:this.oAppComponent,variantReference:this.sCurrentVariant,changeType:"setTitle",title:this.getNewText(),layer:this.sLayer,generator:t.GENERATOR_NAME};return Promise.resolve(this.oModel.addVariantChange(this.sVariantManagementReference,o)).then(function(e){this._oVariantChange=e}.bind(this))};i.prototype.undo=function(){var e={variantReference:this.sCurrentVariant,changeType:"setTitle",title:this.getOldText()};var t=this._oVariantChange;return Promise.resolve(this.oModel.deleteVariantChange(this.sVariantManagementReference,e,t)).then(function(){this._oVariantChange=null}.bind(this))};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/ControlVariantSwitch", ["sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/Utils","sap/ui/rta/command/BaseCommand"],function(e,t,n,a){"use strict";var r=a.extend("sap.ui.rta.command.ControlVariantSwitch",{metadata:{library:"sap.ui.rta",properties:{targetVariantReference:{type:"string"},sourceVariantReference:{type:"string"},discardVariantContent:{type:"boolean"}},associations:{},events:{}},constructor:function(...e){a.apply(this,e);this.setRelevantForSave(false)}});function i(e){return this.oModel.eraseDirtyChangesOnVariant(this.sVariantManagementReference,e).then(function(e){this._aSourceVariantDirtyChanges=e}.bind(this))}r.prototype._getAppComponent=function(){var e=this.getElement();return e?n.getAppComponentForControl(e):this.getSelector().appComponent};r.prototype.execute=function(){var n=this.getElement();var a=this._getAppComponent();var r=this.getTargetVariantReference();this.oModel=a.getModel(t.getVariantModelName());this.sVariantManagementReference=e.getSelector(n,a).id;return Promise.resolve().then(function(){if(this.getDiscardVariantContent()){return i.call(this,this.getSourceVariantReference())}return undefined}.bind(this)).then(this._updateModelVariant.bind(this,r,a))};r.prototype.undo=function(){var e=this.getSourceVariantReference();var t=this._getAppComponent();return this._updateModelVariant(e,t).then(function(){if(this.getDiscardVariantContent()){return this.oModel.addAndApplyChangesOnVariant(this._aSourceVariantDirtyChanges).then(function(){this._aSourceVariantDirtyChanges=null;this.oModel.checkUpdate(true)}.bind(this))}return undefined}.bind(this))};r.prototype._updateModelVariant=function(e,t){if(this.getTargetVariantReference()!==this.getSourceVariantReference()){return this.oModel.updateCurrentVariant({variantManagementReference:this.sVariantManagementReference,newVariantReference:e,appComponent:t})}return Promise.resolve()};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/CreateContainer", ["sap/ui/rta/command/FlexCommand"],function(t){"use strict";var e=t.extend("sap.ui.rta.command.CreateContainer",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int",group:"content"},newControlId:{type:"string",group:"content"},label:{type:"string"},parentId:{type:"string",group:"content"}},associations:{},events:{}}});e.prototype._getChangeSpecificData=function(){var e=t.prototype._getChangeSpecificData.apply(this);e.newLabel=this.getLabel();return e};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/CustomAdd", ["sap/ui/rta/command/FlexCommand"],function(t){"use strict";var e=t.extend("sap.ui.rta.command.CustomAdd",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int",group:"content"},addElementInfo:{type:"object",group:"content"},aggregationName:{type:"string",group:"content"},customItemId:{type:"string",group:"content"}}}});return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/FlexCommand", ["sap/base/util/merge","sap/base/util/values","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Element","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/Utils","sap/ui/rta/command/BaseCommand","sap/ui/rta/library"],function(e,t,n,r,o,a,i,p,s,l){"use strict";var g=s.extend("sap.ui.rta.command.FlexCommand",{metadata:{library:"sap.ui.rta",properties:{changeType:{type:"string"},jsOnly:{type:"boolean",defaultValue:false},selector:{type:"object"},variantIndependent:{type:"boolean",defaultValue:false}},associations:{},events:{}}});g.prototype.getElementId=function(){var e=this.getElement();return e?e.getId():this.getSelector().id};g.prototype.getAppComponent=function(){var e=this.getElement();return e?p.getAppComponentForControl(e):this.getSelector().appComponent};g.prototype.prepare=function(e,t,r){var a;if(!this.getSelector()&&e&&e.templateSelector){a={id:e.templateSelector,appComponent:this.getAppComponent(),controlType:p.getControlType(o.getElementById(e.templateSelector))};this.setSelector(a)}else if(!this.getSelector()&&this.getElement()){a={id:this.getElement().getId(),appComponent:this.getAppComponent(),controlType:p.getControlType(this.getElement())};this.setSelector(a)}return this._createChange(e,t,r).then(function(e){this._oPreparedChange=e;return true}.bind(this)).catch(function(e){n.error(e.message||e.name);return false})};g.prototype.getPreparedChange=function(){return this._oPreparedChange};g.prototype.execute=function(){var e=this.getPreparedChange();return this._applyChange(e)};g.prototype._getChangeSpecificData=function(){var e=this.getMetadata().getProperties();var n={changeType:this.getChangeType()};t(e).filter(function(e){return e.group==="content"}).forEach(function(e){n[e.name]=e.get(this)},this);return n};g.prototype._createChange=function(e,t,n){return this._createChangeFromData(this._getChangeSpecificData(),e,t,n)};g.prototype._createChangeFromData=function(t,n,o,p){if(n){t=e({},t,n)}t.jsOnly=this.getJsOnly();var s=this.getAppComponent().getModel(a.getVariantModelName());var g;if(s&&o){g=s.getCurrentVariantReference(o)}if(g&&!this.getVariantIndependent()){var c={variantManagementReference:o,variantReference:g,isChangeOnStandardVariant:o===g};t=Object.assign({},t,c)}t.command=p;t.generator=n.generator||l.GENERATOR_NAME;return i.create({changeSpecificData:t,selector:this._validateControlForChange(n)}).then(function(e){if(n&&n.originalSelector){e.addDependentControl(n.originalSelector,"originalSelector",{modifier:r,appComponent:this.getAppComponent()});e.setSelector(Object.assign(e.getSelector(),r.getSelector(this.getSelector().id,this.getAppComponent())));e.setContent(Object.assign({},e.getContent(),n.content))}return e}.bind(this))};g.prototype.undo=function(){var e=this.getElement()||r.bySelector(this.getSelector());var t=this.getPreparedChange();return i.revert({change:t,element:e})};g.prototype._applyChange=function(e){var t=this.getAppComponent();var n=r.bySelector(e.getSelector(),t);var o={modifier:r,appComponent:t,view:p.getViewForControl(n)};return i.apply(Object.assign({change:e,element:n},o)).then(function(e){if(!e.success){return Promise.reject(e.error)}return undefined})};g.prototype._validateControlForChange=function(e){if(e&&e.originalSelector&&e.content&&e.content.boundAggregation){return{id:e.originalSelector,appComponent:this.getAppComponent(),controlType:p.getControlType(o.getElementById(e.originalSelector))}}return this.getElement()||this.getSelector()};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/LREPSerializer", ["sap/ui/base/ManagedObject","sap/ui/rta/command/FlexCommand","sap/ui/rta/command/AppDescriptorCommand","sap/ui/fl/Utils","sap/ui/dt/ElementUtil","sap/base/Log","sap/ui/fl/write/api/PersistenceWriteAPI"],function(e,t,n,a,o,i,r){"use strict";var s=e.extend("sap.ui.rta.command.LREPSerializer",{metadata:{library:"sap.ui.rta",associations:{rootControl:{type:"sap.ui.core.Control"}},properties:{commandStack:{type:"object"}},aggregations:{}}});function d(e){return o.getElementInstance(e)}s.prototype._lastPromise=Promise.resolve();s.prototype.setCommandStack=function(e){if(this.getCommandStack()){this.getCommandStack().removeCommandExecutionHandler(this._fnHandleCommandExecuted)}this.setProperty("commandStack",e);e.addCommandExecutionHandler(this._fnHandleCommandExecuted)};s.prototype.init=function(){this._fnHandleCommandExecuted=this.handleCommandExecuted.bind(this)};s.prototype.exit=function(){this.getCommandStack().removeCommandExecutionHandler(this._fnHandleCommandExecuted)};s.prototype._isPersistedChange=function(e){return!!this.getCommandStack()._aPersistedChanges&&this.getCommandStack()._aPersistedChanges.indexOf(e.getId())!==-1};s.prototype.handleCommandExecuted=function(e){return function(e){var a=e;this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var e=this.getCommandStack().getSubCommands(a.command);var o;var i=[];if(a.undo){e.forEach(function(e){if(!(e instanceof t||e instanceof n)||e.getRuntimeOnly()){return}var a=e.getPreparedChange();o=e.getAppComponent();if(o){i.push(a)}});if(o){return r.remove({flexObjects:i,selector:o})}return Promise.resolve()}var s=[];e.forEach(function(e){if(e.getRuntimeOnly()){return}if(e instanceof t){o=e.getAppComponent();if(o){var a=e.getPreparedChange();if(!this._isPersistedChange(a)){i.push(e.getPreparedChange())}}}else if(e instanceof n){s.push(e.createAndStoreChange())}}.bind(this));if(o){r.add({flexObjects:i,selector:o})}return Promise.all(s)}.bind(this));return this._lastPromise}.bind(this)(e)};s.prototype.needsReload=function(){this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var e=this.getCommandStack().getAllExecutedCommands();return e.some(function(e){return!!e.needsReload})}.bind(this));return this._lastPromise};s.prototype.saveCommands=function(e){this._lastPromise=this._lastPromise.catch(function(e){i.error(e)}).then(function(){var t=d(this.getRootControl());if(!t){throw new Error("Can't save commands without root control instance!")}return r.save({selector:t,skipUpdateCache:false,draft:!!e.saveAsDraft,layer:e.layer,removeOtherLayerChanges:!!e.removeOtherLayerChanges,version:e.version,adaptationId:e.adaptationId,condenseAnyLayer:e.condenseAnyLayer})}.bind(this)).then(function(){i.info("UI adaptation successfully transfered changes to layered repository");this.getCommandStack().setSaved(true);this.getCommandStack().removeAllCommands()}.bind(this));return this._lastPromise};s.prototype._triggerUndoChanges=function(e){var t=this.getCommandStack();var n=[];var o=t.getAllExecutedCommands();if(e){o.forEach(function(){n.push(t.undo.bind(t))})}else{o.forEach(function(e){n.push(e.undo.bind(e))});n=n.reverse()}return a.execPromiseQueueSequentially(n,false,true)};s.prototype.clearCommandStack=function(e){var t=this.getCommandStack();if(!e){t.detachCommandExecuted(this.handleCommandExecuted.bind(this))}return this._triggerUndoChanges(e).then(function(){t.removeAllCommands();if(!e){t.attachCommandExecuted(this.handleCommandExecuted.bind(this))}return true}.bind(this))};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/LocalReset", ["sap/ui/rta/command/BaseCommand","sap/ui/fl/Utils","sap/ui/fl/write/api/LocalResetAPI"],function(e,t,n){"use strict";var r=e.extend("sap.ui.rta.command.LocalReset",{metadata:{library:"sap.ui.rta",properties:{currentVariant:{type:"string"},changeType:{type:"string"},jsOnly:{type:"boolean"}},associations:{},events:{}}});r.prototype.prepare=function(e){var r=this.getElement();this._oAppComponent=t.getAppComponentForControl(r);this._aAffectedChanges=n.getNestedUIChangesForControl(r,{layer:e.layer,currentVariant:this.getCurrentVariant()});return Promise.resolve(true)};r.prototype.execute=function(){return n.resetChanges(this._aAffectedChanges,this._oAppComponent)};r.prototype.undo=function(){return n.restoreChanges(this._aAffectedChanges,this._oAppComponent)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Move", ["sap/ui/rta/command/FlexCommand"],function(e){"use strict";var t=e.extend("sap.ui.rta.command.Move",{metadata:{library:"sap.ui.rta",properties:{movedElements:{type:"any[]"},target:{type:"any"},source:{type:"any"}},associations:{},events:{}}});t.prototype._getChangeSpecificData=function(){var e=this.getSource();var t=this.getTarget();if(e.parent){e.id=e.parent.getId();delete e.parent}if(t.parent){t.id=t.parent.getId();delete t.parent}var a={changeType:this.getChangeType(),source:e,target:t,movedElements:[]};this.getMovedElements().forEach(function(e){a.movedElements.push({id:e.id||e.element&&e.element.getId(),sourceIndex:e.sourceIndex,targetIndex:e.targetIndex})});return a};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Property", ["sap/ui/rta/command/FlexCommand"],function(e){"use strict";var t=e.extend("sap.ui.rta.command.Property",{metadata:{library:"sap.ui.rta",properties:{propertyName:{type:"string"},newValue:{type:"any"},semanticMeaning:{type:"string"},changeType:{type:"string",defaultValue:"propertyChange"}},associations:{},events:{}}});t.prototype._getChangeSpecificData=function(){var e=this.getElement();return{changeType:this.getChangeType(),selector:{id:e.getId(),type:e.getMetadata().getName()},content:{property:this.getPropertyName(),newValue:this.getNewValue(),semantic:this.getSemanticMeaning()}}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Remove", ["sap/ui/rta/command/FlexCommand"],function(e){"use strict";var t=e.extend("sap.ui.rta.command.Remove",{metadata:{library:"sap.ui.rta",properties:{removedElement:{type:"any"}},associations:{},events:{}}});t.prototype._getChangeSpecificData=function(){var e=this.getRemovedElement()||this.getElement();var t={changeType:this.getChangeType(),removedElement:{id:e.getId()}};return t};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Rename", ["sap/ui/rta/command/FlexCommand"],function(e){"use strict";var t=e.extend("sap.ui.rta.command.Rename",{metadata:{library:"sap.ui.rta",properties:{renamedElement:{type:"object"},newValue:{type:"string",defaultValue:"new text"}},associations:{},events:{}}});t.prototype._getChangeSpecificData=function(){var e={changeType:this.getChangeType(),renamedElement:{id:this.getRenamedElement().getId()},value:this.getNewValue()};return e};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Resize", ["sap/ui/rta/command/FlexCommand"],function(e){"use strict";var a=e.extend("sap.ui.rta.command.Resize",{metadata:{library:"sap.ui.rta",properties:{content:{type:"any",group:"content"},changeType:{type:"string",defaultValue:"resize"}},associations:{},events:{}}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Reveal", ["sap/ui/rta/command/FlexCommand"],function(e){"use strict";var t=e.extend("sap.ui.rta.command.Reveal",{metadata:{library:"sap.ui.rta",properties:{revealedElementId:{type:"string"},directParent:"object"}}});t.prototype._getChangeSpecificData=function(){var e={changeType:this.getChangeType()};if(this.getRevealedElementId()){e.revealedElementId=this.getRevealedElementId()}return e};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Settings", ["sap/ui/rta/command/FlexCommand"],function(t){"use strict";var e=t.extend("sap.ui.rta.command.Settings",{metadata:{library:"sap.ui.rta",properties:{content:{type:"any",group:"content"}},associations:{},events:{}}});e.prototype.execute=function(...e){if(this.getElement()){return t.prototype.execute.apply(this,e)}return Promise.resolve()};e.prototype.undo=function(...e){if(this.getElement()){return t.prototype.undo.apply(this,e)}return Promise.resolve()};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Split", ["sap/ui/rta/command/FlexCommand"],function(e){"use strict";var t=e.extend("sap.ui.rta.command.Split",{metadata:{library:"sap.ui.rta",properties:{newElementIds:{type:"string[]"},source:{type:"any"},parentElement:{type:"any"}},associations:{},events:{}}});t.prototype._getChangeSpecificData=function(){var e={newElementIds:this.getNewElementIds(),sourceControlId:this.getSource().getId(),changeType:this.getChangeType(),parentId:this.getParentElement().getId()};return e};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Stack", ["sap/ui/base/ManagedObject","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Utils","sap/ui/rta/command/Settings","sap/ui/rta/command/CompositeCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/rta/util/showMessageBox","sap/ui/core/Lib"],function(e,t,n,o,i,r,a,s){"use strict";function u(e,t,n){var o=e[n];if(o){t.push(o)}return t}function d(e,t,n,a){var s=a.getSelector&&a.getSelector();var u=new o({selector:s,changeType:a.getChangeType(),element:r.bySelector(s,e)});u._oPreparedChange=a;var d=a.getSupportInformation().compositeCommand;if(d){if(!t[d]){t[d]=new i;n.pushExecutedCommand(t[d])}t[d].addCommand(u)}else{n.pushExecutedCommand(u)}}var m=e.extend("sap.ui.rta.command.Stack",{metadata:{library:"sap.ui.rta",properties:{saved:{type:"boolean",defaultValue:false}},aggregations:{commands:{type:"sap.ui.rta.command.BaseCommand",multiple:true}},events:{modified:{},commandExecuted:{parameters:{command:{type:"object"},undo:{type:"boolean"}}}}}});m.initializeWithChanges=function(e,o){var i=new m;i._aPersistedChanges=o;if(o&&o.length>0){var r=n.getAppComponentForControl(e);var a={selector:r,invalidateCache:false};return t._getUIChanges(a).then(function(e){var t={};var n={};e.forEach(function(e){n[e.getId()]=e});o.reduce(u.bind(null,n),[]).forEach(d.bind(null,r,t,i));return i})}return Promise.resolve(i)};m.prototype.addCommandExecutionHandler=function(e){this._aCommandExecutionHandler.push(e)};m.prototype.removeCommandExecutionHandler=function(e){var t=this._aCommandExecutionHandler.indexOf(e);if(t>-1){this._aCommandExecutionHandler.splice(t,1)}};m.prototype.init=function(){this._aCommandExecutionHandler=[];this._toBeExecuted=-1;this._oLastCommand=Promise.resolve()};m.prototype._waitForCommandExecutionHandler=function(e){return Promise.all(this._aCommandExecutionHandler.map(function(t){return t(e)}))};m.prototype._getCommandToBeExecuted=function(){return this.getCommands()[this._toBeExecuted]};m.prototype.pushExecutedCommand=function(e){this.push(e,true);this.fireModified()};m.prototype.push=function(e,t){if(this._bUndoneCommands){this._bUndoneCommands=false;while(this._toBeExecuted>-1){this.pop()}}this.insertCommand(e,0);if(!t){this._toBeExecuted++}};m.prototype.top=function(){return this.getCommands()[0]};m.prototype.pop=function(){if(this._toBeExecuted>-1){this._toBeExecuted--}return this.removeCommand(0)};m.prototype.removeCommand=function(e,t){var n=this.removeAggregation("commands",e,t);return n};m.prototype.removeAllCommands=function(e){var t=this.removeAllAggregation("commands",e);this._toBeExecuted=-1;this.fireModified();return t};m.prototype.isEmpty=function(){return this.getCommands().length===0};m.prototype.execute=function(){this._oLastCommand=this._oLastCommand.catch(function(){}).then(function(){var e=this._getCommandToBeExecuted();if(e){var t={command:e,undo:false};return e.execute().then(this._waitForCommandExecutionHandler.bind(this,t)).then(function(){this._toBeExecuted--;this.fireCommandExecuted(t);this.fireModified()}.bind(this)).catch(function(e){e||=new Error("Executing of the change failed.");e.index=this._toBeExecuted;e.command=this.removeCommand(this._toBeExecuted);this._toBeExecuted--;var t=s.getResourceBundleFor("sap.ui.rta");a(t.getText("MSG_GENERIC_ERROR_MESSAGE",[e.message]),{title:t.getText("HEADER_ERROR")},"error");return Promise.reject(e)}.bind(this))}return undefined}.bind(this));return this._oLastCommand};m.prototype._unExecute=function(){if(this.canUndo()){this._bUndoneCommands=true;this._toBeExecuted++;var e=this._getCommandToBeExecuted();if(e){var t={command:e,undo:true};return e.undo().then(this._waitForCommandExecutionHandler.bind(this,t)).then(function(){this.fireCommandExecuted(t);this.fireModified()}.bind(this))}return Promise.resolve()}return Promise.resolve()};m.prototype.canUndo=function(){return this._toBeExecuted+1<this.getCommands().length};m.prototype.canSave=function(){return this.canUndo()&&this.getAllExecutedCommands().some(function(e){return e.getRelevantForSave()})};m.prototype.undo=function(){return this._unExecute()};m.prototype.canRedo=function(){return!!this._getCommandToBeExecuted()};m.prototype.redo=function(){return this.execute()};m.prototype.pushAndExecute=function(e){this.push(e);return this.execute()};m.prototype.getAllExecutedCommands=function(){var e=[];var t=this.getCommands();for(var n=t.length-1;n>this._toBeExecuted;n--){var o=this.getSubCommands(t[n]);e=e.concat(o)}return e};m.prototype.getSubCommands=function(e){var t=[];if(e.getCommands){e.getCommands().forEach(function(e){var n=this.getSubCommands(e);t=t.concat(n)},this)}else{t.push(e)}return t};m.prototype.compositeLastTwoCommands=function(){var e=this.pop();var t=this.pop();var n=new i;n.addCommand(t);n.addCommand(e);this.push(n)};return m});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/appDescriptor/AddLibrary", ["sap/ui/core/Lib","sap/ui/rta/command/AppDescriptorCommand"],function(e,r){"use strict";var a=r.extend("sap.ui.rta.command.appDescriptor.AddLibrary",{metadata:{library:"sap.ui.rta",events:{}}});a.prototype.init=function(){this.setChangeType("appdescr_ui5_addLibraries")};a.prototype.execute=function(){var r=[];if(this.getParameters().libraries){var a=Object.keys(this.getParameters().libraries);a.forEach(function(a){r.push(e.load({name:a}))})}return Promise.all(r)};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/compVariant/CompVariantContent", ["sap/ui/rta/command/BaseCommand","sap/ui/fl/write/api/SmartVariantManagementWriteAPI","sap/ui/rta/library"],function(t,e,i){"use strict";var r=t.extend("sap.ui.rta.command.compVariant.CompVariantContent",{metadata:{library:"sap.ui.rta",properties:{variantId:{type:"string"},persistencyKey:{type:"string"},newContent:{type:"object"},isModifiedBefore:{type:"boolean"}}}});function n(t,i,r){var n=Object.assign({},r,this.mInformation,{id:i,control:this.getElement()});return e[t](n)}function a(t){var e=this.getElement();var i=e._getVariantContent(this.getVariantId());var r=Object.assign({},i);if(e.isPageVariant()){var n={};n[this.getPersistencyKey()]=t;e._applyVariantByPersistencyKey(this.getPersistencyKey(),n,"KEY_USER");r[this.getPersistencyKey()]=t}else{e._applyVariant(e._getPersoController(),t,"KEY_USER");r=t}return r}r.prototype.prepare=function(t,e,r){this.mInformation={layer:t.layer,command:r,generator:i.GENERATOR_NAME};return true};r.prototype.execute=function(){this.getElement().setModified(true);var t=a.call(this,this.getNewContent());n.call(this,"updateVariantContent",this.getVariantId(),{content:t});return Promise.resolve()};r.prototype.undo=function(){var t=n.call(this,"revert",this.getVariantId(),{});this.getElement().setModified(this.getIsModifiedBefore());var e=this.getElement();if(e.isPageVariant()){a.call(this,t.getContent()[this.getPersistencyKey()])}else{a.call(this,t.getContent())}return Promise.resolve()};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/compVariant/CompVariantSaveAs", ["sap/ui/fl/write/api/SmartVariantManagementWriteAPI","sap/ui/rta/command/BaseCommand","sap/ui/rta/library"],function(t,e,a){"use strict";var i=e.extend("sap.ui.rta.command.compVariant.CompVariantSaveAs",{metadata:{library:"sap.ui.rta",properties:{newVariantProperties:{type:"object"},previousDirtyFlag:{type:"boolean"},previousVariantId:{type:"string"},previousDefault:{type:"string"},activateAfterUndo:{type:"boolean"}}}});i.prototype.prepare=function(t,e,i){this.mInformation={layer:t.layer,command:i,generator:a.GENERATOR_NAME};return true};i.prototype.getPreparedChange=function(){return this._oVariant};i.prototype.execute=function(){var e=this.getNewVariantProperties();var a={changeSpecificData:{id:this._oVariant?this._oVariant.getVariantId():undefined,type:e.type,texts:{variantName:e.text},content:e.content,executeOnSelection:e.executeOnSelection,favorite:true,contexts:e.contexts,layer:this.mInformation.layer},control:this.getElement(),command:this.mInformation.command,generator:this.mInformation.generator};this._oVariant=t.addVariant(a);if(e.default){t.setDefaultVariantId(Object.assign({},this.mInformation,{control:this.getElement(),defaultVariantId:this._oVariant.getVariantId()}))}this.getElement().addVariant(this._oVariant,e.default);this.getElement().activateVariant(this._oVariant.getVariantId());return Promise.resolve()};i.prototype.undo=function(){t.removeVariant({id:this._oVariant.getVariantId(),control:this.getElement(),revert:true});if(this.getNewVariantProperties().default){t.setDefaultVariantId(Object.assign({},this.mInformation,{control:this.getElement(),defaultVariantId:this.getPreviousDefault()}))}this.getElement().removeWeakVariant({previousDirtyFlag:this.getPreviousDirtyFlag(),previousVariantId:this.getPreviousVariantId(),previousDefault:this.getPreviousDefault(),variantId:this._oVariant.getVariantId()});if(this.getElement().getCurrentVariantId()!==""){this.getElement()._getVariantById(this.getPreviousVariantId()).setContent(this.getNewVariantProperties().content)}if(this.getActivateAfterUndo()){this.getElement().activateVariant(this.getPreviousVariantId())}if(this.getElement().getCurrentVariantId()!==""){this.getElement().setModified(this.getPreviousDirtyFlag())}return Promise.resolve()};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/compVariant/CompVariantSwitch", ["sap/ui/rta/command/BaseCommand","sap/ui/fl/write/api/SmartVariantManagementWriteAPI"],function(t,e){"use strict";var a=t.extend("sap.ui.rta.command.compVariant.CompVariantSwitch",{metadata:{library:"sap.ui.rta",properties:{sourceVariantId:{type:"string"},targetVariantId:{type:"string"},discardVariantContent:{type:"boolean"}}},constructor:function(...e){t.apply(this,e);this.setRelevantForSave(false)}});a.prototype.execute=function(){this.getElement().activateVariant(this.getTargetVariantId());if(this.getDiscardVariantContent()){this.getElement().setModified(false);e.discardVariantContent({control:this.getElement(),id:this.getSourceVariantId()})}return Promise.resolve()};a.prototype.undo=function(){if(this.getDiscardVariantContent()){e.revert({control:this.getElement(),id:this.getSourceVariantId()})}this.getElement().activateVariant(this.getSourceVariantId());if(this.getDiscardVariantContent()){this.getElement().setModified(true)}return Promise.resolve()};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/compVariant/CompVariantUpdate", ["sap/base/util/each","sap/ui/fl/write/api/SmartVariantManagementWriteAPI","sap/ui/rta/command/BaseCommand","sap/ui/rta/library"],function(t,e,a,i){"use strict";var r=a.extend("sap.ui.rta.command.compVariant.CompVariantUpdate",{metadata:{library:"sap.ui.rta",properties:{newVariantProperties:{type:"object"},newDefaultVariantId:{type:"string"},oldDefaultVariantId:{type:"string"},onlySave:{type:"boolean"},isModifiedBefore:{type:"boolean"}}}});r.prototype.prepare=function(t,e,a){this.mInformation={layer:t.layer,command:a,generator:i.GENERATOR_NAME};return true};function n(t,a,i){var r=Object.assign({},i,this.mInformation,{id:a,control:this.getElement()});return e[t](r)}r.prototype.execute=function(){if(this.getOnlySave()){this.setIsModifiedBefore(this.getElement().getModified());this.getElement().setModified(false);var e=Object.keys(this.getNewVariantProperties())[0];n.call(this,"saveVariantContent",e,this.getNewVariantProperties()[e])}else{t(this.getNewVariantProperties(),function(t,e){if(e.deleted){n.call(this,"removeVariant",t,{});this.getElement().removeVariant({variantId:t})}else{var a=n.call(this,"updateVariantMetadata",t,e);this.getElement().updateVariant(a)}}.bind(this));if(this.getNewDefaultVariantId()){n.call(this,"setDefaultVariantId",undefined,{defaultVariantId:this.getNewDefaultVariantId()});this.getElement().setDefaultVariantId(this.getNewDefaultVariantId())}}return Promise.resolve()};r.prototype.undo=function(){if(this.getOnlySave()){var e=Object.keys(this.getNewVariantProperties())[0];n.call(this,"revert",e,{});this.getElement().setModified(this.getIsModifiedBefore())}else{t(this.getNewVariantProperties(),function(t,e){var a=n.call(this,"revert",t,{});if(e.deleted){this.getElement().addVariant(a)}else{this.getElement().updateVariant(a)}}.bind(this));if(this.getNewDefaultVariantId()){n.call(this,"revertSetDefaultVariantId",this.getOldDefaultVariantId());this.getElement().setDefaultVariantId(this.getOldDefaultVariantId())}}return Promise.resolve()};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/enablement/TestDelegate", ["sap/base/util/isPlainObject","sap/base/util/merge"],function(e,r){"use strict";function t(e,r){return e[r]&&typeof e[r]==="string"}function n(r){if(!r.appComponent.isA("sap.ui.core.Component")){return false}if(!e(r.modifier)){return false}if(r.modifier.targets==="xmlTree"&&!t(r.view,"nodeName")){return false}if(r.payload&&!e(r.payload)){return false}return["aggregationName","bindingPath"].every(t.bind(null,r))}var o={getPropertyInfo(e){return Promise.resolve().then(function(){var r=e.element.isA("sap.ui.core.Element")&&e.aggregationName&&typeof e.aggregationName==="string"&&(!e.payload||typeof e.payload==="object");if(r){return[]}return undefined})},createLabel(e){return Promise.resolve().then(function(){var r=n(e)&&t(e,"labelFor");if(r){return e.modifier.createControl("sap.m.Label",e.appComponent,e.view,`${e.labelFor}-label`,{labelFor:e.labelFor,text:e.bindingPath},true)}return undefined})},createControlForProperty(o){return Promise.resolve().then(function(){var a=n(o)&&(t(o.element,"nodeName")||o.element.isA("sap.ui.core.Element"))&&e(o.fieldSelector)&&t(o.fieldSelector,"id");if(a){var i=[o.modifier.createControl("sap.m.Text",o.appComponent,o.view,o.fieldSelector,{text:`{${o.bindingPath}}`})];if(o.payload.valueHelpId){var l=r({},o.fieldSelector,{id:`${o.fieldSelector.id}-${o.payload.valueHelpId}`});i.push(o.modifier.createControl("sap.ui.core.Element",o.appComponent,o.view,l,true))}return Promise.all(i).then(function(e){return{control:e[0],valueHelp:e[1]}})}return undefined})},createLayout(e){var t=n(e)&&e.fieldSelector&&typeof e.fieldSelector==="object"&&typeof e.fieldSelector.id==="string";if(t){if(!e.payload.useCreateLayout){return Promise.resolve()}var a;var i;var l;var u=r({},e);var f=u.modifier;u.fieldSelector.id+="-field";return o.createControlForProperty(u).then(function(r){l=r;i=l.valueHelp;return f.createControl(u.payload.layoutType,u.appComponent,u.view,e.fieldSelector)}).then(function(e){a=e;return f.insertAggregation(a,u.payload.aggregation,l.control,0,u.view)}).then(function(){if(u.payload.labelAggregation){var e=Object.assign({labelFor:f.getId(l.control)},u);return o.createLabel(e)}return undefined}).then(function(e){if(e){return f.insertAggregation(a,u.payload.labelAggregation,e,0,u.view)}return undefined}).then(function(){return{control:a,valueHelp:i}})}return undefined}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/enablement/elementActionTest", ["sap/ui/core/UIComponent","sap/ui/core/ComponentContainer","sap/ui/core/Core","sap/ui/core/mvc/XMLView","sap/ui/rta/command/CommandFactory","sap/ui/rta/util/changeVisualization/ChangeCategories","sap/ui/rta/util/changeVisualization/ChangeVisualization","sap/ui/dt/DesignTime","sap/ui/dt/DesignTimeStatus","sap/ui/dt/OverlayRegistry","sap/ui/fl/ChangePersistence","sap/ui/model/Model","sap/ui/fl/registry/Settings","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Layer","sap/ui/thirdparty/sinon-4","sap/ui/fl/library"],function(e,t,n,i,o,a,r,s,c,h,u,d,l,m,f,g){"use strict";function p(v,C){if(p._only&&v.indexOf(p._only)<0){return}if(typeof C.xmlView==="string"){C.xmlView={viewContent:C.xmlView}}var y=g.createSandbox();C.before||=function(){};C.after||=function(){};QUnit.module(v,function(){QUnit.test("When using the 'elementActionTest' function to test if your control is ready for UI adaptation at runtime",function(e){e.ok(C.afterAction,"then you implement a function to check if your action has been successful: See the afterAction parameter.");e.ok(C.afterUndo,"then you implement a function to check if the undo has been successful: See the afterUndo parameter.");e.ok(C.afterRedo,"then you implement a function to check if the redo has been successful: See the afterRedo parameter.");e.ok(C.xmlView,"then you provide an XML view to test on: See the.xmlView parameter.");var t=(new DOMParser).parseFromString(C.xmlView.viewContent,"application/xml").documentElement;e.ok(t.tagName.match("View$"),"then you use the sap.ui.core.mvc View tag as the first tag in your view");e.ok(C.action,"then you provide an action: See the action parameter.");e.ok(C.action.name,"then you provide an action name: See the action.name parameter.");e.ok(C.action.controlId||C.action.control,"then you provide the control or control's id to operate the action on: See the action.controlId.")})});var b="sap.ui.rta.control.enabling.comp";var w=false;var V=true;var A=e.extend(b,{metadata:{interfaces:["sap.ui.core.IAsyncContentCreation"],manifest:{"sap.app":{id:b,type:"application"}}},createContent(){var e=Object.assign({},C.xmlView);e.id=this.createId("view");if(e.async===undefined){e.async=this.getComponentData().async}e.definition=e.viewContent;this.oViewPromise=i.create(e);return this.oViewPromise}});function I(e){this.oUiComponent=new A({id:"comp",componentData:{async:e}});return this.oUiComponent.oViewPromise.then(function(){this.oUiComponentContainer=new t({component:this.oUiComponent,height:"100%"});this.oUiComponentContainer.placeAt(C.placeAt||"qunit-fixture");this.oView=this.oUiComponent.getRootControl();if(C.model instanceof d){this.oView.setModel(C.model)}n.applyChanges();return C.model&&C.model.getMetaModel()&&C.model.getMetaModel().loaded()}.bind(this))}function x(e){var t=[].concat(C.previousActions||[],C.action);var n=[];return t.reduce(function(t,i){return t.then(M.bind(this,e,i)).then(function(e){n.push(e);return e.execute()})}.bind(this),Promise.resolve()).then(function(){return n})}function U(e){if(typeof e.control==="function"){return e.control(this.oView)}return this.oView.byId(e.controlId)}function P(e){return e.designtimeActionControl?e.designtimeActionControl(this.oView):undefined}function E(){this.oDesignTime=new s({rootElements:[this.oView]});return new Promise(function(e){this.oDesignTime.attachEventOnce("synced",e)}.bind(this))}function k(e){if(e){return typeof e==="function"?e(this.oView):e}return{}}function D(e,t,n,i,o,a){if(Array.isArray(t.name)){var r=o.getAction(t.name[0],n,t.name[1]);e.ok(r,`the ${t[0]} via ${t.name[1]} action is available in the designtime`)}else if(t.name==="createContainer"||t.name==="addIFrame"){e.ok(a.getAction(t.name,n),`the ${t.name}action is available in the calculated designtime metadata during execution`)}else if(t.name==="move"){e.ok(o.getAction(t.name,i),`the ${t.name}action is available in the calculated designtime metadata during execution`)}else{e.ok(o.getAction(t.name,n),`the ${t.name}action is available in the calculated designtime metadata during execution`)}}function M(e,t){var n;var i;var a;var r;var s;var c=t.name;var u;return Promise.resolve().then(U.bind(this,t)).then(function(e){n=e;a=k.call(this,t.parameter);return P.call(this,t)}.bind(this)).then(function(e){i=e;return E.call(this)}.bind(this)).then(function(){var o=h.getOverlay(i||n);if(!o){throw new Error(`The provided control ${n.getId()}does not have any overlay existing during test execution. `+`With this testsetup it is no possible to check for designtime action definition. In some cases it is not `+`possible to identify the control with the designtime metadata automatically just by the given 'action.control'. `+`In this case please provide the 'action.designtimeActionControl' property with a valid control containing `+`the designtime metadata definition for this check.`)}r=o.getDesignTimeMetadata();var d=r.getResponsibleElement(n);var l;if(C.label){e.strictEqual(r.getLabel(n),C.label,"then the control label is correct")}if(t.name==="move"){u=a.movedElements[0].element||a.movedElements[0].id;var m=h.getOverlay(u);var f=m.getRelevantContainer();n=f;r=m.getParentAggregationOverlay().getDesignTimeMetadata()}else if(Array.isArray(t.name)){var g=r.getActionDataFromAggregations(t.name[0],n,undefined,t.name[1]);l=o.getAggregationOverlay(g[0].aggregation);r=l.getDesignTimeMetadata();c="addDelegateProperty"}else if(t.name==="createContainer"||t.name==="addIFrame"){var p=r.getActionDataFromAggregations(t.name,i||n);l=o.getAggregationOverlay(p[0].aggregation);s=l.getDesignTimeMetadata()}else if(d){if(t.name==="reveal"){n=t.revealedElement(this.oView);o=h.getOverlay(t.revealedElement(this.oView));r=o.getDesignTimeMetadata();if(t.label){var v=r.getAction("reveal");e.strictEqual(v.getLabel(n),t.label,"then the control label is correct")}}else{n=d;o=h.getOverlay(n);r=o.getDesignTimeMetadata();n.getMetadata().loadDesignTime(n)}}}.bind(this)).then(function(){return D.call(this,e,t,n,u,r,s)}.bind(this)).then(function(){var e=new o({flexSettings:{layer:C.layer||f.CUSTOMER}});return e.getCommandFor(n,c,a,r)}).then(function(t){e.ok(t,`then the registration for action to change type, the registration for change and `+`control type to change handler is available and ${C.action.name} is a valid action`);return t}).catch(function(e){throw new Error(e)})}function S(e){return e.reduce(function(e,t){return e.then(t.execute.bind(t))},Promise.resolve())}function T(e){var t=e.slice().reverse();return t.reduce(function(e,t){return e.then(t.undo.bind(t))},Promise.resolve())}function R(e){e.forEach(function(e){e.destroy()})}function O(e,t,n){var i={remainingCommands:[],deletedCommands:[]};if(t.length===1){i.remainingCommands.push(t[0]);return Promise.resolve(i)}var o=t.map(function(e){return e.getPreparedChange()});return m._condense({selector:e,changes:o}).then(function(e){if(C.changesAfterCondensing!==undefined){n.equal(e.length,C.changesAfterCondensing,"after condensing the amount of changes is correct")}var o=e.map(function(e){return e.getId()});t.forEach(function(e){if(o.indexOf(e.getPreparedChange().getId())>-1){i.remainingCommands.push(e)}else{i.deletedCommands.push(e)}});return i})}function z(e,t,n){if(!C.changeVisualization){return Promise.resolve()}var i;if(typeof C.changeVisualization==="function"){i=C.changeVisualization(e)}else{i=C.changeVisualization}var o=new r({rootControlId:e.getId(),isActive:true});y.stub(o,"_updateChangeIndicators");var s=t.map(function(e){return e.getPreparedChange()});y.stub(o,"_collectChanges").resolves(s);return o._updateChangeRegistry().then(function(){return o._selectChangeCategory(a.ALL)}).then(function(){var t=o._oChangeIndicatorRegistry;var a=t.getSelectorsWithRegisteredChanges();var r=i.displayElementId;var s=r?e.createId(r):e.getId();n.ok(a[s]&&a[s].length,"there is a change indicator at the correct element");var c=t.getAllRegisteredChanges()[0];var h=i.info;function u(t){return t.map(function(t){return e.createId(t)})}if(h){if(h.affectedControls){var d=u(h.affectedControls);n.deepEqual(d,c.visualizationInfo.affectedElementIds,"then the affected control ids are correct")}if(h.dependentControls){var l=u(h.dependentControls);n.deepEqual(l,c.visualizationInfo.dependentElementIds,"then the dependent control ids are correct")}if(h.displayControls){var m=u(h.displayControls);n.deepEqual(m,c.visualizationInfo.displayElementIds,"then the display control ids are correct")}if(h.descriptionPayload){n.deepEqual(h.descriptionPayload,c.visualizationInfo.descriptionPayload,"then the descriptionPayload is correct")}}})}function _(e){var t=[];e.forEach(function(e){var n=e.getPreparedChange();if(e.getAppComponent){t.push(m.remove({change:n,selector:e.getAppComponent()}))}});return Promise.all(t)}function L(e){var t=[];y.stub(u.prototype,"getChangesForView").resolves(t);return I.call(this,w).then(Q.bind(this,e,t))}function Q(e,t){var n=[].concat(C.previousActions||[],C.action);var i=[];return n.reduce(function(n,o){return n.then(M.bind(this,e,o)).then(function(e){i.push(e);t.push(e.getPreparedChange());this.oUiComponentContainer.destroy();return I.call(this,V)}.bind(this))}.bind(this),Promise.resolve()).then(function(){this.aCommands=i}.bind(this))}if(!C.jsOnly){QUnit.module(`${v} on async views`,{before(e){this.hookContext={};return C.before.call(this.hookContext,e)},after(e){return C.after.call(this.hookContext,e)},beforeEach(){y.stub(l,"getInstance").resolves({_oSettings:{}})},afterEach(){this.oUiComponentContainer.destroy();this.oDesignTime.destroy();R(this.aCommands);y.restore()}},function(){QUnit.test("When applying the change directly on the XMLView",function(e){return L.call(this,e).then(function(){return z(this.oView,this.aCommands,e)}.bind(this)).then(function(){return C.afterAction(this.oUiComponent,this.oView,e)}.bind(this))});QUnit.test("When executing on XML and reverting the change in JS (e.g. variant switch)",function(e){return L.call(this,e).then(function(){return T(this.aCommands)}.bind(this)).then(function(){return _(this.aCommands)}.bind(this)).then(function(){n.applyChanges();C.afterUndo(this.oUiComponent,this.oView,e)}.bind(this))});QUnit.test("When executing on XML, reverting the change in JS (e.g. variant switch) and applying again",function(e){return L.call(this,e).then(function(){return O(this.oView,this.aCommands,e)}.bind(this)).then(function(e){this.aRemainingCommands=e.remainingCommands;return T(this.aCommands)}.bind(this)).then(function(){return _(this.aCommands)}.bind(this)).then(function(){return S(this.aRemainingCommands)}.bind(this)).then(function(){n.applyChanges();C.afterRedo(this.oUiComponent,this.oView,e)}.bind(this))})})}function W(e){if(e.getStatus()!==c.SYNCED){return new Promise(function(t){e.attachEventOnce("synced",t)})}return Promise.resolve()}QUnit.module(v,{before(e){this.hookContext={};return C.before.call(this.hookContext,e)},after(e){return C.after.call(this.hookContext,e)},beforeEach(e){y.stub(u.prototype,"getChangesForComponent").returns(Promise.resolve([]));y.stub(l,"getInstance").returns(Promise.resolve({_oSettings:{}}));return I.call(this,w).then(x.bind(this,e)).then(function(e){this.aCommands=e}.bind(this))},afterEach(){this.oDesignTime.destroy();this.oUiComponentContainer.destroy();R(this.aCommands);y.restore()}},function(){QUnit.test("When executing the underlying command on the control at runtime",function(e){return W(this.oDesignTime).then(function(){return z(this.oView,this.aCommands,e)}.bind(this)).then(function(){n.applyChanges();return C.afterAction(this.oUiComponent,this.oView,e)}.bind(this))});QUnit.test("When executing and undoing the command",function(e){return W(this.oDesignTime).then(T.bind(null,this.aCommands)).then(_.bind(null,this.aCommands)).then(function(){n.applyChanges();return C.afterUndo(this.oUiComponent,this.oView,e)}.bind(this))});QUnit.test("When executing, undoing and redoing the command",function(e){return W(this.oDesignTime).then(O.bind(this,this.oView,this.aCommands,e)).then(function(e){this.aRemainingCommands=e.remainingCommands;return T(this.aCommands)}.bind(this)).then(_.bind(null,this.aCommands)).then(function(){return S(this.aRemainingCommands)}.bind(this)).then(function(){n.applyChanges();return C.afterRedo(this.oUiComponent,this.oView,e)}.bind(this))})})}p.skip=function(){};p.only=function(e){p._only=e};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/library", ["sap/ui/core/Lib","sap/ui/core/library","sap/m/library","sap/ui/fl/library","sap/ui/dt/library"],function(i){"use strict";var a=i.init({name:"sap.ui.rta",version:"1.120.31",dependencies:["sap.ui.core","sap.m","sap.ui.fl","sap.ui.dt"],types:[],interfaces:[],controls:[],elements:[]});a.GENERATOR_NAME="sap.ui.rta.command";return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/AddXMLAtExtensionPoint", ["sap/ui/rta/plugin/Plugin","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/write/api/ExtensionPointRegistryAPI","sap/base/util/values","sap/ui/base/DesignTime"],function(t,n,e,r,i,a,o){"use strict";var s=t.extend("sap.ui.rta.plugin.AddXMLAtExtensionPoint",{metadata:{library:"sap.ui.rta",properties:{fragmentHandler:{type:"function"}},associations:{},events:{}}});var u="addXMLAtExtensionPoint";var l="appdescr_ui5_setFlexExtensionPointEnabled";function p(t){var n=t.getId();var e=i.getExtensionPointInfoByParentId({parentId:n});return e.length?e:a(i.getExtensionPointInfoByViewId({viewId:n}))}function d(t){return p(t).length>0}function f(){return o.isDesignModeEnabled()}s.prototype.bAppDescriptorCommandAlreadyAvailable=false;s.prototype._isEditable=function(t){if(f()){var n=t.getElement();return this.hasChangeHandler(u,n).then(function(t){return t&&d(n)})}return Promise.resolve(false)};s.prototype.isEnabled=function(t){return t.length===1};s.prototype.isAvailable=function(t){if(f()){var n=t[0].getElement();return d(n)}return false};function m(t,n,r){var i=n.extensionPointName;var a=e.getViewForControl(t);var o={name:i,view:a};var s={fragment:n.fragment,fragmentPath:n.fragmentPath};return this.getCommandFactory().getCommandFor(o,u,s).then(function(t){return r.addCommand(t)})}function c(t,n){var i=r.isFlexExtensionPointHandlingEnabled(t);if(i||this.bAppDescriptorCommandAlreadyAvailable){return Promise.resolve()}var a=e.getAppComponentForControl(t);var o=a.getManifestEntry("sap.app").id;return this.getCommandFactory().getCommandFor(t,"appDescriptor",{reference:o,appComponent:a,changeType:l,parameters:{flexExtensionPointEnabled:true},texts:{}}).then(function(t){this.bAppDescriptorCommandAlreadyAvailable=true;return n.addCommand(t)}.bind(this))}function g(t,n){var e;var r=t[0];var i=r.getElement();return this.getCommandFactory().getCommandFor(i,"composite").then(function(t){e=t}).then(function(){return m.call(this,i,n,e)}.bind(this)).then(function(){return c.call(this,i,e)}.bind(this)).then(function(){return e})}s.prototype.handler=function(t,e){return Promise.resolve().then(function(){var n=e.fragmentHandler||this.getFragmentHandler();if(!n){return Promise.reject("Fragment handler function is not available in the handler")}var r=t[0];var i=r.getElement();var a=p(i);return n(r,a)}.bind(this)).then(function(t){if(!t.extensionPointName||!(typeof t.extensionPointName==="string")){return Promise.reject("Extension point name is not selected!")}if(!t.fragmentPath||!(typeof t.fragmentPath==="string")){return Promise.reject("Fragment path is not available")}return t}).then(function(n){return g.call(this,t,n)}.bind(this)).then(function(t){this.fireElementModified({command:t})}.bind(this)).catch(function(t){throw n.propagateError(t,"AddXMLAtExtensionPoint#handler","Error occurred in AddXMLAtExtensionPoint handler function","sap.ui.rta")})};s.prototype.getMenuItems=function(t){return this._getMenuItems(t,{pluginId:"CTX_ADDXML_AT_EXTENSIONPOINT",rank:110,icon:"sap-icon://add-equipment"})};s.prototype.getActionName=function(){return"AddXMLAtExtensionPoint"};s.prototype.getAction=function(){return{changeType:u}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/BaseCreate", ["sap/ui/core/Lib","sap/ui/rta/plugin/Plugin","sap/ui/fl/Utils","sap/ui/rta/Utils"],function(e,t,r,n){"use strict";var a=t.extend("sap.ui.rta.plugin.BaseCreate",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});a.prototype._isEditable=function(e){return Promise.all([this._isEditableCheck(e,true),this._isEditableCheck(e,false)]).then(function(e){return{asSibling:e[0],asChild:e[1]}})};a.prototype._isEditableCheck=function(e,t){var n=this._getParentOverlay(t,e);var a;if(!n||!n.getParentElementOverlay()){return Promise.resolve(false)}if(t){a=e.getParentAggregationOverlay().getAggregationName()}return this.checkAggregationsOnSelf(n,this.getActionName(),a).then(function(t){if(t){var a=r.getViewForControl(n.getElement());return this.hasStableId(e)&&r.checkControlId(a)}return false}.bind(this))};a.prototype._getParentOverlay=function(e,t){var r;var n=this.getResponsibleElementOverlay(t);if(e){r=n.getParentElementOverlay()}else{r=n}return r};a.prototype.getCreateActions=function(e,t){var r=this.getResponsibleElementOverlay(t);var n=this._getParentOverlay(e,r);var a=n.getDesignTimeMetadata();var i=a.getActionDataFromAggregations(this.getActionName(),r.getElement());if(e){var o=r.getParentAggregationOverlay().getAggregationName();return i.filter(function(e){return e.aggregation===o})}return i};a.prototype.getCreateAction=function(e,t,r){var n=this.getCreateActions(e,t);if(r){var a;n.some(function(e){if(e.aggregation===r){a=e;return true}});return a}return n[0]};a.prototype.isAvailable=function(e,t){return this._isEditableByPlugin(e[0],t)};a.prototype.isActionEnabled=function(e,t,r){if(!e){return false}if(e.isEnabled&&typeof e.isEnabled==="function"){var n=e.isEnabled;var a=this._getParentOverlay(t,r);return n(a.getElement())}return true};a.prototype.getCreatedContainerId=function(e,t){var r=t;if(e.getCreatedContainerId&&typeof e.getCreatedContainerId==="function"){var n=e.getCreatedContainerId;r=n(t)}return r};a.prototype._determineIndex=function(e,t,r,a){return n.getIndex(e,t,r,a)};a.prototype._getText=function(t,r,n,a){if(!t){return a}var i=n.getAggregationDescription(t.aggregation,r);if(!i){return a}var o=i.singular;var g=e.getResourceBundleFor("sap.ui.rta");return g.getText(a,[o])};a.prototype.getActionName=function(){throw new Error("abstract")};function i(){}a.prototype.getMenuItems=function(e){i(e);throw new Error("abstract")};a.prototype.handleCreate=function(e,t){i(e,t);throw new Error("abstract")};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/Combine", ["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/fl/Utils","sap/ui/dt/Util","sap/base/util/uid"],function(e,t,n,i,r){"use strict";var a=e.extend("sap.ui.rta.plugin.Combine",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});a.prototype._isEditable=function(e){var t=this.getAction(e);if(!e.isRoot()&&t&&t.changeOnRelevantContainer){return this._checkChangeHandlerAndStableId(e)}return Promise.resolve(false)};a.prototype._checkForSameRelevantContainer=function(e){var t=[];for(var n=0,i=e.length;n<i;n++){t[n]=e[n].getRelevantContainer();var r=this.getAction(e[n]);if(!r||!r.changeType){return false}if(n>0){if(t[0]!==t[n]||this.getAction(e[0]).changeType!==r.changeType){return false}}}return true};a.prototype._checkBindingCompatibilityOfControls=function(e,n){return e.every(function(i){return e.every(function(e){return i!==e?t.checkSourceTargetBindingCompatibility(i,e,n):true})})};a.prototype.isAvailable=function(e){if(e.length<=1){return false}return e.every(function(e){return this._isEditableByPlugin(e)},this)&&this._checkForSameRelevantContainer(e)};a.prototype.isEnabled=function(e){if(!this.isAvailable(e)||e.length<=1){return false}var t=e.map(function(e){return e.getElement()});var n=e.every(function(e){var n=this.getAction(e);if(!n){return false}if(typeof n.isEnabled!=="undefined"){if(typeof n.isEnabled==="function"){return n.isEnabled(t)}return n.isEnabled}return true},this);if(n){var i=t[0]&&t[0].getModel();return this._checkBindingCompatibilityOfControls(t,i)}return n};a.prototype.handleCombine=function(e,t){var a;var o=e.map(function(e){if(e.getElement().getId()===t.getId()){a=e}return e.getElement()});var u=a.getDesignTimeMetadata();var s=this.getVariantManagementReference(a);var c=n.getViewForControl(t);var l=c.createId(r());return this.getCommandFactory().getCommandFor(t,"combine",{newElementId:l,source:t,combineElements:o},u,s).then(function(e){this.fireElementModified({command:e})}.bind(this)).catch(function(e){throw i.createError("Combine#handleCombine",e,"sap.ui.rta")})};a.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_GROUP_FIELDS",rank:90,icon:"sap-icon://combine"})};a.prototype.getActionName=function(){return"combine"};a.prototype.handler=function(e,t){this.handleCombine(e,t.contextElement)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/CompVariant", ["sap/m/MessageBox","sap/base/util/restricted/_omit","sap/base/util/isEmptyObject","sap/ui/core/Lib","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/rta/plugin/Plugin","sap/ui/rta/plugin/RenameHandler","sap/ui/rta/Utils","sap/ui/fl/write/api/ContextSharingAPI"],function(t,e,a,n,i,r,o,s,c,l){"use strict";var d=o.extend("sap.ui.rta.plugin.CompVariant",{metadata:{library:"sap.ui.rta",properties:{oldValue:{type:"string"}}}});function g(t,e,a,n){var i=t.getDesignTimeMetadata();var o=n||t.getElement();return Promise.resolve().then(function(){if(e.length===1){return this.getCommandFactory().getCommandFor(o,e[0],a,i)}var t;return this.getCommandFactory().getCommandFor(o,"composite").then(function(n){t=n;var r=[];e.forEach(function(t){r.push(this.getCommandFactory().getCommandFor(o,t,a[t],i))}.bind(this));return Promise.all(r).then(function(e){e.forEach(t.addCommand.bind(t));return t})}.bind(this))}.bind(this)).then(function(t){this.fireElementModified({command:t})}.bind(this)).catch(function(t){throw r.createError(e[0],t,"sap.ui.rta.plugin.CompVariant")})}function u(t){return t.getElement().getAllVariants()}function p(t){this.startEdit(t[0])}d.prototype.startEdit=function(t){var e=t.getDesignTimeMetadata().getData().variantRenameDomRef;s.startEdit.call(this,{overlay:t,domRef:e,pluginMethodName:"plugin.CompVariant.startEdit"})};d.prototype.stopEdit=function(t){s._stopEdit.call(this,t,"plugin.CompVariant.stopEdit")};d.prototype._emitLabelChangeEvent=function(){var t=this._oEditedOverlay;var e=t.getElement().getPresentVariantId();var a=s._getCurrentEditableFieldText.call(this);var n={newVariantProperties:{}};n.newVariantProperties[e]={name:a};g.call(this,t,["compVariantUpdate"],n)};function m(t){var n=t[0].getElement();var i=this.getCommandFactory().getFlexSettings();i.variantManagementControl=n;var r={layer:this.getCommandFactory().getFlexSettings().layer,contextSharingComponentContainer:l.createComponent(i),rtaStyleClass:c.getRtaStyleClassName()};n.openManageViewsDialogForKeyUser(r,function(i){if(!a(i)){g.call(this,t[0],["compVariantUpdate"],{newVariantProperties:e(i,["default"]),newDefaultVariantId:i.default,oldDefaultVariantId:n.getDefaultVariantId()})}}.bind(this))}function h(e,a,i){if(i===t.Action.CANCEL){return}var r=n.getResourceBundleFor("sap.ui.rta");var o=e.getElement();var s;if(i===r.getText("BTN_MODIFIED_VARIANT_SAVE")){A(o).then(function(t){s={compVariantSwitch:{targetVariantId:a,sourceVariantId:o.getPresentVariantId()},compVariantUpdate:t};g.call(this,e,["compVariantUpdate","compVariantSwitch"],s)}.bind(this))}if(i===r.getText("BTN_MODIFIED_VARIANT_DISCARD")){g.call(this,e,["compVariantSwitch"],{targetVariantId:a,sourceVariantId:o.getPresentVariantId(),discardVariantContent:true})}}function V(t){return u(t[0]).length>1}function f(e,a){var i=e[0];var r=i.getElement();if(r.getModified()){var o=n.getResourceBundleFor("sap.ui.rta");var s=a.eventItem.getParameters().item.getProperty("key");t.warning(o.getText("MSG_CHANGE_MODIFIED_VARIANT"),{onClose:h.bind(this,i,s),actions:[o.getText("BTN_MODIFIED_VARIANT_SAVE"),o.getText("BTN_MODIFIED_VARIANT_DISCARD"),t.Action.CANCEL],emphasizedAction:o.getText("BTN_MODIFIED_VARIANT_SAVE"),styleClass:c.getRtaStyleClassName()})}else{g.call(this,i,["compVariantSwitch"],{targetVariantId:a.eventItem.getParameters().item.getProperty("key"),sourceVariantId:r.getPresentVariantId()})}}function A(t){return t.getPresentVariantContent().then(function(e){var a={onlySave:true,newVariantProperties:{}};a.newVariantProperties[t.getPresentVariantId()]={content:e};return a})}function C(t){var e=t[0].getElement();A(e).then(function(e){g.call(this,t[0],["compVariantUpdate"],e)}.bind(this))}function v(t){return t[0].getElement().currentVariantGetModified()}function E(t,e){var a=t[0].getElement();var n=this.getCommandFactory().getFlexSettings();n.variantManagementControl=a;var i=l.createComponent(n);return new Promise(function(n){a.openSaveAsDialogForKeyUser(c.getRtaStyleClassName(),function(i){if(i){g.call(this,t[0],["compVariantSaveAs"],{newVariantProperties:{default:i.default,executeOnSelection:i.executeOnSelection,content:i.content,type:i.type,text:i.text,contexts:i.contexts},previousDirtyFlag:a.getModified(),previousVariantId:a.getPresentVariantId(),previousDefault:a.getDefaultVariantId(),activateAfterUndo:!!e})}n(i)}.bind(this),i)}.bind(this))}function I(t,e,a){var r=n.getResourceBundleFor("sap.ui.rta");if(a===r.getText("BTN_CREATE_NEW_VIEW")){E.call(this,[i.getOverlay(t)],true).then(function(a){if(!a){t.activateVariant(e)}})}else{t.activateVariant(e)}}function T(e){var a=n.getResourceBundleFor("sap.ui.rta");var i=e[0];var r=i.getElement();var o=this.getAction(i);var s=r.getVariantManagement();var l=s.getModified();return o.handler(r,{styleClass:c.getRtaStyleClassName()}).then(function(e){if(e&&e.length){var n=e[0].changeSpecificData.content.persistencyKey;var r=s.getAllVariants();var o=r.find(function(t){return t.getVariantId()===s.getPresentVariantId()});if(o.isEditEnabled(this.getCommandFactory().getFlexSettings().layer)){g.call(this,i,["compVariantContent"],{variantId:e[0].changeSpecificData.content.key,newContent:e[0].changeSpecificData.content.content,persistencyKey:n,isModifiedBefore:l},s)}else{t.warning(a.getText("MSG_CHANGE_READONLY_VARIANT"),{onClose:I.bind(this,s,o.getVariantId()),actions:[a.getText("BTN_CREATE_NEW_VIEW"),t.Action.CANCEL],emphasizedAction:a.getText("BTN_CREATE_NEW_VIEW"),styleClass:c.getRtaStyleClassName()})}}}.bind(this))}d.prototype._isEditable=function(t){return this.hasStableId(t)&&!!this.getAction(t)};d.prototype.getMenuItems=function(t){var e=t[0];var a=e.getElement();var i=[];if(this.isAvailable([e])){if(this.getAction(e).changeType==="variantContent"){i.push({id:"CTX_COMP_VARIANT_CONTENT",text:this.getActionText(e,this.getAction(e)),handler:T.bind(this),enabled:true,rank:250,icon:"sap-icon://key-user-settings"})}else{var r=this.getCommandFactory().getFlexSettings().layer;var o=n.getResourceBundleFor("sap.ui.rta");var s=u(e);var c=s.find(function(t){return t.getVariantId()===a.getPresentVariantId()});if(c.isRenameEnabled(r)){i.push({id:"CTX_COMP_VARIANT_RENAME",text:o.getText("CTX_RENAME"),handler:p.bind(this),enabled:true,rank:210,icon:"sap-icon://edit"})}if(c.isEditEnabled(r)){i.push({id:"CTX_COMP_VARIANT_SAVE",text:o.getText("CTX_VARIANT_SAVE"),handler:C.bind(this),enabled:v,rank:220,icon:"sap-icon://save"})}i.push({id:"CTX_COMP_VARIANT_SAVE_AS",text:o.getText("CTX_VARIANT_SAVEAS"),handler:E.bind(this),enabled:true,rank:230,icon:"sap-icon://duplicate"});i.push({id:"CTX_COMP_VARIANT_MANAGE",text:o.getText("CTX_VARIANT_MANAGE"),handler:m.bind(this),enabled:true,rank:240,icon:"sap-icon://action-settings"});var l=s.map(function(t){var e=a.getPresentVariantId()===t.getVariantId();var n={id:t.getVariantId(),text:t.getText("variantName"),icon:e?"sap-icon://accept":"blank",enabled:!e};return n});i.push({id:"CTX_COMP_VARIANT_SWITCH",text:o.getText("CTX_VARIANT_SWITCH"),handler:f.bind(this),enabled:V,submenu:l,rank:250,icon:"sap-icon://switch-views"})}}return i};d.prototype.getActionName=function(){return"compVariant"};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/ControlVariant", ["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/rta/plugin/Plugin","sap/ui/rta/plugin/RenameHandler","sap/ui/rta/Utils","sap/ui/dt/ElementOverlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/Layer","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/variants/VariantManagement","sap/ui/fl/write/api/ContextSharingAPI","sap/ui/base/ManagedObject","sap/base/Log","sap/m/MessageBox"],function(t,e,a,n,i,r,o,s,l,g,u,c,d,m,h,p,f){"use strict";r.prototype._variantManagement=undefined;r.prototype.getVariantManagement=function(){return this._variantManagement};r.prototype.setVariantManagement=function(t){this._variantManagement=t};r.prototype.hasVariantManagement=function(){return!!this._variantManagement};function v(t){var e=t.getElement().getManageDialog();if(e&&!e.bIsDestroyed){e.destroy()}}var V=a.extend("sap.ui.rta.plugin.ControlVariant",{metadata:{library:"sap.ui.rta",properties:{oldValue:"string"},associations:{},events:{}}});function C(t){var e=t.getElement();var a=t.getDesignTimeMetadata();var n=this._getVariantModel(e);var i=t.getVariantManagement();return this.getCommandFactory().getCommandFor(e,"save",{model:n},a,i)}function E(t,e,a,n){var i=t.getElement();var r=t.getDesignTimeMetadata();return this.getCommandFactory().getCommandFor(i,"switch",{targetVariantReference:e,sourceVariantReference:a,discardVariantContent:n},r)}V.prototype.registerElementOverlay=function(...e){const[i]=e;var r=i.getElement();var s;a.prototype.registerElementOverlay.apply(this,e);if(r instanceof d){var l=r.getFor();var u;var c=g.getAppComponentForControl(r);var m=r.getId();s=c.getLocalId(m)||m;i.setVariantManagement(s);if(!l||Array.isArray(l)&&l.length===0){return}u=!Array.isArray(l)?[l]:l;u.forEach(function(e){var a=e instanceof h?e:t.getElementById(e);var n=o.getOverlay(a);this._propagateVariantManagement(n,s)}.bind(this));i.attachEvent("editableChange",n._manageClickEvent,this);v(i)}else if(!i.getVariantManagement()){s=this._getVariantManagementFromParent(i);if(s){i.setVariantManagement(s);i.attachEvent("editableChange",n._manageClickEvent,this)}}};V.prototype._isPersonalizationMode=function(){return this.getCommandFactory().getFlexSettings().layer===u.USER};V.prototype._propagateVariantManagement=function(t,e){var a=[];t.setVariantManagement(e);a=s.getAllChildOverlays(t);a.forEach(function(t){a=a.concat(this._propagateVariantManagement(t,e))}.bind(this));return a};V.prototype._getVariantManagementFromParent=function(t){var e=t.getVariantManagement();if(!e&&t.getParentElementOverlay()){return this._getVariantManagementFromParent(t.getParentElementOverlay())}return e};V.prototype.deregisterElementOverlay=function(...t){const e=t[0];if(this._isVariantManagementControl(e)){v(e)}e.detachEvent("editableChange",n._manageClickEvent,this);e.detachBrowserEvent("click",n._onClick,this);this.removeFromPluginsList(e);a.prototype.deregisterElementOverlay.apply(this,t)};V.prototype._getVariantModel=function(t){var e=g.getAppComponentForControl(t);return e?e.getModel(c.getVariantModelName()):undefined};V.prototype._isEditable=function(t){if(this._isPersonalizationMode()){return false}return this._isVariantManagementControl(t)&&this.hasStableId(t)};V.prototype._isVariantManagementControl=function(t){var e=t.getElement();var a=e.getAssociation("for");return!!(a&&e instanceof d)};V.prototype.isVariantSwitchAvailable=function(t){return this._isVariantManagementControl(t)};V.prototype.isVariantSwitchEnabled=function(t){var e=t[0];var a=[];if(this._isVariantManagementControl(e)){var n=e.getElement();var i=e.getVariantManagement?e.getVariantManagement():undefined;if(!i){return false}var r=this._getVariantModel(n);if(r){a=r.getData()[i].variants.reduce(function(t,e){if(e.visible){return t.concat(e)}return t},[])}var o=a.length>1;return o}return false};V.prototype.setDesignTime=function(t){n._setDesignTime.call(this,t)};V.prototype.isRenameAvailable=function(t){return this._isVariantManagementControl(t)};V.prototype.isRenameEnabled=function(t){return this._isVariantManagementControl(t[0])};V.prototype.isVariantSaveAvailable=function(t){return this._isVariantManagementControl(t)};V.prototype.isVariantSaveEnabled=function(t){var e=t[0];var a=e.getElement();var n=this._getVariantModel(a);var i=e.getVariantManagement();return n.oData[i]&&n.oData[i].modified};V.prototype.isVariantSaveAsAvailable=function(t){return this._isVariantManagementControl(t)};V.prototype.isVariantSaveAsEnabled=function(t){return this._isVariantManagementControl(t[0])};V.prototype.isVariantConfigureAvailable=function(t){return this._isVariantManagementControl(t)};V.prototype.isVariantConfigureEnabled=function(t){return this._isVariantManagementControl(t[0])};V.prototype.switchVariant=function(t,a,n){var r=t.getElement();var o=e.getResourceBundleFor("sap.ui.rta");function s(e){if(e===f.Action.CANCEL){return}if(e===o.getText("BTN_MODIFIED_VARIANT_SAVE")){var i;this.getCommandFactory().getCommandFor(r,"composite").then(function(e){i=e;return C.call(this,t)}.bind(this)).then(function(e){i.addCommand(e);return E.call(this,t,a,n)}.bind(this)).then(function(t){i.addCommand(t);this.fireElementModified({command:i})}.bind(this))}if(e===o.getText("BTN_MODIFIED_VARIANT_DISCARD")){E.call(this,t,a,n,true).then(function(t){this.fireElementModified({command:t})}.bind(this))}}if(r.getModified()){f.warning(o.getText("MSG_CHANGE_MODIFIED_VARIANT"),{onClose:s.bind(this),actions:[o.getText("BTN_MODIFIED_VARIANT_SAVE"),o.getText("BTN_MODIFIED_VARIANT_DISCARD"),f.Action.CANCEL],emphasizedAction:o.getText("BTN_MODIFIED_VARIANT_SAVE"),styleClass:i.getRtaStyleClassName()})}else{E.call(this,t,a,n).then(function(t){this.fireElementModified({command:t})}.bind(this)).catch(function(t){throw l.createError("ControlVariant#switchVariant",t,"sap.ui.rta")})}};V.prototype.renameVariant=function(t){this.startEdit(t[0])};V.prototype.startEdit=function(t){var e=t.getDesignTimeMetadata().getData().variantRenameDomRef;n.startEdit.call(this,{overlay:t,domRef:e,pluginMethodName:"plugin.ControlVariant.startEdit"})};V.prototype.stopEdit=function(t){n._stopEdit.call(this,t,"plugin.ControlVariant.stopEdit")};V.prototype.createSaveCommand=function(t){var e=t[0];return C.call(this,e).then(function(t){this.fireElementModified({command:t})}.bind(this))};V.prototype.createSaveAsCommand=function(t){var e=t[0];var a=e.getElement();var n=e.getDesignTimeMetadata();var i=this._getVariantModel(a);var r=e.getVariantManagement();var o=i.getCurrentVariantReference(r);return this.getCommandFactory().getCommandFor(a,"saveAs",{sourceVariantReference:o,model:i},n,r).then(function(t){this.fireElementModified({command:t})}.bind(this))};V.prototype._emitLabelChangeEvent=function(){var t=n._getCurrentEditableFieldText.call(this);var e=this._oEditedOverlay;var a=e.getDesignTimeMetadata();var i=e.getElement();var r=e.getVariantManagement();return this._createSetTitleCommand({text:t,element:i,designTimeMetadata:a,variantManagementReference:r}).then(function(t){this.fireElementModified({command:t})}.bind(this))};V.prototype._createSetTitleCommand=function(t){this._oEditableControlDomRef.textContent=t.text;return this.getCommandFactory().getCommandFor(t.element,"setTitle",{newText:t.text},t.designTimeMetadata,t.variantManagementReference).catch(function(t){p.error("Error during rename: ",t)})};V.prototype._prepareOverlayForValueState=function(t,e){t.getValueState=function(){return"Error"};t.getValueStateText=function(){return e};t.getDomRefForValueStateMessage=function(){return this.$()}};V.prototype.configureVariants=function(t){var e=t[0];var a=e.getElement();var n=e.getVariantManagement();var r=this._getVariantModel(a);var o=e.getDesignTimeMetadata();var s=this.getCommandFactory().getFlexSettings();var g=s;g.variantManagementControl=a;return r.manageVariants(a,n,s.layer,i.getRtaStyleClassName(),m.createComponent(g)).then(function(t){if(t.length>0){return this.getCommandFactory().getCommandFor(a,"configure",{control:a,changes:t},o,n)}return undefined}.bind(this)).then(function(t){if(t){this.fireElementModified({command:t})}}.bind(this)).catch(function(t){throw l.createError("ControlVariant#configureVariants",t,"sap.ui.rta")})};V.prototype.getMenuItems=function(t){var a=t[0];var n=[];if(this.isRenameAvailable(a)){n.push({id:"CTX_VARIANT_SET_TITLE",text:e.getResourceBundleFor("sap.ui.rta").getText("CTX_RENAME"),handler:this.renameVariant.bind(this),enabled:this.isRenameEnabled.bind(this),rank:210,icon:"sap-icon://edit"})}if(this.isVariantSaveAvailable(a)){n.push({id:"CTX_VARIANT_SAVE",text:e.getResourceBundleFor("sap.ui.rta").getText("CTX_VARIANT_SAVE"),handler:this.createSaveCommand.bind(this),enabled:this.isVariantSaveEnabled.bind(this),rank:220,icon:"sap-icon://save"})}if(this.isVariantSaveAsAvailable(a)){n.push({id:"CTX_VARIANT_SAVEAS",text:e.getResourceBundleFor("sap.ui.rta").getText("CTX_VARIANT_SAVEAS"),handler:this.createSaveAsCommand.bind(this),enabled:this.isVariantSaveAsEnabled.bind(this),rank:225,icon:"sap-icon://duplicate"})}if(this.isVariantConfigureAvailable(a)){n.push({id:"CTX_VARIANT_MANAGE",text:e.getResourceBundleFor("sap.ui.rta").getText("CTX_VARIANT_MANAGE"),handler:this.configureVariants.bind(this),enabled:this.isVariantConfigureEnabled.bind(this),startSection:true,rank:230,icon:"sap-icon://action-settings"})}if(this.isVariantSwitchAvailable(a)){var i=this._getVariantModel(a.getElement());var r=a.getVariantManagement();var o=i.getData()[r].variants.reduce(function(t,e){if(e.visible){var a=i.getData()[r].currentVariant===e.key;var n={id:e.key,text:e.title,icon:a?"sap-icon://accept":"blank",enabled:!a};return t.concat(n)}return t},[]);n.push({id:"CTX_VARIANT_SWITCH_SUBMENU",text:e.getResourceBundleFor("sap.ui.rta").getText("CTX_VARIANT_SWITCH"),handler:function(t,e){var a=e.eventItem.getParameters().item.getProperty("key");var n=t[0];var o=i.getData()[r].currentVariant;return this.switchVariant(n,a,o)}.bind(this),enabled:this.isVariantSwitchEnabled.bind(this),submenu:o,rank:240,icon:"sap-icon://switch-views"})}return n};V.prototype.getActionName=function(){return"controlVariant"};return V});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/CreateContainer", ["sap/ui/rta/plugin/BaseCreate","sap/ui/fl/Utils","sap/ui/dt/Util","sap/base/util/uid"],function(t,e,a,r){"use strict";var n=t.extend("sap.ui.rta.plugin.CreateContainer",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});n.prototype.isEnabled=function(t,e){var a=t[0];var r=this.getCreateAction(e,a);return this.isActionEnabled(r,e,a)};n.prototype.getCreateContainerText=function(t,e){var a=this.getCreateAction(t,e);var r=this._getParentOverlay(t,e);var n=r.getDesignTimeMetadata();var i=r.getElement();var o="CTX_CREATE_CONTAINER";return this._getText(a,i,n,o)};n.prototype._getContainerTitle=function(t,e,a){var r="TITLE_CREATE_CONTAINER";return this._getText(t,e,a,r)};n.prototype.handleCreate=function(t,n){var i=this.getCreateAction(t,n);var o=this._getParentOverlay(t,n);var s=o.getElement();var g=o.getDesignTimeMetadata();var d=e.getViewForControl(s);var C;if(t){C=n.getElement()}var u=d.createId(r());var l=g.getAggregation(i.aggregation).getIndex;var h=this._determineIndex(s,C,i.aggregation,l);var c=this.getVariantManagementReference(o);return this.getCommandFactory().getCommandFor(s,"createContainer",{newControlId:u,label:this._getContainerTitle(i,s,g),index:h,parentId:s.getId()},g,c).then(function(t){this.fireElementModified({command:t,action:i,newControlId:u})}.bind(this)).catch(function(t){throw a.createError("CreateContainer#handleCreate",t,"sap.ui.rta")})};n.prototype.getMenuItems=function(t){var e=true;var a="CTX_CREATE_SIBLING_CONTAINER";var r=40;var n=[];var i=function(t,e){return this.isEnabled(e,t)}.bind(this);for(var o=0;o<2;o++){if(this.isAvailable(t,e)){n.push({id:a,text:this.getCreateContainerText.bind(this,e),handler:this.handleCreate.bind(this,e,t[0]),enabled:i.bind(this,e),icon:"sap-icon://add-folder",rank:r})}e=false;a="CTX_CREATE_CHILD_CONTAINER";r=50}return n};n.prototype.getActionName=function(){return"createContainer"};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/CutPaste", ["sap/ui/core/Lib","sap/ui/dt/plugin/CutPaste","sap/ui/dt/Util","sap/ui/rta/plugin/Plugin","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/Utils"],function(t,e,i,n,r,a){"use strict";var o=e.extend("sap.ui.rta.plugin.CutPaste",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{dragStarted:{},elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});a.extendWith(o.prototype,n.prototype,function(t,e,i){return i!=="getMetadata"});o.prototype.init=function(...t){e.prototype.init.apply(this,t);this.setElementMover(new r({commandFactory:this.getCommandFactory()}))};o.prototype._isEditable=function(t,e){return this.getElementMover().isEditable(t,e.onRegistration).then(function(e){if(e){return true}return this._isPasteEditable(t)}.bind(this))};o.prototype._isPasteEditable=function(t){var e=this.getElementMover();if(!this.hasStableId(t)){return Promise.resolve(false)}return e.isMoveAvailableOnRelevantContainer(t).then(function(i){if(!i){return false}return a.doIfAllControlsAreAvailable([t],function(){return e.isMoveAvailableForChildren(t)})})};o.prototype.isAvailable=function(t){return t.every(function(t){return t.getMovable()})};o.prototype.registerElementOverlay=function(...t){e.prototype.registerElementOverlay.apply(this,t);n.prototype.registerElementOverlay.apply(this,t)};o.prototype.deregisterElementOverlay=function(...t){e.prototype.deregisterElementOverlay.apply(this,t);n.prototype.removeFromPluginsList.apply(this,t)};o.prototype.paste=function(t){this._executePaste(t);i.waitForSynced(this.getDesignTime())().then(function(){return this.getElementMover().buildMoveCommand()}.bind(this)).then(function(t){this.fireElementModified({command:t});this.stopCutAndPaste()}.bind(this)).catch(function(t){throw i.createError("CutPaste#paste",t,"sap.ui.rta")})};o.prototype.cut=function(...t){const[i]=t;return e.prototype.cut.apply(this,t).then(function(){i.setSelected(false)})};o.prototype.getMenuItems=function(e){var i=[];var n=this.enhanceItemWithResponsibleElement({id:"CTX_PASTE",text:t.getResourceBundleFor("sap.ui.rta").getText("CTX_PASTE"),handler:function(t){return this.paste(t[0])}.bind(this),enabled:function(t){return this.isElementPasteable(t[0])}.bind(this),rank:80,icon:"sap-icon://paste"},e,["move"]);var r=n.responsible||e;if(this.isAvailable(r)){var a=this.enhanceItemWithResponsibleElement({id:"CTX_CUT",text:t.getResourceBundleFor("sap.ui.rta").getText("CTX_CUT"),handler:function(t){return this.cut(t[0])}.bind(this),enabled(t){return t.length===1},rank:70,icon:"sap-icon://scissors"},e,["move"]);i.push(a,n);return i}return this._isPasteEditable(e[0]).then(function(t){if(t){i.push(n)}return i})};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/DragDrop", ["sap/ui/dt/plugin/ControlDragDrop","sap/ui/dt/Util","sap/ui/dt/OverlayRegistry","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils"],function(t,e,r,a,o,n){"use strict";var i=t.extend("sap.ui.rta.plugin.DragDrop",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{dragStarted:{},elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});n.extendWith(i.prototype,o.prototype,function(t,e,r){return r!=="getMetadata"});i.prototype.init=function(...e){t.prototype.init.apply(this,e);this.setElementMover(new a({commandFactory:this.getCommandFactory()}))};i.prototype.setCommandFactory=function(t){this.setProperty("commandFactory",t);this.getElementMover().setCommandFactory(t)};i.prototype._isEditable=function(t,e){return this.getElementMover().isEditable(t,e.onRegistration)};i.prototype.registerElementOverlay=function(...e){t.prototype.registerElementOverlay.apply(this,e);o.prototype.registerElementOverlay.apply(this,e)};i.prototype.deregisterElementOverlay=function(...e){t.prototype.deregisterElementOverlay.apply(this,e);o.prototype.removeFromPluginsList.apply(this,e)};i.prototype.onDragStart=function(...e){const[r]=e;this.fireDragStarted();t.prototype.onDragStart.apply(this,e);this.getSelectedOverlays().forEach(function(t){t.setSelected(false)});r.getDomRef().classList.add("sapUiRtaOverlayPlaceholder")};i.prototype.onDragEnd=function(r){this.getElementMover().buildMoveCommand().then(function(...e){const[a]=e;this.fireElementModified({command:a});r.getDomRef().classList.remove("sapUiRtaOverlayPlaceholder");r.setSelected(true);r.focus();t.prototype.onDragEnd.apply(this,e);this._updateRelevantOverlays()}.bind(this)).catch(function(t){throw e.propagateError(t,"DragDrop#onDragEnd","Error accured during onDragEnd execution","sap.ui.rta.plugin")})};i.prototype.onMovableChange=function(...e){t.prototype.onMovableChange.apply(this,e)};i.prototype._updateRelevantOverlays=function(){var t=this.getElementMover().getSourceAndTargetParentInformation();var e=t.sourceParentInformation.parent;var a=t.targetParentInformation.parent;var o=t.sourceParentInformation.aggregation;var n=t.targetParentInformation.aggregation;var i=e&&e.getAggregation(o);var p=[];if(i&&i.length>0){var s=r.getOverlay(i[0]);p=this._getRelevantOverlays(s,o)}if(a&&(a!==e||a===e&&o!==n)){var l=a&&a.getAggregation(n);if(l&&l.length>1){var g=t.targetParentInformation.index;var y=l[g+1]||l[g-1];var d=r.getOverlay(y);var u=this._getRelevantOverlays(d,n);p=p.concat(u)}}if(p.length>0){p=p.filter(function(t,e,r){return e===r.indexOf(t)});this.evaluateEditable(p,{onRegistration:false})}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/EasyAdd", ["sap/ui/core/Lib","sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/dt/OverlayRegistry","sap/m/Button"],function(e,t,a,s){"use strict";var i=t.extend("sap.ui.rta.plugin.EasyAdd",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});i.prototype.registerElementOverlay=function(...e){const[s]=e;var i=s.getElement();if(i.getMetadata().getName()==="sap.uxap.ObjectPageSection"&&this.hasStableId(s)){s.addStyleClass("sapUiRtaPersAdd");i.addStyleClass("sapUiRtaMarginBottom")}else if(i.getMetadata().getName()==="sap.uxap.ObjectPageLayout"&&this.hasStableId(s)){s.addStyleClass("sapUiRtaPersAddTop");i.getDomRef().querySelectorAll("[id*='sectionsContainer']").forEach(function(e){e.classList.add("sapUiRtaPaddingTop")})}var r=function(e,t,a){var s;var i="sections";if(e){s=t.getDesignTimeMetadata().getName().plural}else{s=t.getDesignTimeMetadata().getAggregation(i).childNames.plural()}this.clearCachedElements();this.showAvailableElements(e,i,[t],a,s)}.bind(this);var n=function(e,t,s,i,n){var o=function(e){var t=a.getOverlay(e.currentTarget.id.replace("-AddButton",""));r(s,t,n);e.stopPropagation()};var l=typeof i==="function"?i():i;this._addButton(e,o,t,l,s)}.bind(this);if(s.hasStyleClass("sapUiRtaPersAdd")){var o=Array.from(s.getDomRef().querySelectorAll(":scope > .sapUiRtaPersAddIconOuter"));var l=s.hasStyleClass("sapUiRtaPersAdd")&&o.length===0;if(l){n(s,s.getDomRef(),true,s.getDesignTimeMetadata().getName().singular)}}else if(s.hasStyleClass("sapUiRtaPersAddTop")){var o=Array.from(s.getAggregationOverlay("sections").getDomRef().querySelectorAll(":scope > .sapUiRtaPersAddIconOuter"));if(o.length===0){var d=s.getAggregationOverlay("sections").getDomRef();n(s,d,false,s.getDesignTimeMetadata().getAggregation("sections").childNames.singular,0)}}t.prototype.registerElementOverlay.apply(this,e)};i.prototype.deregisterElementOverlay=function(...e){const[a]=e;var s=a.getElement();if(a._oAddButton){a._oAddButton.destroy()}if(s.getMetadata().getName()==="sap.uxap.ObjectPageSection"){a.removeStyleClass("sapUiRtaPersAdd");s.removeStyleClass("sapUiRtaMarginBottom")}else if(s.getMetadata().getName()==="sap.uxap.ObjectPageLayout"){a.removeStyleClass("sapUiRtaPersAddTop");s.getDomRef().querySelectorAll("[id*='sectionsContainer']").forEach(function(e){e.classList.remove("sapUiRtaPaddingTop")})}t.prototype.deregisterElementOverlay.apply(this,e)};i.prototype._isEditable=function(...e){const[a]=e;return t.prototype._isEditable.apply(this,e).then(function(e){if(a._oAddButton){var t=a.hasStyleClass("sapUiRtaPersAddTop");var s=t?"asChild":"asSibling";a._oAddButton.setEnabled(e[s]);if(t){var i=a.getElement();i.attachEventOnce("onAfterRenderingDOMReady",function(){i.getDomRef().querySelectorAll("[id*='sectionsContainer']").forEach(function(e){e.classList.add("sapUiRtaPaddingTop")})})}}return e})};i.prototype._addButton=function(t,i,r,n,o){var l=t.getEditableByPlugins().indexOf(this._retrievePluginName(o))>-1;var d=e.getResourceBundleFor("sap.ui.rta");var g=`${t.getId()}-AddButton`;var p=document.createElement("div");p.classList.add("sapUiRtaPersAddIconOuter");p.setAttribute("draggable","true");p.setAttribute("tabindex",-1);t._oAddButton=new s(g,{text:d.getText("CTX_ADD_ELEMENTS",[n]),icon:"sap-icon://add",enabled:l}).placeAt(p).attachBrowserEvent("click",i).attachBrowserEvent("tap",i);r.append(p);p.addEventListener("mouseover",function(e){e.stopPropagation();var t=e.fromElement?a.getOverlay(e.fromElement.id):null;if(t&&t.getMetadata().getName()==="sap.ui.dt.ElementOverlay"){var s=t.getParentElementOverlay();s.removeStyleClass("sapUiRtaOverlayHover")}});p.addEventListener("mouseleave",function(e){e.stopPropagation();var t=e.toElement?a.getOverlay(e.toElement.id):null;if(t&&t.getMetadata().getName()==="sap.ui.dt.ElementOverlay"){var s=t.getParentElementOverlay();if(s.getMovable()){s.addStyleClass("sapUiRtaOverlayHover")}}});p.addEventListener("click",function(e){e.stopPropagation()});p.addEventListener("contextmenu",function(e){e.stopPropagation();e.preventDefault()});p.addEventListener("dragstart",function(e){e.stopPropagation();e.preventDefault()})};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/EasyRemove", ["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/rta/plugin/Remove","sap/m/Button"],function(e,t,a,r){"use strict";var n=a.extend("sap.ui.rta.plugin.EasyRemove",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});n.prototype.registerElementOverlay=function(...t){const[r]=t;var n=r.getElement();if(n.getMetadata().getName()==="sap.uxap.ObjectPageSection"&&this.hasStableId(r)){r.addStyleClass("sapUiRtaPersDelete")}var o=Array.from(r.getDomRef().querySelectorAll(":scope > .sapUiRtaPersDeleteClick"));if(r.hasStyleClass("sapUiRtaPersDelete")&&o.length===0){var s=function(e){this.handler([e])}.bind(this);var i=this._addButton(r);i.attachBrowserEvent("contextmenu",function(e){e.stopPropagation();e.preventDefault()});var l=function(t){var a=e.getElementById(t.currentTarget.id.replace("-DeleteIcon",""));s(a);t.stopPropagation();t.preventDefault()};i.attachBrowserEvent("click",l).attachBrowserEvent("tap",l)}a.prototype.registerElementOverlay.apply(this,t)};n.prototype._isEditable=function(...e){const[t]=e;if(t._oDeleteButton){t._oDeleteButton.setEnabled(this.isEnabled([t]))}return a.prototype._isEditable.apply(this,e)};n.prototype._addButton=function(e){var a=this.isEnabled([e]);var n=`${e.getId()}-DeleteIcon`;var o=document.createElement("div");o.classList.add("sapUiRtaPersDeleteClick");o.setAttribute("draggable","true");var s=document.createElement("div");s.classList.add("sapUiRtaPersDeleteIconOuter");e._oDeleteButton=new r(n,{icon:"sap-icon://less",tooltip:t.getResourceBundleFor("sap.ui.rta").getText("CTX_REMOVE"),enabled:a}).placeAt(s);o.append(s);e.getDomRef().append(o);o.addEventListener("dragstart",function(e){e.stopPropagation();e.preventDefault()});return e._oDeleteButton};n.prototype.deregisterElementOverlay=function(...e){const[t]=e;var r=t.getElement();if(r.getMetadata().getName()==="sap.uxap.ObjectPageSection"){t.removeStyleClass("sapUiRtaPersDelete");if(t._oDeleteButton){t._oDeleteButton.destroy()}}a.prototype.deregisterElementOverlay.apply(this,e)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/LocalReset", ["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/rta/plugin/Plugin","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/write/api/LocalResetAPI","sap/ui/rta/command/CompositeCommand","sap/m/MessageToast","sap/ui/dt/OverlayRegistry"],function(e,t,a,n,r,i,o,s,l,u){"use strict";function p(e,t){return t?e.getCurrentVariantReference(t):""}var d=a.extend("sap.ui.rta.plugin.LocalReset",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});d.prototype._isEditable=function(e){if(!this.hasStableId(e)){return false}var t=this.getAction(e);return!!t};d.prototype.isEnabled=function(e){if(e.length!==1){return false}var t=e[0];var a=t.getElement();var n=this.getAction(t);if(!n){return false}var s=true;if(typeof n.isEnabled!=="undefined"){if(typeof n.isEnabled==="function"){s=n.isEnabled(a)}else{s=n.isEnabled}}var l=n.changeOnRelevantContainer?t.getRelevantContainer():a;var d=u.getOverlay(l);var c=r.getAppComponentForControl(l);var g=c.getModel(i.getVariantModelName());var m=p(g,this.getVariantManagementReference(d));return s&&o.isResetEnabled(l,{layer:this.getCommandFactory().getFlexSettings().layer,currentVariant:m})};d.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_LOCAL_RESET",rank:61,icon:"sap-icon://reset"})};d.prototype.getActionName=function(){return"localReset"};d.prototype.handler=function(a){var o=a[0];var u=o.getElement();var d=o.getDesignTimeMetadata();var c=this.getVariantManagementReference(o);var g=r.getAppComponentForControl(u);var m=g.getModel(i.getVariantModelName());var f=p(m,c);var v=!!f;var h=v?g.byId(c)||e.getElementById(c):undefined;var E=this.getCommandFactory();var y=new s;return Promise.all([E.getCommandFor(u,"localReset",{currentVariant:f},d,c),v&&E.getCommandFor(h,"save",{model:m},d,c)].filter(Boolean)).then(function(e){e.forEach(function(e){y.addCommand(e)});this.fireElementModified({command:y});if(v){var a=t.getResourceBundleFor("sap.ui.rta").getText("MSG_LOCAL_RESET_VARIANT_SAVE");l.show(a,{duration:5e3})}}.bind(this)).catch(function(e){throw n.propagateError(e,"LocalReset#handler","Error occurred during handler execution","sap.ui.rta.plugin")})};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/Plugin", ["sap/base/util/restricted/_debounce","sap/ui/dt/Plugin","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/rta/util/hasStableId"],function(e,t,i,n,a,r,s){"use strict";function l(e,t,i){var n=i;if(typeof this.getActionName()==="string"){if(this.isResponsibleElementActionAvailable(i)){n=this.getResponsibleElementOverlay(i)}}var a=n.getElement()&&n.getDesignTimeMetadata()&&!n.getDesignTimeMetadata().markedAsNotAdaptable()&&this._isEditable(n,Object.assign({sourceElementOverlay:i},e));if(a&&typeof a.then==="function"){a.then(function(e){this._handleModifyPluginList(i,e)}.bind(this));t.push(a)}else{this._handleModifyPluginList(i,a)}return t}var o=t.extend("sap.ui.rta.plugin.Plugin",{metadata:{abstract:true,library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});o.prototype._isEditable=function(){};o.prototype.executeWhenVisible=function(e,t){var i=function(n){if(n.getSource().getGeometry()&&n.getSource().getGeometry().visible){e.detachEvent("geometryChanged",i,this);t()}};var n=e.getGeometry();if(e.getElementVisibility()&&(!n||!n.visible)){e.attachEvent("geometryChanged",i,this)}else{t()}};function u(t,i,n,a){var r=i.getId();t[r]||={};t[r][n]||=e(a,16);t[r][n]()}var g=function(e){if(!this._mDebounceFunctions){this._mDebounceFunctions={insertOrRemove:{},addOrSet:{}}}var t=e.getParameters();var i;var n=e.getSource();if(t.type==="propertyChanged"&&t.name==="visible"){i=this._getRelevantOverlays(n);if(t.value===true){this.executeWhenVisible(n,function(){this.evaluateEditable(i,{onRegistration:false})}.bind(this))}else{this.evaluateEditable(i,{onRegistration:false})}}else if(t.type==="afterRendering"){if(this.getDesignTime().getStatus()==="synced"){this.evaluateEditable([n],{onRegistration:false})}else{this.getDesignTime().attachEventOnce("synced",function(){this.evaluateEditable([n],{onRegistration:false})},this)}}else if(t.type==="insertAggregation"||t.type==="removeAggregation"){u(this._mDebounceFunctions.insertOrRemove,n,t.name,function(){i=this._getRelevantOverlays(n,t.name);this.evaluateEditable(i,{onRegistration:false})}.bind(this))}else if(t.type==="addOrSetAggregation"){u(this._mDebounceFunctions.addOrSet,n,t.name,function(){var e=this.getDesignTime();if(!e){return}if(e.getStatus()==="synced"){i=this._getRelevantOverlays(n,t.name);this.evaluateEditable(i,{onRegistration:false})}else{e.attachEventOnce("synced",function(){i=this._getRelevantOverlays(n,t.name);this.evaluateEditable(i,{onRegistration:false})},this)}}.bind(this))}};o.prototype._getRelevantOverlays=function(e,t){var i=e.getRelevantOverlays();if(i.length===0){var n=[];if(!e.getIsPartOfTemplate()){n=a.findAllOverlaysInContainer(e);if(t){var r=e.getAggregationOverlay(t);var s=r?r.getChildren():[];s=s.filter(function(e){return n.indexOf(e)===-1});n=n.concat(s)}}e.setRelevantOverlays(n);return n}return i};o.prototype.evaluateEditable=function(e,t){if(!t.onRegistration&&this.getDesignTime()&&this.getDesignTime().getBusyPlugins().length){return}this.setProcessingStatus(true);var i=e.reduce(l.bind(this,t),[]);if(i.length){Promise.all(i).then(function(){this.setProcessingStatus(false)}.bind(this)).catch(function(){this.setProcessingStatus(false)}.bind(this))}else{this.setProcessingStatus(false)}};o.prototype._handleModifyPluginList=function(e,t){if(t!==undefined&&t!==null){if(typeof t==="boolean"){this._modifyPluginList(e,t)}else{this._modifyPluginList(e,t.asChild,false);this._modifyPluginList(e,t.asSibling,true)}}};o.prototype._modifyPluginList=function(e,t,i){if(t){this.addToPluginsList(e,i)}else{this.removeFromPluginsList(e,i)}};o.prototype._retrievePluginName=function(e){var t=this.getMetadata().getName();if(e!==undefined){t+=e?".asSibling":".asChild"}return t};o.prototype._isEditableByPlugin=function(e,t){var i=this._retrievePluginName(t);var n=e.getEditableByPlugins();return n.indexOf(i)>-1};o.prototype.registerElementOverlay=function(e){this.executeWhenVisible(e,function(){this.evaluateEditable([e],{onRegistration:true});e.attachElementModified(g,this)}.bind(this))};o.prototype.deregisterElementOverlay=function(e){this.removeFromPluginsList(e);this.removeFromPluginsList(e,true);this.removeFromPluginsList(e,false);e.detachElementModified(g,this)};o.prototype.hasStableId=function(e){return s(e)};o.prototype.getVariantManagementReference=function(e){var t;if(e.getVariantManagement){t=e.getVariantManagement()}return t};o.prototype.checkAggregationsOnSelf=function(e,t,i,a){var r=e.getDesignTimeMetadata();var s=e.getElement();var l=r.getActionDataFromAggregations(t,s,undefined,a);var o=l.filter(function(e){if(e&&i){return e.aggregation===i}return true})[0];var u=o?o.changeType:null;var g=o&&o.changeOnRelevantContainer;if(g){s=e.getRelevantContainer();var h=n.getOverlay(s);if(!this.hasStableId(h)){return Promise.resolve(false)}}if(u){return this.hasChangeHandler(u,s)}return Promise.resolve(false)};o.prototype.removeFromPluginsList=function(e,t){var i=this._retrievePluginName(t);e.removeEditableByPlugin(i);if(!e.getEditableByPlugins().length){e.setEditable(false)}};o.prototype.addToPluginsList=function(e,t){var i=this._retrievePluginName(t);var n=e.getEditableByPlugins();if(n.indexOf(i)===-1){e.addEditableByPlugin(i);e.setEditable(true)}};o.prototype.hasChangeHandler=function(e,t,n){return i.getChangeHandler({changeType:e,element:t,modifier:r,layer:this.getCommandFactory().getFlexSettings().layer,controlType:n}).then(function(){return true}).catch(function(){return false})};o.prototype.isAvailable=function(e){return e.every(function(e){return this._isEditableByPlugin(e)},this)};o.prototype._checkRelevantContainerStableID=function(e,t){if(e.changeOnRelevantContainer){var i=t.getRelevantContainer();var a=n.getOverlay(i);if(!this.hasStableId(a)){return false}}return true};o.prototype._checkChangeHandlerAndStableId=function(e){var t=this.getAction(e);if(t&&t.changeType){var i=t.changeOnRelevantContainer?e.getRelevantContainer():e.getElement();return this.hasChangeHandler(t.changeType,i).then(function(i){return i&&this._checkRelevantContainerStableID(t,e)&&this.hasStableId(e)}.bind(this))}return Promise.resolve(false)};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/RTAElementMover", ["sap/ui/dt/plugin/ElementMover","sap/ui/dt/OverlayUtil","sap/ui/dt/ElementUtil","sap/ui/rta/Utils","sap/ui/rta/command/CommandFactory","sap/ui/rta/plugin/Plugin","sap/ui/dt/OverlayRegistry"],function(e,t,n,r,a,i,o){"use strict";var s=e.extend("sap.ui.rta.plugin.RTAElementMover",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"any",defaultValue:a},movableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]}},associations:{},events:{}}});s.prototype.init=function(){this.oBasePlugin=new i({commandFactory:this.getCommandFactory()})};s.prototype.exit=function(){this.oBasePlugin.destroy()};s.prototype.setCommandFactory=function(e){this.setProperty("commandFactory",e);this.oBasePlugin.setCommandFactory(e)};s.prototype.isEditable=function(e,t){var n=e.getElement();if(!this.isMovableType(n)){return Promise.resolve(false)}return this.checkMovable(e,t).then(function(t){e.setMovable(t);return t})};function l(e,t){var r=e.getDesignTimeMetadata();var a=e.getParentElementOverlay();var i=r.markedAsNotAdaptable();if(!r||!a||i){return Promise.resolve(false)}var s=e.getElement();if(s.isDestroyStarted()||n.isElementDirectTemplateChild(s)){return Promise.resolve(false)}var l=e.getRelevantContainer();var v=o.getOverlay(l);if(!v){return Promise.resolve(false)}return this.isMoveAvailableOnRelevantContainer(e).then(function(t){t&&=this.oBasePlugin.hasStableId(e)&&this.oBasePlugin.hasStableId(a)&&this.oBasePlugin.hasStableId(v);return t}.bind(this)).then(function(n){if(n){return u.call(this,e,v,t)}return n}.bind(this))}function u(e,n,r){var a=t.findAllUniqueAggregationOverlaysInContainer(e,n);var i=a.map(function(t){return this.checkTargetZone(t,e,r).then(function(e){return e?t:undefined})}.bind(this));return Promise.all(i).then(function(e){e=e.filter(function(e){return!!e});if(e.length<1){return false}else if(e.length===1){var t=e[0].getChildren().filter(function(e){var t=e.getElement();return t&&t.getVisible()&&t.getParent()});return t.length>1}return true})}e.prototype._getMoveAction=function(e){var t;var n=e.getParentAggregationOverlay();if(n){t=n.getDesignTimeMetadata()}return t?t.getAction("move",e.getElement()):undefined};e.prototype.isMovableType=function(){return true};s.prototype.checkMovable=function(e,t){return l.call(this,e,t)};s.prototype.checkTargetZone=function(e,t,n){var a=t||this.getMovedOverlay();return r.checkTargetZone(e,a,this.oBasePlugin,n)};s.prototype.isMoveAvailableOnRelevantContainer=function(e){var t;var n=this._getMoveAction(e);if(n&&n.changeType){t=e.getRelevantContainer();var r=o.getOverlay(t);if(!this.oBasePlugin.hasStableId(r)){return Promise.resolve(false)}return this.oBasePlugin.hasChangeHandler(n.changeType,t)}return Promise.resolve(false)};s.prototype.isMoveAvailableForChildren=function(e){var t=e.getDesignTimeMetadata();var n=t.getAggregationNamesWithAction("move");var r=[];n.forEach(function(t){var n=e.getAggregationOverlay(t);if(n){var a=n.getChildren();var i=a.map(this.checkMovable.bind(this));r=r.concat(i)}else{r.push(Promise.resolve(false))}}.bind(this));return Promise.all(r).then(function(e){return e.some(function(e){return e})})};s.prototype.buildMoveCommand=function(){var e=this.getMovedOverlay();var n=e.getParentAggregationOverlay();var r=e.getElement();var a=this._getSource();var i=e.getRelevantContainer();var o=t.getParentInformation(e);var s=a.index;var l=o.index;var u=this._compareSourceAndTarget(a,o);if(u){return Promise.resolve()}delete a.index;delete o.index;var v=this.oBasePlugin.getVariantManagementReference(e);return this.getCommandFactory().getCommandFor(i,"Move",{movedElements:[{element:r,sourceIndex:s,targetIndex:l}],source:a,target:o},n.getDesignTimeMetadata(),v)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/Remove", ["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/rta/command/CompositeCommand","sap/ui/dt/OverlayRegistry","sap/ui/events/KeyCodes","sap/base/Log"],function(e,t,n,r,i,o){"use strict";var a=e.extend("sap.ui.rta.plugin.Remove",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});a.prototype.registerElementOverlay=function(...t){const[n]=t;if(this.isEnabled([n])){n.attachBrowserEvent("keydown",this._onKeyDown,this)}e.prototype.registerElementOverlay.apply(this,t)};a.prototype._isEditable=function(e){return this._checkChangeHandlerAndStableId(e)};a.prototype.isEnabled=function(e){var t=e.map(function(e){return this.getResponsibleElementOverlay(e)}.bind(this));var n=t[0];var r=this.getAction(n);var i=false;if(!r){return i}if(typeof r.isEnabled!=="undefined"){if(typeof r.isEnabled==="function"){i=r.isEnabled(n.getElement())}else{i=r.isEnabled}}else{i=true}return i&&this._canBeRemovedFromAggregation(t)};a.prototype._canBeRemovedFromAggregation=function(e){var t=function(e){var t=e.getParentAggregationOverlay();if(t){var n=this.getAction(t);return!!(n&&n.removeLastElement)}return false}.bind(this);var n=e[0];var i=n.getElement();var o=i.getParent();if(!o){return false}var a=o.getAggregation(i.sParentAggregationName);if(!Array.isArray(a)){return true}var s=e.length;var l=a.filter(function(e){var t=r.getOverlay(e);return!(t&&t.getElementVisibility())});var g=l.length+s===a.length;if(g){return t(n)}return true};a.prototype._getConfirmationText=function(e){var t=this.getAction(e);if(t&&t.getConfirmationText){return t.getConfirmationText(e.getElement())}};a.prototype.deregisterElementOverlay=function(...t){const[n]=t;if(this.isEnabled([n])){n.detachBrowserEvent("keydown",this._onKeyDown,this)}e.prototype.deregisterElementOverlay.apply(this,t)};a.prototype._onKeyDown=function(e){if(e.keyCode===i.DELETE||e.keyCode===i.BACKSPACE){e.stopPropagation();this.removeElement()}};a.prototype.removeElement=function(e){var t=e||this.getSelectedOverlays();t=t.filter(function(e){return this.isEnabled([e])},this);if(t.length>0){this.handler(t)}};a.prototype._getRemoveCommand=function(e,t,n){return this.getCommandFactory().getCommandFor(e,"Remove",{removedElement:e},t,n)};a.prototype._fireElementModified=function(e){if(e.getCommands().length){this.fireElementModified({command:e})}};a.prototype.handler=function(e){var r=[];var i=new n;function s(e){e.setSelected(true);setTimeout(function(){e.focus()},0)}var l=a._getElementToFocus(e);e.forEach(function(n){var o=this.getResponsibleElementOverlay(n);var a=o.getElement();var s=o.getDesignTimeMetadata();var g=this.getVariantManagementReference(o);var u=this._getConfirmationText(o);r.push(Promise.resolve().then(function(){if(u){return t.openRemoveConfirmationDialog(a,u)}return true}).then(function(e){if(!e){throw Error("Cancelled")}return this._getRemoveCommand(a,s,g)}.bind(this)).then(function(e){i.addCommand(e)}).catch(function(t){if(t&&t.message==="Cancelled"){if(e.length===1){l=n}}else{throw t}}));n.setSelected(false)},this);if(r.length){return Promise.all(r).then(function(){s(l);this._fireElementModified(i)}.bind(this)).catch(function(e){o.error("Error during remove: ",e)})}};a._getElementToFocus=function(e){var t;if(e.length===1){var n=e[0];var i=n.getParent().getAggregation(n.sParentAggregationName);if(i.length>1){var o=i.indexOf(n);var a=i.slice(o+1);if(o!==0){a=a.concat(i.slice(0,o).reverse())}t=a.filter(function(e){return e.getElement().getVisible()}).shift()}}t||=r.getOverlay(e[0].getRelevantContainer());return t};a.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_REMOVE",rank:60,icon:"sap-icon://less"})};a.prototype.getActionName=function(){return"remove"};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/Rename", ["sap/ui/rta/plugin/Plugin","sap/ui/rta/plugin/RenameHandler","sap/base/Log"],function(e,t,n){"use strict";var i=e.extend("sap.ui.rta.plugin.Rename",{metadata:{library:"sap.ui.rta",properties:{oldValue:"string"},associations:{},events:{editable:{},nonEditable:{}}}});i.prototype.exit=function(...n){e.prototype.exit.apply(this,n);this.setBusy(false);t._exit.call(this)};i.prototype.setDesignTime=function(e){t._setDesignTime.call(this,e)};i.prototype.startEdit=function(e){var n=this.getAction(e).domRef;var i=this.getAction(e).getTextMutators;t.startEdit.call(this,{overlay:e,domRef:n,getTextMutators:i,pluginMethodName:"plugin.Rename.startEdit"})};i.prototype.stopEdit=function(e){t._stopEdit.call(this,e,"plugin.Rename.stopEdit")};i.prototype.handler=function(e){e=this.getSelectedOverlays()||e;this.startEdit(e[0])};i.prototype.isRenameAvailable=function(e){return this._isEditableByPlugin(e)};i.prototype.isRenameEnabled=function(e){return this.isEnabled(e)};i.prototype.isEnabled=function(e){if(e.length>1){return false}var t=e[0];var n=this.getResponsibleElementOverlay(t);var i=true;if(!this.getAction(n)){i=false}var a=this.getAction(t);if(i&&typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){i=a.isEnabled(t.getElement())}else{i=a.isEnabled}}if(i){var r=t.getDesignTimeMetadata();var o=r.getAssociatedDomRef(t.getElement(),a.domRef);if(!(o&&o.get(0))){i=false}}return i};i.prototype.registerElementOverlay=function(...n){const[i]=n;i.attachEvent("editableChange",t._manageClickEvent,this);e.prototype.registerElementOverlay.apply(this,n)};i.prototype._isEditable=function(e){return this._checkChangeHandlerAndStableId(e)};i.prototype.deregisterElementOverlay=function(...n){const[i]=n;i.detachEvent("editableChange",t._manageClickEvent,this);i.detachBrowserEvent("click",t._onClick,this);e.prototype.deregisterElementOverlay.apply(this,n)};i.prototype.createRenameCommand=function(e,t){var i=this.getResponsibleElementOverlay(e);var a=i.getElement();var r=i.getDesignTimeMetadata();var o=this.getVariantManagementReference(i);return this.getCommandFactory().getCommandFor(a,"rename",{renamedElement:a,newValue:t},r,o).then(function(e){this.fireElementModified({command:e})}.bind(this)).catch(function(e){n.error("Error during rename: ",e)})};i.prototype._emitLabelChangeEvent=function(){var e=t._getCurrentEditableFieldText.call(this);this._fnSetControlText(e);return this.createRenameCommand(this._oEditedOverlay,e)};i.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_RENAME",rank:10,icon:"sap-icon://edit"})};i.prototype.getActionName=function(){return"rename"};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/RenameHandler", ["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/core/Element","sap/ui/core/EventBus","sap/ui/rta/plugin/Plugin","sap/ui/rta/util/validateText","sap/ui/dt/Overlay","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/rta/Utils","sap/ui/dt/DOMUtil","sap/ui/events/KeyCodes","sap/ui/dt/OverlayUtil"],function(jQuery,e,t,i,a,l,o,s,r,d,n,h,_){"use strict";var E=" ";var v={errorStyleClass:"sapUiRtaErrorBg",_manageClickEvent(e){var t=e.getSource?e.getSource():e;if(t.isSelected()&&this.isRenameAvailable(t)&&this.isRenameEnabled([t])){t.attachBrowserEvent("click",v._onClick,this)}else{t.detachBrowserEvent("click",v._onClick,this)}},_setEditableFieldPosition(){if(this._oEditableField){jQuery(this._oEditableField).offset({left:n.getOffset(this._oEditableControlDomRef).left});jQuery(this._oEditableField).offset({top:n.getOffset(this._oEditableControlDomRef).top});this._oEditedOverlay.setSelected(true);this._oEditableField.focus()}},startEdit(t){this.setBusy(true);this._oEditedOverlay=t.overlay;this._bPreviouslyMovable=this._oEditedOverlay.getMovable();this._oEditedOverlay.setMovable(false);_.setFirstParentMovable(this._oEditedOverlay,false);var a=t.overlay.getElement();var l=this._oEditedOverlay.getDesignTimeMetadata();var h=l.getAssociatedDomRef(a,t.domRef);if(!d.isElementInViewport(h)){h.get(0).scrollIntoView()}this._oEditableControlDomRef=h.get(0);var E=typeof t.getTextMutators==="function"?t.getTextMutators(a):{getText:function(){return this._oEditableControlDomRef.textContent}.bind(this),setText:function(e){this._oEditableControlDomRef.textContent=e}.bind(this)};this._fnGetControlText=E.getText;this._fnSetControlText=E.setText;var b=0;var c=r.getOverlay(h.jquery?h.get(0).id:h.id);if(!c){c=this._oEditedOverlay;var f=s.getDomRef(a);var u=this._oEditableControlDomRef.parentNode;var y=f?parseInt(f.offsetWidth):"NaN";if(!isNaN(y)){var g=parseInt(this._oEditableControlDomRef.offsetWidth);var p=parseInt(u.offsetWidth);b=y-g;var m=Array.from(u.children);var F=m.filter(function(e){return n.isVisible(e)});if(b<0&&p){if(u.id!==f.id&&F.length===1&&F[0].id===this._oEditableControlDomRef.id&&y>p){b=y-p}else{b=0}}}}var C=document.createElement("div");C.classList.add("sapUiRtaEditableField");C.style.whiteSpace="nowrap";C.style.overflow="hidden";C.style.width=`calc(100% - (${b}px))`;c.getDomRef().append(C);var S=document.createElement("div");S.setAttribute("contentEditable","true");C.append(S);this._oEditableField=S;var O=this._fnGetControlText();if(O===""){this._fnSetControlText("_?_");this._oEditableField.textContent=""}else{this._oEditableField.textContent=O}this.setOldValue(v._getCurrentEditableFieldText.call(this));n.copyComputedStyle(this._oEditableControlDomRef,this._oEditableField);while(this._oEditableField.lastElementChild){this._oEditableField.removeChild(this._oEditableField.lastElementChild)}this._oEditableField.style.visibility="hidden";this._oEditableField.style["-moz-user-modify"]="read-write";this._oEditableField.style["-webkit-user-modify"]="read-write";this._oEditableField.style["-ms-user-modify"]="read-write";this._oEditableField.style["user-modify"]="read-write";this._oEditableField.style.userSelect="text";this._oEditableField.style["-webkit-user-select"]="text";this._oEditableField.style.textOverflow="clip";this._oEditableField.style.whiteSpace="nowrap";if(e.browser.name==="ed"&&a.getMetadata().getName()==="sap.ui.fl.variants.VariantManagement"){this._oEditableField.style.lineHeight="normal"}o.getMutationObserver().ignoreOnce({target:this._oEditableControlDomRef});this._FocusHandler=v._onEditableFieldFocus.bind(this);this._oBlurHandler=v._onEditableFieldBlur.bind(this);this._oKeyDownHandler=v._onEditableFieldKeydown.bind(this);this._oStopPropagationHandler=v._stopPropagation.bind(this);this._oEditableField.addEventListener("focus",this._FocusHandler,{once:true});this._oEditableField.addEventListener("blur",this._oBlurHandler);this._oEditableField.addEventListener("keydown",this._oKeyDownHandler);this._oEditableField.addEventListener("dragstart",this._oStopPropagationHandler);this._oEditableField.addEventListener("drag",this._oStopPropagationHandler);this._oEditableField.addEventListener("dragend",this._oStopPropagationHandler);this._oEditableField.addEventListener("click",this._oStopPropagationHandler);this._oEditableField.addEventListener("mousedown",this._oStopPropagationHandler);this._oEditableControlDomRef.style.visibility="hidden";jQuery(C).offset({left:n.getOffset(this._oEditableControlDomRef).left});v._setEditableFieldPosition.apply(this);this._oEditableField.style.visibility="";this._oEditableField.focus();this._aOverlaysWithScrollbar=_.findParentOverlaysWithScrollbar(c);this._aOverlaysWithScrollbar.forEach(function(e){e.attachScrollSynced(v._setEditableFieldPosition,this)}.bind(this));t.overlay.setSelected(true);i.getInstance().publish("sap.ui.rta",t.pluginMethodName,{overlay:t.overlay,editableField:this._oEditableField})},_setDesignTime(...e){const[t]=e;this._aSelection=[];var i=this.getDesignTime();if(i){i.getSelectionManager().detachChange(v._onDesignTimeSelectionChange,this)}a.prototype.setDesignTime.apply(this,e);if(t){t.getSelectionManager().attachChange(v._onDesignTimeSelectionChange,this);this._aSelection=this.getSelectedOverlays()}},_onDesignTimeSelectionChange(e){var t=e.getParameter("selection");this._aSelection.forEach(v._manageClickEvent,this);t.forEach(v._manageClickEvent,this);this._aSelection=t},_stopPropagation(e){e.stopPropagation()},_preventDefault(e){e.preventDefault()},_onEditableFieldFocus(e){var t=e.target;var i=document.createRange();i.selectNodeContents(t);var a=window.getSelection();a.removeAllRanges();a.addRange(i)},_stopEdit(e,t){var a;this.setBusy(false);this._oEditableField.removeEventListener("blur",this._oBlurHandler);this._oEditableField.removeEventListener("focus",this._FocusHandler);this._oEditableField.removeEventListener("keydown",this._oKeyDownHandler);this._oEditableField.removeEventListener("dragstart",this._oStopPropagationHandler);this._oEditableField.removeEventListener("drag",this._oStopPropagationHandler);this._oEditableField.removeEventListener("dragend",this._oStopPropagationHandler);this._oEditableField.removeEventListener("click",this._oStopPropagationHandler);this._oEditableField.removeEventListener("mousedown",this._oStopPropagationHandler);if(this._fnGetControlText()==="_?_"){this._fnSetControlText("")}o.getMutationObserver().ignoreOnce({target:this._oEditableControlDomRef});this._oEditableControlDomRef.style.visibility="visible";if(e){a=this._oEditedOverlay;a.setSelected(true);a.focus()}this._aOverlaysWithScrollbar.forEach(function(e){e.detachScrollSynced(v._setEditableFieldPosition,this)}.bind(this));delete this._oEditableField;var l=this._oEditedOverlay.getDomRef()&&this._oEditedOverlay.getDomRef().querySelector(".sapUiRtaEditableField");if(l){l.remove()}this._oEditedOverlay.setMovable(this._bPreviouslyMovable);_.setFirstParentMovable(this._oEditedOverlay,true);delete this._oEditableControlDomRef;delete this._oEditedOverlay;delete this._bBlurOrKeyDownStarted;delete this._fnGetControlText;delete this._fnSetControlText;i.getInstance().publish("sap.ui.rta",t,{overlay:a})},_onEditableFieldBlur(e){return v._handlePostRename.call(this,false,e)},_handlePostRename(e,t){if(!this._bBlurOrKeyDownStarted){this._oEditedOverlay.removeStyleClass(v.errorStyleClass);this._bBlurOrKeyDownStarted=true;if(t){v._preventDefault.call(this,t);v._stopPropagation.call(this,t)}return Promise.resolve().then(v._validateNewText.bind(this)).then(this._emitLabelChangeEvent.bind(this)).catch(function(e){if(e.message==="sameTextError"){return}throw e}).then(function(t){this.stopEdit(e);if(typeof t==="function"){t()}}.bind(this)).catch(function(t){return v._handleInvalidRename.call(this,t.message,e)}.bind(this))}return Promise.resolve()},_handleInvalidRename(e,t){return d.showMessageBox("error",e,{titleKey:"RENAME_ERROR_TITLE"}).then(function(){var e=this._oEditedOverlay;e.setIgnoreEnterKeyUpOnce(false);e.addStyleClass(v.errorStyleClass);this.stopEdit(t);this.startEdit(e)}.bind(this))},_validateNewText(){var e=this.getResponsibleElementOverlay(this._oEditedOverlay);var t=this.getAction(e);var i=v._getCurrentEditableFieldText.call(this);l(i,this.getOldValue(),t)},_onEditableFieldKeydown(e){switch(e.keyCode){case h.ENTER:this._oEditedOverlay.setIgnoreEnterKeyUpOnce(true);return v._handlePostRename.call(this,true,e);case h.ESCAPE:this._oEditedOverlay.removeStyleClass(v.errorStyleClass);this.stopEdit(true);v._preventDefault.call(this,e);break;case h.DELETE:case h.BACKSPACE:v._stopPropagation.call(this,e);break;default:}return Promise.resolve()},_getCurrentEditableFieldText(){var e=this._oEditableField?this._oEditableField.textContent.trim():"";return e===""?E:e},_onClick(e){var i=t.getElementById(e.currentTarget.id);if(this.isRenameEnabled([i])&&!e.metaKey&&!e.ctrlKey&&!e.shiftKey){this.startEdit(i);v._preventDefault.call(this,e)}},_exit(){if(this._oEditableControlDomRef){this.stopEdit(false)}}};return v},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/Resize", ["sap/base/i18n/Localization","sap/ui/rta/plugin/Plugin","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/util/ZIndexManager","sap/ui/dt/Util"],function(e,t,n,i,r,a){"use strict";var o=t.extend("sap.ui.rta.plugin.Resize",{metadata:{library:"sap.ui.rta",properties:{handle:"object",dragging:"boolean"},associations:{},events:{}}});var s="sapUiRtaResizeHandle";var l="sapUiRtaResizeHandleExtension";var h="sapUiRtaFullScreenDiv";var d=15;var c=e.getRTL();var u=c?-1:1;var v=c?"right":"left";var g=15*u;function m(e){return e.getDomRef().offsetWidth}function f(){this._oFullScreenDiv=document.createElement("div");this._oFullScreenDiv.className=h;this._oFullScreenDiv.style["z-index"]=r.getNextZIndex();var e=n.getOverlayContainer()[0];e.append(this._oFullScreenDiv)}function p(){this._oFullScreenDiv.removeEventListener("mouseup",this._fnOnMouseUp);this._oFullScreenDiv.removeEventListener("mousemove",this._fnOnMouseMove);this._oFullScreenDiv.remove();delete this._oFullScreenDiv}o.prototype._isEditable=function(e){var t=this.getAction(e);if(t&&t.handler){return Promise.resolve(this.hasStableId(e))}return this._checkChangeHandlerAndStableId(e)};o.prototype._createResizeCommand=function(e,t,n){var i=this.getVariantManagementReference(e);return this.getCommandFactory().getCommandFor(t.selectorElement,"resize",t.changeSpecificData,undefined,i).then(function(e){return n.addCommand(e)})};o.prototype._createCompositeCommand=function(e,t,n){var i;return this.getCommandFactory().getCommandFor(t,"composite").then(function(t){i=t;return n.reduce(function(t,n){return t.then(this._createResizeCommand.bind(this,e,n,i))}.bind(this),Promise.resolve())}.bind(this)).then(function(){return i})};o.prototype._createCommand=function(e,t){var n=e.getElement();var i=this.getAction(e);var r=i.handler;return Promise.resolve().then(function(){if(r){var o={newWidth:t};return r(n,o).then(function(t){if(t.length>0){return this._createCompositeCommand(e,n,t)}return undefined}.bind(this)).catch(function(e){throw a.propagateError(e,"Resize#handler","Error occurred during handler execution","sap.ui.rta.plugin")})}return this._createCompositeCommand(e,n,[{changeSpecificData:{changeType:i.changeType,content:{resizedElementId:n.getId(),newWidth:t}},selectorElement:n}])}.bind(this)).then(function(e){if(e&&e.getCommands().length>0){this.fireElementModified({command:e})}}.bind(this))};o.prototype._onHandleMouseDown=function(e,t){this.setBusy(true);if(t.detail===2){this._onDoubleClick(e);this.setBusy(false);return}f.call(this);var n=this.getAction(e);var i=this.getHandle();var r=e.getElement();var a=e.getDomRef();var o=Math.round(a.getBoundingClientRect()[v]);var s=Math.round(i.offsetWidth/2);var h=t.clientX;var d;var c=m(e);i.style[v]=`${(h-o)*u-s}px`;this.setDragging(true);e.focus();this._fnOnMouseMove=y.bind(this);this._fnOnMouseUp=_.bind(this);if(n.getHandleExtensionHeight){var g=n.getHandleExtensionHeight(r);d=document.createElement("div");d.className=l;d.style.height=`${g}px`;d.style["pointer-events"]="none"}function y(t){if(d){i.append(d);i.extension=d}c=(t.clientX-o)*u+s;c=this._limitNewWidth(e,c);i.style[v]=`${c-i.offsetWidth}px`}function _(){this._finalizeResize(e,c);p.call(this);this.setDragging(false);this.setBusy(false)}this._oFullScreenDiv.addEventListener("mousemove",this._fnOnMouseMove);this._oFullScreenDiv.addEventListener("mouseup",this._fnOnMouseUp)};o.prototype._onDoubleClick=function(e){var t=this.getAction(e);if(t.getDoubleClickWidth){var n=t.getDoubleClickWidth(e.getElement());this._finalizeResize(e,n)}};o.prototype._finalizeResize=function(e,t){var n=m(e);if(t===n){return Promise.resolve()}var i=function(){e.setSelected(true);e.focus();e.detachEvent("geometryChanged",i,this);e.attachEvent("geometryChanged",this._onOverlayGeometryChanged,this)};e.detachEvent("geometryChanged",this._onOverlayGeometryChanged,this);e.attachEvent("geometryChanged",i,this);e.setSelected(false);return this._createCommand(e,t).catch(function(e){i.call(this);throw a.propagateError(e,"Resize","Error occurred during resize command creation","sap.ui.rta.plugin")}.bind(this))};o.prototype._limitNewWidth=function(e,t){var n=this.getAction(e);var i=e.getElement();var r=n.getSizeLimits&&n.getSizeLimits(i);var a=r&&r.minimumWidth||d;var o=r&&r.maximumWidth;if(a&&t<a){t=a}if(o&&t>o){t=o}return t};o.prototype._createHandle=function(e){var t=this.getHandle();var n=i.getOverlay(e.target.id);if(!this.isEnabled([n])){this._removeHandle(false);return}if(!t&&!this.getDragging()){var a=n.getDomRef();var o=document.createElement("div");o.className=s;a.append(o);o.style[v]=`${a.clientWidth-o.clientWidth}px`;o.style["z-index"]=r.getNextZIndex();o.addEventListener("mousedown",this._onHandleMouseDown.bind(this,n));this.setHandle(o)}};o.prototype._removeHandle=function(e){var t=this.getHandle();if(t&&(e||!this.getDragging())){t.remove();this.setDragging(false);this.setHandle(null)}};o.prototype._onOverlayMouseMove=function(e){var t=i.getOverlay(e.target.id);if(t&&t.isSelectable()){this._createHandle(e)}};o.prototype._onOverlayKeyDown=function(e){var t=i.getOverlay(e.target.id);var n;if(e.key==="Escape"){this._removeHandle(true);if(this._oFullScreenDiv){p.call(this)}e.stopImmediatePropagation();return}if(!e.shiftKey||e.ctrlKey||e.metaKey||e.altKey){return}var r=m(t);if(e.key==="ArrowLeft"||e.key==="ArrowRight"){var a=e.key==="ArrowLeft"?g*-1:g;n=this._limitNewWidth(t,r+a);this._finalizeResize(t,n)}};o.prototype._onOverlayMouseLeave=function(){this._removeHandle(false)};o.prototype._onOverlaySelectionChange=function(e){if(e.getParameter("selected")){this._removeHandle(false);e.target={id:e.getParameter("id")};this._createHandle(e)}else{this._removeHandle()}};o.prototype._onOverlayFocus=function(e){var t=i.getOverlay(e.target.id);if(t.getSelected()&&!this.getHandle()){this._createHandle(e)}};o.prototype._onOverlayGeometryChanged=function(e){var t=i.getOverlay(e.getParameter("id"));if(t.getSelected()&&t.hasFocus()){this._removeHandle();this._createHandle(e)}};o.prototype.registerElementOverlay=function(...e){const[n]=e;if(this.isEnabled([n])){n.attachBrowserEvent("mousemove",this._onOverlayMouseMove,this);n.attachBrowserEvent("mouseleave",this._onOverlayMouseLeave,this);n.attachBrowserEvent("keydown",this._onOverlayKeyDown,this);n.attachBrowserEvent("focus",this._onOverlayFocus,this);n.attachEvent("selectionChange",this._onOverlaySelectionChange,this);n.attachEvent("geometryChanged",this._onOverlayGeometryChanged,this)}t.prototype.registerElementOverlay.apply(this,e)};o.prototype.deregisterElementOverlay=function(...e){const[n]=e;n.detachBrowserEvent("mousemove",this._onOverlayMouseMove,this);n.detachBrowserEvent("mouseleave",this._onOverlayMouseLeave,this);n.detachBrowserEvent("keydown",this._onOverlayKeyDown,this);n.detachBrowserEvent("focus",this._onOverlayFocus,this);n.detachEvent("selectionChange",this._onOverlaySelectionChange,this);n.detachEvent("geometryChanged",this._onOverlayGeometryChanged,this);t.prototype.deregisterElementOverlay.apply(this,e)};o.prototype.getActionName=function(){return"resize"};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/Selection", ["sap/base/util/restricted/_intersection","sap/m/InstanceManager","sap/ui/dt/DOMUtil","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/events/KeyCodes","sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils"],function(e,t,i,a,s,r,o,n){"use strict";var l=o.extend("sap.ui.rta.plugin.Selection",{metadata:{library:"sap.ui.rta",properties:{multiSelectionRequiredPlugins:{type:"string[]"},isActive:{type:"boolean",defaultValue:true}},associations:{},events:{elementEditableChange:{parameters:{editable:{type:"boolean"}}}}}});function c(e){e.preventDefault();e.stopPropagation()}function u(t,i){var a=i.slice();t.forEach(function(t){a=e(a,t.getEditableByPlugins())});return a.length>0}function v(e){return e.every(function(t){return t.getRelevantContainer()===e[0].getRelevantContainer()})}function h(e){return e.every(function(t){return t.getParentElementOverlay()===e[0].getParentElementOverlay()})}function g(e){return e.every(function(t){return t.getElement().getMetadata().getName()===e[0].getElement().getMetadata().getName()})}l.prototype.init=function(...e){this._multiSelectionValidator=this._multiSelectionValidator.bind(this);o.prototype.init.apply(this,e)};l.prototype._checkDeveloperMode=function(e,t){if(t){var i=this.getCommandFactory().getFlexSettings().developerMode;if(i&&this.hasStableId(e)){e.setEditable(true);e.setSelectable(true);this.fireElementEditableChange({editable:true});return true}}return false};l.prototype.setIsActive=function(e){this.setProperty("isActive",e);if(e===false){this._deselectOverlays()}};l.prototype.registerElementOverlay=function(e){var t=e.getDesignTimeMetadata();if(!t.markedAsNotAdaptable()&&!this._checkDeveloperMode(e,t)){e.attachEditableChange(this._onEditableChange,this);this._adaptSelectable(e)}e.attachBrowserEvent("click",this._selectOverlay,this);e.attachBrowserEvent("contextmenu",this._selectOverlay,this);e.attachBrowserEvent("keydown",this._onKeyDown,this);e.attachBrowserEvent("mousedown",this._onMouseDown,this);e.attachBrowserEvent("mouseover",this._onMouseover,this);e.attachBrowserEvent("mouseleave",this._onMouseleave,this)};l.prototype._onEditableChange=function(e){var t=e.getSource();this._adaptSelectable(t)};l.prototype._adaptSelectable=function(e){var t=e.getEditable();if(e.getSelectable()!==t){e.setSelectable(t);if(!t){this._removePreviousHover()}this.fireElementEditableChange({editable:t})}};l.prototype.deregisterElementOverlay=function(e){e.detachBrowserEvent("click",this._selectOverlay,this);e.detachBrowserEvent("contextmenu",this._selectOverlay,this);e.detachBrowserEvent("keydown",this._onKeyDown,this);e.detachBrowserEvent("mousedown",this._onMouseDown,this);e.detachBrowserEvent("mouseover",this._onMouseover,this);e.detachBrowserEvent("mouseleave",this._onMouseleave,this);e.detachEditableChange(this._onEditableChange,this)};l.prototype._setFocusOnOverlay=function(e,t){if(e&&e.getSelectable()){e.focus();t.stopPropagation()}};l.prototype._onKeyDown=function(e){if(!this.getIsActive()){return}var t=n.getFocusedOverlay();if(e.keyCode===r.ENTER){this._selectOverlay(e)}else if(e.keyCode===r.ARROW_UP&&e.shiftKey===false&&e.altKey===false){if(t){var i=n.getFocusableParentOverlay(t);this._setFocusOnOverlay(i,e);e.preventDefault()}}else if(e.keyCode===r.ARROW_DOWN&&e.shiftKey===false&&e.altKey===false){if(t){var a=n.getFirstFocusableDescendantOverlay(t);this._setFocusOnOverlay(a,e);e.preventDefault()}}else if(e.keyCode===r.ARROW_LEFT&&e.shiftKey===false&&e.altKey===false){if(t){var s=n.getPreviousFocusableSiblingOverlay(t);this._setFocusOnOverlay(s,e);e.preventDefault()}}else if(e.keyCode===r.ARROW_RIGHT&&e.shiftKey===false&&e.altKey===false){if(t){var o=n.getNextFocusableSiblingOverlay(t);this._setFocusOnOverlay(o,e);e.preventDefault()}}else if(e.keyCode===r.ESCAPE){if(t){this._deselectOverlays()}}};l.prototype._deselectOverlays=function(){this.getDesignTime().getSelectionManager().reset()};l.prototype._selectOverlay=function(e){var t=a.getOverlay(e.currentTarget.id);if(!this.getIsActive()){if(t.isRoot()){c(e)}return}var i=e.metaKey||e.ctrlKey||e.shiftKey;var s=e.type==="contextmenu";if(t&&t.getSelectable()){if(t.isSelected()){if(!s){this.getDesignTime().getSelectionManager().remove(t)}}else if(i){this.getDesignTime().getSelectionManager().add(t)}else{this.getDesignTime().getSelectionManager().set(t)}c(e)}else if(t&&t.isRoot()){c(e)}};l.prototype._onMouseDown=function(e){if(!this.getIsActive()){var i=a.getOverlay(e.currentTarget.id);if(i.isRoot()){c(e)}t.getOpenPopovers().forEach(function(e){if(e._bOpenedByChangeIndicator){e.close()}});return}};l.prototype._onMouseover=function(e){var t=a.getOverlay(e.currentTarget.id);if(!this.getIsActive()||this.getDesignTime()&&this.getDesignTime().getBusyPlugins().length){if(t.isRoot()){c(e)}return}if(t.isSelectable()){s.setFirstParentMovable(t,false);if(t!==this._oHoverTarget){this._removePreviousHover();this._oHoverTarget=t;t.addStyleClass("sapUiRtaOverlayHover")}c(e)}};l.prototype._onMouseleave=function(e){var t=a.getOverlay(e.currentTarget.id);if(!this.getIsActive()){if(t.isRoot()){c(e)}return}if(t.isSelectable()){s.setFirstParentMovable(t,true);this._removePreviousHover();c(e)}};l.prototype._removePreviousHover=function(){if(this._oHoverTarget){this._oHoverTarget.removeStyleClass("sapUiRtaOverlayHover")}delete this._oHoverTarget};l.prototype.setDesignTime=function(...e){if(this.getDesignTime()){this.getDesignTime().getSelectionManager().removeValidator(this._multiSelectionValidator)}o.prototype.setDesignTime.apply(this,e);if(this.getDesignTime()){this.getDesignTime().getSelectionManager().addValidator(this._multiSelectionValidator)}};l.prototype._multiSelectionValidator=function(e){return e.length===1||u(e,this.getMultiSelectionRequiredPlugins())&&v(e)&&(h(e)||g(e))};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/Settings", ["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/dt/Util","sap/base/Log"],function(e,n,t,r){"use strict";var a=e.extend("sap.ui.rta.plugin.Settings",{metadata:{library:"sap.ui.rta",properties:{commandStack:{type:"any"}},associations:{},events:{}}});var i="CTX_SETTINGS";a.prototype._isEditable=function(e){var n=this.getAction(e);if(n){if(n.handler){return this.hasStableId(e)}var t=Object.keys(n).some(function(t){var r=n[t];return r.handler&&this._checkRelevantContainerStableID(r,e)}.bind(this));if(t){return this.hasStableId(e)}}return false};a.prototype.isEnabled=function(e){var n=e[0];var t=this.getAction(n);if(!t){return false}if(typeof t.isEnabled!=="undefined"){if(typeof t.isEnabled==="function"){return t.isEnabled(n.getElement())}return t.isEnabled}return true};a.prototype._getUnsavedChanges=function(e,n){var t;var r=this.getCommandStack().getAllExecutedCommands().filter(function(r){t=r.getElementId&&r.getElementId()||r.getElement&&r.getElement().getId();return t===e&&n.indexOf(r.getChangeType())>=0}).map(function(e){return e.getPreparedChange()});return r};a.prototype._handleFlexChangeCommand=function(e,n,t,r){var a=e.changeSpecificData;var i;var o=e.selectorElement||e.selectorControl;var s;var d;if(o.controlType){s=o.controlType}else{d=o}return this.hasChangeHandler(a.changeType,d,s).then(function(e){if(n[0].getVariantManagement&&e&&!r.CAUTION_variantIndependent){i=n[0].getVariantManagement()}return this.getCommandFactory().getCommandFor(o,"settings",a,undefined,i)}.bind(this)).then(function(e){var n=r.runtimeOnly;if(e&&n){e.setRuntimeOnly(n)}return t.addCommand(e)})};a.prototype._handleAppDescriptorChangeCommand=function(e,n,t){var r=e.changeSpecificData;var a=e.appComponent;var i=a.getManifest();var o=i["sap.app"].id;return this.getCommandFactory().getCommandFor(n,"appDescriptor",{reference:o,appComponent:a,changeType:r.appDescriptorChangeType,parameters:r.content.parameters,texts:r.content.texts}).then(function(e){return t.addCommand(e)})};a.prototype._handleCompositeCommand=function(e,n,t,r){var a;return this.getCommandFactory().getCommandFor(n,"composite").then(function(e){a=e}).then(function(){return t.map(function(t){var i=t.changeSpecificData;if(i.changeType){return this._handleFlexChangeCommand(t,e,a,r)}else if(i.appDescriptorChangeType){return this._handleAppDescriptorChangeCommand(t,n,a)}return undefined},this)}.bind(this)).then(function(e){return Promise.all(e)}).then(function(){if(a.getCommands().length>0){this.fireElementModified({command:a})}}.bind(this))};a.prototype.handler=function(e,r,a){r||={};var i=e[0].getElement();var{fnHandler:o}=r;o||=e[0].getDesignTimeMetadata().getAction("settings").handler;if(!o){throw new Error("Handler not found for settings action")}r.getUnsavedChanges=this._getUnsavedChanges.bind(this);r.styleClass=n.getRtaStyleClassName();return o(i,r).then(function(n){if(n.length>0){return this._handleCompositeCommand(e,i,n,a)}return undefined}.bind(this)).catch(function(e){throw t.propagateError(e,"Settings#handler","Error occurred during handler execution","sap.ui.rta.plugin")})};a.prototype.getMenuItems=function(e){var n=e[0];var t=this.getAction(n);var a=[];if(t){var d=110;if(t.handler){t={settings:t}}var u=Object.keys(t);u.forEach(function(e,u,c){var l=t[e];if(l.handler&&this._checkRelevantContainerStableID(l,n)&&this.isAvailable([n])){var h=c.length===1;a.push({id:h?i:i+u,rank:h?d:d+u,text:this.getActionText(n,l,i),icon:s(l),enabled:typeof l.isEnabled==="function"&&function(e){return l.isEnabled(e[0].getElement())}||l.isEnabled||this.isEnabled([n]),handler:function(e,n,t){t||={};t.fnHandler=e;return this.handler(n,t,l)}.bind(this,l.handler),submenu:o(l.submenu)})}else{r.warning(`Handler not found for settings action '${e}' or relevant container has no stable id`)}},this)}return a};function o(e){if(e){return e.map(function(e,n){return{id:e.key||`${i}_SUB_${n}`,icon:e.icon||"blank",text:e.name||"",enabled:e.hasOwnProperty("enabled")?e.enabled:true}})}return undefined}function s(e){var n="sap-icon://key-user-settings";var t=e.icon;if(!t){return n}if(typeof t!=="string"){r.error("Icon setting for settingsAction should be a string");return n}return t}a.prototype.getActionName=function(){return"settings"};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/Split", ["sap/ui/rta/plugin/Plugin","sap/ui/dt/Util","sap/ui/fl/Utils","sap/base/util/uid"],function(t,e,n,i){"use strict";var r=t.extend("sap.ui.rta.plugin.Split",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});r.prototype._isEditable=function(t){var e=this.getAction(t);if(e&&e.changeOnRelevantContainer){return this._checkChangeHandlerAndStableId(t)}return Promise.resolve(false)};r.prototype.isAvailable=function(t){if(t.length!==1){return false}var e=t[0];if(!this._isEditableByPlugin(e)){return false}var n=this.getAction(e);var i=e.getElement();if(n&&n.getControlsCount(i)<=1){return false}return true};r.prototype.isEnabled=function(t){var e=t[0];var n=this.getAction(e);if(!n||!this.isAvailable(t)){return false}var i=true;if(typeof n.isEnabled!=="undefined"){if(typeof n.isEnabled==="function"){i=n.isEnabled(e.getElement())}else{i=n.isEnabled}}return i};r.prototype.handleSplit=function(t){var r=t.getElement();var a=r.getParent();var o=t.getDesignTimeMetadata();var s=this.getAction(t).getControlsCount(r);var l=n.getViewForControl(r);var u=[];for(var p=0;p<s;p++){u.push(l.createId(i()))}var c=this.getAction(t);var d=this.getVariantManagementReference(t,c);return this.getCommandFactory().getCommandFor(r,"split",{newElementIds:u,source:r,parentElement:a},o,d).then(function(t){this.fireElementModified({command:t})}.bind(this)).catch(function(t){throw e.propagateError(t,"Split#handleSplit","Error occurred during handleSplit execution","sap.ui.rta.plugin")})};r.prototype.getMenuItems=function(t){return this._getMenuItems(t,{pluginId:"CTX_UNGROUP_FIELDS",rank:100,icon:"sap-icon://split"})};r.prototype.getActionName=function(){return"split"};r.prototype.handler=function(t){this.handleSplit(t[0])};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/Stretch", ["sap/ui/rta/plugin/Plugin","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/base/util/includes","sap/base/util/restricted/_debounce"],function(e,t,n,i,a){"use strict";var r=e.extend("sap.ui.rta.plugin.Stretch",{metadata:{library:"sap.ui.rta",properties:{},associations:{stretchCandidates:{type:"sap.ui.core.Control",multiple:true}},events:{}}});r.STRETCHSTYLECLASS="sapUiRtaStretchPaddingTop";function s(e,t){return e&&e.getGeometry()&&t.getGeometry()&&e.getGeometry().position.top===t.getGeometry().position.top&&e.getGeometry().position.left===t.getGeometry().position.left}function l(e,t){var n=e.getElement();if(n.addStyleClass&&n.removeStyleClass){if(t){n.addStyleClass(r.STRETCHSTYLECLASS)}else{n.removeStyleClass(r.STRETCHSTYLECLASS)}}else{var i=e.getAssociatedDomRef()&&e.getAssociatedDomRef().get(0);if(i){if(t){i.classList.add(r.STRETCHSTYLECLASS)}else{i.classList.remove(r.STRETCHSTYLECLASS)}}}}function o(e,t,i){var a=e.getGeometry();if(!a){return false}var r=a.size.height;if(i){r-=parseInt(window.getComputedStyle(a.domRef,null).getPropertyValue("padding-top"))}var s=Math.round(a.size.width)*Math.round(r);t||=n.getAllChildOverlays(e);var l=t.map(function(e){return e.getGeometry()});var o=n.getGeometry(l);if(!o){return false}var d=Math.round(o.size.width)*Math.round(o.size.height);return d===s}function d(e,t){var i=t.some(function(e){return e.getEditable()&&e.getGeometry()});if(i){return true}var a=[];t.forEach(function(e){a=a.concat(n.getAllChildOverlays(e))});if(!a.length){return false}if(o(e,a)){return d(e,a)}return false}r.prototype.setDesignTime=function(...t){const[n]=t;e.prototype.setDesignTime.apply(this,t);if(n){n.attachEventOnce("synced",this._onDTSynced,this)}};r.prototype.exit=function(){if(this.getDesignTime()){this.getDesignTime().detachEvent("elementOverlayAdded",this._onElementOverlayChanged);this.getDesignTime().detachEvent("elementOverlayMoved",this._onElementOverlayChanged);this.getDesignTime().detachEvent("elementPropertyChanged",this._onElementPropertyChanged);this.getDesignTime().detachEvent("elementOverlayEditableChanged",this._onElementOverlayEditableChanged);this.getDesignTime().detachEvent("elementOverlayDestroyed",this._onElementOverlayDestroyed)}};r.prototype.addStretchCandidate=function(e){var t=e.getElement();if(!i(this.getStretchCandidates(),t.getId())){this.addAssociation("stretchCandidates",t)}};r.prototype.removeStretchCandidate=function(e){this.removeAssociation("stretchCandidates",e.getElement());l(e,false)};r.prototype.registerElementOverlay=function(...t){const[n]=t;this._checkParentAndAddToStretchCandidates(n);n.attachElementModified(this._onElementModified,this);e.prototype.registerElementOverlay.apply(this,t)};r.prototype.deregisterElementOverlay=function(...t){const[n]=t;l(n,false);e.prototype.deregisterElementOverlay.apply(this,t)};r.prototype._isEditable=function(){return false};r.prototype._onDTSynced=function(){this._setStyleClassForAllStretchCandidates();this.getDesignTime().attachEvent("elementOverlayAdded",this._onElementOverlayChanged,this);this.getDesignTime().attachEvent("elementOverlayMoved",this._onElementOverlayChanged,this);this.getDesignTime().attachEvent("elementPropertyChanged",this._onElementPropertyChanged,this);this.getDesignTime().attachEvent("elementOverlayEditableChanged",this._onElementOverlayEditableChanged,this);this.getDesignTime().attachEvent("elementOverlayDestroyed",this._onElementOverlayDestroyed,this)};r.prototype._onElementModified=function(e){if(this.getDesignTime().getBusyPlugins().length){return}var t=e.getParameters();var n=e.getSource();if(t.type==="afterRendering"){this.fnDebounced||=a(function(){this._setStyleClassForAllStretchCandidates(this._getNewStretchCandidates(this._aOverlaysCollected));this._aOverlaysCollected=[];this.fnDebounced=undefined}.bind(this),16);this._aOverlaysCollected||=[];if(!i(this._aOverlaysCollected,n)){this._aOverlaysCollected.push(n);this.fnDebounced()}}};r.prototype._onElementOverlayDestroyed=function(e){if(this.getDesignTime().getBusyPlugins().length){return}var t=[];var n=e.getParameters().elementOverlay.getParentElementOverlay();if(n&&!n._bIsBeingDestroyed){var i=this._getRelevantOverlays(n).filter(function(e){return e.getElement()});t=this._getNewStretchCandidates(i)}this._setStyleClassForAllStretchCandidates(t)};r.prototype._onElementOverlayEditableChanged=function(e){var n=t.getOverlay(e.getParameters().id);if(this.getDesignTime().getBusyPlugins().length||!n){return}var i=this._getRelevantOverlaysOnEditableChange(n);this._setStyleClassForAllStretchCandidates(i)};r.prototype._onElementPropertyChanged=function(e){var n=t.getOverlay(e.getParameters().id);if(this.getDesignTime().getBusyPlugins().length||!n){return}var i=this._getRelevantOverlays(n);var r=a(function(){if(!this.bIsDestroyed&&!n.bIsDestroyed){var e=this._getNewStretchCandidates(i).concat(this._getRelevantOverlaysOnEditableChange(n));e=e.filter(function(e,t,n){return n.indexOf(e)===t});this._setStyleClassForAllStretchCandidates(e)}}.bind(this));i.forEach(function(e){e.attachEventOnce("geometryChanged",r)})};r.prototype._onElementOverlayChanged=function(e){var n=t.getOverlay(e.getParameters().id);if(this.getDesignTime().getBusyPlugins().length||!n){return}var i=this._getRelevantOverlays(n);var a=this._getNewStretchCandidates(i);this._setStyleClassForAllStretchCandidates(a)};r.prototype._getRelevantOverlaysOnEditableChange=function(e){var t=i(this.getStretchCandidates(),e.getElement().getId())?[e.getElement().getId()]:[];var n=e.getParentAggregationOverlay();if(!n){return t}var a=n.getChildren();a.splice(a.indexOf(e),1);var r=a.some(function(e){return e.getEditable()&&e.getGeometry()});if(r){return t}return t.concat(this._getRelevantParents(e))};r.prototype._getRelevantParents=function(e){var t=[];for(var n=0;n<25;n++){e=e.getParentElementOverlay();if(!e){return t}if(!i(this.getStretchCandidates(),e.getElement().getId())){return t}t.push(e.getElement().getId())}};r.prototype._getNewStretchCandidates=function(e){var t=[];e.forEach(function(e){if(this._reevaluateStretching(e)){t.push(e.getElement().getId())}},this);return t};r.prototype._reevaluateStretching=function(e){if(!e.bIsDestroyed){var t=e.getAssociatedDomRef()&&e.getAssociatedDomRef().get(0);if(t){var n=t.classList.contains(r.STRETCHSTYLECLASS);var i=o(e,undefined,n);if(n&&!i){this.removeStretchCandidate(e)}else if(!n&&i){this.addStretchCandidate(e);return true}}}};r.prototype._checkParentAndAddToStretchCandidates=function(e){var t=e.getParentElementOverlay();var n=t&&t.getAssociatedDomRef()&&t.getAssociatedDomRef().get(0);if(n){if(s(t,e)){if(o(t)){this.addStretchCandidate(t)}}}};r.prototype._setStyleClassForAllStretchCandidates=function(e){if(!Array.isArray(e)){e=this.getStretchCandidates()}e.forEach(function(e){var i=t.getOverlay(e);var a=n.getAllChildOverlays(i);var r=i.getEditable()&&d(i,a);l(i,r)},this)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/additionalElements/ActionExtractor", ["sap/base/util/restricted/_difference","sap/base/util/merge","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Lib","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/fl/apply/api/DelegateMediatorAPI","sap/ui/rta/plugin/additionalElements/AdditionalElementsUtils","sap/ui/rta/Utils"],function(e,t,n,r,a,i,o,l,u,s){"use strict";var g={};function f(){var e=[];var t=l.getKnownDefaultDelegateLibraries();t.forEach(function(t){var r=a.load({name:t}).then(function(){return Promise.resolve(t)}).catch(function(e){n.warning("Required library not available: ",e);return Promise.resolve()});e.push(r)});return Promise.all(e)}function c(e,t,n){return n.hasChangeHandler(e.changeType,e.element).then(function(n){if(n){return{aggregationName:e.aggregation,addPropertyActionData:{designTimeMetadata:t,action:e,delegateInfo:{payload:e.delegateInfo.payload||{},delegate:e.delegateInfo.instance,modelType:e.delegateInfo.modelType,requiredLibraries:e.delegateInfo.requiredLibraries,delegateType:e.delegateInfo.delegateType}}}}return undefined})}function d(e,t,n){var r=e.getElement();if(!r){return[]}var a=i.getAggregation(r,t,n).filter(function(t){var r=o.getOverlay(t);if(!n.hasStableId(r)){return false}var a=e.getRelevantContainer(true);var i=o.getOverlay(a);var l=e;var u=false;do{u=!l.getElementVisibility();if(u){break}if(l===i){break}else{l=l.getParentElementOverlay()}}while(l);if(u){return true}return r.getElementVisibility()===false},this);return a.map(function(e){return{element:e,sourceAggregation:t}})}function v(e,t){return t.sParentAggregationName}function h(e,t,n,r){var a=n.changeType&&r.hasStableId(e);if(a&&e!==t.relevantContainerOverlay){a=r.hasStableId(t.relevantContainerOverlay)}return a}function m(t,n,a,i){function u(t,u){var s=u.changeOnRelevantContainer?n.relevantContainer:n.parent;var g=o.getOverlay(s);var f=h(g,n,u,a);if(f){u.element=s;return l.getDelegateForControl({control:n.relevantContainer,modifier:r,supportsDefault:u.supportsDefaultDelegate}).then(function(r){if(r&&r.names&&r.names.length&&r.delegateType===l.types.COMPLETE){var a=l.getRequiredLibrariesForDefaultDelegate({delegateName:r.names,control:n.relevantContainer});if(e(a,i.filter(Boolean)).length===0){u.delegateInfo=r;t.push(u)}}return t})}return t}return t.reduce(function(e,t){return e.then(function(e){return u(e,t)})},Promise.resolve([]))}function p(e,t,n,r,a){var i=e.reduce(function(e,t){var n=[];r.forEach(function(e){n=n.concat(d.call(this,t,e,a))}.bind(this),[]);return t?e.concat(n):e}.bind(this),[]);var o={elements:[],controlTypeNames:[]};var l=i.reduce(function(e,t){return e.then(function(e){return y(e,t,a,n)})},Promise.resolve(o));return l.then(function(e){if(e.elements.length>0){t[n]={reveal:e}}return t})}function y(e,t,n,r){var a=t.element;var l;var g;var f=false;var c=Promise.resolve(false);var d=t.sourceAggregation;var h=o.getOverlay(a);if(h){l=h.getDesignTimeMetadata();g=l&&l.getAction("reveal",a);if(g&&g.changeType){var m=a;if(g.changeOnRelevantContainer){m=h.getRelevantContainer()}c=n.hasChangeHandler(g.changeType,m).then(function(e){if(i.isElementValid(a)){var t=u.getParents(true,h,n);if(e){if(g.changeOnRelevantContainer){f=n.hasStableId(t.relevantContainerOverlay)&&n.hasStableId(t.parentOverlay)}else{f=true}g.getAggregationName||=v;if(f&&d!==r){var o=t.parentOverlay.getAggregationOverlay(r);return s.checkTargetZone(o,h,n)}}}return f})}}return c.then(function(t){if(t){e.elements.push({element:a,designTimeMetadata:l,action:g,sourceAggregation:d,targetAggregation:r});var n=l.getName(a);if(n){e.controlTypeNames.push(n)}}return e})}g.getActions=function(e,n,r,a,i){var o=e?"asSibling":"asChild";if(!a&&n._mAddActions){return Promise.resolve(n._mAddActions[o])}var l=this._getRevealActions(e,n,r,i);var u=this._getAddViaDelegateActions(e,n,r);return Promise.all([l,u]).then(function(e){var r=t(e[0],e[1]);n._mAddActions||={asSibling:{},asChild:{}};n._mAddActions[o]=r;return r})};g.getActionsOrUndef=function(e,t){var n=e?"asSibling":"asChild";return t._mAddActions&&t._mAddActions[n]};var A={};var b=true;g._getRevealActions=function(e,t,n,r){if(b){b=false;r.attachEventOnce("synced",function(){A={};b=true},this)}var a=u.getParents(e,t,n);var l=[a.parentOverlay];if(a.relevantContainer!==a.parent){l=i.findAllSiblingsInContainer(a.parent,a.relevantContainer).map(function(e){return o.getOverlay(e)}).filter(function(e){return e})}var s=[];if(a.parentOverlay){var g=A[a.parentOverlay.getId()];if(g&&e){return g}s=a.parentOverlay.getChildren().filter(function(e){return!e.getDesignTimeMetadata().isIgnored(a.parent)}).map(function(e){return e.getAggregationName()});return s.reduce(function(e,t){return e.then(function(e){return p(l,e,t,s,n)})},Promise.resolve({})).then(function(t){if(e){A[a.parentOverlay.getId()]=t}return t})}return Promise.resolve({})};g._getAddViaDelegateActions=function(e,t,n){var r=u.getParents(e,t,n);var a=r.parentOverlay&&r.parentOverlay.getDesignTimeMetadata();return Promise.resolve().then(function(){var e=a?a.getActionDataFromAggregations("add",r.parent,undefined,"delegate"):[];if(e.length){return f().then(m.bind(this,e,r,n))}return[]}.bind(this)).then(function(e){return e.reduce(function(e,t){return e.then(function(e){return c.call(this,t,a,n).then(function(t){if(t){t.addPropertyActionData.relevantContainer=r.relevantContainer;e[t.aggregationName]||={};e[t.aggregationName].addViaDelegate=t.addPropertyActionData}return e})}.bind(this))}.bind(this),Promise.resolve({}))}.bind(this))};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/additionalElements/AddElementsDialog", ["sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/fl/write/api/FieldExtensibility","sap/ui/model/json/JSONModel","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/resource/ResourceModel","sap/ui/model/Sorter","sap/ui/rta/Utils"],function(e,t,i,o,s,n,l,r,a,u){"use strict";var d=e.extend("sap.ui.rta.plugin.additionalElements.AddElementsDialog",{metadata:{library:"sap.ui.rta",properties:{customFieldEnabled:{type:"boolean",defaultValue:false},businessContextVisible:{type:"boolean",defaultValue:false},title:{type:"string"}},events:{opened:{},openCustomField:{}}}});var p;d.prototype.init=function(){this._oDialogPromise=i.load({id:this.getId(),name:"sap.ui.rta.plugin.additionalElements.AddElementsDialog",controller:this});this._oDialogModel=new s({elements:[],customFieldEnabled:false,customFieldVisible:false,businessContextVisible:false,customFieldButtonTooltip:"",businessContextTexts:[{text:""}]});this._oDialogPromise.then(function(e){e.setModel(this._oDialogModel);p||=new r({bundleName:"sap.ui.rta.messagebundle"});e.setModel(p,"i18n");e.addStyleClass(u.getRtaStyleClassName());this._oDialogModel.setProperty("/listNoDataText",p.getProperty("MSG_NO_FIELDS").toLowerCase());this._oList=t.getElementById(`${this.getId()}--rta_addElementsDialogList`);this._bDescendingSortOrder=false}.bind(this))};d.prototype.exit=function(...t){this._oDialogPromise.then(function(e){e.destroy()});if(e.prototype.exit){e.prototype.exit.apply(this,t)}};d.prototype.setCustomFieldButtonVisible=function(e){this._oDialogModel.setProperty("/customFieldVisible",e)};d.prototype._submitDialog=function(){return this._oDialogPromise.then(function(e){e.close();this._fnResolveOnDialogConfirm()}.bind(this))};d.prototype._cancelDialog=function(){this._oDialogModel.getObject("/elements").forEach(function(e){e.selected=false});this._oDialogPromise.then(function(e){e.close()});this._fnRejectOnDialogCancel()};d.prototype.setElements=function(e){this._oDialogModel.setProperty("/elements",e)};d.prototype.getElements=function(){return this._oDialogModel.getProperty("/elements")};d.prototype.getSelectedElements=function(){return this._oDialogModel.getObject("/elements").filter(function(e){return e.selected})};d.prototype.open=function(){return new Promise(function(e,t){this._fnResolveOnDialogConfirm=e;this._fnRejectOnDialogCancel=t;this._oDialogPromise.then(function(e){e.attachAfterOpen(function(){this.fireOpened()}.bind(this));e.open()}.bind(this))}.bind(this))};d.prototype._resortList=function(){this._bDescendingSortOrder=!this._bDescendingSortOrder;var e=this._oList.getBinding("items");var t=[];t.push(new a("label",this._bDescendingSortOrder));e.sort(t)};d.prototype._updateModelFilter=function(e){var t=e.getParameter("newValue");var i=this._oList.getBinding("items");if(typeof t==="string"){var o=new n("label",l.Contains,t);var s=new n("originalLabel",l.Contains,t);var r=new n("parentPropertyName",l.Contains,t);var a=new n("duplicateName",l.EQ,true);var u=new n({filters:[r,a],and:true});var d=new n({filters:[o,s,u],and:false});i.filter([d])}else{i.filter([])}};d.prototype._redirectToCustomFieldCreation=function(){this.fireOpenCustomField();this._oDialogPromise.then(function(e){e.close()})};d.prototype.setTitle=function(t){e.prototype.setProperty.call(this,"title",t,true);this._oDialogPromise.then(function(e){e.setTitle(t)})};d.prototype.setCustomFieldEnabled=function(e){this.setProperty("customFieldEnabled",e,true);this._oDialogModel.setProperty("/customFieldEnabled",this.getProperty("customFieldEnabled"))};d.prototype._setBusinessContextVisible=function(e){this.setProperty("businessContextVisible",e,true);this._oDialogModel.setProperty("/businessContextVisible",e)};d.prototype.addExtensionData=function(e){this._removeExtensionDataTexts();var t=this._oDialogModel.getObject("/businessContextTexts");if(e&&e.length>0){e.forEach(function(e){t.push({text:e.description})},this)}else{t.push({text:p.getProperty("MSG_NO_BUSINESS_CONTEXTS")})}this._setBusinessContextVisible(true);return o.getTexts().then(function(e){if(e){this._oDialogModel.setProperty("/customFieldButtonTooltip",e.tooltip);this._oDialogModel.setProperty("/businessContextTexts/0/text",e.headerText)}}.bind(this))};d.prototype._removeExtensionDataTexts=function(){var e=this._oDialogModel.getObject("/businessContextTexts");e.splice(1)};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer", ["sap/base/util/isPlainObject","sap/base/util/ObjectPath","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/dt/ElementUtil","sap/ui/fl/apply/api/DelegateMediatorAPI","sap/ui/rta/util/BindingsExtractor"],function(e,t,n,r,a,i){"use strict";function o(e,t,n){if(!e){return false}var r=e.getBindingInfo(t,n);var a=r&&r.path;if(!a){return false}if(a.indexOf(">")>-1){a=a.split(">").pop()}return a.indexOf("/")===0}function l(e,t,n,r){var a;if(t){a=e.getBindingInfo(n,r);if(typeof a.model==="string"&&a.model!==r){a=undefined}}else{a=e.getBindingContext(r)}return a}function u(e,t,n){var r=o(e,t,n);var a=l(e,r,t,n);if(a){return r?a.path:a.getPath()}}function f(e){var t=e.reduce(function(e,t){if(Array.isArray(t.properties)){e=e.concat(t.properties.map(function(e){e.parentPropertyName=t.label||t.name;return e}))}else{e.push(t)}return e},[]);return t}function g(e,t,n){var r={element:e,aggregationName:t,payload:n.delegateInfo.payload||{}};return n.delegateInfo.delegate.getPropertyInfo(r).then(f.bind(null))}function c(e,t){return a.getDelegateForControl({control:e,modifier:n,supportsDefault:true}).then(function(n){if(n&&n.instance){return n.instance.getPropertyInfo({element:e,aggregationName:t,payload:n.payload||{}})}return[]})}function d(e,t,n){var r=n.addViaDelegate;var a;if(r){a=g.bind(null,e,t,r)}else{a=c.bind(null,e,t)}return a().then(function(e){return b(e)})}function p(e){return e.filter(function(e){return!(e.unsupported||e.hideFromReveal)})}function s(e){return{selected:false,label:e.label||e.name,parentPropertyName:e.parentPropertyName?e.parentPropertyName:"",duplicateName:e.duplicateName?e.duplicateName:false,tooltip:e.tooltip||e.label,originalLabel:"",type:"delegate",entityType:e.entityType,name:e.name,bindingPath:e.bindingPath}}function m(e){var t=e.element;var n=e.action;return{selected:false,label:t.__label||r.getLabelForElement(t,n.getLabel),tooltip:t.__tooltip||r.getLabelForElement(t,n.getLabel)||t.__bindingPath,parentPropertyName:t.__parentPropertyName?t.__parentPropertyName:"",duplicateName:t.__duplicateName?t.__duplicateName:false,originalLabel:t.__renamedLabel&&t.__label!==t.__originalLabel?t.__originalLabel:"",bindingPath:t.__bindingPath,type:"invisible",elementId:t.getId(),sourceAggregation:e.sourceAggregation}}function v(e,t,n,a){if(t&&t!==e){var i=u(e,n,a);return r.findAllSiblingsInContainer(e,t).filter(function(e){return i===u(e,n,a)})}return[e]}function b(e){e.forEach(function(e,t,n){if(e.duplicateName!==true){for(var r=t+1;r<n.length-1;r++){if(e.label===n[r].label){e.duplicateName=true;n[r].duplicateName=true}}}});return e}function h(e,t){return t.some(function(t){return t.label===e.__label})}function _(e){return Array.isArray(e)&&e.length>0}function P(e,t){return t.sort(function(e,t){return!!t.hideFromReveal-!!e.hideFromReveal}).filter(function(t){return e.some(function(e){return e===t.bindingPath||e.startsWith(`${t.bindingPath}/`)})}).pop()}function y(t){return e(t)?t.parts[0].path:!!t.getPath&&t.getPath()}function N(e,t,n,r){var a=e.getModel(n);var o=v(e,t.relevantContainer,r,n);var l=[];o.forEach(function(e){l=l.concat(i.getBindings({element:e,model:a,parent:e.getParent()}).map(y))});return l}function I(e,t){var n={element:e.relevantContainer,aggregationName:t,payload:e.delegateInfo.payload||{}};return e.delegateInfo.delegate.getRepresentedProperties(n)}function L(e,t,n,r){return I(t,r).then(function(a){if(a===undefined){return N(e,t,n,r)}var i=[];a.forEach(function(e){i=i.concat(e.bindingPaths)});return i})}function A(e,n,r,a){return Promise.resolve().then(function(){var i=!!t.get("delegateInfo.delegate.getRepresentedProperties",n);if(i){return L(e,n,r,a)}return N(e,n,r,a)})}function E(e,t){e.__originalLabel=t.label;e.__tooltip=t.tooltip;e.__bindingPath=t.name;if(e.__label!==e.__originalLabel){e.__renamedLabel=true}if(t.parentPropertyName){e.__parentPropertyName=t.parentPropertyName}}function F(e,n){var r=!!t.get("delegateInfo.delegate.getRepresentedProperties",e);if(r){return I(e,n)}}function B(e,t){var n;t.some(function(t){if(t.id===e.getId()){n=t;return true}});return n.bindingPaths||[]}function C(e,t,n,r){if(!_(n)){return true}var a=P(n,t);if(a){if(a.hideFromReveal){return false}if(r){E(e,a)}return true}return!r}function D(e,t,n,r,a,o){var l=r.addViaDelegate;var f=R(l);var g=e.getModel(f);var c=true;var d=[];if(a){d=B(n,a)}else if(u(e,t,f)===u(n,t,f)){d=i.collectBindingPaths(n,g).bindingPaths}else if(l&&i.getBindings({element:n,model:g}).length>0){c=false}if(c){n.__duplicateName=h(n,o);c=C(n,o,d,!!l)}return c}function R(e){return t.get("delegateInfo.payload.modelName",e)}var M={enhanceInvisibleElements(e,t){var n=t.reveal;var a=t.addViaDelegate;var i=e.getMetadata().getAggregation();var o=i?i.name:t.aggregation;return Promise.all([d(e,o,t),F(a,o)]).then(function(a){var i=a[0];var l=a[1];var u=[];var f=n.elements||[];f.forEach(function(n){var a=n.element;var f=n.action;a.__label=r.getLabelForElement(a,f.getLabel);var g=D(e,o,a,t,l,i);if(g){u.push({element:a,action:f,sourceAggregation:n.sourceAggregation})}});return u}).then(function(e){return e.map(m)})},getUnrepresentedDelegateProperties(e,t){var n=R(t);var r=e.getMetadata().getAggregation();var a=r?r.name:t.action.aggregation;return Promise.all([g(e,a,t),A(e,t,n,a)]).then(function(e){var n=e[0];var r=e[1];var a=t.action.filter?t.action.filter:function(){return true};var i=p(n);i=i.filter(function(e){var n=false;if(r){n=r.some(function(t){return t===e.bindingPath})}return!n&&a(t.relevantContainer,e)});i=b(i);return i}).then(function(e){return e.map(s)})}};return M});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin", ["sap/base/util/each","sap/base/Log","sap/ui/core/IconPool","sap/ui/core/Lib","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/fl/write/api/FieldExtensibility","sap/ui/rta/plugin/additionalElements/AddElementsDialog","sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer","sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/rta/plugin/additionalElements/AdditionalElementsUtils","sap/ui/rta/plugin/additionalElements/CommandBuilder","sap/ui/rta/plugin/additionalElements/ActionExtractor"],function(e,t,i,n,a,s,r,l,o,u,d,h,g,f){"use strict";var c=true;var E=false;function m(e,t){var i=t.responsibleElementOverlay.getParentAggregationOverlay().getAggregationName();return Object.keys(e).some(function(e){return e===i})}function v(e){return r.onControlSelected(e).then(function(){return Promise.all([d.isServiceUpToDate(e),r.isExtensibilityEnabled(e)])}).then(function(t){var i=!!t[1];if(i){return r.getExtensionData(e)}return undefined})}var b=u.extend("sap.ui.rta.plugin.additionalElements.AdditionalElementsPlugin",{constructor:function(...e){const[t]=e;t.dialog=new l;u.apply(this,e)},metadata:{library:"sap.ui.rta",properties:{commandFactory:"object"},aggregations:{dialog:{type:"sap.ui.rta.plugin.additionalElements.AddElementsDialog",multiple:false}},associations:{},events:{}},_getRelevantOverlays(e){var t=s.findAllOverlaysInContainer(e,true);e.setRelevantOverlays(t);return t},getContextMenuText(e,t,i,a){var s;function r(){s=n.getResourceBundleFor("sap.ui.rta");return s.getText("CTX_ADD_ELEMENTS",[s.getText("MULTIPLE_CONTROL_NAME")])}if(i==="$$OnlyChildCustomField$$"){return r()}if(a){s=n.getResourceBundleFor("sap.ui.rta");return s.getText("CTX_ADD_ELEMENTS_WITH_SUBMENU")}var l=h.getParents(e,t,this);var o=f.getActionsOrUndef(e,t);i||=Object.keys(o)[0];var u=o[i];if(!u){return r()}u.aggregation=i;return h.getText("CTX_ADD_ELEMENTS",u,l.parent,c)},isAvailable(e,t){return e.every(function(e){return this._isEditableByPlugin(e,t)},this)},isEnabled(e,t,i){if(e.length>1){return false}if(this.getExtensibilityInfo(t)){return true}var n=this.getResponsibleElementOverlay(e[0]);var a;var s=false;if(t){a=n.getParentElementOverlay();if(a){s=true}}else{var r=f.getActionsOrUndef(t,n);var l=r[i];if(l&&(l.reveal&&l.reveal.elements.length>0||l.addViaDelegate)){s=true}}var o=this.getCachedElements(t);var u=!!(o&&o.length>0);s&&=u;return s},registerElementOverlay(...e){const[t]=e;var i=t.getElement().getModel();if(i){var n=i.getMetaModel();if(n&&n.loaded){n.loaded().then(function(){this.evaluateEditable([t],{onRegistration:true})}.bind(this))}}u.prototype.registerElementOverlay.apply(this,e)},_checkIfCreateFunctionIsAvailable(e){return!e||e&&e.content&&e.content.createFunction},showAvailableElements(e,i,s,r,l,o){var u=s[0];var d=h.getParents(e,u,this);var c=e&&u.getElement();var E;var m=[];return f.getActions(e,u,this,undefined,this.getDesignTime()).then(function(t){if(i==="$$OnlyChildCustomField$$"){return[]}E=t[i];return this.getAllElements(e,[d.responsibleElementOverlay],l,o)}.bind(this)).then(function(t){m=t;var i=this.getExtensibilityInfo(e);this.getDialog().setCustomFieldEnabled(!!i);if(i){this.getDialog().detachEvent("openCustomField",this._onOpenCustomField,this);this.getDialog().attachEvent("openCustomField",e,this._onOpenCustomField,this);this.getDialog().setCustomFieldButtonVisible(true);return this.getDialog().addExtensionData(i.extensionData)}return this.getDialog().setCustomFieldButtonVisible(false)}.bind(this)).then(function(){var e=m.filter(function(e){return e.aggregation===i})[0];var t=e?e.elements:[];this.getDialog().setElements(t);if(o){var s=n.getResourceBundleFor("sap.ui.rta");var h=s.getText("HEADER_ADDITIONAL_ELEMENTS_WITH_AGGREGATION",[o]);this.getDialog().setTitle(h)}else if(i||l){this._setDialogTitle(E||{},d.parent,l)}return this.getDialog().open().then(function(){var e=this.getDialog().getSelectedElements();return g.createCommands(d,c,E,r,e,i,this)}.bind(this)).then(function(){var e=a.getOverlay(c)||u;e.focus()}).catch(function(e){if(e instanceof Error){throw e}})}.bind(this)).catch(function(e){if(e instanceof Error){throw e}else{t.info("Service not up to date, skipping add dialog","sap.ui.rta")}})},_setDialogTitle(e,t,i){var n=h.getText("HEADER_ADDITIONAL_ELEMENTS",e,t,E,i);this.getDialog().setTitle(n)},_onOpenCustomField(e,t){var i=d.getRtaStyleClassName();return r.onTriggerCreateExtensionData(this.getExtensibilityInfo(t),i)},_isEditable(e,i){return Promise.all([this._isEditableCheck(i.sourceElementOverlay,true),this._isEditableCheck(i.sourceElementOverlay,false)]).then(function(e){return{asSibling:e[0],asChild:e[1]}}).catch(function(e){t.error(e)})},_isEditableCheck(e,t){return Promise.resolve().then(function(){var i=h.getParents(t,e,this);if(!i.relevantContainerOverlay){return false}return f.getActions(t,e,this,true,this.getDesignTime()).then(function(n){this.clearCachedElements();return d.doIfAllControlsAreAvailable([e,i.parentOverlay],function(){var e=false;if(t){e=m(n,i)}else{e=Object.keys(n).some(function(t){if(n[t].addViaDelegate){e=this.checkAggregationsOnSelf(i.parentOverlay,"add",undefined,"delegate")}if(!e&&n[t].reveal){return true}return e}.bind(this))}return e}.bind(this))}.bind(this)).then(function(t){t&&=this.hasStableId(e)&&this.hasStableId(i.parentOverlay);return t}.bind(this))}.bind(this))},getAllElements(t,i){var n=i[0];var a=h.getParents(t,n,this);var s;var r=[];var l=false;var u=this.getCachedElements(t);if(u){return u}this.clearExtensibilityInfo(t);return f.getActions(t,n,this,undefined,this.getDesignTime()).then(function(t){e(t,function(e){s=t[e];s.aggregation=e;if(s.addViaDelegate){l=true}r.push({aggregation:e,elementPromises:[s.reveal?o.enhanceInvisibleElements(a.parent,s):Promise.resolve([]),s.addViaDelegate?o.getUnrepresentedDelegateProperties(a.parent,s.addViaDelegate):Promise.resolve([])]})});if(l){return v(a.parent)}return undefined}).then(function(e){this.setExtensibilityInfo(t,e)}.bind(this)).then(this._combineAnalyzerResults.bind(this,r)).then(function(e){this.setCachedElements(e,t);return e}.bind(this)).catch(function(e){throw e})},getMenuItems(e){var t=[];var i;this.clearCachedElements();return Promise.all([this.getAllElements(false,e),this.getAllElements(true,e)]).then(function(n){var a=n[0].length>0;var s=n[0].length>1;var r=n[1].length>0;var l=this.isAvailable(e,false);var o=this.isAvailable(e,true);if(o&&(!l||!a)){i=this._buildMenuItem("CTX_ADD_ELEMENTS_AS_SIBLING",true,e,n,false)}else if(!o&&l&&!s){i=this._buildMenuItem("CTX_ADD_ELEMENTS_AS_CHILD",false,e,n,false)}else if(!o&&l&&s){i=this._buildMenuItem("CTX_ADD_ELEMENTS_AS_CHILD",false,e,n,true)}else if(l&&o&&a&&r){i=this._buildMenuItem("CTX_ADD_ELEMENTS_CHILD_AND_SIBLING",false,e,n,true)}if(i){t.push(this.enhanceItemWithResponsibleElement(i,e,["addViaDelegate","reveal","custom"]))}return t}.bind(this))},_buildMenuItem(e,t,i,n,a){var s;var r;var l;var o=i[0];if(t){var u=h.getParents(t,o,this);l=u.responsibleElementOverlay.getParentAggregationOverlay().getAggregationName()}else{var d=n[0].length===0&&n[1].length===0;l=d?"$$OnlyChildCustomField$$":n[0]&&n[0][0]&&n[0][0].aggregation}if(a){s=this._buildSubmenuItems(false,i,n[0]);if(e==="CTX_ADD_ELEMENTS_CHILD_AND_SIBLING"){s=s.concat(this._buildSubmenuItems(true,i,n[1]))}}else{r=function(e,t){return this.showAvailableElements(e,l,t)}.bind(this,t)}var g={id:e,text:this.getContextMenuText.bind(this,t,o,l,a),enabled:a||function(e,t){return this.isEnabled(t,e,l)}.bind(this,t),rank:20,icon:"sap-icon://add",handler:r};if(a){g.submenu=s}return g},_buildSubmenuItems(e,t,n){var a=[];var s=e?"CTX_ADD_ELEMENTS_AS_SIBLING":"CTX_ADD_ELEMENTS_AS_CHILD";var r=0;i.registerFont({collectionName:"BusinessSuiteInAppSymbols",fontFamily:"BusinessSuiteInAppSymbols",fontURI:sap.ui.require.toUrl("sap/ushell/themes/base/fonts/"),lazy:true});function l(e,t,i){var n=e?i[0].getParentElementOverlay():i[0];var a=n.getDesignTimeMetadata();var s=a.getAggregationDisplayName(t,n.getElement());return s?s.singular:t}n.forEach(function(i){var n=i.aggregation;var o=l(e,n,t);var u={id:`${s}_${r}`,text:o,enabled:function(t){return this.isEnabled(t,e,n)}.bind(this),handler:function(e,t){return this.showAvailableElements(e,n,t,undefined,undefined,o)}.bind(this,e),icon:e?"sap-icon://BusinessSuiteInAppSymbols/icon-add-outside":"sap-icon://add"};a.push(this.enhanceItemWithResponsibleElement(u,t,["addViaDelegate","reveal","custom"]));r++}.bind(this));return a},_combineAnalyzerResults(e){var t=[];e.forEach(function(e){t.push(Promise.all(e.elementPromises).then(function(t){var i=t[0];var n=t[1];var a=i.concat(n);return{aggregation:e.aggregation,elements:a}}))});return Promise.all(t).then(function(e){return e.filter(function(e){var t=e&&e.elements;return t.length>0})})},clearCachedElements(){this._oCachedElements=undefined},setCachedElements(e,t){this._oCachedElements||={};this._oCachedElements[t?"asSibling":"asChild"]=e},getCachedElements(e){if(this._oCachedElements){return this._oCachedElements[e?"asSibling":"asChild"]}return undefined},clearExtensibilityInfo(e){if(this._oExtensibilityInfo){this._oExtensibilityInfo[e?"asSibling":"asChild"]=undefined}},setExtensibilityInfo(e,t){this._oExtensibilityInfo||={};this._oExtensibilityInfo[e?"asSibling":"asChild"]=t},getExtensibilityInfo(e){if(this._oExtensibilityInfo){return this._oExtensibilityInfo[e?"asSibling":"asChild"]}return undefined},exit(...e){this.getDialog().destroy();if(u.prototype.exit){u.prototype.exit.apply(this,e)}}});return b});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/additionalElements/AdditionalElementsUtils", ["sap/ui/core/Lib","sap/ui/dt/OverlayRegistry"],function(e,a){"use strict";var r={};function t(e){return e.addViaDelegate&&e.addViaDelegate.designTimeMetadata}r.getParents=function(e,r,t){var n;var i=r;var l=["add.delegate","reveal"].some(function(e){return t.isResponsibleElementActionAvailable(r,e)});if(l){i=t.getResponsibleElementOverlay(r)}var s=i.getRelevantContainer(!e);var u=a.getOverlay(s);if(e){n=i.getParentElementOverlay()}else{n=i}return{responsibleElementOverlay:i,relevantContainerOverlay:u,parentOverlay:n,relevantContainer:s,parent:n&&n.getElement()}};r.getText=function(a,r,n,i,l){var s=[];var u;var v;var g=r.aggregation;if(r.addViaCustom||r.addViaDelegate){var o=t(r);u=o.getAggregationDescription(g,n);if(u){v=i?u.singular:u.plural;s.push(v)}}if(r.reveal){r.reveal.controlTypeNames.forEach(function(e){v=i?e.singular:e.plural;s.push(v)})}var d=s.reduce(function(e,a){if(e.indexOf(a)===-1){e.push(a)}return e},[]);var f=e.getResourceBundleFor("sap.ui.rta");if(d.length===1){[v]=d}else if(l){v=l}else{v=f.getText("MULTIPLE_CONTROL_NAME")}return f.getText(a,[v])};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/additionalElements/CommandBuilder", ["sap/base/Log","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/rta/Utils"],function(e,t,n,a,r,i){"use strict";var o={};function g(e,t){var n;e.reveal.elements.some(function(e){if(e.element.getId()===t.getId()){n=e;return false}return undefined});return n}function d(t){var n=t.compositeCommand;var a=t.selectedElement;var r=t.parents;var i=t.siblingElement;var o=t.actions;var g=t.index;var d=t.targetAggregation;var v=t.plugin;return m(a,o,r,v).then(function(e){n.addCommand(e);return l(a,r,i,g,d,v)}).then(function(t){if(t){n.addCommand(t)}else{e.warning(`No move action configured for ${r.parent.getMetadata().getName()}, aggregation: ${a.aggregation}`,"sap.ui.rta")}return n})}function m(e,a,r,i){var o=t.getElementInstance(e.elementId);var d=n.getOverlay(o);var m=g(a,o);var l=m.designTimeMetadata;var v=m.action;var s;if(d){s=i.getVariantManagementReference(d)}if(v.changeOnRelevantContainer){return i.getCommandFactory().getCommandFor(o,"reveal",{revealedElementId:o.getId(),directParent:r.parent},l,s)}return i.getCommandFactory().getCommandFor(o,"reveal",{},l,s)}function l(e,a,r,o,g,d){var m=t.getElementInstance(e.elementId);var l=n.getOverlay(m);var v=e.sourceAggregation;var s=l.getParentElementOverlay().getElement()||a.parent;var c=a.parent;var u=i.getIndex(a.parent,r,g);var p=i.getIndex(s,m,v)-1;u=o!==undefined?o:t.adjustIndexForMove(s,c,p,u);if(u!==p||a.parent!==m.getParent()||v!==g){var f=n.getOverlay(m)?n.getOverlay(m).getParentAggregationOverlay():a.relevantContainerOverlay;var C=f.getDesignTimeMetadata();var y=d.getVariantManagementReference(l);return d.getCommandFactory().getCommandFor(a.relevantContainer,"move",{movedElements:[{element:m,sourceIndex:p,targetIndex:u}],source:{parent:s,aggregation:v},target:{parent:c,aggregation:g}},C,y)}return Promise.resolve()}function v(e,t){var n=e.getManifestEntry("/sap.ui5/dependencies/libs");return Object.keys(t).some(function(e){return!n[e]||n[e].lazy})}function s(e,t,n,a){if(t){var i=r.getAppComponentForControl(e.relevantContainer);var o=v(i,t);if(o){var g=i.getManifest();var d=g["sap.app"].id;return a.getCommandFactory().getCommandFor(e.publicParent,"addLibrary",{reference:d,parameters:{libraries:t},appComponent:i},n)}}return Promise.resolve()}function c(e){var t=e.compositeCommand;var n=e.actions.addViaDelegate.action;var a=n.delegateInfo.requiredLibraries;var r=e.parents.parentOverlay.getAggregationOverlay(e.actions.aggregation);var i=r.getDesignTimeMetadata();return s(e.parents,a,i,e.plugin).then(function(n){if(n){t.addCommand(n)}return p(e,i)}).then(function(e){if(e){t.addCommand(e)}return t})}function u(e){var t="";if(e){var n=e.getEntry?e.getEntry("sap.app"):e["sap.app"];if(n&&n.dataSources&&n.dataSources.mainService&&n.dataSources.mainService.uri){t=n.dataSources.mainService.uri}}return t}function p(e,t){var n=e.selectedElement;var a=e.parents;var o=e.siblingElement;var g=e.actions;var d=e.index;var m=e.plugin;var l=g.addViaDelegate.action;var v=l.changeOnRelevantContainer?a.relevantContainer:a.parent;var s=l.changeOnRelevantContainer?a.relevantContainerOverlay:a.parentOverlay;var c=m.getVariantManagementReference(s);var p=i.getIndex(a.parent,o,g.aggregation,t.getData().getIndex);var f="addDelegateProperty";var C=r.getAppComponentForControl(a.parent).getManifest();var y=u(C);return m.getCommandFactory().getCommandFor(a.parent,f,{newControlId:i.createFieldLabelId(v,n.entityType,n.bindingPath),index:d!==undefined?d:p,bindingString:n.bindingPath,entityType:n.entityType,parentId:a.parent.getId(),propertyName:n.name,oDataServiceVersion:n.oDataServiceVersion,oDataServiceUri:y,modelType:l.delegateInfo.modelType,relevantContainerId:a.relevantContainer.getId()},t,c)}o.createCommands=function(t,n,r,i,o,g,m){o.sort(function(e,t){if(e.label>t.label){return-1}if(e.label<t.label){return 1}return 0});if(o.length>0){return m.getCommandFactory().getCommandFor(t.parent,"composite").then(function(a){var l=Promise.resolve();o.forEach(function(o){var v={compositeCommand:a,selectedElement:o,parents:t,siblingElement:n,actions:r,index:i,targetAggregation:g,plugin:m};switch(o.type){case"invisible":l=l.then(d.bind(this,v));break;case"delegate":l=l.then(c.bind(this,v));break;default:e.error(`Can't create command for untreated element.type ${o.type}`)}},this);return l.then(function(){return a})}.bind(this)).then(function(e){m.fireElementModified({command:e})}).catch(function(e){throw a.propagateError(e,"AdditionalElementsPlugin#_createCommands","Error occurred during _createCommands execution","sap.ui.rta.plugin")})}return Promise.resolve()};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/iframe/AddIFrame", ["sap/ui/core/Lib","sap/ui/rta/plugin/BaseCreate","sap/ui/fl/Utils","sap/ui/dt/Util","sap/base/util/uid","sap/ui/core/IconPool","sap/ui/rta/plugin/iframe/AddIFrameDialog"],function(e,t,a,i,n,r,s){"use strict";function o(e,t,a,i){var n=!e;var r=this.getCreateAction(n,i,e);return a.getText(t,[r.text])}function g(e,t,i,r){var s=a.getViewForControl(e);var o=s.createId(n());var g;var d;if(t.frameWidth){g=t.frameWidth+t.frameWidthUnit}else{g="100%"}if(t.frameHeight){d=t.frameHeight+t.frameHeightUnit}else{d="100%"}return this.getCommandFactory().getCommandFor(e,"addIFrame",{targetAggregation:t.aggregation,baseId:o,index:t.index,url:t.frameUrl,width:g,height:d,title:t.title,useLegacyNavigation:t.useLegacyNavigation,advancedSettings:t.advancedSettings},i,r)}function d(e,t){var a=t[0];var n=!e;var r=this.getCreateAction(n,a,e);var o=this._getParentOverlay(n,a);var d=o.getElement();var c=o.getDesignTimeMetadata();var l=0;if(n){var u=a.getElement();var h=c.getAggregation(r.aggregation).getIndex;l=this._determineIndex(d,u,r.aggregation,h)}var f=this.getVariantManagementReference(o);var v=!!r.getCreatedContainerId;var m=new s;var p;s.buildUrlBuilderParametersFor(d).then(function(e){var t={parameters:e,asContainer:v};return m.open(t)}).then(function(e){if(!e){return Promise.reject()}e.index=l;e.aggregation=r.aggregation;p=e.title;return g.call(this,d,e,c,f)}.bind(this)).then(function(e){this.fireElementModified({command:e,newControlId:e.getBaseId(),action:v?r:undefined,title:p})}.bind(this)).catch(function(e){if(e){throw i.createError("AddIFrame#handler",e,"sap.ui.rta")}})}var c=t.extend("sap.ui.rta.plugin.AddIFrame",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});c.prototype.isEnabled=function(e,t){var a=t[0];var i=!e;var n=this.getCreateAction(i,a,e);return this.isActionEnabled(n,i,a)};c.prototype.getMenuItems=async function(t){function a(t){var a=e.getResourceBundleFor("sap.ui.rta");var i=a.getText("CTX_ADDIFRAME_GROUP");return{text:o.bind(this,t,"CTX_ADDIFRAME",a),handler:d.bind(this,t),enabled:this.isEnabled.bind(this,t),isSibling:!t,icon:"sap-icon://tnt/content-enricher",group:i}}r.registerFont({collectionName:"tnt",fontFamily:"SAP-icons-TNT",fontURI:sap.ui.require.toUrl("sap/tnt/themes/base/fonts"),lazy:false});await r.fontLoaded("tnt");var i=140;var n=[];var s=true;if(this.isAvailable(t,s)){var g=this.getCreateAction(s,t[0]);if(g){var c=Object.assign({id:"CTX_CREATE_SIBLING_IFRAME",rank:i,action:g},a.call(this));n.push(this.enhanceItemWithResponsibleElement(c,t));i+=10}}s=false;if(this.isAvailable(t,s)){n=n.concat(this.getCreateActions(s,t[0]).map(function(e,n){var r=Object.assign({action:e,id:`CTX_CREATE_CHILD_IFRAME_${e.aggregation.toUpperCase()}`,rank:i+10*n},a.call(this,e.aggregation));return this.enhanceItemWithResponsibleElement(r,t)},this))}return n};c.prototype.getActionName=function(){return"addIFrame"};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/iframe/AddIFrameDialog", ["sap/base/Log","sap/ui/base/ManagedObject","sap/ui/core/Fragment","sap/ui/core/library","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/model/json/JSONModel","sap/ui/rta/Utils","sap/ui/rta/plugin/iframe/AddIFrameDialogController","sap/ui/fl/util/getContainerUserInfo"],function(e,t,a,i,A,_,n,l,E,r){"use strict";var{ValueState:o}=i;var I=_.getResourceBundleFor("sap.ui.rta");var D="https://help.sap.com/docs/search?q=Embedding%20Content%20%28Object%20Pages%29";var T=`${I.getText("IFRAME_ADDIFRAME_DIALOG_URL_WARNING_TEXT")} (`+`<a href=${D}>${I.getText("IFRAME_ADDIFRAME_DIALOG_URL_WARNING_LINKTEXT")}</a>`+`)`;var s={dialogTitle:I.getText("IFRAME_ADDIFRAME_DIALOG_TITLE"),dialogCreateTitle:I.getText("IFRAME_ADDIFRAME_DIALOG_TITLE"),dialogUpdateTitle:I.getText("IFRAME_ADDIFRAME_DIALOG_UPDATE_TITLE"),sizeTitle:I.getText("IFRAME_ADDIFRAME_DIALOG_SIZE_TITLE"),widthLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_WIDTH_LABEL"),widthUnitLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_WIDTH_UNITLABEL"),heightLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_HEIGHT_LABEL"),heightUnitLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_HEIGHT_UNITLABEL"),saveText:I.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_SAVE"),cancelText:I.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_CANCEL"),previewUrlLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_PREVIEW_URL_LABEL"),previewUrlMessage:I.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_PREVIEW_MESSAGE"),previewButtonText:I.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_SHOW_PREVIEW"),showPreviewButton:I.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_SHOW_PREVIEW"),updatePreviewButton:I.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_UPDATE_PREVIEW"),previewFrameLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_PREVIEW_FRAME_LABEL"),parameterSearchLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_PARAMETER_SEARCH_LABEL"),editUrlLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_EDIT_URL_LABEL"),parametersLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_PARAMETERS_LABEL"),columnParameterLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_TABLE_PARAMETER_LABEL"),columnUiValueLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_TABLE_UI_VALUE_LABEL"),containerTitleLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_CONTAINER_TITLE_LABEL"),containerTitleDefaultValue:I.getText("IFRAME_ADDIFRAME_DIALOG_CONTAINER_TITLE_DEFAULT_VALUE_TEXT"),selectAdditionalTextPercentSection:I.getText("IFRAME_ADDIFRAME_DIALOG_SELECT_ADDITIONAL_TEXT_PERCENT_SECTION"),selectAdditionalTextPercentHeader:I.getText("IFRAME_ADDIFRAME_DIALOG_SELECT_ADDITIONAL_TEXT_PERCENT_HEADER"),selectAdditionalTextVh:I.getText("IFRAME_ADDIFRAME_DIALOG_SELECT_ADDITIONAL_TEXT_VH"),selectAdditionalTextPx:I.getText("IFRAME_ADDIFRAME_DIALOG_SELECT_ADDITIONAL_TEXT_PX"),selectAdditionalTextRem:I.getText("IFRAME_ADDIFRAME_DIALOG_SELECT_ADDITIONAL_TEXT_REM"),advancedSettingsTitle:I.getText("IFRAME_ADDIFRAME_ADVANCED_SETTINGS"),useLegacyNavigationLabel:I.getText("IFRAME_ADDIFRAME_USE_LEGACY_NAVIGATION"),useLegacyNavigationInfo:I.getText("IFRAME_ADDIFRAME_USE_LEGACY_NAVIGATION_INFO"),additionalParametersSecurityWarningText:I.getText("IFRAME_ADDIFRAME_ADDITIONAL_PARAMETERS_SECURITY_WARNING_TEXT"),additionalParametersWarningMoreInfoText:I.getText("IFRAME_ADDIFRAME_ADDITIONAL_PARAMETERS_WARNING_MORE_INFO_TEXT"),additionalSandboxParametersLabel:I.getText("IFRAME_ADDIFRAME_ADD_ADDITIONAL_SANDBOX_PARAMETERS_LABEL"),additionalSandboxParametersPlaceholder:I.getText("IFRAME_ADDIFRAME_ADD_ADDITIONAL_SANDBOX_PARAMETERS_PLACEHOLDER")};function d(e,t,a,i,A,_){s.dialogTitle=e?s.dialogUpdateTitle:s.dialogCreateTitle;var l=t?s.selectAdditionalTextPercentSection:s.selectAdditionalTextPercentHeader;return new n({text:s,asContainer:{value:t},title:{value:s.containerTitleDefaultValue,valueState:o.None,id:"sapUiRtaAddIFrameDialog_ContainerTitle_TitleInput"},frameWidth:{value:parseFloat(a)||100,valueState:o.None,id:"sapUiRtaAddIFrameDialog_WidthInput"},frameWidthUnit:{value:"%"},frameHeight:{value:parseFloat(i)||50,valueState:o.None,id:"sapUiRtaAddIFrameDialog_HeightInput"},frameHeightUnit:{value:"vh"},frameUrl:{value:"",valueState:o.None},previewUrl:{value:""},documentationLink:{HTML:T},parameters:{value:[]},unitsOfWidthMeasure:[{unit:"%",descriptionText:l},{unit:"px",descriptionText:s.selectAdditionalTextPx},{unit:"rem",descriptionText:s.selectAdditionalTextRem}],unitsOfHeightMeasure:[{unit:"vh",descriptionText:s.selectAdditionalTextVh},{unit:"px",descriptionText:s.selectAdditionalTextPx},{unit:"rem",descriptionText:s.selectAdditionalTextRem}],useLegacyNavigation:{value:!!A},previewUseLegacyNavigation:{value:!!A},advancedSettings:{value:{allowForms:true,allowScripts:true,allowSameOrigin:true,additionalSandboxParameters:[],..._}},settingsUpdate:{value:false}})}var R=t.extend("sap.ui.rta.plugin.iframe.AddIFrameDialog",{metadata:{library:"sap.ui.rta",events:{opened:{}}}});R.prototype.open=function(e){return new Promise(function(t){this._fnResolve=t;this._createDialog(e)}.bind(this))};R.prototype._createDialog=function(t){this._oJSONModel=d(!!t?.updateMode,!!t?.asContainer,t?.frameWidth,t?.frameHeight,t?.useLegacyNavigation,t?.advancedSettings);this._oController=new E(this._oJSONModel,t);a.load({name:"sap.ui.rta.plugin.iframe.AddIFrameDialog",controller:this._oController}).then(function(e){this._oDialog=e;this._oDialog.addStyleClass(l.getRtaStyleClassName());this._oDialog.setModel(this._oJSONModel);this._openDialog()}.bind(this)).catch(function(t){e.error("Error loading fragment sap.ui.rta.plugin.iframe.AddIFrameDialog: ",t)})};R.prototype._openDialog=function(){this._oDialog.attachAfterOpen(function(){this._disablePanelExpand();this.fireOpened()}.bind(this));this._oDialog.attachAfterClose(function(){this._oDialog.destroy();this._oDialog=null;this._fnResolve(this._oController.getSettings());this._oController=null}.bind(this));this._oDialog.open()};R.prototype._disablePanelExpand=function(){var e=A.getElementById("sapUiRtaAddIFrameDialog_PreviewLinkPanel").getDependents()[0];if(e){e.setEnabled(false)}};R.buildUrlBuilderParametersFor=function(e){return r().then(function(t){var a=Object.keys(t).map(function(e){return{label:e,key:`{$user>/${e}}`,value:t[e]}});var i=e.getBindingContext();var A;if(i){var _=i.getObject();A=Object.keys(_).filter(function(e){return typeof _[e]!=="object"}).map(function(e){return{label:e,key:`{${e}}`,value:_[e]}})}else{A=[]}return a.concat(A)})};return R});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/iframe/AddIFrameDialogController", ["sap/base/Log","sap/m/Popover","sap/m/Text","sap/m/Token","sap/ui/core/mvc/Controller","sap/ui/core/Element","sap/ui/core/library","sap/ui/rta/util/validateText","sap/ui/rta/Utils","sap/ui/fl/util/IFrame","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/rta/plugin/iframe/urlCleaner"],function(e,t,r,a,i,o,s,n,l,d,u,v,g){"use strict";var{ValueState:p}=s;var h=["frameUrl","title"];var m=["frameWidth","frameHeight"];var c=["frameWidthUnit","frameHeightUnit","useLegacyNavigation","advancedSettings"];function _(e){return d.isValidUrl(encodeURI(e))}function S(e){const t=e.text;return new a({key:t,text:t})}return i.extend("sap.ui.rta.plugin.iframe.AddIFrameDialogController",{constructor:function(e,t){this._oJSONModel=e;this._importSettings(t);this._mParameterHashMap=this._buildParameterHashMap(t)},configureMultiInput(){const e=o.getElementById("sapUiRtaAddIFrameDialog_AddAdditionalParametersInput");e.addValidator(S)},onSwitchChange(){this._oJSONModel.setProperty("/settingsUpdate/value",true)},onTokenUpdate(e){let t=this._oJSONModel.getProperty("/advancedSettings/value/additionalSandboxParameters");if(e.getParameter("type")==="added"){e.getParameter("addedTokens").forEach(function(e){t=[...t,e.getText()]})}else if(e.getParameter("type")==="removed"){e.getParameter("removedTokens").forEach(function(e){t=t.filter(function(t){return t!==e.getText()})})}this._oJSONModel.setProperty("/advancedSettings/value/additionalSandboxParameters",t);this._oJSONModel.setProperty("/settingsUpdate/value",true)},onValidationSuccess(e){e.getSource().setValueState(p.None);this._oJSONModel.setProperty("/areAllFieldsValid",this._areAllTextFieldsValid()&&this._areAllValueStateNones())},onValidationError(e){e.getSource().setValueState(p.Error);this._oJSONModel.setProperty("/areAllFieldsValid",false);this._setFocusOnInvalidInput()},onSavePress(){var e=this._buildPreviewURL(this._buildReturnedURL());if(_(e)&&this._areAllTextFieldsValid()&&this._areAllValueStateNones()){this._close(this._buildReturnedSettings())}else{this._setFocusOnInvalidInput()}},onShowPreview(){var t=this._buildPreviewURL(this._buildReturnedURL());if(!_(t)){return}var r=o.getElementById("sapUiRtaAddIFrameDialog_PreviewFrame");var a=o.getElementById("sapUiRtaAddIFrameDialog_PreviewLinkPanel");var i=a.getDependents()[0];if(t){i.setEnabled(true)}else{a.setExpanded(false);i.setEnabled(false)}try{this._oJSONModel.setProperty("/previewUrl/value",t);this._oJSONModel.setProperty("/previewUseLegacyNavigation/value",this._oJSONModel.getProperty("/useLegacyNavigation/value"));r.setUrl(t);this._oJSONModel.setProperty("/settingsUpdate/value",false);r.applySettings({url:t,advancedSettings:{...this._oJSONModel.getProperty("/advancedSettings/value")}})}catch(t){e.error("Error previewing the URL: ",t)}},onParameterPress(e){var t=e.getSource().getBindingContext().getObject().key;this._oJSONModel.setProperty("/frameUrl/value",this._addURLParameter(t));this.onUrlChange()},onLiveChange(e){var t=new u("label",v.Contains,e.getParameter("newValue"));var r=o.getElementById("sapUiRtaAddIFrameDialog_ParameterTable").getBinding("items");r.filter([t])},onLegacyNavigationInfoPress(e){const a=e.getSource();if(!this._oPopover){this._oPopover=new t(`${a.getId()}-popover`,{showHeader:false,contentWidth:"400px",content:[new r({text:"{/text/useLegacyNavigationInfo}"}).addStyleClass("sapUiSmallMargin")]});a.addDependent(this._oPopover)}this._oPopover.openBy(a)},_buildPreviewURL(e){return e.replace(/{(.*?)}/g,function(e){return this._mParameterHashMap[e]}.bind(this))},_addURLParameter(e){return this._buildReturnedURL()+e},_buildReturnedURL(){return g(this._oJSONModel.getProperty("/frameUrl/value"))},onUrlChange(){var e=this._buildPreviewURL(this._buildReturnedURL());var t=o.getElementById("sapUiRtaAddIFrameDialog_EditUrlTA");if(_(e)){t.setValueState("None")}else{t.setValueState("Error")}},_buildParameterHashMap(e){if(e&&e.parameters){return l.buildHashMapFromArray(e.parameters,"key","value")}return{}},onCancelPress(){this._close()},onContainerTitleChange(e){var t=e.getSource();var r="None";var a=false;var i=t.getValue();if(i.trim()===""){r="Error";t.setValueState(r);a=true;return a}try{n(i)}catch(e){r="Error";a=true}t.setValueState(r);return a},_close(e){var t=o.getElementById("sapUiRtaAddIFrameDialog");this._mSettings=e;t.close()},getSettings(){return this._mSettings},_areAllValueStateNones(){var e=this._oJSONModel.getData();return h.concat(m).every(function(t){return e[t].valueState===p.None},this)},_areAllTextFieldsValid(){var e=this._oJSONModel;var t=this._oJSONModel.getProperty("asContainer/value");return h.reduce(function(r,a){if(a==="title"&&!t){return true}var i=`/${a}/value`;var o;if(e.getProperty(i).trim()===""){o=p.Error}else{o=p.None}e.setProperty(`${i}State`,o);return r&&o===p.None},true)},_buildReturnedSettings(){var e={};var t=this._oJSONModel.getData();h.concat(m,c).forEach(function(r){var a=t[r].value;if(r==="frameUrl"){a=g(a)}e[r]=a});return e},_importSettings(e){if(e){Object.keys(e).forEach(function(t){if(t==="frameWidth"||t==="frameHeight"){this._importIFrameSize(t,e[t])}else if(t==="advancedSettings"&&!e[t]){return}else{this._oJSONModel.setProperty(`/${t}/value`,e[t])}},this)}},_importIFrameSize(e,t){var r=t.split(/(px|rem|%|vh)/);if(r.length>=2){this._oJSONModel.setProperty(`/${e}/value`,parseFloat(r[0]));this._oJSONModel.setProperty(`/${e}Unit/value`,r[1])}},_setFocusOnInvalidInput(){var e=this._oJSONModel.getData();m.some(function(t){if(e[t].valueState===p.Error){var r=o.getElementById(e[t].id);r.focus();return true}},this)}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/iframe/urlCleaner", [],function(){"use strict";return function(n){return n.replace(/\t|\r|\n/g,"")}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/service/Action", ["sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/base/util/restricted/_castArray","sap/base/util/restricted/_pick"],function(t,n,r,e){"use strict";return function(n){function i(t,n){return typeof t==="function"?t(n):t}function o(t){var r=n._oDesignTime.getPlugins().map(function(n){return n.getMenuItems(t)});return Promise.all(r).then(function(n){return n.reduce(function(t,n){return n?t.concat(n):t},[]).map(function(n){return Object.assign({},n,{enabled:i(n.enabled,t),text:i(n.text,t[0])})})})}function u(n){var i=r(n);var u=i.map(function(n){var r=t.getOverlay(n);if(!r){throw new Error(`Control with id="${n}" is not under a root element or ignored.'`)}return r});return o(u).then(function(t){return t.map(function(t){return e(t,["id","icon","rank","group","enabled","text"])})})}function a(n,e){var i=r(n);var u=i.map(function(n){var r=t.getOverlay(n);if(!r){throw new Error(`Control with id="${n}" is not under a root element or ignored.`)}return r});return o(u).then(function(t){var n=t.filter(function(t){return t.id===e}).pop();if(!n){throw new Error("No action found by specified ID")}else{return n.handler(u,{})}})}return{exports:{get:u,execute:a}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/service/ControllerExtension", ["sap/ui/core/Element","sap/ui/dt/Util","sap/ui/dt/OverlayRegistry","sap/ui/fl/Utils","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/thirdparty/jquery"],function(e,r,t,a,o,n,i,jQuery){"use strict";return function(s){function l(e){return new Promise(function(r,t){var a;jQuery.ajax({url:a=`${sap.ui.require.toUrl(e)}.js`,async:true,success(e){r(e)},error(r,o,n){var i=new Error(`resource ${e} could not be loaded from ${a}. Check for 'file not found' or parse errors. Reason: ${n}`);i.status=o;i.error=n;i.statusCode=r.status;t(n)},dataType:"text"})})}return{exports:{add(t,l){var c=s.getFlexSettings();if(!c.developerMode){throw r.createError("service.ControllerExtension#add","code extensions can only be created in developer mode","sap.ui.rta")}if(!t){throw r.createError("service.ControllerExtension#add","can't create controller extension without codeRef","sap.ui.rta")}if(!t.endsWith(".js")){throw r.createError("service.ControllerExtension#add","codeRef has to end with 'js'")}var u=e.getElementById(l);var d=a.getAppComponentForControl(u);var p=u.getControllerName&&u.getControllerName()||u.getController()&&u.getController().getMetadata().getName();var g=o.getFlexReference({element:d});var f=g.replace(/\.Component/g,"").replace(/\./g,"/");f+="/changes/";f+=t.replace(/\.js/g,"");var v={codeRef:t,controllerName:p,changeType:"codeExt",layer:c.layer,namespace:c.namespace,reference:g,moduleName:f,generator:"rta.service.ControllerExtension"};var m=n.create({changeSpecificData:v,selector:d});i.add({change:m,selector:d});return m.convertToFileContent()},getTemplate(e){var a=t.getOverlay(e);if(!a){throw r.createError("service.ControllerExtension#getTemplate","no overlay found for the given view ID","sap.ui.rta")}var o=a.getDesignTimeMetadata().getControllerExtensionTemplate();return l(`${o}-dbg`).catch(function(){return l(o)})}}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/service/Outline", ["sap/ui/dt/OverlayRegistry","sap/ui/dt/ElementOverlay","sap/ui/dt/AggregationOverlay","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/write/api/ExtensionPointRegistryAPI","sap/base/util/deepEqual","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/util/restricted/_omit","sap/ui/core/mvc/View","sap/base/Log","sap/ui/base/DesignTime"],function(e,t,n,i,a,r,s,g,o,l,d,u,m){"use strict";function v(e,t){var n=r.getExtensionPointInfoByViewId({viewId:e});return l(n,t)}function c(e){return l(e,["bIsView"])}return function(p,f){var h={};h.mExtensionPointMetadata={palette:{icons:{svg:"sap/ui/core/designtime/Icon.icon.svg"}}};h._aConsideredExtensionPoints=[];h._attachNotConsideredExtensionPoints=function(e,t){var n=a.getViewForControl(e.getElement()).getId();var i=v(n,this._aConsideredExtensionPoints);Object.keys(i).forEach(function(e,a){var r=i[e];var s=this._getExtensionPointData(r);s.id=n;t.elements.splice(a,0,s);this._aConsideredExtensionPoints.push(s.name)}.bind(this))};h._getOutline=function(t,n){var a;if(!n&&i.isInteger(t)){n=t;t=undefined}var r=[];if(!t){r=p._oDesignTime.getRootElements().map(function(t){return e.getOverlay(t)})}else{var s=e.getOverlay(t);if(!s){throw i.createError("services.Outline#get",`Cannot find element with id= ${t}. A valid or empty value for the initial element id should be provided.`,"sap.ui.rta")}r.push(s)}a=r.map(function(e){return this._getChildrenNodes(e,n)},this);this._aConsideredExtensionPoints=[];return a};h._getExtensionPoints=function(e){var t=e.id;var n=e.technicalName;return r.getExtensionPointInfoByParentId({parentId:t}).filter(function(e){return e.aggregationName===n})};h._getExtensionPointData=function(e){return{id:e.targetControl.getId(),name:e.name,technicalName:"sap.ui.extensionpoint",type:"extensionPoint",icon:this.mExtensionPointMetadata.palette.icons.svg,extensionPointInfo:{defaultContent:e.defaultContent.map(function(e){return e.getId()}),createdControls:e.createdControls||[]}}};h._enrichExtensionPointData=function(e,t){var n=m.isDesignModeEnabled();if(!n){return undefined}if(e.type==="aggregation"){var i=this._getExtensionPoints(e).sort(function(e,t){return t.index-e.index});i.forEach(function(t){var n=this._getExtensionPointData(t);e.elements.splice(t.index,0,n);this._aConsideredExtensionPoints.push(n.name)}.bind(this))}else if(e.bIsView){return this._attachNotConsideredExtensionPoints(t,e)}};function y(e,t,n){var i=e.getAggregationName&&e.getAggregationName();if(i){var a=e.getParent().getId();if(n[i]){return Object.assign({templateFor:a},n[i])}return(t&&t.elements||[]).map(function(e){if(e.type==="aggregationBindingTemplate"||e.parentAggregationName===i){return Object.assign({templateFor:a},e)}return e.technicalName===i&&e}).filter(Boolean)[0]}var r=e.getParentElementOverlay().getAggregationBindingTemplateOverlays&&e.getParentElementOverlay().getAggregationBindingTemplateOverlays().reduce(function(e,t){return e.concat(t.getChildren())},[])||[];if(r.includes(e)){return undefined}if(!t){return undefined}var s=e.getParentElementOverlay();if(s.getId()===t.templateFor){return t}var g=e.getParent().getChildren().indexOf(e);return t.elements[g]}h._getChildrenNodes=function(e,t,n,a){var r=i.isInteger(t);var s={};if(e.getShouldBeDestroyed()){return{}}var l=this._getNodeProperties(e,n,a)||{};var d=e.getChildren();var u=e.getAggregationBindingTemplateOverlays&&e.getAggregationBindingTemplateOverlays()||[];if(u.length>0){d=u.reduce(function(e,t){var n=t.getChildren()[0];s[n.getId()]=t.getAggregationName();return[n].concat(e)},d)}if((!r||r&&t>0)&&d.length>0&&!g(l)){t=r?t-1:t;var m={};l.elements=d.map(function(e){var n=y(e,a,m);var i=this._getChildrenNodes(e,t,e.getParent(),n);if(i.type==="aggregationBindingTemplate"){var r=s[e.getId()];m[r]=o({},i)}return i},this).filter(function(e){return!g(e)});this._enrichExtensionPointData(l,e)}return c(l)};function E(e,t,n){var i=e.getParentElementOverlay();return i&&n&&i.getAggregationOverlay(n,"AggregationBindingTemplateOverlays")===t}function O(e,t,n){var i={editable:e.getEditable(),bIsView:e.getElement()instanceof d};if(t.isA("sap.ui.core.Component")){i.component=true}if(typeof e.isVisible()==="boolean"){i.visible=e.isVisible()}var a=e.getParent()&&e.getParentAggregationOverlay();var r=a&&a.getAggregationName()||"";if(E(e,a,r)){i.type="aggregationBindingTemplate";i.icon="sap-icon://attachment-text-file";i.parentAggregationName=r}else{i.type="element"}var s=n.getName(t);if(s&&s.singular){i.name=s&&s.singular}return i}function _(e,t,n){var i=e.getAggregationName();var a={technicalName:e.getAggregationName(),editable:false,type:"aggregation",bIsView:e.getElement()instanceof d};if(t.getAggregation(i)){var r=t.getDesignTimeMetadata().getAggregationDescription(i,n);if(r.singular){a.name=r.singular}}if(t.getAggregationBindingTemplateOverlays().length){a.icon="sap-icon://card"}return a}function b(e,t,n){var i={id:e.getId(),technicalName:e.getMetadata().getName(),editable:false,type:null};if(n){i.templateReference=n.id}var a=P(t);if(a){i.icon=a}var r=t.getLabel(e);if(r&&r!==i.id){i.instanceName=r}return i}function P(e){var t=e.getData();return t.palette&&t.palette.icons&&t.palette.icons.svg||undefined}h._getNodeProperties=function(e,n,i){var a=e.getElement();var r=e.getDesignTimeMetadata();var s=b(a,r,i);if(e instanceof t){return Object.assign(s,O(e,a,r))}return Object.assign(s,_(e,n,a))};h._removeDuplicate=function(e,t){return e.filter(function(e){return!s(t,e,Infinity)})};h._updatesHandler=function(t){var i=t.getParameters();if(this.sStatus==="initial"){this.aUpdates=[]}var a=o({},i);var r=a.id?e.getOverlay(a.id).getElement().getId():undefined;var s=a.targetId?e.getOverlay(a.targetId).getElement().getId():undefined;switch(t.getId()){case"elementOverlayCreated":if(i.elementOverlay.isRoot()){var g=i.elementOverlay.getElement().getId();[a.element]=h._getOutline(g);a.type="new";break}return;case"elementOverlayAdded":[a.element]=h._getOutline(r);a.targetId=s;a.type="new";break;case"elementOverlayMoved":[a.element]=h._getOutline(r,0);a.targetId=s;a.type="move";break;case"elementOverlayDestroyed":var d=a.elementOverlay.getParentAggregationOverlay();if(d instanceof n&&!d._bIsBeingDestroyed||a.elementOverlay.isRoot()){a.element={};a.element.id=a.elementOverlay.getElement()?a.elementOverlay.getElement().getId():a.elementOverlay.getAssociation("element");a.type="destroy";break}return;case"elementOverlayEditableChanged":a.element={id:r,editable:a.editable};a.type="editableChange";break;case"elementPropertyChanged":[a.element]=h._getOutline(r,0);a.type="elementPropertyChange";break;default:u.error("Event type is not 'expected' by handler")}a=l(a,["elementOverlay","editable","target","id","elementId"]);this.aUpdates=h._removeDuplicate(this.aUpdates,a);this.aUpdates.push(a);if(this.sStatus==="initial"){setTimeout(function(){if(Array.isArray(this.aUpdates)&&this.aUpdates.length>0){this.sStatus="initial";f("update",this.aUpdates)}}.bind(h),200)}this.sStatus="processing"};h.destroy=function(){p._oDesignTime.detachEvent("elementOverlayCreated",this._updatesHandler,this);p._oDesignTime.detachEvent("elementOverlayAdded",this._updatesHandler,this);p._oDesignTime.detachEvent("elementOverlayMoved",this._updatesHandler,this);p._oDesignTime.detachEvent("elementOverlayDestroyed",this._updatesHandler,this);p._oDesignTime.detachEvent("elementPropertyChanged",this._updatesHandler,this);p._oDesignTime.detachEvent("elementOverlayEditableChanged",this._updatesHandler,this);delete this.aUpdates;delete this.sStatus};h.aUpdates=[];h.sStatus="initial";p._oDesignTime.attachEvent("elementOverlayCreated",h._updatesHandler,h);p._oDesignTime.attachEvent("elementOverlayAdded",h._updatesHandler,h);p._oDesignTime.attachEvent("elementOverlayMoved",h._updatesHandler,h);p._oDesignTime.attachEvent("elementOverlayDestroyed",h._updatesHandler,h);p._oDesignTime.attachEvent("elementPropertyChanged",h._updatesHandler,h);p._oDesignTime.attachEvent("elementOverlayEditableChanged",h._updatesHandler,h);return{events:["update"],exports:{get:h._getOutline.bind(h)},destroy:h.destroy.bind(h)}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/service/Property", ["sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/util/restricted/_omit"],function(e,t,n,r,i){"use strict";var a="[NOT SERIALIZABLE]";function o(e,t,n){if(Object(e)!==e){return true}if(typeof e==="function"){return false}if(typeof e==="object"){if(Array.isArray(e)){return e.every(o)}else if(e instanceof Map){var r={};e.forEach(function(e,t){r[t]=e});if(n){n[t]=r}e=r}return Object.keys(e).every(function(t){return o(e[t],t,e)})}return false}function u(e){return o(e)?e:a}return function(){var a={};a._getDesignTimeProperties=function(i){var o=e.getOverlay(i);if(!o){return t.createError("service.Property#get","A valid control id was not passed","sap.ui.rta")}var s=o.getElement();var l=s.getMetadata().getAllProperties();var g=o.getDesignTimeMetadata();var f=r({},g.getData());var c=f.properties||{};var d=f.annotations||{};var p=f.getLabel;return Promise.all([a._getConsolidatedAnnotations(d,s),a._getConsolidatedProperties(c||{},l,s),a._getResolvedFunction(p,s),a._getResolvedLinks(f.links,s)]).then(function(e){return Object.assign({},e[0]&&!n(e[0])&&{annotations:e[0]},e[1]&&{properties:e[1]},e[2]&&{label:u(e[2])},f.name&&{name:g.getName(s)},!n(e[3])&&{links:e[3]})})};a._getConsolidatedProperties=function(e,n,o){var s=Object.keys(n).reduce(function(e,t){e[t]={value:u(o.getProperty(t)),virtual:false,type:n[t].type,name:n[t].name,ignore:false,group:n[t].group,deprecated:n[t].deprecated,defaultValue:n[t].defaultValue,visibility:n[t].visibility};var r=a._getBindingInfo(t,o);Object.assign(e[t],r&&{binding:r});return e},{});return a._getResolvedFunction(e,o).then(function(e){return Promise.all(Object.keys(e).map(function(n){return a._getResolvedFunction(e[n].ignore,o).then(function(r){if(typeof r!=="boolean"){throw t.createError("services.Property#get",`Invalid ignore property value found in designtime for element with id ${o.getId()} .`,"sap.ui.rta")}var l={};if(!s[n]){if(e[n].virtual===true){l=a._getEvaluatedVirtualProperty(e,n,o,r)}else{l[n]={value:u(i(e[n],"ignore")),virtual:false,ignore:r}}}else{l[n]={ignore:r}}return l})}))}).then(function(e){return e.reduce(function(e,t){return r(e,t)},s)})};a._getEvaluatedVirtualProperty=function(e,t,n,r){var i={};i[t]={value:u(e[t].get(n)),virtual:true,type:e[t].type,name:e[t].name,group:e[t].group,ignore:r};var o=a._getBindingInfo(t,n);return a._getResolvedFunction(e[t].possibleValues,n).then(function(n){Object.assign(i[t],o&&{binding:o},n&&{possibleValues:u(n)},typeof e[t].nullable==="boolean"&&{nullable:e[t].nullable});return i})};a._getConsolidatedAnnotations=function(e,r){return Promise.all(Object.keys(e).map(function(i){return a._getResolvedFunction(e[i].ignore,r).then(function(o){var u={};if(typeof o!=="boolean"&&typeof o!=="undefined"){throw t.createError("services.Property#get",`Invalid ignore property value found in designtime for element with id ${r.getId()} .`,"sap.ui.rta")}e[i].ignore=o;if(!o){u[i]=Object.assign({},e[i]);return a._getResolvedLinks(u[i].links,r).then(function(e){if(!n(e)){u[i].links=e}return u})}})})).then(function(e){return e.reduce(function(e,t){return Object.assign(e,t)},{})})};a._getResolvedLinks=function(e,n){var r=[];var i=Object.assign({},e);Object.keys(i).forEach(function(e){if(Array.isArray(i[e])){i[e].forEach(function(e){r.push(t.wrapIntoPromise(function(){if(typeof e.text==="function"){return e.text(n)}})(e).then(function(t){e.text=u(t||e.text)}))})}});return Promise.all(r).then(function(){return i})};a._getBindingInfo=function(e,t){var n=t.getBindingInfo(e);if(!n){return}return r({},n.parts&&{parts:n.parts},n.binding&&{bindingValues:{values:n.binding.getValue()}},n.binding&&n.binding.getOriginalValue&&{bindingValues:{originalValues:n.binding.getOriginalValue()}},n.bindingString&&{bindingString:n.bindingString})};a._getResolvedFunction=function(e,n){return t.wrapIntoPromise(function(){return typeof e==="function"?e(n)||false:e||false})(e,n)};return{exports:{get:a._getDesignTimeProperties.bind(a)}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/service/Receiver", ["sap/ui/core/postmessage/Bus","sap/ui/dt/Util","sap/base/util/uid"],function(e,t,s){"use strict";var i="sap.ui.rta.service.receiver";var r;return function(n){var c={};var a=function(e){var a=e.data;var u=a.body;switch(e.eventId){case"getService":var o=u.arguments[0];n.getService(o).then(function(t){var s={};var c=[];Object.keys(t).forEach(function(e){if(typeof t[e]==="function"){if(!/^(at|de)tach/.test(e)){c.push(e)}}else{s[e]=t[e]}});r.publish({target:e.source,origin:e.origin,channelId:i,eventId:"getService",data:{id:a.id,type:"response",body:{methods:c,properties:s,events:n._mServices[o].service.events}}})});break;case"callMethod":n.getService(u.service).then(function(t){t[u.method].apply(null,u.arguments).then(function(t){r.publish({target:e.source,origin:e.origin,channelId:i,eventId:"callMethod",data:{type:"response",status:"success",id:a.id,body:t}})})}).catch(function(s){var n=t.propagateError(s,"service.Receiver",`Unexpected error: Can't execute method ${u.method} of service ${u.service}`,"sap.ui.rta");r.publish({target:e.source,origin:e.origin,channelId:i,eventId:"callMethod",data:{type:"response",status:"error",id:a.id,body:n.toString()}})});break;case"subscribe":n.getService(u.service).then(function(t){var n=function(t){r.publish({target:e.source,origin:e.origin,channelId:i,eventId:"event",data:{body:{service:u.service,event:u.event,data:t}}})};var o=s();c[o]=n;t.attachEvent(u.event,n);r.publish({target:e.source,origin:e.origin,channelId:i,eventId:"subscribe",data:{type:"response",status:"success",id:a.id,body:{id:o}}})});break;case"unsubscribe":n.getService(u.service).then(function(t){t.detachEvent(u.event,c[u.id]);delete c[u.id];r.publish({target:e.source,origin:e.origin,channelId:i,eventId:"unsubscribe",data:{type:"response",status:"success",id:a.id}})});break;default:}};r=e.getInstance();r.publish({channelId:i,eventId:e.event.READY});r.subscribe(i,"getService",a);r.subscribe(i,"callMethod",a);r.subscribe(i,"subscribe",a);r.subscribe(i,"unsubscribe",a);return{destroy(){if(r){r.unsubscribe(i,"getService",a);r.unsubscribe(i,"callMethod",a);r.unsubscribe(i,"subscribe",a);r.unsubscribe(i,"unsubscribe",a)}}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/service/Selection", function(){"use strict";return function(e,t){var n=e._oDesignTime.getSelectionManager();function r(e){return e.map(function(e){return e.getElement().getId()})}n.attachEvent("change",function(e){t("change",r(e.getParameter("selection")))});return{events:["change"],exports:{get(){return r(n.get())},set:n.set.bind(n),add:n.add.bind(n),remove:n.remove.bind(n),reset:n.reset.bind(n)}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/service/SupportTools", ["sap/ui/core/Element","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/dt/OverlayRegistry","sap/ui/fl/write/api/ChangesWriteAPI"],function(e,t,n,i){"use strict";var r="sapUiFlexibilitySupportExtension_Selected";function a(e,n,r){var a=e.getAction(n);if(a&&a.changeType){var l=a.changeOnRelevantContainer?n.getRelevantContainer():n.getElement();return i.getChangeHandler({changeType:a.changeType,element:l,modifier:t,layer:r.getLayer()}).then(function(e){return e}).catch(function(){return})}return Promise.resolve(undefined)}function l(e){if(e.endsWith(".asSibling")){return true}if(e.endsWith(".asChild")){return false}return undefined}function o(e,t){var n=l(t);var i=e.getPlugins();return Object.values(i).find(function(e){var i=e._retrievePluginName?e._retrievePluginName(n):e.getMetadata().getName();return i===t})}function u(){var e=document.getElementsByClassName(r);if(e.length>0){e[0].classList.remove(r)}}function s(t,n){var i=e.getElementById(n.overlayId);if(!i){return}var r=i.getElement();if(i.getSelectable()){u()}return Promise.all(i.getEditableByPlugins().map(function(e){var n=o(t,e);var r=l(e);return a(n,i,t).then(function(t){return{name:e,isAvailable:n.isAvailable([i],r),hasChangeHandler:!!t}})})).then(function(e){return{elementId:r.getId(),elementControlType:r.getMetadata().getName(),overlayId:i.getId(),plugins:e}})}function d(t,n){var i=e.getElementById(n.overlayId);var r=o(t,n.pluginName);a(r,i,t).then(console.log)}function g(e){if(document.getElementsByClassName("sapUiDtContextMenu").length>0){var t=e.getPlugins().contextMenu;t.oContextMenuControl.close()}}function c(t,n){var i=e.getElementById(n.overlayId);i.focus();window.postMessage({type:"getOverlayInfo",id:"ui5FlexibilitySupport.submodules.overlayInfo",content:{overlayId:i.getId()}});u();g(t);if(i.getSelectable()){i.setSelected(true)}else{var r=t.getSelection();r.forEach(function(e){e.setSelected(false)});if(i.getDomRef()){i.getDomRef().classList.add("sapUiFlexibilitySupportExtension_Selected")}}}function f(){var e=n.getOverlays();var t=[];e.forEach(function(e){if(!e.isA("sap.ui.dt.AggregationOverlay")){var n=e.getParentElementOverlay()?.getId();var i=e.getChildren().map(function(e){return e.getId()});t.push({id:e.getId(),parentId:n,elementId:e.getElement().getId(),visible:e.getSelectable()&&e.isVisible(),idNum:parseInt(e.getId().replace("__overlay","")),children:i,hasParent:n!==undefined})}});return t}function v(t,n){var i=e.getElementById(n.overlayId);console.log(i.getDesignTimeMetadata().getData())}var p={getOverlayInfo:{handler:s,returnMessageType:"overlayInfo",id:"ui5FlexibilitySupport.submodules.overlayInfo"},printChangeHandler:{handler:d,id:"ui5FlexibilitySupport.submodules.overlayInfo"},printDesignTimeMetadata:{handler:v,id:"ui5FlexibilitySupport.submodules.overlayInfo"},changeOverlaySelection:{handler:c,id:"ui5FlexibilitySupport.submodules.overlayInfo"},collectOverlayTableData:{handler:f,returnMessageType:"overlayInfoTableData",id:"ui5FlexibilitySupport.submodules.overlayInfo"}};function y(){window.postMessage({type:"rtaStopped",id:"ui5FlexibilitySupport.submodules.overlayInfo",content:{}})}function m(){window.postMessage({type:"rtaStarted",id:"ui5FlexibilitySupport.submodules.overlayInfo",content:{}})}function I(e,t){if(t.source!==window){return}var n=Object.entries(p).find(function(e){return e[0]===t.data.type&&e[1].id===t.data.id});var i=n&&n[1];if(i){Promise.resolve(i.handler(e,t.data.content)).then(function(e){if(i.returnMessageType){t.source.postMessage({id:i.id,type:i.returnMessageType,content:e})}})}}return function(e){var t=I.bind(null,e);window.addEventListener("message",t);e.attachEventOnce("stop",y);m();return{destroy(){window.removeEventListener("message",t)}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/service/index", function(){"use strict";return Object.freeze({selection:"sap.ui.rta.service.Selection",receiver:"sap.ui.rta.service.Receiver",controllerExtension:"sap.ui.rta.service.ControllerExtension",outline:"sap.ui.rta.service.Outline",action:"sap.ui.rta.service.Action",property:"sap.ui.rta.service.Property",supportTools:"sap.ui.rta.service.SupportTools"})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/Adaptation", ["./AdaptationRenderer","sap/base/Log","sap/m/MessageBox","sap/ui/core/BusyIndicator","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/core/Popup","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/initial/api/Version","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/model/json/JSONModel","sap/ui/performance/Measurement","sap/ui/rta/appVariant/Feature","sap/ui/rta/toolbar/Base","sap/ui/rta/toolbar/contextBased/ManageAdaptations","sap/ui/rta/toolbar/contextBased/SaveAsAdaptation","sap/ui/rta/toolbar/translation/Translation","sap/ui/rta/toolbar/versioning/Versioning","sap/ui/rta/Utils","sap/ui/VersionInfo"],function(t,e,i,o,n,s,r,a,h,c,d,l,u,p,f,g,b,_,m,A){"use strict";var T=p.extend("sap.ui.rta.toolbar.Adaptation",{renderer:t,animation:true,metadata:{library:"sap.ui.rta",events:{undo:{},redo:{},exit:{},save:{},restore:{},publishVersion:{},modeChange:{},activate:{},discardDraft:{},switchVersion:{},switchAdaptation:{},deleteAdaptation:{},openChangeCategorySelectionPopover:{}}}});T.LEFT_SECTION="toolbarIconAndDraftSection";T.MIDDLE_SECTION="toolbarSwitcherSection";T.RIGHT_SECTION="toolbarActionsSection";var I=124;T.prototype.init=function(...t){this._mSizeLimits={switchToIcons:undefined};p.prototype.init.apply(this,t);this._pFragmentLoaded=this._pFragmentLoaded.then(function(){this._onResize=this._onResize.bind(this);window.addEventListener("resize",this._onResize);this._aIntersectionObservers=[]}.bind(this))};T.prototype._calculateWindowWidth=function(t){var e=t[0].intersectionRect.width;return e*2+this._iSwitcherToolbarWidth+80};T.prototype.exit=function(...t){window.removeEventListener("resize",this._onResize);this._aIntersectionObservers.forEach(function(t){t.disconnect()});p.prototype.exit.apply(this,t)};T.prototype._restoreHiddenElements=function(){delete this._iOnResizeAnimationFrame;if(window.innerWidth>this._mSizeLimits.switchToIcons){this._switchToTexts();delete this._mSizeLimits.switchToIcons}};T.prototype._onResize=function(){if(this._iOnResizeAnimationFrame){window.cancelAnimationFrame(this._iOnResizeAnimationFrame)}this._iOnResizeAnimationFrame=window.requestAnimationFrame(this._restoreHiddenElements.bind(this))};T.prototype.initialAdjustToolbarSectionWidths=function(){var t=this.getControl("modeSwitcher").getDomRef().getBoundingClientRect().width;this._iSwitcherToolbarWidthWithTexts=t+16;this._iSwitcherToolbarWidth=this._iSwitcherToolbarWidthWithTexts;this.adjustToolbarSectionWidths()};T.prototype.adjustToolbarSectionWidths=function(){this.getControl(T.MIDDLE_SECTION).setWidth(`${this._iSwitcherToolbarWidth}px`);[T.LEFT_SECTION,T.RIGHT_SECTION].forEach(function(t){this.getControl(t).getDomRef().style.setProperty("width",`calc(50% - ${Math.ceil(this._iSwitcherToolbarWidth/2)}px)`,"important")}.bind(this))};T.prototype._observeIntersections=function(){this._aIntersectionObservers.forEach(function(t){t.disconnect()});[T.LEFT_SECTION,T.RIGHT_SECTION].forEach(function(t){var e=this._createIntersectionObserver(t);this._observeToolbarIntersection(t,e);this._aIntersectionObservers.push(e)}.bind(this))};T.prototype._hideElementsOnIntersection=function(t,e){if(e[0].intersectionRatio===0){this.adjustToolbarSectionWidths();this._observeIntersections();return}if(e[0].intersectionRatio<1){if(!this._mSizeLimits.switchToIcons){this._mSizeLimits.switchToIcons=this._calculateWindowWidth(e);this._switchToIcons()}}};T.prototype._createIntersectionObserver=function(t){return new IntersectionObserver(this._hideElementsOnIntersection.bind(this,t),{threshold:1,root:this.getControl(t).getDomRef()})};T.prototype._observeToolbarIntersection=function(t,e){var i=this.getControl(t);i.getItems().map(function(t){var i=t.getDomRef();e.observe(i)})};T.prototype.show=function(){return p.prototype.show.call(this,this.initialAdjustToolbarSectionWidths.bind(this)).then(function(){this._observeIntersections()}.bind(this))};function v(t,e,i,o){var n=this.getControl(t);var s=i?this.getTextResources().getText(i):"";var r=o?this.getTextResources().getText(o):"";n.setText(s||"");n.setTooltip(r||"");n.setIcon(e||"")}T.prototype.formatPublishVersionVisibility=function(t,e,i,o){return this.getExtension("versioning",_).formatPublishVersionVisibility(t,e,i,o)};T.prototype.formatDiscardDraftVisible=function(t,e,i){return this.getExtension("versioning",_).formatDiscardDraftVisible(t,e,i)};T.prototype.formatVersionButtonText=function(t,e){return this.getExtension("versioning",_).formatVersionButtonText(t,e)};T.prototype.showVersionHistory=function(t){return this.getExtension("versioning",_).showVersionHistory(t)};T.prototype._openVersionTitleDialog=function(t){return this.getExtension("versioning",_).openActivateVersionDialog(t)};T.prototype.showActionsMenu=function(t){var e=t.getSource();if(!this._oActionsMenuFragment){return s.load({id:`${this.getId()}_actionsMenu_fragment`,name:"sap.ui.rta.toolbar.ActionsMenu",controller:{openDownloadTranslationDialog:w.bind(this),openUploadTranslationDialog:D.bind(this),manageApps:P.bind(this),overviewForKeyUser:V.bind(this),overviewForDeveloper:L.bind(this),restore:this.eventHandler.bind(this,"Restore"),formatSaveAsEnabled:S,saveAs:y.bind(this)}}).then(function(t){t.addStyleClass(m.getRtaStyleClassName());this.addDependent(t);t.openBy(e,true,r.Dock.CenterTop,r.Dock.CenterBottom);this._oActionsMenuFragment=t}.bind(this))}this._oActionsMenuFragment.openBy(e,true,r.Dock.CenterTop,r.Dock.CenterBottom);return Promise.resolve()};T.prototype._showButtonIcon=function(t,e,i){v.call(this,t,e,"",i)};T.prototype._showButtonText=function(t,e){v.call(this,t,"",e,"")};T.prototype._switchToIcons=function(){this._showButtonIcon("adaptationSwitcherButton","sap-icon://wrench","BTN_ADAPTATION");this._showButtonIcon("navigationSwitcherButton","sap-icon://explorer","BTN_NAVIGATION");this._showButtonIcon("visualizationSwitcherButton","sap-icon://show","BTN_VISUALIZATION");this._iSwitcherToolbarWidth=I;this.adjustToolbarSectionWidths()};T.prototype._switchToTexts=function(){this._showButtonText("adaptationSwitcherButton","BTN_ADAPTATION");this._showButtonText("navigationSwitcherButton","BTN_NAVIGATION");this._showButtonText("visualizationSwitcherButton","BTN_VISUALIZATION");this._iSwitcherToolbarWidth=this._iSwitcherToolbarWidthWithTexts;this.adjustToolbarSectionWidths()};T.prototype.buildControls=function(){return s.load({name:"sap.ui.rta.toolbar.Adaptation",id:`${this.getId()}_fragment`,controller:{activate:this._openVersionTitleDialog.bind(this),discardDraft:this.eventHandler.bind(this,"DiscardDraft"),formatDiscardDraftVisible:this.formatDiscardDraftVisible.bind(this),formatPublishVersionVisibility:this.formatPublishVersionVisibility.bind(this),modeChange:this.eventHandler.bind(this,"ModeChange"),undo:this.eventHandler.bind(this,"Undo"),redo:this.eventHandler.bind(this,"Redo"),openChangeCategorySelectionPopover:this.eventHandler.bind(this,"OpenChangeCategorySelectionPopover"),saveAsAdaptation:x.bind(this),editAdaptation:E.bind(this),deleteAdaptation:B.bind(this),manageAdaptations:M.bind(this),switchAdaptation:F.bind(this),formatAdaptationsMenuText:N.bind(this),publishVersion:this.eventHandler.bind(this,"PublishVersion"),save:this.eventHandler.bind(this,"Save"),exit:this.eventHandler.bind(this,"Exit"),formatVersionButtonText:this.formatVersionButtonText.bind(this),showVersionHistory:this.showVersionHistory.bind(this),showActionsMenu:this.showActionsMenu.bind(this),showFeedbackForm:this.showFeedbackForm.bind(this)}})};function w(){var t={layer:this.getRtaInformation().flexSettings.layer,selector:this.getRtaInformation().rootControl};this.getExtension("translation",b).openDownloadTranslationDialog(t)}function D(){this.getExtension("translation",b).openUploadTranslationDialog()}function S(t,e){return t&&e!==h.Number.Draft}function y(){u.onSaveAs(true,true,this.getRtaInformation().flexSettings.layer,null)}function R(t){var e=t.commandStack.canSave();return m.showMessageBox("confirm",e?"DAC_DIALOG_MIGRATION_DIRTY_DESCRIPTION":"DAC_DIALOG_MIGRATION_DESCRIPTION",{titleKey:"DAC_DIALOG_MIGRATION_HEADER",actionKeys:["DAC_DIALOG_MIGRATION_HEADER"],showCancel:true}).then(function(o){if(o!==i.Action.CANCEL){if(e){return new Promise(function(t){this.fireEvent("save",{callback:t})}.bind(this)).then(function(){return C.call(this,t)}.bind(this))}return C.call(this,t)}}.bind(this))}function C(t){o.show();l.start("onCBAMigration","Measurement of migration to context-based adaptation");return c.migrate({control:t.rootControl,layer:t.flexSettings.layer}).finally(function(){l.end("onCBAMigration");l.getActive()&&e.info(`onCBAMigration: ${l.getMeasurement("onCBAMigration").time} ms`);o.hide()}).then(m.showMessageBox.bind(undefined,"information","DAC_DIALOG_MIGRATION_SUCCESSFULL_DESCRIPTION",{titleKey:"DAC_DIALOG_MIGRATION_HEADER"})).then(function(){return new Promise(function(t){this.fireEvent("switchAdaptation",{adaptationId:"DEFAULT",callback:t})}.bind(this))}.bind(this)).catch(function(t){e.error(t.stack||t);var i="DAC_DIALOG_MIGRATION_ERROR_DESCRIPTION";var o={titleKey:"DAC_DIALOG_MIGRATION_HEADER",details:t.userMessage||t};m.showMessageBox("error",i,o)})}function x(){var t=this.getRtaInformation();m.checkDraftOverwrite(this.getModel("versions")).then(function(){l.start("onCBACanMigrate","Measurement if its possible to migrate to context-based adaptation");return c.canMigrate({control:t.rootControl,layer:t.flexSettings.layer})}).then(function(i){l.end("onCBACanMigrate");l.getActive()&&e.info(`onCBACanMigrate: ${l.getMeasurement("onCBACanMigrate").time} ms`);if(i){R.call(this,t)}else{this.getExtension("contextBasedSaveAs",g).openAddAdaptationDialog(t.flexSettings.layer)}}.bind(this)).catch(O)}function E(){m.checkDraftOverwrite(this.getModel("versions")).then(function(){this.getExtension("contextBasedSaveAs",g).openAddAdaptationDialog(this.getRtaInformation().flexSettings.layer,true)}.bind(this)).catch(O)}function O(t){if(t!=="cancel"){m.showMessageBox("error","MSG_LREP_TRANSFER_ERROR",{error:t});e.error(`sap.ui.rta: ${t.stack||t.message||t}`)}}function B(){m.checkDraftOverwrite(this.getModel("versions")).then(function(){this.fireEvent("deleteAdaptation")}.bind(this)).catch(O)}function M(){this.getExtension("contextBasedManage",f).openManageAdaptationDialog()}function F(t){this.fireEvent("switchAdaptation",{adaptationId:t})}function N(t,e){if(t>0){if(e===""){return this.getTextResources().getText("TXT_DEFAULT_APP")}return this.getTextResources().getText("BTN_ADAPTING_FOR",[e])}return this.getTextResources().getText("BTN_ADAPTING_FOR_ALL_USERS")}function V(){return u.onGetOverview(true,this.getRtaInformation().flexSettings.layer)}function L(){return u.onGetOverview(false,this.getRtaInformation().flexSettings.layer)}function P(){u.onGetOverview(true,this.getRtaInformation().flexSettings.layer)}T.prototype.getControl=function(t){var e=n.getElementById(`${this.getId()}_fragment--sapUiRta_${t}`);if(!e&&this._oActionsMenuFragment){e=n.getElementById(this._oActionsMenuFragment.getId().replace("sapUiRta_actions","sapUiRta_")+t)}return e};T.prototype.hide=function(...t){this._aIntersectionObservers.forEach(function(t){t.disconnect()});return p.prototype.hide.apply(this,t)};T.prototype.showFeedbackForm=async function(){var t=a.getConfiguredFlexServices()[0].connector;var i="https://sapinsights.eu.qualtrics.com/jfe/form/";var o="SV_4MANxRymEIl9K06";var n=i+o;var r=new URLSearchParams;const h=await A.load();r.set("version",h.version);r.set("feature",t==="KeyUserConnector"?"BTP":"ABAP");var c=new d({url:`${n}?${r.toString()}`});return s.load({name:"sap.ui.rta.toolbar.FeedbackDialog",controller:this}).then(function(t){this._oFeedbackDialog=t;this._oFeedbackDialog.addStyleClass(m.getRtaStyleClassName());this._oFeedbackDialog.setModel(c,"feedbackModel");this._oFeedbackDialog.setModel(this.getModel("i18n"),"i18n");this._oFeedbackDialog.attachEventOnce("afterClose",function(){this._oFeedbackDialog.destroy()}.bind(this));this._oFeedbackDialog.open()}.bind(this)).catch(function(t){e.error("Error loading fragment sap.ui.rta.toolbar.FeedbackDialog: ",t)})};T.prototype.closeFeedbackForm=function(){if(this._oFeedbackDialog){this._oFeedbackDialog.close()}};return T});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/AdaptationRenderer", ["sap/ui/rta/toolbar/BaseRenderer"],function(a){"use strict";var e=a.extend("sap.ui.rta.toolbar.AdaptationRenderer");e.apiVersion=1;e.render=function(e,r){e.class("sapUiRtaToolbarAdaptation");a.render(e,r)};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/Base", ["sap/m/HBox","sap/ui/core/Element","sap/ui/core/StaticArea","sap/ui/core/Lib","sap/ui/dt/util/ZIndexManager","sap/ui/model/resource/ResourceModel","sap/ui/rta/util/Animation","./BaseRenderer"],function(t,e,i,o,n,s,r,a){"use strict";var l=t.extend("sap.ui.rta.toolbar.Base",{metadata:{library:"sap.ui.rta",properties:{color:{type:"string",defaultValue:"default"},zIndex:{type:"int"},rtaInformation:{type:"object",defaultValue:{flexSettings:{}}},textResources:"object"}},constructor:function(...e){t.apply(this,e);this._oExtensions={};this.setAlignItems("Center");this.setVisible(false);this.placeToContainer()},type:null,animation:false,renderer:a});l.prototype.init=function(...e){this._oResourceModel=new s({bundle:o.getResourceBundleFor("sap.ui.rta")});t.prototype.init.apply(this,e);this.setModel(this._oResourceModel,"i18n");this._fnOnScrollBound=this._onScroll.bind(this);window.addEventListener("scroll",this._fnOnScrollBound,true);this._pFragmentLoaded=this.buildContent()};l.prototype.exit=function(...e){Object.values(this._oExtensions).forEach(function(t){t.destroy()});this._oExtensions={};window.removeEventListener("scroll",this._fnOnScrollBound,true);t.prototype.exit.apply(this,e)};l.prototype.getExtension=function(t,e){if(!Object.keys(this._oExtensions).includes(t)){this._oExtensions[t]=new e({toolbar:this})}return this._oExtensions[t]};l.prototype.setTextResources=function(t){this.setProperty("textResources",t);this._oResourceModel=new s({bundle:o.getResourceBundleFor("sap.ui.rta")})};l.prototype.onFragmentLoaded=function(){return Promise.resolve()};l.prototype.eventHandler=function(t,e){this[`fire${t}`](e.getParameters())};l.prototype.buildControls=function(){return Promise.resolve([])};l.prototype.placeToContainer=function(){this.placeAt(i.getDomRef())};l.prototype.buildContent=function(){return this.buildControls().then(function(t){t.forEach(this.addItem,this)}.bind(this))};l.prototype.onFragmentLoaded=function(){return this._pFragmentLoaded};l.prototype.show=function(t){return new Promise(function(t){var e={onAfterRendering(){this.removeEventDelegate(e);t()}};this.addEventDelegate(e,this);this.bringToFront();this.setVisible(true)}.bind(this)).then(function(){if(t&&typeof t==="function"){t()}return this.animation?r.waitTransition(this.getDomRef(),this.addStyleClass.bind(this,"is_visible")):Promise.resolve()}.bind(this)).then(function(){this.focus()}.bind(this))};l.prototype.hide=function(t){var e=Promise.resolve();if(this.animation){if(t){this.removeStyleClass("is_visible")}else{e=r.waitTransition(this.getDomRef(),this.removeStyleClass.bind(this,"is_visible"))}}return e.then(function(){this.setVisible(false)}.bind(this))};l.prototype.getControl=function(t){return e.getElementById(`sapUiRta_${t}`)};l.prototype.bringToFront=function(){this.setZIndex(n.getNextZIndex())};l.prototype._onScroll=function(){var t=this.getDomRef();if(!t){return}var e="sapUiRtaToolbar_scrolling";t.classList.toggle(e,window.scrollY>0)};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/BaseRenderer", ["sap/ui/core/Renderer","sap/m/HBoxRenderer"],function(e,r){"use strict";var a=e.extend.call(r,"sap.ui.rta.toolbar.BaseRenderer");a.apiVersion=1;a.render=function(e,a){e.class("sapUiRtaToolbar");e.class(`color_${a.getColor()}`);a.type&&e.class(`type_${a.type}`);var s=a.getZIndex();s&&e.style("z-index",s);r.render(e,a)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/Fiori", ["sap/m/Image","./Adaptation","../Utils","sap/base/Log"],function(t,i,e,o){"use strict";var r="sapUiRtaFioriHeaderInvisible";var n=i.extend("sap.ui.rta.toolbar.Fiori",{metadata:{library:"sap.ui.rta"},renderer:"sap.ui.rta.toolbar.AdaptationRenderer",type:"fiori"});n.prototype.init=function(...t){this._oRenderer=e.getFiori2Renderer();this._oFioriHeader=this._oRenderer.getRootControl().getShellHeader();i.prototype.init.apply(this,t)};n.prototype.show=function(...t){this._oFioriHeader.addStyleClass(r);return i.prototype.show.apply(this,t)};n.prototype.buildControls=function(...e){return i.prototype.buildControls.apply(this,e).then(function(i){var e=this._oFioriHeader.getLogo();if(this._oFioriHeader.getShowLogo()&&e){var o=this._oFioriHeader.$().find("#shell-header-icon").get(0);var r;var n;if(o){r=o.getBoundingClientRect().width;n=o.getBoundingClientRect().height;this._checkLogoSize(o,r,n)}this.getControl("iconSpacer").setWidth("8px");this._iLogoWidth=r+8;this.getControl("iconBox").addItem(new t(`${this.getId()}_fragment--sapUiRta_icon`,{src:e,width:typeof r==="number"?`${r}px`:r,height:typeof n==="number"?`${n}px`:n}))}return i}.bind(this))};n.prototype.hide=function(...t){return i.prototype.hide.apply(this,t).then(function(){this._oFioriHeader.removeStyleClass(r)}.bind(this))};n.prototype._checkLogoSize=function(t,i,e){var r=t.naturalWidth;var n=t.naturalHeight;if(i!==r||e!==n){o.error(["sap.ui.rta: please check Fiori Launchpad logo, expected size is",`${i}x${e},`,`but actual is ${r}x${n}`].join(" "))}};n.prototype._restoreHiddenElements=function(){if(this._iLogoVisibilityLimit&&window.innerWidth>this._iLogoVisibilityLimit){this._setLogoVisibility(true);delete this._iLogoVisibilityLimit}i.prototype._restoreHiddenElements.apply(this)};n.prototype._hideElementsOnIntersection=function(...t){const[e,o]=t;var r;if(o[0].intersectionRatio===0){this.adjustToolbarSectionWidths();this._observeIntersections();return}if(o[0].intersectionRatio<1){if(!this._iLogoVisibilityLimit&&e===i.LEFT_SECTION){var n=o[0].boundingClientRect.width-o[0].intersectionRect.width;r=n>this._iLogoWidth;this._iLogoVisibilityLimit=this._calculateWindowWidth(o);this._setLogoVisibility(false);if(r){i.prototype._hideElementsOnIntersection.apply(this,t)}return}}i.prototype._hideElementsOnIntersection.apply(this,t)};n.prototype._setLogoVisibility=function(t){var i=this.getControl("iconBox");var e=this.getControl("iconSpacer");i.setVisible(t);e.setVisible(t)};n.prototype.destroy=function(...t){this._oFioriHeader.removeStyleClass(r);i.prototype.destroy.apply(this,t)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/FioriLike", ["./Adaptation"],function(a){"use strict";var r=a.extend("sap.ui.rta.toolbar.FioriLike",{metadata:{library:"sap.ui.rta"},renderer:"sap.ui.rta.toolbar.AdaptationRenderer",type:"fiori"});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/OverflowToolbarButton", ["sap/m/OverflowToolbarButton","sap/m/ButtonRenderer","sap/m/Button"],function(t,e,o){"use strict";var r=t.extend("sap.ui.rta.toolbar.OverflowToolbarButton",{metadata:{library:"sap.ui.rta",interfaces:["sap.m.IOverflowToolbarContent"],properties:{visibleIcon:{type:"string",defaultValue:""}}},renderer:e});r.prototype._onBeforeEnterOverflow=function(...e){t.prototype._onBeforeEnterOverflow.apply(this,e);this.setVisibleIcon(this.getIcon());this.setIcon("")};r.prototype._onAfterExitOverflow=function(...e){t.prototype._onAfterExitOverflow.apply(this,e);this.setIcon(this.getVisibleIcon())};r.prototype._getText=function(){if(this.getIcon()===""&&this.getVisibleIcon()===""||this._bInOverflow){return o.prototype._getText.call(this)}return""};r.prototype.getOverflowToolbarConfig=function(){return{canOverflow:true,onBeforeEnterOverflow:this._onBeforeEnterOverflow.bind(this),onAfterExitOverflow:this._onAfterExitOverflow.bind(this)}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/Personalization", ["./Base","sap/m/Button"],function(t,e){"use strict";var n=t.extend("sap.ui.rta.toolbar.Personalization",{renderer:"sap.ui.rta.toolbar.BaseRenderer",type:"personalization",metadata:{library:"sap.ui.rta",events:{exit:{},restore:{}}},constructor:function(...e){t.apply(this,e);this.setJustifyContent("End")}});n.prototype.buildContent=function(){[new e("sapUiRta_restore",{type:"Transparent",text:"{i18n>BTN_RESTORE}",visible:true,press:this.eventHandler.bind(this,"Restore")}).data("name","restore"),new e("sapUiRta_exit",{type:"Emphasized",text:"{i18n>BTN_DONE}",press:this.eventHandler.bind(this,"Exit")}).data("name","exit")].forEach(function(t){this.addItem(t)}.bind(this));return Promise.resolve()};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/Standalone", ["./Adaptation"],function(a){"use strict";var t=a.extend("sap.ui.rta.toolbar.Standalone",{metadata:{library:"sap.ui.rta"},renderer:"sap.ui.rta.toolbar.AdaptationRenderer",type:"standalone"});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/contextBased/ManageAdaptations", ["sap/base/i18n/Localization","sap/base/util/restricted/_isEqual","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/core/Fragment","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/m/ColumnListItem","sap/ui/rta/Utils","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/json/JSONModel","sap/ui/core/date/UI5Date","sap/ui/performance/Measurement"],function(t,e,a,o,n,i,r,s,l,d,c,p,g){"use strict";var u={Initial:0,Default:1024,Before(t){return t+1024},Between(t,e){return(t+e)/2},After(t){return t+.5}};var h=o.extend("sap.ui.rta.toolbar.contextBased.ManageAdaptations",{metadata:{properties:{toolbar:{type:"any"}}},constructor:function(...t){o.prototype.constructor.apply(this,t);this.oTextResources=this.getToolbar().getTextResources()}});h.prototype.openManageAdaptationDialog=function(){g.start("onCBAOpenManageAdaptationDialog","Measurement of opening the manage context-based adaptation dialog");if(!this._oManageAdaptationDialogPromise){this._oManageAdaptationDialogPromise=n.load({name:"sap.ui.rta.toolbar.contextBased.ManageAdaptationsDialog",id:`${this.getToolbar().getId()}_fragment--sapUiRta_manageAdaptationDialog`,controller:{formatContextColumnCell:f.bind(this),formatContextColumnTooltip:A.bind(this),formatCreatedChangedOnColumnCell:m.bind(this),onLiveSearch:M.bind(this),moveUp:b.bind(this),moveDown:_.bind(this),onDropSelectedAdaptation:x.bind(this),onSaveReorderedAdaptations:U.bind(this),isAdaptationsSelected:N.bind(this),getIndexOfSelectedAdaptation:k.bind(this),onCancel:V.bind(this)}}).then(function(t){this._oManageAdaptationDialog=t;t.addStyleClass(s.getRtaStyleClassName());this.getToolbar().addDependent(this._oManageAdaptationDialog)}.bind(this))}else{C.call(this);w.call(this,true);B.call(this,false)}return this._oManageAdaptationDialogPromise.then(function(){this._oRtaInformation=this.getToolbar().getRtaInformation();return i.load({control:this._oRtaInformation.rootControl,layer:this._oRtaInformation.flexSettings.layer})}.bind(this)).then(function(t){this.oAdaptationsModel=i.getAdaptationsModel({control:this._oRtaInformation.rootControl,layer:this._oRtaInformation.flexSettings.layer});this.oAdaptationsModel.updateAdaptations(t.adaptations);this.oReferenceAdaptationsData=JSON.parse(JSON.stringify(this.oAdaptationsModel.getProperty("/adaptations")));this._oOriginAdaptationsData=JSON.parse(JSON.stringify(this.oAdaptationsModel.getProperty("/allAdaptations")));this._oControlConfigurationModel=new c({isTableItemSelected:false});this._oManageAdaptationDialog.setModel(this.oAdaptationsModel,"contextBased");this._oManageAdaptationDialog.setModel(this._oControlConfigurationModel,"controlConfiguration");D.call(this).attachSelectionChange(v.bind(this));g.end("onCBAOpenManageAdaptationDialog");g.getActive()&&a.info(`onCBAOpenManageAdaptationDialog: ${g.getMeasurement("onCBAOpenManageAdaptationDialog").time} ms`);return this._oManageAdaptationDialog.open()}.bind(this)).catch(function(t){a.error(t.stack);var e="MSG_LREP_TRANSFER_ERROR";var o={titleKey:"BTN_MANAGE_APP_CTX"};o.details=t.userMessage;s.showMessageBox("error",e,o)})};function f(t){return`${t.length} ${t.length>1?this.oTextResources.getText("TXT_TABLE_CONTEXT_CELL_ROLES"):this.oTextResources.getText("TXT_TABLE_CONTEXT_CELL_ROLE")}`}function A(t){return t.join("\n")}function m(e,a){var o=p.getInstance(a);var n={year:"numeric",month:"short",day:"numeric",hour:"numeric",minute:"numeric"};var i=t.getLanguage();return`${e}\n${o.toLocaleTimeString(i,n)}`}function v(t){if(t.getParameter("selected")===true){this._oControlConfigurationModel.setProperty("/isTableItemSelected",true);C.call(this)}}function C(){var t=R.call(this,"moveUpButton");var e=R.call(this,"moveDownButton");if(L.call(this)){if(N.call(this)){t.setEnabled(k.call(this)>0);e.setEnabled(k.call(this)<this.oAdaptationsModel.getProperty("/count")-1)}else{t.setEnabled(false);e.setEnabled(false)}}else{t.setEnabled(false);e.setEnabled(false)}}function M(t){var e;var a=t.getSource().getValue();var o=D.call(this);var n=O.call(this);var i=E.call(this);if(a&&a.length>0){C.call(this);w.call(this,false);var r=new l("title",d.Contains,a);var s=new l({path:"contexts/role",test(t){return t.some(function(t){return t.includes(a.toUpperCase())})}});var c=new l("createdBy",d.Contains,a);var p=new l("changedBy",d.Contains,a);e=new l([r,s,c,p]);if(i.toUpperCase().includes(a.toUpperCase())){n.setVisible(true)}else{n.setVisible(false)}}else{w.call(this,true);if(this._oControlConfigurationModel.getProperty("/isTableItemSelected")){C.call(this)}n.setVisible(true)}var g=o.getBinding("items");g.filter(e,"Application")}function b(t){T.call(this,"Up");t.getSource().focus()}function _(t){T.call(this,"Down");t.getSource().focus()}function P(t,e){return t.rank-e.rank}function y(t){var e=t.getProperty("/adaptations")||[];e.sort(P);t.setProperty("/adaptations",e);t.refresh(true)}function T(t){var e=D.call(this);var a=e.getSelectedItem(0);var o=a.getBindingContext("contextBased");var n=e.indexOfItem(a)+(t==="Up"?-1:1);var i=e.getItems()[n];var r=i?i.getBindingContext("contextBased"):undefined;if(!r){return}var s=r.getProperty("rank");var l=o.getProperty("rank");this.oAdaptationsModel.setProperty("rank",s,o);this.oAdaptationsModel.setProperty("rank",l,r);y(this.oAdaptationsModel);e.getItems()[n].setSelected(true).focus();B.call(this,S.call(this));C.call(this)}function x(t){var e=t.getParameter("draggedControl");var a=e.getBindingContext("contextBased");if(!a){return}var o=u.Default;var n=t.getParameter("droppedControl");if(n instanceof r){var i=t.getParameter("dropPosition");var s=n.getBindingContext("contextBased");var l=s.getProperty("rank");var d=n.getParent();var c=d.indexOfItem(n);if(s===a){return}var p=c+(i==="After"?1:-1);var g=d.getItems()[p];if(!g||p===-1){o=p===-1?.5:u[i](l)}else{var h=g.getBindingContext("contextBased");o=u.Between(l,h.getProperty("rank"))}}this.oAdaptationsModel.setProperty("rank",o,a);y(this.oAdaptationsModel);var f=Object.assign(this.oAdaptationsModel.getProperty("/allAdaptations"),this.oAdaptationsModel.getProperty("/adaptations"));this.oAdaptationsModel.updateAdaptations(f);B.call(this,S.call(this))}function S(){return!e(this.oAdaptationsModel.getProperty("/adaptations").map(function(t){return t.id}),this.oReferenceAdaptationsData.map(function(t){return t.id}))}function B(t){var e=R.call(this,"manageAdaptations-saveButton");e.setTooltip(t?"":this.oTextResources.getText("TOOLTIP_APP_CTX_DIALOG_SAVE"));e.setEnabled(t)}function D(){return R.call(this,"manageAdaptationsTable")}function R(t){return this.getToolbar().getControl(`manageAdaptationDialog--${t}`)}function O(){return R.call(this,"defaultContext")}function E(){return R.call(this,"defaultApplicationTitle").getProperty("text")}function I(){return R.call(this,"searchField")}function L(){return I.call(this).getValue().length===0}function w(t){D.call(this).getDragDropConfig()[0].setEnabled(t)}function N(){var t=D.call(this);return t.getSelectedContextPaths().length>0}function k(){var t=D.call(this);if(t.getSelectedContextPaths().length>0){var e=t.getSelectedContextPaths()[0].split("/");var a=Number(e[e.length-1]);return a}return-1}function U(){s.checkDraftOverwrite(this.getToolbar().getModel("versions")).then(function(){var t=this.getToolbar().getRtaInformation();var e=this.oAdaptationsModel.getProperty("/adaptations").map(function(t){return t.id});return i.reorder({control:t.rootControl,layer:t.flexSettings.layer,parameters:{priorities:e}})}.bind(this)).then(function(){var t=Object.assign(this.oAdaptationsModel.getProperty("/allAdaptations"),this.oAdaptationsModel.getProperty("/adaptations"));this.oAdaptationsModel.updateAdaptations(t);$.call(this)}.bind(this)).catch(function(t){if(t!=="cancel"){s.showMessageBox("error","MSG_LREP_TRANSFER_ERROR",{titleKey:"BTN_MANAGE_APP_CTX",error:t});a.error(`sap.ui.rta: ${t.stack||t.message||t}`)}})}function V(){this.oAdaptationsModel.updateAdaptations(this._oOriginAdaptationsData);$.call(this)}function $(){this._oControlConfigurationModel.setProperty("/isTableItemSelected",false);I.call(this).setValue("");var t=D.call(this);t.getBinding("items").filter([]);t.removeSelections();O.call(this).setVisible(true);this._oManageAdaptationDialog.close()}return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/contextBased/SaveAsAdaptation", ["sap/ui/base/ManagedObject","sap/base/Log","sap/base/strings/formatMessage","sap/ui/core/BusyIndicator","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/core/library","sap/ui/fl/Layer","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/fl/write/api/ContextSharingAPI","sap/ui/rta/Utils","sap/ui/model/json/JSONModel","sap/ui/performance/Measurement"],function(t,e,o,i,a,n,s,r,d,l,p,h,g){"use strict";var{ValueState:u}=s;var c=t.extend("sap.ui.rta.toolbar.contextBased.SaveAsAdaptation",{metadata:{properties:{toolbar:{type:"any"}}},constructor:function(...e){t.prototype.constructor.apply(this,e);this.oTextResources=this.getToolbar().getTextResources()}});c.prototype.openAddAdaptationDialog=function(t,e){this._bIsEditMode=e;if(!this._oAddAdaptationDialogPromise){this._oAddAdaptationDialogPromise=n.load({name:"sap.ui.rta.toolbar.contextBased.SaveAsAdaptationDialog",id:`${this.getToolbar().getId()}_fragment--sapUiRta_addAdaptationDialog`,controller:{onAdaptationTitleChange:f.bind(this),onSaveAsAdaptation:T.bind(this),onCancelAdaptationDialog:x.bind(this),onPriorityChange:E.bind(this)}}).then(function(t){this._oAddAdaptationDialog=t;this._oAddAdaptationDialog.attachBeforeClose(R.bind(this));t.addStyleClass(p.getRtaStyleClassName());this.getToolbar().addDependent(this._oAddAdaptationDialog);this.oDialogModel=new h;this._oAddAdaptationDialog.setModel(this.oDialogModel,"dialogModel")}.bind(this))}else{var o=this.getToolbar().getControl("addAdaptationDialog--saveAdaptation-title-input");o.setValue("");o.setValueState(u.None)}return this._oAddAdaptationDialogPromise.then(function(){return v.call(this,t)}.bind(this)).then(function(){var t=this.getToolbar().getRtaInformation();this.oAdaptationsModel=d.getAdaptationsModel({control:t.rootControl,layer:t.flexSettings.layer});if(e){C.call(this)}else{this.oDialogModel.setProperty("/title",this.oTextResources.getText("SAC_DIALOG_HEADER"));this.oDialogModel.refresh(true)}return A.call(this)}.bind(this))};function A(){_.call(this,this.oAdaptationsModel.getProperty("/adaptations"));return this._oAddAdaptationDialog.open()}function C(){this.oDialogModel.setProperty("/title",this.oTextResources.getText("EAC_DIALOG_HEADER"));this.oDialogModel.refresh(true);var t=this.oAdaptationsModel.getProperty("/displayedAdaptation");this._mEditProperties={adaptationId:t.id,title:t.title,priority:t.rank-1,roles:t.contexts.role};this.getToolbar().getControl("addAdaptationDialog--saveAdaptation-title-input").setValue(this._mEditProperties.title);this._oContextComponentInstance.setSelectedContexts({role:this._mEditProperties.roles})}function _(t){var e=[{key:"0",title:this.oTextResources.getText("TXT_SELECT_FIRST_PRIO")}];var i=this.oTextResources.getText("TXT_SELECT_PRIO");var a=this._mEditProperties?this._mEditProperties.priority:undefined;t.forEach(function(t,n){if(a!==undefined&&a===n){return}var s=e.length;e.push({key:s.toString(),title:o(i,[t.title,s+1])})});this.oDialogModel.setProperty("/selected",a?e[a].key:e[0].key);this.oDialogModel.setProperty("/priority",e)}function f(){y.call(this);b.call(this)}function m(){b.call(this)}function x(){this._oAddAdaptationDialog.close()}function T(){var t={};t.title=S.call(this);t.contexts=this._oContextComponentInstance.getSelectedContexts();t.priority=D.call(this);var o=this.getToolbar().getRtaInformation();if(this._bIsEditMode){g.start("onCBAUpdateAdaptation","Measurement of updating a context-based adaptation");t.adaptationId=this._mEditProperties.adaptationId;d.update({control:o.rootControl,layer:o.flexSettings.layer,contextBasedAdaptation:t,adaptationId:this._mEditProperties.adaptationId}).then(function(t,o){if(o.status===200){this.oAdaptationsModel.updateAdaptationContent(t);g.end("onCBAUpdateAdaptation");g.getActive()&&e.info(`onCBAUpdateAdaptation: ${g.getMeasurement("onCBAUpdateAdaptation").time} ms`)}}.bind(this,t)).catch(function(t){e.error(t.stack);var o="MSG_LREP_TRANSFER_ERROR";var i={titleKey:"EAC_DIALOG_HEADER"};i.details=t.userMessage;p.showMessageBox("error",o,i)})}else{g.start("onCBASaveAsAdaptation","Measurement of saving a context-based adaptation");i.show();d.create({control:o.rootControl,layer:o.flexSettings.layer,contextBasedAdaptation:t}).then(function(){i.hide();this.getToolbar().fireEvent("switchAdaptation",{adaptationId:t.id,trigger:"SaveAs"});g.end("onCBASaveAsAdaptation");g.getActive()&&e.info(`onCBASaveAsAdaptation: ${g.getMeasurement("onCBASaveAsAdaptation").time} ms`)}.bind(this)).catch(function(t){i.hide();e.error(t.stack);var o="MSG_LREP_TRANSFER_ERROR";var a={titleKey:"SAC_DIALOG_HEADER"};a.details=t.userMessage;p.showMessageBox("error",o,a)})}this._oAddAdaptationDialog.close()}function E(t){b.call(this);this.sPriority=t.getParameters().selectedItem.getProperty("key")}function y(){if(this._oAddAdaptationDialog&&this._oAddAdaptationDialog.isOpen()){var t=this.getToolbar().getControl("addAdaptationDialog--saveAdaptation-title-input");var e=t.getValue().trim().length;var o=100;if(e===0){t.setValueState(u.Error);t.setValueStateText(this.oTextResources.getText("TXT_CTX_ERROR_EMPTY_TITLE"))}else if(e>o){t.setValueState(u.Error);t.setValueStateText(this.oTextResources.getText("TXT_CTX_ERROR_MAX_LEN",[o]))}else if(e>0){var i=this.oAdaptationsModel.getProperty("/adaptations").findIndex(function(e){if(e.title.trim().toLowerCase()===t.getValue().trim().toLowerCase()){if(this._mEditProperties&&this._mEditProperties.title.toLowerCase()===t.getValue().toLowerCase()){return false}return true}return false}.bind(this));if(i>-1){t.setValueState(u.Error);t.setValueStateText(this.oTextResources.getText("TXT_CTX_ERROR_DUPLICATE_TITLE"))}else{t.setValueState(u.None);t.setValueStateText(null)}}}}function v(t){var e={layer:t||r.CUSTOMER};return l.createComponent(e).then(function(t){this._oContextComponent=t;this._oContextComponentInstance=t.getComponentInstance();this._oContextComponentInstance.resetSelectedContexts();this._oAddAdaptationDialog.addContent(this._oContextComponent);var e=a.getElementById("contextSharing---ContextVisibility--selectedContextsList");e.attachUpdateFinished(m.bind(this));e.getHeaderToolbar().getContent()[0].setRequired(true);this._oContextComponentInstance.setEmptyListTextWithAdvice();this._oContextComponentInstance.showMessageStrip(false)}.bind(this))}function S(){var t=this.getToolbar().getControl("addAdaptationDialog--saveAdaptation-title-input");return t?t.getValue().trim():""}function D(){if(this._bIsEditMode&&!this.sPriority){this.sPriority=this.oDialogModel.getProperty("/selected")}return Number(this.sPriority)||0}function b(){var t=this.getToolbar().getControl("addAdaptationDialog--saveAdaptation-title-input");var e;var o=this._oContextComponentInstance.getSelectedContexts().role.length>0&&t.getValueState()===u.None&&t.getValue().length>0;if(this._bIsEditMode&&this._mEditProperties&&this.oDialogModel){e=o&&(t.getValue()!==this._mEditProperties.title||this.oDialogModel.getProperty("/selected")!==this._mEditProperties.priority.toString()||this._oContextComponentInstance.getSelectedContexts().role.length!==this._mEditProperties.roles.length||!this._oContextComponentInstance.getSelectedContexts().role.every(function(t){return this._mEditProperties.roles.indexOf(t)>-1}.bind(this)))}else{e=o}this.getToolbar().getControl("addAdaptationDialog--saveAdaptation-saveButton").setEnabled(e)}function R(){this._mEditProperties=undefined;this._oAddAdaptationDialog.removeContent(this._oContextComponent);this._oContextComponentInstance.destroy();this._oContextComponent.destroy()}return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/translation/Translation", ["sap/base/Log","sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/core/Lib","sap/ui/rta/Utils","sap/ui/model/json/JSONModel","sap/m/MessageBox","sap/m/MessageToast","sap/ui/fl/write/api/TranslationAPI","sap/ui/fl/Layer","sap/ui/core/util/File"],function(a,o,t,e,n,i,l,r,s,d,g,u){"use strict";function p(o){var t=o.userMessage||o.stack||o.message||o.status||o;var e=n.getResourceBundleFor("sap.ui.rta");a.error(t);var l=`${e.getText("MSG_LREP_TRANSFER_ERROR")}\n${e.getText("MSG_ERROR_REASON",[t])}`;r.error(l,{styleClass:i.getRtaStyleClassName()})}var c=o.extend("sap.ui.rta.toolbar.translation.Translation",{metadata:{properties:{toolbar:{type:"any"}}},constructor:function(...a){o.prototype.constructor.apply(this,a);this._oTranslationModel=new l(D())}});function h(a){var o=a.getSource().getModel("translation");var t=o.getProperty("/sourceLanguage");var e=o.getProperty("/targetLanguage");var n=`${t}_${e}_`+`TranslationXLIFF`;var i={layer:g.CUSTOMER,sourceLanguage:t,targetLanguage:e,selector:this.getToolbar().getRtaInformation().rootControl};var l=new Promise(function(a){if(o.getProperty("/translationRelevantDirtyChangesExist")){l=this.getToolbar().fireSave({callback:a})}else{a()}}.bind(this));l.then(d.getTexts.bind(undefined,i)).then(function(a){u.save(a,n,"xml","application/xml");this._oDownloadDialog.close()}.bind(this)).catch(function(a){p(a)})}c.prototype._createDownloadTranslationDialog=function(){return e.load({name:"sap.ui.rta.toolbar.translation.DownloadTranslationDialog",id:`${this.getToolbar().getId()}_download_translation_fragment`,controller:{onDownloadFile:h.bind(this),onCancelDownloadDialog:function(){this._oDownloadDialog.close()}.bind(this)}}).then(function(a){this._oDownloadDialog=a;this._oDownloadDialog.setModel(this._oTranslationModel,"translation");this.getToolbar().addDependent(this._oDownloadDialog);return a}.bind(this))};c.prototype._createUploadTranslationDialog=function(){var a=`${this.getToolbar().getId()}_upload_translation_fragment`;return e.load({name:"sap.ui.rta.toolbar.translation.UploadTranslationDialog",id:a,controller:{onCancelUploadDialog:function(){this._oUploadDialog.close()}.bind(this),formatUploadEnabled(){var o=t.getElementById(`${a}--fileUploader`);return o.checkFileReadable()},saveFiles:function(a){this._oTranslationModel.setProperty("/file",a.getParameter("files")[0])}.bind(this),handleUploadPress:f.bind(this,a)}}).then(function(a){this._oUploadDialog=a;this._oUploadDialog.setModel(this._oTranslationModel,"translation");this.getToolbar().addDependent(this._oUploadDialog);return this._oUploadDialog}.bind(this))};function f(a){var o=t.getElementById(`${a}--fileUploader`);o.checkFileReadable().then(function(){if(this._oTranslationModel.getProperty("/file")){var a={layer:g.CUSTOMER,payload:new FormData};a.payload.append("file",this._oTranslationModel.getProperty("/file"),o.getValue());return d.uploadTranslationTexts(a).then(function(){var a=n.getResourceBundleFor("sap.ui.rta");var o=a.getText("MSG_UPLOAD_TRANSLATION_SUCCESS");s.show(o,{styleClass:i.getRtaStyleClassName()});this._oUploadDialog.close()}.bind(this)).catch(function(a){p(a)}).finally(o.clear.bind(o))}}.bind(this))}function D(){return Object.assign({},{sourceLanguage:"",sourceLanguages:[],downloadChangedTexts:false,file:undefined})}c.prototype.openDownloadTranslationDialog=function(a){var o=d.hasTranslationRelevantDirtyChanges(a);this._oTranslationModel.setProperty("/translationRelevantDirtyChangesExist",o);return d.getSourceLanguages(a).then(function(a){if(a){this._oTranslationModel.setProperty("/sourceLanguages",a);this._oTranslationModel.setProperty("/sourceLanguage",a[0]||"")}}.bind(this)).then(function(){if(this._oDownloadDialogPromise){this._oTranslationModel.setProperty("/targetLanguage","")}else{this._oDownloadDialogPromise=this._createDownloadTranslationDialog()}return this._oDownloadDialogPromise}.bind(this)).then(function(a){return a.open()}).catch(function(a){p(a)})};c.prototype.openUploadTranslationDialog=function(){this._oUploadDialogPromise||=this._createUploadTranslationDialog();return this._oUploadDialogPromise.then(function(a){this.getToolbar().addDependent(a);return a.open()}.bind(this))};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/versioning/Versioning", ["sap/m/GroupHeaderListItem","sap/ui/base/ManagedObject","sap/ui/core/format/DateFormat","sap/ui/core/Fragment","sap/ui/core/library","sap/ui/fl/initial/api/Version","sap/ui/model/Sorter","sap/ui/rta/Utils"],function(e,t,i,o,r,s,n,a){"use strict";var{MessageType:l}=r;var u="sapUiRtaDraftVersionAccent";var c="sapUiRtaActiveVersionAccent";var g=t.extend("sap.ui.rta.toolbar.versioning.Versioning",{metadata:{properties:{toolbar:{type:"any"}}},constructor:function(...e){t.prototype.constructor.apply(this,e);this.oTextResources=this.getToolbar().getTextResources()}});function T(e){var t=e.getSource().getBindingContext("versions");var i=s.Number.Original;if(t){i=t.getProperty("version")}this.getToolbar().fireEvent("switchVersion",{version:i})}function h(e){return e.some(function(e){return e.type===s.Type.Active})}function f(e){return h(e)?l.None:l.Success}function p(e){return h(e)?this.oTextResources.getText("LBL_INACTIVE"):this.oTextResources.getText("LBL_ACTIVE")}function v(e){switch(e){case s.Type.Draft:return l.Warning;case s.Type.Active:return l.Success;default:return l.None}}function d(e){switch(e){case s.Type.Draft:return this.oTextResources.getText("TIT_DRAFT");case s.Type.Active:return this.oTextResources.getText("LBL_ACTIVE");default:return this.oTextResources.getText("LBL_INACTIVE")}}function V(e,t){if(t===s.Type.Draft){return this.oTextResources.getText("TIT_DRAFT")}return e||this.oTextResources.getText("TIT_VERSION_1")}function b(e,t){var o=t||e;if(!o){return""}if(o.indexOf("Z")===-1){o=`${o}Z`}return i.getInstance({format:"yMMMdjm"}).format(new Date(o))}function y(t){return new e({title:t.key?this.oTextResources.getText("TIT_VERSION_HISTORY_PUBLISHED"):this.oTextResources.getText("TIT_VERSION_HISTORY_UNPUBLISHED"),upperCase:false,visible:this.getToolbar().getModel("versions").getProperty("/publishVersionVisible")}).addStyleClass("sapUiRtaVersionHistoryGrouping").addStyleClass("sapUiRtaVersionHistory")}function m(e,t){switch(t){case s.Type.Draft:e.addStyleClass(u);e.removeStyleClass(c);break;case s.Type.Active:e.addStyleClass(c);e.removeStyleClass(u);break;default:e.removeStyleClass(c);e.removeStyleClass(u)}}g.prototype.formatVersionButtonText=function(e,t){var i="";var o="Active";e||=[];if(t===undefined||t===s.Number.Original){i=this.oTextResources.getText("TIT_ORIGINAL_APP");o=s.Type.Inactive;if(e.length===0||e.length===1&&e[0].type===s.Type.Draft){o=s.Type.Active}}else{var r=e.find(function(e){return e.version===t});if(r){o=r.type;if(t===s.Number.Draft){i=this.oTextResources.getText("TIT_DRAFT")}else{i=r.title||this.oTextResources.getText("TIT_VERSION_1")}}}m(this.getToolbar().getControl("versionButton"),o);return i};g.prototype.formatPublishVersionVisibility=function(e,t,i,o){return e&&t&&i!==s.Number.Draft&&o==="adaptation"};g.prototype.formatDiscardDraftVisible=function(e,t,i){return e===s.Number.Draft&&t&&i==="adaptation"};g.prototype.showVersionHistory=function(e){var t=e.getSource();this._oVersionHistoryDialogPromise||=o.load({name:"sap.ui.rta.toolbar.versioning.VersionHistory",id:`${this.getToolbar().getId()}_fragment--sapUiRta_versionHistoryDialog`,controller:{formatVersionTitle:V.bind(this),formatVersionTimeStamp:b,formatHighlight:v,formatHighlightText:d.bind(this),formatOriginalAppHighlight:f,formatOriginalAppHighlightText:p.bind(this),versionSelected:T.bind(this),getGroupHeaderFactory:y.bind(this)}}).then(function(e){this.getToolbar().addDependent(e);return e}.bind(this));return this._oVersionHistoryDialogPromise.then(function(e){if(!e.isOpen()){e.openBy(t);if(this.getToolbar().getModel("versions").getProperty("/publishVersionVisible")){var i=this.getToolbar().getControl("versionHistoryDialog--versionList");var o=new n({path:"isPublished",group:true});i.getBinding("items").sort(o)}}else{e.close()}}.bind(this))};g.prototype.openActivateVersionDialog=function(e){if(!this._oActivateVersionDialogPromise){this._oActivateVersionDialogPromise=o.load({name:"sap.ui.rta.toolbar.versioning.VersionTitleDialog",id:`${this.getToolbar().getId()}_fragment--sapUiRta_activateVersionDialog`,controller:{onConfirmVersioningDialog:function(){var e=this.getToolbar().getControl("activateVersionDialog--versionTitleInput").getValue();this.getToolbar().fireEvent("activate",{versionTitle:e});this._oActivateVersionDialog.close()}.bind(this),onCancelVersioningDialog:function(){this._oActivateVersionDialog.close()}.bind(this),onVersionTitleLiveChange:function(e){var t=e.getParameter("value");this.getToolbar().getControl("activateVersionDialog--confirmVersionTitleButton").setEnabled(!!t)}.bind(this)}}).then(function(e){this._oActivateVersionDialog=e;e.addStyleClass(a.getRtaStyleClassName());this.getToolbar().addDependent(this._oActivateVersionDialog)}.bind(this))}else{this.getToolbar().getControl("activateVersionDialog--versionTitleInput").setValue("");this.getToolbar().getControl("activateVersionDialog--confirmVersionTitleButton").setEnabled(false)}return this._oActivateVersionDialogPromise.then(function(){var t=this.oTextResources.getText("TIT_VERSION_TITLE_DIALOG");if(e!==s.Number.Draft){t=this.oTextResources.getText("TIT_REACTIVATE_VERSION_TITLE_DIALOG")}this._oActivateVersionDialog.setTitle(t);return this._oActivateVersionDialog.open()}.bind(this))};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/Animation", [],function(){"use strict";var n={};n.waitTransition=function(n,e){if(typeof e!=="function"){throw new Error("fnCallback should be a function")}return new Promise(function(i){n.addEventListener("transitionend",i,{once:true});var t;var r=function(n){t||=n;if(n!==t){e()}else{window.requestAnimationFrame(r)}};window.requestAnimationFrame(r)})};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/BindingsExtractor", ["sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/base/util/isPlainObject","sap/base/util/restricted/_uniqWith","sap/base/util/deepEqual"],function(t,e,n,a,i){"use strict";var r={};r.collectBindingPaths=function(e,a,i){var g={bindingPaths:[],bindingContextPaths:[]};var o=e.sParentAggregationName;var d=e.getParent();var l=r.getBindings({element:e,model:a,relevantContainerElement:i,parent:d});if(d){var s=d.getMetadata().getAggregation();if(s){var u=t.getAggregation(d,o).indexOf(e);var f=s.name;var v=d.getBindingInfo(f);var p=v&&v.template;if(p){var c=p.getMetadata().getAggregation();if(c){var m=c.name;var P=t.getAggregation(p,m)[u];l=l.concat(r.getBindings({model:a,element:P,template:true,relevantContainerElement:i,parent:d}))}}}}for(var h=0,B=l.length;h<B;h++){if(l[h].getPath){var C=l[h].getPath();if(C&&g.bindingPaths.indexOf(C)===-1){g.bindingPaths.push(C)}}if(l[h].getContext&&l[h].getContext()&&l[h].getContext().getPath){var b=l[h].getContext().getPath();if(b&&g.bindingContextPaths.indexOf(b)===-1){g.bindingContextPaths.push(b)}}if(n(l[h])){var M=l[h].parts[0]&&l[h].parts[0].path;if(M&&g.bindingPaths.indexOf(M)===-1){g.bindingPaths.push(M)}}}return g};function g(t,n){if(n&&t!==n){var a=e.getOverlay(t);var i=a&&(a.getRelevantContainer()||a.getElement());return i?i.getId()===n.getId():true}return true}r.getBindings=function(t){var e=t.element;var n=t.model;var d=t.parent;var s=t.aggregationName;var u=t.relevantContainerElement;var f=[];if(g(e,u)){f=t.template?l(e,d,n):r.getBindingsFromProperties(e,n)}var v=s?[s]:Object.keys(e.getMetadata().getAllAggregations());v.forEach(function(a){f=f.concat(o(e,n,t.template,a,u))});return a(f,i)};function o(e,n,a,i,o){var d=[];var s=[];var u;var f=a;var v=e.getModel();var p=e.getBindingInfo(i);u=p&&p.template;if(u&&v&&v!==n){return[]}if(u){f=true;s=[u]}else{s=t.getAggregation(e,i)}s.forEach(function(t){if(t.getMetadata){if(g(e,o)){d=d.concat(f?l(t,e,n):r.getBindingsFromProperties(t,n))}d=d.concat(r.getBindings({element:t,model:n,template:f,relevantContainerElement:o,parent:e}))}});return d}r.filterAndFlattenBindings=function(t,e){var n=[];var a=t.getMetadata().getName();if(a==="sap.ui.model.CompositeBinding"){t.getBindings().forEach(function(t){n=n.concat(r.filterAndFlattenBindings(t,e))})}else if((a==="sap.ui.model.odata.ODataPropertyBinding"||a==="sap.ui.model.odata.v2.ODataPropertyBinding"||a==="sap.ui.model.odata.v4.ODataPropertyBinding"||a==="sap.ui.model.json.JSONPropertyBinding"||a==="sap.ui.model.json.XMLPropertyBinding"||a==="sap.ui.model.resource.ResourcePropertyBinding")&&t.getModel()===e&&t.isRelative()&&typeof t.getPath==="function"&&t.getPath()){n.push(t)}return n};function d(t){var e=[];var n=t.parts;n.forEach(function(t){e.push({parts:[t]})});return e}r.getBindingsFromProperties=function(t,e){var n=Object.keys(t.getMetadata().getAllProperties());return n.filter(t.getBinding.bind(t)).reduce(function(n,a){return n.concat(r.filterAndFlattenBindings(t.getBinding(a),e))},[])};function l(t,e,n){var a=Object.keys(t.getMetadata().getAllProperties());var i;return a.filter(function(a){var r=t.mBindingInfos[a];var g=r&&r.parts[0]&&r.parts[0].model;i=n===e.getModel(g);if(!g){var o=e.getDefaultModel?e.getDefaultModel():null;var d=t.getDefaultModel?t.getDefaultModel():null;i=o===d}else{i=n===e.getModel(g)}return r&&i}).reduce(function(e,n){return e.concat(d(t.mBindingInfos[n]))},[])}r.getBindingContextPath=function(t){if(t.getBindingContext()&&t.getBindingContext().getPath){return t.getBindingContext().getPath()}return undefined};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/PluginManager", ["sap/base/util/isEmptyObject","sap/base/util/values","sap/ui/base/ManagedObject","sap/ui/dt/plugin/ContextMenu","sap/ui/dt/plugin/TabHandling","sap/ui/dt/plugin/ToolHooks","sap/ui/fl/Layer","sap/ui/fl/registry/Settings","sap/ui/rta/command/CommandFactory","sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/rta/plugin/additionalElements/AddElementsDialog","sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer","sap/ui/rta/plugin/iframe/AddIFrame","sap/ui/rta/plugin/Combine","sap/ui/rta/plugin/CompVariant","sap/ui/rta/plugin/ControlVariant","sap/ui/rta/plugin/CreateContainer","sap/ui/rta/plugin/CutPaste","sap/ui/rta/plugin/DragDrop","sap/ui/rta/plugin/Remove","sap/ui/rta/plugin/Rename","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/Selection","sap/ui/rta/plugin/Settings","sap/ui/rta/plugin/Split","sap/ui/rta/plugin/Stretch","sap/ui/rta/plugin/LocalReset","sap/ui/rta/plugin/Resize"],function(t,a,i,e,n,s,o,l,u,r,m,g,d,p,c,h,f,y,P,_,C,F,D,b,E,v,w,M){"use strict";var S=i.extend("sap.ui.rta.util.PluginManager",{metadata:{properties:{plugins:{type:"any",defaultValue:{}}}}});S.prototype.init=function(){this.iEditableOverlaysCount=0};S.prototype.getEditableOverlaysCount=function(){return this.iEditableOverlaysCount};S.prototype.getDefaultPlugins=function(t){if(!this._mDefaultPlugins){this._oCommandFactory=new u({flexSettings:t});this._mDefaultPlugins={};this._mDefaultPlugins.selection=new D({commandFactory:this._oCommandFactory,multiSelectionRequiredPlugins:[p.getMetadata().getName(),_.getMetadata().getName()],elementEditableChange:this.onElementEditableChange.bind(this)});this._oRTAElementMover=new F({commandFactory:this._oCommandFactory});this._mDefaultPlugins.dragDrop=new P({elementMover:this._oRTAElementMover,commandFactory:this._oCommandFactory,dragStarted:this.handleStopCutPaste.bind(this)});this._mDefaultPlugins.rename=new C({commandFactory:this._oCommandFactory,editable:this.handleStopCutPaste.bind(this)});this._mDefaultPlugins.additionalElements=new r({commandFactory:this._oCommandFactory});this._mDefaultPlugins.createContainer=new f({commandFactory:this._oCommandFactory});this._mDefaultPlugins.remove=new _({commandFactory:this._oCommandFactory});this._mDefaultPlugins.cutPaste=new y({elementMover:this._oRTAElementMover,commandFactory:this._oCommandFactory});this._mDefaultPlugins.settings=new b({commandFactory:this._oCommandFactory});this._mDefaultPlugins.combine=new p({commandFactory:this._oCommandFactory});this._mDefaultPlugins.split=new E({commandFactory:this._oCommandFactory});this._mDefaultPlugins.resize=new M({commandFactory:this._oCommandFactory});this._mDefaultPlugins.contextMenu=new e;this._mDefaultPlugins.tabHandling=new n;this._mDefaultPlugins.stretch=new v;var a=l.getInstanceOrUndef();if(a&&a.isVariantAdaptationEnabled()){this._mDefaultPlugins.compVariant=new c({commandFactory:this._oCommandFactory})}this._mDefaultPlugins.controlVariant=new h({commandFactory:this._oCommandFactory});this._mDefaultPlugins.addIFrame=new d({commandFactory:this._oCommandFactory});this._mDefaultPlugins.toolHooks=new s;if(t.layer===o.CUSTOMER&&a&&a.isLocalResetEnabled()){this._mDefaultPlugins.localReset=new w({commandFactory:this._oCommandFactory})}}return Object.assign({},this._mDefaultPlugins)};S.prototype.preparePlugins=function(a,i,e){if(t(this.getPlugins())){this.setPlugins(this.getDefaultPlugins(a))}else{this._destroyDefaultPlugins(this.getPlugins())}Object.keys(this.getPlugins()).forEach(function(t){if(this.getPlugin(t).attachElementModified){this.getPlugin(t).attachElementModified(i)}}.bind(this));this.provideCommandStack("settings",e)};S.prototype.getPluginList=function(){return a(this.getPlugins())};S.prototype.getPlugin=function(t){return this.getPlugins()[t]};S.prototype.provideCommandStack=function(t,a){if(this.getPlugin(t)){this.getPlugin(t).setCommandStack(a)}};S.prototype.onElementEditableChange=function(t){var a=t.getParameter("editable");if(a){this.iEditableOverlaysCount+=1}else{this.iEditableOverlaysCount-=1}};S.prototype.handleStopCutPaste=function(){var t=this.getPlugin("cutPaste");if(t){t.stopCutAndPaste()}};S.prototype._destroyDefaultPlugins=function(t){for(var a in this._mDefaultPlugins){var i=this._mDefaultPlugins[a];if(i&&!i.bIsDestroyed){if(!t||t[a]!==i){i.destroy()}}}};return S});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/PopupManager", ["sap/ui/base/ManagedObject","sap/m/InstanceManager","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/fl/Utils","sap/ui/core/Component","sap/ui/core/ComponentContainer","sap/ui/core/Element","sap/ui/dt/util/ZIndexManager","sap/m/Dialog","sap/m/Popover","sap/base/util/restricted/_curry"],function(t,e,o,n,i,a,p,r,s,u,l,d){"use strict";var c={add:"_activateFocusHandle",remove:"_deactivateFocusHandle"};var f=t.extend("sap.ui.rta.util.PopupManager",{metadata:{properties:{rta:"any"},associations:{autoCloseAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"autoCloseArea"}},events:{open:{parameters:{oControl:{type:"sap.ui.core.Control"}}},close:{parameters:{oControl:{type:"sap.ui.core.Control"}}}},library:"sap.ui.rta"}});f.prototype.init=function(){this._oModalState=new Map;this._aPopupFilters=[this._isSupportedPopup.bind(this),this._isPopupAdaptable.bind(this)];this._aPopupFilters.forEach(function(t){s.addPopupFilter(t)})};f.prototype._overrideInstanceFunctions=function(){this._applyPopupAttributes({method:this._createPopupOverlays,setModal:true,bringToTop:true});this._overrideAddPopupInstance();this._overrideRemovePopupInstance()};f.prototype.getCategorizedOpenPopups=function(){var t;var o;t=e.getOpenDialogs();var n=this._getValidatedPopups(t);o=e.getOpenPopovers();var i=this._getValidatedPopups(o);var a={aDialogs:n.relevant,aPopovers:i.relevant,aAllSupportedPopups:n.allSupported.concat(i.allSupported)};return a};f.prototype._getValidatedPopups=function(t){var e=[];t=t.filter(function(t){if(this._isPopupAdaptable(t)){e.push(t);return true}else if(t instanceof u){e.push(t)}return undefined}.bind(this));return{relevant:t,allSupported:e}};f.prototype._isComponentInsidePopup=function(t){return Array.isArray(t.getContent())?t.getContent().some(function(t){if(t instanceof p){return this.oRtaRootAppComponent===this._getAppComponentForControl(a.getComponentById(t.getComponent()))}return undefined}.bind(this)):false};f.prototype._isSupportedPopup=function(t){return t instanceof u||t instanceof l};f.prototype.setRta=function(t){if(t&&t._oDesignTime){this.setProperty("rta",t);var e=t.getRootControlInstance();this.oRtaRootAppComponent=this._getAppComponentForControl(e);var o=this._onModeChange.bind(this);t.attachModeChanged(o);this._overrideInstanceFunctions()}};f.prototype._adjustRootOverlayVisibility=function(t,e){this.getRta()._oDesignTime.getRootElements().forEach(function(o){if(o.getId()!==e.getId()){n.getOverlay(o).setVisible(t)}})};f.prototype._onModeChange=function(t){var e=t.getParameters().mode;var o=function(t,e){if(t==="navigation"){e.oPopup[this._getFocusEventName("add")]()}else{e.oPopup[this._getFocusEventName("remove")]();if(this.getRta().getShowToolbars()){this.getRta().getToolbar().bringToFront()}}};if(e==="navigation"){this._applyPatchesToOpenPopups(d(o)(e))}else{this._removePatchesToOpenPopups(d(o)(e))}};f.prototype._applyPatchesToOpenPopups=function(t){this._applyPopupAttributes({method:t,focus:true,setModal:false})};f.prototype._removePatchesToOpenPopups=function(t){this._applyPopupAttributes({method:t,setModal:true})};f.prototype._getFocusEventName=function(t){return c[t]};f.prototype._overrideAddPopupInstance=function(){this._fnOriginalAddDialogInstance=e.addDialogInstance;e.addDialogInstance=this._overrideAddFunctions(this._fnOriginalAddDialogInstance);this._fnOriginalAddPopoverInstance=e.addPopoverInstance;e.addPopoverInstance=this._overrideAddFunctions(this._fnOriginalAddPopoverInstance)};f.prototype._overrideAddFunctions=function(t){return function(...o){const[n]=o;var i=t.apply(e,o);if(this._isSupportedPopup(n)){if(this._isPopupAdaptable(n)&&this.getRta()._oDesignTime){n.attachEventOnce("afterOpen",this._createPopupOverlays,this);n.attachEventOnce("afterOpen",this.fireOpen,this);this._setModal(true,n)}else if(!(n instanceof l)){this._setModal(true,n)}}return i}.bind(this)};f.prototype._setModal=function(t,e){var o=this._oModalState.get(e.oPopup);if(typeof o!=="boolean"&&t&&this.getRta().getMode()!=="navigation"){this._oModalState.set(e.oPopup,e.oPopup.getModal());if(this._isPopupAdaptable(e)){this._adjustRootOverlayVisibility(false,e)}e.oPopup.setModal(true)}else if(typeof o==="boolean"&&t===false){e.oPopup.setModal(o);if(this._isPopupAdaptable(e)){this._adjustRootOverlayVisibility(true,e)}this._oModalState.delete(e.oPopup)}};f.prototype._applyPopupAttributes=function(t){var e=this.getCategorizedOpenPopups();["aDialogs","aPopovers"].forEach(function(o){if(e[o].length>0){if(t.focus){if(e[o][0].oPopup.oContent){e[o][0].oPopup.oContent.focus()}}e[o].forEach(function(e){t.method.call(this,e)}.bind(this))}}.bind(this));e.aAllSupportedPopups.forEach(this._setModal.bind(this,t.setModal))};f.prototype._applyPopupPatch=function(t){var e=o.getOverlayContainer();var{oPopup:n}=t;var i=[n.oContent.getDomRef(),e.get(0)].concat(this.getAutoCloseAreas());if(this.getRta().getShowToolbars()){var a=this.getRta().getToolbar();var p=!!a.getVisible();if(!p){this.getRta().attachEventOnce("start",function(){i.push(a.getDomRef())})}else{i.push(a.getDomRef())}}n.setExtraContent(i);this.fnOriginalPopupOnAfterRendering||=n.onAfterRendering;n.onAfterRendering=function(...t){var e=this.fnOriginalPopupOnAfterRendering.apply(n,t);n[this._getFocusEventName("remove")]();return e}.bind(this);if(this.getRta().getMode()==="adaptation"){n[this._getFocusEventName("remove")]()}};f.prototype._overrideRemovePopupInstance=function(){this._fnOriginalRemoveDialogInstance=e.removeDialogInstance;e.removeDialogInstance=this._overrideRemoveFunctions(this._fnOriginalRemoveDialogInstance);this._fnOriginalRemovePopoverInstance=e.removePopoverInstance;e.removePopoverInstance=this._overrideRemoveFunctions(this._fnOriginalRemovePopoverInstance)};f.prototype._overrideRemoveFunctions=function(t){return function(...o){const[n]=o;var i=t.apply(e,o);if(this._isSupportedPopup(n)){if(this._isPopupAdaptable(n)&&this.getRta()._oDesignTime){this.getRta()._oDesignTime.removeRootElement(n)}this._oModalState.delete(n.oPopup);this.fireClose(n)}return i}.bind(this)};f.prototype._getAppComponentForControl=function(t){var e;var o;if(t instanceof a){e=t}else{e=this._getComponentForControl(t)}if(e){o=i.getAppComponentForControl(e)}return o};f.prototype._getComponentForControl=function(t){var e;var o;var n;if(t){e=a.getOwnerComponentFor(t);if(!e&&typeof t.getParent==="function"&&t.getParent()instanceof r){n=t.getParent()}else if(e){n=e}if(n){o=this._getComponentForControl(n)}}return o||e};f.prototype._createPopupOverlays=function(t){if(!t){return}var e=t instanceof r?t:t.getSource();if(this.getRta()._oDesignTime.getRootElements().indexOf(e.getId())===-1&&!this._isComponentInsidePopup(e)){this.getRta()._oDesignTime.addRootElement(e)}e.detachAfterOpen(this._createPopupOverlays,this);this._applyPopupPatch(e)};f.prototype._restoreInstanceFunctions=function(){if(this._fnOriginalAddDialogInstance){e.addDialogInstance=this._fnOriginalAddDialogInstance}if(this._fnOriginalRemoveDialogInstance){e.removeDialogInstance=this._fnOriginalRemoveDialogInstance}if(this._fnOriginalAddPopoverInstance){e.addPopoverInstance=this._fnOriginalAddPopoverInstance}if(this._fnOriginalRemovePopoverInstance){e.removePopoverInstance=this._fnOriginalRemovePopoverInstance}this._applyPatchesToOpenPopups(this._removePopupPatch)};f.prototype._removePopupPatch=function(t){var{oPopup:e}=t;e[this._getFocusEventName("add")]();if(this.fnOriginalPopupOnAfterRendering){e.onAfterRendering=this.fnOriginalPopupOnAfterRendering}};function h(t){if(!t||t instanceof a){return true}if(!t.isPopupAdaptationAllowed||t.isPopupAdaptationAllowed()){return h(t.getParent())}return false}f.prototype._isPopupAdaptable=function(t){if(t.isPopupAdaptationAllowed&&!t.isPopupAdaptationAllowed()){return false}var e=this._getAppComponentForControl(t);if(e&&this.oRtaRootAppComponent===e||this._isComponentInsidePopup(t)){return h(t.getParent())}return false};f.prototype.exit=function(){this._restoreInstanceFunctions();delete this._oModalState;this._aPopupFilters.forEach(function(t){s.removePopupFilter(t)})};return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/ReloadManager", ["sap/base/util/merge","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/write/api/ReloadInfoAPI","sap/ui/fl/write/api/VersionsAPI","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/rta/Utils"],function(e,a,t,r,n,i,o){"use strict";var s={};var l={};var A={NOT_NEEDED:"NO_RELOAD",VIA_HASH:"CROSS_APP_NAVIGATION",RELOAD_PAGE:"HARD_RELOAD"};function u(e){return{target:{semanticObject:e.semanticObject,action:e.action,context:e.contextRaw},params:e.params,appSpecificRoute:e.appSpecificRoute,writeHistory:false}}function _(e){var a;var t=e.layer===n.CUSTOMER;if(e.hasHigherLayerChanges&&e.isDraftAvailable){a=t?"MSG_VIEWS_OR_PERSONALIZATION_AND_DRAFT_EXISTS":"MSG_HIGHER_LAYER_CHANGES_AND_DRAFT_EXISTS"}else if(e.hasHigherLayerChanges&&e.allContexts){a="MSG_RESTRICTED_CONTEXT_EXIST_AND_PERSONALIZATION"}else if(e.hasHigherLayerChanges){a=t?"MSG_PERSONALIZATION_OR_PUBLIC_VIEWS_EXISTS":"MSG_HIGHER_LAYER_CHANGES_EXIST"}else if(e.isDraftAvailable){a="MSG_DRAFT_EXISTS"}else if(e.allContexts){a="MSG_RESTRICTED_CONTEXT_EXIST"}return a}function f(e){var a=e.layer===n.CUSTOMER;if(e.hasHigherLayerChanges){if(!a){return"MSG_RELOAD_WITH_ALL_CHANGES"}if(e.isDraftAvailable){return"MSG_RELOAD_WITH_VIEWS_PERSONALIZATION_AND_WITHOUT_DRAFT"}if(e.allContexts){return"MSG_RELOAD_WITH_PERSONALIZATION_AND_RESTRICTED_CONTEXT"}if(e.switchEndUserAdaptation){return"MSG_RELOAD_WITH_PERSONALIZATION_AND_CONTEXT_BASED_ADAPTATION"}return"MSG_RELOAD_WITH_PERSONALIZATION_AND_VIEWS"}if(e.initialDraftGotActivated){return"MSG_RELOAD_ACTIVATED_DRAFT"}if(e.isDraftAvailable){return"MSG_RELOAD_WITHOUT_DRAFT"}if(e.changesNeedReload){return"MSG_RELOAD_NEEDED"}if(e.allContexts){return"MSG_RELOAD_WITHOUT_ALL_CONTEXT"}if(e.switchEndUserAdaptation){return"MSG_RELOAD_OTHER_CONTEXT_BASED_ADAPTATION"}return undefined}function E(e){var a=f(e);if(a){return o.showMessageBox("information",a,{titleKey:"HEADER_RELOAD_NEEDED"})}return Promise.resolve()}function d(e,a,t){return Promise.resolve().then(function(){if(l.CrossApplicationNavigation&&a){if(e.isDraftAvailable){return r.loadDraftForApplication({control:e.selector,layer:e.layer,allContexts:e.allContexts,adaptationId:e.adaptationId})}return r.loadVersionForApplication({control:e.selector,layer:e.layer,allContexts:e.allContexts,adaptationId:e.adaptationId})}return undefined}).then(function(){var a=_(e);return t?undefined:o.showMessageBox("information",a)}).then(function(){s.enableAutomaticStart(e.layer,e.selector);e.onStart=true;return s.triggerReload(e)}).then(function(){return true})}function c(e){e.parameters=document.location.search;if(e.onStart){t.handleParametersOnStart(e,"standalone")}else{t.handleUrlParameters(e,"standalone")}if(document.location.search===e.parameters){s.reloadPage()}else{s.setUriParameters(e.parameters)}}function R(e){e.URLParsingService=l.URLParsing;e.parsedHash=i.getParsedURLHash(l.URLParsing);e.parameters=e.parsedHash.params;var a=e.onStart?t.handleParametersOnStart(e,"flp"):t.handleUrlParameters(e,"flp");if(a){l.CrossApplicationNavigation.toExternal(u(e.parsedHash))}else{l.AppLifeCycle.reloadCurrentApp()}if(e.triggerHardReload){s.reloadPage()}}s.setUShellServices=function(e){l=e};s.enableAutomaticStart=function(e,t){var r=a.getFlexReference({element:t});var n=r||true;window.sessionStorage.setItem(`sap.ui.rta.restart.${e}`,n)};s.disableAutomaticStart=function(e){window.sessionStorage.removeItem(`sap.ui.rta.restart.${e}`)};s.needsAutomaticStart=function(e){return!!window.sessionStorage.getItem(`sap.ui.rta.restart.${e}`)};s.triggerReload=function(e){if(i.getUshellContainer()){R(e)}else{c(e)}};s.reloadPage=function(){window.location.reload()};s.setUriParameters=function(e){document.location.search=e};s.handleReloadOnStart=function(a){e(a,{hasHigherLayerChanges:false,isDraftAvailable:false,ignoreMaxLayerParameter:false,includeCtrlVariants:true,URLParsingService:l.URLParsing});return t.getReloadReasonsForStart(a).then(function(e){if(e.hasHigherLayerChanges||e.isDraftAvailable||e.allContexts||e.switchAdaptation){return d(e,a.versioningEnabled,a.developerMode)}return undefined})};s.checkReloadOnExit=function(e){return e.changesNeedReloadPromise.then(function(a){e.changesNeedReload=a;e.URLParsingService=l.URLParsing;var r=t.getReloadMethod(e);return E(r).then(function(){r.triggerHardReload=r.reloadMethod===A.RELOAD_PAGE;return r})})};s.handleUrlParametersOnExit=function(e){if(e.layer!==n.USER&&e.reloadMethod!==A.NOT_NEEDED){e.removeVersionParameter=true;s.triggerReload(e)}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/ServiceEventBus", ["sap/ui/core/EventBus"],function(e){"use strict";var t=e.extend("sap.ui.rta.util.ServiceEventBus");t.prototype._callListener=function(e,t,n,i,r){e.call(t,r)};t.prototype.getChannel=function(e){return this._mChannels[e]};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/adaptationStarter", ["sap/base/Log","sap/ui/core/Control","sap/ui/core/Lib","sap/ui/core/UIComponent","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/rta/util/showMessageBox","sap/ui/rta/RuntimeAuthoring"],function(t,e,r,n,o,a,i,s,u,l){"use strict";function f(t){if(i.CUSTOMER===t){return o.isKeyUser().then(function(t){if(!t){var e=r.getResourceBundleFor("sap.ui.rta");var n=new Error(e.getText("MSG_NO_KEY_USER_RIGHTS_ERROR_MESSAGE"));n.reason="isKeyUser";throw n}})}return Promise.resolve()}function T(t){var e=new URLSearchParams(window.location.search).get("fiori-tools-rta-mode");if(!e||e==="false"){var r=t.getManifest()||{};var n=r["sap.ui5"]&&r["sap.ui5"].flexEnabled;if(n===false){var o=Error("This app is not enabled for key user adaptation");o.reason="flexEnabled";throw o}}}function c(t){const e=t.getComponentData?.();if(e?.startupParameters&&Array.isArray(e.startupParameters["sap-app-id"])){const e=t.getManifest();const n=e["sap.app"]?.ach;const o=r.getResourceBundleFor("sap.ui.rta");const a=o.getText("MSG_PSEUDO_APP_VARIANT_ERROR_MESSAGE",[n]);const i=Error(a);i.reason="pseudoAppVariant";throw i}}function p(o,p,A,_,E){var g;return Promise.resolve().then(function(){if(!(o.rootControl instanceof e)&&!(o.rootControl instanceof n)){var t=Error("An invalid root control was passed");t.reason="rootControl";throw t}o.rootControl=s.getAppComponentForControl(o.rootControl)}).then(f.bind(undefined,o.flexSettings.layer)).then(function(){return T(o.rootControl)}).then(c.bind(undefined,o.rootControl)).then(function(){g=new l(o);if(A){g.attachEvent("start",A)}if(_){g.attachEvent("failed",_)}var t=E||function(){g.destroy()};g.attachEvent("stop",t);if(p){return p(g)}}).then(function(){return g.start()}).then(function(){if(o.flexSettings.layer==="CUSTOMER"){var t={oComponent:o.rootControl,selector:o.rootControl,invalidateCache:false,includeVariants:true,includeCtrlVariants:true,currentLayer:i.CUSTOMER};a.getChangesWarning(t).then(function(t){if(t.showWarning){var e=r.getResourceBundleFor("sap.ui.rta");var n=t.warningType==="mixedChangesWarning"?{text:"MSG_ADAPTATION_STARTER_MIXED_CHANGES_WARNING",title:"TIT_ADAPTATION_STARTER_MIXED_CHANGES_TITLE"}:{text:"MSG_ADAPTATION_STARTER_NO_CHANGES_IN_P_WARNING",title:"TIT_ADAPTATION_STARTER_NO_CHANGES_IN_P_TITLE"};u(e.getText(n.text),{title:e.getText(n.title)},"warning")}})}return g}).catch(function(e){if(e!=="Reload triggered"&&!(s.getUshellContainer()&&e.reason==="flexEnabled")){var n=r.getResourceBundleFor("sap.ui.rta");if(e.reason==="pseudoAppVariant"){u(e.message,{title:n.getText("MSG_ADAPTATION_COULD_NOT_START")},"error")}else{u(n.getText("MSG_GENERIC_ERROR_MESSAGE",[e.message]),{title:n.getText("MSG_ADAPTATION_COULD_NOT_START")},"error")}t.error("UI Adaptation could not be started",e.message)}throw e})}return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/ChangeCategories", ["sap/ui/fl/changeHandler/common/ChangeCategories"],function(e){"use strict";var a={};a.ALL="all";var n={};n[e.ADD]=["createContainer","addDelegateProperty","reveal","addIFrame"];n[e.MOVE]=["move"];n[e.RENAME]=["rename"];n[e.COMBINESPLIT]=["combine","split"];n[e.REMOVE]=["remove"];n[e.OTHER]=[];var o={};o[a.ALL]="sap-icon://show";o[e.ADD]="sap-icon://add";o[e.MOVE]="sap-icon://move";o[e.RENAME]="sap-icon://edit";o[e.COMBINESPLIT]="sap-icon://combine";o[e.REMOVE]="sap-icon://less";o[e.OTHER]="sap-icon://key-user-settings";a.getCategories=function(){return n};a.getIconForCategory=function(e){return o[e]};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/ChangeIndicator", ["sap/ui/core/format/DateFormat","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/core/Lib","sap/ui/core/StaticArea","sap/ui/events/KeyCodes","sap/ui/fl/util/resolveBinding","sap/ui/fl/Utils","sap/ui/model/json/JSONModel","sap/ui/rta/util/changeVisualization/commands/getCommandVisualization","sap/ui/rta/util/changeVisualization/ChangeCategories","sap/ui/rta/util/changeVisualization/ChangeVisualizationUtils"],function(e,t,i,o,a,n,s,r,l,p,g,h,c){"use strict";var d=t.extend("sap.ui.rta.util.changeVisualization.ChangeIndicator",{metadata:{library:"sap.ui.rta",properties:{changes:{type:"array",defaultValue:[]},posX:{type:"int"},posY:{type:"int"},overlayId:{type:"string"},selectorId:{type:"string"}},aggregations:{_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},events:{selectChange:{parameters:{changeId:{type:"string"}}},keyPress:{parameters:{originalEvent:{type:"object"}}},detailPopoverOpened:{}}},renderer:{apiVersion:2,render(e,t){e.openStart("div",t);e.class("sapUiRtaChangeIndicator");e.class("sapUiRtaChangeIndicatorChange");var i=t.getTooltip_AsString();if(i){e.attr("title",i)}if(t.getChanges().length>4){e.class("sapUiRtaChangeIndicatorColorDark")}else if(t.getChanges().length>1){e.class("sapUiRtaChangeIndicatorColorMedium")}else{e.class("sapUiRtaChangeIndicatorColorLight")}e.openEnd();if(i){e.openStart("span",`${t.getId()}-tooltip`);e.class("sapUiInvisibleText");e.openEnd();e.text(i);e.close("span")}e.close("div")}},constructor:function(...e){this._oDetailModel=new p;this._oDetailModel.setDefaultBindingMode("OneWay");this._fnHoverTrue=this._setHoverStyleClasses.bind(this,true);this._fnHoverFalse=this._setHoverStyleClasses.bind(this,false);t.prototype.constructor.apply(this,e);this._bEventAttachedToElement=false}});function u(e,t){e[t]("click",this._onSelect,this);e[t]("tap",this._onSelect,this);e[t]("keydown",this._onKeyDown,this);e[t]("mouseover",this._fnHoverTrue);e[t]("focusin",this._fnHoverTrue)}function v(e,t){e[t]("click",this._onSelect,this);e[t]("tap",this._onSelect,this);e[t]("keydown",this._onKeyDown,this)}function f(e){var t=e.getDomRef();var o=i.getElementById(e.getOverlayId()).getDomRef().offsetHeight;var a=t.offsetHeight;if(o<a*5){e.addStyleClass("sapUiRtaChangeIndicatorVerticallyCentered")}else{e.removeStyleClass("sapUiRtaChangeIndicatorVerticallyCentered")}}function y(e,t,o){var a=i.getElementById(e.affectedElementId);var n=Object.keys(e.descriptionPayload||{}).reduce(function(t,i){var o=e.descriptionPayload[i];var n=l.isBinding(o);var s=n?r(o,a):o;t[i]=s;return t},{});var s={appComponent:l.getAppComponentForControl(a)};var p=i.getElementById(o);var h=p.getDesignTimeMetadata().getLabel(a);var d=g(e);var u=d&&d.getDescription(n,h,s)||{};var v=e.commandName;var f;var y;if(v==="settings"&&n.description){u.descriptionText=n.description;u.descriptionTooltip=n.descriptionTooltip}else if(e.changeCategory==="other"){v="other"}if(u.descriptionText){f=u.descriptionText;y=u.descriptionTooltip||""}else{var I=c.shortenString(h);var _=`TXT_CHANGEVISUALIZATION_CHANGE_${v.toUpperCase()}`;f=t.getText(_,[I]);y=t.getText(_,[h])}y=f.length<y.length?y:null;var C=u&&u.buttonText;var T=t.getText(`TXT_CHANGEVISUALIZATION_OVERVIEW_${e.changeCategory.toUpperCase()}`);return{description:f,tooltip:y,buttonText:C,iconTooltip:T}}function I(t,i){var o=t.change.getCreation();var a=new Date(o);var n=i.getText("TXT_CHANGEVISUALIZATION_CREATED_IN_SESSION_DATE");return{fullDate:o?e.getDateTimeInstance().format(a):n,relativeDate:o?e.getDateTimeInstance({relative:"true"}).format(a):n}}function _(e,t){var i=a.getResourceBundleFor("sap.ui.rta");var o=y(t,i,e);var n=I(t,i);return{id:t.id,change:t,description:o.description,descriptionTooltip:o.tooltip,fullDate:n.fullDate,relativeDate:n.relativeDate,detailButtonText:o.buttonText,icon:h.getIconForCategory(t.changeCategory),iconTooltip:o.iconTooltip}}d.prototype.init=function(){this._iOldTabIndex=0;v.call(this,this,"attachBrowserEvent")};d.prototype.setVisible=function(...e){const[o]=e;t.prototype.setVisible.apply(this,e);var a=i.getElementById(this.getOverlayId());if(a){if(o&&!this._bEventAttachedToElement){u.call(this,a,"attachBrowserEvent");this._bEventAttachedToElement=true}if(!o){u.call(this,a,"detachBrowserEvent");this._bEventAttachedToElement=false;if(this.getAggregation("_popover")){this.getAggregation("_popover").destroy()}}}return this};d.prototype.focus=function(...e){if(this.getDomRef()){t.prototype.focus.apply(this,e);this._bScheduledForFocus=false;return}this._bScheduledForFocus=true};d.prototype.setOverlayId=function(e){var t=this.getDomRef();if(t){t.parentNode.removeChild(t)}this.placeAt(n.getDomRef());this.setProperty("overlayId",e);return this};d.prototype.onAfterRendering=function(){var e=i.getElementById(this.getOverlayId());if(e){e.getDomRef().appendChild(this.getDomRef());f(this)}this.getDomRef().tabIndex=this._iOldTabIndex;if(this._bScheduledForFocus){this.focus();this._setHoverStyleClasses(true)}};d.prototype.exit=function(){var e=this.getDomRef();var t=i.getElementById(this.getOverlayId());if(e){e.parentNode.removeChild(e)}if(t){if(this.getAggregation("_popover")){this.getAggregation("_popover").destroy()}u.call(this,t,"detachBrowserEvent")}v.call(this,this,"detachBrowserEvent")};d.prototype.setChanges=function(e){var t=a.getResourceBundleFor("sap.ui.rta");this.setProperty("changes",e);this._oDetailModel.setData((e||[]).reverse().map(_.bind(this,this.getOverlayId())));if(e&&e.length===1){this.setTooltip(t.getText("TXT_CHANGEVISUALIZATION_INDICATOR_TOOLTIP_SING"))}else if(e){this.setTooltip(t.getText("TXT_CHANGEVISUALIZATION_INDICATOR_TOOLTIP_PLUR",[e.length]))}};d.prototype._onSelect=function(e){this.focus();e.stopPropagation();this._toggleDetailPopover()};d.prototype._onKeyDown=function(e){if(e.keyCode===s.ENTER){this._onSelect(e)}this.fireKeyPress({originalEvent:e})};d.prototype.onDetailPopoverOpened=function(e){e.preventDefault();this._setHoverStyleClasses(true)};d.prototype.onIndicatorBrowserInteraction=function(e,t){t.stopPropagation();t.preventDefault();this._setHoverStyleClasses(e)};d.prototype._setHoverStyleClasses=function(e){var t=i.getElementById(this.getOverlayId());if(t.getMetadata().getName()!=="sap.ui.dt.ElementOverlay"){return}var o=e?"addStyleClass":"removeStyleClass";t[o]("sapUiRtaChangeIndicatorHovered");this[o]("sapUiRtaHover")};d.prototype._toggleDetailPopover=function(){if(!this.getAggregation("_popover")){this._iOldTabIndex=this.getDomRef().getAttribute("tabindex");o.load({name:"sap.ui.rta.util.changeVisualization.ChangeIndicatorPopover",id:`${this.sId}Info`,controller:this}).then(function(e){e._bOpenedByChangeIndicator=true;this.setAggregation("_popover",e);e.setModel(this._oDetailModel,"details");e.openBy(this);this.fireDetailPopoverOpened()}.bind(this))}else{if(this.getAggregation("_popover").isOpen()){return this.getAggregation("_popover").close()}this.getAggregation("_popover").openBy(this);this.fireDetailPopoverOpened()}return undefined};d.prototype._showDependentElements=function(e){this.getAggregation("_popover").close();var t=this.getChanges().length>1?e.getSource().getBindingContext("details").getObject().id:this.getChanges()[0].id;this.fireSelectChange({changeId:t})};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/ChangeIndicatorRegistry", ["sap/base/util/includes","sap/base/util/values","sap/base/util/restricted/_omit","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/dt/ElementUtil","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/Utils","sap/ui/fl/changeHandler/common/ChangeCategories","sap/ui/rta/util/changeVisualization/ChangeStates"],function(e,t,n,i,o,a,r,s,g,c,d){"use strict";var u=o.extend("sap.ui.rta.util.changeVisualization.ChangeIndicatorRegistry",{metadata:{properties:{changeCategories:{type:"object",defaultValue:[]},rootControlId:{type:"string"}}},constructor:function(...e){o.prototype.constructor.apply(this,e);this._oRegisteredChanges={};this._oChangeIndicators={}}});u.prototype.exit=function(){this.reset()};u.prototype.getAllRegisteredChanges=function(){return t(this._oRegisteredChanges||{}).map(function(e){return Object.assign({},e)})};u.prototype.getRegisteredChangeIds=function(){return Object.keys(this._oRegisteredChanges||{})};u.prototype.getRegisteredChange=function(e){return this._oRegisteredChanges[e]&&Object.assign({},this._oRegisteredChanges[e])};u.prototype.getSelectorsWithRegisteredChanges=function(){var e={};var i;function o(t,o,a,r){if(e[t]===undefined){e[t]=[]}e[t].push(Object.assign({id:a.change.getId(),dependent:r,affectedElementId:o||i,displayElementsKey:a.visualizationInfo.displayElementIds.toString(),descriptionPayload:a.visualizationInfo.descriptionPayload||{}},n(a,["visualizationInfo"])));i=o||i}t(this._oRegisteredChanges).forEach(function(e){e.visualizationInfo.displayElementIds.forEach(function(t,n){o(t,e.visualizationInfo.affectedElementIds[n],e,false)})});return e};u.prototype.getRelevantChangesWithSelector=function(){var e=this.getSelectorsWithRegisteredChanges();var t=[];Object.keys(e).forEach(function(n){var i=e[n].filter(function(e){return!e.dependent});t=t.concat(i)});return t};u.prototype.getChangeIndicator=function(e){return this._oChangeIndicators[e]};u.prototype.getChangeIndicators=function(){return t(this._oChangeIndicators||{})};u.prototype.registerChange=function(t,n,i){var o=g.getAppComponentForControl(r.getElementInstance(this.getRootControlId()));return l(t,o).then(function(o){var a=this.getChangeCategories();var r;if(n==="settings"&&e(Object.keys(a),o.descriptionPayload.category)){r=o.descriptionPayload.category}else{r=Object.keys(a).find(function(t){return e(a[t],n)});r||=c.OTHER}var s;var g=[];if(i){g=i.getData().draftFilenames}if(t.getState()==="NEW"){s=d.getDraftAndDirtyStates()}else if(g&&g.includes(t.getId())){s=[d.DRAFT]}else{s=[d.ALL]}this._oRegisteredChanges[t.getId()]={change:t,commandName:n,changeCategory:r,changeStates:s,visualizationInfo:o}}.bind(this))};function l(e,t){function n(e){if(!e){return undefined}return e.map(function(e){var n=typeof e.getId==="function"?e:a.bySelector(e,t);return n&&n.getId()}).filter(Boolean)}return h(t,e).then(function(t){var i=t||{};var o=e.getSelector&&e.getSelector()&&[e.getSelector()];var a=i.affectedControls||o||[];var r=e.getOriginalSelector&&e.getOriginalSelector();var s=r?o:a;return{affectedElementIds:n(a),dependentElementIds:n(i.dependentControls)||[],displayElementIds:n(i.displayControls||n(s)),updateRequired:i.updateRequired,descriptionPayload:i.descriptionPayload||{}}})}function h(e,t){var n=t.getOriginalSelector&&t.getOriginalSelector();n||=t.getSelector&&t.getSelector();var o=a.bySelector(n,e);if(o){return s.getChangeHandler({changeType:t.getChangeType(),element:o,modifier:a,layer:t.getLayer()}).then(function(n){if(n&&typeof n.getChangeVisualizationInfo==="function"&&t.isSuccessfullyApplied&&t.isSuccessfullyApplied()){return n.getChangeVisualizationInfo(t,e)}return undefined}).catch(function(e){i.error(e);return undefined})}return Promise.resolve()}u.prototype.registerChangeIndicator=function(e,t){this._oChangeIndicators[e]=t};u.prototype.reset=function(){Object.keys(this._oRegisteredChanges).forEach(function(e){this.removeRegisteredChange(e)}.bind(this));t(this._oChangeIndicators).forEach(function(e){e.destroy()});this._oChangeIndicators={}};u.prototype.removeRegisteredChange=function(e){delete this._oRegisteredChanges[e]};u.prototype.removeOutdatedRegisteredChanges=function(){this.getAllRegisteredChanges().forEach(function(e){if(e.visualizationInfo&&e.visualizationInfo.updateRequired){this.removeRegisteredChange(e.change.getId())}}.bind(this))};u.prototype.removeRegisteredChangesWithoutVizInfo=function(){this.getAllRegisteredChanges().forEach(function(e){if(e.visualizationInfo&&e.visualizationInfo.displayElementIds.length===0){this.removeRegisteredChange(e.change.getId())}}.bind(this))};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/ChangeStates", [],function(){"use strict";var t={};t.ALL="all";t.DRAFT="draft";t.DIRTY="dirty";t.getDraftAndDirtyStates=function(){return[this.DRAFT,this.DIRTY]};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/ChangeVisualization", ["sap/ui/core/Core","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/core/Lib","sap/base/util/isEmptyObject","sap/base/util/restricted/_difference","sap/base/util/deepEqual","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Control","sap/ui/dt/OverlayRegistry","sap/ui/dt/ElementUtil","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/model/resource/ResourceModel","sap/ui/model/json/JSONModel","sap/ui/rta/util/changeVisualization/ChangeIndicator","sap/ui/rta/util/changeVisualization/ChangeIndicatorRegistry","sap/ui/rta/util/changeVisualization/ChangeCategories","sap/ui/rta/util/changeVisualization/ChangeStates"],function(e,t,i,n,a,o,s,r,g,l,h,u,c,d,p,C,f,y,v,_){"use strict";function I(){var e=this.getPopover();if(e&&e.isOpen()){e.close()}}function m(e){return!e||!e.getDomRef()||!e.isVisible()}function V(e,t){var i=l.getOverlay(e);if(!i){var n=l.getOverlay(t);var a=n&&n.getRelevantContainer();if(a){i=l.getOverlay(a)}}return i}var M=g.extend("sap.ui.rta.util.changeVisualization.ChangeVisualization",{metadata:{library:"sap.ui.rta",properties:{rootControlId:{type:"string"},isActive:{type:"boolean",defaultValue:false}},aggregations:{popover:{type:"sap.m.Popover",multiple:false}}},constructor:function(...e){this._oChangeIndicatorRegistry=new y({changeCategories:v.getCategories()});g.prototype.constructor.apply(this,e);this._oTextBundle=n.getResourceBundleFor("sap.ui.rta");this.setModel(new p({bundle:this._oTextBundle}),"i18n");this._oChangeVisualizationModel=new C({active:this.getIsActive(),changeState:_.ALL});this._oChangeVisualizationModel.setDefaultBindingMode("TwoWay");this._sSelectedChangeCategory=v.ALL;this._bSetModeChanged=false;this._fnOnClickHandler=I.bind(this)}});M.prototype.setVersionsModel=function(e){this.oVersionsModel=e.getModel("versions")};M.prototype.setRootControlId=function(e){if(this.getRootControlId()&&this.getRootControlId()!==e){this._reset()}this.setProperty("rootControlId",e);this._oChangeIndicatorRegistry.setRootControlId(e)};M.prototype._getComponent=function(){return d.getAppComponentForControl(h.getElementInstance(this.getRootControlId()))};M.prototype.setIsActive=function(e){if(e===this.getIsActive()){return}this.setProperty("isActive",e);if(this._oChangeVisualizationModel){this._updateVisualizationModel({active:e})}};M.prototype.exit=function(){this._oChangeIndicatorRegistry.destroy();this._toggleRootOverlayClickHandler(false)};M.prototype.updateAfterSave=function(e){if(this.getProperty("rootControlId")){this._oChangeIndicatorRegistry.reset();this._updateChangeRegistry().then(function(){this._selectChangeCategory(this._sSelectedChangeCategory);this._selectChangeState(_.ALL);this._updateVisualizationModelMenuData();e.setModel(this._oChangeVisualizationModel,"visualizationModel")}.bind(this))}};M.prototype._reset=function(){this._oChangeIndicatorRegistry.reset()};M.prototype._determineChangeVisibility=function(e,t,i){function n(e){return e.filter(function(e){if(!i||i===_.ALL||e.changeStates.includes(i)){return true}return false})}var a=[];var o=[];var s=false;var r=false;var g=t.map(function(e){return e.id});e.forEach(function(e){if(e.changeStates.includes(_.DIRTY)){s=true;r=true}else if(e.changeStates.includes(_.DRAFT)){s=true}var t=V(e.visualizationInfo.displayElementIds[0],e.visualizationInfo.affectedElementIds[0]);if(!g.includes(e.change.getId())){a.push(e)}else if(m(t)){a.push(e)}else{o.push(e)}});var l=n(a);var h=n(o);return{relevantHiddenChanges:l,relevantVisualizedChanges:h,hasDirtyChanges:r,hasDraftChanges:s}};M.prototype._updateVisualizationModelMenuData=function(){var e=this._oChangeVisualizationModel.getData().changeState;var t=this._oChangeIndicatorRegistry.getAllRegisteredChanges();var i=this._oChangeIndicatorRegistry.getRelevantChangesWithSelector();var n=t.filter(function(e){if(!e.dependent){return true}return false});var a=this._determineChangeVisibility(n,i,e);var o=Object.keys(v.getCategories()).map(function(e){var t=this._getChangeCategoryLabel(e,this._getChangesForChangeCategory(e,a.relevantVisualizedChanges).length);return{key:e,count:this._getChangesForChangeCategory(e,a.relevantVisualizedChanges).length,title:t,icon:v.getIconForCategory(e)}}.bind(this));o.unshift({key:v.ALL,count:this._getChangesForChangeCategory(v.ALL,a.relevantVisualizedChanges).length,title:this._getChangeCategoryLabel(v.ALL,this._getChangesForChangeCategory(v.ALL,a.relevantVisualizedChanges).length),icon:v.getIconForCategory(v.ALL)});this._updateVisualizationModel({changeCategories:o,hasDraftChanges:a.hasDraftChanges,hasDirtyChanges:a.hasDirtyChanges,popupInfoMessage:this._oTextBundle.getText("MSG_CHANGEVISUALIZATION_HIDDEN_CHANGES_INFO",[a.relevantHiddenChanges.length]),sortedChanges:a})};M.prototype._getChangesForChangeCategory=function(e,t){return t.filter(function(t){return e===v.ALL?t.changeCategory!==undefined:e===t.changeCategory})};M.prototype._getChangeCategoryLabel=function(e,t){var i=`TXT_CHANGEVISUALIZATION_OVERVIEW_${e.toUpperCase()}`;return this._oTextBundle.getText(i,[t])};M.prototype._getChangeCategoryButton=function(e){var t=`BTN_CHANGEVISUALIZATION_OVERVIEW_${e.toUpperCase()}`;return this._oTextBundle.getText(t)};M.prototype.openChangeCategorySelectionPopover=function(e){this._oToolbarButton||=t.getElementById(e.getParameter("id"));var n=this.getPopover();if(!n){i.load({name:"sap.ui.rta.util.changeVisualization.ChangeIndicatorCategorySelection",id:this._getComponent().createId("changeVisualization_changesList"),controller:this}).then(function(e){this._oToolbarButton.addDependent(e);e.setModel(this._oChangeVisualizationModel,"visualizationModel");e.openBy(this._oToolbarButton);this.setPopover(e);e.close();e.openBy(this._oToolbarButton)}.bind(this));return}if(n.isOpen()){n.close()}else{n.openBy(this._oToolbarButton)}};M.prototype.onChangeCategorySelection=function(e){var t=e.getSource().getBindingContext("visualizationModel").getObject().key;this._selectChangeCategory(t)};M.prototype.onVersioningCategoryChange=function(e){var t=e.getSource().getSelectedKey();this._selectChangeState(t)};M.prototype._selectChangeCategory=function(e){this._sSelectedChangeCategory=e;var t=this._getChangeCategoryButton(e);this._updateVisualizationModel({changeCategory:e,changeCategoryText:t});this._updateChangeIndicators();this._setFocusedIndicator()};M.prototype._selectChangeState=function(e){this._sSelectedChangeState=e;this._updateVisualizationModel({changeState:e});this._updateChangeIndicators();this._updateVisualizationModelMenuData()};M.prototype._getCommandForChange=function(e){var t=e.getSupportInformation().command;if(t){return t}if(!e.getSelector||!e.getSelector()||a(e.getSelector())){return false}var i=this._getComponent();var n=r.bySelector(e.getSelector(),i);var o=e.getDependentSelectorList().slice(-1)[0];var s=r.bySelector(o,i);function g(t,i){var a=t.getElement();var o=t.getDesignTimeMetadata().getCommandName(e.getChangeType(),a,i);if(o){return o}var s=t.getParentElementOverlay();var r=t.getParentAggregationOverlay();if(t.getElement().getId()===n.getId()||!s){return undefined}return g(s,r&&r.getAggregationName())}return n&&s&&g(l.getOverlay(s))};M.prototype._collectChanges=function(){var e=this._getComponent();var t={selector:e,invalidateCache:false,includeCtrlVariants:true,currentLayer:c.CUSTOMER,includeDirtyChanges:true,onlyCurrentVariants:true};return u._getUIChanges(t)};M.prototype._updateChangeRegistry=function(){return this._collectChanges().then(function(e){this._oChangeIndicatorRegistry.removeOutdatedRegisteredChanges();this._oChangeIndicatorRegistry.removeRegisteredChangesWithoutVizInfo();if(this._oChangeVisualizationModel.getData().displayedVersion!=="0"){this._oChangeIndicatorRegistry.reset()}var t=this._oChangeIndicatorRegistry.getRegisteredChangeIds();var i=e.reduce(function(e,t){e[t.getId()]=t;return e},{});var n=Object.keys(i);o(t,n).forEach(function(e){this._oChangeIndicatorRegistry.removeRegisteredChange(e)}.bind(this));var a=[];o(n,t).forEach(function(e){var t=i[e];var n=this._getCommandForChange(t);a.push(this._oChangeIndicatorRegistry.registerChange(t,n,this.oVersionsModel))}.bind(this));return Promise.all(a)}.bind(this))};M.prototype.selectChange=function(e){var t=e.getParameter("changeId");this._selectChange(t)};M.prototype._selectChange=function(e){var t=this._oChangeIndicatorRegistry.getRegisteredChange(e).visualizationInfo.dependentElementIds;t.forEach(function(e){var t=l.getOverlay(e).getDomRef();t.scrollIntoView({block:"nearest"});t.classList.add("sapUiRtaChangeIndicatorDependent");t.addEventListener("animationend",function(){t.classList.remove("sapUiRtaChangeIndicatorDependent")},{once:true})})};M.prototype._updateVisualizationModel=function(e){this._oChangeVisualizationModel.setData(Object.assign({},this._oChangeVisualizationModel.getData(),e))};M.prototype._updateChangeIndicators=function(){var e=this._oChangeIndicatorRegistry.getSelectorsWithRegisteredChanges();var t={};this._mDisplayElementsKeyMap={};Object.keys(e).forEach(function(i){var n=e[i];var a=this._filterRelevantChanges(e[i]);var o=V(i,n[0].affectedElementId);if(m(o)){return undefined}var s=o.getDomRef().getClientRects()[0]||{left:0,top:0};t[i]={posX:parseInt(s.left),posY:parseInt(s.top),changes:a};var r=this._oChangeIndicatorRegistry.getChangeIndicator(i);var g=o.getId();if(!r){this._createChangeIndicator(o,i);var l=n[0].displayElementsKey;if(!this._mDisplayElementsKeyMap[l]){this._mDisplayElementsKeyMap[l]=[i]}else{this._mDisplayElementsKeyMap[l].push(i)}}else if(r.getOverlayId()!==g){r.setOverlayId(g)}return undefined}.bind(this));this._registerIndicatorBrowserEvents();if(!s(t,this._oChangeVisualizationModel.getData().content)){this._updateVisualizationModel({content:t})}};M.prototype._registerIndicatorBrowserEvents=function(){Object.keys(this._mDisplayElementsKeyMap).forEach(function(e){var i=this._mDisplayElementsKeyMap[e].map(function(e){return this._oChangeIndicatorRegistry.getChangeIndicator(e)}.bind(this));function n(e,t){i.forEach(function(i){if(i.getVisible()){i.onIndicatorBrowserInteraction(e,t)}})}function a(e){i.forEach(function(t){if(t.getVisible()){t.onDetailPopoverOpened(e)}})}i.forEach(function(e){e.attachBrowserEvent("mouseover",n.bind(this,true));e.attachBrowserEvent("focusin",n.bind(this,true));e.attachBrowserEvent("mouseout",n.bind(this,false));e.attachBrowserEvent("focusout",n.bind(this,false));e.attachDetailPopoverOpened(a.bind(this));var i=t.getElementById(e.getOverlayId());i.attachBrowserEvent("mouseout",n.bind(this,false));i.attachBrowserEvent("focusout",n.bind(this,false))})}.bind(this))};M.prototype._filterRelevantChanges=function(e){if(!Array.isArray(e)){return e}var t=this._oChangeVisualizationModel.getData();return e.filter(function(e){return!e.dependent&&e.changeCategory&&(t.changeCategory===v.ALL||t.changeCategory===e.changeCategory)&&(!t.changeState||t.changeState===_.ALL||e.changeStates.includes(t.changeState))})};M.prototype._createChangeIndicator=function(e,t){var i=new f({changes:"{changes}",posX:"{posX}",posY:"{posY}",visible:"{= ${/active} && (${changes} || []).length > 0}",overlayId:e.getId(),selectorId:t,selectChange:this.selectChange.bind(this)});i.setModel(this._oChangeVisualizationModel);i.bindElement(`/content/${t}`);i.setModel(this.getModel("i18n"),"i18n");this._oChangeIndicatorRegistry.registerChangeIndicator(t,i)};M.prototype._setFocusedIndicator=function(){e.applyChanges();var t=this._oChangeIndicatorRegistry.getChangeIndicators().filter(function(e){return e.getVisible()}).sort(function(e,t){var i=e.getPosY()-t.getPosY();var n=e.getPosX()-t.getPosX();return i||n});if(t.length===0){return}var i=[];t.forEach(function(e,t){e.getDomRef().tabIndex=t+2;if(e.getPosY()>0){i.push(e)}});if(i.length>0){i[0].focus()}else{t[0].focus()}};M.prototype._toggleRootOverlayClickHandler=function(e){var t=this.oRootOverlay&&this.oRootOverlay.getDomRef();if(t){if(e){t.addEventListener("click",this._fnOnClickHandler,{capture:true})}else{t.removeEventListener("click",this._fnOnClickHandler,{capture:true})}}};M.prototype.triggerModeChange=function(e,t){this.oMenuButton=t.getControl("toggleChangeVisualizationMenuButton");this.oRootOverlay=l.getOverlay(e);this.setVersionsModel(t);if(this.oVersionsModel&&this.oVersionsModel.getData().versioningEnabled){this._updateVisualizationModel({versioningAvailable:this.oVersionsModel.getData().versioningEnabled,displayedVersion:this.oVersionsModel.getData().displayedVersion})}else{this._updateVisualizationModel({versioningAvailable:false,displayedVersion:"0"})}if(this.getIsActive()){this.setIsActive(false);this._toggleRootOverlayClickHandler(false);return}this._toggleRootOverlayClickHandler(true);if(!this.getRootControlId()){this.setRootControlId(e)}this.setIsActive(true);this._updateChangeRegistry().then(function(){this._selectChangeCategory(this._sSelectedChangeCategory);t.adjustToolbarSectionWidths();this._updateVisualizationModelMenuData();t.setModel(this._oChangeVisualizationModel,"visualizationModel")}.bind(this))};return M});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/ChangeVisualizationUtils", [],function(){"use strict";var r={};r.shortenString=function(r){if(!r){return null}var n=r.length;if(n>60){var t=r.substring(0,27);var i=r.substring(n-27);r=`${t}(...)${i}`}return r};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/commands/CombineVisualization", ["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/dt/ElementUtil","sap/ui/rta/util/changeVisualization/ChangeVisualizationUtils"],function(e,t,i,r,n){"use strict";var o=t.getResourceBundleFor("sap.ui.rta");var a={};a.getDescription=function(t,a,T){var l=(t.originalSelectors||[]).length;if(l<2){return{descriptionText:o.getText("TXT_CHANGEVISUALIZATION_CHANGE_COMBINE",[n.shortenString(a)]),descriptionTooltip:o.getText("TXT_CHANGEVISUALIZATION_CHANGE_COMBINE",[a])}}var s=T.appComponent;var u=t.originalSelectors;var p=u.map(function(t){var n=i.getControlIdBySelector(t,s);var o=e.getElementById(n);return o?r.getLabelForElement(o):n});var I=p.map(n.shortenString);if(l===2){return{descriptionText:o.getText("TXT_CHANGEVISUALIZATION_CHANGE_COMBINE_TWO",I),descriptionTooltip:o.getText("TXT_CHANGEVISUALIZATION_CHANGE_COMBINE_TWO",p)}}return{descriptionText:o.getText("TXT_CHANGEVISUALIZATION_CHANGE_COMBINE_MANY",[p.length]),descriptionTooltip:p.map(function(e){return`"${e}"`}).join(",\n")}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/commands/CreateContainerVisualization", ["sap/ui/core/Lib","sap/ui/rta/util/changeVisualization/ChangeVisualizationUtils"],function(i,t){"use strict";var e={};e.getDescription=function(e,r){var a=i.getResourceBundleFor("sap.ui.rta");var n=e.originalLabel||r;var o=t.shortenString(n);var s="TXT_CHANGEVISUALIZATION_CHANGE_CREATECONTAINER";return{descriptionText:a.getText(s,[o]),descriptionTooltip:a.getText(s,[n])}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/commands/MoveVisualization", ["sap/ui/core/Lib","sap/ui/rta/util/changeVisualization/ChangeVisualizationUtils","sap/ui/core/util/reflection/JsControlTreeModifier"],function(t,e,r){"use strict";var i={};i.getDescription=function(i,n,o){var a=t.getResourceBundleFor("sap.ui.rta");var T=a.getText("TXT_CHANGEVISUALIZATION_CHANGE_MOVE_WITHIN",[e.shortenString(n)]);var I=a.getText("TXT_CHANGEVISUALIZATION_CHANGE_MOVE_WITHIN",[n]);var N;var A=o.appComponent;var s=i.sourceContainer&&r.getControlIdBySelector(i.sourceContainer,A);var u=i.targetContainer&&r.getControlIdBySelector(i.targetContainer,A);if(s!==u){T=a.getText("TXT_CHANGEVISUALIZATION_CHANGE_MOVE",[e.shortenString(n)]);I=s&&a.getText("TXT_CHANGEVISUALIZATION_CHANGE_MOVE",[n])||"";N=s&&a.getText("BTN_CHANGEVISUALIZATION_SHOW_DEPENDENT_CONTAINER_MOVE")}return{descriptionText:T,descriptionTooltip:I,buttonText:N}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/commands/RenameVisualization", ["sap/ui/core/Lib","sap/ui/rta/util/changeVisualization/ChangeVisualizationUtils"],function(i,e){"use strict";var t={};t.getDescription=function(t,a){var r=i.getResourceBundleFor("sap.ui.rta");var n=t.originalLabel?"TXT_CHANGEVISUALIZATION_CHANGE_RENAME_FROM_TO":"TXT_CHANGEVISUALIZATION_CHANGE_RENAME_TO";var o=r.getText(n,[e.shortenString(t.newLabel)||a,e.shortenString(t.originalLabel)]);var s=r.getText(n,[t.newLabel||a,t.originalLabel]);return{descriptionText:o,descriptionTooltip:s}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/commands/SplitVisualization", ["sap/ui/core/Lib","sap/ui/rta/util/changeVisualization/ChangeVisualizationUtils"],function(t,e){"use strict";var i={};i.getDescription=function(i,r){var T=t.getResourceBundleFor("sap.ui.rta");var n=T.getText("TXT_CHANGEVISUALIZATION_CHANGE_SPLIT",[e.shortenString(r)]);var a=T.getText("TXT_CHANGEVISUALIZATION_CHANGE_SPLIT",[r]);var u=T.getText("BTN_CHANGEVISUALIZATION_SHOW_DEPENDENT_CONTAINER_SPLIT");return{descriptionText:n,descriptionTooltip:a,buttonText:u}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/commands/getCommandVisualization", ["sap/ui/rta/util/changeVisualization/commands/RenameVisualization","sap/ui/rta/util/changeVisualization/commands/MoveVisualization","sap/ui/rta/util/changeVisualization/commands/CombineVisualization","sap/ui/rta/util/changeVisualization/commands/SplitVisualization","sap/ui/rta/util/changeVisualization/commands/CreateContainerVisualization"],function(a,i,n,t,e){"use strict";var s={rename:a,move:i,combine:n,split:t,createContainer:e};return function(a){var i=a.commandName;if(i==="settings"){i=a.changeCategory}return s[i]}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/hasStableId", ["sap/ui/fl/Utils","sap/ui/dt/ElementUtil","sap/base/util/isPlainObject"],function(e,t,a){"use strict";function n(e){var{sParentAggregationName:t}=e;var a=e.getParent();if(a&&t){var r=a.getBindingInfo(t);if(r){if(r.template&&e instanceof r.template.getMetadata().getClass()){return r.template}return false}return n(a)}return false}return function r(i){if(!i||i._bIsBeingDestroyed){return false}if(typeof i.data("hasStableId")!=="boolean"){var l=i.getDesignTimeMetadata().getStableElements(i);var s=false;if(l.length>0){if(n(i.getElement())){s=l.some(function(n){var r;var i;var l=false;if(a(n)){r=n.id;i=n.appComponent}else{r=n}l=!e.checkControlId(r,i);if(l){var s=t.getElementInstance(r);if(t.getElementInstance(r)){var o=t.getAggregationInformation(s);l=!e.checkControlId(t.extractTemplateId(o),i)}}return l})}else{s=l.some(function(t){var a=t.id||t;return!e.checkControlId(a,t.appComponent)})}}i.data("hasStableId",!s)}return i.data("hasStableId")}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/showMessageBox", ["sap/m/MessageBox","sap/ui/layout/HorizontalLayout","sap/m/Link","sap/m/Text"],function(e,r,t,n){"use strict";var a="\\[(.*?)\\]\\((.*?)\\)";function i(e){var r=o(e);return Array.isArray(r)&&r.length>0}function u(e){var r=new RegExp(`^${a}$`);return Array.isArray(r.exec(e))}function s(e){var r=new RegExp(a).exec(e);return{text:r[1],href:r[2]}}function o(e){var r=new RegExp(a,"g");return e.match(r)}function c(e){var a=new r({allowWrapping:true,content:e.map(function(e){if(u(e)){var r=s(e);return new t({text:r.text,href:r.href,target:"_blank",emphasized:true,wrapping:true})}return new n({text:e,renderWhitespace:true})})});a.addStyleClass("sapUiRtaMessageBox");return a}function p(e){var r=[e];var t=o(e);t.forEach(function(e){var t=0;while(t<r.length){var n=r[t];if(u(n)){t++}else{var a=n.split(e);var i=[];a.forEach(function(r,t,n){i.push(r);if(t!==n.length-1){i.push(e)}});r.splice.apply(r,[t,1].concat(i));t+=i.length}}});return r}return function r(t,n,a){var u;if(i(t)){var s=p(t);u=c(s)}else{u=t}e[a||"show"](u,n)}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/validateFlexEnabled", ["sap/ui/fl/Utils","sap/m/MessageBox","sap/base/util/ObjectPath","sap/ui/rta/util/validateStableIds","sap/ui/rta/util/showMessageBox","sap/base/Log","sap/ui/rta/Utils","sap/ui/dt/Util"],function(e,t,a,n,o,i,s,r){"use strict";return function(l){var g={};var u=[];var p=e.getAppComponentForControl(l.getRootControlInstance());function f(e,a,n,i,r){var l=a.getId();if(!g[l]){o(e._getTextResources().getText(n),{icon:t.Icon[i],title:e._getTextResources().getText(r),styleClass:s.getRtaStyleClassName()},"show");c(l,true)}}function c(e,t){g[e]=t}function d(e){var t=e.getManifest();return a.get(["sap.app","id"],t)!=="sap.ui.documentation.sdk"&&!(a.get(["sap.app","id"],t)||"").startsWith("sap.ui.rta")&&!a.get(["sap.ovp"],t)}function m(){return"QUnit"in window||window.frameElement&&(window.frameElement.getAttribute("id")||"").toLowerCase()==="opaframe"}function v(e){return e&&!e._bIsBeingDestroyed}function E(t){var a=t.getParameters().mode;if(a==="adaptation"){var n=t.getSource();var o=e.getAppComponentForControl(n.getRootControlInstance());u=u.filter(v);R(n,o,u);u=[]}}function I(t,a){var n=t.getParameters().elementOverlay;if(a.getMode()==="adaptation"){var o=e.getAppComponentForControl(a.getRootControlInstance());r.waitForSynced(a._oDesignTime,function(e){if(v(e)){R(a,o,[e])}})(n)}else{u.push(n)}}function R(e,t,a){var o=n(a,t);if(o.length){o.forEach(function(e){i.error("Control ID was generated dynamically by SAPUI5. To support SAPUI5 flexibility, a stable control ID is needed to assign the changes to.",e.getElement().getId())});f(e,t,"MSG_UNSTABLE_ID_FOUND","ERROR","HEADER_ERROR")}}l.attachEventOnce("stop",function(){c(p.getId(),false)});if(p&&d(p)){var C=p.getManifest();var _=a.get(["sap.ui5","flexEnabled"],C);if(typeof _!=="boolean"){if(!m()){f(l,p,"MSG_NO_FLEX_ENABLED_FLAG","WARNING","HEADER_WARNING")}}else{l.attachEvent("modeChanged",E);l._oDesignTime.attachEvent("elementOverlayCreated",l,I);R(l,p,l._oDesignTime.getElementOverlays())}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/validateStableIds", ["sap/base/util/ObjectPath","sap/ui/rta/util/hasStableId","sap/ui/core/mvc/View","sap/ui/core/Fragment","sap/ui/dt/OverlayUtil","sap/base/util/isPlainObject"],function(e,t,a,i,r,n){"use strict";function s(t){var a=t.getManifest();var i=!!e.get(["sap.ui5","dependencies","libs","sap.fe.templates"],a);var r=!!e.get(["sap.ui.generic.app"],a);var n=!!e.get(["sap.ovp"],a);return r||i||n}function u(t){var a=t.getManifest();var i=e.get(["sap.ui5","extends","extensions","sap.ui.viewExtensions"],a);var r=[];if(n(i)){Object.keys(i).forEach(function(e){if(e.startsWith("sap.suite.ui.generic.template")){var t=i[e];Object.keys(t).forEach(function(e){r.push(t[e])})}})}return r}function c(e,t){var n=[];for(var s=0,u=t.length;s<u;s++){var c=t[s];var f=c.getElement();var p=e.some(function(e){var t=sap.ui.require(e.className.replace(/\./g,"/"));var r;var n;if(f instanceof a){n=f.getViewName();r=e.viewName}else if(f instanceof i){n=f.getFragmentName()}else{return false}return f instanceof t&&n===r});if(p){n.push(c);if(n.length===e.length){break}}}var v=[];n.forEach(function(e){r.iterateOverlayElementTree(e,function(e){v.push(e)})});return v}return function(e,a){var i=[];var r=e.slice(0);if(s(a)){var n=u(a);r=n.length?c(n,r):[]}i=r.filter(function(e){return!e.getDesignTimeMetadata().markedAsNotAdaptable()&&!t(e)});return i}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/validateText", ["sap/ui/base/BindingParser","sap/ui/core/Lib"],function(r,e){"use strict";var t=" ";var o={noEmptyText:{validatorFunction(r){return r!==t},errorMessage:e.getResourceBundleFor("sap.ui.rta").getText("RENAME_EMPTY_ERROR_TEXT")}};function a(t,o){if(o===t){throw Error("sameTextError")}var a;var i;try{a=r.complexParser(t,undefined,true)}catch(r){i=true}if(a&&typeof a==="object"||i){throw Error(e.getResourceBundleFor("sap.ui.rta").getText("RENAME_BINDING_ERROR_TEXT"))}}return function(r,e,t){a(r,e);var i;var n=t&&t.validators||[];n.some(function(e){var t;if(typeof e==="string"&&o[e]){t=o[e]}else{t=e}if(!t.validatorFunction(r)){i=t.errorMessage;return true}return false});if(i){throw Error(i)}}},true);
sap.ui.require.preload({
	"sap/ui/rta/appVariant/manageApps/webapp/index.js":function(){
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.require(["sap/m/Shell","sap/ui/core/ComponentContainer","sap/ui/core/Core"],function(a,e,p){"use strict";p.ready().then(()=>{new a({app:new e({height:"100%",name:"sap.ui.rta.appVariant.manageApps",settings:{id:"sap.ui.rta.appVariant.manageApps"}})}).placeAt("content")})});
},
	"sap/ui/rta/appVariant/manageApps/webapp/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.rta.appVariant.manageApps","type":"application","i18n":{"bundleUrl":"i18n/i18n.properties","supportedLocales":["","ar","bg","ca","cs","da","de","el","en","en_US_sappsd","en_US_saptrc","es","et","fi","fr","hi","hr","hu","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh_CN","zh_TW"],"fallbackLocale":"en"},"applicationVersion":{"version":"1.0.0"},"title":"{{appTitle}}","description":"{{appDescription}}","resources":"resources.json","ach":"ach","sourceTemplate":{"id":"ui5template.basicSAPUI5ApplicationProject","version":"1.40.12"}},"sap.ui":{"technology":"UI5","icons":{"icon":"","favIcon":"","phone":"","phone@2":"","tablet":"","tablet@2":""},"deviceTypes":{"desktop":true,"tablet":true,"phone":true}},"sap.ui5":{"rootView":{"viewName":"sap.ui.rta.appVariant.manageApps.webapp.view.ManageApps","type":"XML","async":true},"dependencies":{"minUI5Version":"1.30.0","libs":{"sap.m":{},"sap.ui.core":{},"sap.ui.layout":{},"sap.ui.rta":{}}},"contentDensities":{"compact":true,"cozy":true},"models":{"i18n":{"type":"sap.ui.model.resource.ResourceModel","settings":{"bundleName":"sap.ui.rta.appVariant.manageApps.webapp.i18n.i18n","supportedLocales":["","ar","bg","ca","cs","da","de","el","en","en_US_sappsd","en_US_saptrc","es","et","fi","fr","hi","hr","hu","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh_CN","zh_TW"],"fallbackLocale":"en"}}},"resources":{"css":[{"uri":"css/style.css"}]}}}',
	"sap/ui/rta/appVariant/manageApps/webapp/view/ManageApps.view.xml":'<mvc:View\n\tcontrollerName="sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps"\n\txmlns:mvc="sap.ui.core.mvc"\n\txmlns:core="sap.ui.core"\n\txmlns="sap.m"><Table id="Table1"\n\t\tshowNoData="false"\n\t\tinset="false"\n\t\tgrowing="true"\n\t\tgrowingThreshold="500"\n\t\tsticky="ColumnHeaders"\n\t\titems="{/appVariants}"><columns><Column\n\t\t\t\twidth="8rem"\n\t\t\t\thAlign="Left"><Text text="{i18n>MAA_DIALOG_APP_TYPE}" /></Column><Column\n\t\t\t\twidth="4rem"\n\t\t\t\tminScreenWidth="tablet"\n\t\t\t\tdemandPopin="true"\n\t\t\t\tpopinDisplay="Inline"\n\t\t\t\thAlign="Left"><core:InvisibleText text="{i18n>MAA_DIALOG_ICON}" /></Column><Column\n\t\t\t\tminScreenWidth="tablet"\n\t\t\t\tdemandPopin="true"\n\t\t\t\tpopinDisplay="Inline"\n\t\t\t\thAlign="Left"><Text text="{i18n>MAA_DIALOG_TITLE}" /></Column><Column\n\t\t\t\tminScreenWidth="tablet"\n\t\t\t\tdemandPopin="true"\n\t\t\t\tpopinDisplay="Inline"\n\t\t\t\thAlign="Left"><Text text="{i18n>MAA_DIALOG_DESCRIPTION}" /></Column><Column\n\t\t\t\twidth="8rem"\n\t\t\t\tminScreenWidth="Desktop"\n\t\t\t\tdemandPopin="true"\n\t\t\t\tpopinDisplay="Inline"\n\t\t\t\thAlign="End"><core:InvisibleText text="{i18n>MAA_DIALOG_ACTIONS_HEADER}" /></Column></columns><items><ColumnListItem highlight="{path: \'currentStatus\', formatter:\'.formatRowHighlight\'}"><cells><ObjectIdentifier\n\t\t\t\t\t\ttitle="{typeOfApp}"\n\t\t\t\t\t\ttext="{currentStatus}" /><core:Icon src="{icon}" tooltip="{iconText}" class="sapUiListTableIconSize" /><ObjectIdentifier\n\t\t\t\t\t\ttitle="{title}"\n\t\t\t\t\t\ttext="{subTitle}" /><Text text="{description}" /><MenuButton text="{i18n>MAA_DIALOG_ACTIONS}"><menu><Menu itemSelected="onMenuAction"><items><MenuItem text="{i18n>MAA_DIALOG_ADAPT_UI}"\n\t\t\t\t\t\t\t\t\t\tvisible="{parts: [{path: \'adaptUIButtonVisibility\'}, {path: \'isKeyUser\'}], formatter:\'.formatAdaptUIButtonVisibility\'}"\n\t\t\t\t\t\t\t\t\t\tenabled="{adaptUIButtonEnabled}"\n\t\t\t\t\t\t\t\t\t\ttooltip="{parts: [{path: \'adaptUIButtonEnabled\'}, {path: \'appVarStatus\'}], formatter:\'.formatAdaptUIButtonTooltip\'}"\n\t\t\t\t\t\t\t\t\t\ticon="sap-icon://wrench"/><MenuItem text="{i18n>MAA_DIALOG_COPY_ID}" tooltip="{i18n>TOOLTIP_MAA_DIALOG_COPY_ID}" icon="sap-icon://copy" /><MenuItem text="{i18n>MAA_DIALOG_DELETE_APPVAR}"\n\t\t\t\t\t\t\t\t\t\tenabled="{delAppVarButtonEnabled}"\n\t\t\t\t\t\t\t\t\t\tvisible="{delAppVarButtonVisibility}"\n\t\t\t\t\t\t\t\t\t\ttooltip="{parts: [{path: \'delAppVarButtonEnabled\'}, {path: \'isS4HanaCloud\'}], formatter:\'.formatDelButtonTooltip\'}"\n\t\t\t\t\t\t\t\t\t\ticon="sap-icon://delete" /></items></Menu></menu></MenuButton></cells></ColumnListItem></items></Table></mvc:View>',
	"sap/ui/rta/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.rta","type":"library","embeds":["appVariant/manageApps/webapp"],"applicationVersion":{"version":"1.120.31"},"title":"SAPUI5 library with RTA controls.","description":"SAPUI5 library with RTA controls.","ach":"CA-UI5-FL-RTA","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.120","libs":{"sap.ui.core":{"minVersion":"1.120.31"},"sap.ui.layout":{"minVersion":"1.120.31"},"sap.m":{"minVersion":"1.120.31"},"sap.ui.fl":{"minVersion":"1.120.31"},"sap.ui.dt":{"minVersion":"1.120.31"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":[],"elements":[],"types":[],"interfaces":[]}}}}',
	"sap/ui/rta/plugin/additionalElements/AddElementsDialog.fragment.xml":'<core:FragmentDefinition\n  xmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:layout="sap.ui.layout"><Dialog\n\t\tclass="sapUIRtaFieldRepositoryDialog sapUiNoContentPadding"\n\t\thorizontalScrolling="false"><buttons><Button\n\t\t\t\tid="rta_addDialogOkButton"\n\t\t\t\ttext="{i18n>BTN_FREP_OK}"\n\t\t\t\tpress="._submitDialog"\n\t\t\t\ttype="Emphasized"/><Button\n\t\t\t\ttext="{i18n>BTN_FREP_CANCEL}"\n\t\t\t\tpress="._cancelDialog"/></buttons><content><Toolbar><SearchField\n\t\t\t\t\twidth="100%"\n\t\t\t\t\tshowSearchButton="false"\n\t\t\t\t\tliveChange="._updateModelFilter"/><Button\n\t\t\t\t\ttext=""\n\t\t\t\t\ticon="sap-icon://sort"\n\t\t\t\t\tpress="._resortList"/><Button\n\t\t\t\t\tid="rta_customFieldButton"\n\t\t\t\t\ttext=""\n\t\t\t\t\ticon="sap-icon://add"\n\t\t\t\t\ttooltip="{/customFieldButtonTooltip}"\n\t\t\t\t\tenabled="{/customFieldEnabled}"\n\t\t\t\t\tvisible="{/customFieldVisible}"\n\t\t\t\t\tpress="._redirectToCustomFieldCreation"/></Toolbar><layout:VerticalLayout\n\t\t\t\tid="rta_businessContextContainer"\n\t\t\t\tclass="sapUIRtaBusinessContextContainer"\n\t\t\t\tvisible="{/businessContextVisible}"\n\t\t\t\tcontent="{/businessContextTexts}"><Text text="{text}"/></layout:VerticalLayout><ScrollContainer\n\t\t\t\tclass="sapUIRtaCCDialogScrollContainer"\n\t\t\t\tvertical="true"\n\t\t\t\thorizontal="false"><List\n\t\t\t\t\tid="rta_addElementsDialogList"\n\t\t\t\t\tmode="MultiSelect"\n\t\t\t\t\tincludeItemInSelection="true"\n\t\t\t\t\tgrowing="true"\n\t\t\t\t\tgrowingScrollToLoad="true"\n\t\t\t\t\titems="{ path: \'/elements\', sorter: { path: \'label\', descending: false}, templateShareable: false }"\n\t\t\t\t\tnoDataText="{i18n>MSG_NO_FIELDS}"><CustomListItem\n\t\t\t\t\t\tclass="sapUIRtaListItem"\n\t\t\t\t\t\ttype="Active"\n\t\t\t\t\t\tselected="{selected}"\n\t\t\t\t\t\ttooltip="{tooltip}"><VBox><Label\n\t\t\t\t\t\t\t\tdesign="Standard"\n\t\t\t\t\t\t\t\ttext="{= ${parentPropertyName} &amp;&amp; ${duplicateName} ? ${label} + \' (\' + ${parentPropertyName} + \')\' : ${label} }"/><Label\n\t\t\t\t\t\t\t\ttext="{= ${originalLabel} ? ${i18n>LBL_FREP}.replace(\'{0}\', ${originalLabel}) : \'\'}"\n\t\t\t\t\t\t\t\tvisible="{= !!${originalLabel} }"/></VBox></CustomListItem></List></ScrollContainer></content></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/plugin/iframe/AddIFrameDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns:core="sap.ui.core"\n\t\txmlns="sap.m"\n\t\txmlns:form="sap.ui.layout.form"\n\t\txmlns:util="sap.ui.fl.util"\n\t\txmlns:layout="sap.ui.layout"><Dialog\n\t\tid="sapUiRtaAddIFrameDialog"\n\t\ttitle="{/text/dialogTitle}"\n\t\tverticalScrolling="true"\n\t\tresizable="false"\n\t\tclass="sapUiRtaAddIFrameDialog"\n\t\tdraggable="true"\n\t\tvalidationSuccess="onValidationSuccess"\n\t\tvalidationError="onValidationError"\n\t\tparseError="onValidationError"\n\t\tcontentWidth="50rem"\n\t\tcontentHeight="44rem"\n\t\tcore:require="{ FloatType: \'sap/ui/model/type/Float\' }"\n\t\tafterOpen="configureMultiInput"\n\t><content><layout:VerticalLayout\n\t\t\t\t\tid="sapUiRtaAddIFrameDialog_VL"\n\t\t\t\t\twidth="100%"\n\t\t\t\t\tclass="sapUiRtaAddIFrameDialogVlWrapper"><VBox visible="{/asContainer/value}" class="sapUiRtaAddIFrameDialogContainerTitleVBox" renderType="Bare"><items><Label\n\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_ContainerTitleLabel"\n\t\t\t\t\t\t\ttext="{/text/containerTitleLabel}"\n\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogContainerTitleLabel"\n\t\t\t\t\t\t\tdesign="Bold"\n\t\t\t\t\t\t/><Input\n\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_ContainerTitle_TitleInput"\n\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogContainerTitleInput"\n\t\t\t\t\t\t\tvalue="{\n\t\t\t\t\t\t\t\tpath : \'/title/value\',\n\t\t\t\t\t\t\t\ttype : \'sap.ui.model.type.String\'\n\t\t\t\t\t\t\t}"\n\t\t\t\t\t\t\tliveChange=".onContainerTitleChange"\n\t\t\t\t\t\t\tvalueLiveUpdate="true"\n\t\t\t\t\t\t\tvalueState="{/title/valueState}"\n\t\t\t\t\t\t/></items></VBox><VBox><items><Label id="sapUiRtaAddIFrameDialog_SizeTitle" text="{/text/sizeTitle}" class="sapUiRtaAddIFrameDialogSizeTitle" design="Bold"/><layout:Grid\n\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_SizeGrid"\n\t\t\t\t\t\t\t\tcontainerQuery="true" position="Center"\n\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogSizeGrid"\n\t\t\t\t\t\t\t\tdefaultSpan="XL6 L6 M6 S12"><form:SimpleForm\n\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_WidthForm" editable="true" layout="ResponsiveGridLayout" class="sapUiRtaAddIFrameDialogWidthForm"\n\t\t\t\t\t\t\t\t\tadjustLabelSpan="false" singleContainerFullSize="false" ariaLabelledBy="sapUiRtaAddIFrameDialog_WidthLabel"\n\t\t\t\t\t\t\t\t\tlabelSpanXL="2" labelSpanL="2" labelSpanM="2" labelSpanS="4"\n\t\t\t\t\t\t\t\t\temptySpanXL="2" emptySpanL="2" emptySpanM="2" emptySpanS="0"\n\t\t\t\t\t\t\t><form:content><Label id="sapUiRtaAddIFrameDialog_WidthLabel" class="sapUiRtaAddIFrameDialogWidthLabel" labelFor="sapUiRtaAddIFrameDialog_WidthInput"\n\t\t\t\t\t\t\t\t\t\ttext="{/text/widthLabel}"></Label><Input id="sapUiRtaAddIFrameDialog_WidthInput" class="sapUiRtaAddIFrameDialogWidthInput"\n\t\t\t\t\t\t\t\t\t\tvalue="{path: \'/frameWidth/value\', type: \'FloatType\', constraints: {minimum: 1}}"\n\t\t\t\t\t\t\t\t\t\tvalueState="{/frameWidth/valueState}"/><Select\n\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_WidthUnit"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogWidthUnit"\n\t\t\t\t\t\t\t\t\t\tariaLabelledBy="sapUiRtaAddIFrameDialog_WidthUnitLabel"\n\t\t\t\t\t\t\t\t\t\tselectedKey="{/frameWidthUnit/value}"\n\t\t\t\t\t\t\t\t\t\titems="{/unitsOfWidthMeasure}"\n\t\t\t\t\t\t\t\t\t\tshowSecondaryValues= "true"\n\t\t\t\t\t\t\t\t\t\tcolumnRatio="1:5"\n\t\t\t\t\t\t\t\t\t\twidth="auto"\n\t\t\t\t\t\t\t\t\t\tmaxWidth="400px"><core:ListItem key="{unit}" text="{unit}" additionalText="{descriptionText}"/></Select></form:content></form:SimpleForm><form:SimpleForm\n\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_HeightForm" editable="true" layout="ResponsiveGridLayout" class="sapUiRtaAddIFrameDialogHeightForm"\n\t\t\t\t\t\t\t\t\tadjustLabelSpan="false" singleContainerFullSize="false" ariaLabelledBy="sapUiRtaAddIFrameDialog_HeightLabel"\n\t\t\t\t\t\t\t\t\tlabelSpanXL="2" labelSpanL="2" labelSpanM="2" labelSpanS="4"\n\t\t\t\t\t\t\t\t\temptySpanXL="2" emptySpanL="2" emptySpanM="2" emptySpanS="0"\n\t\t\t\t\t\t\t><form:content><Label id="sapUiRtaAddIFrameDialog_HeightLabel" class="sapUiRtaAddIFrameDialogHeightLabel" labelFor="sapUiRtaAddIFrameDialog_HeightInput"\n\t\t\t\t\t\t\t\t\t\ttext="{/text/heightLabel}"/><Input id="sapUiRtaAddIFrameDialog_HeightInput" class="sapUiRtaAddIFrameDialogHeightInput"\n\t\t\t\t\t\t\t\t\t\tvalue="{path: \'/frameHeight/value\', type: \'FloatType\', constraints: {minimum: 1}}"\n\t\t\t\t\t\t\t\t\t\tvalueState="{/frameHeight/valueState}"/><Select\n\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_HeightUnit"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogHeightUnit"\n\t\t\t\t\t\t\t\t\t\tariaLabelledBy="sapUiRtaAddIFrameDialog_HeightUnitLabel"\n\t\t\t\t\t\t\t\t\t\tselectedKey="{/frameHeightUnit/value}"\n\t\t\t\t\t\t\t\t\t\tforceSelection="false"\n\t\t\t\t\t\t\t\t\t\titems="{/unitsOfHeightMeasure}"\n\t\t\t\t\t\t\t\t\t\tshowSecondaryValues= "true"\n\t\t\t\t\t\t\t\t\t\tcolumnRatio="1:5"\n\t\t\t\t\t\t\t\t\t\twidth="auto"\n\t\t\t\t\t\t\t\t\t\tmaxWidth="400px"><core:ListItem key="{unit}" text="{= ${unit} === \'vh\' ? \'%\' : ${unit}}" additionalText="{descriptionText}"/></Select></form:content></form:SimpleForm></layout:Grid></items></VBox><layout:Grid\n\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_PercentGrid"\n\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPercentGrid"\n\t\t\t\t\t\tcontainerQuery="true"\n\t\t\t\t\t\tposition="Right"\n\t\t\t\t\t\tdefaultSpan="XL12 L12 M12 S12"><Text id="sapUiRtaAddIFrameDialog_PercentText" text="{/text/percentUseLabel}" class="sapUiRtaAddIFrameDialogPercentText"/></layout:Grid><layout:Grid\n\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_EditGrid"\n\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogEditGrid"\n\t\t\t\t\t\tcontainerQuery="true"\n\t\t\t\t\t\tdefaultSpan="XL6 L6 M6 S12"><VBox id="sapUiRtaAddIFrameDialog_Parameters" class="sapUiRtaAddIFrameDialogParameters" renderType="Bare"><items><Label id="sapUiRtaAddIFrameDialog_ParametersLabel" text="{/text/parametersLabel}" labelFor="sapUiRtaAddIFrameDialog_ParameterTable"\n\t\t\t\t\t\t\t\t   class="sapUiRtaAddIFrameDialogParametersLabel" design="Bold"/><SearchField\n\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_ParametersSearch"\n\t\t\t\t\t\t\t\tariaLabelledBy="sapUiRtaAddIFrameDialog_ParameterSearchLabel"\n\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogParametersSearch"\n\t\t\t\t\t\t\t\tliveChange="onLiveChange"\n\t\t\t\t\t\t\t\tshowSearchButton="false"\n\t\t\t\t\t\t\t/><ScrollContainer height="12rem" vertical="true" ><Table id="sapUiRtaAddIFrameDialog_ParameterTable" items="{/parameters/value}" ariaLabelledBy="sapUiRtaAddIFrameDialog_ParametersLabel"\n\t\t\t\t\t\t\t\t\t   class="sapUiSizeCompact sapUiRtaAddIFrameDialogParameterTable" sticky="ColumnHeaders"><columns><Column><header><Label id="sapUiRtaAddIFrameDialog_ParameterLabel" class="sapUiRtaAddIFrameDialogParameterLabel" text="{/text/columnParameterLabel}"/></header></Column><Column><header><Label id="sapUiRtaAddIFrameDialog_ValueLabel" class="sapUiRtaAddIFrameDialog_ValueLabel" text="{/text/columnUiValueLabel}"/></header></Column></columns><items><ColumnListItem type="Active" press="onParameterPress"><cells><Text text="{label}"/><Text text="{value}" wrapping="false"/></cells></ColumnListItem></items></Table></ScrollContainer></items></VBox><VBox id="sapUiRtaAddIFrameDialog_EditUrl" class="sapUiRtaAddIFrameDialogEditUrl" renderType="Bare"><items><Label id="sapUiRtaAddIFrameDialog_EditUrlLabel" labelFor="sapUiRtaAddIFrameDialog_EditUrlTA"\n\t\t\t\t\t\t\t\t   class="sapUiRtaAddIFrameDialogEditUrlLabel" text="{/text/editUrlLabel}" design="Bold" /><TextArea id="sapUiRtaAddIFrameDialog_EditUrlTA" ariaLabelledBy="sapUiRtaAddIFrameDialog_EditUrlLabel"\n\t\t\t\t\t\t\t\t\t  class="sapUiRtaAddIFrameDialog_EditUrlTA"\n\t\t\t\t\t\t\t\t\t  valueLiveUpdate="true" value="{/frameUrl/value}" liveChange="onUrlChange" rows="11" width="100%" /></items></VBox></layout:Grid><layout:Grid\n\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_UrlWarningGrid"\n\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogUrlWarningGrid"\n\t\t\t\t\t\tcontainerQuery="true"\n\t\t\t\t\t\tdefaultSpan="XL12 L12 M12 S12"><FormattedText\n\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_DocumentationLink"\n\t\t\t\t\t\t\thtmlText="{/documentationLink/HTML}" class="sapUiRtaAddIFrameDialogDocumentationLink"/></layout:Grid><layout:Grid\n\t\t\t\t\tid="sapUiRtaAddIFrameDialog_PreviewLinkGrid"\n\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewLinkGrid"\n\t\t\t\t\tcontainerQuery="true"\n\t\t\t\t\tdefaultSpan="XL12 L12 M12 S12"><Panel id="sapUiRtaAddIFrameDialog_PreviewLinkPanel"\n\t\t\t\t\t\t   expandable="true" width="auto" expanded="false"\n\t\t\t\t\t\t   class="sapUiResponsiveMargin sapUiRtaAddIFrameDialogPreviewLinkPanel"><headerToolbar><OverflowToolbar\n\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_PreviewLinkToolbar"\n\t\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewLinkToolbar" height="3rem" style="Clear"><Title\n\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_PreviewLinkTitle"\n\t\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewLinkTitle"\n\t\t\t\t\t\t\t\t\ttext="{/text/previewUrlLabel}" /><ToolbarSpacer /><Button\n\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_PreviewButton"\n\t\t\t\t\t\t\t\t\tenabled="{=${/previewUrl/value} !== ${/frameUrl/value} || ${/previewUseLegacyNavigation/value} !== ${/useLegacyNavigation/value} || ${/settingsUpdate/value}}"\n\t\t\t\t\t\t\t\t\ttext="{=${/previewUrl/value} === \'\' ? ${/text/showPreviewButton} : ${/text/updatePreviewButton} }"\n\t\t\t\t\t\t\t\t\tpress="onShowPreview"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginTop sapUiRtaAddIFrameDialogPreviewButton" /></OverflowToolbar></headerToolbar><content><Link\n\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_PreviewLink"\n\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewLink"\n\t\t\t\t\t\t\t\thref="{/previewUrl/value}" text="{/previewUrl/value}" wrapping="true" visible="{= !!${/previewUrl/value} }" target="_blank" /></content></Panel></layout:Grid><layout:Grid\n\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_PreviewGrid"\n\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewGrid"\n\t\t\t\t\t\tcontainerQuery="true"\n\t\t\t\t\t\tdefaultSpan="XL12 L12 M12 S12"><VBox\n\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_PreviewGridVB"\n\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewGridVB"\n\t\t\t\t\t\trenderType="Bare"><layoutData><FlexItemData growFactor="1"/></layoutData><items><Label\n\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_NoPreviewLabel"\n\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogNoPreviewLabel" wrapping="true"\n\t\t\t\t\t\t\t\ttext="{/text/previewUrlMessage}" textAlign="Center" visible="{= !${/previewUrl/value} }" /><util:IFrame\n\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_PreviewFrame"\n\t\t\t\t\t\t\t\t\theight="100%"\n\t\t\t\t\t\t\t\t\ttitle="{/text/previewFrameLabel}"\n\t\t\t\t\t\t\t\t\tuseLegacyNavigation="{/previewUseLegacyNavigation/value/}"\n\t\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewFrame"\n\t\t\t\t\t\t\t\t\tvisible="{= !!${/previewUrl/value} }"\n\t\t\t\t\t\t\t\t\tadvancedSettings="{/advancedSettings/value}" /></items></VBox></layout:Grid><layout:Grid\n\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewLinkGrid"\n\t\t\t\t\tcontainerQuery="true"\n\t\t\t\t\tdefaultSpan="XL12 L12 M12 S12"><Panel\n\t\t\t\t\t\texpandable="true"\n\t\t\t\t\t\twidth="auto"\n\t\t\t\t\t\texpanded="false"\n\t\t\t\t\t\tclass="sapUiResponsiveMargin sapUiRtaAddIFrameDialogPreviewLinkPanel"><headerToolbar><OverflowToolbar\n\t\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewLinkToolbar" height="3rem" style="Clear"><Title\n\t\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewLinkTitle"\n\t\t\t\t\t\t\t\t\ttext="{/text/advancedSettingsTitle}" /><ToolbarSpacer /></OverflowToolbar></headerToolbar><content><HBox\n\t\t\t\t\t\t\t\talignItems="Center"\n\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogLegacyNavigationContainer sapUiLargeMarginBottom"><Switch\n\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_UseLegacyNavigationToggle"\n\t\t\t\t\t\t\t\t\tcustomTextOn=" "\n\t\t\t\t\t\t\t\t\tcustomTextOff=" "\n\t\t\t\t\t\t\t\t\tstate="{/useLegacyNavigation/value}" /><Label\n\t\t\t\t\t\t\t\t\ttext="{/text/useLegacyNavigationLabel}" /><Button\n\t\t\t\t\t\t\t\t\ticon="sap-icon://hint"\n\t\t\t\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\t\t\t\tpress="onLegacyNavigationInfoPress"\n\t\t\t\t\t\t\t\t\tariaHasPopup="Dialog" /></HBox><MessageStrip\n\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_SecurityWarningMessage"\n\t\t\t\t\t\t\t\ttext="{/text/additionalParametersSecurityWarningText}"\n\t\t\t\t\t\t\t\ttype="Warning"\n\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\tshowCloseButton="true"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"><link><Link text="{/text/additionalParametersWarningMoreInfoText}"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\t\thref="https://developer.mozilla.org/en-US/docs/Web/HTML/Element/iframe#sandbox"/></link></MessageStrip><form:Form editable="true"><form:layout><form:ResponsiveGridLayout\n\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_SanboxPropertiesForm"\n\t\t\t\t\t\t\t\t\t\tadjustLabelSpan="false" singleContainerFullSize="false"\n\t\t\t\t\t\t\t\t\t\tlabelSpanXL="6" labelSpanL="6" labelSpanM="6" labelSpanS="12"\n\t\t\t\t\t\t\t\t\t\tcolumnsXL="2" columnsL="2" columnsM="2"/></form:layout><form:FormContainer><form:FormElement label="allow-forms"><Switch\n\t\t\t\t\t\t\t\t\t\t\t\t\tchange="onSwitchChange"\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_allowFormsSwitch"\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOn=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOff=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{/advancedSettings/value/allowForms}" /></form:FormElement><form:FormElement label="allow-scripts"><Switch\n\t\t\t\t\t\t\t\t\t\t\t\t\tchange="onSwitchChange"\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_allowScriptsSwitch"\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOn=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOff=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{/advancedSettings/value/allowScripts}" /></form:FormElement><form:FormElement label="allow-same-origin"><Switch\n\t\t\t\t\t\t\t\t\t\t\t\t\tchange="onSwitchChange"\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_allowSameOriginSwitch"\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOn=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOff=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{/advancedSettings/value/allowSameOrigin}" /></form:FormElement><form:FormElement label="allow-popups"><Switch\n\t\t\t\t\t\t\t\t\t\t\t\t\tchange="onSwitchChange"\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_allowPopupsSwitch"\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOn=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOff=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{/advancedSettings/value/allowPopups}" /></form:FormElement><form:FormElement label="allow-modals"><Switch\n\t\t\t\t\t\t\t\t\t\t\t\t\tchange="onSwitchChange"\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_allowModalsSwitch"\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOn=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOff=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{/advancedSettings/value/allowModals}" /></form:FormElement></form:FormContainer><form:FormContainer><form:FormElement label="allow-top-navigation"><Switch\n\t\t\t\t\t\t\t\t\t\t\t\t\tchange="onSwitchChange"\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_allowTopNavigationSwitch"\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOn=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOff=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{/advancedSettings/value/allowTopNavigation}" /></form:FormElement><form:FormElement label="allow-downloads"><Switch\n\t\t\t\t\t\t\t\t\t\t\t\t\tchange="onSwitchChange"\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_allowDownloadsSwitch"\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOn=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOff=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{/advancedSettings/value/allowDownloads}" /></form:FormElement><form:FormElement label="allow-downloads-without-user-activation"><Switch\n\t\t\t\t\t\t\t\t\t\t\t\t\tchange="onSwitchChange"\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_allowDownloadsWithoutUserActivationSwitch"\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOn=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOff=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{/advancedSettings/value/allowDownloadsWithoutUserActivation}" /></form:FormElement><form:FormElement><Label\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_AddAdditionalParametersLabel"\n\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginTop"\n\t\t\t\t\t\t\t\t\t\t\t\t\ttext="{/text/additionalSandboxParametersLabel}"\n\t\t\t\t\t\t\t\t\t\t\t\t\tlabelFor="sapUiRtaAddIFrameDialog_AddAdditionalParametersInput" /></form:FormElement><form:FormElement><MultiInput\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_AddAdditionalParametersInput"\n\t\t\t\t\t\t\t\t\t\t\t\t\tplaceholder="{/text/additionalSandboxParametersPlaceholder}"\n\t\t\t\t\t\t\t\t\t\t\t\t\tshowValueHelp="false"\n\t\t\t\t\t\t\t\t\t\t\t\t\ttokenUpdate="onTokenUpdate"\n\t\t\t\t\t\t\t\t\t\t\t\t\ttokens="{/advancedSettings/value/additionalSandboxParameters}"\n\t\t\t\t\t\t\t\t\t\t\t\t\tariaLabelledBy="sapUiRtaAddIFrameDialog_AddAdditionalParametersLabel"><tokens><Token text="{}" key="{}"/></tokens></MultiInput></form:FormElement></form:FormContainer></form:Form></content></Panel></layout:Grid></layout:VerticalLayout><core:InvisibleText id="sapUiRtaAddIFrameDialog_WidthUnitLabel" text="{/text/widthUnitLabel}"/><core:InvisibleText id="sapUiRtaAddIFrameDialog_HeightUnitLabel" text="{/text/heightUnitLabel}"/><core:InvisibleText id="sapUiRtaAddIFrameDialog_ParameterSearchLabel" text="{/text/parameterSearchLabel}"/></content><beginButton><Button\n\t\t\t\tid="sapUiRtaAddIFrameDialogSaveButton"\n\t\t\t\tclass="sapUiRtaAddIFrameDialogSaveButton"\n\t\t\t\ttype="Emphasized"\n\t\t\t\ttext="{/text/saveText}"\n\t\t\t\tpress="onSavePress"\n\t\t\t\tenabled="{= !!${/frameUrl/value} }"\n\t\t\t/></beginButton><endButton><Button\n\t\t\t\tid="sapUiRtaAddIFrameDialogCancelButton"\n\t\t\t\tclass="sapUiRtaAddIFrameDialogCancelButton"\n\t\t\t\ttype="Transparent"\n\t\t\t\ttext="{/text/cancelText}"\n\t\t\t\tpress="onCancelPress"\n\t\t\t/></endButton></Dialog></core:FragmentDefinition>\n',
	"sap/ui/rta/toolbar/ActionsMenu.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"><Menu\n\t\t\tid="sapUiRta_actions"\n\t\t\tclass="sapUiRtaToolbarVisualizationSelection"><MenuItem\n\t\t\t\tid="sapUiRta_translateMenu"\n\t\t\t\ticon="sap-icon://translate"\n\t\t\t\tvisible="{= ${controls>/translation/visible}}"\n\t\t\t\tenabled="{controls>/translation/enabled}"\n\t\t\t\ttooltip="{i18n>BTN_TRANSLATE}"\n\t\t\t\ttext="{i18n>BTN_TRANSLATE}" ><items><MenuItem\n\t\t\t\t\t\ttext="{i18n>BTN_OPEN_DOWNLOAD_TRANSLATION}"\n\t\t\t\t\t\tpress=".openDownloadTranslationDialog"\n\t\t\t\t\t\ticon="sap-icon://download"/><MenuItem\n\t\t\t\t\t\ttext="{i18n>BTN_OPEN_UPLOAD_TRANSLATION}"\n\t\t\t\t\t\tpress=".openUploadTranslationDialog"\n\t\t\t\t\t\tenabled="{= ${translation>/sourceLanguages}.length > 0}"\n\t\t\t\t\t\ticon="sap-icon://upload"/></items></MenuItem><MenuItem\n\t\t\t\tid="sapUiRta_appVariantMenu"\n\t\t\t\ticon="sap-icon://BusinessSuiteInAppSymbols/icon-variant-configuration"\n\t\t\t\tenabled="{controls>/appVariantMenu/enabled}"\n\t\t\t\tvisible="{= (${controls>/appVariantMenu/visible} &amp;&amp; ${controls>/modeSwitcher} === \'adaptation\')}"\n\t\t\t\ttext="{i18n>BTN_MANAGE_APPS_TXT}" ><items><MenuItem\n\t\t\t\t\t\tid="sapUiRta_appVariantOverview"\n\t\t\t\t\t\ticon="sap-icon://action-settings"\n\t\t\t\t\t\tenabled="{controls>/appVariantMenu/overview/enabled}"\n\t\t\t\t\t\tvisible="{= (${controls>/appVariantMenu/overview/visible} &amp;&amp; ${controls>/modeSwitcher} === \'adaptation\')}"\n\t\t\t\t\t\ttext="{i18n>BTN_MANAGE_APPS_ITEM}" ><items><MenuItem\n\t\t\t\t\t\t\t\tid="sapUiRta_keyUser"\n\t\t\t\t\t\t\t\tpress=".overviewForKeyUser"\n\t\t\t\t\t\t\t\ticon="sap-icon://key-user-settings"\n\t\t\t\t\t\t\t\ttext="{i18n>MENU_ITEM_KEY_USER}" /><MenuItem\n\t\t\t\t\t\t\t\tid="sapUiRta_developer"\n\t\t\t\t\t\t\t\tpress=".overviewForDeveloper"\n\t\t\t\t\t\t\t\ticon="sap-icon://developer-settings"\n\t\t\t\t\t\t\t\ttext="{i18n>MENU_ITEM_SAP_DEVELOPER}" /></items></MenuItem><MenuItem\n\t\t\t\t\t\tid="sapUiRta_manageApps"\n\t\t\t\t\t\ticon="sap-icon://action-settings"\n\t\t\t\t\t\tpress=".manageApps"\n\t\t\t\t\t\tenabled="{controls>/appVariantMenu/manageApps/enabled}"\n\t\t\t\t\t\tvisible="{= (${controls>/appVariantMenu/manageApps/visible} &amp;&amp; ${controls>/modeSwitcher} === \'adaptation\')}"\n\t\t\t\t\t\ttext="{i18n>BTN_MANAGE_APPS_ITEM}" /><MenuItem\n\t\t\t\t\t\tid="sapUiRta_saveAs"\n\t\t\t\t\t\tvisible="{= (${controls>/appVariantMenu/saveAs/visible} &amp;&amp; ${controls>/modeSwitcher} === \'adaptation\')}"\n\t\t\t\t\t\tenabled="{parts: [\'controls>/appVariantMenu/saveAs/enabled\', \'versions>/displayedVersion\'], formatter: \'.formatSaveAsEnabled\'}"\n\t\t\t\t\t\tpress=".saveAs"\n\t\t\t\t\t\ticon="sap-icon://copy"\n\t\t\t\t\t\ttext="{i18n>BTN_SAVE_AS}" /></items></MenuItem><MenuItem\n\t\t\t\tid="sapUiRta_restore"\n\t\t\t\ticon="sap-icon://reset"\n\t\t\t\tenabled="{controls>/restore/enabled}"\n\t\t\t\tvisible="{= (${controls>/restore/visible} &amp;&amp; ((${controls>/modeSwitcher} === \'visualization\') || (${controls>/modeSwitcher} === \'adaptation\')))}"\n\t\t\t\tpress=".restore"\n\t\t\t\ttext="{i18n>BTN_RESTORE}" /></Menu></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/Adaptation.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:toolbar="sap.ui.rta.toolbar"><HBox\n\t\t\tid="sapUiRta_toolbarIconAndDraftSection"\n\t\t\tclass="sapUiRtaToolbarIconAndDraftSection" ><OverflowToolbar\n\t\t\tid="sapUiRta_iconAndDraftToolbar"\n\t\t\tclass="sapUiRtaIconAndDraftToolbar"><content><HBox id="sapUiRta_iconBox" /><ToolbarSpacer\n\t\t\t\t\t\tid="sapUiRta_iconSpacer"\n\t\t\t\t\t\twidth="0%"\n\t\t\t\t\t\tvisible="true" /><Button\n\t\t\t\t\t\tid="sapUiRta_versionButton"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\tclass="sapUiRtaVersionButton"\n\t\t\t\t\t\ticon="sap-icon://megamenu"\n\t\t\t\t\t\ticonFirst="false"\n\t\t\t\t\t\tvisible="{= (${versions>/versioningEnabled} &amp;&amp; ${controls>/modeSwitcher} === \'adaptation\')}"\n\t\t\t\t\t\ttext="{parts: [{path: \'versions>/versions\'}, {path: \'versions>/displayedVersion\'}], formatter: \'.formatVersionButtonText\'}"\n\t\t\t\t\t\ttooltip="{parts: [{path: \'versions>/versions\'}, {path: \'versions>/displayedVersion\'}], formatter: \'.formatVersionButtonText\'}"\n\t\t\t\t\t\tpress=".showVersionHistory"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></Button><toolbar:OverflowToolbarButton\n\t\t\t\t\t\tid="sapUiRta_activate"\n\t\t\t\t\t\ticon="sap-icon://activate"\n\t\t\t\t\t\tpress=".activate(${versions>/displayedVersion})"\n\t\t\t\t\t\tvisible="{= (${versions>/versioningEnabled} &amp;&amp; ${controls>/modeSwitcher} === \'adaptation\')}"\n\t\t\t\t\t\tenabled="{versions>/activateEnabled}"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\ttext="{i18n>TOL_ACTIVATE}"\n\t\t\t\t\t\ttooltip="{i18n>TOL_ACTIVATE}" /><toolbar:OverflowToolbarButton\n\t\t\t\t\t\tid="sapUiRta_discardDraft"\n\t\t\t\t\t\ticon="sap-icon://delete"\n\t\t\t\t\t\tpress=".discardDraft"\n\t\t\t\t\t\tvisible="{parts: [\'versions>/displayedVersion\', \'versions>/versioningEnabled\', \'controls>/modeSwitcher\' ], formatter: \'.formatDiscardDraftVisible\'}"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\ttext="{i18n>TOL_DISCARD_DRAFT}"\n\t\t\t\t\t\ttooltip="{i18n>TOL_DISCARD_DRAFT}" /><toolbar:OverflowToolbarButton\n\t\t\t\t\t\tid="sapUiRta_publishVersion"\n\t\t\t\t\t\tenabled="{versions>/publishVersionEnabled}"\n\t\t\t\t\t\tvisible="{parts: [\'versions>/publishVersionVisible\', \'versions>/versioningEnabled\', \'versions>/displayedVersion\', \'controls>/modeSwitcher\'], formatter: \'.formatPublishVersionVisibility\'}"\n\t\t\t\t\t\tpress=".publishVersion"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\ticon="sap-icon://shipping-status"\n\t\t\t\t\t\ttooltip="{i18n>TOL_PUBLISH_VERSION}" /></content></OverflowToolbar></HBox><HBox\n\t\t\tid="sapUiRta_toolbarSwitcherSection"\n\t\t\tclass="sapUiRtaToolbarSwitcherSection" ><Toolbar><content><SegmentedButton\n\t\t\t\t\t\tid="sapUiRta_modeSwitcher"\n\t\t\t\t\t\tselectionChange=".modeChange"\n\t\t\t\t\t\tselectedKey="{controls>/modeSwitcher}"\n\t\t\t\t\t\twidth="auto" ><items><SegmentedButtonItem\n\t\t\t\t\t\t\t\tid="sapUiRta_adaptationSwitcherButton"\n\t\t\t\t\t\t\t\ttext="{i18n>BTN_ADAPTATION}"\n\t\t\t\t\t\t\t\twidth="auto"\n\t\t\t\t\t\t\t\tkey="adaptation" /><SegmentedButtonItem\n\t\t\t\t\t\t\t\tid="sapUiRta_navigationSwitcherButton"\n\t\t\t\t\t\t\t\ttext="{i18n>BTN_NAVIGATION}"\n\t\t\t\t\t\t\t\twidth="auto"\n\t\t\t\t\t\t\t\tkey="navigation" /><SegmentedButtonItem\n\t\t\t\t\t\t\t\tid="sapUiRta_visualizationSwitcherButton"\n\t\t\t\t\t\t\t\tvisible="{controls>/visualizationButton/visible}"\n\t\t\t\t\t\t\t\ttext="{i18n>BTN_VISUALIZATION}"\n\t\t\t\t\t\t\t\twidth="auto"\n\t\t\t\t\t\t\t\tkey="visualization" /></items></SegmentedButton></content></Toolbar></HBox><HBox\n\t\t\tid="sapUiRta_toolbarActionsSection"\n\t\t\tclass="sapUiRtaToolbarActionsSection"\n\t\t\tjustifyContent="End" ><OverflowToolbar\n\t\t\t\tid="sapUiRta_actionsToolbar"\n\t\t\t\tclass="sapUiRtaActionsToolbar"><content><ToolbarSpacer /><Button\n\t\t\t\t\t\tid="sapUiRta_toggleChangeVisualizationMenuButton"\n\t\t\t\t\t\tvisible="{= ${controls>/modeSwitcher} === \'visualization\'}"\n\t\t\t\t\t\ttext="{visualizationModel>/changeCategoryText}"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\ticon="sap-icon://slim-arrow-down"\n\t\t\t\t\t\ticonFirst="false"\n\t\t\t\t\t\tpress=".openChangeCategorySelectionPopover"\n\t\t\t\t\t\ttooltip="{i18n>BUT_CHANGEVISUALIZATION_SELECTCHANGES}"/><Button\n\t\t\t\t\t\tid="sapUiRta_actionsMenu"\n\t\t\t\t\t\ticon="sap-icon://menu2"\n\t\t\t\t\t\tvisible="{= ${controls>/modeSwitcher} === \'adaptation\' &amp;&amp; (${controls>/translation/visible} || ${controls>/appVariantMenu/visible} || ${controls>/restore/visible})}"\n\t\t\t\t\t\tenabled="{controls>/actionsMenuButton/enabled}"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\ttooltip="{i18n>BTN_MENU}"\n\t\t\t\t\t\tpress=".showActionsMenu"\n\t\t\t\t\t\tariaHasPopup="Menu" ><layoutData><OverflowToolbarLayoutData priority="NeverOverflow" /></layoutData></Button><Button\n\t\t\t\t\t\tid="sapUiRta_undo"\n\t\t\t\t\t\ticon="sap-icon://undo"\n\t\t\t\t\t\tpress=".undo"\n\t\t\t\t\t\tenabled="{controls>/undo/enabled}"\n\t\t\t\t\t\tvisible="{= ${controls>/modeSwitcher} === \'adaptation\'}"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\ttooltip="{i18n>BTN_UNDO}" ><layoutData><OverflowToolbarLayoutData priority="NeverOverflow" /></layoutData></Button><Button\n\t\t\t\t\t\tid="sapUiRta_redo"\n\t\t\t\t\t\ticon="sap-icon://redo"\n\t\t\t\t\t\tpress=".redo"\n\t\t\t\t\t\tenabled="{controls>/redo/enabled}"\n\t\t\t\t\t\tvisible="{= ${controls>/modeSwitcher} === \'adaptation\'}"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\ttooltip="{i18n>BTN_REDO}" ><layoutData><OverflowToolbarLayoutData priority="NeverOverflow" /></layoutData></Button><MenuButton\n\t\t\t\t\t\tid="sapUiRta_contextBasedAdaptationMenu"\n\t\t\t\t\t\ttooltip="{parts: [{path: \'contextBasedAdaptations>/count\'}, {path: \'contextBasedAdaptations>/displayedAdaptation/title\'}], formatter: \'.formatAdaptationsMenuText\'}"\n\t\t\t\t\t\ttext="{parts: [{path: \'contextBasedAdaptations>/count\'}, {path: \'contextBasedAdaptations>/displayedAdaptation/title\'}], formatter: \'.formatAdaptationsMenuText\'}"\n\t\t\t\t\t\tvisible="{= (${controls>/contextBasedAdaptation/visible} &amp;&amp; ${controls>/modeSwitcher} === \'adaptation\')}"><Menu><MenuItem\n\t\t\t\t\t\t\t\tid="sapUiRta_saveAsAdaptation"\n\t\t\t\t\t\t\t\ttext="{i18n>SAC_DIALOG_HEADER}"\n\t\t\t\t\t\t\t\tpress=".saveAsAdaptation"\n\t\t\t\t\t\t\t\ticon="sap-icon://copy"/><MenuItem\n\t\t\t\t\t\t\t\tid="sapUiRta_editAdaptation"\n\t\t\t\t\t\t\t\tvisible="{= (${contextBasedAdaptations>/count} > 0 &amp;&amp; ${contextBasedAdaptations>/displayedAdaptation/title} !== \'\')}"\n\t\t\t\t\t\t\t\ttext="{i18n>EAC_DIALOG_HEADER}"\n\t\t\t\t\t\t\t\tpress=".editAdaptation"\n\t\t\t\t\t\t\t\ticon="sap-icon://edit"/><MenuItem\n\t\t\t\t\t\t\t\tid="sapUiRta_deleteAdaptation"\n\t\t\t\t\t\t\t\ttext="{i18n>DAC_DIALOG_HEADER}"\n\t\t\t\t\t\t\t\tpress=".deleteAdaptation"\n\t\t\t\t\t\t\t\tvisible="{= (${contextBasedAdaptations>/count} > 0 &amp;&amp; ${contextBasedAdaptations>/displayedAdaptation/title} !== \'\')}"\n\t\t\t\t\t\t\t\ticon="sap-icon://delete"/><MenuItem\n\t\t\t\t\t\t\t\tid="sapUiRta_manageAdaptations"\n\t\t\t\t\t\t\t\ttext="{i18n>MANAGE_ADAPTATIONS_DIALOG_HEADER}"\n\t\t\t\t\t\t\t\tpress=".manageAdaptations"\n\t\t\t\t\t\t\t\ticon="sap-icon://action-settings"/><MenuItem\n\t\t\t\t\t\t\t\tid="sapUiRta_switchAdaptations"\n\t\t\t\t\t\t\t\tvisible="{= (${contextBasedAdaptations>/count} > 0)}"\n\t\t\t\t\t\t\t\ttext="{i18n>BTN_SWITCH_ADAPTATIONS}"\n\t\t\t\t\t\t\t\ticon="sap-icon://switch-views"\n\t\t\t\t\t\t\t\titems="{contextBasedAdaptations>/allAdaptations}"><items><MenuItem\n\t\t\t\t\t\t\t\t\tid="sapUiRta_switchAdaptations_items"\n\t\t\t\t\t\t\t\t\tenabled="{= (${contextBasedAdaptations>id} !== ${contextBasedAdaptations>/displayedAdaptation/id}) }"\n\t\t\t\t\t\t\t\t\ticon="{= (${contextBasedAdaptations>id} === ${contextBasedAdaptations>/displayedAdaptation/id} ? \'sap-icon://accept\' : \'blank\')}"\n\t\t\t\t\t\t\t\t\ttext="{= (${contextBasedAdaptations>title} ? ${contextBasedAdaptations>title} : ${i18n>TXT_DEFAULT_APP})}"\n\t\t\t\t\t\t\t\t\tpress=".switchAdaptation(${contextBasedAdaptations>id})"/></items></MenuItem></Menu><layoutData><OverflowToolbarLayoutData priority="NeverOverflow" /></layoutData></MenuButton><Button\n\t\t\t\t\t\tid="sapUiRta_feedback"\n\t\t\t\t\t\ticon="sap-icon://feedback"\n\t\t\t\t\t\tpress=".showFeedbackForm"\n\t\t\t\t\t\tvisible="{controls>/feedbackButton/visible}"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\ttooltip="{i18n>BTN_FEEDBACK}" ><layoutData><OverflowToolbarLayoutData priority="NeverOverflow" /></layoutData></Button><toolbar:OverflowToolbarButton\n\t\t\t\t\t\tid="sapUiRta_save"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\tpress=".save"\n\t\t\t\t\t\tenabled="{controls>/save/enabled}"\n\t\t\t\t\t\ttooltip="{= ${versions>/versioningEnabled} ? ${i18n>BTN_SAVE_DRAFT} : ${i18n>BTN_SAVE} }"\n\t\t\t\t\t\ticon="sap-icon://save" ><toolbar:layoutData><OverflowToolbarLayoutData priority="High" /></toolbar:layoutData></toolbar:OverflowToolbarButton><toolbar:OverflowToolbarButton\n\t\t\t\t\t\tid="sapUiRta_exit"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\tpress=".exit"\n\t\t\t\t\t\ttooltip="{i18n>BTN_EXIT}"\n\t\t\t\t\t\ticon="sap-icon://decline" ><toolbar:layoutData><OverflowToolbarLayoutData priority="High" /></toolbar:layoutData></toolbar:OverflowToolbarButton></content></OverflowToolbar><layoutData><FlexItemData growFactor="0" /></layoutData></HBox></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/FeedbackDialog.fragment.xml":'<core:FragmentDefinition\n\txmlns:core="sap.ui.core"\n\txmlns="sap.m"\n\txmlns:util="sap.ui.fl.util"><Dialog\n\t\tid="sapUiRtaFeedbackIFrameDialog"\n\t\ttitle="{i18n>TIT_FEEDBACK}"\n\t\tcontentWidth="50rem"\n\t\tcontentHeight="50rem"\n\t\tdraggable="true"><content><util:IFrame\n\t\t\t\tid="sapUiRtaFeedbackIFrameDialog_iFrame"\n\t\t\t\turl="{feedbackModel>/url}"\n\t\t\t\theight="46rem"/></content><buttons><Button\n\t\t\t\tid="sapUiRtaFeedbackIFrameDialog_ButtonClose"\n\t\t\t\ttext="{i18n>BTN_CLOSE_FEEDBACK_DIALOG}"\n\t\t\t\tpress=".closeFeedbackForm"/></buttons></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/contextBased/ManageAdaptationsDialog.fragment.xml":'<core:FragmentDefinition\n\txmlns:core="sap.ui.core"\n\txmlns:dnd="sap.ui.core.dnd"\n\txmlns="sap.m"><Dialog\n\t\tresizable="true"\n\t\tdraggable="true"\n\t\tcontentWidth="830px"\n\t\tcontentHeight="450px"\n\t\tsetHorizontalScrolling="false"\n\t\ttitle="{i18n>MANAGE_ADAPTATIONS_DIALOG_HEADER}"><Table id="manageAdaptationsTable"\n\t\t\tshowNoData="false"\n\t\t\tinset="false"\n\t\t\tsticky="HeaderToolbar"\n\t\t\tmode="SingleSelectMaster"\n\t\t\titems="{\n\t\t\tpath: \'contextBased>/adaptations\',\n\t\t\tsorter: {path: \'rank\', descending: false}\n\t\t}"><headerToolbar><OverflowToolbar><SearchField id="searchField" liveChange=".onLiveSearch" width="80%" /><ToolbarSpacer/><Button id="moveUpButton"\n\t\t\t\t\t\ticon="sap-icon://navigation-up-arrow"\n\t\t\t\t\t\ttooltip="{i18n>BTN_TOOLTIP_MOVE_UP}"\n\t\t\t\t\t\tpress=".moveUp"\n\t\t\t\t\t\tenabled="false"/><Button id="moveDownButton"\n\t\t\t\t\t\ticon="sap-icon://navigation-down-arrow"\n\t\t\t\t\t\ttooltip="{i18n>BTN_TOOLTIP_MOVE_DOWN}"\n\t\t\t\t\t\tpress=".moveDown"\n\t\t\t\t\t\tenabled="false"/></OverflowToolbar></headerToolbar><columns><Column width="5rem"\n\t\t\t\t\tminScreenWidth="tablet"\n\t\t\t\t\tdemandPopin="true"\n\t\t\t\t\tpopinDisplay="Inline"\n\t\t\t\t\thAlign="Left"><Text text="{i18n>CLM_HEADER_PRIORITY}" /></Column><Column minScreenWidth="tablet"\n\t\t\t\t\tdemandPopin="true"\n\t\t\t\t\tpopinDisplay="Inline"\n\t\t\t\t\thAlign="Left"><Text text="{i18n>CLM_HEADER_ADAPTATIONS_TITLE}" /></Column><Column width="6rem"\n\t\t\t\t\tminScreenWidth="tablet"\n\t\t\t\t\tdemandPopin="true"\n\t\t\t\t\tpopinDisplay="Inline"\n\t\t\t\t\thAlign="Left"><Text text="{i18n>CLM_HEADER_CONTEXT}" /></Column><Column minScreenWidth="tablet"\n\t\t\t\t\tdemandPopin="true"\n\t\t\t\t\tpopinDisplay="Inline"\n\t\t\t\t\thAlign="Left"><Text text="{i18n>CLM_HEADER_ADAPTATIONS_CREATED_ON}" /></Column><Column minScreenWidth="tablet"\n\t\t\t\t\tdemandPopin="true"\n\t\t\t\t\tpopinDisplay="Inline"\n\t\t\t\t\thAlign="Left"><Text text="{i18n>CLM_HEADER_ADAPTATIONS_CHANGED_ON}" /></Column></columns><dragDropConfig><dnd:DragDropInfo sourceAggregation="items"\n\t\t\t\t\ttargetAggregation="items"\n\t\t\t\t\tdropPosition="Between"\n\t\t\t\t\tdrop=".onDropSelectedAdaptation"/></dragDropConfig><items><ColumnListItem><cells><Text text="{contextBased>rank}"/><Text wrapping="false" maxLines="1" text="{contextBased>title}"\n\t\t\t\t\t\t\t\t\ttooltip="{contextBased>title}"/><Text text="{ parts: [\'contextBased>contexts/role\'], formatter: \'.formatContextColumnCell\'}"\n\t\t\t\t\t\t\ttooltip="{ parts: [\'contextBased>contexts/role\'], formatter: \'.formatContextColumnTooltip\'}" /><Text text="{ parts: [\'contextBased>createdBy\', \'contextBased>createdAt\'], formatter: \'.formatCreatedChangedOnColumnCell\'}"/><Text text="{ parts: [\'contextBased>changedBy\', \'contextBased>changedAt\'], formatter: \'.formatCreatedChangedOnColumnCell\'}"/></cells></ColumnListItem></items></Table><Table id="defaultContext"><columns><Column width="4.195rem"\n\t\t\t\t\tminScreenWidth="tablet"\n\t\t\t\t\tdemandPopin="true"\n\t\t\t\t\tpopinDisplay="Inline"\n\t\t\t\t\thAlign="Left"></Column><Column minScreenWidth="tablet"\n\t\t\t\t\tdemandPopin="true"\n\t\t\t\t\tpopinDisplay="Inline"\n\t\t\t\t\thAlign="Left"></Column><Column width="8rem"\n\t\t\t\t\tminScreenWidth="tablet"\n\t\t\t\t\tdemandPopin="true"\n\t\t\t\t\tpopinDisplay="Inline"\n\t\t\t\t\thAlign="Left"></Column></columns><items><ColumnListItem highlight="Information"><cells><Text text=""/><CustomListItem><HBox><VBox class="sapUiSmallMarginTopBottom"><Text id="defaultApplicationTitle" text="{i18n>TXT_DEFAULT_APP}"/><FormattedText htmlText=""/></VBox></HBox></CustomListItem><Text text="" /></cells></ColumnListItem></items></Table><beginButton><Button id="manageAdaptations-saveButton"\n\t\t\t\tenabled="false"\n\t\t\t\ttype="Emphasized"\n\t\t\t\ttext="{i18n>APP_CTX_DIALOG_SAVE}"\n\t\t\t\ttooltip="{i18n>TOOLTIP_APP_CTX_DIALOG_SAVE}"\n\t\t\t\tpress=".onSaveReorderedAdaptations"/></beginButton><endButton><Button id="manageAdaptations-closeButton"\n\t\t\t\ttext="{i18n>APP_CTX_DIALOG_CANCEL}"\n\t\t\t\tpress=".onCancel"/></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/contextBased/SaveAsAdaptationDialog.fragment.xml":'<core:FragmentDefinition\n\txmlns:form="sap.ui.layout.form"\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"><Dialog id="selectContextsDialog"\n\t\tresizable="true"\n\t\tdraggable="true"\n\t\ttitle="{dialogModel>/title}"><Panel id="saveAdaptation-information-panel"><headerToolbar><Toolbar id="toolbar"><Label id="label"\n\t\t\t\t\t\ttext="Information"\n\t\t\t\t\t\tdesign="Bold"></Label></Toolbar></headerToolbar><form:Form id="saveAdaptation-form"\n\t\t\t\teditable="true"><form:layout><form:ResponsiveGridLayout labelSpanXL="3"\n\t\t\t\t\t\tlabelSpanL="3"\n\t\t\t\t\t\tlabelSpanM="3"\n\t\t\t\t\t\tlabelSpanS="12"\n\t\t\t\t\t\tadjustLabelSpan="false"\n\t\t\t\t\t\temptySpanXL="4"\n\t\t\t\t\t\temptySpanL="4"\n\t\t\t\t\t\temptySpanM="4"\n\t\t\t\t\t\temptySpanS="0"\n\t\t\t\t\t\tcolumnsXL="1"\n\t\t\t\t\t\tcolumnsL="1"\n\t\t\t\t\t\tcolumnsM="1"\n\t\t\t\t\t\tsingleContainerFullSize="false"/></form:layout><form:FormContainer><form:formElements><form:FormElement ><form:label><Label id="saveAdaptation-title-label"\n\t\t\t\t\t\t\t\t\ttext="{i18n>APP_DIALOG_TITLE_TEXT}"\n\t\t\t\t\t\t\t\t\trequired="true"></Label></form:label><Input id="saveAdaptation-title-input"\n\t\t\t\t\t\t\t\tvalue="{/title}"\n\t\t\t\t\t\t\t\tvalueLiveUpdate="true"\n\t\t\t\t\t\t\t\tliveChange=".onAdaptationTitleChange"\n\t\t\t\t\t\t\t\tplaceholder="{i18n>SAVE_AS_DIALOG_PLACEHOLDER_TITLE_TEXT}"></Input></form:FormElement><form:FormElement ><form:label><Label id="saveAdaptation-rank-label"\n\t\t\t\t\t\t\t\t\ttext="{i18n>CLM_HEADER_PRIORITY}"\n\t\t\t\t\t\t\t\t\trequired="true"></Label></form:label><Select\n\t\t\t\t\t\t\t\t\tid="saveAdaptation-rank-select"\n\t\t\t\t\t\t\t\t\tforceSelection="true"\n\t\t\t\t\t\t\t\t\tselectedKey="{dialogModel>/selected}"\n\t\t\t\t\t\t\t\t\titems="{dialogModel>/priority}"\n\t\t\t\t\t\t\t\t\tchange=".onPriorityChange"><core:Item key="{dialogModel>key}" text="{dialogModel>title}" /></Select></form:FormElement></form:formElements></form:FormContainer></form:Form></Panel><beginButton><Button id="saveAdaptation-saveButton"\n\t\t\t\ttype="Emphasized"\n\t\t\t\ttext="{i18n>APP_CTX_DIALOG_SAVE}"\n\t\t\t\tpress=".onSaveAsAdaptation"/></beginButton><endButton><Button id="saveAdaptation-cancelButton"\n\t\t\t\ttext="{i18n>APP_CTX_DIALOG_CANCEL}"\n\t\t\t\tpress=".onCancelAdaptationDialog"/></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/translation/DownloadTranslationDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core" ><Dialog\n\t\ttitle="{i18n>TIT_DOWNLOAD_CHANGED_TEXTS}"\n\t\ttype="Message"\n\t\tcontentWidth="33%"><Label\n\t\t\tlabelFor="languageSelection"\n\t\t\twrappingType="Hyphenated"\n\t\t\twrapping="true"\n\t\t\twidth="auto"\n\t\t\ttext="{i18n>MSG_DOWNLOAD_CHANGED_TEXTS}"\n\t\t\tclass="sapUiTinyMarginBottom"></Label><MessageStrip\n\t\t\tid="dirtyChangesExistsMessage"\n\t\t\ttext="{i18n>MSG_DOWNLOAD_CHANGED_TEXTS_DIRTY_CHANGES_EXIST}"\n\t\t\tclass="sapUiTinyMarginBottom"\n\t\t\tvisible="{translation>/translationRelevantDirtyChangesExist}"></MessageStrip><Select\n\t\t\twidth="100%"\n\t\t\tid="selectedSourceLanguage"\n\t\t\titems="{translation>/sourceLanguages}"\n\t\t\tselectedKey="{translation>/sourceLanguage}"><core:Item key="{translation>}" text="{translation>}"/></Select><Input\n\t\t\twidth="100%"\n\t\t\tid="selectedTargetLanguage"\n\t\t\tvalue="{translation>/targetLanguage}"\n\t\t\tplaceholder="{i18n>TXT_TARGET_LANGUAGE}"></Input><beginButton><Button\n\t\t\t\tid="downloadTranslation"\n\t\t\t\ttext="{i18n>BTN_DOWNLOAD_CHANGED_TEXTS}"\n\t\t\t\ttype="Emphasized"\n\t\t\t\ticon="sap-icon://download"\n\t\t\t\tenabled="{= !!${translation>/sourceLanguages}.length}"\n\t\t\t\tpress=".onDownloadFile" /></beginButton><endButton><Button\n\t\t\t\tid="cancelDownloadTranslation"\n\t\t\t\ttext="{i18n>BUT_DOWNLOAD_CHANGED_TEXTS_CANCEL}"\n\t\t\t\tpress=".onCancelDownloadDialog" /></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/translation/TranslationPopover.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core" ><Popover\n\t\t\tplacement="Bottom"\n\t\t\tshowHeader="false"><List><ActionListItem text="{i18n>BTN_OPEN_DOWNLOAD_TRANSLATION}"\n\t\t\t\t\tpress=".openDownloadTranslationDialog"/><ActionListItem text="{i18n>BTN_OPEN_UPLOAD_TRANSLATION}"\n\t\t\t\t\tpress=".openUploadTranslationDialog"/></List></Popover></core:FragmentDefinition>\n',
	"sap/ui/rta/toolbar/translation/UploadTranslationDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:u="sap.ui.unified"><Dialog\n\t\ttitle="{i18n>TIT_UPLOAD_CHANGED_TEXTS}"\n\t\ttype="Message"><Label\n\t\t\tlabelFor="fileUploader"\n\t\t\twrappingType="Hyphenated"\n\t\t\twrapping="true"\n\t\t\twidth="auto"\n\t\t\ttext="{i18n>MSG_UPLOAD_CHANGED_TEXTS}"\n\t\t\tclass="sapUiTinyMarginBottom"></Label><u:FileUploader\n\t\t\tid="fileUploader"\n\t\t\tsameFilenameAllowed="true"\n\t\t\tfileType="xml"\n\t\t\twidth="100%"\n\t\t\tvalue="{translation>/filePath}"\n\t\t\ticon="sap-icon://upload"\n\t\t\tchange=".saveFiles"><u:xhrSettings><u:FileUploaderXHRSettings withCredentials = "true"/></u:xhrSettings></u:FileUploader><beginButton><Button\n\t\t\t\tid="uploadTranslation"\n\t\t\t\ttext="{i18n>BTN_UPLOAD_CHANGED_TEXTS}"\n\t\t\t\tenabled="{= !!${translation>/filePath}}"\n\t\t\t\ttype="Emphasized"\n\t\t\t\tpress=".handleUploadPress" /></beginButton><endButton><Button\n\t\t\t\tid="cancelTranslationUpload"\n\t\t\t\ttext="{i18n>BUT_UPLOAD_CHANGED_TEXTS_CANCEL}"\n\t\t\t\tpress=".onCancelUploadDialog" /></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/versioning/VersionHistory.fragment.xml":'<core:FragmentDefinition\n        xmlns="sap.m"\n        xmlns:core="sap.ui.core" ><Popover\n            id="popover"\n            class="sapUiRtaVersionHistory"\n            showHeader="false"\n            placement="Bottom" ><List\n                id="versionList"\n                class="sapUiRtaVersionsList"\n                visible="{= ${versions>/versions/length} > 0}"\n                items="{path: \'versions>/versions\', groupHeaderFactory: \'.getGroupHeaderFactory\'}" ><FeedListItem\n                text="{parts: [{path: \'versions>title\'}, {path: \'versions>type\'}], formatter: \'.formatVersionTitle\'}"\n                info="{versions>activatedBy}"\n                timestamp="{parts: [\'versions>activatedAt\', \'versions>importedAt\'], formatter: \'.formatVersionTimeStamp\'}"\n                type="Active"\n                press=".versionSelected"\n                highlight="{path: \'versions>type\', formatter: \'.formatHighlight\'}"\n                highlightText="{path: \'versions>type\', formatter: \'.formatHighlightText\'}"\n                showIcon="false" /></List><List id="originalVersionList"><FeedListItem\n                text="{i18n>TIT_ORIGINAL_APP}"\n                type="Active"\n                press=".versionSelected"\n                highlight="{path: \'versions>/versions\', formatter: \'.formatOriginalAppHighlight\'}"\n                highlightText="{path: \'versions>/versions\', formatter: \'.formatOriginalAppHighlightText\'}"\n                showIcon="false" /></List></Popover></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/versioning/VersionTitleDialog.fragment.xml":'<core:FragmentDefinition\n        xmlns="sap.m"\n        xmlns:core="sap.ui.core" ><Dialog\n            id="dialog"\n            title="{i18n>TIT_VERSION_TITLE_DIALOG}"\n            type="Message" ><content><Input\n                    id="versionTitleInput"\n                    type="Text"\n                    maxLength="200"\n                    liveChange=".onVersionTitleLiveChange"\n                    submit=".onConfirmVersioningDialog"\n                    placeholder="{i18n>TXT_VERSION_TITLE_INPUT_PLACEHOLDER}" /></content><beginButton><Button\n                id="confirmVersionTitleButton"\n                text="{i18n>BUT_VERSION_TITLE_DIALOG_CONFIRM}"\n                type="Emphasized"\n                enabled="false"\n                press=".onConfirmVersioningDialog" /></beginButton><endButton><Button\n                text="{i18n>BUT_VERSION_TITLE_DIALOG_CANCEL}"\n                press=".onCancelVersioningDialog" /></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/util/changeVisualization/ChangeIndicatorCategorySelection.fragment.xml":'<core:FragmentDefinition\n\txmlns:core="sap.ui.core"\n\txmlns="sap.m"\n\txmlns:l="sap.ui.layout"><Popover\n\t\tshowHeader="false"\n\t\tplacement="Bottom"\n\t\tid="popover"><SegmentedButton selectedKey="{visualizationModel>/changeState}" width="420px" selectionChange=".onVersioningCategoryChange"><items><SegmentedButtonItem\n\t\t\t\t\ttext="{i18n>BUT_CHANGEVISUALIZATION_VERSIONING_ALL}"\n\t\t\t\t\tkey="all"/><SegmentedButtonItem\n\t\t\t\t\ttext="{i18n>BUT_CHANGEVISUALIZATION_VERSIONING_DRAFT}"\n\t\t\t\t\tkey="draft"\n\t\t\t\t\tvisible="{visualizationModel>/versioningAvailable}"\n\t\t\t\t\tenabled="{= ${visualizationModel>/hasDraftChanges} ||  ${visualizationModel>/hasDirtyChanges}}"/><SegmentedButtonItem\n\t\t\t\t\ttext="{i18n>BUT_CHANGEVISUALIZATION_VERSIONING_DIRTY}"\n\t\t\t\t\tkey="dirty"\n\t\t\t\t\tenabled="{visualizationModel>/hasDirtyChanges}"/></items></SegmentedButton><MessageStrip\n\t\t\ttext="{visualizationModel>/popupInfoMessage}"\n\t\t\ttype="Information"\n\t\t\tshowIcon="true"\n\t\t\tvisible="{= ${visualizationModel>/sortedChanges/relevantHiddenChanges}.length > 0 }"><link><Link text="{i18n>BUT_CHANGEVISUALIZATION_LEARNMORE}"\n\t\t\t\t\ttarget="_blank"\n\t\t\t\t\thref="https://ui5.sap.com/#/topic/35274280504f42cd87cc4fd3d403ca91.html#loio35274280504f42cd87cc4fd3d403ca91/visualization"/></link></MessageStrip><List\n\t\t\tclass="sapUiRtaChangesList"\n\t\t\titems="{visualizationModel>/changeCategories/}"><StandardListItem\n\t\t\t\ttitle="{visualizationModel>title}"\n\t\t\t\tcounter="{visualizationModel>count}"\n\t\t\t\ttype="{= ${visualizationModel>count} > 0 ? \'Active\' : \'Inactive\'}"\n\t\t\t\ticon="{visualizationModel>icon}"\n\t\t\t\tpress=".onChangeCategorySelection"/></List></Popover></core:FragmentDefinition>',
	"sap/ui/rta/util/changeVisualization/ChangeIndicatorPopover.fragment.xml":'<core:FragmentDefinition\n\txmlns:core="sap.ui.core"\n\txmlns="sap.m"\n\txmlns:l="sap.ui.layout"><Popover\n\t\tshowHeader="false"\n\t\tplacement="PreferredTopOrFlip"\n\t\tid="popover"\n\t\tclass="sapUiRtaPopover sapUiRtaChangeVisualizationPopover"><Table\n\t\t\tariaLabelledBy="Changes"\n\t\t\titems="{details>/}"\n\t\t\tinset="false"\n\t\t\tfixedLayout="false"\n\t\t\twidth="auto"><columns><Column\n\t\t\t\t\twidth="auto"><Text text="{i18n>TIT_CHANGEVISUALIZATION_TYPE}" /></Column><Column\n\t\t\t\t\twidth="auto"><Text text="{i18n>TIT_CHANGEVISUALIZATION_DESCRIPTION}" /></Column><Column\n\t\t\t\t\twidth="auto"><Text text="{i18n>TIT_CHANGEVISUALIZATION_DATE}" /></Column></columns><items><ColumnListItem><cells><core:Icon\n\t\t\t\t\t\t\tsrc="{details>icon}"\n\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin"\n\t\t\t\t\t\t\ttooltip="{details>iconTooltip}"/><HBox alignItems="Center"><Text\n\t\t\t\t\t\t\t\ttext="{details>description}"\n\t\t\t\t\t\t\t\ttooltip="{details>descriptionTooltip}"/><Button\n\t\t\t\t\t\t\t\tvisible="{= !!${details>detailButtonText}}"\n\t\t\t\t\t\t\t\ttext="{details>detailButtonText}"\n\t\t\t\t\t\t\t\tpress="._showDependentElements"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin"/></HBox><Text\n\t\t\t\t\t\t\ttext="{details>relativeDate}"\n\t\t\t\t\t\t\ttooltip="{details>fullDate}"/></cells></ColumnListItem></items></Table></Popover></core:FragmentDefinition>',
	"sap/ui/rta/view/RemoveElementDialog.fragment.xml":'<core:FragmentDefinition xmlns:core="sap.ui.core"\n\txmlns:commons="sap.ui.commons" xmlns:layout="sap.ui.layout"\n\txmlns:sap.m="sap.m"><sap.m:Dialog class="sapUiRtaConfirmationDialog" verticalScrolling="false" title="{/titleText}" icon="{/icon}"><layout:VerticalLayout width="100%"><sap.m:Text class="sapUiRtaConfirmationDialogText" text="{/messageText}" /></layout:VerticalLayout><sap.m:beginButton><sap.m:Button class="sapUiRtaConfirmationDialogRemoveButton" text="{/removeText}" press="removeField" /></sap.m:beginButton><sap.m:endButton><sap.m:Button class="sapUiRtaConfirmationDialogCancelButton" text="{/cancelText}" press="closeDialog" /></sap.m:endButton></sap.m:Dialog></core:FragmentDefinition>'
});
//# sourceMappingURL=library-preload.js.map
