/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/dt/Util","sap/base/Log"],function(e,n,t,r){"use strict";var a=e.extend("sap.ui.rta.plugin.Settings",{metadata:{library:"sap.ui.rta",properties:{commandStack:{type:"any"}},associations:{},events:{}}});var i="CTX_SETTINGS";a.prototype._isEditable=function(e){var n=this.getAction(e);if(n){if(n.handler){return this.hasStableId(e)}var t=Object.keys(n).some(function(t){var r=n[t];return r.handler&&this._checkRelevantContainerStableID(r,e)}.bind(this));if(t){return this.hasStableId(e)}}return false};a.prototype.isEnabled=function(e){var n=e[0];var t=this.getAction(n);if(!t){return false}if(typeof t.isEnabled!=="undefined"){if(typeof t.isEnabled==="function"){return t.isEnabled(n.getElement())}return t.isEnabled}return true};a.prototype._getUnsavedChanges=function(e,n){var t;var r=this.getCommandStack().getAllExecutedCommands().filter(function(r){t=r.getElementId&&r.getElementId()||r.getElement&&r.getElement().getId();return t===e&&n.indexOf(r.getChangeType())>=0}).map(function(e){return e.getPreparedChange()});return r};a.prototype._handleFlexChangeCommand=function(e,n,t,r){var a=e.changeSpecificData;var i;var o=e.selectorElement||e.selectorControl;var s;var d;if(o.controlType){s=o.controlType}else{d=o}return this.hasChangeHandler(a.changeType,d,s).then(function(e){if(n[0].getVariantManagement&&e&&!r.CAUTION_variantIndependent){i=n[0].getVariantManagement()}return this.getCommandFactory().getCommandFor(o,"settings",a,undefined,i)}.bind(this)).then(function(e){var n=r.runtimeOnly;if(e&&n){e.setRuntimeOnly(n)}return t.addCommand(e)})};a.prototype._handleAppDescriptorChangeCommand=function(e,n,t){var r=e.changeSpecificData;var a=e.appComponent;var i=a.getManifest();var o=i["sap.app"].id;return this.getCommandFactory().getCommandFor(n,"appDescriptor",{reference:o,appComponent:a,changeType:r.appDescriptorChangeType,parameters:r.content.parameters,texts:r.content.texts}).then(function(e){return t.addCommand(e)})};a.prototype._handleCompositeCommand=function(e,n,t,r){var a;return this.getCommandFactory().getCommandFor(n,"composite").then(function(e){a=e}).then(function(){return t.map(function(t){var i=t.changeSpecificData;if(i.changeType){return this._handleFlexChangeCommand(t,e,a,r)}else if(i.appDescriptorChangeType){return this._handleAppDescriptorChangeCommand(t,n,a)}return undefined},this)}.bind(this)).then(function(e){return Promise.all(e)}).then(function(){if(a.getCommands().length>0){this.fireElementModified({command:a})}}.bind(this))};a.prototype.handler=function(e,r,a){r||={};var i=e[0].getElement();var{fnHandler:o}=r;o||=e[0].getDesignTimeMetadata().getAction("settings").handler;if(!o){throw new Error("Handler not found for settings action")}r.getUnsavedChanges=this._getUnsavedChanges.bind(this);r.styleClass=n.getRtaStyleClassName();return o(i,r).then(function(n){if(n.length>0){return this._handleCompositeCommand(e,i,n,a)}return undefined}.bind(this)).catch(function(e){throw t.propagateError(e,"Settings#handler","Error occurred during handler execution","sap.ui.rta.plugin")})};a.prototype.getMenuItems=function(e){var n=e[0];var t=this.getAction(n);var a=[];if(t){var d=110;if(t.handler){t={settings:t}}var u=Object.keys(t);u.forEach(function(e,u,c){var l=t[e];if(l.handler&&this._checkRelevantContainerStableID(l,n)&&this.isAvailable([n])){var h=c.length===1;a.push({id:h?i:i+u,rank:h?d:d+u,text:this.getActionText(n,l,i),icon:s(l),enabled:typeof l.isEnabled==="function"&&function(e){return l.isEnabled(e[0].getElement())}||l.isEnabled||this.isEnabled([n]),handler:function(e,n,t){t||={};t.fnHandler=e;return this.handler(n,t,l)}.bind(this,l.handler),submenu:o(l.submenu)})}else{r.warning(`Handler not found for settings action '${e}' or relevant container has no stable id`)}},this)}return a};function o(e){if(e){return e.map(function(e,n){return{id:e.key||`${i}_SUB_${n}`,icon:e.icon||"blank",text:e.name||"",enabled:e.hasOwnProperty("enabled")?e.enabled:true}})}return undefined}function s(e){var n="sap-icon://key-user-settings";var t=e.icon;if(!t){return n}if(typeof t!=="string"){r.error("Icon setting for settingsAction should be a string");return n}return t}a.prototype.getActionName=function(){return"settings"};return a});
//# sourceMappingURL=Settings.js.map