/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/core/Lib","sap/ui/rta/Utils","sap/ui/model/json/JSONModel","sap/m/MessageBox","sap/m/MessageToast","sap/ui/fl/write/api/TranslationAPI","sap/ui/fl/Layer","sap/ui/core/util/File"],function(a,o,t,e,n,i,l,r,s,d,g,u){"use strict";function p(o){var t=o.userMessage||o.stack||o.message||o.status||o;var e=n.getResourceBundleFor("sap.ui.rta");a.error(t);var l=`${e.getText("MSG_LREP_TRANSFER_ERROR")}\n${e.getText("MSG_ERROR_REASON",[t])}`;r.error(l,{styleClass:i.getRtaStyleClassName()})}var c=o.extend("sap.ui.rta.toolbar.translation.Translation",{metadata:{properties:{toolbar:{type:"any"}}},constructor:function(...a){o.prototype.constructor.apply(this,a);this._oTranslationModel=new l(D())}});function h(a){var o=a.getSource().getModel("translation");var t=o.getProperty("/sourceLanguage");var e=o.getProperty("/targetLanguage");var n=`${t}_${e}_`+`TranslationXLIFF`;var i={layer:g.CUSTOMER,sourceLanguage:t,targetLanguage:e,selector:this.getToolbar().getRtaInformation().rootControl};var l=new Promise(function(a){if(o.getProperty("/translationRelevantDirtyChangesExist")){l=this.getToolbar().fireSave({callback:a})}else{a()}}.bind(this));l.then(d.getTexts.bind(undefined,i)).then(function(a){u.save(a,n,"xml","application/xml");this._oDownloadDialog.close()}.bind(this)).catch(function(a){p(a)})}c.prototype._createDownloadTranslationDialog=function(){return e.load({name:"sap.ui.rta.toolbar.translation.DownloadTranslationDialog",id:`${this.getToolbar().getId()}_download_translation_fragment`,controller:{onDownloadFile:h.bind(this),onCancelDownloadDialog:function(){this._oDownloadDialog.close()}.bind(this)}}).then(function(a){this._oDownloadDialog=a;this._oDownloadDialog.setModel(this._oTranslationModel,"translation");this.getToolbar().addDependent(this._oDownloadDialog);return a}.bind(this))};c.prototype._createUploadTranslationDialog=function(){var a=`${this.getToolbar().getId()}_upload_translation_fragment`;return e.load({name:"sap.ui.rta.toolbar.translation.UploadTranslationDialog",id:a,controller:{onCancelUploadDialog:function(){this._oUploadDialog.close()}.bind(this),formatUploadEnabled(){var o=t.getElementById(`${a}--fileUploader`);return o.checkFileReadable()},saveFiles:function(a){this._oTranslationModel.setProperty("/file",a.getParameter("files")[0])}.bind(this),handleUploadPress:f.bind(this,a)}}).then(function(a){this._oUploadDialog=a;this._oUploadDialog.setModel(this._oTranslationModel,"translation");this.getToolbar().addDependent(this._oUploadDialog);return this._oUploadDialog}.bind(this))};function f(a){var o=t.getElementById(`${a}--fileUploader`);o.checkFileReadable().then(function(){if(this._oTranslationModel.getProperty("/file")){var a={layer:g.CUSTOMER,payload:new FormData};a.payload.append("file",this._oTranslationModel.getProperty("/file"),o.getValue());return d.uploadTranslationTexts(a).then(function(){var a=n.getResourceBundleFor("sap.ui.rta");var o=a.getText("MSG_UPLOAD_TRANSLATION_SUCCESS");s.show(o,{styleClass:i.getRtaStyleClassName()});this._oUploadDialog.close()}.bind(this)).catch(function(a){p(a)}).finally(o.clear.bind(o))}}.bind(this))}function D(){return Object.assign({},{sourceLanguage:"",sourceLanguages:[],downloadChangedTexts:false,file:undefined})}c.prototype.openDownloadTranslationDialog=function(a){var o=d.hasTranslationRelevantDirtyChanges(a);this._oTranslationModel.setProperty("/translationRelevantDirtyChangesExist",o);return d.getSourceLanguages(a).then(function(a){if(a){this._oTranslationModel.setProperty("/sourceLanguages",a);this._oTranslationModel.setProperty("/sourceLanguage",a[0]||"")}}.bind(this)).then(function(){if(this._oDownloadDialogPromise){this._oTranslationModel.setProperty("/targetLanguage","")}else{this._oDownloadDialogPromise=this._createDownloadTranslationDialog()}return this._oDownloadDialogPromise}.bind(this)).then(function(a){return a.open()}).catch(function(a){p(a)})};c.prototype.openUploadTranslationDialog=function(){this._oUploadDialogPromise||=this._createUploadTranslationDialog();return this._oUploadDialogPromise.then(function(a){this.getToolbar().addDependent(a);return a.open()}.bind(this))};return c});
//# sourceMappingURL=Translation.js.map