/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseController","./PresetsController","../models/SharedModel","../models/TableSettingsModel","../models/SelectionUtils","../models/PresetsUtils","../models/CustomJSONListSelection","sap/base/util/deepExtend","sap/ui/model/json/JSONModel","sap/ui/model/BindingMode","sap/ui/core/Fragment","sap/m/library","sap/m/MessageToast","sap/m/List","sap/m/StandardListItem","sap/m/table/columnmenu/Menu","sap/m/table/columnmenu/Item","sap/ui/support/supportRules/CommunicationBus","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/RuleSerializer","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/Storage","sap/ui/support/supportRules/util/EvalUtils"],function(e,t,i,s,o,r,n,l,u,a,d,c,h,p,g,m,f,S,R,y,b,P,E){"use strict";return e.extend("sap.ui.support.supportRules.ui.controllers.Analysis",{onInit:function(){this.model=i;this.setCommunicationSubscriptions();this.tempRulesLoaded=false;this.getView().setModel(this.model);this.treeTable=o.treeTable=this.byId("ruleList");this._oRuleSetsModel=new u;this.treeTable.setModel(this._oRuleSetsModel,"ruleSets");this.treeTable.setModel(s,"tableSettings");this.ruleSetView=this.byId("ruleSetsView");this.rulesViewContainer=this.byId("rulesNavContainer");this.bAdditionalViewLoaded=false;this.bAdditionalRulesetsLoaded=false;this.bInitFired=false;new n(this.treeTable,true,"id");S.subscribe(R.UPDATE_SUPPORT_RULES,function(){if(!this.bAdditionalViewLoaded){S.publish(R.RESIZE_FRAME,{bigger:true});this.bAdditionalViewLoaded=true;this.loadAdditionalUI()}},this);if(this.model.getProperty("/persistingSettings")){var e=P.getVisibleColumns()||[];if(e.length){this.setColumnVisibility(e,true)}}this.byId("presetVariant").addEventDelegate({onclick:this.onPresetVariantClick.bind(this)});this.byId("rowActionTemplate").setVisible(!this.model.getProperty("/tempRulesDisabled"));this._associateTableColumnsMenu()},onAfterRendering:function(){if(!this.bInitFired){var e=function(){S.publish(R.ON_INIT_ANALYSIS_CTRL);sap.ui.getCore().detachThemeChanged(e)};if(sap.ui.getCore().isThemeApplied()){S.publish(R.ON_INIT_ANALYSIS_CTRL)}else{sap.ui.getCore().attachThemeChanged(e)}this.bInitFired=true}},loadAdditionalUI:function(){if(!this._ruleDetails){this._ruleDetails=d.load({name:"sap.ui.support.supportRules.ui.views.RuleDetails",controller:this}).then(function(e){this.byId("rulesDisplayPage").addContentArea(e)}.bind(this))}if(!this._ruleCreateUpdatePages){this._ruleCreateUpdatePages=d.load({name:"sap.ui.support.supportRules.ui.views.RuleUpdate",controller:this}).then(function(e){e.forEach(function(e){this.byId("rulesNavContainer").insertPage(e)},this)}.bind(this))}this._updateRuleList()},onAsyncSwitch:function(e){var t=e.getSource();if(e.getParameter("selected")){var i=t.getCustomData()[0].getValue()==="true";var s=t.getProperty("groupName")==="asyncContext"?"/newRule":"/editRule";this.model.setProperty(s+"/async",i);this._updateCheckFunction(s,i)}},_updateCheckFunction:function(e,t){var i=this.model.getProperty(e+"/check");if(!i){return}var s=i.match(/function[^(]*\(([^)]*)\)/);if(!s){return}var o=s[1].trim().split(/\W+/);o[0]=o[0]||"oIssueManager";o[1]=o[1]||"oCoreFacade";o[2]=o[2]||"oScope";if(t){o[3]=o[3]||"fnResolve"}else{o=o.slice(0,3)}var r=i.replace(/function[^(]*\(([^)]*)\)/,"function ("+o.join(", ")+")");this.model.setProperty(e+"/check",r)},getTemporaryLib:function(){var e=this.model.getProperty("/libraries");for(var t=0;t<e.length;t++){if(e[t].title==b.TEMP_RULESETS_NAME){return l({},e[t])}}return null},setTemporaryLib:function(e){var t=this.model.getProperty("/libraries");for(var i=0;i<t.length;i++){if(t[i].title==b.TEMP_RULESETS_NAME){this.model.setProperty("/libraries/"+i,e);return}}},setCommunicationSubscriptions:function(){if(!this.model.getProperty("/tempRulesDisabled")){this._setTempRulesCommunicationSubscriptions()}S.subscribe(R.UPDATE_SUPPORT_RULES,this.updateSupportRules,this);S.subscribe(R.POST_AVAILABLE_LIBRARIES,function(e){this.bAdditionalRulesetsLoaded=true;this.model.setProperty("/availableLibrariesSet",e.libNames);this.rulesViewContainer.setBusy(false)},this);S.subscribe(R.POST_AVAILABLE_COMPONENTS,function(e){var t=[],i=this.model.getProperty("/executionScopeComponents"),s=P.getSelectedScopeComponents(),o;for(var r=0;r<e.length;r+=1){t.push({text:e[r]})}if(i&&i.length>0){for(o=0;o<t.length;o++){t[o].selected=this.checkIfComponentIsSelected(t[o],i)}}else if(s&&s.length>0){for(o=0;o<t.length;o++){t[o].selected=this.checkIfComponentIsSelected(t[o],s)}}this.model.setProperty("/executionScopeComponents",t)},this);S.subscribe(R.GET_RULES_MODEL,function(e){var t=P.readPersistenceCookie(b.COOKIE_NAME),i=this.model.getProperty("/loadingAdditionalRuleSets");if(i){o._syncSelectionAdditionalRuleSetsMainModel(e,this._oRuleSetsModel.getData());o._deselectAdditionalRuleSets(e,this.model.getProperty("/namesOfLoadedAdditionalRuleSets"))}if(t){this.initializeTempRules();var s=o.updateSelectedRulesFromLocalStorage(e);if(s){e=s}r.loadCustomPresets()}this._oRuleSetsModel.setData(e);if(t||i){this.treeTable.updateSelectionFromModel()}else{this.treeTable.selectAll()}this.model.setProperty("/selectedRulesCount",o.getSelectedRules().length);r.initializeSelectionPresets(o.getSelectedRules())},this);S.subscribe(R.POST_MESSAGE,function(e){h.show(e.message)},this);S.subscribe(R.ON_ANALYZE_STARTED,function(e){this.model.setProperty("/showProgressIndicator",true)},this)},checkIfComponentIsSelected:function(e,t){for(var i=0;i<t.length;i+=1){if(t[i].text==e.text&&t[i].selected){return true}}return false},onAnalyze:function(){var e=this.model.getProperty("/selectionPresetsCurrent"),t=this._getExecutionContext();if(e.selections.length===0){h.show("Select some rules to be analyzed.");return}if(t.type==="components"&&t.components.length===0){h.show("Please select some components to be analyzed.");return}S.publish(R.ON_ANALYZE_REQUEST,{rulePreset:e,executionContext:t})},_getExecutionContext:function(){var e={type:this.model.getProperty("/analyzeContext/key")};if(e.type==="subtree"){e.parentId=this.model.getProperty("/subtreeExecutionContextId")}if(e.type==="components"){var t=sap.ui.getCore().byId("componentsSelectionContainer"),i=t.getContent();e.components=[];i.forEach(function(t){if(t.getSelected()){e.components.push(t.getText())}})}return e},onSelectedRuleSets:function(e){var t=true,i=this.model.getProperty("/selectedRule"),s=e.getParameter("selectedKey")==="additionalRulesets";if(s||!i){t=false}if(!this.bAdditionalRulesetsLoaded&&s){this.rulesViewContainer.setBusyIndicatorDelay(0);this.rulesViewContainer.setBusy(true);S.publish(R.GET_NON_LOADED_RULE_SETS,{loadedRulesets:this._getLoadedRulesets()})}this.getView().getModel().setProperty("/showRuleProperties",t)},_getLoadedRulesets:function(){var e=this.treeTable.getModel("ruleSets").getData(),t=[];Object.keys(e).forEach(function(i){var s=e[i].name;if(s&&s!=="temporary"){t.push(s)}});return t},_applyTempRulesSelection:function(e){var t=l({},this._oRuleSetsModel.getData()),i,s,o,r,n,u,a=function(e){return e.id===s.id};for(var d in t){i=t[d];o=t[d].nodes;if(i.name!==b.TEMP_RULESETS_NAME){continue}t[d].nodes=[];for(var c in e.rules){s=e.rules[c];r=o[c]!==undefined?o[c].selected:true;if(this.tempRulesFromStorage){n=this.tempRulesFromStorage.filter(a);if(n.length>0){r=n[0].selected;u=this.tempRulesFromStorage.indexOf(n[0]);this.tempRulesFromStorage.splice(u,1);if(r===false){i.selected=false}}if(this.tempRulesFromStorage.length===0){this.tempRulesFromStorage.length=null}}i.nodes.push({name:s.title,description:s.description,id:s.id,audiences:s.audiences.toString(),categories:s.categories.toString(),minversion:s.minversion,resolution:s.resolution,title:s.title,selected:r,libName:i.name,check:s.check})}}this._oRuleSetsModel.setData(t)},_syncTreeTableVieModelTempRule:function(e,t){var i=this.model.getProperty("/editRuleSource");for(var s in t){if(t[s].name===b.TEMP_RULESETS_NAME){for(var o in t[s].nodes){if(t[s].nodes[o].id===i.id){t[s].nodes[o]={name:e.title,description:e.description,id:e.id,audiences:e.audiences,categories:e.categories,minversion:e.minversion,resolution:e.resolution,selected:t[s].nodes[o].selected,title:e.title,libName:t[s].name,check:e.check}}}}}},_hasSelectedComponent:function(){var e=sap.ui.getCore().byId("componentsSelectionContainer").getContent();function t(e){return e.getSelected()}return e.some(t)},onAnalyzeSettings:function(e){var t=e.getSource();S.publish(R.GET_AVAILABLE_COMPONENTS);if(!this._analyzeSettingsPopover){this._analyzeSettingsPopover=d.load({name:"sap.ui.support.supportRules.ui.views.AnalyzeSettings",controller:this}).then(function(e){this.getView().addDependent(e);return e}.bind(this))}this._analyzeSettingsPopover.then(function(e){e.openBy(t)})},onContextSelect:function(e){if(e.getParameter("selected")){var t=e.getSource(),i=t.getCustomData()[0].getValue(),s=this.model.getProperty("/executionScopes")[i];if(i==="components"&&!this._hasSelectedComponent()){var o=sap.ui.getCore().byId("componentsSelectionContainer").getContent();if(o.length>0){o[0].setSelected(true);this.onScopeComponentSelect(null)}}this.model.setProperty("/analyzeContext",s)}if(P.readPersistenceCookie(b.COOKIE_NAME)){this.persistExecutionScope()}},onExecutionContextChange:function(e){var t=e.getSource().getValue();if(t){this.model.setProperty("/subtreeExecutionContextId",t)}if(P.readPersistenceCookie(b.COOKIE_NAME)){this.persistExecutionScope()}},onScopeComponentSelect:function(e){var t=this.model.getProperty("/executionScopeComponents");if(P.readPersistenceCookie(b.COOKIE_NAME)){P.setSelectedScopeComponents(t)}},onBeforePopoverOpen:function(){if(this.model.getProperty("/executionScopeComponents").length===0){S.publish(R.GET_AVAILABLE_COMPONENTS)}},createNewRulePress:function(e){var t=this.model.getProperty("/newEmptyRule");this.model.setProperty("/selectedSetPreviewKey","availableRules");this.model.setProperty("/newRule",l({},t));this.model.setProperty("/tempLink",{href:"",text:""});this.goToCreateRule()},goToRuleProperties:function(){var e=this.byId("rulesNavContainer");e.to(this.byId("rulesDisplayPage"),"show")},createRuleString:function(e){if(!e){return""}var t="{\n",i=0,s=Object.keys(e).length;for(var o in e){var r=e[o];i++;t+="\t";t+=o+": ";if(o==="check"){t+=r.split("\n").join("\n\t")}else{t+=JSON.stringify(r)}if(i<s){t+=","}t+="\n"}t+="}";return t},updateRule:function(){var e=this.model.getProperty("/editRuleSource/id"),t=this.model.getProperty("/editRule");if(this.checkFunctionString(t.check)){S.publish(R.VERIFY_UPDATE_RULE,{oldId:e,updateObj:y.serialize(t)})}},updateSupportRules:function(e){e=y.deserialize(e.sRuleSet);S.publish(R.REQUEST_RULES_MODEL,e);var t=[],i=this;for(var s in e){var o=[],r=e[s].ruleset._mRules;for(var n in r){var l=r[n];l.libName=s;l.selected=true;o.push(l)}t.push({title:s,type:"library",rules:o,selected:true})}var u;if(t[0].rules[0]){u=t[0].rules[0]}else{u=t[1].rules[0]}i.placeTemporaryRulesetAtStart(t);i.model.setProperty("/selectedRuleStringify","");i.model.setProperty("/selectedRule",u);i.model.setProperty("/selectedRuleStringify",i.createRuleString(u));i.model.setProperty("/libraries",t);var a=i.model.getProperty("/loadingAdditionalRuleSets");if(a){h.show("Additional rule set(s) loaded!");this.ruleSetView.setSelectedKey("availableRules")}},initializeTempRules:function(){if(this.model.getProperty("/tempRulesDisabled")){return}var e=P.getRules(),t=this.model.getProperty("/loadingAdditionalRuleSets");if(e&&!t&&!this.tempRulesLoaded){this.tempRulesFromStorage=e;this.tempRulesLoaded=true;e.forEach(function(e){S.publish(R.VERIFY_CREATE_RULE,y.serialize(e))});this.persistedTempRulesCount=e.length}},placeTemporaryRulesetAtStart:function(e){for(var t=0;t<e.length;t++){var i=e[t];if(i.title===b.TEMP_RULESETS_NAME){var s=i;e.splice(t,1);e.unshift(s);return}}},addLinkToRule:function(e){var t=this.model.getProperty("/tempLink"),i=l({},t),s=e.getSource().getProperty("text"),o=s==="Add"?"/newRule":"/editRule",r=this.model.getProperty(o+"/resolutionurls");if(r){r.push(i)}else{this.model.setProperty(o+"/resolutionurls","");r.push(i)}this.model.setProperty("/tempLink",{href:"",text:""})},goToCreateRule:function(){var e=this.byId("rulesNavContainer");e.to(sap.ui.getCore().byId("rulesCreatePage"),"show")},checkFunctionString:function(e){try{E.evalFunction(e)}catch(e){h.show("Your check function contains errors, and can't be evaluated:"+e);return false}return true},addNewRule:function(){var e=this.model.getProperty("/newRule");if(this.checkFunctionString(e.check)){this.showRuleCreatedToast=true;S.publish(R.VERIFY_CREATE_RULE,y.serialize(e))}},rulesToolbarITHSelect:function(e){if(e.getParameter("key")==="jsonOutput"){var t=this.model.getProperty("/newRule"),i=this.createRuleString(t);this.model.setProperty("/newRuleStringified",i)}},rulesToolbarEditITHSelect:function(e){if(e.getParameter("key")==="jsonOutput"){var t=this.model.getProperty("/editRule"),i=this.createRuleString(t);this.model.setProperty("/updateRuleStringified",i)}},loadMarkedSupportLibraries:function(){var e=this.byId("availableLibrariesSet"),t=[],i=this.model.getProperty("/availableLibrariesSet");t=e.getSelectedItems().map(function(e){return e.getTitle()});e.getItems().forEach(function(e){e.setSelected(false)});if(t.length>0){i=i.filter(function(e){return t.indexOf(e)<0});this.model.setProperty("/availableLibrariesSet",i);this.model.setProperty("/namesOfLoadedAdditionalRuleSets",t);S.publish(R.LOAD_RULESETS,{aLibNames:{publicRules:t,internalRules:t}});this.model.setProperty("/loadingAdditionalRuleSets",true);this.model.setProperty("/showRuleProperties",true)}else{h.show("Select additional RuleSet to be loaded.")}},onCellClick:function(e){if(e.getParameter("rowBindingContext")){var t=e.getParameter("rowBindingContext").getObject(),i,s="",o=false;if(t.id&&t.type!=="lib"){i=this.getMainModelFromTreeViewModel(t);s=this.createRuleString(i);o=true}this.model.setProperty("/selectedRuleStringify",s);this.model.setProperty("/selectedRule",i);this.model.setProperty("/showRuleProperties",o)}},onRowSelectionChange:function(e){if(e.getParameter("userInteraction")){r.syncCurrentSelectionPreset(o.getSelectedRules())}},getMainModelFromTreeViewModel:function(e){var t=this.model.getProperty("/libraries"),i=null;t.forEach(function(s,o){t[o].rules.forEach(function(t){if(e.id===t.id){i=t}})});return i},_generateRuleId:function(e){var t=0,i=this.getTemporaryLib(),s=i.rules,o,r=function(i){return i.id===e+t};while(++t){o=s.some(r);if(!o){return e+t}}},duplicateRule:function(e){var t=e.getSource().getBindingContext("ruleSets").getPath(),i=this.treeTable.getBinding().getModel().getProperty(t),s=this.getMainModelFromTreeViewModel(i),o=l({},s);o.id=this._generateRuleId(o.id);this.model.setProperty("/newRule",o);this.goToCreateRule()},editRule:function(e){var t=e.getSource().getBindingContext("ruleSets").getPath(),i=this.treeTable.getBinding().getModel().getProperty(t),s=this.getMainModelFromTreeViewModel(i);this.model.setProperty("/editRuleSource",s);this.model.setProperty("/editRule",l({},s));var o=this.byId("rulesNavContainer");o.to(sap.ui.getCore().byId("ruleUpdatePage"),"show")},deleteTemporaryRule:function(e){var t=this.getObjectOnTreeRow(e),i=l({},this._oRuleSetsModel.getData()),s=this.model.getProperty("/libraries"),n;s.forEach(function(e){if(e.title===b.TEMP_RULESETS_NAME){n=e.rules.filter(function(e){return e.id!==t.id});e.rules=n}});for(var u in i){if(i[u].name===b.TEMP_RULESETS_NAME){for(var a in i[u].nodes){if(i[u].nodes[a].id===t.id){i[u].nodes.splice(a,1)}}}}this._oRuleSetsModel.setData(i);S.publish(R.DELETE_RULE,y.serialize(t));this._updateRuleList();r.syncCurrentSelectionPreset(o.getSelectedRules());if(P.readPersistenceCookie(b.COOKIE_NAME)){P.removeSelectedRules(n);o.persistSelection()}},getObjectOnTreeRow:function(e){var t=e.getSource().getBindingContext("ruleSets").getPath(),i=this.treeTable.getBinding().getModel().getProperty(t),s=this.model.getProperty("/libraries");s.forEach(function(e,t){e.rules.forEach(function(e){if(e.id===i.id){i.check=e.check}})});return i},_updateRuleList:function(){var e=this.getView().byId("ruleList"),t=this.getTemporaryLib(),i=t?t["rules"]:[];if(!i.length){e.setRowActionCount(1)}else{e.setRowActionCount(2)}},setColumnVisibility:function(e,t){var i=this.treeTable.getColumns();i.forEach(function(i){i.setVisible(!t);e.forEach(function(e){if(i.sId.includes(e)){i.setVisible(t)}})})},onPresetVariantClick:function(){if(!this._PresetsController){this._PresetsController=new t(this.model,this.getView())}this._PresetsController.openPresetVariant()},_setTempRulesCommunicationSubscriptions:function(){S.subscribe(R.VERIFY_RULE_CREATE_RESULT,function(e){var t=e.result,i=y.deserialize(e.newRule,true),s=this.getTemporaryLib();if(t=="success"){s.rules.push(i);this.setTemporaryLib(s);this._applyTempRulesSelection(s);r.syncCurrentSelectionPreset(o.getSelectedRules());if(P.readPersistenceCookie(b.COOKIE_NAME)){o.persistSelection();P.setRules(s.rules);if(this.showRuleCreatedToast){h.show('Your temporary rule "'+i.id+'" was persisted in the local storage');this.showRuleCreatedToast=false}}var n=this.model.getProperty("/newEmptyRule");this.model.setProperty("/newRule",l({},n));this.goToRuleProperties();this.model.setProperty("/selectedRule",i);this._updateRuleList();this.treeTable.updateSelectionFromModel()}else{h.show("Add rule failed because: "+t)}},this);S.subscribe(R.VERIFY_RULE_UPDATE_RESULT,function(e){var t=e.result,i=y.deserialize(e.updateRule,true),s=this;if(t==="success"){var r=this.model.getProperty("/editRuleSource"),n=this._oRuleSetsModel.getData(),l=this.model.getProperty("/libraries");l.forEach(function(e,t){if(e.title===b.TEMP_RULESETS_NAME){e.rules.forEach(function(t,o){if(t.id===r.id){e.rules[o]=i;if(s.model.getProperty("/persistingSettings")){P.setRules(e.rules)}}});s._syncTreeTableVieModelTempRule(i,n)}});this._oRuleSetsModel.setData(n);this.model.setProperty("/selectedRule",i);o.getSelectedRules();this.treeTable.updateSelectionFromModel();this.goToRuleProperties()}else{h.show("Update rule failed because: "+t)}},this)},_associateTableColumnsMenu:function(){const e=s.getProperty("/columns");const t=new p({mode:c.ListMode.MultiSelect});t.setModel(s,"tableSettings");for(const i in e){if(e[i].visibilityConfigurable){t.addItem(new g({title:`{tableSettings>/columns/${i}/title}`,selected:{model:"tableSettings",path:`/columns/${i}/visible`,mode:a.OneWay}}))}}const i=new m("tableColumnMenu",{beforeOpen:function(){t.getItems().forEach(function(e){e.setSelected(e.getBinding("selected").getValue())})},items:[new f({label:"Columns",content:t,showResetButton:false,confirm:function(){t.getItems().forEach(function(e){s.setProperty(e.getBinding("selected").getPath(),e.getSelected())});if(this.model.getProperty("/persistingSettings")){this.persistVisibleColumns()}}.bind(this)})]});this.getView().addDependent(i);for(const t in e){this.byId(t+"Column").setHeaderMenu(i)}}})});
//# sourceMappingURL=Analysis.controller.js.map