/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/unified/Menu","sap/ui/unified/MenuItem","sap/ui/unified/MenuTextFieldItem","sap/ui/unified/MenuRenderer","./utils/TableUtils","sap/base/assert","sap/ui/thirdparty/jquery"],function(e,t,i,n,o,u,r,jQuery){"use strict";var l=new window.WeakMap;var a=t.extend("sap.ui.table.ColumnMenu",{metadata:{library:"sap.ui.table"},renderer:o});a.prototype.init=function(){if(t.prototype.init){t.prototype.init.apply(this,arguments)}this.addStyleClass("sapUiTableColumnMenu");this._bInvalidated=true;this._iPopupClosedTimeoutId=null};a.prototype.exit=function(){if(t.prototype.exit){t.prototype.exit.apply(this,arguments)}window.clearTimeout(this._iPopupClosedTimeoutId);a._destroyColumnVisibilityMenuItem(this._getTable())};a.prototype.onThemeChanged=function(){if(this.getDomRef()){this._invalidate()}};a.prototype.setParent=function(e){this._invalidate();return t.prototype.setParent.apply(this,arguments)};a.prototype._getColumn=function(){var e=this.getParent();return u.isA(e,"sap.ui.table.Column")?e:null};a.prototype._getTable=function(){var e=this._getColumn();return e?e._getTable():null};a._destroyColumnVisibilityMenuItem=function(e){if(!e||!e._oColumnVisibilityMenuItem){return}e._oColumnVisibilityMenuItem.destroy();e._oColumnVisibilityMenuItem=null};a.prototype._removeColumnVisibilityFromAggregation=function(){var e=this._getTable();if(!e||e._oColumnVisibilityMenuItem){return}this.removeAggregation("items",e._oColumnVisibilityMenuItem,true)};a.prototype._invalidate=function(){this._removeColumnVisibilityFromAggregation();this.destroyItems();this._bInvalidated=true};a.prototype.open=function(){if(!this._bInvalidated&&this._getColumn()){this._addColumnVisibilityMenuItem()}if(this._bInvalidated){this._bInvalidated=false;this._addMenuItems()}u.Hook.call(this._getTable(),u.Hook.Keys.Table.OpenMenu,u.getCellInfo(arguments[4]),this);if(this.getItems().length>0){this._lastFocusedDomRef=arguments[4];t.prototype.open.apply(this,arguments)}};a.prototype._addMenuItems=function(){if(this._getColumn()){this._addSortMenuItem(false);this._addSortMenuItem(true);this._addFilterMenuItem();this._addGroupMenuItem();this._addFreezeMenuItem();this._addColumnVisibilityMenuItem()}};a.prototype._addSortMenuItem=function(e){var t=this._getColumn();if(t.isSortableByMenu()){var i=e?"desc":"asc";var n=e?"sort-descending":"sort-ascending";this.addItem(this._createMenuItem(i,"TBL_SORT_"+i.toUpperCase(),n,function(i){t.sort(e,i.getParameter("ctrlKey")===true)}))}};a.prototype._addFilterMenuItem=function(){var e=this._getColumn();if(e.isFilterableByMenu()){var t=e.getParent();var i=t&&t.getEnableCustomFilter();if(i){this.addItem(this._createMenuItem("filter","TBL_FILTER_ITEM","filter",function(){t.fireCustomFilter({column:e})}))}else{this.addItem(this._createMenuTextFieldItem("filter","TBL_FILTER","filter",e.getFilterValue(),function(){e.filter(this.getValue())}))}}};a.prototype._addGroupMenuItem=function(){var e=this._getColumn();if(e.isGroupableByMenu()){var t=this._getTable();this.addItem(this._createMenuItem("group","TBL_GROUP",null,function(){var i;t.setGroupBy(e);if(u.isNoDataVisible(t)){i=t.getDomRef("noDataCnt")}else{i=t.getDomRef("rowsel0")}if(i){i.focus()}}))}};a.prototype._addFreezeMenuItem=function(){var e=this._getColumn();var t=this._getTable();var i=t&&t.getEnableColumnFreeze();if(i){var n=e.getIndex();var o=n+u.Column.getHeaderSpan(e)==t.getComputedFixedColumnCount();this.addItem(this._createMenuItem("freeze",o?"TBL_UNFREEZE":"TBL_FREEZE",null,function(){var i=t.fireColumnFreeze({column:e});if(i){if(o){t.setFixedColumnCount(0)}else{t.setFixedColumnCount(n+1)}}}))}};a.prototype._addColumnVisibilityMenuItem=function(){var e=this._getTable();if(e&&e.getShowColumnVisibilityMenu()){if(!e._oColumnVisibilityMenuItem||e._oColumnVisibilityMenuItem.bIsDestroyed){e._oColumnVisibilityMenuItem=this._createMenuItem("column-visibilty","TBL_COLUMNS");var i=new t(e._oColumnVisibilityMenuItem.getId()+"-menu");e._oColumnVisibilityMenuItem.setSubmenu(i)}this.addItem(e._oColumnVisibilityMenuItem);this._updateColumnVisibilityMenuItem()}};a.prototype._createColumnVisibilityMenuItem=function(e){var t=this._getTable();var n=u.Column.getHeaderText(e);return new i({text:n,icon:e.getVisible()?"sap-icon://accept":null,ariaLabelledBy:[t.getId()+(e.getVisible()?"-ariahidecolmenu":"-ariashowcolmenu")],select:jQuery.proxy(function(i){var n=!e.getVisible();if(n||u.getVisibleColumnCount(t)>1){var o=true;if(u.isA(t,"sap.ui.table.Table")){o=t.fireColumnVisibility({column:e,newVisible:n})}if(o){if(t.getFocusDomRef().getAttribute("id")===e.getId()){var r=t._getVisibleColumns();r[Math.min(r.indexOf(e)+1,u.getVisibleColumnCount(t)-2)].focus()}e.setVisible(n)}}},this)})};a.prototype._createMenuItem=function(e,t,n,o){return new i(this.getId()+"-"+e,{text:u.getResourceText(t),icon:n?"sap-icon://"+n:null,select:o||function(){}})};a.prototype._createMenuTextFieldItem=function(e,t,i,o,r){r=r||function(){};return new n(this.getId()+"-"+e,{label:u.getResourceText(t),icon:i?"sap-icon://"+i:null,value:o,select:r||function(){}})};a.prototype._setFilterValue=function(e){var t=this.getParent();var i=t?t.getParent():undefined;var n=sap.ui.getCore().byId(this.getId()+"-filter");if(n&&n.setValue&&(i&&!i.getEnableCustomFilter())){n.setValue(e)}return this};a.prototype._setFilterState=function(e){var t=this.getParent();var i=t?t.getParent():undefined;var n=sap.ui.getCore().byId(this.getId()+"-filter");if(n&&n.setValueState&&(i&&!i.getEnableCustomFilter())){n.setValueState(e)}return this};function s(e){var t=e.getColumns();if(e.getColumnVisibilityMenuSorter&&typeof e.getColumnVisibilityMenuSorter==="function"){var i=e.getColumnVisibilityMenuSorter();if(typeof i==="function"){t=t.sort(i)}}return t}function m(e,t){if(t.isA("sap.ui.table.AnalyticalColumn")){var i=e.getAnalyticalQueryResult();var n=i.getEntityType();var o=e.getModel().getProperty("/#"+n.getTypeDescription().name+"/"+t.getLeadingProperty()+"/sap:visible");if(o&&(o.value==="false"||o.value===false)){return true}}return false}a.prototype._updateColumnVisibilityMenuItem=function(){var e=this._getTable();if(!e||!e._oColumnVisibilityMenuItem){return}var t=e._oColumnVisibilityMenuItem.getSubmenu();if(!t){return}var i=s(e);var n=t.getItems();var o=e._getVisibleColumns();var r=e.getBinding();var a=u.isA(r,"sap.ui.model.analytics.AnalyticalBinding");for(var d=0;d<i.length;d++){var p=i[d];if(a){if(m(r,p)){continue}}var f=l.get(p);if(!f||f.bIsDestroyed){var f=this._createColumnVisibilityMenuItem(p);t.insertItem(f,d);l.set(p,f)}else{var g=n.indexOf(f);if(d!==g){t.removeItem(f);t.insertItem(f,d)}}var y=o.indexOf(p)>-1;var c=y?"sap-icon://accept":"";n=t.getItems();n[d].setProperty("icon",c);n[d].setEnabled(!y||o.length>1);n[d].removeAllAriaLabelledBy();n[d].addAriaLabelledBy(e.getId()+(y?"-ariahidecolmenu":"-ariashowcolmenu"))}for(var d=n.length;d>i.length;d--){n[d-1].destroy()}};return a});
//# sourceMappingURL=ColumnMenu.js.map