/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","./utils/TableUtils","sap/ui/thirdparty/jquery"],function(t,e,jQuery){"use strict";var o=Object.freeze({Standard:"Standard",Summary:"Summary",GroupHeader:"GroupHeader"});function n(){var t=null;var e=o.Standard;var n=false;var i="";var r=false;var a=false;var l=0;Object.defineProperties(this,{context:{get:function(){return t},set:function(e){t=e||null}},Type:{get:function(){return o}},type:{get:function(){return e},set:function(t){if(!(t in o)){throw Error("Is not a valid type for sap.ui.table.Row: "+t)}e=t}},empty:{get:function(){return this.context==null}},contentHidden:{get:function(){return this.empty?true:n},set:function(t){n=t===true}},title:{get:function(){return this.empty?"":i},set:function(t){i=typeof t==="string"?t:""}},expandable:{get:function(){return this.empty?false:a},set:function(t){a=t===true}},expanded:{get:function(){return this.expandable?r:false},set:function(t){r=t===true}},level:{get:function(){return this.empty?0:l},set:function(t){l=typeof t==="number"?Math.max(1,t||1):1}},reset:{value:function(){t=null;e=o.Standard;n=false;i="";a=false;r=false;l=1}}})}var i=new window.WeakMap;function r(t){if(!i.has(t)){i.set(t,Object.seal(new n))}return i.get(t)}var a=t.extend("sap.ui.table.Row",{metadata:{library:"sap.ui.table",defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"},_rowAction:{type:"sap.ui.table.RowAction",multiple:false,visibility:"hidden"},_settings:{type:"sap.ui.table.RowSettings",multiple:false,visibility:"hidden"}}}});a.prototype.init=function(){this.initDomRefs()};a.prototype.exit=function(){this.initDomRefs()};a.prototype.getFocusInfo=function(){var e=this.getTable();return e?e.getFocusInfo():t.prototype.getFocusInfo.apply(this,arguments)};a.prototype.applyFocusInfo=function(e){var o=this.getTable();if(o){o.applyFocusInfo(e)}else{t.prototype.applyFocusInfo.apply(this,arguments)}return this};a.prototype._setFocus=function(t){var o=e.getFirstInteractiveElement(this);if(t===true&&o){o.focus()}else{this.getDomRef("col0").focus()}};a.prototype.addStyleClass=function(t){this.getDomRefs(true).row.addClass(t)};a.prototype.removeStyleClass=function(t){this.getDomRefs(true).row.removeClass(t)};a.prototype.initDomRefs=function(){this._mDomRefs={}};a.prototype.getIndex=function(){var t=this.getTable();if(!t){return-1}var e=t.indexOfRow(this);var o=t._getRowCounts();if(o.fixedTop>0&&e<o.fixedTop){return e}if(o.fixedBottom>0&&e>=o.count-o.fixedBottom){var n=t._getTotalRowCount();if(n>=o.count){return n-(o.count-e)}else{return e}}return t._getFirstRenderedRowIndex()+e};a.prototype.getDomRefs=function(t,e){t=t===true;e=e===true;var o=t?"jQuery":"dom";var n=this._mDomRefs;if(!n[o]){var i=this.getTable();var r=function(e){var o=document.getElementById(e);if(o){return t?jQuery(o):o}return null};var a=function(e){if(e){return t?e.parent():e.parentNode}return null};n[o]={};if(i){var l=i.indexOfRow(this);n[o].rowSelector=r(i.getId()+"-rowsel"+l);n[o].rowAction=r(i.getId()+"-rowact"+l)}n[o].rowHeaderPart=a(n[o].rowSelector);n[o].rowFixedPart=r(this.getId()+"-fixed");n[o].rowScrollPart=r(this.getId());n[o].rowActionPart=a(n[o].rowAction);n[o].rowSelectorText=r(this.getId()+"-rowselecttext");if(t){n[o].row=jQuery().add(n[o].rowHeaderPart).add(n[o].rowFixedPart).add(n[o].rowScrollPart).add(n[o].rowActionPart)}else{n[o].row=[n[o].rowHeaderPart,n[o].rowFixedPart,n[o].rowScrollPart,n[o].rowActionPart].filter(Boolean)}}var s=n[o];if(e){return Object.keys(s).map(function(t){return t==="row"?null:s[t]}).filter(Boolean)}return s};a.prototype._updateSelection=function(){var t=this.getTable();var e=t._getSelectionPlugin().isSelected(this);this._setSelected(e);t._getAccExtension().updateSelectionStateOfRow(this)};a.prototype.setRowBindingContext=function(t,o){var n=o.getBindingInfo("rows");var i=n?n.model:undefined;var a=r(this);a.reset();a.context=t;if(a.context){e.Hook.call(o,e.Hook.Keys.Row.UpdateState,a)}this.setBindingContext(a.context,i);this.getDomRefs(true).row.toggleClass("sapUiTableRowHidden",this.isContentHidden());this._updateTableCells(o)};a.prototype.getRowBindingContext=function(){return r(this).context};a.prototype.setBindingContext=function(e,o){return t.prototype.setBindingContext.call(this,e||null,o)};a.prototype._updateTableCells=function(t){var e=this.getCells(),o=this.getIndex(),n=!!t._updateTableCell,i,r,a,l=this.getRowBindingContext();for(var s=0;s<e.length;s++){i=e[s];a=!!i._updateTableCell;r=a||n?i.$().closest("td"):null;if(a){i._updateTableCell(i,l,r,o)}if(n){t._updateTableCell(i,l,r,o)}}};a.prototype.getType=function(){return r(this).type};a.prototype.isGroupHeader=function(){return this.getType()===o.GroupHeader};a.prototype.isSummary=function(){return this.getType()===o.Summary};a.prototype.isGroupSummary=function(){return this.isSummary()&&this.getLevel()>1};a.prototype.isTotalSummary=function(){return this.isSummary()&&this.getLevel()===1};a.prototype.isEmpty=function(){return r(this).empty};a.prototype.isContentHidden=function(){return r(this).contentHidden};a.prototype.getLevel=function(){return r(this).level};a.prototype.getTitle=function(){return r(this).title};a.prototype.isExpandable=function(){return r(this).expandable};a.prototype.isExpanded=function(){return r(this).expanded};a.prototype.destroy=function(){this.removeAllCells();return t.prototype.destroy.apply(this,arguments)};a.prototype.invalidate=function(){return this};a.prototype.getDragGhost=function(){var t=this.getTable();var e=t.getDomRef();var o=this.getDomRefs();var n;var i;var r;var a=t._getSelectionPlugin().getSelectedCount();function l(t){t.removeAttribute("id");t.removeAttribute("data-sap-ui");t.removeAttribute("data-sap-ui-related");var e=t.children.length;for(var o=0;o<e;o++){l(t.children[o])}}function s(t,e){var o=t.cloneNode();var n=t.querySelector("thead").cloneNode(true);var i=t.querySelector("tbody").cloneNode();var r=e.cloneNode(true);i.appendChild(r);o.appendChild(n);o.appendChild(i);return o}n=e.cloneNode();n.classList.add("sapUiTableRowGhost");n.classList.remove("sapUiTableVScr");n.classList.remove("sapUiTableHScr");n.style.width=e.getBoundingClientRect().width+"px";if(o.rowSelector){i=t.getDomRef("sapUiTableRowHdrScr").cloneNode();r=o.rowSelector.cloneNode(true);i.appendChild(r);n.appendChild(i)}if(o.rowFixedPart){i=t.getDomRef("sapUiTableCtrlScrFixed").cloneNode();r=s(t.getDomRef("table-fixed"),o.rowFixedPart);i.appendChild(r);n.appendChild(i)}if(o.rowScrollPart){var p=t.getDomRef("sapUiTableCtrlScr");i=p.cloneNode();r=s(t.getDomRef("table"),o.rowScrollPart);i.appendChild(t.getDomRef("tableCtrlCnt").cloneNode());i.firstChild.appendChild(r);n.appendChild(i)}if(o.rowAction){i=t.getDomRef("sapUiTableRowActionScr").cloneNode();r=o.rowAction.cloneNode(true);i.appendChild(r);n.appendChild(i)}if(a>1){i=document.createElement("div");i.classList.add("sapUiTableRowGhostCount");var u=document.createElement("div");u.textContent=a;i.appendChild(u);n.appendChild(i)}l(n);return n};a.prototype._setSelected=function(t){var o=this.getTable();if(t){this.addStyleClass("sapUiTableRowSel")}else{this.removeStyleClass("sapUiTableRowSel")}if(o){e.dynamicCall(o._getSyncExtension,function(e){e.syncRowSelection(o.indexOfRow(this),t)},this)}};a.prototype._setHovered=function(t){var o=this.getTable();if(t){this.addStyleClass("sapUiTableRowHvr")}else{this.removeStyleClass("sapUiTableRowHvr")}if(o){e.dynamicCall(o._getSyncExtension,function(e){e.syncRowHover(o.indexOfRow(this),t)},this)}};a.prototype.getRowAction=function(){return this.getAggregation("_rowAction")};a.prototype.getTable=function(){var t=this.getParent();return e.isA(t,"sap.ui.table.Table")?t:null};a.prototype.expand=function(){if(this.isExpandable()&&!this.isExpanded()){e.Hook.call(this.getTable(),e.Hook.Keys.Row.Expand,this)}};a.prototype.collapse=function(){if(this.isExpandable()&&this.isExpanded()){e.Hook.call(this.getTable(),e.Hook.Keys.Row.Collapse,this)}};a.prototype.toggleExpandedState=function(){if(this.isExpanded()){this.collapse()}else{this.expand()}};a.prototype.Type=o;return a});
//# sourceMappingURL=Row.js.map