/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","./utils/TableUtils","./RowActionRenderer","sap/ui/core/Control","sap/ui/core/Icon","sap/ui/unified/Menu","sap/ui/core/Popup"],function(e,t,i,s,o,n,a){"use strict";var r=s.extend("sap.ui.table.RowAction",{metadata:{library:"sap.ui.table",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.table.RowActionItem",multiple:true},_icons:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{}},renderer:i});r.prototype.init=function(){this._bFixedLayout=true;this._aActions=["",""];this._iLastCloseTime=0;this.addAggregation("_icons",new o(this.getId()+"-icon0",{decorative:false,press:[this._onIconPress,this]}).addStyleClass("sapUiTableActionIcon")).addDelegate({onAfterRendering:function(){var e=this.getAggregation("_icons")[0].getDomRef();if(this._aActions[0]==="menu"){e.setAttribute("aria-haspopup","menu")}else{e.removeAttribute("aria-haspopup")}}},this);this.addAggregation("_icons",new o(this.getId()+"-icon1",{decorative:false,press:[this._onIconPress,this]}).addStyleClass("sapUiTableActionIcon")).addDelegate({onAfterRendering:function(){var e=this.getAggregation("_icons")[1].getDomRef();if(this._aActions[1]==="menu"){e.setAttribute("aria-haspopup","menu")}else{e.removeAttribute("aria-haspopup")}}},this)};r.prototype.onBeforeRendering=function(){var e=this.getRow();var i=e?e.getTable():null;var s=this.getAggregation("_icons");var o=this.getItems();var n=this._getVisibleItems();var a=n.length;var r=this._getSize();var c=i?i.getId()+"-rowacthdr":"";if(this._bFixedLayout&&a===1&&r===2&&o.length>1&&n[0]===o[1]){n[0]._syncIcon(s[1]);this._aActions=["","action_fixed"]}else if(a===0||r===0){this._aActions=["",""]}else if(a===1&&r>0){n[0]._syncIcon(s[0]);this._aActions=["action",""]}else if(a===2&&r===2){n[0]._syncIcon(s[0]);n[1]._syncIcon(s[1]);this._aActions=["action","action"]}else if(a>2&&r===2){n[0]._syncIcon(s[0]);s[1].setSrc("sap-icon://overflow");s[1].setTooltip(t.getResourceText("TBL_ROW_ACTION_MORE"));this._aActions=["action","menu"]}else{s[0].setSrc("sap-icon://overflow");s[0].setTooltip(t.getResourceText("TBL_ROW_ACTION_MORE"));this._aActions=["menu",""]}s.forEach(function(e,t){e.removeAllAriaLabelledBy();e.removeStyleClass("sapUiTableActionHidden");if(c){e.addAriaLabelledBy(c)}if(this._aActions[t]===""){e.addStyleClass("sapUiTableActionHidden")}}.bind(this))};r.prototype.getAccessibilityInfo=function(){var e=this.getRow();var i=this._getVisibleItems().length;var s=this._getSize();var o=this.getVisible()&&i>0&&s>0&&(!e||!e.isContentHidden()&&!e.isGroupHeader()&&!e.isSummary());var n;if(o){n=t.getResourceText(i==1?"TBL_ROW_ACTION_SINGLE_ACTION":"TBL_ROW_ACTION_MULTIPLE_ACTION",[i])}else{n=t.getResourceText("TBL_ROW_ACTION_NO_ACTION")}return{focusable:o,enabled:o,description:n}};r.prototype._getVisibleItems=function(){return this.getItems().filter(function(e){return e.getVisible()})};r.prototype.getRow=function(){var e=this.getParent();return t.isA(e,"sap.ui.table.Row")?e:null};r.prototype._getSize=function(){var e=this.getRow();var t=e?e.getTable():null;return t?t.getRowActionCount():2};r.prototype._onIconPress=function(e){var t=e.getSource();var i=this.indexOfAggregation("_icons",t);var s=this._aActions[i];if(s==="action"){this._getVisibleItems()[i]._firePress()}else if(s==="action_fixed"){this._getVisibleItems()[0]._firePress()}else if(s==="menu"){var o=this.getAggregation("_menu");if(!o){o=new n;this.setAggregation("_menu",o,true);o.getPopup().attachClosed(function(){this._iLastCloseTime=Date.now()},this)}o.removeAllItems();if(Date.now()-this._iLastCloseTime<500){return}var r=this.getItems();for(var c=i;c<r.length;c++){o.addItem(r[c]._getMenuItem())}o.open(null,t,a.Dock.EndTop,a.Dock.EndBottom,t)}};return r});
//# sourceMappingURL=RowAction.js.map