/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ColumnHeaderMenuAdapter","../utils/TableUtils","../library","sap/m/library","sap/m/table/columnmenu/QuickAction","sap/m/table/columnmenu/QuickActionContainer","sap/m/table/columnmenu/QuickSort","sap/m/table/columnmenu/QuickSortItem","sap/m/table/columnmenu/QuickGroup","sap/m/table/columnmenu/QuickGroupItem","sap/m/table/columnmenu/QuickTotal","sap/m/table/columnmenu/QuickTotalItem","sap/m/table/columnmenu/Item","sap/m/table/columnmenu/ItemContainer","sap/m/table/columnmenu/ActionItem","sap/m/Button","sap/m/Input","sap/ui/core/library","sap/ui/core/Core","sap/ui/Device"],function(e,t,i,o,r,u,s,n,a,c,l,_,p,m,h,k,Q,f,d,C){"use strict";var g=e.extend("sap.ui.table.menus.MobileColumnHeaderMenuAdapter",{});g.prototype.injectMenuItems=function(e,t){this._oColumn=t;this._oMenu=e;this._prepareQuickActions(t);e.addAggregation("_quickActions",this._oQuickActionContainer);this._prepareItems(t);e.addAggregation("_items",this._oItemContainer)};g.prototype.removeMenuItems=function(e){delete this._oColumn;e.removeAggregation("_quickActions",this._oQuickActionContainer);e.removeAggregation("_items",this._oItemContainer)};g.prototype.onAfterMenuDestroyed=function(e){if(e!==this._oMenu){return}delete this._oQuickActionContainer;delete this._oQuickSort;delete this._oQuickFreeze;delete this._oQuickFilter;delete this._oQuickGroup;delete this._oQuickTotal;delete this._oItemContainer;delete this._oCustomFilterItem};g.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments);this._destroyQuickActions();this._destroyItems();delete this._oColumn};g.prototype._prepareQuickActions=function(e){var t=e._getTable();this._prepareQuickSort(e);if(!t.getEnableCustomFilter()){this._prepareQuickFilter(e)}this._prepareQuickGroup(e);this._prepareQuickTotal(e);this._prepareQuickFreeze(e);this._prepareQuickResize(e);if(!this._oQuickActionContainer){this._oQuickActionContainer=new u}this._oQuickActionContainer.addQuickAction(this._oQuickSort);this._oQuickActionContainer.addQuickAction(this._oQuickFilter);this._oQuickActionContainer.addQuickAction(this._oQuickGroup);this._oQuickActionContainer.addQuickAction(this._oQuickTotal);this._oQuickActionContainer.addQuickAction(this._oQuickFreeze);this._oQuickActionContainer.addQuickAction(this._oQuickResize)};g.prototype._prepareItems=function(e){var t=e._getTable();if(t.getEnableCustomFilter()){this._prepareCustomFilterItem(e)}if(!this._oItemContainer){this._oItemContainer=new m}this._oItemContainer.addItem(this._oCustomFilterItem)};g.prototype._destroyQuickActions=function(){if(this._oQuickActionContainer){this._oQuickActionContainer.destroy()}delete this._oQuickActionContainer;delete this._oQuickSort;delete this._oQuickFilter;delete this._oQuickGroup;delete this._oQuickTotal;delete this._oQuickFreeze};g.prototype._destroyItems=function(){if(this._oItemContainer){this._oItemContainer.destroy()}delete this._oItemContainer;delete this._oCustomFilterItem};g.prototype._prepareQuickSort=function(e){if(e.isSortableByMenu()){if(!this._oQuickSort){this._oQuickSort=this._createQuickSort()}this._updateQuickSort(e);this._oQuickSort.setVisible(true)}else if(this._oQuickSort){this._oQuickSort.setVisible(false)}};g.prototype._createQuickSort=function(){return new s({items:new n,change:[function(e){var t=e.getParameter("item").getSortOrder();this._oColumn._sort(t,false)},this]})};g.prototype._updateQuickSort=function(e){var i=this._oQuickSort.getItems()[0];i.setLabel(t.Column.getHeaderText(e));i.setSortOrder(e.getSortOrder())};g.prototype._prepareQuickFilter=function(e){if(e.getShowFilterMenuEntry()&&e.isFilterableByMenu()){if(!this._oQuickFilter){this._oQuickFilter=this._createQuickFilter();this._oQuickFilter._bHideLabelColon=true}this._updateQuickFilter(e);this._oQuickFilter.setVisible(true)}else if(this._oQuickFilter){this._oQuickFilter.setVisible(false)}};g.prototype._createQuickFilter=function(){return new r({content:new Q({submit:[function(e){this._oColumn.setFilterValue(e.getSource().getValue());var t=this._oColumn._getFilterState();if(t===f.ValueState.None){this._oColumn.filter(e.getSource().getValue());this._oMenu.close()}e.getSource().setValueState(t)},this]}),category:o.table.columnmenu.Category.Filter})};g.prototype._updateQuickFilter=function(e){var i=d.getLibraryResourceBundle("sap.m");var o=this._oQuickFilter.getContent()[0];this._oQuickFilter.setLabel(i.getText("table.COLUMNMENU_QUICK_FILTER",[t.Column.getHeaderText(e)]));o.setValue(e.getFilterValue());o.setValueState(e._getFilterState())};g.prototype._prepareQuickGroup=function(e){if(e._isGroupableByMenu()){if(!this._oQuickGroup){this._oQuickGroup=this._createQuickGroup()}this._updateQuickGroup(e);this._oQuickGroup.setVisible(true)}else if(this._oQuickGroup){this._oQuickGroup.setVisible(false)}};g.prototype._createQuickGroup=function(){return new a({items:new c,change:[function(e){var i=e.getParameter("item").getGrouped();var o=this._oColumn;var r=o._getTable();this._oMenu.attachEventOnce("afterClose",function(){if(i&&(!o.getShowIfGrouped||!o.getShowIfGrouped())){var e;if(t.isNoDataVisible(r)){e=r.getDomRef("noDataCnt")}else{e=r.getDomRef("rowsel0")}if(e){e.focus()}}o._setGrouped(i)})},this]})};g.prototype._updateQuickGroup=function(e){var i=this._oQuickGroup.getItems()[0];i.setLabel(t.Column.getHeaderText(e));i.setGrouped(e.getGrouped())};g.prototype._prepareQuickTotal=function(e){if(e._isAggregatableByMenu()){if(!this._oQuickTotal){this._oQuickTotal=this._createQuickTotal()}this._updateQuickTotal(e);this._oQuickTotal.setVisible(true)}else if(this._oQuickTotal){this._oQuickTotal.setVisible(false)}};g.prototype._createQuickTotal=function(){return new l({items:new _,change:[function(e){this._oColumn.setSummed(e.getParameter("item").getTotaled())},this]})};g.prototype._updateQuickTotal=function(e){var i=this._oQuickTotal.getItems()[0];i.setLabel(t.Column.getHeaderText(e));i.setTotaled(e.getSummed())};g.prototype._prepareQuickFreeze=function(e){if(e._getTable().getEnableColumnFreeze()){if(!this._oQuickFreeze){this._oQuickFreeze=this._createQuickFreeze()}this._updateQuickFreeze(e);this._oQuickFreeze.setVisible(true)}else if(this._oQuickFreeze){this._oQuickFreeze.setVisible(false)}};g.prototype._createQuickFreeze=function(){return new r({content:new k({press:[function(e){var i=this._oColumn._getTable();var o=i.fireColumnFreeze({column:this._oColumn});if(o){var r=e.getSource().getText()===t.getResourceText("TBL_UNFREEZE");if(r){i.setFixedColumnCount(0)}else{i.setFixedColumnCount(this._oColumn.getIndex()+1)}}this._oMenu.close()},this]})})};g.prototype._updateQuickFreeze=function(e){var i=e.getIndex()+t.Column.getHeaderSpan(e)===e._getTable().getComputedFixedColumnCount();var o=i?"TBL_UNFREEZE":"TBL_FREEZE";this._oQuickFreeze.getContent()[0].setText(t.getResourceText(o))};g.prototype._prepareQuickResize=function(e){if(!C.system.desktop&&e.getResizable()){if(!this._oQuickResize){this._oQuickResize=this._createQuickResize(e)}this._oQuickResize.setVisible(true)}else if(this._oQuickResize){this._oQuickResize.setVisible(false)}};g.prototype._createQuickResize=function(e){var t=d.getLibraryResourceBundle("sap.m");return new r({content:new k({text:t.getText("table.COLUMNMENU_RESIZE"),press:[function(t){this._startColumnResize(e);this._oMenu.close()},this]})})};g.prototype._startColumnResize=function(e){var t=e._getTable();t.$().toggleClass("sapUiTableResizing",true);t._$colResize=t.$("rsz");t._$colResize.toggleClass("sapUiTableColRszActive",true)};g.prototype._removeHeaderCellColumnResizer=function(e){var t=e&&e.$().find(".sapUiTableCHT .sapUiTableCellTouchMenu");if(t.length){t.parent().find(".sapUiTableCellInner").show();t.remove()}};g.prototype._prepareCustomFilterItem=function(e){if(e.getShowFilterMenuEntry()){if(!this._oCustomFilterItem){this._oCustomFilterItem=this._createCustomFilterItem()}this._oCustomFilterItem.setVisible(true)}else if(this._oCustomFilterItem){this._oCustomFilterItem.setVisible(false)}};g.prototype._createCustomFilterItem=function(){return new h({label:t.getResourceText("TBL_FILTER_ITEM"),icon:"sap-icon://filter",press:[function(e){this._oColumn._getTable().fireCustomFilter({column:this._oColumn})},this]})};return g});
//# sourceMappingURL=MobileColumnHeaderMenuAdapter.js.map