/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./SelectionPlugin","../utils/TableUtils","../library"],function(e,t,n){"use strict";var i=n.SelectionMode;var l=e.extend("sap.ui.table.plugins.BindingSelection",{metadata:{library:"sap.ui.table",properties:{selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:i.MultiToggle}},events:{selectionChange:{parameters:{indices:{type:"int[]"},selectAll:{type:"boolean"}}}}}});l.prototype.onDeactivate=function(t){e.prototype.onDeactivate.apply(this,arguments);a(this,this.getTableBinding())};l.prototype.setSelected=function(e,t,n){if(!this.isIndexSelectable(e.getIndex())){return}if(n&&n.range){var i=this.getSelectedIndex();if(i>=0){this.addSelectionInterval(i,e.getIndex())}}else if(t){this.addSelectionInterval(e.getIndex(),e.getIndex())}else{this.removeSelectionInterval(e.getIndex(),e.getIndex())}};l.prototype.isSelected=function(e){return this.isIndexSelected(e.getIndex())};l.prototype.getRenderConfig=function(){return{headerSelector:{type:"toggle",visible:t.hasSelectAll(this.getTable()),selected:this.getSelectableCount()>0&&this.getSelectableCount()===this.getSelectedCount()}}};function o(e){var t=e.getTable(),n;if(e.getSelectableCount()>e.getSelectedCount()){t._iSourceRowIndex=0;e.selectAll();n=true}else{t._iSourceRowIndex=-1;e.clearSelection();n=false}t._iSourceRowIndex=undefined;return n}l.prototype.onHeaderSelectorPress=function(){if(this.getRenderConfig().headerSelector.visible){o(this)}};l.prototype.onKeyboardShortcut=function(e,t){if(e==="toggle"&&o(this)===false){t?.setMarked("sapUiTableClearAll")}else if(e==="clear"){this.clearSelection();t?.setMarked("sapUiTableClearAll")}};l.prototype.addSelectionInterval=function(e,t){if(this.getSelectionMode()===i.None){return}var n=this.getTableBinding();if(n&&n.addSelectionInterval){if(this.getSelectionMode()===i.Single){e=t;this.setSelectionInterval(e,t)}else{n.addSelectionInterval(e,t)}}};l.prototype.clearSelection=function(){var e=this.getTableBinding();if(e&&e.clearSelection){e.clearSelection()}};l.prototype.getSelectedIndex=function(){var e=this.getTableBinding();if(e&&e.getSelectedIndex){return e.getSelectedIndex()}else{return-1}};l.prototype.getSelectedIndices=function(){var e=this.getTableBinding();if(this.getSelectionMode()===i.Single){var t=this.getSelectedIndex();if(t===-1){return[]}return[t]}if(e&&e.getSelectedIndices){return e.getSelectedIndices()}else{return[]}};l.prototype.getSelectableCount=function(){var e=this.getTableBinding();if(!e){return 0}else if(e.isA("sap.ui.model.analytics.AnalyticalBinding")){var t=e.getGrandTotalContextInfo();return t?t.totalNumberOfLeafs:0}else{return e.getLength()}};l.prototype.getSelectedCount=function(){var e=this.getTableBinding();if(e&&e.getSelectedNodesCount){return e.getSelectedNodesCount()}else{return 0}};l.prototype.isIndexSelectable=function(e){var t=this.getTableBinding();if(t&&t.isIndexSelectable){return t.isIndexSelectable(e)}else{return false}};l.prototype.isIndexSelected=function(e){var t=this.getTableBinding();if(this.getSelectionMode()===i.Single){if(e<0){return false}return e===this.getSelectedIndex()}if(t&&t.isIndexSelected){return t.isIndexSelected(e)}else{return false}};l.prototype.removeSelectionInterval=function(e,t){var n=this.getTableBinding();if(n&&n.removeSelectionInterval){n.removeSelectionInterval(e,t)}};l.prototype.selectAll=function(){if(this.getSelectionMode()===i.None){return}var e=this.getTableBinding();if(e&&e.selectAll){e.selectAll()}};l.prototype.setSelectedIndex=function(e){if(this.getSelectionMode()===i.None){return}if(e===-1){this.clearSelection()}else{var t=this.getTableBinding();if(t&&t.setSelectedIndex){t.setSelectedIndex(e)}}};l.prototype.setSelectionInterval=function(e,t){if(this.getSelectionMode()===i.None){return}var n=this.getTableBinding();if(n&&n.setSelectionInterval){if(this.getSelectionMode()===i.Single){e=t}n.setSelectionInterval(e,t)}};l.prototype.setSelectionMode=function(e){var t=this.getSelectionMode();this.setProperty("selectionMode",e);if(this.getSelectionMode()!==t){this.clearSelection()}return this};l.prototype._getHighestSelectableIndex=function(){var e=this.getTableBinding();if(!e){return-1}else if(e.isA("sap.ui.model.analytics.AnalyticalBinding")){var t=e.providesGrandTotal()&&e.hasTotaledMeasures();return e.getLength()-(t?2:1)}else{return e.getLength()-1}};l.prototype.onTableRowsBound=function(t){e.prototype.onTableRowsBound.apply(this,arguments);r(this,t)};function r(e,t){if(t){t.attachChange(e._onBindingChange,e);if(t.attachSelectionChanged){t.attachSelectionChanged(e._onSelectionChange,e)}}}function a(e,t){if(t){t.detachChange(e._onBindingChange,e);if(t.detachSelectionChanged){t.detachSelectionChanged(e._onSelectionChange,e)}}}l.prototype._onBindingChange=function(e){var t=typeof e==="object"?e.getParameter("reason"):e;if(t==="sort"||t==="filter"){this.clearSelection()}};l.prototype._onSelectionChange=function(e){var t=e.getParameter("rowIndices");var n=e.getParameter("selectAll");this.fireSelectionChange({rowIndices:t,selectAll:n})};return l});
//# sourceMappingURL=BindingSelection.js.map