/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./SelectionPlugin","./PluginBase","../library","../utils/TableUtils","sap/ui/core/Icon","sap/ui/core/IconPool","sap/base/Log"],function(e,t,i,n,o,l,r){"use strict";var s=i.SelectionMode;var a=e.extend("sap.ui.table.plugins.MultiSelectionPlugin",{metadata:{library:"sap.ui.table",properties:{limit:{type:"int",group:"Behavior",defaultValue:200},enableNotification:{type:"boolean",group:"Behavior",defaultValue:false},showHeaderSelector:{type:"boolean",group:"Appearance",defaultValue:true},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:s.MultiToggle}},events:{selectionChange:{parameters:{indices:{type:"int[]"},limitReached:{type:"boolean"},customPayload:{type:"object"}}}}}});a.findOn=t.findOn;a.prototype.init=function(){e.prototype.init.apply(this,arguments);var t=new o({src:l.getIconURI(n.ThemeParameters.clearSelectionIcon),useIconTooltip:false});t.addStyleClass("sapUiTableSelectClear");this._bLimitReached=false;this._bLimitDisabled=this.getLimit()===0;this.oInnerSelectionPlugin=null;this.oDeselectAllIcon=t};a.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this.oDeselectAllIcon){this.oDeselectAllIcon.destroy();this.oDeselectAllIcon=null}};a.prototype.onActivate=function(t){e.prototype.onActivate.apply(this,arguments);this.oInnerSelectionPlugin=t._createLegacySelectionPlugin();this.oInnerSelectionPlugin.attachSelectionChange(this._onSelectionChange,this);t.addAggregation("_hiddenDependents",this.oInnerSelectionPlugin);t.setProperty("selectionMode",this.getSelectionMode())};a.prototype.onDeactivate=function(t){e.prototype.onDeactivate.apply(this,arguments);t.setProperty("selectionMode",s.None);if(this.oInnerSelectionPlugin){this.oInnerSelectionPlugin.destroy();this.oInnerSelectionPlugin=null}};a.prototype.setSelected=function(e,t,i){if(!this.isIndexSelectable(e.getIndex())){return}if(i&&i.range){var n=this.getSelectedIndex();if(n>=0){this.addSelectionInterval(n,e.getIndex())}}else if(t){this.addSelectionInterval(e.getIndex(),e.getIndex())}else{this.removeSelectionInterval(e.getIndex(),e.getIndex())}};a.prototype.isSelected=function(e){return this.isIndexSelected(e.getIndex())};a.prototype.getRenderConfig=function(){if(!this.isActive()){return e.prototype.getRenderConfig.apply(this,arguments)}return{headerSelector:{type:this._bLimitDisabled?"toggle":"clear",icon:this.oDeselectAllIcon,visible:this.getSelectionMode()===s.MultiToggle&&this.getShowHeaderSelector(),enabled:this._bLimitDisabled||this.getSelectedCount()>0,selected:this.getSelectableCount()>0&&this.getSelectableCount()===this.getSelectedCount()}}};a.prototype.onHeaderSelectorPress=function(){var e=this.getRenderConfig();if(!e.headerSelector.visible||!e.headerSelector.enabled){return}if(e.headerSelector.type==="toggle"){c(this)}else if(e.headerSelector.type==="clear"){this.clearSelection()}};a.prototype.onKeyboardShortcut=function(e,t){if(e==="toggle"){if(this._bLimitDisabled&&c(this)===false){t?.setMarked("sapUiTableClearAll")}}else if(e==="clear"){this.clearSelection();t?.setMarked("sapUiTableClearAll")}};function c(e){if(e.getSelectableCount()>e.getSelectedCount()){e.selectAll();return true}else{e.clearSelection();return false}}a.prototype.setSelectionMode=function(e){var t=this.getParent();if(t){t.setProperty("selectionMode",e,true)}if(this.oInnerSelectionPlugin){this.oInnerSelectionPlugin.setSelectionMode(e)}this.setProperty("selectionMode",e);return this};a.prototype.setLimit=function(e){if(typeof e==="number"&&e<0){r.warning("The limit must be greater than or equal to 0",this);return this}this.setProperty("limit",e,!!this.getLimit()===!!e);this._bLimitDisabled=e===0;return this};a.prototype.setEnableNotification=function(e){this.setProperty("enableNotification",e,true);return this};a.prototype.isLimitReached=function(){return this._bLimitReached};a.prototype.setLimitReached=function(e){this._bLimitReached=e};a.prototype.selectAll=function(e){if(!this._bLimitDisabled){return Promise.reject(new Error("Not possible if the limit is enabled"))}var t=this.getSelectableCount();if(t===0){return Promise.reject(new Error("Nothing to select"))}return this.addSelectionInterval(0,this._getHighestSelectableIndex(),e)};function u(e,t,i,o){var l=e._getHighestSelectableIndex();if(t<0&&i<0||t>l&&i>l){return Promise.reject(new Error("Out of range"))}t=Math.min(Math.max(0,t),l);i=Math.min(Math.max(0,i),l);var r=e.getLimit();var s=i<t;var a=s?i:t;var c;if(o&&e.isIndexSelected(t)){if(s){t--}else if(t!==i){t++;a++}}c=Math.abs(i-t)+1;if(!e._bLimitDisabled){e.setLimitReached(c>r);if(e.isLimitReached()){if(s){i=t-r+1;a=i-1}else{i=t+r-1}c=r+1}}return n.loadContexts(e.getTableBinding(),a,c).then(function(){return{indexFrom:t,indexTo:i}})}a.prototype.setSelectionInterval=function(e,t,i){var o=this.getTable();var l=this.getSelectionMode();if(l===s.None){return Promise.reject(new Error("SelectionMode is '"+s.None+"'"))}if(l===s.Single){e=t}return u(this,e,t,false).then(function(e){this._oCustomEventPayloadTmp=i;this.oInnerSelectionPlugin.setSelectionInterval(e.indexFrom,e.indexTo);delete this._oCustomEventPayloadTmp;if(!this.isLimitReached()){return Promise.resolve()}return n.scrollTableToIndex(o,e.indexTo,e.indexFrom>e.indexTo).then(function(){if(!this.getEnableNotification()){return Promise.resolve()}return n.showNotificationPopoverAtIndex(o,e.indexTo,this.getLimit())}.bind(this))}.bind(this))};a.prototype.setSelectedIndex=function(e,t){return this.setSelectionInterval(e,e,t)};a.prototype.addSelectionInterval=function(e,t,i){var o=this.getTable();var l=this.getSelectionMode();if(l===s.None){return Promise.reject(new Error("SelectionMode is '"+s.None+"'"))}if(l===s.Single){return this.setSelectionInterval(t,t)}if(l===s.MultiToggle){return u(this,e,t,true).then(function(e){this._oCustomEventPayloadTmp=i;this.oInnerSelectionPlugin.addSelectionInterval(e.indexFrom,e.indexTo);delete this._oCustomEventPayloadTmp;if(!this.isLimitReached()){return Promise.resolve()}return n.scrollTableToIndex(o,e.indexTo,e.indexFrom>e.indexTo).then(function(){if(!this.getEnableNotification()){return Promise.resolve()}return n.showNotificationPopoverAtIndex(o,e.indexTo,this.getLimit())}.bind(this))}.bind(this))}};a.prototype.clearSelection=function(e){if(this.oInnerSelectionPlugin){this.setLimitReached(false);this._oCustomEventPayloadTmp=e;this.oInnerSelectionPlugin.clearSelection();delete this._oCustomEventPayloadTmp}};a.prototype.getSelectedIndex=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedIndex()}return-1};a.prototype.getSelectedIndices=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedIndices()}return[]};a.prototype.getSelectableCount=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectableCount()}return 0};a.prototype.getSelectedCount=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedCount()}return 0};a.prototype.isIndexSelectable=function(e){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.isIndexSelectable(e)}return false};a.prototype.isIndexSelected=function(e){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.isIndexSelected(e)}return false};a.prototype.removeSelectionInterval=function(e,t,i){if(this.oInnerSelectionPlugin){this.setLimitReached(false);this._oCustomEventPayloadTmp=i;this.oInnerSelectionPlugin.removeSelectionInterval(e,t);delete this._oCustomEventPayloadTmp}};a.prototype._onSelectionChange=function(e){var t=e.getParameter("rowIndices");this.fireSelectionChange({rowIndices:t,limitReached:this.isLimitReached(),customPayload:typeof this._oCustomEventPayloadTmp==="object"?this._oCustomEventPayloadTmp:null,_internalTrigger:e.getParameter("_internalTrigger")})};a.prototype._getHighestSelectableIndex=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin._getHighestSelectableIndex()}return 0};a.prototype.onThemeChanged=function(){this.oDeselectAllIcon.setSrc(l.getIconURI(n.ThemeParameters.clearSelectionIcon))};return a});
//# sourceMappingURL=MultiSelectionPlugin.js.map