/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./SelectionPlugin","../library","../utils/TableUtils","sap/ui/core/Icon","sap/ui/core/IconPool"],function(e,t,i,n,o){"use strict";var l=t.plugins.SelectionMode;var r=t.SelectionMode;var a=e.extend("sap.ui.table.plugins.ODataV4Selection",{metadata:{library:"sap.ui.table",properties:{selectionMode:{type:"sap.ui.table.plugins.SelectionMode",group:"Behavior",defaultValue:l.MultiToggle},limit:{type:"int",group:"Behavior",defaultValue:200},enableNotification:{type:"boolean",group:"Behavior",defaultValue:false},hideHeaderSelector:{type:"boolean",group:"Appearance",defaultValue:false}},events:{selectionChange:{}}}});a.prototype.init=function(){e.prototype.init.apply(this,arguments);var t=new n({src:o.getIconURI(i.ThemeParameters.clearSelectionIcon),useIconTooltip:false});t.addStyleClass("sapUiTableSelectClear");this._bLimitReached=false;this.oDeselectAllIcon=t;this._oRangeSelectionStartContext=null};a.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this.oDeselectAllIcon){this.oDeselectAllIcon.destroy();this.oDeselectAllIcon=null}};a.prototype.onActivate=function(t){e.prototype.onActivate.apply(this,arguments);t.setProperty("selectionMode",this.getSelectionMode())};a.prototype.onDeactivate=function(t){e.prototype.onDeactivate.apply(this,arguments);t.setProperty("selectionMode",r.None);this.clearSelection()};a.prototype.setSelected=function(e,t,i){var n=e.getRowBindingContext();if(!n||!g(n)){return}if(i&&i.range){s(this,e);return}if(this.isSelected(e)===t){return}if(this.getSelectionMode()===l.Single){this._bSuppressSelectionChangeEvent=true;this.clearSelection()}n.setSelected(t);this._oRangeSelectionStartContext=t&&this.getSelectionMode()===l.MultiToggle?n:null;this.fireSelectionChange()};a.prototype.setSelectedContexts=function(e){this.clearSelection();var t=this.getSelectionMode()===l.Single?e.slice(0,1):e;t.forEach(function(e){e.setSelected(true)});this.fireSelectionChange()};function s(e,t){if(!e._oRangeSelectionStartContext){return}var i=e._oRangeSelectionStartContext.getIndex();var n=t.getRowBindingContext();var o=n?n.getIndex():-1;if(i!==o){i+=o>i?1:-1}d(e,i,o)}a.prototype.isSelected=function(e){var t=e.getRowBindingContext();return t?t.isSelected():false};a.prototype.getSelectedCount=function(){return this.getSelectedContexts().length};a.prototype.getRenderConfig=function(){if(!this.isActive()){return e.prototype.getRenderConfig.apply(this,arguments)}return{headerSelector:{type:this._isLimitDisabled()?"toggle":"clear",icon:this.oDeselectAllIcon,visible:this.getSelectionMode()===l.MultiToggle&&!this.getHideHeaderSelector(),enabled:this._isLimitDisabled()||this.getSelectedCount()>0,selected:u(this)}}};function c(e){if(u(e)){e.clearSelection();return false}else if(e._isLimitDisabled()){var t=e.getTableBinding();if(t&&t.getLength()){d(e,0,t.getLength()-1);return true}}return undefined}function u(e){var t=e.getTableBinding();if(!t||!t.isLengthFinal()){return false}var i=t.getAllCurrentContexts().filter(function(e){return g(e)}).length;var n=e.getSelectedContexts().filter(function(e){return g(e)}).length;return i>0&&i===n}a.prototype.onHeaderSelectorPress=function(){var e=this.getRenderConfig();if(!e.headerSelector.visible||!e.headerSelector.enabled){return}if(e.headerSelector.type==="toggle"){c(this)}else if(e.headerSelector.type==="clear"){this.clearSelection()}};a.prototype.onKeyboardShortcut=function(e,t){if(e==="toggle"){if(this._isLimitDisabled()&&c(this)===false){t?.setMarked("sapUiTableClearAll")}}else if(e==="clear"){this.clearSelection();t?.setMarked("sapUiTableClearAll")}};a.prototype.setSelectionMode=function(e){var t=this.getTable();this.setProperty("selectionMode",e,true);this._oRangeSelectionStartContext=null;this.clearSelection();if(t){t.setProperty("selectionMode",this.getSelectionMode())}return this};a.prototype.onTableRowsBound=function(e){if(!e.getModel().isA("sap.ui.model.odata.v4.ODataModel")){this.deactivate()}};a.prototype._isLimitDisabled=function(){return this.getLimit()===0};a.prototype.isLimitReached=function(){return this._bLimitReached};function d(e,t,n){var o=e.getTable();var l=e.getLimit();var r=n<t;var a=r?n:t;var s=Math.abs(n-t)+1;if(!e._isLimitDisabled()){e._bLimitReached=s>l;if(e._bLimitReached){if(r){n=t-l+1;a=n}else{n=t+l-1}s=l+1}}var c=false;i.loadContexts(e.getTableBinding(),a,s).then(function(t){t.forEach(function(t){if(!g(t)||t.isSelected()){return}if(r&&t.getIndex()>=n||t.getIndex()<=n){t.setSelected(true);c=true}if(t.getIndex()===n){e._oRangeSelectionStartContext=t}});if(e.isLimitReached()){i.scrollTableToIndex(o,n,r).then(function(){if(e.getEnableNotification()){i.showNotificationPopoverAtIndex(o,n,e.getLimit())}})}if(c){e.fireSelectionChange()}})}function g(e){var t="hierarchyQualifier"in(e.getBinding().getAggregation()||{});return t||e.getProperty("@$ui5.node.isExpanded")===undefined&&!e.getProperty("@$ui5.node.isTotal")}a.prototype.clearSelection=function(){var e=false;this.getSelectedContexts().forEach(function(t){if(!e&&t.isSelected()){e=true}t.setSelected(false)});if(e&&!this._bSuppressSelectionChangeEvent){this.fireSelectionChange()}this._bSuppressSelectionChangeEvent=false};a.prototype.getSelectedContexts=function(){var e=this.getTableBinding();return e?e.getAllCurrentContexts().filter(function(e){return e.isSelected()}):[]};a.prototype.onThemeChanged=function(){this.oDeselectAllIcon.setSrc(o.getIconURI(i.ThemeParameters.clearSelectionIcon))};return a});
//# sourceMappingURL=ODataV4Selection.js.map